/*!--------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*//******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

export function __extends(d, b) {
    if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

export var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    }
    return __assign.apply(this, arguments);
}

export function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

export function __decorate(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
}

export function __param(paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
}

export function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};

export function __runInitializers(thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};

export function __propKey(x) {
    return typeof x === "symbol" ? x : "".concat(x);
};

export function __setFunctionName(f, name, prefix) {
    if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
    return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
};

export function __metadata(metadataKey, metadataValue) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

export function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

export function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

export var __createBinding = Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
});

export function __exportStar(m, o) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}

export function __values(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

export function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

/** @deprecated */
export function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
    return ar;
}

/** @deprecated */
export function __spreadArrays() {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
}

export function __spreadArray(to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
}

export function __await(v) {
    return this instanceof __await ? (this.v = v, this) : new __await(v);
}

export function __asyncGenerator(thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
    function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
    function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

export function __asyncDelegator(o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
}

export function __asyncValues(o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

export function __makeTemplateObject(cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};

var __setModuleDefault = Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
};

export function __importStar(mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
}

export function __importDefault(mod) {
    return (mod && mod.__esModule) ? mod : { default: mod };
}

export function __classPrivateFieldGet(receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}

export function __classPrivateFieldSet(receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
}

export function __classPrivateFieldIn(state, receiver) {
    if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function")) throw new TypeError("Cannot use 'in' operator on non-object");
    return typeof state === "function" ? receiver === state : state.has(receiver);
}

export function __addDisposableResource(env, value, async) {
    if (value !== null && value !== void 0) {
        if (typeof value !== "object" && typeof value !== "function") throw new TypeError("Object expected.");
        var dispose, inner;
        if (async) {
            if (!Symbol.asyncDispose) throw new TypeError("Symbol.asyncDispose is not defined.");
            dispose = value[Symbol.asyncDispose];
        }
        if (dispose === void 0) {
            if (!Symbol.dispose) throw new TypeError("Symbol.dispose is not defined.");
            dispose = value[Symbol.dispose];
            if (async) inner = dispose;
        }
        if (typeof dispose !== "function") throw new TypeError("Object not disposable.");
        if (inner) dispose = function() { try { inner.call(this); } catch (e) { return Promise.reject(e); } };
        env.stack.push({ value: value, dispose: dispose, async: async });
    }
    else if (async) {
        env.stack.push({ async: true });
    }
    return value;

}

var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
    var e = new Error(message);
    return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

export function __disposeResources(env) {
    function fail(e) {
        env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
        env.hasError = true;
    }
    function next() {
        while (env.stack.length) {
            var rec = env.stack.pop();
            try {
                var result = rec.dispose && rec.dispose.call(rec.value);
                if (rec.async) return Promise.resolve(result).then(next, function(e) { fail(e); return next(); });
            }
            catch (e) {
                fail(e);
            }
        }
        if (env.hasError) throw env.error;
    }
    return next();
}

export default {
    __extends: __extends,
    __assign: __assign,
    __rest: __rest,
    __decorate: __decorate,
    __param: __param,
    __metadata: __metadata,
    __awaiter: __awaiter,
    __generator: __generator,
    __createBinding: __createBinding,
    __exportStar: __exportStar,
    __values: __values,
    __read: __read,
    __spread: __spread,
    __spreadArrays: __spreadArrays,
    __spreadArray: __spreadArray,
    __await: __await,
    __asyncGenerator: __asyncGenerator,
    __asyncDelegator: __asyncDelegator,
    __asyncValues: __asyncValues,
    __makeTemplateObject: __makeTemplateObject,
    __importStar: __importStar,
    __importDefault: __importDefault,
    __classPrivateFieldGet: __classPrivateFieldGet,
    __classPrivateFieldSet: __classPrivateFieldSet,
    __classPrivateFieldIn: __classPrivateFieldIn,
    __addDisposableResource: __addDisposableResource,
    __disposeResources: __disposeResources,
};

var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __esm = (fn, res) => function __init() {
  return fn && (res = (0, fn[__getOwnPropNames(fn)[0]])(fn = 0)), res;
};
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));

// out-build/vs/base/common/performance.js
function _definePolyfillMarks(timeOrigin) {
  const _data = [];
  if (typeof timeOrigin === "number") {
    _data.push("code/timeOrigin", timeOrigin);
  }
  function mark2(name, markOptions) {
    _data.push(name, markOptions?.startTime ?? Date.now());
  }
  function getMarks2() {
    const result = [];
    for (let i = 0; i < _data.length; i += 2) {
      result.push({
        name: _data[i],
        startTime: _data[i + 1]
      });
    }
    return result;
  }
  return { mark: mark2, getMarks: getMarks2 };
}
function _define() {
  if (typeof performance === "object" && typeof performance.mark === "function" && !performance.nodeTiming) {
    if (typeof performance.timeOrigin !== "number" && !performance.timing) {
      return _definePolyfillMarks();
    } else {
      return {
        mark(name, markOptions) {
          performance.mark(name, markOptions);
        },
        getMarks() {
          let timeOrigin = performance.timeOrigin;
          if (typeof timeOrigin !== "number") {
            timeOrigin = performance.timing.navigationStart || performance.timing.redirectStart || performance.timing.fetchStart;
          }
          const result = [{ name: "code/timeOrigin", startTime: Math.round(timeOrigin) }];
          for (const entry of performance.getEntriesByType("mark")) {
            result.push({
              name: entry.name,
              startTime: Math.round(timeOrigin + entry.startTime)
            });
          }
          return result;
        }
      };
    }
  } else if (typeof process === "object") {
    const timeOrigin = performance?.timeOrigin;
    return _definePolyfillMarks(timeOrigin);
  } else {
    console.trace("perf-util loaded in UNKNOWN environment");
    return _definePolyfillMarks();
  }
}
function _factory(sharedObj) {
  if (!sharedObj.MonacoPerformanceMarks) {
    sharedObj.MonacoPerformanceMarks = _define();
  }
  return sharedObj.MonacoPerformanceMarks;
}
var perf, mark, getMarks;
var init_performance = __esm({
  "out-build/vs/base/common/performance.js"() {
    "use strict";
    perf = _factory(globalThis);
    mark = perf.mark;
    getMarks = perf.getMarks;
  }
});

// node_modules/minimist/index.js
var require_minimist = __commonJS({
  "node_modules/minimist/index.js"(exports2, module2) {
    "use strict";
    function hasKey(obj, keys) {
      var o = obj;
      keys.slice(0, -1).forEach(function(key2) {
        o = o[key2] || {};
      });
      var key = keys[keys.length - 1];
      return key in o;
    }
    function isNumber2(x) {
      if (typeof x === "number") {
        return true;
      }
      if (/^0x[0-9a-f]+$/i.test(x)) {
        return true;
      }
      return /^[-+]?(?:\d+(?:\.\d*)?|\.\d+)(e[-+]?\d+)?$/.test(x);
    }
    function isConstructorOrProto(obj, key) {
      return key === "constructor" && typeof obj[key] === "function" || key === "__proto__";
    }
    module2.exports = function(args2, opts) {
      if (!opts) {
        opts = {};
      }
      var flags = {
        bools: {},
        strings: {},
        unknownFn: null
      };
      if (typeof opts.unknown === "function") {
        flags.unknownFn = opts.unknown;
      }
      if (typeof opts.boolean === "boolean" && opts.boolean) {
        flags.allBools = true;
      } else {
        [].concat(opts.boolean).filter(Boolean).forEach(function(key2) {
          flags.bools[key2] = true;
        });
      }
      var aliases = {};
      function aliasIsBoolean(key2) {
        return aliases[key2].some(function(x) {
          return flags.bools[x];
        });
      }
      Object.keys(opts.alias || {}).forEach(function(key2) {
        aliases[key2] = [].concat(opts.alias[key2]);
        aliases[key2].forEach(function(x) {
          aliases[x] = [key2].concat(aliases[key2].filter(function(y) {
            return x !== y;
          }));
        });
      });
      [].concat(opts.string).filter(Boolean).forEach(function(key2) {
        flags.strings[key2] = true;
        if (aliases[key2]) {
          [].concat(aliases[key2]).forEach(function(k) {
            flags.strings[k] = true;
          });
        }
      });
      var defaults = opts.default || {};
      var argv = { _: [] };
      function argDefined(key2, arg2) {
        return flags.allBools && /^--[^=]+$/.test(arg2) || flags.strings[key2] || flags.bools[key2] || aliases[key2];
      }
      function setKey(obj, keys, value2) {
        var o = obj;
        for (var i2 = 0; i2 < keys.length - 1; i2++) {
          var key2 = keys[i2];
          if (isConstructorOrProto(o, key2)) {
            return;
          }
          if (o[key2] === void 0) {
            o[key2] = {};
          }
          if (o[key2] === Object.prototype || o[key2] === Number.prototype || o[key2] === String.prototype) {
            o[key2] = {};
          }
          if (o[key2] === Array.prototype) {
            o[key2] = [];
          }
          o = o[key2];
        }
        var lastKey = keys[keys.length - 1];
        if (isConstructorOrProto(o, lastKey)) {
          return;
        }
        if (o === Object.prototype || o === Number.prototype || o === String.prototype) {
          o = {};
        }
        if (o === Array.prototype) {
          o = [];
        }
        if (o[lastKey] === void 0 || flags.bools[lastKey] || typeof o[lastKey] === "boolean") {
          o[lastKey] = value2;
        } else if (Array.isArray(o[lastKey])) {
          o[lastKey].push(value2);
        } else {
          o[lastKey] = [o[lastKey], value2];
        }
      }
      function setArg(key2, val, arg2) {
        if (arg2 && flags.unknownFn && !argDefined(key2, arg2)) {
          if (flags.unknownFn(arg2) === false) {
            return;
          }
        }
        var value2 = !flags.strings[key2] && isNumber2(val) ? Number(val) : val;
        setKey(argv, key2.split("."), value2);
        (aliases[key2] || []).forEach(function(x) {
          setKey(argv, x.split("."), value2);
        });
      }
      Object.keys(flags.bools).forEach(function(key2) {
        setArg(key2, defaults[key2] === void 0 ? false : defaults[key2]);
      });
      var notFlags = [];
      if (args2.indexOf("--") !== -1) {
        notFlags = args2.slice(args2.indexOf("--") + 1);
        args2 = args2.slice(0, args2.indexOf("--"));
      }
      for (var i = 0; i < args2.length; i++) {
        var arg = args2[i];
        var key;
        var next;
        if (/^--.+=/.test(arg)) {
          var m = arg.match(/^--([^=]+)=([\s\S]*)$/);
          key = m[1];
          var value = m[2];
          if (flags.bools[key]) {
            value = value !== "false";
          }
          setArg(key, value, arg);
        } else if (/^--no-.+/.test(arg)) {
          key = arg.match(/^--no-(.+)/)[1];
          setArg(key, false, arg);
        } else if (/^--.+/.test(arg)) {
          key = arg.match(/^--(.+)/)[1];
          next = args2[i + 1];
          if (next !== void 0 && !/^(-|--)[^-]/.test(next) && !flags.bools[key] && !flags.allBools && (aliases[key] ? !aliasIsBoolean(key) : true)) {
            setArg(key, next, arg);
            i += 1;
          } else if (/^(true|false)$/.test(next)) {
            setArg(key, next === "true", arg);
            i += 1;
          } else {
            setArg(key, flags.strings[key] ? "" : true, arg);
          }
        } else if (/^-[^-]+/.test(arg)) {
          var letters = arg.slice(1, -1).split("");
          var broken = false;
          for (var j = 0; j < letters.length; j++) {
            next = arg.slice(j + 2);
            if (next === "-") {
              setArg(letters[j], next, arg);
              continue;
            }
            if (/[A-Za-z]/.test(letters[j]) && next[0] === "=") {
              setArg(letters[j], next.slice(1), arg);
              broken = true;
              break;
            }
            if (/[A-Za-z]/.test(letters[j]) && /-?\d+(\.\d*)?(e-?\d+)?$/.test(next)) {
              setArg(letters[j], next, arg);
              broken = true;
              break;
            }
            if (letters[j + 1] && letters[j + 1].match(/\W/)) {
              setArg(letters[j], arg.slice(j + 2), arg);
              broken = true;
              break;
            } else {
              setArg(letters[j], flags.strings[letters[j]] ? "" : true, arg);
            }
          }
          key = arg.slice(-1)[0];
          if (!broken && key !== "-") {
            if (args2[i + 1] && !/^(-|--)[^-]/.test(args2[i + 1]) && !flags.bools[key] && (aliases[key] ? !aliasIsBoolean(key) : true)) {
              setArg(key, args2[i + 1], arg);
              i += 1;
            } else if (args2[i + 1] && /^(true|false)$/.test(args2[i + 1])) {
              setArg(key, args2[i + 1] === "true", arg);
              i += 1;
            } else {
              setArg(key, flags.strings[key] ? "" : true, arg);
            }
          }
        } else {
          if (!flags.unknownFn || flags.unknownFn(arg) !== false) {
            argv._.push(flags.strings._ || !isNumber2(arg) ? arg : Number(arg));
          }
          if (opts.stopEarly) {
            argv._.push.apply(argv._, args2.slice(i + 1));
            break;
          }
        }
      }
      Object.keys(defaults).forEach(function(k) {
        if (!hasKey(argv, k.split("."))) {
          setKey(argv, k.split("."), defaults[k]);
          (aliases[k] || []).forEach(function(x) {
            setKey(argv, x.split("."), defaults[k]);
          });
        }
      });
      if (opts["--"]) {
        argv["--"] = notFlags.slice();
      } else {
        notFlags.forEach(function(k) {
          argv._.push(k);
        });
      }
      return argv;
    };
  }
});

// out-build/vs/base/common/jsonc.js
function stripComments(content) {
  return content.replace(regexp, function(match, _m1, _m2, m3, m4, m5) {
    if (m3) {
      return "";
    } else if (m4) {
      const length = m4.length;
      if (m4[length - 1] === "\n") {
        return m4[length - 2] === "\r" ? "\r\n" : "\n";
      } else {
        return "";
      }
    } else if (m5) {
      return match.substring(1);
    } else {
      return match;
    }
  });
}
function parse(content) {
  const commentsStripped = stripComments(content);
  try {
    return JSON.parse(commentsStripped);
  } catch (error) {
    const trailingCommasStriped = commentsStripped.replace(/,\s*([}\]])/g, "$1");
    return JSON.parse(trailingCommasStriped);
  }
}
var regexp;
var init_jsonc = __esm({
  "out-build/vs/base/common/jsonc.js"() {
    "use strict";
    regexp = /("[^"\\]*(?:\\.[^"\\]*)*")|('[^'\\]*(?:\\.[^'\\]*)*')|(\/\*[^\/\*]*(?:(?:\*|\/)[^\/\*]*)*?\*\/)|(\/{2,}.*?(?:(?:\r?\n)|$))|(,\s*[}\]])/g;
  }
});

// out-build/vs/platform/environment/node/userDataPath.js
import { homedir } from "os";
import { resolve, isAbsolute, join as join2 } from "path";
function getUserDataPath(cliArgs, productName) {
  const userDataPath2 = doGetUserDataPath(cliArgs, productName);
  const pathsToResolve = [userDataPath2];
  if (!isAbsolute(userDataPath2)) {
    pathsToResolve.unshift(cwd);
  }
  return resolve(...pathsToResolve);
}
function doGetUserDataPath(cliArgs, productName) {
  if (process.env["VSCODE_DEV"]) {
    productName = "code-oss-dev";
  }
  const portablePath = process.env["VSCODE_PORTABLE"];
  if (portablePath) {
    return join2(portablePath, "user-data");
  }
  let appDataPath = process.env["VSCODE_APPDATA"];
  if (appDataPath) {
    return join2(appDataPath, productName);
  }
  const cliPath = cliArgs["user-data-dir"];
  if (cliPath) {
    return cliPath;
  }
  switch (process.platform) {
    case "win32":
      appDataPath = process.env["APPDATA"];
      if (!appDataPath) {
        const userProfile = process.env["USERPROFILE"];
        if (typeof userProfile !== "string") {
          throw new Error("Windows: Unexpected undefined %USERPROFILE% environment variable");
        }
        appDataPath = join2(userProfile, "AppData", "Roaming");
      }
      break;
    case "darwin":
      appDataPath = join2(homedir(), "Library", "Application Support");
      break;
    case "linux":
      appDataPath = process.env["XDG_CONFIG_HOME"] || join2(homedir(), ".config");
      break;
    default:
      throw new Error("Platform not supported");
  }
  return join2(appDataPath, productName);
}
var cwd;
var init_userDataPath = __esm({
  "out-build/vs/platform/environment/node/userDataPath.js"() {
    "use strict";
    cwd = process.env["VSCODE_CWD"] || process.cwd();
  }
});

// out-build/vs/nls.messages.js
function getNLSMessages() {
  return globalThis._VSCODE_NLS_MESSAGES;
}
function getNLSLanguage() {
  return globalThis._VSCODE_NLS_LANGUAGE;
}
var init_nls_messages = __esm({
  "out-build/vs/nls.messages.js"() {
    "use strict";
  }
});

// out-build/vs/nls.js
function _format(message, args2) {
  let result;
  if (args2.length === 0) {
    result = message;
  } else {
    result = message.replace(/\{(\d+)\}/g, (match, rest) => {
      const index = rest[0];
      const arg = args2[index];
      let result2 = match;
      if (typeof arg === "string") {
        result2 = arg;
      } else if (typeof arg === "number" || typeof arg === "boolean" || arg === void 0 || arg === null) {
        result2 = String(arg);
      }
      return result2;
    });
  }
  if (isPseudo) {
    result = "\uFF3B" + result.replace(/[aouei]/g, "$&$&") + "\uFF3D";
  }
  return result;
}
function localize(data, message, ...args2) {
  if (typeof data === "number") {
    return _format(lookupMessage(data, message), args2);
  }
  return _format(message, args2);
}
function lookupMessage(index, fallback) {
  const message = getNLSMessages()?.[index];
  if (typeof message !== "string") {
    if (typeof fallback === "string") {
      return fallback;
    }
    throw new Error(`!!! NLS MISSING: ${index} !!!`);
  }
  return message;
}
function localize2(data, originalMessage, ...args2) {
  let message;
  if (typeof data === "number") {
    message = lookupMessage(data, originalMessage);
  } else {
    message = originalMessage;
  }
  const value = _format(message, args2);
  return {
    value,
    original: originalMessage === message ? value : _format(originalMessage, args2)
  };
}
var isPseudo;
var init_nls = __esm({
  "out-build/vs/nls.js"() {
    "use strict";
    init_nls_messages();
    init_nls_messages();
    isPseudo = getNLSLanguage() === "pseudo" || typeof document !== "undefined" && document.location && typeof document.location.hash === "string" && document.location.hash.indexOf("pseudo=true") >= 0;
  }
});

// out-build/vs/base/common/platform.js
function PlatformToString(platform4) {
  switch (platform4) {
    case 0:
      return "Web";
    case 1:
      return "Mac";
    case 2:
      return "Linux";
    case 3:
      return "Windows";
  }
}
function isBigSurOrNewer(osVersion) {
  return parseFloat(osVersion) >= 20;
}
var LANGUAGE_DEFAULT, _isWindows, _isMacintosh, _isLinux, _isLinuxSnap, _isNative, _isWeb, _isElectron, _isIOS, _isCI, _isMobile, _locale, _language, _platformLocale, _translationsConfigFile, _userAgent, $globalThis, nodeProcess, isElectronProcess, isElectronRenderer, Platform, _platform, isWindows2, isMacintosh, isLinux, isLinuxSnap, isNative, isWeb, isWebWorker, webWorkerOrigin, isCI, platform, userAgent, language, Language, translationsConfigFile, setTimeout0IsFaster, setTimeout0, OperatingSystem, OS, isChrome, isFirefox, isSafari, isEdge, isAndroid;
var init_platform = __esm({
  "out-build/vs/base/common/platform.js"() {
    "use strict";
    init_nls();
    LANGUAGE_DEFAULT = "en";
    _isWindows = false;
    _isMacintosh = false;
    _isLinux = false;
    _isLinuxSnap = false;
    _isNative = false;
    _isWeb = false;
    _isElectron = false;
    _isIOS = false;
    _isCI = false;
    _isMobile = false;
    _locale = void 0;
    _language = LANGUAGE_DEFAULT;
    _platformLocale = LANGUAGE_DEFAULT;
    _translationsConfigFile = void 0;
    _userAgent = void 0;
    $globalThis = globalThis;
    nodeProcess = void 0;
    if (typeof $globalThis.vscode !== "undefined" && typeof $globalThis.vscode.process !== "undefined") {
      nodeProcess = $globalThis.vscode.process;
    } else if (typeof process !== "undefined" && typeof process?.versions?.node === "string") {
      nodeProcess = process;
    }
    isElectronProcess = typeof nodeProcess?.versions?.electron === "string";
    isElectronRenderer = isElectronProcess && nodeProcess?.type === "renderer";
    if (typeof nodeProcess === "object") {
      _isWindows = nodeProcess.platform === "win32";
      _isMacintosh = nodeProcess.platform === "darwin";
      _isLinux = nodeProcess.platform === "linux";
      _isLinuxSnap = _isLinux && !!nodeProcess.env["SNAP"] && !!nodeProcess.env["SNAP_REVISION"];
      _isElectron = isElectronProcess;
      _isCI = !!nodeProcess.env["CI"] || !!nodeProcess.env["BUILD_ARTIFACTSTAGINGDIRECTORY"];
      _locale = LANGUAGE_DEFAULT;
      _language = LANGUAGE_DEFAULT;
      const rawNlsConfig = nodeProcess.env["VSCODE_NLS_CONFIG"];
      if (rawNlsConfig) {
        try {
          const nlsConfig = JSON.parse(rawNlsConfig);
          _locale = nlsConfig.userLocale;
          _platformLocale = nlsConfig.osLocale;
          _language = nlsConfig.resolvedLanguage || LANGUAGE_DEFAULT;
          _translationsConfigFile = nlsConfig.languagePack?.translationsConfigFile;
        } catch (e) {
        }
      }
      _isNative = true;
    } else if (typeof navigator === "object" && !isElectronRenderer) {
      _userAgent = navigator.userAgent;
      _isWindows = _userAgent.indexOf("Windows") >= 0;
      _isMacintosh = _userAgent.indexOf("Macintosh") >= 0;
      _isIOS = (_userAgent.indexOf("Macintosh") >= 0 || _userAgent.indexOf("iPad") >= 0 || _userAgent.indexOf("iPhone") >= 0) && !!navigator.maxTouchPoints && navigator.maxTouchPoints > 0;
      _isLinux = _userAgent.indexOf("Linux") >= 0;
      _isMobile = _userAgent?.indexOf("Mobi") >= 0;
      _isWeb = true;
      _language = getNLSLanguage() || LANGUAGE_DEFAULT;
      _locale = navigator.language.toLowerCase();
      _platformLocale = _locale;
    } else {
      console.error("Unable to resolve platform.");
    }
    (function(Platform2) {
      Platform2[Platform2["Web"] = 0] = "Web";
      Platform2[Platform2["Mac"] = 1] = "Mac";
      Platform2[Platform2["Linux"] = 2] = "Linux";
      Platform2[Platform2["Windows"] = 3] = "Windows";
    })(Platform || (Platform = {}));
    _platform = 0;
    if (_isMacintosh) {
      _platform = 1;
    } else if (_isWindows) {
      _platform = 3;
    } else if (_isLinux) {
      _platform = 2;
    }
    isWindows2 = _isWindows;
    isMacintosh = _isMacintosh;
    isLinux = _isLinux;
    isLinuxSnap = _isLinuxSnap;
    isNative = _isNative;
    isWeb = _isWeb;
    isWebWorker = _isWeb && typeof $globalThis.importScripts === "function";
    webWorkerOrigin = isWebWorker ? $globalThis.origin : void 0;
    isCI = _isCI;
    platform = _platform;
    userAgent = _userAgent;
    language = _language;
    (function(Language2) {
      function value() {
        return language;
      }
      Language2.value = value;
      function isDefaultVariant() {
        if (language.length === 2) {
          return language === "en";
        } else if (language.length >= 3) {
          return language[0] === "e" && language[1] === "n" && language[2] === "-";
        } else {
          return false;
        }
      }
      Language2.isDefaultVariant = isDefaultVariant;
      function isDefault() {
        return language === "en";
      }
      Language2.isDefault = isDefault;
    })(Language || (Language = {}));
    translationsConfigFile = _translationsConfigFile;
    setTimeout0IsFaster = typeof $globalThis.postMessage === "function" && !$globalThis.importScripts;
    setTimeout0 = (() => {
      if (setTimeout0IsFaster) {
        const pending = [];
        $globalThis.addEventListener("message", (e) => {
          if (e.data && e.data.vscodeScheduleAsyncWork) {
            for (let i = 0, len = pending.length; i < len; i++) {
              const candidate = pending[i];
              if (candidate.id === e.data.vscodeScheduleAsyncWork) {
                pending.splice(i, 1);
                candidate.callback();
                return;
              }
            }
          }
        });
        let lastId = 0;
        return (callback) => {
          const myId = ++lastId;
          pending.push({
            id: myId,
            callback
          });
          $globalThis.postMessage({ vscodeScheduleAsyncWork: myId }, "*");
        };
      }
      return (callback) => setTimeout(callback);
    })();
    (function(OperatingSystem2) {
      OperatingSystem2[OperatingSystem2["Windows"] = 1] = "Windows";
      OperatingSystem2[OperatingSystem2["Macintosh"] = 2] = "Macintosh";
      OperatingSystem2[OperatingSystem2["Linux"] = 3] = "Linux";
    })(OperatingSystem || (OperatingSystem = {}));
    OS = _isMacintosh || _isIOS ? 2 : _isWindows ? 1 : 3;
    isChrome = !!(userAgent && userAgent.indexOf("Chrome") >= 0);
    isFirefox = !!(userAgent && userAgent.indexOf("Firefox") >= 0);
    isSafari = !!(!isChrome && (userAgent && userAgent.indexOf("Safari") >= 0));
    isEdge = !!(userAgent && userAgent.indexOf("Edg/") >= 0);
    isAndroid = !!(userAgent && userAgent.indexOf("Android") >= 0);
  }
});

// out-build/vs/base/common/process.js
var safeProcess, vscodeGlobal, cwd2, env, platform2, arch;
var init_process = __esm({
  "out-build/vs/base/common/process.js"() {
    "use strict";
    init_platform();
    vscodeGlobal = globalThis.vscode;
    if (typeof vscodeGlobal !== "undefined" && typeof vscodeGlobal.process !== "undefined") {
      const sandboxProcess = vscodeGlobal.process;
      safeProcess = {
        get platform() {
          return sandboxProcess.platform;
        },
        get arch() {
          return sandboxProcess.arch;
        },
        get env() {
          return sandboxProcess.env;
        },
        cwd() {
          return sandboxProcess.cwd();
        }
      };
    } else if (typeof process !== "undefined" && typeof process?.versions?.node === "string") {
      safeProcess = {
        get platform() {
          return process.platform;
        },
        get arch() {
          return process.arch;
        },
        get env() {
          return process.env;
        },
        cwd() {
          return process.env["VSCODE_CWD"] || process.cwd();
        }
      };
    } else {
      safeProcess = {
        // Supported
        get platform() {
          return isWindows2 ? "win32" : isMacintosh ? "darwin" : "linux";
        },
        get arch() {
          return void 0;
        },
        // Unsupported
        get env() {
          return {};
        },
        cwd() {
          return "/";
        }
      };
    }
    cwd2 = safeProcess.cwd;
    env = safeProcess.env;
    platform2 = safeProcess.platform;
    arch = safeProcess.arch;
  }
});

// out-build/vs/base/common/path.js
function validateObject(pathObject, name) {
  if (pathObject === null || typeof pathObject !== "object") {
    throw new ErrorInvalidArgType(name, "Object", pathObject);
  }
}
function validateString(value, name) {
  if (typeof value !== "string") {
    throw new ErrorInvalidArgType(name, "string", value);
  }
}
function isPathSeparator(code2) {
  return code2 === CHAR_FORWARD_SLASH || code2 === CHAR_BACKWARD_SLASH;
}
function isPosixPathSeparator(code2) {
  return code2 === CHAR_FORWARD_SLASH;
}
function isWindowsDeviceRoot(code2) {
  return code2 >= CHAR_UPPERCASE_A && code2 <= CHAR_UPPERCASE_Z || code2 >= CHAR_LOWERCASE_A && code2 <= CHAR_LOWERCASE_Z;
}
function normalizeString(path4, allowAboveRoot, separator, isPathSeparator3) {
  let res = "";
  let lastSegmentLength = 0;
  let lastSlash = -1;
  let dots = 0;
  let code2 = 0;
  for (let i = 0; i <= path4.length; ++i) {
    if (i < path4.length) {
      code2 = path4.charCodeAt(i);
    } else if (isPathSeparator3(code2)) {
      break;
    } else {
      code2 = CHAR_FORWARD_SLASH;
    }
    if (isPathSeparator3(code2)) {
      if (lastSlash === i - 1 || dots === 1) {
      } else if (dots === 2) {
        if (res.length < 2 || lastSegmentLength !== 2 || res.charCodeAt(res.length - 1) !== CHAR_DOT || res.charCodeAt(res.length - 2) !== CHAR_DOT) {
          if (res.length > 2) {
            const lastSlashIndex = res.lastIndexOf(separator);
            if (lastSlashIndex === -1) {
              res = "";
              lastSegmentLength = 0;
            } else {
              res = res.slice(0, lastSlashIndex);
              lastSegmentLength = res.length - 1 - res.lastIndexOf(separator);
            }
            lastSlash = i;
            dots = 0;
            continue;
          } else if (res.length !== 0) {
            res = "";
            lastSegmentLength = 0;
            lastSlash = i;
            dots = 0;
            continue;
          }
        }
        if (allowAboveRoot) {
          res += res.length > 0 ? `${separator}..` : "..";
          lastSegmentLength = 2;
        }
      } else {
        if (res.length > 0) {
          res += `${separator}${path4.slice(lastSlash + 1, i)}`;
        } else {
          res = path4.slice(lastSlash + 1, i);
        }
        lastSegmentLength = i - lastSlash - 1;
      }
      lastSlash = i;
      dots = 0;
    } else if (code2 === CHAR_DOT && dots !== -1) {
      ++dots;
    } else {
      dots = -1;
    }
  }
  return res;
}
function formatExt(ext) {
  return ext ? `${ext[0] === "." ? "" : "."}${ext}` : "";
}
function _format2(sep2, pathObject) {
  validateObject(pathObject, "pathObject");
  const dir = pathObject.dir || pathObject.root;
  const base = pathObject.base || `${pathObject.name || ""}${formatExt(pathObject.ext)}`;
  if (!dir) {
    return base;
  }
  return dir === pathObject.root ? `${dir}${base}` : `${dir}${sep2}${base}`;
}
var CHAR_UPPERCASE_A, CHAR_LOWERCASE_A, CHAR_UPPERCASE_Z, CHAR_LOWERCASE_Z, CHAR_DOT, CHAR_FORWARD_SLASH, CHAR_BACKWARD_SLASH, CHAR_COLON, CHAR_QUESTION_MARK, ErrorInvalidArgType, platformIsWin32, win32, posixCwd, posix, normalize, isAbsolute2, join3, resolve2, relative2, dirname3, basename, extname, format, parse2, toNamespacedPath, sep, delimiter;
var init_path = __esm({
  "out-build/vs/base/common/path.js"() {
    "use strict";
    init_process();
    CHAR_UPPERCASE_A = 65;
    CHAR_LOWERCASE_A = 97;
    CHAR_UPPERCASE_Z = 90;
    CHAR_LOWERCASE_Z = 122;
    CHAR_DOT = 46;
    CHAR_FORWARD_SLASH = 47;
    CHAR_BACKWARD_SLASH = 92;
    CHAR_COLON = 58;
    CHAR_QUESTION_MARK = 63;
    ErrorInvalidArgType = class extends Error {
      constructor(name, expected, actual) {
        let determiner;
        if (typeof expected === "string" && expected.indexOf("not ") === 0) {
          determiner = "must not be";
          expected = expected.replace(/^not /, "");
        } else {
          determiner = "must be";
        }
        const type3 = name.indexOf(".") !== -1 ? "property" : "argument";
        let msg = `The "${name}" ${type3} ${determiner} of type ${expected}`;
        msg += `. Received type ${typeof actual}`;
        super(msg);
        this.code = "ERR_INVALID_ARG_TYPE";
      }
    };
    platformIsWin32 = platform2 === "win32";
    win32 = {
      // path.resolve([from ...], to)
      resolve(...pathSegments) {
        let resolvedDevice = "";
        let resolvedTail = "";
        let resolvedAbsolute = false;
        for (let i = pathSegments.length - 1; i >= -1; i--) {
          let path4;
          if (i >= 0) {
            path4 = pathSegments[i];
            validateString(path4, `paths[${i}]`);
            if (path4.length === 0) {
              continue;
            }
          } else if (resolvedDevice.length === 0) {
            path4 = cwd2();
          } else {
            path4 = env[`=${resolvedDevice}`] || cwd2();
            if (path4 === void 0 || path4.slice(0, 2).toLowerCase() !== resolvedDevice.toLowerCase() && path4.charCodeAt(2) === CHAR_BACKWARD_SLASH) {
              path4 = `${resolvedDevice}\\`;
            }
          }
          const len = path4.length;
          let rootEnd = 0;
          let device = "";
          let isAbsolute4 = false;
          const code2 = path4.charCodeAt(0);
          if (len === 1) {
            if (isPathSeparator(code2)) {
              rootEnd = 1;
              isAbsolute4 = true;
            }
          } else if (isPathSeparator(code2)) {
            isAbsolute4 = true;
            if (isPathSeparator(path4.charCodeAt(1))) {
              let j = 2;
              let last = j;
              while (j < len && !isPathSeparator(path4.charCodeAt(j))) {
                j++;
              }
              if (j < len && j !== last) {
                const firstPart = path4.slice(last, j);
                last = j;
                while (j < len && isPathSeparator(path4.charCodeAt(j))) {
                  j++;
                }
                if (j < len && j !== last) {
                  last = j;
                  while (j < len && !isPathSeparator(path4.charCodeAt(j))) {
                    j++;
                  }
                  if (j === len || j !== last) {
                    device = `\\\\${firstPart}\\${path4.slice(last, j)}`;
                    rootEnd = j;
                  }
                }
              }
            } else {
              rootEnd = 1;
            }
          } else if (isWindowsDeviceRoot(code2) && path4.charCodeAt(1) === CHAR_COLON) {
            device = path4.slice(0, 2);
            rootEnd = 2;
            if (len > 2 && isPathSeparator(path4.charCodeAt(2))) {
              isAbsolute4 = true;
              rootEnd = 3;
            }
          }
          if (device.length > 0) {
            if (resolvedDevice.length > 0) {
              if (device.toLowerCase() !== resolvedDevice.toLowerCase()) {
                continue;
              }
            } else {
              resolvedDevice = device;
            }
          }
          if (resolvedAbsolute) {
            if (resolvedDevice.length > 0) {
              break;
            }
          } else {
            resolvedTail = `${path4.slice(rootEnd)}\\${resolvedTail}`;
            resolvedAbsolute = isAbsolute4;
            if (isAbsolute4 && resolvedDevice.length > 0) {
              break;
            }
          }
        }
        resolvedTail = normalizeString(resolvedTail, !resolvedAbsolute, "\\", isPathSeparator);
        return resolvedAbsolute ? `${resolvedDevice}\\${resolvedTail}` : `${resolvedDevice}${resolvedTail}` || ".";
      },
      normalize(path4) {
        validateString(path4, "path");
        const len = path4.length;
        if (len === 0) {
          return ".";
        }
        let rootEnd = 0;
        let device;
        let isAbsolute4 = false;
        const code2 = path4.charCodeAt(0);
        if (len === 1) {
          return isPosixPathSeparator(code2) ? "\\" : path4;
        }
        if (isPathSeparator(code2)) {
          isAbsolute4 = true;
          if (isPathSeparator(path4.charCodeAt(1))) {
            let j = 2;
            let last = j;
            while (j < len && !isPathSeparator(path4.charCodeAt(j))) {
              j++;
            }
            if (j < len && j !== last) {
              const firstPart = path4.slice(last, j);
              last = j;
              while (j < len && isPathSeparator(path4.charCodeAt(j))) {
                j++;
              }
              if (j < len && j !== last) {
                last = j;
                while (j < len && !isPathSeparator(path4.charCodeAt(j))) {
                  j++;
                }
                if (j === len) {
                  return `\\\\${firstPart}\\${path4.slice(last)}\\`;
                }
                if (j !== last) {
                  device = `\\\\${firstPart}\\${path4.slice(last, j)}`;
                  rootEnd = j;
                }
              }
            }
          } else {
            rootEnd = 1;
          }
        } else if (isWindowsDeviceRoot(code2) && path4.charCodeAt(1) === CHAR_COLON) {
          device = path4.slice(0, 2);
          rootEnd = 2;
          if (len > 2 && isPathSeparator(path4.charCodeAt(2))) {
            isAbsolute4 = true;
            rootEnd = 3;
          }
        }
        let tail = rootEnd < len ? normalizeString(path4.slice(rootEnd), !isAbsolute4, "\\", isPathSeparator) : "";
        if (tail.length === 0 && !isAbsolute4) {
          tail = ".";
        }
        if (tail.length > 0 && isPathSeparator(path4.charCodeAt(len - 1))) {
          tail += "\\";
        }
        if (!isAbsolute4 && device === void 0 && path4.includes(":")) {
          if (tail.length >= 2 && isWindowsDeviceRoot(tail.charCodeAt(0)) && tail.charCodeAt(1) === CHAR_COLON) {
            return `.\\${tail}`;
          }
          let index = path4.indexOf(":");
          do {
            if (index === len - 1 || isPathSeparator(path4.charCodeAt(index + 1))) {
              return `.\\${tail}`;
            }
          } while ((index = path4.indexOf(":", index + 1)) !== -1);
        }
        if (device === void 0) {
          return isAbsolute4 ? `\\${tail}` : tail;
        }
        return isAbsolute4 ? `${device}\\${tail}` : `${device}${tail}`;
      },
      isAbsolute(path4) {
        validateString(path4, "path");
        const len = path4.length;
        if (len === 0) {
          return false;
        }
        const code2 = path4.charCodeAt(0);
        return isPathSeparator(code2) || // Possible device root
        len > 2 && isWindowsDeviceRoot(code2) && path4.charCodeAt(1) === CHAR_COLON && isPathSeparator(path4.charCodeAt(2));
      },
      join(...paths) {
        if (paths.length === 0) {
          return ".";
        }
        let joined;
        let firstPart;
        for (let i = 0; i < paths.length; ++i) {
          const arg = paths[i];
          validateString(arg, "path");
          if (arg.length > 0) {
            if (joined === void 0) {
              joined = firstPart = arg;
            } else {
              joined += `\\${arg}`;
            }
          }
        }
        if (joined === void 0) {
          return ".";
        }
        let needsReplace = true;
        let slashCount = 0;
        if (typeof firstPart === "string" && isPathSeparator(firstPart.charCodeAt(0))) {
          ++slashCount;
          const firstLen = firstPart.length;
          if (firstLen > 1 && isPathSeparator(firstPart.charCodeAt(1))) {
            ++slashCount;
            if (firstLen > 2) {
              if (isPathSeparator(firstPart.charCodeAt(2))) {
                ++slashCount;
              } else {
                needsReplace = false;
              }
            }
          }
        }
        if (needsReplace) {
          while (slashCount < joined.length && isPathSeparator(joined.charCodeAt(slashCount))) {
            slashCount++;
          }
          if (slashCount >= 2) {
            joined = `\\${joined.slice(slashCount)}`;
          }
        }
        return win32.normalize(joined);
      },
      // It will solve the relative path from `from` to `to`, for instance:
      //  from = 'C:\\orandea\\test\\aaa'
      //  to = 'C:\\orandea\\impl\\bbb'
      // The output of the function should be: '..\\..\\impl\\bbb'
      relative(from, to) {
        validateString(from, "from");
        validateString(to, "to");
        if (from === to) {
          return "";
        }
        const fromOrig = win32.resolve(from);
        const toOrig = win32.resolve(to);
        if (fromOrig === toOrig) {
          return "";
        }
        from = fromOrig.toLowerCase();
        to = toOrig.toLowerCase();
        if (from === to) {
          return "";
        }
        if (fromOrig.length !== from.length || toOrig.length !== to.length) {
          const fromSplit = fromOrig.split("\\");
          const toSplit = toOrig.split("\\");
          if (fromSplit[fromSplit.length - 1] === "") {
            fromSplit.pop();
          }
          if (toSplit[toSplit.length - 1] === "") {
            toSplit.pop();
          }
          const fromLen2 = fromSplit.length;
          const toLen2 = toSplit.length;
          const length2 = fromLen2 < toLen2 ? fromLen2 : toLen2;
          let i2;
          for (i2 = 0; i2 < length2; i2++) {
            if (fromSplit[i2].toLowerCase() !== toSplit[i2].toLowerCase()) {
              break;
            }
          }
          if (i2 === 0) {
            return toOrig;
          } else if (i2 === length2) {
            if (toLen2 > length2) {
              return toSplit.slice(i2).join("\\");
            }
            if (fromLen2 > length2) {
              return "..\\".repeat(fromLen2 - 1 - i2) + "..";
            }
            return "";
          }
          return "..\\".repeat(fromLen2 - i2) + toSplit.slice(i2).join("\\");
        }
        let fromStart = 0;
        while (fromStart < from.length && from.charCodeAt(fromStart) === CHAR_BACKWARD_SLASH) {
          fromStart++;
        }
        let fromEnd = from.length;
        while (fromEnd - 1 > fromStart && from.charCodeAt(fromEnd - 1) === CHAR_BACKWARD_SLASH) {
          fromEnd--;
        }
        const fromLen = fromEnd - fromStart;
        let toStart = 0;
        while (toStart < to.length && to.charCodeAt(toStart) === CHAR_BACKWARD_SLASH) {
          toStart++;
        }
        let toEnd = to.length;
        while (toEnd - 1 > toStart && to.charCodeAt(toEnd - 1) === CHAR_BACKWARD_SLASH) {
          toEnd--;
        }
        const toLen = toEnd - toStart;
        const length = fromLen < toLen ? fromLen : toLen;
        let lastCommonSep = -1;
        let i = 0;
        for (; i < length; i++) {
          const fromCode = from.charCodeAt(fromStart + i);
          if (fromCode !== to.charCodeAt(toStart + i)) {
            break;
          } else if (fromCode === CHAR_BACKWARD_SLASH) {
            lastCommonSep = i;
          }
        }
        if (i !== length) {
          if (lastCommonSep === -1) {
            return toOrig;
          }
        } else {
          if (toLen > length) {
            if (to.charCodeAt(toStart + i) === CHAR_BACKWARD_SLASH) {
              return toOrig.slice(toStart + i + 1);
            }
            if (i === 2) {
              return toOrig.slice(toStart + i);
            }
          }
          if (fromLen > length) {
            if (from.charCodeAt(fromStart + i) === CHAR_BACKWARD_SLASH) {
              lastCommonSep = i;
            } else if (i === 2) {
              lastCommonSep = 3;
            }
          }
          if (lastCommonSep === -1) {
            lastCommonSep = 0;
          }
        }
        let out = "";
        for (i = fromStart + lastCommonSep + 1; i <= fromEnd; ++i) {
          if (i === fromEnd || from.charCodeAt(i) === CHAR_BACKWARD_SLASH) {
            out += out.length === 0 ? ".." : "\\..";
          }
        }
        toStart += lastCommonSep;
        if (out.length > 0) {
          return `${out}${toOrig.slice(toStart, toEnd)}`;
        }
        if (toOrig.charCodeAt(toStart) === CHAR_BACKWARD_SLASH) {
          ++toStart;
        }
        return toOrig.slice(toStart, toEnd);
      },
      toNamespacedPath(path4) {
        if (typeof path4 !== "string" || path4.length === 0) {
          return path4;
        }
        const resolvedPath = win32.resolve(path4);
        if (resolvedPath.length <= 2) {
          return path4;
        }
        if (resolvedPath.charCodeAt(0) === CHAR_BACKWARD_SLASH) {
          if (resolvedPath.charCodeAt(1) === CHAR_BACKWARD_SLASH) {
            const code2 = resolvedPath.charCodeAt(2);
            if (code2 !== CHAR_QUESTION_MARK && code2 !== CHAR_DOT) {
              return `\\\\?\\UNC\\${resolvedPath.slice(2)}`;
            }
          }
        } else if (isWindowsDeviceRoot(resolvedPath.charCodeAt(0)) && resolvedPath.charCodeAt(1) === CHAR_COLON && resolvedPath.charCodeAt(2) === CHAR_BACKWARD_SLASH) {
          return `\\\\?\\${resolvedPath}`;
        }
        return resolvedPath;
      },
      dirname(path4) {
        validateString(path4, "path");
        const len = path4.length;
        if (len === 0) {
          return ".";
        }
        let rootEnd = -1;
        let offset = 0;
        const code2 = path4.charCodeAt(0);
        if (len === 1) {
          return isPathSeparator(code2) ? path4 : ".";
        }
        if (isPathSeparator(code2)) {
          rootEnd = offset = 1;
          if (isPathSeparator(path4.charCodeAt(1))) {
            let j = 2;
            let last = j;
            while (j < len && !isPathSeparator(path4.charCodeAt(j))) {
              j++;
            }
            if (j < len && j !== last) {
              last = j;
              while (j < len && isPathSeparator(path4.charCodeAt(j))) {
                j++;
              }
              if (j < len && j !== last) {
                last = j;
                while (j < len && !isPathSeparator(path4.charCodeAt(j))) {
                  j++;
                }
                if (j === len) {
                  return path4;
                }
                if (j !== last) {
                  rootEnd = offset = j + 1;
                }
              }
            }
          }
        } else if (isWindowsDeviceRoot(code2) && path4.charCodeAt(1) === CHAR_COLON) {
          rootEnd = len > 2 && isPathSeparator(path4.charCodeAt(2)) ? 3 : 2;
          offset = rootEnd;
        }
        let end = -1;
        let matchedSlash = true;
        for (let i = len - 1; i >= offset; --i) {
          if (isPathSeparator(path4.charCodeAt(i))) {
            if (!matchedSlash) {
              end = i;
              break;
            }
          } else {
            matchedSlash = false;
          }
        }
        if (end === -1) {
          if (rootEnd === -1) {
            return ".";
          }
          end = rootEnd;
        }
        return path4.slice(0, end);
      },
      basename(path4, suffix) {
        if (suffix !== void 0) {
          validateString(suffix, "suffix");
        }
        validateString(path4, "path");
        let start = 0;
        let end = -1;
        let matchedSlash = true;
        let i;
        if (path4.length >= 2 && isWindowsDeviceRoot(path4.charCodeAt(0)) && path4.charCodeAt(1) === CHAR_COLON) {
          start = 2;
        }
        if (suffix !== void 0 && suffix.length > 0 && suffix.length <= path4.length) {
          if (suffix === path4) {
            return "";
          }
          let extIdx = suffix.length - 1;
          let firstNonSlashEnd = -1;
          for (i = path4.length - 1; i >= start; --i) {
            const code2 = path4.charCodeAt(i);
            if (isPathSeparator(code2)) {
              if (!matchedSlash) {
                start = i + 1;
                break;
              }
            } else {
              if (firstNonSlashEnd === -1) {
                matchedSlash = false;
                firstNonSlashEnd = i + 1;
              }
              if (extIdx >= 0) {
                if (code2 === suffix.charCodeAt(extIdx)) {
                  if (--extIdx === -1) {
                    end = i;
                  }
                } else {
                  extIdx = -1;
                  end = firstNonSlashEnd;
                }
              }
            }
          }
          if (start === end) {
            end = firstNonSlashEnd;
          } else if (end === -1) {
            end = path4.length;
          }
          return path4.slice(start, end);
        }
        for (i = path4.length - 1; i >= start; --i) {
          if (isPathSeparator(path4.charCodeAt(i))) {
            if (!matchedSlash) {
              start = i + 1;
              break;
            }
          } else if (end === -1) {
            matchedSlash = false;
            end = i + 1;
          }
        }
        if (end === -1) {
          return "";
        }
        return path4.slice(start, end);
      },
      extname(path4) {
        validateString(path4, "path");
        let start = 0;
        let startDot = -1;
        let startPart = 0;
        let end = -1;
        let matchedSlash = true;
        let preDotState = 0;
        if (path4.length >= 2 && path4.charCodeAt(1) === CHAR_COLON && isWindowsDeviceRoot(path4.charCodeAt(0))) {
          start = startPart = 2;
        }
        for (let i = path4.length - 1; i >= start; --i) {
          const code2 = path4.charCodeAt(i);
          if (isPathSeparator(code2)) {
            if (!matchedSlash) {
              startPart = i + 1;
              break;
            }
            continue;
          }
          if (end === -1) {
            matchedSlash = false;
            end = i + 1;
          }
          if (code2 === CHAR_DOT) {
            if (startDot === -1) {
              startDot = i;
            } else if (preDotState !== 1) {
              preDotState = 1;
            }
          } else if (startDot !== -1) {
            preDotState = -1;
          }
        }
        if (startDot === -1 || end === -1 || // We saw a non-dot character immediately before the dot
        preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
        preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
          return "";
        }
        return path4.slice(startDot, end);
      },
      format: _format2.bind(null, "\\"),
      parse(path4) {
        validateString(path4, "path");
        const ret = { root: "", dir: "", base: "", ext: "", name: "" };
        if (path4.length === 0) {
          return ret;
        }
        const len = path4.length;
        let rootEnd = 0;
        let code2 = path4.charCodeAt(0);
        if (len === 1) {
          if (isPathSeparator(code2)) {
            ret.root = ret.dir = path4;
            return ret;
          }
          ret.base = ret.name = path4;
          return ret;
        }
        if (isPathSeparator(code2)) {
          rootEnd = 1;
          if (isPathSeparator(path4.charCodeAt(1))) {
            let j = 2;
            let last = j;
            while (j < len && !isPathSeparator(path4.charCodeAt(j))) {
              j++;
            }
            if (j < len && j !== last) {
              last = j;
              while (j < len && isPathSeparator(path4.charCodeAt(j))) {
                j++;
              }
              if (j < len && j !== last) {
                last = j;
                while (j < len && !isPathSeparator(path4.charCodeAt(j))) {
                  j++;
                }
                if (j === len) {
                  rootEnd = j;
                } else if (j !== last) {
                  rootEnd = j + 1;
                }
              }
            }
          }
        } else if (isWindowsDeviceRoot(code2) && path4.charCodeAt(1) === CHAR_COLON) {
          if (len <= 2) {
            ret.root = ret.dir = path4;
            return ret;
          }
          rootEnd = 2;
          if (isPathSeparator(path4.charCodeAt(2))) {
            if (len === 3) {
              ret.root = ret.dir = path4;
              return ret;
            }
            rootEnd = 3;
          }
        }
        if (rootEnd > 0) {
          ret.root = path4.slice(0, rootEnd);
        }
        let startDot = -1;
        let startPart = rootEnd;
        let end = -1;
        let matchedSlash = true;
        let i = path4.length - 1;
        let preDotState = 0;
        for (; i >= rootEnd; --i) {
          code2 = path4.charCodeAt(i);
          if (isPathSeparator(code2)) {
            if (!matchedSlash) {
              startPart = i + 1;
              break;
            }
            continue;
          }
          if (end === -1) {
            matchedSlash = false;
            end = i + 1;
          }
          if (code2 === CHAR_DOT) {
            if (startDot === -1) {
              startDot = i;
            } else if (preDotState !== 1) {
              preDotState = 1;
            }
          } else if (startDot !== -1) {
            preDotState = -1;
          }
        }
        if (end !== -1) {
          if (startDot === -1 || // We saw a non-dot character immediately before the dot
          preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
          preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
            ret.base = ret.name = path4.slice(startPart, end);
          } else {
            ret.name = path4.slice(startPart, startDot);
            ret.base = path4.slice(startPart, end);
            ret.ext = path4.slice(startDot, end);
          }
        }
        if (startPart > 0 && startPart !== rootEnd) {
          ret.dir = path4.slice(0, startPart - 1);
        } else {
          ret.dir = ret.root;
        }
        return ret;
      },
      sep: "\\",
      delimiter: ";",
      win32: null,
      posix: null
    };
    posixCwd = (() => {
      if (platformIsWin32) {
        const regexp2 = /\\/g;
        return () => {
          const cwd3 = cwd2().replace(regexp2, "/");
          return cwd3.slice(cwd3.indexOf("/"));
        };
      }
      return () => cwd2();
    })();
    posix = {
      // path.resolve([from ...], to)
      resolve(...pathSegments) {
        let resolvedPath = "";
        let resolvedAbsolute = false;
        for (let i = pathSegments.length - 1; i >= 0 && !resolvedAbsolute; i--) {
          const path4 = pathSegments[i];
          validateString(path4, `paths[${i}]`);
          if (path4.length === 0) {
            continue;
          }
          resolvedPath = `${path4}/${resolvedPath}`;
          resolvedAbsolute = path4.charCodeAt(0) === CHAR_FORWARD_SLASH;
        }
        if (!resolvedAbsolute) {
          const cwd3 = posixCwd();
          resolvedPath = `${cwd3}/${resolvedPath}`;
          resolvedAbsolute = cwd3.charCodeAt(0) === CHAR_FORWARD_SLASH;
        }
        resolvedPath = normalizeString(resolvedPath, !resolvedAbsolute, "/", isPosixPathSeparator);
        if (resolvedAbsolute) {
          return `/${resolvedPath}`;
        }
        return resolvedPath.length > 0 ? resolvedPath : ".";
      },
      normalize(path4) {
        validateString(path4, "path");
        if (path4.length === 0) {
          return ".";
        }
        const isAbsolute4 = path4.charCodeAt(0) === CHAR_FORWARD_SLASH;
        const trailingSeparator = path4.charCodeAt(path4.length - 1) === CHAR_FORWARD_SLASH;
        path4 = normalizeString(path4, !isAbsolute4, "/", isPosixPathSeparator);
        if (path4.length === 0) {
          if (isAbsolute4) {
            return "/";
          }
          return trailingSeparator ? "./" : ".";
        }
        if (trailingSeparator) {
          path4 += "/";
        }
        return isAbsolute4 ? `/${path4}` : path4;
      },
      isAbsolute(path4) {
        validateString(path4, "path");
        return path4.length > 0 && path4.charCodeAt(0) === CHAR_FORWARD_SLASH;
      },
      join(...paths) {
        if (paths.length === 0) {
          return ".";
        }
        const path4 = [];
        for (let i = 0; i < paths.length; ++i) {
          const arg = paths[i];
          validateString(arg, "path");
          if (arg.length > 0) {
            path4.push(arg);
          }
        }
        if (path4.length === 0) {
          return ".";
        }
        return posix.normalize(path4.join("/"));
      },
      relative(from, to) {
        validateString(from, "from");
        validateString(to, "to");
        if (from === to) {
          return "";
        }
        from = posix.resolve(from);
        to = posix.resolve(to);
        if (from === to) {
          return "";
        }
        const fromStart = 1;
        const fromEnd = from.length;
        const fromLen = fromEnd - fromStart;
        const toStart = 1;
        const toLen = to.length - toStart;
        const length = fromLen < toLen ? fromLen : toLen;
        let lastCommonSep = -1;
        let i = 0;
        for (; i < length; i++) {
          const fromCode = from.charCodeAt(fromStart + i);
          if (fromCode !== to.charCodeAt(toStart + i)) {
            break;
          } else if (fromCode === CHAR_FORWARD_SLASH) {
            lastCommonSep = i;
          }
        }
        if (i === length) {
          if (toLen > length) {
            if (to.charCodeAt(toStart + i) === CHAR_FORWARD_SLASH) {
              return to.slice(toStart + i + 1);
            }
            if (i === 0) {
              return to.slice(toStart + i);
            }
          } else if (fromLen > length) {
            if (from.charCodeAt(fromStart + i) === CHAR_FORWARD_SLASH) {
              lastCommonSep = i;
            } else if (i === 0) {
              lastCommonSep = 0;
            }
          }
        }
        let out = "";
        for (i = fromStart + lastCommonSep + 1; i <= fromEnd; ++i) {
          if (i === fromEnd || from.charCodeAt(i) === CHAR_FORWARD_SLASH) {
            out += out.length === 0 ? ".." : "/..";
          }
        }
        return `${out}${to.slice(toStart + lastCommonSep)}`;
      },
      toNamespacedPath(path4) {
        return path4;
      },
      dirname(path4) {
        validateString(path4, "path");
        if (path4.length === 0) {
          return ".";
        }
        const hasRoot = path4.charCodeAt(0) === CHAR_FORWARD_SLASH;
        let end = -1;
        let matchedSlash = true;
        for (let i = path4.length - 1; i >= 1; --i) {
          if (path4.charCodeAt(i) === CHAR_FORWARD_SLASH) {
            if (!matchedSlash) {
              end = i;
              break;
            }
          } else {
            matchedSlash = false;
          }
        }
        if (end === -1) {
          return hasRoot ? "/" : ".";
        }
        if (hasRoot && end === 1) {
          return "//";
        }
        return path4.slice(0, end);
      },
      basename(path4, suffix) {
        if (suffix !== void 0) {
          validateString(suffix, "suffix");
        }
        validateString(path4, "path");
        let start = 0;
        let end = -1;
        let matchedSlash = true;
        let i;
        if (suffix !== void 0 && suffix.length > 0 && suffix.length <= path4.length) {
          if (suffix === path4) {
            return "";
          }
          let extIdx = suffix.length - 1;
          let firstNonSlashEnd = -1;
          for (i = path4.length - 1; i >= 0; --i) {
            const code2 = path4.charCodeAt(i);
            if (code2 === CHAR_FORWARD_SLASH) {
              if (!matchedSlash) {
                start = i + 1;
                break;
              }
            } else {
              if (firstNonSlashEnd === -1) {
                matchedSlash = false;
                firstNonSlashEnd = i + 1;
              }
              if (extIdx >= 0) {
                if (code2 === suffix.charCodeAt(extIdx)) {
                  if (--extIdx === -1) {
                    end = i;
                  }
                } else {
                  extIdx = -1;
                  end = firstNonSlashEnd;
                }
              }
            }
          }
          if (start === end) {
            end = firstNonSlashEnd;
          } else if (end === -1) {
            end = path4.length;
          }
          return path4.slice(start, end);
        }
        for (i = path4.length - 1; i >= 0; --i) {
          if (path4.charCodeAt(i) === CHAR_FORWARD_SLASH) {
            if (!matchedSlash) {
              start = i + 1;
              break;
            }
          } else if (end === -1) {
            matchedSlash = false;
            end = i + 1;
          }
        }
        if (end === -1) {
          return "";
        }
        return path4.slice(start, end);
      },
      extname(path4) {
        validateString(path4, "path");
        let startDot = -1;
        let startPart = 0;
        let end = -1;
        let matchedSlash = true;
        let preDotState = 0;
        for (let i = path4.length - 1; i >= 0; --i) {
          const char = path4[i];
          if (char === "/") {
            if (!matchedSlash) {
              startPart = i + 1;
              break;
            }
            continue;
          }
          if (end === -1) {
            matchedSlash = false;
            end = i + 1;
          }
          if (char === ".") {
            if (startDot === -1) {
              startDot = i;
            } else if (preDotState !== 1) {
              preDotState = 1;
            }
          } else if (startDot !== -1) {
            preDotState = -1;
          }
        }
        if (startDot === -1 || end === -1 || // We saw a non-dot character immediately before the dot
        preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
        preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
          return "";
        }
        return path4.slice(startDot, end);
      },
      format: _format2.bind(null, "/"),
      parse(path4) {
        validateString(path4, "path");
        const ret = { root: "", dir: "", base: "", ext: "", name: "" };
        if (path4.length === 0) {
          return ret;
        }
        const isAbsolute4 = path4.charCodeAt(0) === CHAR_FORWARD_SLASH;
        let start;
        if (isAbsolute4) {
          ret.root = "/";
          start = 1;
        } else {
          start = 0;
        }
        let startDot = -1;
        let startPart = 0;
        let end = -1;
        let matchedSlash = true;
        let i = path4.length - 1;
        let preDotState = 0;
        for (; i >= start; --i) {
          const code2 = path4.charCodeAt(i);
          if (code2 === CHAR_FORWARD_SLASH) {
            if (!matchedSlash) {
              startPart = i + 1;
              break;
            }
            continue;
          }
          if (end === -1) {
            matchedSlash = false;
            end = i + 1;
          }
          if (code2 === CHAR_DOT) {
            if (startDot === -1) {
              startDot = i;
            } else if (preDotState !== 1) {
              preDotState = 1;
            }
          } else if (startDot !== -1) {
            preDotState = -1;
          }
        }
        if (end !== -1) {
          const start2 = startPart === 0 && isAbsolute4 ? 1 : startPart;
          if (startDot === -1 || // We saw a non-dot character immediately before the dot
          preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
          preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
            ret.base = ret.name = path4.slice(start2, end);
          } else {
            ret.name = path4.slice(start2, startDot);
            ret.base = path4.slice(start2, end);
            ret.ext = path4.slice(startDot, end);
          }
        }
        if (startPart > 0) {
          ret.dir = path4.slice(0, startPart - 1);
        } else if (isAbsolute4) {
          ret.dir = "/";
        }
        return ret;
      },
      sep: "/",
      delimiter: ":",
      win32: null,
      posix: null
    };
    posix.win32 = win32.win32 = win32;
    posix.posix = win32.posix = posix;
    normalize = platformIsWin32 ? win32.normalize : posix.normalize;
    isAbsolute2 = platformIsWin32 ? win32.isAbsolute : posix.isAbsolute;
    join3 = platformIsWin32 ? win32.join : posix.join;
    resolve2 = platformIsWin32 ? win32.resolve : posix.resolve;
    relative2 = platformIsWin32 ? win32.relative : posix.relative;
    dirname3 = platformIsWin32 ? win32.dirname : posix.dirname;
    basename = platformIsWin32 ? win32.basename : posix.basename;
    extname = platformIsWin32 ? win32.extname : posix.extname;
    format = platformIsWin32 ? win32.format : posix.format;
    parse2 = platformIsWin32 ? win32.parse : posix.parse;
    toNamespacedPath = platformIsWin32 ? win32.toNamespacedPath : posix.toNamespacedPath;
    sep = platformIsWin32 ? win32.sep : posix.sep;
    delimiter = platformIsWin32 ? win32.delimiter : posix.delimiter;
  }
});

// out-build/vs/base/common/collections.js
function groupBy(data, groupFn) {
  const result = /* @__PURE__ */ Object.create(null);
  for (const element of data) {
    const key = groupFn(element);
    let target = result[key];
    if (!target) {
      target = result[key] = [];
    }
    target.push(element);
  }
  return result;
}
var _a, SetWithKey;
var init_collections = __esm({
  "out-build/vs/base/common/collections.js"() {
    "use strict";
    SetWithKey = class {
      static {
        _a = Symbol.toStringTag;
      }
      constructor(values, toKey) {
        this.toKey = toKey;
        this._map = /* @__PURE__ */ new Map();
        this[_a] = "SetWithKey";
        for (const value of values) {
          this.add(value);
        }
      }
      get size() {
        return this._map.size;
      }
      add(value) {
        const key = this.toKey(value);
        this._map.set(key, value);
        return this;
      }
      delete(value) {
        return this._map.delete(this.toKey(value));
      }
      has(value) {
        return this._map.has(this.toKey(value));
      }
      *entries() {
        for (const entry of this._map.values()) {
          yield [entry, entry];
        }
      }
      keys() {
        return this.values();
      }
      *values() {
        for (const entry of this._map.values()) {
          yield entry;
        }
      }
      clear() {
        this._map.clear();
      }
      forEach(callbackfn, thisArg) {
        this._map.forEach((entry) => callbackfn.call(thisArg, entry, entry, this));
      }
      [Symbol.iterator]() {
        return this.values();
      }
    };
  }
});

// out-build/vs/base/common/errors.js
function setUnexpectedErrorHandler(newUnexpectedErrorHandler) {
  errorHandler.setUnexpectedErrorHandler(newUnexpectedErrorHandler);
}
function isSigPipeError(e) {
  if (!e || typeof e !== "object") {
    return false;
  }
  const cast = e;
  return cast.code === "EPIPE" && cast.syscall?.toUpperCase() === "WRITE";
}
function onUnexpectedError(e) {
  if (!isCancellationError(e)) {
    errorHandler.onUnexpectedError(e);
  }
  return void 0;
}
function isCancellationError(error) {
  if (error instanceof CancellationError) {
    return true;
  }
  return error instanceof Error && error.name === canceledName && error.message === canceledName;
}
function canceled() {
  const error = new Error(canceledName);
  error.name = error.message;
  return error;
}
function illegalState(name) {
  if (name) {
    return new Error(`Illegal state: ${name}`);
  } else {
    return new Error("Illegal state");
  }
}
function getErrorMessage(err) {
  if (!err) {
    return "Error";
  }
  if (err.message) {
    return err.message;
  }
  if (err.stack) {
    return err.stack.split("\n")[0];
  }
  return String(err);
}
var ErrorHandler, errorHandler, canceledName, CancellationError, PendingMigrationError, ExpectedError, ErrorNoTelemetry, BugIndicatingError;
var init_errors = __esm({
  "out-build/vs/base/common/errors.js"() {
    "use strict";
    ErrorHandler = class {
      constructor() {
        this.listeners = [];
        this.unexpectedErrorHandler = function(e) {
          setTimeout(() => {
            if (e.stack) {
              if (ErrorNoTelemetry.isErrorNoTelemetry(e)) {
                throw new ErrorNoTelemetry(e.message + "\n\n" + e.stack);
              }
              throw new Error(e.message + "\n\n" + e.stack);
            }
            throw e;
          }, 0);
        };
      }
      addListener(listener) {
        this.listeners.push(listener);
        return () => {
          this._removeListener(listener);
        };
      }
      emit(e) {
        this.listeners.forEach((listener) => {
          listener(e);
        });
      }
      _removeListener(listener) {
        this.listeners.splice(this.listeners.indexOf(listener), 1);
      }
      setUnexpectedErrorHandler(newUnexpectedErrorHandler) {
        this.unexpectedErrorHandler = newUnexpectedErrorHandler;
      }
      getUnexpectedErrorHandler() {
        return this.unexpectedErrorHandler;
      }
      onUnexpectedError(e) {
        this.unexpectedErrorHandler(e);
        this.emit(e);
      }
      // For external errors, we don't want the listeners to be called
      onUnexpectedExternalError(e) {
        this.unexpectedErrorHandler(e);
      }
    };
    errorHandler = new ErrorHandler();
    canceledName = "Canceled";
    CancellationError = class extends Error {
      constructor() {
        super(canceledName);
        this.name = this.message;
      }
    };
    PendingMigrationError = class _PendingMigrationError extends Error {
      static {
        this._name = "PendingMigrationError";
      }
      static is(error) {
        return error instanceof _PendingMigrationError || error instanceof Error && error.name === _PendingMigrationError._name;
      }
      constructor(message) {
        super(message);
        this.name = _PendingMigrationError._name;
      }
    };
    ExpectedError = class extends Error {
      constructor() {
        super(...arguments);
        this.isExpected = true;
      }
    };
    ErrorNoTelemetry = class _ErrorNoTelemetry extends Error {
      constructor(msg) {
        super(msg);
        this.name = "CodeExpectedError";
      }
      static fromError(err) {
        if (err instanceof _ErrorNoTelemetry) {
          return err;
        }
        const result = new _ErrorNoTelemetry();
        result.message = err.message;
        result.stack = err.stack;
        return result;
      }
      static isErrorNoTelemetry(err) {
        return err.name === "CodeExpectedError";
      }
    };
    BugIndicatingError = class _BugIndicatingError extends Error {
      constructor(message) {
        super(message || "An unexpected bug occurred.");
        Object.setPrototypeOf(this, _BugIndicatingError.prototype);
      }
    };
  }
});

// out-build/vs/base/common/functional.js
function createSingleCallFunction(fn, fnDidRunCallback) {
  const _this = this;
  let didCall = false;
  let result;
  return function() {
    if (didCall) {
      return result;
    }
    didCall = true;
    if (fnDidRunCallback) {
      try {
        result = fn.apply(_this, arguments);
      } finally {
        fnDidRunCallback();
      }
    } else {
      result = fn.apply(_this, arguments);
    }
    return result;
  };
}
var init_functional = __esm({
  "out-build/vs/base/common/functional.js"() {
    "use strict";
  }
});

// out-build/vs/base/common/arraysFind.js
function findLastIdxMonotonous(array, predicate, startIdx = 0, endIdxEx = array.length) {
  let i = startIdx;
  let j = endIdxEx;
  while (i < j) {
    const k = Math.floor((i + j) / 2);
    if (predicate(array[k])) {
      i = k + 1;
    } else {
      j = k;
    }
  }
  return i - 1;
}
function findFirstIdxMonotonousOrArrLen(array, predicate, startIdx = 0, endIdxEx = array.length) {
  let i = startIdx;
  let j = endIdxEx;
  while (i < j) {
    const k = Math.floor((i + j) / 2);
    if (predicate(array[k])) {
      j = k;
    } else {
      i = k + 1;
    }
  }
  return i;
}
var MonotonousArray;
var init_arraysFind = __esm({
  "out-build/vs/base/common/arraysFind.js"() {
    "use strict";
    MonotonousArray = class _MonotonousArray {
      static {
        this.assertInvariants = false;
      }
      constructor(_array) {
        this._array = _array;
        this._findLastMonotonousLastIdx = 0;
      }
      /**
       * The predicate must be monotonous, i.e. `arr.map(predicate)` must be like `[true, ..., true, false, ..., false]`!
       * For subsequent calls, current predicate must be weaker than (or equal to) the previous predicate, i.e. more entries must be `true`.
       */
      findLastMonotonous(predicate) {
        if (_MonotonousArray.assertInvariants) {
          if (this._prevFindLastPredicate) {
            for (const item of this._array) {
              if (this._prevFindLastPredicate(item) && !predicate(item)) {
                throw new Error("MonotonousArray: current predicate must be weaker than (or equal to) the previous predicate.");
              }
            }
          }
          this._prevFindLastPredicate = predicate;
        }
        const idx = findLastIdxMonotonous(this._array, predicate, this._findLastMonotonousLastIdx);
        this._findLastMonotonousLastIdx = idx + 1;
        return idx === -1 ? void 0 : this._array[idx];
      }
    };
  }
});

// out-build/vs/base/common/arrays.js
function equals(one, other, itemEquals = (a, b) => a === b) {
  if (one === other) {
    return true;
  }
  if (!one || !other) {
    return false;
  }
  if (one.length !== other.length) {
    return false;
  }
  for (let i = 0, len = one.length; i < len; i++) {
    if (!itemEquals(one[i], other[i])) {
      return false;
    }
  }
  return true;
}
function binarySearch(array, key, comparator) {
  return binarySearch2(array.length, (i) => comparator(array[i], key));
}
function binarySearch2(length, compareToKey) {
  let low = 0, high = length - 1;
  while (low <= high) {
    const mid = (low + high) / 2 | 0;
    const comp = compareToKey(mid);
    if (comp < 0) {
      low = mid + 1;
    } else if (comp > 0) {
      high = mid - 1;
    } else {
      return mid;
    }
  }
  return -(low + 1);
}
function top(array, compare4, n) {
  if (n === 0) {
    return [];
  }
  const result = array.slice(0, n).sort(compare4);
  topStep(array, compare4, result, n, array.length);
  return result;
}
function topStep(array, compare4, result, i, m) {
  for (const n = result.length; i < m; i++) {
    const element = array[i];
    if (compare4(element, result[n - 1]) < 0) {
      result.pop();
      const j = findFirstIdxMonotonousOrArrLen(result, (e) => compare4(element, e) < 0);
      result.splice(j, 0, element);
    }
  }
}
function coalesce(array) {
  return array.filter((e) => !!e);
}
function distinct(array, keyFn = (value) => value) {
  const seen = /* @__PURE__ */ new Set();
  return array.filter((element) => {
    const key = keyFn(element);
    if (seen.has(key)) {
      return false;
    }
    seen.add(key);
    return true;
  });
}
function insert(array, element) {
  array.push(element);
  return () => remove(array, element);
}
function remove(array, element) {
  const index = array.indexOf(element);
  if (index > -1) {
    array.splice(index, 1);
    return element;
  }
  return void 0;
}
function shuffle(array, _seed) {
  let rand;
  if (typeof _seed === "number") {
    let seed = _seed;
    rand = () => {
      const x = Math.sin(seed++) * 179426549;
      return x - Math.floor(x);
    };
  } else {
    rand = Math.random;
  }
  for (let i = array.length - 1; i > 0; i -= 1) {
    const j = Math.floor(rand() * (i + 1));
    const temp = array[i];
    array[i] = array[j];
    array[j] = temp;
  }
}
function getRandomElement(arr) {
  return arr[Math.floor(Math.random() * arr.length)];
}
function compareBy(selector, comparator) {
  return (a, b) => comparator(selector(a), selector(b));
}
var CompareResult, numberComparator, CallbackIterable;
var init_arrays = __esm({
  "out-build/vs/base/common/arrays.js"() {
    "use strict";
    init_arraysFind();
    init_errors();
    (function(CompareResult2) {
      function isLessThan(result) {
        return result < 0;
      }
      CompareResult2.isLessThan = isLessThan;
      function isLessThanOrEqual(result) {
        return result <= 0;
      }
      CompareResult2.isLessThanOrEqual = isLessThanOrEqual;
      function isGreaterThan(result) {
        return result > 0;
      }
      CompareResult2.isGreaterThan = isGreaterThan;
      function isNeitherLessOrGreaterThan(result) {
        return result === 0;
      }
      CompareResult2.isNeitherLessOrGreaterThan = isNeitherLessOrGreaterThan;
      CompareResult2.greaterThan = 1;
      CompareResult2.lessThan = -1;
      CompareResult2.neitherLessOrGreaterThan = 0;
    })(CompareResult || (CompareResult = {}));
    numberComparator = (a, b) => a - b;
    CallbackIterable = class _CallbackIterable {
      static {
        this.empty = new _CallbackIterable((_callback) => {
        });
      }
      constructor(iterate) {
        this.iterate = iterate;
      }
      forEach(handler) {
        this.iterate((item) => {
          handler(item);
          return true;
        });
      }
      toArray() {
        const result = [];
        this.iterate((item) => {
          result.push(item);
          return true;
        });
        return result;
      }
      filter(predicate) {
        return new _CallbackIterable((cb) => this.iterate((item) => predicate(item) ? cb(item) : true));
      }
      map(mapFn) {
        return new _CallbackIterable((cb) => this.iterate((item) => cb(mapFn(item))));
      }
      some(predicate) {
        let result = false;
        this.iterate((item) => {
          result = predicate(item);
          return !result;
        });
        return result;
      }
      findFirst(predicate) {
        let result;
        this.iterate((item) => {
          if (predicate(item)) {
            result = item;
            return false;
          }
          return true;
        });
        return result;
      }
      findLast(predicate) {
        let result;
        this.iterate((item) => {
          if (predicate(item)) {
            result = item;
          }
          return true;
        });
        return result;
      }
      findLastMaxBy(comparator) {
        let result;
        let first2 = true;
        this.iterate((item) => {
          if (first2 || CompareResult.isGreaterThan(comparator(item, result))) {
            first2 = false;
            result = item;
          }
          return true;
        });
        return result;
      }
    };
  }
});

// out-build/vs/base/common/map.js
function mapToString(map) {
  const entries = [];
  map.forEach((value, key) => {
    entries.push(`${key} => ${value}`);
  });
  return `Map(${map.size}) {${entries.join(", ")}}`;
}
function setToString(set) {
  const entries = [];
  set.forEach((value) => {
    entries.push(value);
  });
  return `Set(${set.size}) {${entries.join(", ")}}`;
}
function isEntries(arg) {
  return Array.isArray(arg);
}
var _a2, _b, _c, ResourceMapEntry, ResourceMap, ResourceSet, Touch, LinkedMap, Cache, LRUCache, SetMap;
var init_map = __esm({
  "out-build/vs/base/common/map.js"() {
    "use strict";
    ResourceMapEntry = class {
      constructor(uri, value) {
        this.uri = uri;
        this.value = value;
      }
    };
    ResourceMap = class _ResourceMap {
      static {
        this.defaultToKey = (resource) => resource.toString();
      }
      constructor(arg, toKey) {
        this[_a2] = "ResourceMap";
        if (arg instanceof _ResourceMap) {
          this.map = new Map(arg.map);
          this.toKey = toKey ?? _ResourceMap.defaultToKey;
        } else if (isEntries(arg)) {
          this.map = /* @__PURE__ */ new Map();
          this.toKey = toKey ?? _ResourceMap.defaultToKey;
          for (const [resource, value] of arg) {
            this.set(resource, value);
          }
        } else {
          this.map = /* @__PURE__ */ new Map();
          this.toKey = arg ?? _ResourceMap.defaultToKey;
        }
      }
      set(resource, value) {
        this.map.set(this.toKey(resource), new ResourceMapEntry(resource, value));
        return this;
      }
      get(resource) {
        return this.map.get(this.toKey(resource))?.value;
      }
      has(resource) {
        return this.map.has(this.toKey(resource));
      }
      get size() {
        return this.map.size;
      }
      clear() {
        this.map.clear();
      }
      delete(resource) {
        return this.map.delete(this.toKey(resource));
      }
      forEach(clb, thisArg) {
        if (typeof thisArg !== "undefined") {
          clb = clb.bind(thisArg);
        }
        for (const [_, entry] of this.map) {
          clb(entry.value, entry.uri, this);
        }
      }
      *values() {
        for (const entry of this.map.values()) {
          yield entry.value;
        }
      }
      *keys() {
        for (const entry of this.map.values()) {
          yield entry.uri;
        }
      }
      *entries() {
        for (const entry of this.map.values()) {
          yield [entry.uri, entry.value];
        }
      }
      *[(_a2 = Symbol.toStringTag, Symbol.iterator)]() {
        for (const [, entry] of this.map) {
          yield [entry.uri, entry.value];
        }
      }
    };
    ResourceSet = class {
      constructor(entriesOrKey, toKey) {
        this[_b] = "ResourceSet";
        if (!entriesOrKey || typeof entriesOrKey === "function") {
          this._map = new ResourceMap(entriesOrKey);
        } else {
          this._map = new ResourceMap(toKey);
          entriesOrKey.forEach(this.add, this);
        }
      }
      get size() {
        return this._map.size;
      }
      add(value) {
        this._map.set(value, value);
        return this;
      }
      clear() {
        this._map.clear();
      }
      delete(value) {
        return this._map.delete(value);
      }
      forEach(callbackfn, thisArg) {
        this._map.forEach((_value, key) => callbackfn.call(thisArg, key, key, this));
      }
      has(value) {
        return this._map.has(value);
      }
      entries() {
        return this._map.entries();
      }
      keys() {
        return this._map.keys();
      }
      values() {
        return this._map.keys();
      }
      [(_b = Symbol.toStringTag, Symbol.iterator)]() {
        return this.keys();
      }
    };
    (function(Touch2) {
      Touch2[Touch2["None"] = 0] = "None";
      Touch2[Touch2["AsOld"] = 1] = "AsOld";
      Touch2[Touch2["AsNew"] = 2] = "AsNew";
    })(Touch || (Touch = {}));
    LinkedMap = class {
      constructor() {
        this[_c] = "LinkedMap";
        this._map = /* @__PURE__ */ new Map();
        this._head = void 0;
        this._tail = void 0;
        this._size = 0;
        this._state = 0;
      }
      clear() {
        this._map.clear();
        this._head = void 0;
        this._tail = void 0;
        this._size = 0;
        this._state++;
      }
      isEmpty() {
        return !this._head && !this._tail;
      }
      get size() {
        return this._size;
      }
      get first() {
        return this._head?.value;
      }
      get last() {
        return this._tail?.value;
      }
      has(key) {
        return this._map.has(key);
      }
      get(key, touch2 = 0) {
        const item = this._map.get(key);
        if (!item) {
          return void 0;
        }
        if (touch2 !== 0) {
          this.touch(item, touch2);
        }
        return item.value;
      }
      set(key, value, touch2 = 0) {
        let item = this._map.get(key);
        if (item) {
          item.value = value;
          if (touch2 !== 0) {
            this.touch(item, touch2);
          }
        } else {
          item = { key, value, next: void 0, previous: void 0 };
          switch (touch2) {
            case 0:
              this.addItemLast(item);
              break;
            case 1:
              this.addItemFirst(item);
              break;
            case 2:
              this.addItemLast(item);
              break;
            default:
              this.addItemLast(item);
              break;
          }
          this._map.set(key, item);
          this._size++;
        }
        return this;
      }
      delete(key) {
        return !!this.remove(key);
      }
      remove(key) {
        const item = this._map.get(key);
        if (!item) {
          return void 0;
        }
        this._map.delete(key);
        this.removeItem(item);
        this._size--;
        return item.value;
      }
      shift() {
        if (!this._head && !this._tail) {
          return void 0;
        }
        if (!this._head || !this._tail) {
          throw new Error("Invalid list");
        }
        const item = this._head;
        this._map.delete(item.key);
        this.removeItem(item);
        this._size--;
        return item.value;
      }
      forEach(callbackfn, thisArg) {
        const state = this._state;
        let current = this._head;
        while (current) {
          if (thisArg) {
            callbackfn.bind(thisArg)(current.value, current.key, this);
          } else {
            callbackfn(current.value, current.key, this);
          }
          if (this._state !== state) {
            throw new Error(`LinkedMap got modified during iteration.`);
          }
          current = current.next;
        }
      }
      keys() {
        const map = this;
        const state = this._state;
        let current = this._head;
        const iterator = {
          [Symbol.iterator]() {
            return iterator;
          },
          next() {
            if (map._state !== state) {
              throw new Error(`LinkedMap got modified during iteration.`);
            }
            if (current) {
              const result = { value: current.key, done: false };
              current = current.next;
              return result;
            } else {
              return { value: void 0, done: true };
            }
          }
        };
        return iterator;
      }
      values() {
        const map = this;
        const state = this._state;
        let current = this._head;
        const iterator = {
          [Symbol.iterator]() {
            return iterator;
          },
          next() {
            if (map._state !== state) {
              throw new Error(`LinkedMap got modified during iteration.`);
            }
            if (current) {
              const result = { value: current.value, done: false };
              current = current.next;
              return result;
            } else {
              return { value: void 0, done: true };
            }
          }
        };
        return iterator;
      }
      entries() {
        const map = this;
        const state = this._state;
        let current = this._head;
        const iterator = {
          [Symbol.iterator]() {
            return iterator;
          },
          next() {
            if (map._state !== state) {
              throw new Error(`LinkedMap got modified during iteration.`);
            }
            if (current) {
              const result = { value: [current.key, current.value], done: false };
              current = current.next;
              return result;
            } else {
              return { value: void 0, done: true };
            }
          }
        };
        return iterator;
      }
      [(_c = Symbol.toStringTag, Symbol.iterator)]() {
        return this.entries();
      }
      trimOld(newSize) {
        if (newSize >= this.size) {
          return;
        }
        if (newSize === 0) {
          this.clear();
          return;
        }
        let current = this._head;
        let currentSize = this.size;
        while (current && currentSize > newSize) {
          this._map.delete(current.key);
          current = current.next;
          currentSize--;
        }
        this._head = current;
        this._size = currentSize;
        if (current) {
          current.previous = void 0;
        }
        this._state++;
      }
      trimNew(newSize) {
        if (newSize >= this.size) {
          return;
        }
        if (newSize === 0) {
          this.clear();
          return;
        }
        let current = this._tail;
        let currentSize = this.size;
        while (current && currentSize > newSize) {
          this._map.delete(current.key);
          current = current.previous;
          currentSize--;
        }
        this._tail = current;
        this._size = currentSize;
        if (current) {
          current.next = void 0;
        }
        this._state++;
      }
      addItemFirst(item) {
        if (!this._head && !this._tail) {
          this._tail = item;
        } else if (!this._head) {
          throw new Error("Invalid list");
        } else {
          item.next = this._head;
          this._head.previous = item;
        }
        this._head = item;
        this._state++;
      }
      addItemLast(item) {
        if (!this._head && !this._tail) {
          this._head = item;
        } else if (!this._tail) {
          throw new Error("Invalid list");
        } else {
          item.previous = this._tail;
          this._tail.next = item;
        }
        this._tail = item;
        this._state++;
      }
      removeItem(item) {
        if (item === this._head && item === this._tail) {
          this._head = void 0;
          this._tail = void 0;
        } else if (item === this._head) {
          if (!item.next) {
            throw new Error("Invalid list");
          }
          item.next.previous = void 0;
          this._head = item.next;
        } else if (item === this._tail) {
          if (!item.previous) {
            throw new Error("Invalid list");
          }
          item.previous.next = void 0;
          this._tail = item.previous;
        } else {
          const next = item.next;
          const previous = item.previous;
          if (!next || !previous) {
            throw new Error("Invalid list");
          }
          next.previous = previous;
          previous.next = next;
        }
        item.next = void 0;
        item.previous = void 0;
        this._state++;
      }
      touch(item, touch2) {
        if (!this._head || !this._tail) {
          throw new Error("Invalid list");
        }
        if (touch2 !== 1 && touch2 !== 2) {
          return;
        }
        if (touch2 === 1) {
          if (item === this._head) {
            return;
          }
          const next = item.next;
          const previous = item.previous;
          if (item === this._tail) {
            previous.next = void 0;
            this._tail = previous;
          } else {
            next.previous = previous;
            previous.next = next;
          }
          item.previous = void 0;
          item.next = this._head;
          this._head.previous = item;
          this._head = item;
          this._state++;
        } else if (touch2 === 2) {
          if (item === this._tail) {
            return;
          }
          const next = item.next;
          const previous = item.previous;
          if (item === this._head) {
            next.previous = void 0;
            this._head = next;
          } else {
            next.previous = previous;
            previous.next = next;
          }
          item.next = void 0;
          item.previous = this._tail;
          this._tail.next = item;
          this._tail = item;
          this._state++;
        }
      }
      toJSON() {
        const data = [];
        this.forEach((value, key) => {
          data.push([key, value]);
        });
        return data;
      }
      fromJSON(data) {
        this.clear();
        for (const [key, value] of data) {
          this.set(key, value);
        }
      }
    };
    Cache = class extends LinkedMap {
      constructor(limit, ratio = 1) {
        super();
        this._limit = limit;
        this._ratio = Math.min(Math.max(0, ratio), 1);
      }
      get limit() {
        return this._limit;
      }
      set limit(limit) {
        this._limit = limit;
        this.checkTrim();
      }
      get ratio() {
        return this._ratio;
      }
      set ratio(ratio) {
        this._ratio = Math.min(Math.max(0, ratio), 1);
        this.checkTrim();
      }
      get(key, touch2 = 2) {
        return super.get(key, touch2);
      }
      peek(key) {
        return super.get(
          key,
          0
          /* Touch.None */
        );
      }
      set(key, value) {
        super.set(
          key,
          value,
          2
          /* Touch.AsNew */
        );
        return this;
      }
      checkTrim() {
        if (this.size > this._limit) {
          this.trim(Math.round(this._limit * this._ratio));
        }
      }
    };
    LRUCache = class extends Cache {
      constructor(limit, ratio = 1) {
        super(limit, ratio);
      }
      trim(newSize) {
        this.trimOld(newSize);
      }
      set(key, value) {
        super.set(key, value);
        this.checkTrim();
        return this;
      }
    };
    SetMap = class {
      constructor() {
        this.map = /* @__PURE__ */ new Map();
      }
      add(key, value) {
        let values = this.map.get(key);
        if (!values) {
          values = /* @__PURE__ */ new Set();
          this.map.set(key, values);
        }
        values.add(value);
      }
      delete(key, value) {
        const values = this.map.get(key);
        if (!values) {
          return;
        }
        values.delete(value);
        if (values.size === 0) {
          this.map.delete(key);
        }
      }
      forEach(key, fn) {
        const values = this.map.get(key);
        if (!values) {
          return;
        }
        values.forEach(fn);
      }
      get(key) {
        const values = this.map.get(key);
        if (!values) {
          return /* @__PURE__ */ new Set();
        }
        return values;
      }
    };
  }
});

// out-build/vs/base/common/assert.js
function ok(value, message) {
  if (!value) {
    throw new Error(message ? `Assertion failed (${message})` : "Assertion Failed");
  }
}
function assert(condition, messageOrError = "unexpected state") {
  if (!condition) {
    const errorToThrow = typeof messageOrError === "string" ? new BugIndicatingError(`Assertion Failed: ${messageOrError}`) : messageOrError;
    throw errorToThrow;
  }
}
var init_assert = __esm({
  "out-build/vs/base/common/assert.js"() {
    "use strict";
    init_errors();
  }
});

// out-build/vs/base/common/types.js
function isString(str) {
  return typeof str === "string";
}
function isObject(obj) {
  return typeof obj === "object" && obj !== null && !Array.isArray(obj) && !(obj instanceof RegExp) && !(obj instanceof Date);
}
function isTypedArray(obj) {
  const TypedArray = Object.getPrototypeOf(Uint8Array);
  return typeof obj === "object" && obj instanceof TypedArray;
}
function isNumber(obj) {
  return typeof obj === "number" && !isNaN(obj);
}
function isIterable(obj) {
  return !!obj && typeof obj[Symbol.iterator] === "function";
}
function isBoolean(obj) {
  return obj === true || obj === false;
}
function isUndefined(obj) {
  return typeof obj === "undefined";
}
function isUndefinedOrNull(obj) {
  return isUndefined(obj) || obj === null;
}
function assertType(condition, type3) {
  if (!condition) {
    throw new Error(type3 ? `Unexpected type, expected '${type3}'` : "Unexpected type");
  }
}
function assertIsDefined(arg) {
  assert(arg !== null && arg !== void 0, "Argument is `undefined` or `null`.");
  return arg;
}
function isEmptyObject(obj) {
  if (!isObject(obj)) {
    return false;
  }
  for (const key in obj) {
    if (hasOwnProperty.call(obj, key)) {
      return false;
    }
  }
  return true;
}
function isFunction(obj) {
  return typeof obj === "function";
}
function upcast(x) {
  return x;
}
var hasOwnProperty;
var init_types = __esm({
  "out-build/vs/base/common/types.js"() {
    "use strict";
    init_assert();
    hasOwnProperty = Object.prototype.hasOwnProperty;
  }
});

// out-build/vs/base/common/iterator.js
var Iterable;
var init_iterator = __esm({
  "out-build/vs/base/common/iterator.js"() {
    "use strict";
    init_types();
    (function(Iterable2) {
      function is(thing) {
        return !!thing && typeof thing === "object" && typeof thing[Symbol.iterator] === "function";
      }
      Iterable2.is = is;
      const _empty2 = Object.freeze([]);
      function empty() {
        return _empty2;
      }
      Iterable2.empty = empty;
      function* single(element) {
        yield element;
      }
      Iterable2.single = single;
      function wrap(iterableOrElement) {
        if (is(iterableOrElement)) {
          return iterableOrElement;
        } else {
          return single(iterableOrElement);
        }
      }
      Iterable2.wrap = wrap;
      function from(iterable) {
        return iterable || _empty2;
      }
      Iterable2.from = from;
      function* reverse(array) {
        for (let i = array.length - 1; i >= 0; i--) {
          yield array[i];
        }
      }
      Iterable2.reverse = reverse;
      function isEmpty(iterable) {
        return !iterable || iterable[Symbol.iterator]().next().done === true;
      }
      Iterable2.isEmpty = isEmpty;
      function first2(iterable) {
        return iterable[Symbol.iterator]().next().value;
      }
      Iterable2.first = first2;
      function some(iterable, predicate) {
        let i = 0;
        for (const element of iterable) {
          if (predicate(element, i++)) {
            return true;
          }
        }
        return false;
      }
      Iterable2.some = some;
      function every(iterable, predicate) {
        let i = 0;
        for (const element of iterable) {
          if (!predicate(element, i++)) {
            return false;
          }
        }
        return true;
      }
      Iterable2.every = every;
      function find(iterable, predicate) {
        for (const element of iterable) {
          if (predicate(element)) {
            return element;
          }
        }
        return void 0;
      }
      Iterable2.find = find;
      function* filter(iterable, predicate) {
        for (const element of iterable) {
          if (predicate(element)) {
            yield element;
          }
        }
      }
      Iterable2.filter = filter;
      function* map(iterable, fn) {
        let index = 0;
        for (const element of iterable) {
          yield fn(element, index++);
        }
      }
      Iterable2.map = map;
      function* flatMap(iterable, fn) {
        let index = 0;
        for (const element of iterable) {
          yield* fn(element, index++);
        }
      }
      Iterable2.flatMap = flatMap;
      function* concat(...iterables) {
        for (const item of iterables) {
          if (isIterable(item)) {
            yield* item;
          } else {
            yield item;
          }
        }
      }
      Iterable2.concat = concat;
      function reduce(iterable, reducer, initialValue) {
        let value = initialValue;
        for (const element of iterable) {
          value = reducer(value, element);
        }
        return value;
      }
      Iterable2.reduce = reduce;
      function length(iterable) {
        let count = 0;
        for (const _ of iterable) {
          count++;
        }
        return count;
      }
      Iterable2.length = length;
      function* slice(arr, from2, to = arr.length) {
        if (from2 < -arr.length) {
          from2 = 0;
        }
        if (from2 < 0) {
          from2 += arr.length;
        }
        if (to < 0) {
          to += arr.length;
        } else if (to > arr.length) {
          to = arr.length;
        }
        for (; from2 < to; from2++) {
          yield arr[from2];
        }
      }
      Iterable2.slice = slice;
      function consume(iterable, atMost = Number.POSITIVE_INFINITY) {
        const consumed = [];
        if (atMost === 0) {
          return [consumed, iterable];
        }
        const iterator = iterable[Symbol.iterator]();
        for (let i = 0; i < atMost; i++) {
          const next = iterator.next();
          if (next.done) {
            return [consumed, Iterable2.empty()];
          }
          consumed.push(next.value);
        }
        return [consumed, { [Symbol.iterator]() {
          return iterator;
        } }];
      }
      Iterable2.consume = consume;
      async function asyncToArray(iterable) {
        const result = [];
        for await (const item of iterable) {
          result.push(item);
        }
        return result;
      }
      Iterable2.asyncToArray = asyncToArray;
      async function asyncToArrayFlat(iterable) {
        let result = [];
        for await (const item of iterable) {
          result = result.concat(item);
        }
        return result;
      }
      Iterable2.asyncToArrayFlat = asyncToArrayFlat;
    })(Iterable || (Iterable = {}));
  }
});

// out-build/vs/base/common/lifecycle.js
function setDisposableTracker(tracker) {
  disposableTracker = tracker;
}
function trackDisposable(x) {
  disposableTracker?.trackDisposable(x);
  return x;
}
function markAsDisposed(disposable) {
  disposableTracker?.markAsDisposed(disposable);
}
function setParentOfDisposable(child, parent) {
  disposableTracker?.setParent(child, parent);
}
function setParentOfDisposables(children, parent) {
  if (!disposableTracker) {
    return;
  }
  for (const child of children) {
    disposableTracker.setParent(child, parent);
  }
}
function isDisposable(thing) {
  return typeof thing === "object" && thing !== null && typeof thing.dispose === "function" && thing.dispose.length === 0;
}
function dispose(arg) {
  if (Iterable.is(arg)) {
    const errors = [];
    for (const d of arg) {
      if (d) {
        try {
          d.dispose();
        } catch (e) {
          errors.push(e);
        }
      }
    }
    if (errors.length === 1) {
      throw errors[0];
    } else if (errors.length > 1) {
      throw new AggregateError(errors, "Encountered errors while disposing of store");
    }
    return Array.isArray(arg) ? [] : arg;
  } else if (arg) {
    arg.dispose();
    return arg;
  }
}
function combinedDisposable(...disposables) {
  const parent = toDisposable(() => dispose(disposables));
  setParentOfDisposables(disposables, parent);
  return parent;
}
function toDisposable(fn) {
  const self2 = trackDisposable({
    dispose: createSingleCallFunction(() => {
      markAsDisposed(self2);
      fn();
    })
  });
  return self2;
}
var TRACK_DISPOSABLES, disposableTracker, DisposableTracker, DisposableStore, Disposable, MutableDisposable, DisposableMap;
var init_lifecycle = __esm({
  "out-build/vs/base/common/lifecycle.js"() {
    "use strict";
    init_arrays();
    init_collections();
    init_map();
    init_functional();
    init_iterator();
    TRACK_DISPOSABLES = false;
    disposableTracker = null;
    DisposableTracker = class _DisposableTracker {
      constructor() {
        this.livingDisposables = /* @__PURE__ */ new Map();
      }
      static {
        this.idx = 0;
      }
      getDisposableData(d) {
        let val = this.livingDisposables.get(d);
        if (!val) {
          val = { parent: null, source: null, isSingleton: false, value: d, idx: _DisposableTracker.idx++ };
          this.livingDisposables.set(d, val);
        }
        return val;
      }
      trackDisposable(d) {
        const data = this.getDisposableData(d);
        if (!data.source) {
          data.source = new Error().stack;
        }
      }
      setParent(child, parent) {
        const data = this.getDisposableData(child);
        data.parent = parent;
      }
      markAsDisposed(x) {
        this.livingDisposables.delete(x);
      }
      markAsSingleton(disposable) {
        this.getDisposableData(disposable).isSingleton = true;
      }
      getRootParent(data, cache) {
        const cacheValue = cache.get(data);
        if (cacheValue) {
          return cacheValue;
        }
        const result = data.parent ? this.getRootParent(this.getDisposableData(data.parent), cache) : data;
        cache.set(data, result);
        return result;
      }
      getTrackedDisposables() {
        const rootParentCache = /* @__PURE__ */ new Map();
        const leaking = [...this.livingDisposables.entries()].filter(([, v]) => v.source !== null && !this.getRootParent(v, rootParentCache).isSingleton).flatMap(([k]) => k);
        return leaking;
      }
      computeLeakingDisposables(maxReported = 10, preComputedLeaks) {
        let uncoveredLeakingObjs;
        if (preComputedLeaks) {
          uncoveredLeakingObjs = preComputedLeaks;
        } else {
          const rootParentCache = /* @__PURE__ */ new Map();
          const leakingObjects = [...this.livingDisposables.values()].filter((info) => info.source !== null && !this.getRootParent(info, rootParentCache).isSingleton);
          if (leakingObjects.length === 0) {
            return;
          }
          const leakingObjsSet = new Set(leakingObjects.map((o) => o.value));
          uncoveredLeakingObjs = leakingObjects.filter((l) => {
            return !(l.parent && leakingObjsSet.has(l.parent));
          });
          if (uncoveredLeakingObjs.length === 0) {
            throw new Error("There are cyclic diposable chains!");
          }
        }
        if (!uncoveredLeakingObjs) {
          return void 0;
        }
        function getStackTracePath(leaking) {
          function removePrefix(array, linesToRemove) {
            while (array.length > 0 && linesToRemove.some((regexp2) => typeof regexp2 === "string" ? regexp2 === array[0] : array[0].match(regexp2))) {
              array.shift();
            }
          }
          const lines = leaking.source.split("\n").map((p) => p.trim().replace("at ", "")).filter((l) => l !== "");
          removePrefix(lines, ["Error", /^trackDisposable \(.*\)$/, /^DisposableTracker.trackDisposable \(.*\)$/]);
          return lines.reverse();
        }
        const stackTraceStarts = new SetMap();
        for (const leaking of uncoveredLeakingObjs) {
          const stackTracePath = getStackTracePath(leaking);
          for (let i2 = 0; i2 <= stackTracePath.length; i2++) {
            stackTraceStarts.add(stackTracePath.slice(0, i2).join("\n"), leaking);
          }
        }
        uncoveredLeakingObjs.sort(compareBy((l) => l.idx, numberComparator));
        let message = "";
        let i = 0;
        for (const leaking of uncoveredLeakingObjs.slice(0, maxReported)) {
          i++;
          const stackTracePath = getStackTracePath(leaking);
          const stackTraceFormattedLines = [];
          for (let i2 = 0; i2 < stackTracePath.length; i2++) {
            let line = stackTracePath[i2];
            const starts = stackTraceStarts.get(stackTracePath.slice(0, i2 + 1).join("\n"));
            line = `(shared with ${starts.size}/${uncoveredLeakingObjs.length} leaks) at ${line}`;
            const prevStarts = stackTraceStarts.get(stackTracePath.slice(0, i2).join("\n"));
            const continuations = groupBy([...prevStarts].map((d) => getStackTracePath(d)[i2]), (v) => v);
            delete continuations[stackTracePath[i2]];
            for (const [cont, set] of Object.entries(continuations)) {
              stackTraceFormattedLines.unshift(`    - stacktraces of ${set.length} other leaks continue with ${cont}`);
            }
            stackTraceFormattedLines.unshift(line);
          }
          message += `


==================== Leaking disposable ${i}/${uncoveredLeakingObjs.length}: ${leaking.value.constructor.name} ====================
${stackTraceFormattedLines.join("\n")}
============================================================

`;
        }
        if (uncoveredLeakingObjs.length > maxReported) {
          message += `


... and ${uncoveredLeakingObjs.length - maxReported} more leaking disposables

`;
        }
        return { leaks: uncoveredLeakingObjs, details: message };
      }
    };
    if (TRACK_DISPOSABLES) {
      const __is_disposable_tracked__ = "__is_disposable_tracked__";
      setDisposableTracker(new class {
        trackDisposable(x) {
          const stack = new Error("Potentially leaked disposable").stack;
          setTimeout(() => {
            if (!x[__is_disposable_tracked__]) {
              console.log(stack);
            }
          }, 3e3);
        }
        setParent(child, parent) {
          if (child && child !== Disposable.None) {
            try {
              child[__is_disposable_tracked__] = true;
            } catch {
            }
          }
        }
        markAsDisposed(disposable) {
          if (disposable && disposable !== Disposable.None) {
            try {
              disposable[__is_disposable_tracked__] = true;
            } catch {
            }
          }
        }
        markAsSingleton(disposable) {
        }
      }());
    }
    DisposableStore = class _DisposableStore {
      static {
        this.DISABLE_DISPOSED_WARNING = false;
      }
      constructor() {
        this._toDispose = /* @__PURE__ */ new Set();
        this._isDisposed = false;
        trackDisposable(this);
      }
      /**
       * Dispose of all registered disposables and mark this object as disposed.
       *
       * Any future disposables added to this object will be disposed of on `add`.
       */
      dispose() {
        if (this._isDisposed) {
          return;
        }
        markAsDisposed(this);
        this._isDisposed = true;
        this.clear();
      }
      /**
       * @return `true` if this object has been disposed of.
       */
      get isDisposed() {
        return this._isDisposed;
      }
      /**
       * Dispose of all registered disposables but do not mark this object as disposed.
       */
      clear() {
        if (this._toDispose.size === 0) {
          return;
        }
        try {
          dispose(this._toDispose);
        } finally {
          this._toDispose.clear();
        }
      }
      /**
       * Add a new {@link IDisposable disposable} to the collection.
       */
      add(o) {
        if (!o) {
          return o;
        }
        if (o === this) {
          throw new Error("Cannot register a disposable on itself!");
        }
        setParentOfDisposable(o, this);
        if (this._isDisposed) {
          if (!_DisposableStore.DISABLE_DISPOSED_WARNING) {
            console.warn(new Error("Trying to add a disposable to a DisposableStore that has already been disposed of. The added object will be leaked!").stack);
          }
        } else {
          this._toDispose.add(o);
        }
        return o;
      }
      /**
       * Deletes a disposable from store and disposes of it. This will not throw or warn and proceed to dispose the
       * disposable even when the disposable is not part in the store.
       */
      delete(o) {
        if (!o) {
          return;
        }
        if (o === this) {
          throw new Error("Cannot dispose a disposable on itself!");
        }
        this._toDispose.delete(o);
        o.dispose();
      }
      /**
       * Deletes the value from the store, but does not dispose it.
       */
      deleteAndLeak(o) {
        if (!o) {
          return;
        }
        if (this._toDispose.has(o)) {
          this._toDispose.delete(o);
          setParentOfDisposable(o, null);
        }
      }
    };
    Disposable = class {
      static {
        this.None = Object.freeze({ dispose() {
        } });
      }
      constructor() {
        this._store = new DisposableStore();
        trackDisposable(this);
        setParentOfDisposable(this._store, this);
      }
      dispose() {
        markAsDisposed(this);
        this._store.dispose();
      }
      /**
       * Adds `o` to the collection of disposables managed by this object.
       */
      _register(o) {
        if (o === this) {
          throw new Error("Cannot register a disposable on itself!");
        }
        return this._store.add(o);
      }
    };
    MutableDisposable = class {
      constructor() {
        this._isDisposed = false;
        trackDisposable(this);
      }
      get value() {
        return this._isDisposed ? void 0 : this._value;
      }
      set value(value) {
        if (this._isDisposed || value === this._value) {
          return;
        }
        this._value?.dispose();
        if (value) {
          setParentOfDisposable(value, this);
        }
        this._value = value;
      }
      /**
       * Resets the stored value and disposed of the previously stored value.
       */
      clear() {
        this.value = void 0;
      }
      dispose() {
        this._isDisposed = true;
        markAsDisposed(this);
        this._value?.dispose();
        this._value = void 0;
      }
      /**
       * Clears the value, but does not dispose it.
       * The old value is returned.
      */
      clearAndLeak() {
        const oldValue = this._value;
        this._value = void 0;
        if (oldValue) {
          setParentOfDisposable(oldValue, null);
        }
        return oldValue;
      }
    };
    DisposableMap = class {
      constructor() {
        this._store = /* @__PURE__ */ new Map();
        this._isDisposed = false;
        trackDisposable(this);
      }
      /**
       * Disposes of all stored values and mark this object as disposed.
       *
       * Trying to use this object after it has been disposed of is an error.
       */
      dispose() {
        markAsDisposed(this);
        this._isDisposed = true;
        this.clearAndDisposeAll();
      }
      /**
       * Disposes of all stored values and clear the map, but DO NOT mark this object as disposed.
       */
      clearAndDisposeAll() {
        if (!this._store.size) {
          return;
        }
        try {
          dispose(this._store.values());
        } finally {
          this._store.clear();
        }
      }
      has(key) {
        return this._store.has(key);
      }
      get size() {
        return this._store.size;
      }
      get(key) {
        return this._store.get(key);
      }
      set(key, value, skipDisposeOnOverwrite = false) {
        if (this._isDisposed) {
          console.warn(new Error("Trying to add a disposable to a DisposableMap that has already been disposed of. The added object will be leaked!").stack);
        }
        if (!skipDisposeOnOverwrite) {
          this._store.get(key)?.dispose();
        }
        this._store.set(key, value);
      }
      /**
       * Delete the value stored for `key` from this map and also dispose of it.
       */
      deleteAndDispose(key) {
        this._store.get(key)?.dispose();
        this._store.delete(key);
      }
      /**
       * Delete the value stored for `key` from this map but return it. The caller is
       * responsible for disposing of the value.
       */
      deleteAndLeak(key) {
        const value = this._store.get(key);
        this._store.delete(key);
        return value;
      }
      keys() {
        return this._store.keys();
      }
      values() {
        return this._store.values();
      }
      [Symbol.iterator]() {
        return this._store[Symbol.iterator]();
      }
    };
  }
});

// out-build/vs/base/common/linkedList.js
var Node, LinkedList;
var init_linkedList = __esm({
  "out-build/vs/base/common/linkedList.js"() {
    "use strict";
    Node = class _Node {
      static {
        this.Undefined = new _Node(void 0);
      }
      constructor(element) {
        this.element = element;
        this.next = _Node.Undefined;
        this.prev = _Node.Undefined;
      }
    };
    LinkedList = class {
      constructor() {
        this._first = Node.Undefined;
        this._last = Node.Undefined;
        this._size = 0;
      }
      get size() {
        return this._size;
      }
      isEmpty() {
        return this._first === Node.Undefined;
      }
      clear() {
        let node = this._first;
        while (node !== Node.Undefined) {
          const next = node.next;
          node.prev = Node.Undefined;
          node.next = Node.Undefined;
          node = next;
        }
        this._first = Node.Undefined;
        this._last = Node.Undefined;
        this._size = 0;
      }
      unshift(element) {
        return this._insert(element, false);
      }
      push(element) {
        return this._insert(element, true);
      }
      _insert(element, atTheEnd) {
        const newNode = new Node(element);
        if (this._first === Node.Undefined) {
          this._first = newNode;
          this._last = newNode;
        } else if (atTheEnd) {
          const oldLast = this._last;
          this._last = newNode;
          newNode.prev = oldLast;
          oldLast.next = newNode;
        } else {
          const oldFirst = this._first;
          this._first = newNode;
          newNode.next = oldFirst;
          oldFirst.prev = newNode;
        }
        this._size += 1;
        let didRemove = false;
        return () => {
          if (!didRemove) {
            didRemove = true;
            this._remove(newNode);
          }
        };
      }
      shift() {
        if (this._first === Node.Undefined) {
          return void 0;
        } else {
          const res = this._first.element;
          this._remove(this._first);
          return res;
        }
      }
      pop() {
        if (this._last === Node.Undefined) {
          return void 0;
        } else {
          const res = this._last.element;
          this._remove(this._last);
          return res;
        }
      }
      _remove(node) {
        if (node.prev !== Node.Undefined && node.next !== Node.Undefined) {
          const anchor = node.prev;
          anchor.next = node.next;
          node.next.prev = anchor;
        } else if (node.prev === Node.Undefined && node.next === Node.Undefined) {
          this._first = Node.Undefined;
          this._last = Node.Undefined;
        } else if (node.next === Node.Undefined) {
          this._last = this._last.prev;
          this._last.next = Node.Undefined;
        } else if (node.prev === Node.Undefined) {
          this._first = this._first.next;
          this._first.prev = Node.Undefined;
        }
        this._size -= 1;
      }
      *[Symbol.iterator]() {
        let node = this._first;
        while (node !== Node.Undefined) {
          yield node.element;
          node = node.next;
        }
      }
    };
  }
});

// out-build/vs/base/common/stopwatch.js
var performanceNow, StopWatch;
var init_stopwatch = __esm({
  "out-build/vs/base/common/stopwatch.js"() {
    "use strict";
    performanceNow = globalThis.performance.now.bind(globalThis.performance);
    StopWatch = class _StopWatch {
      static create(highResolution) {
        return new _StopWatch(highResolution);
      }
      constructor(highResolution) {
        this._now = highResolution === false ? Date.now : performanceNow;
        this._startTime = this._now();
        this._stopTime = -1;
      }
      stop() {
        this._stopTime = this._now();
      }
      reset() {
        this._startTime = this._now();
        this._stopTime = -1;
      }
      elapsed() {
        if (this._stopTime !== -1) {
          return this._stopTime - this._startTime;
        }
        return this._now() - this._startTime;
      }
    };
  }
});

// out-build/vs/base/common/event.js
var _enableDisposeWithListenerWarning, _enableSnapshotPotentialLeakWarning, Event, EventProfiling, _globalLeakWarningThreshold, LeakageMonitor, Stacktrace, ListenerLeakError, ListenerRefusalError, id, UniqueContainer, compactionThreshold, forEachListener, Emitter, EventDeliveryQueuePrivate, PauseableEmitter, EventMultiplexer, Relay;
var init_event = __esm({
  "out-build/vs/base/common/event.js"() {
    "use strict";
    init_collections();
    init_errors();
    init_functional();
    init_lifecycle();
    init_linkedList();
    init_stopwatch();
    _enableDisposeWithListenerWarning = false;
    _enableSnapshotPotentialLeakWarning = false;
    (function(Event2) {
      Event2.None = () => Disposable.None;
      function _addLeakageTraceLogic(options) {
        if (_enableSnapshotPotentialLeakWarning) {
          const { onDidAddListener: origListenerDidAdd } = options;
          const stack = Stacktrace.create();
          let count = 0;
          options.onDidAddListener = () => {
            if (++count === 2) {
              console.warn("snapshotted emitter LIKELY used public and SHOULD HAVE BEEN created with DisposableStore. snapshotted here");
              stack.print();
            }
            origListenerDidAdd?.();
          };
        }
      }
      function defer(event, disposable) {
        return debounce(event, () => void 0, 0, void 0, true, void 0, disposable);
      }
      Event2.defer = defer;
      function once(event) {
        return (listener, thisArgs = null, disposables) => {
          let didFire = false;
          let result = void 0;
          result = event((e) => {
            if (didFire) {
              return;
            } else if (result) {
              result.dispose();
            } else {
              didFire = true;
            }
            return listener.call(thisArgs, e);
          }, null, disposables);
          if (didFire) {
            result.dispose();
          }
          return result;
        };
      }
      Event2.once = once;
      function onceIf(event, condition) {
        return Event2.once(Event2.filter(event, condition));
      }
      Event2.onceIf = onceIf;
      function map(event, map2, disposable) {
        return snapshot((listener, thisArgs = null, disposables) => event((i) => listener.call(thisArgs, map2(i)), null, disposables), disposable);
      }
      Event2.map = map;
      function forEach(event, each, disposable) {
        return snapshot((listener, thisArgs = null, disposables) => event((i) => {
          each(i);
          listener.call(thisArgs, i);
        }, null, disposables), disposable);
      }
      Event2.forEach = forEach;
      function filter(event, filter2, disposable) {
        return snapshot((listener, thisArgs = null, disposables) => event((e) => filter2(e) && listener.call(thisArgs, e), null, disposables), disposable);
      }
      Event2.filter = filter;
      function signal(event) {
        return event;
      }
      Event2.signal = signal;
      function any(...events) {
        return (listener, thisArgs = null, disposables) => {
          const disposable = combinedDisposable(...events.map((event) => event((e) => listener.call(thisArgs, e))));
          return addAndReturnDisposable(disposable, disposables);
        };
      }
      Event2.any = any;
      function reduce(event, merge, initial, disposable) {
        let output = initial;
        return map(event, (e) => {
          output = merge(output, e);
          return output;
        }, disposable);
      }
      Event2.reduce = reduce;
      function snapshot(event, disposable) {
        let listener;
        const options = {
          onWillAddFirstListener() {
            listener = event(emitter.fire, emitter);
          },
          onDidRemoveLastListener() {
            listener?.dispose();
          }
        };
        if (!disposable) {
          _addLeakageTraceLogic(options);
        }
        const emitter = new Emitter(options);
        disposable?.add(emitter);
        return emitter.event;
      }
      function addAndReturnDisposable(d, store) {
        if (store instanceof Array) {
          store.push(d);
        } else if (store) {
          store.add(d);
        }
        return d;
      }
      function debounce(event, merge, delay = 100, leading = false, flushOnListenerRemove = false, leakWarningThreshold, disposable) {
        let subscription;
        let output = void 0;
        let handle = void 0;
        let numDebouncedCalls = 0;
        let doFire;
        const options = {
          leakWarningThreshold,
          onWillAddFirstListener() {
            subscription = event((cur) => {
              numDebouncedCalls++;
              output = merge(output, cur);
              if (leading && !handle) {
                emitter.fire(output);
                output = void 0;
              }
              doFire = () => {
                const _output = output;
                output = void 0;
                handle = void 0;
                if (!leading || numDebouncedCalls > 1) {
                  emitter.fire(_output);
                }
                numDebouncedCalls = 0;
              };
              if (typeof delay === "number") {
                if (handle) {
                  clearTimeout(handle);
                }
                handle = setTimeout(doFire, delay);
              } else {
                if (handle === void 0) {
                  handle = null;
                  queueMicrotask(doFire);
                }
              }
            });
          },
          onWillRemoveListener() {
            if (flushOnListenerRemove && numDebouncedCalls > 0) {
              doFire?.();
            }
          },
          onDidRemoveLastListener() {
            doFire = void 0;
            subscription.dispose();
          }
        };
        if (!disposable) {
          _addLeakageTraceLogic(options);
        }
        const emitter = new Emitter(options);
        disposable?.add(emitter);
        return emitter.event;
      }
      Event2.debounce = debounce;
      function accumulate(event, delay = 0, disposable) {
        return Event2.debounce(event, (last, e) => {
          if (!last) {
            return [e];
          }
          last.push(e);
          return last;
        }, delay, void 0, true, void 0, disposable);
      }
      Event2.accumulate = accumulate;
      function latch(event, equals3 = (a, b) => a === b, disposable) {
        let firstCall = true;
        let cache;
        return filter(event, (value) => {
          const shouldEmit = firstCall || !equals3(value, cache);
          firstCall = false;
          cache = value;
          return shouldEmit;
        }, disposable);
      }
      Event2.latch = latch;
      function split(event, isT, disposable) {
        return [
          Event2.filter(event, isT, disposable),
          Event2.filter(event, (e) => !isT(e), disposable)
        ];
      }
      Event2.split = split;
      function buffer(event, flushAfterTimeout = false, _buffer = [], disposable) {
        let buffer2 = _buffer.slice();
        let listener = event((e) => {
          if (buffer2) {
            buffer2.push(e);
          } else {
            emitter.fire(e);
          }
        });
        if (disposable) {
          disposable.add(listener);
        }
        const flush = () => {
          buffer2?.forEach((e) => emitter.fire(e));
          buffer2 = null;
        };
        const emitter = new Emitter({
          onWillAddFirstListener() {
            if (!listener) {
              listener = event((e) => emitter.fire(e));
              if (disposable) {
                disposable.add(listener);
              }
            }
          },
          onDidAddFirstListener() {
            if (buffer2) {
              if (flushAfterTimeout) {
                setTimeout(flush);
              } else {
                flush();
              }
            }
          },
          onDidRemoveLastListener() {
            if (listener) {
              listener.dispose();
            }
            listener = null;
          }
        });
        if (disposable) {
          disposable.add(emitter);
        }
        return emitter.event;
      }
      Event2.buffer = buffer;
      function chain(event, sythensize) {
        const fn = (listener, thisArgs, disposables) => {
          const cs = sythensize(new ChainableSynthesis());
          return event(function(value) {
            const result = cs.evaluate(value);
            if (result !== HaltChainable) {
              listener.call(thisArgs, result);
            }
          }, void 0, disposables);
        };
        return fn;
      }
      Event2.chain = chain;
      const HaltChainable = Symbol("HaltChainable");
      class ChainableSynthesis {
        constructor() {
          this.steps = [];
        }
        map(fn) {
          this.steps.push(fn);
          return this;
        }
        forEach(fn) {
          this.steps.push((v) => {
            fn(v);
            return v;
          });
          return this;
        }
        filter(fn) {
          this.steps.push((v) => fn(v) ? v : HaltChainable);
          return this;
        }
        reduce(merge, initial) {
          let last = initial;
          this.steps.push((v) => {
            last = merge(last, v);
            return last;
          });
          return this;
        }
        latch(equals3 = (a, b) => a === b) {
          let firstCall = true;
          let cache;
          this.steps.push((value) => {
            const shouldEmit = firstCall || !equals3(value, cache);
            firstCall = false;
            cache = value;
            return shouldEmit ? value : HaltChainable;
          });
          return this;
        }
        evaluate(value) {
          for (const step of this.steps) {
            value = step(value);
            if (value === HaltChainable) {
              break;
            }
          }
          return value;
        }
      }
      function fromNodeEventEmitter(emitter, eventName, map2 = (id2) => id2) {
        const fn = (...args2) => result.fire(map2(...args2));
        const onFirstListenerAdd = () => emitter.on(eventName, fn);
        const onLastListenerRemove = () => emitter.removeListener(eventName, fn);
        const result = new Emitter({ onWillAddFirstListener: onFirstListenerAdd, onDidRemoveLastListener: onLastListenerRemove });
        return result.event;
      }
      Event2.fromNodeEventEmitter = fromNodeEventEmitter;
      function fromDOMEventEmitter(emitter, eventName, map2 = (id2) => id2) {
        const fn = (...args2) => result.fire(map2(...args2));
        const onFirstListenerAdd = () => emitter.addEventListener(eventName, fn);
        const onLastListenerRemove = () => emitter.removeEventListener(eventName, fn);
        const result = new Emitter({ onWillAddFirstListener: onFirstListenerAdd, onDidRemoveLastListener: onLastListenerRemove });
        return result.event;
      }
      Event2.fromDOMEventEmitter = fromDOMEventEmitter;
      function toPromise(event, disposables) {
        let cancelRef;
        const promise = new Promise((resolve3, reject) => {
          const listener = once(event)(resolve3, null, disposables);
          cancelRef = () => listener.dispose();
        });
        promise.cancel = cancelRef;
        return promise;
      }
      Event2.toPromise = toPromise;
      function fromPromise(promise) {
        const result = new Emitter();
        promise.then((res) => {
          result.fire(res);
        }, () => {
          result.fire(void 0);
        }).finally(() => {
          result.dispose();
        });
        return result.event;
      }
      Event2.fromPromise = fromPromise;
      function forward(from, to) {
        return from((e) => to.fire(e));
      }
      Event2.forward = forward;
      function runAndSubscribe(event, handler, initial) {
        handler(initial);
        return event((e) => handler(e));
      }
      Event2.runAndSubscribe = runAndSubscribe;
      class EmitterObserver {
        constructor(_observable, store) {
          this._observable = _observable;
          this._counter = 0;
          this._hasChanged = false;
          const options = {
            onWillAddFirstListener: () => {
              _observable.addObserver(this);
              this._observable.reportChanges();
            },
            onDidRemoveLastListener: () => {
              _observable.removeObserver(this);
            }
          };
          if (!store) {
            _addLeakageTraceLogic(options);
          }
          this.emitter = new Emitter(options);
          if (store) {
            store.add(this.emitter);
          }
        }
        beginUpdate(_observable) {
          this._counter++;
        }
        handlePossibleChange(_observable) {
        }
        handleChange(_observable, _change) {
          this._hasChanged = true;
        }
        endUpdate(_observable) {
          this._counter--;
          if (this._counter === 0) {
            this._observable.reportChanges();
            if (this._hasChanged) {
              this._hasChanged = false;
              this.emitter.fire(this._observable.get());
            }
          }
        }
      }
      function fromObservable(obs, store) {
        const observer = new EmitterObserver(obs, store);
        return observer.emitter.event;
      }
      Event2.fromObservable = fromObservable;
      function fromObservableLight(observable) {
        return (listener, thisArgs, disposables) => {
          let count = 0;
          let didChange = false;
          const observer = {
            beginUpdate() {
              count++;
            },
            endUpdate() {
              count--;
              if (count === 0) {
                observable.reportChanges();
                if (didChange) {
                  didChange = false;
                  listener.call(thisArgs);
                }
              }
            },
            handlePossibleChange() {
            },
            handleChange() {
              didChange = true;
            }
          };
          observable.addObserver(observer);
          observable.reportChanges();
          const disposable = {
            dispose() {
              observable.removeObserver(observer);
            }
          };
          if (disposables instanceof DisposableStore) {
            disposables.add(disposable);
          } else if (Array.isArray(disposables)) {
            disposables.push(disposable);
          }
          return disposable;
        };
      }
      Event2.fromObservableLight = fromObservableLight;
    })(Event || (Event = {}));
    EventProfiling = class _EventProfiling {
      static {
        this.all = /* @__PURE__ */ new Set();
      }
      static {
        this._idPool = 0;
      }
      constructor(name) {
        this.listenerCount = 0;
        this.invocationCount = 0;
        this.elapsedOverall = 0;
        this.durations = [];
        this.name = `${name}_${_EventProfiling._idPool++}`;
        _EventProfiling.all.add(this);
      }
      start(listenerCount) {
        this._stopWatch = new StopWatch();
        this.listenerCount = listenerCount;
      }
      stop() {
        if (this._stopWatch) {
          const elapsed = this._stopWatch.elapsed();
          this.durations.push(elapsed);
          this.elapsedOverall += elapsed;
          this.invocationCount += 1;
          this._stopWatch = void 0;
        }
      }
    };
    _globalLeakWarningThreshold = -1;
    LeakageMonitor = class _LeakageMonitor {
      static {
        this._idPool = 1;
      }
      constructor(_errorHandler, threshold, name = (_LeakageMonitor._idPool++).toString(16).padStart(3, "0")) {
        this._errorHandler = _errorHandler;
        this.threshold = threshold;
        this.name = name;
        this._warnCountdown = 0;
      }
      dispose() {
        this._stacks?.clear();
      }
      check(stack, listenerCount) {
        const threshold = this.threshold;
        if (threshold <= 0 || listenerCount < threshold) {
          return void 0;
        }
        if (!this._stacks) {
          this._stacks = /* @__PURE__ */ new Map();
        }
        const count = this._stacks.get(stack.value) || 0;
        this._stacks.set(stack.value, count + 1);
        this._warnCountdown -= 1;
        if (this._warnCountdown <= 0) {
          this._warnCountdown = threshold * 0.5;
          const [topStack, topCount] = this.getMostFrequentStack();
          const message = `[${this.name}] potential listener LEAK detected, having ${listenerCount} listeners already. MOST frequent listener (${topCount}):`;
          console.warn(message);
          console.warn(topStack);
          const error = new ListenerLeakError(message, topStack);
          this._errorHandler(error);
        }
        return () => {
          const count2 = this._stacks.get(stack.value) || 0;
          this._stacks.set(stack.value, count2 - 1);
        };
      }
      getMostFrequentStack() {
        if (!this._stacks) {
          return void 0;
        }
        let topStack;
        let topCount = 0;
        for (const [stack, count] of this._stacks) {
          if (!topStack || topCount < count) {
            topStack = [stack, count];
            topCount = count;
          }
        }
        return topStack;
      }
    };
    Stacktrace = class _Stacktrace {
      static create() {
        const err = new Error();
        return new _Stacktrace(err.stack ?? "");
      }
      constructor(value) {
        this.value = value;
      }
      print() {
        console.warn(this.value.split("\n").slice(2).join("\n"));
      }
    };
    ListenerLeakError = class extends Error {
      constructor(message, stack) {
        super(message);
        this.name = "ListenerLeakError";
        this.stack = stack;
      }
    };
    ListenerRefusalError = class extends Error {
      constructor(message, stack) {
        super(message);
        this.name = "ListenerRefusalError";
        this.stack = stack;
      }
    };
    id = 0;
    UniqueContainer = class {
      constructor(value) {
        this.value = value;
        this.id = id++;
      }
    };
    compactionThreshold = 2;
    forEachListener = (listeners, fn) => {
      if (listeners instanceof UniqueContainer) {
        fn(listeners);
      } else {
        for (let i = 0; i < listeners.length; i++) {
          const l = listeners[i];
          if (l) {
            fn(l);
          }
        }
      }
    };
    Emitter = class {
      constructor(options) {
        this._size = 0;
        this._options = options;
        this._leakageMon = _globalLeakWarningThreshold > 0 || this._options?.leakWarningThreshold ? new LeakageMonitor(options?.onListenerError ?? onUnexpectedError, this._options?.leakWarningThreshold ?? _globalLeakWarningThreshold) : void 0;
        this._perfMon = this._options?._profName ? new EventProfiling(this._options._profName) : void 0;
        this._deliveryQueue = this._options?.deliveryQueue;
      }
      dispose() {
        if (!this._disposed) {
          this._disposed = true;
          if (this._deliveryQueue?.current === this) {
            this._deliveryQueue.reset();
          }
          if (this._listeners) {
            if (_enableDisposeWithListenerWarning) {
              const listeners = this._listeners;
              queueMicrotask(() => {
                forEachListener(listeners, (l) => l.stack?.print());
              });
            }
            this._listeners = void 0;
            this._size = 0;
          }
          this._options?.onDidRemoveLastListener?.();
          this._leakageMon?.dispose();
        }
      }
      /**
       * For the public to allow to subscribe
       * to events from this Emitter
       */
      get event() {
        this._event ??= (callback, thisArgs, disposables) => {
          if (this._leakageMon && this._size > this._leakageMon.threshold ** 2) {
            const message = `[${this._leakageMon.name}] REFUSES to accept new listeners because it exceeded its threshold by far (${this._size} vs ${this._leakageMon.threshold})`;
            console.warn(message);
            const tuple = this._leakageMon.getMostFrequentStack() ?? ["UNKNOWN stack", -1];
            const error = new ListenerRefusalError(`${message}. HINT: Stack shows most frequent listener (${tuple[1]}-times)`, tuple[0]);
            const errorHandler2 = this._options?.onListenerError || onUnexpectedError;
            errorHandler2(error);
            return Disposable.None;
          }
          if (this._disposed) {
            return Disposable.None;
          }
          if (thisArgs) {
            callback = callback.bind(thisArgs);
          }
          const contained = new UniqueContainer(callback);
          let removeMonitor;
          let stack;
          if (this._leakageMon && this._size >= Math.ceil(this._leakageMon.threshold * 0.2)) {
            contained.stack = Stacktrace.create();
            removeMonitor = this._leakageMon.check(contained.stack, this._size + 1);
          }
          if (_enableDisposeWithListenerWarning) {
            contained.stack = stack ?? Stacktrace.create();
          }
          if (!this._listeners) {
            this._options?.onWillAddFirstListener?.(this);
            this._listeners = contained;
            this._options?.onDidAddFirstListener?.(this);
          } else if (this._listeners instanceof UniqueContainer) {
            this._deliveryQueue ??= new EventDeliveryQueuePrivate();
            this._listeners = [this._listeners, contained];
          } else {
            this._listeners.push(contained);
          }
          this._options?.onDidAddListener?.(this);
          this._size++;
          const result = toDisposable(() => {
            removeMonitor?.();
            this._removeListener(contained);
          });
          if (disposables instanceof DisposableStore) {
            disposables.add(result);
          } else if (Array.isArray(disposables)) {
            disposables.push(result);
          }
          return result;
        };
        return this._event;
      }
      _removeListener(listener) {
        this._options?.onWillRemoveListener?.(this);
        if (!this._listeners) {
          return;
        }
        if (this._size === 1) {
          this._listeners = void 0;
          this._options?.onDidRemoveLastListener?.(this);
          this._size = 0;
          return;
        }
        const listeners = this._listeners;
        const index = listeners.indexOf(listener);
        if (index === -1) {
          console.log("disposed?", this._disposed);
          console.log("size?", this._size);
          console.log("arr?", JSON.stringify(this._listeners));
          throw new Error("Attempted to dispose unknown listener");
        }
        this._size--;
        listeners[index] = void 0;
        const adjustDeliveryQueue = this._deliveryQueue.current === this;
        if (this._size * compactionThreshold <= listeners.length) {
          let n = 0;
          for (let i = 0; i < listeners.length; i++) {
            if (listeners[i]) {
              listeners[n++] = listeners[i];
            } else if (adjustDeliveryQueue && n < this._deliveryQueue.end) {
              this._deliveryQueue.end--;
              if (n < this._deliveryQueue.i) {
                this._deliveryQueue.i--;
              }
            }
          }
          listeners.length = n;
        }
      }
      _deliver(listener, value) {
        if (!listener) {
          return;
        }
        const errorHandler2 = this._options?.onListenerError || onUnexpectedError;
        if (!errorHandler2) {
          listener.value(value);
          return;
        }
        try {
          listener.value(value);
        } catch (e) {
          errorHandler2(e);
        }
      }
      /** Delivers items in the queue. Assumes the queue is ready to go. */
      _deliverQueue(dq) {
        const listeners = dq.current._listeners;
        while (dq.i < dq.end) {
          this._deliver(listeners[dq.i++], dq.value);
        }
        dq.reset();
      }
      /**
       * To be kept private to fire an event to
       * subscribers
       */
      fire(event) {
        if (this._deliveryQueue?.current) {
          this._deliverQueue(this._deliveryQueue);
          this._perfMon?.stop();
        }
        this._perfMon?.start(this._size);
        if (!this._listeners) {
        } else if (this._listeners instanceof UniqueContainer) {
          this._deliver(this._listeners, event);
        } else {
          const dq = this._deliveryQueue;
          dq.enqueue(this, event, this._listeners.length);
          this._deliverQueue(dq);
        }
        this._perfMon?.stop();
      }
      hasListeners() {
        return this._size > 0;
      }
    };
    EventDeliveryQueuePrivate = class {
      constructor() {
        this.i = -1;
        this.end = 0;
      }
      enqueue(emitter, value, end) {
        this.i = 0;
        this.end = end;
        this.current = emitter;
        this.value = value;
      }
      reset() {
        this.i = this.end;
        this.current = void 0;
        this.value = void 0;
      }
    };
    PauseableEmitter = class extends Emitter {
      get isPaused() {
        return this._isPaused !== 0;
      }
      constructor(options) {
        super(options);
        this._isPaused = 0;
        this._eventQueue = new LinkedList();
        this._mergeFn = options?.merge;
      }
      pause() {
        this._isPaused++;
      }
      resume() {
        if (this._isPaused !== 0 && --this._isPaused === 0) {
          if (this._mergeFn) {
            if (this._eventQueue.size > 0) {
              const events = Array.from(this._eventQueue);
              this._eventQueue.clear();
              super.fire(this._mergeFn(events));
            }
          } else {
            while (!this._isPaused && this._eventQueue.size !== 0) {
              super.fire(this._eventQueue.shift());
            }
          }
        }
      }
      fire(event) {
        if (this._size) {
          if (this._isPaused !== 0) {
            this._eventQueue.push(event);
          } else {
            super.fire(event);
          }
        }
      }
    };
    EventMultiplexer = class {
      constructor() {
        this.hasListeners = false;
        this.events = [];
        this.emitter = new Emitter({
          onWillAddFirstListener: () => this.onFirstListenerAdd(),
          onDidRemoveLastListener: () => this.onLastListenerRemove()
        });
      }
      get event() {
        return this.emitter.event;
      }
      add(event) {
        const e = { event, listener: null };
        this.events.push(e);
        if (this.hasListeners) {
          this.hook(e);
        }
        const dispose3 = () => {
          if (this.hasListeners) {
            this.unhook(e);
          }
          const idx = this.events.indexOf(e);
          this.events.splice(idx, 1);
        };
        return toDisposable(createSingleCallFunction(dispose3));
      }
      onFirstListenerAdd() {
        this.hasListeners = true;
        this.events.forEach((e) => this.hook(e));
      }
      onLastListenerRemove() {
        this.hasListeners = false;
        this.events.forEach((e) => this.unhook(e));
      }
      hook(e) {
        e.listener = e.event((r) => this.emitter.fire(r));
      }
      unhook(e) {
        e.listener?.dispose();
        e.listener = null;
      }
      dispose() {
        this.emitter.dispose();
        for (const e of this.events) {
          e.listener?.dispose();
        }
        this.events = [];
      }
    };
    Relay = class {
      constructor() {
        this.listening = false;
        this.inputEvent = Event.None;
        this.inputEventListener = Disposable.None;
        this.emitter = new Emitter({
          onDidAddFirstListener: () => {
            this.listening = true;
            this.inputEventListener = this.inputEvent(this.emitter.fire, this.emitter);
          },
          onDidRemoveLastListener: () => {
            this.listening = false;
            this.inputEventListener.dispose();
          }
        });
        this.event = this.emitter.event;
      }
      set input(event) {
        this.inputEvent = event;
        if (this.listening) {
          this.inputEventListener.dispose();
          this.inputEventListener = event(this.emitter.fire, this.emitter);
        }
      }
      dispose() {
        this.inputEventListener.dispose();
        this.emitter.dispose();
      }
    };
  }
});

// out-build/vs/base/common/cancellation.js
var shortcutEvent, CancellationToken, MutableToken, CancellationTokenSource;
var init_cancellation = __esm({
  "out-build/vs/base/common/cancellation.js"() {
    "use strict";
    init_event();
    shortcutEvent = Object.freeze(function(callback, context) {
      const handle = setTimeout(callback.bind(context), 0);
      return { dispose() {
        clearTimeout(handle);
      } };
    });
    (function(CancellationToken2) {
      function isCancellationToken(thing) {
        if (thing === CancellationToken2.None || thing === CancellationToken2.Cancelled) {
          return true;
        }
        if (thing instanceof MutableToken) {
          return true;
        }
        if (!thing || typeof thing !== "object") {
          return false;
        }
        return typeof thing.isCancellationRequested === "boolean" && typeof thing.onCancellationRequested === "function";
      }
      CancellationToken2.isCancellationToken = isCancellationToken;
      CancellationToken2.None = Object.freeze({
        isCancellationRequested: false,
        onCancellationRequested: Event.None
      });
      CancellationToken2.Cancelled = Object.freeze({
        isCancellationRequested: true,
        onCancellationRequested: shortcutEvent
      });
    })(CancellationToken || (CancellationToken = {}));
    MutableToken = class {
      constructor() {
        this._isCancelled = false;
        this._emitter = null;
      }
      cancel() {
        if (!this._isCancelled) {
          this._isCancelled = true;
          if (this._emitter) {
            this._emitter.fire(void 0);
            this.dispose();
          }
        }
      }
      get isCancellationRequested() {
        return this._isCancelled;
      }
      get onCancellationRequested() {
        if (this._isCancelled) {
          return shortcutEvent;
        }
        if (!this._emitter) {
          this._emitter = new Emitter();
        }
        return this._emitter.event;
      }
      dispose() {
        if (this._emitter) {
          this._emitter.dispose();
          this._emitter = null;
        }
      }
    };
    CancellationTokenSource = class {
      constructor(parent) {
        this._token = void 0;
        this._parentListener = void 0;
        this._parentListener = parent && parent.onCancellationRequested(this.cancel, this);
      }
      get token() {
        if (!this._token) {
          this._token = new MutableToken();
        }
        return this._token;
      }
      cancel() {
        if (!this._token) {
          this._token = CancellationToken.Cancelled;
        } else if (this._token instanceof MutableToken) {
          this._token.cancel();
        }
      }
      dispose(cancel = false) {
        if (cancel) {
          this.cancel();
        }
        this._parentListener?.dispose();
        if (!this._token) {
          this._token = CancellationToken.None;
        } else if (this._token instanceof MutableToken) {
          this._token.dispose();
        }
      }
    };
  }
});

// out-build/vs/base/common/cache.js
function identity(t) {
  return t;
}
var LRUCachedFunction;
var init_cache = __esm({
  "out-build/vs/base/common/cache.js"() {
    "use strict";
    init_cancellation();
    LRUCachedFunction = class {
      constructor(arg1, arg2) {
        this.lastCache = void 0;
        this.lastArgKey = void 0;
        if (typeof arg1 === "function") {
          this._fn = arg1;
          this._computeKey = identity;
        } else {
          this._fn = arg2;
          this._computeKey = arg1.getCacheKey;
        }
      }
      get(arg) {
        const key = this._computeKey(arg);
        if (this.lastArgKey !== key) {
          this.lastArgKey = key;
          this.lastCache = this._fn(arg);
        }
        return this.lastCache;
      }
    };
  }
});

// out-build/vs/base/common/lazy.js
var Lazy;
var init_lazy = __esm({
  "out-build/vs/base/common/lazy.js"() {
    "use strict";
    Lazy = class {
      constructor(executor) {
        this.executor = executor;
        this._didRun = false;
      }
      /**
       * True if the lazy value has been resolved.
       */
      get hasValue() {
        return this._didRun;
      }
      /**
       * Get the wrapped value.
       *
       * This will force evaluation of the lazy value if it has not been resolved yet. Lazy values are only
       * resolved once. `getValue` will re-throw exceptions that are hit while resolving the value
       */
      get value() {
        if (!this._didRun) {
          try {
            this._value = this.executor();
          } catch (err) {
            this._error = err;
          } finally {
            this._didRun = true;
          }
        }
        if (this._error) {
          throw this._error;
        }
        return this._value;
      }
      /**
       * Get the wrapped value without forcing evaluation.
       */
      get rawValue() {
        return this._value;
      }
    };
  }
});

// out-build/vs/base/common/strings.js
function isFalsyOrWhitespace(str) {
  if (!str || typeof str !== "string") {
    return true;
  }
  return str.trim().length === 0;
}
function escapeRegExpCharacters(value) {
  return value.replace(/[\\\{\}\*\+\?\|\^\$\.\[\]\(\)]/g, "\\$&");
}
function trim(haystack, needle = " ") {
  const trimmed = ltrim(haystack, needle);
  return rtrim(trimmed, needle);
}
function ltrim(haystack, needle) {
  if (!haystack || !needle) {
    return haystack;
  }
  const needleLen = needle.length;
  if (needleLen === 0 || haystack.length === 0) {
    return haystack;
  }
  let offset = 0;
  while (haystack.indexOf(needle, offset) === offset) {
    offset = offset + needleLen;
  }
  return haystack.substring(offset);
}
function rtrim(haystack, needle) {
  if (!haystack || !needle) {
    return haystack;
  }
  const needleLen = needle.length, haystackLen = haystack.length;
  if (needleLen === 0 || haystackLen === 0) {
    return haystack;
  }
  let offset = haystackLen, idx = -1;
  while (true) {
    idx = haystack.lastIndexOf(needle, offset - 1);
    if (idx === -1 || idx + needleLen !== offset) {
      break;
    }
    if (idx === 0) {
      return "";
    }
    offset = idx;
  }
  return haystack.substring(0, offset);
}
function compare(a, b) {
  if (a < b) {
    return -1;
  } else if (a > b) {
    return 1;
  } else {
    return 0;
  }
}
function compareSubstring(a, b, aStart = 0, aEnd = a.length, bStart = 0, bEnd = b.length) {
  for (; aStart < aEnd && bStart < bEnd; aStart++, bStart++) {
    const codeA = a.charCodeAt(aStart);
    const codeB = b.charCodeAt(bStart);
    if (codeA < codeB) {
      return -1;
    } else if (codeA > codeB) {
      return 1;
    }
  }
  const aLen = aEnd - aStart;
  const bLen = bEnd - bStart;
  if (aLen < bLen) {
    return -1;
  } else if (aLen > bLen) {
    return 1;
  }
  return 0;
}
function compareIgnoreCase(a, b) {
  return compareSubstringIgnoreCase(a, b, 0, a.length, 0, b.length);
}
function compareSubstringIgnoreCase(a, b, aStart = 0, aEnd = a.length, bStart = 0, bEnd = b.length) {
  for (; aStart < aEnd && bStart < bEnd; aStart++, bStart++) {
    let codeA = a.charCodeAt(aStart);
    let codeB = b.charCodeAt(bStart);
    if (codeA === codeB) {
      continue;
    }
    if (codeA >= 128 || codeB >= 128) {
      return compareSubstring(a.toLowerCase(), b.toLowerCase(), aStart, aEnd, bStart, bEnd);
    }
    if (isLowerAsciiLetter(codeA)) {
      codeA -= 32;
    }
    if (isLowerAsciiLetter(codeB)) {
      codeB -= 32;
    }
    const diff2 = codeA - codeB;
    if (diff2 === 0) {
      continue;
    }
    return diff2;
  }
  const aLen = aEnd - aStart;
  const bLen = bEnd - bStart;
  if (aLen < bLen) {
    return -1;
  } else if (aLen > bLen) {
    return 1;
  }
  return 0;
}
function isLowerAsciiLetter(code2) {
  return code2 >= 97 && code2 <= 122;
}
function isUpperAsciiLetter(code2) {
  return code2 >= 65 && code2 <= 90;
}
function equalsIgnoreCase(a, b) {
  return a.length === b.length && compareSubstringIgnoreCase(a, b) === 0;
}
function startsWithIgnoreCase(str, candidate) {
  const candidateLength = candidate.length;
  if (candidate.length > str.length) {
    return false;
  }
  return compareSubstringIgnoreCase(str, candidate, 0, candidateLength) === 0;
}
function isHighSurrogate(charCode) {
  return 55296 <= charCode && charCode <= 56319;
}
function isLowSurrogate(charCode) {
  return 56320 <= charCode && charCode <= 57343;
}
function computeCodePoint(highSurrogate, lowSurrogate) {
  return (highSurrogate - 55296 << 10) + (lowSurrogate - 56320) + 65536;
}
function getGraphemeBreakRawData() {
  return JSON.parse("[0,0,0,51229,51255,12,44061,44087,12,127462,127487,6,7083,7085,5,47645,47671,12,54813,54839,12,128678,128678,14,3270,3270,5,9919,9923,14,45853,45879,12,49437,49463,12,53021,53047,12,71216,71218,7,128398,128399,14,129360,129374,14,2519,2519,5,4448,4519,9,9742,9742,14,12336,12336,14,44957,44983,12,46749,46775,12,48541,48567,12,50333,50359,12,52125,52151,12,53917,53943,12,69888,69890,5,73018,73018,5,127990,127990,14,128558,128559,14,128759,128760,14,129653,129655,14,2027,2035,5,2891,2892,7,3761,3761,5,6683,6683,5,8293,8293,4,9825,9826,14,9999,9999,14,43452,43453,5,44509,44535,12,45405,45431,12,46301,46327,12,47197,47223,12,48093,48119,12,48989,49015,12,49885,49911,12,50781,50807,12,51677,51703,12,52573,52599,12,53469,53495,12,54365,54391,12,65279,65279,4,70471,70472,7,72145,72147,7,119173,119179,5,127799,127818,14,128240,128244,14,128512,128512,14,128652,128652,14,128721,128722,14,129292,129292,14,129445,129450,14,129734,129743,14,1476,1477,5,2366,2368,7,2750,2752,7,3076,3076,5,3415,3415,5,4141,4144,5,6109,6109,5,6964,6964,5,7394,7400,5,9197,9198,14,9770,9770,14,9877,9877,14,9968,9969,14,10084,10084,14,43052,43052,5,43713,43713,5,44285,44311,12,44733,44759,12,45181,45207,12,45629,45655,12,46077,46103,12,46525,46551,12,46973,46999,12,47421,47447,12,47869,47895,12,48317,48343,12,48765,48791,12,49213,49239,12,49661,49687,12,50109,50135,12,50557,50583,12,51005,51031,12,51453,51479,12,51901,51927,12,52349,52375,12,52797,52823,12,53245,53271,12,53693,53719,12,54141,54167,12,54589,54615,12,55037,55063,12,69506,69509,5,70191,70193,5,70841,70841,7,71463,71467,5,72330,72342,5,94031,94031,5,123628,123631,5,127763,127765,14,127941,127941,14,128043,128062,14,128302,128317,14,128465,128467,14,128539,128539,14,128640,128640,14,128662,128662,14,128703,128703,14,128745,128745,14,129004,129007,14,129329,129330,14,129402,129402,14,129483,129483,14,129686,129704,14,130048,131069,14,173,173,4,1757,1757,1,2200,2207,5,2434,2435,7,2631,2632,5,2817,2817,5,3008,3008,5,3201,3201,5,3387,3388,5,3542,3542,5,3902,3903,7,4190,4192,5,6002,6003,5,6439,6440,5,6765,6770,7,7019,7027,5,7154,7155,7,8205,8205,13,8505,8505,14,9654,9654,14,9757,9757,14,9792,9792,14,9852,9853,14,9890,9894,14,9937,9937,14,9981,9981,14,10035,10036,14,11035,11036,14,42654,42655,5,43346,43347,7,43587,43587,5,44006,44007,7,44173,44199,12,44397,44423,12,44621,44647,12,44845,44871,12,45069,45095,12,45293,45319,12,45517,45543,12,45741,45767,12,45965,45991,12,46189,46215,12,46413,46439,12,46637,46663,12,46861,46887,12,47085,47111,12,47309,47335,12,47533,47559,12,47757,47783,12,47981,48007,12,48205,48231,12,48429,48455,12,48653,48679,12,48877,48903,12,49101,49127,12,49325,49351,12,49549,49575,12,49773,49799,12,49997,50023,12,50221,50247,12,50445,50471,12,50669,50695,12,50893,50919,12,51117,51143,12,51341,51367,12,51565,51591,12,51789,51815,12,52013,52039,12,52237,52263,12,52461,52487,12,52685,52711,12,52909,52935,12,53133,53159,12,53357,53383,12,53581,53607,12,53805,53831,12,54029,54055,12,54253,54279,12,54477,54503,12,54701,54727,12,54925,54951,12,55149,55175,12,68101,68102,5,69762,69762,7,70067,70069,7,70371,70378,5,70720,70721,7,71087,71087,5,71341,71341,5,71995,71996,5,72249,72249,7,72850,72871,5,73109,73109,5,118576,118598,5,121505,121519,5,127245,127247,14,127568,127569,14,127777,127777,14,127872,127891,14,127956,127967,14,128015,128016,14,128110,128172,14,128259,128259,14,128367,128368,14,128424,128424,14,128488,128488,14,128530,128532,14,128550,128551,14,128566,128566,14,128647,128647,14,128656,128656,14,128667,128673,14,128691,128693,14,128715,128715,14,128728,128732,14,128752,128752,14,128765,128767,14,129096,129103,14,129311,129311,14,129344,129349,14,129394,129394,14,129413,129425,14,129466,129471,14,129511,129535,14,129664,129666,14,129719,129722,14,129760,129767,14,917536,917631,5,13,13,2,1160,1161,5,1564,1564,4,1807,1807,1,2085,2087,5,2307,2307,7,2382,2383,7,2497,2500,5,2563,2563,7,2677,2677,5,2763,2764,7,2879,2879,5,2914,2915,5,3021,3021,5,3142,3144,5,3263,3263,5,3285,3286,5,3398,3400,7,3530,3530,5,3633,3633,5,3864,3865,5,3974,3975,5,4155,4156,7,4229,4230,5,5909,5909,7,6078,6085,7,6277,6278,5,6451,6456,7,6744,6750,5,6846,6846,5,6972,6972,5,7074,7077,5,7146,7148,7,7222,7223,5,7416,7417,5,8234,8238,4,8417,8417,5,9000,9000,14,9203,9203,14,9730,9731,14,9748,9749,14,9762,9763,14,9776,9783,14,9800,9811,14,9831,9831,14,9872,9873,14,9882,9882,14,9900,9903,14,9929,9933,14,9941,9960,14,9974,9974,14,9989,9989,14,10006,10006,14,10062,10062,14,10160,10160,14,11647,11647,5,12953,12953,14,43019,43019,5,43232,43249,5,43443,43443,5,43567,43568,7,43696,43696,5,43765,43765,7,44013,44013,5,44117,44143,12,44229,44255,12,44341,44367,12,44453,44479,12,44565,44591,12,44677,44703,12,44789,44815,12,44901,44927,12,45013,45039,12,45125,45151,12,45237,45263,12,45349,45375,12,45461,45487,12,45573,45599,12,45685,45711,12,45797,45823,12,45909,45935,12,46021,46047,12,46133,46159,12,46245,46271,12,46357,46383,12,46469,46495,12,46581,46607,12,46693,46719,12,46805,46831,12,46917,46943,12,47029,47055,12,47141,47167,12,47253,47279,12,47365,47391,12,47477,47503,12,47589,47615,12,47701,47727,12,47813,47839,12,47925,47951,12,48037,48063,12,48149,48175,12,48261,48287,12,48373,48399,12,48485,48511,12,48597,48623,12,48709,48735,12,48821,48847,12,48933,48959,12,49045,49071,12,49157,49183,12,49269,49295,12,49381,49407,12,49493,49519,12,49605,49631,12,49717,49743,12,49829,49855,12,49941,49967,12,50053,50079,12,50165,50191,12,50277,50303,12,50389,50415,12,50501,50527,12,50613,50639,12,50725,50751,12,50837,50863,12,50949,50975,12,51061,51087,12,51173,51199,12,51285,51311,12,51397,51423,12,51509,51535,12,51621,51647,12,51733,51759,12,51845,51871,12,51957,51983,12,52069,52095,12,52181,52207,12,52293,52319,12,52405,52431,12,52517,52543,12,52629,52655,12,52741,52767,12,52853,52879,12,52965,52991,12,53077,53103,12,53189,53215,12,53301,53327,12,53413,53439,12,53525,53551,12,53637,53663,12,53749,53775,12,53861,53887,12,53973,53999,12,54085,54111,12,54197,54223,12,54309,54335,12,54421,54447,12,54533,54559,12,54645,54671,12,54757,54783,12,54869,54895,12,54981,55007,12,55093,55119,12,55243,55291,10,66045,66045,5,68325,68326,5,69688,69702,5,69817,69818,5,69957,69958,7,70089,70092,5,70198,70199,5,70462,70462,5,70502,70508,5,70750,70750,5,70846,70846,7,71100,71101,5,71230,71230,7,71351,71351,5,71737,71738,5,72000,72000,7,72160,72160,5,72273,72278,5,72752,72758,5,72882,72883,5,73031,73031,5,73461,73462,7,94192,94193,7,119149,119149,7,121403,121452,5,122915,122916,5,126980,126980,14,127358,127359,14,127535,127535,14,127759,127759,14,127771,127771,14,127792,127793,14,127825,127867,14,127897,127899,14,127945,127945,14,127985,127986,14,128000,128007,14,128021,128021,14,128066,128100,14,128184,128235,14,128249,128252,14,128266,128276,14,128335,128335,14,128379,128390,14,128407,128419,14,128444,128444,14,128481,128481,14,128499,128499,14,128526,128526,14,128536,128536,14,128543,128543,14,128556,128556,14,128564,128564,14,128577,128580,14,128643,128645,14,128649,128649,14,128654,128654,14,128660,128660,14,128664,128664,14,128675,128675,14,128686,128689,14,128695,128696,14,128705,128709,14,128717,128719,14,128725,128725,14,128736,128741,14,128747,128748,14,128755,128755,14,128762,128762,14,128981,128991,14,129009,129023,14,129160,129167,14,129296,129304,14,129320,129327,14,129340,129342,14,129356,129356,14,129388,129392,14,129399,129400,14,129404,129407,14,129432,129442,14,129454,129455,14,129473,129474,14,129485,129487,14,129648,129651,14,129659,129660,14,129671,129679,14,129709,129711,14,129728,129730,14,129751,129753,14,129776,129782,14,917505,917505,4,917760,917999,5,10,10,3,127,159,4,768,879,5,1471,1471,5,1536,1541,1,1648,1648,5,1767,1768,5,1840,1866,5,2070,2073,5,2137,2139,5,2274,2274,1,2363,2363,7,2377,2380,7,2402,2403,5,2494,2494,5,2507,2508,7,2558,2558,5,2622,2624,7,2641,2641,5,2691,2691,7,2759,2760,5,2786,2787,5,2876,2876,5,2881,2884,5,2901,2902,5,3006,3006,5,3014,3016,7,3072,3072,5,3134,3136,5,3157,3158,5,3260,3260,5,3266,3266,5,3274,3275,7,3328,3329,5,3391,3392,7,3405,3405,5,3457,3457,5,3536,3537,7,3551,3551,5,3636,3642,5,3764,3772,5,3895,3895,5,3967,3967,7,3993,4028,5,4146,4151,5,4182,4183,7,4226,4226,5,4253,4253,5,4957,4959,5,5940,5940,7,6070,6070,7,6087,6088,7,6158,6158,4,6432,6434,5,6448,6449,7,6679,6680,5,6742,6742,5,6754,6754,5,6783,6783,5,6912,6915,5,6966,6970,5,6978,6978,5,7042,7042,7,7080,7081,5,7143,7143,7,7150,7150,7,7212,7219,5,7380,7392,5,7412,7412,5,8203,8203,4,8232,8232,4,8265,8265,14,8400,8412,5,8421,8432,5,8617,8618,14,9167,9167,14,9200,9200,14,9410,9410,14,9723,9726,14,9733,9733,14,9745,9745,14,9752,9752,14,9760,9760,14,9766,9766,14,9774,9774,14,9786,9786,14,9794,9794,14,9823,9823,14,9828,9828,14,9833,9850,14,9855,9855,14,9875,9875,14,9880,9880,14,9885,9887,14,9896,9897,14,9906,9916,14,9926,9927,14,9935,9935,14,9939,9939,14,9962,9962,14,9972,9972,14,9978,9978,14,9986,9986,14,9997,9997,14,10002,10002,14,10017,10017,14,10055,10055,14,10071,10071,14,10133,10135,14,10548,10549,14,11093,11093,14,12330,12333,5,12441,12442,5,42608,42610,5,43010,43010,5,43045,43046,5,43188,43203,7,43302,43309,5,43392,43394,5,43446,43449,5,43493,43493,5,43571,43572,7,43597,43597,7,43703,43704,5,43756,43757,5,44003,44004,7,44009,44010,7,44033,44059,12,44089,44115,12,44145,44171,12,44201,44227,12,44257,44283,12,44313,44339,12,44369,44395,12,44425,44451,12,44481,44507,12,44537,44563,12,44593,44619,12,44649,44675,12,44705,44731,12,44761,44787,12,44817,44843,12,44873,44899,12,44929,44955,12,44985,45011,12,45041,45067,12,45097,45123,12,45153,45179,12,45209,45235,12,45265,45291,12,45321,45347,12,45377,45403,12,45433,45459,12,45489,45515,12,45545,45571,12,45601,45627,12,45657,45683,12,45713,45739,12,45769,45795,12,45825,45851,12,45881,45907,12,45937,45963,12,45993,46019,12,46049,46075,12,46105,46131,12,46161,46187,12,46217,46243,12,46273,46299,12,46329,46355,12,46385,46411,12,46441,46467,12,46497,46523,12,46553,46579,12,46609,46635,12,46665,46691,12,46721,46747,12,46777,46803,12,46833,46859,12,46889,46915,12,46945,46971,12,47001,47027,12,47057,47083,12,47113,47139,12,47169,47195,12,47225,47251,12,47281,47307,12,47337,47363,12,47393,47419,12,47449,47475,12,47505,47531,12,47561,47587,12,47617,47643,12,47673,47699,12,47729,47755,12,47785,47811,12,47841,47867,12,47897,47923,12,47953,47979,12,48009,48035,12,48065,48091,12,48121,48147,12,48177,48203,12,48233,48259,12,48289,48315,12,48345,48371,12,48401,48427,12,48457,48483,12,48513,48539,12,48569,48595,12,48625,48651,12,48681,48707,12,48737,48763,12,48793,48819,12,48849,48875,12,48905,48931,12,48961,48987,12,49017,49043,12,49073,49099,12,49129,49155,12,49185,49211,12,49241,49267,12,49297,49323,12,49353,49379,12,49409,49435,12,49465,49491,12,49521,49547,12,49577,49603,12,49633,49659,12,49689,49715,12,49745,49771,12,49801,49827,12,49857,49883,12,49913,49939,12,49969,49995,12,50025,50051,12,50081,50107,12,50137,50163,12,50193,50219,12,50249,50275,12,50305,50331,12,50361,50387,12,50417,50443,12,50473,50499,12,50529,50555,12,50585,50611,12,50641,50667,12,50697,50723,12,50753,50779,12,50809,50835,12,50865,50891,12,50921,50947,12,50977,51003,12,51033,51059,12,51089,51115,12,51145,51171,12,51201,51227,12,51257,51283,12,51313,51339,12,51369,51395,12,51425,51451,12,51481,51507,12,51537,51563,12,51593,51619,12,51649,51675,12,51705,51731,12,51761,51787,12,51817,51843,12,51873,51899,12,51929,51955,12,51985,52011,12,52041,52067,12,52097,52123,12,52153,52179,12,52209,52235,12,52265,52291,12,52321,52347,12,52377,52403,12,52433,52459,12,52489,52515,12,52545,52571,12,52601,52627,12,52657,52683,12,52713,52739,12,52769,52795,12,52825,52851,12,52881,52907,12,52937,52963,12,52993,53019,12,53049,53075,12,53105,53131,12,53161,53187,12,53217,53243,12,53273,53299,12,53329,53355,12,53385,53411,12,53441,53467,12,53497,53523,12,53553,53579,12,53609,53635,12,53665,53691,12,53721,53747,12,53777,53803,12,53833,53859,12,53889,53915,12,53945,53971,12,54001,54027,12,54057,54083,12,54113,54139,12,54169,54195,12,54225,54251,12,54281,54307,12,54337,54363,12,54393,54419,12,54449,54475,12,54505,54531,12,54561,54587,12,54617,54643,12,54673,54699,12,54729,54755,12,54785,54811,12,54841,54867,12,54897,54923,12,54953,54979,12,55009,55035,12,55065,55091,12,55121,55147,12,55177,55203,12,65024,65039,5,65520,65528,4,66422,66426,5,68152,68154,5,69291,69292,5,69633,69633,5,69747,69748,5,69811,69814,5,69826,69826,5,69932,69932,7,70016,70017,5,70079,70080,7,70095,70095,5,70196,70196,5,70367,70367,5,70402,70403,7,70464,70464,5,70487,70487,5,70709,70711,7,70725,70725,7,70833,70834,7,70843,70844,7,70849,70849,7,71090,71093,5,71103,71104,5,71227,71228,7,71339,71339,5,71344,71349,5,71458,71461,5,71727,71735,5,71985,71989,7,71998,71998,5,72002,72002,7,72154,72155,5,72193,72202,5,72251,72254,5,72281,72283,5,72344,72345,5,72766,72766,7,72874,72880,5,72885,72886,5,73023,73029,5,73104,73105,5,73111,73111,5,92912,92916,5,94095,94098,5,113824,113827,4,119142,119142,7,119155,119162,4,119362,119364,5,121476,121476,5,122888,122904,5,123184,123190,5,125252,125258,5,127183,127183,14,127340,127343,14,127377,127386,14,127491,127503,14,127548,127551,14,127744,127756,14,127761,127761,14,127769,127769,14,127773,127774,14,127780,127788,14,127796,127797,14,127820,127823,14,127869,127869,14,127894,127895,14,127902,127903,14,127943,127943,14,127947,127950,14,127972,127972,14,127988,127988,14,127992,127994,14,128009,128011,14,128019,128019,14,128023,128041,14,128064,128064,14,128102,128107,14,128174,128181,14,128238,128238,14,128246,128247,14,128254,128254,14,128264,128264,14,128278,128299,14,128329,128330,14,128348,128359,14,128371,128377,14,128392,128393,14,128401,128404,14,128421,128421,14,128433,128434,14,128450,128452,14,128476,128478,14,128483,128483,14,128495,128495,14,128506,128506,14,128519,128520,14,128528,128528,14,128534,128534,14,128538,128538,14,128540,128542,14,128544,128549,14,128552,128555,14,128557,128557,14,128560,128563,14,128565,128565,14,128567,128576,14,128581,128591,14,128641,128642,14,128646,128646,14,128648,128648,14,128650,128651,14,128653,128653,14,128655,128655,14,128657,128659,14,128661,128661,14,128663,128663,14,128665,128666,14,128674,128674,14,128676,128677,14,128679,128685,14,128690,128690,14,128694,128694,14,128697,128702,14,128704,128704,14,128710,128714,14,128716,128716,14,128720,128720,14,128723,128724,14,128726,128727,14,128733,128735,14,128742,128744,14,128746,128746,14,128749,128751,14,128753,128754,14,128756,128758,14,128761,128761,14,128763,128764,14,128884,128895,14,128992,129003,14,129008,129008,14,129036,129039,14,129114,129119,14,129198,129279,14,129293,129295,14,129305,129310,14,129312,129319,14,129328,129328,14,129331,129338,14,129343,129343,14,129351,129355,14,129357,129359,14,129375,129387,14,129393,129393,14,129395,129398,14,129401,129401,14,129403,129403,14,129408,129412,14,129426,129431,14,129443,129444,14,129451,129453,14,129456,129465,14,129472,129472,14,129475,129482,14,129484,129484,14,129488,129510,14,129536,129647,14,129652,129652,14,129656,129658,14,129661,129663,14,129667,129670,14,129680,129685,14,129705,129708,14,129712,129718,14,129723,129727,14,129731,129733,14,129744,129750,14,129754,129759,14,129768,129775,14,129783,129791,14,917504,917504,4,917506,917535,4,917632,917759,4,918000,921599,4,0,9,4,11,12,4,14,31,4,169,169,14,174,174,14,1155,1159,5,1425,1469,5,1473,1474,5,1479,1479,5,1552,1562,5,1611,1631,5,1750,1756,5,1759,1764,5,1770,1773,5,1809,1809,5,1958,1968,5,2045,2045,5,2075,2083,5,2089,2093,5,2192,2193,1,2250,2273,5,2275,2306,5,2362,2362,5,2364,2364,5,2369,2376,5,2381,2381,5,2385,2391,5,2433,2433,5,2492,2492,5,2495,2496,7,2503,2504,7,2509,2509,5,2530,2531,5,2561,2562,5,2620,2620,5,2625,2626,5,2635,2637,5,2672,2673,5,2689,2690,5,2748,2748,5,2753,2757,5,2761,2761,7,2765,2765,5,2810,2815,5,2818,2819,7,2878,2878,5,2880,2880,7,2887,2888,7,2893,2893,5,2903,2903,5,2946,2946,5,3007,3007,7,3009,3010,7,3018,3020,7,3031,3031,5,3073,3075,7,3132,3132,5,3137,3140,7,3146,3149,5,3170,3171,5,3202,3203,7,3262,3262,7,3264,3265,7,3267,3268,7,3271,3272,7,3276,3277,5,3298,3299,5,3330,3331,7,3390,3390,5,3393,3396,5,3402,3404,7,3406,3406,1,3426,3427,5,3458,3459,7,3535,3535,5,3538,3540,5,3544,3550,7,3570,3571,7,3635,3635,7,3655,3662,5,3763,3763,7,3784,3789,5,3893,3893,5,3897,3897,5,3953,3966,5,3968,3972,5,3981,3991,5,4038,4038,5,4145,4145,7,4153,4154,5,4157,4158,5,4184,4185,5,4209,4212,5,4228,4228,7,4237,4237,5,4352,4447,8,4520,4607,10,5906,5908,5,5938,5939,5,5970,5971,5,6068,6069,5,6071,6077,5,6086,6086,5,6089,6099,5,6155,6157,5,6159,6159,5,6313,6313,5,6435,6438,7,6441,6443,7,6450,6450,5,6457,6459,5,6681,6682,7,6741,6741,7,6743,6743,7,6752,6752,5,6757,6764,5,6771,6780,5,6832,6845,5,6847,6862,5,6916,6916,7,6965,6965,5,6971,6971,7,6973,6977,7,6979,6980,7,7040,7041,5,7073,7073,7,7078,7079,7,7082,7082,7,7142,7142,5,7144,7145,5,7149,7149,5,7151,7153,5,7204,7211,7,7220,7221,7,7376,7378,5,7393,7393,7,7405,7405,5,7415,7415,7,7616,7679,5,8204,8204,5,8206,8207,4,8233,8233,4,8252,8252,14,8288,8292,4,8294,8303,4,8413,8416,5,8418,8420,5,8482,8482,14,8596,8601,14,8986,8987,14,9096,9096,14,9193,9196,14,9199,9199,14,9201,9202,14,9208,9210,14,9642,9643,14,9664,9664,14,9728,9729,14,9732,9732,14,9735,9741,14,9743,9744,14,9746,9746,14,9750,9751,14,9753,9756,14,9758,9759,14,9761,9761,14,9764,9765,14,9767,9769,14,9771,9773,14,9775,9775,14,9784,9785,14,9787,9791,14,9793,9793,14,9795,9799,14,9812,9822,14,9824,9824,14,9827,9827,14,9829,9830,14,9832,9832,14,9851,9851,14,9854,9854,14,9856,9861,14,9874,9874,14,9876,9876,14,9878,9879,14,9881,9881,14,9883,9884,14,9888,9889,14,9895,9895,14,9898,9899,14,9904,9905,14,9917,9918,14,9924,9925,14,9928,9928,14,9934,9934,14,9936,9936,14,9938,9938,14,9940,9940,14,9961,9961,14,9963,9967,14,9970,9971,14,9973,9973,14,9975,9977,14,9979,9980,14,9982,9985,14,9987,9988,14,9992,9996,14,9998,9998,14,10000,10001,14,10004,10004,14,10013,10013,14,10024,10024,14,10052,10052,14,10060,10060,14,10067,10069,14,10083,10083,14,10085,10087,14,10145,10145,14,10175,10175,14,11013,11015,14,11088,11088,14,11503,11505,5,11744,11775,5,12334,12335,5,12349,12349,14,12951,12951,14,42607,42607,5,42612,42621,5,42736,42737,5,43014,43014,5,43043,43044,7,43047,43047,7,43136,43137,7,43204,43205,5,43263,43263,5,43335,43345,5,43360,43388,8,43395,43395,7,43444,43445,7,43450,43451,7,43454,43456,7,43561,43566,5,43569,43570,5,43573,43574,5,43596,43596,5,43644,43644,5,43698,43700,5,43710,43711,5,43755,43755,7,43758,43759,7,43766,43766,5,44005,44005,5,44008,44008,5,44012,44012,7,44032,44032,11,44060,44060,11,44088,44088,11,44116,44116,11,44144,44144,11,44172,44172,11,44200,44200,11,44228,44228,11,44256,44256,11,44284,44284,11,44312,44312,11,44340,44340,11,44368,44368,11,44396,44396,11,44424,44424,11,44452,44452,11,44480,44480,11,44508,44508,11,44536,44536,11,44564,44564,11,44592,44592,11,44620,44620,11,44648,44648,11,44676,44676,11,44704,44704,11,44732,44732,11,44760,44760,11,44788,44788,11,44816,44816,11,44844,44844,11,44872,44872,11,44900,44900,11,44928,44928,11,44956,44956,11,44984,44984,11,45012,45012,11,45040,45040,11,45068,45068,11,45096,45096,11,45124,45124,11,45152,45152,11,45180,45180,11,45208,45208,11,45236,45236,11,45264,45264,11,45292,45292,11,45320,45320,11,45348,45348,11,45376,45376,11,45404,45404,11,45432,45432,11,45460,45460,11,45488,45488,11,45516,45516,11,45544,45544,11,45572,45572,11,45600,45600,11,45628,45628,11,45656,45656,11,45684,45684,11,45712,45712,11,45740,45740,11,45768,45768,11,45796,45796,11,45824,45824,11,45852,45852,11,45880,45880,11,45908,45908,11,45936,45936,11,45964,45964,11,45992,45992,11,46020,46020,11,46048,46048,11,46076,46076,11,46104,46104,11,46132,46132,11,46160,46160,11,46188,46188,11,46216,46216,11,46244,46244,11,46272,46272,11,46300,46300,11,46328,46328,11,46356,46356,11,46384,46384,11,46412,46412,11,46440,46440,11,46468,46468,11,46496,46496,11,46524,46524,11,46552,46552,11,46580,46580,11,46608,46608,11,46636,46636,11,46664,46664,11,46692,46692,11,46720,46720,11,46748,46748,11,46776,46776,11,46804,46804,11,46832,46832,11,46860,46860,11,46888,46888,11,46916,46916,11,46944,46944,11,46972,46972,11,47000,47000,11,47028,47028,11,47056,47056,11,47084,47084,11,47112,47112,11,47140,47140,11,47168,47168,11,47196,47196,11,47224,47224,11,47252,47252,11,47280,47280,11,47308,47308,11,47336,47336,11,47364,47364,11,47392,47392,11,47420,47420,11,47448,47448,11,47476,47476,11,47504,47504,11,47532,47532,11,47560,47560,11,47588,47588,11,47616,47616,11,47644,47644,11,47672,47672,11,47700,47700,11,47728,47728,11,47756,47756,11,47784,47784,11,47812,47812,11,47840,47840,11,47868,47868,11,47896,47896,11,47924,47924,11,47952,47952,11,47980,47980,11,48008,48008,11,48036,48036,11,48064,48064,11,48092,48092,11,48120,48120,11,48148,48148,11,48176,48176,11,48204,48204,11,48232,48232,11,48260,48260,11,48288,48288,11,48316,48316,11,48344,48344,11,48372,48372,11,48400,48400,11,48428,48428,11,48456,48456,11,48484,48484,11,48512,48512,11,48540,48540,11,48568,48568,11,48596,48596,11,48624,48624,11,48652,48652,11,48680,48680,11,48708,48708,11,48736,48736,11,48764,48764,11,48792,48792,11,48820,48820,11,48848,48848,11,48876,48876,11,48904,48904,11,48932,48932,11,48960,48960,11,48988,48988,11,49016,49016,11,49044,49044,11,49072,49072,11,49100,49100,11,49128,49128,11,49156,49156,11,49184,49184,11,49212,49212,11,49240,49240,11,49268,49268,11,49296,49296,11,49324,49324,11,49352,49352,11,49380,49380,11,49408,49408,11,49436,49436,11,49464,49464,11,49492,49492,11,49520,49520,11,49548,49548,11,49576,49576,11,49604,49604,11,49632,49632,11,49660,49660,11,49688,49688,11,49716,49716,11,49744,49744,11,49772,49772,11,49800,49800,11,49828,49828,11,49856,49856,11,49884,49884,11,49912,49912,11,49940,49940,11,49968,49968,11,49996,49996,11,50024,50024,11,50052,50052,11,50080,50080,11,50108,50108,11,50136,50136,11,50164,50164,11,50192,50192,11,50220,50220,11,50248,50248,11,50276,50276,11,50304,50304,11,50332,50332,11,50360,50360,11,50388,50388,11,50416,50416,11,50444,50444,11,50472,50472,11,50500,50500,11,50528,50528,11,50556,50556,11,50584,50584,11,50612,50612,11,50640,50640,11,50668,50668,11,50696,50696,11,50724,50724,11,50752,50752,11,50780,50780,11,50808,50808,11,50836,50836,11,50864,50864,11,50892,50892,11,50920,50920,11,50948,50948,11,50976,50976,11,51004,51004,11,51032,51032,11,51060,51060,11,51088,51088,11,51116,51116,11,51144,51144,11,51172,51172,11,51200,51200,11,51228,51228,11,51256,51256,11,51284,51284,11,51312,51312,11,51340,51340,11,51368,51368,11,51396,51396,11,51424,51424,11,51452,51452,11,51480,51480,11,51508,51508,11,51536,51536,11,51564,51564,11,51592,51592,11,51620,51620,11,51648,51648,11,51676,51676,11,51704,51704,11,51732,51732,11,51760,51760,11,51788,51788,11,51816,51816,11,51844,51844,11,51872,51872,11,51900,51900,11,51928,51928,11,51956,51956,11,51984,51984,11,52012,52012,11,52040,52040,11,52068,52068,11,52096,52096,11,52124,52124,11,52152,52152,11,52180,52180,11,52208,52208,11,52236,52236,11,52264,52264,11,52292,52292,11,52320,52320,11,52348,52348,11,52376,52376,11,52404,52404,11,52432,52432,11,52460,52460,11,52488,52488,11,52516,52516,11,52544,52544,11,52572,52572,11,52600,52600,11,52628,52628,11,52656,52656,11,52684,52684,11,52712,52712,11,52740,52740,11,52768,52768,11,52796,52796,11,52824,52824,11,52852,52852,11,52880,52880,11,52908,52908,11,52936,52936,11,52964,52964,11,52992,52992,11,53020,53020,11,53048,53048,11,53076,53076,11,53104,53104,11,53132,53132,11,53160,53160,11,53188,53188,11,53216,53216,11,53244,53244,11,53272,53272,11,53300,53300,11,53328,53328,11,53356,53356,11,53384,53384,11,53412,53412,11,53440,53440,11,53468,53468,11,53496,53496,11,53524,53524,11,53552,53552,11,53580,53580,11,53608,53608,11,53636,53636,11,53664,53664,11,53692,53692,11,53720,53720,11,53748,53748,11,53776,53776,11,53804,53804,11,53832,53832,11,53860,53860,11,53888,53888,11,53916,53916,11,53944,53944,11,53972,53972,11,54000,54000,11,54028,54028,11,54056,54056,11,54084,54084,11,54112,54112,11,54140,54140,11,54168,54168,11,54196,54196,11,54224,54224,11,54252,54252,11,54280,54280,11,54308,54308,11,54336,54336,11,54364,54364,11,54392,54392,11,54420,54420,11,54448,54448,11,54476,54476,11,54504,54504,11,54532,54532,11,54560,54560,11,54588,54588,11,54616,54616,11,54644,54644,11,54672,54672,11,54700,54700,11,54728,54728,11,54756,54756,11,54784,54784,11,54812,54812,11,54840,54840,11,54868,54868,11,54896,54896,11,54924,54924,11,54952,54952,11,54980,54980,11,55008,55008,11,55036,55036,11,55064,55064,11,55092,55092,11,55120,55120,11,55148,55148,11,55176,55176,11,55216,55238,9,64286,64286,5,65056,65071,5,65438,65439,5,65529,65531,4,66272,66272,5,68097,68099,5,68108,68111,5,68159,68159,5,68900,68903,5,69446,69456,5,69632,69632,7,69634,69634,7,69744,69744,5,69759,69761,5,69808,69810,7,69815,69816,7,69821,69821,1,69837,69837,1,69927,69931,5,69933,69940,5,70003,70003,5,70018,70018,7,70070,70078,5,70082,70083,1,70094,70094,7,70188,70190,7,70194,70195,7,70197,70197,7,70206,70206,5,70368,70370,7,70400,70401,5,70459,70460,5,70463,70463,7,70465,70468,7,70475,70477,7,70498,70499,7,70512,70516,5,70712,70719,5,70722,70724,5,70726,70726,5,70832,70832,5,70835,70840,5,70842,70842,5,70845,70845,5,70847,70848,5,70850,70851,5,71088,71089,7,71096,71099,7,71102,71102,7,71132,71133,5,71219,71226,5,71229,71229,5,71231,71232,5,71340,71340,7,71342,71343,7,71350,71350,7,71453,71455,5,71462,71462,7,71724,71726,7,71736,71736,7,71984,71984,5,71991,71992,7,71997,71997,7,71999,71999,1,72001,72001,1,72003,72003,5,72148,72151,5,72156,72159,7,72164,72164,7,72243,72248,5,72250,72250,1,72263,72263,5,72279,72280,7,72324,72329,1,72343,72343,7,72751,72751,7,72760,72765,5,72767,72767,5,72873,72873,7,72881,72881,7,72884,72884,7,73009,73014,5,73020,73021,5,73030,73030,1,73098,73102,7,73107,73108,7,73110,73110,7,73459,73460,5,78896,78904,4,92976,92982,5,94033,94087,7,94180,94180,5,113821,113822,5,118528,118573,5,119141,119141,5,119143,119145,5,119150,119154,5,119163,119170,5,119210,119213,5,121344,121398,5,121461,121461,5,121499,121503,5,122880,122886,5,122907,122913,5,122918,122922,5,123566,123566,5,125136,125142,5,126976,126979,14,126981,127182,14,127184,127231,14,127279,127279,14,127344,127345,14,127374,127374,14,127405,127461,14,127489,127490,14,127514,127514,14,127538,127546,14,127561,127567,14,127570,127743,14,127757,127758,14,127760,127760,14,127762,127762,14,127766,127768,14,127770,127770,14,127772,127772,14,127775,127776,14,127778,127779,14,127789,127791,14,127794,127795,14,127798,127798,14,127819,127819,14,127824,127824,14,127868,127868,14,127870,127871,14,127892,127893,14,127896,127896,14,127900,127901,14,127904,127940,14,127942,127942,14,127944,127944,14,127946,127946,14,127951,127955,14,127968,127971,14,127973,127984,14,127987,127987,14,127989,127989,14,127991,127991,14,127995,127999,5,128008,128008,14,128012,128014,14,128017,128018,14,128020,128020,14,128022,128022,14,128042,128042,14,128063,128063,14,128065,128065,14,128101,128101,14,128108,128109,14,128173,128173,14,128182,128183,14,128236,128237,14,128239,128239,14,128245,128245,14,128248,128248,14,128253,128253,14,128255,128258,14,128260,128263,14,128265,128265,14,128277,128277,14,128300,128301,14,128326,128328,14,128331,128334,14,128336,128347,14,128360,128366,14,128369,128370,14,128378,128378,14,128391,128391,14,128394,128397,14,128400,128400,14,128405,128406,14,128420,128420,14,128422,128423,14,128425,128432,14,128435,128443,14,128445,128449,14,128453,128464,14,128468,128475,14,128479,128480,14,128482,128482,14,128484,128487,14,128489,128494,14,128496,128498,14,128500,128505,14,128507,128511,14,128513,128518,14,128521,128525,14,128527,128527,14,128529,128529,14,128533,128533,14,128535,128535,14,128537,128537,14]");
}
var CSI_SEQUENCE, OSC_SEQUENCE, ESC_SEQUENCE, CONTROL_SEQUENCES, UTF8_BOM_CHARACTER, GraphemeBreakType, GraphemeBreakTree, CodePoint, AmbiguousCharacters, InvisibleCharacters;
var init_strings = __esm({
  "out-build/vs/base/common/strings.js"() {
    "use strict";
    init_cache();
    init_lazy();
    CSI_SEQUENCE = /(?:\x1b\[|\x9b)[=?>!]?[\d;:]*["$#'* ]?[a-zA-Z@^`{}|~]/;
    OSC_SEQUENCE = /(?:\x1b\]|\x9d).*?(?:\x1b\\|\x07|\x9c)/;
    ESC_SEQUENCE = /\x1b(?:[ #%\(\)\*\+\-\.\/]?[a-zA-Z0-9\|}~@])/;
    CONTROL_SEQUENCES = new RegExp("(?:" + [
      CSI_SEQUENCE.source,
      OSC_SEQUENCE.source,
      ESC_SEQUENCE.source
    ].join("|") + ")", "g");
    UTF8_BOM_CHARACTER = String.fromCharCode(
      65279
      /* CharCode.UTF8_BOM */
    );
    (function(GraphemeBreakType2) {
      GraphemeBreakType2[GraphemeBreakType2["Other"] = 0] = "Other";
      GraphemeBreakType2[GraphemeBreakType2["Prepend"] = 1] = "Prepend";
      GraphemeBreakType2[GraphemeBreakType2["CR"] = 2] = "CR";
      GraphemeBreakType2[GraphemeBreakType2["LF"] = 3] = "LF";
      GraphemeBreakType2[GraphemeBreakType2["Control"] = 4] = "Control";
      GraphemeBreakType2[GraphemeBreakType2["Extend"] = 5] = "Extend";
      GraphemeBreakType2[GraphemeBreakType2["Regional_Indicator"] = 6] = "Regional_Indicator";
      GraphemeBreakType2[GraphemeBreakType2["SpacingMark"] = 7] = "SpacingMark";
      GraphemeBreakType2[GraphemeBreakType2["L"] = 8] = "L";
      GraphemeBreakType2[GraphemeBreakType2["V"] = 9] = "V";
      GraphemeBreakType2[GraphemeBreakType2["T"] = 10] = "T";
      GraphemeBreakType2[GraphemeBreakType2["LV"] = 11] = "LV";
      GraphemeBreakType2[GraphemeBreakType2["LVT"] = 12] = "LVT";
      GraphemeBreakType2[GraphemeBreakType2["ZWJ"] = 13] = "ZWJ";
      GraphemeBreakType2[GraphemeBreakType2["Extended_Pictographic"] = 14] = "Extended_Pictographic";
    })(GraphemeBreakType || (GraphemeBreakType = {}));
    GraphemeBreakTree = class _GraphemeBreakTree {
      static {
        this._INSTANCE = null;
      }
      static getInstance() {
        if (!_GraphemeBreakTree._INSTANCE) {
          _GraphemeBreakTree._INSTANCE = new _GraphemeBreakTree();
        }
        return _GraphemeBreakTree._INSTANCE;
      }
      constructor() {
        this._data = getGraphemeBreakRawData();
      }
      getGraphemeBreakType(codePoint) {
        if (codePoint < 32) {
          if (codePoint === 10) {
            return 3;
          }
          if (codePoint === 13) {
            return 2;
          }
          return 4;
        }
        if (codePoint < 127) {
          return 0;
        }
        const data = this._data;
        const nodeCount = data.length / 3;
        let nodeIndex = 1;
        while (nodeIndex <= nodeCount) {
          if (codePoint < data[3 * nodeIndex]) {
            nodeIndex = 2 * nodeIndex;
          } else if (codePoint > data[3 * nodeIndex + 1]) {
            nodeIndex = 2 * nodeIndex + 1;
          } else {
            return data[3 * nodeIndex + 2];
          }
        }
        return 0;
      }
    };
    (function(CodePoint2) {
      CodePoint2[CodePoint2["zwj"] = 8205] = "zwj";
      CodePoint2[CodePoint2["emojiVariantSelector"] = 65039] = "emojiVariantSelector";
      CodePoint2[CodePoint2["enclosingKeyCap"] = 8419] = "enclosingKeyCap";
      CodePoint2[CodePoint2["space"] = 32] = "space";
    })(CodePoint || (CodePoint = {}));
    AmbiguousCharacters = class _AmbiguousCharacters {
      static {
        this.ambiguousCharacterData = new Lazy(() => {
          return JSON.parse('{"_common":[8232,32,8233,32,5760,32,8192,32,8193,32,8194,32,8195,32,8196,32,8197,32,8198,32,8200,32,8201,32,8202,32,8287,32,8199,32,8239,32,2042,95,65101,95,65102,95,65103,95,8208,45,8209,45,8210,45,65112,45,1748,45,8259,45,727,45,8722,45,10134,45,11450,45,1549,44,1643,44,184,44,42233,44,894,59,2307,58,2691,58,1417,58,1795,58,1796,58,5868,58,65072,58,6147,58,6153,58,8282,58,1475,58,760,58,42889,58,8758,58,720,58,42237,58,451,33,11601,33,660,63,577,63,2429,63,5038,63,42731,63,119149,46,8228,46,1793,46,1794,46,42510,46,68176,46,1632,46,1776,46,42232,46,1373,96,65287,96,8219,96,1523,96,8242,96,1370,96,8175,96,65344,96,900,96,8189,96,8125,96,8127,96,8190,96,697,96,884,96,712,96,714,96,715,96,756,96,699,96,701,96,700,96,702,96,42892,96,1497,96,2036,96,2037,96,5194,96,5836,96,94033,96,94034,96,65339,91,10088,40,10098,40,12308,40,64830,40,65341,93,10089,41,10099,41,12309,41,64831,41,10100,123,119060,123,10101,125,65342,94,8270,42,1645,42,8727,42,66335,42,5941,47,8257,47,8725,47,8260,47,9585,47,10187,47,10744,47,119354,47,12755,47,12339,47,11462,47,20031,47,12035,47,65340,92,65128,92,8726,92,10189,92,10741,92,10745,92,119311,92,119355,92,12756,92,20022,92,12034,92,42872,38,708,94,710,94,5869,43,10133,43,66203,43,8249,60,10094,60,706,60,119350,60,5176,60,5810,60,5120,61,11840,61,12448,61,42239,61,8250,62,10095,62,707,62,119351,62,5171,62,94015,62,8275,126,732,126,8128,126,8764,126,65372,124,65293,45,118002,50,120784,50,120794,50,120804,50,120814,50,120824,50,130034,50,42842,50,423,50,1000,50,42564,50,5311,50,42735,50,119302,51,118003,51,120785,51,120795,51,120805,51,120815,51,120825,51,130035,51,42923,51,540,51,439,51,42858,51,11468,51,1248,51,94011,51,71882,51,118004,52,120786,52,120796,52,120806,52,120816,52,120826,52,130036,52,5070,52,71855,52,118005,53,120787,53,120797,53,120807,53,120817,53,120827,53,130037,53,444,53,71867,53,118006,54,120788,54,120798,54,120808,54,120818,54,120828,54,130038,54,11474,54,5102,54,71893,54,119314,55,118007,55,120789,55,120799,55,120809,55,120819,55,120829,55,130039,55,66770,55,71878,55,2819,56,2538,56,2666,56,125131,56,118008,56,120790,56,120800,56,120810,56,120820,56,120830,56,130040,56,547,56,546,56,66330,56,2663,57,2920,57,2541,57,3437,57,118009,57,120791,57,120801,57,120811,57,120821,57,120831,57,130041,57,42862,57,11466,57,71884,57,71852,57,71894,57,9082,97,65345,97,119834,97,119886,97,119938,97,119990,97,120042,97,120094,97,120146,97,120198,97,120250,97,120302,97,120354,97,120406,97,120458,97,593,97,945,97,120514,97,120572,97,120630,97,120688,97,120746,97,65313,65,117974,65,119808,65,119860,65,119912,65,119964,65,120016,65,120068,65,120120,65,120172,65,120224,65,120276,65,120328,65,120380,65,120432,65,913,65,120488,65,120546,65,120604,65,120662,65,120720,65,5034,65,5573,65,42222,65,94016,65,66208,65,119835,98,119887,98,119939,98,119991,98,120043,98,120095,98,120147,98,120199,98,120251,98,120303,98,120355,98,120407,98,120459,98,388,98,5071,98,5234,98,5551,98,65314,66,8492,66,117975,66,119809,66,119861,66,119913,66,120017,66,120069,66,120121,66,120173,66,120225,66,120277,66,120329,66,120381,66,120433,66,42932,66,914,66,120489,66,120547,66,120605,66,120663,66,120721,66,5108,66,5623,66,42192,66,66178,66,66209,66,66305,66,65347,99,8573,99,119836,99,119888,99,119940,99,119992,99,120044,99,120096,99,120148,99,120200,99,120252,99,120304,99,120356,99,120408,99,120460,99,7428,99,1010,99,11429,99,43951,99,66621,99,128844,67,71913,67,71922,67,65315,67,8557,67,8450,67,8493,67,117976,67,119810,67,119862,67,119914,67,119966,67,120018,67,120174,67,120226,67,120278,67,120330,67,120382,67,120434,67,1017,67,11428,67,5087,67,42202,67,66210,67,66306,67,66581,67,66844,67,8574,100,8518,100,119837,100,119889,100,119941,100,119993,100,120045,100,120097,100,120149,100,120201,100,120253,100,120305,100,120357,100,120409,100,120461,100,1281,100,5095,100,5231,100,42194,100,8558,68,8517,68,117977,68,119811,68,119863,68,119915,68,119967,68,120019,68,120071,68,120123,68,120175,68,120227,68,120279,68,120331,68,120383,68,120435,68,5024,68,5598,68,5610,68,42195,68,8494,101,65349,101,8495,101,8519,101,119838,101,119890,101,119942,101,120046,101,120098,101,120150,101,120202,101,120254,101,120306,101,120358,101,120410,101,120462,101,43826,101,1213,101,8959,69,65317,69,8496,69,117978,69,119812,69,119864,69,119916,69,120020,69,120072,69,120124,69,120176,69,120228,69,120280,69,120332,69,120384,69,120436,69,917,69,120492,69,120550,69,120608,69,120666,69,120724,69,11577,69,5036,69,42224,69,71846,69,71854,69,66182,69,119839,102,119891,102,119943,102,119995,102,120047,102,120099,102,120151,102,120203,102,120255,102,120307,102,120359,102,120411,102,120463,102,43829,102,42905,102,383,102,7837,102,1412,102,119315,70,8497,70,117979,70,119813,70,119865,70,119917,70,120021,70,120073,70,120125,70,120177,70,120229,70,120281,70,120333,70,120385,70,120437,70,42904,70,988,70,120778,70,5556,70,42205,70,71874,70,71842,70,66183,70,66213,70,66853,70,65351,103,8458,103,119840,103,119892,103,119944,103,120048,103,120100,103,120152,103,120204,103,120256,103,120308,103,120360,103,120412,103,120464,103,609,103,7555,103,397,103,1409,103,117980,71,119814,71,119866,71,119918,71,119970,71,120022,71,120074,71,120126,71,120178,71,120230,71,120282,71,120334,71,120386,71,120438,71,1292,71,5056,71,5107,71,42198,71,65352,104,8462,104,119841,104,119945,104,119997,104,120049,104,120101,104,120153,104,120205,104,120257,104,120309,104,120361,104,120413,104,120465,104,1211,104,1392,104,5058,104,65320,72,8459,72,8460,72,8461,72,117981,72,119815,72,119867,72,119919,72,120023,72,120179,72,120231,72,120283,72,120335,72,120387,72,120439,72,919,72,120494,72,120552,72,120610,72,120668,72,120726,72,11406,72,5051,72,5500,72,42215,72,66255,72,731,105,9075,105,65353,105,8560,105,8505,105,8520,105,119842,105,119894,105,119946,105,119998,105,120050,105,120102,105,120154,105,120206,105,120258,105,120310,105,120362,105,120414,105,120466,105,120484,105,618,105,617,105,953,105,8126,105,890,105,120522,105,120580,105,120638,105,120696,105,120754,105,1110,105,42567,105,1231,105,43893,105,5029,105,71875,105,65354,106,8521,106,119843,106,119895,106,119947,106,119999,106,120051,106,120103,106,120155,106,120207,106,120259,106,120311,106,120363,106,120415,106,120467,106,1011,106,1112,106,65322,74,117983,74,119817,74,119869,74,119921,74,119973,74,120025,74,120077,74,120129,74,120181,74,120233,74,120285,74,120337,74,120389,74,120441,74,42930,74,895,74,1032,74,5035,74,5261,74,42201,74,119844,107,119896,107,119948,107,120000,107,120052,107,120104,107,120156,107,120208,107,120260,107,120312,107,120364,107,120416,107,120468,107,8490,75,65323,75,117984,75,119818,75,119870,75,119922,75,119974,75,120026,75,120078,75,120130,75,120182,75,120234,75,120286,75,120338,75,120390,75,120442,75,922,75,120497,75,120555,75,120613,75,120671,75,120729,75,11412,75,5094,75,5845,75,42199,75,66840,75,1472,108,8739,73,9213,73,65512,73,1633,108,1777,73,66336,108,125127,108,118001,108,120783,73,120793,73,120803,73,120813,73,120823,73,130033,73,65321,73,8544,73,8464,73,8465,73,117982,108,119816,73,119868,73,119920,73,120024,73,120128,73,120180,73,120232,73,120284,73,120336,73,120388,73,120440,73,65356,108,8572,73,8467,108,119845,108,119897,108,119949,108,120001,108,120053,108,120105,73,120157,73,120209,73,120261,73,120313,73,120365,73,120417,73,120469,73,448,73,120496,73,120554,73,120612,73,120670,73,120728,73,11410,73,1030,73,1216,73,1493,108,1503,108,1575,108,126464,108,126592,108,65166,108,65165,108,1994,108,11599,73,5825,73,42226,73,93992,73,66186,124,66313,124,119338,76,8556,76,8466,76,117985,76,119819,76,119871,76,119923,76,120027,76,120079,76,120131,76,120183,76,120235,76,120287,76,120339,76,120391,76,120443,76,11472,76,5086,76,5290,76,42209,76,93974,76,71843,76,71858,76,66587,76,66854,76,65325,77,8559,77,8499,77,117986,77,119820,77,119872,77,119924,77,120028,77,120080,77,120132,77,120184,77,120236,77,120288,77,120340,77,120392,77,120444,77,924,77,120499,77,120557,77,120615,77,120673,77,120731,77,1018,77,11416,77,5047,77,5616,77,5846,77,42207,77,66224,77,66321,77,119847,110,119899,110,119951,110,120003,110,120055,110,120107,110,120159,110,120211,110,120263,110,120315,110,120367,110,120419,110,120471,110,1400,110,1404,110,65326,78,8469,78,117987,78,119821,78,119873,78,119925,78,119977,78,120029,78,120081,78,120185,78,120237,78,120289,78,120341,78,120393,78,120445,78,925,78,120500,78,120558,78,120616,78,120674,78,120732,78,11418,78,42208,78,66835,78,3074,111,3202,111,3330,111,3458,111,2406,111,2662,111,2790,111,3046,111,3174,111,3302,111,3430,111,3664,111,3792,111,4160,111,1637,111,1781,111,65359,111,8500,111,119848,111,119900,111,119952,111,120056,111,120108,111,120160,111,120212,111,120264,111,120316,111,120368,111,120420,111,120472,111,7439,111,7441,111,43837,111,959,111,120528,111,120586,111,120644,111,120702,111,120760,111,963,111,120532,111,120590,111,120648,111,120706,111,120764,111,11423,111,4351,111,1413,111,1505,111,1607,111,126500,111,126564,111,126596,111,65259,111,65260,111,65258,111,65257,111,1726,111,64428,111,64429,111,64427,111,64426,111,1729,111,64424,111,64425,111,64423,111,64422,111,1749,111,3360,111,4125,111,66794,111,71880,111,71895,111,66604,111,1984,79,2534,79,2918,79,12295,79,70864,79,71904,79,118000,79,120782,79,120792,79,120802,79,120812,79,120822,79,130032,79,65327,79,117988,79,119822,79,119874,79,119926,79,119978,79,120030,79,120082,79,120134,79,120186,79,120238,79,120290,79,120342,79,120394,79,120446,79,927,79,120502,79,120560,79,120618,79,120676,79,120734,79,11422,79,1365,79,11604,79,4816,79,2848,79,66754,79,42227,79,71861,79,66194,79,66219,79,66564,79,66838,79,9076,112,65360,112,119849,112,119901,112,119953,112,120005,112,120057,112,120109,112,120161,112,120213,112,120265,112,120317,112,120369,112,120421,112,120473,112,961,112,120530,112,120544,112,120588,112,120602,112,120646,112,120660,112,120704,112,120718,112,120762,112,120776,112,11427,112,65328,80,8473,80,117989,80,119823,80,119875,80,119927,80,119979,80,120031,80,120083,80,120187,80,120239,80,120291,80,120343,80,120395,80,120447,80,929,80,120504,80,120562,80,120620,80,120678,80,120736,80,11426,80,5090,80,5229,80,42193,80,66197,80,119850,113,119902,113,119954,113,120006,113,120058,113,120110,113,120162,113,120214,113,120266,113,120318,113,120370,113,120422,113,120474,113,1307,113,1379,113,1382,113,8474,81,117990,81,119824,81,119876,81,119928,81,119980,81,120032,81,120084,81,120188,81,120240,81,120292,81,120344,81,120396,81,120448,81,11605,81,119851,114,119903,114,119955,114,120007,114,120059,114,120111,114,120163,114,120215,114,120267,114,120319,114,120371,114,120423,114,120475,114,43847,114,43848,114,7462,114,11397,114,43905,114,119318,82,8475,82,8476,82,8477,82,117991,82,119825,82,119877,82,119929,82,120033,82,120189,82,120241,82,120293,82,120345,82,120397,82,120449,82,422,82,5025,82,5074,82,66740,82,5511,82,42211,82,94005,82,65363,115,119852,115,119904,115,119956,115,120008,115,120060,115,120112,115,120164,115,120216,115,120268,115,120320,115,120372,115,120424,115,120476,115,42801,115,445,115,1109,115,43946,115,71873,115,66632,115,65331,83,117992,83,119826,83,119878,83,119930,83,119982,83,120034,83,120086,83,120138,83,120190,83,120242,83,120294,83,120346,83,120398,83,120450,83,1029,83,1359,83,5077,83,5082,83,42210,83,94010,83,66198,83,66592,83,119853,116,119905,116,119957,116,120009,116,120061,116,120113,116,120165,116,120217,116,120269,116,120321,116,120373,116,120425,116,120477,116,8868,84,10201,84,128872,84,65332,84,117993,84,119827,84,119879,84,119931,84,119983,84,120035,84,120087,84,120139,84,120191,84,120243,84,120295,84,120347,84,120399,84,120451,84,932,84,120507,84,120565,84,120623,84,120681,84,120739,84,11430,84,5026,84,42196,84,93962,84,71868,84,66199,84,66225,84,66325,84,119854,117,119906,117,119958,117,120010,117,120062,117,120114,117,120166,117,120218,117,120270,117,120322,117,120374,117,120426,117,120478,117,42911,117,7452,117,43854,117,43858,117,651,117,965,117,120534,117,120592,117,120650,117,120708,117,120766,117,1405,117,66806,117,71896,117,8746,85,8899,85,117994,85,119828,85,119880,85,119932,85,119984,85,120036,85,120088,85,120140,85,120192,85,120244,85,120296,85,120348,85,120400,85,120452,85,1357,85,4608,85,66766,85,5196,85,42228,85,94018,85,71864,85,8744,118,8897,118,65366,118,8564,118,119855,118,119907,118,119959,118,120011,118,120063,118,120115,118,120167,118,120219,118,120271,118,120323,118,120375,118,120427,118,120479,118,7456,118,957,118,120526,118,120584,118,120642,118,120700,118,120758,118,1141,118,1496,118,71430,118,43945,118,71872,118,119309,86,1639,86,1783,86,8548,86,117995,86,119829,86,119881,86,119933,86,119985,86,120037,86,120089,86,120141,86,120193,86,120245,86,120297,86,120349,86,120401,86,120453,86,1140,86,11576,86,5081,86,5167,86,42719,86,42214,86,93960,86,71840,86,66845,86,623,119,119856,119,119908,119,119960,119,120012,119,120064,119,120116,119,120168,119,120220,119,120272,119,120324,119,120376,119,120428,119,120480,119,7457,119,1121,119,1309,119,1377,119,71434,119,71438,119,71439,119,43907,119,71910,87,71919,87,117996,87,119830,87,119882,87,119934,87,119986,87,120038,87,120090,87,120142,87,120194,87,120246,87,120298,87,120350,87,120402,87,120454,87,1308,87,5043,87,5076,87,42218,87,5742,120,10539,120,10540,120,10799,120,65368,120,8569,120,119857,120,119909,120,119961,120,120013,120,120065,120,120117,120,120169,120,120221,120,120273,120,120325,120,120377,120,120429,120,120481,120,5441,120,5501,120,5741,88,9587,88,66338,88,71916,88,65336,88,8553,88,117997,88,119831,88,119883,88,119935,88,119987,88,120039,88,120091,88,120143,88,120195,88,120247,88,120299,88,120351,88,120403,88,120455,88,42931,88,935,88,120510,88,120568,88,120626,88,120684,88,120742,88,11436,88,11613,88,5815,88,42219,88,66192,88,66228,88,66327,88,66855,88,611,121,7564,121,65369,121,119858,121,119910,121,119962,121,120014,121,120066,121,120118,121,120170,121,120222,121,120274,121,120326,121,120378,121,120430,121,120482,121,655,121,7935,121,43866,121,947,121,8509,121,120516,121,120574,121,120632,121,120690,121,120748,121,1199,121,4327,121,71900,121,65337,89,117998,89,119832,89,119884,89,119936,89,119988,89,120040,89,120092,89,120144,89,120196,89,120248,89,120300,89,120352,89,120404,89,120456,89,933,89,978,89,120508,89,120566,89,120624,89,120682,89,120740,89,11432,89,1198,89,5033,89,5053,89,42220,89,94019,89,71844,89,66226,89,119859,122,119911,122,119963,122,120015,122,120067,122,120119,122,120171,122,120223,122,120275,122,120327,122,120379,122,120431,122,120483,122,7458,122,43923,122,71876,122,71909,90,66293,90,65338,90,8484,90,8488,90,117999,90,119833,90,119885,90,119937,90,119989,90,120041,90,120197,90,120249,90,120301,90,120353,90,120405,90,120457,90,918,90,120493,90,120551,90,120609,90,120667,90,120725,90,5059,90,42204,90,71849,90,65282,34,65283,35,65284,36,65285,37,65286,38,65290,42,65291,43,65294,46,65295,47,65296,48,65298,50,65299,51,65300,52,65301,53,65302,54,65303,55,65304,56,65305,57,65308,60,65309,61,65310,62,65312,64,65316,68,65318,70,65319,71,65324,76,65329,81,65330,82,65333,85,65334,86,65335,87,65343,95,65346,98,65348,100,65350,102,65355,107,65357,109,65358,110,65361,113,65362,114,65364,116,65365,117,65367,119,65370,122,65371,123,65373,125,119846,109],"_default":[160,32,8211,45,65374,126,8218,44,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"cs":[65374,126,8218,44,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"de":[65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"es":[8211,45,65374,126,8218,44,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"fr":[65374,126,8218,44,65306,58,65281,33,8216,96,8245,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"it":[160,32,8211,45,65374,126,8218,44,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"ja":[8211,45,8218,44,65281,33,8216,96,8245,96,180,96,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65292,44,65297,49,65307,59],"ko":[8211,45,65374,126,8218,44,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"pl":[65374,126,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"pt-BR":[65374,126,8218,44,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"qps-ploc":[160,32,8211,45,65374,126,8218,44,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"ru":[65374,126,8218,44,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,305,105,921,73,1009,112,215,120,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"tr":[160,32,8211,45,65374,126,8218,44,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"zh-hans":[160,32,65374,126,8218,44,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65297,49],"zh-hant":[8211,45,65374,126,8218,44,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89]}');
        });
      }
      static {
        this.cache = new LRUCachedFunction({ getCacheKey: JSON.stringify }, (locales) => {
          function arrayToMap(arr) {
            const result = /* @__PURE__ */ new Map();
            for (let i = 0; i < arr.length; i += 2) {
              result.set(arr[i], arr[i + 1]);
            }
            return result;
          }
          function mergeMaps(map1, map2) {
            const result = new Map(map1);
            for (const [key, value] of map2) {
              result.set(key, value);
            }
            return result;
          }
          function intersectMaps(map1, map2) {
            if (!map1) {
              return map2;
            }
            const result = /* @__PURE__ */ new Map();
            for (const [key, value] of map1) {
              if (map2.has(key)) {
                result.set(key, value);
              }
            }
            return result;
          }
          const data = this.ambiguousCharacterData.value;
          let filteredLocales = locales.filter((l) => !l.startsWith("_") && l in data);
          if (filteredLocales.length === 0) {
            filteredLocales = ["_default"];
          }
          let languageSpecificMap = void 0;
          for (const locale of filteredLocales) {
            const map2 = arrayToMap(data[locale]);
            languageSpecificMap = intersectMaps(languageSpecificMap, map2);
          }
          const commonMap = arrayToMap(data["_common"]);
          const map = mergeMaps(commonMap, languageSpecificMap);
          return new _AmbiguousCharacters(map);
        });
      }
      static getInstance(locales) {
        return _AmbiguousCharacters.cache.get(Array.from(locales));
      }
      static {
        this._locales = new Lazy(() => Object.keys(_AmbiguousCharacters.ambiguousCharacterData.value).filter((k) => !k.startsWith("_")));
      }
      static getLocales() {
        return _AmbiguousCharacters._locales.value;
      }
      constructor(confusableDictionary) {
        this.confusableDictionary = confusableDictionary;
      }
      isAmbiguous(codePoint) {
        return this.confusableDictionary.has(codePoint);
      }
      containsAmbiguousCharacter(str) {
        for (let i = 0; i < str.length; i++) {
          const codePoint = str.codePointAt(i);
          if (typeof codePoint === "number" && this.isAmbiguous(codePoint)) {
            return true;
          }
        }
        return false;
      }
      /**
       * Returns the non basic ASCII code point that the given code point can be confused,
       * or undefined if such code point does note exist.
       */
      getPrimaryConfusable(codePoint) {
        return this.confusableDictionary.get(codePoint);
      }
      getConfusableCodePoints() {
        return new Set(this.confusableDictionary.keys());
      }
    };
    InvisibleCharacters = class _InvisibleCharacters {
      static getRawData() {
        return JSON.parse('{"_common":[11,12,13,127,847,1564,4447,4448,6068,6069,6155,6156,6157,6158,7355,7356,8192,8193,8194,8195,8196,8197,8198,8199,8200,8201,8202,8204,8205,8206,8207,8234,8235,8236,8237,8238,8239,8287,8288,8289,8290,8291,8292,8293,8294,8295,8296,8297,8298,8299,8300,8301,8302,8303,10240,12644,65024,65025,65026,65027,65028,65029,65030,65031,65032,65033,65034,65035,65036,65037,65038,65039,65279,65440,65520,65521,65522,65523,65524,65525,65526,65527,65528,65532,78844,119155,119156,119157,119158,119159,119160,119161,119162,917504,917505,917506,917507,917508,917509,917510,917511,917512,917513,917514,917515,917516,917517,917518,917519,917520,917521,917522,917523,917524,917525,917526,917527,917528,917529,917530,917531,917532,917533,917534,917535,917536,917537,917538,917539,917540,917541,917542,917543,917544,917545,917546,917547,917548,917549,917550,917551,917552,917553,917554,917555,917556,917557,917558,917559,917560,917561,917562,917563,917564,917565,917566,917567,917568,917569,917570,917571,917572,917573,917574,917575,917576,917577,917578,917579,917580,917581,917582,917583,917584,917585,917586,917587,917588,917589,917590,917591,917592,917593,917594,917595,917596,917597,917598,917599,917600,917601,917602,917603,917604,917605,917606,917607,917608,917609,917610,917611,917612,917613,917614,917615,917616,917617,917618,917619,917620,917621,917622,917623,917624,917625,917626,917627,917628,917629,917630,917631,917760,917761,917762,917763,917764,917765,917766,917767,917768,917769,917770,917771,917772,917773,917774,917775,917776,917777,917778,917779,917780,917781,917782,917783,917784,917785,917786,917787,917788,917789,917790,917791,917792,917793,917794,917795,917796,917797,917798,917799,917800,917801,917802,917803,917804,917805,917806,917807,917808,917809,917810,917811,917812,917813,917814,917815,917816,917817,917818,917819,917820,917821,917822,917823,917824,917825,917826,917827,917828,917829,917830,917831,917832,917833,917834,917835,917836,917837,917838,917839,917840,917841,917842,917843,917844,917845,917846,917847,917848,917849,917850,917851,917852,917853,917854,917855,917856,917857,917858,917859,917860,917861,917862,917863,917864,917865,917866,917867,917868,917869,917870,917871,917872,917873,917874,917875,917876,917877,917878,917879,917880,917881,917882,917883,917884,917885,917886,917887,917888,917889,917890,917891,917892,917893,917894,917895,917896,917897,917898,917899,917900,917901,917902,917903,917904,917905,917906,917907,917908,917909,917910,917911,917912,917913,917914,917915,917916,917917,917918,917919,917920,917921,917922,917923,917924,917925,917926,917927,917928,917929,917930,917931,917932,917933,917934,917935,917936,917937,917938,917939,917940,917941,917942,917943,917944,917945,917946,917947,917948,917949,917950,917951,917952,917953,917954,917955,917956,917957,917958,917959,917960,917961,917962,917963,917964,917965,917966,917967,917968,917969,917970,917971,917972,917973,917974,917975,917976,917977,917978,917979,917980,917981,917982,917983,917984,917985,917986,917987,917988,917989,917990,917991,917992,917993,917994,917995,917996,917997,917998,917999],"cs":[173,8203,12288],"de":[173,8203,12288],"es":[8203,12288],"fr":[173,8203,12288],"it":[160,173,12288],"ja":[173],"ko":[173,12288],"pl":[173,8203,12288],"pt-BR":[173,8203,12288],"qps-ploc":[160,173,8203,12288],"ru":[173,12288],"tr":[160,173,8203,12288],"zh-hans":[160,173,8203,12288],"zh-hant":[173,12288]}');
      }
      static {
        this._data = void 0;
      }
      static getData() {
        if (!this._data) {
          this._data = new Set([...Object.values(_InvisibleCharacters.getRawData())].flat());
        }
        return this._data;
      }
      static isInvisibleCharacter(codePoint) {
        return _InvisibleCharacters.getData().has(codePoint);
      }
      static containsInvisibleCharacter(str) {
        for (let i = 0; i < str.length; i++) {
          const codePoint = str.codePointAt(i);
          if (typeof codePoint === "number" && (_InvisibleCharacters.isInvisibleCharacter(codePoint) || codePoint === 32)) {
            return true;
          }
        }
        return false;
      }
      static get codePoints() {
        return _InvisibleCharacters.getData();
      }
    };
  }
});

// out-build/vs/base/common/extpath.js
function isPathSeparator2(code2) {
  return code2 === 47 || code2 === 92;
}
function toSlashes(osPath) {
  return osPath.replace(/[\\/]/g, posix.sep);
}
function toPosixPath(osPath) {
  if (osPath.indexOf("/") === -1) {
    osPath = toSlashes(osPath);
  }
  if (/^[a-zA-Z]:(\/|$)/.test(osPath)) {
    osPath = "/" + osPath;
  }
  return osPath;
}
function getRoot(path4, sep2 = posix.sep) {
  if (!path4) {
    return "";
  }
  const len = path4.length;
  const firstLetter = path4.charCodeAt(0);
  if (isPathSeparator2(firstLetter)) {
    if (isPathSeparator2(path4.charCodeAt(1))) {
      if (!isPathSeparator2(path4.charCodeAt(2))) {
        let pos2 = 3;
        const start = pos2;
        for (; pos2 < len; pos2++) {
          if (isPathSeparator2(path4.charCodeAt(pos2))) {
            break;
          }
        }
        if (start !== pos2 && !isPathSeparator2(path4.charCodeAt(pos2 + 1))) {
          pos2 += 1;
          for (; pos2 < len; pos2++) {
            if (isPathSeparator2(path4.charCodeAt(pos2))) {
              return path4.slice(0, pos2 + 1).replace(/[\\/]/g, sep2);
            }
          }
        }
      }
    }
    return sep2;
  } else if (isWindowsDriveLetter(firstLetter)) {
    if (path4.charCodeAt(1) === 58) {
      if (isPathSeparator2(path4.charCodeAt(2))) {
        return path4.slice(0, 2) + sep2;
      } else {
        return path4.slice(0, 2);
      }
    }
  }
  let pos = path4.indexOf("://");
  if (pos !== -1) {
    pos += 3;
    for (; pos < len; pos++) {
      if (isPathSeparator2(path4.charCodeAt(pos))) {
        return path4.slice(0, pos + 1);
      }
    }
  }
  return "";
}
function isUNC(path4) {
  if (!isWindows2) {
    return false;
  }
  if (!path4 || path4.length < 5) {
    return false;
  }
  let code2 = path4.charCodeAt(0);
  if (code2 !== 92) {
    return false;
  }
  code2 = path4.charCodeAt(1);
  if (code2 !== 92) {
    return false;
  }
  let pos = 2;
  const start = pos;
  for (; pos < path4.length; pos++) {
    code2 = path4.charCodeAt(pos);
    if (code2 === 92) {
      break;
    }
  }
  if (start === pos) {
    return false;
  }
  code2 = path4.charCodeAt(pos + 1);
  if (isNaN(code2) || code2 === 92) {
    return false;
  }
  return true;
}
function isValidBasename(name, isWindowsOS = isWindows2) {
  const invalidFileChars = isWindowsOS ? WINDOWS_INVALID_FILE_CHARS : UNIX_INVALID_FILE_CHARS;
  if (!name || name.length === 0 || /^\s+$/.test(name)) {
    return false;
  }
  invalidFileChars.lastIndex = 0;
  if (invalidFileChars.test(name)) {
    return false;
  }
  if (isWindowsOS && WINDOWS_FORBIDDEN_NAMES.test(name)) {
    return false;
  }
  if (name === "." || name === "..") {
    return false;
  }
  if (isWindowsOS && name[name.length - 1] === ".") {
    return false;
  }
  if (isWindowsOS && name.length !== name.trim().length) {
    return false;
  }
  if (name.length > 255) {
    return false;
  }
  return true;
}
function isEqual(pathA, pathB, ignoreCase) {
  const identityEquals = pathA === pathB;
  if (!ignoreCase || identityEquals) {
    return identityEquals;
  }
  if (!pathA || !pathB) {
    return false;
  }
  return equalsIgnoreCase(pathA, pathB);
}
function isEqualOrParent(base, parentCandidate, ignoreCase, separator = sep) {
  if (base === parentCandidate) {
    return true;
  }
  if (!base || !parentCandidate) {
    return false;
  }
  if (parentCandidate.length > base.length) {
    return false;
  }
  if (ignoreCase) {
    const beginsWith = startsWithIgnoreCase(base, parentCandidate);
    if (!beginsWith) {
      return false;
    }
    if (parentCandidate.length === base.length) {
      return true;
    }
    let sepOffset = parentCandidate.length;
    if (parentCandidate.charAt(parentCandidate.length - 1) === separator) {
      sepOffset--;
    }
    return base.charAt(sepOffset) === separator;
  }
  if (parentCandidate.charAt(parentCandidate.length - 1) !== separator) {
    parentCandidate += separator;
  }
  return base.indexOf(parentCandidate) === 0;
}
function isWindowsDriveLetter(char0) {
  return char0 >= 65 && char0 <= 90 || char0 >= 97 && char0 <= 122;
}
function sanitizeFilePath(candidate, cwd3) {
  if (isWindows2 && candidate.endsWith(":")) {
    candidate += sep;
  }
  if (!isAbsolute2(candidate)) {
    candidate = join3(cwd3, candidate);
  }
  candidate = normalize(candidate);
  return removeTrailingPathSeparator(candidate);
}
function removeTrailingPathSeparator(candidate) {
  if (isWindows2) {
    candidate = rtrim(candidate, sep);
    if (candidate.endsWith(":")) {
      candidate += sep;
    }
  } else {
    candidate = rtrim(candidate, sep);
    if (!candidate) {
      candidate = sep;
    }
  }
  return candidate;
}
function isRootOrDriveLetter(path4) {
  const pathNormalized = normalize(path4);
  if (isWindows2) {
    if (path4.length > 3) {
      return false;
    }
    return hasDriveLetter(pathNormalized) && (path4.length === 2 || pathNormalized.charCodeAt(2) === 92);
  }
  return pathNormalized === posix.sep;
}
function hasDriveLetter(path4, isWindowsOS = isWindows2) {
  if (isWindowsOS) {
    return isWindowsDriveLetter(path4.charCodeAt(0)) && path4.charCodeAt(1) === 58;
  }
  return false;
}
function parseLineAndColumnAware(rawPath) {
  const segments = rawPath.split(":");
  let path4 = void 0;
  let line = void 0;
  let column = void 0;
  for (const segment of segments) {
    const segmentAsNumber = Number(segment);
    if (!isNumber(segmentAsNumber)) {
      path4 = !!path4 ? [path4, segment].join(":") : segment;
    } else if (line === void 0) {
      line = segmentAsNumber;
    } else if (column === void 0) {
      column = segmentAsNumber;
    }
  }
  if (!path4) {
    throw new Error("Format for `--goto` should be: `FILE:LINE(:COLUMN)`");
  }
  return {
    path: path4,
    line: line !== void 0 ? line : void 0,
    column: column !== void 0 ? column : line !== void 0 ? 1 : void 0
    // if we have a line, make sure column is also set
  };
}
function randomPath(parent, prefix, randomLength = 8) {
  let suffix = "";
  for (let i = 0; i < randomLength; i++) {
    let pathCharsTouse;
    if (i === 0 && isWindows2 && !prefix && (randomLength === 3 || randomLength === 4)) {
      pathCharsTouse = windowsSafePathFirstChars;
    } else {
      pathCharsTouse = pathChars;
    }
    suffix += pathCharsTouse.charAt(Math.floor(Math.random() * pathCharsTouse.length));
  }
  let randomFileName;
  if (prefix) {
    randomFileName = `${prefix}-${suffix}`;
  } else {
    randomFileName = suffix;
  }
  if (parent) {
    return join3(parent, randomFileName);
  }
  return randomFileName;
}
var WINDOWS_INVALID_FILE_CHARS, UNIX_INVALID_FILE_CHARS, WINDOWS_FORBIDDEN_NAMES, pathChars, windowsSafePathFirstChars;
var init_extpath = __esm({
  "out-build/vs/base/common/extpath.js"() {
    "use strict";
    init_path();
    init_platform();
    init_strings();
    init_types();
    WINDOWS_INVALID_FILE_CHARS = /[\\/:\*\?"<>\|]/g;
    UNIX_INVALID_FILE_CHARS = /[/]/g;
    WINDOWS_FORBIDDEN_NAMES = /^(con|prn|aux|clock\$|nul|lpt[0-9]|com[0-9])(\.(.*?))?$/i;
    pathChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    windowsSafePathFirstChars = "BDEFGHIJKMOQRSTUVWXYZbdefghijkmoqrstuvwxyz0123456789";
  }
});

// out-build/vs/base/common/uri.js
function _validateUri(ret, _strict) {
  if (!ret.scheme && _strict) {
    throw new Error(`[UriError]: Scheme is missing: {scheme: "", authority: "${ret.authority}", path: "${ret.path}", query: "${ret.query}", fragment: "${ret.fragment}"}`);
  }
  if (ret.scheme && !_schemePattern.test(ret.scheme)) {
    throw new Error("[UriError]: Scheme contains illegal characters.");
  }
  if (ret.path) {
    if (ret.authority) {
      if (!_singleSlashStart.test(ret.path)) {
        throw new Error('[UriError]: If a URI contains an authority component, then the path component must either be empty or begin with a slash ("/") character');
      }
    } else {
      if (_doubleSlashStart.test(ret.path)) {
        throw new Error('[UriError]: If a URI does not contain an authority component, then the path cannot begin with two slash characters ("//")');
      }
    }
  }
}
function _schemeFix(scheme, _strict) {
  if (!scheme && !_strict) {
    return "file";
  }
  return scheme;
}
function _referenceResolution(scheme, path4) {
  switch (scheme) {
    case "https":
    case "http":
    case "file":
      if (!path4) {
        path4 = _slash;
      } else if (path4[0] !== _slash) {
        path4 = _slash + path4;
      }
      break;
  }
  return path4;
}
function encodeURIComponentFast(uriComponent, isPath, isAuthority) {
  let res = void 0;
  let nativeEncodePos = -1;
  for (let pos = 0; pos < uriComponent.length; pos++) {
    const code2 = uriComponent.charCodeAt(pos);
    if (code2 >= 97 && code2 <= 122 || code2 >= 65 && code2 <= 90 || code2 >= 48 && code2 <= 57 || code2 === 45 || code2 === 46 || code2 === 95 || code2 === 126 || isPath && code2 === 47 || isAuthority && code2 === 91 || isAuthority && code2 === 93 || isAuthority && code2 === 58) {
      if (nativeEncodePos !== -1) {
        res += encodeURIComponent(uriComponent.substring(nativeEncodePos, pos));
        nativeEncodePos = -1;
      }
      if (res !== void 0) {
        res += uriComponent.charAt(pos);
      }
    } else {
      if (res === void 0) {
        res = uriComponent.substr(0, pos);
      }
      const escaped = encodeTable[code2];
      if (escaped !== void 0) {
        if (nativeEncodePos !== -1) {
          res += encodeURIComponent(uriComponent.substring(nativeEncodePos, pos));
          nativeEncodePos = -1;
        }
        res += escaped;
      } else if (nativeEncodePos === -1) {
        nativeEncodePos = pos;
      }
    }
  }
  if (nativeEncodePos !== -1) {
    res += encodeURIComponent(uriComponent.substring(nativeEncodePos));
  }
  return res !== void 0 ? res : uriComponent;
}
function encodeURIComponentMinimal(path4) {
  let res = void 0;
  for (let pos = 0; pos < path4.length; pos++) {
    const code2 = path4.charCodeAt(pos);
    if (code2 === 35 || code2 === 63) {
      if (res === void 0) {
        res = path4.substr(0, pos);
      }
      res += encodeTable[code2];
    } else {
      if (res !== void 0) {
        res += path4[pos];
      }
    }
  }
  return res !== void 0 ? res : path4;
}
function uriToFsPath(uri, keepDriveLetterCasing) {
  let value;
  if (uri.authority && uri.path.length > 1 && uri.scheme === "file") {
    value = `//${uri.authority}${uri.path}`;
  } else if (uri.path.charCodeAt(0) === 47 && (uri.path.charCodeAt(1) >= 65 && uri.path.charCodeAt(1) <= 90 || uri.path.charCodeAt(1) >= 97 && uri.path.charCodeAt(1) <= 122) && uri.path.charCodeAt(2) === 58) {
    if (!keepDriveLetterCasing) {
      value = uri.path[1].toLowerCase() + uri.path.substr(2);
    } else {
      value = uri.path.substr(1);
    }
  } else {
    value = uri.path;
  }
  if (isWindows2) {
    value = value.replace(/\//g, "\\");
  }
  return value;
}
function _asFormatted(uri, skipEncoding) {
  const encoder = !skipEncoding ? encodeURIComponentFast : encodeURIComponentMinimal;
  let res = "";
  let { scheme, authority, path: path4, query, fragment } = uri;
  if (scheme) {
    res += scheme;
    res += ":";
  }
  if (authority || scheme === "file") {
    res += _slash;
    res += _slash;
  }
  if (authority) {
    let idx = authority.indexOf("@");
    if (idx !== -1) {
      const userinfo = authority.substr(0, idx);
      authority = authority.substr(idx + 1);
      idx = userinfo.lastIndexOf(":");
      if (idx === -1) {
        res += encoder(userinfo, false, false);
      } else {
        res += encoder(userinfo.substr(0, idx), false, false);
        res += ":";
        res += encoder(userinfo.substr(idx + 1), false, true);
      }
      res += "@";
    }
    authority = authority.toLowerCase();
    idx = authority.lastIndexOf(":");
    if (idx === -1) {
      res += encoder(authority, false, true);
    } else {
      res += encoder(authority.substr(0, idx), false, true);
      res += authority.substr(idx);
    }
  }
  if (path4) {
    if (path4.length >= 3 && path4.charCodeAt(0) === 47 && path4.charCodeAt(2) === 58) {
      const code2 = path4.charCodeAt(1);
      if (code2 >= 65 && code2 <= 90) {
        path4 = `/${String.fromCharCode(code2 + 32)}:${path4.substr(3)}`;
      }
    } else if (path4.length >= 2 && path4.charCodeAt(1) === 58) {
      const code2 = path4.charCodeAt(0);
      if (code2 >= 65 && code2 <= 90) {
        path4 = `${String.fromCharCode(code2 + 32)}:${path4.substr(2)}`;
      }
    }
    res += encoder(path4, true, false);
  }
  if (query) {
    res += "?";
    res += encoder(query, false, false);
  }
  if (fragment) {
    res += "#";
    res += !skipEncoding ? encodeURIComponentFast(fragment, false, false) : fragment;
  }
  return res;
}
function decodeURIComponentGraceful(str) {
  try {
    return decodeURIComponent(str);
  } catch {
    if (str.length > 3) {
      return str.substr(0, 3) + decodeURIComponentGraceful(str.substr(3));
    } else {
      return str;
    }
  }
}
function percentDecode(str) {
  if (!str.match(_rEncodedAsHex)) {
    return str;
  }
  return str.replace(_rEncodedAsHex, (match) => decodeURIComponentGraceful(match));
}
var _schemePattern, _singleSlashStart, _doubleSlashStart, _empty, _slash, _regexp, URI, _pathSepMarker, Uri, encodeTable, _rEncodedAsHex;
var init_uri = __esm({
  "out-build/vs/base/common/uri.js"() {
    "use strict";
    init_path();
    init_platform();
    _schemePattern = /^\w[\w\d+.-]*$/;
    _singleSlashStart = /^\//;
    _doubleSlashStart = /^\/\//;
    _empty = "";
    _slash = "/";
    _regexp = /^(([^:/?#]+?):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/;
    URI = class _URI {
      static isUri(thing) {
        if (thing instanceof _URI) {
          return true;
        }
        if (!thing || typeof thing !== "object") {
          return false;
        }
        return typeof thing.authority === "string" && typeof thing.fragment === "string" && typeof thing.path === "string" && typeof thing.query === "string" && typeof thing.scheme === "string" && typeof thing.fsPath === "string" && typeof thing.with === "function" && typeof thing.toString === "function";
      }
      /**
       * @internal
       */
      constructor(schemeOrData, authority, path4, query, fragment, _strict = false) {
        if (typeof schemeOrData === "object") {
          this.scheme = schemeOrData.scheme || _empty;
          this.authority = schemeOrData.authority || _empty;
          this.path = schemeOrData.path || _empty;
          this.query = schemeOrData.query || _empty;
          this.fragment = schemeOrData.fragment || _empty;
        } else {
          this.scheme = _schemeFix(schemeOrData, _strict);
          this.authority = authority || _empty;
          this.path = _referenceResolution(this.scheme, path4 || _empty);
          this.query = query || _empty;
          this.fragment = fragment || _empty;
          _validateUri(this, _strict);
        }
      }
      // ---- filesystem path -----------------------
      /**
       * Returns a string representing the corresponding file system path of this URI.
       * Will handle UNC paths, normalizes windows drive letters to lower-case, and uses the
       * platform specific path separator.
       *
       * * Will *not* validate the path for invalid characters and semantics.
       * * Will *not* look at the scheme of this URI.
       * * The result shall *not* be used for display purposes but for accessing a file on disk.
       *
       *
       * The *difference* to `URI#path` is the use of the platform specific separator and the handling
       * of UNC paths. See the below sample of a file-uri with an authority (UNC path).
       *
       * ```ts
          const u = URI.parse('file://server/c$/folder/file.txt')
          u.authority === 'server'
          u.path === '/shares/c$/file.txt'
          u.fsPath === '\\server\c$\folder\file.txt'
      ```
       *
       * Using `URI#path` to read a file (using fs-apis) would not be enough because parts of the path,
       * namely the server name, would be missing. Therefore `URI#fsPath` exists - it's sugar to ease working
       * with URIs that represent files on disk (`file` scheme).
       */
      get fsPath() {
        return uriToFsPath(this, false);
      }
      // ---- modify to new -------------------------
      with(change) {
        if (!change) {
          return this;
        }
        let { scheme, authority, path: path4, query, fragment } = change;
        if (scheme === void 0) {
          scheme = this.scheme;
        } else if (scheme === null) {
          scheme = _empty;
        }
        if (authority === void 0) {
          authority = this.authority;
        } else if (authority === null) {
          authority = _empty;
        }
        if (path4 === void 0) {
          path4 = this.path;
        } else if (path4 === null) {
          path4 = _empty;
        }
        if (query === void 0) {
          query = this.query;
        } else if (query === null) {
          query = _empty;
        }
        if (fragment === void 0) {
          fragment = this.fragment;
        } else if (fragment === null) {
          fragment = _empty;
        }
        if (scheme === this.scheme && authority === this.authority && path4 === this.path && query === this.query && fragment === this.fragment) {
          return this;
        }
        return new Uri(scheme, authority, path4, query, fragment);
      }
      // ---- parse & validate ------------------------
      /**
       * Creates a new URI from a string, e.g. `http://www.example.com/some/path`,
       * `file:///usr/home`, or `scheme:with/path`.
       *
       * @param value A string which represents an URI (see `URI#toString`).
       */
      static parse(value, _strict = false) {
        const match = _regexp.exec(value);
        if (!match) {
          return new Uri(_empty, _empty, _empty, _empty, _empty);
        }
        return new Uri(match[2] || _empty, percentDecode(match[4] || _empty), percentDecode(match[5] || _empty), percentDecode(match[7] || _empty), percentDecode(match[9] || _empty), _strict);
      }
      /**
       * Creates a new URI from a file system path, e.g. `c:\my\files`,
       * `/usr/home`, or `\\server\share\some\path`.
       *
       * The *difference* between `URI#parse` and `URI#file` is that the latter treats the argument
       * as path, not as stringified-uri. E.g. `URI.file(path)` is **not the same as**
       * `URI.parse('file://' + path)` because the path might contain characters that are
       * interpreted (# and ?). See the following sample:
       * ```ts
      const good = URI.file('/coding/c#/project1');
      good.scheme === 'file';
      good.path === '/coding/c#/project1';
      good.fragment === '';
      const bad = URI.parse('file://' + '/coding/c#/project1');
      bad.scheme === 'file';
      bad.path === '/coding/c'; // path is now broken
      bad.fragment === '/project1';
      ```
       *
       * @param path A file system path (see `URI#fsPath`)
       */
      static file(path4) {
        let authority = _empty;
        if (isWindows2) {
          path4 = path4.replace(/\\/g, _slash);
        }
        if (path4[0] === _slash && path4[1] === _slash) {
          const idx = path4.indexOf(_slash, 2);
          if (idx === -1) {
            authority = path4.substring(2);
            path4 = _slash;
          } else {
            authority = path4.substring(2, idx);
            path4 = path4.substring(idx) || _slash;
          }
        }
        return new Uri("file", authority, path4, _empty, _empty);
      }
      /**
       * Creates new URI from uri components.
       *
       * Unless `strict` is `true` the scheme is defaults to be `file`. This function performs
       * validation and should be used for untrusted uri components retrieved from storage,
       * user input, command arguments etc
       */
      static from(components, strict) {
        const result = new Uri(components.scheme, components.authority, components.path, components.query, components.fragment, strict);
        return result;
      }
      /**
       * Join a URI path with path fragments and normalizes the resulting path.
       *
       * @param uri The input URI.
       * @param pathFragment The path fragment to add to the URI path.
       * @returns The resulting URI.
       */
      static joinPath(uri, ...pathFragment) {
        if (!uri.path) {
          throw new Error(`[UriError]: cannot call joinPath on URI without path`);
        }
        let newPath;
        if (isWindows2 && uri.scheme === "file") {
          newPath = _URI.file(win32.join(uriToFsPath(uri, true), ...pathFragment)).path;
        } else {
          newPath = posix.join(uri.path, ...pathFragment);
        }
        return uri.with({ path: newPath });
      }
      // ---- printing/externalize ---------------------------
      /**
       * Creates a string representation for this URI. It's guaranteed that calling
       * `URI.parse` with the result of this function creates an URI which is equal
       * to this URI.
       *
       * * The result shall *not* be used for display purposes but for externalization or transport.
       * * The result will be encoded using the percentage encoding and encoding happens mostly
       * ignore the scheme-specific encoding rules.
       *
       * @param skipEncoding Do not encode the result, default is `false`
       */
      toString(skipEncoding = false) {
        return _asFormatted(this, skipEncoding);
      }
      toJSON() {
        return this;
      }
      static revive(data) {
        if (!data) {
          return data;
        } else if (data instanceof _URI) {
          return data;
        } else {
          const result = new Uri(data);
          result._formatted = data.external ?? null;
          result._fsPath = data._sep === _pathSepMarker ? data.fsPath ?? null : null;
          return result;
        }
      }
      [Symbol.for("debug.description")]() {
        return `URI(${this.toString()})`;
      }
    };
    _pathSepMarker = isWindows2 ? 1 : void 0;
    Uri = class extends URI {
      constructor() {
        super(...arguments);
        this._formatted = null;
        this._fsPath = null;
      }
      get fsPath() {
        if (!this._fsPath) {
          this._fsPath = uriToFsPath(this, false);
        }
        return this._fsPath;
      }
      toString(skipEncoding = false) {
        if (!skipEncoding) {
          if (!this._formatted) {
            this._formatted = _asFormatted(this, false);
          }
          return this._formatted;
        } else {
          return _asFormatted(this, true);
        }
      }
      toJSON() {
        const res = {
          $mid: 1
          /* MarshalledId.Uri */
        };
        if (this._fsPath) {
          res.fsPath = this._fsPath;
          res._sep = _pathSepMarker;
        }
        if (this._formatted) {
          res.external = this._formatted;
        }
        if (this.path) {
          res.path = this.path;
        }
        if (this.scheme) {
          res.scheme = this.scheme;
        }
        if (this.authority) {
          res.authority = this.authority;
        }
        if (this.query) {
          res.query = this.query;
        }
        if (this.fragment) {
          res.fragment = this.fragment;
        }
        return res;
      }
    };
    encodeTable = {
      [
        58
        /* CharCode.Colon */
      ]: "%3A",
      // gen-delims
      [
        47
        /* CharCode.Slash */
      ]: "%2F",
      [
        63
        /* CharCode.QuestionMark */
      ]: "%3F",
      [
        35
        /* CharCode.Hash */
      ]: "%23",
      [
        91
        /* CharCode.OpenSquareBracket */
      ]: "%5B",
      [
        93
        /* CharCode.CloseSquareBracket */
      ]: "%5D",
      [
        64
        /* CharCode.AtSign */
      ]: "%40",
      [
        33
        /* CharCode.ExclamationMark */
      ]: "%21",
      // sub-delims
      [
        36
        /* CharCode.DollarSign */
      ]: "%24",
      [
        38
        /* CharCode.Ampersand */
      ]: "%26",
      [
        39
        /* CharCode.SingleQuote */
      ]: "%27",
      [
        40
        /* CharCode.OpenParen */
      ]: "%28",
      [
        41
        /* CharCode.CloseParen */
      ]: "%29",
      [
        42
        /* CharCode.Asterisk */
      ]: "%2A",
      [
        43
        /* CharCode.Plus */
      ]: "%2B",
      [
        44
        /* CharCode.Comma */
      ]: "%2C",
      [
        59
        /* CharCode.Semicolon */
      ]: "%3B",
      [
        61
        /* CharCode.Equals */
      ]: "%3D",
      [
        32
        /* CharCode.Space */
      ]: "%20"
    };
    _rEncodedAsHex = /(%[0-9A-Za-z][0-9A-Za-z])+/g;
  }
});

// out-build/vs/base/common/network.js
function matchesScheme(target, scheme) {
  if (URI.isUri(target)) {
    return equalsIgnoreCase(target.scheme, scheme);
  } else {
    return startsWithIgnoreCase(target, scheme + ":");
  }
}
function matchesSomeScheme(target, ...schemes) {
  return schemes.some((scheme) => matchesScheme(target, scheme));
}
function getServerProductSegment(product3) {
  return `${product3.quality ?? "oss"}-${product3.commit ?? "dev"}`;
}
var Schemas, connectionTokenQueryName, RemoteAuthoritiesImpl, RemoteAuthorities, VSCODE_AUTHORITY, FileAccessImpl, FileAccess, CacheControlheaders, DocumentPolicyheaders, COI;
var init_network = __esm({
  "out-build/vs/base/common/network.js"() {
    "use strict";
    init_errors();
    init_platform();
    init_strings();
    init_uri();
    init_path();
    (function(Schemas2) {
      Schemas2.inMemory = "inmemory";
      Schemas2.vscode = "vscode";
      Schemas2.internal = "private";
      Schemas2.walkThrough = "walkThrough";
      Schemas2.walkThroughSnippet = "walkThroughSnippet";
      Schemas2.http = "http";
      Schemas2.https = "https";
      Schemas2.file = "file";
      Schemas2.mailto = "mailto";
      Schemas2.untitled = "untitled";
      Schemas2.data = "data";
      Schemas2.command = "command";
      Schemas2.vscodeRemote = "vscode-remote";
      Schemas2.vscodeRemoteResource = "vscode-remote-resource";
      Schemas2.vscodeManagedRemoteResource = "vscode-managed-remote-resource";
      Schemas2.vscodeUserData = "vscode-userdata";
      Schemas2.vscodeCustomEditor = "vscode-custom-editor";
      Schemas2.vscodeNotebookCell = "vscode-notebook-cell";
      Schemas2.vscodeNotebookCellMetadata = "vscode-notebook-cell-metadata";
      Schemas2.vscodeNotebookCellMetadataDiff = "vscode-notebook-cell-metadata-diff";
      Schemas2.vscodeNotebookCellOutput = "vscode-notebook-cell-output";
      Schemas2.vscodeNotebookCellOutputDiff = "vscode-notebook-cell-output-diff";
      Schemas2.vscodeNotebookMetadata = "vscode-notebook-metadata";
      Schemas2.vscodeInteractiveInput = "vscode-interactive-input";
      Schemas2.vscodeSettings = "vscode-settings";
      Schemas2.vscodeWorkspaceTrust = "vscode-workspace-trust";
      Schemas2.vscodeTerminal = "vscode-terminal";
      Schemas2.vscodeChatCodeBlock = "vscode-chat-code-block";
      Schemas2.vscodeChatCodeCompareBlock = "vscode-chat-code-compare-block";
      Schemas2.vscodeChatSesssion = "vscode-chat-editor";
      Schemas2.webviewPanel = "webview-panel";
      Schemas2.vscodeWebview = "vscode-webview";
      Schemas2.extension = "extension";
      Schemas2.vscodeFileResource = "vscode-file";
      Schemas2.tmp = "tmp";
      Schemas2.vsls = "vsls";
      Schemas2.vscodeSourceControl = "vscode-scm";
      Schemas2.commentsInput = "comment";
      Schemas2.codeSetting = "code-setting";
      Schemas2.outputChannel = "output";
      Schemas2.accessibleView = "accessible-view";
    })(Schemas || (Schemas = {}));
    connectionTokenQueryName = "tkn";
    RemoteAuthoritiesImpl = class {
      constructor() {
        this._hosts = /* @__PURE__ */ Object.create(null);
        this._ports = /* @__PURE__ */ Object.create(null);
        this._connectionTokens = /* @__PURE__ */ Object.create(null);
        this._preferredWebSchema = "http";
        this._delegate = null;
        this._serverRootPath = "/";
      }
      setPreferredWebSchema(schema) {
        this._preferredWebSchema = schema;
      }
      setDelegate(delegate) {
        this._delegate = delegate;
      }
      setServerRootPath(product3, serverBasePath) {
        this._serverRootPath = posix.join(serverBasePath ?? "/", getServerProductSegment(product3));
      }
      getServerRootPath() {
        return this._serverRootPath;
      }
      get _remoteResourcesPath() {
        return posix.join(this._serverRootPath, Schemas.vscodeRemoteResource);
      }
      set(authority, host, port) {
        this._hosts[authority] = host;
        this._ports[authority] = port;
      }
      setConnectionToken(authority, connectionToken) {
        this._connectionTokens[authority] = connectionToken;
      }
      getPreferredWebSchema() {
        return this._preferredWebSchema;
      }
      rewrite(uri) {
        if (this._delegate) {
          try {
            return this._delegate(uri);
          } catch (err) {
            onUnexpectedError(err);
            return uri;
          }
        }
        const authority = uri.authority;
        let host = this._hosts[authority];
        if (host && host.indexOf(":") !== -1 && host.indexOf("[") === -1) {
          host = `[${host}]`;
        }
        const port = this._ports[authority];
        const connectionToken = this._connectionTokens[authority];
        let query = `path=${encodeURIComponent(uri.path)}`;
        if (typeof connectionToken === "string") {
          query += `&${connectionTokenQueryName}=${encodeURIComponent(connectionToken)}`;
        }
        return URI.from({
          scheme: isWeb ? this._preferredWebSchema : Schemas.vscodeRemoteResource,
          authority: `${host}:${port}`,
          path: this._remoteResourcesPath,
          query
        });
      }
    };
    RemoteAuthorities = new RemoteAuthoritiesImpl();
    VSCODE_AUTHORITY = "vscode-app";
    FileAccessImpl = class _FileAccessImpl {
      static {
        this.FALLBACK_AUTHORITY = VSCODE_AUTHORITY;
      }
      /**
       * Returns a URI to use in contexts where the browser is responsible
       * for loading (e.g. fetch()) or when used within the DOM.
       *
       * **Note:** use `dom.ts#asCSSUrl` whenever the URL is to be used in CSS context.
       */
      asBrowserUri(resourcePath) {
        const uri = this.toUri(resourcePath);
        return this.uriToBrowserUri(uri);
      }
      /**
       * Returns a URI to use in contexts where the browser is responsible
       * for loading (e.g. fetch()) or when used within the DOM.
       *
       * **Note:** use `dom.ts#asCSSUrl` whenever the URL is to be used in CSS context.
       */
      uriToBrowserUri(uri) {
        if (uri.scheme === Schemas.vscodeRemote) {
          return RemoteAuthorities.rewrite(uri);
        }
        if (
          // ...only ever for `file` resources
          uri.scheme === Schemas.file && // ...and we run in native environments
          (isNative || // ...or web worker extensions on desktop
          webWorkerOrigin === `${Schemas.vscodeFileResource}://${_FileAccessImpl.FALLBACK_AUTHORITY}`)
        ) {
          return uri.with({
            scheme: Schemas.vscodeFileResource,
            // We need to provide an authority here so that it can serve
            // as origin for network and loading matters in chromium.
            // If the URI is not coming with an authority already, we
            // add our own
            authority: uri.authority || _FileAccessImpl.FALLBACK_AUTHORITY,
            query: null,
            fragment: null
          });
        }
        return uri;
      }
      /**
       * Returns the `file` URI to use in contexts where node.js
       * is responsible for loading.
       */
      asFileUri(resourcePath) {
        const uri = this.toUri(resourcePath);
        return this.uriToFileUri(uri);
      }
      /**
       * Returns the `file` URI to use in contexts where node.js
       * is responsible for loading.
       */
      uriToFileUri(uri) {
        if (uri.scheme === Schemas.vscodeFileResource) {
          return uri.with({
            scheme: Schemas.file,
            // Only preserve the `authority` if it is different from
            // our fallback authority. This ensures we properly preserve
            // Windows UNC paths that come with their own authority.
            authority: uri.authority !== _FileAccessImpl.FALLBACK_AUTHORITY ? uri.authority : null,
            query: null,
            fragment: null
          });
        }
        return uri;
      }
      toUri(uriOrModule) {
        if (URI.isUri(uriOrModule)) {
          return uriOrModule;
        }
        if (globalThis._VSCODE_FILE_ROOT) {
          const rootUriOrPath = globalThis._VSCODE_FILE_ROOT;
          if (/^\w[\w\d+.-]*:\/\//.test(rootUriOrPath)) {
            return URI.joinPath(URI.parse(rootUriOrPath, true), uriOrModule);
          }
          const modulePath = join3(rootUriOrPath, uriOrModule);
          return URI.file(modulePath);
        }
        throw new Error("Cannot determine URI for module id!");
      }
    };
    FileAccess = new FileAccessImpl();
    CacheControlheaders = Object.freeze({
      "Cache-Control": "no-cache, no-store"
    });
    DocumentPolicyheaders = Object.freeze({
      "Document-Policy": "include-js-call-stacks-in-crash-reports"
    });
    (function(COI2) {
      const coiHeaders = /* @__PURE__ */ new Map([
        ["1", { "Cross-Origin-Opener-Policy": "same-origin" }],
        ["2", { "Cross-Origin-Embedder-Policy": "require-corp" }],
        ["3", { "Cross-Origin-Opener-Policy": "same-origin", "Cross-Origin-Embedder-Policy": "require-corp" }]
      ]);
      COI2.CoopAndCoep = Object.freeze(coiHeaders.get("3"));
      const coiSearchParamName = "vscode-coi";
      function getHeadersFromQuery(url) {
        let params;
        if (typeof url === "string") {
          params = new URL(url).searchParams;
        } else if (url instanceof URL) {
          params = url.searchParams;
        } else if (URI.isUri(url)) {
          params = new URL(url.toString(true)).searchParams;
        }
        const value = params?.get(coiSearchParamName);
        if (!value) {
          return void 0;
        }
        return coiHeaders.get(value);
      }
      COI2.getHeadersFromQuery = getHeadersFromQuery;
      function addSearchParam(urlOrSearch, coop, coep) {
        if (!globalThis.crossOriginIsolated) {
          return;
        }
        const value = coop && coep ? "3" : coep ? "2" : "1";
        if (urlOrSearch instanceof URLSearchParams) {
          urlOrSearch.set(coiSearchParamName, value);
        } else {
          urlOrSearch[coiSearchParamName] = value;
        }
      }
      COI2.addSearchParam = addSearchParam;
    })(COI || (COI = {}));
  }
});

// out-build/vs/base/common/resources.js
function originalFSPath(uri) {
  return uriToFsPath(uri, true);
}
var ExtUri, extUri, extUriBiasedIgnorePathCase, extUriIgnorePathCase, isEqual2, isEqualOrParent2, getComparisonKey, basenameOrAuthority, basename2, extname2, dirname4, joinPath, normalizePath, relativePath, resolvePath, isAbsolutePath, isEqualAuthority, hasTrailingPathSeparator, removeTrailingPathSeparator2, addTrailingPathSeparator, DataUri;
var init_resources = __esm({
  "out-build/vs/base/common/resources.js"() {
    "use strict";
    init_extpath();
    init_network();
    init_path();
    init_platform();
    init_strings();
    init_uri();
    ExtUri = class {
      constructor(_ignorePathCasing) {
        this._ignorePathCasing = _ignorePathCasing;
      }
      compare(uri1, uri2, ignoreFragment = false) {
        if (uri1 === uri2) {
          return 0;
        }
        return compare(this.getComparisonKey(uri1, ignoreFragment), this.getComparisonKey(uri2, ignoreFragment));
      }
      isEqual(uri1, uri2, ignoreFragment = false) {
        if (uri1 === uri2) {
          return true;
        }
        if (!uri1 || !uri2) {
          return false;
        }
        return this.getComparisonKey(uri1, ignoreFragment) === this.getComparisonKey(uri2, ignoreFragment);
      }
      getComparisonKey(uri, ignoreFragment = false) {
        return uri.with({
          path: this._ignorePathCasing(uri) ? uri.path.toLowerCase() : void 0,
          fragment: ignoreFragment ? null : void 0
        }).toString();
      }
      ignorePathCasing(uri) {
        return this._ignorePathCasing(uri);
      }
      isEqualOrParent(base, parentCandidate, ignoreFragment = false) {
        if (base.scheme === parentCandidate.scheme) {
          if (base.scheme === Schemas.file) {
            return isEqualOrParent(originalFSPath(base), originalFSPath(parentCandidate), this._ignorePathCasing(base)) && base.query === parentCandidate.query && (ignoreFragment || base.fragment === parentCandidate.fragment);
          }
          if (isEqualAuthority(base.authority, parentCandidate.authority)) {
            return isEqualOrParent(base.path, parentCandidate.path, this._ignorePathCasing(base), "/") && base.query === parentCandidate.query && (ignoreFragment || base.fragment === parentCandidate.fragment);
          }
        }
        return false;
      }
      // --- path math
      joinPath(resource, ...pathFragment) {
        return URI.joinPath(resource, ...pathFragment);
      }
      basenameOrAuthority(resource) {
        return basename2(resource) || resource.authority;
      }
      basename(resource) {
        return posix.basename(resource.path);
      }
      extname(resource) {
        return posix.extname(resource.path);
      }
      dirname(resource) {
        if (resource.path.length === 0) {
          return resource;
        }
        let dirname6;
        if (resource.scheme === Schemas.file) {
          dirname6 = URI.file(dirname3(originalFSPath(resource))).path;
        } else {
          dirname6 = posix.dirname(resource.path);
          if (resource.authority && dirname6.length && dirname6.charCodeAt(0) !== 47) {
            console.error(`dirname("${resource.toString})) resulted in a relative path`);
            dirname6 = "/";
          }
        }
        return resource.with({
          path: dirname6
        });
      }
      normalizePath(resource) {
        if (!resource.path.length) {
          return resource;
        }
        let normalizedPath;
        if (resource.scheme === Schemas.file) {
          normalizedPath = URI.file(normalize(originalFSPath(resource))).path;
        } else {
          normalizedPath = posix.normalize(resource.path);
        }
        return resource.with({
          path: normalizedPath
        });
      }
      relativePath(from, to) {
        if (from.scheme !== to.scheme || !isEqualAuthority(from.authority, to.authority)) {
          return void 0;
        }
        if (from.scheme === Schemas.file) {
          const relativePath2 = relative2(originalFSPath(from), originalFSPath(to));
          return isWindows2 ? toSlashes(relativePath2) : relativePath2;
        }
        let fromPath = from.path || "/";
        const toPath = to.path || "/";
        if (this._ignorePathCasing(from)) {
          let i = 0;
          for (const len = Math.min(fromPath.length, toPath.length); i < len; i++) {
            if (fromPath.charCodeAt(i) !== toPath.charCodeAt(i)) {
              if (fromPath.charAt(i).toLowerCase() !== toPath.charAt(i).toLowerCase()) {
                break;
              }
            }
          }
          fromPath = toPath.substr(0, i) + fromPath.substr(i);
        }
        return posix.relative(fromPath, toPath);
      }
      resolvePath(base, path4) {
        if (base.scheme === Schemas.file) {
          const newURI = URI.file(resolve2(originalFSPath(base), path4));
          return base.with({
            authority: newURI.authority,
            path: newURI.path
          });
        }
        path4 = toPosixPath(path4);
        return base.with({
          path: posix.resolve(base.path, path4)
        });
      }
      // --- misc
      isAbsolutePath(resource) {
        return !!resource.path && resource.path[0] === "/";
      }
      isEqualAuthority(a1, a2) {
        return a1 === a2 || a1 !== void 0 && a2 !== void 0 && equalsIgnoreCase(a1, a2);
      }
      hasTrailingPathSeparator(resource, sep2 = sep) {
        if (resource.scheme === Schemas.file) {
          const fsp = originalFSPath(resource);
          return fsp.length > getRoot(fsp).length && fsp[fsp.length - 1] === sep2;
        } else {
          const p = resource.path;
          return p.length > 1 && p.charCodeAt(p.length - 1) === 47 && !/^[a-zA-Z]:(\/$|\\$)/.test(resource.fsPath);
        }
      }
      removeTrailingPathSeparator(resource, sep2 = sep) {
        if (hasTrailingPathSeparator(resource, sep2)) {
          return resource.with({ path: resource.path.substr(0, resource.path.length - 1) });
        }
        return resource;
      }
      addTrailingPathSeparator(resource, sep2 = sep) {
        let isRootSep = false;
        if (resource.scheme === Schemas.file) {
          const fsp = originalFSPath(resource);
          isRootSep = fsp !== void 0 && fsp.length === getRoot(fsp).length && fsp[fsp.length - 1] === sep2;
        } else {
          sep2 = "/";
          const p = resource.path;
          isRootSep = p.length === 1 && p.charCodeAt(p.length - 1) === 47;
        }
        if (!isRootSep && !hasTrailingPathSeparator(resource, sep2)) {
          return resource.with({ path: resource.path + "/" });
        }
        return resource;
      }
    };
    extUri = new ExtUri(() => false);
    extUriBiasedIgnorePathCase = new ExtUri((uri) => {
      return uri.scheme === Schemas.file ? !isLinux : true;
    });
    extUriIgnorePathCase = new ExtUri((_) => true);
    isEqual2 = extUri.isEqual.bind(extUri);
    isEqualOrParent2 = extUri.isEqualOrParent.bind(extUri);
    getComparisonKey = extUri.getComparisonKey.bind(extUri);
    basenameOrAuthority = extUri.basenameOrAuthority.bind(extUri);
    basename2 = extUri.basename.bind(extUri);
    extname2 = extUri.extname.bind(extUri);
    dirname4 = extUri.dirname.bind(extUri);
    joinPath = extUri.joinPath.bind(extUri);
    normalizePath = extUri.normalizePath.bind(extUri);
    relativePath = extUri.relativePath.bind(extUri);
    resolvePath = extUri.resolvePath.bind(extUri);
    isAbsolutePath = extUri.isAbsolutePath.bind(extUri);
    isEqualAuthority = extUri.isEqualAuthority.bind(extUri);
    hasTrailingPathSeparator = extUri.hasTrailingPathSeparator.bind(extUri);
    removeTrailingPathSeparator2 = extUri.removeTrailingPathSeparator.bind(extUri);
    addTrailingPathSeparator = extUri.addTrailingPathSeparator.bind(extUri);
    (function(DataUri2) {
      DataUri2.META_DATA_LABEL = "label";
      DataUri2.META_DATA_DESCRIPTION = "description";
      DataUri2.META_DATA_SIZE = "size";
      DataUri2.META_DATA_MIME = "mime";
      function parseMetaData(dataUri) {
        const metadata = /* @__PURE__ */ new Map();
        const meta = dataUri.path.substring(dataUri.path.indexOf(";") + 1, dataUri.path.lastIndexOf(";"));
        meta.split(";").forEach((property) => {
          const [key, value] = property.split(":");
          if (key && value) {
            metadata.set(key, value);
          }
        });
        const mime = dataUri.path.substring(0, dataUri.path.indexOf(";"));
        if (mime) {
          metadata.set(DataUri2.META_DATA_MIME, mime);
        }
        return metadata;
      }
      DataUri2.parseMetaData = parseMetaData;
    })(DataUri || (DataUri = {}));
  }
});

// out-build/vs/base/common/symbols.js
var MicrotaskDelay;
var init_symbols = __esm({
  "out-build/vs/base/common/symbols.js"() {
    "use strict";
    MicrotaskDelay = Symbol("MicrotaskDelay");
  }
});

// out-build/vs/base/common/async.js
function isThenable(obj) {
  return !!obj && typeof obj.then === "function";
}
function createCancelablePromise(callback) {
  const source = new CancellationTokenSource();
  const thenable = callback(source.token);
  let isCancelled = false;
  const promise = new Promise((resolve3, reject) => {
    const subscription = source.token.onCancellationRequested(() => {
      isCancelled = true;
      subscription.dispose();
      reject(new CancellationError());
    });
    Promise.resolve(thenable).then((value) => {
      subscription.dispose();
      source.dispose();
      if (!isCancelled) {
        resolve3(value);
      } else if (isDisposable(value)) {
        value.dispose();
      }
    }, (err) => {
      subscription.dispose();
      source.dispose();
      reject(err);
    });
  });
  return new class {
    cancel() {
      source.cancel();
      source.dispose();
    }
    then(resolve3, reject) {
      return promise.then(resolve3, reject);
    }
    catch(reject) {
      return this.then(void 0, reject);
    }
    finally(onfinally) {
      return promise.finally(onfinally);
    }
  }();
}
function promiseWithResolvers() {
  let resolve3;
  let reject;
  const promise = new Promise((res, rej) => {
    resolve3 = res;
    reject = rej;
  });
  return { promise, resolve: resolve3, reject };
}
function timeout(millis, token) {
  if (!token) {
    return createCancelablePromise((token2) => timeout(millis, token2));
  }
  return new Promise((resolve3, reject) => {
    const handle = setTimeout(() => {
      disposable.dispose();
      resolve3();
    }, millis);
    const disposable = token.onCancellationRequested(() => {
      clearTimeout(handle);
      disposable.dispose();
      reject(new CancellationError());
    });
  });
}
function disposableTimeout(handler, timeout2 = 0, store) {
  const timer = setTimeout(() => {
    handler();
    if (store) {
      disposable.dispose();
    }
  }, timeout2);
  const disposable = toDisposable(() => {
    clearTimeout(timer);
    store?.delete(disposable);
  });
  store?.add(disposable);
  return disposable;
}
function first(promiseFactories, shouldStop = (t) => !!t, defaultValue = null) {
  let index = 0;
  const len = promiseFactories.length;
  const loop = () => {
    if (index >= len) {
      return Promise.resolve(defaultValue);
    }
    const factory = promiseFactories[index++];
    const promise = Promise.resolve(factory());
    return promise.then((result) => {
      if (shouldStop(result)) {
        return Promise.resolve(result);
      }
      return loop();
    });
  };
  return loop();
}
async function retry(task, delay, retries) {
  let lastError;
  for (let i = 0; i < retries; i++) {
    try {
      return await task();
    } catch (error) {
      lastError = error;
      await timeout(delay);
    }
  }
  throw lastError;
}
var Throttler, timeoutDeferred, microtaskDeferred, Delayer, ThrottledDelayer, Barrier, Limiter, Queue, ResourceQueue, RunOnceScheduler, RunOnceWorker, ThrottledWorker, runWhenGlobalIdle, _runWhenIdle, AbstractIdleValue, GlobalIdleValue, DeferredOutcome, DeferredPromise, Promises, AsyncIterableSourceState, AsyncIterableObject;
var init_async = __esm({
  "out-build/vs/base/common/async.js"() {
    "use strict";
    init_cancellation();
    init_errors();
    init_event();
    init_lifecycle();
    init_resources();
    init_platform();
    init_symbols();
    init_lazy();
    Throttler = class {
      constructor() {
        this.isDisposed = false;
        this.activePromise = null;
        this.queuedPromise = null;
        this.queuedPromiseFactory = null;
      }
      queue(promiseFactory) {
        if (this.isDisposed) {
          return Promise.reject(new Error("Throttler is disposed"));
        }
        if (this.activePromise) {
          this.queuedPromiseFactory = promiseFactory;
          if (!this.queuedPromise) {
            const onComplete = () => {
              this.queuedPromise = null;
              if (this.isDisposed) {
                return;
              }
              const result = this.queue(this.queuedPromiseFactory);
              this.queuedPromiseFactory = null;
              return result;
            };
            this.queuedPromise = new Promise((resolve3) => {
              this.activePromise.then(onComplete, onComplete).then(resolve3);
            });
          }
          return new Promise((resolve3, reject) => {
            this.queuedPromise.then(resolve3, reject);
          });
        }
        this.activePromise = promiseFactory();
        return new Promise((resolve3, reject) => {
          this.activePromise.then((result) => {
            this.activePromise = null;
            resolve3(result);
          }, (err) => {
            this.activePromise = null;
            reject(err);
          });
        });
      }
      dispose() {
        this.isDisposed = true;
      }
    };
    timeoutDeferred = (timeout2, fn) => {
      let scheduled = true;
      const handle = setTimeout(() => {
        scheduled = false;
        fn();
      }, timeout2);
      return {
        isTriggered: () => scheduled,
        dispose: () => {
          clearTimeout(handle);
          scheduled = false;
        }
      };
    };
    microtaskDeferred = (fn) => {
      let scheduled = true;
      queueMicrotask(() => {
        if (scheduled) {
          scheduled = false;
          fn();
        }
      });
      return {
        isTriggered: () => scheduled,
        dispose: () => {
          scheduled = false;
        }
      };
    };
    Delayer = class {
      constructor(defaultDelay) {
        this.defaultDelay = defaultDelay;
        this.deferred = null;
        this.completionPromise = null;
        this.doResolve = null;
        this.doReject = null;
        this.task = null;
      }
      trigger(task, delay = this.defaultDelay) {
        this.task = task;
        this.cancelTimeout();
        if (!this.completionPromise) {
          this.completionPromise = new Promise((resolve3, reject) => {
            this.doResolve = resolve3;
            this.doReject = reject;
          }).then(() => {
            this.completionPromise = null;
            this.doResolve = null;
            if (this.task) {
              const task2 = this.task;
              this.task = null;
              return task2();
            }
            return void 0;
          });
        }
        const fn = () => {
          this.deferred = null;
          this.doResolve?.(null);
        };
        this.deferred = delay === MicrotaskDelay ? microtaskDeferred(fn) : timeoutDeferred(delay, fn);
        return this.completionPromise;
      }
      isTriggered() {
        return !!this.deferred?.isTriggered();
      }
      cancel() {
        this.cancelTimeout();
        if (this.completionPromise) {
          this.doReject?.(new CancellationError());
          this.completionPromise = null;
        }
      }
      cancelTimeout() {
        this.deferred?.dispose();
        this.deferred = null;
      }
      dispose() {
        this.cancel();
      }
    };
    ThrottledDelayer = class {
      constructor(defaultDelay) {
        this.delayer = new Delayer(defaultDelay);
        this.throttler = new Throttler();
      }
      trigger(promiseFactory, delay) {
        return this.delayer.trigger(() => this.throttler.queue(promiseFactory), delay);
      }
      isTriggered() {
        return this.delayer.isTriggered();
      }
      cancel() {
        this.delayer.cancel();
      }
      dispose() {
        this.delayer.dispose();
        this.throttler.dispose();
      }
    };
    Barrier = class {
      constructor() {
        this._isOpen = false;
        this._promise = new Promise((c, e) => {
          this._completePromise = c;
        });
      }
      isOpen() {
        return this._isOpen;
      }
      open() {
        this._isOpen = true;
        this._completePromise(true);
      }
      wait() {
        return this._promise;
      }
    };
    Limiter = class {
      constructor(maxDegreeOfParalellism) {
        this._size = 0;
        this._isDisposed = false;
        this.maxDegreeOfParalellism = maxDegreeOfParalellism;
        this.outstandingPromises = [];
        this.runningPromises = 0;
        this._onDrained = new Emitter();
      }
      /**
       *
       * @returns A promise that resolved when all work is done (onDrained) or when
       * there is nothing to do
       */
      whenIdle() {
        return this.size > 0 ? Event.toPromise(this.onDrained) : Promise.resolve();
      }
      get onDrained() {
        return this._onDrained.event;
      }
      get size() {
        return this._size;
      }
      queue(factory) {
        if (this._isDisposed) {
          throw new Error("Object has been disposed");
        }
        this._size++;
        return new Promise((c, e) => {
          this.outstandingPromises.push({ factory, c, e });
          this.consume();
        });
      }
      consume() {
        while (this.outstandingPromises.length && this.runningPromises < this.maxDegreeOfParalellism) {
          const iLimitedTask = this.outstandingPromises.shift();
          this.runningPromises++;
          const promise = iLimitedTask.factory();
          promise.then(iLimitedTask.c, iLimitedTask.e);
          promise.then(() => this.consumed(), () => this.consumed());
        }
      }
      consumed() {
        if (this._isDisposed) {
          return;
        }
        this.runningPromises--;
        if (--this._size === 0) {
          this._onDrained.fire();
        }
        if (this.outstandingPromises.length > 0) {
          this.consume();
        }
      }
      clear() {
        if (this._isDisposed) {
          throw new Error("Object has been disposed");
        }
        this.outstandingPromises.length = 0;
        this._size = this.runningPromises;
      }
      dispose() {
        this._isDisposed = true;
        this.outstandingPromises.length = 0;
        this._size = 0;
        this._onDrained.dispose();
      }
    };
    Queue = class extends Limiter {
      constructor() {
        super(1);
      }
    };
    ResourceQueue = class {
      constructor() {
        this.queues = /* @__PURE__ */ new Map();
        this.drainers = /* @__PURE__ */ new Set();
        this.drainListeners = void 0;
        this.drainListenerCount = 0;
      }
      async whenDrained() {
        if (this.isDrained()) {
          return;
        }
        const promise = new DeferredPromise();
        this.drainers.add(promise);
        return promise.p;
      }
      isDrained() {
        for (const [, queue] of this.queues) {
          if (queue.size > 0) {
            return false;
          }
        }
        return true;
      }
      queueSize(resource, extUri2 = extUri) {
        const key = extUri2.getComparisonKey(resource);
        return this.queues.get(key)?.size ?? 0;
      }
      queueFor(resource, factory, extUri2 = extUri) {
        const key = extUri2.getComparisonKey(resource);
        let queue = this.queues.get(key);
        if (!queue) {
          queue = new Queue();
          const drainListenerId = this.drainListenerCount++;
          const drainListener = Event.once(queue.onDrained)(() => {
            queue?.dispose();
            this.queues.delete(key);
            this.onDidQueueDrain();
            this.drainListeners?.deleteAndDispose(drainListenerId);
            if (this.drainListeners?.size === 0) {
              this.drainListeners.dispose();
              this.drainListeners = void 0;
            }
          });
          if (!this.drainListeners) {
            this.drainListeners = new DisposableMap();
          }
          this.drainListeners.set(drainListenerId, drainListener);
          this.queues.set(key, queue);
        }
        return queue.queue(factory);
      }
      onDidQueueDrain() {
        if (!this.isDrained()) {
          return;
        }
        this.releaseDrainers();
      }
      releaseDrainers() {
        for (const drainer of this.drainers) {
          drainer.complete();
        }
        this.drainers.clear();
      }
      dispose() {
        for (const [, queue] of this.queues) {
          queue.dispose();
        }
        this.queues.clear();
        this.releaseDrainers();
        this.drainListeners?.dispose();
      }
    };
    RunOnceScheduler = class {
      constructor(runner, delay) {
        this.timeoutToken = void 0;
        this.runner = runner;
        this.timeout = delay;
        this.timeoutHandler = this.onTimeout.bind(this);
      }
      /**
       * Dispose RunOnceScheduler
       */
      dispose() {
        this.cancel();
        this.runner = null;
      }
      /**
       * Cancel current scheduled runner (if any).
       */
      cancel() {
        if (this.isScheduled()) {
          clearTimeout(this.timeoutToken);
          this.timeoutToken = void 0;
        }
      }
      /**
       * Cancel previous runner (if any) & schedule a new runner.
       */
      schedule(delay = this.timeout) {
        this.cancel();
        this.timeoutToken = setTimeout(this.timeoutHandler, delay);
      }
      get delay() {
        return this.timeout;
      }
      set delay(value) {
        this.timeout = value;
      }
      /**
       * Returns true if scheduled.
       */
      isScheduled() {
        return this.timeoutToken !== void 0;
      }
      flush() {
        if (this.isScheduled()) {
          this.cancel();
          this.doRun();
        }
      }
      onTimeout() {
        this.timeoutToken = void 0;
        if (this.runner) {
          this.doRun();
        }
      }
      doRun() {
        this.runner?.();
      }
    };
    RunOnceWorker = class extends RunOnceScheduler {
      constructor(runner, timeout2) {
        super(runner, timeout2);
        this.units = [];
      }
      work(unit) {
        this.units.push(unit);
        if (!this.isScheduled()) {
          this.schedule();
        }
      }
      doRun() {
        const units = this.units;
        this.units = [];
        this.runner?.(units);
      }
      dispose() {
        this.units = [];
        super.dispose();
      }
    };
    ThrottledWorker = class extends Disposable {
      constructor(options, handler) {
        super();
        this.options = options;
        this.handler = handler;
        this.pendingWork = [];
        this.throttler = this._register(new MutableDisposable());
        this.disposed = false;
        this.lastExecutionTime = 0;
      }
      /**
       * The number of work units that are pending to be processed.
       */
      get pending() {
        return this.pendingWork.length;
      }
      /**
       * Add units to be worked on. Use `pending` to figure out
       * how many units are not yet processed after this method
       * was called.
       *
       * @returns whether the work was accepted or not. If the
       * worker is disposed, it will not accept any more work.
       * If the number of pending units would become larger
       * than `maxPendingWork`, more work will also not be accepted.
       */
      work(units) {
        if (this.disposed) {
          return false;
        }
        if (typeof this.options.maxBufferedWork === "number") {
          if (this.throttler.value) {
            if (this.pending + units.length > this.options.maxBufferedWork) {
              return false;
            }
          } else {
            if (this.pending + units.length - this.options.maxWorkChunkSize > this.options.maxBufferedWork) {
              return false;
            }
          }
        }
        for (const unit of units) {
          this.pendingWork.push(unit);
        }
        const timeSinceLastExecution = Date.now() - this.lastExecutionTime;
        if (!this.throttler.value && (!this.options.waitThrottleDelayBetweenWorkUnits || timeSinceLastExecution >= this.options.throttleDelay)) {
          this.doWork();
        } else if (!this.throttler.value && this.options.waitThrottleDelayBetweenWorkUnits) {
          this.scheduleThrottler(Math.max(this.options.throttleDelay - timeSinceLastExecution, 0));
        } else {
        }
        return true;
      }
      doWork() {
        this.lastExecutionTime = Date.now();
        this.handler(this.pendingWork.splice(0, this.options.maxWorkChunkSize));
        if (this.pendingWork.length > 0) {
          this.scheduleThrottler();
        }
      }
      scheduleThrottler(delay = this.options.throttleDelay) {
        this.throttler.value = new RunOnceScheduler(() => {
          this.throttler.clear();
          this.doWork();
        }, delay);
        this.throttler.value.schedule();
      }
      dispose() {
        super.dispose();
        this.pendingWork.length = 0;
        this.disposed = true;
      }
    };
    (function() {
      if (typeof globalThis.requestIdleCallback !== "function" || typeof globalThis.cancelIdleCallback !== "function") {
        _runWhenIdle = (_targetWindow, runner, timeout2) => {
          setTimeout0(() => {
            if (disposed) {
              return;
            }
            const end = Date.now() + 15;
            const deadline = {
              didTimeout: true,
              timeRemaining() {
                return Math.max(0, end - Date.now());
              }
            };
            runner(Object.freeze(deadline));
          });
          let disposed = false;
          return {
            dispose() {
              if (disposed) {
                return;
              }
              disposed = true;
            }
          };
        };
      } else {
        _runWhenIdle = (targetWindow, runner, timeout2) => {
          const handle = targetWindow.requestIdleCallback(runner, typeof timeout2 === "number" ? { timeout: timeout2 } : void 0);
          let disposed = false;
          return {
            dispose() {
              if (disposed) {
                return;
              }
              disposed = true;
              targetWindow.cancelIdleCallback(handle);
            }
          };
        };
      }
      runWhenGlobalIdle = (runner, timeout2) => _runWhenIdle(globalThis, runner, timeout2);
    })();
    AbstractIdleValue = class {
      constructor(targetWindow, executor) {
        this._didRun = false;
        this._executor = () => {
          try {
            this._value = executor();
          } catch (err) {
            this._error = err;
          } finally {
            this._didRun = true;
          }
        };
        this._handle = _runWhenIdle(targetWindow, () => this._executor());
      }
      dispose() {
        this._handle.dispose();
      }
      get value() {
        if (!this._didRun) {
          this._handle.dispose();
          this._executor();
        }
        if (this._error) {
          throw this._error;
        }
        return this._value;
      }
      get isInitialized() {
        return this._didRun;
      }
    };
    GlobalIdleValue = class extends AbstractIdleValue {
      constructor(executor) {
        super(globalThis, executor);
      }
    };
    (function(DeferredOutcome2) {
      DeferredOutcome2[DeferredOutcome2["Resolved"] = 0] = "Resolved";
      DeferredOutcome2[DeferredOutcome2["Rejected"] = 1] = "Rejected";
    })(DeferredOutcome || (DeferredOutcome = {}));
    DeferredPromise = class {
      get isRejected() {
        return this.outcome?.outcome === 1;
      }
      get isResolved() {
        return this.outcome?.outcome === 0;
      }
      get isSettled() {
        return !!this.outcome;
      }
      get value() {
        return this.outcome?.outcome === 0 ? this.outcome?.value : void 0;
      }
      constructor() {
        this.p = new Promise((c, e) => {
          this.completeCallback = c;
          this.errorCallback = e;
        });
      }
      complete(value) {
        return new Promise((resolve3) => {
          this.completeCallback(value);
          this.outcome = { outcome: 0, value };
          resolve3();
        });
      }
      error(err) {
        return new Promise((resolve3) => {
          this.errorCallback(err);
          this.outcome = { outcome: 1, value: err };
          resolve3();
        });
      }
      settleWith(promise) {
        return promise.then((value) => this.complete(value), (error) => this.error(error));
      }
      cancel() {
        return this.error(new CancellationError());
      }
    };
    (function(Promises3) {
      async function settled(promises19) {
        let firstError = void 0;
        const result = await Promise.all(promises19.map((promise) => promise.then((value) => value, (error) => {
          if (!firstError) {
            firstError = error;
          }
          return void 0;
        })));
        if (typeof firstError !== "undefined") {
          throw firstError;
        }
        return result;
      }
      Promises3.settled = settled;
      function withAsyncBody(bodyFn) {
        return new Promise(async (resolve3, reject) => {
          try {
            await bodyFn(resolve3, reject);
          } catch (error) {
            reject(error);
          }
        });
      }
      Promises3.withAsyncBody = withAsyncBody;
    })(Promises || (Promises = {}));
    (function(AsyncIterableSourceState2) {
      AsyncIterableSourceState2[AsyncIterableSourceState2["Initial"] = 0] = "Initial";
      AsyncIterableSourceState2[AsyncIterableSourceState2["DoneOK"] = 1] = "DoneOK";
      AsyncIterableSourceState2[AsyncIterableSourceState2["DoneError"] = 2] = "DoneError";
    })(AsyncIterableSourceState || (AsyncIterableSourceState = {}));
    AsyncIterableObject = class _AsyncIterableObject {
      static fromArray(items) {
        return new _AsyncIterableObject((writer) => {
          writer.emitMany(items);
        });
      }
      static fromPromise(promise) {
        return new _AsyncIterableObject(async (emitter) => {
          emitter.emitMany(await promise);
        });
      }
      static fromPromisesResolveOrder(promises19) {
        return new _AsyncIterableObject(async (emitter) => {
          await Promise.all(promises19.map(async (p) => emitter.emitOne(await p)));
        });
      }
      static merge(iterables) {
        return new _AsyncIterableObject(async (emitter) => {
          await Promise.all(iterables.map(async (iterable) => {
            for await (const item of iterable) {
              emitter.emitOne(item);
            }
          }));
        });
      }
      static {
        this.EMPTY = _AsyncIterableObject.fromArray([]);
      }
      constructor(executor, onReturn) {
        this._state = 0;
        this._results = [];
        this._error = null;
        this._onReturn = onReturn;
        this._onStateChanged = new Emitter();
        queueMicrotask(async () => {
          const writer = {
            emitOne: (item) => this.emitOne(item),
            emitMany: (items) => this.emitMany(items),
            reject: (error) => this.reject(error)
          };
          try {
            await Promise.resolve(executor(writer));
            this.resolve();
          } catch (err) {
            this.reject(err);
          } finally {
            writer.emitOne = void 0;
            writer.emitMany = void 0;
            writer.reject = void 0;
          }
        });
      }
      [Symbol.asyncIterator]() {
        let i = 0;
        return {
          next: async () => {
            do {
              if (this._state === 2) {
                throw this._error;
              }
              if (i < this._results.length) {
                return { done: false, value: this._results[i++] };
              }
              if (this._state === 1) {
                return { done: true, value: void 0 };
              }
              await Event.toPromise(this._onStateChanged.event);
            } while (true);
          },
          return: async () => {
            this._onReturn?.();
            return { done: true, value: void 0 };
          }
        };
      }
      static map(iterable, mapFn) {
        return new _AsyncIterableObject(async (emitter) => {
          for await (const item of iterable) {
            emitter.emitOne(mapFn(item));
          }
        });
      }
      map(mapFn) {
        return _AsyncIterableObject.map(this, mapFn);
      }
      static filter(iterable, filterFn) {
        return new _AsyncIterableObject(async (emitter) => {
          for await (const item of iterable) {
            if (filterFn(item)) {
              emitter.emitOne(item);
            }
          }
        });
      }
      filter(filterFn) {
        return _AsyncIterableObject.filter(this, filterFn);
      }
      static coalesce(iterable) {
        return _AsyncIterableObject.filter(iterable, (item) => !!item);
      }
      coalesce() {
        return _AsyncIterableObject.coalesce(this);
      }
      static async toPromise(iterable) {
        const result = [];
        for await (const item of iterable) {
          result.push(item);
        }
        return result;
      }
      toPromise() {
        return _AsyncIterableObject.toPromise(this);
      }
      /**
       * The value will be appended at the end.
       *
       * **NOTE** If `resolve()` or `reject()` have already been called, this method has no effect.
       */
      emitOne(value) {
        if (this._state !== 0) {
          return;
        }
        this._results.push(value);
        this._onStateChanged.fire();
      }
      /**
       * The values will be appended at the end.
       *
       * **NOTE** If `resolve()` or `reject()` have already been called, this method has no effect.
       */
      emitMany(values) {
        if (this._state !== 0) {
          return;
        }
        this._results = this._results.concat(values);
        this._onStateChanged.fire();
      }
      /**
       * Calling `resolve()` will mark the result array as complete.
       *
       * **NOTE** `resolve()` must be called, otherwise all consumers of this iterable will hang indefinitely, similar to a non-resolved promise.
       * **NOTE** If `resolve()` or `reject()` have already been called, this method has no effect.
       */
      resolve() {
        if (this._state !== 0) {
          return;
        }
        this._state = 1;
        this._onStateChanged.fire();
      }
      /**
       * Writing an error will permanently invalidate this iterable.
       * The current users will receive an error thrown, as will all future users.
       *
       * **NOTE** If `resolve()` or `reject()` have already been called, this method has no effect.
       */
      reject(error) {
        if (this._state !== 0) {
          return;
        }
        this._state = 2;
        this._error = error;
        this._onStateChanged.fire();
      }
    };
  }
});

// out-build/vs/base/common/normalization.js
function normalizeNFC(str) {
  return normalize2(str, "NFC", nfcCache);
}
function normalize2(str, form, normalizedCache) {
  if (!str) {
    return str;
  }
  const cached = normalizedCache.get(str);
  if (cached) {
    return cached;
  }
  let res;
  if (nonAsciiCharactersPattern.test(str)) {
    res = str.normalize(form);
  } else {
    res = str;
  }
  normalizedCache.set(str, res);
  return res;
}
var nfcCache, nfdCache, nonAsciiCharactersPattern;
var init_normalization = __esm({
  "out-build/vs/base/common/normalization.js"() {
    "use strict";
    init_map();
    nfcCache = new LRUCache(1e4);
    nfdCache = new LRUCache(1e4);
    nonAsciiCharactersPattern = /[^\u0000-\u0080]/;
  }
});

// out-build/vs/base/node/pfs.js
import * as fs3 from "fs";
import { tmpdir } from "os";
import { promisify } from "util";
async function rimraf(path4, mode = RimRafMode.UNLINK, moveToPath) {
  if (isRootOrDriveLetter(path4)) {
    throw new Error("rimraf - will refuse to recursively delete root");
  }
  if (mode === RimRafMode.UNLINK) {
    return rimrafUnlink(path4);
  }
  return rimrafMove(path4, moveToPath);
}
async function rimrafMove(path4, moveToPath = randomPath(tmpdir())) {
  try {
    try {
      await fs3.promises.rename(path4, moveToPath);
    } catch (error) {
      if (error.code === "ENOENT") {
        return;
      }
      return rimrafUnlink(path4);
    }
    rimrafUnlink(moveToPath).catch((error) => {
    });
  } catch (error) {
    if (error.code !== "ENOENT") {
      throw error;
    }
  }
}
async function rimrafUnlink(path4) {
  return fs3.promises.rm(path4, { recursive: true, force: true, maxRetries: 3 });
}
async function readdir(path4, options) {
  return handleDirectoryChildren(await (options ? safeReaddirWithFileTypes(path4) : fs3.promises.readdir(path4)));
}
async function safeReaddirWithFileTypes(path4) {
  try {
    return await fs3.promises.readdir(path4, { withFileTypes: true });
  } catch (error) {
    console.warn("[node.js fs] readdir with filetypes failed with error: ", error);
  }
  const result = [];
  const children = await readdir(path4);
  for (const child of children) {
    let isFile = false;
    let isDirectory = false;
    let isSymbolicLink = false;
    try {
      const lstat = await fs3.promises.lstat(join3(path4, child));
      isFile = lstat.isFile();
      isDirectory = lstat.isDirectory();
      isSymbolicLink = lstat.isSymbolicLink();
    } catch (error) {
      console.warn("[node.js fs] unexpected error from lstat after readdir: ", error);
    }
    result.push({
      name: child,
      isFile: () => isFile,
      isDirectory: () => isDirectory,
      isSymbolicLink: () => isSymbolicLink
    });
  }
  return result;
}
function handleDirectoryChildren(children) {
  return children.map((child) => {
    if (typeof child === "string") {
      return isMacintosh ? normalizeNFC(child) : child;
    }
    child.name = isMacintosh ? normalizeNFC(child.name) : child.name;
    return child;
  });
}
async function readDirsInDir(dirPath) {
  const children = await readdir(dirPath);
  const directories = [];
  for (const child of children) {
    if (await SymlinkSupport.existsDirectory(join3(dirPath, child))) {
      directories.push(child);
    }
  }
  return directories;
}
function whenDeleted(path4, intervalMs = 1e3) {
  return new Promise((resolve3) => {
    let running = false;
    const interval = setInterval(() => {
      if (!running) {
        running = true;
        fs3.access(path4, (err) => {
          running = false;
          if (err) {
            clearInterval(interval);
            resolve3(void 0);
          }
        });
      }
    }, intervalMs);
  });
}
function writeFile2(path4, data, options) {
  return writeQueues.queueFor(URI.file(path4), () => {
    const ensuredOptions = ensureWriteOptions(options);
    return new Promise((resolve3, reject) => doWriteFileAndFlush(path4, data, ensuredOptions, (error) => error ? reject(error) : resolve3()));
  }, extUriBiasedIgnorePathCase);
}
function configureFlushOnWrite(enabled) {
  canFlush = enabled;
}
function doWriteFileAndFlush(path4, data, options, callback) {
  if (!canFlush) {
    return fs3.writeFile(path4, data, { mode: options.mode, flag: options.flag }, callback);
  }
  fs3.open(path4, options.flag, options.mode, (openError, fd) => {
    if (openError) {
      return callback(openError);
    }
    fs3.writeFile(fd, data, (writeError) => {
      if (writeError) {
        return fs3.close(fd, () => callback(writeError));
      }
      fs3.fdatasync(fd, (syncError) => {
        if (syncError) {
          console.warn("[node.js fs] fdatasync is now disabled for this session because it failed: ", syncError);
          configureFlushOnWrite(false);
        }
        return fs3.close(fd, (closeError) => callback(closeError));
      });
    });
  });
}
function ensureWriteOptions(options) {
  if (!options) {
    return { mode: 438, flag: "w" };
  }
  return {
    mode: typeof options.mode === "number" ? options.mode : 438,
    flag: typeof options.flag === "string" ? options.flag : "w"
  };
}
async function rename(source, target, windowsRetryTimeout = 6e4) {
  if (source === target) {
    return;
  }
  try {
    if (isWindows2 && typeof windowsRetryTimeout === "number") {
      await renameWithRetry(source, target, Date.now(), windowsRetryTimeout);
    } else {
      await fs3.promises.rename(source, target);
    }
  } catch (error) {
    if (source.toLowerCase() !== target.toLowerCase() && error.code === "EXDEV" || source.endsWith(".")) {
      await copy(source, target, {
        preserveSymlinks: false
        /* copying to another device */
      });
      await rimraf(source, RimRafMode.MOVE);
    } else {
      throw error;
    }
  }
}
async function renameWithRetry(source, target, startTime, retryTimeout, attempt = 0) {
  try {
    return await fs3.promises.rename(source, target);
  } catch (error) {
    if (error.code !== "EACCES" && error.code !== "EPERM" && error.code !== "EBUSY") {
      throw error;
    }
    if (Date.now() - startTime >= retryTimeout) {
      console.error(`[node.js fs] rename failed after ${attempt} retries with error: ${error}`);
      throw error;
    }
    if (attempt === 0) {
      let abortRetry = false;
      try {
        const { stat } = await SymlinkSupport.stat(target);
        if (!stat.isFile()) {
          abortRetry = true;
        }
      } catch (error2) {
      }
      if (abortRetry) {
        throw error;
      }
    }
    await timeout(Math.min(100, attempt * 10));
    return renameWithRetry(source, target, startTime, retryTimeout, attempt + 1);
  }
}
async function copy(source, target, options) {
  return doCopy(source, target, { root: { source, target }, options, handledSourcePaths: /* @__PURE__ */ new Set() });
}
async function doCopy(source, target, payload) {
  if (payload.handledSourcePaths.has(source)) {
    return;
  } else {
    payload.handledSourcePaths.add(source);
  }
  const { stat, symbolicLink } = await SymlinkSupport.stat(source);
  if (symbolicLink) {
    if (payload.options.preserveSymlinks) {
      try {
        return await doCopySymlink(source, target, payload);
      } catch (error) {
      }
    }
    if (symbolicLink.dangling) {
      return;
    }
  }
  if (stat.isDirectory()) {
    return doCopyDirectory(source, target, stat.mode & COPY_MODE_MASK, payload);
  } else {
    return doCopyFile(source, target, stat.mode & COPY_MODE_MASK);
  }
}
async function doCopyDirectory(source, target, mode, payload) {
  await fs3.promises.mkdir(target, { recursive: true, mode });
  const files = await readdir(source);
  for (const file of files) {
    await doCopy(join3(source, file), join3(target, file), payload);
  }
}
async function doCopyFile(source, target, mode) {
  await fs3.promises.copyFile(source, target);
  await fs3.promises.chmod(target, mode);
}
async function doCopySymlink(source, target, payload) {
  let linkTarget = await fs3.promises.readlink(source);
  if (isEqualOrParent(linkTarget, payload.root.source, !isLinux)) {
    linkTarget = join3(payload.root.target, linkTarget.substr(payload.root.source.length + 1));
  }
  await fs3.promises.symlink(linkTarget, target);
}
var RimRafMode, SymlinkSupport, writeQueues, canFlush, COPY_MODE_MASK, Promises2;
var init_pfs = __esm({
  "out-build/vs/base/node/pfs.js"() {
    "use strict";
    init_async();
    init_extpath();
    init_normalization();
    init_path();
    init_platform();
    init_resources();
    init_uri();
    (function(RimRafMode2) {
      RimRafMode2[RimRafMode2["UNLINK"] = 0] = "UNLINK";
      RimRafMode2[RimRafMode2["MOVE"] = 1] = "MOVE";
    })(RimRafMode || (RimRafMode = {}));
    (function(SymlinkSupport2) {
      async function stat(path4) {
        let lstats;
        try {
          lstats = await fs3.promises.lstat(path4);
          if (!lstats.isSymbolicLink()) {
            return { stat: lstats };
          }
        } catch (error) {
        }
        try {
          const stats = await fs3.promises.stat(path4);
          return { stat: stats, symbolicLink: lstats?.isSymbolicLink() ? { dangling: false } : void 0 };
        } catch (error) {
          if (error.code === "ENOENT" && lstats) {
            return { stat: lstats, symbolicLink: { dangling: true } };
          }
          if (isWindows2 && error.code === "EACCES") {
            try {
              const stats = await fs3.promises.stat(await fs3.promises.readlink(path4));
              return { stat: stats, symbolicLink: { dangling: false } };
            } catch (error2) {
              if (error2.code === "ENOENT" && lstats) {
                return { stat: lstats, symbolicLink: { dangling: true } };
              }
              throw error2;
            }
          }
          throw error;
        }
      }
      SymlinkSupport2.stat = stat;
      async function existsFile(path4) {
        try {
          const { stat: stat2, symbolicLink } = await SymlinkSupport2.stat(path4);
          return stat2.isFile() && symbolicLink?.dangling !== true;
        } catch (error) {
        }
        return false;
      }
      SymlinkSupport2.existsFile = existsFile;
      async function existsDirectory(path4) {
        try {
          const { stat: stat2, symbolicLink } = await SymlinkSupport2.stat(path4);
          return stat2.isDirectory() && symbolicLink?.dangling !== true;
        } catch (error) {
        }
        return false;
      }
      SymlinkSupport2.existsDirectory = existsDirectory;
    })(SymlinkSupport || (SymlinkSupport = {}));
    writeQueues = new ResourceQueue();
    canFlush = true;
    COPY_MODE_MASK = 511;
    Promises2 = new class {
      //#region Implemented by node.js
      get read() {
        return (fd, buffer, offset, length, position) => {
          return new Promise((resolve3, reject) => {
            fs3.read(fd, buffer, offset, length, position, (err, bytesRead, buffer2) => {
              if (err) {
                return reject(err);
              }
              return resolve3({ bytesRead, buffer: buffer2 });
            });
          });
        };
      }
      get write() {
        return (fd, buffer, offset, length, position) => {
          return new Promise((resolve3, reject) => {
            fs3.write(fd, buffer, offset, length, position, (err, bytesWritten, buffer2) => {
              if (err) {
                return reject(err);
              }
              return resolve3({ bytesWritten, buffer: buffer2 });
            });
          });
        };
      }
      get fdatasync() {
        return promisify(fs3.fdatasync);
      }
      // not exposed as API in 20.x yet
      get open() {
        return promisify(fs3.open);
      }
      // changed to return `FileHandle` in promise API
      get close() {
        return promisify(fs3.close);
      }
      // not exposed as API due to the `FileHandle` return type of `open`
      get realpath() {
        return promisify(fs3.realpath);
      }
      // `fs.promises.realpath` will use `fs.realpath.native` which we do not want
      get ftruncate() {
        return promisify(fs3.ftruncate);
      }
      // not exposed as API in 20.x yet
      //#endregion
      //#region Implemented by us
      async exists(path4) {
        try {
          await fs3.promises.access(path4);
          return true;
        } catch {
          return false;
        }
      }
      get readdir() {
        return readdir;
      }
      get readDirsInDir() {
        return readDirsInDir;
      }
      get writeFile() {
        return writeFile2;
      }
      get rm() {
        return rimraf;
      }
      get rename() {
        return rename;
      }
      get copy() {
        return copy;
      }
    }();
  }
});

// out-build/vs/base/node/unc.js
function getUNCHostAllowlist() {
  const allowlist = processUNCHostAllowlist();
  if (allowlist) {
    return Array.from(allowlist);
  }
  return [];
}
function processUNCHostAllowlist() {
  return process.uncHostAllowlist;
}
function addUNCHostToAllowlist(allowedHost) {
  if (process.platform !== "win32") {
    return;
  }
  const allowlist = processUNCHostAllowlist();
  if (allowlist) {
    if (typeof allowedHost === "string") {
      allowlist.add(allowedHost.toLowerCase());
    } else {
      for (const host of toSafeStringArray(allowedHost)) {
        addUNCHostToAllowlist(host);
      }
    }
  }
}
function toSafeStringArray(arg0) {
  const allowedUNCHosts = /* @__PURE__ */ new Set();
  if (Array.isArray(arg0)) {
    for (const host of arg0) {
      if (typeof host === "string") {
        allowedUNCHosts.add(host);
      }
    }
  }
  return Array.from(allowedUNCHosts);
}
function getUNCHost(maybeUNCPath) {
  if (typeof maybeUNCPath !== "string") {
    return void 0;
  }
  const uncRoots = [
    "\\\\.\\UNC\\",
    // DOS Device paths (https://learn.microsoft.com/en-us/dotnet/standard/io/file-path-formats)
    "\\\\?\\UNC\\",
    "\\\\"
    // standard UNC path
  ];
  let host = void 0;
  for (const uncRoot of uncRoots) {
    const indexOfUNCRoot = maybeUNCPath.indexOf(uncRoot);
    if (indexOfUNCRoot !== 0) {
      continue;
    }
    const indexOfUNCPath = maybeUNCPath.indexOf("\\", uncRoot.length);
    if (indexOfUNCPath === -1) {
      continue;
    }
    const hostCandidate = maybeUNCPath.substring(uncRoot.length, indexOfUNCPath);
    if (hostCandidate) {
      host = hostCandidate;
      break;
    }
  }
  return host;
}
function disableUNCAccessRestrictions() {
  if (process.platform !== "win32") {
    return;
  }
  process.restrictUNCAccess = false;
}
function isUNCAccessRestrictionsDisabled() {
  if (process.platform !== "win32") {
    return true;
  }
  return process.restrictUNCAccess === false;
}
var init_unc = __esm({
  "out-build/vs/base/node/unc.js"() {
    "use strict";
  }
});

// out-build/vs/platform/instantiation/common/instantiation.js
function storeServiceDependency(id2, target, index) {
  if (target[_util.DI_TARGET] === target) {
    target[_util.DI_DEPENDENCIES].push({ id: id2, index });
  } else {
    target[_util.DI_DEPENDENCIES] = [{ id: id2, index }];
    target[_util.DI_TARGET] = target;
  }
}
function createDecorator(serviceId) {
  if (_util.serviceIds.has(serviceId)) {
    return _util.serviceIds.get(serviceId);
  }
  const id2 = function(target, key, index) {
    if (arguments.length !== 3) {
      throw new Error("@IServiceName-decorator can only be used to decorate a parameter");
    }
    storeServiceDependency(id2, target, index);
  };
  id2.toString = () => serviceId;
  _util.serviceIds.set(serviceId, id2);
  return id2;
}
function refineServiceDecorator(serviceIdentifier) {
  return serviceIdentifier;
}
var _util, IInstantiationService;
var init_instantiation = __esm({
  "out-build/vs/platform/instantiation/common/instantiation.js"() {
    "use strict";
    (function(_util2) {
      _util2.serviceIds = /* @__PURE__ */ new Map();
      _util2.DI_TARGET = "$di$target";
      _util2.DI_DEPENDENCIES = "$di$dependencies";
      function getServiceDependencies(ctor) {
        return ctor[_util2.DI_DEPENDENCIES] || [];
      }
      _util2.getServiceDependencies = getServiceDependencies;
    })(_util || (_util = {}));
    IInstantiationService = createDecorator("instantiationService");
  }
});

// out-build/vs/platform/configuration/common/configuration.js
function isConfigurationOverrides(thing) {
  return thing && typeof thing === "object" && (!thing.overrideIdentifier || typeof thing.overrideIdentifier === "string") && (!thing.resource || thing.resource instanceof URI);
}
function isConfigurationUpdateOverrides(thing) {
  return thing && typeof thing === "object" && (!thing.overrideIdentifiers || Array.isArray(thing.overrideIdentifiers)) && !thing.overrideIdentifier && (!thing.resource || thing.resource instanceof URI);
}
function toValuesTree(properties, conflictReporter) {
  const root = /* @__PURE__ */ Object.create(null);
  for (const key in properties) {
    addToValueTree(root, key, properties[key], conflictReporter);
  }
  return root;
}
function addToValueTree(settingsTreeRoot, key, value, conflictReporter) {
  const segments = key.split(".");
  const last = segments.pop();
  let curr = settingsTreeRoot;
  for (let i = 0; i < segments.length; i++) {
    const s = segments[i];
    let obj = curr[s];
    switch (typeof obj) {
      case "undefined":
        obj = curr[s] = /* @__PURE__ */ Object.create(null);
        break;
      case "object":
        if (obj === null) {
          conflictReporter(`Ignoring ${key} as ${segments.slice(0, i + 1).join(".")} is null`);
          return;
        }
        break;
      default:
        conflictReporter(`Ignoring ${key} as ${segments.slice(0, i + 1).join(".")} is ${JSON.stringify(obj)}`);
        return;
    }
    curr = obj;
  }
  if (typeof curr === "object" && curr !== null) {
    try {
      curr[last] = value;
    } catch (e) {
      conflictReporter(`Ignoring ${key} as ${segments.join(".")} is ${JSON.stringify(curr)}`);
    }
  } else {
    conflictReporter(`Ignoring ${key} as ${segments.join(".")} is ${JSON.stringify(curr)}`);
  }
}
function removeFromValueTree(valueTree, key) {
  const segments = key.split(".");
  doRemoveFromValueTree(valueTree, segments);
}
function doRemoveFromValueTree(valueTree, segments) {
  if (!valueTree) {
    return;
  }
  const first2 = segments.shift();
  if (segments.length === 0) {
    delete valueTree[first2];
    return;
  }
  if (Object.keys(valueTree).indexOf(first2) !== -1) {
    const value = valueTree[first2];
    if (typeof value === "object" && !Array.isArray(value)) {
      doRemoveFromValueTree(value, segments);
      if (Object.keys(value).length === 0) {
        delete valueTree[first2];
      }
    }
  }
}
function getConfigurationValue(config, settingPath, defaultValue) {
  function accessSetting(config2, path5) {
    let current = config2;
    for (const component of path5) {
      if (typeof current !== "object" || current === null) {
        return void 0;
      }
      current = current[component];
    }
    return current;
  }
  const path4 = settingPath.split(".");
  const result = accessSetting(config, path4);
  return typeof result === "undefined" ? defaultValue : result;
}
function getLanguageTagSettingPlainKey(settingKey) {
  return settingKey.replace(/[\[\]]/g, "");
}
var IConfigurationService, ConfigurationTarget;
var init_configuration = __esm({
  "out-build/vs/platform/configuration/common/configuration.js"() {
    "use strict";
    init_assert();
    init_types();
    init_uri();
    init_instantiation();
    IConfigurationService = createDecorator("configurationService");
    (function(ConfigurationTarget2) {
      ConfigurationTarget2[ConfigurationTarget2["APPLICATION"] = 1] = "APPLICATION";
      ConfigurationTarget2[ConfigurationTarget2["USER"] = 2] = "USER";
      ConfigurationTarget2[ConfigurationTarget2["USER_LOCAL"] = 3] = "USER_LOCAL";
      ConfigurationTarget2[ConfigurationTarget2["USER_REMOTE"] = 4] = "USER_REMOTE";
      ConfigurationTarget2[ConfigurationTarget2["WORKSPACE"] = 5] = "WORKSPACE";
      ConfigurationTarget2[ConfigurationTarget2["WORKSPACE_FOLDER"] = 6] = "WORKSPACE_FOLDER";
      ConfigurationTarget2[ConfigurationTarget2["DEFAULT"] = 7] = "DEFAULT";
      ConfigurationTarget2[ConfigurationTarget2["MEMORY"] = 8] = "MEMORY";
    })(ConfigurationTarget || (ConfigurationTarget = {}));
  }
});

// out-build/vs/base/common/jsonSchema.js
function getCompressedContent(schema) {
  let hasDups = false;
  const equalsByString = /* @__PURE__ */ new Map();
  const nodeToEquals = /* @__PURE__ */ new Map();
  const visitSchemas = (next) => {
    if (schema === next) {
      return true;
    }
    const val = JSON.stringify(next);
    if (val.length < 30) {
      return true;
    }
    const eq2 = equalsByString.get(val);
    if (!eq2) {
      const newEq = { schemas: [next] };
      equalsByString.set(val, newEq);
      nodeToEquals.set(next, newEq);
      return true;
    }
    eq2.schemas.push(next);
    nodeToEquals.set(next, eq2);
    hasDups = true;
    return false;
  };
  traverseNodes(schema, visitSchemas);
  equalsByString.clear();
  if (!hasDups) {
    return JSON.stringify(schema);
  }
  let defNodeName = "$defs";
  while (schema.hasOwnProperty(defNodeName)) {
    defNodeName += "_";
  }
  const definitions = [];
  function stringify2(root) {
    return JSON.stringify(root, (_key, value) => {
      if (value !== root) {
        const eq2 = nodeToEquals.get(value);
        if (eq2 && eq2.schemas.length > 1) {
          if (!eq2.id) {
            eq2.id = `_${definitions.length}`;
            definitions.push(eq2.schemas[0]);
          }
          return { $ref: `#/${defNodeName}/${eq2.id}` };
        }
      }
      return value;
    });
  }
  const str = stringify2(schema);
  const defStrings = [];
  for (let i = 0; i < definitions.length; i++) {
    defStrings.push(`"_${i}":${stringify2(definitions[i])}`);
  }
  if (defStrings.length) {
    return `${str.substring(0, str.length - 1)},"${defNodeName}":{${defStrings.join(",")}}}`;
  }
  return str;
}
function isObject2(thing) {
  return typeof thing === "object" && thing !== null;
}
function traverseNodes(root, visit2) {
  if (!root || typeof root !== "object") {
    return;
  }
  const collectEntries = (...entries) => {
    for (const entry of entries) {
      if (isObject2(entry)) {
        toWalk.push(entry);
      }
    }
  };
  const collectMapEntries = (...maps) => {
    for (const map of maps) {
      if (isObject2(map)) {
        for (const key in map) {
          const entry = map[key];
          if (isObject2(entry)) {
            toWalk.push(entry);
          }
        }
      }
    }
  };
  const collectArrayEntries = (...arrays) => {
    for (const array of arrays) {
      if (Array.isArray(array)) {
        for (const entry of array) {
          if (isObject2(entry)) {
            toWalk.push(entry);
          }
        }
      }
    }
  };
  const collectEntryOrArrayEntries = (items) => {
    if (Array.isArray(items)) {
      for (const entry of items) {
        if (isObject2(entry)) {
          toWalk.push(entry);
        }
      }
    } else if (isObject2(items)) {
      toWalk.push(items);
    }
  };
  const toWalk = [root];
  let next = toWalk.pop();
  while (next) {
    const visitChildern = visit2(next);
    if (visitChildern) {
      collectEntries(next.additionalItems, next.additionalProperties, next.not, next.contains, next.propertyNames, next.if, next.then, next.else, next.unevaluatedItems, next.unevaluatedProperties);
      collectMapEntries(next.definitions, next.$defs, next.properties, next.patternProperties, next.dependencies, next.dependentSchemas);
      collectArrayEntries(next.anyOf, next.allOf, next.oneOf, next.prefixItems);
      collectEntryOrArrayEntries(next.items);
    }
    next = toWalk.pop();
  }
}
var init_jsonSchema = __esm({
  "out-build/vs/base/common/jsonSchema.js"() {
    "use strict";
  }
});

// out-build/vs/platform/registry/common/platform.js
var RegistryImpl, Registry;
var init_platform2 = __esm({
  "out-build/vs/platform/registry/common/platform.js"() {
    "use strict";
    init_assert();
    init_types();
    RegistryImpl = class {
      constructor() {
        this.data = /* @__PURE__ */ new Map();
      }
      add(id2, data) {
        ok(isString(id2));
        ok(isObject(data));
        ok(!this.data.has(id2), "There is already an extension with this id");
        this.data.set(id2, data);
      }
      knows(id2) {
        return this.data.has(id2);
      }
      as(id2) {
        return this.data.get(id2) || null;
      }
      dispose() {
        this.data.forEach((value) => {
          if (isFunction(value.dispose)) {
            value.dispose();
          }
        });
        this.data.clear();
      }
    };
    Registry = new RegistryImpl();
  }
});

// out-build/vs/platform/jsonschemas/common/jsonContributionRegistry.js
function normalizeId(id2) {
  if (id2.length > 0 && id2.charAt(id2.length - 1) === "#") {
    return id2.substring(0, id2.length - 1);
  }
  return id2;
}
var Extensions, JSONContributionRegistry, jsonContributionRegistry;
var init_jsonContributionRegistry = __esm({
  "out-build/vs/platform/jsonschemas/common/jsonContributionRegistry.js"() {
    "use strict";
    init_event();
    init_jsonSchema();
    init_lifecycle();
    init_platform2();
    Extensions = {
      JSONContribution: "base.contributions.json"
    };
    JSONContributionRegistry = class extends Disposable {
      constructor() {
        super(...arguments);
        this.schemasById = {};
        this.schemaAssociations = {};
        this._onDidChangeSchema = this._register(new Emitter());
        this.onDidChangeSchema = this._onDidChangeSchema.event;
        this._onDidChangeSchemaAssociations = this._register(new Emitter());
        this.onDidChangeSchemaAssociations = this._onDidChangeSchemaAssociations.event;
      }
      registerSchema(uri, unresolvedSchemaContent, store) {
        const normalizedUri = normalizeId(uri);
        this.schemasById[normalizedUri] = unresolvedSchemaContent;
        this._onDidChangeSchema.fire(uri);
        if (store) {
          store.add(toDisposable(() => {
            delete this.schemasById[normalizedUri];
            this._onDidChangeSchema.fire(uri);
          }));
        }
      }
      registerSchemaAssociation(uri, glob) {
        const normalizedUri = normalizeId(uri);
        if (!this.schemaAssociations[normalizedUri]) {
          this.schemaAssociations[normalizedUri] = [];
        }
        if (!this.schemaAssociations[normalizedUri].includes(glob)) {
          this.schemaAssociations[normalizedUri].push(glob);
          this._onDidChangeSchemaAssociations.fire();
        }
        return toDisposable(() => {
          const associations = this.schemaAssociations[normalizedUri];
          if (associations) {
            const index = associations.indexOf(glob);
            if (index !== -1) {
              associations.splice(index, 1);
              if (associations.length === 0) {
                delete this.schemaAssociations[normalizedUri];
              }
              this._onDidChangeSchemaAssociations.fire();
            }
          }
        });
      }
      notifySchemaChanged(uri) {
        this._onDidChangeSchema.fire(uri);
      }
      getSchemaContributions() {
        return {
          schemas: this.schemasById
        };
      }
      getSchemaContent(uri) {
        const schema = this.schemasById[uri];
        return schema ? getCompressedContent(schema) : void 0;
      }
      hasSchemaContent(uri) {
        return !!this.schemasById[uri];
      }
      getSchemaAssociations() {
        return this.schemaAssociations;
      }
    };
    jsonContributionRegistry = new JSONContributionRegistry();
    Registry.add(Extensions.JSONContribution, jsonContributionRegistry);
  }
});

// out-build/vs/platform/configuration/common/configurationRegistry.js
function overrideIdentifiersFromKey(key) {
  const identifiers = [];
  if (OVERRIDE_PROPERTY_REGEX.test(key)) {
    let matches = OVERRIDE_IDENTIFIER_REGEX.exec(key);
    while (matches?.length) {
      const identifier = matches[1].trim();
      if (identifier) {
        identifiers.push(identifier);
      }
      matches = OVERRIDE_IDENTIFIER_REGEX.exec(key);
    }
  }
  return distinct(identifiers);
}
function keyFromOverrideIdentifiers(overrideIdentifiers) {
  return overrideIdentifiers.reduce((result, overrideIdentifier) => `${result}[${overrideIdentifier}]`, "");
}
function getDefaultValue(type3) {
  const t = Array.isArray(type3) ? type3[0] : type3;
  switch (t) {
    case "boolean":
      return false;
    case "integer":
    case "number":
      return 0;
    case "string":
      return "";
    case "array":
      return [];
    case "object":
      return {};
    default:
      return null;
  }
}
function validateProperty(property, schema) {
  if (!property.trim()) {
    return localize(1793, null);
  }
  if (OVERRIDE_PROPERTY_REGEX.test(property)) {
    return localize(1794, null, property);
  }
  if (configurationRegistry.getConfigurationProperties()[property] !== void 0) {
    return localize(1795, null, property);
  }
  if (schema.policy?.name && configurationRegistry.getPolicyConfigurations().get(schema.policy?.name) !== void 0) {
    return localize(1796, null, property, schema.policy?.name, configurationRegistry.getPolicyConfigurations().get(schema.policy?.name));
  }
  return null;
}
var EditPresentationTypes, Extensions2, ConfigurationScope, allSettings, applicationSettings, applicationMachineSettings, machineSettings, machineOverridableSettings, windowSettings, resourceSettings, resourceLanguageSettingsSchemaId, contributionRegistry, ConfigurationRegistry, OVERRIDE_IDENTIFIER_PATTERN, OVERRIDE_IDENTIFIER_REGEX, OVERRIDE_PROPERTY_PATTERN, OVERRIDE_PROPERTY_REGEX, configurationRegistry;
var init_configurationRegistry = __esm({
  "out-build/vs/platform/configuration/common/configurationRegistry.js"() {
    "use strict";
    init_arrays();
    init_event();
    init_types();
    init_nls();
    init_configuration();
    init_jsonContributionRegistry();
    init_platform2();
    init_lifecycle();
    (function(EditPresentationTypes2) {
      EditPresentationTypes2["Multiline"] = "multilineText";
      EditPresentationTypes2["Singleline"] = "singlelineText";
    })(EditPresentationTypes || (EditPresentationTypes = {}));
    Extensions2 = {
      Configuration: "base.contributions.configuration"
    };
    (function(ConfigurationScope2) {
      ConfigurationScope2[ConfigurationScope2["APPLICATION"] = 1] = "APPLICATION";
      ConfigurationScope2[ConfigurationScope2["MACHINE"] = 2] = "MACHINE";
      ConfigurationScope2[ConfigurationScope2["APPLICATION_MACHINE"] = 3] = "APPLICATION_MACHINE";
      ConfigurationScope2[ConfigurationScope2["WINDOW"] = 4] = "WINDOW";
      ConfigurationScope2[ConfigurationScope2["RESOURCE"] = 5] = "RESOURCE";
      ConfigurationScope2[ConfigurationScope2["LANGUAGE_OVERRIDABLE"] = 6] = "LANGUAGE_OVERRIDABLE";
      ConfigurationScope2[ConfigurationScope2["MACHINE_OVERRIDABLE"] = 7] = "MACHINE_OVERRIDABLE";
    })(ConfigurationScope || (ConfigurationScope = {}));
    allSettings = { properties: {}, patternProperties: {} };
    applicationSettings = { properties: {}, patternProperties: {} };
    applicationMachineSettings = { properties: {}, patternProperties: {} };
    machineSettings = { properties: {}, patternProperties: {} };
    machineOverridableSettings = { properties: {}, patternProperties: {} };
    windowSettings = { properties: {}, patternProperties: {} };
    resourceSettings = { properties: {}, patternProperties: {} };
    resourceLanguageSettingsSchemaId = "vscode://schemas/settings/resourceLanguage";
    contributionRegistry = Registry.as(Extensions.JSONContribution);
    ConfigurationRegistry = class extends Disposable {
      constructor() {
        super();
        this.registeredConfigurationDefaults = [];
        this.overrideIdentifiers = /* @__PURE__ */ new Set();
        this._onDidSchemaChange = this._register(new Emitter());
        this.onDidSchemaChange = this._onDidSchemaChange.event;
        this._onDidUpdateConfiguration = this._register(new Emitter());
        this.onDidUpdateConfiguration = this._onDidUpdateConfiguration.event;
        this.configurationDefaultsOverrides = /* @__PURE__ */ new Map();
        this.defaultLanguageConfigurationOverridesNode = {
          id: "defaultOverrides",
          title: localize(1787, null),
          properties: {}
        };
        this.configurationContributors = [this.defaultLanguageConfigurationOverridesNode];
        this.resourceLanguageSettingsSchema = {
          properties: {},
          patternProperties: {},
          additionalProperties: true,
          allowTrailingCommas: true,
          allowComments: true
        };
        this.configurationProperties = {};
        this.policyConfigurations = /* @__PURE__ */ new Map();
        this.excludedConfigurationProperties = {};
        contributionRegistry.registerSchema(resourceLanguageSettingsSchemaId, this.resourceLanguageSettingsSchema);
        this.registerOverridePropertyPatternKey();
      }
      registerConfiguration(configuration, validate = true) {
        this.registerConfigurations([configuration], validate);
        return configuration;
      }
      registerConfigurations(configurations, validate = true) {
        const properties = /* @__PURE__ */ new Set();
        this.doRegisterConfigurations(configurations, validate, properties);
        contributionRegistry.registerSchema(resourceLanguageSettingsSchemaId, this.resourceLanguageSettingsSchema);
        this._onDidSchemaChange.fire();
        this._onDidUpdateConfiguration.fire({ properties });
      }
      deregisterConfigurations(configurations) {
        const properties = /* @__PURE__ */ new Set();
        this.doDeregisterConfigurations(configurations, properties);
        contributionRegistry.registerSchema(resourceLanguageSettingsSchemaId, this.resourceLanguageSettingsSchema);
        this._onDidSchemaChange.fire();
        this._onDidUpdateConfiguration.fire({ properties });
      }
      updateConfigurations({ add, remove: remove2 }) {
        const properties = /* @__PURE__ */ new Set();
        this.doDeregisterConfigurations(remove2, properties);
        this.doRegisterConfigurations(add, false, properties);
        contributionRegistry.registerSchema(resourceLanguageSettingsSchemaId, this.resourceLanguageSettingsSchema);
        this._onDidSchemaChange.fire();
        this._onDidUpdateConfiguration.fire({ properties });
      }
      registerDefaultConfigurations(configurationDefaults) {
        const properties = /* @__PURE__ */ new Set();
        this.doRegisterDefaultConfigurations(configurationDefaults, properties);
        this._onDidSchemaChange.fire();
        this._onDidUpdateConfiguration.fire({ properties, defaultsOverrides: true });
      }
      doRegisterDefaultConfigurations(configurationDefaults, bucket) {
        this.registeredConfigurationDefaults.push(...configurationDefaults);
        const overrideIdentifiers = [];
        for (const { overrides, source } of configurationDefaults) {
          for (const key in overrides) {
            bucket.add(key);
            const configurationDefaultOverridesForKey = this.configurationDefaultsOverrides.get(key) ?? this.configurationDefaultsOverrides.set(key, { configurationDefaultOverrides: [] }).get(key);
            const value = overrides[key];
            configurationDefaultOverridesForKey.configurationDefaultOverrides.push({ value, source });
            if (OVERRIDE_PROPERTY_REGEX.test(key)) {
              const newDefaultOverride = this.mergeDefaultConfigurationsForOverrideIdentifier(key, value, source, configurationDefaultOverridesForKey.configurationDefaultOverrideValue);
              if (!newDefaultOverride) {
                continue;
              }
              configurationDefaultOverridesForKey.configurationDefaultOverrideValue = newDefaultOverride;
              this.updateDefaultOverrideProperty(key, newDefaultOverride, source);
              overrideIdentifiers.push(...overrideIdentifiersFromKey(key));
            } else {
              const newDefaultOverride = this.mergeDefaultConfigurationsForConfigurationProperty(key, value, source, configurationDefaultOverridesForKey.configurationDefaultOverrideValue);
              if (!newDefaultOverride) {
                continue;
              }
              configurationDefaultOverridesForKey.configurationDefaultOverrideValue = newDefaultOverride;
              const property = this.configurationProperties[key];
              if (property) {
                this.updatePropertyDefaultValue(key, property);
                this.updateSchema(key, property);
              }
            }
          }
        }
        this.doRegisterOverrideIdentifiers(overrideIdentifiers);
      }
      deregisterDefaultConfigurations(defaultConfigurations) {
        const properties = /* @__PURE__ */ new Set();
        this.doDeregisterDefaultConfigurations(defaultConfigurations, properties);
        this._onDidSchemaChange.fire();
        this._onDidUpdateConfiguration.fire({ properties, defaultsOverrides: true });
      }
      doDeregisterDefaultConfigurations(defaultConfigurations, bucket) {
        for (const defaultConfiguration of defaultConfigurations) {
          const index = this.registeredConfigurationDefaults.indexOf(defaultConfiguration);
          if (index !== -1) {
            this.registeredConfigurationDefaults.splice(index, 1);
          }
        }
        for (const { overrides, source } of defaultConfigurations) {
          for (const key in overrides) {
            const configurationDefaultOverridesForKey = this.configurationDefaultsOverrides.get(key);
            if (!configurationDefaultOverridesForKey) {
              continue;
            }
            const index = configurationDefaultOverridesForKey.configurationDefaultOverrides.findIndex((configurationDefaultOverride) => source ? configurationDefaultOverride.source?.id === source.id : configurationDefaultOverride.value === overrides[key]);
            if (index === -1) {
              continue;
            }
            configurationDefaultOverridesForKey.configurationDefaultOverrides.splice(index, 1);
            if (configurationDefaultOverridesForKey.configurationDefaultOverrides.length === 0) {
              this.configurationDefaultsOverrides.delete(key);
            }
            if (OVERRIDE_PROPERTY_REGEX.test(key)) {
              let configurationDefaultOverrideValue;
              for (const configurationDefaultOverride of configurationDefaultOverridesForKey.configurationDefaultOverrides) {
                configurationDefaultOverrideValue = this.mergeDefaultConfigurationsForOverrideIdentifier(key, configurationDefaultOverride.value, configurationDefaultOverride.source, configurationDefaultOverrideValue);
              }
              if (configurationDefaultOverrideValue && !isEmptyObject(configurationDefaultOverrideValue.value)) {
                configurationDefaultOverridesForKey.configurationDefaultOverrideValue = configurationDefaultOverrideValue;
                this.updateDefaultOverrideProperty(key, configurationDefaultOverrideValue, source);
              } else {
                this.configurationDefaultsOverrides.delete(key);
                delete this.configurationProperties[key];
                delete this.defaultLanguageConfigurationOverridesNode.properties[key];
              }
            } else {
              let configurationDefaultOverrideValue;
              for (const configurationDefaultOverride of configurationDefaultOverridesForKey.configurationDefaultOverrides) {
                configurationDefaultOverrideValue = this.mergeDefaultConfigurationsForConfigurationProperty(key, configurationDefaultOverride.value, configurationDefaultOverride.source, configurationDefaultOverrideValue);
              }
              configurationDefaultOverridesForKey.configurationDefaultOverrideValue = configurationDefaultOverrideValue;
              const property = this.configurationProperties[key];
              if (property) {
                this.updatePropertyDefaultValue(key, property);
                this.updateSchema(key, property);
              }
            }
            bucket.add(key);
          }
        }
        this.updateOverridePropertyPatternKey();
      }
      updateDefaultOverrideProperty(key, newDefaultOverride, source) {
        const property = {
          type: "object",
          default: newDefaultOverride.value,
          description: localize(1788, null, getLanguageTagSettingPlainKey(key)),
          $ref: resourceLanguageSettingsSchemaId,
          defaultDefaultValue: newDefaultOverride.value,
          source,
          defaultValueSource: source
        };
        this.configurationProperties[key] = property;
        this.defaultLanguageConfigurationOverridesNode.properties[key] = property;
      }
      mergeDefaultConfigurationsForOverrideIdentifier(overrideIdentifier, configurationValueObject, valueSource, existingDefaultOverride) {
        const defaultValue = existingDefaultOverride?.value || {};
        const source = existingDefaultOverride?.source ?? /* @__PURE__ */ new Map();
        if (!(source instanceof Map)) {
          console.error("objectConfigurationSources is not a Map");
          return void 0;
        }
        for (const propertyKey of Object.keys(configurationValueObject)) {
          const propertyDefaultValue = configurationValueObject[propertyKey];
          const isObjectSetting = isObject(propertyDefaultValue) && (isUndefined(defaultValue[propertyKey]) || isObject(defaultValue[propertyKey]));
          if (isObjectSetting) {
            defaultValue[propertyKey] = { ...defaultValue[propertyKey] ?? {}, ...propertyDefaultValue };
            if (valueSource) {
              for (const objectKey in propertyDefaultValue) {
                source.set(`${propertyKey}.${objectKey}`, valueSource);
              }
            }
          } else {
            defaultValue[propertyKey] = propertyDefaultValue;
            if (valueSource) {
              source.set(propertyKey, valueSource);
            } else {
              source.delete(propertyKey);
            }
          }
        }
        return { value: defaultValue, source };
      }
      mergeDefaultConfigurationsForConfigurationProperty(propertyKey, value, valuesSource, existingDefaultOverride) {
        const property = this.configurationProperties[propertyKey];
        const existingDefaultValue = existingDefaultOverride?.value ?? property?.defaultDefaultValue;
        let source = valuesSource;
        const isObjectSetting = isObject(value) && (property !== void 0 && property.type === "object" || property === void 0 && (isUndefined(existingDefaultValue) || isObject(existingDefaultValue)));
        if (isObjectSetting) {
          source = existingDefaultOverride?.source ?? /* @__PURE__ */ new Map();
          if (!(source instanceof Map)) {
            console.error("defaultValueSource is not a Map");
            return void 0;
          }
          for (const objectKey in value) {
            if (valuesSource) {
              source.set(`${propertyKey}.${objectKey}`, valuesSource);
            }
          }
          value = { ...isObject(existingDefaultValue) ? existingDefaultValue : {}, ...value };
        }
        return { value, source };
      }
      deltaConfiguration(delta) {
        let defaultsOverrides = false;
        const properties = /* @__PURE__ */ new Set();
        if (delta.removedDefaults) {
          this.doDeregisterDefaultConfigurations(delta.removedDefaults, properties);
          defaultsOverrides = true;
        }
        if (delta.addedDefaults) {
          this.doRegisterDefaultConfigurations(delta.addedDefaults, properties);
          defaultsOverrides = true;
        }
        if (delta.removedConfigurations) {
          this.doDeregisterConfigurations(delta.removedConfigurations, properties);
        }
        if (delta.addedConfigurations) {
          this.doRegisterConfigurations(delta.addedConfigurations, false, properties);
        }
        this._onDidSchemaChange.fire();
        this._onDidUpdateConfiguration.fire({ properties, defaultsOverrides });
      }
      notifyConfigurationSchemaUpdated(...configurations) {
        this._onDidSchemaChange.fire();
      }
      registerOverrideIdentifiers(overrideIdentifiers) {
        this.doRegisterOverrideIdentifiers(overrideIdentifiers);
        this._onDidSchemaChange.fire();
      }
      doRegisterOverrideIdentifiers(overrideIdentifiers) {
        for (const overrideIdentifier of overrideIdentifiers) {
          this.overrideIdentifiers.add(overrideIdentifier);
        }
        this.updateOverridePropertyPatternKey();
      }
      doRegisterConfigurations(configurations, validate, bucket) {
        configurations.forEach((configuration) => {
          this.validateAndRegisterProperties(configuration, validate, configuration.extensionInfo, configuration.restrictedProperties, void 0, bucket);
          this.configurationContributors.push(configuration);
          this.registerJSONConfiguration(configuration);
        });
      }
      doDeregisterConfigurations(configurations, bucket) {
        const deregisterConfiguration = (configuration) => {
          if (configuration.properties) {
            for (const key in configuration.properties) {
              bucket.add(key);
              const property = this.configurationProperties[key];
              if (property?.policy?.name) {
                this.policyConfigurations.delete(property.policy.name);
              }
              delete this.configurationProperties[key];
              this.removeFromSchema(key, configuration.properties[key]);
            }
          }
          configuration.allOf?.forEach((node) => deregisterConfiguration(node));
        };
        for (const configuration of configurations) {
          deregisterConfiguration(configuration);
          const index = this.configurationContributors.indexOf(configuration);
          if (index !== -1) {
            this.configurationContributors.splice(index, 1);
          }
        }
      }
      validateAndRegisterProperties(configuration, validate = true, extensionInfo, restrictedProperties, scope = 4, bucket) {
        scope = isUndefinedOrNull(configuration.scope) ? scope : configuration.scope;
        const properties = configuration.properties;
        if (properties) {
          for (const key in properties) {
            const property = properties[key];
            if (validate && validateProperty(key, property)) {
              delete properties[key];
              continue;
            }
            property.source = extensionInfo;
            property.defaultDefaultValue = properties[key].default;
            this.updatePropertyDefaultValue(key, property);
            if (OVERRIDE_PROPERTY_REGEX.test(key)) {
              property.scope = void 0;
            } else {
              property.scope = isUndefinedOrNull(property.scope) ? scope : property.scope;
              property.restricted = isUndefinedOrNull(property.restricted) ? !!restrictedProperties?.includes(key) : property.restricted;
            }
            const excluded = properties[key].hasOwnProperty("included") && !properties[key].included;
            const policyName = properties[key].policy?.name;
            if (excluded) {
              this.excludedConfigurationProperties[key] = properties[key];
              if (policyName) {
                this.policyConfigurations.set(policyName, key);
                bucket.add(key);
              }
              delete properties[key];
            } else {
              bucket.add(key);
              if (policyName) {
                this.policyConfigurations.set(policyName, key);
              }
              this.configurationProperties[key] = properties[key];
              if (!properties[key].deprecationMessage && properties[key].markdownDeprecationMessage) {
                properties[key].deprecationMessage = properties[key].markdownDeprecationMessage;
              }
            }
          }
        }
        const subNodes = configuration.allOf;
        if (subNodes) {
          for (const node of subNodes) {
            this.validateAndRegisterProperties(node, validate, extensionInfo, restrictedProperties, scope, bucket);
          }
        }
      }
      // TODO: @sandy081 - Remove this method and include required info in getConfigurationProperties
      getConfigurations() {
        return this.configurationContributors;
      }
      getConfigurationProperties() {
        return this.configurationProperties;
      }
      getPolicyConfigurations() {
        return this.policyConfigurations;
      }
      getExcludedConfigurationProperties() {
        return this.excludedConfigurationProperties;
      }
      getRegisteredDefaultConfigurations() {
        return [...this.registeredConfigurationDefaults];
      }
      getConfigurationDefaultsOverrides() {
        const configurationDefaultsOverrides = /* @__PURE__ */ new Map();
        for (const [key, value] of this.configurationDefaultsOverrides) {
          if (value.configurationDefaultOverrideValue) {
            configurationDefaultsOverrides.set(key, value.configurationDefaultOverrideValue);
          }
        }
        return configurationDefaultsOverrides;
      }
      registerJSONConfiguration(configuration) {
        const register3 = (configuration2) => {
          const properties = configuration2.properties;
          if (properties) {
            for (const key in properties) {
              this.updateSchema(key, properties[key]);
            }
          }
          const subNodes = configuration2.allOf;
          subNodes?.forEach(register3);
        };
        register3(configuration);
      }
      updateSchema(key, property) {
        allSettings.properties[key] = property;
        switch (property.scope) {
          case 1:
            applicationSettings.properties[key] = property;
            break;
          case 2:
            machineSettings.properties[key] = property;
            break;
          case 3:
            applicationMachineSettings.properties[key] = property;
            break;
          case 7:
            machineOverridableSettings.properties[key] = property;
            break;
          case 4:
            windowSettings.properties[key] = property;
            break;
          case 5:
            resourceSettings.properties[key] = property;
            break;
          case 6:
            resourceSettings.properties[key] = property;
            this.resourceLanguageSettingsSchema.properties[key] = property;
            break;
        }
      }
      removeFromSchema(key, property) {
        delete allSettings.properties[key];
        switch (property.scope) {
          case 1:
            delete applicationSettings.properties[key];
            break;
          case 2:
            delete machineSettings.properties[key];
            break;
          case 3:
            delete applicationMachineSettings.properties[key];
            break;
          case 7:
            delete machineOverridableSettings.properties[key];
            break;
          case 4:
            delete windowSettings.properties[key];
            break;
          case 5:
          case 6:
            delete resourceSettings.properties[key];
            delete this.resourceLanguageSettingsSchema.properties[key];
            break;
        }
      }
      updateOverridePropertyPatternKey() {
        for (const overrideIdentifier of this.overrideIdentifiers.values()) {
          const overrideIdentifierProperty = `[${overrideIdentifier}]`;
          const resourceLanguagePropertiesSchema = {
            type: "object",
            description: localize(1789, null),
            errorMessage: localize(1790, null),
            $ref: resourceLanguageSettingsSchemaId
          };
          this.updatePropertyDefaultValue(overrideIdentifierProperty, resourceLanguagePropertiesSchema);
          allSettings.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
          applicationSettings.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
          applicationMachineSettings.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
          machineSettings.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
          machineOverridableSettings.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
          windowSettings.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
          resourceSettings.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
        }
      }
      registerOverridePropertyPatternKey() {
        const resourceLanguagePropertiesSchema = {
          type: "object",
          description: localize(1791, null),
          errorMessage: localize(1792, null),
          $ref: resourceLanguageSettingsSchemaId
        };
        allSettings.patternProperties[OVERRIDE_PROPERTY_PATTERN] = resourceLanguagePropertiesSchema;
        applicationSettings.patternProperties[OVERRIDE_PROPERTY_PATTERN] = resourceLanguagePropertiesSchema;
        applicationMachineSettings.patternProperties[OVERRIDE_PROPERTY_PATTERN] = resourceLanguagePropertiesSchema;
        machineSettings.patternProperties[OVERRIDE_PROPERTY_PATTERN] = resourceLanguagePropertiesSchema;
        machineOverridableSettings.patternProperties[OVERRIDE_PROPERTY_PATTERN] = resourceLanguagePropertiesSchema;
        windowSettings.patternProperties[OVERRIDE_PROPERTY_PATTERN] = resourceLanguagePropertiesSchema;
        resourceSettings.patternProperties[OVERRIDE_PROPERTY_PATTERN] = resourceLanguagePropertiesSchema;
        this._onDidSchemaChange.fire();
      }
      updatePropertyDefaultValue(key, property) {
        const configurationdefaultOverride = this.configurationDefaultsOverrides.get(key)?.configurationDefaultOverrideValue;
        let defaultValue = void 0;
        let defaultSource = void 0;
        if (configurationdefaultOverride && (!property.disallowConfigurationDefault || !configurationdefaultOverride.source)) {
          defaultValue = configurationdefaultOverride.value;
          defaultSource = configurationdefaultOverride.source;
        }
        if (isUndefined(defaultValue)) {
          defaultValue = property.defaultDefaultValue;
          defaultSource = void 0;
        }
        if (isUndefined(defaultValue)) {
          defaultValue = getDefaultValue(property.type);
        }
        property.default = defaultValue;
        property.defaultValueSource = defaultSource;
      }
    };
    OVERRIDE_IDENTIFIER_PATTERN = `\\[([^\\]]+)\\]`;
    OVERRIDE_IDENTIFIER_REGEX = new RegExp(OVERRIDE_IDENTIFIER_PATTERN, "g");
    OVERRIDE_PROPERTY_PATTERN = `^(${OVERRIDE_IDENTIFIER_PATTERN})+$`;
    OVERRIDE_PROPERTY_REGEX = new RegExp(OVERRIDE_PROPERTY_PATTERN);
    configurationRegistry = new ConfigurationRegistry();
    Registry.add(Extensions2.Configuration, configurationRegistry);
  }
});

// out-build/vs/platform/update/common/update.config.contribution.js
var configurationRegistry2;
var init_update_config_contribution = __esm({
  "out-build/vs/platform/update/common/update.config.contribution.js"() {
    "use strict";
    init_platform();
    init_nls();
    init_configurationRegistry();
    init_platform2();
    configurationRegistry2 = Registry.as(Extensions2.Configuration);
    configurationRegistry2.registerConfiguration({
      id: "update",
      order: 15,
      title: localize(2603, null),
      type: "object",
      properties: {
        "update.mode": {
          type: "string",
          enum: ["none", "manual", "start", "default"],
          default: "manual",
          scope: 1,
          description: localize(2604, null),
          tags: ["usesOnlineServices"],
          enumDescriptions: [
            localize(2605, null),
            localize(2606, null),
            localize(2607, null),
            localize(2608, null)
          ],
          policy: {
            name: "UpdateMode",
            minimumVersion: "1.67"
          }
        },
        "update.channel": {
          type: "string",
          default: "default",
          scope: 1,
          description: localize(2609, null),
          deprecationMessage: localize(2610, null, "update.mode")
        },
        "update.enableWindowsBackgroundUpdates": {
          type: "boolean",
          default: true,
          scope: 1,
          title: localize(2611, null),
          description: localize(2612, null),
          included: isWindows2 && !isWeb
        },
        "update.showReleaseNotes": {
          type: "boolean",
          default: true,
          scope: 1,
          description: localize(2613, null),
          tags: ["usesOnlineServices"]
        }
      }
    });
  }
});

// out-build/vs/base/common/errorMessage.js
function exceptionToErrorMessage(exception, verbose) {
  if (verbose && (exception.stack || exception.stacktrace)) {
    return localize(110, null, detectSystemErrorMessage(exception), stackToString(exception.stack) || stackToString(exception.stacktrace));
  }
  return detectSystemErrorMessage(exception);
}
function stackToString(stack) {
  if (Array.isArray(stack)) {
    return stack.join("\n");
  }
  return stack;
}
function detectSystemErrorMessage(exception) {
  if (exception.code === "ERR_UNC_HOST_NOT_ALLOWED") {
    return `${exception.message}. Please update the 'security.allowedUNCHosts' setting if you want to allow this host.`;
  }
  if (typeof exception.code === "string" && typeof exception.errno === "number" && typeof exception.syscall === "string") {
    return localize(111, null, exception.message);
  }
  return exception.message || localize(112, null);
}
function toErrorMessage(error = null, verbose = false) {
  if (!error) {
    return localize(113, null);
  }
  if (Array.isArray(error)) {
    const errors = coalesce(error);
    const msg = toErrorMessage(errors[0], verbose);
    if (errors.length > 1) {
      return localize(114, null, msg, errors.length);
    }
    return msg;
  }
  if (isString(error)) {
    return error;
  }
  if (error.detail) {
    const detail = error.detail;
    if (detail.error) {
      return exceptionToErrorMessage(detail.error, verbose);
    }
    if (detail.exception) {
      return exceptionToErrorMessage(detail.exception, verbose);
    }
  }
  if (error.stack) {
    return exceptionToErrorMessage(error, verbose);
  }
  if (error.message) {
    return error.message;
  }
  return localize(115, null);
}
var init_errorMessage = __esm({
  "out-build/vs/base/common/errorMessage.js"() {
    "use strict";
    init_arrays();
    init_types();
    init_nls();
  }
});

// out-build/vs/base/common/labels.js
function getPathLabel(resource, formatting) {
  const { os: os6, tildify: tildifier, relative: relatifier } = formatting;
  if (relatifier) {
    const relativePath2 = getRelativePathLabel(resource, relatifier, os6);
    if (typeof relativePath2 === "string") {
      return relativePath2;
    }
  }
  let absolutePath = resource.fsPath;
  if (os6 === 1 && !isWindows2) {
    absolutePath = absolutePath.replace(/\//g, "\\");
  } else if (os6 !== 1 && isWindows2) {
    absolutePath = absolutePath.replace(/\\/g, "/");
  }
  if (os6 !== 1 && tildifier?.userHome) {
    const userHome = tildifier.userHome.fsPath;
    let userHomeCandidate;
    if (resource.scheme !== tildifier.userHome.scheme && resource.path[0] === posix.sep && resource.path[1] !== posix.sep) {
      userHomeCandidate = tildifier.userHome.with({ path: resource.path }).fsPath;
    } else {
      userHomeCandidate = absolutePath;
    }
    absolutePath = tildify(userHomeCandidate, userHome, os6);
  }
  const pathLib = os6 === 1 ? win32 : posix;
  return pathLib.normalize(normalizeDriveLetter(
    absolutePath,
    os6 === 1
    /* OperatingSystem.Windows */
  ));
}
function getRelativePathLabel(resource, relativePathProvider, os6) {
  const pathLib = os6 === 1 ? win32 : posix;
  const extUriLib = os6 === 3 ? extUri : extUriIgnorePathCase;
  const workspace = relativePathProvider.getWorkspace();
  const firstFolder = workspace.folders.at(0);
  if (!firstFolder) {
    return void 0;
  }
  if (resource.scheme !== firstFolder.uri.scheme && resource.path[0] === posix.sep && resource.path[1] !== posix.sep) {
    resource = firstFolder.uri.with({ path: resource.path });
  }
  const folder = relativePathProvider.getWorkspaceFolder(resource);
  if (!folder) {
    return void 0;
  }
  let relativePathLabel = void 0;
  if (extUriLib.isEqual(folder.uri, resource)) {
    relativePathLabel = "";
  } else {
    relativePathLabel = extUriLib.relativePath(folder.uri, resource) ?? "";
  }
  if (relativePathLabel) {
    relativePathLabel = pathLib.normalize(relativePathLabel);
  }
  if (workspace.folders.length > 1 && !relativePathProvider.noPrefix) {
    const rootName = folder.name ? folder.name : extUriLib.basenameOrAuthority(folder.uri);
    relativePathLabel = relativePathLabel ? `${rootName} \u2022 ${relativePathLabel}` : rootName;
  }
  return relativePathLabel;
}
function normalizeDriveLetter(path4, isWindowsOS = isWindows2) {
  if (hasDriveLetter(path4, isWindowsOS)) {
    return path4.charAt(0).toUpperCase() + path4.slice(1);
  }
  return path4;
}
function tildify(path4, userHome, os6 = OS) {
  if (os6 === 1 || !path4 || !userHome) {
    return path4;
  }
  let normalizedUserHome = normalizedUserHomeCached.original === userHome ? normalizedUserHomeCached.normalized : void 0;
  if (!normalizedUserHome) {
    normalizedUserHome = userHome;
    if (isWindows2) {
      normalizedUserHome = toSlashes(normalizedUserHome);
    }
    normalizedUserHome = `${rtrim(normalizedUserHome, posix.sep)}${posix.sep}`;
    normalizedUserHomeCached = { original: userHome, normalized: normalizedUserHome };
  }
  let normalizedPath = path4;
  if (isWindows2) {
    normalizedPath = toSlashes(normalizedPath);
  }
  if (os6 === 3 ? normalizedPath.startsWith(normalizedUserHome) : startsWithIgnoreCase(normalizedPath, normalizedUserHome)) {
    return `~/${normalizedPath.substr(normalizedUserHome.length)}`;
  }
  return path4;
}
function mnemonicMenuLabel(label, forceDisableMnemonics) {
  if (isMacintosh || forceDisableMnemonics) {
    return label.replace(/\(&&\w\)|&&/g, "").replace(/&/g, isMacintosh ? "&" : "&&");
  }
  return label.replace(/&&|&/g, (m) => m === "&" ? "&&" : "&");
}
function mnemonicButtonLabel(label, forceDisableMnemonics) {
  const withoutMnemonic = label.replace(/\(&&\w\)|&&/g, "");
  if (forceDisableMnemonics) {
    return withoutMnemonic;
  }
  if (isMacintosh) {
    return { withMnemonic: withoutMnemonic, withoutMnemonic };
  }
  let withMnemonic;
  if (isWindows2) {
    withMnemonic = label.replace(/&&|&/g, (m) => m === "&" ? "&&" : "&");
  } else {
    withMnemonic = label.replace(/&&/g, "_");
  }
  return { withMnemonic, withoutMnemonic };
}
function splitRecentLabel(recentLabel) {
  if (recentLabel.endsWith("]")) {
    const lastIndexOfSquareBracket = recentLabel.lastIndexOf(" [", recentLabel.length - 2);
    if (lastIndexOfSquareBracket !== -1) {
      const split = splitName(recentLabel.substring(0, lastIndexOfSquareBracket));
      const remoteNameWithSpace = recentLabel.substring(lastIndexOfSquareBracket);
      return { name: split.name + remoteNameWithSpace, parentPath: split.parentPath };
    }
  }
  return splitName(recentLabel);
}
function splitName(fullPath) {
  const p = fullPath.indexOf("/") !== -1 ? posix : win32;
  const name = p.basename(fullPath);
  const parentPath = p.dirname(fullPath);
  if (name.length) {
    return { name, parentPath };
  }
  return { name: parentPath, parentPath: "" };
}
var normalizedUserHomeCached, Type;
var init_labels = __esm({
  "out-build/vs/base/common/labels.js"() {
    "use strict";
    init_extpath();
    init_path();
    init_platform();
    init_resources();
    init_strings();
    normalizedUserHomeCached = /* @__PURE__ */ Object.create(null);
    (function(Type2) {
      Type2[Type2["TEXT"] = 0] = "TEXT";
      Type2[Type2["VARIABLE"] = 1] = "VARIABLE";
      Type2[Type2["SEPARATOR"] = 2] = "SEPARATOR";
    })(Type || (Type = {}));
  }
});

// out-build/vs/base/common/stream.js
function isReadableStream(obj) {
  const candidate = obj;
  if (!candidate) {
    return false;
  }
  return [candidate.on, candidate.pause, candidate.resume, candidate.destroy].every((fn) => typeof fn === "function");
}
function isReadableBufferedStream(obj) {
  const candidate = obj;
  if (!candidate) {
    return false;
  }
  return isReadableStream(candidate.stream) && Array.isArray(candidate.buffer) && typeof candidate.ended === "boolean";
}
function newWriteableStream(reducer, options) {
  return new WriteableStreamImpl(reducer, options);
}
function consumeReadable(readable, reducer) {
  const chunks = [];
  let chunk;
  while ((chunk = readable.read()) !== null) {
    chunks.push(chunk);
  }
  return reducer(chunks);
}
function peekReadable(readable, reducer, maxChunks) {
  const chunks = [];
  let chunk = void 0;
  while ((chunk = readable.read()) !== null && chunks.length < maxChunks) {
    chunks.push(chunk);
  }
  if (chunk === null && chunks.length > 0) {
    return reducer(chunks);
  }
  return {
    read: () => {
      if (chunks.length > 0) {
        return chunks.shift();
      }
      if (typeof chunk !== "undefined") {
        const lastReadChunk = chunk;
        chunk = void 0;
        return lastReadChunk;
      }
      return readable.read();
    }
  };
}
function consumeStream(stream, reducer) {
  return new Promise((resolve3, reject) => {
    const chunks = [];
    listenStream(stream, {
      onData: (chunk) => {
        if (reducer) {
          chunks.push(chunk);
        }
      },
      onError: (error) => {
        if (reducer) {
          reject(error);
        } else {
          resolve3(void 0);
        }
      },
      onEnd: () => {
        if (reducer) {
          resolve3(reducer(chunks));
        } else {
          resolve3(void 0);
        }
      }
    });
  });
}
function listenStream(stream, listener, token) {
  stream.on("error", (error) => {
    if (!token?.isCancellationRequested) {
      listener.onError(error);
    }
  });
  stream.on("end", () => {
    if (!token?.isCancellationRequested) {
      listener.onEnd();
    }
  });
  stream.on("data", (data) => {
    if (!token?.isCancellationRequested) {
      listener.onData(data);
    }
  });
}
function peekStream(stream, maxChunks) {
  return new Promise((resolve3, reject) => {
    const streamListeners = new DisposableStore();
    const buffer = [];
    const dataListener = (chunk) => {
      buffer.push(chunk);
      if (buffer.length > maxChunks) {
        streamListeners.dispose();
        stream.pause();
        return resolve3({ stream, buffer, ended: false });
      }
    };
    const errorListener = (error) => {
      streamListeners.dispose();
      return reject(error);
    };
    const endListener = () => {
      streamListeners.dispose();
      return resolve3({ stream, buffer, ended: true });
    };
    streamListeners.add(toDisposable(() => stream.removeListener("error", errorListener)));
    stream.on("error", errorListener);
    streamListeners.add(toDisposable(() => stream.removeListener("end", endListener)));
    stream.on("end", endListener);
    streamListeners.add(toDisposable(() => stream.removeListener("data", dataListener)));
    stream.on("data", dataListener);
  });
}
function toReadable(t) {
  let consumed = false;
  return {
    read: () => {
      if (consumed) {
        return null;
      }
      consumed = true;
      return t;
    }
  };
}
function transform(stream, transformer, reducer) {
  const target = newWriteableStream(reducer);
  listenStream(stream, {
    onData: (data) => target.write(transformer.data(data)),
    onError: (error) => target.error(transformer.error ? transformer.error(error) : error),
    onEnd: () => target.end()
  });
  return target;
}
var WriteableStreamImpl;
var init_stream = __esm({
  "out-build/vs/base/common/stream.js"() {
    "use strict";
    init_errors();
    init_lifecycle();
    WriteableStreamImpl = class {
      /**
       * @param reducer a function that reduces the buffered data into a single object;
       * 				  because some objects can be complex and non-reducible, we also
       * 				  allow passing the explicit `null` value to skip the reduce step
       * @param options stream options
       */
      constructor(reducer, options) {
        this.reducer = reducer;
        this.options = options;
        this.state = {
          flowing: false,
          ended: false,
          destroyed: false
        };
        this.buffer = {
          data: [],
          error: []
        };
        this.listeners = {
          data: [],
          error: [],
          end: []
        };
        this.pendingWritePromises = [];
      }
      pause() {
        if (this.state.destroyed) {
          return;
        }
        this.state.flowing = false;
      }
      resume() {
        if (this.state.destroyed) {
          return;
        }
        if (!this.state.flowing) {
          this.state.flowing = true;
          this.flowData();
          this.flowErrors();
          this.flowEnd();
        }
      }
      write(data) {
        if (this.state.destroyed) {
          return;
        }
        if (this.state.flowing) {
          this.emitData(data);
        } else {
          this.buffer.data.push(data);
          if (typeof this.options?.highWaterMark === "number" && this.buffer.data.length > this.options.highWaterMark) {
            return new Promise((resolve3) => this.pendingWritePromises.push(resolve3));
          }
        }
      }
      error(error) {
        if (this.state.destroyed) {
          return;
        }
        if (this.state.flowing) {
          this.emitError(error);
        } else {
          this.buffer.error.push(error);
        }
      }
      end(result) {
        if (this.state.destroyed) {
          return;
        }
        if (typeof result !== "undefined") {
          this.write(result);
        }
        if (this.state.flowing) {
          this.emitEnd();
          this.destroy();
        } else {
          this.state.ended = true;
        }
      }
      emitData(data) {
        this.listeners.data.slice(0).forEach((listener) => listener(data));
      }
      emitError(error) {
        if (this.listeners.error.length === 0) {
          onUnexpectedError(error);
        } else {
          this.listeners.error.slice(0).forEach((listener) => listener(error));
        }
      }
      emitEnd() {
        this.listeners.end.slice(0).forEach((listener) => listener());
      }
      on(event, callback) {
        if (this.state.destroyed) {
          return;
        }
        switch (event) {
          case "data":
            this.listeners.data.push(callback);
            this.resume();
            break;
          case "end":
            this.listeners.end.push(callback);
            if (this.state.flowing && this.flowEnd()) {
              this.destroy();
            }
            break;
          case "error":
            this.listeners.error.push(callback);
            if (this.state.flowing) {
              this.flowErrors();
            }
            break;
        }
      }
      removeListener(event, callback) {
        if (this.state.destroyed) {
          return;
        }
        let listeners = void 0;
        switch (event) {
          case "data":
            listeners = this.listeners.data;
            break;
          case "end":
            listeners = this.listeners.end;
            break;
          case "error":
            listeners = this.listeners.error;
            break;
        }
        if (listeners) {
          const index = listeners.indexOf(callback);
          if (index >= 0) {
            listeners.splice(index, 1);
          }
        }
      }
      flowData() {
        if (this.buffer.data.length === 0) {
          return;
        }
        if (typeof this.reducer === "function") {
          const fullDataBuffer = this.reducer(this.buffer.data);
          this.emitData(fullDataBuffer);
        } else {
          for (const data of this.buffer.data) {
            this.emitData(data);
          }
        }
        this.buffer.data.length = 0;
        const pendingWritePromises = [...this.pendingWritePromises];
        this.pendingWritePromises.length = 0;
        pendingWritePromises.forEach((pendingWritePromise) => pendingWritePromise());
      }
      flowErrors() {
        if (this.listeners.error.length > 0) {
          for (const error of this.buffer.error) {
            this.emitError(error);
          }
          this.buffer.error.length = 0;
        }
      }
      flowEnd() {
        if (this.state.ended) {
          this.emitEnd();
          return this.listeners.end.length > 0;
        }
        return false;
      }
      destroy() {
        if (!this.state.destroyed) {
          this.state.destroyed = true;
          this.state.ended = true;
          this.buffer.data.length = 0;
          this.buffer.error.length = 0;
          this.listeners.data.length = 0;
          this.listeners.error.length = 0;
          this.listeners.end.length = 0;
          this.pendingWritePromises.length = 0;
        }
      }
    };
  }
});

// out-build/vs/base/common/buffer.js
function binaryIndexOf(haystack, needle, offset = 0) {
  const needleLen = needle.byteLength;
  const haystackLen = haystack.byteLength;
  if (needleLen === 0) {
    return 0;
  }
  if (needleLen === 1) {
    return haystack.indexOf(needle[0]);
  }
  if (needleLen > haystackLen - offset) {
    return -1;
  }
  const table = indexOfTable.value;
  table.fill(needle.length);
  for (let i2 = 0; i2 < needle.length; i2++) {
    table[needle[i2]] = needle.length - i2 - 1;
  }
  let i = offset + needle.length - 1;
  let j = i;
  let result = -1;
  while (i < haystackLen) {
    if (haystack[i] === needle[j]) {
      if (j === 0) {
        result = i;
        break;
      }
      i--;
      j--;
    } else {
      i += Math.max(needle.length - j, table[haystack[i]]);
      j = needle.length - 1;
    }
  }
  return result;
}
function readUInt32BE(source, offset) {
  return source[offset] * 2 ** 24 + source[offset + 1] * 2 ** 16 + source[offset + 2] * 2 ** 8 + source[offset + 3];
}
function writeUInt32BE(destination, value, offset) {
  destination[offset + 3] = value;
  value = value >>> 8;
  destination[offset + 2] = value;
  value = value >>> 8;
  destination[offset + 1] = value;
  value = value >>> 8;
  destination[offset] = value;
}
function readUInt32LE(source, offset) {
  return source[offset + 0] << 0 >>> 0 | source[offset + 1] << 8 >>> 0 | source[offset + 2] << 16 >>> 0 | source[offset + 3] << 24 >>> 0;
}
function writeUInt32LE(destination, value, offset) {
  destination[offset + 0] = value & 255;
  value = value >>> 8;
  destination[offset + 1] = value & 255;
  value = value >>> 8;
  destination[offset + 2] = value & 255;
  value = value >>> 8;
  destination[offset + 3] = value & 255;
}
function readUInt8(source, offset) {
  return source[offset];
}
function writeUInt8(destination, value, offset) {
  destination[offset] = value;
}
function readableToBuffer(readable) {
  return consumeReadable(readable, (chunks) => VSBuffer.concat(chunks));
}
function bufferToReadable(buffer) {
  return toReadable(buffer);
}
function streamToBuffer(stream) {
  return consumeStream(stream, (chunks) => VSBuffer.concat(chunks));
}
async function bufferedStreamToBuffer(bufferedStream) {
  if (bufferedStream.ended) {
    return VSBuffer.concat(bufferedStream.buffer);
  }
  return VSBuffer.concat([
    // Include already read chunks...
    ...bufferedStream.buffer,
    // ...and all additional chunks
    await streamToBuffer(bufferedStream.stream)
  ]);
}
function streamToBufferReadableStream(stream) {
  return transform(stream, { data: (data) => typeof data === "string" ? VSBuffer.fromString(data) : VSBuffer.wrap(data) }, (chunks) => VSBuffer.concat(chunks));
}
function newWriteableBufferStream(options) {
  return newWriteableStream((chunks) => VSBuffer.concat(chunks), options);
}
function encodeHex({ buffer }) {
  let result = "";
  for (let i = 0; i < buffer.length; i++) {
    const byte = buffer[i];
    result += hexChars[byte >>> 4];
    result += hexChars[byte & 15];
  }
  return result;
}
var hasBuffer, indexOfTable, textEncoder, textDecoder, VSBuffer, hexChars;
var init_buffer = __esm({
  "out-build/vs/base/common/buffer.js"() {
    "use strict";
    init_lazy();
    init_stream();
    hasBuffer = typeof Buffer !== "undefined";
    indexOfTable = new Lazy(() => new Uint8Array(256));
    VSBuffer = class _VSBuffer {
      /**
       * When running in a nodejs context, the backing store for the returned `VSBuffer` instance
       * might use a nodejs Buffer allocated from node's Buffer pool, which is not transferrable.
       */
      static alloc(byteLength) {
        if (hasBuffer) {
          return new _VSBuffer(Buffer.allocUnsafe(byteLength));
        } else {
          return new _VSBuffer(new Uint8Array(byteLength));
        }
      }
      /**
       * When running in a nodejs context, if `actual` is not a nodejs Buffer, the backing store for
       * the returned `VSBuffer` instance might use a nodejs Buffer allocated from node's Buffer pool,
       * which is not transferrable.
       */
      static wrap(actual) {
        if (hasBuffer && !Buffer.isBuffer(actual)) {
          actual = Buffer.from(actual.buffer, actual.byteOffset, actual.byteLength);
        }
        return new _VSBuffer(actual);
      }
      /**
       * When running in a nodejs context, the backing store for the returned `VSBuffer` instance
       * might use a nodejs Buffer allocated from node's Buffer pool, which is not transferrable.
       */
      static fromString(source, options) {
        const dontUseNodeBuffer = options?.dontUseNodeBuffer || false;
        if (!dontUseNodeBuffer && hasBuffer) {
          return new _VSBuffer(Buffer.from(source));
        } else {
          if (!textEncoder) {
            textEncoder = new TextEncoder();
          }
          return new _VSBuffer(textEncoder.encode(source));
        }
      }
      /**
       * When running in a nodejs context, the backing store for the returned `VSBuffer` instance
       * might use a nodejs Buffer allocated from node's Buffer pool, which is not transferrable.
       */
      static fromByteArray(source) {
        const result = _VSBuffer.alloc(source.length);
        for (let i = 0, len = source.length; i < len; i++) {
          result.buffer[i] = source[i];
        }
        return result;
      }
      /**
       * When running in a nodejs context, the backing store for the returned `VSBuffer` instance
       * might use a nodejs Buffer allocated from node's Buffer pool, which is not transferrable.
       */
      static concat(buffers, totalLength) {
        if (typeof totalLength === "undefined") {
          totalLength = 0;
          for (let i = 0, len = buffers.length; i < len; i++) {
            totalLength += buffers[i].byteLength;
          }
        }
        const ret = _VSBuffer.alloc(totalLength);
        let offset = 0;
        for (let i = 0, len = buffers.length; i < len; i++) {
          const element = buffers[i];
          ret.set(element, offset);
          offset += element.byteLength;
        }
        return ret;
      }
      constructor(buffer) {
        this.buffer = buffer;
        this.byteLength = this.buffer.byteLength;
      }
      /**
       * When running in a nodejs context, the backing store for the returned `VSBuffer` instance
       * might use a nodejs Buffer allocated from node's Buffer pool, which is not transferrable.
       */
      clone() {
        const result = _VSBuffer.alloc(this.byteLength);
        result.set(this);
        return result;
      }
      toString() {
        if (hasBuffer) {
          return this.buffer.toString();
        } else {
          if (!textDecoder) {
            textDecoder = new TextDecoder();
          }
          return textDecoder.decode(this.buffer);
        }
      }
      slice(start, end) {
        return new _VSBuffer(this.buffer.subarray(start, end));
      }
      set(array, offset) {
        if (array instanceof _VSBuffer) {
          this.buffer.set(array.buffer, offset);
        } else if (array instanceof Uint8Array) {
          this.buffer.set(array, offset);
        } else if (array instanceof ArrayBuffer) {
          this.buffer.set(new Uint8Array(array), offset);
        } else if (ArrayBuffer.isView(array)) {
          this.buffer.set(new Uint8Array(array.buffer, array.byteOffset, array.byteLength), offset);
        } else {
          throw new Error(`Unknown argument 'array'`);
        }
      }
      readUInt32BE(offset) {
        return readUInt32BE(this.buffer, offset);
      }
      writeUInt32BE(value, offset) {
        writeUInt32BE(this.buffer, value, offset);
      }
      readUInt32LE(offset) {
        return readUInt32LE(this.buffer, offset);
      }
      writeUInt32LE(value, offset) {
        writeUInt32LE(this.buffer, value, offset);
      }
      readUInt8(offset) {
        return readUInt8(this.buffer, offset);
      }
      writeUInt8(value, offset) {
        writeUInt8(this.buffer, value, offset);
      }
      indexOf(subarray, offset = 0) {
        return binaryIndexOf(this.buffer, subarray instanceof _VSBuffer ? subarray.buffer : subarray, offset);
      }
      equals(other) {
        if (this === other) {
          return true;
        }
        if (this.byteLength !== other.byteLength) {
          return false;
        }
        return this.buffer.every((value, index) => value === other.buffer[index]);
      }
    };
    hexChars = "0123456789abcdef";
  }
});

// out-build/vs/base/common/decorators/cancelPreviousCalls.js
var init_cancelPreviousCalls = __esm({
  "out-build/vs/base/common/decorators/cancelPreviousCalls.js"() {
    "use strict";
    init_types();
    init_lifecycle();
    init_cancellation();
  }
});

// out-build/vs/base/common/decorators.js
function memoize(_target, key, descriptor) {
  let fnKey = null;
  let fn = null;
  if (typeof descriptor.value === "function") {
    fnKey = "value";
    fn = descriptor.value;
    if (fn.length !== 0) {
      console.warn("Memoize should only be used in functions with zero parameters");
    }
  } else if (typeof descriptor.get === "function") {
    fnKey = "get";
    fn = descriptor.get;
  }
  if (!fn) {
    throw new Error("not supported");
  }
  const memoizeKey = `$memoize$${key}`;
  descriptor[fnKey] = function(...args2) {
    if (!this.hasOwnProperty(memoizeKey)) {
      Object.defineProperty(this, memoizeKey, {
        configurable: false,
        enumerable: false,
        writable: false,
        value: fn.apply(this, args2)
      });
    }
    return this[memoizeKey];
  };
}
var init_decorators = __esm({
  "out-build/vs/base/common/decorators.js"() {
    "use strict";
    init_cancelPreviousCalls();
  }
});

// out-build/vs/base/common/marshalling.js
function stringify(obj) {
  return JSON.stringify(obj, replacer);
}
function parse3(text) {
  let data = JSON.parse(text);
  data = revive(data);
  return data;
}
function replacer(key, value) {
  if (value instanceof RegExp) {
    return {
      $mid: 2,
      source: value.source,
      flags: value.flags
    };
  }
  return value;
}
function revive(obj, depth = 0) {
  if (!obj || depth > 200) {
    return obj;
  }
  if (typeof obj === "object") {
    switch (obj.$mid) {
      case 1:
        return URI.revive(obj);
      case 2:
        return new RegExp(obj.source, obj.flags);
      case 17:
        return new Date(obj.source);
    }
    if (obj instanceof VSBuffer || obj instanceof Uint8Array) {
      return obj;
    }
    if (Array.isArray(obj)) {
      for (let i = 0; i < obj.length; ++i) {
        obj[i] = revive(obj[i], depth + 1);
      }
    } else {
      for (const key in obj) {
        if (Object.hasOwnProperty.call(obj, key)) {
          obj[key] = revive(obj[key], depth + 1);
        }
      }
    }
  }
  return obj;
}
var init_marshalling = __esm({
  "out-build/vs/base/common/marshalling.js"() {
    "use strict";
    init_buffer();
    init_uri();
  }
});

// out-build/vs/base/parts/ipc/common/ipc.js
function requestTypeToStr(type3) {
  switch (type3) {
    case 100:
      return "req";
    case 101:
      return "cancel";
    case 102:
      return "subscribe";
    case 103:
      return "unsubscribe";
  }
}
function responseTypeToStr(type3) {
  switch (type3) {
    case 200:
      return `init`;
    case 201:
      return `reply:`;
    case 202:
    case 203:
      return `replyErr:`;
    case 204:
      return `event:`;
  }
}
function readIntVQL(reader) {
  let value = 0;
  for (let n = 0; ; n += 7) {
    const next = reader.read(1);
    value |= (next.buffer[0] & 127) << n;
    if (!(next.buffer[0] & 128)) {
      return value;
    }
  }
}
function writeInt32VQL(writer, value) {
  if (value === 0) {
    writer.write(vqlZero);
    return;
  }
  let len = 0;
  for (let v2 = value; v2 !== 0; v2 = v2 >>> 7) {
    len++;
  }
  const scratch = VSBuffer.alloc(len);
  for (let i = 0; value !== 0; i++) {
    scratch.buffer[i] = value & 127;
    value = value >>> 7;
    if (value > 0) {
      scratch.buffer[i] |= 128;
    }
  }
  writer.write(scratch);
}
function createOneByteBuffer(value) {
  const result = VSBuffer.alloc(1);
  result.writeUInt8(value, 0);
  return result;
}
function serialize(writer, data) {
  if (typeof data === "undefined") {
    writer.write(BufferPresets.Undefined);
  } else if (typeof data === "string") {
    const buffer = VSBuffer.fromString(data);
    writer.write(BufferPresets.String);
    writeInt32VQL(writer, buffer.byteLength);
    writer.write(buffer);
  } else if (hasBuffer2 && Buffer.isBuffer(data)) {
    const buffer = VSBuffer.wrap(data);
    writer.write(BufferPresets.Buffer);
    writeInt32VQL(writer, buffer.byteLength);
    writer.write(buffer);
  } else if (data instanceof VSBuffer) {
    writer.write(BufferPresets.VSBuffer);
    writeInt32VQL(writer, data.byteLength);
    writer.write(data);
  } else if (Array.isArray(data)) {
    writer.write(BufferPresets.Array);
    writeInt32VQL(writer, data.length);
    for (const el of data) {
      serialize(writer, el);
    }
  } else if (typeof data === "number" && (data | 0) === data) {
    writer.write(BufferPresets.Uint);
    writeInt32VQL(writer, data);
  } else {
    const buffer = VSBuffer.fromString(JSON.stringify(data));
    writer.write(BufferPresets.Object);
    writeInt32VQL(writer, buffer.byteLength);
    writer.write(buffer);
  }
}
function deserialize(reader) {
  const type3 = reader.read(1).readUInt8(0);
  switch (type3) {
    case DataType.Undefined:
      return void 0;
    case DataType.String:
      return reader.read(readIntVQL(reader)).toString();
    case DataType.Buffer:
      return reader.read(readIntVQL(reader)).buffer;
    case DataType.VSBuffer:
      return reader.read(readIntVQL(reader));
    case DataType.Array: {
      const length = readIntVQL(reader);
      const result = [];
      for (let i = 0; i < length; i++) {
        result.push(deserialize(reader));
      }
      return result;
    }
    case DataType.Object:
      return JSON.parse(reader.read(readIntVQL(reader)).toString());
    case DataType.Int:
      return readIntVQL(reader);
  }
}
function getDelayedChannel(promise) {
  return {
    call(command, arg, cancellationToken) {
      return promise.then((c) => c.call(command, arg, cancellationToken));
    },
    listen(event, arg) {
      const relay = new Relay();
      promise.then((c) => relay.input = c.listen(event, arg));
      return relay.event;
    }
  };
}
function getNextTickChannel(channel) {
  let didTick = false;
  return {
    call(command, arg, cancellationToken) {
      if (didTick) {
        return channel.call(command, arg, cancellationToken);
      }
      return timeout(0).then(() => didTick = true).then(() => channel.call(command, arg, cancellationToken));
    },
    listen(event, arg) {
      if (didTick) {
        return channel.listen(event, arg);
      }
      const relay = new Relay();
      timeout(0).then(() => didTick = true).then(() => relay.input = channel.listen(event, arg));
      return relay.event;
    }
  };
}
var RequestType, ResponseType, State, vqlZero, BufferReader, BufferWriter, DataType, BufferPresets, hasBuffer2, ChannelServer, RequestInitiator, ChannelClient, IPCServer, IPCClient, StaticRouter, ProxyChannel;
var init_ipc = __esm({
  "out-build/vs/base/parts/ipc/common/ipc.js"() {
    "use strict";
    init_arrays();
    init_async();
    init_buffer();
    init_cancellation();
    init_decorators();
    init_errors();
    init_event();
    init_functional();
    init_lifecycle();
    init_marshalling();
    init_strings();
    init_types();
    (function(RequestType2) {
      RequestType2[RequestType2["Promise"] = 100] = "Promise";
      RequestType2[RequestType2["PromiseCancel"] = 101] = "PromiseCancel";
      RequestType2[RequestType2["EventListen"] = 102] = "EventListen";
      RequestType2[RequestType2["EventDispose"] = 103] = "EventDispose";
    })(RequestType || (RequestType = {}));
    (function(ResponseType2) {
      ResponseType2[ResponseType2["Initialize"] = 200] = "Initialize";
      ResponseType2[ResponseType2["PromiseSuccess"] = 201] = "PromiseSuccess";
      ResponseType2[ResponseType2["PromiseError"] = 202] = "PromiseError";
      ResponseType2[ResponseType2["PromiseErrorObj"] = 203] = "PromiseErrorObj";
      ResponseType2[ResponseType2["EventFire"] = 204] = "EventFire";
    })(ResponseType || (ResponseType = {}));
    (function(State3) {
      State3[State3["Uninitialized"] = 0] = "Uninitialized";
      State3[State3["Idle"] = 1] = "Idle";
    })(State || (State = {}));
    vqlZero = createOneByteBuffer(0);
    BufferReader = class {
      constructor(buffer) {
        this.buffer = buffer;
        this.pos = 0;
      }
      read(bytes) {
        const result = this.buffer.slice(this.pos, this.pos + bytes);
        this.pos += result.byteLength;
        return result;
      }
    };
    BufferWriter = class {
      constructor() {
        this.buffers = [];
      }
      get buffer() {
        return VSBuffer.concat(this.buffers);
      }
      write(buffer) {
        this.buffers.push(buffer);
      }
    };
    (function(DataType2) {
      DataType2[DataType2["Undefined"] = 0] = "Undefined";
      DataType2[DataType2["String"] = 1] = "String";
      DataType2[DataType2["Buffer"] = 2] = "Buffer";
      DataType2[DataType2["VSBuffer"] = 3] = "VSBuffer";
      DataType2[DataType2["Array"] = 4] = "Array";
      DataType2[DataType2["Object"] = 5] = "Object";
      DataType2[DataType2["Int"] = 6] = "Int";
    })(DataType || (DataType = {}));
    BufferPresets = {
      Undefined: createOneByteBuffer(DataType.Undefined),
      String: createOneByteBuffer(DataType.String),
      Buffer: createOneByteBuffer(DataType.Buffer),
      VSBuffer: createOneByteBuffer(DataType.VSBuffer),
      Array: createOneByteBuffer(DataType.Array),
      Object: createOneByteBuffer(DataType.Object),
      Uint: createOneByteBuffer(DataType.Int)
    };
    hasBuffer2 = typeof Buffer !== "undefined";
    ChannelServer = class {
      constructor(protocol4, ctx, logger = null, timeoutDelay = 1e3) {
        this.protocol = protocol4;
        this.ctx = ctx;
        this.logger = logger;
        this.timeoutDelay = timeoutDelay;
        this.channels = /* @__PURE__ */ new Map();
        this.activeRequests = /* @__PURE__ */ new Map();
        this.pendingRequests = /* @__PURE__ */ new Map();
        this.protocolListener = this.protocol.onMessage((msg) => this.onRawMessage(msg));
        this.sendResponse({
          type: 200
          /* ResponseType.Initialize */
        });
      }
      registerChannel(channelName, channel) {
        this.channels.set(channelName, channel);
        setTimeout(() => this.flushPendingRequests(channelName), 0);
      }
      sendResponse(response) {
        switch (response.type) {
          case 200: {
            const msgLength = this.send([response.type]);
            this.logger?.logOutgoing(msgLength, 0, 1, responseTypeToStr(response.type));
            return;
          }
          case 201:
          case 202:
          case 204:
          case 203: {
            const msgLength = this.send([response.type, response.id], response.data);
            this.logger?.logOutgoing(msgLength, response.id, 1, responseTypeToStr(response.type), response.data);
            return;
          }
        }
      }
      send(header, body = void 0) {
        const writer = new BufferWriter();
        serialize(writer, header);
        serialize(writer, body);
        return this.sendBuffer(writer.buffer);
      }
      sendBuffer(message) {
        try {
          this.protocol.send(message);
          return message.byteLength;
        } catch (err) {
          return 0;
        }
      }
      onRawMessage(message) {
        const reader = new BufferReader(message);
        const header = deserialize(reader);
        const body = deserialize(reader);
        const type3 = header[0];
        switch (type3) {
          case 100:
            this.logger?.logIncoming(message.byteLength, header[1], 1, `${requestTypeToStr(type3)}: ${header[2]}.${header[3]}`, body);
            return this.onPromise({ type: type3, id: header[1], channelName: header[2], name: header[3], arg: body });
          case 102:
            this.logger?.logIncoming(message.byteLength, header[1], 1, `${requestTypeToStr(type3)}: ${header[2]}.${header[3]}`, body);
            return this.onEventListen({ type: type3, id: header[1], channelName: header[2], name: header[3], arg: body });
          case 101:
            this.logger?.logIncoming(message.byteLength, header[1], 1, `${requestTypeToStr(type3)}`);
            return this.disposeActiveRequest({ type: type3, id: header[1] });
          case 103:
            this.logger?.logIncoming(message.byteLength, header[1], 1, `${requestTypeToStr(type3)}`);
            return this.disposeActiveRequest({ type: type3, id: header[1] });
        }
      }
      onPromise(request) {
        const channel = this.channels.get(request.channelName);
        if (!channel) {
          this.collectPendingRequest(request);
          return;
        }
        const cancellationTokenSource = new CancellationTokenSource();
        let promise;
        try {
          promise = channel.call(this.ctx, request.name, request.arg, cancellationTokenSource.token);
        } catch (err) {
          promise = Promise.reject(err);
        }
        const id2 = request.id;
        promise.then((data) => {
          this.sendResponse({
            id: id2,
            data,
            type: 201
            /* ResponseType.PromiseSuccess */
          });
        }, (err) => {
          if (err instanceof Error) {
            this.sendResponse({
              id: id2,
              data: {
                message: err.message,
                name: err.name,
                stack: err.stack ? err.stack.split("\n") : void 0
              },
              type: 202
              /* ResponseType.PromiseError */
            });
          } else {
            this.sendResponse({
              id: id2,
              data: err,
              type: 203
              /* ResponseType.PromiseErrorObj */
            });
          }
        }).finally(() => {
          disposable.dispose();
          this.activeRequests.delete(request.id);
        });
        const disposable = toDisposable(() => cancellationTokenSource.cancel());
        this.activeRequests.set(request.id, disposable);
      }
      onEventListen(request) {
        const channel = this.channels.get(request.channelName);
        if (!channel) {
          this.collectPendingRequest(request);
          return;
        }
        const id2 = request.id;
        const event = channel.listen(this.ctx, request.name, request.arg);
        const disposable = event((data) => this.sendResponse({
          id: id2,
          data,
          type: 204
          /* ResponseType.EventFire */
        }));
        this.activeRequests.set(request.id, disposable);
      }
      disposeActiveRequest(request) {
        const disposable = this.activeRequests.get(request.id);
        if (disposable) {
          disposable.dispose();
          this.activeRequests.delete(request.id);
        }
      }
      collectPendingRequest(request) {
        let pendingRequests = this.pendingRequests.get(request.channelName);
        if (!pendingRequests) {
          pendingRequests = [];
          this.pendingRequests.set(request.channelName, pendingRequests);
        }
        const timer = setTimeout(() => {
          console.error(`Unknown channel: ${request.channelName}`);
          if (request.type === 100) {
            this.sendResponse({
              id: request.id,
              data: { name: "Unknown channel", message: `Channel name '${request.channelName}' timed out after ${this.timeoutDelay}ms`, stack: void 0 },
              type: 202
              /* ResponseType.PromiseError */
            });
          }
        }, this.timeoutDelay);
        pendingRequests.push({ request, timeoutTimer: timer });
      }
      flushPendingRequests(channelName) {
        const requests = this.pendingRequests.get(channelName);
        if (requests) {
          for (const request of requests) {
            clearTimeout(request.timeoutTimer);
            switch (request.request.type) {
              case 100:
                this.onPromise(request.request);
                break;
              case 102:
                this.onEventListen(request.request);
                break;
            }
          }
          this.pendingRequests.delete(channelName);
        }
      }
      dispose() {
        if (this.protocolListener) {
          this.protocolListener.dispose();
          this.protocolListener = null;
        }
        dispose(this.activeRequests.values());
        this.activeRequests.clear();
      }
    };
    (function(RequestInitiator2) {
      RequestInitiator2[RequestInitiator2["LocalSide"] = 0] = "LocalSide";
      RequestInitiator2[RequestInitiator2["OtherSide"] = 1] = "OtherSide";
    })(RequestInitiator || (RequestInitiator = {}));
    ChannelClient = class {
      constructor(protocol4, logger = null) {
        this.protocol = protocol4;
        this.isDisposed = false;
        this.state = State.Uninitialized;
        this.activeRequests = /* @__PURE__ */ new Set();
        this.handlers = /* @__PURE__ */ new Map();
        this.lastRequestId = 0;
        this._onDidInitialize = new Emitter();
        this.onDidInitialize = this._onDidInitialize.event;
        this.protocolListener = this.protocol.onMessage((msg) => this.onBuffer(msg));
        this.logger = logger;
      }
      getChannel(channelName) {
        const that = this;
        return {
          call(command, arg, cancellationToken) {
            if (that.isDisposed) {
              return Promise.reject(new CancellationError());
            }
            return that.requestPromise(channelName, command, arg, cancellationToken);
          },
          listen(event, arg) {
            if (that.isDisposed) {
              return Event.None;
            }
            return that.requestEvent(channelName, event, arg);
          }
        };
      }
      requestPromise(channelName, name, arg, cancellationToken = CancellationToken.None) {
        const id2 = this.lastRequestId++;
        const type3 = 100;
        const request = { id: id2, type: type3, channelName, name, arg };
        if (cancellationToken.isCancellationRequested) {
          return Promise.reject(new CancellationError());
        }
        let disposable;
        let disposableWithRequestCancel;
        const result = new Promise((c, e) => {
          if (cancellationToken.isCancellationRequested) {
            return e(new CancellationError());
          }
          const doRequest = () => {
            const handler = (response) => {
              switch (response.type) {
                case 201:
                  this.handlers.delete(id2);
                  c(response.data);
                  break;
                case 202: {
                  this.handlers.delete(id2);
                  const error = new Error(response.data.message);
                  error.stack = Array.isArray(response.data.stack) ? response.data.stack.join("\n") : response.data.stack;
                  error.name = response.data.name;
                  e(error);
                  break;
                }
                case 203:
                  this.handlers.delete(id2);
                  e(response.data);
                  break;
              }
            };
            this.handlers.set(id2, handler);
            this.sendRequest(request);
          };
          let uninitializedPromise = null;
          if (this.state === State.Idle) {
            doRequest();
          } else {
            uninitializedPromise = createCancelablePromise((_) => this.whenInitialized());
            uninitializedPromise.then(() => {
              uninitializedPromise = null;
              doRequest();
            });
          }
          const cancel = () => {
            if (uninitializedPromise) {
              uninitializedPromise.cancel();
              uninitializedPromise = null;
            } else {
              this.sendRequest({
                id: id2,
                type: 101
                /* RequestType.PromiseCancel */
              });
            }
            e(new CancellationError());
          };
          disposable = cancellationToken.onCancellationRequested(cancel);
          disposableWithRequestCancel = {
            dispose: createSingleCallFunction(() => {
              cancel();
              disposable.dispose();
            })
          };
          this.activeRequests.add(disposableWithRequestCancel);
        });
        return result.finally(() => {
          disposable?.dispose();
          this.activeRequests.delete(disposableWithRequestCancel);
        });
      }
      requestEvent(channelName, name, arg) {
        const id2 = this.lastRequestId++;
        const type3 = 102;
        const request = { id: id2, type: type3, channelName, name, arg };
        let uninitializedPromise = null;
        const emitter = new Emitter({
          onWillAddFirstListener: () => {
            const doRequest = () => {
              this.activeRequests.add(emitter);
              this.sendRequest(request);
            };
            if (this.state === State.Idle) {
              doRequest();
            } else {
              uninitializedPromise = createCancelablePromise((_) => this.whenInitialized());
              uninitializedPromise.then(() => {
                uninitializedPromise = null;
                doRequest();
              });
            }
          },
          onDidRemoveLastListener: () => {
            if (uninitializedPromise) {
              uninitializedPromise.cancel();
              uninitializedPromise = null;
            } else {
              this.activeRequests.delete(emitter);
              this.sendRequest({
                id: id2,
                type: 103
                /* RequestType.EventDispose */
              });
            }
          }
        });
        const handler = (res) => emitter.fire(res.data);
        this.handlers.set(id2, handler);
        return emitter.event;
      }
      sendRequest(request) {
        switch (request.type) {
          case 100:
          case 102: {
            const msgLength = this.send([request.type, request.id, request.channelName, request.name], request.arg);
            this.logger?.logOutgoing(msgLength, request.id, 0, `${requestTypeToStr(request.type)}: ${request.channelName}.${request.name}`, request.arg);
            return;
          }
          case 101:
          case 103: {
            const msgLength = this.send([request.type, request.id]);
            this.logger?.logOutgoing(msgLength, request.id, 0, requestTypeToStr(request.type));
            return;
          }
        }
      }
      send(header, body = void 0) {
        const writer = new BufferWriter();
        serialize(writer, header);
        serialize(writer, body);
        return this.sendBuffer(writer.buffer);
      }
      sendBuffer(message) {
        try {
          this.protocol.send(message);
          return message.byteLength;
        } catch (err) {
          return 0;
        }
      }
      onBuffer(message) {
        const reader = new BufferReader(message);
        const header = deserialize(reader);
        const body = deserialize(reader);
        const type3 = header[0];
        switch (type3) {
          case 200:
            this.logger?.logIncoming(message.byteLength, 0, 0, responseTypeToStr(type3));
            return this.onResponse({ type: header[0] });
          case 201:
          case 202:
          case 204:
          case 203:
            this.logger?.logIncoming(message.byteLength, header[1], 0, responseTypeToStr(type3), body);
            return this.onResponse({ type: header[0], id: header[1], data: body });
        }
      }
      onResponse(response) {
        if (response.type === 200) {
          this.state = State.Idle;
          this._onDidInitialize.fire();
          return;
        }
        const handler = this.handlers.get(response.id);
        handler?.(response);
      }
      get onDidInitializePromise() {
        return Event.toPromise(this.onDidInitialize);
      }
      whenInitialized() {
        if (this.state === State.Idle) {
          return Promise.resolve();
        } else {
          return this.onDidInitializePromise;
        }
      }
      dispose() {
        this.isDisposed = true;
        if (this.protocolListener) {
          this.protocolListener.dispose();
          this.protocolListener = null;
        }
        dispose(this.activeRequests.values());
        this.activeRequests.clear();
      }
    };
    __decorate([
      memoize
    ], ChannelClient.prototype, "onDidInitializePromise", null);
    IPCServer = class {
      get connections() {
        const result = [];
        this._connections.forEach((ctx) => result.push(ctx));
        return result;
      }
      constructor(onDidClientConnect, ipcLogger, timeoutDelay) {
        this.channels = /* @__PURE__ */ new Map();
        this._connections = /* @__PURE__ */ new Set();
        this._onDidAddConnection = new Emitter();
        this.onDidAddConnection = this._onDidAddConnection.event;
        this._onDidRemoveConnection = new Emitter();
        this.onDidRemoveConnection = this._onDidRemoveConnection.event;
        this.disposables = new DisposableStore();
        this.disposables.add(onDidClientConnect(({ protocol: protocol4, onDidClientDisconnect }) => {
          const onFirstMessage = Event.once(protocol4.onMessage);
          this.disposables.add(onFirstMessage((msg) => {
            const reader = new BufferReader(msg);
            const ctx = deserialize(reader);
            const channelServer = new ChannelServer(protocol4, ctx, ipcLogger, timeoutDelay);
            const channelClient = new ChannelClient(protocol4, ipcLogger);
            this.channels.forEach((channel, name) => channelServer.registerChannel(name, channel));
            const connection = { channelServer, channelClient, ctx };
            this._connections.add(connection);
            this._onDidAddConnection.fire(connection);
            this.disposables.add(onDidClientDisconnect(() => {
              channelServer.dispose();
              channelClient.dispose();
              this._connections.delete(connection);
              this._onDidRemoveConnection.fire(connection);
            }));
          }));
        }));
      }
      getChannel(channelName, routerOrClientFilter) {
        const that = this;
        return {
          call(command, arg, cancellationToken) {
            let connectionPromise;
            if (isFunction(routerOrClientFilter)) {
              const connection = getRandomElement(that.connections.filter(routerOrClientFilter));
              connectionPromise = connection ? Promise.resolve(connection) : Event.toPromise(Event.filter(that.onDidAddConnection, routerOrClientFilter));
            } else {
              connectionPromise = routerOrClientFilter.routeCall(that, command, arg);
            }
            const channelPromise = connectionPromise.then((connection) => connection.channelClient.getChannel(channelName));
            return getDelayedChannel(channelPromise).call(command, arg, cancellationToken);
          },
          listen(event, arg) {
            if (isFunction(routerOrClientFilter)) {
              return that.getMulticastEvent(channelName, routerOrClientFilter, event, arg);
            }
            const channelPromise = routerOrClientFilter.routeEvent(that, event, arg).then((connection) => connection.channelClient.getChannel(channelName));
            return getDelayedChannel(channelPromise).listen(event, arg);
          }
        };
      }
      getMulticastEvent(channelName, clientFilter, eventName, arg) {
        const that = this;
        let disposables;
        const emitter = new Emitter({
          onWillAddFirstListener: () => {
            disposables = new DisposableStore();
            const eventMultiplexer = new EventMultiplexer();
            const map = /* @__PURE__ */ new Map();
            const onDidAddConnection = (connection) => {
              const channel = connection.channelClient.getChannel(channelName);
              const event = channel.listen(eventName, arg);
              const disposable = eventMultiplexer.add(event);
              map.set(connection, disposable);
            };
            const onDidRemoveConnection = (connection) => {
              const disposable = map.get(connection);
              if (!disposable) {
                return;
              }
              disposable.dispose();
              map.delete(connection);
            };
            that.connections.filter(clientFilter).forEach(onDidAddConnection);
            Event.filter(that.onDidAddConnection, clientFilter)(onDidAddConnection, void 0, disposables);
            that.onDidRemoveConnection(onDidRemoveConnection, void 0, disposables);
            eventMultiplexer.event(emitter.fire, emitter, disposables);
            disposables.add(eventMultiplexer);
          },
          onDidRemoveLastListener: () => {
            disposables?.dispose();
            disposables = void 0;
          }
        });
        that.disposables.add(emitter);
        return emitter.event;
      }
      registerChannel(channelName, channel) {
        this.channels.set(channelName, channel);
        for (const connection of this._connections) {
          connection.channelServer.registerChannel(channelName, channel);
        }
      }
      dispose() {
        this.disposables.dispose();
        for (const connection of this._connections) {
          connection.channelClient.dispose();
          connection.channelServer.dispose();
        }
        this._connections.clear();
        this.channels.clear();
        this._onDidAddConnection.dispose();
        this._onDidRemoveConnection.dispose();
      }
    };
    IPCClient = class {
      constructor(protocol4, ctx, ipcLogger = null) {
        const writer = new BufferWriter();
        serialize(writer, ctx);
        protocol4.send(writer.buffer);
        this.channelClient = new ChannelClient(protocol4, ipcLogger);
        this.channelServer = new ChannelServer(protocol4, ctx, ipcLogger);
      }
      getChannel(channelName) {
        return this.channelClient.getChannel(channelName);
      }
      registerChannel(channelName, channel) {
        this.channelServer.registerChannel(channelName, channel);
      }
      dispose() {
        this.channelClient.dispose();
        this.channelServer.dispose();
      }
    };
    StaticRouter = class {
      constructor(fn) {
        this.fn = fn;
      }
      routeCall(hub) {
        return this.route(hub);
      }
      routeEvent(hub) {
        return this.route(hub);
      }
      async route(hub) {
        for (const connection of hub.connections) {
          if (await Promise.resolve(this.fn(connection.ctx))) {
            return Promise.resolve(connection);
          }
        }
        await Event.toPromise(hub.onDidAddConnection);
        return await this.route(hub);
      }
    };
    (function(ProxyChannel2) {
      function fromService(service, disposables, options) {
        const handler = service;
        const disableMarshalling = options && options.disableMarshalling;
        const mapEventNameToEvent = /* @__PURE__ */ new Map();
        for (const key in handler) {
          if (propertyIsEvent(key)) {
            mapEventNameToEvent.set(key, Event.buffer(handler[key], true, void 0, disposables));
          }
        }
        return new class {
          listen(_, event, arg) {
            const eventImpl = mapEventNameToEvent.get(event);
            if (eventImpl) {
              return eventImpl;
            }
            const target = handler[event];
            if (typeof target === "function") {
              if (propertyIsDynamicEvent(event)) {
                return target.call(handler, arg);
              }
              if (propertyIsEvent(event)) {
                mapEventNameToEvent.set(event, Event.buffer(handler[event], true, void 0, disposables));
                return mapEventNameToEvent.get(event);
              }
            }
            throw new ErrorNoTelemetry(`Event not found: ${event}`);
          }
          call(_, command, args2) {
            const target = handler[command];
            if (typeof target === "function") {
              if (!disableMarshalling && Array.isArray(args2)) {
                for (let i = 0; i < args2.length; i++) {
                  args2[i] = revive(args2[i]);
                }
              }
              let res = target.apply(handler, args2);
              if (!(res instanceof Promise)) {
                res = Promise.resolve(res);
              }
              return res;
            }
            throw new ErrorNoTelemetry(`Method not found: ${command}`);
          }
        }();
      }
      ProxyChannel2.fromService = fromService;
      function toService(channel, options) {
        const disableMarshalling = options && options.disableMarshalling;
        return new Proxy({}, {
          get(_target, propKey) {
            if (typeof propKey === "string") {
              if (options?.properties?.has(propKey)) {
                return options.properties.get(propKey);
              }
              if (propertyIsDynamicEvent(propKey)) {
                return function(arg) {
                  return channel.listen(propKey, arg);
                };
              }
              if (propertyIsEvent(propKey)) {
                return channel.listen(propKey);
              }
              return async function(...args2) {
                let methodArgs;
                if (options && !isUndefinedOrNull(options.context)) {
                  methodArgs = [options.context, ...args2];
                } else {
                  methodArgs = args2;
                }
                const result = await channel.call(propKey, methodArgs);
                if (!disableMarshalling) {
                  return revive(result);
                }
                return result;
              };
            }
            throw new ErrorNoTelemetry(`Property not found: ${String(propKey)}`);
          }
        });
      }
      ProxyChannel2.toService = toService;
      function propertyIsEvent(name) {
        return name[0] === "o" && name[1] === "n" && isUpperAsciiLetter(name.charCodeAt(2));
      }
      function propertyIsDynamicEvent(name) {
        return /^onDynamic/.test(name) && isUpperAsciiLetter(name.charCodeAt(9));
      }
    })(ProxyChannel || (ProxyChannel = {}));
  }
});

// out-build/vs/base/common/uuid.js
function isUUID(value) {
  return _UUIDPattern.test(value);
}
var _UUIDPattern, generateUuid;
var init_uuid = __esm({
  "out-build/vs/base/common/uuid.js"() {
    "use strict";
    _UUIDPattern = /^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/i;
    generateUuid = function() {
      if (typeof crypto.randomUUID === "function") {
        return crypto.randomUUID.bind(crypto);
      }
      const _data = new Uint8Array(16);
      const _hex = [];
      for (let i = 0; i < 256; i++) {
        _hex.push(i.toString(16).padStart(2, "0"));
      }
      return function generateUuid2() {
        crypto.getRandomValues(_data);
        _data[6] = _data[6] & 15 | 64;
        _data[8] = _data[8] & 63 | 128;
        let i = 0;
        let result = "";
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += "-";
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += "-";
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += "-";
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += "-";
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        return result;
      };
    }();
  }
});

// out-build/vs/base/parts/ipc/common/ipc.net.js
function getEmptyBuffer() {
  if (!emptyBuffer) {
    emptyBuffer = VSBuffer.alloc(0);
  }
  return emptyBuffer;
}
function protocolMessageTypeToString(messageType) {
  switch (messageType) {
    case 0:
      return "None";
    case 1:
      return "Regular";
    case 2:
      return "Control";
    case 3:
      return "Ack";
    case 5:
      return "Disconnect";
    case 6:
      return "ReplayRequest";
    case 7:
      return "PauseWriting";
    case 8:
      return "ResumeWriting";
    case 9:
      return "KeepAlive";
  }
}
var SocketDiagnosticsEventType, SocketDiagnostics, SocketCloseEventType, emptyBuffer, ChunkStream, ProtocolMessageType, ProtocolConstants, ProtocolMessage, ProtocolReader, ProtocolWriter, Protocol, Client, BufferedEmitter, QueueElement, Queue2, LoadEstimator, PersistentProtocol;
var init_ipc_net = __esm({
  "out-build/vs/base/parts/ipc/common/ipc.net.js"() {
    "use strict";
    init_buffer();
    init_event();
    init_lifecycle();
    init_ipc();
    (function(SocketDiagnosticsEventType2) {
      SocketDiagnosticsEventType2["Created"] = "created";
      SocketDiagnosticsEventType2["Read"] = "read";
      SocketDiagnosticsEventType2["Write"] = "write";
      SocketDiagnosticsEventType2["Open"] = "open";
      SocketDiagnosticsEventType2["Error"] = "error";
      SocketDiagnosticsEventType2["Close"] = "close";
      SocketDiagnosticsEventType2["BrowserWebSocketBlobReceived"] = "browserWebSocketBlobReceived";
      SocketDiagnosticsEventType2["NodeEndReceived"] = "nodeEndReceived";
      SocketDiagnosticsEventType2["NodeEndSent"] = "nodeEndSent";
      SocketDiagnosticsEventType2["NodeDrainBegin"] = "nodeDrainBegin";
      SocketDiagnosticsEventType2["NodeDrainEnd"] = "nodeDrainEnd";
      SocketDiagnosticsEventType2["zlibInflateError"] = "zlibInflateError";
      SocketDiagnosticsEventType2["zlibInflateData"] = "zlibInflateData";
      SocketDiagnosticsEventType2["zlibInflateInitialWrite"] = "zlibInflateInitialWrite";
      SocketDiagnosticsEventType2["zlibInflateInitialFlushFired"] = "zlibInflateInitialFlushFired";
      SocketDiagnosticsEventType2["zlibInflateWrite"] = "zlibInflateWrite";
      SocketDiagnosticsEventType2["zlibInflateFlushFired"] = "zlibInflateFlushFired";
      SocketDiagnosticsEventType2["zlibDeflateError"] = "zlibDeflateError";
      SocketDiagnosticsEventType2["zlibDeflateData"] = "zlibDeflateData";
      SocketDiagnosticsEventType2["zlibDeflateWrite"] = "zlibDeflateWrite";
      SocketDiagnosticsEventType2["zlibDeflateFlushFired"] = "zlibDeflateFlushFired";
      SocketDiagnosticsEventType2["WebSocketNodeSocketWrite"] = "webSocketNodeSocketWrite";
      SocketDiagnosticsEventType2["WebSocketNodeSocketPeekedHeader"] = "webSocketNodeSocketPeekedHeader";
      SocketDiagnosticsEventType2["WebSocketNodeSocketReadHeader"] = "webSocketNodeSocketReadHeader";
      SocketDiagnosticsEventType2["WebSocketNodeSocketReadData"] = "webSocketNodeSocketReadData";
      SocketDiagnosticsEventType2["WebSocketNodeSocketUnmaskedData"] = "webSocketNodeSocketUnmaskedData";
      SocketDiagnosticsEventType2["WebSocketNodeSocketDrainBegin"] = "webSocketNodeSocketDrainBegin";
      SocketDiagnosticsEventType2["WebSocketNodeSocketDrainEnd"] = "webSocketNodeSocketDrainEnd";
      SocketDiagnosticsEventType2["ProtocolHeaderRead"] = "protocolHeaderRead";
      SocketDiagnosticsEventType2["ProtocolMessageRead"] = "protocolMessageRead";
      SocketDiagnosticsEventType2["ProtocolHeaderWrite"] = "protocolHeaderWrite";
      SocketDiagnosticsEventType2["ProtocolMessageWrite"] = "protocolMessageWrite";
      SocketDiagnosticsEventType2["ProtocolWrite"] = "protocolWrite";
    })(SocketDiagnosticsEventType || (SocketDiagnosticsEventType = {}));
    (function(SocketDiagnostics2) {
      SocketDiagnostics2.enableDiagnostics = false;
      SocketDiagnostics2.records = [];
      const socketIds = /* @__PURE__ */ new WeakMap();
      let lastUsedSocketId = 0;
      function getSocketId(nativeObject, label) {
        if (!socketIds.has(nativeObject)) {
          const id2 = String(++lastUsedSocketId);
          socketIds.set(nativeObject, id2);
        }
        return socketIds.get(nativeObject);
      }
      function traceSocketEvent(nativeObject, socketDebugLabel, type3, data) {
        if (!SocketDiagnostics2.enableDiagnostics) {
          return;
        }
        const id2 = getSocketId(nativeObject, socketDebugLabel);
        if (data instanceof VSBuffer || data instanceof Uint8Array || data instanceof ArrayBuffer || ArrayBuffer.isView(data)) {
          const copiedData = VSBuffer.alloc(data.byteLength);
          copiedData.set(data);
          SocketDiagnostics2.records.push({ timestamp: Date.now(), id: id2, label: socketDebugLabel, type: type3, buff: copiedData });
        } else {
          SocketDiagnostics2.records.push({ timestamp: Date.now(), id: id2, label: socketDebugLabel, type: type3, data });
        }
      }
      SocketDiagnostics2.traceSocketEvent = traceSocketEvent;
    })(SocketDiagnostics || (SocketDiagnostics = {}));
    (function(SocketCloseEventType2) {
      SocketCloseEventType2[SocketCloseEventType2["NodeSocketCloseEvent"] = 0] = "NodeSocketCloseEvent";
      SocketCloseEventType2[SocketCloseEventType2["WebSocketCloseEvent"] = 1] = "WebSocketCloseEvent";
    })(SocketCloseEventType || (SocketCloseEventType = {}));
    emptyBuffer = null;
    ChunkStream = class {
      get byteLength() {
        return this._totalLength;
      }
      constructor() {
        this._chunks = [];
        this._totalLength = 0;
      }
      acceptChunk(buff) {
        this._chunks.push(buff);
        this._totalLength += buff.byteLength;
      }
      read(byteCount) {
        return this._read(byteCount, true);
      }
      peek(byteCount) {
        return this._read(byteCount, false);
      }
      _read(byteCount, advance) {
        if (byteCount === 0) {
          return getEmptyBuffer();
        }
        if (byteCount > this._totalLength) {
          throw new Error(`Cannot read so many bytes!`);
        }
        if (this._chunks[0].byteLength === byteCount) {
          const result2 = this._chunks[0];
          if (advance) {
            this._chunks.shift();
            this._totalLength -= byteCount;
          }
          return result2;
        }
        if (this._chunks[0].byteLength > byteCount) {
          const result2 = this._chunks[0].slice(0, byteCount);
          if (advance) {
            this._chunks[0] = this._chunks[0].slice(byteCount);
            this._totalLength -= byteCount;
          }
          return result2;
        }
        const result = VSBuffer.alloc(byteCount);
        let resultOffset = 0;
        let chunkIndex = 0;
        while (byteCount > 0) {
          const chunk = this._chunks[chunkIndex];
          if (chunk.byteLength > byteCount) {
            const chunkPart = chunk.slice(0, byteCount);
            result.set(chunkPart, resultOffset);
            resultOffset += byteCount;
            if (advance) {
              this._chunks[chunkIndex] = chunk.slice(byteCount);
              this._totalLength -= byteCount;
            }
            byteCount -= byteCount;
          } else {
            result.set(chunk, resultOffset);
            resultOffset += chunk.byteLength;
            if (advance) {
              this._chunks.shift();
              this._totalLength -= chunk.byteLength;
            } else {
              chunkIndex++;
            }
            byteCount -= chunk.byteLength;
          }
        }
        return result;
      }
    };
    (function(ProtocolMessageType2) {
      ProtocolMessageType2[ProtocolMessageType2["None"] = 0] = "None";
      ProtocolMessageType2[ProtocolMessageType2["Regular"] = 1] = "Regular";
      ProtocolMessageType2[ProtocolMessageType2["Control"] = 2] = "Control";
      ProtocolMessageType2[ProtocolMessageType2["Ack"] = 3] = "Ack";
      ProtocolMessageType2[ProtocolMessageType2["Disconnect"] = 5] = "Disconnect";
      ProtocolMessageType2[ProtocolMessageType2["ReplayRequest"] = 6] = "ReplayRequest";
      ProtocolMessageType2[ProtocolMessageType2["Pause"] = 7] = "Pause";
      ProtocolMessageType2[ProtocolMessageType2["Resume"] = 8] = "Resume";
      ProtocolMessageType2[ProtocolMessageType2["KeepAlive"] = 9] = "KeepAlive";
    })(ProtocolMessageType || (ProtocolMessageType = {}));
    (function(ProtocolConstants2) {
      ProtocolConstants2[ProtocolConstants2["HeaderLength"] = 13] = "HeaderLength";
      ProtocolConstants2[ProtocolConstants2["AcknowledgeTime"] = 2e3] = "AcknowledgeTime";
      ProtocolConstants2[ProtocolConstants2["TimeoutTime"] = 2e4] = "TimeoutTime";
      ProtocolConstants2[ProtocolConstants2["ReconnectionGraceTime"] = 108e5] = "ReconnectionGraceTime";
      ProtocolConstants2[ProtocolConstants2["ReconnectionShortGraceTime"] = 3e5] = "ReconnectionShortGraceTime";
      ProtocolConstants2[ProtocolConstants2["KeepAliveSendTime"] = 5e3] = "KeepAliveSendTime";
    })(ProtocolConstants || (ProtocolConstants = {}));
    ProtocolMessage = class {
      constructor(type3, id2, ack, data) {
        this.type = type3;
        this.id = id2;
        this.ack = ack;
        this.data = data;
        this.writtenTime = 0;
      }
      get size() {
        return this.data.byteLength;
      }
    };
    ProtocolReader = class extends Disposable {
      constructor(socket) {
        super();
        this._onMessage = this._register(new Emitter());
        this.onMessage = this._onMessage.event;
        this._state = {
          readHead: true,
          readLen: 13,
          messageType: 0,
          id: 0,
          ack: 0
        };
        this._socket = socket;
        this._isDisposed = false;
        this._incomingData = new ChunkStream();
        this._register(this._socket.onData((data) => this.acceptChunk(data)));
        this.lastReadTime = Date.now();
      }
      acceptChunk(data) {
        if (!data || data.byteLength === 0) {
          return;
        }
        this.lastReadTime = Date.now();
        this._incomingData.acceptChunk(data);
        while (this._incomingData.byteLength >= this._state.readLen) {
          const buff = this._incomingData.read(this._state.readLen);
          if (this._state.readHead) {
            this._state.readHead = false;
            this._state.readLen = buff.readUInt32BE(9);
            this._state.messageType = buff.readUInt8(0);
            this._state.id = buff.readUInt32BE(1);
            this._state.ack = buff.readUInt32BE(5);
            this._socket.traceSocketEvent("protocolHeaderRead", { messageType: protocolMessageTypeToString(this._state.messageType), id: this._state.id, ack: this._state.ack, messageSize: this._state.readLen });
          } else {
            const messageType = this._state.messageType;
            const id2 = this._state.id;
            const ack = this._state.ack;
            this._state.readHead = true;
            this._state.readLen = 13;
            this._state.messageType = 0;
            this._state.id = 0;
            this._state.ack = 0;
            this._socket.traceSocketEvent("protocolMessageRead", buff);
            this._onMessage.fire(new ProtocolMessage(messageType, id2, ack, buff));
            if (this._isDisposed) {
              break;
            }
          }
        }
      }
      readEntireBuffer() {
        return this._incomingData.read(this._incomingData.byteLength);
      }
      dispose() {
        this._isDisposed = true;
        super.dispose();
      }
    };
    ProtocolWriter = class {
      constructor(socket) {
        this._writeNowTimeout = null;
        this._isDisposed = false;
        this._isPaused = false;
        this._socket = socket;
        this._data = [];
        this._totalLength = 0;
        this.lastWriteTime = 0;
      }
      dispose() {
        try {
          this.flush();
        } catch (err) {
        }
        this._isDisposed = true;
      }
      drain() {
        this.flush();
        return this._socket.drain();
      }
      flush() {
        this._writeNow();
      }
      pause() {
        this._isPaused = true;
      }
      resume() {
        this._isPaused = false;
        this._scheduleWriting();
      }
      write(msg) {
        if (this._isDisposed) {
          return;
        }
        msg.writtenTime = Date.now();
        this.lastWriteTime = Date.now();
        const header = VSBuffer.alloc(
          13
          /* ProtocolConstants.HeaderLength */
        );
        header.writeUInt8(msg.type, 0);
        header.writeUInt32BE(msg.id, 1);
        header.writeUInt32BE(msg.ack, 5);
        header.writeUInt32BE(msg.data.byteLength, 9);
        this._socket.traceSocketEvent("protocolHeaderWrite", { messageType: protocolMessageTypeToString(msg.type), id: msg.id, ack: msg.ack, messageSize: msg.data.byteLength });
        this._socket.traceSocketEvent("protocolMessageWrite", msg.data);
        this._writeSoon(header, msg.data);
      }
      _bufferAdd(head, body) {
        const wasEmpty = this._totalLength === 0;
        this._data.push(head, body);
        this._totalLength += head.byteLength + body.byteLength;
        return wasEmpty;
      }
      _bufferTake() {
        const ret = VSBuffer.concat(this._data, this._totalLength);
        this._data.length = 0;
        this._totalLength = 0;
        return ret;
      }
      _writeSoon(header, data) {
        if (this._bufferAdd(header, data)) {
          this._scheduleWriting();
        }
      }
      _scheduleWriting() {
        if (this._writeNowTimeout) {
          return;
        }
        this._writeNowTimeout = setTimeout(() => {
          this._writeNowTimeout = null;
          this._writeNow();
        });
      }
      _writeNow() {
        if (this._totalLength === 0) {
          return;
        }
        if (this._isPaused) {
          return;
        }
        const data = this._bufferTake();
        this._socket.traceSocketEvent("protocolWrite", { byteLength: data.byteLength });
        this._socket.write(data);
      }
    };
    Protocol = class extends Disposable {
      constructor(socket) {
        super();
        this._onMessage = new Emitter();
        this.onMessage = this._onMessage.event;
        this._onDidDispose = new Emitter();
        this.onDidDispose = this._onDidDispose.event;
        this._socket = socket;
        this._socketWriter = this._register(new ProtocolWriter(this._socket));
        this._socketReader = this._register(new ProtocolReader(this._socket));
        this._register(this._socketReader.onMessage((msg) => {
          if (msg.type === 1) {
            this._onMessage.fire(msg.data);
          }
        }));
        this._register(this._socket.onClose(() => this._onDidDispose.fire()));
      }
      drain() {
        return this._socketWriter.drain();
      }
      getSocket() {
        return this._socket;
      }
      sendDisconnect() {
      }
      send(buffer) {
        this._socketWriter.write(new ProtocolMessage(1, 0, 0, buffer));
      }
    };
    Client = class _Client extends IPCClient {
      static fromSocket(socket, id2) {
        return new _Client(new Protocol(socket), id2);
      }
      get onDidDispose() {
        return this.protocol.onDidDispose;
      }
      constructor(protocol4, id2, ipcLogger = null) {
        super(protocol4, id2, ipcLogger);
        this.protocol = protocol4;
      }
      dispose() {
        super.dispose();
        const socket = this.protocol.getSocket();
        this.protocol.sendDisconnect();
        this.protocol.dispose();
        socket.end();
      }
    };
    BufferedEmitter = class {
      constructor() {
        this._hasListeners = false;
        this._isDeliveringMessages = false;
        this._bufferedMessages = [];
        this._emitter = new Emitter({
          onWillAddFirstListener: () => {
            this._hasListeners = true;
            queueMicrotask(() => this._deliverMessages());
          },
          onDidRemoveLastListener: () => {
            this._hasListeners = false;
          }
        });
        this.event = this._emitter.event;
      }
      _deliverMessages() {
        if (this._isDeliveringMessages) {
          return;
        }
        this._isDeliveringMessages = true;
        while (this._hasListeners && this._bufferedMessages.length > 0) {
          this._emitter.fire(this._bufferedMessages.shift());
        }
        this._isDeliveringMessages = false;
      }
      fire(event) {
        if (this._hasListeners) {
          if (this._bufferedMessages.length > 0) {
            this._bufferedMessages.push(event);
          } else {
            this._emitter.fire(event);
          }
        } else {
          this._bufferedMessages.push(event);
        }
      }
      flushBuffer() {
        this._bufferedMessages = [];
      }
    };
    QueueElement = class {
      constructor(data) {
        this.data = data;
        this.next = null;
      }
    };
    Queue2 = class {
      constructor() {
        this._first = null;
        this._last = null;
      }
      length() {
        let result = 0;
        let current = this._first;
        while (current) {
          current = current.next;
          result++;
        }
        return result;
      }
      peek() {
        if (!this._first) {
          return null;
        }
        return this._first.data;
      }
      toArray() {
        const result = [];
        let resultLen = 0;
        let it = this._first;
        while (it) {
          result[resultLen++] = it.data;
          it = it.next;
        }
        return result;
      }
      pop() {
        if (!this._first) {
          return;
        }
        if (this._first === this._last) {
          this._first = null;
          this._last = null;
          return;
        }
        this._first = this._first.next;
      }
      push(item) {
        const element = new QueueElement(item);
        if (!this._first) {
          this._first = element;
          this._last = element;
          return;
        }
        this._last.next = element;
        this._last = element;
      }
    };
    LoadEstimator = class _LoadEstimator {
      static {
        this._HISTORY_LENGTH = 10;
      }
      static {
        this._INSTANCE = null;
      }
      static getInstance() {
        if (!_LoadEstimator._INSTANCE) {
          _LoadEstimator._INSTANCE = new _LoadEstimator();
        }
        return _LoadEstimator._INSTANCE;
      }
      constructor() {
        this.lastRuns = [];
        const now2 = Date.now();
        for (let i = 0; i < _LoadEstimator._HISTORY_LENGTH; i++) {
          this.lastRuns[i] = now2 - 1e3 * i;
        }
        setInterval(() => {
          for (let i = _LoadEstimator._HISTORY_LENGTH; i >= 1; i--) {
            this.lastRuns[i] = this.lastRuns[i - 1];
          }
          this.lastRuns[0] = Date.now();
        }, 1e3);
      }
      /**
       * returns an estimative number, from 0 (low load) to 1 (high load)
       */
      load() {
        const now2 = Date.now();
        const historyLimit = (1 + _LoadEstimator._HISTORY_LENGTH) * 1e3;
        let score = 0;
        for (let i = 0; i < _LoadEstimator._HISTORY_LENGTH; i++) {
          if (now2 - this.lastRuns[i] <= historyLimit) {
            score++;
          }
        }
        return 1 - score / _LoadEstimator._HISTORY_LENGTH;
      }
      hasHighLoad() {
        return this.load() >= 0.5;
      }
    };
    PersistentProtocol = class {
      get unacknowledgedCount() {
        return this._outgoingMsgId - this._outgoingAckId;
      }
      constructor(opts) {
        this._onControlMessage = new BufferedEmitter();
        this.onControlMessage = this._onControlMessage.event;
        this._onMessage = new BufferedEmitter();
        this.onMessage = this._onMessage.event;
        this._onDidDispose = new BufferedEmitter();
        this.onDidDispose = this._onDidDispose.event;
        this._onSocketClose = new BufferedEmitter();
        this.onSocketClose = this._onSocketClose.event;
        this._onSocketTimeout = new BufferedEmitter();
        this.onSocketTimeout = this._onSocketTimeout.event;
        this._loadEstimator = opts.loadEstimator ?? LoadEstimator.getInstance();
        this._shouldSendKeepAlive = opts.sendKeepAlive ?? true;
        this._isReconnecting = false;
        this._outgoingUnackMsg = new Queue2();
        this._outgoingMsgId = 0;
        this._outgoingAckId = 0;
        this._outgoingAckTimeout = null;
        this._incomingMsgId = 0;
        this._incomingAckId = 0;
        this._incomingMsgLastTime = 0;
        this._incomingAckTimeout = null;
        this._lastReplayRequestTime = 0;
        this._lastSocketTimeoutTime = Date.now();
        this._socketDisposables = new DisposableStore();
        this._socket = opts.socket;
        this._socketWriter = this._socketDisposables.add(new ProtocolWriter(this._socket));
        this._socketReader = this._socketDisposables.add(new ProtocolReader(this._socket));
        this._socketDisposables.add(this._socketReader.onMessage((msg) => this._receiveMessage(msg)));
        this._socketDisposables.add(this._socket.onClose((e) => this._onSocketClose.fire(e)));
        if (opts.initialChunk) {
          this._socketReader.acceptChunk(opts.initialChunk);
        }
        if (this._shouldSendKeepAlive) {
          this._keepAliveInterval = setInterval(
            () => {
              this._sendKeepAlive();
            },
            5e3
            /* ProtocolConstants.KeepAliveSendTime */
          );
        } else {
          this._keepAliveInterval = null;
        }
      }
      dispose() {
        if (this._outgoingAckTimeout) {
          clearTimeout(this._outgoingAckTimeout);
          this._outgoingAckTimeout = null;
        }
        if (this._incomingAckTimeout) {
          clearTimeout(this._incomingAckTimeout);
          this._incomingAckTimeout = null;
        }
        if (this._keepAliveInterval) {
          clearInterval(this._keepAliveInterval);
          this._keepAliveInterval = null;
        }
        this._socketDisposables.dispose();
      }
      drain() {
        return this._socketWriter.drain();
      }
      sendDisconnect() {
        if (!this._didSendDisconnect) {
          this._didSendDisconnect = true;
          const msg = new ProtocolMessage(5, 0, 0, getEmptyBuffer());
          this._socketWriter.write(msg);
          this._socketWriter.flush();
        }
      }
      sendPause() {
        const msg = new ProtocolMessage(7, 0, 0, getEmptyBuffer());
        this._socketWriter.write(msg);
      }
      sendResume() {
        const msg = new ProtocolMessage(8, 0, 0, getEmptyBuffer());
        this._socketWriter.write(msg);
      }
      pauseSocketWriting() {
        this._socketWriter.pause();
      }
      getSocket() {
        return this._socket;
      }
      getMillisSinceLastIncomingData() {
        return Date.now() - this._socketReader.lastReadTime;
      }
      beginAcceptReconnection(socket, initialDataChunk) {
        this._isReconnecting = true;
        this._socketDisposables.dispose();
        this._socketDisposables = new DisposableStore();
        this._onControlMessage.flushBuffer();
        this._onSocketClose.flushBuffer();
        this._onSocketTimeout.flushBuffer();
        this._socket.dispose();
        this._lastReplayRequestTime = 0;
        this._lastSocketTimeoutTime = Date.now();
        this._socket = socket;
        this._socketWriter = this._socketDisposables.add(new ProtocolWriter(this._socket));
        this._socketReader = this._socketDisposables.add(new ProtocolReader(this._socket));
        this._socketDisposables.add(this._socketReader.onMessage((msg) => this._receiveMessage(msg)));
        this._socketDisposables.add(this._socket.onClose((e) => this._onSocketClose.fire(e)));
        this._socketReader.acceptChunk(initialDataChunk);
      }
      endAcceptReconnection() {
        this._isReconnecting = false;
        this._incomingAckId = this._incomingMsgId;
        const msg = new ProtocolMessage(3, 0, this._incomingAckId, getEmptyBuffer());
        this._socketWriter.write(msg);
        const toSend = this._outgoingUnackMsg.toArray();
        for (let i = 0, len = toSend.length; i < len; i++) {
          this._socketWriter.write(toSend[i]);
        }
        this._recvAckCheck();
      }
      acceptDisconnect() {
        this._onDidDispose.fire();
      }
      _receiveMessage(msg) {
        if (msg.ack > this._outgoingAckId) {
          this._outgoingAckId = msg.ack;
          do {
            const first2 = this._outgoingUnackMsg.peek();
            if (first2 && first2.id <= msg.ack) {
              this._outgoingUnackMsg.pop();
            } else {
              break;
            }
          } while (true);
        }
        switch (msg.type) {
          case 0: {
            break;
          }
          case 1: {
            if (msg.id > this._incomingMsgId) {
              if (msg.id !== this._incomingMsgId + 1) {
                const now2 = Date.now();
                if (now2 - this._lastReplayRequestTime > 1e4) {
                  this._lastReplayRequestTime = now2;
                  this._socketWriter.write(new ProtocolMessage(6, 0, 0, getEmptyBuffer()));
                }
              } else {
                this._incomingMsgId = msg.id;
                this._incomingMsgLastTime = Date.now();
                this._sendAckCheck();
                this._onMessage.fire(msg.data);
              }
            }
            break;
          }
          case 2: {
            this._onControlMessage.fire(msg.data);
            break;
          }
          case 3: {
            break;
          }
          case 5: {
            this._onDidDispose.fire();
            break;
          }
          case 6: {
            const toSend = this._outgoingUnackMsg.toArray();
            for (let i = 0, len = toSend.length; i < len; i++) {
              this._socketWriter.write(toSend[i]);
            }
            this._recvAckCheck();
            break;
          }
          case 7: {
            this._socketWriter.pause();
            break;
          }
          case 8: {
            this._socketWriter.resume();
            break;
          }
          case 9: {
            break;
          }
        }
      }
      readEntireBuffer() {
        return this._socketReader.readEntireBuffer();
      }
      flush() {
        this._socketWriter.flush();
      }
      send(buffer) {
        const myId = ++this._outgoingMsgId;
        this._incomingAckId = this._incomingMsgId;
        const msg = new ProtocolMessage(1, myId, this._incomingAckId, buffer);
        this._outgoingUnackMsg.push(msg);
        if (!this._isReconnecting) {
          this._socketWriter.write(msg);
          this._recvAckCheck();
        }
      }
      /**
       * Send a message which will not be part of the regular acknowledge flow.
       * Use this for early control messages which are repeated in case of reconnection.
       */
      sendControl(buffer) {
        const msg = new ProtocolMessage(2, 0, 0, buffer);
        this._socketWriter.write(msg);
      }
      _sendAckCheck() {
        if (this._incomingMsgId <= this._incomingAckId) {
          return;
        }
        if (this._incomingAckTimeout) {
          return;
        }
        const timeSinceLastIncomingMsg = Date.now() - this._incomingMsgLastTime;
        if (timeSinceLastIncomingMsg >= 2e3) {
          this._sendAck();
          return;
        }
        this._incomingAckTimeout = setTimeout(() => {
          this._incomingAckTimeout = null;
          this._sendAckCheck();
        }, 2e3 - timeSinceLastIncomingMsg + 5);
      }
      _recvAckCheck() {
        if (this._outgoingMsgId <= this._outgoingAckId) {
          return;
        }
        if (this._outgoingAckTimeout) {
          return;
        }
        if (this._isReconnecting) {
          return;
        }
        const oldestUnacknowledgedMsg = this._outgoingUnackMsg.peek();
        const timeSinceOldestUnacknowledgedMsg = Date.now() - oldestUnacknowledgedMsg.writtenTime;
        const timeSinceLastReceivedSomeData = Date.now() - this._socketReader.lastReadTime;
        const timeSinceLastTimeout = Date.now() - this._lastSocketTimeoutTime;
        if (timeSinceOldestUnacknowledgedMsg >= 2e4 && timeSinceLastReceivedSomeData >= 2e4 && timeSinceLastTimeout >= 2e4) {
          if (!this._loadEstimator.hasHighLoad()) {
            this._lastSocketTimeoutTime = Date.now();
            this._onSocketTimeout.fire({
              unacknowledgedMsgCount: this._outgoingUnackMsg.length(),
              timeSinceOldestUnacknowledgedMsg,
              timeSinceLastReceivedSomeData
            });
            return;
          }
        }
        const minimumTimeUntilTimeout = Math.max(2e4 - timeSinceOldestUnacknowledgedMsg, 2e4 - timeSinceLastReceivedSomeData, 2e4 - timeSinceLastTimeout, 500);
        this._outgoingAckTimeout = setTimeout(() => {
          this._outgoingAckTimeout = null;
          this._recvAckCheck();
        }, minimumTimeUntilTimeout);
      }
      _sendAck() {
        if (this._incomingMsgId <= this._incomingAckId) {
          return;
        }
        this._incomingAckId = this._incomingMsgId;
        const msg = new ProtocolMessage(3, 0, this._incomingAckId, getEmptyBuffer());
        this._socketWriter.write(msg);
      }
      _sendKeepAlive() {
        this._incomingAckId = this._incomingMsgId;
        const msg = new ProtocolMessage(9, 0, this._incomingAckId, getEmptyBuffer());
        this._socketWriter.write(msg);
      }
    };
  }
});

// out-build/vs/base/parts/ipc/node/ipc.net.js
import { createHash } from "crypto";
import { createServer, createConnection } from "net";
import { tmpdir as tmpdir2 } from "os";
import { createDeflateRaw, createInflateRaw } from "zlib";
function createStaticIPCHandle(directoryPath, type3, version) {
  const scope = createHash("sha256").update(directoryPath).digest("hex");
  const scopeForSocket = scope.substr(0, 8);
  if (process.platform === "win32") {
    return `\\\\.\\pipe\\${scopeForSocket}-${version}-${type3}-sock`;
  }
  const versionForSocket = version.substr(0, 4);
  const typeForSocket = type3.substr(0, 6);
  let result;
  if (process.platform !== "darwin" && XDG_RUNTIME_DIR && !process.env["VSCODE_PORTABLE"]) {
    result = join3(XDG_RUNTIME_DIR, `vscode-${scopeForSocket}-${versionForSocket}-${typeForSocket}.sock`);
  } else {
    result = join3(directoryPath, `${versionForSocket}-${typeForSocket}.sock`);
  }
  validateIPCHandleLength(result);
  return result;
}
function validateIPCHandleLength(handle) {
  const limit = safeIpcPathLengths[platform];
  if (typeof limit === "number" && handle.length >= limit) {
    console.warn(`WARNING: IPC handle "${handle}" is longer than ${limit} chars, try a shorter --user-data-dir`);
  }
}
function serve(hook) {
  return new Promise((c, e) => {
    const server = createServer();
    server.on("error", e);
    server.listen(hook, () => {
      server.removeListener("error", e);
      c(new Server(server));
    });
  });
}
function connect(hook, clientId) {
  return new Promise((c, e) => {
    const socket = createConnection(hook, () => {
      socket.removeListener("error", e);
      c(Client.fromSocket(new NodeSocket(socket, `ipc-client${clientId}`), clientId));
    });
    socket.once("error", e);
  });
}
var socketEndTimeoutMs, NodeSocket, Constants, ReadState, XDG_RUNTIME_DIR, safeIpcPathLengths, Server;
var init_ipc_net2 = __esm({
  "out-build/vs/base/parts/ipc/node/ipc.net.js"() {
    "use strict";
    init_buffer();
    init_errors();
    init_event();
    init_lifecycle();
    init_path();
    init_platform();
    init_uuid();
    init_ipc();
    init_ipc_net();
    socketEndTimeoutMs = 3e4;
    NodeSocket = class {
      traceSocketEvent(type3, data) {
        SocketDiagnostics.traceSocketEvent(this.socket, this.debugLabel, type3, data);
      }
      constructor(socket, debugLabel = "") {
        this._canWrite = true;
        this.debugLabel = debugLabel;
        this.socket = socket;
        this.traceSocketEvent("created", { type: "NodeSocket" });
        this._errorListener = (err) => {
          this.traceSocketEvent("error", { code: err?.code, message: err?.message });
          if (err) {
            if (err.code === "EPIPE") {
              return;
            }
            onUnexpectedError(err);
          }
        };
        this.socket.on("error", this._errorListener);
        let endTimeoutHandle;
        this._closeListener = (hadError) => {
          this.traceSocketEvent("close", { hadError });
          this._canWrite = false;
          if (endTimeoutHandle) {
            clearTimeout(endTimeoutHandle);
          }
        };
        this.socket.on("close", this._closeListener);
        this._endListener = () => {
          this.traceSocketEvent(
            "nodeEndReceived"
            /* SocketDiagnosticsEventType.NodeEndReceived */
          );
          this._canWrite = false;
          endTimeoutHandle = setTimeout(() => socket.destroy(), socketEndTimeoutMs);
        };
        this.socket.on("end", this._endListener);
      }
      dispose() {
        this.socket.off("error", this._errorListener);
        this.socket.off("close", this._closeListener);
        this.socket.off("end", this._endListener);
        this.socket.destroy();
      }
      onData(_listener) {
        const listener = (buff) => {
          this.traceSocketEvent("read", buff);
          _listener(VSBuffer.wrap(buff));
        };
        this.socket.on("data", listener);
        return {
          dispose: () => this.socket.off("data", listener)
        };
      }
      onClose(listener) {
        const adapter = (hadError) => {
          listener({
            type: 0,
            hadError,
            error: void 0
          });
        };
        this.socket.on("close", adapter);
        return {
          dispose: () => this.socket.off("close", adapter)
        };
      }
      onEnd(listener) {
        const adapter = () => {
          listener();
        };
        this.socket.on("end", adapter);
        return {
          dispose: () => this.socket.off("end", adapter)
        };
      }
      write(buffer) {
        if (this.socket.destroyed || !this._canWrite) {
          return;
        }
        try {
          this.traceSocketEvent("write", buffer);
          this.socket.write(buffer.buffer, (err) => {
            if (err) {
              if (err.code === "EPIPE") {
                return;
              }
              onUnexpectedError(err);
            }
          });
        } catch (err) {
          if (err.code === "EPIPE") {
            return;
          }
          onUnexpectedError(err);
        }
      }
      end() {
        this.traceSocketEvent(
          "nodeEndSent"
          /* SocketDiagnosticsEventType.NodeEndSent */
        );
        this.socket.end();
      }
      drain() {
        this.traceSocketEvent(
          "nodeDrainBegin"
          /* SocketDiagnosticsEventType.NodeDrainBegin */
        );
        return new Promise((resolve3, reject) => {
          if (this.socket.bufferSize === 0) {
            this.traceSocketEvent(
              "nodeDrainEnd"
              /* SocketDiagnosticsEventType.NodeDrainEnd */
            );
            resolve3();
            return;
          }
          const finished = () => {
            this.socket.off("close", finished);
            this.socket.off("end", finished);
            this.socket.off("error", finished);
            this.socket.off("timeout", finished);
            this.socket.off("drain", finished);
            this.traceSocketEvent(
              "nodeDrainEnd"
              /* SocketDiagnosticsEventType.NodeDrainEnd */
            );
            resolve3();
          };
          this.socket.on("close", finished);
          this.socket.on("end", finished);
          this.socket.on("error", finished);
          this.socket.on("timeout", finished);
          this.socket.on("drain", finished);
        });
      }
    };
    (function(Constants4) {
      Constants4[Constants4["MinHeaderByteSize"] = 2] = "MinHeaderByteSize";
      Constants4[Constants4["MaxWebSocketMessageLength"] = 262144] = "MaxWebSocketMessageLength";
    })(Constants || (Constants = {}));
    (function(ReadState2) {
      ReadState2[ReadState2["PeekHeader"] = 1] = "PeekHeader";
      ReadState2[ReadState2["ReadHeader"] = 2] = "ReadHeader";
      ReadState2[ReadState2["ReadBody"] = 3] = "ReadBody";
      ReadState2[ReadState2["Fin"] = 4] = "Fin";
    })(ReadState || (ReadState = {}));
    XDG_RUNTIME_DIR = process.env["XDG_RUNTIME_DIR"];
    safeIpcPathLengths = {
      [
        2
        /* Platform.Linux */
      ]: 107,
      [
        1
        /* Platform.Mac */
      ]: 103
    };
    Server = class _Server extends IPCServer {
      static toClientConnectionEvent(server) {
        const onConnection = Event.fromNodeEventEmitter(server, "connection");
        return Event.map(onConnection, (socket) => ({
          protocol: new Protocol(new NodeSocket(socket, "ipc-server-connection")),
          onDidClientDisconnect: Event.once(Event.fromNodeEventEmitter(socket, "close"))
        }));
      }
      constructor(server) {
        super(_Server.toClientConnectionEvent(server));
        this.server = server;
      }
      dispose() {
        super.dispose();
        if (this.server) {
          this.server.close();
          this.server = null;
        }
      }
    };
  }
});

// out-build/vs/base/parts/ipc/electron-main/ipcMain.js
import electron from "electron";
var ValidatedIpcMain, validatedIpcMain;
var init_ipcMain = __esm({
  "out-build/vs/base/parts/ipc/electron-main/ipcMain.js"() {
    "use strict";
    init_errors();
    init_network();
    ValidatedIpcMain = class {
      constructor() {
        this.mapListenerToWrapper = /* @__PURE__ */ new WeakMap();
      }
      /**
       * Listens to `channel`, when a new message arrives `listener` would be called with
       * `listener(event, args...)`.
       */
      on(channel, listener) {
        const wrappedListener = (event, ...args2) => {
          if (this.validateEvent(channel, event)) {
            listener(event, ...args2);
          }
        };
        this.mapListenerToWrapper.set(listener, wrappedListener);
        electron.ipcMain.on(channel, wrappedListener);
        return this;
      }
      /**
       * Adds a one time `listener` function for the event. This `listener` is invoked
       * only the next time a message is sent to `channel`, after which it is removed.
       */
      once(channel, listener) {
        electron.ipcMain.once(channel, (event, ...args2) => {
          if (this.validateEvent(channel, event)) {
            listener(event, ...args2);
          }
        });
        return this;
      }
      /**
       * Adds a handler for an `invoke`able IPC. This handler will be called whenever a
       * renderer calls `ipcRenderer.invoke(channel, ...args)`.
       *
       * If `listener` returns a Promise, the eventual result of the promise will be
       * returned as a reply to the remote caller. Otherwise, the return value of the
       * listener will be used as the value of the reply.
       *
       * The `event` that is passed as the first argument to the handler is the same as
       * that passed to a regular event listener. It includes information about which
       * WebContents is the source of the invoke request.
       *
       * Errors thrown through `handle` in the main process are not transparent as they
       * are serialized and only the `message` property from the original error is
       * provided to the renderer process. Please refer to #24427 for details.
       */
      handle(channel, listener) {
        electron.ipcMain.handle(channel, (event, ...args2) => {
          if (this.validateEvent(channel, event)) {
            return listener(event, ...args2);
          }
          return Promise.reject(`Invalid channel '${channel}' or sender for ipcMain.handle() usage.`);
        });
        return this;
      }
      /**
       * Removes any handler for `channel`, if present.
       */
      removeHandler(channel) {
        electron.ipcMain.removeHandler(channel);
        return this;
      }
      /**
       * Removes the specified `listener` from the listener array for the specified
       * `channel`.
       */
      removeListener(channel, listener) {
        const wrappedListener = this.mapListenerToWrapper.get(listener);
        if (wrappedListener) {
          electron.ipcMain.removeListener(channel, wrappedListener);
          this.mapListenerToWrapper.delete(listener);
        }
        return this;
      }
      validateEvent(channel, event) {
        if (!channel || !channel.startsWith("vscode:")) {
          onUnexpectedError(`Refused to handle ipcMain event for channel '${channel}' because the channel is unknown.`);
          return false;
        }
        const sender = event.senderFrame;
        const url = sender?.url;
        if (!url || url === "about:blank") {
          return true;
        }
        let host = "unknown";
        try {
          host = new URL(url).host;
        } catch (error) {
          onUnexpectedError(`Refused to handle ipcMain event for channel '${channel}' because of a malformed URL '${url}'.`);
          return false;
        }
        if (host !== VSCODE_AUTHORITY) {
          onUnexpectedError(`Refused to handle ipcMain event for channel '${channel}' because of a bad origin of '${host}'.`);
          return false;
        }
        if (sender?.parent !== null) {
          onUnexpectedError(`Refused to handle ipcMain event for channel '${channel}' because sender of origin '${host}' is not a main frame.`);
          return false;
        }
        return true;
      }
    };
    validatedIpcMain = new ValidatedIpcMain();
  }
});

// out-build/vs/base/parts/contextmenu/common/contextmenu.js
var CONTEXT_MENU_CHANNEL, CONTEXT_MENU_CLOSE_CHANNEL;
var init_contextmenu = __esm({
  "out-build/vs/base/parts/contextmenu/common/contextmenu.js"() {
    "use strict";
    CONTEXT_MENU_CHANNEL = "vscode:contextmenu";
    CONTEXT_MENU_CLOSE_CHANNEL = "vscode:onCloseContextMenu";
  }
});

// out-build/vs/base/parts/contextmenu/electron-main/contextmenu.js
import { Menu, MenuItem } from "electron";
function registerContextMenuListener() {
  validatedIpcMain.on(CONTEXT_MENU_CHANNEL, (event, contextMenuId, items, onClickChannel, options) => {
    const menu = createMenu(event, onClickChannel, items);
    menu.popup({
      x: options ? options.x : void 0,
      y: options ? options.y : void 0,
      positioningItem: options ? options.positioningItem : void 0,
      callback: () => {
        if (menu) {
          event.sender.send(CONTEXT_MENU_CLOSE_CHANNEL, contextMenuId);
        }
      }
    });
  });
}
function createMenu(event, onClickChannel, items) {
  const menu = new Menu();
  items.forEach((item) => {
    let menuitem;
    if (item.type === "separator") {
      menuitem = new MenuItem({
        type: item.type
      });
    } else if (Array.isArray(item.submenu)) {
      menuitem = new MenuItem({
        submenu: createMenu(event, onClickChannel, item.submenu),
        label: item.label
      });
    } else {
      menuitem = new MenuItem({
        label: item.label,
        type: item.type,
        accelerator: item.accelerator,
        checked: item.checked,
        enabled: item.enabled,
        visible: item.visible,
        click: (menuItem, win, contextmenuEvent) => event.sender.send(onClickChannel, item.id, contextmenuEvent)
      });
    }
    menu.append(menuitem);
  });
  return menu;
}
var init_contextmenu2 = __esm({
  "out-build/vs/base/parts/contextmenu/electron-main/contextmenu.js"() {
    "use strict";
    init_ipcMain();
    init_contextmenu();
  }
});

// out-build/vs/base/parts/ipc/common/ipc.electron.js
var Protocol2;
var init_ipc_electron = __esm({
  "out-build/vs/base/parts/ipc/common/ipc.electron.js"() {
    "use strict";
    Protocol2 = class {
      constructor(sender, onMessage) {
        this.sender = sender;
        this.onMessage = onMessage;
      }
      send(message) {
        try {
          this.sender.send("vscode:message", message.buffer);
        } catch (e) {
        }
      }
      disconnect() {
        this.sender.send("vscode:disconnect", null);
      }
    };
  }
});

// out-build/vs/base/parts/ipc/electron-main/ipc.electron.js
function createScopedOnMessageEvent(senderId, eventName) {
  const onMessage = Event.fromNodeEventEmitter(validatedIpcMain, eventName, (event, message) => ({ event, message }));
  const onMessageFromSender = Event.filter(onMessage, ({ event }) => event.sender.id === senderId);
  return Event.map(onMessageFromSender, ({ message }) => message ? VSBuffer.wrap(message) : message);
}
var Server2;
var init_ipc_electron2 = __esm({
  "out-build/vs/base/parts/ipc/electron-main/ipc.electron.js"() {
    "use strict";
    init_ipcMain();
    init_buffer();
    init_event();
    init_lifecycle();
    init_ipc();
    init_ipc_electron();
    Server2 = class _Server extends IPCServer {
      static {
        this.Clients = /* @__PURE__ */ new Map();
      }
      static getOnDidClientConnect() {
        const onHello = Event.fromNodeEventEmitter(validatedIpcMain, "vscode:hello", ({ sender }) => sender);
        return Event.map(onHello, (webContents4) => {
          const id2 = webContents4.id;
          const client = _Server.Clients.get(id2);
          client?.dispose();
          const onDidClientReconnect = new Emitter();
          _Server.Clients.set(id2, toDisposable(() => onDidClientReconnect.fire()));
          const onMessage = createScopedOnMessageEvent(id2, "vscode:message");
          const onDidClientDisconnect = Event.any(Event.signal(createScopedOnMessageEvent(id2, "vscode:disconnect")), onDidClientReconnect.event);
          const protocol4 = new Protocol2(webContents4, onMessage);
          return { protocol: protocol4, onDidClientDisconnect };
        });
      }
      constructor() {
        super(_Server.getOnDidClientConnect());
      }
    };
  }
});

// out-build/vs/base/parts/ipc/common/ipc.mp.js
var Protocol3, Client2;
var init_ipc_mp = __esm({
  "out-build/vs/base/parts/ipc/common/ipc.mp.js"() {
    "use strict";
    init_buffer();
    init_event();
    init_ipc();
    Protocol3 = class {
      constructor(port) {
        this.port = port;
        this.onMessage = Event.fromDOMEventEmitter(this.port, "message", (e) => {
          if (e.data) {
            return VSBuffer.wrap(e.data);
          }
          return VSBuffer.alloc(0);
        });
        port.start();
      }
      send(message) {
        this.port.postMessage(message.buffer);
      }
      disconnect() {
        this.port.close();
      }
    };
    Client2 = class extends IPCClient {
      constructor(port, clientId) {
        const protocol4 = new Protocol3(port);
        super(protocol4, clientId);
        this.protocol = protocol4;
      }
      dispose() {
        this.protocol.disconnect();
        super.dispose();
      }
    };
  }
});

// out-build/vs/base/parts/ipc/electron-main/ipc.mp.js
var Client3;
var init_ipc_mp2 = __esm({
  "out-build/vs/base/parts/ipc/electron-main/ipc.mp.js"() {
    "use strict";
    init_ipcMain();
    init_event();
    init_uuid();
    init_ipc_mp();
    Client3 = class extends Client2 {
      /**
       * @param clientId a way to uniquely identify this client among
       * other clients. this is important for routing because every
       * client can also be a server
       */
      constructor(port, clientId) {
        super({
          addEventListener: (type3, listener) => port.addListener(type3, listener),
          removeEventListener: (type3, listener) => port.removeListener(type3, listener),
          postMessage: (message) => port.postMessage(message),
          start: () => port.start(),
          close: () => port.close()
        }, clientId);
      }
    };
  }
});

// out-build/vs/base/common/hash.js
function hash(obj) {
  return doHash(obj, 0);
}
function doHash(obj, hashVal) {
  switch (typeof obj) {
    case "object":
      if (obj === null) {
        return numberHash(349, hashVal);
      } else if (Array.isArray(obj)) {
        return arrayHash(obj, hashVal);
      }
      return objectHash(obj, hashVal);
    case "string":
      return stringHash(obj, hashVal);
    case "boolean":
      return booleanHash(obj, hashVal);
    case "number":
      return numberHash(obj, hashVal);
    case "undefined":
      return numberHash(937, hashVal);
    default:
      return numberHash(617, hashVal);
  }
}
function numberHash(val, initialHashVal) {
  return (initialHashVal << 5) - initialHashVal + val | 0;
}
function booleanHash(b, initialHashVal) {
  return numberHash(b ? 433 : 863, initialHashVal);
}
function stringHash(s, hashVal) {
  hashVal = numberHash(149417, hashVal);
  for (let i = 0, length = s.length; i < length; i++) {
    hashVal = numberHash(s.charCodeAt(i), hashVal);
  }
  return hashVal;
}
function arrayHash(arr, initialHashVal) {
  initialHashVal = numberHash(104579, initialHashVal);
  return arr.reduce((hashVal, item) => doHash(item, hashVal), initialHashVal);
}
function objectHash(obj, initialHashVal) {
  initialHashVal = numberHash(181387, initialHashVal);
  return Object.keys(obj).sort().reduce((hashVal, key) => {
    hashVal = stringHash(key, hashVal);
    return doHash(obj[key], hashVal);
  }, initialHashVal);
}
function leftRotate(value, bits, totalBits = 32) {
  const delta = totalBits - bits;
  const mask = ~((1 << delta) - 1);
  return (value << bits | (mask & value) >>> delta) >>> 0;
}
function toHexString(bufferOrValue, bitsize = 32) {
  if (bufferOrValue instanceof ArrayBuffer) {
    return encodeHex(VSBuffer.wrap(new Uint8Array(bufferOrValue)));
  }
  return (bufferOrValue >>> 0).toString(16).padStart(bitsize / 4, "0");
}
var SHA1Constant, StringSHA1;
var init_hash = __esm({
  "out-build/vs/base/common/hash.js"() {
    "use strict";
    init_buffer();
    init_strings();
    (function(SHA1Constant2) {
      SHA1Constant2[SHA1Constant2["BLOCK_SIZE"] = 64] = "BLOCK_SIZE";
      SHA1Constant2[SHA1Constant2["UNICODE_REPLACEMENT"] = 65533] = "UNICODE_REPLACEMENT";
    })(SHA1Constant || (SHA1Constant = {}));
    StringSHA1 = class _StringSHA1 {
      static {
        this._bigBlock32 = new DataView(new ArrayBuffer(320));
      }
      // 80 * 4 = 320
      constructor() {
        this._h0 = 1732584193;
        this._h1 = 4023233417;
        this._h2 = 2562383102;
        this._h3 = 271733878;
        this._h4 = 3285377520;
        this._buff = new Uint8Array(
          64 + 3
          /* to fit any utf-8 */
        );
        this._buffDV = new DataView(this._buff.buffer);
        this._buffLen = 0;
        this._totalLen = 0;
        this._leftoverHighSurrogate = 0;
        this._finished = false;
      }
      update(str) {
        const strLen = str.length;
        if (strLen === 0) {
          return;
        }
        const buff = this._buff;
        let buffLen = this._buffLen;
        let leftoverHighSurrogate = this._leftoverHighSurrogate;
        let charCode;
        let offset;
        if (leftoverHighSurrogate !== 0) {
          charCode = leftoverHighSurrogate;
          offset = -1;
          leftoverHighSurrogate = 0;
        } else {
          charCode = str.charCodeAt(0);
          offset = 0;
        }
        while (true) {
          let codePoint = charCode;
          if (isHighSurrogate(charCode)) {
            if (offset + 1 < strLen) {
              const nextCharCode = str.charCodeAt(offset + 1);
              if (isLowSurrogate(nextCharCode)) {
                offset++;
                codePoint = computeCodePoint(charCode, nextCharCode);
              } else {
                codePoint = 65533;
              }
            } else {
              leftoverHighSurrogate = charCode;
              break;
            }
          } else if (isLowSurrogate(charCode)) {
            codePoint = 65533;
          }
          buffLen = this._push(buff, buffLen, codePoint);
          offset++;
          if (offset < strLen) {
            charCode = str.charCodeAt(offset);
          } else {
            break;
          }
        }
        this._buffLen = buffLen;
        this._leftoverHighSurrogate = leftoverHighSurrogate;
      }
      _push(buff, buffLen, codePoint) {
        if (codePoint < 128) {
          buff[buffLen++] = codePoint;
        } else if (codePoint < 2048) {
          buff[buffLen++] = 192 | (codePoint & 1984) >>> 6;
          buff[buffLen++] = 128 | (codePoint & 63) >>> 0;
        } else if (codePoint < 65536) {
          buff[buffLen++] = 224 | (codePoint & 61440) >>> 12;
          buff[buffLen++] = 128 | (codePoint & 4032) >>> 6;
          buff[buffLen++] = 128 | (codePoint & 63) >>> 0;
        } else {
          buff[buffLen++] = 240 | (codePoint & 1835008) >>> 18;
          buff[buffLen++] = 128 | (codePoint & 258048) >>> 12;
          buff[buffLen++] = 128 | (codePoint & 4032) >>> 6;
          buff[buffLen++] = 128 | (codePoint & 63) >>> 0;
        }
        if (buffLen >= 64) {
          this._step();
          buffLen -= 64;
          this._totalLen += 64;
          buff[0] = buff[64 + 0];
          buff[1] = buff[64 + 1];
          buff[2] = buff[64 + 2];
        }
        return buffLen;
      }
      digest() {
        if (!this._finished) {
          this._finished = true;
          if (this._leftoverHighSurrogate) {
            this._leftoverHighSurrogate = 0;
            this._buffLen = this._push(
              this._buff,
              this._buffLen,
              65533
              /* SHA1Constant.UNICODE_REPLACEMENT */
            );
          }
          this._totalLen += this._buffLen;
          this._wrapUp();
        }
        return toHexString(this._h0) + toHexString(this._h1) + toHexString(this._h2) + toHexString(this._h3) + toHexString(this._h4);
      }
      _wrapUp() {
        this._buff[this._buffLen++] = 128;
        this._buff.subarray(this._buffLen).fill(0);
        if (this._buffLen > 56) {
          this._step();
          this._buff.fill(0);
        }
        const ml = 8 * this._totalLen;
        this._buffDV.setUint32(56, Math.floor(ml / 4294967296), false);
        this._buffDV.setUint32(60, ml % 4294967296, false);
        this._step();
      }
      _step() {
        const bigBlock32 = _StringSHA1._bigBlock32;
        const data = this._buffDV;
        for (let j = 0; j < 64; j += 4) {
          bigBlock32.setUint32(j, data.getUint32(j, false), false);
        }
        for (let j = 64; j < 320; j += 4) {
          bigBlock32.setUint32(j, leftRotate(bigBlock32.getUint32(j - 12, false) ^ bigBlock32.getUint32(j - 32, false) ^ bigBlock32.getUint32(j - 56, false) ^ bigBlock32.getUint32(j - 64, false), 1), false);
        }
        let a = this._h0;
        let b = this._h1;
        let c = this._h2;
        let d = this._h3;
        let e = this._h4;
        let f, k;
        let temp;
        for (let j = 0; j < 80; j++) {
          if (j < 20) {
            f = b & c | ~b & d;
            k = 1518500249;
          } else if (j < 40) {
            f = b ^ c ^ d;
            k = 1859775393;
          } else if (j < 60) {
            f = b & c | b & d | c & d;
            k = 2400959708;
          } else {
            f = b ^ c ^ d;
            k = 3395469782;
          }
          temp = leftRotate(a, 5) + f + e + k + bigBlock32.getUint32(j * 4, false) & 4294967295;
          e = d;
          d = c;
          c = leftRotate(b, 30);
          b = a;
          a = temp;
        }
        this._h0 = this._h0 + a & 4294967295;
        this._h1 = this._h1 + b & 4294967295;
        this._h2 = this._h2 + c & 4294967295;
        this._h3 = this._h3 + d & 4294967295;
        this._h4 = this._h4 + e & 4294967295;
      }
    };
  }
});

// out-build/vs/platform/encryption/common/encryptionService.js
var IEncryptionService, IEncryptionMainService, PasswordStoreCLIOption, KnownStorageProvider;
var init_encryptionService = __esm({
  "out-build/vs/platform/encryption/common/encryptionService.js"() {
    "use strict";
    init_instantiation();
    IEncryptionService = createDecorator("encryptionService");
    IEncryptionMainService = createDecorator("encryptionMainService");
    (function(PasswordStoreCLIOption2) {
      PasswordStoreCLIOption2["kwallet"] = "kwallet";
      PasswordStoreCLIOption2["kwallet5"] = "kwallet5";
      PasswordStoreCLIOption2["gnomeLibsecret"] = "gnome-libsecret";
      PasswordStoreCLIOption2["basic"] = "basic";
    })(PasswordStoreCLIOption || (PasswordStoreCLIOption = {}));
    (function(KnownStorageProvider2) {
      KnownStorageProvider2["unknown"] = "unknown";
      KnownStorageProvider2["basicText"] = "basic_text";
      KnownStorageProvider2["gnomeAny"] = "gnome_any";
      KnownStorageProvider2["gnomeLibsecret"] = "gnome_libsecret";
      KnownStorageProvider2["gnomeKeyring"] = "gnome_keyring";
      KnownStorageProvider2["kwallet"] = "kwallet";
      KnownStorageProvider2["kwallet5"] = "kwallet5";
      KnownStorageProvider2["kwallet6"] = "kwallet6";
      KnownStorageProvider2["dplib"] = "dpapi";
      KnownStorageProvider2["keychainAccess"] = "keychain_access";
    })(KnownStorageProvider || (KnownStorageProvider = {}));
  }
});

// out-build/vs/platform/environment/common/environment.js
var IEnvironmentService, INativeEnvironmentService;
var init_environment = __esm({
  "out-build/vs/platform/environment/common/environment.js"() {
    "use strict";
    init_instantiation();
    IEnvironmentService = createDecorator("environmentService");
    INativeEnvironmentService = refineServiceDecorator(IEnvironmentService);
  }
});

// out-build/vs/base/common/date.js
function toLocalISOString(date) {
  return date.getFullYear() + "-" + String(date.getMonth() + 1).padStart(2, "0") + "-" + String(date.getDate()).padStart(2, "0") + "T" + String(date.getHours()).padStart(2, "0") + ":" + String(date.getMinutes()).padStart(2, "0") + ":" + String(date.getSeconds()).padStart(2, "0") + "." + (date.getMilliseconds() / 1e3).toFixed(3).slice(2, 5) + "Z";
}
var minute, hour, day, week, month, year;
var init_date = __esm({
  "out-build/vs/base/common/date.js"() {
    "use strict";
    init_nls();
    init_lazy();
    init_platform();
    minute = 60;
    hour = minute * 60;
    day = hour * 24;
    week = day * 7;
    month = day * 30;
    year = day * 365;
  }
});

// out-build/vs/platform/environment/common/environmentService.js
function parseExtensionHostDebugPort(args2, isBuilt) {
  return parseDebugParams(args2["inspect-extensions"], args2["inspect-brk-extensions"], 5870, isBuilt, args2.debugId, args2.extensionEnvironment);
}
function parseDebugParams(debugArg, debugBrkArg, defaultBuildPort, isBuilt, debugId, environmentString) {
  const portStr = debugBrkArg || debugArg;
  const port = Number(portStr) || (!isBuilt ? defaultBuildPort : null);
  const brk = port ? Boolean(!!debugBrkArg) : false;
  let env2;
  if (environmentString) {
    try {
      env2 = JSON.parse(environmentString);
    } catch {
    }
  }
  return { port, break: brk, debugId, env: env2 };
}
var EXTENSION_IDENTIFIER_WITH_LOG_REGEX, AbstractNativeEnvironmentService;
var init_environmentService = __esm({
  "out-build/vs/platform/environment/common/environmentService.js"() {
    "use strict";
    init_date();
    init_decorators();
    init_network();
    init_path();
    init_process();
    init_resources();
    init_uri();
    EXTENSION_IDENTIFIER_WITH_LOG_REGEX = /^([^.]+\..+)[:=](.+)$/;
    AbstractNativeEnvironmentService = class {
      get appRoot() {
        return dirname3(FileAccess.asFileUri("").fsPath);
      }
      get userHome() {
        return URI.file(this.paths.homeDir);
      }
      get userDataPath() {
        return this.paths.userDataDir;
      }
      get appSettingsHome() {
        return URI.file(join3(this.userDataPath, "User"));
      }
      get tmpDir() {
        return URI.file(this.paths.tmpDir);
      }
      get cacheHome() {
        return URI.file(this.userDataPath);
      }
      get stateResource() {
        return joinPath(this.appSettingsHome, "globalStorage", "storage.json");
      }
      get userRoamingDataHome() {
        return this.appSettingsHome.with({ scheme: Schemas.vscodeUserData });
      }
      get userDataSyncHome() {
        return joinPath(this.appSettingsHome, "sync");
      }
      get logsHome() {
        if (!this.args.logsPath) {
          const key = toLocalISOString(/* @__PURE__ */ new Date()).replace(/-|:|\.\d+Z$/g, "");
          this.args.logsPath = join3(this.userDataPath, "logs", key);
        }
        return URI.file(this.args.logsPath);
      }
      get sync() {
        return this.args.sync;
      }
      get machineSettingsResource() {
        return joinPath(URI.file(join3(this.userDataPath, "Machine")), "settings.json");
      }
      get workspaceStorageHome() {
        return joinPath(this.appSettingsHome, "workspaceStorage");
      }
      get localHistoryHome() {
        return joinPath(this.appSettingsHome, "History");
      }
      get keyboardLayoutResource() {
        return joinPath(this.userRoamingDataHome, "keyboardLayout.json");
      }
      get argvResource() {
        const vscodePortable = env["VSCODE_PORTABLE"];
        if (vscodePortable) {
          return URI.file(join3(vscodePortable, "argv.json"));
        }
        return joinPath(this.userHome, this.productService.dataFolderName, "argv.json");
      }
      get isExtensionDevelopment() {
        return !!this.args.extensionDevelopmentPath;
      }
      get untitledWorkspacesHome() {
        return URI.file(join3(this.userDataPath, "Workspaces"));
      }
      get builtinExtensionsPath() {
        const cliBuiltinExtensionsDir = this.args["builtin-extensions-dir"];
        if (cliBuiltinExtensionsDir) {
          return resolve2(cliBuiltinExtensionsDir);
        }
        return normalize(join3(FileAccess.asFileUri("").fsPath, "..", "extensions"));
      }
      get extensionsDownloadLocation() {
        const cliExtensionsDownloadDir = this.args["extensions-download-dir"];
        if (cliExtensionsDownloadDir) {
          return URI.file(resolve2(cliExtensionsDownloadDir));
        }
        return URI.file(join3(this.userDataPath, "CachedExtensionVSIXs"));
      }
      get extensionsPath() {
        const cliExtensionsDir = this.args["extensions-dir"];
        if (cliExtensionsDir) {
          return resolve2(cliExtensionsDir);
        }
        const vscodeExtensions = env["VSCODE_EXTENSIONS"];
        if (vscodeExtensions) {
          return vscodeExtensions;
        }
        const vscodePortable = env["VSCODE_PORTABLE"];
        if (vscodePortable) {
          return join3(vscodePortable, "extensions");
        }
        return joinPath(this.userHome, this.productService.dataFolderName, "extensions").fsPath;
      }
      get extensionDevelopmentLocationURI() {
        const extensionDevelopmentPaths = this.args.extensionDevelopmentPath;
        if (Array.isArray(extensionDevelopmentPaths)) {
          return extensionDevelopmentPaths.map((extensionDevelopmentPath) => {
            if (/^[^:/?#]+?:\/\//.test(extensionDevelopmentPath)) {
              return URI.parse(extensionDevelopmentPath);
            }
            return URI.file(normalize(extensionDevelopmentPath));
          });
        }
        return void 0;
      }
      get extensionDevelopmentKind() {
        return this.args.extensionDevelopmentKind?.map((kind) => kind === "ui" || kind === "workspace" || kind === "web" ? kind : "workspace");
      }
      get extensionTestsLocationURI() {
        const extensionTestsPath = this.args.extensionTestsPath;
        if (extensionTestsPath) {
          if (/^[^:/?#]+?:\/\//.test(extensionTestsPath)) {
            return URI.parse(extensionTestsPath);
          }
          return URI.file(normalize(extensionTestsPath));
        }
        return void 0;
      }
      get disableExtensions() {
        if (this.args["disable-extensions"]) {
          return true;
        }
        const disableExtensions = this.args["disable-extension"];
        if (disableExtensions) {
          if (typeof disableExtensions === "string") {
            return [disableExtensions];
          }
          if (Array.isArray(disableExtensions) && disableExtensions.length > 0) {
            return disableExtensions;
          }
        }
        return false;
      }
      get debugExtensionHost() {
        return parseExtensionHostDebugPort(this.args, this.isBuilt);
      }
      get debugRenderer() {
        return !!this.args.debugRenderer;
      }
      get isBuilt() {
        return !env["VSCODE_DEV"];
      }
      get verbose() {
        return !!this.args.verbose;
      }
      get logLevel() {
        return this.args.log?.find((entry) => !EXTENSION_IDENTIFIER_WITH_LOG_REGEX.test(entry));
      }
      get extensionLogLevel() {
        const result = [];
        for (const entry of this.args.log || []) {
          const matches = EXTENSION_IDENTIFIER_WITH_LOG_REGEX.exec(entry);
          if (matches && matches[1] && matches[2]) {
            result.push([matches[1], matches[2]]);
          }
        }
        return result.length ? result : void 0;
      }
      get serviceMachineIdResource() {
        return joinPath(URI.file(this.userDataPath), "machineid");
      }
      get crashReporterId() {
        return this.args["crash-reporter-id"];
      }
      get crashReporterDirectory() {
        return this.args["crash-reporter-directory"];
      }
      get disableTelemetry() {
        return !!this.args["disable-telemetry"];
      }
      get disableWorkspaceTrust() {
        return !!this.args["disable-workspace-trust"];
      }
      get useInMemorySecretStorage() {
        return !!this.args["use-inmemory-secretstorage"];
      }
      get policyFile() {
        if (this.args["__enable-file-policy"]) {
          const vscodePortable = env["VSCODE_PORTABLE"];
          if (vscodePortable) {
            return URI.file(join3(vscodePortable, "policy.json"));
          }
          return joinPath(this.userHome, this.productService.dataFolderName, "policy.json");
        }
        return void 0;
      }
      get editSessionId() {
        return this.args["editSessionId"];
      }
      get continueOn() {
        return this.args["continueOn"];
      }
      set continueOn(value) {
        this.args["continueOn"] = value;
      }
      get args() {
        return this._args;
      }
      constructor(_args, paths, productService) {
        this._args = _args;
        this.paths = paths;
        this.productService = productService;
      }
    };
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "appRoot", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "userHome", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "userDataPath", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "appSettingsHome", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "tmpDir", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "cacheHome", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "stateResource", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "userRoamingDataHome", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "userDataSyncHome", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "sync", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "machineSettingsResource", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "workspaceStorageHome", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "localHistoryHome", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "keyboardLayoutResource", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "argvResource", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "isExtensionDevelopment", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "untitledWorkspacesHome", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "builtinExtensionsPath", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "extensionsPath", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "extensionDevelopmentLocationURI", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "extensionDevelopmentKind", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "extensionTestsLocationURI", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "debugExtensionHost", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "logLevel", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "extensionLogLevel", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "serviceMachineIdResource", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "disableTelemetry", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "disableWorkspaceTrust", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "useInMemorySecretStorage", null);
    __decorate([
      memoize
    ], AbstractNativeEnvironmentService.prototype, "policyFile", null);
  }
});

// out-build/vs/platform/environment/node/environmentService.js
import { homedir as homedir2, tmpdir as tmpdir3 } from "os";
function parsePtyHostDebugPort(args2, isBuilt) {
  return parseDebugParams(args2["inspect-ptyhost"], args2["inspect-brk-ptyhost"], 5877, isBuilt, args2.extensionEnvironment);
}
function parseSharedProcessDebugPort(args2, isBuilt) {
  return parseDebugParams(args2["inspect-sharedprocess"], args2["inspect-brk-sharedprocess"], 5879, isBuilt, args2.extensionEnvironment);
}
var NativeEnvironmentService;
var init_environmentService2 = __esm({
  "out-build/vs/platform/environment/node/environmentService.js"() {
    "use strict";
    init_environmentService();
    init_userDataPath();
    NativeEnvironmentService = class extends AbstractNativeEnvironmentService {
      constructor(args2, productService) {
        super(args2, {
          homeDir: homedir2(),
          tmpDir: tmpdir3(),
          userDataDir: getUserDataPath(args2, productService.nameShort)
        }, productService);
      }
    };
  }
});

// out-build/vs/platform/environment/electron-main/environmentMainService.js
var IEnvironmentMainService, EnvironmentMainService;
var init_environmentMainService = __esm({
  "out-build/vs/platform/environment/electron-main/environmentMainService.js"() {
    "use strict";
    init_decorators();
    init_path();
    init_platform();
    init_ipc_net2();
    init_environment();
    init_environmentService2();
    init_instantiation();
    IEnvironmentMainService = refineServiceDecorator(IEnvironmentService);
    EnvironmentMainService = class extends NativeEnvironmentService {
      constructor() {
        super(...arguments);
        this._snapEnv = {};
      }
      get backupHome() {
        return join3(this.userDataPath, "Backups");
      }
      get mainIPCHandle() {
        return createStaticIPCHandle(this.userDataPath, "main", this.productService.version);
      }
      get mainLockfile() {
        return join3(this.userDataPath, "code.lock");
      }
      get disableUpdates() {
        return !!this.args["disable-updates"];
      }
      get crossOriginIsolated() {
        return !!this.args["enable-coi"];
      }
      get enableRDPDisplayTracking() {
        return !!this.args["enable-rdp-display-tracking"];
      }
      get codeCachePath() {
        return process.env["VSCODE_CODE_CACHE_PATH"] || void 0;
      }
      get useCodeCache() {
        return !!this.codeCachePath;
      }
      unsetSnapExportedVariables() {
        if (!isLinux) {
          return;
        }
        for (const key in process.env) {
          if (key.endsWith("_VSCODE_SNAP_ORIG")) {
            const originalKey = key.slice(0, -17);
            if (this._snapEnv[originalKey]) {
              continue;
            }
            if (process.env[originalKey]) {
              this._snapEnv[originalKey] = process.env[originalKey];
            }
            if (process.env[key]) {
              process.env[originalKey] = process.env[key];
            } else {
              delete process.env[originalKey];
            }
          }
        }
      }
      restoreSnapExportedVariables() {
        if (!isLinux) {
          return;
        }
        for (const key in this._snapEnv) {
          process.env[key] = this._snapEnv[key];
          delete this._snapEnv[key];
        }
      }
    };
    __decorate([
      memoize
    ], EnvironmentMainService.prototype, "backupHome", null);
    __decorate([
      memoize
    ], EnvironmentMainService.prototype, "mainIPCHandle", null);
    __decorate([
      memoize
    ], EnvironmentMainService.prototype, "mainLockfile", null);
    __decorate([
      memoize
    ], EnvironmentMainService.prototype, "disableUpdates", null);
    __decorate([
      memoize
    ], EnvironmentMainService.prototype, "crossOriginIsolated", null);
    __decorate([
      memoize
    ], EnvironmentMainService.prototype, "enableRDPDisplayTracking", null);
    __decorate([
      memoize
    ], EnvironmentMainService.prototype, "codeCachePath", null);
    __decorate([
      memoize
    ], EnvironmentMainService.prototype, "useCodeCache", null);
  }
});

// out-build/vs/platform/contextkey/common/scanner.js
function hintDidYouMean(...meant) {
  switch (meant.length) {
    case 1:
      return localize(1818, null, meant[0]);
    case 2:
      return localize(1819, null, meant[0], meant[1]);
    case 3:
      return localize(1820, null, meant[0], meant[1], meant[2]);
    default:
      return void 0;
  }
}
var TokenType, hintDidYouForgetToOpenOrCloseQuote, hintDidYouForgetToEscapeSlash, Scanner;
var init_scanner = __esm({
  "out-build/vs/platform/contextkey/common/scanner.js"() {
    "use strict";
    init_errors();
    init_nls();
    (function(TokenType2) {
      TokenType2[TokenType2["LParen"] = 0] = "LParen";
      TokenType2[TokenType2["RParen"] = 1] = "RParen";
      TokenType2[TokenType2["Neg"] = 2] = "Neg";
      TokenType2[TokenType2["Eq"] = 3] = "Eq";
      TokenType2[TokenType2["NotEq"] = 4] = "NotEq";
      TokenType2[TokenType2["Lt"] = 5] = "Lt";
      TokenType2[TokenType2["LtEq"] = 6] = "LtEq";
      TokenType2[TokenType2["Gt"] = 7] = "Gt";
      TokenType2[TokenType2["GtEq"] = 8] = "GtEq";
      TokenType2[TokenType2["RegexOp"] = 9] = "RegexOp";
      TokenType2[TokenType2["RegexStr"] = 10] = "RegexStr";
      TokenType2[TokenType2["True"] = 11] = "True";
      TokenType2[TokenType2["False"] = 12] = "False";
      TokenType2[TokenType2["In"] = 13] = "In";
      TokenType2[TokenType2["Not"] = 14] = "Not";
      TokenType2[TokenType2["And"] = 15] = "And";
      TokenType2[TokenType2["Or"] = 16] = "Or";
      TokenType2[TokenType2["Str"] = 17] = "Str";
      TokenType2[TokenType2["QuotedStr"] = 18] = "QuotedStr";
      TokenType2[TokenType2["Error"] = 19] = "Error";
      TokenType2[TokenType2["EOF"] = 20] = "EOF";
    })(TokenType || (TokenType = {}));
    hintDidYouForgetToOpenOrCloseQuote = localize(1821, null);
    hintDidYouForgetToEscapeSlash = localize(1822, null);
    Scanner = class _Scanner {
      constructor() {
        this._input = "";
        this._start = 0;
        this._current = 0;
        this._tokens = [];
        this._errors = [];
        this.stringRe = /[a-zA-Z0-9_<>\-\./\\:\*\?\+\[\]\^,#@;"%\$\p{L}-]+/uy;
      }
      static getLexeme(token) {
        switch (token.type) {
          case 0:
            return "(";
          case 1:
            return ")";
          case 2:
            return "!";
          case 3:
            return token.isTripleEq ? "===" : "==";
          case 4:
            return token.isTripleEq ? "!==" : "!=";
          case 5:
            return "<";
          case 6:
            return "<=";
          case 7:
            return ">=";
          case 8:
            return ">=";
          case 9:
            return "=~";
          case 10:
            return token.lexeme;
          case 11:
            return "true";
          case 12:
            return "false";
          case 13:
            return "in";
          case 14:
            return "not";
          case 15:
            return "&&";
          case 16:
            return "||";
          case 17:
            return token.lexeme;
          case 18:
            return token.lexeme;
          case 19:
            return token.lexeme;
          case 20:
            return "EOF";
          default:
            throw illegalState(`unhandled token type: ${JSON.stringify(token)}; have you forgotten to add a case?`);
        }
      }
      static {
        this._regexFlags = new Set(["i", "g", "s", "m", "y", "u"].map((ch) => ch.charCodeAt(0)));
      }
      static {
        this._keywords = /* @__PURE__ */ new Map([
          [
            "not",
            14
            /* TokenType.Not */
          ],
          [
            "in",
            13
            /* TokenType.In */
          ],
          [
            "false",
            12
            /* TokenType.False */
          ],
          [
            "true",
            11
            /* TokenType.True */
          ]
        ]);
      }
      get errors() {
        return this._errors;
      }
      reset(value) {
        this._input = value;
        this._start = 0;
        this._current = 0;
        this._tokens = [];
        this._errors = [];
        return this;
      }
      scan() {
        while (!this._isAtEnd()) {
          this._start = this._current;
          const ch = this._advance();
          switch (ch) {
            case 40:
              this._addToken(
                0
                /* TokenType.LParen */
              );
              break;
            case 41:
              this._addToken(
                1
                /* TokenType.RParen */
              );
              break;
            case 33:
              if (this._match(
                61
                /* CharCode.Equals */
              )) {
                const isTripleEq = this._match(
                  61
                  /* CharCode.Equals */
                );
                this._tokens.push({ type: 4, offset: this._start, isTripleEq });
              } else {
                this._addToken(
                  2
                  /* TokenType.Neg */
                );
              }
              break;
            case 39:
              this._quotedString();
              break;
            case 47:
              this._regex();
              break;
            case 61:
              if (this._match(
                61
                /* CharCode.Equals */
              )) {
                const isTripleEq = this._match(
                  61
                  /* CharCode.Equals */
                );
                this._tokens.push({ type: 3, offset: this._start, isTripleEq });
              } else if (this._match(
                126
                /* CharCode.Tilde */
              )) {
                this._addToken(
                  9
                  /* TokenType.RegexOp */
                );
              } else {
                this._error(hintDidYouMean("==", "=~"));
              }
              break;
            case 60:
              this._addToken(
                this._match(
                  61
                  /* CharCode.Equals */
                ) ? 6 : 5
                /* TokenType.Lt */
              );
              break;
            case 62:
              this._addToken(
                this._match(
                  61
                  /* CharCode.Equals */
                ) ? 8 : 7
                /* TokenType.Gt */
              );
              break;
            case 38:
              if (this._match(
                38
                /* CharCode.Ampersand */
              )) {
                this._addToken(
                  15
                  /* TokenType.And */
                );
              } else {
                this._error(hintDidYouMean("&&"));
              }
              break;
            case 124:
              if (this._match(
                124
                /* CharCode.Pipe */
              )) {
                this._addToken(
                  16
                  /* TokenType.Or */
                );
              } else {
                this._error(hintDidYouMean("||"));
              }
              break;
            // TODO@ulugbekna: 1) rewrite using a regex 2) reconsider what characters are considered whitespace, including unicode, nbsp, etc.
            case 32:
            case 13:
            case 9:
            case 10:
            case 160:
              break;
            default:
              this._string();
          }
        }
        this._start = this._current;
        this._addToken(
          20
          /* TokenType.EOF */
        );
        return Array.from(this._tokens);
      }
      _match(expected) {
        if (this._isAtEnd()) {
          return false;
        }
        if (this._input.charCodeAt(this._current) !== expected) {
          return false;
        }
        this._current++;
        return true;
      }
      _advance() {
        return this._input.charCodeAt(this._current++);
      }
      _peek() {
        return this._isAtEnd() ? 0 : this._input.charCodeAt(this._current);
      }
      _addToken(type3) {
        this._tokens.push({ type: type3, offset: this._start });
      }
      _error(additional) {
        const offset = this._start;
        const lexeme = this._input.substring(this._start, this._current);
        const errToken = { type: 19, offset: this._start, lexeme };
        this._errors.push({ offset, lexeme, additionalInfo: additional });
        this._tokens.push(errToken);
      }
      _string() {
        this.stringRe.lastIndex = this._start;
        const match = this.stringRe.exec(this._input);
        if (match) {
          this._current = this._start + match[0].length;
          const lexeme = this._input.substring(this._start, this._current);
          const keyword = _Scanner._keywords.get(lexeme);
          if (keyword) {
            this._addToken(keyword);
          } else {
            this._tokens.push({ type: 17, lexeme, offset: this._start });
          }
        }
      }
      // captures the lexeme without the leading and trailing '
      _quotedString() {
        while (this._peek() !== 39 && !this._isAtEnd()) {
          this._advance();
        }
        if (this._isAtEnd()) {
          this._error(hintDidYouForgetToOpenOrCloseQuote);
          return;
        }
        this._advance();
        this._tokens.push({ type: 18, lexeme: this._input.substring(this._start + 1, this._current - 1), offset: this._start + 1 });
      }
      /*
       * Lexing a regex expression: /.../[igsmyu]*
       * Based on https://github.com/microsoft/TypeScript/blob/9247ef115e617805983740ba795d7a8164babf89/src/compiler/scanner.ts#L2129-L2181
       *
       * Note that we want slashes within a regex to be escaped, e.g., /file:\\/\\/\\// should match `file:///`
       */
      _regex() {
        let p = this._current;
        let inEscape = false;
        let inCharacterClass = false;
        while (true) {
          if (p >= this._input.length) {
            this._current = p;
            this._error(hintDidYouForgetToEscapeSlash);
            return;
          }
          const ch = this._input.charCodeAt(p);
          if (inEscape) {
            inEscape = false;
          } else if (ch === 47 && !inCharacterClass) {
            p++;
            break;
          } else if (ch === 91) {
            inCharacterClass = true;
          } else if (ch === 92) {
            inEscape = true;
          } else if (ch === 93) {
            inCharacterClass = false;
          }
          p++;
        }
        while (p < this._input.length && _Scanner._regexFlags.has(this._input.charCodeAt(p))) {
          p++;
        }
        this._current = p;
        const lexeme = this._input.substring(this._start, this._current);
        this._tokens.push({ type: 10, lexeme, offset: this._start });
      }
      _isAtEnd() {
        return this._current >= this._input.length;
      }
    };
  }
});

// out-build/vs/platform/contextkey/common/contextkey.js
function cmp(a, b) {
  return a.cmp(b);
}
function withFloatOrStr(value, callback) {
  if (typeof value === "string") {
    const n = parseFloat(value);
    if (!isNaN(n)) {
      value = n;
    }
  }
  if (typeof value === "string" || typeof value === "number") {
    return callback(value);
  }
  return ContextKeyFalseExpr.INSTANCE;
}
function eliminateConstantsInArray(arr) {
  let newArr = null;
  for (let i = 0, len = arr.length; i < len; i++) {
    const newExpr = arr[i].substituteConstants();
    if (arr[i] !== newExpr) {
      if (newArr === null) {
        newArr = [];
        for (let j = 0; j < i; j++) {
          newArr[j] = arr[j];
        }
      }
    }
    if (newArr !== null) {
      newArr[i] = newExpr;
    }
  }
  if (newArr === null) {
    return arr;
  }
  return newArr;
}
function cmp1(key1, key2) {
  if (key1 < key2) {
    return -1;
  }
  if (key1 > key2) {
    return 1;
  }
  return 0;
}
function cmp2(key1, value1, key2, value2) {
  if (key1 < key2) {
    return -1;
  }
  if (key1 > key2) {
    return 1;
  }
  if (value1 < value2) {
    return -1;
  }
  if (value1 > value2) {
    return 1;
  }
  return 0;
}
function getTerminals(node) {
  if (node.type === 9) {
    return node.expr;
  }
  return [node];
}
var CONSTANT_VALUES, hasOwnProperty2, ContextKeyExprType, defaultConfig, errorEmptyString, hintEmptyString, errorNoInAfterNot, errorClosingParenthesis, errorUnexpectedToken, hintUnexpectedToken, errorUnexpectedEOF, hintUnexpectedEOF, Parser, ContextKeyExpr, ContextKeyFalseExpr, ContextKeyTrueExpr, ContextKeyDefinedExpr, ContextKeyEqualsExpr, ContextKeyInExpr, ContextKeyNotInExpr, ContextKeyNotEqualsExpr, ContextKeyNotExpr, ContextKeyGreaterExpr, ContextKeyGreaterEqualsExpr, ContextKeySmallerExpr, ContextKeySmallerEqualsExpr, ContextKeyRegexExpr, ContextKeyNotRegexExpr, ContextKeyAndExpr, ContextKeyOrExpr, RawContextKey, IContextKeyService;
var init_contextkey = __esm({
  "out-build/vs/platform/contextkey/common/contextkey.js"() {
    "use strict";
    init_platform();
    init_strings();
    init_scanner();
    init_instantiation();
    init_nls();
    init_errors();
    CONSTANT_VALUES = /* @__PURE__ */ new Map();
    CONSTANT_VALUES.set("false", false);
    CONSTANT_VALUES.set("true", true);
    CONSTANT_VALUES.set("isMac", isMacintosh);
    CONSTANT_VALUES.set("isLinux", isLinux);
    CONSTANT_VALUES.set("isWindows", isWindows2);
    CONSTANT_VALUES.set("isWeb", isWeb);
    CONSTANT_VALUES.set("isMacNative", isMacintosh && !isWeb);
    CONSTANT_VALUES.set("isEdge", isEdge);
    CONSTANT_VALUES.set("isFirefox", isFirefox);
    CONSTANT_VALUES.set("isChrome", isChrome);
    CONSTANT_VALUES.set("isSafari", isSafari);
    hasOwnProperty2 = Object.prototype.hasOwnProperty;
    (function(ContextKeyExprType2) {
      ContextKeyExprType2[ContextKeyExprType2["False"] = 0] = "False";
      ContextKeyExprType2[ContextKeyExprType2["True"] = 1] = "True";
      ContextKeyExprType2[ContextKeyExprType2["Defined"] = 2] = "Defined";
      ContextKeyExprType2[ContextKeyExprType2["Not"] = 3] = "Not";
      ContextKeyExprType2[ContextKeyExprType2["Equals"] = 4] = "Equals";
      ContextKeyExprType2[ContextKeyExprType2["NotEquals"] = 5] = "NotEquals";
      ContextKeyExprType2[ContextKeyExprType2["And"] = 6] = "And";
      ContextKeyExprType2[ContextKeyExprType2["Regex"] = 7] = "Regex";
      ContextKeyExprType2[ContextKeyExprType2["NotRegex"] = 8] = "NotRegex";
      ContextKeyExprType2[ContextKeyExprType2["Or"] = 9] = "Or";
      ContextKeyExprType2[ContextKeyExprType2["In"] = 10] = "In";
      ContextKeyExprType2[ContextKeyExprType2["NotIn"] = 11] = "NotIn";
      ContextKeyExprType2[ContextKeyExprType2["Greater"] = 12] = "Greater";
      ContextKeyExprType2[ContextKeyExprType2["GreaterEquals"] = 13] = "GreaterEquals";
      ContextKeyExprType2[ContextKeyExprType2["Smaller"] = 14] = "Smaller";
      ContextKeyExprType2[ContextKeyExprType2["SmallerEquals"] = 15] = "SmallerEquals";
    })(ContextKeyExprType || (ContextKeyExprType = {}));
    defaultConfig = {
      regexParsingWithErrorRecovery: true
    };
    errorEmptyString = localize(1798, null);
    hintEmptyString = localize(1799, null);
    errorNoInAfterNot = localize(1800, null);
    errorClosingParenthesis = localize(1801, null);
    errorUnexpectedToken = localize(1802, null);
    hintUnexpectedToken = localize(1803, null);
    errorUnexpectedEOF = localize(1804, null);
    hintUnexpectedEOF = localize(1805, null);
    Parser = class _Parser {
      static {
        this._parseError = new Error();
      }
      get lexingErrors() {
        return this._scanner.errors;
      }
      get parsingErrors() {
        return this._parsingErrors;
      }
      constructor(_config = defaultConfig) {
        this._config = _config;
        this._scanner = new Scanner();
        this._tokens = [];
        this._current = 0;
        this._parsingErrors = [];
        this._flagsGYRe = /g|y/g;
      }
      /**
       * Parse a context key expression.
       *
       * @param input the expression to parse
       * @returns the parsed expression or `undefined` if there's an error - call `lexingErrors` and `parsingErrors` to see the errors
       */
      parse(input) {
        if (input === "") {
          this._parsingErrors.push({ message: errorEmptyString, offset: 0, lexeme: "", additionalInfo: hintEmptyString });
          return void 0;
        }
        this._tokens = this._scanner.reset(input).scan();
        this._current = 0;
        this._parsingErrors = [];
        try {
          const expr = this._expr();
          if (!this._isAtEnd()) {
            const peek = this._peek();
            const additionalInfo = peek.type === 17 ? hintUnexpectedToken : void 0;
            this._parsingErrors.push({ message: errorUnexpectedToken, offset: peek.offset, lexeme: Scanner.getLexeme(peek), additionalInfo });
            throw _Parser._parseError;
          }
          return expr;
        } catch (e) {
          if (!(e === _Parser._parseError)) {
            throw e;
          }
          return void 0;
        }
      }
      _expr() {
        return this._or();
      }
      _or() {
        const expr = [this._and()];
        while (this._matchOne(
          16
          /* TokenType.Or */
        )) {
          const right = this._and();
          expr.push(right);
        }
        return expr.length === 1 ? expr[0] : ContextKeyExpr.or(...expr);
      }
      _and() {
        const expr = [this._term()];
        while (this._matchOne(
          15
          /* TokenType.And */
        )) {
          const right = this._term();
          expr.push(right);
        }
        return expr.length === 1 ? expr[0] : ContextKeyExpr.and(...expr);
      }
      _term() {
        if (this._matchOne(
          2
          /* TokenType.Neg */
        )) {
          const peek = this._peek();
          switch (peek.type) {
            case 11:
              this._advance();
              return ContextKeyFalseExpr.INSTANCE;
            case 12:
              this._advance();
              return ContextKeyTrueExpr.INSTANCE;
            case 0: {
              this._advance();
              const expr = this._expr();
              this._consume(1, errorClosingParenthesis);
              return expr?.negate();
            }
            case 17:
              this._advance();
              return ContextKeyNotExpr.create(peek.lexeme);
            default:
              throw this._errExpectedButGot(`KEY | true | false | '(' expression ')'`, peek);
          }
        }
        return this._primary();
      }
      _primary() {
        const peek = this._peek();
        switch (peek.type) {
          case 11:
            this._advance();
            return ContextKeyExpr.true();
          case 12:
            this._advance();
            return ContextKeyExpr.false();
          case 0: {
            this._advance();
            const expr = this._expr();
            this._consume(1, errorClosingParenthesis);
            return expr;
          }
          case 17: {
            const key = peek.lexeme;
            this._advance();
            if (this._matchOne(
              9
              /* TokenType.RegexOp */
            )) {
              const expr = this._peek();
              if (!this._config.regexParsingWithErrorRecovery) {
                this._advance();
                if (expr.type !== 10) {
                  throw this._errExpectedButGot(`REGEX`, expr);
                }
                const regexLexeme = expr.lexeme;
                const closingSlashIndex = regexLexeme.lastIndexOf("/");
                const flags = closingSlashIndex === regexLexeme.length - 1 ? void 0 : this._removeFlagsGY(regexLexeme.substring(closingSlashIndex + 1));
                let regexp2;
                try {
                  regexp2 = new RegExp(regexLexeme.substring(1, closingSlashIndex), flags);
                } catch (e) {
                  throw this._errExpectedButGot(`REGEX`, expr);
                }
                return ContextKeyRegexExpr.create(key, regexp2);
              }
              switch (expr.type) {
                case 10:
                case 19: {
                  const lexemeReconstruction = [expr.lexeme];
                  this._advance();
                  let followingToken = this._peek();
                  let parenBalance = 0;
                  for (let i = 0; i < expr.lexeme.length; i++) {
                    if (expr.lexeme.charCodeAt(i) === 40) {
                      parenBalance++;
                    } else if (expr.lexeme.charCodeAt(i) === 41) {
                      parenBalance--;
                    }
                  }
                  while (!this._isAtEnd() && followingToken.type !== 15 && followingToken.type !== 16) {
                    switch (followingToken.type) {
                      case 0:
                        parenBalance++;
                        break;
                      case 1:
                        parenBalance--;
                        break;
                      case 10:
                      case 18:
                        for (let i = 0; i < followingToken.lexeme.length; i++) {
                          if (followingToken.lexeme.charCodeAt(i) === 40) {
                            parenBalance++;
                          } else if (expr.lexeme.charCodeAt(i) === 41) {
                            parenBalance--;
                          }
                        }
                    }
                    if (parenBalance < 0) {
                      break;
                    }
                    lexemeReconstruction.push(Scanner.getLexeme(followingToken));
                    this._advance();
                    followingToken = this._peek();
                  }
                  const regexLexeme = lexemeReconstruction.join("");
                  const closingSlashIndex = regexLexeme.lastIndexOf("/");
                  const flags = closingSlashIndex === regexLexeme.length - 1 ? void 0 : this._removeFlagsGY(regexLexeme.substring(closingSlashIndex + 1));
                  let regexp2;
                  try {
                    regexp2 = new RegExp(regexLexeme.substring(1, closingSlashIndex), flags);
                  } catch (e) {
                    throw this._errExpectedButGot(`REGEX`, expr);
                  }
                  return ContextKeyExpr.regex(key, regexp2);
                }
                case 18: {
                  const serializedValue = expr.lexeme;
                  this._advance();
                  let regex = null;
                  if (!isFalsyOrWhitespace(serializedValue)) {
                    const start = serializedValue.indexOf("/");
                    const end = serializedValue.lastIndexOf("/");
                    if (start !== end && start >= 0) {
                      const value = serializedValue.slice(start + 1, end);
                      const caseIgnoreFlag = serializedValue[end + 1] === "i" ? "i" : "";
                      try {
                        regex = new RegExp(value, caseIgnoreFlag);
                      } catch (_e) {
                        throw this._errExpectedButGot(`REGEX`, expr);
                      }
                    }
                  }
                  if (regex === null) {
                    throw this._errExpectedButGot("REGEX", expr);
                  }
                  return ContextKeyRegexExpr.create(key, regex);
                }
                default:
                  throw this._errExpectedButGot("REGEX", this._peek());
              }
            }
            if (this._matchOne(
              14
              /* TokenType.Not */
            )) {
              this._consume(13, errorNoInAfterNot);
              const right = this._value();
              return ContextKeyExpr.notIn(key, right);
            }
            const maybeOp = this._peek().type;
            switch (maybeOp) {
              case 3: {
                this._advance();
                const right = this._value();
                if (this._previous().type === 18) {
                  return ContextKeyExpr.equals(key, right);
                }
                switch (right) {
                  case "true":
                    return ContextKeyExpr.has(key);
                  case "false":
                    return ContextKeyExpr.not(key);
                  default:
                    return ContextKeyExpr.equals(key, right);
                }
              }
              case 4: {
                this._advance();
                const right = this._value();
                if (this._previous().type === 18) {
                  return ContextKeyExpr.notEquals(key, right);
                }
                switch (right) {
                  case "true":
                    return ContextKeyExpr.not(key);
                  case "false":
                    return ContextKeyExpr.has(key);
                  default:
                    return ContextKeyExpr.notEquals(key, right);
                }
              }
              // TODO: ContextKeyExpr.smaller(key, right) accepts only `number` as `right` AND during eval of this node, we just eval to `false` if `right` is not a number
              // consequently, package.json linter should _warn_ the user if they're passing undesired things to ops
              case 5:
                this._advance();
                return ContextKeySmallerExpr.create(key, this._value());
              case 6:
                this._advance();
                return ContextKeySmallerEqualsExpr.create(key, this._value());
              case 7:
                this._advance();
                return ContextKeyGreaterExpr.create(key, this._value());
              case 8:
                this._advance();
                return ContextKeyGreaterEqualsExpr.create(key, this._value());
              case 13:
                this._advance();
                return ContextKeyExpr.in(key, this._value());
              default:
                return ContextKeyExpr.has(key);
            }
          }
          case 20:
            this._parsingErrors.push({ message: errorUnexpectedEOF, offset: peek.offset, lexeme: "", additionalInfo: hintUnexpectedEOF });
            throw _Parser._parseError;
          default:
            throw this._errExpectedButGot(`true | false | KEY 
	| KEY '=~' REGEX 
	| KEY ('==' | '!=' | '<' | '<=' | '>' | '>=' | 'in' | 'not' 'in') value`, this._peek());
        }
      }
      _value() {
        const token = this._peek();
        switch (token.type) {
          case 17:
          case 18:
            this._advance();
            return token.lexeme;
          case 11:
            this._advance();
            return "true";
          case 12:
            this._advance();
            return "false";
          case 13:
            this._advance();
            return "in";
          default:
            return "";
        }
      }
      _removeFlagsGY(flags) {
        return flags.replaceAll(this._flagsGYRe, "");
      }
      // careful: this can throw if current token is the initial one (ie index = 0)
      _previous() {
        return this._tokens[this._current - 1];
      }
      _matchOne(token) {
        if (this._check(token)) {
          this._advance();
          return true;
        }
        return false;
      }
      _advance() {
        if (!this._isAtEnd()) {
          this._current++;
        }
        return this._previous();
      }
      _consume(type3, message) {
        if (this._check(type3)) {
          return this._advance();
        }
        throw this._errExpectedButGot(message, this._peek());
      }
      _errExpectedButGot(expected, got, additionalInfo) {
        const message = localize(1806, null, expected, Scanner.getLexeme(got));
        const offset = got.offset;
        const lexeme = Scanner.getLexeme(got);
        this._parsingErrors.push({ message, offset, lexeme, additionalInfo });
        return _Parser._parseError;
      }
      _check(type3) {
        return this._peek().type === type3;
      }
      _peek() {
        return this._tokens[this._current];
      }
      _isAtEnd() {
        return this._peek().type === 20;
      }
    };
    ContextKeyExpr = class {
      static false() {
        return ContextKeyFalseExpr.INSTANCE;
      }
      static true() {
        return ContextKeyTrueExpr.INSTANCE;
      }
      static has(key) {
        return ContextKeyDefinedExpr.create(key);
      }
      static equals(key, value) {
        return ContextKeyEqualsExpr.create(key, value);
      }
      static notEquals(key, value) {
        return ContextKeyNotEqualsExpr.create(key, value);
      }
      static regex(key, value) {
        return ContextKeyRegexExpr.create(key, value);
      }
      static in(key, value) {
        return ContextKeyInExpr.create(key, value);
      }
      static notIn(key, value) {
        return ContextKeyNotInExpr.create(key, value);
      }
      static not(key) {
        return ContextKeyNotExpr.create(key);
      }
      static and(...expr) {
        return ContextKeyAndExpr.create(expr, null, true);
      }
      static or(...expr) {
        return ContextKeyOrExpr.create(expr, null, true);
      }
      static greater(key, value) {
        return ContextKeyGreaterExpr.create(key, value);
      }
      static greaterEquals(key, value) {
        return ContextKeyGreaterEqualsExpr.create(key, value);
      }
      static smaller(key, value) {
        return ContextKeySmallerExpr.create(key, value);
      }
      static smallerEquals(key, value) {
        return ContextKeySmallerEqualsExpr.create(key, value);
      }
      static {
        this._parser = new Parser({ regexParsingWithErrorRecovery: false });
      }
      static deserialize(serialized) {
        if (serialized === void 0 || serialized === null) {
          return void 0;
        }
        const expr = this._parser.parse(serialized);
        return expr;
      }
    };
    ContextKeyFalseExpr = class _ContextKeyFalseExpr {
      static {
        this.INSTANCE = new _ContextKeyFalseExpr();
      }
      constructor() {
        this.type = 0;
      }
      cmp(other) {
        return this.type - other.type;
      }
      equals(other) {
        return other.type === this.type;
      }
      substituteConstants() {
        return this;
      }
      evaluate(context) {
        return false;
      }
      serialize() {
        return "false";
      }
      keys() {
        return [];
      }
      map(mapFnc) {
        return this;
      }
      negate() {
        return ContextKeyTrueExpr.INSTANCE;
      }
    };
    ContextKeyTrueExpr = class _ContextKeyTrueExpr {
      static {
        this.INSTANCE = new _ContextKeyTrueExpr();
      }
      constructor() {
        this.type = 1;
      }
      cmp(other) {
        return this.type - other.type;
      }
      equals(other) {
        return other.type === this.type;
      }
      substituteConstants() {
        return this;
      }
      evaluate(context) {
        return true;
      }
      serialize() {
        return "true";
      }
      keys() {
        return [];
      }
      map(mapFnc) {
        return this;
      }
      negate() {
        return ContextKeyFalseExpr.INSTANCE;
      }
    };
    ContextKeyDefinedExpr = class _ContextKeyDefinedExpr {
      static create(key, negated = null) {
        const constantValue = CONSTANT_VALUES.get(key);
        if (typeof constantValue === "boolean") {
          return constantValue ? ContextKeyTrueExpr.INSTANCE : ContextKeyFalseExpr.INSTANCE;
        }
        return new _ContextKeyDefinedExpr(key, negated);
      }
      constructor(key, negated) {
        this.key = key;
        this.negated = negated;
        this.type = 2;
      }
      cmp(other) {
        if (other.type !== this.type) {
          return this.type - other.type;
        }
        return cmp1(this.key, other.key);
      }
      equals(other) {
        if (other.type === this.type) {
          return this.key === other.key;
        }
        return false;
      }
      substituteConstants() {
        const constantValue = CONSTANT_VALUES.get(this.key);
        if (typeof constantValue === "boolean") {
          return constantValue ? ContextKeyTrueExpr.INSTANCE : ContextKeyFalseExpr.INSTANCE;
        }
        return this;
      }
      evaluate(context) {
        return !!context.getValue(this.key);
      }
      serialize() {
        return this.key;
      }
      keys() {
        return [this.key];
      }
      map(mapFnc) {
        return mapFnc.mapDefined(this.key);
      }
      negate() {
        if (!this.negated) {
          this.negated = ContextKeyNotExpr.create(this.key, this);
        }
        return this.negated;
      }
    };
    ContextKeyEqualsExpr = class _ContextKeyEqualsExpr {
      static create(key, value, negated = null) {
        if (typeof value === "boolean") {
          return value ? ContextKeyDefinedExpr.create(key, negated) : ContextKeyNotExpr.create(key, negated);
        }
        const constantValue = CONSTANT_VALUES.get(key);
        if (typeof constantValue === "boolean") {
          const trueValue = constantValue ? "true" : "false";
          return value === trueValue ? ContextKeyTrueExpr.INSTANCE : ContextKeyFalseExpr.INSTANCE;
        }
        return new _ContextKeyEqualsExpr(key, value, negated);
      }
      constructor(key, value, negated) {
        this.key = key;
        this.value = value;
        this.negated = negated;
        this.type = 4;
      }
      cmp(other) {
        if (other.type !== this.type) {
          return this.type - other.type;
        }
        return cmp2(this.key, this.value, other.key, other.value);
      }
      equals(other) {
        if (other.type === this.type) {
          return this.key === other.key && this.value === other.value;
        }
        return false;
      }
      substituteConstants() {
        const constantValue = CONSTANT_VALUES.get(this.key);
        if (typeof constantValue === "boolean") {
          const trueValue = constantValue ? "true" : "false";
          return this.value === trueValue ? ContextKeyTrueExpr.INSTANCE : ContextKeyFalseExpr.INSTANCE;
        }
        return this;
      }
      evaluate(context) {
        return context.getValue(this.key) == this.value;
      }
      serialize() {
        return `${this.key} == '${this.value}'`;
      }
      keys() {
        return [this.key];
      }
      map(mapFnc) {
        return mapFnc.mapEquals(this.key, this.value);
      }
      negate() {
        if (!this.negated) {
          this.negated = ContextKeyNotEqualsExpr.create(this.key, this.value, this);
        }
        return this.negated;
      }
    };
    ContextKeyInExpr = class _ContextKeyInExpr {
      static create(key, valueKey) {
        return new _ContextKeyInExpr(key, valueKey);
      }
      constructor(key, valueKey) {
        this.key = key;
        this.valueKey = valueKey;
        this.type = 10;
        this.negated = null;
      }
      cmp(other) {
        if (other.type !== this.type) {
          return this.type - other.type;
        }
        return cmp2(this.key, this.valueKey, other.key, other.valueKey);
      }
      equals(other) {
        if (other.type === this.type) {
          return this.key === other.key && this.valueKey === other.valueKey;
        }
        return false;
      }
      substituteConstants() {
        return this;
      }
      evaluate(context) {
        const source = context.getValue(this.valueKey);
        const item = context.getValue(this.key);
        if (Array.isArray(source)) {
          return source.includes(item);
        }
        if (typeof item === "string" && typeof source === "object" && source !== null) {
          return hasOwnProperty2.call(source, item);
        }
        return false;
      }
      serialize() {
        return `${this.key} in '${this.valueKey}'`;
      }
      keys() {
        return [this.key, this.valueKey];
      }
      map(mapFnc) {
        return mapFnc.mapIn(this.key, this.valueKey);
      }
      negate() {
        if (!this.negated) {
          this.negated = ContextKeyNotInExpr.create(this.key, this.valueKey);
        }
        return this.negated;
      }
    };
    ContextKeyNotInExpr = class _ContextKeyNotInExpr {
      static create(key, valueKey) {
        return new _ContextKeyNotInExpr(key, valueKey);
      }
      constructor(key, valueKey) {
        this.key = key;
        this.valueKey = valueKey;
        this.type = 11;
        this._negated = ContextKeyInExpr.create(key, valueKey);
      }
      cmp(other) {
        if (other.type !== this.type) {
          return this.type - other.type;
        }
        return this._negated.cmp(other._negated);
      }
      equals(other) {
        if (other.type === this.type) {
          return this._negated.equals(other._negated);
        }
        return false;
      }
      substituteConstants() {
        return this;
      }
      evaluate(context) {
        return !this._negated.evaluate(context);
      }
      serialize() {
        return `${this.key} not in '${this.valueKey}'`;
      }
      keys() {
        return this._negated.keys();
      }
      map(mapFnc) {
        return mapFnc.mapNotIn(this.key, this.valueKey);
      }
      negate() {
        return this._negated;
      }
    };
    ContextKeyNotEqualsExpr = class _ContextKeyNotEqualsExpr {
      static create(key, value, negated = null) {
        if (typeof value === "boolean") {
          if (value) {
            return ContextKeyNotExpr.create(key, negated);
          }
          return ContextKeyDefinedExpr.create(key, negated);
        }
        const constantValue = CONSTANT_VALUES.get(key);
        if (typeof constantValue === "boolean") {
          const falseValue = constantValue ? "true" : "false";
          return value === falseValue ? ContextKeyFalseExpr.INSTANCE : ContextKeyTrueExpr.INSTANCE;
        }
        return new _ContextKeyNotEqualsExpr(key, value, negated);
      }
      constructor(key, value, negated) {
        this.key = key;
        this.value = value;
        this.negated = negated;
        this.type = 5;
      }
      cmp(other) {
        if (other.type !== this.type) {
          return this.type - other.type;
        }
        return cmp2(this.key, this.value, other.key, other.value);
      }
      equals(other) {
        if (other.type === this.type) {
          return this.key === other.key && this.value === other.value;
        }
        return false;
      }
      substituteConstants() {
        const constantValue = CONSTANT_VALUES.get(this.key);
        if (typeof constantValue === "boolean") {
          const falseValue = constantValue ? "true" : "false";
          return this.value === falseValue ? ContextKeyFalseExpr.INSTANCE : ContextKeyTrueExpr.INSTANCE;
        }
        return this;
      }
      evaluate(context) {
        return context.getValue(this.key) != this.value;
      }
      serialize() {
        return `${this.key} != '${this.value}'`;
      }
      keys() {
        return [this.key];
      }
      map(mapFnc) {
        return mapFnc.mapNotEquals(this.key, this.value);
      }
      negate() {
        if (!this.negated) {
          this.negated = ContextKeyEqualsExpr.create(this.key, this.value, this);
        }
        return this.negated;
      }
    };
    ContextKeyNotExpr = class _ContextKeyNotExpr {
      static create(key, negated = null) {
        const constantValue = CONSTANT_VALUES.get(key);
        if (typeof constantValue === "boolean") {
          return constantValue ? ContextKeyFalseExpr.INSTANCE : ContextKeyTrueExpr.INSTANCE;
        }
        return new _ContextKeyNotExpr(key, negated);
      }
      constructor(key, negated) {
        this.key = key;
        this.negated = negated;
        this.type = 3;
      }
      cmp(other) {
        if (other.type !== this.type) {
          return this.type - other.type;
        }
        return cmp1(this.key, other.key);
      }
      equals(other) {
        if (other.type === this.type) {
          return this.key === other.key;
        }
        return false;
      }
      substituteConstants() {
        const constantValue = CONSTANT_VALUES.get(this.key);
        if (typeof constantValue === "boolean") {
          return constantValue ? ContextKeyFalseExpr.INSTANCE : ContextKeyTrueExpr.INSTANCE;
        }
        return this;
      }
      evaluate(context) {
        return !context.getValue(this.key);
      }
      serialize() {
        return `!${this.key}`;
      }
      keys() {
        return [this.key];
      }
      map(mapFnc) {
        return mapFnc.mapNot(this.key);
      }
      negate() {
        if (!this.negated) {
          this.negated = ContextKeyDefinedExpr.create(this.key, this);
        }
        return this.negated;
      }
    };
    ContextKeyGreaterExpr = class _ContextKeyGreaterExpr {
      static create(key, _value, negated = null) {
        return withFloatOrStr(_value, (value) => new _ContextKeyGreaterExpr(key, value, negated));
      }
      constructor(key, value, negated) {
        this.key = key;
        this.value = value;
        this.negated = negated;
        this.type = 12;
      }
      cmp(other) {
        if (other.type !== this.type) {
          return this.type - other.type;
        }
        return cmp2(this.key, this.value, other.key, other.value);
      }
      equals(other) {
        if (other.type === this.type) {
          return this.key === other.key && this.value === other.value;
        }
        return false;
      }
      substituteConstants() {
        return this;
      }
      evaluate(context) {
        if (typeof this.value === "string") {
          return false;
        }
        return parseFloat(context.getValue(this.key)) > this.value;
      }
      serialize() {
        return `${this.key} > ${this.value}`;
      }
      keys() {
        return [this.key];
      }
      map(mapFnc) {
        return mapFnc.mapGreater(this.key, this.value);
      }
      negate() {
        if (!this.negated) {
          this.negated = ContextKeySmallerEqualsExpr.create(this.key, this.value, this);
        }
        return this.negated;
      }
    };
    ContextKeyGreaterEqualsExpr = class _ContextKeyGreaterEqualsExpr {
      static create(key, _value, negated = null) {
        return withFloatOrStr(_value, (value) => new _ContextKeyGreaterEqualsExpr(key, value, negated));
      }
      constructor(key, value, negated) {
        this.key = key;
        this.value = value;
        this.negated = negated;
        this.type = 13;
      }
      cmp(other) {
        if (other.type !== this.type) {
          return this.type - other.type;
        }
        return cmp2(this.key, this.value, other.key, other.value);
      }
      equals(other) {
        if (other.type === this.type) {
          return this.key === other.key && this.value === other.value;
        }
        return false;
      }
      substituteConstants() {
        return this;
      }
      evaluate(context) {
        if (typeof this.value === "string") {
          return false;
        }
        return parseFloat(context.getValue(this.key)) >= this.value;
      }
      serialize() {
        return `${this.key} >= ${this.value}`;
      }
      keys() {
        return [this.key];
      }
      map(mapFnc) {
        return mapFnc.mapGreaterEquals(this.key, this.value);
      }
      negate() {
        if (!this.negated) {
          this.negated = ContextKeySmallerExpr.create(this.key, this.value, this);
        }
        return this.negated;
      }
    };
    ContextKeySmallerExpr = class _ContextKeySmallerExpr {
      static create(key, _value, negated = null) {
        return withFloatOrStr(_value, (value) => new _ContextKeySmallerExpr(key, value, negated));
      }
      constructor(key, value, negated) {
        this.key = key;
        this.value = value;
        this.negated = negated;
        this.type = 14;
      }
      cmp(other) {
        if (other.type !== this.type) {
          return this.type - other.type;
        }
        return cmp2(this.key, this.value, other.key, other.value);
      }
      equals(other) {
        if (other.type === this.type) {
          return this.key === other.key && this.value === other.value;
        }
        return false;
      }
      substituteConstants() {
        return this;
      }
      evaluate(context) {
        if (typeof this.value === "string") {
          return false;
        }
        return parseFloat(context.getValue(this.key)) < this.value;
      }
      serialize() {
        return `${this.key} < ${this.value}`;
      }
      keys() {
        return [this.key];
      }
      map(mapFnc) {
        return mapFnc.mapSmaller(this.key, this.value);
      }
      negate() {
        if (!this.negated) {
          this.negated = ContextKeyGreaterEqualsExpr.create(this.key, this.value, this);
        }
        return this.negated;
      }
    };
    ContextKeySmallerEqualsExpr = class _ContextKeySmallerEqualsExpr {
      static create(key, _value, negated = null) {
        return withFloatOrStr(_value, (value) => new _ContextKeySmallerEqualsExpr(key, value, negated));
      }
      constructor(key, value, negated) {
        this.key = key;
        this.value = value;
        this.negated = negated;
        this.type = 15;
      }
      cmp(other) {
        if (other.type !== this.type) {
          return this.type - other.type;
        }
        return cmp2(this.key, this.value, other.key, other.value);
      }
      equals(other) {
        if (other.type === this.type) {
          return this.key === other.key && this.value === other.value;
        }
        return false;
      }
      substituteConstants() {
        return this;
      }
      evaluate(context) {
        if (typeof this.value === "string") {
          return false;
        }
        return parseFloat(context.getValue(this.key)) <= this.value;
      }
      serialize() {
        return `${this.key} <= ${this.value}`;
      }
      keys() {
        return [this.key];
      }
      map(mapFnc) {
        return mapFnc.mapSmallerEquals(this.key, this.value);
      }
      negate() {
        if (!this.negated) {
          this.negated = ContextKeyGreaterExpr.create(this.key, this.value, this);
        }
        return this.negated;
      }
    };
    ContextKeyRegexExpr = class _ContextKeyRegexExpr {
      static create(key, regexp2) {
        return new _ContextKeyRegexExpr(key, regexp2);
      }
      constructor(key, regexp2) {
        this.key = key;
        this.regexp = regexp2;
        this.type = 7;
        this.negated = null;
      }
      cmp(other) {
        if (other.type !== this.type) {
          return this.type - other.type;
        }
        if (this.key < other.key) {
          return -1;
        }
        if (this.key > other.key) {
          return 1;
        }
        const thisSource = this.regexp ? this.regexp.source : "";
        const otherSource = other.regexp ? other.regexp.source : "";
        if (thisSource < otherSource) {
          return -1;
        }
        if (thisSource > otherSource) {
          return 1;
        }
        return 0;
      }
      equals(other) {
        if (other.type === this.type) {
          const thisSource = this.regexp ? this.regexp.source : "";
          const otherSource = other.regexp ? other.regexp.source : "";
          return this.key === other.key && thisSource === otherSource;
        }
        return false;
      }
      substituteConstants() {
        return this;
      }
      evaluate(context) {
        const value = context.getValue(this.key);
        return this.regexp ? this.regexp.test(value) : false;
      }
      serialize() {
        const value = this.regexp ? `/${this.regexp.source}/${this.regexp.flags}` : "/invalid/";
        return `${this.key} =~ ${value}`;
      }
      keys() {
        return [this.key];
      }
      map(mapFnc) {
        return mapFnc.mapRegex(this.key, this.regexp);
      }
      negate() {
        if (!this.negated) {
          this.negated = ContextKeyNotRegexExpr.create(this);
        }
        return this.negated;
      }
    };
    ContextKeyNotRegexExpr = class _ContextKeyNotRegexExpr {
      static create(actual) {
        return new _ContextKeyNotRegexExpr(actual);
      }
      constructor(_actual) {
        this._actual = _actual;
        this.type = 8;
      }
      cmp(other) {
        if (other.type !== this.type) {
          return this.type - other.type;
        }
        return this._actual.cmp(other._actual);
      }
      equals(other) {
        if (other.type === this.type) {
          return this._actual.equals(other._actual);
        }
        return false;
      }
      substituteConstants() {
        return this;
      }
      evaluate(context) {
        return !this._actual.evaluate(context);
      }
      serialize() {
        return `!(${this._actual.serialize()})`;
      }
      keys() {
        return this._actual.keys();
      }
      map(mapFnc) {
        return new _ContextKeyNotRegexExpr(this._actual.map(mapFnc));
      }
      negate() {
        return this._actual;
      }
    };
    ContextKeyAndExpr = class _ContextKeyAndExpr {
      static create(_expr, negated, extraRedundantCheck) {
        return _ContextKeyAndExpr._normalizeArr(_expr, negated, extraRedundantCheck);
      }
      constructor(expr, negated) {
        this.expr = expr;
        this.negated = negated;
        this.type = 6;
      }
      cmp(other) {
        if (other.type !== this.type) {
          return this.type - other.type;
        }
        if (this.expr.length < other.expr.length) {
          return -1;
        }
        if (this.expr.length > other.expr.length) {
          return 1;
        }
        for (let i = 0, len = this.expr.length; i < len; i++) {
          const r = cmp(this.expr[i], other.expr[i]);
          if (r !== 0) {
            return r;
          }
        }
        return 0;
      }
      equals(other) {
        if (other.type === this.type) {
          if (this.expr.length !== other.expr.length) {
            return false;
          }
          for (let i = 0, len = this.expr.length; i < len; i++) {
            if (!this.expr[i].equals(other.expr[i])) {
              return false;
            }
          }
          return true;
        }
        return false;
      }
      substituteConstants() {
        const exprArr = eliminateConstantsInArray(this.expr);
        if (exprArr === this.expr) {
          return this;
        }
        return _ContextKeyAndExpr.create(exprArr, this.negated, false);
      }
      evaluate(context) {
        for (let i = 0, len = this.expr.length; i < len; i++) {
          if (!this.expr[i].evaluate(context)) {
            return false;
          }
        }
        return true;
      }
      static _normalizeArr(arr, negated, extraRedundantCheck) {
        const expr = [];
        let hasTrue = false;
        for (const e of arr) {
          if (!e) {
            continue;
          }
          if (e.type === 1) {
            hasTrue = true;
            continue;
          }
          if (e.type === 0) {
            return ContextKeyFalseExpr.INSTANCE;
          }
          if (e.type === 6) {
            expr.push(...e.expr);
            continue;
          }
          expr.push(e);
        }
        if (expr.length === 0 && hasTrue) {
          return ContextKeyTrueExpr.INSTANCE;
        }
        if (expr.length === 0) {
          return void 0;
        }
        if (expr.length === 1) {
          return expr[0];
        }
        expr.sort(cmp);
        for (let i = 1; i < expr.length; i++) {
          if (expr[i - 1].equals(expr[i])) {
            expr.splice(i, 1);
            i--;
          }
        }
        if (expr.length === 1) {
          return expr[0];
        }
        while (expr.length > 1) {
          const lastElement = expr[expr.length - 1];
          if (lastElement.type !== 9) {
            break;
          }
          expr.pop();
          const secondToLastElement = expr.pop();
          const isFinished = expr.length === 0;
          const resultElement = ContextKeyOrExpr.create(lastElement.expr.map((el) => _ContextKeyAndExpr.create([el, secondToLastElement], null, extraRedundantCheck)), null, isFinished);
          if (resultElement) {
            expr.push(resultElement);
            expr.sort(cmp);
          }
        }
        if (expr.length === 1) {
          return expr[0];
        }
        if (extraRedundantCheck) {
          for (let i = 0; i < expr.length; i++) {
            for (let j = i + 1; j < expr.length; j++) {
              if (expr[i].negate().equals(expr[j])) {
                return ContextKeyFalseExpr.INSTANCE;
              }
            }
          }
          if (expr.length === 1) {
            return expr[0];
          }
        }
        return new _ContextKeyAndExpr(expr, negated);
      }
      serialize() {
        return this.expr.map((e) => e.serialize()).join(" && ");
      }
      keys() {
        const result = [];
        for (const expr of this.expr) {
          result.push(...expr.keys());
        }
        return result;
      }
      map(mapFnc) {
        return new _ContextKeyAndExpr(this.expr.map((expr) => expr.map(mapFnc)), null);
      }
      negate() {
        if (!this.negated) {
          const result = [];
          for (const expr of this.expr) {
            result.push(expr.negate());
          }
          this.negated = ContextKeyOrExpr.create(result, this, true);
        }
        return this.negated;
      }
    };
    ContextKeyOrExpr = class _ContextKeyOrExpr {
      static create(_expr, negated, extraRedundantCheck) {
        return _ContextKeyOrExpr._normalizeArr(_expr, negated, extraRedundantCheck);
      }
      constructor(expr, negated) {
        this.expr = expr;
        this.negated = negated;
        this.type = 9;
      }
      cmp(other) {
        if (other.type !== this.type) {
          return this.type - other.type;
        }
        if (this.expr.length < other.expr.length) {
          return -1;
        }
        if (this.expr.length > other.expr.length) {
          return 1;
        }
        for (let i = 0, len = this.expr.length; i < len; i++) {
          const r = cmp(this.expr[i], other.expr[i]);
          if (r !== 0) {
            return r;
          }
        }
        return 0;
      }
      equals(other) {
        if (other.type === this.type) {
          if (this.expr.length !== other.expr.length) {
            return false;
          }
          for (let i = 0, len = this.expr.length; i < len; i++) {
            if (!this.expr[i].equals(other.expr[i])) {
              return false;
            }
          }
          return true;
        }
        return false;
      }
      substituteConstants() {
        const exprArr = eliminateConstantsInArray(this.expr);
        if (exprArr === this.expr) {
          return this;
        }
        return _ContextKeyOrExpr.create(exprArr, this.negated, false);
      }
      evaluate(context) {
        for (let i = 0, len = this.expr.length; i < len; i++) {
          if (this.expr[i].evaluate(context)) {
            return true;
          }
        }
        return false;
      }
      static _normalizeArr(arr, negated, extraRedundantCheck) {
        let expr = [];
        let hasFalse = false;
        if (arr) {
          for (let i = 0, len = arr.length; i < len; i++) {
            const e = arr[i];
            if (!e) {
              continue;
            }
            if (e.type === 0) {
              hasFalse = true;
              continue;
            }
            if (e.type === 1) {
              return ContextKeyTrueExpr.INSTANCE;
            }
            if (e.type === 9) {
              expr = expr.concat(e.expr);
              continue;
            }
            expr.push(e);
          }
          if (expr.length === 0 && hasFalse) {
            return ContextKeyFalseExpr.INSTANCE;
          }
          expr.sort(cmp);
        }
        if (expr.length === 0) {
          return void 0;
        }
        if (expr.length === 1) {
          return expr[0];
        }
        for (let i = 1; i < expr.length; i++) {
          if (expr[i - 1].equals(expr[i])) {
            expr.splice(i, 1);
            i--;
          }
        }
        if (expr.length === 1) {
          return expr[0];
        }
        if (extraRedundantCheck) {
          for (let i = 0; i < expr.length; i++) {
            for (let j = i + 1; j < expr.length; j++) {
              if (expr[i].negate().equals(expr[j])) {
                return ContextKeyTrueExpr.INSTANCE;
              }
            }
          }
          if (expr.length === 1) {
            return expr[0];
          }
        }
        return new _ContextKeyOrExpr(expr, negated);
      }
      serialize() {
        return this.expr.map((e) => e.serialize()).join(" || ");
      }
      keys() {
        const result = [];
        for (const expr of this.expr) {
          result.push(...expr.keys());
        }
        return result;
      }
      map(mapFnc) {
        return new _ContextKeyOrExpr(this.expr.map((expr) => expr.map(mapFnc)), null);
      }
      negate() {
        if (!this.negated) {
          const result = [];
          for (const expr of this.expr) {
            result.push(expr.negate());
          }
          while (result.length > 1) {
            const LEFT = result.shift();
            const RIGHT = result.shift();
            const all = [];
            for (const left of getTerminals(LEFT)) {
              for (const right of getTerminals(RIGHT)) {
                all.push(ContextKeyAndExpr.create([left, right], null, false));
              }
            }
            result.unshift(_ContextKeyOrExpr.create(all, null, false));
          }
          this.negated = _ContextKeyOrExpr.create(result, this, true);
        }
        return this.negated;
      }
    };
    RawContextKey = class _RawContextKey extends ContextKeyDefinedExpr {
      static {
        this._info = [];
      }
      static all() {
        return _RawContextKey._info.values();
      }
      constructor(key, defaultValue, metaOrHide) {
        super(key, null);
        this._defaultValue = defaultValue;
        if (typeof metaOrHide === "object") {
          _RawContextKey._info.push({ ...metaOrHide, key });
        } else if (metaOrHide !== true) {
          _RawContextKey._info.push({ key, description: metaOrHide, type: defaultValue !== null && defaultValue !== void 0 ? typeof defaultValue : void 0 });
        }
      }
      bindTo(target) {
        return target.createKey(this.key, this._defaultValue);
      }
      getValue(target) {
        return target.getContextKeyValue(this.key);
      }
      toNegated() {
        return this.negate();
      }
      isEqualTo(value) {
        return ContextKeyEqualsExpr.create(this.key, value);
      }
      notEqualsTo(value) {
        return ContextKeyNotEqualsExpr.create(this.key, value);
      }
      greater(value) {
        return ContextKeyGreaterExpr.create(this.key, value);
      }
    };
    IContextKeyService = createDecorator("contextKeyService");
  }
});

// out-build/vs/platform/log/common/log.js
function now() {
  return (/* @__PURE__ */ new Date()).toISOString();
}
function isLogLevel(thing) {
  return isNumber(thing);
}
function canLog(loggerLevel, messageLevel) {
  return loggerLevel !== LogLevel.Off && loggerLevel <= messageLevel;
}
function log(logger, level, message) {
  switch (level) {
    case LogLevel.Trace:
      logger.trace(message);
      break;
    case LogLevel.Debug:
      logger.debug(message);
      break;
    case LogLevel.Info:
      logger.info(message);
      break;
    case LogLevel.Warning:
      logger.warn(message);
      break;
    case LogLevel.Error:
      logger.error(message);
      break;
    case LogLevel.Off:
      break;
    default:
      throw new Error(`Invalid log level ${level}`);
  }
}
function format2(args2, verbose = false) {
  let result = "";
  for (let i = 0; i < args2.length; i++) {
    let a = args2[i];
    if (a instanceof Error) {
      a = toErrorMessage(a, verbose);
    }
    if (typeof a === "object") {
      try {
        a = JSON.stringify(a);
      } catch (e) {
      }
    }
    result += (i > 0 ? " " : "") + a;
  }
  return result;
}
function getLogLevel(environmentService) {
  if (environmentService.verbose) {
    return LogLevel.Trace;
  }
  if (typeof environmentService.logLevel === "string") {
    const logLevel = parseLogLevel(environmentService.logLevel.toLowerCase());
    if (logLevel !== void 0) {
      return logLevel;
    }
  }
  return DEFAULT_LOG_LEVEL;
}
function LogLevelToString(logLevel) {
  switch (logLevel) {
    case LogLevel.Trace:
      return "trace";
    case LogLevel.Debug:
      return "debug";
    case LogLevel.Info:
      return "info";
    case LogLevel.Warning:
      return "warn";
    case LogLevel.Error:
      return "error";
    case LogLevel.Off:
      return "off";
  }
}
function parseLogLevel(logLevel) {
  switch (logLevel) {
    case "trace":
      return LogLevel.Trace;
    case "debug":
      return LogLevel.Debug;
    case "info":
      return LogLevel.Info;
    case "warn":
      return LogLevel.Warning;
    case "error":
      return LogLevel.Error;
    case "critical":
      return LogLevel.Error;
    case "off":
      return LogLevel.Off;
  }
  return void 0;
}
var ILogService, ILoggerService, LogLevel, DEFAULT_LOG_LEVEL, AbstractLogger, AbstractMessageLogger, ConsoleMainLogger, MultiplexLogger, AbstractLoggerService, NullLogger, NullLogService, CONTEXT_LOG_LEVEL;
var init_log = __esm({
  "out-build/vs/platform/log/common/log.js"() {
    "use strict";
    init_nls();
    init_errorMessage();
    init_event();
    init_hash();
    init_lifecycle();
    init_map();
    init_platform();
    init_resources();
    init_types();
    init_uri();
    init_contextkey();
    init_instantiation();
    ILogService = createDecorator("logService");
    ILoggerService = createDecorator("loggerService");
    (function(LogLevel2) {
      LogLevel2[LogLevel2["Off"] = 0] = "Off";
      LogLevel2[LogLevel2["Trace"] = 1] = "Trace";
      LogLevel2[LogLevel2["Debug"] = 2] = "Debug";
      LogLevel2[LogLevel2["Info"] = 3] = "Info";
      LogLevel2[LogLevel2["Warning"] = 4] = "Warning";
      LogLevel2[LogLevel2["Error"] = 5] = "Error";
    })(LogLevel || (LogLevel = {}));
    DEFAULT_LOG_LEVEL = LogLevel.Info;
    AbstractLogger = class extends Disposable {
      constructor() {
        super(...arguments);
        this.level = DEFAULT_LOG_LEVEL;
        this._onDidChangeLogLevel = this._register(new Emitter());
        this.onDidChangeLogLevel = this._onDidChangeLogLevel.event;
      }
      setLevel(level) {
        if (this.level !== level) {
          this.level = level;
          this._onDidChangeLogLevel.fire(this.level);
        }
      }
      getLevel() {
        return this.level;
      }
      checkLogLevel(level) {
        return canLog(this.level, level);
      }
      canLog(level) {
        if (this._store.isDisposed) {
          return false;
        }
        return this.checkLogLevel(level);
      }
    };
    AbstractMessageLogger = class extends AbstractLogger {
      constructor(logAlways) {
        super();
        this.logAlways = logAlways;
      }
      checkLogLevel(level) {
        return this.logAlways || super.checkLogLevel(level);
      }
      trace(message, ...args2) {
        if (this.canLog(LogLevel.Trace)) {
          this.log(LogLevel.Trace, format2([message, ...args2], true));
        }
      }
      debug(message, ...args2) {
        if (this.canLog(LogLevel.Debug)) {
          this.log(LogLevel.Debug, format2([message, ...args2]));
        }
      }
      info(message, ...args2) {
        if (this.canLog(LogLevel.Info)) {
          this.log(LogLevel.Info, format2([message, ...args2]));
        }
      }
      warn(message, ...args2) {
        if (this.canLog(LogLevel.Warning)) {
          this.log(LogLevel.Warning, format2([message, ...args2]));
        }
      }
      error(message, ...args2) {
        if (this.canLog(LogLevel.Error)) {
          if (message instanceof Error) {
            const array = Array.prototype.slice.call(arguments);
            array[0] = message.stack;
            this.log(LogLevel.Error, format2(array));
          } else {
            this.log(LogLevel.Error, format2([message, ...args2]));
          }
        }
      }
      flush() {
      }
    };
    ConsoleMainLogger = class extends AbstractLogger {
      constructor(logLevel = DEFAULT_LOG_LEVEL) {
        super();
        this.setLevel(logLevel);
        this.useColors = !isWindows2;
      }
      trace(message, ...args2) {
        if (this.canLog(LogLevel.Trace)) {
          if (this.useColors) {
            console.log(`\x1B[90m[main ${now()}]\x1B[0m`, message, ...args2);
          } else {
            console.log(`[main ${now()}]`, message, ...args2);
          }
        }
      }
      debug(message, ...args2) {
        if (this.canLog(LogLevel.Debug)) {
          if (this.useColors) {
            console.log(`\x1B[90m[main ${now()}]\x1B[0m`, message, ...args2);
          } else {
            console.log(`[main ${now()}]`, message, ...args2);
          }
        }
      }
      info(message, ...args2) {
        if (this.canLog(LogLevel.Info)) {
          if (this.useColors) {
            console.log(`\x1B[90m[main ${now()}]\x1B[0m`, message, ...args2);
          } else {
            console.log(`[main ${now()}]`, message, ...args2);
          }
        }
      }
      warn(message, ...args2) {
        if (this.canLog(LogLevel.Warning)) {
          if (this.useColors) {
            console.warn(`\x1B[93m[main ${now()}]\x1B[0m`, message, ...args2);
          } else {
            console.warn(`[main ${now()}]`, message, ...args2);
          }
        }
      }
      error(message, ...args2) {
        if (this.canLog(LogLevel.Error)) {
          if (this.useColors) {
            console.error(`\x1B[91m[main ${now()}]\x1B[0m`, message, ...args2);
          } else {
            console.error(`[main ${now()}]`, message, ...args2);
          }
        }
      }
      flush() {
      }
    };
    MultiplexLogger = class extends AbstractLogger {
      constructor(loggers) {
        super();
        this.loggers = loggers;
        if (loggers.length) {
          this.setLevel(loggers[0].getLevel());
        }
      }
      setLevel(level) {
        for (const logger of this.loggers) {
          logger.setLevel(level);
        }
        super.setLevel(level);
      }
      trace(message, ...args2) {
        for (const logger of this.loggers) {
          logger.trace(message, ...args2);
        }
      }
      debug(message, ...args2) {
        for (const logger of this.loggers) {
          logger.debug(message, ...args2);
        }
      }
      info(message, ...args2) {
        for (const logger of this.loggers) {
          logger.info(message, ...args2);
        }
      }
      warn(message, ...args2) {
        for (const logger of this.loggers) {
          logger.warn(message, ...args2);
        }
      }
      error(message, ...args2) {
        for (const logger of this.loggers) {
          logger.error(message, ...args2);
        }
      }
      flush() {
        for (const logger of this.loggers) {
          logger.flush();
        }
      }
      dispose() {
        for (const logger of this.loggers) {
          logger.dispose();
        }
        super.dispose();
      }
    };
    AbstractLoggerService = class extends Disposable {
      constructor(logLevel, logsHome, loggerResources) {
        super();
        this.logLevel = logLevel;
        this.logsHome = logsHome;
        this._loggers = new ResourceMap();
        this._onDidChangeLoggers = this._register(new Emitter());
        this.onDidChangeLoggers = this._onDidChangeLoggers.event;
        this._onDidChangeLogLevel = this._register(new Emitter());
        this.onDidChangeLogLevel = this._onDidChangeLogLevel.event;
        this._onDidChangeVisibility = this._register(new Emitter());
        this.onDidChangeVisibility = this._onDidChangeVisibility.event;
        if (loggerResources) {
          for (const loggerResource of loggerResources) {
            this._loggers.set(loggerResource.resource, { logger: void 0, info: loggerResource });
          }
        }
      }
      getLoggerEntry(resourceOrId) {
        if (isString(resourceOrId)) {
          return [...this._loggers.values()].find((logger) => logger.info.id === resourceOrId);
        }
        return this._loggers.get(resourceOrId);
      }
      getLogger(resourceOrId) {
        return this.getLoggerEntry(resourceOrId)?.logger;
      }
      createLogger(idOrResource, options) {
        const resource = this.toResource(idOrResource);
        const id2 = isString(idOrResource) ? idOrResource : options?.id ?? hash(resource.toString()).toString(16);
        let logger = this._loggers.get(resource)?.logger;
        const logLevel = options?.logLevel === "always" ? LogLevel.Trace : options?.logLevel;
        if (!logger) {
          logger = this.doCreateLogger(resource, logLevel ?? this.getLogLevel(resource) ?? this.logLevel, { ...options, id: id2 });
        }
        const loggerEntry = {
          logger,
          info: {
            resource,
            id: id2,
            logLevel,
            name: options?.name,
            hidden: options?.hidden,
            group: options?.group,
            extensionId: options?.extensionId,
            when: options?.when
          }
        };
        this.registerLogger(loggerEntry.info);
        this._loggers.set(resource, loggerEntry);
        return logger;
      }
      toResource(idOrResource) {
        return isString(idOrResource) ? joinPath(this.logsHome, `${idOrResource}.log`) : idOrResource;
      }
      setLogLevel(arg1, arg2) {
        if (URI.isUri(arg1)) {
          const resource = arg1;
          const logLevel = arg2;
          const logger = this._loggers.get(resource);
          if (logger && logLevel !== logger.info.logLevel) {
            logger.info.logLevel = logLevel === this.logLevel ? void 0 : logLevel;
            logger.logger?.setLevel(logLevel);
            this._loggers.set(logger.info.resource, logger);
            this._onDidChangeLogLevel.fire([resource, logLevel]);
          }
        } else {
          this.logLevel = arg1;
          for (const [resource, logger] of this._loggers.entries()) {
            if (this._loggers.get(resource)?.info.logLevel === void 0) {
              logger.logger?.setLevel(this.logLevel);
            }
          }
          this._onDidChangeLogLevel.fire(this.logLevel);
        }
      }
      setVisibility(resourceOrId, visibility) {
        const logger = this.getLoggerEntry(resourceOrId);
        if (logger && visibility !== !logger.info.hidden) {
          logger.info.hidden = !visibility;
          this._loggers.set(logger.info.resource, logger);
          this._onDidChangeVisibility.fire([logger.info.resource, visibility]);
        }
      }
      getLogLevel(resource) {
        let logLevel;
        if (resource) {
          logLevel = this._loggers.get(resource)?.info.logLevel;
        }
        return logLevel ?? this.logLevel;
      }
      registerLogger(resource) {
        const existing = this._loggers.get(resource.resource);
        if (existing) {
          if (existing.info.hidden !== resource.hidden) {
            this.setVisibility(resource.resource, !resource.hidden);
          }
        } else {
          this._loggers.set(resource.resource, { info: resource, logger: void 0 });
          this._onDidChangeLoggers.fire({ added: [resource], removed: [] });
        }
      }
      deregisterLogger(idOrResource) {
        const resource = this.toResource(idOrResource);
        const existing = this._loggers.get(resource);
        if (existing) {
          if (existing.logger) {
            existing.logger.dispose();
          }
          this._loggers.delete(resource);
          this._onDidChangeLoggers.fire({ added: [], removed: [existing.info] });
        }
      }
      *getRegisteredLoggers() {
        for (const entry of this._loggers.values()) {
          yield entry.info;
        }
      }
      getRegisteredLogger(resource) {
        return this._loggers.get(resource)?.info;
      }
      dispose() {
        this._loggers.forEach((logger) => logger.logger?.dispose());
        this._loggers.clear();
        super.dispose();
      }
    };
    NullLogger = class {
      constructor() {
        this.onDidChangeLogLevel = new Emitter().event;
      }
      setLevel(level) {
      }
      getLevel() {
        return LogLevel.Info;
      }
      trace(message, ...args2) {
      }
      debug(message, ...args2) {
      }
      info(message, ...args2) {
      }
      warn(message, ...args2) {
      }
      error(message, ...args2) {
      }
      critical(message, ...args2) {
      }
      dispose() {
      }
      flush() {
      }
    };
    NullLogService = class extends NullLogger {
    };
    CONTEXT_LOG_LEVEL = new RawContextKey("logLevel", LogLevelToString(LogLevel.Info));
  }
});

// out-build/vs/base/common/ternarySearchTree.js
var StringIterator, ConfigKeysIterator, PathIterator, UriIteratorState, UriIterator, Undef, TernarySearchTreeNode, Dir, TernarySearchTree;
var init_ternarySearchTree = __esm({
  "out-build/vs/base/common/ternarySearchTree.js"() {
    "use strict";
    init_arrays();
    init_assert();
    init_strings();
    StringIterator = class {
      constructor() {
        this._value = "";
        this._pos = 0;
      }
      reset(key) {
        this._value = key;
        this._pos = 0;
        return this;
      }
      next() {
        this._pos += 1;
        return this;
      }
      hasNext() {
        return this._pos < this._value.length - 1;
      }
      cmp(a) {
        const aCode = a.charCodeAt(0);
        const thisCode = this._value.charCodeAt(this._pos);
        return aCode - thisCode;
      }
      value() {
        return this._value[this._pos];
      }
    };
    ConfigKeysIterator = class {
      constructor(_caseSensitive = true) {
        this._caseSensitive = _caseSensitive;
      }
      reset(key) {
        this._value = key;
        this._from = 0;
        this._to = 0;
        return this.next();
      }
      hasNext() {
        return this._to < this._value.length;
      }
      next() {
        this._from = this._to;
        let justSeps = true;
        for (; this._to < this._value.length; this._to++) {
          const ch = this._value.charCodeAt(this._to);
          if (ch === 46) {
            if (justSeps) {
              this._from++;
            } else {
              break;
            }
          } else {
            justSeps = false;
          }
        }
        return this;
      }
      cmp(a) {
        return this._caseSensitive ? compareSubstring(a, this._value, 0, a.length, this._from, this._to) : compareSubstringIgnoreCase(a, this._value, 0, a.length, this._from, this._to);
      }
      value() {
        return this._value.substring(this._from, this._to);
      }
    };
    PathIterator = class {
      constructor(_splitOnBackslash = true, _caseSensitive = true) {
        this._splitOnBackslash = _splitOnBackslash;
        this._caseSensitive = _caseSensitive;
      }
      reset(key) {
        this._from = 0;
        this._to = 0;
        this._value = key;
        this._valueLen = key.length;
        for (let pos = key.length - 1; pos >= 0; pos--, this._valueLen--) {
          const ch = this._value.charCodeAt(pos);
          if (!(ch === 47 || this._splitOnBackslash && ch === 92)) {
            break;
          }
        }
        return this.next();
      }
      hasNext() {
        return this._to < this._valueLen;
      }
      next() {
        this._from = this._to;
        let justSeps = true;
        for (; this._to < this._valueLen; this._to++) {
          const ch = this._value.charCodeAt(this._to);
          if (ch === 47 || this._splitOnBackslash && ch === 92) {
            if (justSeps) {
              this._from++;
            } else {
              break;
            }
          } else {
            justSeps = false;
          }
        }
        return this;
      }
      cmp(a) {
        return this._caseSensitive ? compareSubstring(a, this._value, 0, a.length, this._from, this._to) : compareSubstringIgnoreCase(a, this._value, 0, a.length, this._from, this._to);
      }
      value() {
        return this._value.substring(this._from, this._to);
      }
    };
    (function(UriIteratorState2) {
      UriIteratorState2[UriIteratorState2["Scheme"] = 1] = "Scheme";
      UriIteratorState2[UriIteratorState2["Authority"] = 2] = "Authority";
      UriIteratorState2[UriIteratorState2["Path"] = 3] = "Path";
      UriIteratorState2[UriIteratorState2["Query"] = 4] = "Query";
      UriIteratorState2[UriIteratorState2["Fragment"] = 5] = "Fragment";
    })(UriIteratorState || (UriIteratorState = {}));
    UriIterator = class {
      constructor(_ignorePathCasing, _ignoreQueryAndFragment) {
        this._ignorePathCasing = _ignorePathCasing;
        this._ignoreQueryAndFragment = _ignoreQueryAndFragment;
        this._states = [];
        this._stateIdx = 0;
      }
      reset(key) {
        this._value = key;
        this._states = [];
        if (this._value.scheme) {
          this._states.push(
            1
            /* UriIteratorState.Scheme */
          );
        }
        if (this._value.authority) {
          this._states.push(
            2
            /* UriIteratorState.Authority */
          );
        }
        if (this._value.path) {
          this._pathIterator = new PathIterator(false, !this._ignorePathCasing(key));
          this._pathIterator.reset(key.path);
          if (this._pathIterator.value()) {
            this._states.push(
              3
              /* UriIteratorState.Path */
            );
          }
        }
        if (!this._ignoreQueryAndFragment(key)) {
          if (this._value.query) {
            this._states.push(
              4
              /* UriIteratorState.Query */
            );
          }
          if (this._value.fragment) {
            this._states.push(
              5
              /* UriIteratorState.Fragment */
            );
          }
        }
        this._stateIdx = 0;
        return this;
      }
      next() {
        if (this._states[this._stateIdx] === 3 && this._pathIterator.hasNext()) {
          this._pathIterator.next();
        } else {
          this._stateIdx += 1;
        }
        return this;
      }
      hasNext() {
        return this._states[this._stateIdx] === 3 && this._pathIterator.hasNext() || this._stateIdx < this._states.length - 1;
      }
      cmp(a) {
        if (this._states[this._stateIdx] === 1) {
          return compareIgnoreCase(a, this._value.scheme);
        } else if (this._states[this._stateIdx] === 2) {
          return compareIgnoreCase(a, this._value.authority);
        } else if (this._states[this._stateIdx] === 3) {
          return this._pathIterator.cmp(a);
        } else if (this._states[this._stateIdx] === 4) {
          return compare(a, this._value.query);
        } else if (this._states[this._stateIdx] === 5) {
          return compare(a, this._value.fragment);
        }
        throw new Error();
      }
      value() {
        if (this._states[this._stateIdx] === 1) {
          return this._value.scheme;
        } else if (this._states[this._stateIdx] === 2) {
          return this._value.authority;
        } else if (this._states[this._stateIdx] === 3) {
          return this._pathIterator.value();
        } else if (this._states[this._stateIdx] === 4) {
          return this._value.query;
        } else if (this._states[this._stateIdx] === 5) {
          return this._value.fragment;
        }
        throw new Error();
      }
    };
    Undef = class _Undef {
      static {
        this.Val = Symbol("undefined_placeholder");
      }
      static wrap(value) {
        return value === void 0 ? _Undef.Val : value;
      }
      static unwrap(value) {
        return value === _Undef.Val ? void 0 : value;
      }
    };
    TernarySearchTreeNode = class {
      constructor() {
        this.height = 1;
        this.value = void 0;
        this.key = void 0;
        this.left = void 0;
        this.mid = void 0;
        this.right = void 0;
      }
      isEmpty() {
        return !this.left && !this.mid && !this.right && this.value === void 0;
      }
      rotateLeft() {
        const tmp = this.right;
        this.right = tmp.left;
        tmp.left = this;
        this.updateHeight();
        tmp.updateHeight();
        return tmp;
      }
      rotateRight() {
        const tmp = this.left;
        this.left = tmp.right;
        tmp.right = this;
        this.updateHeight();
        tmp.updateHeight();
        return tmp;
      }
      updateHeight() {
        this.height = 1 + Math.max(this.heightLeft, this.heightRight);
      }
      balanceFactor() {
        return this.heightRight - this.heightLeft;
      }
      get heightLeft() {
        return this.left?.height ?? 0;
      }
      get heightRight() {
        return this.right?.height ?? 0;
      }
    };
    (function(Dir2) {
      Dir2[Dir2["Left"] = -1] = "Left";
      Dir2[Dir2["Mid"] = 0] = "Mid";
      Dir2[Dir2["Right"] = 1] = "Right";
    })(Dir || (Dir = {}));
    TernarySearchTree = class _TernarySearchTree {
      static forUris(ignorePathCasing = () => false, ignoreQueryAndFragment = () => false) {
        return new _TernarySearchTree(new UriIterator(ignorePathCasing, ignoreQueryAndFragment));
      }
      static forPaths(ignorePathCasing = false) {
        return new _TernarySearchTree(new PathIterator(void 0, !ignorePathCasing));
      }
      static forStrings() {
        return new _TernarySearchTree(new StringIterator());
      }
      static forConfigKeys() {
        return new _TernarySearchTree(new ConfigKeysIterator());
      }
      constructor(segments) {
        this._iter = segments;
      }
      clear() {
        this._root = void 0;
      }
      fill(values, keys) {
        if (keys) {
          const arr = keys.slice(0);
          shuffle(arr);
          for (const k of arr) {
            this.set(k, values);
          }
        } else {
          const arr = values.slice(0);
          shuffle(arr);
          for (const entry of arr) {
            this.set(entry[0], entry[1]);
          }
        }
      }
      set(key, element) {
        const iter = this._iter.reset(key);
        let node;
        if (!this._root) {
          this._root = new TernarySearchTreeNode();
          this._root.segment = iter.value();
        }
        const stack = [];
        node = this._root;
        while (true) {
          const val = iter.cmp(node.segment);
          if (val > 0) {
            if (!node.left) {
              node.left = new TernarySearchTreeNode();
              node.left.segment = iter.value();
            }
            stack.push([-1, node]);
            node = node.left;
          } else if (val < 0) {
            if (!node.right) {
              node.right = new TernarySearchTreeNode();
              node.right.segment = iter.value();
            }
            stack.push([1, node]);
            node = node.right;
          } else if (iter.hasNext()) {
            iter.next();
            if (!node.mid) {
              node.mid = new TernarySearchTreeNode();
              node.mid.segment = iter.value();
            }
            stack.push([0, node]);
            node = node.mid;
          } else {
            break;
          }
        }
        const oldElement = Undef.unwrap(node.value);
        node.value = Undef.wrap(element);
        node.key = key;
        for (let i = stack.length - 1; i >= 0; i--) {
          const node2 = stack[i][1];
          node2.updateHeight();
          const bf = node2.balanceFactor();
          if (bf < -1 || bf > 1) {
            const d1 = stack[i][0];
            const d2 = stack[i + 1][0];
            if (d1 === 1 && d2 === 1) {
              stack[i][1] = node2.rotateLeft();
            } else if (d1 === -1 && d2 === -1) {
              stack[i][1] = node2.rotateRight();
            } else if (d1 === 1 && d2 === -1) {
              node2.right = stack[i + 1][1] = stack[i + 1][1].rotateRight();
              stack[i][1] = node2.rotateLeft();
            } else if (d1 === -1 && d2 === 1) {
              node2.left = stack[i + 1][1] = stack[i + 1][1].rotateLeft();
              stack[i][1] = node2.rotateRight();
            } else {
              throw new Error();
            }
            if (i > 0) {
              switch (stack[i - 1][0]) {
                case -1:
                  stack[i - 1][1].left = stack[i][1];
                  break;
                case 1:
                  stack[i - 1][1].right = stack[i][1];
                  break;
                case 0:
                  stack[i - 1][1].mid = stack[i][1];
                  break;
              }
            } else {
              this._root = stack[0][1];
            }
          }
        }
        return oldElement;
      }
      get(key) {
        return Undef.unwrap(this._getNode(key)?.value);
      }
      _getNode(key) {
        const iter = this._iter.reset(key);
        let node = this._root;
        while (node) {
          const val = iter.cmp(node.segment);
          if (val > 0) {
            node = node.left;
          } else if (val < 0) {
            node = node.right;
          } else if (iter.hasNext()) {
            iter.next();
            node = node.mid;
          } else {
            break;
          }
        }
        return node;
      }
      has(key) {
        const node = this._getNode(key);
        return !(node?.value === void 0 && node?.mid === void 0);
      }
      delete(key) {
        return this._delete(key, false);
      }
      deleteSuperstr(key) {
        return this._delete(key, true);
      }
      _delete(key, superStr) {
        const iter = this._iter.reset(key);
        const stack = [];
        let node = this._root;
        while (node) {
          const val = iter.cmp(node.segment);
          if (val > 0) {
            stack.push([-1, node]);
            node = node.left;
          } else if (val < 0) {
            stack.push([1, node]);
            node = node.right;
          } else if (iter.hasNext()) {
            iter.next();
            stack.push([0, node]);
            node = node.mid;
          } else {
            break;
          }
        }
        if (!node) {
          return;
        }
        if (superStr) {
          node.left = void 0;
          node.mid = void 0;
          node.right = void 0;
          node.height = 1;
        } else {
          node.key = void 0;
          node.value = void 0;
        }
        if (!node.mid && !node.value) {
          if (node.left && node.right) {
            const stack2 = [[1, node]];
            const min = this._min(node.right, stack2);
            if (min.key) {
              node.key = min.key;
              node.value = min.value;
              node.segment = min.segment;
              const newChild = min.right;
              if (stack2.length > 1) {
                const [dir, parent] = stack2[stack2.length - 1];
                switch (dir) {
                  case -1:
                    parent.left = newChild;
                    break;
                  case 0:
                    assert(false);
                  case 1:
                    assert(false);
                }
              } else {
                node.right = newChild;
              }
              const newChild2 = this._balanceByStack(stack2);
              if (stack.length > 0) {
                const [dir, parent] = stack[stack.length - 1];
                switch (dir) {
                  case -1:
                    parent.left = newChild2;
                    break;
                  case 0:
                    parent.mid = newChild2;
                    break;
                  case 1:
                    parent.right = newChild2;
                    break;
                }
              } else {
                this._root = newChild2;
              }
            }
          } else {
            const newChild = node.left ?? node.right;
            if (stack.length > 0) {
              const [dir, parent] = stack[stack.length - 1];
              switch (dir) {
                case -1:
                  parent.left = newChild;
                  break;
                case 0:
                  parent.mid = newChild;
                  break;
                case 1:
                  parent.right = newChild;
                  break;
              }
            } else {
              this._root = newChild;
            }
          }
        }
        this._root = this._balanceByStack(stack) ?? this._root;
      }
      _min(node, stack) {
        while (node.left) {
          stack.push([-1, node]);
          node = node.left;
        }
        return node;
      }
      _balanceByStack(stack) {
        for (let i = stack.length - 1; i >= 0; i--) {
          const node = stack[i][1];
          node.updateHeight();
          const bf = node.balanceFactor();
          if (bf > 1) {
            if (node.right.balanceFactor() >= 0) {
              stack[i][1] = node.rotateLeft();
            } else {
              node.right = node.right.rotateRight();
              stack[i][1] = node.rotateLeft();
            }
          } else if (bf < -1) {
            if (node.left.balanceFactor() <= 0) {
              stack[i][1] = node.rotateRight();
            } else {
              node.left = node.left.rotateLeft();
              stack[i][1] = node.rotateRight();
            }
          }
          if (i > 0) {
            switch (stack[i - 1][0]) {
              case -1:
                stack[i - 1][1].left = stack[i][1];
                break;
              case 1:
                stack[i - 1][1].right = stack[i][1];
                break;
              case 0:
                stack[i - 1][1].mid = stack[i][1];
                break;
            }
          } else {
            return stack[0][1];
          }
        }
        return void 0;
      }
      findSubstr(key) {
        const iter = this._iter.reset(key);
        let node = this._root;
        let candidate = void 0;
        while (node) {
          const val = iter.cmp(node.segment);
          if (val > 0) {
            node = node.left;
          } else if (val < 0) {
            node = node.right;
          } else if (iter.hasNext()) {
            iter.next();
            candidate = Undef.unwrap(node.value) || candidate;
            node = node.mid;
          } else {
            break;
          }
        }
        return node && Undef.unwrap(node.value) || candidate;
      }
      findSuperstr(key) {
        return this._findSuperstrOrElement(key, false);
      }
      _findSuperstrOrElement(key, allowValue) {
        const iter = this._iter.reset(key);
        let node = this._root;
        while (node) {
          const val = iter.cmp(node.segment);
          if (val > 0) {
            node = node.left;
          } else if (val < 0) {
            node = node.right;
          } else if (iter.hasNext()) {
            iter.next();
            node = node.mid;
          } else {
            if (!node.mid) {
              if (allowValue) {
                return Undef.unwrap(node.value);
              } else {
                return void 0;
              }
            } else {
              return this._entries(node.mid);
            }
          }
        }
        return void 0;
      }
      hasElementOrSubtree(key) {
        return this._findSuperstrOrElement(key, true) !== void 0;
      }
      forEach(callback) {
        for (const [key, value] of this) {
          callback(value, key);
        }
      }
      *[Symbol.iterator]() {
        yield* this._entries(this._root);
      }
      _entries(node) {
        const result = [];
        this._dfsEntries(node, result);
        return result[Symbol.iterator]();
      }
      _dfsEntries(node, bucket) {
        if (!node) {
          return;
        }
        if (node.left) {
          this._dfsEntries(node.left, bucket);
        }
        if (node.value !== void 0) {
          bucket.push([node.key, Undef.unwrap(node.value)]);
        }
        if (node.mid) {
          this._dfsEntries(node.mid, bucket);
        }
        if (node.right) {
          this._dfsEntries(node.right, bucket);
        }
      }
      // for debug/testing
      _isBalanced() {
        const nodeIsBalanced = (node) => {
          if (!node) {
            return true;
          }
          const bf = node.balanceFactor();
          if (bf < -1 || bf > 1) {
            return false;
          }
          return nodeIsBalanced(node.left) && nodeIsBalanced(node.right);
        };
        return nodeIsBalanced(this._root);
      }
    };
  }
});

// out-build/vs/platform/files/common/files.js
function isFileOpenForWriteOptions(options) {
  return options.create === true;
}
function hasReadWriteCapability(provider) {
  return !!(provider.capabilities & 2);
}
function hasFileFolderCopyCapability(provider) {
  return !!(provider.capabilities & 8);
}
function hasFileCloneCapability(provider) {
  return !!(provider.capabilities & 131072);
}
function hasOpenReadWriteCloseCapability(provider) {
  return !!(provider.capabilities & 4);
}
function hasFileReadStreamCapability(provider) {
  return !!(provider.capabilities & 16);
}
function hasFileAtomicReadCapability(provider) {
  if (!hasReadWriteCapability(provider)) {
    return false;
  }
  return !!(provider.capabilities & 16384);
}
function hasFileAtomicWriteCapability(provider) {
  if (!hasReadWriteCapability(provider)) {
    return false;
  }
  return !!(provider.capabilities & 32768);
}
function hasFileAtomicDeleteCapability(provider) {
  return !!(provider.capabilities & 65536);
}
function createFileSystemProviderError(error, code2) {
  return FileSystemProviderError.create(error, code2);
}
function ensureFileSystemProviderError(error) {
  if (!error) {
    return createFileSystemProviderError(localize(2020, null), FileSystemProviderErrorCode.Unknown);
  }
  return error;
}
function markAsFileSystemProviderError(error, code2) {
  error.name = code2 ? `${code2} (FileSystemError)` : `FileSystemError`;
  return error;
}
function toFileSystemProviderErrorCode(error) {
  if (!error) {
    return FileSystemProviderErrorCode.Unknown;
  }
  if (error instanceof FileSystemProviderError) {
    return error.code;
  }
  const match = /^(.+) \(FileSystemError\)$/.exec(error.name);
  if (!match) {
    return FileSystemProviderErrorCode.Unknown;
  }
  switch (match[1]) {
    case FileSystemProviderErrorCode.FileExists:
      return FileSystemProviderErrorCode.FileExists;
    case FileSystemProviderErrorCode.FileIsADirectory:
      return FileSystemProviderErrorCode.FileIsADirectory;
    case FileSystemProviderErrorCode.FileNotADirectory:
      return FileSystemProviderErrorCode.FileNotADirectory;
    case FileSystemProviderErrorCode.FileNotFound:
      return FileSystemProviderErrorCode.FileNotFound;
    case FileSystemProviderErrorCode.FileTooLarge:
      return FileSystemProviderErrorCode.FileTooLarge;
    case FileSystemProviderErrorCode.FileWriteLocked:
      return FileSystemProviderErrorCode.FileWriteLocked;
    case FileSystemProviderErrorCode.NoPermissions:
      return FileSystemProviderErrorCode.NoPermissions;
    case FileSystemProviderErrorCode.Unavailable:
      return FileSystemProviderErrorCode.Unavailable;
  }
  return FileSystemProviderErrorCode.Unknown;
}
function toFileOperationResult(error) {
  if (error instanceof FileOperationError) {
    return error.fileOperationResult;
  }
  switch (toFileSystemProviderErrorCode(error)) {
    case FileSystemProviderErrorCode.FileNotFound:
      return 1;
    case FileSystemProviderErrorCode.FileIsADirectory:
      return 0;
    case FileSystemProviderErrorCode.FileNotADirectory:
      return 9;
    case FileSystemProviderErrorCode.FileWriteLocked:
      return 5;
    case FileSystemProviderErrorCode.NoPermissions:
      return 6;
    case FileSystemProviderErrorCode.FileExists:
      return 4;
    case FileSystemProviderErrorCode.FileTooLarge:
      return 7;
    default:
      return 10;
  }
}
function isParent(path4, candidate, ignoreCase) {
  if (!path4 || !candidate || path4 === candidate) {
    return false;
  }
  if (candidate.length > path4.length) {
    return false;
  }
  if (candidate.charAt(candidate.length - 1) !== sep) {
    candidate += sep;
  }
  if (ignoreCase) {
    return startsWithIgnoreCase(path4, candidate);
  }
  return path4.indexOf(candidate) === 0;
}
function etag(stat) {
  if (typeof stat.size !== "number" || typeof stat.mtime !== "number") {
    return void 0;
  }
  return stat.mtime.toString(29) + stat.size.toString(31);
}
var IFileService, FileType, FilePermission, FileChangeFilter, FileSystemProviderCapabilities, FileSystemProviderErrorCode, FileSystemProviderError, FileOperation, FileOperationEvent, FileChangeType, FileChangesEvent, FileOperationError, TooLargeFileOperationError, NotModifiedSinceFileOperationError, FileOperationResult, HotExitConfiguration, FileKind, ETAG_DISABLED, ByteSize;
var init_files = __esm({
  "out-build/vs/platform/files/common/files.js"() {
    "use strict";
    init_ternarySearchTree();
    init_path();
    init_strings();
    init_types();
    init_uri();
    init_nls();
    init_instantiation();
    init_platform();
    init_network();
    init_lazy();
    IFileService = createDecorator("fileService");
    (function(FileType2) {
      FileType2[FileType2["Unknown"] = 0] = "Unknown";
      FileType2[FileType2["File"] = 1] = "File";
      FileType2[FileType2["Directory"] = 2] = "Directory";
      FileType2[FileType2["SymbolicLink"] = 64] = "SymbolicLink";
    })(FileType || (FileType = {}));
    (function(FilePermission2) {
      FilePermission2[FilePermission2["Readonly"] = 1] = "Readonly";
      FilePermission2[FilePermission2["Locked"] = 2] = "Locked";
    })(FilePermission || (FilePermission = {}));
    (function(FileChangeFilter2) {
      FileChangeFilter2[FileChangeFilter2["UPDATED"] = 2] = "UPDATED";
      FileChangeFilter2[FileChangeFilter2["ADDED"] = 4] = "ADDED";
      FileChangeFilter2[FileChangeFilter2["DELETED"] = 8] = "DELETED";
    })(FileChangeFilter || (FileChangeFilter = {}));
    (function(FileSystemProviderCapabilities2) {
      FileSystemProviderCapabilities2[FileSystemProviderCapabilities2["None"] = 0] = "None";
      FileSystemProviderCapabilities2[FileSystemProviderCapabilities2["FileReadWrite"] = 2] = "FileReadWrite";
      FileSystemProviderCapabilities2[FileSystemProviderCapabilities2["FileOpenReadWriteClose"] = 4] = "FileOpenReadWriteClose";
      FileSystemProviderCapabilities2[FileSystemProviderCapabilities2["FileReadStream"] = 16] = "FileReadStream";
      FileSystemProviderCapabilities2[FileSystemProviderCapabilities2["FileFolderCopy"] = 8] = "FileFolderCopy";
      FileSystemProviderCapabilities2[FileSystemProviderCapabilities2["PathCaseSensitive"] = 1024] = "PathCaseSensitive";
      FileSystemProviderCapabilities2[FileSystemProviderCapabilities2["Readonly"] = 2048] = "Readonly";
      FileSystemProviderCapabilities2[FileSystemProviderCapabilities2["Trash"] = 4096] = "Trash";
      FileSystemProviderCapabilities2[FileSystemProviderCapabilities2["FileWriteUnlock"] = 8192] = "FileWriteUnlock";
      FileSystemProviderCapabilities2[FileSystemProviderCapabilities2["FileAtomicRead"] = 16384] = "FileAtomicRead";
      FileSystemProviderCapabilities2[FileSystemProviderCapabilities2["FileAtomicWrite"] = 32768] = "FileAtomicWrite";
      FileSystemProviderCapabilities2[FileSystemProviderCapabilities2["FileAtomicDelete"] = 65536] = "FileAtomicDelete";
      FileSystemProviderCapabilities2[FileSystemProviderCapabilities2["FileClone"] = 131072] = "FileClone";
    })(FileSystemProviderCapabilities || (FileSystemProviderCapabilities = {}));
    (function(FileSystemProviderErrorCode2) {
      FileSystemProviderErrorCode2["FileExists"] = "EntryExists";
      FileSystemProviderErrorCode2["FileNotFound"] = "EntryNotFound";
      FileSystemProviderErrorCode2["FileNotADirectory"] = "EntryNotADirectory";
      FileSystemProviderErrorCode2["FileIsADirectory"] = "EntryIsADirectory";
      FileSystemProviderErrorCode2["FileExceedsStorageQuota"] = "EntryExceedsStorageQuota";
      FileSystemProviderErrorCode2["FileTooLarge"] = "EntryTooLarge";
      FileSystemProviderErrorCode2["FileWriteLocked"] = "EntryWriteLocked";
      FileSystemProviderErrorCode2["NoPermissions"] = "NoPermissions";
      FileSystemProviderErrorCode2["Unavailable"] = "Unavailable";
      FileSystemProviderErrorCode2["Unknown"] = "Unknown";
    })(FileSystemProviderErrorCode || (FileSystemProviderErrorCode = {}));
    FileSystemProviderError = class _FileSystemProviderError extends Error {
      static create(error, code2) {
        const providerError = new _FileSystemProviderError(error.toString(), code2);
        markAsFileSystemProviderError(providerError, code2);
        return providerError;
      }
      constructor(message, code2) {
        super(message);
        this.code = code2;
      }
    };
    (function(FileOperation2) {
      FileOperation2[FileOperation2["CREATE"] = 0] = "CREATE";
      FileOperation2[FileOperation2["DELETE"] = 1] = "DELETE";
      FileOperation2[FileOperation2["MOVE"] = 2] = "MOVE";
      FileOperation2[FileOperation2["COPY"] = 3] = "COPY";
      FileOperation2[FileOperation2["WRITE"] = 4] = "WRITE";
    })(FileOperation || (FileOperation = {}));
    FileOperationEvent = class {
      constructor(resource, operation, target) {
        this.resource = resource;
        this.operation = operation;
        this.target = target;
      }
      isOperation(operation) {
        return this.operation === operation;
      }
    };
    (function(FileChangeType2) {
      FileChangeType2[FileChangeType2["UPDATED"] = 0] = "UPDATED";
      FileChangeType2[FileChangeType2["ADDED"] = 1] = "ADDED";
      FileChangeType2[FileChangeType2["DELETED"] = 2] = "DELETED";
    })(FileChangeType || (FileChangeType = {}));
    FileChangesEvent = class _FileChangesEvent {
      static {
        this.MIXED_CORRELATION = null;
      }
      constructor(changes, ignorePathCasing) {
        this.ignorePathCasing = ignorePathCasing;
        this.correlationId = void 0;
        this.added = new Lazy(() => {
          const added = TernarySearchTree.forUris(() => this.ignorePathCasing);
          added.fill(this.rawAdded.map((resource) => [resource, true]));
          return added;
        });
        this.updated = new Lazy(() => {
          const updated = TernarySearchTree.forUris(() => this.ignorePathCasing);
          updated.fill(this.rawUpdated.map((resource) => [resource, true]));
          return updated;
        });
        this.deleted = new Lazy(() => {
          const deleted = TernarySearchTree.forUris(() => this.ignorePathCasing);
          deleted.fill(this.rawDeleted.map((resource) => [resource, true]));
          return deleted;
        });
        this.rawAdded = [];
        this.rawUpdated = [];
        this.rawDeleted = [];
        for (const change of changes) {
          switch (change.type) {
            case 1:
              this.rawAdded.push(change.resource);
              break;
            case 0:
              this.rawUpdated.push(change.resource);
              break;
            case 2:
              this.rawDeleted.push(change.resource);
              break;
          }
          if (this.correlationId !== _FileChangesEvent.MIXED_CORRELATION) {
            if (typeof change.cId === "number") {
              if (this.correlationId === void 0) {
                this.correlationId = change.cId;
              } else if (this.correlationId !== change.cId) {
                this.correlationId = _FileChangesEvent.MIXED_CORRELATION;
              }
            } else {
              if (this.correlationId !== void 0) {
                this.correlationId = _FileChangesEvent.MIXED_CORRELATION;
              }
            }
          }
        }
      }
      /**
       * Find out if the file change events match the provided resource.
       *
       * Note: when passing `FileChangeType.DELETED`, we consider a match
       * also when the parent of the resource got deleted.
       */
      contains(resource, ...types) {
        return this.doContains(resource, { includeChildren: false }, ...types);
      }
      /**
       * Find out if the file change events either match the provided
       * resource, or contain a child of this resource.
       */
      affects(resource, ...types) {
        return this.doContains(resource, { includeChildren: true }, ...types);
      }
      doContains(resource, options, ...types) {
        if (!resource) {
          return false;
        }
        const hasTypesFilter = types.length > 0;
        if (!hasTypesFilter || types.includes(
          1
          /* FileChangeType.ADDED */
        )) {
          if (this.added.value.get(resource)) {
            return true;
          }
          if (options.includeChildren && this.added.value.findSuperstr(resource)) {
            return true;
          }
        }
        if (!hasTypesFilter || types.includes(
          0
          /* FileChangeType.UPDATED */
        )) {
          if (this.updated.value.get(resource)) {
            return true;
          }
          if (options.includeChildren && this.updated.value.findSuperstr(resource)) {
            return true;
          }
        }
        if (!hasTypesFilter || types.includes(
          2
          /* FileChangeType.DELETED */
        )) {
          if (this.deleted.value.findSubstr(resource)) {
            return true;
          }
          if (options.includeChildren && this.deleted.value.findSuperstr(resource)) {
            return true;
          }
        }
        return false;
      }
      /**
       * Returns if this event contains added files.
       */
      gotAdded() {
        return this.rawAdded.length > 0;
      }
      /**
       * Returns if this event contains deleted files.
       */
      gotDeleted() {
        return this.rawDeleted.length > 0;
      }
      /**
       * Returns if this event contains updated files.
       */
      gotUpdated() {
        return this.rawUpdated.length > 0;
      }
      /**
       * Returns if this event contains changes that correlate to the
       * provided `correlationId`.
       *
       * File change event correlation is an advanced watch feature that
       * allows to  identify from which watch request the events originate
       * from. This correlation allows to route events specifically
       * only to the requestor and not emit them to all listeners.
       */
      correlates(correlationId) {
        return this.correlationId === correlationId;
      }
      /**
       * Figure out if the event contains changes that correlate to one
       * correlation identifier.
       *
       * File change event correlation is an advanced watch feature that
       * allows to  identify from which watch request the events originate
       * from. This correlation allows to route events specifically
       * only to the requestor and not emit them to all listeners.
       */
      hasCorrelation() {
        return typeof this.correlationId === "number";
      }
    };
    FileOperationError = class extends Error {
      constructor(message, fileOperationResult, options) {
        super(message);
        this.fileOperationResult = fileOperationResult;
        this.options = options;
      }
    };
    TooLargeFileOperationError = class extends FileOperationError {
      constructor(message, fileOperationResult, size, options) {
        super(message, fileOperationResult, options);
        this.fileOperationResult = fileOperationResult;
        this.size = size;
      }
    };
    NotModifiedSinceFileOperationError = class extends FileOperationError {
      constructor(message, stat, options) {
        super(message, 2, options);
        this.stat = stat;
      }
    };
    (function(FileOperationResult2) {
      FileOperationResult2[FileOperationResult2["FILE_IS_DIRECTORY"] = 0] = "FILE_IS_DIRECTORY";
      FileOperationResult2[FileOperationResult2["FILE_NOT_FOUND"] = 1] = "FILE_NOT_FOUND";
      FileOperationResult2[FileOperationResult2["FILE_NOT_MODIFIED_SINCE"] = 2] = "FILE_NOT_MODIFIED_SINCE";
      FileOperationResult2[FileOperationResult2["FILE_MODIFIED_SINCE"] = 3] = "FILE_MODIFIED_SINCE";
      FileOperationResult2[FileOperationResult2["FILE_MOVE_CONFLICT"] = 4] = "FILE_MOVE_CONFLICT";
      FileOperationResult2[FileOperationResult2["FILE_WRITE_LOCKED"] = 5] = "FILE_WRITE_LOCKED";
      FileOperationResult2[FileOperationResult2["FILE_PERMISSION_DENIED"] = 6] = "FILE_PERMISSION_DENIED";
      FileOperationResult2[FileOperationResult2["FILE_TOO_LARGE"] = 7] = "FILE_TOO_LARGE";
      FileOperationResult2[FileOperationResult2["FILE_INVALID_PATH"] = 8] = "FILE_INVALID_PATH";
      FileOperationResult2[FileOperationResult2["FILE_NOT_DIRECTORY"] = 9] = "FILE_NOT_DIRECTORY";
      FileOperationResult2[FileOperationResult2["FILE_OTHER_ERROR"] = 10] = "FILE_OTHER_ERROR";
    })(FileOperationResult || (FileOperationResult = {}));
    HotExitConfiguration = {
      OFF: "off",
      ON_EXIT: "onExit",
      ON_EXIT_AND_WINDOW_CLOSE: "onExitAndWindowClose"
    };
    (function(FileKind2) {
      FileKind2[FileKind2["FILE"] = 0] = "FILE";
      FileKind2[FileKind2["FOLDER"] = 1] = "FOLDER";
      FileKind2[FileKind2["ROOT_FOLDER"] = 2] = "ROOT_FOLDER";
    })(FileKind || (FileKind = {}));
    ETAG_DISABLED = "";
    ByteSize = class _ByteSize {
      static {
        this.KB = 1024;
      }
      static {
        this.MB = _ByteSize.KB * _ByteSize.KB;
      }
      static {
        this.GB = _ByteSize.MB * _ByteSize.KB;
      }
      static {
        this.TB = _ByteSize.GB * _ByteSize.KB;
      }
      static formatSize(size) {
        if (!isNumber(size)) {
          size = 0;
        }
        if (size < _ByteSize.KB) {
          return localize(2021, null, size.toFixed(0));
        }
        if (size < _ByteSize.MB) {
          return localize(2022, null, (size / _ByteSize.KB).toFixed(2));
        }
        if (size < _ByteSize.GB) {
          return localize(2023, null, (size / _ByteSize.MB).toFixed(2));
        }
        if (size < _ByteSize.TB) {
          return localize(2024, null, (size / _ByteSize.GB).toFixed(2));
        }
        return localize(2025, null, (size / _ByteSize.TB).toFixed(2));
      }
    };
  }
});

// out-build/vs/platform/state/node/state.js
var IStateReadService, IStateService;
var init_state = __esm({
  "out-build/vs/platform/state/node/state.js"() {
    "use strict";
    init_instantiation();
    IStateReadService = createDecorator("stateReadService");
    IStateService = createDecorator("stateService");
  }
});

// out-build/vs/base/common/color.js
function roundFloat(number, decimalPoints) {
  const decimal = Math.pow(10, decimalPoints);
  return Math.round(number * decimal) / decimal;
}
var RGBA, HSLA, HSVA, Color;
var init_color = __esm({
  "out-build/vs/base/common/color.js"() {
    "use strict";
    RGBA = class {
      constructor(r, g, b, a = 1) {
        this._rgbaBrand = void 0;
        this.r = Math.min(255, Math.max(0, r)) | 0;
        this.g = Math.min(255, Math.max(0, g)) | 0;
        this.b = Math.min(255, Math.max(0, b)) | 0;
        this.a = roundFloat(Math.max(Math.min(1, a), 0), 3);
      }
      static equals(a, b) {
        return a.r === b.r && a.g === b.g && a.b === b.b && a.a === b.a;
      }
    };
    HSLA = class _HSLA {
      constructor(h, s, l, a) {
        this._hslaBrand = void 0;
        this.h = Math.max(Math.min(360, h), 0) | 0;
        this.s = roundFloat(Math.max(Math.min(1, s), 0), 3);
        this.l = roundFloat(Math.max(Math.min(1, l), 0), 3);
        this.a = roundFloat(Math.max(Math.min(1, a), 0), 3);
      }
      static equals(a, b) {
        return a.h === b.h && a.s === b.s && a.l === b.l && a.a === b.a;
      }
      /**
       * Converts an RGB color value to HSL. Conversion formula
       * adapted from http://en.wikipedia.org/wiki/HSL_color_space.
       * Assumes r, g, and b are contained in the set [0, 255] and
       * returns h in the set [0, 360], s, and l in the set [0, 1].
       */
      static fromRGBA(rgba) {
        const r = rgba.r / 255;
        const g = rgba.g / 255;
        const b = rgba.b / 255;
        const a = rgba.a;
        const max = Math.max(r, g, b);
        const min = Math.min(r, g, b);
        let h = 0;
        let s = 0;
        const l = (min + max) / 2;
        const chroma = max - min;
        if (chroma > 0) {
          s = Math.min(l <= 0.5 ? chroma / (2 * l) : chroma / (2 - 2 * l), 1);
          switch (max) {
            case r:
              h = (g - b) / chroma + (g < b ? 6 : 0);
              break;
            case g:
              h = (b - r) / chroma + 2;
              break;
            case b:
              h = (r - g) / chroma + 4;
              break;
          }
          h *= 60;
          h = Math.round(h);
        }
        return new _HSLA(h, s, l, a);
      }
      static _hue2rgb(p, q, t) {
        if (t < 0) {
          t += 1;
        }
        if (t > 1) {
          t -= 1;
        }
        if (t < 1 / 6) {
          return p + (q - p) * 6 * t;
        }
        if (t < 1 / 2) {
          return q;
        }
        if (t < 2 / 3) {
          return p + (q - p) * (2 / 3 - t) * 6;
        }
        return p;
      }
      /**
       * Converts an HSL color value to RGB. Conversion formula
       * adapted from http://en.wikipedia.org/wiki/HSL_color_space.
       * Assumes h in the set [0, 360] s, and l are contained in the set [0, 1] and
       * returns r, g, and b in the set [0, 255].
       */
      static toRGBA(hsla) {
        const h = hsla.h / 360;
        const { s, l, a } = hsla;
        let r, g, b;
        if (s === 0) {
          r = g = b = l;
        } else {
          const q = l < 0.5 ? l * (1 + s) : l + s - l * s;
          const p = 2 * l - q;
          r = _HSLA._hue2rgb(p, q, h + 1 / 3);
          g = _HSLA._hue2rgb(p, q, h);
          b = _HSLA._hue2rgb(p, q, h - 1 / 3);
        }
        return new RGBA(Math.round(r * 255), Math.round(g * 255), Math.round(b * 255), a);
      }
    };
    HSVA = class _HSVA {
      constructor(h, s, v, a) {
        this._hsvaBrand = void 0;
        this.h = Math.max(Math.min(360, h), 0) | 0;
        this.s = roundFloat(Math.max(Math.min(1, s), 0), 3);
        this.v = roundFloat(Math.max(Math.min(1, v), 0), 3);
        this.a = roundFloat(Math.max(Math.min(1, a), 0), 3);
      }
      static equals(a, b) {
        return a.h === b.h && a.s === b.s && a.v === b.v && a.a === b.a;
      }
      // from http://www.rapidtables.com/convert/color/rgb-to-hsv.htm
      static fromRGBA(rgba) {
        const r = rgba.r / 255;
        const g = rgba.g / 255;
        const b = rgba.b / 255;
        const cmax = Math.max(r, g, b);
        const cmin = Math.min(r, g, b);
        const delta = cmax - cmin;
        const s = cmax === 0 ? 0 : delta / cmax;
        let m;
        if (delta === 0) {
          m = 0;
        } else if (cmax === r) {
          m = ((g - b) / delta % 6 + 6) % 6;
        } else if (cmax === g) {
          m = (b - r) / delta + 2;
        } else {
          m = (r - g) / delta + 4;
        }
        return new _HSVA(Math.round(m * 60), s, cmax, rgba.a);
      }
      // from http://www.rapidtables.com/convert/color/hsv-to-rgb.htm
      static toRGBA(hsva) {
        const { h, s, v, a } = hsva;
        const c = v * s;
        const x = c * (1 - Math.abs(h / 60 % 2 - 1));
        const m = v - c;
        let [r, g, b] = [0, 0, 0];
        if (h < 60) {
          r = c;
          g = x;
        } else if (h < 120) {
          r = x;
          g = c;
        } else if (h < 180) {
          g = c;
          b = x;
        } else if (h < 240) {
          g = x;
          b = c;
        } else if (h < 300) {
          r = x;
          b = c;
        } else if (h <= 360) {
          r = c;
          b = x;
        }
        r = Math.round((r + m) * 255);
        g = Math.round((g + m) * 255);
        b = Math.round((b + m) * 255);
        return new RGBA(r, g, b, a);
      }
    };
    Color = class _Color {
      static fromHex(hex) {
        return _Color.Format.CSS.parseHex(hex) || _Color.red;
      }
      static equals(a, b) {
        if (!a && !b) {
          return true;
        }
        if (!a || !b) {
          return false;
        }
        return a.equals(b);
      }
      get hsla() {
        if (this._hsla) {
          return this._hsla;
        } else {
          return HSLA.fromRGBA(this.rgba);
        }
      }
      get hsva() {
        if (this._hsva) {
          return this._hsva;
        }
        return HSVA.fromRGBA(this.rgba);
      }
      constructor(arg) {
        if (!arg) {
          throw new Error("Color needs a value");
        } else if (arg instanceof RGBA) {
          this.rgba = arg;
        } else if (arg instanceof HSLA) {
          this._hsla = arg;
          this.rgba = HSLA.toRGBA(arg);
        } else if (arg instanceof HSVA) {
          this._hsva = arg;
          this.rgba = HSVA.toRGBA(arg);
        } else {
          throw new Error("Invalid color ctor argument");
        }
      }
      equals(other) {
        return !!other && RGBA.equals(this.rgba, other.rgba) && HSLA.equals(this.hsla, other.hsla) && HSVA.equals(this.hsva, other.hsva);
      }
      /**
       * http://www.w3.org/TR/WCAG20/#relativeluminancedef
       * Returns the number in the set [0, 1]. O => Darkest Black. 1 => Lightest white.
       */
      getRelativeLuminance() {
        const R = _Color._relativeLuminanceForComponent(this.rgba.r);
        const G = _Color._relativeLuminanceForComponent(this.rgba.g);
        const B = _Color._relativeLuminanceForComponent(this.rgba.b);
        const luminance = 0.2126 * R + 0.7152 * G + 0.0722 * B;
        return roundFloat(luminance, 4);
      }
      /**
       * Reduces the "foreground" color on this "background" color unti it is
       * below the relative luminace ratio.
       * @returns the new foreground color
       * @see https://github.com/xtermjs/xterm.js/blob/44f9fa39ae03e2ca6d28354d88a399608686770e/src/common/Color.ts#L315
       */
      reduceRelativeLuminace(foreground, ratio) {
        let { r: fgR, g: fgG, b: fgB } = foreground.rgba;
        let cr = this.getContrastRatio(foreground);
        while (cr < ratio && (fgR > 0 || fgG > 0 || fgB > 0)) {
          fgR -= Math.max(0, Math.ceil(fgR * 0.1));
          fgG -= Math.max(0, Math.ceil(fgG * 0.1));
          fgB -= Math.max(0, Math.ceil(fgB * 0.1));
          cr = this.getContrastRatio(new _Color(new RGBA(fgR, fgG, fgB)));
        }
        return new _Color(new RGBA(fgR, fgG, fgB));
      }
      /**
       * Increases the "foreground" color on this "background" color unti it is
       * below the relative luminace ratio.
       * @returns the new foreground color
       * @see https://github.com/xtermjs/xterm.js/blob/44f9fa39ae03e2ca6d28354d88a399608686770e/src/common/Color.ts#L335
       */
      increaseRelativeLuminace(foreground, ratio) {
        let { r: fgR, g: fgG, b: fgB } = foreground.rgba;
        let cr = this.getContrastRatio(foreground);
        while (cr < ratio && (fgR < 255 || fgG < 255 || fgB < 255)) {
          fgR = Math.min(255, fgR + Math.ceil((255 - fgR) * 0.1));
          fgG = Math.min(255, fgG + Math.ceil((255 - fgG) * 0.1));
          fgB = Math.min(255, fgB + Math.ceil((255 - fgB) * 0.1));
          cr = this.getContrastRatio(new _Color(new RGBA(fgR, fgG, fgB)));
        }
        return new _Color(new RGBA(fgR, fgG, fgB));
      }
      static _relativeLuminanceForComponent(color2) {
        const c = color2 / 255;
        return c <= 0.03928 ? c / 12.92 : Math.pow((c + 0.055) / 1.055, 2.4);
      }
      /**
       * http://www.w3.org/TR/WCAG20/#contrast-ratiodef
       * Returns the contrast ration number in the set [1, 21].
       */
      getContrastRatio(another) {
        const lum1 = this.getRelativeLuminance();
        const lum2 = another.getRelativeLuminance();
        return lum1 > lum2 ? (lum1 + 0.05) / (lum2 + 0.05) : (lum2 + 0.05) / (lum1 + 0.05);
      }
      /**
       *	http://24ways.org/2010/calculating-color-contrast
       *  Return 'true' if darker color otherwise 'false'
       */
      isDarker() {
        const yiq = (this.rgba.r * 299 + this.rgba.g * 587 + this.rgba.b * 114) / 1e3;
        return yiq < 128;
      }
      /**
       *	http://24ways.org/2010/calculating-color-contrast
       *  Return 'true' if lighter color otherwise 'false'
       */
      isLighter() {
        const yiq = (this.rgba.r * 299 + this.rgba.g * 587 + this.rgba.b * 114) / 1e3;
        return yiq >= 128;
      }
      isLighterThan(another) {
        const lum1 = this.getRelativeLuminance();
        const lum2 = another.getRelativeLuminance();
        return lum1 > lum2;
      }
      isDarkerThan(another) {
        const lum1 = this.getRelativeLuminance();
        const lum2 = another.getRelativeLuminance();
        return lum1 < lum2;
      }
      /**
       * Based on xterm.js: https://github.com/xtermjs/xterm.js/blob/44f9fa39ae03e2ca6d28354d88a399608686770e/src/common/Color.ts#L288
       *
       * Given a foreground color and a background color, either increase or reduce the luminance of the
       * foreground color until the specified contrast ratio is met. If pure white or black is hit
       * without the contrast ratio being met, go the other direction using the background color as the
       * foreground color and take either the first or second result depending on which has the higher
       * contrast ratio.
       *
       * @param foreground The foreground color.
       * @param ratio The contrast ratio to achieve.
       * @returns The adjusted foreground color.
       */
      ensureConstrast(foreground, ratio) {
        const bgL = this.getRelativeLuminance();
        const fgL = foreground.getRelativeLuminance();
        const cr = this.getContrastRatio(foreground);
        if (cr < ratio) {
          if (fgL < bgL) {
            const resultA2 = this.reduceRelativeLuminace(foreground, ratio);
            const resultARatio2 = this.getContrastRatio(resultA2);
            if (resultARatio2 < ratio) {
              const resultB = this.increaseRelativeLuminace(foreground, ratio);
              const resultBRatio = this.getContrastRatio(resultB);
              return resultARatio2 > resultBRatio ? resultA2 : resultB;
            }
            return resultA2;
          }
          const resultA = this.increaseRelativeLuminace(foreground, ratio);
          const resultARatio = this.getContrastRatio(resultA);
          if (resultARatio < ratio) {
            const resultB = this.reduceRelativeLuminace(foreground, ratio);
            const resultBRatio = this.getContrastRatio(resultB);
            return resultARatio > resultBRatio ? resultA : resultB;
          }
          return resultA;
        }
        return foreground;
      }
      lighten(factor) {
        return new _Color(new HSLA(this.hsla.h, this.hsla.s, this.hsla.l + this.hsla.l * factor, this.hsla.a));
      }
      darken(factor) {
        return new _Color(new HSLA(this.hsla.h, this.hsla.s, this.hsla.l - this.hsla.l * factor, this.hsla.a));
      }
      transparent(factor) {
        const { r, g, b, a } = this.rgba;
        return new _Color(new RGBA(r, g, b, a * factor));
      }
      isTransparent() {
        return this.rgba.a === 0;
      }
      isOpaque() {
        return this.rgba.a === 1;
      }
      opposite() {
        return new _Color(new RGBA(255 - this.rgba.r, 255 - this.rgba.g, 255 - this.rgba.b, this.rgba.a));
      }
      blend(c) {
        const rgba = c.rgba;
        const thisA = this.rgba.a;
        const colorA = rgba.a;
        const a = thisA + colorA * (1 - thisA);
        if (a < 1e-6) {
          return _Color.transparent;
        }
        const r = this.rgba.r * thisA / a + rgba.r * colorA * (1 - thisA) / a;
        const g = this.rgba.g * thisA / a + rgba.g * colorA * (1 - thisA) / a;
        const b = this.rgba.b * thisA / a + rgba.b * colorA * (1 - thisA) / a;
        return new _Color(new RGBA(r, g, b, a));
      }
      /**
       * Mixes the current color with the provided color based on the given factor.
       * @param color The color to mix with
       * @param factor The factor of mixing (0 means this color, 1 means the input color, 0.5 means equal mix)
       * @returns A new color representing the mix
       */
      mix(color2, factor = 0.5) {
        const normalize4 = Math.min(Math.max(factor, 0), 1);
        const thisRGBA = this.rgba;
        const otherRGBA = color2.rgba;
        const r = thisRGBA.r + (otherRGBA.r - thisRGBA.r) * normalize4;
        const g = thisRGBA.g + (otherRGBA.g - thisRGBA.g) * normalize4;
        const b = thisRGBA.b + (otherRGBA.b - thisRGBA.b) * normalize4;
        const a = thisRGBA.a + (otherRGBA.a - thisRGBA.a) * normalize4;
        return new _Color(new RGBA(r, g, b, a));
      }
      makeOpaque(opaqueBackground) {
        if (this.isOpaque() || opaqueBackground.rgba.a !== 1) {
          return this;
        }
        const { r, g, b, a } = this.rgba;
        return new _Color(new RGBA(opaqueBackground.rgba.r - a * (opaqueBackground.rgba.r - r), opaqueBackground.rgba.g - a * (opaqueBackground.rgba.g - g), opaqueBackground.rgba.b - a * (opaqueBackground.rgba.b - b), 1));
      }
      flatten(...backgrounds) {
        const background = backgrounds.reduceRight((accumulator, color2) => {
          return _Color._flatten(color2, accumulator);
        });
        return _Color._flatten(this, background);
      }
      static _flatten(foreground, background) {
        const backgroundAlpha = 1 - foreground.rgba.a;
        return new _Color(new RGBA(backgroundAlpha * background.rgba.r + foreground.rgba.a * foreground.rgba.r, backgroundAlpha * background.rgba.g + foreground.rgba.a * foreground.rgba.g, backgroundAlpha * background.rgba.b + foreground.rgba.a * foreground.rgba.b));
      }
      toString() {
        if (!this._toString) {
          this._toString = _Color.Format.CSS.format(this);
        }
        return this._toString;
      }
      toNumber32Bit() {
        if (!this._toNumber32Bit) {
          this._toNumber32Bit = (this.rgba.r << 24 | this.rgba.g << 16 | this.rgba.b << 8 | this.rgba.a * 255 << 0) >>> 0;
        }
        return this._toNumber32Bit;
      }
      static getLighterColor(of, relative3, factor) {
        if (of.isLighterThan(relative3)) {
          return of;
        }
        factor = factor ? factor : 0.5;
        const lum1 = of.getRelativeLuminance();
        const lum2 = relative3.getRelativeLuminance();
        factor = factor * (lum2 - lum1) / lum2;
        return of.lighten(factor);
      }
      static getDarkerColor(of, relative3, factor) {
        if (of.isDarkerThan(relative3)) {
          return of;
        }
        factor = factor ? factor : 0.5;
        const lum1 = of.getRelativeLuminance();
        const lum2 = relative3.getRelativeLuminance();
        factor = factor * (lum1 - lum2) / lum1;
        return of.darken(factor);
      }
      static {
        this.white = new _Color(new RGBA(255, 255, 255, 1));
      }
      static {
        this.black = new _Color(new RGBA(0, 0, 0, 1));
      }
      static {
        this.red = new _Color(new RGBA(255, 0, 0, 1));
      }
      static {
        this.blue = new _Color(new RGBA(0, 0, 255, 1));
      }
      static {
        this.green = new _Color(new RGBA(0, 255, 0, 1));
      }
      static {
        this.cyan = new _Color(new RGBA(0, 255, 255, 1));
      }
      static {
        this.lightgrey = new _Color(new RGBA(211, 211, 211, 1));
      }
      static {
        this.transparent = new _Color(new RGBA(0, 0, 0, 0));
      }
    };
    (function(Color2) {
      let Format;
      (function(Format2) {
        let CSS;
        (function(CSS2) {
          function formatRGB(color2) {
            if (color2.rgba.a === 1) {
              return `rgb(${color2.rgba.r}, ${color2.rgba.g}, ${color2.rgba.b})`;
            }
            return Color2.Format.CSS.formatRGBA(color2);
          }
          CSS2.formatRGB = formatRGB;
          function formatRGBA(color2) {
            return `rgba(${color2.rgba.r}, ${color2.rgba.g}, ${color2.rgba.b}, ${+color2.rgba.a.toFixed(2)})`;
          }
          CSS2.formatRGBA = formatRGBA;
          function formatHSL(color2) {
            if (color2.hsla.a === 1) {
              return `hsl(${color2.hsla.h}, ${(color2.hsla.s * 100).toFixed(2)}%, ${(color2.hsla.l * 100).toFixed(2)}%)`;
            }
            return Color2.Format.CSS.formatHSLA(color2);
          }
          CSS2.formatHSL = formatHSL;
          function formatHSLA(color2) {
            return `hsla(${color2.hsla.h}, ${(color2.hsla.s * 100).toFixed(2)}%, ${(color2.hsla.l * 100).toFixed(2)}%, ${color2.hsla.a.toFixed(2)})`;
          }
          CSS2.formatHSLA = formatHSLA;
          function _toTwoDigitHex(n) {
            const r = n.toString(16);
            return r.length !== 2 ? "0" + r : r;
          }
          function formatHex(color2) {
            return `#${_toTwoDigitHex(color2.rgba.r)}${_toTwoDigitHex(color2.rgba.g)}${_toTwoDigitHex(color2.rgba.b)}`;
          }
          CSS2.formatHex = formatHex;
          function formatHexA(color2, compact = false) {
            if (compact && color2.rgba.a === 1) {
              return Color2.Format.CSS.formatHex(color2);
            }
            return `#${_toTwoDigitHex(color2.rgba.r)}${_toTwoDigitHex(color2.rgba.g)}${_toTwoDigitHex(color2.rgba.b)}${_toTwoDigitHex(Math.round(color2.rgba.a * 255))}`;
          }
          CSS2.formatHexA = formatHexA;
          function format5(color2) {
            if (color2.isOpaque()) {
              return Color2.Format.CSS.formatHex(color2);
            }
            return Color2.Format.CSS.formatRGBA(color2);
          }
          CSS2.format = format5;
          function parse8(css) {
            if (css === "transparent") {
              return Color2.transparent;
            }
            if (css.startsWith("#")) {
              return parseHex(css);
            }
            if (css.startsWith("rgba(")) {
              const color2 = css.match(/rgba\((?<r>(?:\+|-)?\d+), *(?<g>(?:\+|-)?\d+), *(?<b>(?:\+|-)?\d+), *(?<a>(?:\+|-)?\d+(\.\d+)?)\)/);
              if (!color2) {
                throw new Error("Invalid color format " + css);
              }
              const r = parseInt(color2.groups?.r ?? "0");
              const g = parseInt(color2.groups?.g ?? "0");
              const b = parseInt(color2.groups?.b ?? "0");
              const a = parseFloat(color2.groups?.a ?? "0");
              return new Color2(new RGBA(r, g, b, a));
            }
            if (css.startsWith("rgb(")) {
              const color2 = css.match(/rgb\((?<r>(?:\+|-)?\d+), *(?<g>(?:\+|-)?\d+), *(?<b>(?:\+|-)?\d+)\)/);
              if (!color2) {
                throw new Error("Invalid color format " + css);
              }
              const r = parseInt(color2.groups?.r ?? "0");
              const g = parseInt(color2.groups?.g ?? "0");
              const b = parseInt(color2.groups?.b ?? "0");
              return new Color2(new RGBA(r, g, b));
            }
            return parseNamedKeyword(css);
          }
          CSS2.parse = parse8;
          function parseNamedKeyword(css) {
            switch (css) {
              case "aliceblue":
                return new Color2(new RGBA(240, 248, 255, 1));
              case "antiquewhite":
                return new Color2(new RGBA(250, 235, 215, 1));
              case "aqua":
                return new Color2(new RGBA(0, 255, 255, 1));
              case "aquamarine":
                return new Color2(new RGBA(127, 255, 212, 1));
              case "azure":
                return new Color2(new RGBA(240, 255, 255, 1));
              case "beige":
                return new Color2(new RGBA(245, 245, 220, 1));
              case "bisque":
                return new Color2(new RGBA(255, 228, 196, 1));
              case "black":
                return new Color2(new RGBA(0, 0, 0, 1));
              case "blanchedalmond":
                return new Color2(new RGBA(255, 235, 205, 1));
              case "blue":
                return new Color2(new RGBA(0, 0, 255, 1));
              case "blueviolet":
                return new Color2(new RGBA(138, 43, 226, 1));
              case "brown":
                return new Color2(new RGBA(165, 42, 42, 1));
              case "burlywood":
                return new Color2(new RGBA(222, 184, 135, 1));
              case "cadetblue":
                return new Color2(new RGBA(95, 158, 160, 1));
              case "chartreuse":
                return new Color2(new RGBA(127, 255, 0, 1));
              case "chocolate":
                return new Color2(new RGBA(210, 105, 30, 1));
              case "coral":
                return new Color2(new RGBA(255, 127, 80, 1));
              case "cornflowerblue":
                return new Color2(new RGBA(100, 149, 237, 1));
              case "cornsilk":
                return new Color2(new RGBA(255, 248, 220, 1));
              case "crimson":
                return new Color2(new RGBA(220, 20, 60, 1));
              case "cyan":
                return new Color2(new RGBA(0, 255, 255, 1));
              case "darkblue":
                return new Color2(new RGBA(0, 0, 139, 1));
              case "darkcyan":
                return new Color2(new RGBA(0, 139, 139, 1));
              case "darkgoldenrod":
                return new Color2(new RGBA(184, 134, 11, 1));
              case "darkgray":
                return new Color2(new RGBA(169, 169, 169, 1));
              case "darkgreen":
                return new Color2(new RGBA(0, 100, 0, 1));
              case "darkgrey":
                return new Color2(new RGBA(169, 169, 169, 1));
              case "darkkhaki":
                return new Color2(new RGBA(189, 183, 107, 1));
              case "darkmagenta":
                return new Color2(new RGBA(139, 0, 139, 1));
              case "darkolivegreen":
                return new Color2(new RGBA(85, 107, 47, 1));
              case "darkorange":
                return new Color2(new RGBA(255, 140, 0, 1));
              case "darkorchid":
                return new Color2(new RGBA(153, 50, 204, 1));
              case "darkred":
                return new Color2(new RGBA(139, 0, 0, 1));
              case "darksalmon":
                return new Color2(new RGBA(233, 150, 122, 1));
              case "darkseagreen":
                return new Color2(new RGBA(143, 188, 143, 1));
              case "darkslateblue":
                return new Color2(new RGBA(72, 61, 139, 1));
              case "darkslategray":
                return new Color2(new RGBA(47, 79, 79, 1));
              case "darkslategrey":
                return new Color2(new RGBA(47, 79, 79, 1));
              case "darkturquoise":
                return new Color2(new RGBA(0, 206, 209, 1));
              case "darkviolet":
                return new Color2(new RGBA(148, 0, 211, 1));
              case "deeppink":
                return new Color2(new RGBA(255, 20, 147, 1));
              case "deepskyblue":
                return new Color2(new RGBA(0, 191, 255, 1));
              case "dimgray":
                return new Color2(new RGBA(105, 105, 105, 1));
              case "dimgrey":
                return new Color2(new RGBA(105, 105, 105, 1));
              case "dodgerblue":
                return new Color2(new RGBA(30, 144, 255, 1));
              case "firebrick":
                return new Color2(new RGBA(178, 34, 34, 1));
              case "floralwhite":
                return new Color2(new RGBA(255, 250, 240, 1));
              case "forestgreen":
                return new Color2(new RGBA(34, 139, 34, 1));
              case "fuchsia":
                return new Color2(new RGBA(255, 0, 255, 1));
              case "gainsboro":
                return new Color2(new RGBA(220, 220, 220, 1));
              case "ghostwhite":
                return new Color2(new RGBA(248, 248, 255, 1));
              case "gold":
                return new Color2(new RGBA(255, 215, 0, 1));
              case "goldenrod":
                return new Color2(new RGBA(218, 165, 32, 1));
              case "gray":
                return new Color2(new RGBA(128, 128, 128, 1));
              case "green":
                return new Color2(new RGBA(0, 128, 0, 1));
              case "greenyellow":
                return new Color2(new RGBA(173, 255, 47, 1));
              case "grey":
                return new Color2(new RGBA(128, 128, 128, 1));
              case "honeydew":
                return new Color2(new RGBA(240, 255, 240, 1));
              case "hotpink":
                return new Color2(new RGBA(255, 105, 180, 1));
              case "indianred":
                return new Color2(new RGBA(205, 92, 92, 1));
              case "indigo":
                return new Color2(new RGBA(75, 0, 130, 1));
              case "ivory":
                return new Color2(new RGBA(255, 255, 240, 1));
              case "khaki":
                return new Color2(new RGBA(240, 230, 140, 1));
              case "lavender":
                return new Color2(new RGBA(230, 230, 250, 1));
              case "lavenderblush":
                return new Color2(new RGBA(255, 240, 245, 1));
              case "lawngreen":
                return new Color2(new RGBA(124, 252, 0, 1));
              case "lemonchiffon":
                return new Color2(new RGBA(255, 250, 205, 1));
              case "lightblue":
                return new Color2(new RGBA(173, 216, 230, 1));
              case "lightcoral":
                return new Color2(new RGBA(240, 128, 128, 1));
              case "lightcyan":
                return new Color2(new RGBA(224, 255, 255, 1));
              case "lightgoldenrodyellow":
                return new Color2(new RGBA(250, 250, 210, 1));
              case "lightgray":
                return new Color2(new RGBA(211, 211, 211, 1));
              case "lightgreen":
                return new Color2(new RGBA(144, 238, 144, 1));
              case "lightgrey":
                return new Color2(new RGBA(211, 211, 211, 1));
              case "lightpink":
                return new Color2(new RGBA(255, 182, 193, 1));
              case "lightsalmon":
                return new Color2(new RGBA(255, 160, 122, 1));
              case "lightseagreen":
                return new Color2(new RGBA(32, 178, 170, 1));
              case "lightskyblue":
                return new Color2(new RGBA(135, 206, 250, 1));
              case "lightslategray":
                return new Color2(new RGBA(119, 136, 153, 1));
              case "lightslategrey":
                return new Color2(new RGBA(119, 136, 153, 1));
              case "lightsteelblue":
                return new Color2(new RGBA(176, 196, 222, 1));
              case "lightyellow":
                return new Color2(new RGBA(255, 255, 224, 1));
              case "lime":
                return new Color2(new RGBA(0, 255, 0, 1));
              case "limegreen":
                return new Color2(new RGBA(50, 205, 50, 1));
              case "linen":
                return new Color2(new RGBA(250, 240, 230, 1));
              case "magenta":
                return new Color2(new RGBA(255, 0, 255, 1));
              case "maroon":
                return new Color2(new RGBA(128, 0, 0, 1));
              case "mediumaquamarine":
                return new Color2(new RGBA(102, 205, 170, 1));
              case "mediumblue":
                return new Color2(new RGBA(0, 0, 205, 1));
              case "mediumorchid":
                return new Color2(new RGBA(186, 85, 211, 1));
              case "mediumpurple":
                return new Color2(new RGBA(147, 112, 219, 1));
              case "mediumseagreen":
                return new Color2(new RGBA(60, 179, 113, 1));
              case "mediumslateblue":
                return new Color2(new RGBA(123, 104, 238, 1));
              case "mediumspringgreen":
                return new Color2(new RGBA(0, 250, 154, 1));
              case "mediumturquoise":
                return new Color2(new RGBA(72, 209, 204, 1));
              case "mediumvioletred":
                return new Color2(new RGBA(199, 21, 133, 1));
              case "midnightblue":
                return new Color2(new RGBA(25, 25, 112, 1));
              case "mintcream":
                return new Color2(new RGBA(245, 255, 250, 1));
              case "mistyrose":
                return new Color2(new RGBA(255, 228, 225, 1));
              case "moccasin":
                return new Color2(new RGBA(255, 228, 181, 1));
              case "navajowhite":
                return new Color2(new RGBA(255, 222, 173, 1));
              case "navy":
                return new Color2(new RGBA(0, 0, 128, 1));
              case "oldlace":
                return new Color2(new RGBA(253, 245, 230, 1));
              case "olive":
                return new Color2(new RGBA(128, 128, 0, 1));
              case "olivedrab":
                return new Color2(new RGBA(107, 142, 35, 1));
              case "orange":
                return new Color2(new RGBA(255, 165, 0, 1));
              case "orangered":
                return new Color2(new RGBA(255, 69, 0, 1));
              case "orchid":
                return new Color2(new RGBA(218, 112, 214, 1));
              case "palegoldenrod":
                return new Color2(new RGBA(238, 232, 170, 1));
              case "palegreen":
                return new Color2(new RGBA(152, 251, 152, 1));
              case "paleturquoise":
                return new Color2(new RGBA(175, 238, 238, 1));
              case "palevioletred":
                return new Color2(new RGBA(219, 112, 147, 1));
              case "papayawhip":
                return new Color2(new RGBA(255, 239, 213, 1));
              case "peachpuff":
                return new Color2(new RGBA(255, 218, 185, 1));
              case "peru":
                return new Color2(new RGBA(205, 133, 63, 1));
              case "pink":
                return new Color2(new RGBA(255, 192, 203, 1));
              case "plum":
                return new Color2(new RGBA(221, 160, 221, 1));
              case "powderblue":
                return new Color2(new RGBA(176, 224, 230, 1));
              case "purple":
                return new Color2(new RGBA(128, 0, 128, 1));
              case "rebeccapurple":
                return new Color2(new RGBA(102, 51, 153, 1));
              case "red":
                return new Color2(new RGBA(255, 0, 0, 1));
              case "rosybrown":
                return new Color2(new RGBA(188, 143, 143, 1));
              case "royalblue":
                return new Color2(new RGBA(65, 105, 225, 1));
              case "saddlebrown":
                return new Color2(new RGBA(139, 69, 19, 1));
              case "salmon":
                return new Color2(new RGBA(250, 128, 114, 1));
              case "sandybrown":
                return new Color2(new RGBA(244, 164, 96, 1));
              case "seagreen":
                return new Color2(new RGBA(46, 139, 87, 1));
              case "seashell":
                return new Color2(new RGBA(255, 245, 238, 1));
              case "sienna":
                return new Color2(new RGBA(160, 82, 45, 1));
              case "silver":
                return new Color2(new RGBA(192, 192, 192, 1));
              case "skyblue":
                return new Color2(new RGBA(135, 206, 235, 1));
              case "slateblue":
                return new Color2(new RGBA(106, 90, 205, 1));
              case "slategray":
                return new Color2(new RGBA(112, 128, 144, 1));
              case "slategrey":
                return new Color2(new RGBA(112, 128, 144, 1));
              case "snow":
                return new Color2(new RGBA(255, 250, 250, 1));
              case "springgreen":
                return new Color2(new RGBA(0, 255, 127, 1));
              case "steelblue":
                return new Color2(new RGBA(70, 130, 180, 1));
              case "tan":
                return new Color2(new RGBA(210, 180, 140, 1));
              case "teal":
                return new Color2(new RGBA(0, 128, 128, 1));
              case "thistle":
                return new Color2(new RGBA(216, 191, 216, 1));
              case "tomato":
                return new Color2(new RGBA(255, 99, 71, 1));
              case "turquoise":
                return new Color2(new RGBA(64, 224, 208, 1));
              case "violet":
                return new Color2(new RGBA(238, 130, 238, 1));
              case "wheat":
                return new Color2(new RGBA(245, 222, 179, 1));
              case "white":
                return new Color2(new RGBA(255, 255, 255, 1));
              case "whitesmoke":
                return new Color2(new RGBA(245, 245, 245, 1));
              case "yellow":
                return new Color2(new RGBA(255, 255, 0, 1));
              case "yellowgreen":
                return new Color2(new RGBA(154, 205, 50, 1));
              default:
                return null;
            }
          }
          function parseHex(hex) {
            const length = hex.length;
            if (length === 0) {
              return null;
            }
            if (hex.charCodeAt(0) !== 35) {
              return null;
            }
            if (length === 7) {
              const r = 16 * _parseHexDigit(hex.charCodeAt(1)) + _parseHexDigit(hex.charCodeAt(2));
              const g = 16 * _parseHexDigit(hex.charCodeAt(3)) + _parseHexDigit(hex.charCodeAt(4));
              const b = 16 * _parseHexDigit(hex.charCodeAt(5)) + _parseHexDigit(hex.charCodeAt(6));
              return new Color2(new RGBA(r, g, b, 1));
            }
            if (length === 9) {
              const r = 16 * _parseHexDigit(hex.charCodeAt(1)) + _parseHexDigit(hex.charCodeAt(2));
              const g = 16 * _parseHexDigit(hex.charCodeAt(3)) + _parseHexDigit(hex.charCodeAt(4));
              const b = 16 * _parseHexDigit(hex.charCodeAt(5)) + _parseHexDigit(hex.charCodeAt(6));
              const a = 16 * _parseHexDigit(hex.charCodeAt(7)) + _parseHexDigit(hex.charCodeAt(8));
              return new Color2(new RGBA(r, g, b, a / 255));
            }
            if (length === 4) {
              const r = _parseHexDigit(hex.charCodeAt(1));
              const g = _parseHexDigit(hex.charCodeAt(2));
              const b = _parseHexDigit(hex.charCodeAt(3));
              return new Color2(new RGBA(16 * r + r, 16 * g + g, 16 * b + b));
            }
            if (length === 5) {
              const r = _parseHexDigit(hex.charCodeAt(1));
              const g = _parseHexDigit(hex.charCodeAt(2));
              const b = _parseHexDigit(hex.charCodeAt(3));
              const a = _parseHexDigit(hex.charCodeAt(4));
              return new Color2(new RGBA(16 * r + r, 16 * g + g, 16 * b + b, (16 * a + a) / 255));
            }
            return null;
          }
          CSS2.parseHex = parseHex;
          function _parseHexDigit(charCode) {
            switch (charCode) {
              case 48:
                return 0;
              case 49:
                return 1;
              case 50:
                return 2;
              case 51:
                return 3;
              case 52:
                return 4;
              case 53:
                return 5;
              case 54:
                return 6;
              case 55:
                return 7;
              case 56:
                return 8;
              case 57:
                return 9;
              case 97:
                return 10;
              case 65:
                return 10;
              case 98:
                return 11;
              case 66:
                return 11;
              case 99:
                return 12;
              case 67:
                return 12;
              case 100:
                return 13;
              case 68:
                return 13;
              case 101:
                return 14;
              case 69:
                return 14;
              case 102:
                return 15;
              case 70:
                return 15;
            }
            return 0;
          }
        })(CSS = Format2.CSS || (Format2.CSS = {}));
      })(Format = Color2.Format || (Color2.Format = {}));
    })(Color || (Color = {}));
  }
});

// out-build/vs/platform/product/common/productService.js
var IProductService;
var init_productService = __esm({
  "out-build/vs/platform/product/common/productService.js"() {
    "use strict";
    init_instantiation();
    IProductService = createDecorator("productService");
  }
});

// out-build/vs/platform/theme/common/theme.js
var ColorScheme, ThemeTypeSelector;
var init_theme = __esm({
  "out-build/vs/platform/theme/common/theme.js"() {
    "use strict";
    (function(ColorScheme2) {
      ColorScheme2["DARK"] = "dark";
      ColorScheme2["LIGHT"] = "light";
      ColorScheme2["HIGH_CONTRAST_DARK"] = "hcDark";
      ColorScheme2["HIGH_CONTRAST_LIGHT"] = "hcLight";
    })(ColorScheme || (ColorScheme = {}));
    (function(ThemeTypeSelector2) {
      ThemeTypeSelector2["VS"] = "vs";
      ThemeTypeSelector2["VS_DARK"] = "vs-dark";
      ThemeTypeSelector2["HC_BLACK"] = "hc-black";
      ThemeTypeSelector2["HC_LIGHT"] = "hc-light";
    })(ThemeTypeSelector || (ThemeTypeSelector = {}));
  }
});

// out-build/vs/platform/theme/electron-main/themeMainService.js
import electron2 from "electron";
var ThemeMainService_1, DEFAULT_BG_LIGHT, DEFAULT_BG_DARK, DEFAULT_BG_HC_BLACK, DEFAULT_BG_HC_LIGHT, THEME_STORAGE_KEY, THEME_BG_STORAGE_KEY, THEME_WINDOW_SPLASH_KEY, THEME_WINDOW_SPLASH_OVERRIDE_KEY, AUXILIARYBAR_DEFAULT_VISIBILITY, ThemeSettings, IThemeMainService, ThemeMainService;
var init_themeMainService = __esm({
  "out-build/vs/platform/theme/electron-main/themeMainService.js"() {
    "use strict";
    init_event();
    init_lifecycle();
    init_platform();
    init_configuration();
    init_instantiation();
    init_state();
    init_theme();
    init_arrays();
    init_windows();
    init_log();
    DEFAULT_BG_LIGHT = "#FFFFFF";
    DEFAULT_BG_DARK = "#1F1F1F";
    DEFAULT_BG_HC_BLACK = "#000000";
    DEFAULT_BG_HC_LIGHT = "#FFFFFF";
    THEME_STORAGE_KEY = "theme";
    THEME_BG_STORAGE_KEY = "themeBackground";
    THEME_WINDOW_SPLASH_KEY = "windowSplash";
    THEME_WINDOW_SPLASH_OVERRIDE_KEY = "windowSplashWorkspaceOverride";
    AUXILIARYBAR_DEFAULT_VISIBILITY = "workbench.secondarySideBar.defaultVisibility";
    (function(ThemeSettings2) {
      ThemeSettings2.DETECT_COLOR_SCHEME = "window.autoDetectColorScheme";
      ThemeSettings2.DETECT_HC = "window.autoDetectHighContrast";
      ThemeSettings2.SYSTEM_COLOR_THEME = "window.systemColorTheme";
    })(ThemeSettings || (ThemeSettings = {}));
    IThemeMainService = createDecorator("themeMainService");
    ThemeMainService = class ThemeMainService2 extends Disposable {
      static {
        ThemeMainService_1 = this;
      }
      static {
        this.DEFAULT_BAR_WIDTH = 300;
      }
      static {
        this.WORKSPACE_OVERRIDE_LIMIT = 50;
      }
      constructor(stateService, configurationService, logService) {
        super();
        this.stateService = stateService;
        this.configurationService = configurationService;
        this.logService = logService;
        this._onDidChangeColorScheme = this._register(new Emitter());
        this.onDidChangeColorScheme = this._onDidChangeColorScheme.event;
        if (!isLinux) {
          this._register(this.configurationService.onDidChangeConfiguration((e) => {
            if (e.affectsConfiguration(ThemeSettings.SYSTEM_COLOR_THEME) || e.affectsConfiguration(ThemeSettings.DETECT_COLOR_SCHEME)) {
              this.updateSystemColorTheme();
            }
          }));
        }
        this.updateSystemColorTheme();
        this._register(Event.fromNodeEventEmitter(electron2.nativeTheme, "updated")(() => this._onDidChangeColorScheme.fire(this.getColorScheme())));
      }
      updateSystemColorTheme() {
        if (isLinux || this.configurationService.getValue(ThemeSettings.DETECT_COLOR_SCHEME)) {
          electron2.nativeTheme.themeSource = "system";
        } else {
          switch (this.configurationService.getValue(ThemeSettings.SYSTEM_COLOR_THEME)) {
            case "dark":
              electron2.nativeTheme.themeSource = "dark";
              break;
            case "light":
              electron2.nativeTheme.themeSource = "light";
              break;
            case "auto":
              switch (this.getPreferredBaseTheme() ?? this.getStoredBaseTheme()) {
                case ThemeTypeSelector.VS:
                  electron2.nativeTheme.themeSource = "light";
                  break;
                case ThemeTypeSelector.VS_DARK:
                  electron2.nativeTheme.themeSource = "dark";
                  break;
                default:
                  electron2.nativeTheme.themeSource = "system";
              }
              break;
            default:
              electron2.nativeTheme.themeSource = "system";
              break;
          }
        }
      }
      getColorScheme() {
        if (isWindows2) {
          if (electron2.nativeTheme.shouldUseHighContrastColors) {
            return { dark: electron2.nativeTheme.shouldUseInvertedColorScheme, highContrast: true };
          }
        } else if (isMacintosh) {
          if (electron2.nativeTheme.shouldUseInvertedColorScheme || electron2.nativeTheme.shouldUseHighContrastColors) {
            return { dark: electron2.nativeTheme.shouldUseDarkColors, highContrast: true };
          }
        } else if (isLinux) {
          if (electron2.nativeTheme.shouldUseHighContrastColors) {
            return { dark: true, highContrast: true };
          }
        }
        return {
          dark: electron2.nativeTheme.shouldUseDarkColors,
          highContrast: false
        };
      }
      getPreferredBaseTheme() {
        const colorScheme = this.getColorScheme();
        if (this.configurationService.getValue(ThemeSettings.DETECT_HC) && colorScheme.highContrast) {
          return colorScheme.dark ? ThemeTypeSelector.HC_BLACK : ThemeTypeSelector.HC_LIGHT;
        }
        if (this.configurationService.getValue(ThemeSettings.DETECT_COLOR_SCHEME)) {
          return colorScheme.dark ? ThemeTypeSelector.VS_DARK : ThemeTypeSelector.VS;
        }
        return void 0;
      }
      getBackgroundColor() {
        const preferred = this.getPreferredBaseTheme();
        const stored = this.getStoredBaseTheme();
        if (preferred === void 0 || preferred === stored) {
          const storedBackground = this.stateService.getItem(THEME_BG_STORAGE_KEY, null);
          if (storedBackground) {
            return storedBackground;
          }
        }
        switch (preferred ?? stored) {
          case ThemeTypeSelector.VS:
            return DEFAULT_BG_LIGHT;
          case ThemeTypeSelector.HC_BLACK:
            return DEFAULT_BG_HC_BLACK;
          case ThemeTypeSelector.HC_LIGHT:
            return DEFAULT_BG_HC_LIGHT;
          default:
            return DEFAULT_BG_DARK;
        }
      }
      getStoredBaseTheme() {
        const baseTheme = this.stateService.getItem(THEME_STORAGE_KEY, ThemeTypeSelector.VS_DARK).split(" ")[0];
        switch (baseTheme) {
          case ThemeTypeSelector.VS:
            return ThemeTypeSelector.VS;
          case ThemeTypeSelector.HC_BLACK:
            return ThemeTypeSelector.HC_BLACK;
          case ThemeTypeSelector.HC_LIGHT:
            return ThemeTypeSelector.HC_LIGHT;
          default:
            return ThemeTypeSelector.VS_DARK;
        }
      }
      saveWindowSplash(windowId, workspace, splash) {
        const splashOverride = this.updateWindowSplashOverride(workspace, splash);
        this.stateService.setItems(coalesce([
          { key: THEME_STORAGE_KEY, data: splash.baseTheme },
          { key: THEME_BG_STORAGE_KEY, data: splash.colorInfo.background },
          { key: THEME_WINDOW_SPLASH_KEY, data: splash },
          splashOverride ? { key: THEME_WINDOW_SPLASH_OVERRIDE_KEY, data: splashOverride } : void 0
        ]));
        if (typeof windowId === "number") {
          this.updateBackgroundColor(windowId, splash);
        }
        this.updateSystemColorTheme();
      }
      updateWindowSplashOverride(workspace, splash) {
        let splashOverride = void 0;
        let changed = false;
        if (workspace) {
          splashOverride = { ...this.getWindowSplashOverride() };
          changed = this.doUpdateWindowSplashOverride(workspace, splash, splashOverride, "sideBar");
          changed = this.doUpdateWindowSplashOverride(workspace, splash, splashOverride, "auxiliaryBar") || changed;
        }
        return changed ? splashOverride : void 0;
      }
      doUpdateWindowSplashOverride(workspace, splash, splashOverride, part) {
        const currentWidth = part === "sideBar" ? splash.layoutInfo?.sideBarWidth : splash.layoutInfo?.auxiliarySideBarWidth;
        const overrideWidth = part === "sideBar" ? splashOverride.layoutInfo.sideBarWidth : splashOverride.layoutInfo.auxiliaryBarWidth;
        let changed = false;
        if (typeof currentWidth !== "number") {
          if (splashOverride.layoutInfo.workspaces[workspace.id]) {
            delete splashOverride.layoutInfo.workspaces[workspace.id];
            changed = true;
          }
          return changed;
        }
        let workspaceOverride = splashOverride.layoutInfo.workspaces[workspace.id];
        if (!workspaceOverride) {
          const workspaceEntries = Object.keys(splashOverride.layoutInfo.workspaces);
          if (workspaceEntries.length >= ThemeMainService_1.WORKSPACE_OVERRIDE_LIMIT) {
            delete splashOverride.layoutInfo.workspaces[workspaceEntries[0]];
            changed = true;
          }
          workspaceOverride = { sideBarVisible: false, auxiliaryBarVisible: false };
          splashOverride.layoutInfo.workspaces[workspace.id] = workspaceOverride;
          changed = true;
        }
        if (currentWidth > 0) {
          if (overrideWidth !== currentWidth) {
            splashOverride.layoutInfo[part === "sideBar" ? "sideBarWidth" : "auxiliaryBarWidth"] = currentWidth;
            changed = true;
          }
          switch (part) {
            case "sideBar":
              if (!workspaceOverride.sideBarVisible) {
                workspaceOverride.sideBarVisible = true;
                changed = true;
              }
              break;
            case "auxiliaryBar":
              if (!workspaceOverride.auxiliaryBarVisible) {
                workspaceOverride.auxiliaryBarVisible = true;
                changed = true;
              }
              break;
          }
        } else {
          switch (part) {
            case "sideBar":
              if (workspaceOverride.sideBarVisible) {
                workspaceOverride.sideBarVisible = false;
                changed = true;
              }
              break;
            case "auxiliaryBar":
              if (workspaceOverride.auxiliaryBarVisible) {
                workspaceOverride.auxiliaryBarVisible = false;
                changed = true;
              }
              break;
          }
        }
        return changed;
      }
      updateBackgroundColor(windowId, splash) {
        for (const window of getAllWindowsExcludingOffscreen()) {
          if (window.id === windowId) {
            window.setBackgroundColor(splash.colorInfo.background);
            break;
          }
        }
      }
      getWindowSplash(workspace) {
        try {
          return this.doGetWindowSplash(workspace);
        } catch (error) {
          this.logService.error("[theme main service] Failed to get window splash", error);
          return void 0;
        }
      }
      doGetWindowSplash(workspace) {
        const partSplash = this.stateService.getItem(THEME_WINDOW_SPLASH_KEY);
        if (!partSplash?.layoutInfo) {
          return partSplash;
        }
        const override = this.getWindowSplashOverride();
        let sideBarWidth;
        if (workspace) {
          if (override.layoutInfo.workspaces[workspace.id]?.sideBarVisible === false) {
            sideBarWidth = 0;
          } else {
            sideBarWidth = override.layoutInfo.sideBarWidth || partSplash.layoutInfo.sideBarWidth || ThemeMainService_1.DEFAULT_BAR_WIDTH;
          }
        } else {
          sideBarWidth = 0;
        }
        const auxiliarySideBarDefaultVisibility = this.configurationService.getValue(AUXILIARYBAR_DEFAULT_VISIBILITY);
        let auxiliarySideBarWidth;
        if (workspace) {
          const auxiliaryBarVisible = override.layoutInfo.workspaces[workspace.id]?.auxiliaryBarVisible;
          if (auxiliaryBarVisible === true) {
            auxiliarySideBarWidth = override.layoutInfo.auxiliaryBarWidth || partSplash.layoutInfo.auxiliarySideBarWidth || ThemeMainService_1.DEFAULT_BAR_WIDTH;
          } else if (auxiliaryBarVisible === false) {
            auxiliarySideBarWidth = 0;
          } else {
            if (auxiliarySideBarDefaultVisibility === "visible" || auxiliarySideBarDefaultVisibility === "visibleInWorkspace") {
              auxiliarySideBarWidth = override.layoutInfo.auxiliaryBarWidth || partSplash.layoutInfo.auxiliarySideBarWidth || ThemeMainService_1.DEFAULT_BAR_WIDTH;
            } else {
              auxiliarySideBarWidth = 0;
            }
          }
        } else {
          auxiliarySideBarWidth = 0;
        }
        return {
          ...partSplash,
          layoutInfo: {
            ...partSplash.layoutInfo,
            sideBarWidth,
            auxiliarySideBarWidth
          }
        };
      }
      getWindowSplashOverride() {
        let override = this.stateService.getItem(THEME_WINDOW_SPLASH_OVERRIDE_KEY);
        if (!override?.layoutInfo) {
          override = {
            layoutInfo: {
              sideBarWidth: ThemeMainService_1.DEFAULT_BAR_WIDTH,
              auxiliaryBarWidth: ThemeMainService_1.DEFAULT_BAR_WIDTH,
              workspaces: {}
            }
          };
        }
        if (!override.layoutInfo.sideBarWidth) {
          override.layoutInfo.sideBarWidth = ThemeMainService_1.DEFAULT_BAR_WIDTH;
        }
        if (!override.layoutInfo.auxiliaryBarWidth) {
          override.layoutInfo.auxiliaryBarWidth = ThemeMainService_1.DEFAULT_BAR_WIDTH;
        }
        if (!override.layoutInfo.workspaces) {
          override.layoutInfo.workspaces = {};
        }
        return override;
      }
    };
    ThemeMainService = ThemeMainService_1 = __decorate([
      __param(0, IStateService),
      __param(1, IConfigurationService),
      __param(2, ILogService)
    ], ThemeMainService);
  }
});

// out-build/vs/platform/window/common/window.js
function isWorkspaceToOpen(uriToOpen) {
  return !!uriToOpen.workspaceUri;
}
function isFolderToOpen(uriToOpen) {
  return !!uriToOpen.folderUri;
}
function isFileToOpen(uriToOpen) {
  return !!uriToOpen.fileUri;
}
function hasNativeContextMenu(configurationService, titleBarStyle) {
  if (isWeb) {
    return false;
  }
  const nativeTitle = hasNativeTitlebar(configurationService, titleBarStyle);
  const windowConfigurations = configurationService.getValue("window");
  if (windowConfigurations?.menuStyle === "native") {
    if (!isMacintosh && !nativeTitle) {
      return false;
    }
    return true;
  }
  if (windowConfigurations?.menuStyle === "custom") {
    return false;
  }
  return nativeTitle;
}
function hasNativeMenu(configurationService, titleBarStyle) {
  if (isWeb) {
    return false;
  }
  if (isMacintosh) {
    return true;
  }
  return hasNativeContextMenu(configurationService, titleBarStyle);
}
function getMenuBarVisibility(configurationService) {
  const menuBarVisibility = configurationService.getValue(
    "window.menuBarVisibility"
    /* MenuSettings.MenuBarVisibility */
  );
  if (menuBarVisibility === "default" || menuBarVisibility === "compact" && hasNativeMenu(configurationService) || isMacintosh && isNative) {
    return "classic";
  } else {
    return menuBarVisibility;
  }
}
function hasNativeTitlebar(configurationService, titleBarStyle) {
  if (!titleBarStyle) {
    titleBarStyle = getTitleBarStyle(configurationService);
  }
  return titleBarStyle === "native";
}
function getTitleBarStyle(configurationService) {
  if (isWeb) {
    return "custom";
  }
  const configuration = configurationService.getValue("window");
  if (configuration) {
    const useNativeTabs = isMacintosh && configuration.nativeTabs === true;
    if (useNativeTabs) {
      return "native";
    }
    const useSimpleFullScreen = isMacintosh && configuration.nativeFullScreen === false;
    if (useSimpleFullScreen) {
      return "native";
    }
    const style = configuration.titleBarStyle;
    if (style === "native" || style === "custom") {
      return style;
    }
  }
  return "custom";
}
function getWindowControlsStyle(configurationService) {
  if (isWeb || isMacintosh || getTitleBarStyle(configurationService) === "native") {
    return "native";
  }
  const configuration = configurationService.getValue("window");
  const style = configuration?.controlsStyle;
  if (style === "custom" || style === "hidden") {
    return style;
  }
  return "native";
}
function useWindowControlsOverlay(configurationService) {
  if (isWeb) {
    return false;
  }
  if (hasNativeTitlebar(configurationService)) {
    return false;
  }
  if (!isMacintosh) {
    const setting = getWindowControlsStyle(configurationService);
    if (setting === "custom" || setting === "hidden") {
      return false;
    }
  }
  return true;
}
function useNativeFullScreen(configurationService) {
  const windowConfig = configurationService.getValue("window");
  if (!windowConfig || typeof windowConfig.nativeFullScreen !== "boolean") {
    return true;
  }
  if (windowConfig.nativeTabs) {
    return true;
  }
  return windowConfig.nativeFullScreen !== false;
}
function zoomLevelToZoomFactor(zoomLevel = 0) {
  return Math.pow(1.2, zoomLevel);
}
var WindowMinimumSize, MenuSettings, MenuStyleConfiguration, TitleBarSetting, TitlebarStyle, WindowControlsStyle, CustomTitleBarVisibility, DEFAULT_CUSTOM_TITLEBAR_HEIGHT, DEFAULT_WINDOW_SIZE, DEFAULT_AUX_WINDOW_SIZE;
var init_window = __esm({
  "out-build/vs/platform/window/common/window.js"() {
    "use strict";
    init_platform();
    WindowMinimumSize = {
      WIDTH: 400,
      WIDTH_WITH_VERTICAL_PANEL: 600,
      HEIGHT: 270
    };
    (function(MenuSettings2) {
      MenuSettings2["MenuStyle"] = "window.menuStyle";
      MenuSettings2["MenuBarVisibility"] = "window.menuBarVisibility";
    })(MenuSettings || (MenuSettings = {}));
    (function(MenuStyleConfiguration2) {
      MenuStyleConfiguration2["CUSTOM"] = "custom";
      MenuStyleConfiguration2["NATIVE"] = "native";
      MenuStyleConfiguration2["INHERIT"] = "inherit";
    })(MenuStyleConfiguration || (MenuStyleConfiguration = {}));
    (function(TitleBarSetting2) {
      TitleBarSetting2["TITLE_BAR_STYLE"] = "window.titleBarStyle";
      TitleBarSetting2["CUSTOM_TITLE_BAR_VISIBILITY"] = "window.customTitleBarVisibility";
    })(TitleBarSetting || (TitleBarSetting = {}));
    (function(TitlebarStyle2) {
      TitlebarStyle2["NATIVE"] = "native";
      TitlebarStyle2["CUSTOM"] = "custom";
    })(TitlebarStyle || (TitlebarStyle = {}));
    (function(WindowControlsStyle2) {
      WindowControlsStyle2["NATIVE"] = "native";
      WindowControlsStyle2["CUSTOM"] = "custom";
      WindowControlsStyle2["HIDDEN"] = "hidden";
    })(WindowControlsStyle || (WindowControlsStyle = {}));
    (function(CustomTitleBarVisibility2) {
      CustomTitleBarVisibility2["AUTO"] = "auto";
      CustomTitleBarVisibility2["WINDOWED"] = "windowed";
      CustomTitleBarVisibility2["NEVER"] = "never";
    })(CustomTitleBarVisibility || (CustomTitleBarVisibility = {}));
    DEFAULT_CUSTOM_TITLEBAR_HEIGHT = 35;
    DEFAULT_WINDOW_SIZE = { width: 1200, height: 800 };
    DEFAULT_AUX_WINDOW_SIZE = { width: 1024, height: 768 };
  }
});

// out-build/vs/platform/window/electron-main/window.js
import electron3 from "electron";
var LoadReason, UnloadReason, defaultWindowState, defaultAuxWindowState, WindowMode, WindowError;
var init_window2 = __esm({
  "out-build/vs/platform/window/electron-main/window.js"() {
    "use strict";
    init_window();
    (function(LoadReason2) {
      LoadReason2[LoadReason2["INITIAL"] = 1] = "INITIAL";
      LoadReason2[LoadReason2["LOAD"] = 2] = "LOAD";
      LoadReason2[LoadReason2["RELOAD"] = 3] = "RELOAD";
    })(LoadReason || (LoadReason = {}));
    (function(UnloadReason2) {
      UnloadReason2[UnloadReason2["CLOSE"] = 1] = "CLOSE";
      UnloadReason2[UnloadReason2["QUIT"] = 2] = "QUIT";
      UnloadReason2[UnloadReason2["RELOAD"] = 3] = "RELOAD";
      UnloadReason2[UnloadReason2["LOAD"] = 4] = "LOAD";
    })(UnloadReason || (UnloadReason = {}));
    defaultWindowState = function(mode = 1) {
      return {
        width: DEFAULT_WINDOW_SIZE.width,
        height: DEFAULT_WINDOW_SIZE.height,
        mode
      };
    };
    defaultAuxWindowState = function() {
      const width = DEFAULT_AUX_WINDOW_SIZE.width;
      const height = DEFAULT_AUX_WINDOW_SIZE.height;
      const workArea = electron3.screen.getPrimaryDisplay().workArea;
      const x = Math.max(workArea.x + workArea.width / 2 - width / 2, 0);
      const y = Math.max(workArea.y + workArea.height / 2 - height / 2, 0);
      return {
        x,
        y,
        width,
        height,
        mode: 1
        /* WindowMode.Normal */
      };
    };
    (function(WindowMode2) {
      WindowMode2[WindowMode2["Maximized"] = 0] = "Maximized";
      WindowMode2[WindowMode2["Normal"] = 1] = "Normal";
      WindowMode2[WindowMode2["Minimized"] = 2] = "Minimized";
      WindowMode2[WindowMode2["Fullscreen"] = 3] = "Fullscreen";
    })(WindowMode || (WindowMode = {}));
    (function(WindowError2) {
      WindowError2[WindowError2["UNRESPONSIVE"] = 1] = "UNRESPONSIVE";
      WindowError2[WindowError2["PROCESS_GONE"] = 2] = "PROCESS_GONE";
      WindowError2[WindowError2["LOAD"] = 3] = "LOAD";
      WindowError2[WindowError2["RESPONSIVE"] = 4] = "RESPONSIVE";
    })(WindowError || (WindowError = {}));
  }
});

// out-build/vs/platform/windows/electron-main/windows.js
import electron4 from "electron";
function defaultBrowserWindowOptions(accessor, windowState, overrides, webPreferences) {
  const themeMainService = accessor.get(IThemeMainService);
  const productService = accessor.get(IProductService);
  const configurationService = accessor.get(IConfigurationService);
  const environmentMainService = accessor.get(IEnvironmentMainService);
  const windowSettings2 = configurationService.getValue("window");
  const options = {
    backgroundColor: themeMainService.getBackgroundColor(),
    minWidth: WindowMinimumSize.WIDTH,
    minHeight: WindowMinimumSize.HEIGHT,
    title: productService.nameLong,
    show: windowState.mode !== 0 && windowState.mode !== 3,
    // reduce flicker by showing later
    x: windowState.x,
    y: windowState.y,
    width: windowState.width,
    height: windowState.height,
    webPreferences: {
      ...webPreferences,
      enableWebSQL: false,
      spellcheck: false,
      zoomFactor: zoomLevelToZoomFactor(windowState.zoomLevel ?? windowSettings2?.zoomLevel),
      autoplayPolicy: "user-gesture-required",
      // Enable experimental css highlight api https://chromestatus.com/feature/5436441440026624
      // Refs https://github.com/microsoft/vscode/issues/140098
      enableBlinkFeatures: "HighlightAPI",
      sandbox: true,
      // TODO(deepak1556): Should be removed once migration is complete
      // https://github.com/microsoft/vscode/issues/239228
      enableDeprecatedPaste: true
    },
    experimentalDarkMode: true
  };
  if (isLinux) {
    options.icon = join3(environmentMainService.appRoot, "resources/linux/code.png");
  } else if (isWindows2 && !environmentMainService.isBuilt) {
    options.icon = join3(environmentMainService.appRoot, "resources/win32/code_150x150.png");
  }
  if (isMacintosh) {
    options.acceptFirstMouse = true;
    if (windowSettings2?.clickThroughInactive === false) {
      options.acceptFirstMouse = false;
    }
  }
  if (overrides?.disableFullscreen) {
    options.fullscreen = false;
  } else if (isMacintosh && !useNativeFullScreen(configurationService)) {
    options.fullscreenable = false;
  }
  const useNativeTabs = isMacintosh && windowSettings2?.nativeTabs === true;
  if (useNativeTabs) {
    options.tabbingIdentifier = productService.nameShort;
  }
  const hideNativeTitleBar = !hasNativeTitlebar(configurationService, overrides?.forceNativeTitlebar ? "native" : void 0);
  if (hideNativeTitleBar) {
    options.titleBarStyle = "hidden";
    if (!isMacintosh) {
      options.frame = false;
    }
    if (useWindowControlsOverlay(configurationService)) {
      if (isMacintosh) {
        options.titleBarOverlay = true;
      } else {
        const titleBarColor = themeMainService.getWindowSplash(void 0)?.colorInfo.titleBarBackground ?? themeMainService.getBackgroundColor();
        const symbolColor = Color.fromHex(titleBarColor).isDarker() ? "#FFFFFF" : "#000000";
        options.titleBarOverlay = {
          height: 29,
          // the smallest size of the title bar on windows accounting for the border on windows 11
          color: titleBarColor,
          symbolColor
        };
      }
    }
  }
  if (overrides?.alwaysOnTop) {
    options.alwaysOnTop = true;
  }
  return options;
}
function getLastFocused(windows) {
  let lastFocusedWindow = void 0;
  let maxLastFocusTime = Number.MIN_VALUE;
  for (const window of windows) {
    if (window.lastFocusTime > maxLastFocusTime) {
      maxLastFocusTime = window.lastFocusTime;
      lastFocusedWindow = window;
    }
  }
  return lastFocusedWindow;
}
function getAllWindowsExcludingOffscreen() {
  return electron4.BrowserWindow.getAllWindows().filter((win) => !win.webContents.isOffscreen());
}
var IWindowsMainService, OpenContext, WindowStateValidator;
var init_windows = __esm({
  "out-build/vs/platform/windows/electron-main/windows.js"() {
    "use strict";
    init_color();
    init_path();
    init_platform();
    init_configuration();
    init_environmentMainService();
    init_instantiation();
    init_productService();
    init_themeMainService();
    init_window();
    init_window2();
    IWindowsMainService = createDecorator("windowsMainService");
    (function(OpenContext2) {
      OpenContext2[OpenContext2["CLI"] = 0] = "CLI";
      OpenContext2[OpenContext2["DOCK"] = 1] = "DOCK";
      OpenContext2[OpenContext2["MENU"] = 2] = "MENU";
      OpenContext2[OpenContext2["DIALOG"] = 3] = "DIALOG";
      OpenContext2[OpenContext2["DESKTOP"] = 4] = "DESKTOP";
      OpenContext2[OpenContext2["API"] = 5] = "API";
      OpenContext2[OpenContext2["LINK"] = 6] = "LINK";
    })(OpenContext || (OpenContext = {}));
    (function(WindowStateValidator2) {
      function validateWindowState(logService, state, displays = electron4.screen.getAllDisplays()) {
        logService.trace(`window#validateWindowState: validating window state on ${displays.length} display(s)`, state);
        if (typeof state.x !== "number" || typeof state.y !== "number" || typeof state.width !== "number" || typeof state.height !== "number") {
          logService.trace("window#validateWindowState: unexpected type of state values");
          return void 0;
        }
        if (state.width <= 0 || state.height <= 0) {
          logService.trace("window#validateWindowState: unexpected negative values");
          return void 0;
        }
        if (displays.length === 1) {
          const displayWorkingArea2 = getWorkingArea(displays[0]);
          logService.trace("window#validateWindowState: single monitor working area", displayWorkingArea2);
          if (displayWorkingArea2) {
            let ensureStateInDisplayWorkingArea2 = function() {
              if (!state || typeof state.x !== "number" || typeof state.y !== "number" || !displayWorkingArea2) {
                return;
              }
              if (state.x < displayWorkingArea2.x) {
                state.x = displayWorkingArea2.x;
              }
              if (state.y < displayWorkingArea2.y) {
                state.y = displayWorkingArea2.y;
              }
            };
            var ensureStateInDisplayWorkingArea = ensureStateInDisplayWorkingArea2;
            ensureStateInDisplayWorkingArea2();
            if (state.width > displayWorkingArea2.width) {
              state.width = displayWorkingArea2.width;
            }
            if (state.height > displayWorkingArea2.height) {
              state.height = displayWorkingArea2.height;
            }
            if (state.x > displayWorkingArea2.x + displayWorkingArea2.width - 128) {
              state.x = displayWorkingArea2.x + displayWorkingArea2.width - state.width;
            }
            if (state.y > displayWorkingArea2.y + displayWorkingArea2.height - 128) {
              state.y = displayWorkingArea2.y + displayWorkingArea2.height - state.height;
            }
            ensureStateInDisplayWorkingArea2();
          }
          return state;
        }
        if (state.display && state.mode === 3) {
          const display2 = displays.find((d) => d.id === state.display);
          if (display2 && typeof display2.bounds?.x === "number" && typeof display2.bounds?.y === "number") {
            logService.trace("window#validateWindowState: restoring fullscreen to previous display");
            const defaults = defaultWindowState(
              3
              /* WindowMode.Fullscreen */
            );
            defaults.x = display2.bounds.x;
            defaults.y = display2.bounds.y;
            return defaults;
          }
        }
        let display;
        let displayWorkingArea;
        try {
          display = electron4.screen.getDisplayMatching({ x: state.x, y: state.y, width: state.width, height: state.height });
          displayWorkingArea = getWorkingArea(display);
          logService.trace("window#validateWindowState: multi-monitor working area", displayWorkingArea);
        } catch (error) {
          logService.error("window#validateWindowState: error finding display for window state", error);
        }
        if (display && validateWindowStateOnDisplay(state, display)) {
          return state;
        }
        logService.trace("window#validateWindowState: state is outside of the multi-monitor working area");
        return void 0;
      }
      WindowStateValidator2.validateWindowState = validateWindowState;
      function validateWindowStateOnDisplay(state, display) {
        if (typeof state.x !== "number" || typeof state.y !== "number" || typeof state.width !== "number" || typeof state.height !== "number" || state.width <= 0 || state.height <= 0) {
          return false;
        }
        const displayWorkingArea = getWorkingArea(display);
        return Boolean(
          displayWorkingArea && // we have valid working area bounds
          state.x + state.width > displayWorkingArea.x && // prevent window from falling out of the screen to the left
          state.y + state.height > displayWorkingArea.y && // prevent window from falling out of the screen to the top
          state.x < displayWorkingArea.x + displayWorkingArea.width && // prevent window from falling out of the screen to the right
          state.y < displayWorkingArea.y + displayWorkingArea.height
          // prevent window from falling out of the screen to the bottom
        );
      }
      WindowStateValidator2.validateWindowStateOnDisplay = validateWindowStateOnDisplay;
      function getWorkingArea(display) {
        if (display.workArea.width > 0 && display.workArea.height > 0) {
          return display.workArea;
        }
        if (display.bounds.width > 0 && display.bounds.height > 0) {
          return display.bounds;
        }
        return void 0;
      }
    })(WindowStateValidator || (WindowStateValidator = {}));
  }
});

// out-build/vs/platform/lifecycle/electron-main/lifecycleMainService.js
import electron5 from "electron";
var LifecycleMainService_1, ILifecycleMainService, ShutdownReason, LifecycleMainPhase, LifecycleMainService;
var init_lifecycleMainService = __esm({
  "out-build/vs/platform/lifecycle/electron-main/lifecycleMainService.js"() {
    "use strict";
    init_ipcMain();
    init_async();
    init_event();
    init_lifecycle();
    init_platform();
    init_process();
    init_types();
    init_instantiation();
    init_log();
    init_state();
    init_environmentMainService();
    init_windows();
    ILifecycleMainService = createDecorator("lifecycleMainService");
    (function(ShutdownReason2) {
      ShutdownReason2[ShutdownReason2["QUIT"] = 1] = "QUIT";
      ShutdownReason2[ShutdownReason2["KILL"] = 2] = "KILL";
    })(ShutdownReason || (ShutdownReason = {}));
    (function(LifecycleMainPhase2) {
      LifecycleMainPhase2[LifecycleMainPhase2["Starting"] = 1] = "Starting";
      LifecycleMainPhase2[LifecycleMainPhase2["Ready"] = 2] = "Ready";
      LifecycleMainPhase2[LifecycleMainPhase2["AfterWindowOpen"] = 3] = "AfterWindowOpen";
      LifecycleMainPhase2[LifecycleMainPhase2["Eventually"] = 4] = "Eventually";
    })(LifecycleMainPhase || (LifecycleMainPhase = {}));
    LifecycleMainService = class LifecycleMainService2 extends Disposable {
      static {
        LifecycleMainService_1 = this;
      }
      static {
        this.QUIT_AND_RESTART_KEY = "lifecycle.quitAndRestart";
      }
      get quitRequested() {
        return this._quitRequested;
      }
      get wasRestarted() {
        return this._wasRestarted;
      }
      get phase() {
        return this._phase;
      }
      constructor(logService, stateService, environmentMainService) {
        super();
        this.logService = logService;
        this.stateService = stateService;
        this.environmentMainService = environmentMainService;
        this._onBeforeShutdown = this._register(new Emitter());
        this.onBeforeShutdown = this._onBeforeShutdown.event;
        this._onWillShutdown = this._register(new Emitter());
        this.onWillShutdown = this._onWillShutdown.event;
        this._onWillLoadWindow = this._register(new Emitter());
        this.onWillLoadWindow = this._onWillLoadWindow.event;
        this._onBeforeCloseWindow = this._register(new Emitter());
        this.onBeforeCloseWindow = this._onBeforeCloseWindow.event;
        this._quitRequested = false;
        this._wasRestarted = false;
        this._phase = 1;
        this.windowToCloseRequest = /* @__PURE__ */ new Set();
        this.oneTimeListenerTokenGenerator = 0;
        this.windowCounter = 0;
        this.pendingQuitPromise = void 0;
        this.pendingQuitPromiseResolve = void 0;
        this.pendingWillShutdownPromise = void 0;
        this.mapWindowIdToPendingUnload = /* @__PURE__ */ new Map();
        this.phaseWhen = /* @__PURE__ */ new Map();
        this.relaunchHandler = void 0;
        this.resolveRestarted();
        this.when(
          2
          /* LifecycleMainPhase.Ready */
        ).then(() => this.registerListeners());
      }
      resolveRestarted() {
        this._wasRestarted = !!this.stateService.getItem(LifecycleMainService_1.QUIT_AND_RESTART_KEY);
        if (this._wasRestarted) {
          this.stateService.removeItem(LifecycleMainService_1.QUIT_AND_RESTART_KEY);
        }
      }
      registerListeners() {
        const beforeQuitListener = () => {
          if (this._quitRequested) {
            return;
          }
          this.trace("Lifecycle#app.on(before-quit)");
          this._quitRequested = true;
          this.trace("Lifecycle#onBeforeShutdown.fire()");
          this._onBeforeShutdown.fire();
          if (isMacintosh && this.windowCounter === 0) {
            this.fireOnWillShutdown(
              1
              /* ShutdownReason.QUIT */
            );
          }
        };
        electron5.app.addListener("before-quit", beforeQuitListener);
        const windowAllClosedListener = () => {
          this.trace("Lifecycle#app.on(window-all-closed)");
          if (this._quitRequested || !isMacintosh) {
            electron5.app.quit();
          }
        };
        electron5.app.addListener("window-all-closed", windowAllClosedListener);
        electron5.app.once("will-quit", (e) => {
          this.trace("Lifecycle#app.on(will-quit) - begin");
          e.preventDefault();
          const shutdownPromise = this.fireOnWillShutdown(
            1
            /* ShutdownReason.QUIT */
          );
          shutdownPromise.finally(() => {
            this.trace("Lifecycle#app.on(will-quit) - after fireOnWillShutdown");
            this.resolvePendingQuitPromise(
              false
              /* no veto */
            );
            electron5.app.removeListener("before-quit", beforeQuitListener);
            electron5.app.removeListener("window-all-closed", windowAllClosedListener);
            this.trace("Lifecycle#app.on(will-quit) - calling app.quit()");
            electron5.app.quit();
          });
        });
      }
      fireOnWillShutdown(reason) {
        if (this.pendingWillShutdownPromise) {
          return this.pendingWillShutdownPromise;
        }
        const logService = this.logService;
        this.trace("Lifecycle#onWillShutdown.fire()");
        const joiners = [];
        this._onWillShutdown.fire({
          reason,
          join(id2, promise) {
            logService.trace(`Lifecycle#onWillShutdown - begin '${id2}'`);
            joiners.push(promise.finally(() => {
              logService.trace(`Lifecycle#onWillShutdown - end '${id2}'`);
            }));
          }
        });
        this.pendingWillShutdownPromise = (async () => {
          try {
            await Promises.settled(joiners);
          } catch (error) {
            this.logService.error(error);
          }
          try {
            await this.stateService.close();
          } catch (error) {
            this.logService.error(error);
          }
        })();
        return this.pendingWillShutdownPromise;
      }
      set phase(value) {
        if (value < this.phase) {
          throw new Error("Lifecycle cannot go backwards");
        }
        if (this._phase === value) {
          return;
        }
        this.trace(`lifecycle (main): phase changed (value: ${value})`);
        this._phase = value;
        const barrier = this.phaseWhen.get(this._phase);
        if (barrier) {
          barrier.open();
          this.phaseWhen.delete(this._phase);
        }
      }
      async when(phase) {
        if (phase <= this._phase) {
          return;
        }
        let barrier = this.phaseWhen.get(phase);
        if (!barrier) {
          barrier = new Barrier();
          this.phaseWhen.set(phase, barrier);
        }
        await barrier.wait();
      }
      registerWindow(window) {
        const windowListeners = new DisposableStore();
        this.windowCounter++;
        windowListeners.add(window.onWillLoad((e) => this._onWillLoadWindow.fire({ window, workspace: e.workspace, reason: e.reason })));
        const win = assertIsDefined(window.win);
        windowListeners.add(Event.fromNodeEventEmitter(win, "close")((e) => {
          const windowId = window.id;
          if (this.windowToCloseRequest.has(windowId)) {
            this.windowToCloseRequest.delete(windowId);
            return;
          }
          this.trace(`Lifecycle#window.on('close') - window ID ${window.id}`);
          e.preventDefault();
          this.unload(
            window,
            1
            /* UnloadReason.CLOSE */
          ).then((veto) => {
            if (veto) {
              this.windowToCloseRequest.delete(windowId);
              return;
            }
            this.windowToCloseRequest.add(windowId);
            this.trace(`Lifecycle#onBeforeCloseWindow.fire() - window ID ${windowId}`);
            this._onBeforeCloseWindow.fire(window);
            window.close();
          });
        }));
        windowListeners.add(Event.fromNodeEventEmitter(win, "closed")(() => {
          this.trace(`Lifecycle#window.on('closed') - window ID ${window.id}`);
          this.windowCounter--;
          windowListeners.dispose();
          if (this.windowCounter === 0 && (!isMacintosh || this._quitRequested)) {
            this.fireOnWillShutdown(
              1
              /* ShutdownReason.QUIT */
            );
          }
        }));
      }
      registerAuxWindow(auxWindow) {
        const win = assertIsDefined(auxWindow.win);
        const windowListeners = new DisposableStore();
        windowListeners.add(Event.fromNodeEventEmitter(win, "close")((e) => {
          this.trace(`Lifecycle#auxWindow.on('close') - window ID ${auxWindow.id}`);
          if (this._quitRequested) {
            this.trace(`Lifecycle#auxWindow.on('close') - preventDefault() because quit requested`);
            e.preventDefault();
          }
        }));
        windowListeners.add(Event.fromNodeEventEmitter(win, "closed")(() => {
          this.trace(`Lifecycle#auxWindow.on('closed') - window ID ${auxWindow.id}`);
          windowListeners.dispose();
        }));
      }
      async reload(window, cli) {
        const veto = await this.unload(
          window,
          3
          /* UnloadReason.RELOAD */
        );
        if (!veto) {
          window.reload(cli);
        }
      }
      unload(window, reason) {
        const pendingUnloadPromise = this.mapWindowIdToPendingUnload.get(window.id);
        if (pendingUnloadPromise) {
          return pendingUnloadPromise;
        }
        const unloadPromise = this.doUnload(window, reason).finally(() => {
          this.mapWindowIdToPendingUnload.delete(window.id);
        });
        this.mapWindowIdToPendingUnload.set(window.id, unloadPromise);
        return unloadPromise;
      }
      async doUnload(window, reason) {
        if (!window.isReady) {
          return false;
        }
        this.trace(`Lifecycle#unload() - window ID ${window.id}`);
        const windowUnloadReason = this._quitRequested ? 2 : reason;
        const veto = await this.onBeforeUnloadWindowInRenderer(window, windowUnloadReason);
        if (veto) {
          this.trace(`Lifecycle#unload() - veto in renderer (window ID ${window.id})`);
          return this.handleWindowUnloadVeto(veto);
        }
        await this.onWillUnloadWindowInRenderer(window, windowUnloadReason);
        return false;
      }
      handleWindowUnloadVeto(veto) {
        if (!veto) {
          return false;
        }
        this.resolvePendingQuitPromise(
          true
          /* veto */
        );
        this._quitRequested = false;
        return true;
      }
      resolvePendingQuitPromise(veto) {
        if (this.pendingQuitPromiseResolve) {
          this.pendingQuitPromiseResolve(veto);
          this.pendingQuitPromiseResolve = void 0;
          this.pendingQuitPromise = void 0;
        }
      }
      onBeforeUnloadWindowInRenderer(window, reason) {
        return new Promise((resolve3) => {
          const oneTimeEventToken = this.oneTimeListenerTokenGenerator++;
          const okChannel = `vscode:ok${oneTimeEventToken}`;
          const cancelChannel = `vscode:cancel${oneTimeEventToken}`;
          validatedIpcMain.once(okChannel, () => {
            resolve3(false);
          });
          validatedIpcMain.once(cancelChannel, () => {
            resolve3(true);
          });
          window.send("vscode:onBeforeUnload", { okChannel, cancelChannel, reason });
        });
      }
      onWillUnloadWindowInRenderer(window, reason) {
        return new Promise((resolve3) => {
          const oneTimeEventToken = this.oneTimeListenerTokenGenerator++;
          const replyChannel = `vscode:reply${oneTimeEventToken}`;
          validatedIpcMain.once(replyChannel, () => resolve3());
          window.send("vscode:onWillUnload", { replyChannel, reason });
        });
      }
      quit(willRestart) {
        return this.doQuit(willRestart).then((veto) => {
          if (!veto && willRestart) {
            try {
              if (isWindows2) {
                const currentWorkingDir = cwd2();
                if (currentWorkingDir !== process.cwd()) {
                  process.chdir(currentWorkingDir);
                }
              }
            } catch (err) {
              this.logService.error(err);
            }
          }
          return veto;
        });
      }
      doQuit(willRestart) {
        this.trace(`Lifecycle#quit() - begin (willRestart: ${willRestart})`);
        if (this.pendingQuitPromise) {
          this.trace("Lifecycle#quit() - returning pending quit promise");
          return this.pendingQuitPromise;
        }
        if (willRestart) {
          this.stateService.setItem(LifecycleMainService_1.QUIT_AND_RESTART_KEY, true);
        }
        this.pendingQuitPromise = new Promise((resolve3) => {
          this.pendingQuitPromiseResolve = resolve3;
          this.trace("Lifecycle#quit() - calling app.quit()");
          electron5.app.quit();
        });
        return this.pendingQuitPromise;
      }
      trace(msg) {
        if (this.environmentMainService.args["enable-smoke-test-driver"]) {
          this.logService.info(msg);
        } else {
          this.logService.trace(msg);
        }
      }
      setRelaunchHandler(handler) {
        this.relaunchHandler = handler;
      }
      async relaunch(options) {
        this.trace("Lifecycle#relaunch()");
        const args2 = process.argv.slice(1);
        if (options?.addArgs) {
          args2.push(...options.addArgs);
        }
        if (options?.removeArgs) {
          for (const a of options.removeArgs) {
            const idx = args2.indexOf(a);
            if (idx >= 0) {
              args2.splice(idx, 1);
            }
          }
        }
        const quitListener = () => {
          if (!this.relaunchHandler?.handleRelaunch(options)) {
            this.trace("Lifecycle#relaunch() - calling app.relaunch()");
            electron5.app.relaunch({ args: args2 });
          }
        };
        electron5.app.once("quit", quitListener);
        const veto = await this.quit(
          true
          /* will restart */
        );
        if (veto) {
          electron5.app.removeListener("quit", quitListener);
        }
      }
      async kill(code2) {
        this.trace("Lifecycle#kill()");
        await this.fireOnWillShutdown(
          2
          /* ShutdownReason.KILL */
        );
        await Promise.race([
          // Still do not block more than 1s
          timeout(1e3),
          // Destroy any opened window: we do not unload windows here because
          // there is a chance that the unload is veto'd or long running due
          // to a participant within the window. this is not wanted when we
          // are asked to kill the application.
          (async () => {
            for (const window of getAllWindowsExcludingOffscreen()) {
              if (window && !window.isDestroyed()) {
                let whenWindowClosed;
                if (window.webContents && !window.webContents.isDestroyed()) {
                  whenWindowClosed = new Promise((resolve3) => window.once("closed", resolve3));
                } else {
                  whenWindowClosed = Promise.resolve();
                }
                window.destroy();
                await whenWindowClosed;
              }
            }
          })()
        ]);
        electron5.app.exit(code2);
      }
    };
    LifecycleMainService = LifecycleMainService_1 = __decorate([
      __param(0, ILogService),
      __param(1, IStateService),
      __param(2, IEnvironmentMainService)
    ], LifecycleMainService);
  }
});

// out-build/vs/base/parts/storage/common/storage.js
var StorageHint, StorageState, Storage, InMemoryStorageDatabase;
var init_storage = __esm({
  "out-build/vs/base/parts/storage/common/storage.js"() {
    "use strict";
    init_async();
    init_event();
    init_lifecycle();
    init_marshalling();
    init_types();
    (function(StorageHint2) {
      StorageHint2[StorageHint2["STORAGE_DOES_NOT_EXIST"] = 0] = "STORAGE_DOES_NOT_EXIST";
      StorageHint2[StorageHint2["STORAGE_IN_MEMORY"] = 1] = "STORAGE_IN_MEMORY";
    })(StorageHint || (StorageHint = {}));
    (function(StorageState2) {
      StorageState2[StorageState2["None"] = 0] = "None";
      StorageState2[StorageState2["Initialized"] = 1] = "Initialized";
      StorageState2[StorageState2["Closed"] = 2] = "Closed";
    })(StorageState || (StorageState = {}));
    Storage = class _Storage extends Disposable {
      static {
        this.DEFAULT_FLUSH_DELAY = 100;
      }
      constructor(database, options = /* @__PURE__ */ Object.create(null)) {
        super();
        this.database = database;
        this.options = options;
        this._onDidChangeStorage = this._register(new PauseableEmitter());
        this.onDidChangeStorage = this._onDidChangeStorage.event;
        this.state = StorageState.None;
        this.cache = /* @__PURE__ */ new Map();
        this.flushDelayer = this._register(new ThrottledDelayer(_Storage.DEFAULT_FLUSH_DELAY));
        this.pendingDeletes = /* @__PURE__ */ new Set();
        this.pendingInserts = /* @__PURE__ */ new Map();
        this.pendingClose = void 0;
        this.whenFlushedCallbacks = [];
        this.registerListeners();
      }
      registerListeners() {
        this._register(this.database.onDidChangeItemsExternal((e) => this.onDidChangeItemsExternal(e)));
      }
      onDidChangeItemsExternal(e) {
        this._onDidChangeStorage.pause();
        try {
          e.changed?.forEach((value, key) => this.acceptExternal(key, value));
          e.deleted?.forEach((key) => this.acceptExternal(key, void 0));
        } finally {
          this._onDidChangeStorage.resume();
        }
      }
      acceptExternal(key, value) {
        if (this.state === StorageState.Closed) {
          return;
        }
        let changed = false;
        if (isUndefinedOrNull(value)) {
          changed = this.cache.delete(key);
        } else {
          const currentValue = this.cache.get(key);
          if (currentValue !== value) {
            this.cache.set(key, value);
            changed = true;
          }
        }
        if (changed) {
          this._onDidChangeStorage.fire({ key, external: true });
        }
      }
      get items() {
        return this.cache;
      }
      get size() {
        return this.cache.size;
      }
      async init() {
        if (this.state !== StorageState.None) {
          return;
        }
        this.state = StorageState.Initialized;
        if (this.options.hint === StorageHint.STORAGE_DOES_NOT_EXIST) {
          return;
        }
        this.cache = await this.database.getItems();
      }
      get(key, fallbackValue) {
        const value = this.cache.get(key);
        if (isUndefinedOrNull(value)) {
          return fallbackValue;
        }
        return value;
      }
      getBoolean(key, fallbackValue) {
        const value = this.get(key);
        if (isUndefinedOrNull(value)) {
          return fallbackValue;
        }
        return value === "true";
      }
      getNumber(key, fallbackValue) {
        const value = this.get(key);
        if (isUndefinedOrNull(value)) {
          return fallbackValue;
        }
        return parseInt(value, 10);
      }
      getObject(key, fallbackValue) {
        const value = this.get(key);
        if (isUndefinedOrNull(value)) {
          return fallbackValue;
        }
        return parse3(value);
      }
      async set(key, value, external = false) {
        if (this.state === StorageState.Closed) {
          return;
        }
        if (isUndefinedOrNull(value)) {
          return this.delete(key, external);
        }
        const valueStr = isObject(value) || Array.isArray(value) ? stringify(value) : String(value);
        const currentValue = this.cache.get(key);
        if (currentValue === valueStr) {
          return;
        }
        this.cache.set(key, valueStr);
        this.pendingInserts.set(key, valueStr);
        this.pendingDeletes.delete(key);
        this._onDidChangeStorage.fire({ key, external });
        return this.doFlush();
      }
      async delete(key, external = false) {
        if (this.state === StorageState.Closed) {
          return;
        }
        const wasDeleted = this.cache.delete(key);
        if (!wasDeleted) {
          return;
        }
        if (!this.pendingDeletes.has(key)) {
          this.pendingDeletes.add(key);
        }
        this.pendingInserts.delete(key);
        this._onDidChangeStorage.fire({ key, external });
        return this.doFlush();
      }
      async optimize() {
        if (this.state === StorageState.Closed) {
          return;
        }
        await this.flush(0);
        return this.database.optimize();
      }
      async close() {
        if (!this.pendingClose) {
          this.pendingClose = this.doClose();
        }
        return this.pendingClose;
      }
      async doClose() {
        this.state = StorageState.Closed;
        try {
          await this.doFlush(
            0
            /* as soon as possible */
          );
        } catch (error) {
        }
        await this.database.close(() => this.cache);
      }
      get hasPending() {
        return this.pendingInserts.size > 0 || this.pendingDeletes.size > 0;
      }
      async flushPending() {
        if (!this.hasPending) {
          return;
        }
        const updateRequest = { insert: this.pendingInserts, delete: this.pendingDeletes };
        this.pendingDeletes = /* @__PURE__ */ new Set();
        this.pendingInserts = /* @__PURE__ */ new Map();
        return this.database.updateItems(updateRequest).finally(() => {
          if (!this.hasPending) {
            while (this.whenFlushedCallbacks.length) {
              this.whenFlushedCallbacks.pop()?.();
            }
          }
        });
      }
      async flush(delay) {
        if (this.state === StorageState.Closed || // Return early if we are already closed
        this.pendingClose) {
          return;
        }
        return this.doFlush(delay);
      }
      async doFlush(delay) {
        if (this.options.hint === StorageHint.STORAGE_IN_MEMORY) {
          return this.flushPending();
        }
        return this.flushDelayer.trigger(() => this.flushPending(), delay);
      }
      async whenFlushed() {
        if (!this.hasPending) {
          return;
        }
        return new Promise((resolve3) => this.whenFlushedCallbacks.push(resolve3));
      }
      isInMemory() {
        return this.options.hint === StorageHint.STORAGE_IN_MEMORY;
      }
    };
    InMemoryStorageDatabase = class {
      constructor() {
        this.onDidChangeItemsExternal = Event.None;
        this.items = /* @__PURE__ */ new Map();
      }
      async getItems() {
        return this.items;
      }
      async updateItems(request) {
        request.insert?.forEach((value, key) => this.items.set(key, value));
        request.delete?.forEach((key) => this.items.delete(key));
      }
      async optimize() {
      }
      async close() {
      }
    };
  }
});

// out-build/vs/platform/workspace/common/workspace.js
function isSingleFolderWorkspaceIdentifier(obj) {
  const singleFolderIdentifier = obj;
  return typeof singleFolderIdentifier?.id === "string" && URI.isUri(singleFolderIdentifier.uri);
}
function toWorkspaceIdentifier(arg0, isExtensionDevelopment) {
  if (typeof arg0 === "string" || typeof arg0 === "undefined") {
    if (typeof arg0 === "string") {
      return {
        id: basename(arg0)
      };
    }
    if (isExtensionDevelopment) {
      return EXTENSION_DEVELOPMENT_EMPTY_WINDOW_WORKSPACE;
    }
    return UNKNOWN_EMPTY_WINDOW_WORKSPACE;
  }
  const workspace = arg0;
  if (workspace.configuration) {
    return {
      id: workspace.id,
      configPath: workspace.configuration
    };
  }
  if (workspace.folders.length === 1) {
    return {
      id: workspace.id,
      uri: workspace.folders[0].uri
    };
  }
  return {
    id: workspace.id
  };
}
function isWorkspaceIdentifier(obj) {
  const workspaceIdentifier = obj;
  return typeof workspaceIdentifier?.id === "string" && URI.isUri(workspaceIdentifier.configPath);
}
function reviveIdentifier(identifier) {
  const singleFolderIdentifierCandidate = identifier;
  if (singleFolderIdentifierCandidate?.uri) {
    return { id: singleFolderIdentifierCandidate.id, uri: URI.revive(singleFolderIdentifierCandidate.uri) };
  }
  const workspaceIdentifierCandidate = identifier;
  if (workspaceIdentifierCandidate?.configPath) {
    return { id: workspaceIdentifierCandidate.id, configPath: URI.revive(workspaceIdentifierCandidate.configPath) };
  }
  if (identifier?.id) {
    return { id: identifier.id };
  }
  return void 0;
}
function isUntitledWorkspace(path4, environmentService) {
  return extUriBiasedIgnorePathCase.isEqualOrParent(path4, environmentService.untitledWorkspacesHome);
}
function hasWorkspaceFileExtension(path4) {
  const ext = typeof path4 === "string" ? extname(path4) : extname2(path4);
  return ext === WORKSPACE_SUFFIX;
}
var IWorkspaceContextService, EXTENSION_DEVELOPMENT_EMPTY_WINDOW_WORKSPACE, UNKNOWN_EMPTY_WINDOW_WORKSPACE, WorkbenchState, WorkspaceFolder, WORKSPACE_EXTENSION, WORKSPACE_SUFFIX, WORKSPACE_FILTER, UNTITLED_WORKSPACE_NAME;
var init_workspace = __esm({
  "out-build/vs/platform/workspace/common/workspace.js"() {
    "use strict";
    init_nls();
    init_path();
    init_ternarySearchTree();
    init_resources();
    init_uri();
    init_instantiation();
    init_network();
    IWorkspaceContextService = createDecorator("contextService");
    EXTENSION_DEVELOPMENT_EMPTY_WINDOW_WORKSPACE = { id: "ext-dev" };
    UNKNOWN_EMPTY_WINDOW_WORKSPACE = { id: "empty-window" };
    (function(WorkbenchState2) {
      WorkbenchState2[WorkbenchState2["EMPTY"] = 1] = "EMPTY";
      WorkbenchState2[WorkbenchState2["FOLDER"] = 2] = "FOLDER";
      WorkbenchState2[WorkbenchState2["WORKSPACE"] = 3] = "WORKSPACE";
    })(WorkbenchState || (WorkbenchState = {}));
    WorkspaceFolder = class {
      constructor(data, raw) {
        this.raw = raw;
        this.uri = data.uri;
        this.index = data.index;
        this.name = data.name;
      }
      toResource(relativePath2) {
        return joinPath(this.uri, relativePath2);
      }
      toJSON() {
        return { uri: this.uri, name: this.name, index: this.index };
      }
    };
    WORKSPACE_EXTENSION = "code-workspace";
    WORKSPACE_SUFFIX = `.${WORKSPACE_EXTENSION}`;
    WORKSPACE_FILTER = [{ name: localize(2661, null), extensions: [WORKSPACE_EXTENSION] }];
    UNTITLED_WORKSPACE_NAME = "workspace.json";
  }
});

// out-build/vs/platform/uriIdentity/common/uriIdentity.js
var IUriIdentityService;
var init_uriIdentity = __esm({
  "out-build/vs/platform/uriIdentity/common/uriIdentity.js"() {
    "use strict";
    init_instantiation();
    IUriIdentityService = createDecorator("IUriIdentityService");
  }
});

// out-build/vs/platform/userDataProfile/common/userDataProfile.js
function isUserDataProfile(thing) {
  const candidate = thing;
  return !!(candidate && typeof candidate === "object" && typeof candidate.id === "string" && typeof candidate.isDefault === "boolean" && typeof candidate.name === "string" && URI.isUri(candidate.location) && URI.isUri(candidate.globalStorageHome) && URI.isUri(candidate.settingsResource) && URI.isUri(candidate.keybindingsResource) && URI.isUri(candidate.tasksResource) && URI.isUri(candidate.snippetsHome) && URI.isUri(candidate.promptsHome) && URI.isUri(candidate.extensionsResource));
}
function toUserDataProfile(id2, name, location, profilesCacheHome, options, defaultProfile) {
  return {
    id: id2,
    name,
    location,
    isDefault: false,
    icon: options?.icon,
    globalStorageHome: defaultProfile && options?.useDefaultFlags?.globalState ? defaultProfile.globalStorageHome : joinPath(location, "globalStorage"),
    settingsResource: defaultProfile && options?.useDefaultFlags?.settings ? defaultProfile.settingsResource : joinPath(location, "settings.json"),
    keybindingsResource: defaultProfile && options?.useDefaultFlags?.keybindings ? defaultProfile.keybindingsResource : joinPath(location, "keybindings.json"),
    tasksResource: defaultProfile && options?.useDefaultFlags?.tasks ? defaultProfile.tasksResource : joinPath(location, "tasks.json"),
    snippetsHome: defaultProfile && options?.useDefaultFlags?.snippets ? defaultProfile.snippetsHome : joinPath(location, "snippets"),
    promptsHome: defaultProfile && options?.useDefaultFlags?.prompts ? defaultProfile.promptsHome : joinPath(location, "prompts"),
    extensionsResource: defaultProfile && options?.useDefaultFlags?.extensions ? defaultProfile.extensionsResource : joinPath(location, "extensions.json"),
    cacheHome: joinPath(profilesCacheHome, id2),
    useDefaultFlags: options?.useDefaultFlags,
    isTransient: options?.transient,
    workspaces: options?.workspaces
  };
}
var ProfileResourceType, IUserDataProfilesService, UserDataProfilesService;
var init_userDataProfile = __esm({
  "out-build/vs/platform/userDataProfile/common/userDataProfile.js"() {
    "use strict";
    init_hash();
    init_event();
    init_lifecycle();
    init_resources();
    init_uri();
    init_nls();
    init_environment();
    init_files();
    init_instantiation();
    init_log();
    init_workspace();
    init_uriIdentity();
    init_async();
    init_uuid();
    init_strings();
    init_types();
    (function(ProfileResourceType2) {
      ProfileResourceType2["Settings"] = "settings";
      ProfileResourceType2["Keybindings"] = "keybindings";
      ProfileResourceType2["Snippets"] = "snippets";
      ProfileResourceType2["Prompts"] = "prompts";
      ProfileResourceType2["Tasks"] = "tasks";
      ProfileResourceType2["Extensions"] = "extensions";
      ProfileResourceType2["GlobalState"] = "globalState";
    })(ProfileResourceType || (ProfileResourceType = {}));
    IUserDataProfilesService = createDecorator("IUserDataProfilesService");
    UserDataProfilesService = class UserDataProfilesService2 extends Disposable {
      static {
        this.PROFILES_KEY = "userDataProfiles";
      }
      static {
        this.PROFILE_ASSOCIATIONS_KEY = "profileAssociations";
      }
      get defaultProfile() {
        return this.profiles[0];
      }
      get profiles() {
        return [...this.profilesObject.profiles, ...this.transientProfilesObject.profiles];
      }
      constructor(environmentService, fileService, uriIdentityService, logService) {
        super();
        this.environmentService = environmentService;
        this.fileService = fileService;
        this.uriIdentityService = uriIdentityService;
        this.logService = logService;
        this._onDidChangeProfiles = this._register(new Emitter());
        this.onDidChangeProfiles = this._onDidChangeProfiles.event;
        this._onWillCreateProfile = this._register(new Emitter());
        this.onWillCreateProfile = this._onWillCreateProfile.event;
        this._onWillRemoveProfile = this._register(new Emitter());
        this.onWillRemoveProfile = this._onWillRemoveProfile.event;
        this._onDidResetWorkspaces = this._register(new Emitter());
        this.onDidResetWorkspaces = this._onDidResetWorkspaces.event;
        this.profileCreationPromises = /* @__PURE__ */ new Map();
        this.transientProfilesObject = {
          profiles: [],
          emptyWindows: /* @__PURE__ */ new Map()
        };
        this.profilesHome = joinPath(this.environmentService.userRoamingDataHome, "profiles");
        this.profilesCacheHome = joinPath(this.environmentService.cacheHome, "CachedProfilesData");
      }
      init() {
        this._profilesObject = void 0;
      }
      get profilesObject() {
        if (!this._profilesObject) {
          const defaultProfile = this.createDefaultProfile();
          const profiles = [defaultProfile];
          try {
            for (const storedProfile of this.getStoredProfiles()) {
              if (!storedProfile.name || !isString(storedProfile.name) || !storedProfile.location) {
                this.logService.warn("Skipping the invalid stored profile", storedProfile.location || storedProfile.name);
                continue;
              }
              profiles.push(toUserDataProfile(basename2(storedProfile.location), storedProfile.name, storedProfile.location, this.profilesCacheHome, { icon: storedProfile.icon, useDefaultFlags: storedProfile.useDefaultFlags }, defaultProfile));
            }
          } catch (error) {
            this.logService.error(error);
          }
          const emptyWindows = /* @__PURE__ */ new Map();
          if (profiles.length) {
            try {
              const profileAssociaitions = this.getStoredProfileAssociations();
              if (profileAssociaitions.workspaces) {
                for (const [workspacePath, profileId] of Object.entries(profileAssociaitions.workspaces)) {
                  const workspace = URI.parse(workspacePath);
                  const profile = profiles.find((p) => p.id === profileId);
                  if (profile) {
                    const workspaces = profile.workspaces ? profile.workspaces.slice(0) : [];
                    workspaces.push(workspace);
                    profile.workspaces = workspaces;
                  }
                }
              }
              if (profileAssociaitions.emptyWindows) {
                for (const [windowId, profileId] of Object.entries(profileAssociaitions.emptyWindows)) {
                  const profile = profiles.find((p) => p.id === profileId);
                  if (profile) {
                    emptyWindows.set(windowId, profile);
                  }
                }
              }
            } catch (error) {
              this.logService.error(error);
            }
          }
          this._profilesObject = { profiles, emptyWindows };
        }
        return this._profilesObject;
      }
      createDefaultProfile() {
        const defaultProfile = toUserDataProfile("__default__profile__", localize(2614, null), this.environmentService.userRoamingDataHome, this.profilesCacheHome);
        return { ...defaultProfile, extensionsResource: this.getDefaultProfileExtensionsLocation() ?? defaultProfile.extensionsResource, isDefault: true };
      }
      async createTransientProfile(workspaceIdentifier) {
        const namePrefix = `Temp`;
        const nameRegEx = new RegExp(`${escapeRegExpCharacters(namePrefix)}\\s(\\d+)`);
        let nameIndex = 0;
        for (const profile of this.profiles) {
          const matches = nameRegEx.exec(profile.name);
          const index = matches ? parseInt(matches[1]) : 0;
          nameIndex = index > nameIndex ? index : nameIndex;
        }
        const name = `${namePrefix} ${nameIndex + 1}`;
        return this.createProfile(hash(generateUuid()).toString(16), name, { transient: true }, workspaceIdentifier);
      }
      async createNamedProfile(name, options, workspaceIdentifier) {
        return this.createProfile(hash(generateUuid()).toString(16), name, options, workspaceIdentifier);
      }
      async createProfile(id2, name, options, workspaceIdentifier) {
        const profile = await this.doCreateProfile(id2, name, options, workspaceIdentifier);
        return profile;
      }
      async doCreateProfile(id2, name, options, workspaceIdentifier) {
        if (!isString(name) || !name) {
          throw new Error("Name of the profile is mandatory and must be of type `string`");
        }
        let profileCreationPromise = this.profileCreationPromises.get(name);
        if (!profileCreationPromise) {
          profileCreationPromise = (async () => {
            try {
              const existing = this.profiles.find((p) => p.id === id2 || !p.isTransient && !options?.transient && p.name === name);
              if (existing) {
                throw new Error(`Profile with ${name} name already exists`);
              }
              const workspace = workspaceIdentifier ? this.getWorkspace(workspaceIdentifier) : void 0;
              if (URI.isUri(workspace)) {
                options = { ...options, workspaces: [workspace] };
              }
              const profile = toUserDataProfile(id2, name, joinPath(this.profilesHome, id2), this.profilesCacheHome, options, this.defaultProfile);
              await this.fileService.createFolder(profile.location);
              const joiners = [];
              this._onWillCreateProfile.fire({
                profile,
                join(promise) {
                  joiners.push(promise);
                }
              });
              await Promises.settled(joiners);
              if (workspace && !URI.isUri(workspace)) {
                this.updateEmptyWindowAssociation(workspace, profile, !!profile.isTransient);
              }
              this.updateProfiles([profile], [], []);
              return profile;
            } finally {
              this.profileCreationPromises.delete(name);
            }
          })();
          this.profileCreationPromises.set(name, profileCreationPromise);
        }
        return profileCreationPromise;
      }
      async updateProfile(profile, options) {
        const profilesToUpdate = [];
        for (const existing of this.profiles) {
          let profileToUpdate;
          if (profile.id === existing.id) {
            if (!existing.isDefault) {
              profileToUpdate = toUserDataProfile(existing.id, options.name ?? existing.name, existing.location, this.profilesCacheHome, {
                icon: options.icon === null ? void 0 : options.icon ?? existing.icon,
                transient: options.transient ?? existing.isTransient,
                useDefaultFlags: options.useDefaultFlags ?? existing.useDefaultFlags,
                workspaces: options.workspaces ?? existing.workspaces
              }, this.defaultProfile);
            } else if (options.workspaces) {
              profileToUpdate = existing;
              profileToUpdate.workspaces = options.workspaces;
            }
          } else if (options.workspaces) {
            const workspaces = existing.workspaces?.filter((w1) => !options.workspaces?.some((w2) => this.uriIdentityService.extUri.isEqual(w1, w2)));
            if (existing.workspaces?.length !== workspaces?.length) {
              profileToUpdate = existing;
              profileToUpdate.workspaces = workspaces;
            }
          }
          if (profileToUpdate) {
            profilesToUpdate.push(profileToUpdate);
          }
        }
        if (!profilesToUpdate.length) {
          if (profile.isDefault) {
            throw new Error("Cannot update default profile");
          }
          throw new Error(`Profile '${profile.name}' does not exist`);
        }
        this.updateProfiles([], [], profilesToUpdate);
        const updatedProfile = this.profiles.find((p) => p.id === profile.id);
        if (!updatedProfile) {
          throw new Error(`Profile '${profile.name}' was not updated`);
        }
        return updatedProfile;
      }
      async removeProfile(profileToRemove) {
        if (profileToRemove.isDefault) {
          throw new Error("Cannot remove default profile");
        }
        const profile = this.profiles.find((p) => p.id === profileToRemove.id);
        if (!profile) {
          throw new Error(`Profile '${profileToRemove.name}' does not exist`);
        }
        const joiners = [];
        this._onWillRemoveProfile.fire({
          profile,
          join(promise) {
            joiners.push(promise);
          }
        });
        try {
          await Promise.allSettled(joiners);
        } catch (error) {
          this.logService.error(error);
        }
        this.updateProfiles([], [profile], []);
        try {
          await this.fileService.del(profile.cacheHome, { recursive: true });
        } catch (error) {
          if (toFileOperationResult(error) !== 1) {
            this.logService.error(error);
          }
        }
      }
      async setProfileForWorkspace(workspaceIdentifier, profileToSet) {
        const profile = this.profiles.find((p) => p.id === profileToSet.id);
        if (!profile) {
          throw new Error(`Profile '${profileToSet.name}' does not exist`);
        }
        const workspace = this.getWorkspace(workspaceIdentifier);
        if (URI.isUri(workspace)) {
          const workspaces = profile.workspaces ? [...profile.workspaces] : [];
          if (!workspaces.some((w) => this.uriIdentityService.extUri.isEqual(w, workspace))) {
            workspaces.push(workspace);
            await this.updateProfile(profile, { workspaces });
          }
        } else {
          this.updateEmptyWindowAssociation(workspace, profile, false);
          this.updateStoredProfiles(this.profiles);
        }
      }
      unsetWorkspace(workspaceIdentifier, transient = false) {
        const workspace = this.getWorkspace(workspaceIdentifier);
        if (URI.isUri(workspace)) {
          const currentlyAssociatedProfile = this.getProfileForWorkspace(workspaceIdentifier);
          if (currentlyAssociatedProfile) {
            this.updateProfile(currentlyAssociatedProfile, { workspaces: currentlyAssociatedProfile.workspaces?.filter((w) => !this.uriIdentityService.extUri.isEqual(w, workspace)) });
          }
        } else {
          this.updateEmptyWindowAssociation(workspace, void 0, transient);
          this.updateStoredProfiles(this.profiles);
        }
      }
      async resetWorkspaces() {
        this.transientProfilesObject.emptyWindows.clear();
        this.profilesObject.emptyWindows.clear();
        for (const profile of this.profiles) {
          profile.workspaces = void 0;
        }
        this.updateProfiles([], [], this.profiles);
        this._onDidResetWorkspaces.fire();
      }
      async cleanUp() {
        if (await this.fileService.exists(this.profilesHome)) {
          const stat = await this.fileService.resolve(this.profilesHome);
          await Promise.all((stat.children || []).filter((child) => child.isDirectory && this.profiles.every((p) => !this.uriIdentityService.extUri.isEqual(p.location, child.resource))).map((child) => this.fileService.del(child.resource, { recursive: true })));
        }
      }
      async cleanUpTransientProfiles() {
        const unAssociatedTransientProfiles = this.transientProfilesObject.profiles.filter((p) => !this.isProfileAssociatedToWorkspace(p));
        await Promise.allSettled(unAssociatedTransientProfiles.map((p) => this.removeProfile(p)));
      }
      getProfileForWorkspace(workspaceIdentifier) {
        const workspace = this.getWorkspace(workspaceIdentifier);
        return URI.isUri(workspace) ? this.profiles.find((p) => p.workspaces?.some((w) => this.uriIdentityService.extUri.isEqual(w, workspace))) : this.profilesObject.emptyWindows.get(workspace) ?? this.transientProfilesObject.emptyWindows.get(workspace);
      }
      getWorkspace(workspaceIdentifier) {
        if (isSingleFolderWorkspaceIdentifier(workspaceIdentifier)) {
          return workspaceIdentifier.uri;
        }
        if (isWorkspaceIdentifier(workspaceIdentifier)) {
          return workspaceIdentifier.configPath;
        }
        return workspaceIdentifier.id;
      }
      isProfileAssociatedToWorkspace(profile) {
        if (profile.workspaces?.length) {
          return true;
        }
        if ([...this.profilesObject.emptyWindows.values()].some((windowProfile) => this.uriIdentityService.extUri.isEqual(windowProfile.location, profile.location))) {
          return true;
        }
        if ([...this.transientProfilesObject.emptyWindows.values()].some((windowProfile) => this.uriIdentityService.extUri.isEqual(windowProfile.location, profile.location))) {
          return true;
        }
        return false;
      }
      updateProfiles(added, removed, updated) {
        const allProfiles = [...this.profiles, ...added];
        const transientProfiles = this.transientProfilesObject.profiles;
        this.transientProfilesObject.profiles = [];
        const profiles = [];
        for (let profile of allProfiles) {
          if (removed.some((p) => profile.id === p.id)) {
            for (const windowId of [...this.profilesObject.emptyWindows.keys()]) {
              if (profile.id === this.profilesObject.emptyWindows.get(windowId)?.id) {
                this.profilesObject.emptyWindows.delete(windowId);
              }
            }
            continue;
          }
          if (!profile.isDefault) {
            profile = updated.find((p) => profile.id === p.id) ?? profile;
            const transientProfile = transientProfiles.find((p) => profile.id === p.id);
            if (profile.isTransient) {
              this.transientProfilesObject.profiles.push(profile);
            } else {
              if (transientProfile) {
                for (const [windowId, p] of this.transientProfilesObject.emptyWindows.entries()) {
                  if (profile.id === p.id) {
                    this.transientProfilesObject.emptyWindows.delete(windowId);
                    this.profilesObject.emptyWindows.set(windowId, profile);
                    break;
                  }
                }
              }
            }
          }
          if (profile.workspaces?.length === 0) {
            profile.workspaces = void 0;
          }
          profiles.push(profile);
        }
        this.updateStoredProfiles(profiles);
        this.triggerProfilesChanges(added, removed, updated);
      }
      triggerProfilesChanges(added, removed, updated) {
        this._onDidChangeProfiles.fire({ added, removed, updated, all: this.profiles });
      }
      updateEmptyWindowAssociation(windowId, newProfile, transient) {
        transient = newProfile?.isTransient ? true : transient;
        if (transient) {
          if (newProfile) {
            this.transientProfilesObject.emptyWindows.set(windowId, newProfile);
          } else {
            this.transientProfilesObject.emptyWindows.delete(windowId);
          }
        } else {
          this.transientProfilesObject.emptyWindows.delete(windowId);
          if (newProfile) {
            this.profilesObject.emptyWindows.set(windowId, newProfile);
          } else {
            this.profilesObject.emptyWindows.delete(windowId);
          }
        }
      }
      updateStoredProfiles(profiles) {
        const storedProfiles = [];
        const workspaces = {};
        const emptyWindows = {};
        for (const profile of profiles) {
          if (profile.isTransient) {
            continue;
          }
          if (!profile.isDefault) {
            storedProfiles.push({ location: profile.location, name: profile.name, icon: profile.icon, useDefaultFlags: profile.useDefaultFlags });
          }
          if (profile.workspaces) {
            for (const workspace of profile.workspaces) {
              workspaces[workspace.toString()] = profile.id;
            }
          }
        }
        for (const [windowId, profile] of this.profilesObject.emptyWindows.entries()) {
          emptyWindows[windowId.toString()] = profile.id;
        }
        this.saveStoredProfileAssociations({ workspaces, emptyWindows });
        this.saveStoredProfiles(storedProfiles);
        this._profilesObject = void 0;
      }
      getStoredProfiles() {
        return [];
      }
      saveStoredProfiles(storedProfiles) {
        throw new Error("not implemented");
      }
      getStoredProfileAssociations() {
        return {};
      }
      saveStoredProfileAssociations(storedProfileAssociations) {
        throw new Error("not implemented");
      }
      getDefaultProfileExtensionsLocation() {
        return void 0;
      }
    };
    UserDataProfilesService = __decorate([
      __param(0, IEnvironmentService),
      __param(1, IFileService),
      __param(2, IUriIdentityService),
      __param(3, ILogService)
    ], UserDataProfilesService);
  }
});

// out-build/vs/platform/storage/common/storage.js
function loadKeyTargets(storage) {
  const keysRaw = storage.get(TARGET_KEY);
  if (keysRaw) {
    try {
      return JSON.parse(keysRaw);
    } catch (error) {
    }
  }
  return /* @__PURE__ */ Object.create(null);
}
function isProfileUsingDefaultStorage(profile) {
  return profile.isDefault || !!profile.useDefaultFlags?.globalState;
}
async function logStorage(application, profile, workspace, applicationPath, profilePath, workspacePath) {
  const safeParse = (value) => {
    try {
      return JSON.parse(value);
    } catch (error) {
      return value;
    }
  };
  const applicationItems = /* @__PURE__ */ new Map();
  const applicationItemsParsed = /* @__PURE__ */ new Map();
  application.forEach((value, key) => {
    applicationItems.set(key, value);
    applicationItemsParsed.set(key, safeParse(value));
  });
  const profileItems = /* @__PURE__ */ new Map();
  const profileItemsParsed = /* @__PURE__ */ new Map();
  profile.forEach((value, key) => {
    profileItems.set(key, value);
    profileItemsParsed.set(key, safeParse(value));
  });
  const workspaceItems = /* @__PURE__ */ new Map();
  const workspaceItemsParsed = /* @__PURE__ */ new Map();
  workspace.forEach((value, key) => {
    workspaceItems.set(key, value);
    workspaceItemsParsed.set(key, safeParse(value));
  });
  if (applicationPath !== profilePath) {
    console.group(`Storage: Application (path: ${applicationPath})`);
  } else {
    console.group(`Storage: Application & Profile (path: ${applicationPath}, default profile)`);
  }
  const applicationValues = [];
  applicationItems.forEach((value, key) => {
    applicationValues.push({ key, value });
  });
  console.table(applicationValues);
  console.groupEnd();
  console.log(applicationItemsParsed);
  if (applicationPath !== profilePath) {
    console.group(`Storage: Profile (path: ${profilePath}, profile specific)`);
    const profileValues = [];
    profileItems.forEach((value, key) => {
      profileValues.push({ key, value });
    });
    console.table(profileValues);
    console.groupEnd();
    console.log(profileItemsParsed);
  }
  console.group(`Storage: Workspace (path: ${workspacePath})`);
  const workspaceValues = [];
  workspaceItems.forEach((value, key) => {
    workspaceValues.push({ key, value });
  });
  console.table(workspaceValues);
  console.groupEnd();
  console.log(workspaceItemsParsed);
}
var IS_NEW_KEY, TARGET_KEY, IStorageService, WillSaveStateReason, StorageScope, StorageTarget, AbstractStorageService;
var init_storage2 = __esm({
  "out-build/vs/platform/storage/common/storage.js"() {
    "use strict";
    init_async();
    init_event();
    init_lifecycle();
    init_performance();
    init_types();
    init_storage();
    init_instantiation();
    init_userDataProfile();
    IS_NEW_KEY = "__$__isNewStorageMarker";
    TARGET_KEY = "__$__targetStorageMarker";
    IStorageService = createDecorator("storageService");
    (function(WillSaveStateReason2) {
      WillSaveStateReason2[WillSaveStateReason2["NONE"] = 0] = "NONE";
      WillSaveStateReason2[WillSaveStateReason2["SHUTDOWN"] = 1] = "SHUTDOWN";
    })(WillSaveStateReason || (WillSaveStateReason = {}));
    (function(StorageScope2) {
      StorageScope2[StorageScope2["APPLICATION"] = -1] = "APPLICATION";
      StorageScope2[StorageScope2["PROFILE"] = 0] = "PROFILE";
      StorageScope2[StorageScope2["WORKSPACE"] = 1] = "WORKSPACE";
    })(StorageScope || (StorageScope = {}));
    (function(StorageTarget2) {
      StorageTarget2[StorageTarget2["USER"] = 0] = "USER";
      StorageTarget2[StorageTarget2["MACHINE"] = 1] = "MACHINE";
    })(StorageTarget || (StorageTarget = {}));
    AbstractStorageService = class _AbstractStorageService extends Disposable {
      static {
        this.DEFAULT_FLUSH_INTERVAL = 60 * 1e3;
      }
      // every minute
      constructor(options = { flushInterval: _AbstractStorageService.DEFAULT_FLUSH_INTERVAL }) {
        super();
        this._onDidChangeValue = this._register(new PauseableEmitter());
        this._onDidChangeTarget = this._register(new PauseableEmitter());
        this.onDidChangeTarget = this._onDidChangeTarget.event;
        this._onWillSaveState = this._register(new Emitter());
        this.onWillSaveState = this._onWillSaveState.event;
        this.runFlushWhenIdle = this._register(new MutableDisposable());
        this._workspaceKeyTargets = void 0;
        this._profileKeyTargets = void 0;
        this._applicationKeyTargets = void 0;
        this.flushWhenIdleScheduler = this._register(new RunOnceScheduler(() => this.doFlushWhenIdle(), options.flushInterval));
      }
      onDidChangeValue(scope, key, disposable) {
        return Event.filter(this._onDidChangeValue.event, (e) => e.scope === scope && (key === void 0 || e.key === key), disposable);
      }
      doFlushWhenIdle() {
        this.runFlushWhenIdle.value = runWhenGlobalIdle(() => {
          if (this.shouldFlushWhenIdle()) {
            this.flush();
          }
          this.flushWhenIdleScheduler.schedule();
        });
      }
      shouldFlushWhenIdle() {
        return true;
      }
      stopFlushWhenIdle() {
        dispose([this.runFlushWhenIdle, this.flushWhenIdleScheduler]);
      }
      initialize() {
        if (!this.initializationPromise) {
          this.initializationPromise = (async () => {
            mark("code/willInitStorage");
            try {
              await this.doInitialize();
            } finally {
              mark("code/didInitStorage");
            }
            this.flushWhenIdleScheduler.schedule();
          })();
        }
        return this.initializationPromise;
      }
      emitDidChangeValue(scope, event) {
        const { key, external } = event;
        if (key === TARGET_KEY) {
          switch (scope) {
            case -1:
              this._applicationKeyTargets = void 0;
              break;
            case 0:
              this._profileKeyTargets = void 0;
              break;
            case 1:
              this._workspaceKeyTargets = void 0;
              break;
          }
          this._onDidChangeTarget.fire({ scope });
        } else {
          this._onDidChangeValue.fire({ scope, key, target: this.getKeyTargets(scope)[key], external });
        }
      }
      emitWillSaveState(reason) {
        this._onWillSaveState.fire({ reason });
      }
      get(key, scope, fallbackValue) {
        return this.getStorage(scope)?.get(key, fallbackValue);
      }
      getBoolean(key, scope, fallbackValue) {
        return this.getStorage(scope)?.getBoolean(key, fallbackValue);
      }
      getNumber(key, scope, fallbackValue) {
        return this.getStorage(scope)?.getNumber(key, fallbackValue);
      }
      getObject(key, scope, fallbackValue) {
        return this.getStorage(scope)?.getObject(key, fallbackValue);
      }
      storeAll(entries, external) {
        this.withPausedEmitters(() => {
          for (const entry of entries) {
            this.store(entry.key, entry.value, entry.scope, entry.target, external);
          }
        });
      }
      store(key, value, scope, target, external = false) {
        if (isUndefinedOrNull(value)) {
          this.remove(key, scope, external);
          return;
        }
        this.withPausedEmitters(() => {
          this.updateKeyTarget(key, scope, target);
          this.getStorage(scope)?.set(key, value, external);
        });
      }
      remove(key, scope, external = false) {
        this.withPausedEmitters(() => {
          this.updateKeyTarget(key, scope, void 0);
          this.getStorage(scope)?.delete(key, external);
        });
      }
      withPausedEmitters(fn) {
        this._onDidChangeValue.pause();
        this._onDidChangeTarget.pause();
        try {
          fn();
        } finally {
          this._onDidChangeValue.resume();
          this._onDidChangeTarget.resume();
        }
      }
      keys(scope, target) {
        const keys = [];
        const keyTargets = this.getKeyTargets(scope);
        for (const key of Object.keys(keyTargets)) {
          const keyTarget = keyTargets[key];
          if (keyTarget === target) {
            keys.push(key);
          }
        }
        return keys;
      }
      updateKeyTarget(key, scope, target, external = false) {
        const keyTargets = this.getKeyTargets(scope);
        if (typeof target === "number") {
          if (keyTargets[key] !== target) {
            keyTargets[key] = target;
            this.getStorage(scope)?.set(TARGET_KEY, JSON.stringify(keyTargets), external);
          }
        } else {
          if (typeof keyTargets[key] === "number") {
            delete keyTargets[key];
            this.getStorage(scope)?.set(TARGET_KEY, JSON.stringify(keyTargets), external);
          }
        }
      }
      get workspaceKeyTargets() {
        if (!this._workspaceKeyTargets) {
          this._workspaceKeyTargets = this.loadKeyTargets(
            1
            /* StorageScope.WORKSPACE */
          );
        }
        return this._workspaceKeyTargets;
      }
      get profileKeyTargets() {
        if (!this._profileKeyTargets) {
          this._profileKeyTargets = this.loadKeyTargets(
            0
            /* StorageScope.PROFILE */
          );
        }
        return this._profileKeyTargets;
      }
      get applicationKeyTargets() {
        if (!this._applicationKeyTargets) {
          this._applicationKeyTargets = this.loadKeyTargets(
            -1
            /* StorageScope.APPLICATION */
          );
        }
        return this._applicationKeyTargets;
      }
      getKeyTargets(scope) {
        switch (scope) {
          case -1:
            return this.applicationKeyTargets;
          case 0:
            return this.profileKeyTargets;
          default:
            return this.workspaceKeyTargets;
        }
      }
      loadKeyTargets(scope) {
        const storage = this.getStorage(scope);
        return storage ? loadKeyTargets(storage) : /* @__PURE__ */ Object.create(null);
      }
      isNew(scope) {
        return this.getBoolean(IS_NEW_KEY, scope) === true;
      }
      async flush(reason = WillSaveStateReason.NONE) {
        this._onWillSaveState.fire({ reason });
        const applicationStorage = this.getStorage(
          -1
          /* StorageScope.APPLICATION */
        );
        const profileStorage = this.getStorage(
          0
          /* StorageScope.PROFILE */
        );
        const workspaceStorage = this.getStorage(
          1
          /* StorageScope.WORKSPACE */
        );
        switch (reason) {
          // Unspecific reason: just wait when data is flushed
          case WillSaveStateReason.NONE:
            await Promises.settled([
              applicationStorage?.whenFlushed() ?? Promise.resolve(),
              profileStorage?.whenFlushed() ?? Promise.resolve(),
              workspaceStorage?.whenFlushed() ?? Promise.resolve()
            ]);
            break;
          // Shutdown: we want to flush as soon as possible
          // and not hit any delays that might be there
          case WillSaveStateReason.SHUTDOWN:
            await Promises.settled([
              applicationStorage?.flush(0) ?? Promise.resolve(),
              profileStorage?.flush(0) ?? Promise.resolve(),
              workspaceStorage?.flush(0) ?? Promise.resolve()
            ]);
            break;
        }
      }
      async log() {
        const applicationItems = this.getStorage(
          -1
          /* StorageScope.APPLICATION */
        )?.items ?? /* @__PURE__ */ new Map();
        const profileItems = this.getStorage(
          0
          /* StorageScope.PROFILE */
        )?.items ?? /* @__PURE__ */ new Map();
        const workspaceItems = this.getStorage(
          1
          /* StorageScope.WORKSPACE */
        )?.items ?? /* @__PURE__ */ new Map();
        return logStorage(applicationItems, profileItems, workspaceItems, this.getLogDetails(
          -1
          /* StorageScope.APPLICATION */
        ) ?? "", this.getLogDetails(
          0
          /* StorageScope.PROFILE */
        ) ?? "", this.getLogDetails(
          1
          /* StorageScope.WORKSPACE */
        ) ?? "");
      }
      async optimize(scope) {
        await this.flush();
        return this.getStorage(scope)?.optimize();
      }
      async switch(to, preserveData) {
        this.emitWillSaveState(WillSaveStateReason.NONE);
        if (isUserDataProfile(to)) {
          return this.switchToProfile(to, preserveData);
        }
        return this.switchToWorkspace(to, preserveData);
      }
      canSwitchProfile(from, to) {
        if (from.id === to.id) {
          return false;
        }
        if (isProfileUsingDefaultStorage(to) && isProfileUsingDefaultStorage(from)) {
          return false;
        }
        return true;
      }
      switchData(oldStorage, newStorage, scope) {
        this.withPausedEmitters(() => {
          const handledkeys = /* @__PURE__ */ new Set();
          for (const [key, oldValue] of oldStorage) {
            handledkeys.add(key);
            const newValue = newStorage.get(key);
            if (newValue !== oldValue) {
              this.emitDidChangeValue(scope, { key, external: true });
            }
          }
          for (const [key] of newStorage.items) {
            if (!handledkeys.has(key)) {
              this.emitDidChangeValue(scope, { key, external: true });
            }
          }
        });
      }
    };
  }
});

// out-build/vs/base/parts/storage/node/storage.js
import * as fs4 from "fs";
var SQLiteStorageDatabase, SQLiteStorageDatabaseLogger;
var init_storage3 = __esm({
  "out-build/vs/base/parts/storage/node/storage.js"() {
    "use strict";
    init_async();
    init_event();
    init_map();
    init_path();
    init_pfs();
    SQLiteStorageDatabase = class _SQLiteStorageDatabase {
      static {
        this.IN_MEMORY_PATH = ":memory:";
      }
      get onDidChangeItemsExternal() {
        return Event.None;
      }
      static {
        this.BUSY_OPEN_TIMEOUT = 2e3;
      }
      static {
        this.MAX_HOST_PARAMETERS = 256;
      }
      // maximum number of parameters within a statement
      constructor(path4, options = /* @__PURE__ */ Object.create(null)) {
        this.path = path4;
        this.name = basename(this.path);
        this.logger = new SQLiteStorageDatabaseLogger(options.logging);
        this.whenConnected = this.connect(this.path);
      }
      async getItems() {
        const connection = await this.whenConnected;
        const items = /* @__PURE__ */ new Map();
        const rows = await this.all(connection, "SELECT * FROM ItemTable");
        rows.forEach((row) => items.set(row.key, row.value));
        if (this.logger.isTracing) {
          this.logger.trace(`[storage ${this.name}] getItems(): ${items.size} rows`);
        }
        return items;
      }
      async updateItems(request) {
        const connection = await this.whenConnected;
        return this.doUpdateItems(connection, request);
      }
      doUpdateItems(connection, request) {
        if (this.logger.isTracing) {
          this.logger.trace(`[storage ${this.name}] updateItems(): insert(${request.insert ? mapToString(request.insert) : "0"}), delete(${request.delete ? setToString(request.delete) : "0"})`);
        }
        return this.transaction(connection, () => {
          const toInsert = request.insert;
          const toDelete = request.delete;
          if (toInsert && toInsert.size > 0) {
            const keysValuesChunks = [];
            keysValuesChunks.push([]);
            let currentChunkIndex = 0;
            toInsert.forEach((value, key) => {
              let keyValueChunk = keysValuesChunks[currentChunkIndex];
              if (keyValueChunk.length > _SQLiteStorageDatabase.MAX_HOST_PARAMETERS) {
                currentChunkIndex++;
                keyValueChunk = [];
                keysValuesChunks.push(keyValueChunk);
              }
              keyValueChunk.push(key, value);
            });
            keysValuesChunks.forEach((keysValuesChunk) => {
              this.prepare(connection, `INSERT INTO ItemTable VALUES ${new Array(keysValuesChunk.length / 2).fill("(?,?)").join(",")}`, (stmt) => stmt.run(keysValuesChunk), () => {
                const keys = [];
                let length = 0;
                toInsert.forEach((value, key) => {
                  keys.push(key);
                  length += value.length;
                });
                return `Keys: ${keys.join(", ")} Length: ${length}`;
              });
            });
          }
          if (toDelete && toDelete.size) {
            const keysChunks = [];
            keysChunks.push([]);
            let currentChunkIndex = 0;
            toDelete.forEach((key) => {
              let keyChunk = keysChunks[currentChunkIndex];
              if (keyChunk.length > _SQLiteStorageDatabase.MAX_HOST_PARAMETERS) {
                currentChunkIndex++;
                keyChunk = [];
                keysChunks.push(keyChunk);
              }
              keyChunk.push(key);
            });
            keysChunks.forEach((keysChunk) => {
              this.prepare(connection, `DELETE FROM ItemTable WHERE key IN (${new Array(keysChunk.length).fill("?").join(",")})`, (stmt) => stmt.run(keysChunk), () => {
                const keys = [];
                toDelete.forEach((key) => {
                  keys.push(key);
                });
                return `Keys: ${keys.join(", ")}`;
              });
            });
          }
        });
      }
      async optimize() {
        this.logger.trace(`[storage ${this.name}] vacuum()`);
        const connection = await this.whenConnected;
        return this.exec(connection, "VACUUM");
      }
      async close(recovery) {
        this.logger.trace(`[storage ${this.name}] close()`);
        const connection = await this.whenConnected;
        return this.doClose(connection, recovery);
      }
      doClose(connection, recovery) {
        return new Promise((resolve3, reject) => {
          connection.db.close((closeError) => {
            if (closeError) {
              this.handleSQLiteError(connection, `[storage ${this.name}] close(): ${closeError}`);
            }
            if (this.path === _SQLiteStorageDatabase.IN_MEMORY_PATH) {
              return resolve3();
            }
            if (!connection.isErroneous && !connection.isInMemory) {
              return this.backup().then(resolve3, (error) => {
                this.logger.error(`[storage ${this.name}] backup(): ${error}`);
                return resolve3();
              });
            }
            if (typeof recovery === "function") {
              return fs4.promises.unlink(this.path).then(() => {
                return this.doConnect(this.path).then((recoveryConnection) => {
                  const closeRecoveryConnection = () => {
                    return this.doClose(
                      recoveryConnection,
                      void 0
                      /* do not attempt to recover again */
                    );
                  };
                  return this.doUpdateItems(recoveryConnection, { insert: recovery() }).then(() => closeRecoveryConnection(), (error) => {
                    closeRecoveryConnection();
                    return Promise.reject(error);
                  });
                });
              }).then(resolve3, reject);
            }
            return reject(closeError || new Error("Database has errors or is in-memory without recovery option"));
          });
        });
      }
      backup() {
        const backupPath = this.toBackupPath(this.path);
        return Promises2.copy(this.path, backupPath, { preserveSymlinks: false });
      }
      toBackupPath(path4) {
        return `${path4}.backup`;
      }
      async checkIntegrity(full) {
        this.logger.trace(`[storage ${this.name}] checkIntegrity(full: ${full})`);
        const connection = await this.whenConnected;
        const row = await this.get(connection, full ? "PRAGMA integrity_check" : "PRAGMA quick_check");
        const integrity = full ? row["integrity_check"] : row["quick_check"];
        if (connection.isErroneous) {
          return `${integrity} (last error: ${connection.lastError})`;
        }
        if (connection.isInMemory) {
          return `${integrity} (in-memory!)`;
        }
        return integrity;
      }
      async connect(path4, retryOnBusy = true) {
        this.logger.trace(`[storage ${this.name}] open(${path4}, retryOnBusy: ${retryOnBusy})`);
        try {
          return await this.doConnect(path4);
        } catch (error) {
          this.logger.error(`[storage ${this.name}] open(): Unable to open DB due to ${error}`);
          if (error.code === "SQLITE_BUSY" && retryOnBusy) {
            await timeout(_SQLiteStorageDatabase.BUSY_OPEN_TIMEOUT);
            return this.connect(
              path4,
              false
              /* not another retry */
            );
          }
          try {
            await fs4.promises.unlink(path4);
            try {
              await Promises2.rename(
                this.toBackupPath(path4),
                path4,
                false
                /* no retry */
              );
            } catch (error2) {
            }
            return await this.doConnect(path4);
          } catch (error2) {
            this.logger.error(`[storage ${this.name}] open(): Unable to use backup due to ${error2}`);
            return this.doConnect(_SQLiteStorageDatabase.IN_MEMORY_PATH);
          }
        }
      }
      handleSQLiteError(connection, msg) {
        connection.isErroneous = true;
        connection.lastError = msg;
        this.logger.error(msg);
      }
      doConnect(path4) {
        return new Promise((resolve3, reject) => {
          import("@vscode/sqlite3").then((sqlite3) => {
            const ctor = this.logger.isTracing ? sqlite3.default.verbose().Database : sqlite3.default.Database;
            const connection = {
              db: new ctor(path4, (error) => {
                if (error) {
                  return connection.db && error.code !== "SQLITE_CANTOPEN" ? connection.db.close(() => reject(error)) : reject(error);
                }
                return this.exec(connection, [
                  "PRAGMA user_version = 1;",
                  "CREATE TABLE IF NOT EXISTS ItemTable (key TEXT UNIQUE ON CONFLICT REPLACE, value BLOB)"
                ].join("")).then(() => {
                  return resolve3(connection);
                }, (error2) => {
                  return connection.db.close(() => reject(error2));
                });
              }),
              isInMemory: path4 === _SQLiteStorageDatabase.IN_MEMORY_PATH
            };
            connection.db.on("error", (error) => this.handleSQLiteError(connection, `[storage ${this.name}] Error (event): ${error}`));
            if (this.logger.isTracing) {
              connection.db.on("trace", (sql) => this.logger.trace(`[storage ${this.name}] Trace (event): ${sql}`));
            }
          }, reject);
        });
      }
      exec(connection, sql) {
        return new Promise((resolve3, reject) => {
          connection.db.exec(sql, (error) => {
            if (error) {
              this.handleSQLiteError(connection, `[storage ${this.name}] exec(): ${error}`);
              return reject(error);
            }
            return resolve3();
          });
        });
      }
      get(connection, sql) {
        return new Promise((resolve3, reject) => {
          connection.db.get(sql, (error, row) => {
            if (error) {
              this.handleSQLiteError(connection, `[storage ${this.name}] get(): ${error}`);
              return reject(error);
            }
            return resolve3(row);
          });
        });
      }
      all(connection, sql) {
        return new Promise((resolve3, reject) => {
          connection.db.all(sql, (error, rows) => {
            if (error) {
              this.handleSQLiteError(connection, `[storage ${this.name}] all(): ${error}`);
              return reject(error);
            }
            return resolve3(rows);
          });
        });
      }
      transaction(connection, transactions) {
        return new Promise((resolve3, reject) => {
          connection.db.serialize(() => {
            connection.db.run("BEGIN TRANSACTION");
            transactions();
            connection.db.run("END TRANSACTION", (error) => {
              if (error) {
                this.handleSQLiteError(connection, `[storage ${this.name}] transaction(): ${error}`);
                return reject(error);
              }
              return resolve3();
            });
          });
        });
      }
      prepare(connection, sql, runCallback, errorDetails) {
        const stmt = connection.db.prepare(sql);
        const statementErrorListener = (error) => {
          this.handleSQLiteError(connection, `[storage ${this.name}] prepare(): ${error} (${sql}). Details: ${errorDetails()}`);
        };
        stmt.on("error", statementErrorListener);
        runCallback(stmt);
        stmt.finalize((error) => {
          if (error) {
            statementErrorListener(error);
          }
          stmt.removeListener("error", statementErrorListener);
        });
      }
    };
    SQLiteStorageDatabaseLogger = class _SQLiteStorageDatabaseLogger {
      static {
        this.VSCODE_TRACE_STORAGE = "VSCODE_TRACE_STORAGE";
      }
      constructor(options) {
        if (options && typeof options.logTrace === "function" && process.env[_SQLiteStorageDatabaseLogger.VSCODE_TRACE_STORAGE]) {
          this.logTrace = options.logTrace;
        }
        if (options && typeof options.logError === "function") {
          this.logError = options.logError;
        }
      }
      get isTracing() {
        return !!this.logTrace;
      }
      trace(msg) {
        this.logTrace?.(msg);
      }
      error(error) {
        this.logError?.(error);
      }
    };
  }
});

// out-build/vs/platform/telemetry/common/telemetry.js
var ITelemetryService, ICustomEndpointTelemetryService, currentSessionDateStorageKey, firstSessionDateStorageKey, lastSessionDateStorageKey, machineIdKey, sqmIdKey, devDeviceIdKey, TELEMETRY_SECTION_ID, TELEMETRY_SETTING_ID, TELEMETRY_CRASH_REPORTER_SETTING_ID, TELEMETRY_OLD_SETTING_ID, TelemetryLevel, TelemetryConfiguration;
var init_telemetry = __esm({
  "out-build/vs/platform/telemetry/common/telemetry.js"() {
    "use strict";
    init_instantiation();
    ITelemetryService = createDecorator("telemetryService");
    ICustomEndpointTelemetryService = createDecorator("customEndpointTelemetryService");
    currentSessionDateStorageKey = "telemetry.currentSessionDate";
    firstSessionDateStorageKey = "telemetry.firstSessionDate";
    lastSessionDateStorageKey = "telemetry.lastSessionDate";
    machineIdKey = "telemetry.machineId";
    sqmIdKey = "telemetry.sqmId";
    devDeviceIdKey = "telemetry.devDeviceId";
    TELEMETRY_SECTION_ID = "telemetry";
    TELEMETRY_SETTING_ID = "telemetry.telemetryLevel";
    TELEMETRY_CRASH_REPORTER_SETTING_ID = "telemetry.enableCrashReporter";
    TELEMETRY_OLD_SETTING_ID = "telemetry.enableTelemetry";
    (function(TelemetryLevel2) {
      TelemetryLevel2[TelemetryLevel2["NONE"] = 0] = "NONE";
      TelemetryLevel2[TelemetryLevel2["CRASH"] = 1] = "CRASH";
      TelemetryLevel2[TelemetryLevel2["ERROR"] = 2] = "ERROR";
      TelemetryLevel2[TelemetryLevel2["USAGE"] = 3] = "USAGE";
    })(TelemetryLevel || (TelemetryLevel = {}));
    (function(TelemetryConfiguration2) {
      TelemetryConfiguration2["OFF"] = "off";
      TelemetryConfiguration2["CRASH"] = "crash";
      TelemetryConfiguration2["ERROR"] = "error";
      TelemetryConfiguration2["ON"] = "all";
    })(TelemetryConfiguration || (TelemetryConfiguration = {}));
  }
});

// out-build/vs/platform/storage/electron-main/storageMain.js
import * as fs5 from "fs";
var BaseStorageMain, BaseProfileAwareStorageMain, ProfileStorageMain, ApplicationStorageMain, WorkspaceStorageMain, InMemoryStorageMain;
var init_storageMain = __esm({
  "out-build/vs/platform/storage/electron-main/storageMain.js"() {
    "use strict";
    init_arrays();
    init_async();
    init_event();
    init_lifecycle();
    init_path();
    init_stopwatch();
    init_uri();
    init_pfs();
    init_storage();
    init_storage3();
    init_log();
    init_storage2();
    init_telemetry();
    init_workspace();
    init_network();
    BaseStorageMain = class _BaseStorageMain extends Disposable {
      static {
        this.LOG_SLOW_CLOSE_THRESHOLD = 2e3;
      }
      get storage() {
        return this._storage;
      }
      constructor(logService, fileService) {
        super();
        this.logService = logService;
        this.fileService = fileService;
        this._onDidChangeStorage = this._register(new Emitter());
        this.onDidChangeStorage = this._onDidChangeStorage.event;
        this._onDidCloseStorage = this._register(new Emitter());
        this.onDidCloseStorage = this._onDidCloseStorage.event;
        this._storage = this._register(new Storage(new InMemoryStorageDatabase(), { hint: StorageHint.STORAGE_IN_MEMORY }));
        this.initializePromise = void 0;
        this.whenInitPromise = new DeferredPromise();
        this.whenInit = this.whenInitPromise.p;
        this.state = StorageState.None;
      }
      isInMemory() {
        return this._storage.isInMemory();
      }
      init() {
        if (!this.initializePromise) {
          this.initializePromise = (async () => {
            if (this.state !== StorageState.None) {
              return;
            }
            try {
              const storage = this._register(await this.doCreate());
              this._storage.dispose();
              this._storage = storage;
              this._register(storage.onDidChangeStorage((e) => this._onDidChangeStorage.fire(e)));
              await this.doInit(storage);
              const isNewStorage = storage.getBoolean(IS_NEW_KEY);
              if (isNewStorage === void 0) {
                storage.set(IS_NEW_KEY, true);
              } else if (isNewStorage) {
                storage.set(IS_NEW_KEY, false);
              }
            } catch (error) {
              this.logService.error(`[storage main] initialize(): Unable to init storage due to ${error}`);
            } finally {
              this.state = StorageState.Initialized;
              this.whenInitPromise.complete();
            }
          })();
        }
        return this.initializePromise;
      }
      createLoggingOptions() {
        return {
          logTrace: this.logService.getLevel() === LogLevel.Trace ? (msg) => this.logService.trace(msg) : void 0,
          logError: (error) => this.logService.error(error)
        };
      }
      doInit(storage) {
        return storage.init();
      }
      get items() {
        return this._storage.items;
      }
      get(key, fallbackValue) {
        return this._storage.get(key, fallbackValue);
      }
      set(key, value) {
        return this._storage.set(key, value);
      }
      delete(key) {
        return this._storage.delete(key);
      }
      optimize() {
        return this._storage.optimize();
      }
      async close() {
        const watch3 = new StopWatch(false);
        await this.doClose();
        watch3.stop();
        if (watch3.elapsed() > _BaseStorageMain.LOG_SLOW_CLOSE_THRESHOLD) {
          await this.logSlowClose(watch3);
        }
        this._onDidCloseStorage.fire();
      }
      async logSlowClose(watch3) {
        if (!this.path) {
          return;
        }
        try {
          const largestEntries = top(Array.from(this._storage.items.entries()).map(([key, value]) => ({ key, length: value.length })), (entryA, entryB) => entryB.length - entryA.length, 5).map((entry) => `${entry.key}:${entry.length}`).join(", ");
          const dbSize = (await this.fileService.stat(URI.file(this.path))).size;
          this.logService.warn(`[storage main] detected slow close() operation: Time: ${watch3.elapsed()}ms, DB size: ${dbSize}b, Large Keys: ${largestEntries}`);
        } catch (error) {
          this.logService.error("[storage main] figuring out stats for slow DB on close() resulted in an error", error);
        }
      }
      async doClose() {
        if (this.initializePromise) {
          await this.initializePromise;
        }
        this.state = StorageState.Closed;
        await this._storage.close();
      }
    };
    BaseProfileAwareStorageMain = class _BaseProfileAwareStorageMain extends BaseStorageMain {
      static {
        this.STORAGE_NAME = "state.vscdb";
      }
      get path() {
        if (!this.options.useInMemoryStorage) {
          return join3(this.profile.globalStorageHome.with({ scheme: Schemas.file }).fsPath, _BaseProfileAwareStorageMain.STORAGE_NAME);
        }
        return void 0;
      }
      constructor(profile, options, logService, fileService) {
        super(logService, fileService);
        this.profile = profile;
        this.options = options;
      }
      async doCreate() {
        return new Storage(new SQLiteStorageDatabase(this.path ?? SQLiteStorageDatabase.IN_MEMORY_PATH, {
          logging: this.createLoggingOptions()
        }), !this.path ? { hint: StorageHint.STORAGE_IN_MEMORY } : void 0);
      }
    };
    ProfileStorageMain = class extends BaseProfileAwareStorageMain {
      constructor(profile, options, logService, fileService) {
        super(profile, options, logService, fileService);
      }
    };
    ApplicationStorageMain = class extends BaseProfileAwareStorageMain {
      constructor(options, userDataProfileService, logService, fileService) {
        super(userDataProfileService.defaultProfile, options, logService, fileService);
      }
      async doInit(storage) {
        await super.doInit(storage);
        this.updateTelemetryState(storage);
      }
      updateTelemetryState(storage) {
        const firstSessionDate = storage.get(firstSessionDateStorageKey, void 0);
        if (firstSessionDate === void 0) {
          storage.set(firstSessionDateStorageKey, (/* @__PURE__ */ new Date()).toUTCString());
        }
        const lastSessionDate = storage.get(currentSessionDateStorageKey, void 0);
        const currentSessionDate = (/* @__PURE__ */ new Date()).toUTCString();
        storage.set(lastSessionDateStorageKey, typeof lastSessionDate === "undefined" ? null : lastSessionDate);
        storage.set(currentSessionDateStorageKey, currentSessionDate);
      }
    };
    WorkspaceStorageMain = class _WorkspaceStorageMain extends BaseStorageMain {
      static {
        this.WORKSPACE_STORAGE_NAME = "state.vscdb";
      }
      static {
        this.WORKSPACE_META_NAME = "workspace.json";
      }
      get path() {
        if (!this.options.useInMemoryStorage) {
          return join3(this.environmentService.workspaceStorageHome.with({ scheme: Schemas.file }).fsPath, this.workspace.id, _WorkspaceStorageMain.WORKSPACE_STORAGE_NAME);
        }
        return void 0;
      }
      constructor(workspace, options, logService, environmentService, fileService) {
        super(logService, fileService);
        this.workspace = workspace;
        this.options = options;
        this.environmentService = environmentService;
      }
      async doCreate() {
        const { storageFilePath, wasCreated } = await this.prepareWorkspaceStorageFolder();
        return new Storage(new SQLiteStorageDatabase(storageFilePath, {
          logging: this.createLoggingOptions()
        }), { hint: this.options.useInMemoryStorage ? StorageHint.STORAGE_IN_MEMORY : wasCreated ? StorageHint.STORAGE_DOES_NOT_EXIST : void 0 });
      }
      async prepareWorkspaceStorageFolder() {
        if (this.options.useInMemoryStorage) {
          return { storageFilePath: SQLiteStorageDatabase.IN_MEMORY_PATH, wasCreated: true };
        }
        const workspaceStorageFolderPath = join3(this.environmentService.workspaceStorageHome.with({ scheme: Schemas.file }).fsPath, this.workspace.id);
        const workspaceStorageDatabasePath = join3(workspaceStorageFolderPath, _WorkspaceStorageMain.WORKSPACE_STORAGE_NAME);
        const storageExists = await Promises2.exists(workspaceStorageFolderPath);
        if (storageExists) {
          return { storageFilePath: workspaceStorageDatabasePath, wasCreated: false };
        }
        await fs5.promises.mkdir(workspaceStorageFolderPath, { recursive: true });
        this.ensureWorkspaceStorageFolderMeta(workspaceStorageFolderPath);
        return { storageFilePath: workspaceStorageDatabasePath, wasCreated: true };
      }
      async ensureWorkspaceStorageFolderMeta(workspaceStorageFolderPath) {
        let meta = void 0;
        if (isSingleFolderWorkspaceIdentifier(this.workspace)) {
          meta = { folder: this.workspace.uri.toString() };
        } else if (isWorkspaceIdentifier(this.workspace)) {
          meta = { workspace: this.workspace.configPath.toString() };
        }
        if (meta) {
          try {
            const workspaceStorageMetaPath = join3(workspaceStorageFolderPath, _WorkspaceStorageMain.WORKSPACE_META_NAME);
            const storageExists = await Promises2.exists(workspaceStorageMetaPath);
            if (!storageExists) {
              await Promises2.writeFile(workspaceStorageMetaPath, JSON.stringify(meta, void 0, 2));
            }
          } catch (error) {
            this.logService.error(`[storage main] ensureWorkspaceStorageFolderMeta(): Unable to create workspace storage metadata due to ${error}`);
          }
        }
      }
    };
    InMemoryStorageMain = class extends BaseStorageMain {
      get path() {
        return void 0;
      }
      async doCreate() {
        return new Storage(new InMemoryStorageDatabase(), { hint: StorageHint.STORAGE_IN_MEMORY });
      }
    };
  }
});

// out-build/vs/platform/state/node/stateService.js
var SaveStrategy, FileStorage, StateReadonlyService, StateService;
var init_stateService = __esm({
  "out-build/vs/platform/state/node/stateService.js"() {
    "use strict";
    init_async();
    init_buffer();
    init_lifecycle();
    init_types();
    init_environment();
    init_files();
    init_log();
    (function(SaveStrategy2) {
      SaveStrategy2[SaveStrategy2["IMMEDIATE"] = 0] = "IMMEDIATE";
      SaveStrategy2[SaveStrategy2["DELAYED"] = 1] = "DELAYED";
    })(SaveStrategy || (SaveStrategy = {}));
    FileStorage = class extends Disposable {
      constructor(storagePath, saveStrategy, logService, fileService) {
        super();
        this.storagePath = storagePath;
        this.logService = logService;
        this.fileService = fileService;
        this.storage = /* @__PURE__ */ Object.create(null);
        this.lastSavedStorageContents = "";
        this.initializing = void 0;
        this.closing = void 0;
        this.flushDelayer = this._register(new ThrottledDelayer(
          saveStrategy === 0 ? 0 : 100
          /* buffer saves over a short time */
        ));
      }
      init() {
        if (!this.initializing) {
          this.initializing = this.doInit();
        }
        return this.initializing;
      }
      async doInit() {
        try {
          this.lastSavedStorageContents = (await this.fileService.readFile(this.storagePath)).value.toString();
          this.storage = JSON.parse(this.lastSavedStorageContents);
        } catch (error) {
          if (error.fileOperationResult !== 1) {
            this.logService.error(error);
          }
        }
      }
      getItem(key, defaultValue) {
        const res = this.storage[key];
        if (isUndefinedOrNull(res)) {
          return defaultValue;
        }
        return res;
      }
      setItem(key, data) {
        this.setItems([{ key, data }]);
      }
      setItems(items) {
        let save = false;
        for (const { key, data } of items) {
          if (this.storage[key] === data) {
            continue;
          }
          if (isUndefinedOrNull(data)) {
            if (!isUndefined(this.storage[key])) {
              this.storage[key] = void 0;
              save = true;
            }
          } else {
            this.storage[key] = data;
            save = true;
          }
        }
        if (save) {
          this.save();
        }
      }
      removeItem(key) {
        if (!isUndefined(this.storage[key])) {
          this.storage[key] = void 0;
          this.save();
        }
      }
      async save() {
        if (this.closing) {
          return;
        }
        return this.flushDelayer.trigger(() => this.doSave());
      }
      async doSave() {
        if (!this.initializing) {
          return;
        }
        await this.initializing;
        const serializedDatabase = JSON.stringify(this.storage, null, 4);
        if (serializedDatabase === this.lastSavedStorageContents) {
          return;
        }
        try {
          await this.fileService.writeFile(this.storagePath, VSBuffer.fromString(serializedDatabase), { atomic: { postfix: ".vsctmp" } });
          this.lastSavedStorageContents = serializedDatabase;
        } catch (error) {
          this.logService.error(error);
        }
      }
      async close() {
        if (!this.closing) {
          this.closing = this.flushDelayer.trigger(
            () => this.doSave(),
            0
            /* as soon as possible */
          );
        }
        return this.closing;
      }
    };
    StateReadonlyService = class StateReadonlyService2 extends Disposable {
      constructor(saveStrategy, environmentService, logService, fileService) {
        super();
        this.fileStorage = this._register(new FileStorage(environmentService.stateResource, saveStrategy, logService, fileService));
      }
      async init() {
        await this.fileStorage.init();
      }
      getItem(key, defaultValue) {
        return this.fileStorage.getItem(key, defaultValue);
      }
    };
    StateReadonlyService = __decorate([
      __param(1, IEnvironmentService),
      __param(2, ILogService),
      __param(3, IFileService)
    ], StateReadonlyService);
    StateService = class extends StateReadonlyService {
      setItem(key, data) {
        this.fileStorage.setItem(key, data);
      }
      setItems(items) {
        this.fileStorage.setItems(items);
      }
      removeItem(key) {
        this.fileStorage.removeItem(key);
      }
      close() {
        return this.fileStorage.close();
      }
    };
  }
});

// out-build/vs/platform/userDataProfile/node/userDataProfile.js
var UserDataProfilesReadonlyService_1, UserDataProfilesService_1, UserDataProfilesReadonlyService, UserDataProfilesService3, ServerUserDataProfilesService;
var init_userDataProfile2 = __esm({
  "out-build/vs/platform/userDataProfile/node/userDataProfile.js"() {
    "use strict";
    init_uri();
    init_environment();
    init_files();
    init_log();
    init_state();
    init_uriIdentity();
    init_userDataProfile();
    init_types();
    init_stateService();
    UserDataProfilesReadonlyService = UserDataProfilesReadonlyService_1 = class UserDataProfilesReadonlyService2 extends UserDataProfilesService {
      constructor(stateReadonlyService, uriIdentityService, nativeEnvironmentService, fileService, logService) {
        super(nativeEnvironmentService, fileService, uriIdentityService, logService);
        this.stateReadonlyService = stateReadonlyService;
        this.nativeEnvironmentService = nativeEnvironmentService;
      }
      getStoredProfiles() {
        const storedProfilesState = this.stateReadonlyService.getItem(UserDataProfilesReadonlyService_1.PROFILES_KEY, []);
        return storedProfilesState.map((p) => ({ ...p, location: isString(p.location) ? this.uriIdentityService.extUri.joinPath(this.profilesHome, p.location) : URI.revive(p.location) }));
      }
      getStoredProfileAssociations() {
        return this.stateReadonlyService.getItem(UserDataProfilesReadonlyService_1.PROFILE_ASSOCIATIONS_KEY, {});
      }
      getDefaultProfileExtensionsLocation() {
        return this.uriIdentityService.extUri.joinPath(URI.file(this.nativeEnvironmentService.extensionsPath).with({ scheme: this.profilesHome.scheme }), "extensions.json");
      }
    };
    UserDataProfilesReadonlyService = UserDataProfilesReadonlyService_1 = __decorate([
      __param(0, IStateReadService),
      __param(1, IUriIdentityService),
      __param(2, INativeEnvironmentService),
      __param(3, IFileService),
      __param(4, ILogService)
    ], UserDataProfilesReadonlyService);
    UserDataProfilesService3 = UserDataProfilesService_1 = class UserDataProfilesService4 extends UserDataProfilesReadonlyService {
      constructor(stateService, uriIdentityService, environmentService, fileService, logService) {
        super(stateService, uriIdentityService, environmentService, fileService, logService);
        this.stateService = stateService;
      }
      saveStoredProfiles(storedProfiles) {
        if (storedProfiles.length) {
          this.stateService.setItem(UserDataProfilesService_1.PROFILES_KEY, storedProfiles.map((profile) => ({ ...profile, location: this.uriIdentityService.extUri.basename(profile.location) })));
        } else {
          this.stateService.removeItem(UserDataProfilesService_1.PROFILES_KEY);
        }
      }
      saveStoredProfileAssociations(storedProfileAssociations) {
        if (storedProfileAssociations.emptyWindows || storedProfileAssociations.workspaces) {
          this.stateService.setItem(UserDataProfilesService_1.PROFILE_ASSOCIATIONS_KEY, storedProfileAssociations);
        } else {
          this.stateService.removeItem(UserDataProfilesService_1.PROFILE_ASSOCIATIONS_KEY);
        }
      }
    };
    UserDataProfilesService3 = UserDataProfilesService_1 = __decorate([
      __param(0, IStateService),
      __param(1, IUriIdentityService),
      __param(2, INativeEnvironmentService),
      __param(3, IFileService),
      __param(4, ILogService)
    ], UserDataProfilesService3);
    ServerUserDataProfilesService = class ServerUserDataProfilesService2 extends UserDataProfilesService3 {
      constructor(uriIdentityService, environmentService, fileService, logService) {
        super(new StateService(0, environmentService, logService, fileService), uriIdentityService, environmentService, fileService, logService);
      }
      async init() {
        await this.stateService.init();
        return super.init();
      }
    };
    ServerUserDataProfilesService = __decorate([
      __param(0, IUriIdentityService),
      __param(1, INativeEnvironmentService),
      __param(2, IFileService),
      __param(3, ILogService)
    ], ServerUserDataProfilesService);
  }
});

// out-build/vs/platform/userDataProfile/electron-main/userDataProfile.js
var IUserDataProfilesMainService, UserDataProfilesMainService;
var init_userDataProfile3 = __esm({
  "out-build/vs/platform/userDataProfile/electron-main/userDataProfile.js"() {
    "use strict";
    init_environment();
    init_files();
    init_instantiation();
    init_log();
    init_uriIdentity();
    init_userDataProfile();
    init_userDataProfile2();
    init_state();
    IUserDataProfilesMainService = refineServiceDecorator(IUserDataProfilesService);
    UserDataProfilesMainService = class UserDataProfilesMainService2 extends UserDataProfilesService3 {
      constructor(stateService, uriIdentityService, environmentService, fileService, logService) {
        super(stateService, uriIdentityService, environmentService, fileService, logService);
      }
      getAssociatedEmptyWindows() {
        const emptyWindows = [];
        for (const id2 of this.profilesObject.emptyWindows.keys()) {
          emptyWindows.push({ id: id2 });
        }
        return emptyWindows;
      }
    };
    UserDataProfilesMainService = __decorate([
      __param(0, IStateService),
      __param(1, IUriIdentityService),
      __param(2, INativeEnvironmentService),
      __param(3, IFileService),
      __param(4, ILogService)
    ], UserDataProfilesMainService);
  }
});

// out-build/vs/platform/storage/electron-main/storageMainService.js
var IStorageMainService, StorageMainService, IApplicationStorageMainService, ApplicationStorageMainService;
var init_storageMainService = __esm({
  "out-build/vs/platform/storage/electron-main/storageMainService.js"() {
    "use strict";
    init_uri();
    init_event();
    init_lifecycle();
    init_environment();
    init_files();
    init_instantiation();
    init_lifecycleMainService();
    init_log();
    init_storage2();
    init_storageMain();
    init_userDataProfile();
    init_userDataProfile3();
    init_uriIdentity();
    init_network();
    IStorageMainService = createDecorator("storageMainService");
    StorageMainService = class StorageMainService2 extends Disposable {
      constructor(logService, environmentService, userDataProfilesService, lifecycleMainService, fileService, uriIdentityService) {
        super();
        this.logService = logService;
        this.environmentService = environmentService;
        this.userDataProfilesService = userDataProfilesService;
        this.lifecycleMainService = lifecycleMainService;
        this.fileService = fileService;
        this.uriIdentityService = uriIdentityService;
        this.shutdownReason = void 0;
        this._onDidChangeProfileStorage = this._register(new Emitter());
        this.onDidChangeProfileStorage = this._onDidChangeProfileStorage.event;
        this.mapProfileToStorage = /* @__PURE__ */ new Map();
        this.mapWorkspaceToStorage = /* @__PURE__ */ new Map();
        this.applicationStorage = this._register(this.createApplicationStorage());
        this.registerListeners();
      }
      getStorageOptions() {
        return {
          useInMemoryStorage: !!this.environmentService.extensionTestsLocationURI
          // no storage during extension tests!
        };
      }
      registerListeners() {
        (async () => {
          await this.lifecycleMainService.when(
            3
            /* LifecycleMainPhase.AfterWindowOpen */
          );
          this.applicationStorage.init();
        })();
        this._register(this.lifecycleMainService.onWillLoadWindow((e) => {
          if (e.window.profile) {
            this.profileStorage(e.window.profile).init();
          }
          if (e.workspace) {
            this.workspaceStorage(e.workspace).init();
          }
        }));
        this._register(this.lifecycleMainService.onWillShutdown((e) => {
          this.logService.trace("storageMainService#onWillShutdown()");
          this.shutdownReason = e.reason;
          e.join("applicationStorage", this.applicationStorage.close());
          for (const [, profileStorage] of this.mapProfileToStorage) {
            e.join("profileStorage", profileStorage.close());
          }
          for (const [, workspaceStorage] of this.mapWorkspaceToStorage) {
            e.join("workspaceStorage", workspaceStorage.close());
          }
        }));
        this._register(this.userDataProfilesService.onWillCreateProfile((e) => {
          e.join((async () => {
            if (!await this.fileService.exists(e.profile.globalStorageHome)) {
              await this.fileService.createFolder(e.profile.globalStorageHome);
            }
          })());
        }));
        this._register(this.userDataProfilesService.onWillRemoveProfile((e) => {
          const storage = this.mapProfileToStorage.get(e.profile.id);
          if (storage) {
            e.join(storage.close());
          }
        }));
      }
      createApplicationStorage() {
        this.logService.trace(`StorageMainService: creating application storage`);
        const applicationStorage = new ApplicationStorageMain(this.getStorageOptions(), this.userDataProfilesService, this.logService, this.fileService);
        this._register(Event.once(applicationStorage.onDidCloseStorage)(() => {
          this.logService.trace(`StorageMainService: closed application storage`);
        }));
        return applicationStorage;
      }
      profileStorage(profile) {
        if (isProfileUsingDefaultStorage(profile)) {
          return this.applicationStorage;
        }
        let profileStorage = this.mapProfileToStorage.get(profile.id);
        if (!profileStorage) {
          this.logService.trace(`StorageMainService: creating profile storage (${profile.name})`);
          profileStorage = this._register(this.createProfileStorage(profile));
          this.mapProfileToStorage.set(profile.id, profileStorage);
          const listener = this._register(profileStorage.onDidChangeStorage((e) => this._onDidChangeProfileStorage.fire({
            ...e,
            storage: profileStorage,
            profile
          })));
          this._register(Event.once(profileStorage.onDidCloseStorage)(() => {
            this.logService.trace(`StorageMainService: closed profile storage (${profile.name})`);
            this.mapProfileToStorage.delete(profile.id);
            listener.dispose();
          }));
        }
        return profileStorage;
      }
      createProfileStorage(profile) {
        if (this.shutdownReason === 2) {
          return new InMemoryStorageMain(this.logService, this.fileService);
        }
        return new ProfileStorageMain(profile, this.getStorageOptions(), this.logService, this.fileService);
      }
      workspaceStorage(workspace) {
        let workspaceStorage = this.mapWorkspaceToStorage.get(workspace.id);
        if (!workspaceStorage) {
          this.logService.trace(`StorageMainService: creating workspace storage (${workspace.id})`);
          workspaceStorage = this._register(this.createWorkspaceStorage(workspace));
          this.mapWorkspaceToStorage.set(workspace.id, workspaceStorage);
          this._register(Event.once(workspaceStorage.onDidCloseStorage)(() => {
            this.logService.trace(`StorageMainService: closed workspace storage (${workspace.id})`);
            this.mapWorkspaceToStorage.delete(workspace.id);
          }));
        }
        return workspaceStorage;
      }
      createWorkspaceStorage(workspace) {
        if (this.shutdownReason === 2) {
          return new InMemoryStorageMain(this.logService, this.fileService);
        }
        return new WorkspaceStorageMain(workspace, this.getStorageOptions(), this.logService, this.environmentService, this.fileService);
      }
      //#endregion
      isUsed(path4) {
        const pathUri = URI.file(path4);
        for (const storage of [this.applicationStorage, ...this.mapProfileToStorage.values(), ...this.mapWorkspaceToStorage.values()]) {
          if (!storage.path) {
            continue;
          }
          if (this.uriIdentityService.extUri.isEqualOrParent(URI.file(storage.path), pathUri)) {
            return true;
          }
        }
        return false;
      }
    };
    StorageMainService = __decorate([
      __param(0, ILogService),
      __param(1, IEnvironmentService),
      __param(2, IUserDataProfilesMainService),
      __param(3, ILifecycleMainService),
      __param(4, IFileService),
      __param(5, IUriIdentityService)
    ], StorageMainService);
    IApplicationStorageMainService = createDecorator("applicationStorageMainService");
    ApplicationStorageMainService = class ApplicationStorageMainService2 extends AbstractStorageService {
      constructor(userDataProfilesService, storageMainService) {
        super();
        this.userDataProfilesService = userDataProfilesService;
        this.storageMainService = storageMainService;
        this.whenReady = this.storageMainService.applicationStorage.whenInit;
      }
      doInitialize() {
        return this.storageMainService.applicationStorage.whenInit;
      }
      getStorage(scope) {
        if (scope === -1) {
          return this.storageMainService.applicationStorage.storage;
        }
        return void 0;
      }
      getLogDetails(scope) {
        if (scope === -1) {
          return this.userDataProfilesService.defaultProfile.globalStorageHome.with({ scheme: Schemas.file }).fsPath;
        }
        return void 0;
      }
      shouldFlushWhenIdle() {
        return false;
      }
      switch() {
        throw new Error("Migrating storage is unsupported from main process");
      }
      switchToProfile() {
        throw new Error("Switching storage profile is unsupported from main process");
      }
      switchToWorkspace() {
        throw new Error("Switching storage workspace is unsupported from main process");
      }
      hasScope() {
        throw new Error("Main process is never profile or workspace scoped");
      }
    };
    ApplicationStorageMainService = __decorate([
      __param(0, IUserDataProfilesService),
      __param(1, IStorageMainService)
    ], ApplicationStorageMainService);
  }
});

// out-build/vs/platform/native/electron-main/auth.js
import { app } from "electron";
var IProxyAuthService, ProxyAuthService;
var init_auth = __esm({
  "out-build/vs/platform/native/electron-main/auth.js"() {
    "use strict";
    init_cancellation();
    init_event();
    init_hash();
    init_lifecycle();
    init_uri();
    init_uuid();
    init_configuration();
    init_encryptionService();
    init_environmentMainService();
    init_instantiation();
    init_log();
    init_storageMainService();
    init_windows();
    IProxyAuthService = createDecorator("proxyAuthService");
    ProxyAuthService = class ProxyAuthService2 extends Disposable {
      constructor(logService, windowsMainService, encryptionMainService, applicationStorageMainService, configurationService, environmentMainService) {
        super();
        this.logService = logService;
        this.windowsMainService = windowsMainService;
        this.encryptionMainService = encryptionMainService;
        this.applicationStorageMainService = applicationStorageMainService;
        this.configurationService = configurationService;
        this.environmentMainService = environmentMainService;
        this.PROXY_CREDENTIALS_SERVICE_KEY = "proxy-credentials://";
        this.pendingProxyResolves = /* @__PURE__ */ new Map();
        this.currentDialog = void 0;
        this.cancelledAuthInfoHashes = /* @__PURE__ */ new Set();
        this.sessionCredentials = /* @__PURE__ */ new Map();
        this.registerListeners();
      }
      registerListeners() {
        const onLogin = Event.fromNodeEventEmitter(app, "login", (event, _webContents, req, authInfo, callback) => ({ event, authInfo: { ...authInfo, attempt: req.firstAuthAttempt ? 1 : 2 }, callback }));
        this._register(onLogin(this.onLogin, this));
      }
      async lookupAuthorization(authInfo) {
        return this.onLogin({ authInfo });
      }
      async onLogin({ event, authInfo, callback }) {
        if (!authInfo.isProxy) {
          return;
        }
        event?.preventDefault();
        const authInfoHash = String(hash({ scheme: authInfo.scheme, host: authInfo.host, port: authInfo.port }));
        let credentials = void 0;
        let pendingProxyResolve = this.pendingProxyResolves.get(authInfoHash);
        if (!pendingProxyResolve) {
          this.logService.trace("auth#onLogin (proxy) - no pending proxy handling found, starting new");
          pendingProxyResolve = this.resolveProxyCredentials(authInfo, authInfoHash);
          this.pendingProxyResolves.set(authInfoHash, pendingProxyResolve);
          try {
            credentials = await pendingProxyResolve;
          } finally {
            this.pendingProxyResolves.delete(authInfoHash);
          }
        } else {
          this.logService.trace("auth#onLogin (proxy) - pending proxy handling found");
          credentials = await pendingProxyResolve;
        }
        callback?.(credentials?.username, credentials?.password);
        return credentials;
      }
      async resolveProxyCredentials(authInfo, authInfoHash) {
        this.logService.trace("auth#resolveProxyCredentials (proxy) - enter");
        try {
          const credentials = await this.doResolveProxyCredentials(authInfo, authInfoHash);
          if (credentials) {
            this.logService.trace("auth#resolveProxyCredentials (proxy) - got credentials");
            return credentials;
          } else {
            this.logService.trace("auth#resolveProxyCredentials (proxy) - did not get credentials");
          }
        } finally {
          this.logService.trace("auth#resolveProxyCredentials (proxy) - exit");
        }
        return void 0;
      }
      async doResolveProxyCredentials(authInfo, authInfoHash) {
        this.logService.trace("auth#doResolveProxyCredentials - enter", authInfo);
        if (this.environmentMainService.extensionTestsLocationURI) {
          try {
            const decodedRealm = Buffer.from(authInfo.realm, "base64").toString("utf-8");
            if (decodedRealm.startsWith("{")) {
              return JSON.parse(decodedRealm);
            }
          } catch {
          }
          return void 0;
        }
        const newHttpProxy = (this.configurationService.getValue("http.proxy") || "").trim() || (process.env["https_proxy"] || process.env["HTTPS_PROXY"] || process.env["http_proxy"] || process.env["HTTP_PROXY"] || "").trim() || void 0;
        if (newHttpProxy?.indexOf("@") !== -1) {
          const uri = URI.parse(newHttpProxy);
          const i = uri.authority.indexOf("@");
          if (i !== -1) {
            if (authInfo.attempt > 1) {
              this.logService.trace("auth#doResolveProxyCredentials (proxy) - exit - ignoring previously used config/envvar credentials");
              return void 0;
            }
            this.logService.trace("auth#doResolveProxyCredentials (proxy) - exit - found config/envvar credentials to use");
            const credentials = uri.authority.substring(0, i);
            const j = credentials.indexOf(":");
            if (j !== -1) {
              return {
                username: credentials.substring(0, j),
                password: credentials.substring(j + 1)
              };
            } else {
              return {
                username: credentials,
                password: ""
              };
            }
          }
        }
        const sessionCredentials = authInfo.attempt === 1 && this.sessionCredentials.get(authInfoHash);
        if (sessionCredentials) {
          this.logService.trace("auth#doResolveProxyCredentials (proxy) - exit - found session credentials to use");
          const { username, password } = sessionCredentials;
          return { username, password };
        }
        let storedUsername;
        let storedPassword;
        try {
          const encryptedValue = this.applicationStorageMainService.get(
            this.PROXY_CREDENTIALS_SERVICE_KEY + authInfoHash,
            -1
            /* StorageScope.APPLICATION */
          );
          if (encryptedValue) {
            const credentials = JSON.parse(await this.encryptionMainService.decrypt(encryptedValue));
            storedUsername = credentials.username;
            storedPassword = credentials.password;
          }
        } catch (error) {
          this.logService.error(error);
        }
        if (authInfo.attempt === 1 && typeof storedUsername === "string" && typeof storedPassword === "string") {
          this.logService.trace("auth#doResolveProxyCredentials (proxy) - exit - found stored credentials to use");
          this.sessionCredentials.set(authInfoHash, { username: storedUsername, password: storedPassword });
          return { username: storedUsername, password: storedPassword };
        }
        const previousDialog = this.currentDialog;
        const currentDialog = this.currentDialog = (async () => {
          await previousDialog;
          const credentials = await this.showProxyCredentialsDialog(authInfo, authInfoHash, storedUsername, storedPassword);
          if (this.currentDialog === currentDialog) {
            this.currentDialog = void 0;
          }
          return credentials;
        })();
        return currentDialog;
      }
      async showProxyCredentialsDialog(authInfo, authInfoHash, storedUsername, storedPassword) {
        if (this.cancelledAuthInfoHashes.has(authInfoHash)) {
          this.logService.trace("auth#doResolveProxyCredentials (proxy) - exit - login dialog was cancelled before, not showing again");
          return void 0;
        }
        const window = this.windowsMainService.getFocusedWindow() || this.windowsMainService.getLastActiveWindow();
        if (!window) {
          this.logService.trace("auth#doResolveProxyCredentials (proxy) - exit - no opened window found to show dialog in");
          return void 0;
        }
        this.logService.trace(`auth#doResolveProxyCredentials (proxy) - asking window ${window.id} to handle proxy login`);
        const sessionCredentials = this.sessionCredentials.get(authInfoHash);
        const payload = {
          authInfo,
          username: sessionCredentials?.username ?? storedUsername,
          // prefer to show already used username (if any) over stored
          password: sessionCredentials?.password ?? storedPassword,
          // prefer to show already used password (if any) over stored
          replyChannel: `vscode:proxyAuthResponse:${generateUuid()}`
        };
        window.sendWhenReady("vscode:openProxyAuthenticationDialog", CancellationToken.None, payload);
        const loginDialogCredentials = await new Promise((resolve3) => {
          const proxyAuthResponseHandler = async (event, channel, reply) => {
            if (channel === payload.replyChannel) {
              this.logService.trace(`auth#doResolveProxyCredentials - exit - received credentials from window ${window.id}`);
              window.win?.webContents.off("ipc-message", proxyAuthResponseHandler);
              if (reply) {
                const credentials = { username: reply.username, password: reply.password };
                try {
                  if (reply.remember) {
                    const encryptedSerializedCredentials = await this.encryptionMainService.encrypt(JSON.stringify(credentials));
                    this.applicationStorageMainService.store(
                      this.PROXY_CREDENTIALS_SERVICE_KEY + authInfoHash,
                      encryptedSerializedCredentials,
                      -1,
                      1
                      /* StorageTarget.MACHINE */
                    );
                  } else {
                    this.applicationStorageMainService.remove(
                      this.PROXY_CREDENTIALS_SERVICE_KEY + authInfoHash,
                      -1
                      /* StorageScope.APPLICATION */
                    );
                  }
                } catch (error) {
                  this.logService.error(error);
                }
                resolve3({ username: credentials.username, password: credentials.password });
              } else {
                this.cancelledAuthInfoHashes.add(authInfoHash);
                resolve3(void 0);
              }
            }
          };
          window.win?.webContents.on("ipc-message", proxyAuthResponseHandler);
        });
        this.sessionCredentials.set(authInfoHash, loginDialogCredentials);
        return loginDialogCredentials;
      }
    };
    ProxyAuthService = __decorate([
      __param(0, ILogService),
      __param(1, IWindowsMainService),
      __param(2, IEncryptionMainService),
      __param(3, IApplicationStorageMainService),
      __param(4, IConfigurationService),
      __param(5, IEnvironmentMainService)
    ], ProxyAuthService);
  }
});

// out-build/vs/platform/backup/electron-main/backup.js
var IBackupMainService;
var init_backup = __esm({
  "out-build/vs/platform/backup/electron-main/backup.js"() {
    "use strict";
    init_instantiation();
    IBackupMainService = createDecorator("backupMainService");
  }
});

// out-build/vs/platform/backup/node/backup.js
function isEmptyWindowBackupInfo(obj) {
  const candidate = obj;
  return typeof candidate?.backupFolder === "string";
}
function deserializeWorkspaceInfos(serializedBackupWorkspaces) {
  let workspaceBackupInfos = [];
  try {
    if (Array.isArray(serializedBackupWorkspaces.workspaces)) {
      workspaceBackupInfos = serializedBackupWorkspaces.workspaces.map((workspace) => ({
        workspace: {
          id: workspace.id,
          configPath: URI.parse(workspace.configURIPath)
        },
        remoteAuthority: workspace.remoteAuthority
      }));
    }
  } catch (e) {
  }
  return workspaceBackupInfos;
}
function deserializeFolderInfos(serializedBackupWorkspaces) {
  let folderBackupInfos = [];
  try {
    if (Array.isArray(serializedBackupWorkspaces.folders)) {
      folderBackupInfos = serializedBackupWorkspaces.folders.map((folder) => ({
        folderUri: URI.parse(folder.folderUri),
        remoteAuthority: folder.remoteAuthority
      }));
    }
  } catch (e) {
  }
  return folderBackupInfos;
}
var init_backup2 = __esm({
  "out-build/vs/platform/backup/node/backup.js"() {
    "use strict";
    init_uri();
  }
});

// out-build/vs/platform/backup/common/backup.js
function isFolderBackupInfo(curr) {
  return curr && curr.hasOwnProperty("folderUri");
}
var init_backup3 = __esm({
  "out-build/vs/platform/backup/common/backup.js"() {
    "use strict";
  }
});

// out-build/vs/platform/workspaces/node/workspaces.js
import { createHash as createHash2 } from "crypto";
function getWorkspaceIdentifier(configPath) {
  function getWorkspaceId() {
    let configPathStr = configPath.scheme === Schemas.file ? originalFSPath(configPath) : configPath.toString();
    if (!isLinux) {
      configPathStr = configPathStr.toLowerCase();
    }
    return createHash2("md5").update(configPathStr).digest("hex");
  }
  return {
    id: getWorkspaceId(),
    configPath
  };
}
function getSingleFolderWorkspaceIdentifier(folderUri, folderStat) {
  function getFolderId() {
    if (folderUri.scheme !== Schemas.file) {
      return createHash2("md5").update(folderUri.toString()).digest("hex");
    }
    if (!folderStat) {
      return void 0;
    }
    let ctime;
    if (isLinux) {
      ctime = folderStat.ino;
    } else if (isMacintosh) {
      ctime = folderStat.birthtime.getTime();
    } else if (isWindows2) {
      if (typeof folderStat.birthtimeMs === "number") {
        ctime = Math.floor(folderStat.birthtimeMs);
      } else {
        ctime = folderStat.birthtime.getTime();
      }
    }
    return createHash2("md5").update(folderUri.fsPath).update(ctime ? String(ctime) : "").digest("hex");
  }
  const folderId = getFolderId();
  if (typeof folderId === "string") {
    return {
      id: folderId,
      uri: folderUri
    };
  }
  return void 0;
}
function createEmptyWorkspaceIdentifier() {
  return {
    id: (Date.now() + Math.round(Math.random() * 1e3)).toString()
  };
}
var NON_EMPTY_WORKSPACE_ID_LENGTH;
var init_workspaces = __esm({
  "out-build/vs/platform/workspaces/node/workspaces.js"() {
    "use strict";
    init_network();
    init_platform();
    init_resources();
    NON_EMPTY_WORKSPACE_ID_LENGTH = 128 / 4;
  }
});

// out-build/vs/platform/backup/electron-main/backupMainService.js
import { createHash as createHash3 } from "crypto";
var BackupMainService_1, BackupMainService;
var init_backupMainService = __esm({
  "out-build/vs/platform/backup/electron-main/backupMainService.js"() {
    "use strict";
    init_extpath();
    init_network();
    init_path();
    init_platform();
    init_resources();
    init_pfs();
    init_backup2();
    init_configuration();
    init_environmentMainService();
    init_state();
    init_files();
    init_log();
    init_backup3();
    init_workspace();
    init_workspaces();
    BackupMainService = class BackupMainService2 {
      static {
        BackupMainService_1 = this;
      }
      static {
        this.backupWorkspacesMetadataStorageKey = "backupWorkspaces";
      }
      constructor(environmentMainService, configurationService, logService, stateService) {
        this.configurationService = configurationService;
        this.logService = logService;
        this.stateService = stateService;
        this.workspaces = [];
        this.folders = [];
        this.emptyWindows = [];
        this.backupUriComparer = extUriBiasedIgnorePathCase;
        this.backupPathComparer = { isEqual: (pathA, pathB) => isEqual(pathA, pathB, !isLinux) };
        this.backupHome = environmentMainService.backupHome;
      }
      async initialize() {
        const serializedBackupWorkspaces = this.stateService.getItem(BackupMainService_1.backupWorkspacesMetadataStorageKey) ?? { workspaces: [], folders: [], emptyWindows: [] };
        this.emptyWindows = await this.validateEmptyWorkspaces(serializedBackupWorkspaces.emptyWindows);
        this.workspaces = await this.validateWorkspaces(deserializeWorkspaceInfos(serializedBackupWorkspaces));
        this.folders = await this.validateFolders(deserializeFolderInfos(serializedBackupWorkspaces));
        this.storeWorkspacesMetadata();
      }
      getWorkspaceBackups() {
        if (this.isHotExitOnExitAndWindowClose()) {
          return [];
        }
        return this.workspaces.slice(0);
      }
      getFolderBackups() {
        if (this.isHotExitOnExitAndWindowClose()) {
          return [];
        }
        return this.folders.slice(0);
      }
      isHotExitEnabled() {
        return this.getHotExitConfig() !== HotExitConfiguration.OFF;
      }
      isHotExitOnExitAndWindowClose() {
        return this.getHotExitConfig() === HotExitConfiguration.ON_EXIT_AND_WINDOW_CLOSE;
      }
      getHotExitConfig() {
        const config = this.configurationService.getValue();
        return config?.files?.hotExit || HotExitConfiguration.ON_EXIT;
      }
      getEmptyWindowBackups() {
        return this.emptyWindows.slice(0);
      }
      registerWorkspaceBackup(workspaceInfo, migrateFrom) {
        if (!this.workspaces.some((workspace) => workspaceInfo.workspace.id === workspace.workspace.id)) {
          this.workspaces.push(workspaceInfo);
          this.storeWorkspacesMetadata();
        }
        const backupPath = join3(this.backupHome, workspaceInfo.workspace.id);
        if (migrateFrom) {
          return this.moveBackupFolder(backupPath, migrateFrom).then(() => backupPath);
        }
        return backupPath;
      }
      async moveBackupFolder(backupPath, moveFromPath) {
        if (await Promises2.exists(backupPath)) {
          await this.convertToEmptyWindowBackup(backupPath);
        }
        if (await Promises2.exists(moveFromPath)) {
          try {
            await Promises2.rename(
              moveFromPath,
              backupPath,
              false
              /* no retry */
            );
          } catch (error) {
            this.logService.error(`Backup: Could not move backup folder to new location: ${error.toString()}`);
          }
        }
      }
      registerFolderBackup(folderInfo) {
        if (!this.folders.some((folder) => this.backupUriComparer.isEqual(folderInfo.folderUri, folder.folderUri))) {
          this.folders.push(folderInfo);
          this.storeWorkspacesMetadata();
        }
        return join3(this.backupHome, this.getFolderHash(folderInfo));
      }
      registerEmptyWindowBackup(emptyWindowInfo) {
        if (!this.emptyWindows.some((emptyWindow) => !!emptyWindow.backupFolder && this.backupPathComparer.isEqual(emptyWindow.backupFolder, emptyWindowInfo.backupFolder))) {
          this.emptyWindows.push(emptyWindowInfo);
          this.storeWorkspacesMetadata();
        }
        return join3(this.backupHome, emptyWindowInfo.backupFolder);
      }
      async validateWorkspaces(rootWorkspaces) {
        if (!Array.isArray(rootWorkspaces)) {
          return [];
        }
        const seenIds = /* @__PURE__ */ new Set();
        const result = [];
        for (const workspaceInfo of rootWorkspaces) {
          const workspace = workspaceInfo.workspace;
          if (!isWorkspaceIdentifier(workspace)) {
            return [];
          }
          if (!seenIds.has(workspace.id)) {
            seenIds.add(workspace.id);
            const backupPath = join3(this.backupHome, workspace.id);
            const hasBackups = await this.doHasBackups(backupPath);
            if (hasBackups) {
              if (workspace.configPath.scheme !== Schemas.file || await Promises2.exists(workspace.configPath.fsPath)) {
                result.push(workspaceInfo);
              } else {
                await this.convertToEmptyWindowBackup(backupPath);
              }
            } else {
              await this.deleteStaleBackup(backupPath);
            }
          }
        }
        return result;
      }
      async validateFolders(folderWorkspaces) {
        if (!Array.isArray(folderWorkspaces)) {
          return [];
        }
        const result = [];
        const seenIds = /* @__PURE__ */ new Set();
        for (const folderInfo of folderWorkspaces) {
          const folderURI = folderInfo.folderUri;
          const key = this.backupUriComparer.getComparisonKey(folderURI);
          if (!seenIds.has(key)) {
            seenIds.add(key);
            const backupPath = join3(this.backupHome, this.getFolderHash(folderInfo));
            const hasBackups = await this.doHasBackups(backupPath);
            if (hasBackups) {
              if (folderURI.scheme !== Schemas.file || await Promises2.exists(folderURI.fsPath)) {
                result.push(folderInfo);
              } else {
                await this.convertToEmptyWindowBackup(backupPath);
              }
            } else {
              await this.deleteStaleBackup(backupPath);
            }
          }
        }
        return result;
      }
      async validateEmptyWorkspaces(emptyWorkspaces) {
        if (!Array.isArray(emptyWorkspaces)) {
          return [];
        }
        const result = [];
        const seenIds = /* @__PURE__ */ new Set();
        for (const backupInfo of emptyWorkspaces) {
          const backupFolder = backupInfo.backupFolder;
          if (typeof backupFolder !== "string") {
            return [];
          }
          if (!seenIds.has(backupFolder)) {
            seenIds.add(backupFolder);
            const backupPath = join3(this.backupHome, backupFolder);
            if (await this.doHasBackups(backupPath)) {
              result.push(backupInfo);
            } else {
              await this.deleteStaleBackup(backupPath);
            }
          }
        }
        return result;
      }
      async deleteStaleBackup(backupPath) {
        try {
          await Promises2.rm(backupPath, RimRafMode.MOVE);
        } catch (error) {
          this.logService.error(`Backup: Could not delete stale backup: ${error.toString()}`);
        }
      }
      prepareNewEmptyWindowBackup() {
        let emptyWorkspaceIdentifier = createEmptyWorkspaceIdentifier();
        while (this.emptyWindows.some((emptyWindow) => !!emptyWindow.backupFolder && this.backupPathComparer.isEqual(emptyWindow.backupFolder, emptyWorkspaceIdentifier.id))) {
          emptyWorkspaceIdentifier = createEmptyWorkspaceIdentifier();
        }
        return { backupFolder: emptyWorkspaceIdentifier.id };
      }
      async convertToEmptyWindowBackup(backupPath) {
        const newEmptyWindowBackupInfo = this.prepareNewEmptyWindowBackup();
        const newEmptyWindowBackupPath = join3(this.backupHome, newEmptyWindowBackupInfo.backupFolder);
        try {
          await Promises2.rename(
            backupPath,
            newEmptyWindowBackupPath,
            false
            /* no retry */
          );
        } catch (error) {
          this.logService.error(`Backup: Could not rename backup folder: ${error.toString()}`);
          return false;
        }
        this.emptyWindows.push(newEmptyWindowBackupInfo);
        return true;
      }
      async getDirtyWorkspaces() {
        const dirtyWorkspaces = [];
        for (const workspace of this.workspaces) {
          if (await this.hasBackups(workspace)) {
            dirtyWorkspaces.push(workspace);
          }
        }
        for (const folder of this.folders) {
          if (await this.hasBackups(folder)) {
            dirtyWorkspaces.push(folder);
          }
        }
        return dirtyWorkspaces;
      }
      hasBackups(backupLocation) {
        let backupPath;
        if (isEmptyWindowBackupInfo(backupLocation)) {
          backupPath = join3(this.backupHome, backupLocation.backupFolder);
        } else if (isFolderBackupInfo(backupLocation)) {
          backupPath = join3(this.backupHome, this.getFolderHash(backupLocation));
        } else {
          backupPath = join3(this.backupHome, backupLocation.workspace.id);
        }
        return this.doHasBackups(backupPath);
      }
      async doHasBackups(backupPath) {
        try {
          const backupSchemas = await Promises2.readdir(backupPath);
          for (const backupSchema of backupSchemas) {
            try {
              const backupSchemaChildren = await Promises2.readdir(join3(backupPath, backupSchema));
              if (backupSchemaChildren.length > 0) {
                return true;
              }
            } catch (error) {
            }
          }
        } catch (error) {
        }
        return false;
      }
      storeWorkspacesMetadata() {
        const serializedBackupWorkspaces = {
          workspaces: this.workspaces.map(({ workspace, remoteAuthority }) => {
            const serializedWorkspaceBackupInfo = {
              id: workspace.id,
              configURIPath: workspace.configPath.toString()
            };
            if (remoteAuthority) {
              serializedWorkspaceBackupInfo.remoteAuthority = remoteAuthority;
            }
            return serializedWorkspaceBackupInfo;
          }),
          folders: this.folders.map(({ folderUri, remoteAuthority }) => {
            const serializedFolderBackupInfo = {
              folderUri: folderUri.toString()
            };
            if (remoteAuthority) {
              serializedFolderBackupInfo.remoteAuthority = remoteAuthority;
            }
            return serializedFolderBackupInfo;
          }),
          emptyWindows: this.emptyWindows.map(({ backupFolder, remoteAuthority }) => {
            const serializedEmptyWindowBackupInfo = {
              backupFolder
            };
            if (remoteAuthority) {
              serializedEmptyWindowBackupInfo.remoteAuthority = remoteAuthority;
            }
            return serializedEmptyWindowBackupInfo;
          })
        };
        this.stateService.setItem(BackupMainService_1.backupWorkspacesMetadataStorageKey, serializedBackupWorkspaces);
      }
      getFolderHash(folder) {
        const folderUri = folder.folderUri;
        let key;
        if (folderUri.scheme === Schemas.file) {
          key = isLinux ? folderUri.fsPath : folderUri.fsPath.toLowerCase();
        } else {
          key = folderUri.toString().toLowerCase();
        }
        return createHash3("md5").update(key).digest("hex");
      }
    };
    BackupMainService = BackupMainService_1 = __decorate([
      __param(0, IEnvironmentMainService),
      __param(1, IConfigurationService),
      __param(2, ILogService),
      __param(3, IStateService)
    ], BackupMainService);
  }
});

// out-build/vs/platform/debug/common/extensionHostDebugIpc.js
var ExtensionHostDebugBroadcastChannel;
var init_extensionHostDebugIpc = __esm({
  "out-build/vs/platform/debug/common/extensionHostDebugIpc.js"() {
    "use strict";
    init_event();
    init_lifecycle();
    ExtensionHostDebugBroadcastChannel = class {
      constructor() {
        this._onCloseEmitter = new Emitter();
        this._onReloadEmitter = new Emitter();
        this._onTerminateEmitter = new Emitter();
        this._onAttachEmitter = new Emitter();
      }
      static {
        this.ChannelName = "extensionhostdebugservice";
      }
      call(ctx, command, arg) {
        switch (command) {
          case "close":
            return Promise.resolve(this._onCloseEmitter.fire({ sessionId: arg[0] }));
          case "reload":
            return Promise.resolve(this._onReloadEmitter.fire({ sessionId: arg[0] }));
          case "terminate":
            return Promise.resolve(this._onTerminateEmitter.fire({ sessionId: arg[0] }));
          case "attach":
            return Promise.resolve(this._onAttachEmitter.fire({ sessionId: arg[0], port: arg[1], subId: arg[2] }));
        }
        throw new Error("Method not implemented.");
      }
      listen(ctx, event, arg) {
        switch (event) {
          case "close":
            return this._onCloseEmitter.event;
          case "reload":
            return this._onReloadEmitter.event;
          case "terminate":
            return this._onTerminateEmitter.event;
          case "attach":
            return this._onAttachEmitter.event;
        }
        throw new Error("Method not implemented.");
      }
    };
  }
});

// out-build/vs/platform/environment/node/argv.js
function parseArgs(args2, options, errorReporter = ignoringReporter) {
  const firstPossibleCommand = args2.find((a, i) => a.length > 0 && a[0] !== "-" && options.hasOwnProperty(a) && options[a].type === "subcommand");
  const alias = {};
  const stringOptions = ["_"];
  const booleanOptions = [];
  const globalOptions = {};
  let command = void 0;
  for (const optionId in options) {
    const o = options[optionId];
    if (o.type === "subcommand") {
      if (optionId === firstPossibleCommand) {
        command = o;
      }
    } else {
      if (o.alias) {
        alias[optionId] = o.alias;
      }
      if (o.type === "string" || o.type === "string[]") {
        stringOptions.push(optionId);
        if (o.deprecates) {
          stringOptions.push(...o.deprecates);
        }
      } else if (o.type === "boolean") {
        booleanOptions.push(optionId);
        if (o.deprecates) {
          booleanOptions.push(...o.deprecates);
        }
      }
      if (o.global) {
        globalOptions[optionId] = o;
      }
    }
  }
  if (command && firstPossibleCommand) {
    const options2 = globalOptions;
    for (const optionId in command.options) {
      options2[optionId] = command.options[optionId];
    }
    const newArgs = args2.filter((a) => a !== firstPossibleCommand);
    const reporter = errorReporter.getSubcommandReporter ? errorReporter.getSubcommandReporter(firstPossibleCommand) : void 0;
    const subcommandOptions = parseArgs(newArgs, options2, reporter);
    return {
      [firstPossibleCommand]: subcommandOptions,
      _: []
    };
  }
  const parsedArgs = (0, import_minimist.default)(args2, { string: stringOptions, boolean: booleanOptions, alias });
  const cleanedArgs = {};
  const remainingArgs = parsedArgs;
  cleanedArgs._ = parsedArgs._.map((arg) => String(arg)).filter((arg) => arg.length > 0);
  delete remainingArgs._;
  for (const optionId in options) {
    const o = options[optionId];
    if (o.type === "subcommand") {
      continue;
    }
    if (o.alias) {
      delete remainingArgs[o.alias];
    }
    let val = remainingArgs[optionId];
    if (o.deprecates) {
      for (const deprecatedId of o.deprecates) {
        if (remainingArgs.hasOwnProperty(deprecatedId)) {
          if (!val) {
            val = remainingArgs[deprecatedId];
            if (val) {
              errorReporter.onDeprecatedOption(deprecatedId, o.deprecationMessage || localize(1880, null, optionId));
            }
          }
          delete remainingArgs[deprecatedId];
        }
      }
    }
    if (typeof val !== "undefined") {
      if (o.type === "string[]") {
        if (!Array.isArray(val)) {
          val = [val];
        }
        if (!o.allowEmptyValue) {
          const sanitized = val.filter((v) => v.length > 0);
          if (sanitized.length !== val.length) {
            errorReporter.onEmptyValue(optionId);
            val = sanitized.length > 0 ? sanitized : void 0;
          }
        }
      } else if (o.type === "string") {
        if (Array.isArray(val)) {
          val = val.pop();
          errorReporter.onMultipleValues(optionId, val);
        } else if (!val && !o.allowEmptyValue) {
          errorReporter.onEmptyValue(optionId);
          val = void 0;
        }
      }
      cleanedArgs[optionId] = val;
      if (o.deprecationMessage) {
        errorReporter.onDeprecatedOption(optionId, o.deprecationMessage);
      }
    }
    delete remainingArgs[optionId];
  }
  for (const key in remainingArgs) {
    errorReporter.onUnknownOption(key);
  }
  return cleanedArgs;
}
var import_minimist, helpCategories, NATIVE_CLI_COMMANDS, OPTIONS, ignoringReporter;
var init_argv = __esm({
  "out-build/vs/platform/environment/node/argv.js"() {
    "use strict";
    import_minimist = __toESM(require_minimist(), 1);
    init_platform();
    init_nls();
    helpCategories = {
      o: localize(1838, null),
      e: localize(1839, null),
      t: localize(1840, null)
    };
    NATIVE_CLI_COMMANDS = ["tunnel", "serve-web"];
    OPTIONS = {
      "tunnel": {
        type: "subcommand",
        description: "Make the current machine accessible from vscode.dev or other machines through a secure tunnel",
        options: {
          "cli-data-dir": { type: "string", args: "dir", description: localize(1841, null) },
          "disable-telemetry": { type: "boolean" },
          "telemetry-level": { type: "string" },
          user: {
            type: "subcommand",
            options: {
              login: {
                type: "subcommand",
                options: {
                  provider: { type: "string" },
                  "access-token": { type: "string" }
                }
              }
            }
          }
        }
      },
      "serve-web": {
        type: "subcommand",
        description: "Run a server that displays the editor UI in browsers.",
        options: {
          "cli-data-dir": { type: "string", args: "dir", description: localize(1842, null) },
          "disable-telemetry": { type: "boolean" },
          "telemetry-level": { type: "string" }
        }
      },
      "diff": { type: "boolean", cat: "o", alias: "d", args: ["file", "file"], description: localize(1843, null) },
      "merge": { type: "boolean", cat: "o", alias: "m", args: ["path1", "path2", "base", "result"], description: localize(1844, null) },
      "add": { type: "boolean", cat: "o", alias: "a", args: "folder", description: localize(1845, null) },
      "remove": { type: "boolean", cat: "o", args: "folder", description: localize(1846, null) },
      "goto": { type: "boolean", cat: "o", alias: "g", args: "file:line[:character]", description: localize(1847, null) },
      "new-window": { type: "boolean", cat: "o", alias: "n", description: localize(1848, null) },
      "reuse-window": { type: "boolean", cat: "o", alias: "r", description: localize(1849, null) },
      "wait": { type: "boolean", cat: "o", alias: "w", description: localize(1850, null) },
      "waitMarkerFilePath": { type: "string" },
      "locale": { type: "string", cat: "o", args: "locale", description: localize(1851, null) },
      "user-data-dir": { type: "string", cat: "o", args: "dir", description: localize(1852, null) },
      "profile": { type: "string", "cat": "o", args: "profileName", description: localize(1853, null) },
      "help": { type: "boolean", cat: "o", alias: "h", description: localize(1854, null) },
      "extensions-dir": { type: "string", deprecates: ["extensionHomePath"], cat: "e", args: "dir", description: localize(1855, null) },
      "extensions-download-dir": { type: "string" },
      "builtin-extensions-dir": { type: "string" },
      "list-extensions": { type: "boolean", cat: "e", description: localize(1856, null) },
      "show-versions": { type: "boolean", cat: "e", description: localize(1857, null) },
      "category": { type: "string", allowEmptyValue: true, cat: "e", description: localize(1858, null), args: "category" },
      "install-extension": { type: "string[]", cat: "e", args: "ext-id | path", description: localize(1859, null) },
      "pre-release": { type: "boolean", cat: "e", description: localize(1860, null) },
      "uninstall-extension": { type: "string[]", cat: "e", args: "ext-id", description: localize(1861, null) },
      "update-extensions": { type: "boolean", cat: "e", description: localize(1862, null) },
      "enable-proposed-api": { type: "string[]", allowEmptyValue: true, cat: "e", args: "ext-id", description: localize(1863, null) },
      "add-mcp": { type: "string[]", cat: "o", args: "json", description: localize(1864, null) },
      "version": { type: "boolean", cat: "t", alias: "v", description: localize(1865, null) },
      "verbose": { type: "boolean", cat: "t", global: true, description: localize(1866, null) },
      "log": { type: "string[]", cat: "t", args: "level", global: true, description: localize(1867, null) },
      "status": { type: "boolean", alias: "s", cat: "t", description: localize(1868, null) },
      "prof-startup": { type: "boolean", cat: "t", description: localize(1869, null) },
      "prof-append-timers": { type: "string" },
      "prof-duration-markers": { type: "string[]" },
      "prof-duration-markers-file": { type: "string" },
      "no-cached-data": { type: "boolean" },
      "prof-startup-prefix": { type: "string" },
      "prof-v8-extensions": { type: "boolean" },
      "disable-extensions": { type: "boolean", deprecates: ["disableExtensions"], cat: "t", description: localize(1870, null) },
      "disable-extension": { type: "string[]", cat: "t", args: "ext-id", description: localize(1871, null) },
      "sync": { type: "string", cat: "t", description: localize(1872, null), args: ["on | off"] },
      "inspect-extensions": { type: "string", allowEmptyValue: true, deprecates: ["debugPluginHost"], args: "port", cat: "t", description: localize(1873, null) },
      "inspect-brk-extensions": { type: "string", allowEmptyValue: true, deprecates: ["debugBrkPluginHost"], args: "port", cat: "t", description: localize(1874, null) },
      "disable-lcd-text": { type: "boolean", cat: "t", description: localize(1875, null) },
      "disable-gpu": { type: "boolean", cat: "t", description: localize(1876, null) },
      "disable-chromium-sandbox": { type: "boolean", cat: "t", description: localize(1877, null) },
      "sandbox": { type: "boolean" },
      "locate-shell-integration-path": { type: "string", cat: "t", args: ["shell"], description: localize(1878, null) },
      "telemetry": { type: "boolean", cat: "t", description: localize(1879, null) },
      "remote": { type: "string", allowEmptyValue: true },
      "folder-uri": { type: "string[]", cat: "o", args: "uri" },
      "file-uri": { type: "string[]", cat: "o", args: "uri" },
      "locate-extension": { type: "string[]" },
      "extensionDevelopmentPath": { type: "string[]" },
      "extensionDevelopmentKind": { type: "string[]" },
      "extensionTestsPath": { type: "string" },
      "extensionEnvironment": { type: "string" },
      "debugId": { type: "string" },
      "debugRenderer": { type: "boolean" },
      "inspect-ptyhost": { type: "string", allowEmptyValue: true },
      "inspect-brk-ptyhost": { type: "string", allowEmptyValue: true },
      "inspect-search": { type: "string", deprecates: ["debugSearch"], allowEmptyValue: true },
      "inspect-brk-search": { type: "string", deprecates: ["debugBrkSearch"], allowEmptyValue: true },
      "inspect-sharedprocess": { type: "string", allowEmptyValue: true },
      "inspect-brk-sharedprocess": { type: "string", allowEmptyValue: true },
      "export-default-configuration": { type: "string" },
      "install-source": { type: "string" },
      "enable-smoke-test-driver": { type: "boolean" },
      "logExtensionHostCommunication": { type: "boolean" },
      "skip-release-notes": { type: "boolean" },
      "skip-welcome": { type: "boolean" },
      "disable-telemetry": { type: "boolean" },
      "disable-updates": { type: "boolean" },
      "use-inmemory-secretstorage": { type: "boolean", deprecates: ["disable-keytar"] },
      "password-store": { type: "string" },
      "disable-workspace-trust": { type: "boolean" },
      "disable-crash-reporter": { type: "boolean" },
      "crash-reporter-directory": { type: "string" },
      "crash-reporter-id": { type: "string" },
      "skip-add-to-recently-opened": { type: "boolean" },
      "open-url": { type: "boolean" },
      "file-write": { type: "boolean" },
      "file-chmod": { type: "boolean" },
      "install-builtin-extension": { type: "string[]" },
      "force": { type: "boolean" },
      "do-not-sync": { type: "boolean" },
      "do-not-include-pack-dependencies": { type: "boolean" },
      "trace": { type: "boolean" },
      "trace-memory-infra": { type: "boolean" },
      "trace-category-filter": { type: "string" },
      "trace-options": { type: "string" },
      "preserve-env": { type: "boolean" },
      "force-user-env": { type: "boolean" },
      "force-disable-user-env": { type: "boolean" },
      "open-devtools": { type: "boolean" },
      "disable-gpu-sandbox": { type: "boolean" },
      "logsPath": { type: "string" },
      "__enable-file-policy": { type: "boolean" },
      "editSessionId": { type: "string" },
      "continueOn": { type: "string" },
      "enable-coi": { type: "boolean" },
      "unresponsive-sample-interval": { type: "string" },
      "unresponsive-sample-period": { type: "string" },
      "enable-rdp-display-tracking": { type: "boolean" },
      // chromium flags
      "no-proxy-server": { type: "boolean" },
      // Minimist incorrectly parses keys that start with `--no`
      // https://github.com/substack/minimist/blob/aeb3e27dae0412de5c0494e9563a5f10c82cc7a9/index.js#L118-L121
      // If --no-sandbox is passed via cli wrapper it will be treated as --sandbox which is incorrect, we use
      // the alias here to make sure --no-sandbox is always respected.
      // For https://github.com/microsoft/vscode/issues/128279
      "no-sandbox": { type: "boolean", alias: "sandbox" },
      "proxy-server": { type: "string" },
      "proxy-bypass-list": { type: "string" },
      "proxy-pac-url": { type: "string" },
      "js-flags": { type: "string" },
      // chrome js flags
      "inspect": { type: "string", allowEmptyValue: true },
      "inspect-brk": { type: "string", allowEmptyValue: true },
      "nolazy": { type: "boolean" },
      // node inspect
      "force-device-scale-factor": { type: "string" },
      "force-renderer-accessibility": { type: "boolean" },
      "ignore-certificate-errors": { type: "boolean" },
      "allow-insecure-localhost": { type: "boolean" },
      "log-net-log": { type: "string" },
      "vmodule": { type: "string" },
      "_urls": { type: "string[]" },
      "disable-dev-shm-usage": { type: "boolean" },
      "profile-temp": { type: "boolean" },
      "ozone-platform": { type: "string" },
      "enable-tracing": { type: "string" },
      "trace-startup-format": { type: "string" },
      "trace-startup-file": { type: "string" },
      "trace-startup-duration": { type: "string" },
      "xdg-portal-required-version": { type: "string" },
      _: { type: "string[]" }
      // main arguments
    };
    ignoringReporter = {
      onUnknownOption: () => {
      },
      onMultipleValues: () => {
      },
      onEmptyValue: () => {
      },
      onDeprecatedOption: () => {
      }
    };
  }
});

// out-build/vs/platform/debug/electron-main/extensionHostDebugIpc.js
import { createServer as createServer2 } from "net";
var ElectronExtensionHostDebugBroadcastChannel;
var init_extensionHostDebugIpc2 = __esm({
  "out-build/vs/platform/debug/electron-main/extensionHostDebugIpc.js"() {
    "use strict";
    init_extensionHostDebugIpc();
    init_argv();
    ElectronExtensionHostDebugBroadcastChannel = class extends ExtensionHostDebugBroadcastChannel {
      constructor(windowsMainService) {
        super();
        this.windowsMainService = windowsMainService;
      }
      call(ctx, command, arg) {
        if (command === "openExtensionDevelopmentHostWindow") {
          return this.openExtensionDevelopmentHostWindow(arg[0], arg[1]);
        } else {
          return super.call(ctx, command, arg);
        }
      }
      async openExtensionDevelopmentHostWindow(args2, debugRenderer) {
        const pargs = parseArgs(args2, OPTIONS);
        pargs.debugRenderer = debugRenderer;
        const extDevPaths = pargs.extensionDevelopmentPath;
        if (!extDevPaths) {
          return { success: false };
        }
        const [codeWindow] = await this.windowsMainService.openExtensionDevelopmentHostWindow(extDevPaths, {
          context: 5,
          cli: pargs,
          forceProfile: pargs.profile,
          forceTempProfile: pargs["profile-temp"]
        });
        if (!debugRenderer) {
          return { success: true };
        }
        const win = codeWindow.win;
        if (!win) {
          return { success: true };
        }
        const debug = win.webContents.debugger;
        let listeners = debug.isAttached() ? Infinity : 0;
        const server = createServer2((listener) => {
          if (listeners++ === 0) {
            debug.attach();
          }
          let closed = false;
          const writeMessage = (message) => {
            if (!closed) {
              listener.write(JSON.stringify(message) + "\0");
            }
          };
          const onMessage = (_event, method, params, sessionId) => writeMessage({ method, params, sessionId });
          win.on("close", () => {
            debug.removeListener("message", onMessage);
            listener.end();
            closed = true;
          });
          debug.addListener("message", onMessage);
          let buf = Buffer.alloc(0);
          listener.on("data", (data) => {
            buf = Buffer.concat([buf, data]);
            for (let delimiter2 = buf.indexOf(0); delimiter2 !== -1; delimiter2 = buf.indexOf(0)) {
              let data2;
              try {
                const contents = buf.slice(0, delimiter2).toString("utf8");
                buf = buf.slice(delimiter2 + 1);
                data2 = JSON.parse(contents);
              } catch (e) {
                console.error("error reading cdp line", e);
              }
              debug.sendCommand(data2.method, data2.params, data2.sessionId).then((result) => writeMessage({ id: data2.id, sessionId: data2.sessionId, result })).catch((error) => writeMessage({ id: data2.id, sessionId: data2.sessionId, error: { code: 0, message: error.message } }));
            }
          });
          listener.on("error", (err) => {
            console.error("error on cdp pipe:", err);
          });
          listener.on("close", () => {
            closed = true;
            if (--listeners === 0) {
              debug.detach();
            }
          });
        });
        await new Promise((r) => server.listen(0, r));
        win.on("close", () => server.close());
        return { rendererDebugPort: server.address().port, success: true };
      }
    };
  }
});

// out-build/vs/platform/diagnostics/common/diagnostics.js
function isRemoteDiagnosticError(x) {
  const candidate = x;
  return !!candidate?.hostName && !!candidate?.errorMessage;
}
var ID, IDiagnosticsService;
var init_diagnostics = __esm({
  "out-build/vs/platform/diagnostics/common/diagnostics.js"() {
    "use strict";
    init_instantiation();
    ID = "diagnosticsService";
    IDiagnosticsService = createDecorator(ID);
  }
});

// out-build/vs/base/common/json.js
function createScanner(text, ignoreTrivia = false) {
  let pos = 0;
  const len = text.length;
  let value = "";
  let tokenOffset = 0;
  let token = 16;
  let scanError = 0;
  function scanHexDigits(count) {
    let digits = 0;
    let hexValue = 0;
    while (digits < count) {
      const ch = text.charCodeAt(pos);
      if (ch >= 48 && ch <= 57) {
        hexValue = hexValue * 16 + ch - 48;
      } else if (ch >= 65 && ch <= 70) {
        hexValue = hexValue * 16 + ch - 65 + 10;
      } else if (ch >= 97 && ch <= 102) {
        hexValue = hexValue * 16 + ch - 97 + 10;
      } else {
        break;
      }
      pos++;
      digits++;
    }
    if (digits < count) {
      hexValue = -1;
    }
    return hexValue;
  }
  function setPosition(newPosition) {
    pos = newPosition;
    value = "";
    tokenOffset = 0;
    token = 16;
    scanError = 0;
  }
  function scanNumber() {
    const start = pos;
    if (text.charCodeAt(pos) === 48) {
      pos++;
    } else {
      pos++;
      while (pos < text.length && isDigit(text.charCodeAt(pos))) {
        pos++;
      }
    }
    if (pos < text.length && text.charCodeAt(pos) === 46) {
      pos++;
      if (pos < text.length && isDigit(text.charCodeAt(pos))) {
        pos++;
        while (pos < text.length && isDigit(text.charCodeAt(pos))) {
          pos++;
        }
      } else {
        scanError = 3;
        return text.substring(start, pos);
      }
    }
    let end = pos;
    if (pos < text.length && (text.charCodeAt(pos) === 69 || text.charCodeAt(pos) === 101)) {
      pos++;
      if (pos < text.length && text.charCodeAt(pos) === 43 || text.charCodeAt(pos) === 45) {
        pos++;
      }
      if (pos < text.length && isDigit(text.charCodeAt(pos))) {
        pos++;
        while (pos < text.length && isDigit(text.charCodeAt(pos))) {
          pos++;
        }
        end = pos;
      } else {
        scanError = 3;
      }
    }
    return text.substring(start, end);
  }
  function scanString() {
    let result = "", start = pos;
    while (true) {
      if (pos >= len) {
        result += text.substring(start, pos);
        scanError = 2;
        break;
      }
      const ch = text.charCodeAt(pos);
      if (ch === 34) {
        result += text.substring(start, pos);
        pos++;
        break;
      }
      if (ch === 92) {
        result += text.substring(start, pos);
        pos++;
        if (pos >= len) {
          scanError = 2;
          break;
        }
        const ch2 = text.charCodeAt(pos++);
        switch (ch2) {
          case 34:
            result += '"';
            break;
          case 92:
            result += "\\";
            break;
          case 47:
            result += "/";
            break;
          case 98:
            result += "\b";
            break;
          case 102:
            result += "\f";
            break;
          case 110:
            result += "\n";
            break;
          case 114:
            result += "\r";
            break;
          case 116:
            result += "	";
            break;
          case 117: {
            const ch3 = scanHexDigits(4);
            if (ch3 >= 0) {
              result += String.fromCharCode(ch3);
            } else {
              scanError = 4;
            }
            break;
          }
          default:
            scanError = 5;
        }
        start = pos;
        continue;
      }
      if (ch >= 0 && ch <= 31) {
        if (isLineBreak(ch)) {
          result += text.substring(start, pos);
          scanError = 2;
          break;
        } else {
          scanError = 6;
        }
      }
      pos++;
    }
    return result;
  }
  function scanNext() {
    value = "";
    scanError = 0;
    tokenOffset = pos;
    if (pos >= len) {
      tokenOffset = len;
      return token = 17;
    }
    let code2 = text.charCodeAt(pos);
    if (isWhitespace(code2)) {
      do {
        pos++;
        value += String.fromCharCode(code2);
        code2 = text.charCodeAt(pos);
      } while (isWhitespace(code2));
      return token = 15;
    }
    if (isLineBreak(code2)) {
      pos++;
      value += String.fromCharCode(code2);
      if (code2 === 13 && text.charCodeAt(pos) === 10) {
        pos++;
        value += "\n";
      }
      return token = 14;
    }
    switch (code2) {
      // tokens: []{}:,
      case 123:
        pos++;
        return token = 1;
      case 125:
        pos++;
        return token = 2;
      case 91:
        pos++;
        return token = 3;
      case 93:
        pos++;
        return token = 4;
      case 58:
        pos++;
        return token = 6;
      case 44:
        pos++;
        return token = 5;
      // strings
      case 34:
        pos++;
        value = scanString();
        return token = 10;
      // comments
      case 47: {
        const start = pos - 1;
        if (text.charCodeAt(pos + 1) === 47) {
          pos += 2;
          while (pos < len) {
            if (isLineBreak(text.charCodeAt(pos))) {
              break;
            }
            pos++;
          }
          value = text.substring(start, pos);
          return token = 12;
        }
        if (text.charCodeAt(pos + 1) === 42) {
          pos += 2;
          const safeLength = len - 1;
          let commentClosed = false;
          while (pos < safeLength) {
            const ch = text.charCodeAt(pos);
            if (ch === 42 && text.charCodeAt(pos + 1) === 47) {
              pos += 2;
              commentClosed = true;
              break;
            }
            pos++;
          }
          if (!commentClosed) {
            pos++;
            scanError = 1;
          }
          value = text.substring(start, pos);
          return token = 13;
        }
        value += String.fromCharCode(code2);
        pos++;
        return token = 16;
      }
      // numbers
      case 45:
        value += String.fromCharCode(code2);
        pos++;
        if (pos === len || !isDigit(text.charCodeAt(pos))) {
          return token = 16;
        }
      // found a minus, followed by a number so
      // we fall through to proceed with scanning
      // numbers
      case 48:
      case 49:
      case 50:
      case 51:
      case 52:
      case 53:
      case 54:
      case 55:
      case 56:
      case 57:
        value += scanNumber();
        return token = 11;
      // literals and unknown symbols
      default:
        while (pos < len && isUnknownContentCharacter(code2)) {
          pos++;
          code2 = text.charCodeAt(pos);
        }
        if (tokenOffset !== pos) {
          value = text.substring(tokenOffset, pos);
          switch (value) {
            case "true":
              return token = 8;
            case "false":
              return token = 9;
            case "null":
              return token = 7;
          }
          return token = 16;
        }
        value += String.fromCharCode(code2);
        pos++;
        return token = 16;
    }
  }
  function isUnknownContentCharacter(code2) {
    if (isWhitespace(code2) || isLineBreak(code2)) {
      return false;
    }
    switch (code2) {
      case 125:
      case 93:
      case 123:
      case 91:
      case 34:
      case 58:
      case 44:
      case 47:
        return false;
    }
    return true;
  }
  function scanNextNonTrivia() {
    let result;
    do {
      result = scanNext();
    } while (result >= 12 && result <= 15);
    return result;
  }
  return {
    setPosition,
    getPosition: () => pos,
    scan: ignoreTrivia ? scanNextNonTrivia : scanNext,
    getToken: () => token,
    getTokenValue: () => value,
    getTokenOffset: () => tokenOffset,
    getTokenLength: () => pos - tokenOffset,
    getTokenError: () => scanError
  };
}
function isWhitespace(ch) {
  return ch === 32 || ch === 9 || ch === 11 || ch === 12 || ch === 160 || ch === 5760 || ch >= 8192 && ch <= 8203 || ch === 8239 || ch === 8287 || ch === 12288 || ch === 65279;
}
function isLineBreak(ch) {
  return ch === 10 || ch === 13 || ch === 8232 || ch === 8233;
}
function isDigit(ch) {
  return ch >= 48 && ch <= 57;
}
function parse4(text, errors = [], options = ParseOptions.DEFAULT) {
  let currentProperty = null;
  let currentParent = [];
  const previousParents = [];
  function onValue(value) {
    if (Array.isArray(currentParent)) {
      currentParent.push(value);
    } else if (currentProperty !== null) {
      currentParent[currentProperty] = value;
    }
  }
  const visitor = {
    onObjectBegin: () => {
      const object = {};
      onValue(object);
      previousParents.push(currentParent);
      currentParent = object;
      currentProperty = null;
    },
    onObjectProperty: (name) => {
      currentProperty = name;
    },
    onObjectEnd: () => {
      currentParent = previousParents.pop();
    },
    onArrayBegin: () => {
      const array = [];
      onValue(array);
      previousParents.push(currentParent);
      currentParent = array;
      currentProperty = null;
    },
    onArrayEnd: () => {
      currentParent = previousParents.pop();
    },
    onLiteralValue: onValue,
    onError: (error, offset, length) => {
      errors.push({ error, offset, length });
    }
  };
  visit(text, visitor, options);
  return currentParent[0];
}
function parseTree(text, errors = [], options = ParseOptions.DEFAULT) {
  let currentParent = { type: "array", offset: -1, length: -1, children: [], parent: void 0 };
  function ensurePropertyComplete(endOffset) {
    if (currentParent.type === "property") {
      currentParent.length = endOffset - currentParent.offset;
      currentParent = currentParent.parent;
    }
  }
  function onValue(valueNode) {
    currentParent.children.push(valueNode);
    return valueNode;
  }
  const visitor = {
    onObjectBegin: (offset) => {
      currentParent = onValue({ type: "object", offset, length: -1, parent: currentParent, children: [] });
    },
    onObjectProperty: (name, offset, length) => {
      currentParent = onValue({ type: "property", offset, length: -1, parent: currentParent, children: [] });
      currentParent.children.push({ type: "string", value: name, offset, length, parent: currentParent });
    },
    onObjectEnd: (offset, length) => {
      currentParent.length = offset + length - currentParent.offset;
      currentParent = currentParent.parent;
      ensurePropertyComplete(offset + length);
    },
    onArrayBegin: (offset, length) => {
      currentParent = onValue({ type: "array", offset, length: -1, parent: currentParent, children: [] });
    },
    onArrayEnd: (offset, length) => {
      currentParent.length = offset + length - currentParent.offset;
      currentParent = currentParent.parent;
      ensurePropertyComplete(offset + length);
    },
    onLiteralValue: (value, offset, length) => {
      onValue({ type: getNodeType(value), offset, length, parent: currentParent, value });
      ensurePropertyComplete(offset + length);
    },
    onSeparator: (sep2, offset, length) => {
      if (currentParent.type === "property") {
        if (sep2 === ":") {
          currentParent.colonOffset = offset;
        } else if (sep2 === ",") {
          ensurePropertyComplete(offset);
        }
      }
    },
    onError: (error, offset, length) => {
      errors.push({ error, offset, length });
    }
  };
  visit(text, visitor, options);
  const result = currentParent.children[0];
  if (result) {
    delete result.parent;
  }
  return result;
}
function findNodeAtLocation(root, path4) {
  if (!root) {
    return void 0;
  }
  let node = root;
  for (const segment of path4) {
    if (typeof segment === "string") {
      if (node.type !== "object" || !Array.isArray(node.children)) {
        return void 0;
      }
      let found = false;
      for (const propertyNode of node.children) {
        if (Array.isArray(propertyNode.children) && propertyNode.children[0].value === segment) {
          node = propertyNode.children[1];
          found = true;
          break;
        }
      }
      if (!found) {
        return void 0;
      }
    } else {
      const index = segment;
      if (node.type !== "array" || index < 0 || !Array.isArray(node.children) || index >= node.children.length) {
        return void 0;
      }
      node = node.children[index];
    }
  }
  return node;
}
function visit(text, visitor, options = ParseOptions.DEFAULT) {
  const _scanner = createScanner(text, false);
  function toNoArgVisit(visitFunction) {
    return visitFunction ? () => visitFunction(_scanner.getTokenOffset(), _scanner.getTokenLength()) : () => true;
  }
  function toOneArgVisit(visitFunction) {
    return visitFunction ? (arg) => visitFunction(arg, _scanner.getTokenOffset(), _scanner.getTokenLength()) : () => true;
  }
  const onObjectBegin = toNoArgVisit(visitor.onObjectBegin), onObjectProperty = toOneArgVisit(visitor.onObjectProperty), onObjectEnd = toNoArgVisit(visitor.onObjectEnd), onArrayBegin = toNoArgVisit(visitor.onArrayBegin), onArrayEnd = toNoArgVisit(visitor.onArrayEnd), onLiteralValue = toOneArgVisit(visitor.onLiteralValue), onSeparator = toOneArgVisit(visitor.onSeparator), onComment = toNoArgVisit(visitor.onComment), onError = toOneArgVisit(visitor.onError);
  const disallowComments = options && options.disallowComments;
  const allowTrailingComma = options && options.allowTrailingComma;
  function scanNext() {
    while (true) {
      const token = _scanner.scan();
      switch (_scanner.getTokenError()) {
        case 4:
          handleError(
            14
            /* ParseErrorCode.InvalidUnicode */
          );
          break;
        case 5:
          handleError(
            15
            /* ParseErrorCode.InvalidEscapeCharacter */
          );
          break;
        case 3:
          handleError(
            13
            /* ParseErrorCode.UnexpectedEndOfNumber */
          );
          break;
        case 1:
          if (!disallowComments) {
            handleError(
              11
              /* ParseErrorCode.UnexpectedEndOfComment */
            );
          }
          break;
        case 2:
          handleError(
            12
            /* ParseErrorCode.UnexpectedEndOfString */
          );
          break;
        case 6:
          handleError(
            16
            /* ParseErrorCode.InvalidCharacter */
          );
          break;
      }
      switch (token) {
        case 12:
        case 13:
          if (disallowComments) {
            handleError(
              10
              /* ParseErrorCode.InvalidCommentToken */
            );
          } else {
            onComment();
          }
          break;
        case 16:
          handleError(
            1
            /* ParseErrorCode.InvalidSymbol */
          );
          break;
        case 15:
        case 14:
          break;
        default:
          return token;
      }
    }
  }
  function handleError(error, skipUntilAfter = [], skipUntil = []) {
    onError(error);
    if (skipUntilAfter.length + skipUntil.length > 0) {
      let token = _scanner.getToken();
      while (token !== 17) {
        if (skipUntilAfter.indexOf(token) !== -1) {
          scanNext();
          break;
        } else if (skipUntil.indexOf(token) !== -1) {
          break;
        }
        token = scanNext();
      }
    }
  }
  function parseString(isValue) {
    const value = _scanner.getTokenValue();
    if (isValue) {
      onLiteralValue(value);
    } else {
      onObjectProperty(value);
    }
    scanNext();
    return true;
  }
  function parseLiteral() {
    switch (_scanner.getToken()) {
      case 11: {
        let value = 0;
        try {
          value = JSON.parse(_scanner.getTokenValue());
          if (typeof value !== "number") {
            handleError(
              2
              /* ParseErrorCode.InvalidNumberFormat */
            );
            value = 0;
          }
        } catch (e) {
          handleError(
            2
            /* ParseErrorCode.InvalidNumberFormat */
          );
        }
        onLiteralValue(value);
        break;
      }
      case 7:
        onLiteralValue(null);
        break;
      case 8:
        onLiteralValue(true);
        break;
      case 9:
        onLiteralValue(false);
        break;
      default:
        return false;
    }
    scanNext();
    return true;
  }
  function parseProperty() {
    if (_scanner.getToken() !== 10) {
      handleError(3, [], [
        2,
        5
        /* SyntaxKind.CommaToken */
      ]);
      return false;
    }
    parseString(false);
    if (_scanner.getToken() === 6) {
      onSeparator(":");
      scanNext();
      if (!parseValue()) {
        handleError(4, [], [
          2,
          5
          /* SyntaxKind.CommaToken */
        ]);
      }
    } else {
      handleError(5, [], [
        2,
        5
        /* SyntaxKind.CommaToken */
      ]);
    }
    return true;
  }
  function parseObject() {
    onObjectBegin();
    scanNext();
    let needsComma = false;
    while (_scanner.getToken() !== 2 && _scanner.getToken() !== 17) {
      if (_scanner.getToken() === 5) {
        if (!needsComma) {
          handleError(4, [], []);
        }
        onSeparator(",");
        scanNext();
        if (_scanner.getToken() === 2 && allowTrailingComma) {
          break;
        }
      } else if (needsComma) {
        handleError(6, [], []);
      }
      if (!parseProperty()) {
        handleError(4, [], [
          2,
          5
          /* SyntaxKind.CommaToken */
        ]);
      }
      needsComma = true;
    }
    onObjectEnd();
    if (_scanner.getToken() !== 2) {
      handleError(7, [
        2
        /* SyntaxKind.CloseBraceToken */
      ], []);
    } else {
      scanNext();
    }
    return true;
  }
  function parseArray() {
    onArrayBegin();
    scanNext();
    let needsComma = false;
    while (_scanner.getToken() !== 4 && _scanner.getToken() !== 17) {
      if (_scanner.getToken() === 5) {
        if (!needsComma) {
          handleError(4, [], []);
        }
        onSeparator(",");
        scanNext();
        if (_scanner.getToken() === 4 && allowTrailingComma) {
          break;
        }
      } else if (needsComma) {
        handleError(6, [], []);
      }
      if (!parseValue()) {
        handleError(4, [], [
          4,
          5
          /* SyntaxKind.CommaToken */
        ]);
      }
      needsComma = true;
    }
    onArrayEnd();
    if (_scanner.getToken() !== 4) {
      handleError(8, [
        4
        /* SyntaxKind.CloseBracketToken */
      ], []);
    } else {
      scanNext();
    }
    return true;
  }
  function parseValue() {
    switch (_scanner.getToken()) {
      case 3:
        return parseArray();
      case 1:
        return parseObject();
      case 10:
        return parseString(true);
      default:
        return parseLiteral();
    }
  }
  scanNext();
  if (_scanner.getToken() === 17) {
    if (options.allowEmptyContent) {
      return true;
    }
    handleError(4, [], []);
    return false;
  }
  if (!parseValue()) {
    handleError(4, [], []);
    return false;
  }
  if (_scanner.getToken() !== 17) {
    handleError(9, [], []);
  }
  return true;
}
function getNodeType(value) {
  switch (typeof value) {
    case "boolean":
      return "boolean";
    case "number":
      return "number";
    case "string":
      return "string";
    case "object": {
      if (!value) {
        return "null";
      } else if (Array.isArray(value)) {
        return "array";
      }
      return "object";
    }
    default:
      return "null";
  }
}
var ScanError, SyntaxKind, ParseErrorCode, ParseOptions, CharacterCodes;
var init_json = __esm({
  "out-build/vs/base/common/json.js"() {
    "use strict";
    (function(ScanError2) {
      ScanError2[ScanError2["None"] = 0] = "None";
      ScanError2[ScanError2["UnexpectedEndOfComment"] = 1] = "UnexpectedEndOfComment";
      ScanError2[ScanError2["UnexpectedEndOfString"] = 2] = "UnexpectedEndOfString";
      ScanError2[ScanError2["UnexpectedEndOfNumber"] = 3] = "UnexpectedEndOfNumber";
      ScanError2[ScanError2["InvalidUnicode"] = 4] = "InvalidUnicode";
      ScanError2[ScanError2["InvalidEscapeCharacter"] = 5] = "InvalidEscapeCharacter";
      ScanError2[ScanError2["InvalidCharacter"] = 6] = "InvalidCharacter";
    })(ScanError || (ScanError = {}));
    (function(SyntaxKind2) {
      SyntaxKind2[SyntaxKind2["OpenBraceToken"] = 1] = "OpenBraceToken";
      SyntaxKind2[SyntaxKind2["CloseBraceToken"] = 2] = "CloseBraceToken";
      SyntaxKind2[SyntaxKind2["OpenBracketToken"] = 3] = "OpenBracketToken";
      SyntaxKind2[SyntaxKind2["CloseBracketToken"] = 4] = "CloseBracketToken";
      SyntaxKind2[SyntaxKind2["CommaToken"] = 5] = "CommaToken";
      SyntaxKind2[SyntaxKind2["ColonToken"] = 6] = "ColonToken";
      SyntaxKind2[SyntaxKind2["NullKeyword"] = 7] = "NullKeyword";
      SyntaxKind2[SyntaxKind2["TrueKeyword"] = 8] = "TrueKeyword";
      SyntaxKind2[SyntaxKind2["FalseKeyword"] = 9] = "FalseKeyword";
      SyntaxKind2[SyntaxKind2["StringLiteral"] = 10] = "StringLiteral";
      SyntaxKind2[SyntaxKind2["NumericLiteral"] = 11] = "NumericLiteral";
      SyntaxKind2[SyntaxKind2["LineCommentTrivia"] = 12] = "LineCommentTrivia";
      SyntaxKind2[SyntaxKind2["BlockCommentTrivia"] = 13] = "BlockCommentTrivia";
      SyntaxKind2[SyntaxKind2["LineBreakTrivia"] = 14] = "LineBreakTrivia";
      SyntaxKind2[SyntaxKind2["Trivia"] = 15] = "Trivia";
      SyntaxKind2[SyntaxKind2["Unknown"] = 16] = "Unknown";
      SyntaxKind2[SyntaxKind2["EOF"] = 17] = "EOF";
    })(SyntaxKind || (SyntaxKind = {}));
    (function(ParseErrorCode2) {
      ParseErrorCode2[ParseErrorCode2["InvalidSymbol"] = 1] = "InvalidSymbol";
      ParseErrorCode2[ParseErrorCode2["InvalidNumberFormat"] = 2] = "InvalidNumberFormat";
      ParseErrorCode2[ParseErrorCode2["PropertyNameExpected"] = 3] = "PropertyNameExpected";
      ParseErrorCode2[ParseErrorCode2["ValueExpected"] = 4] = "ValueExpected";
      ParseErrorCode2[ParseErrorCode2["ColonExpected"] = 5] = "ColonExpected";
      ParseErrorCode2[ParseErrorCode2["CommaExpected"] = 6] = "CommaExpected";
      ParseErrorCode2[ParseErrorCode2["CloseBraceExpected"] = 7] = "CloseBraceExpected";
      ParseErrorCode2[ParseErrorCode2["CloseBracketExpected"] = 8] = "CloseBracketExpected";
      ParseErrorCode2[ParseErrorCode2["EndOfFileExpected"] = 9] = "EndOfFileExpected";
      ParseErrorCode2[ParseErrorCode2["InvalidCommentToken"] = 10] = "InvalidCommentToken";
      ParseErrorCode2[ParseErrorCode2["UnexpectedEndOfComment"] = 11] = "UnexpectedEndOfComment";
      ParseErrorCode2[ParseErrorCode2["UnexpectedEndOfString"] = 12] = "UnexpectedEndOfString";
      ParseErrorCode2[ParseErrorCode2["UnexpectedEndOfNumber"] = 13] = "UnexpectedEndOfNumber";
      ParseErrorCode2[ParseErrorCode2["InvalidUnicode"] = 14] = "InvalidUnicode";
      ParseErrorCode2[ParseErrorCode2["InvalidEscapeCharacter"] = 15] = "InvalidEscapeCharacter";
      ParseErrorCode2[ParseErrorCode2["InvalidCharacter"] = 16] = "InvalidCharacter";
    })(ParseErrorCode || (ParseErrorCode = {}));
    (function(ParseOptions2) {
      ParseOptions2.DEFAULT = {
        allowTrailingComma: true
      };
    })(ParseOptions || (ParseOptions = {}));
    (function(CharacterCodes2) {
      CharacterCodes2[CharacterCodes2["nullCharacter"] = 0] = "nullCharacter";
      CharacterCodes2[CharacterCodes2["maxAsciiCharacter"] = 127] = "maxAsciiCharacter";
      CharacterCodes2[CharacterCodes2["lineFeed"] = 10] = "lineFeed";
      CharacterCodes2[CharacterCodes2["carriageReturn"] = 13] = "carriageReturn";
      CharacterCodes2[CharacterCodes2["lineSeparator"] = 8232] = "lineSeparator";
      CharacterCodes2[CharacterCodes2["paragraphSeparator"] = 8233] = "paragraphSeparator";
      CharacterCodes2[CharacterCodes2["nextLine"] = 133] = "nextLine";
      CharacterCodes2[CharacterCodes2["space"] = 32] = "space";
      CharacterCodes2[CharacterCodes2["nonBreakingSpace"] = 160] = "nonBreakingSpace";
      CharacterCodes2[CharacterCodes2["enQuad"] = 8192] = "enQuad";
      CharacterCodes2[CharacterCodes2["emQuad"] = 8193] = "emQuad";
      CharacterCodes2[CharacterCodes2["enSpace"] = 8194] = "enSpace";
      CharacterCodes2[CharacterCodes2["emSpace"] = 8195] = "emSpace";
      CharacterCodes2[CharacterCodes2["threePerEmSpace"] = 8196] = "threePerEmSpace";
      CharacterCodes2[CharacterCodes2["fourPerEmSpace"] = 8197] = "fourPerEmSpace";
      CharacterCodes2[CharacterCodes2["sixPerEmSpace"] = 8198] = "sixPerEmSpace";
      CharacterCodes2[CharacterCodes2["figureSpace"] = 8199] = "figureSpace";
      CharacterCodes2[CharacterCodes2["punctuationSpace"] = 8200] = "punctuationSpace";
      CharacterCodes2[CharacterCodes2["thinSpace"] = 8201] = "thinSpace";
      CharacterCodes2[CharacterCodes2["hairSpace"] = 8202] = "hairSpace";
      CharacterCodes2[CharacterCodes2["zeroWidthSpace"] = 8203] = "zeroWidthSpace";
      CharacterCodes2[CharacterCodes2["narrowNoBreakSpace"] = 8239] = "narrowNoBreakSpace";
      CharacterCodes2[CharacterCodes2["ideographicSpace"] = 12288] = "ideographicSpace";
      CharacterCodes2[CharacterCodes2["mathematicalSpace"] = 8287] = "mathematicalSpace";
      CharacterCodes2[CharacterCodes2["ogham"] = 5760] = "ogham";
      CharacterCodes2[CharacterCodes2["_"] = 95] = "_";
      CharacterCodes2[CharacterCodes2["$"] = 36] = "$";
      CharacterCodes2[CharacterCodes2["_0"] = 48] = "_0";
      CharacterCodes2[CharacterCodes2["_1"] = 49] = "_1";
      CharacterCodes2[CharacterCodes2["_2"] = 50] = "_2";
      CharacterCodes2[CharacterCodes2["_3"] = 51] = "_3";
      CharacterCodes2[CharacterCodes2["_4"] = 52] = "_4";
      CharacterCodes2[CharacterCodes2["_5"] = 53] = "_5";
      CharacterCodes2[CharacterCodes2["_6"] = 54] = "_6";
      CharacterCodes2[CharacterCodes2["_7"] = 55] = "_7";
      CharacterCodes2[CharacterCodes2["_8"] = 56] = "_8";
      CharacterCodes2[CharacterCodes2["_9"] = 57] = "_9";
      CharacterCodes2[CharacterCodes2["a"] = 97] = "a";
      CharacterCodes2[CharacterCodes2["b"] = 98] = "b";
      CharacterCodes2[CharacterCodes2["c"] = 99] = "c";
      CharacterCodes2[CharacterCodes2["d"] = 100] = "d";
      CharacterCodes2[CharacterCodes2["e"] = 101] = "e";
      CharacterCodes2[CharacterCodes2["f"] = 102] = "f";
      CharacterCodes2[CharacterCodes2["g"] = 103] = "g";
      CharacterCodes2[CharacterCodes2["h"] = 104] = "h";
      CharacterCodes2[CharacterCodes2["i"] = 105] = "i";
      CharacterCodes2[CharacterCodes2["j"] = 106] = "j";
      CharacterCodes2[CharacterCodes2["k"] = 107] = "k";
      CharacterCodes2[CharacterCodes2["l"] = 108] = "l";
      CharacterCodes2[CharacterCodes2["m"] = 109] = "m";
      CharacterCodes2[CharacterCodes2["n"] = 110] = "n";
      CharacterCodes2[CharacterCodes2["o"] = 111] = "o";
      CharacterCodes2[CharacterCodes2["p"] = 112] = "p";
      CharacterCodes2[CharacterCodes2["q"] = 113] = "q";
      CharacterCodes2[CharacterCodes2["r"] = 114] = "r";
      CharacterCodes2[CharacterCodes2["s"] = 115] = "s";
      CharacterCodes2[CharacterCodes2["t"] = 116] = "t";
      CharacterCodes2[CharacterCodes2["u"] = 117] = "u";
      CharacterCodes2[CharacterCodes2["v"] = 118] = "v";
      CharacterCodes2[CharacterCodes2["w"] = 119] = "w";
      CharacterCodes2[CharacterCodes2["x"] = 120] = "x";
      CharacterCodes2[CharacterCodes2["y"] = 121] = "y";
      CharacterCodes2[CharacterCodes2["z"] = 122] = "z";
      CharacterCodes2[CharacterCodes2["A"] = 65] = "A";
      CharacterCodes2[CharacterCodes2["B"] = 66] = "B";
      CharacterCodes2[CharacterCodes2["C"] = 67] = "C";
      CharacterCodes2[CharacterCodes2["D"] = 68] = "D";
      CharacterCodes2[CharacterCodes2["E"] = 69] = "E";
      CharacterCodes2[CharacterCodes2["F"] = 70] = "F";
      CharacterCodes2[CharacterCodes2["G"] = 71] = "G";
      CharacterCodes2[CharacterCodes2["H"] = 72] = "H";
      CharacterCodes2[CharacterCodes2["I"] = 73] = "I";
      CharacterCodes2[CharacterCodes2["J"] = 74] = "J";
      CharacterCodes2[CharacterCodes2["K"] = 75] = "K";
      CharacterCodes2[CharacterCodes2["L"] = 76] = "L";
      CharacterCodes2[CharacterCodes2["M"] = 77] = "M";
      CharacterCodes2[CharacterCodes2["N"] = 78] = "N";
      CharacterCodes2[CharacterCodes2["O"] = 79] = "O";
      CharacterCodes2[CharacterCodes2["P"] = 80] = "P";
      CharacterCodes2[CharacterCodes2["Q"] = 81] = "Q";
      CharacterCodes2[CharacterCodes2["R"] = 82] = "R";
      CharacterCodes2[CharacterCodes2["S"] = 83] = "S";
      CharacterCodes2[CharacterCodes2["T"] = 84] = "T";
      CharacterCodes2[CharacterCodes2["U"] = 85] = "U";
      CharacterCodes2[CharacterCodes2["V"] = 86] = "V";
      CharacterCodes2[CharacterCodes2["W"] = 87] = "W";
      CharacterCodes2[CharacterCodes2["X"] = 88] = "X";
      CharacterCodes2[CharacterCodes2["Y"] = 89] = "Y";
      CharacterCodes2[CharacterCodes2["Z"] = 90] = "Z";
      CharacterCodes2[CharacterCodes2["ampersand"] = 38] = "ampersand";
      CharacterCodes2[CharacterCodes2["asterisk"] = 42] = "asterisk";
      CharacterCodes2[CharacterCodes2["at"] = 64] = "at";
      CharacterCodes2[CharacterCodes2["backslash"] = 92] = "backslash";
      CharacterCodes2[CharacterCodes2["bar"] = 124] = "bar";
      CharacterCodes2[CharacterCodes2["caret"] = 94] = "caret";
      CharacterCodes2[CharacterCodes2["closeBrace"] = 125] = "closeBrace";
      CharacterCodes2[CharacterCodes2["closeBracket"] = 93] = "closeBracket";
      CharacterCodes2[CharacterCodes2["closeParen"] = 41] = "closeParen";
      CharacterCodes2[CharacterCodes2["colon"] = 58] = "colon";
      CharacterCodes2[CharacterCodes2["comma"] = 44] = "comma";
      CharacterCodes2[CharacterCodes2["dot"] = 46] = "dot";
      CharacterCodes2[CharacterCodes2["doubleQuote"] = 34] = "doubleQuote";
      CharacterCodes2[CharacterCodes2["equals"] = 61] = "equals";
      CharacterCodes2[CharacterCodes2["exclamation"] = 33] = "exclamation";
      CharacterCodes2[CharacterCodes2["greaterThan"] = 62] = "greaterThan";
      CharacterCodes2[CharacterCodes2["lessThan"] = 60] = "lessThan";
      CharacterCodes2[CharacterCodes2["minus"] = 45] = "minus";
      CharacterCodes2[CharacterCodes2["openBrace"] = 123] = "openBrace";
      CharacterCodes2[CharacterCodes2["openBracket"] = 91] = "openBracket";
      CharacterCodes2[CharacterCodes2["openParen"] = 40] = "openParen";
      CharacterCodes2[CharacterCodes2["percent"] = 37] = "percent";
      CharacterCodes2[CharacterCodes2["plus"] = 43] = "plus";
      CharacterCodes2[CharacterCodes2["question"] = 63] = "question";
      CharacterCodes2[CharacterCodes2["semicolon"] = 59] = "semicolon";
      CharacterCodes2[CharacterCodes2["singleQuote"] = 39] = "singleQuote";
      CharacterCodes2[CharacterCodes2["slash"] = 47] = "slash";
      CharacterCodes2[CharacterCodes2["tilde"] = 126] = "tilde";
      CharacterCodes2[CharacterCodes2["backspace"] = 8] = "backspace";
      CharacterCodes2[CharacterCodes2["formFeed"] = 12] = "formFeed";
      CharacterCodes2[CharacterCodes2["byteOrderMark"] = 65279] = "byteOrderMark";
      CharacterCodes2[CharacterCodes2["tab"] = 9] = "tab";
      CharacterCodes2[CharacterCodes2["verticalTab"] = 11] = "verticalTab";
    })(CharacterCodes || (CharacterCodes = {}));
  }
});

// out-build/vs/base/common/severity.js
var Severity, severity_default;
var init_severity = __esm({
  "out-build/vs/base/common/severity.js"() {
    "use strict";
    init_strings();
    (function(Severity2) {
      Severity2[Severity2["Ignore"] = 0] = "Ignore";
      Severity2[Severity2["Info"] = 1] = "Info";
      Severity2[Severity2["Warning"] = 2] = "Warning";
      Severity2[Severity2["Error"] = 3] = "Error";
    })(Severity || (Severity = {}));
    (function(Severity2) {
      const _error = "error";
      const _warning = "warning";
      const _warn = "warn";
      const _info = "info";
      const _ignore = "ignore";
      function fromValue(value) {
        if (!value) {
          return Severity2.Ignore;
        }
        if (equalsIgnoreCase(_error, value)) {
          return Severity2.Error;
        }
        if (equalsIgnoreCase(_warning, value) || equalsIgnoreCase(_warn, value)) {
          return Severity2.Warning;
        }
        if (equalsIgnoreCase(_info, value)) {
          return Severity2.Info;
        }
        return Severity2.Ignore;
      }
      Severity2.fromValue = fromValue;
      function toString(severity) {
        switch (severity) {
          case Severity2.Error:
            return _error;
          case Severity2.Warning:
            return _warning;
          case Severity2.Info:
            return _info;
          default:
            return _ignore;
        }
      }
      Severity2.toString = toString;
    })(Severity || (Severity = {}));
    severity_default = Severity;
  }
});

// out-build/vs/base/common/objects.js
function deepClone(obj) {
  if (!obj || typeof obj !== "object") {
    return obj;
  }
  if (obj instanceof RegExp) {
    return obj;
  }
  const result = Array.isArray(obj) ? [] : {};
  Object.entries(obj).forEach(([key, value]) => {
    result[key] = value && typeof value === "object" ? deepClone(value) : value;
  });
  return result;
}
function deepFreeze(obj) {
  if (!obj || typeof obj !== "object") {
    return obj;
  }
  const stack = [obj];
  while (stack.length > 0) {
    const obj2 = stack.shift();
    Object.freeze(obj2);
    for (const key in obj2) {
      if (_hasOwnProperty.call(obj2, key)) {
        const prop = obj2[key];
        if (typeof prop === "object" && !Object.isFrozen(prop) && !isTypedArray(prop)) {
          stack.push(prop);
        }
      }
    }
  }
  return obj;
}
function cloneAndChange(obj, changer) {
  return _cloneAndChange(obj, changer, /* @__PURE__ */ new Set());
}
function _cloneAndChange(obj, changer, seen) {
  if (isUndefinedOrNull(obj)) {
    return obj;
  }
  const changed = changer(obj);
  if (typeof changed !== "undefined") {
    return changed;
  }
  if (Array.isArray(obj)) {
    const r1 = [];
    for (const e of obj) {
      r1.push(_cloneAndChange(e, changer, seen));
    }
    return r1;
  }
  if (isObject(obj)) {
    if (seen.has(obj)) {
      throw new Error("Cannot clone recursive data-structure");
    }
    seen.add(obj);
    const r2 = {};
    for (const i2 in obj) {
      if (_hasOwnProperty.call(obj, i2)) {
        r2[i2] = _cloneAndChange(obj[i2], changer, seen);
      }
    }
    seen.delete(obj);
    return r2;
  }
  return obj;
}
function mixin(destination, source, overwrite = true) {
  if (!isObject(destination)) {
    return source;
  }
  if (isObject(source)) {
    Object.keys(source).forEach((key) => {
      if (key in destination) {
        if (overwrite) {
          if (isObject(destination[key]) && isObject(source[key])) {
            mixin(destination[key], source[key], overwrite);
          } else {
            destination[key] = source[key];
          }
        }
      } else {
        destination[key] = source[key];
      }
    });
  }
  return destination;
}
function equals2(one, other) {
  if (one === other) {
    return true;
  }
  if (one === null || one === void 0 || other === null || other === void 0) {
    return false;
  }
  if (typeof one !== typeof other) {
    return false;
  }
  if (typeof one !== "object") {
    return false;
  }
  if (Array.isArray(one) !== Array.isArray(other)) {
    return false;
  }
  let i;
  let key;
  if (Array.isArray(one)) {
    if (one.length !== other.length) {
      return false;
    }
    for (i = 0; i < one.length; i++) {
      if (!equals2(one[i], other[i])) {
        return false;
      }
    }
  } else {
    const oneKeys = [];
    for (key in one) {
      oneKeys.push(key);
    }
    oneKeys.sort();
    const otherKeys = [];
    for (key in other) {
      otherKeys.push(key);
    }
    otherKeys.sort();
    if (!equals2(oneKeys, otherKeys)) {
      return false;
    }
    for (i = 0; i < oneKeys.length; i++) {
      if (!equals2(one[oneKeys[i]], other[oneKeys[i]])) {
        return false;
      }
    }
  }
  return true;
}
function safeStringify(obj) {
  const seen = /* @__PURE__ */ new Set();
  return JSON.stringify(obj, (key, value) => {
    if (isObject(value) || Array.isArray(value)) {
      if (seen.has(value)) {
        return "[Circular]";
      } else {
        seen.add(value);
      }
    }
    if (typeof value === "bigint") {
      return `[BigInt ${value.toString()}]`;
    }
    return value;
  });
}
function getCaseInsensitive(target, key) {
  const lowercaseKey = key.toLowerCase();
  const equivalentKey = Object.keys(target).find((k) => k.toLowerCase() === lowercaseKey);
  return equivalentKey ? target[equivalentKey] : target[key];
}
var _hasOwnProperty;
var init_objects = __esm({
  "out-build/vs/base/common/objects.js"() {
    "use strict";
    init_types();
    _hasOwnProperty = Object.prototype.hasOwnProperty;
  }
});

// out-build/vs/platform/dialogs/common/dialogs.js
function massageMessageBoxOptions(options, productService) {
  const massagedOptions = deepClone(options);
  let buttons = (massagedOptions.buttons ?? []).map((button) => mnemonicButtonLabel(button).withMnemonic);
  let buttonIndeces = (options.buttons || []).map((button, index) => index);
  let defaultId = 0;
  let cancelId = massagedOptions.cancelId ?? buttons.length - 1;
  if (buttons.length > 1) {
    const cancelButton = typeof cancelId === "number" ? buttons[cancelId] : void 0;
    if (isLinux || isMacintosh) {
      if (typeof cancelButton === "string" && buttons.length > 1 && cancelId !== 1) {
        buttons.splice(cancelId, 1);
        buttons.splice(1, 0, cancelButton);
        const cancelButtonIndex = buttonIndeces[cancelId];
        buttonIndeces.splice(cancelId, 1);
        buttonIndeces.splice(1, 0, cancelButtonIndex);
        cancelId = 1;
      }
      if (isLinux && buttons.length > 1) {
        buttons = buttons.reverse();
        buttonIndeces = buttonIndeces.reverse();
        defaultId = buttons.length - 1;
        if (typeof cancelButton === "string") {
          cancelId = defaultId - 1;
        }
      }
    } else if (isWindows2) {
      if (typeof cancelButton === "string" && buttons.length > 1 && cancelId !== buttons.length - 1) {
        buttons.splice(cancelId, 1);
        buttons.push(cancelButton);
        const buttonIndex = buttonIndeces[cancelId];
        buttonIndeces.splice(cancelId, 1);
        buttonIndeces.push(buttonIndex);
        cancelId = buttons.length - 1;
      }
    }
  }
  massagedOptions.buttons = buttons;
  massagedOptions.defaultId = defaultId;
  massagedOptions.cancelId = cancelId;
  massagedOptions.noLink = true;
  massagedOptions.title = massagedOptions.title || productService.nameLong;
  return {
    options: massagedOptions,
    buttonIndeces
  };
}
var IDialogService, DialogKind, IFileDialogService, ConfirmResult;
var init_dialogs = __esm({
  "out-build/vs/platform/dialogs/common/dialogs.js"() {
    "use strict";
    init_resources();
    init_severity();
    init_nls();
    init_instantiation();
    init_labels();
    init_platform();
    init_objects();
    IDialogService = createDecorator("dialogService");
    (function(DialogKind2) {
      DialogKind2[DialogKind2["Confirmation"] = 1] = "Confirmation";
      DialogKind2[DialogKind2["Prompt"] = 2] = "Prompt";
      DialogKind2[DialogKind2["Input"] = 3] = "Input";
    })(DialogKind || (DialogKind = {}));
    IFileDialogService = createDecorator("fileDialogService");
    (function(ConfirmResult2) {
      ConfirmResult2[ConfirmResult2["SAVE"] = 0] = "SAVE";
      ConfirmResult2[ConfirmResult2["DONT_SAVE"] = 1] = "DONT_SAVE";
      ConfirmResult2[ConfirmResult2["CANCEL"] = 2] = "CANCEL";
    })(ConfirmResult || (ConfirmResult = {}));
  }
});

// out-build/vs/platform/dialogs/electron-main/dialogMainService.js
import electron6 from "electron";
var IDialogMainService, DialogMainService;
var init_dialogMainService = __esm({
  "out-build/vs/platform/dialogs/electron-main/dialogMainService.js"() {
    "use strict";
    init_async();
    init_hash();
    init_labels();
    init_lifecycle();
    init_normalization();
    init_platform();
    init_pfs();
    init_nls();
    init_dialogs();
    init_instantiation();
    init_log();
    init_productService();
    init_workspace();
    IDialogMainService = createDecorator("dialogMainService");
    DialogMainService = class DialogMainService2 {
      constructor(logService, productService) {
        this.logService = logService;
        this.productService = productService;
        this.windowFileDialogLocks = /* @__PURE__ */ new Map();
        this.windowDialogQueues = /* @__PURE__ */ new Map();
        this.noWindowDialogueQueue = new Queue();
      }
      pickFileFolder(options, window) {
        return this.doPick({ ...options, pickFolders: true, pickFiles: true, title: localize(1832, null) }, window);
      }
      pickFolder(options, window) {
        return this.doPick({ ...options, pickFolders: true, title: localize(1833, null) }, window);
      }
      pickFile(options, window) {
        return this.doPick({ ...options, pickFiles: true, title: localize(1834, null) }, window);
      }
      pickWorkspace(options, window) {
        const title = localize(1835, null);
        const buttonLabel = mnemonicButtonLabel(localize(1836, null)).withMnemonic;
        const filters = WORKSPACE_FILTER;
        return this.doPick({ ...options, pickFiles: true, title, filters, buttonLabel }, window);
      }
      async doPick(options, window) {
        const dialogOptions = {
          title: options.title,
          buttonLabel: options.buttonLabel,
          filters: options.filters,
          defaultPath: options.defaultPath
        };
        if (typeof options.pickFiles === "boolean" || typeof options.pickFolders === "boolean") {
          dialogOptions.properties = void 0;
          if (options.pickFiles && options.pickFolders) {
            dialogOptions.properties = ["multiSelections", "openDirectory", "openFile", "createDirectory"];
          }
        }
        if (!dialogOptions.properties) {
          dialogOptions.properties = ["multiSelections", options.pickFolders ? "openDirectory" : "openFile", "createDirectory"];
        }
        if (isMacintosh) {
          dialogOptions.properties.push("treatPackageAsDirectory");
        }
        const result = await this.showOpenDialog(dialogOptions, (window || electron6.BrowserWindow.getFocusedWindow()) ?? void 0);
        if (result && result.filePaths && result.filePaths.length > 0) {
          return result.filePaths;
        }
        return void 0;
      }
      getWindowDialogQueue(window) {
        if (window) {
          let windowDialogQueue = this.windowDialogQueues.get(window.id);
          if (!windowDialogQueue) {
            windowDialogQueue = new Queue();
            this.windowDialogQueues.set(window.id, windowDialogQueue);
          }
          return windowDialogQueue;
        } else {
          return this.noWindowDialogueQueue;
        }
      }
      showMessageBox(rawOptions, window) {
        return this.getWindowDialogQueue(window).queue(async () => {
          const { options, buttonIndeces } = massageMessageBoxOptions(rawOptions, this.productService);
          let result = void 0;
          if (window) {
            result = await electron6.dialog.showMessageBox(window, options);
          } else {
            result = await electron6.dialog.showMessageBox(options);
          }
          return {
            response: buttonIndeces[result.response],
            checkboxChecked: result.checkboxChecked
          };
        });
      }
      async showSaveDialog(options, window) {
        const fileDialogLock = this.acquireFileDialogLock(options, window);
        if (!fileDialogLock) {
          this.logService.error("[DialogMainService]: file save dialog is already or will be showing for the window with the same configuration");
          return { canceled: true, filePath: "" };
        }
        try {
          return await this.getWindowDialogQueue(window).queue(async () => {
            let result;
            if (window) {
              result = await electron6.dialog.showSaveDialog(window, options);
            } else {
              result = await electron6.dialog.showSaveDialog(options);
            }
            result.filePath = this.normalizePath(result.filePath);
            return result;
          });
        } finally {
          dispose(fileDialogLock);
        }
      }
      normalizePath(path4) {
        if (path4 && isMacintosh) {
          path4 = normalizeNFC(path4);
        }
        return path4;
      }
      normalizePaths(paths) {
        return paths.map((path4) => this.normalizePath(path4));
      }
      async showOpenDialog(options, window) {
        if (options.defaultPath) {
          const pathExists = await Promises2.exists(options.defaultPath);
          if (!pathExists) {
            options.defaultPath = void 0;
          }
        }
        const fileDialogLock = this.acquireFileDialogLock(options, window);
        if (!fileDialogLock) {
          this.logService.error("[DialogMainService]: file open dialog is already or will be showing for the window with the same configuration");
          return { canceled: true, filePaths: [] };
        }
        try {
          return await this.getWindowDialogQueue(window).queue(async () => {
            let result;
            if (window) {
              result = await electron6.dialog.showOpenDialog(window, options);
            } else {
              result = await electron6.dialog.showOpenDialog(options);
            }
            result.filePaths = this.normalizePaths(result.filePaths);
            return result;
          });
        } finally {
          dispose(fileDialogLock);
        }
      }
      acquireFileDialogLock(options, window) {
        if (!window) {
          return Disposable.None;
        }
        this.logService.trace("[DialogMainService]: request to acquire file dialog lock", options);
        let windowFileDialogLocks = this.windowFileDialogLocks.get(window.id);
        if (!windowFileDialogLocks) {
          windowFileDialogLocks = /* @__PURE__ */ new Set();
          this.windowFileDialogLocks.set(window.id, windowFileDialogLocks);
        }
        const optionsHash = hash(options);
        if (windowFileDialogLocks.has(optionsHash)) {
          return void 0;
        }
        this.logService.trace("[DialogMainService]: new file dialog lock created", options);
        windowFileDialogLocks.add(optionsHash);
        return toDisposable(() => {
          this.logService.trace("[DialogMainService]: file dialog lock disposed", options);
          windowFileDialogLocks?.delete(optionsHash);
          if (windowFileDialogLocks?.size === 0) {
            this.windowFileDialogLocks.delete(window.id);
          }
        });
      }
    };
    DialogMainService = __decorate([
      __param(0, ILogService),
      __param(1, IProductService)
    ], DialogMainService);
  }
});

// out-build/vs/platform/windows/electron-main/windowsFinder.js
async function findWindowOnFile(windows, fileUri, localWorkspaceResolver) {
  for (const window of windows) {
    const workspace = window.openedWorkspace;
    if (isWorkspaceIdentifier(workspace)) {
      const resolvedWorkspace = await localWorkspaceResolver(workspace);
      if (resolvedWorkspace) {
        if (resolvedWorkspace.folders.some((folder) => extUriBiasedIgnorePathCase.isEqualOrParent(fileUri, folder.uri))) {
          return window;
        }
      } else {
        if (extUriBiasedIgnorePathCase.isEqualOrParent(fileUri, workspace.configPath)) {
          return window;
        }
      }
    }
  }
  const singleFolderWindowsOnFilePath = windows.filter((window) => isSingleFolderWorkspaceIdentifier(window.openedWorkspace) && extUriBiasedIgnorePathCase.isEqualOrParent(fileUri, window.openedWorkspace.uri));
  if (singleFolderWindowsOnFilePath.length) {
    return singleFolderWindowsOnFilePath.sort((windowA, windowB) => -(windowA.openedWorkspace.uri.path.length - windowB.openedWorkspace.uri.path.length))[0];
  }
  return void 0;
}
function findWindowOnWorkspaceOrFolder(windows, folderOrWorkspaceConfigUri) {
  for (const window of windows) {
    if (isWorkspaceIdentifier(window.openedWorkspace) && extUriBiasedIgnorePathCase.isEqual(window.openedWorkspace.configPath, folderOrWorkspaceConfigUri)) {
      return window;
    }
    if (isSingleFolderWorkspaceIdentifier(window.openedWorkspace) && extUriBiasedIgnorePathCase.isEqual(window.openedWorkspace.uri, folderOrWorkspaceConfigUri)) {
      return window;
    }
  }
  return void 0;
}
function findWindowOnExtensionDevelopmentPath(windows, extensionDevelopmentPaths) {
  const matches = (uriString) => {
    return extensionDevelopmentPaths.some((path4) => extUriBiasedIgnorePathCase.isEqual(URI.file(path4), URI.file(uriString)));
  };
  for (const window of windows) {
    if (window.config?.extensionDevelopmentPath?.some((path4) => matches(path4))) {
      return window;
    }
  }
  return void 0;
}
var init_windowsFinder = __esm({
  "out-build/vs/platform/windows/electron-main/windowsFinder.js"() {
    "use strict";
    init_resources();
    init_uri();
    init_workspace();
  }
});

// out-build/vs/base/common/jsonFormatter.js
function format3(documentText, range, options) {
  let initialIndentLevel;
  let formatText;
  let formatTextStart;
  let rangeStart;
  let rangeEnd;
  if (range) {
    rangeStart = range.offset;
    rangeEnd = rangeStart + range.length;
    formatTextStart = rangeStart;
    while (formatTextStart > 0 && !isEOL(documentText, formatTextStart - 1)) {
      formatTextStart--;
    }
    let endOffset = rangeEnd;
    while (endOffset < documentText.length && !isEOL(documentText, endOffset)) {
      endOffset++;
    }
    formatText = documentText.substring(formatTextStart, endOffset);
    initialIndentLevel = computeIndentLevel(formatText, options);
  } else {
    formatText = documentText;
    initialIndentLevel = 0;
    formatTextStart = 0;
    rangeStart = 0;
    rangeEnd = documentText.length;
  }
  const eol = getEOL(options, documentText);
  let lineBreak = false;
  let indentLevel = 0;
  let indentValue;
  if (options.insertSpaces) {
    indentValue = repeat(" ", options.tabSize || 4);
  } else {
    indentValue = "	";
  }
  const scanner = createScanner(formatText, false);
  let hasError = false;
  function newLineAndIndent() {
    return eol + repeat(indentValue, initialIndentLevel + indentLevel);
  }
  function scanNext() {
    let token = scanner.scan();
    lineBreak = false;
    while (token === 15 || token === 14) {
      lineBreak = lineBreak || token === 14;
      token = scanner.scan();
    }
    hasError = token === 16 || scanner.getTokenError() !== 0;
    return token;
  }
  const editOperations = [];
  function addEdit(text, startOffset, endOffset) {
    if (!hasError && startOffset < rangeEnd && endOffset > rangeStart && documentText.substring(startOffset, endOffset) !== text) {
      editOperations.push({ offset: startOffset, length: endOffset - startOffset, content: text });
    }
  }
  let firstToken = scanNext();
  if (firstToken !== 17) {
    const firstTokenStart = scanner.getTokenOffset() + formatTextStart;
    const initialIndent = repeat(indentValue, initialIndentLevel);
    addEdit(initialIndent, formatTextStart, firstTokenStart);
  }
  while (firstToken !== 17) {
    let firstTokenEnd = scanner.getTokenOffset() + scanner.getTokenLength() + formatTextStart;
    let secondToken = scanNext();
    let replaceContent = "";
    while (!lineBreak && (secondToken === 12 || secondToken === 13)) {
      const commentTokenStart = scanner.getTokenOffset() + formatTextStart;
      addEdit(" ", firstTokenEnd, commentTokenStart);
      firstTokenEnd = scanner.getTokenOffset() + scanner.getTokenLength() + formatTextStart;
      replaceContent = secondToken === 12 ? newLineAndIndent() : "";
      secondToken = scanNext();
    }
    if (secondToken === 2) {
      if (firstToken !== 1) {
        indentLevel--;
        replaceContent = newLineAndIndent();
      }
    } else if (secondToken === 4) {
      if (firstToken !== 3) {
        indentLevel--;
        replaceContent = newLineAndIndent();
      }
    } else {
      switch (firstToken) {
        case 3:
        case 1:
          indentLevel++;
          replaceContent = newLineAndIndent();
          break;
        case 5:
        case 12:
          replaceContent = newLineAndIndent();
          break;
        case 13:
          if (lineBreak) {
            replaceContent = newLineAndIndent();
          } else {
            replaceContent = " ";
          }
          break;
        case 6:
          replaceContent = " ";
          break;
        case 10:
          if (secondToken === 6) {
            replaceContent = "";
            break;
          }
        // fall through
        case 7:
        case 8:
        case 9:
        case 11:
        case 2:
        case 4:
          if (secondToken === 12 || secondToken === 13) {
            replaceContent = " ";
          } else if (secondToken !== 5 && secondToken !== 17) {
            hasError = true;
          }
          break;
        case 16:
          hasError = true;
          break;
      }
      if (lineBreak && (secondToken === 12 || secondToken === 13)) {
        replaceContent = newLineAndIndent();
      }
    }
    const secondTokenStart = scanner.getTokenOffset() + formatTextStart;
    addEdit(replaceContent, firstTokenEnd, secondTokenStart);
    firstToken = secondToken;
  }
  return editOperations;
}
function repeat(s, count) {
  let result = "";
  for (let i = 0; i < count; i++) {
    result += s;
  }
  return result;
}
function computeIndentLevel(content, options) {
  let i = 0;
  let nChars = 0;
  const tabSize = options.tabSize || 4;
  while (i < content.length) {
    const ch = content.charAt(i);
    if (ch === " ") {
      nChars++;
    } else if (ch === "	") {
      nChars += tabSize;
    } else {
      break;
    }
    i++;
  }
  return Math.floor(nChars / tabSize);
}
function getEOL(options, text) {
  for (let i = 0; i < text.length; i++) {
    const ch = text.charAt(i);
    if (ch === "\r") {
      if (i + 1 < text.length && text.charAt(i + 1) === "\n") {
        return "\r\n";
      }
      return "\r";
    } else if (ch === "\n") {
      return "\n";
    }
  }
  return options && options.eol || "\n";
}
function isEOL(text, offset) {
  return "\r\n".indexOf(text.charAt(offset)) !== -1;
}
var init_jsonFormatter = __esm({
  "out-build/vs/base/common/jsonFormatter.js"() {
    "use strict";
    init_json();
  }
});

// out-build/vs/base/common/jsonEdit.js
function setProperty(text, originalPath, value, formattingOptions, getInsertionIndex) {
  const path4 = originalPath.slice();
  const errors = [];
  const root = parseTree(text, errors);
  let parent = void 0;
  let lastSegment = void 0;
  while (path4.length > 0) {
    lastSegment = path4.pop();
    parent = findNodeAtLocation(root, path4);
    if (parent === void 0 && value !== void 0) {
      if (typeof lastSegment === "string") {
        value = { [lastSegment]: value };
      } else {
        value = [value];
      }
    } else {
      break;
    }
  }
  if (!parent) {
    if (value === void 0) {
      return [];
    }
    return withFormatting(text, { offset: root ? root.offset : 0, length: root ? root.length : 0, content: JSON.stringify(value) }, formattingOptions);
  } else if (parent.type === "object" && typeof lastSegment === "string" && Array.isArray(parent.children)) {
    const existing = findNodeAtLocation(parent, [lastSegment]);
    if (existing !== void 0) {
      if (value === void 0) {
        if (!existing.parent) {
          throw new Error("Malformed AST");
        }
        const propertyIndex = parent.children.indexOf(existing.parent);
        let removeBegin;
        let removeEnd = existing.parent.offset + existing.parent.length;
        if (propertyIndex > 0) {
          const previous = parent.children[propertyIndex - 1];
          removeBegin = previous.offset + previous.length;
        } else {
          removeBegin = parent.offset + 1;
          if (parent.children.length > 1) {
            const next = parent.children[1];
            removeEnd = next.offset;
          }
        }
        return withFormatting(text, { offset: removeBegin, length: removeEnd - removeBegin, content: "" }, formattingOptions);
      } else {
        return withFormatting(text, { offset: existing.offset, length: existing.length, content: JSON.stringify(value) }, formattingOptions);
      }
    } else {
      if (value === void 0) {
        return [];
      }
      const newProperty = `${JSON.stringify(lastSegment)}: ${JSON.stringify(value)}`;
      const index = getInsertionIndex ? getInsertionIndex(parent.children.map((p) => p.children[0].value)) : parent.children.length;
      let edit;
      if (index > 0) {
        const previous = parent.children[index - 1];
        edit = { offset: previous.offset + previous.length, length: 0, content: "," + newProperty };
      } else if (parent.children.length === 0) {
        edit = { offset: parent.offset + 1, length: 0, content: newProperty };
      } else {
        edit = { offset: parent.offset + 1, length: 0, content: newProperty + "," };
      }
      return withFormatting(text, edit, formattingOptions);
    }
  } else if (parent.type === "array" && typeof lastSegment === "number" && Array.isArray(parent.children)) {
    if (value !== void 0) {
      const newProperty = `${JSON.stringify(value)}`;
      let edit;
      if (parent.children.length === 0 || lastSegment === 0) {
        edit = { offset: parent.offset + 1, length: 0, content: parent.children.length === 0 ? newProperty : newProperty + "," };
      } else {
        const index = lastSegment === -1 || lastSegment > parent.children.length ? parent.children.length : lastSegment;
        const previous = parent.children[index - 1];
        edit = { offset: previous.offset + previous.length, length: 0, content: "," + newProperty };
      }
      return withFormatting(text, edit, formattingOptions);
    } else {
      const removalIndex = lastSegment;
      const toRemove = parent.children[removalIndex];
      let edit;
      if (parent.children.length === 1) {
        edit = { offset: parent.offset + 1, length: parent.length - 2, content: "" };
      } else if (parent.children.length - 1 === removalIndex) {
        const previous = parent.children[removalIndex - 1];
        const offset = previous.offset + previous.length;
        const parentEndOffset = parent.offset + parent.length;
        edit = { offset, length: parentEndOffset - 2 - offset, content: "" };
      } else {
        edit = { offset: toRemove.offset, length: parent.children[removalIndex + 1].offset - toRemove.offset, content: "" };
      }
      return withFormatting(text, edit, formattingOptions);
    }
  } else {
    throw new Error(`Can not add ${typeof lastSegment !== "number" ? "index" : "property"} to parent of type ${parent.type}`);
  }
}
function withFormatting(text, edit, formattingOptions) {
  let newText = applyEdit(text, edit);
  let begin = edit.offset;
  let end = edit.offset + edit.content.length;
  if (edit.length === 0 || edit.content.length === 0) {
    while (begin > 0 && !isEOL(newText, begin - 1)) {
      begin--;
    }
    while (end < newText.length && !isEOL(newText, end)) {
      end++;
    }
  }
  const edits = format3(newText, { offset: begin, length: end - begin }, formattingOptions);
  for (let i = edits.length - 1; i >= 0; i--) {
    const curr = edits[i];
    newText = applyEdit(newText, curr);
    begin = Math.min(begin, curr.offset);
    end = Math.max(end, curr.offset + curr.length);
    end += curr.content.length - curr.length;
  }
  const editLength = text.length - (newText.length - end) - begin;
  return [{ offset: begin, length: editLength, content: newText.substring(begin, end) }];
}
function applyEdit(text, edit) {
  return text.substring(0, edit.offset) + edit.content + text.substring(edit.offset + edit.length);
}
function applyEdits(text, edits) {
  const sortedEdits = edits.slice(0).sort((a, b) => {
    const diff2 = a.offset - b.offset;
    if (diff2 === 0) {
      return a.length - b.length;
    }
    return diff2;
  });
  let lastModifiedOffset = text.length;
  for (let i = sortedEdits.length - 1; i >= 0; i--) {
    const e = sortedEdits[i];
    if (e.offset + e.length <= lastModifiedOffset) {
      text = applyEdit(text, e);
    } else {
      throw new Error("Overlapping edit");
    }
    lastModifiedOffset = e.offset;
  }
  return text;
}
var init_jsonEdit = __esm({
  "out-build/vs/base/common/jsonEdit.js"() {
    "use strict";
    init_json();
    init_jsonFormatter();
  }
});

// out-build/vs/platform/remote/common/remoteHosts.js
function getRemoteAuthority(uri) {
  return uri.scheme === Schemas.vscodeRemote ? uri.authority : void 0;
}
var init_remoteHosts = __esm({
  "out-build/vs/platform/remote/common/remoteHosts.js"() {
    "use strict";
    init_network();
  }
});

// out-build/vs/platform/workspaces/common/workspaces.js
function isRecentWorkspace(curr) {
  return curr.hasOwnProperty("workspace");
}
function isRecentFolder(curr) {
  return curr.hasOwnProperty("folderUri");
}
function isRecentFile(curr) {
  return curr.hasOwnProperty("fileUri");
}
function isStoredWorkspaceFolder(obj) {
  return isRawFileWorkspaceFolder(obj) || isRawUriWorkspaceFolder(obj);
}
function isRawFileWorkspaceFolder(obj) {
  const candidate = obj;
  return typeof candidate?.path === "string" && (!candidate.name || typeof candidate.name === "string");
}
function isRawUriWorkspaceFolder(obj) {
  const candidate = obj;
  return typeof candidate?.uri === "string" && (!candidate.name || typeof candidate.name === "string");
}
function getStoredWorkspaceFolder(folderURI, forceAbsolute, folderName, targetConfigFolderURI, extUri2) {
  if (folderURI.scheme !== targetConfigFolderURI.scheme) {
    return { name: folderName, uri: folderURI.toString(true) };
  }
  let folderPath = !forceAbsolute ? extUri2.relativePath(targetConfigFolderURI, folderURI) : void 0;
  if (folderPath !== void 0) {
    if (folderPath.length === 0) {
      folderPath = ".";
    } else {
      if (isWindows2) {
        folderPath = massagePathForWindows(folderPath);
      }
    }
  } else {
    if (folderURI.scheme === Schemas.file) {
      folderPath = folderURI.fsPath;
      if (isWindows2) {
        folderPath = massagePathForWindows(folderPath);
      }
    } else if (!extUri2.isEqualAuthority(folderURI.authority, targetConfigFolderURI.authority)) {
      return { name: folderName, uri: folderURI.toString(true) };
    } else {
      folderPath = folderURI.path;
    }
  }
  return { name: folderName, path: folderPath };
}
function massagePathForWindows(folderPath) {
  folderPath = normalizeDriveLetter(folderPath);
  if (!isUNC(folderPath)) {
    folderPath = toSlashes(folderPath);
  }
  return folderPath;
}
function toWorkspaceFolders(configuredFolders, workspaceConfigFile, extUri2) {
  const result = [];
  const seen = /* @__PURE__ */ new Set();
  const relativeTo = extUri2.dirname(workspaceConfigFile);
  for (const configuredFolder of configuredFolders) {
    let uri = void 0;
    if (isRawFileWorkspaceFolder(configuredFolder)) {
      if (configuredFolder.path) {
        uri = extUri2.resolvePath(relativeTo, configuredFolder.path);
      }
    } else if (isRawUriWorkspaceFolder(configuredFolder)) {
      try {
        uri = URI.parse(configuredFolder.uri);
        if (uri.path[0] !== posix.sep) {
          uri = uri.with({ path: posix.sep + uri.path });
        }
      } catch (e) {
        console.warn(e);
      }
    }
    if (uri) {
      const comparisonKey = extUri2.getComparisonKey(uri);
      if (!seen.has(comparisonKey)) {
        seen.add(comparisonKey);
        const name = configuredFolder.name || extUri2.basenameOrAuthority(uri);
        result.push(new WorkspaceFolder({ uri, name, index: result.length }, configuredFolder));
      }
    }
  }
  return result;
}
function isSerializedRecentWorkspace(data) {
  return data.workspace && typeof data.workspace === "object" && typeof data.workspace.id === "string" && typeof data.workspace.configPath === "string";
}
function isSerializedRecentFolder(data) {
  return typeof data.folderUri === "string";
}
function isSerializedRecentFile(data) {
  return typeof data.fileUri === "string";
}
function restoreRecentlyOpened(data, logService) {
  const result = { workspaces: [], files: [] };
  if (data) {
    const restoreGracefully = function(entries, onEntry) {
      for (let i = 0; i < entries.length; i++) {
        try {
          onEntry(entries[i], i);
        } catch (e) {
          logService.warn(`Error restoring recent entry ${JSON.stringify(entries[i])}: ${e.toString()}. Skip entry.`);
        }
      }
    };
    const storedRecents = data;
    if (Array.isArray(storedRecents.entries)) {
      restoreGracefully(storedRecents.entries, (entry) => {
        const label = entry.label;
        const remoteAuthority = entry.remoteAuthority;
        if (isSerializedRecentWorkspace(entry)) {
          result.workspaces.push({ label, remoteAuthority, workspace: { id: entry.workspace.id, configPath: URI.parse(entry.workspace.configPath) } });
        } else if (isSerializedRecentFolder(entry)) {
          result.workspaces.push({ label, remoteAuthority, folderUri: URI.parse(entry.folderUri) });
        } else if (isSerializedRecentFile(entry)) {
          result.files.push({ label, remoteAuthority, fileUri: URI.parse(entry.fileUri) });
        }
      });
    }
  }
  return result;
}
function toStoreData(recents) {
  const serialized = { entries: [] };
  const storeLabel = (label, uri) => {
    return label && label !== uri.fsPath && label !== uri.path;
  };
  for (const recent of recents.workspaces) {
    if (isRecentFolder(recent)) {
      serialized.entries.push({
        folderUri: recent.folderUri.toString(),
        label: storeLabel(recent.label, recent.folderUri) ? recent.label : void 0,
        remoteAuthority: recent.remoteAuthority
      });
    } else {
      serialized.entries.push({
        workspace: {
          id: recent.workspace.id,
          configPath: recent.workspace.configPath.toString()
        },
        label: storeLabel(recent.label, recent.workspace.configPath) ? recent.label : void 0,
        remoteAuthority: recent.remoteAuthority
      });
    }
  }
  for (const recent of recents.files) {
    serialized.entries.push({
      fileUri: recent.fileUri.toString(),
      label: storeLabel(recent.label, recent.fileUri) ? recent.label : void 0,
      remoteAuthority: recent.remoteAuthority
    });
  }
  return serialized;
}
var IWorkspacesService;
var init_workspaces2 = __esm({
  "out-build/vs/platform/workspaces/common/workspaces.js"() {
    "use strict";
    init_extpath();
    init_json();
    init_jsonEdit();
    init_labels();
    init_network();
    init_path();
    init_platform();
    init_resources();
    init_uri();
    init_instantiation();
    init_remoteHosts();
    init_workspace();
    IWorkspacesService = createDecorator("workspacesService");
  }
});

// out-build/vs/platform/workspaces/electron-main/workspacesManagementMainService.js
import * as fs6 from "fs";
import electron7 from "electron";
var IWorkspacesManagementMainService, WorkspacesManagementMainService;
var init_workspacesManagementMainService = __esm({
  "out-build/vs/platform/workspaces/electron-main/workspacesManagementMainService.js"() {
    "use strict";
    init_event();
    init_json();
    init_lifecycle();
    init_network();
    init_path();
    init_resources();
    init_pfs();
    init_nls();
    init_backup();
    init_dialogMainService();
    init_environmentMainService();
    init_instantiation();
    init_log();
    init_userDataProfile3();
    init_windowsFinder();
    init_workspace();
    init_workspaces2();
    init_workspaces();
    IWorkspacesManagementMainService = createDecorator("workspacesManagementMainService");
    WorkspacesManagementMainService = class WorkspacesManagementMainService2 extends Disposable {
      constructor(environmentMainService, logService, userDataProfilesMainService, backupMainService, dialogMainService) {
        super();
        this.environmentMainService = environmentMainService;
        this.logService = logService;
        this.userDataProfilesMainService = userDataProfilesMainService;
        this.backupMainService = backupMainService;
        this.dialogMainService = dialogMainService;
        this._onDidDeleteUntitledWorkspace = this._register(new Emitter());
        this.onDidDeleteUntitledWorkspace = this._onDidDeleteUntitledWorkspace.event;
        this._onDidEnterWorkspace = this._register(new Emitter());
        this.onDidEnterWorkspace = this._onDidEnterWorkspace.event;
        this.untitledWorkspaces = [];
        this.untitledWorkspacesHome = this.environmentMainService.untitledWorkspacesHome;
      }
      async initialize() {
        this.untitledWorkspaces = [];
        try {
          const untitledWorkspacePaths = (await Promises2.readdir(this.untitledWorkspacesHome.with({ scheme: Schemas.file }).fsPath)).map((folder) => joinPath(this.untitledWorkspacesHome, folder, UNTITLED_WORKSPACE_NAME));
          for (const untitledWorkspacePath of untitledWorkspacePaths) {
            const workspace = getWorkspaceIdentifier(untitledWorkspacePath);
            const resolvedWorkspace = await this.resolveLocalWorkspace(untitledWorkspacePath);
            if (!resolvedWorkspace) {
              await this.deleteUntitledWorkspace(workspace);
            } else {
              this.untitledWorkspaces.push({ workspace, remoteAuthority: resolvedWorkspace.remoteAuthority });
            }
          }
        } catch (error) {
          if (error.code !== "ENOENT") {
            this.logService.warn(`Unable to read folders in ${this.untitledWorkspacesHome} (${error}).`);
          }
        }
      }
      resolveLocalWorkspace(uri) {
        return this.doResolveLocalWorkspace(uri, (path4) => fs6.promises.readFile(path4, "utf8"));
      }
      doResolveLocalWorkspace(uri, contentsFn) {
        if (!this.isWorkspacePath(uri)) {
          return void 0;
        }
        if (uri.scheme !== Schemas.file) {
          return void 0;
        }
        try {
          const contents = contentsFn(uri.fsPath);
          if (contents instanceof Promise) {
            return contents.then(
              (value) => this.doResolveWorkspace(uri, value),
              (error) => void 0
              /* invalid workspace */
            );
          } else {
            return this.doResolveWorkspace(uri, contents);
          }
        } catch {
          return void 0;
        }
      }
      isWorkspacePath(uri) {
        return isUntitledWorkspace(uri, this.environmentMainService) || hasWorkspaceFileExtension(uri);
      }
      doResolveWorkspace(path4, contents) {
        try {
          const workspace = this.doParseStoredWorkspace(path4, contents);
          const workspaceIdentifier = getWorkspaceIdentifier(path4);
          return {
            id: workspaceIdentifier.id,
            configPath: workspaceIdentifier.configPath,
            folders: toWorkspaceFolders(workspace.folders, workspaceIdentifier.configPath, extUriBiasedIgnorePathCase),
            remoteAuthority: workspace.remoteAuthority,
            transient: workspace.transient
          };
        } catch (error) {
          this.logService.warn(error.toString());
        }
        return void 0;
      }
      doParseStoredWorkspace(path4, contents) {
        const storedWorkspace = parse4(contents);
        if (storedWorkspace && Array.isArray(storedWorkspace.folders)) {
          storedWorkspace.folders = storedWorkspace.folders.filter((folder) => isStoredWorkspaceFolder(folder));
        } else {
          throw new Error(`${path4.toString(true)} looks like an invalid workspace file.`);
        }
        return storedWorkspace;
      }
      async createUntitledWorkspace(folders, remoteAuthority) {
        const { workspace, storedWorkspace } = this.newUntitledWorkspace(folders, remoteAuthority);
        const configPath = workspace.configPath.fsPath;
        await fs6.promises.mkdir(dirname3(configPath), { recursive: true });
        await Promises2.writeFile(configPath, JSON.stringify(storedWorkspace, null, "	"));
        this.untitledWorkspaces.push({ workspace, remoteAuthority });
        return workspace;
      }
      newUntitledWorkspace(folders = [], remoteAuthority) {
        const randomId = (Date.now() + Math.round(Math.random() * 1e3)).toString();
        const untitledWorkspaceConfigFolder = joinPath(this.untitledWorkspacesHome, randomId);
        const untitledWorkspaceConfigPath = joinPath(untitledWorkspaceConfigFolder, UNTITLED_WORKSPACE_NAME);
        const storedWorkspaceFolder = [];
        for (const folder of folders) {
          storedWorkspaceFolder.push(getStoredWorkspaceFolder(folder.uri, true, folder.name, untitledWorkspaceConfigFolder, extUriBiasedIgnorePathCase));
        }
        return {
          workspace: getWorkspaceIdentifier(untitledWorkspaceConfigPath),
          storedWorkspace: { folders: storedWorkspaceFolder, remoteAuthority }
        };
      }
      async getWorkspaceIdentifier(configPath) {
        return getWorkspaceIdentifier(configPath);
      }
      isUntitledWorkspace(workspace) {
        return isUntitledWorkspace(workspace.configPath, this.environmentMainService);
      }
      async deleteUntitledWorkspace(workspace) {
        if (!this.isUntitledWorkspace(workspace)) {
          return;
        }
        await this.doDeleteUntitledWorkspace(workspace);
        this.userDataProfilesMainService.unsetWorkspace(workspace);
        this._onDidDeleteUntitledWorkspace.fire(workspace);
      }
      async doDeleteUntitledWorkspace(workspace) {
        const configPath = originalFSPath(workspace.configPath);
        try {
          await Promises2.rm(dirname3(configPath));
          const workspaceStoragePath = join3(this.environmentMainService.workspaceStorageHome.with({ scheme: Schemas.file }).fsPath, workspace.id);
          if (await Promises2.exists(workspaceStoragePath)) {
            await Promises2.writeFile(join3(workspaceStoragePath, "obsolete"), "");
          }
          this.untitledWorkspaces = this.untitledWorkspaces.filter((untitledWorkspace) => untitledWorkspace.workspace.id !== workspace.id);
        } catch (error) {
          this.logService.warn(`Unable to delete untitled workspace ${configPath} (${error}).`);
        }
      }
      getUntitledWorkspaces() {
        return this.untitledWorkspaces;
      }
      async enterWorkspace(window, windows, path4) {
        if (!window || !window.win || !window.isReady) {
          return void 0;
        }
        const isValid = await this.isValidTargetWorkspacePath(window, windows, path4);
        if (!isValid) {
          return void 0;
        }
        const result = await this.doEnterWorkspace(window, getWorkspaceIdentifier(path4));
        if (!result) {
          return void 0;
        }
        this._onDidEnterWorkspace.fire({ window, workspace: result.workspace });
        return result;
      }
      async isValidTargetWorkspacePath(window, windows, workspacePath) {
        if (!workspacePath) {
          return true;
        }
        if (isWorkspaceIdentifier(window.openedWorkspace) && extUriBiasedIgnorePathCase.isEqual(window.openedWorkspace.configPath, workspacePath)) {
          return false;
        }
        if (findWindowOnWorkspaceOrFolder(windows, workspacePath)) {
          await this.dialogMainService.showMessageBox({
            type: "info",
            buttons: [localize(2672, null)],
            message: localize(2673, null, basename2(workspacePath)),
            detail: localize(2674, null)
          }, electron7.BrowserWindow.getFocusedWindow() ?? void 0);
          return false;
        }
        return true;
      }
      async doEnterWorkspace(window, workspace) {
        if (!window.config) {
          return void 0;
        }
        window.focus();
        let backupPath;
        if (!window.config.extensionDevelopmentPath) {
          if (window.config.backupPath) {
            backupPath = await this.backupMainService.registerWorkspaceBackup({ workspace, remoteAuthority: window.remoteAuthority }, window.config.backupPath);
          } else {
            backupPath = this.backupMainService.registerWorkspaceBackup({ workspace, remoteAuthority: window.remoteAuthority });
          }
        }
        if (isWorkspaceIdentifier(window.openedWorkspace) && this.isUntitledWorkspace(window.openedWorkspace)) {
          await this.deleteUntitledWorkspace(window.openedWorkspace);
        }
        window.config.workspace = workspace;
        window.config.backupPath = backupPath;
        return { workspace, backupPath };
      }
    };
    WorkspacesManagementMainService = __decorate([
      __param(0, IEnvironmentMainService),
      __param(1, ILogService),
      __param(2, IUserDataProfilesMainService),
      __param(3, IBackupMainService),
      __param(4, IDialogMainService)
    ], WorkspacesManagementMainService);
  }
});

// out-build/vs/base/common/processes.js
function sanitizeProcessEnvironment(env2, ...preserve) {
  const set = preserve.reduce((set2, key) => {
    set2[key] = true;
    return set2;
  }, {});
  const keysToRemove = [
    /^ELECTRON_.+$/,
    /^VSCODE_(?!(PORTABLE|SHELL_LOGIN|ENV_REPLACE|ENV_APPEND|ENV_PREPEND)).+$/,
    /^SNAP(|_.*)$/,
    /^GDK_PIXBUF_.+$/
  ];
  const envKeys = Object.keys(env2);
  envKeys.filter((key) => !set[key]).forEach((envKey) => {
    for (let i = 0; i < keysToRemove.length; i++) {
      if (envKey.search(keysToRemove[i]) !== -1) {
        delete env2[envKey];
        break;
      }
    }
  });
}
function removeDangerousEnvVariables(env2) {
  if (!env2) {
    return;
  }
  delete env2["DEBUG"];
  if (isLinux) {
    delete env2["LD_PRELOAD"];
  }
}
var Source, TerminateResponseCode;
var init_processes = __esm({
  "out-build/vs/base/common/processes.js"() {
    "use strict";
    init_platform();
    (function(Source2) {
      Source2[Source2["stdout"] = 0] = "stdout";
      Source2[Source2["stderr"] = 1] = "stderr";
    })(Source || (Source = {}));
    (function(TerminateResponseCode2) {
      TerminateResponseCode2[TerminateResponseCode2["Success"] = 0] = "Success";
      TerminateResponseCode2[TerminateResponseCode2["Unknown"] = 1] = "Unknown";
      TerminateResponseCode2[TerminateResponseCode2["AccessDenied"] = 2] = "AccessDenied";
      TerminateResponseCode2[TerminateResponseCode2["ProcessNotFound"] = 3] = "ProcessNotFound";
    })(TerminateResponseCode || (TerminateResponseCode = {}));
  }
});

// out-build/vs/platform/utilityProcess/electron-main/utilityProcess.js
import { MessageChannelMain, app as app2, utilityProcess } from "electron";
import { StringDecoder } from "string_decoder";
function isWindowUtilityProcessConfiguration(config) {
  const candidate = config;
  return typeof candidate.responseWindowId === "number";
}
var UtilityProcess_1, UtilityProcess, WindowUtilityProcess;
var init_utilityProcess = __esm({
  "out-build/vs/platform/utilityProcess/electron-main/utilityProcess.js"() {
    "use strict";
    init_lifecycle();
    init_event();
    init_log();
    init_async();
    init_network();
    init_windows();
    init_severity();
    init_telemetry();
    init_lifecycleMainService();
    init_processes();
    init_objects();
    init_platform();
    init_unc();
    UtilityProcess = class UtilityProcess2 extends Disposable {
      static {
        UtilityProcess_1 = this;
      }
      static {
        this.ID_COUNTER = 0;
      }
      static {
        this.all = /* @__PURE__ */ new Map();
      }
      static getAll() {
        return Array.from(UtilityProcess_1.all.values());
      }
      constructor(logService, telemetryService, lifecycleMainService) {
        super();
        this.logService = logService;
        this.telemetryService = telemetryService;
        this.lifecycleMainService = lifecycleMainService;
        this.id = String(++UtilityProcess_1.ID_COUNTER);
        this._onStdout = this._register(new Emitter());
        this.onStdout = this._onStdout.event;
        this._onStderr = this._register(new Emitter());
        this.onStderr = this._onStderr.event;
        this._onMessage = this._register(new Emitter());
        this.onMessage = this._onMessage.event;
        this._onSpawn = this._register(new Emitter());
        this.onSpawn = this._onSpawn.event;
        this._onExit = this._register(new Emitter());
        this.onExit = this._onExit.event;
        this._onCrash = this._register(new Emitter());
        this.onCrash = this._onCrash.event;
        this.process = void 0;
        this.processPid = void 0;
        this.configuration = void 0;
      }
      log(msg, severity) {
        let logMsg;
        if (this.configuration?.correlationId) {
          logMsg = `[UtilityProcess id: ${this.configuration?.correlationId}, type: ${this.configuration?.type}, pid: ${this.processPid ?? "<none>"}]: ${msg}`;
        } else {
          logMsg = `[UtilityProcess type: ${this.configuration?.type}, pid: ${this.processPid ?? "<none>"}]: ${msg}`;
        }
        switch (severity) {
          case severity_default.Error:
            this.logService.error(logMsg);
            break;
          case severity_default.Warning:
            this.logService.warn(logMsg);
            break;
          case severity_default.Info:
            this.logService.trace(logMsg);
            break;
        }
      }
      validateCanStart() {
        if (this.process) {
          this.log("Cannot start utility process because it is already running...", severity_default.Error);
          return false;
        }
        return true;
      }
      start(configuration) {
        const started = this.doStart(configuration);
        if (started && configuration.payload) {
          const posted = this.postMessage(configuration.payload);
          if (posted) {
            this.log("payload sent via postMessage()", severity_default.Info);
          }
        }
        return started;
      }
      doStart(configuration) {
        if (!this.validateCanStart()) {
          return false;
        }
        this.configuration = configuration;
        const serviceName = `${this.configuration.type}-${this.id}`;
        const modulePath = FileAccess.asFileUri("bootstrap-fork.js").fsPath;
        const args2 = this.configuration.args ?? [];
        const execArgv = this.configuration.execArgv ?? [];
        const allowLoadingUnsignedLibraries = this.configuration.allowLoadingUnsignedLibraries;
        const respondToAuthRequestsFromMainProcess = this.configuration.respondToAuthRequestsFromMainProcess;
        const stdio = "pipe";
        const env2 = this.createEnv(configuration);
        this.log("creating new...", severity_default.Info);
        this.process = utilityProcess.fork(modulePath, args2, {
          serviceName,
          env: env2,
          execArgv,
          // !!! Add `--trace-warnings` for node.js tracing !!!
          allowLoadingUnsignedLibraries,
          respondToAuthRequestsFromMainProcess,
          stdio
        });
        this.registerListeners(this.process, this.configuration, serviceName);
        return true;
      }
      createEnv(configuration) {
        const env2 = configuration.env ? { ...configuration.env } : { ...deepClone(process.env) };
        env2["VSCODE_ESM_ENTRYPOINT"] = configuration.entryPoint;
        if (typeof configuration.parentLifecycleBound === "number") {
          env2["VSCODE_PARENT_PID"] = String(configuration.parentLifecycleBound);
        }
        env2["VSCODE_CRASH_REPORTER_PROCESS_TYPE"] = configuration.type;
        if (isWindows2) {
          if (isUNCAccessRestrictionsDisabled()) {
            env2["NODE_DISABLE_UNC_ACCESS_CHECKS"] = "1";
          } else {
            env2["NODE_UNC_HOST_ALLOWLIST"] = getUNCHostAllowlist().join("\\");
          }
        }
        removeDangerousEnvVariables(env2);
        for (const key of Object.keys(env2)) {
          env2[key] = String(env2[key]);
        }
        return env2;
      }
      registerListeners(process2, configuration, serviceName) {
        if (process2.stdout) {
          const stdoutDecoder = new StringDecoder("utf-8");
          this._register(Event.fromNodeEventEmitter(process2.stdout, "data")((chunk) => this._onStdout.fire(typeof chunk === "string" ? chunk : stdoutDecoder.write(chunk))));
        }
        if (process2.stderr) {
          const stderrDecoder = new StringDecoder("utf-8");
          this._register(Event.fromNodeEventEmitter(process2.stderr, "data")((chunk) => this._onStderr.fire(typeof chunk === "string" ? chunk : stderrDecoder.write(chunk))));
        }
        this._register(Event.fromNodeEventEmitter(process2, "message")((msg) => this._onMessage.fire(msg)));
        this._register(Event.fromNodeEventEmitter(process2, "spawn")(() => {
          this.processPid = process2.pid;
          if (typeof process2.pid === "number") {
            UtilityProcess_1.all.set(process2.pid, { pid: process2.pid, name: isWindowUtilityProcessConfiguration(configuration) ? `${configuration.name} [${configuration.responseWindowId}]` : configuration.name });
          }
          this.log("successfully created", severity_default.Info);
          this._onSpawn.fire(process2.pid);
        }));
        this._register(Event.fromNodeEventEmitter(process2, "exit")((code2) => {
          this.log(`received exit event with code ${code2}`, severity_default.Info);
          this._onExit.fire({ pid: this.processPid, code: code2, signal: "unknown" });
          this.onDidExitOrCrashOrKill();
        }));
        this._register(Event.fromNodeEventEmitter(process2, "error", (type3, location, report) => ({ type: type3, location, report }))(({ type: type3, location, report }) => {
          this.log(`crashed due to ${type3} from V8 at ${location}`, severity_default.Info);
          let addons = [];
          try {
            const reportJSON = JSON.parse(report);
            addons = reportJSON.sharedObjects.filter((sharedObject) => sharedObject.endsWith(".node")).map((addon) => {
              const index = addon.indexOf("extensions") === -1 ? addon.indexOf("node_modules") : addon.indexOf("extensions");
              return addon.substring(index);
            });
          } catch (e) {
          }
          this.telemetryService.publicLog2("utilityprocessv8error", {
            processtype: configuration.type,
            error: type3,
            location,
            addons
          });
        }));
        this._register(Event.fromNodeEventEmitter(app2, "child-process-gone", (event, details) => ({ event, details }))(({ details }) => {
          if (details.type === "Utility" && details.name === serviceName) {
            this.log(`crashed with code ${details.exitCode} and reason '${details.reason}'`, severity_default.Error);
            this.telemetryService.publicLog2("utilityprocesscrash", {
              type: configuration.type,
              reason: details.reason,
              code: details.exitCode
            });
            this._onCrash.fire({ pid: this.processPid, code: details.exitCode, reason: details.reason });
            this.onDidExitOrCrashOrKill();
          }
        }));
      }
      once(message, callback) {
        const disposable = this._register(this._onMessage.event((msg) => {
          if (msg === message) {
            disposable.dispose();
            callback();
          }
        }));
      }
      postMessage(message, transfer) {
        if (!this.process) {
          return false;
        }
        this.process.postMessage(message, transfer);
        return true;
      }
      connect(payload) {
        const { port1: outPort, port2: utilityProcessPort } = new MessageChannelMain();
        this.postMessage(payload, [utilityProcessPort]);
        return outPort;
      }
      enableInspectPort() {
        if (!this.process || typeof this.processPid !== "number") {
          return false;
        }
        this.log("enabling inspect port", severity_default.Info);
        const processExt = process;
        if (typeof processExt._debugProcess === "function") {
          processExt._debugProcess(this.processPid);
          return true;
        }
        return false;
      }
      kill() {
        if (!this.process) {
          return;
        }
        this.log("attempting to kill the process...", severity_default.Info);
        const killed = this.process.kill();
        if (killed) {
          this.log("successfully killed the process", severity_default.Info);
          this.onDidExitOrCrashOrKill();
        } else {
          this.log("unable to kill the process", severity_default.Warning);
        }
      }
      onDidExitOrCrashOrKill() {
        if (typeof this.processPid === "number") {
          UtilityProcess_1.all.delete(this.processPid);
        }
        this.process = void 0;
      }
      async waitForExit(maxWaitTimeMs) {
        if (!this.process) {
          return;
        }
        this.log("waiting to exit...", severity_default.Info);
        await Promise.race([Event.toPromise(this.onExit), timeout(maxWaitTimeMs)]);
        if (this.process) {
          this.log(`did not exit within ${maxWaitTimeMs}ms, will kill it now...`, severity_default.Info);
          this.kill();
        }
      }
    };
    UtilityProcess = UtilityProcess_1 = __decorate([
      __param(0, ILogService),
      __param(1, ITelemetryService),
      __param(2, ILifecycleMainService)
    ], UtilityProcess);
    WindowUtilityProcess = class WindowUtilityProcess2 extends UtilityProcess {
      constructor(logService, windowsMainService, telemetryService, lifecycleMainService) {
        super(logService, telemetryService, lifecycleMainService);
        this.windowsMainService = windowsMainService;
      }
      start(configuration) {
        const responseWindow = this.windowsMainService.getWindowById(configuration.responseWindowId);
        if (!responseWindow?.win || responseWindow.win.isDestroyed() || responseWindow.win.webContents.isDestroyed()) {
          this.log("Refusing to start utility process because requesting window cannot be found or is destroyed...", severity_default.Error);
          return true;
        }
        const started = super.doStart(configuration);
        if (!started) {
          return false;
        }
        this.registerWindowListeners(responseWindow.win, configuration);
        const windowPort = this.connect(configuration.payload);
        responseWindow.win.webContents.postMessage(configuration.responseChannel, configuration.responseNonce, [windowPort]);
        return true;
      }
      registerWindowListeners(window, configuration) {
        if (configuration.windowLifecycleBound) {
          this._register(Event.filter(this.lifecycleMainService.onWillLoadWindow, (e) => e.window.win === window)(() => this.kill()));
          this._register(Event.fromNodeEventEmitter(window, "closed")(() => this.kill()));
        }
      }
    };
    WindowUtilityProcess = __decorate([
      __param(0, ILogService),
      __param(1, IWindowsMainService),
      __param(2, ITelemetryService),
      __param(3, ILifecycleMainService)
    ], WindowUtilityProcess);
  }
});

// out-build/vs/platform/diagnostics/electron-main/diagnosticsMainService.js
import { app as app3 } from "electron";
var ID2, IDiagnosticsMainService, DiagnosticsMainService;
var init_diagnosticsMainService = __esm({
  "out-build/vs/platform/diagnostics/electron-main/diagnosticsMainService.js"() {
    "use strict";
    init_ipcMain();
    init_cancellation();
    init_instantiation();
    init_windows();
    init_workspace();
    init_workspacesManagementMainService();
    init_types();
    init_log();
    init_utilityProcess();
    ID2 = "diagnosticsMainService";
    IDiagnosticsMainService = createDecorator(ID2);
    DiagnosticsMainService = class DiagnosticsMainService2 {
      constructor(windowsMainService, workspacesManagementMainService, logService) {
        this.windowsMainService = windowsMainService;
        this.workspacesManagementMainService = workspacesManagementMainService;
        this.logService = logService;
      }
      async getRemoteDiagnostics(options) {
        const windows = this.windowsMainService.getWindows();
        const diagnostics = await Promise.all(windows.map(async (window) => {
          const remoteAuthority = window.remoteAuthority;
          if (!remoteAuthority) {
            return void 0;
          }
          const replyChannel = `vscode:getDiagnosticInfoResponse${window.id}`;
          const args2 = {
            includeProcesses: options.includeProcesses,
            folders: options.includeWorkspaceMetadata ? await this.getFolderURIs(window) : void 0
          };
          return new Promise((resolve3) => {
            window.sendWhenReady("vscode:getDiagnosticInfo", CancellationToken.None, { replyChannel, args: args2 });
            validatedIpcMain.once(replyChannel, (_, data) => {
              if (!data) {
                resolve3({ hostName: remoteAuthority, errorMessage: `Unable to resolve connection to '${remoteAuthority}'.` });
              }
              resolve3(data);
            });
            setTimeout(() => {
              resolve3({ hostName: remoteAuthority, errorMessage: `Connection to '${remoteAuthority}' could not be established` });
            }, 5e3);
          });
        }));
        return diagnostics.filter((x) => !!x);
      }
      async getMainDiagnostics() {
        this.logService.trace("Received request for main process info from other instance.");
        const windows = [];
        for (const window of getAllWindowsExcludingOffscreen()) {
          const codeWindow = this.windowsMainService.getWindowById(window.id);
          if (codeWindow) {
            windows.push(await this.codeWindowToInfo(codeWindow));
          } else {
            windows.push(this.browserWindowToInfo(window));
          }
        }
        const pidToNames = [];
        for (const { pid, name } of UtilityProcess.getAll()) {
          pidToNames.push({ pid, name });
        }
        return {
          mainPID: process.pid,
          mainArguments: process.argv.slice(1),
          windows,
          pidToNames,
          screenReader: !!app3.accessibilitySupportEnabled,
          gpuFeatureStatus: app3.getGPUFeatureStatus()
        };
      }
      async codeWindowToInfo(window) {
        const folderURIs = await this.getFolderURIs(window);
        const win = assertIsDefined(window.win);
        return this.browserWindowToInfo(win, folderURIs, window.remoteAuthority);
      }
      browserWindowToInfo(window, folderURIs = [], remoteAuthority) {
        return {
          id: window.id,
          pid: window.webContents.getOSProcessId(),
          title: window.getTitle(),
          folderURIs,
          remoteAuthority
        };
      }
      async getFolderURIs(window) {
        const folderURIs = [];
        const workspace = window.openedWorkspace;
        if (isSingleFolderWorkspaceIdentifier(workspace)) {
          folderURIs.push(workspace.uri);
        } else if (isWorkspaceIdentifier(workspace)) {
          const resolvedWorkspace = await this.workspacesManagementMainService.resolveLocalWorkspace(workspace.configPath);
          if (resolvedWorkspace) {
            const rootFolders = resolvedWorkspace.folders;
            rootFolders.forEach((root) => {
              folderURIs.push(root.uri);
            });
          }
        }
        return folderURIs;
      }
    };
    DiagnosticsMainService = __decorate([
      __param(0, IWindowsMainService),
      __param(1, IWorkspacesManagementMainService),
      __param(2, ILogService)
    ], DiagnosticsMainService);
  }
});

// out-build/vs/platform/encryption/electron-main/encryptionMainService.js
import { safeStorage as safeStorageElectron, app as app4 } from "electron";
var safeStorage, EncryptionMainService;
var init_encryptionMainService = __esm({
  "out-build/vs/platform/encryption/electron-main/encryptionMainService.js"() {
    "use strict";
    init_platform();
    init_log();
    safeStorage = safeStorageElectron;
    EncryptionMainService = class EncryptionMainService2 {
      constructor(logService) {
        this.logService = logService;
        if (app4.commandLine.getSwitchValue("password-store") === "basic") {
          this.logService.trace("[EncryptionMainService] setting usePlainTextEncryption to true...");
          safeStorage.setUsePlainTextEncryption?.(true);
          this.logService.trace("[EncryptionMainService] set usePlainTextEncryption to true");
        }
      }
      async encrypt(value) {
        this.logService.trace("[EncryptionMainService] Encrypting value...");
        try {
          const result = JSON.stringify(safeStorage.encryptString(value));
          this.logService.trace("[EncryptionMainService] Encrypted value.");
          return result;
        } catch (e) {
          this.logService.error(e);
          throw e;
        }
      }
      async decrypt(value) {
        let parsedValue;
        try {
          parsedValue = JSON.parse(value);
          if (!parsedValue.data) {
            throw new Error(`[EncryptionMainService] Invalid encrypted value: ${value}`);
          }
          const bufferToDecrypt = Buffer.from(parsedValue.data);
          this.logService.trace("[EncryptionMainService] Decrypting value...");
          const result = safeStorage.decryptString(bufferToDecrypt);
          this.logService.trace("[EncryptionMainService] Decrypted value.");
          return result;
        } catch (e) {
          this.logService.error(e);
          throw e;
        }
      }
      isEncryptionAvailable() {
        this.logService.trace("[EncryptionMainService] Checking if encryption is available...");
        const result = safeStorage.isEncryptionAvailable();
        this.logService.trace("[EncryptionMainService] Encryption is available: ", result);
        return Promise.resolve(result);
      }
      getKeyStorageProvider() {
        if (isWindows2) {
          return Promise.resolve(
            "dpapi"
            /* KnownStorageProvider.dplib */
          );
        }
        if (isMacintosh) {
          return Promise.resolve(
            "keychain_access"
            /* KnownStorageProvider.keychainAccess */
          );
        }
        if (safeStorage.getSelectedStorageBackend) {
          try {
            this.logService.trace("[EncryptionMainService] Getting selected storage backend...");
            const result = safeStorage.getSelectedStorageBackend();
            this.logService.trace("[EncryptionMainService] Selected storage backend: ", result);
            return Promise.resolve(result);
          } catch (e) {
            this.logService.error(e);
          }
        }
        return Promise.resolve(
          "unknown"
          /* KnownStorageProvider.unknown */
        );
      }
      async setUsePlainTextEncryption() {
        if (isWindows2) {
          throw new Error("Setting plain text encryption is not supported on Windows.");
        }
        if (isMacintosh) {
          throw new Error("Setting plain text encryption is not supported on macOS.");
        }
        if (!safeStorage.setUsePlainTextEncryption) {
          throw new Error("Setting plain text encryption is not supported.");
        }
        this.logService.trace("[EncryptionMainService] Setting usePlainTextEncryption to true...");
        safeStorage.setUsePlainTextEncryption(true);
        this.logService.trace("[EncryptionMainService] Set usePlainTextEncryption to true");
      }
    };
    EncryptionMainService = __decorate([
      __param(0, ILogService)
    ], EncryptionMainService);
  }
});

// out-build/vs/platform/browserElements/common/browserElements.js
var INativeBrowserElementsService, BrowserType;
var init_browserElements = __esm({
  "out-build/vs/platform/browserElements/common/browserElements.js"() {
    "use strict";
    init_instantiation();
    INativeBrowserElementsService = createDecorator("nativeBrowserElementsService");
    (function(BrowserType2) {
      BrowserType2["SimpleBrowser"] = "simpleBrowser";
      BrowserType2["LiveServer"] = "liveServer";
    })(BrowserType || (BrowserType = {}));
  }
});

// out-build/vs/platform/auxiliaryWindow/electron-main/auxiliaryWindows.js
var IAuxiliaryWindowsMainService;
var init_auxiliaryWindows = __esm({
  "out-build/vs/platform/auxiliaryWindow/electron-main/auxiliaryWindows.js"() {
    "use strict";
    init_instantiation();
    IAuxiliaryWindowsMainService = createDecorator("auxiliaryWindowsMainService");
  }
});

// out-build/vs/platform/browserElements/electron-main/nativeBrowserElementsMainService.js
import { webContents } from "electron";
var INativeBrowserElementsMainService, NativeBrowserElementsMainService;
var init_nativeBrowserElementsMainService = __esm({
  "out-build/vs/platform/browserElements/electron-main/nativeBrowserElementsMainService.js"() {
    "use strict";
    init_browserElements();
    init_auxiliaryWindows();
    init_windows();
    init_instantiation();
    init_lifecycle();
    INativeBrowserElementsMainService = createDecorator("browserElementsMainService");
    NativeBrowserElementsMainService = class NativeBrowserElementsMainService2 extends Disposable {
      constructor(windowsMainService, auxiliaryWindowsMainService) {
        super();
        this.windowsMainService = windowsMainService;
        this.auxiliaryWindowsMainService = auxiliaryWindowsMainService;
      }
      get windowId() {
        throw new Error("Not implemented in electron-main");
      }
      async findWebviewTarget(debuggers, windowId, browserType) {
        const { targetInfos } = await debuggers.sendCommand("Target.getTargets");
        let target = void 0;
        const matchingTarget = targetInfos.find((targetInfo) => {
          try {
            const url = new URL(targetInfo.url);
            if (browserType === BrowserType.LiveServer) {
              return url.searchParams.get("id") && url.searchParams.get("extensionId") === "ms-vscode.live-server";
            } else if (browserType === BrowserType.SimpleBrowser) {
              return url.searchParams.get("parentId") === windowId.toString() && url.searchParams.get("extensionId") === "vscode.simple-browser";
            }
            return false;
          } catch (err) {
            return false;
          }
        });
        if (matchingTarget) {
          let resultId;
          let url;
          try {
            url = new URL(matchingTarget.url);
            resultId = url.searchParams.get("id");
          } catch (e) {
            return void 0;
          }
          target = targetInfos.find((targetInfo) => {
            try {
              const url2 = new URL(targetInfo.url);
              const isLiveServer = browserType === BrowserType.LiveServer && url2.searchParams.get("serverWindowId") === resultId;
              const isSimpleBrowser = browserType === BrowserType.SimpleBrowser && url2.searchParams.get("id") === resultId && url2.searchParams.has("vscodeBrowserReqId");
              if (isLiveServer || isSimpleBrowser) {
                this.currentLocalAddress = url2.origin;
                return true;
              }
              return false;
            } catch (e) {
              return false;
            }
          });
          if (target) {
            return target.targetId;
          }
        }
        target = targetInfos.find((targetInfo) => {
          try {
            const url = new URL(targetInfo.url);
            return this.currentLocalAddress === url.origin;
          } catch (e) {
            return false;
          }
        });
        if (!target) {
          return void 0;
        }
        return target.targetId;
      }
      async waitForWebviewTargets(debuggers, windowId, browserType) {
        const start = Date.now();
        const timeout2 = 1e4;
        while (Date.now() - start < timeout2) {
          const targetId = await this.findWebviewTarget(debuggers, windowId, browserType);
          if (targetId) {
            return targetId;
          }
          await new Promise((resolve3) => setTimeout(resolve3, 500));
        }
        debuggers.detach();
        return void 0;
      }
      async startDebugSession(windowId, token, browserType, cancelAndDetachId) {
        const window = this.windowById(windowId);
        if (!window?.win) {
          return void 0;
        }
        const allWebContents = webContents.getAllWebContents();
        const simpleBrowserWebview = allWebContents.find((webContent) => webContent.id === window.id);
        if (!simpleBrowserWebview) {
          return void 0;
        }
        const debuggers = simpleBrowserWebview.debugger;
        if (!debuggers.isAttached()) {
          debuggers.attach();
        }
        try {
          const matchingTargetId = await this.waitForWebviewTargets(debuggers, windowId, browserType);
          if (!matchingTargetId) {
            if (debuggers.isAttached()) {
              debuggers.detach();
            }
            throw new Error("No target found");
          }
        } catch (e) {
          if (debuggers.isAttached()) {
            debuggers.detach();
          }
          throw new Error("No target found");
        }
        window.win.webContents.on("ipc-message", async (event, channel, closedCancelAndDetachId) => {
          if (channel === `vscode:cancelCurrentSession${cancelAndDetachId}`) {
            if (cancelAndDetachId !== closedCancelAndDetachId) {
              return;
            }
            if (debuggers.isAttached()) {
              debuggers.detach();
            }
            if (window.win) {
              window.win.webContents.removeAllListeners("ipc-message");
            }
          }
        });
      }
      async finishOverlay(debuggers, sessionId) {
        if (debuggers.isAttached() && sessionId) {
          await debuggers.sendCommand("Overlay.setInspectMode", {
            mode: "none",
            highlightConfig: {
              showInfo: false,
              showStyles: false
            }
          }, sessionId);
          await debuggers.sendCommand("Overlay.hideHighlight", {}, sessionId);
          await debuggers.sendCommand("Overlay.disable", {}, sessionId);
          debuggers.detach();
        }
      }
      async getElementData(windowId, rect, token, browserType, cancellationId) {
        const window = this.windowById(windowId);
        if (!window?.win) {
          return void 0;
        }
        const allWebContents = webContents.getAllWebContents();
        const simpleBrowserWebview = allWebContents.find((webContent) => webContent.id === window.id);
        if (!simpleBrowserWebview) {
          return void 0;
        }
        const debuggers = simpleBrowserWebview.debugger;
        if (!debuggers.isAttached()) {
          debuggers.attach();
        }
        let targetSessionId = void 0;
        try {
          const targetId = await this.findWebviewTarget(debuggers, windowId, browserType);
          const { sessionId } = await debuggers.sendCommand("Target.attachToTarget", {
            targetId,
            flatten: true
          });
          targetSessionId = sessionId;
          await debuggers.sendCommand("DOM.enable", {}, sessionId);
          await debuggers.sendCommand("CSS.enable", {}, sessionId);
          await debuggers.sendCommand("Overlay.enable", {}, sessionId);
          await debuggers.sendCommand("Debugger.enable", {}, sessionId);
          await debuggers.sendCommand("Runtime.enable", {}, sessionId);
          await debuggers.sendCommand("Runtime.evaluate", {
            expression: `(function() {
							const style = document.createElement('style');
							style.id = '__pseudoBlocker__';
							style.textContent = '*::before, *::after { pointer-events: none !important; }';
							document.head.appendChild(style);
						})();`
          }, sessionId);
          await debuggers.sendCommand("Overlay.setInspectMode", {
            mode: "searchForNode",
            highlightConfig: {
              showInfo: true,
              showRulers: false,
              showStyles: true,
              showAccessibilityInfo: true,
              showExtensionLines: false,
              contrastAlgorithm: "aa",
              contentColor: { r: 173, g: 216, b: 255, a: 0.8 },
              paddingColor: { r: 150, g: 200, b: 255, a: 0.5 },
              borderColor: { r: 120, g: 180, b: 255, a: 0.7 },
              marginColor: { r: 200, g: 220, b: 255, a: 0.4 },
              eventTargetColor: { r: 130, g: 160, b: 255, a: 0.8 },
              shapeColor: { r: 130, g: 160, b: 255, a: 0.8 },
              shapeMarginColor: { r: 130, g: 160, b: 255, a: 0.5 },
              gridHighlightConfig: {
                rowGapColor: { r: 140, g: 190, b: 255, a: 0.3 },
                rowHatchColor: { r: 140, g: 190, b: 255, a: 0.7 },
                columnGapColor: { r: 140, g: 190, b: 255, a: 0.3 },
                columnHatchColor: { r: 140, g: 190, b: 255, a: 0.7 },
                rowLineColor: { r: 120, g: 180, b: 255 },
                columnLineColor: { r: 120, g: 180, b: 255 },
                rowLineDash: true,
                columnLineDash: true
              },
              flexContainerHighlightConfig: {
                containerBorder: {
                  color: { r: 120, g: 180, b: 255 },
                  pattern: "solid"
                },
                itemSeparator: {
                  color: { r: 140, g: 190, b: 255 },
                  pattern: "solid"
                },
                lineSeparator: {
                  color: { r: 140, g: 190, b: 255 },
                  pattern: "solid"
                },
                mainDistributedSpace: {
                  hatchColor: { r: 140, g: 190, b: 255, a: 0.7 },
                  fillColor: { r: 140, g: 190, b: 255, a: 0.4 }
                },
                crossDistributedSpace: {
                  hatchColor: { r: 140, g: 190, b: 255, a: 0.7 },
                  fillColor: { r: 140, g: 190, b: 255, a: 0.4 }
                },
                rowGapSpace: {
                  hatchColor: { r: 140, g: 190, b: 255, a: 0.7 },
                  fillColor: { r: 140, g: 190, b: 255, a: 0.4 }
                },
                columnGapSpace: {
                  hatchColor: { r: 140, g: 190, b: 255, a: 0.7 },
                  fillColor: { r: 140, g: 190, b: 255, a: 0.4 }
                }
              },
              flexItemHighlightConfig: {
                baseSizeBox: {
                  hatchColor: { r: 130, g: 170, b: 255, a: 0.6 }
                },
                baseSizeBorder: {
                  color: { r: 120, g: 180, b: 255 },
                  pattern: "solid"
                },
                flexibilityArrow: {
                  color: { r: 130, g: 190, b: 255 }
                }
              }
            }
          }, sessionId);
        } catch (e) {
          debuggers.detach();
          throw new Error("No target found", e);
        }
        if (!targetSessionId) {
          debuggers.detach();
          throw new Error("No target session id found");
        }
        const nodeData = await this.getNodeData(targetSessionId, debuggers, window.win, cancellationId);
        await this.finishOverlay(debuggers, targetSessionId);
        const zoomFactor = simpleBrowserWebview.getZoomFactor();
        const absoluteBounds = {
          x: rect.x + nodeData.bounds.x,
          y: rect.y + nodeData.bounds.y,
          width: nodeData.bounds.width,
          height: nodeData.bounds.height
        };
        const clippedBounds = {
          x: Math.max(absoluteBounds.x, rect.x),
          y: Math.max(absoluteBounds.y, rect.y),
          width: Math.max(0, Math.min(absoluteBounds.x + absoluteBounds.width, rect.x + rect.width) - Math.max(absoluteBounds.x, rect.x)),
          height: Math.max(0, Math.min(absoluteBounds.y + absoluteBounds.height, rect.y + rect.height) - Math.max(absoluteBounds.y, rect.y))
        };
        const scaledBounds = {
          x: clippedBounds.x * zoomFactor,
          y: clippedBounds.y * zoomFactor,
          width: clippedBounds.width * zoomFactor,
          height: clippedBounds.height * zoomFactor
        };
        return { outerHTML: nodeData.outerHTML, computedStyle: nodeData.computedStyle, bounds: scaledBounds };
      }
      async getNodeData(sessionId, debuggers, window, cancellationId) {
        return new Promise((resolve3, reject) => {
          const onMessage = async (event, method, params) => {
            if (method === "Overlay.inspectNodeRequested") {
              debuggers.off("message", onMessage);
              await debuggers.sendCommand("Runtime.evaluate", {
                expression: `(() => {
										const style = document.getElementById('__pseudoBlocker__');
										if (style) style.remove();
									})();`
              }, sessionId);
              const backendNodeId = params?.backendNodeId;
              if (!backendNodeId) {
                throw new Error("Missing backendNodeId in inspectNodeRequested event");
              }
              try {
                await debuggers.sendCommand("DOM.getDocument", {}, sessionId);
                const { nodeIds } = await debuggers.sendCommand("DOM.pushNodesByBackendIdsToFrontend", { backendNodeIds: [backendNodeId] }, sessionId);
                if (!nodeIds || nodeIds.length === 0) {
                  throw new Error("Failed to get node IDs.");
                }
                const nodeId = nodeIds[0];
                const { model } = await debuggers.sendCommand("DOM.getBoxModel", { nodeId }, sessionId);
                if (!model) {
                  throw new Error("Failed to get box model.");
                }
                const content = model.content;
                const margin = model.margin;
                const x = Math.min(margin[0], content[0]);
                const y = Math.min(margin[1], content[1]) + 32.4;
                const width = Math.max(margin[2] - margin[0], content[2] - content[0]);
                const height = Math.max(margin[5] - margin[1], content[5] - content[1]);
                const matched = await debuggers.sendCommand("CSS.getMatchedStylesForNode", { nodeId }, sessionId);
                if (!matched) {
                  throw new Error("Failed to get matched css.");
                }
                const formatted = this.formatMatchedStyles(matched);
                const { outerHTML } = await debuggers.sendCommand("DOM.getOuterHTML", { nodeId }, sessionId);
                if (!outerHTML) {
                  throw new Error("Failed to get outerHTML.");
                }
                resolve3({
                  outerHTML,
                  computedStyle: formatted,
                  bounds: { x, y, width, height }
                });
              } catch (err) {
                debuggers.off("message", onMessage);
                debuggers.detach();
                reject(err);
              }
            }
          };
          window.webContents.on("ipc-message", async (event, channel, closedCancellationId) => {
            if (channel === `vscode:cancelElementSelection${cancellationId}`) {
              if (cancellationId !== closedCancellationId) {
                return;
              }
              debuggers.off("message", onMessage);
              await this.finishOverlay(debuggers, sessionId);
              window.webContents.removeAllListeners("ipc-message");
            }
          });
          debuggers.on("message", onMessage);
        });
      }
      formatMatchedStyles(matched) {
        const lines = [];
        if (matched.inlineStyle?.cssProperties?.length) {
          lines.push("/* Inline style */");
          lines.push("element {");
          for (const prop of matched.inlineStyle.cssProperties) {
            if (prop.name && prop.value) {
              lines.push(`  ${prop.name}: ${prop.value};`);
            }
          }
          lines.push("}\n");
        }
        if (matched.matchedCSSRules?.length) {
          for (const ruleEntry of matched.matchedCSSRules) {
            const rule = ruleEntry.rule;
            const selectors = rule.selectorList.selectors.map((s) => s.text).join(", ");
            lines.push(`/* Matched Rule from ${rule.origin} */`);
            lines.push(`${selectors} {`);
            for (const prop of rule.style.cssProperties) {
              if (prop.name && prop.value) {
                lines.push(`  ${prop.name}: ${prop.value};`);
              }
            }
            lines.push("}\n");
          }
        }
        if (matched.inherited?.length) {
          let level = 1;
          for (const inherited of matched.inherited) {
            const rules = inherited.matchedCSSRules || [];
            for (const ruleEntry of rules) {
              const rule = ruleEntry.rule;
              const selectors = rule.selectorList.selectors.map((s) => s.text).join(", ");
              lines.push(`/* Inherited from ancestor level ${level} (${rule.origin}) */`);
              lines.push(`${selectors} {`);
              for (const prop of rule.style.cssProperties) {
                if (prop.name && prop.value) {
                  lines.push(`  ${prop.name}: ${prop.value};`);
                }
              }
              lines.push("}\n");
            }
            level++;
          }
        }
        return "\n" + lines.join("\n");
      }
      windowById(windowId, fallbackCodeWindowId) {
        return this.codeWindowById(windowId) ?? this.auxiliaryWindowById(windowId) ?? this.codeWindowById(fallbackCodeWindowId);
      }
      codeWindowById(windowId) {
        if (typeof windowId !== "number") {
          return void 0;
        }
        return this.windowsMainService.getWindowById(windowId);
      }
      auxiliaryWindowById(windowId) {
        if (typeof windowId !== "number") {
          return void 0;
        }
        const contents = webContents.fromId(windowId);
        if (!contents) {
          return void 0;
        }
        return this.auxiliaryWindowsMainService.getWindowByWebContents(contents);
      }
    };
    NativeBrowserElementsMainService = __decorate([
      __param(0, IWindowsMainService),
      __param(1, IAuxiliaryWindowsMainService)
    ], NativeBrowserElementsMainService);
  }
});

// out-build/vs/platform/environment/node/argvHelper.js
import assert2 from "assert";
function parseAndValidate(cmdLineArgs, reportWarnings) {
  const onMultipleValues = (id2, val) => {
    console.warn(localize(1889, null, id2, val));
  };
  const onEmptyValue = (id2) => {
    console.warn(localize(1890, null, id2));
  };
  const onDeprecatedOption = (deprecatedOption, message) => {
    console.warn(localize(1891, null, deprecatedOption, message));
  };
  const getSubcommandReporter = (command) => ({
    onUnknownOption: (id2) => {
      if (!NATIVE_CLI_COMMANDS.includes(command)) {
        console.warn(localize(1892, null, id2, command));
      }
    },
    onMultipleValues,
    onEmptyValue,
    onDeprecatedOption,
    getSubcommandReporter: NATIVE_CLI_COMMANDS.includes(command) ? getSubcommandReporter : void 0
  });
  const errorReporter = {
    onUnknownOption: (id2) => {
      console.warn(localize(1893, null, id2));
    },
    onMultipleValues,
    onEmptyValue,
    onDeprecatedOption,
    getSubcommandReporter
  };
  const args2 = parseArgs(cmdLineArgs, OPTIONS, reportWarnings ? errorReporter : void 0);
  if (args2.goto) {
    args2._.forEach((arg) => assert2(/^(\w:)?[^:]+(:\d*){0,2}:?$/.test(arg), localize(1894, null)));
  }
  return args2;
}
function stripAppPath(argv) {
  const index = argv.findIndex((a) => !/^-/.test(a));
  if (index > -1) {
    return [...argv.slice(0, index), ...argv.slice(index + 1)];
  }
  return void 0;
}
function parseMainProcessArgv(processArgv) {
  let [, ...args2] = processArgv;
  if (process.env["VSCODE_DEV"]) {
    args2 = stripAppPath(args2) || [];
  }
  const reportWarnings = !isLaunchedFromCli(process.env);
  return parseAndValidate(args2, reportWarnings);
}
function addArg(argv, ...args2) {
  const endOfArgsMarkerIndex = argv.indexOf("--");
  if (endOfArgsMarkerIndex === -1) {
    argv.push(...args2);
  } else {
    argv.splice(endOfArgsMarkerIndex, 0, ...args2);
  }
  return argv;
}
function isLaunchedFromCli(env2) {
  return env2["VSCODE_CLI"] === "1";
}
var init_argvHelper = __esm({
  "out-build/vs/platform/environment/node/argvHelper.js"() {
    "use strict";
    init_nls();
    init_argv();
  }
});

// out-build/vs/base/node/powershell.js
import * as os from "os";
function getProgramFilesPath({ useAlternateBitness = false } = {}) {
  if (!useAlternateBitness) {
    return process.env.ProgramFiles || null;
  }
  if (processArch === 0) {
    return process.env["ProgramFiles(x86)"] || null;
  }
  if (osArch === 0) {
    return process.env.ProgramW6432 || null;
  }
  return null;
}
async function findPSCoreWindowsInstallation({ useAlternateBitness = false, findPreview = false } = {}) {
  const programFilesPath = getProgramFilesPath({ useAlternateBitness });
  if (!programFilesPath) {
    return null;
  }
  const powerShellInstallBaseDir = join3(programFilesPath, "PowerShell");
  if (!await SymlinkSupport.existsDirectory(powerShellInstallBaseDir)) {
    return null;
  }
  let highestSeenVersion = -1;
  let pwshExePath = null;
  for (const item of await Promises2.readdir(powerShellInstallBaseDir)) {
    let currentVersion = -1;
    if (findPreview) {
      const dashIndex = item.indexOf("-");
      if (dashIndex < 0) {
        continue;
      }
      const intPart = item.substring(0, dashIndex);
      if (!IntRegex.test(intPart) || item.substring(dashIndex + 1) !== "preview") {
        continue;
      }
      currentVersion = parseInt(intPart, 10);
    } else {
      if (!IntRegex.test(item)) {
        continue;
      }
      currentVersion = parseInt(item, 10);
    }
    if (currentVersion <= highestSeenVersion) {
      continue;
    }
    const exePath = join3(powerShellInstallBaseDir, item, "pwsh.exe");
    if (!await SymlinkSupport.existsFile(exePath)) {
      continue;
    }
    pwshExePath = exePath;
    highestSeenVersion = currentVersion;
  }
  if (!pwshExePath) {
    return null;
  }
  const bitness = programFilesPath.includes("x86") ? " (x86)" : "";
  const preview = findPreview ? " Preview" : "";
  return new PossiblePowerShellExe(pwshExePath, `PowerShell${preview}${bitness}`, true);
}
async function findPSCoreMsix({ findPreview } = {}) {
  if (!process.env.LOCALAPPDATA) {
    return null;
  }
  const msixAppDir = join3(process.env.LOCALAPPDATA, "Microsoft", "WindowsApps");
  if (!await SymlinkSupport.existsDirectory(msixAppDir)) {
    return null;
  }
  const { pwshMsixDirRegex, pwshMsixName } = findPreview ? { pwshMsixDirRegex: PwshPreviewMsixRegex, pwshMsixName: "PowerShell Preview (Store)" } : { pwshMsixDirRegex: PwshMsixRegex, pwshMsixName: "PowerShell (Store)" };
  for (const subdir of await Promises2.readdir(msixAppDir)) {
    if (pwshMsixDirRegex.test(subdir)) {
      const pwshMsixPath = join3(msixAppDir, subdir, "pwsh.exe");
      return new PossiblePowerShellExe(pwshMsixPath, pwshMsixName);
    }
  }
  return null;
}
function findPSCoreDotnetGlobalTool() {
  const dotnetGlobalToolExePath = join3(os.homedir(), ".dotnet", "tools", "pwsh.exe");
  return new PossiblePowerShellExe(dotnetGlobalToolExePath, ".NET Core PowerShell Global Tool");
}
function findPSCoreScoopInstallation() {
  const scoopAppsDir = join3(os.homedir(), "scoop", "apps");
  const scoopPwsh = join3(scoopAppsDir, "pwsh", "current", "pwsh.exe");
  return new PossiblePowerShellExe(scoopPwsh, "PowerShell (Scoop)");
}
function findWinPS() {
  const winPSPath = join3(process.env.windir, processArch === 1 && osArch !== 1 ? "SysNative" : "System32", "WindowsPowerShell", "v1.0", "powershell.exe");
  return new PossiblePowerShellExe(winPSPath, "Windows PowerShell", true);
}
async function* enumerateDefaultPowerShellInstallations() {
  let pwshExe = await findPSCoreWindowsInstallation();
  if (pwshExe) {
    yield pwshExe;
  }
  pwshExe = await findPSCoreWindowsInstallation({ useAlternateBitness: true });
  if (pwshExe) {
    yield pwshExe;
  }
  pwshExe = await findPSCoreMsix();
  if (pwshExe) {
    yield pwshExe;
  }
  pwshExe = findPSCoreDotnetGlobalTool();
  if (pwshExe) {
    yield pwshExe;
  }
  pwshExe = await findPSCoreWindowsInstallation({ findPreview: true });
  if (pwshExe) {
    yield pwshExe;
  }
  pwshExe = await findPSCoreMsix({ findPreview: true });
  if (pwshExe) {
    yield pwshExe;
  }
  pwshExe = await findPSCoreWindowsInstallation({ useAlternateBitness: true, findPreview: true });
  if (pwshExe) {
    yield pwshExe;
  }
  pwshExe = await findPSCoreScoopInstallation();
  if (pwshExe) {
    yield pwshExe;
  }
  pwshExe = findWinPS();
  if (pwshExe) {
    yield pwshExe;
  }
}
async function* enumeratePowerShellInstallations() {
  for await (const defaultPwsh of enumerateDefaultPowerShellInstallations()) {
    if (await defaultPwsh.exists()) {
      yield defaultPwsh;
    }
  }
}
async function getFirstAvailablePowerShellInstallation() {
  for await (const pwsh of enumeratePowerShellInstallations()) {
    return pwsh;
  }
  return null;
}
var IntRegex, PwshMsixRegex, PwshPreviewMsixRegex, Arch, processArch, osArch, PossiblePowerShellExe;
var init_powershell = __esm({
  "out-build/vs/base/node/powershell.js"() {
    "use strict";
    init_path();
    init_pfs();
    IntRegex = /^\d+$/;
    PwshMsixRegex = /^Microsoft.PowerShell_.*/;
    PwshPreviewMsixRegex = /^Microsoft.PowerShellPreview_.*/;
    (function(Arch2) {
      Arch2[Arch2["x64"] = 0] = "x64";
      Arch2[Arch2["x86"] = 1] = "x86";
      Arch2[Arch2["ARM"] = 2] = "ARM";
    })(Arch || (Arch = {}));
    switch (process.arch) {
      case "ia32":
        processArch = 1;
        break;
      case "arm":
      case "arm64":
        processArch = 2;
        break;
      default:
        processArch = 0;
        break;
    }
    if (process.env["PROCESSOR_ARCHITEW6432"]) {
      osArch = process.env["PROCESSOR_ARCHITEW6432"] === "ARM64" ? 2 : 0;
    } else if (process.env["PROCESSOR_ARCHITECTURE"] === "ARM64") {
      osArch = 2;
    } else if (process.env["PROCESSOR_ARCHITECTURE"] === "X86") {
      osArch = 1;
    } else {
      osArch = 0;
    }
    PossiblePowerShellExe = class {
      constructor(exePath, displayName, knownToExist) {
        this.exePath = exePath;
        this.displayName = displayName;
        this.knownToExist = knownToExist;
      }
      async exists() {
        if (this.knownToExist === void 0) {
          this.knownToExist = await SymlinkSupport.existsFile(this.exePath);
        }
        return this.knownToExist;
      }
    };
  }
});

// out-build/vs/base/node/processes.js
import { promises as promises7 } from "fs";
function getWindowsShell(env2 = env) {
  return env2["comspec"] || "cmd.exe";
}
function createQueuedSender(childProcess) {
  let msgQueue = [];
  let useQueue = false;
  const send = function(msg) {
    if (useQueue) {
      msgQueue.push(msg);
      return;
    }
    const result = childProcess.send(msg, (error) => {
      if (error) {
        console.error(error);
      }
      useQueue = false;
      if (msgQueue.length > 0) {
        const msgQueueCopy = msgQueue.slice(0);
        msgQueue = [];
        msgQueueCopy.forEach((entry) => send(entry));
      }
    });
    if (!result || isWindows2) {
      useQueue = true;
    }
  };
  return { send };
}
async function fileExistsDefault(path4) {
  if (await Promises2.exists(path4)) {
    let statValue;
    try {
      statValue = await promises7.stat(path4);
    } catch (e) {
      if (e.message.startsWith("EACCES")) {
        statValue = await promises7.lstat(path4);
      }
    }
    return statValue ? !statValue.isDirectory() : false;
  }
  return false;
}
function getWindowPathExtensions(env2 = env) {
  return (getCaseInsensitive(env2, "PATHEXT") || ".COM;.EXE;.BAT;.CMD").split(";");
}
async function findExecutable(command, cwd3, paths, env2 = env, fileExists = fileExistsDefault) {
  if (isAbsolute2(command)) {
    return await fileExists(command) ? command : void 0;
  }
  if (cwd3 === void 0) {
    cwd3 = cwd2();
  }
  const dir = dirname3(command);
  if (dir !== ".") {
    const fullPath2 = join3(cwd3, command);
    return await fileExists(fullPath2) ? fullPath2 : void 0;
  }
  const envPath = getCaseInsensitive(env2, "PATH");
  if (paths === void 0 && isString(envPath)) {
    paths = envPath.split(delimiter);
  }
  if (paths === void 0 || paths.length === 0) {
    const fullPath2 = join3(cwd3, command);
    return await fileExists(fullPath2) ? fullPath2 : void 0;
  }
  for (const pathEntry of paths) {
    let fullPath2;
    if (isAbsolute2(pathEntry)) {
      fullPath2 = join3(pathEntry, command);
    } else {
      fullPath2 = join3(cwd3, pathEntry, command);
    }
    if (isWindows2) {
      const pathExtsFound = getWindowPathExtensions(env2).map(async (ext) => {
        const withExtension = fullPath2 + ext;
        return await fileExists(withExtension) ? withExtension : void 0;
      });
      for (const foundPromise of pathExtsFound) {
        const found = await foundPromise;
        if (found) {
          return found;
        }
      }
    }
    if (await fileExists(fullPath2)) {
      return fullPath2;
    }
  }
  const fullPath = join3(cwd3, command);
  return await fileExists(fullPath) ? fullPath : void 0;
}
var init_processes2 = __esm({
  "out-build/vs/base/node/processes.js"() {
    "use strict";
    init_objects();
    init_path();
    init_platform();
    init_process();
    init_processes();
    init_types();
    init_pfs();
  }
});

// out-build/vs/base/node/shell.js
import { userInfo } from "os";
async function getSystemShell(os6, env2) {
  if (os6 === 1) {
    if (isWindows2) {
      return getSystemShellWindows();
    }
    return getWindowsShell(env2);
  }
  return getSystemShellUnixLike(os6, env2);
}
function getSystemShellUnixLike(os6, env2) {
  if (isLinux && os6 === 2 || isMacintosh && os6 === 3) {
    return "/bin/bash";
  }
  if (!_TERMINAL_DEFAULT_SHELL_UNIX_LIKE) {
    let unixLikeTerminal;
    if (isWindows2) {
      unixLikeTerminal = "/bin/bash";
    } else {
      unixLikeTerminal = env2["SHELL"];
      if (!unixLikeTerminal) {
        try {
          unixLikeTerminal = userInfo().shell;
        } catch (err) {
        }
      }
      if (!unixLikeTerminal) {
        unixLikeTerminal = "sh";
      }
      if (unixLikeTerminal === "/bin/false") {
        unixLikeTerminal = "/bin/bash";
      }
    }
    _TERMINAL_DEFAULT_SHELL_UNIX_LIKE = unixLikeTerminal;
  }
  return _TERMINAL_DEFAULT_SHELL_UNIX_LIKE;
}
async function getSystemShellWindows() {
  if (!_TERMINAL_DEFAULT_SHELL_WINDOWS) {
    _TERMINAL_DEFAULT_SHELL_WINDOWS = (await getFirstAvailablePowerShellInstallation()).exePath;
  }
  return _TERMINAL_DEFAULT_SHELL_WINDOWS;
}
var _TERMINAL_DEFAULT_SHELL_UNIX_LIKE, _TERMINAL_DEFAULT_SHELL_WINDOWS;
var init_shell = __esm({
  "out-build/vs/base/node/shell.js"() {
    "use strict";
    init_platform();
    init_powershell();
    init_processes2();
    _TERMINAL_DEFAULT_SHELL_UNIX_LIKE = null;
    _TERMINAL_DEFAULT_SHELL_WINDOWS = null;
  }
});

// out-build/vs/base/common/numbers.js
function clamp(value, min, max) {
  return Math.min(Math.max(value, min), max);
}
var init_numbers = __esm({
  "out-build/vs/base/common/numbers.js"() {
    "use strict";
    init_assert();
  }
});

// out-build/vs/platform/shell/node/shellEnv.js
import { spawn } from "child_process";
import { homedir as homedir4 } from "os";
async function getResolvedShellEnv(configurationService, logService, args2, env2) {
  if (args2["force-disable-user-env"]) {
    logService.trace("resolveShellEnv(): skipped (--force-disable-user-env)");
    return {};
  } else if (isLaunchedFromCli(env2) && !args2["force-user-env"]) {
    logService.trace("resolveShellEnv(): skipped (VSCODE_CLI is set)");
    return {};
  } else {
    if (isLaunchedFromCli(env2)) {
      logService.trace("resolveShellEnv(): running (--force-user-env)");
    } else {
      logService.trace("resolveShellEnv(): running");
    }
    if (!shellEnvPromise) {
      shellEnvPromise = Promises.withAsyncBody(async (resolve3, reject) => {
        const cts = new CancellationTokenSource();
        let timeoutValue = 1e4;
        const configuredTimeoutValue = configurationService.getValue("application.shellEnvironmentResolutionTimeout");
        if (typeof configuredTimeoutValue === "number") {
          timeoutValue = clamp(configuredTimeoutValue, 1, 120) * 1e3;
        }
        const timeout2 = setTimeout(() => {
          cts.dispose(true);
          reject(new Error(localize(2223, null)));
        }, timeoutValue);
        try {
          resolve3(await doResolveShellEnv(logService, cts.token));
        } catch (error) {
          if (!isCancellationError(error) && !cts.token.isCancellationRequested) {
            reject(new Error(localize(2224, null, toErrorMessage(error))));
          } else {
            resolve3({});
          }
        } finally {
          clearTimeout(timeout2);
          cts.dispose();
        }
      });
    }
    return shellEnvPromise;
  }
}
async function doResolveShellEnv(logService, token) {
  const runAsNode = process.env["ELECTRON_RUN_AS_NODE"];
  logService.trace("doResolveShellEnv#runAsNode", runAsNode);
  const noAttach = process.env["ELECTRON_NO_ATTACH_CONSOLE"];
  logService.trace("doResolveShellEnv#noAttach", noAttach);
  const mark2 = generateUuid().replace(/-/g, "").substr(0, 12);
  const regex = new RegExp(mark2 + "([\\s\\S]*?)" + mark2);
  const env2 = {
    ...process.env,
    ELECTRON_RUN_AS_NODE: "1",
    ELECTRON_NO_ATTACH_CONSOLE: "1",
    VSCODE_RESOLVING_ENVIRONMENT: "1"
  };
  logService.trace("doResolveShellEnv#env", env2);
  const systemShell = await getSystemShell(OS, env2);
  logService.trace("doResolveShellEnv#shell", systemShell);
  let name = basename(systemShell);
  if (isWindows2) {
    const nameExt = extname(name);
    if (getWindowPathExtensions().some((e) => equalsIgnoreCase(e, nameExt))) {
      name = name.substring(0, name.length - nameExt.length);
    }
  }
  let command, shellArgs;
  const extraArgs = "";
  if (/^(?:pwsh|powershell)(?:-preview)?$/.test(name)) {
    const profilePaths = await getPowershellProfilePaths(systemShell);
    const profilePathThatExists = await first(profilePaths.map((profilePath) => async () => await Promises2.exists(profilePath) ? profilePath : void 0));
    if (!profilePathThatExists) {
      logService.trace("doResolveShellEnv#noPowershellProfile after testing paths", profilePaths);
      return {};
    }
    logService.trace("doResolveShellEnv#powershellProfile found in", profilePathThatExists);
    command = `Write-Output '${mark2}'; [System.Environment]::GetEnvironmentVariables() | ConvertTo-Json -Compress; Write-Output '${mark2}'`;
    shellArgs = isWindows2 ? ["-Command"] : ["-Login", "-Command"];
  } else if (name === "nu") {
    command = `^'${process.execPath}' ${extraArgs} -p '"${mark2}" + JSON.stringify(process.env) + "${mark2}"'`;
    shellArgs = ["-i", "-l", "-c"];
  } else if (name === "xonsh") {
    command = `import os, json; print("${mark2}", json.dumps(dict(os.environ)), "${mark2}")`;
    shellArgs = ["-i", "-l", "-c"];
  } else {
    command = `'${process.execPath}' ${extraArgs} -p '"${mark2}" + JSON.stringify(process.env) + "${mark2}"'`;
    if (name === "tcsh" || name === "csh") {
      shellArgs = ["-ic"];
    } else {
      shellArgs = ["-i", "-l", "-c"];
    }
  }
  return new Promise((resolve3, reject) => {
    if (token.isCancellationRequested) {
      return reject(new CancellationError());
    }
    logService.trace("doResolveShellEnv#spawn", JSON.stringify(shellArgs), command);
    const child = spawn(systemShell, [...shellArgs, command], {
      detached: !isWindows2,
      stdio: ["ignore", "pipe", "pipe"],
      env: env2
    });
    token.onCancellationRequested(() => {
      child.kill();
      return reject(new CancellationError());
    });
    child.on("error", (err) => {
      logService.error("doResolveShellEnv#errorChildProcess", toErrorMessage(err));
      reject(err);
    });
    const buffers = [];
    child.stdout.on("data", (b) => buffers.push(b));
    const stderr = [];
    child.stderr.on("data", (b) => stderr.push(b));
    child.on("close", (code2, signal) => {
      const raw = Buffer.concat(buffers).toString("utf8");
      logService.trace("doResolveShellEnv#raw", raw);
      const stderrStr = Buffer.concat(stderr).toString("utf8");
      if (stderrStr.trim()) {
        logService.trace("doResolveShellEnv#stderr", stderrStr);
      }
      if (code2 || signal) {
        return reject(new Error(localize(2225, null, code2, signal)));
      }
      const match = regex.exec(raw);
      const rawStripped = match ? match[1] : "{}";
      try {
        const env3 = JSON.parse(rawStripped);
        if (runAsNode) {
          env3["ELECTRON_RUN_AS_NODE"] = runAsNode;
        } else {
          delete env3["ELECTRON_RUN_AS_NODE"];
        }
        if (noAttach) {
          env3["ELECTRON_NO_ATTACH_CONSOLE"] = noAttach;
        } else {
          delete env3["ELECTRON_NO_ATTACH_CONSOLE"];
        }
        delete env3["VSCODE_RESOLVING_ENVIRONMENT"];
        delete env3["XDG_RUNTIME_DIR"];
        logService.trace("doResolveShellEnv#result", env3);
        resolve3(env3);
      } catch (err) {
        logService.error("doResolveShellEnv#errorCaught", toErrorMessage(err));
        reject(err);
      }
    });
  });
}
async function getPowershellProfilePaths(psExecutable) {
  const paths = [];
  const userHome = homedir4();
  if (isWindows2) {
    let pshome = process.env.PSHOME;
    if (!pshome) {
      if (!isAbsolute2(psExecutable)) {
        const found = await findExecutable(psExecutable);
        if (!found) {
          return [];
        }
        pshome = dirname3(found);
      } else {
        pshome = dirname3(psExecutable);
      }
    }
    paths.push(
      join3(pshome, "Profile.ps1"),
      // All Users, All Hosts
      join3(pshome, "Microsoft.PowerShell_profile.ps1"),
      // All Users, Current Host
      join3(userHome, "Documents", "PowerShell", "Profile.ps1"),
      // Current User, All Hosts
      join3(userHome, "Documents", "PowerShell", "Microsoft.PowerShell_profile.ps1"),
      // Current User, Current Host
      join3(userHome, "Documents", "WindowsPowerShell", "Profile.ps1"),
      // (Powershell 5) Current User, All Hosts
      join3(userHome, "Documents", "WindowsPowerShell", "Microsoft.PowerShell_profile.ps1")
    );
  } else if (isMacintosh) {
    paths.push(
      "/usr/local/microsoft/powershell/7/profile.ps1",
      // All Users, All Hosts
      "/usr/local/microsoft/powershell/7/Microsoft.PowerShell_profile.ps1",
      // All Users, Current Host
      join3(userHome, ".config", "powershell", "profile.ps1"),
      // Current User, All Hosts
      join3(userHome, ".config", "powershell", "Microsoft.PowerShell_profile.ps1")
    );
  } else {
    paths.push(
      "/opt/microsoft/powershell/7/profile.ps1",
      // All Users, All Hosts
      "/opt/microsoft/powershell/7/Microsoft.PowerShell_profile.ps1",
      // All Users, Current Host
      join3(userHome, ".config", "powershell", "profile.ps1"),
      // Current User, All Hosts
      join3(userHome, ".config", "powershell", "Microsoft.PowerShell_profile.ps1")
    );
  }
  return paths;
}
var shellEnvPromise;
var init_shellEnv = __esm({
  "out-build/vs/platform/shell/node/shellEnv.js"() {
    "use strict";
    init_path();
    init_nls();
    init_cancellation();
    init_errorMessage();
    init_errors();
    init_platform();
    init_uuid();
    init_shell();
    init_argvHelper();
    init_async();
    init_numbers();
    init_processes2();
    init_strings();
    init_pfs();
    shellEnvPromise = void 0;
  }
});

// out-build/vs/platform/extensions/common/extensionHostStarter.js
var IExtensionHostStarter, ipcExtensionHostStarterChannelName;
var init_extensionHostStarter = __esm({
  "out-build/vs/platform/extensions/common/extensionHostStarter.js"() {
    "use strict";
    init_instantiation();
    IExtensionHostStarter = createDecorator("extensionHostStarter");
    ipcExtensionHostStarterChannelName = "extensionHostStarter";
  }
});

// out-build/vs/platform/extensions/electron-main/extensionHostStarter.js
var ExtensionHostStarter_1, ExtensionHostStarter;
var init_extensionHostStarter2 = __esm({
  "out-build/vs/platform/extensions/electron-main/extensionHostStarter.js"() {
    "use strict";
    init_async();
    init_errors();
    init_event();
    init_lifecycle();
    init_lifecycleMainService();
    init_log();
    init_telemetry();
    init_utilityProcess();
    init_windows();
    init_configuration();
    ExtensionHostStarter = class ExtensionHostStarter2 extends Disposable {
      static {
        ExtensionHostStarter_1 = this;
      }
      static {
        this._lastId = 0;
      }
      constructor(_logService, _lifecycleMainService, _windowsMainService, _telemetryService, _configurationService) {
        super();
        this._logService = _logService;
        this._lifecycleMainService = _lifecycleMainService;
        this._windowsMainService = _windowsMainService;
        this._telemetryService = _telemetryService;
        this._configurationService = _configurationService;
        this._extHosts = /* @__PURE__ */ new Map();
        this._shutdown = false;
        this._register(this._lifecycleMainService.onWillShutdown((e) => {
          this._shutdown = true;
          e.join("extHostStarter", this._waitForAllExit(6e3));
        }));
      }
      dispose() {
        super.dispose();
      }
      _getExtHost(id2) {
        const extHostProcess = this._extHosts.get(id2);
        if (!extHostProcess) {
          throw new Error(`Unknown extension host!`);
        }
        return extHostProcess;
      }
      onDynamicStdout(id2) {
        return this._getExtHost(id2).onStdout;
      }
      onDynamicStderr(id2) {
        return this._getExtHost(id2).onStderr;
      }
      onDynamicMessage(id2) {
        return this._getExtHost(id2).onMessage;
      }
      onDynamicExit(id2) {
        return this._getExtHost(id2).onExit;
      }
      async createExtensionHost() {
        if (this._shutdown) {
          throw canceled();
        }
        const id2 = String(++ExtensionHostStarter_1._lastId);
        const extHost = new WindowUtilityProcess(this._logService, this._windowsMainService, this._telemetryService, this._lifecycleMainService);
        this._extHosts.set(id2, extHost);
        const disposable = extHost.onExit(({ pid, code: code2, signal }) => {
          disposable.dispose();
          this._logService.info(`Extension host with pid ${pid} exited with code: ${code2}, signal: ${signal}.`);
          setTimeout(() => {
            extHost.dispose();
            this._extHosts.delete(id2);
          });
          setTimeout(() => {
            try {
              process.kill(pid, 0);
              this._logService.error(`Extension host with pid ${pid} still exists, forcefully killing it...`);
              process.kill(pid);
            } catch (er) {
            }
          }, 1e3);
        });
        return { id: id2 };
      }
      async start(id2, opts) {
        if (this._shutdown) {
          throw canceled();
        }
        const extHost = this._getExtHost(id2);
        const args2 = ["--skipWorkspaceStorageLock"];
        if (this._configurationService.getValue("extensions.supportNodeGlobalNavigator")) {
          args2.push("--supportGlobalNavigator");
        }
        extHost.start({
          ...opts,
          type: "extensionHost",
          name: "extension-host",
          entryPoint: "vs/workbench/api/node/extensionHostProcess",
          args: args2,
          execArgv: opts.execArgv,
          allowLoadingUnsignedLibraries: true,
          respondToAuthRequestsFromMainProcess: true,
          correlationId: id2
        });
        const pid = await Event.toPromise(extHost.onSpawn);
        return { pid };
      }
      async enableInspectPort(id2) {
        if (this._shutdown) {
          throw canceled();
        }
        const extHostProcess = this._extHosts.get(id2);
        if (!extHostProcess) {
          return false;
        }
        return extHostProcess.enableInspectPort();
      }
      async kill(id2) {
        if (this._shutdown) {
          throw canceled();
        }
        const extHostProcess = this._extHosts.get(id2);
        if (!extHostProcess) {
          return;
        }
        extHostProcess.kill();
      }
      async _killAllNow() {
        for (const [, extHost] of this._extHosts) {
          extHost.kill();
        }
      }
      async _waitForAllExit(maxWaitTimeMs) {
        const exitPromises = [];
        for (const [, extHost] of this._extHosts) {
          exitPromises.push(extHost.waitForExit(maxWaitTimeMs));
        }
        return Promises.settled(exitPromises).then(() => {
        });
      }
    };
    ExtensionHostStarter = ExtensionHostStarter_1 = __decorate([
      __param(0, ILogService),
      __param(1, ILifecycleMainService),
      __param(2, IWindowsMainService),
      __param(3, ITelemetryService),
      __param(4, IConfigurationService)
    ], ExtensionHostStarter);
  }
});

// out-build/vs/platform/externalTerminal/electron-main/externalTerminal.js
var IExternalTerminalMainService;
var init_externalTerminal = __esm({
  "out-build/vs/platform/externalTerminal/electron-main/externalTerminal.js"() {
    "use strict";
    init_instantiation();
    IExternalTerminalMainService = createDecorator("externalTerminal");
  }
});

// out-build/vs/platform/externalTerminal/common/externalTerminal.js
var IExternalTerminalService, DEFAULT_TERMINAL_OSX;
var init_externalTerminal2 = __esm({
  "out-build/vs/platform/externalTerminal/common/externalTerminal.js"() {
    "use strict";
    init_instantiation();
    IExternalTerminalService = createDecorator("externalTerminal");
    DEFAULT_TERMINAL_OSX = "Terminal.app";
  }
});

// out-build/vs/platform/externalTerminal/node/externalTerminalService.js
import * as cp from "child_process";
function getSanitizedEnvironment(process2) {
  const env2 = { ...process2.env };
  sanitizeProcessEnvironment(env2);
  return env2;
}
function improveError(err) {
  if ("errno" in err && err["errno"] === "ENOENT" && "path" in err && typeof err["path"] === "string") {
    return new Error(localize(2011, null, err["path"]));
  }
  return err;
}
function quote(args2) {
  let r = "";
  for (const a of args2) {
    if (a.indexOf(" ") >= 0) {
      r += '"' + a + '"';
    } else {
      r += a;
    }
    r += " ";
  }
  return r;
}
var TERMINAL_TITLE, ExternalTerminalService, WindowsExternalTerminalService, MacExternalTerminalService, LinuxExternalTerminalService;
var init_externalTerminalService = __esm({
  "out-build/vs/platform/externalTerminal/node/externalTerminalService.js"() {
    "use strict";
    init_decorators();
    init_network();
    init_path();
    init_platform();
    init_processes();
    init_pfs();
    init_processes2();
    init_nls();
    init_externalTerminal2();
    TERMINAL_TITLE = localize(2006, null);
    ExternalTerminalService = class {
      async getDefaultTerminalForPlatforms() {
        return {
          windows: WindowsExternalTerminalService.getDefaultTerminalWindows(),
          linux: await LinuxExternalTerminalService.getDefaultTerminalLinuxReady(),
          osx: "xterm"
        };
      }
    };
    WindowsExternalTerminalService = class _WindowsExternalTerminalService extends ExternalTerminalService {
      static {
        this.CMD = "cmd.exe";
      }
      openTerminal(configuration, cwd3) {
        return this.spawnTerminal(cp, configuration, getWindowsShell(), cwd3);
      }
      spawnTerminal(spawner, configuration, command, cwd3) {
        const exec4 = configuration.windowsExec || _WindowsExternalTerminalService.getDefaultTerminalWindows();
        if (cwd3 && cwd3[1] === ":") {
          cwd3 = cwd3[0].toUpperCase() + cwd3.substr(1);
        }
        const basename3 = basename(exec4, ".exe").toLowerCase();
        if (basename3 === "cmder") {
          spawner.spawn(exec4, cwd3 ? [cwd3] : void 0);
          return Promise.resolve(void 0);
        }
        const cmdArgs = ["/c", "start", "/wait"];
        if (exec4.indexOf(" ") >= 0) {
          cmdArgs.push(exec4);
        }
        cmdArgs.push(exec4);
        if (basename3 === "wt") {
          cmdArgs.push("-d .");
        }
        return new Promise((c, e) => {
          const env2 = getSanitizedEnvironment(process);
          const child = spawner.spawn(command, cmdArgs, { cwd: cwd3, env: env2, detached: true });
          child.on("error", e);
          child.on("exit", () => c());
        });
      }
      async runInTerminal(title, dir, args2, envVars, settings) {
        const exec4 = "windowsExec" in settings && settings.windowsExec ? settings.windowsExec : _WindowsExternalTerminalService.getDefaultTerminalWindows();
        const wt = await _WindowsExternalTerminalService.getWtExePath();
        return new Promise((resolve3, reject) => {
          const title2 = `"${dir} - ${TERMINAL_TITLE}"`;
          const command = `"${args2.join('" "')}" & pause`;
          const env2 = Object.assign({}, getSanitizedEnvironment(process), envVars);
          Object.keys(env2).filter((v) => env2[v] === null).forEach((key) => delete env2[key]);
          const options = {
            cwd: dir,
            env: env2,
            windowsVerbatimArguments: true
          };
          let spawnExec;
          let cmdArgs;
          if (basename(exec4, ".exe") === "wt") {
            spawnExec = exec4;
            cmdArgs = ["-d", ".", _WindowsExternalTerminalService.CMD, "/c", command];
          } else if (wt) {
            spawnExec = wt;
            cmdArgs = ["-d", ".", exec4, "/c", command];
          } else {
            spawnExec = _WindowsExternalTerminalService.CMD;
            cmdArgs = ["/c", "start", title2, "/wait", exec4, "/c", `"${command}"`];
          }
          const cmd = cp.spawn(spawnExec, cmdArgs, options);
          cmd.on("error", (err) => {
            reject(improveError(err));
          });
          resolve3(void 0);
        });
      }
      static getDefaultTerminalWindows() {
        if (!_WindowsExternalTerminalService._DEFAULT_TERMINAL_WINDOWS) {
          const isWoW64 = !!process.env.hasOwnProperty("PROCESSOR_ARCHITEW6432");
          _WindowsExternalTerminalService._DEFAULT_TERMINAL_WINDOWS = `${process.env.windir ? process.env.windir : "C:\\Windows"}\\${isWoW64 ? "Sysnative" : "System32"}\\cmd.exe`;
        }
        return _WindowsExternalTerminalService._DEFAULT_TERMINAL_WINDOWS;
      }
      static async getWtExePath() {
        try {
          return await findExecutable("wt");
        } catch {
          return void 0;
        }
      }
    };
    __decorate([
      memoize
    ], WindowsExternalTerminalService, "getWtExePath", null);
    MacExternalTerminalService = class _MacExternalTerminalService extends ExternalTerminalService {
      static {
        this.OSASCRIPT = "/usr/bin/osascript";
      }
      // osascript is the AppleScript interpreter on OS X
      openTerminal(configuration, cwd3) {
        return this.spawnTerminal(cp, configuration, cwd3);
      }
      runInTerminal(title, dir, args2, envVars, settings) {
        const terminalApp = settings.osxExec || DEFAULT_TERMINAL_OSX;
        return new Promise((resolve3, reject) => {
          if (terminalApp === DEFAULT_TERMINAL_OSX || terminalApp === "iTerm.app") {
            const script = terminalApp === DEFAULT_TERMINAL_OSX ? "TerminalHelper" : "iTermHelper";
            const scriptpath = FileAccess.asFileUri(`vs/workbench/contrib/externalTerminal/node/${script}.scpt`).fsPath;
            const osaArgs = [
              scriptpath,
              "-t",
              title || TERMINAL_TITLE,
              "-w",
              dir
            ];
            for (const a of args2) {
              osaArgs.push("-a");
              osaArgs.push(a);
            }
            if (envVars) {
              const env2 = Object.assign({}, getSanitizedEnvironment(process), envVars);
              for (const key in env2) {
                const value = env2[key];
                if (value === null) {
                  osaArgs.push("-u");
                  osaArgs.push(key);
                } else {
                  osaArgs.push("-e");
                  osaArgs.push(`${key}=${value}`);
                }
              }
            }
            let stderr = "";
            const osa = cp.spawn(_MacExternalTerminalService.OSASCRIPT, osaArgs);
            osa.on("error", (err) => {
              reject(improveError(err));
            });
            osa.stderr.on("data", (data) => {
              stderr += data.toString();
            });
            osa.on("exit", (code2) => {
              if (code2 === 0) {
                resolve3(void 0);
              } else {
                if (stderr) {
                  const lines = stderr.split("\n", 1);
                  reject(new Error(lines[0]));
                } else {
                  reject(new Error(localize(2007, null, script, code2)));
                }
              }
            });
          } else {
            reject(new Error(localize(2008, null, terminalApp)));
          }
        });
      }
      spawnTerminal(spawner, configuration, cwd3) {
        const terminalApp = configuration.osxExec || DEFAULT_TERMINAL_OSX;
        return new Promise((c, e) => {
          const args2 = ["-a", terminalApp];
          if (cwd3) {
            args2.push(cwd3);
          }
          const env2 = getSanitizedEnvironment(process);
          const child = spawner.spawn("/usr/bin/open", args2, { cwd: cwd3, env: env2 });
          child.on("error", e);
          child.on("exit", () => c());
        });
      }
    };
    LinuxExternalTerminalService = class _LinuxExternalTerminalService extends ExternalTerminalService {
      static {
        this.WAIT_MESSAGE = localize(2009, null);
      }
      openTerminal(configuration, cwd3) {
        return this.spawnTerminal(cp, configuration, cwd3);
      }
      runInTerminal(title, dir, args2, envVars, settings) {
        const execPromise = settings.linuxExec ? Promise.resolve(settings.linuxExec) : _LinuxExternalTerminalService.getDefaultTerminalLinuxReady();
        return new Promise((resolve3, reject) => {
          const termArgs = [];
          execPromise.then((exec4) => {
            if (exec4.indexOf("gnome-terminal") >= 0) {
              termArgs.push("-x");
            } else {
              termArgs.push("-e");
            }
            termArgs.push("bash");
            termArgs.push("-c");
            const bashCommand = `${quote(args2)}; echo; read -p "${_LinuxExternalTerminalService.WAIT_MESSAGE}" -n1;`;
            termArgs.push(`''${bashCommand}''`);
            const env2 = Object.assign({}, getSanitizedEnvironment(process), envVars);
            Object.keys(env2).filter((v) => env2[v] === null).forEach((key) => delete env2[key]);
            const options = {
              cwd: dir,
              env: env2
            };
            let stderr = "";
            const cmd = cp.spawn(exec4, termArgs, options);
            cmd.on("error", (err) => {
              reject(improveError(err));
            });
            cmd.stderr.on("data", (data) => {
              stderr += data.toString();
            });
            cmd.on("exit", (code2) => {
              if (code2 === 0) {
                resolve3(void 0);
              } else {
                if (stderr) {
                  const lines = stderr.split("\n", 1);
                  reject(new Error(lines[0]));
                } else {
                  reject(new Error(localize(2010, null, exec4, code2)));
                }
              }
            });
          });
        });
      }
      static async getDefaultTerminalLinuxReady() {
        if (!_LinuxExternalTerminalService._DEFAULT_TERMINAL_LINUX_READY) {
          if (!isLinux) {
            _LinuxExternalTerminalService._DEFAULT_TERMINAL_LINUX_READY = Promise.resolve("xterm");
          } else {
            const isDebian = await Promises2.exists("/etc/debian_version");
            _LinuxExternalTerminalService._DEFAULT_TERMINAL_LINUX_READY = new Promise((r) => {
              if (isDebian) {
                r("x-terminal-emulator");
              } else if (process.env.DESKTOP_SESSION === "gnome" || process.env.DESKTOP_SESSION === "gnome-classic") {
                r("gnome-terminal");
              } else if (process.env.DESKTOP_SESSION === "kde-plasma") {
                r("konsole");
              } else if (process.env.COLORTERM) {
                r(process.env.COLORTERM);
              } else if (process.env.TERM) {
                r(process.env.TERM);
              } else {
                r("xterm");
              }
            });
          }
        }
        return _LinuxExternalTerminalService._DEFAULT_TERMINAL_LINUX_READY;
      }
      spawnTerminal(spawner, configuration, cwd3) {
        const execPromise = configuration.linuxExec ? Promise.resolve(configuration.linuxExec) : _LinuxExternalTerminalService.getDefaultTerminalLinuxReady();
        return new Promise((c, e) => {
          execPromise.then((exec4) => {
            const env2 = getSanitizedEnvironment(process);
            const child = spawner.spawn(exec4, [], { cwd: cwd3, env: env2 });
            child.on("error", e);
            child.on("exit", () => c());
          });
        });
      }
    };
  }
});

// out-build/vs/base/common/glob.js
function starsToRegExp(starCount, isLastPattern) {
  switch (starCount) {
    case 0:
      return "";
    case 1:
      return `${NO_PATH_REGEX}*?`;
    // 1 star matches any number of characters except path separator (/ and \) - non greedy (?)
    default:
      return `(?:${PATH_REGEX}|${NO_PATH_REGEX}+${PATH_REGEX}${isLastPattern ? `|${PATH_REGEX}${NO_PATH_REGEX}+` : ""})*?`;
  }
}
function splitGlobAware(pattern, splitChar) {
  if (!pattern) {
    return [];
  }
  const segments = [];
  let inBraces = false;
  let inBrackets = false;
  let curVal = "";
  for (const char of pattern) {
    switch (char) {
      case splitChar:
        if (!inBraces && !inBrackets) {
          segments.push(curVal);
          curVal = "";
          continue;
        }
        break;
      case "{":
        inBraces = true;
        break;
      case "}":
        inBraces = false;
        break;
      case "[":
        inBrackets = true;
        break;
      case "]":
        inBrackets = false;
        break;
    }
    curVal += char;
  }
  if (curVal) {
    segments.push(curVal);
  }
  return segments;
}
function parseRegExp(pattern) {
  if (!pattern) {
    return "";
  }
  let regEx = "";
  const segments = splitGlobAware(pattern, GLOB_SPLIT);
  if (segments.every((segment) => segment === GLOBSTAR)) {
    regEx = ".*";
  } else {
    let previousSegmentWasGlobStar = false;
    segments.forEach((segment, index) => {
      if (segment === GLOBSTAR) {
        if (previousSegmentWasGlobStar) {
          return;
        }
        regEx += starsToRegExp(2, index === segments.length - 1);
      } else {
        let inBraces = false;
        let braceVal = "";
        let inBrackets = false;
        let bracketVal = "";
        for (const char of segment) {
          if (char !== "}" && inBraces) {
            braceVal += char;
            continue;
          }
          if (inBrackets && (char !== "]" || !bracketVal)) {
            let res;
            if (char === "-") {
              res = char;
            } else if ((char === "^" || char === "!") && !bracketVal) {
              res = "^";
            } else if (char === GLOB_SPLIT) {
              res = "";
            } else {
              res = escapeRegExpCharacters(char);
            }
            bracketVal += res;
            continue;
          }
          switch (char) {
            case "{":
              inBraces = true;
              continue;
            case "[":
              inBrackets = true;
              continue;
            case "}": {
              const choices = splitGlobAware(braceVal, ",");
              const braceRegExp = `(?:${choices.map((choice) => parseRegExp(choice)).join("|")})`;
              regEx += braceRegExp;
              inBraces = false;
              braceVal = "";
              break;
            }
            case "]": {
              regEx += "[" + bracketVal + "]";
              inBrackets = false;
              bracketVal = "";
              break;
            }
            case "?":
              regEx += NO_PATH_REGEX;
              continue;
            case "*":
              regEx += starsToRegExp(1);
              continue;
            default:
              regEx += escapeRegExpCharacters(char);
          }
        }
        if (index < segments.length - 1 && // more segments to come after this
        (segments[index + 1] !== GLOBSTAR || // next segment is not **, or...
        index + 2 < segments.length)) {
          regEx += PATH_REGEX;
        }
      }
      previousSegmentWasGlobStar = segment === GLOBSTAR;
    });
  }
  return regEx;
}
function parsePattern(arg1, options) {
  if (!arg1) {
    return NULL;
  }
  let pattern;
  if (typeof arg1 !== "string") {
    pattern = arg1.pattern;
  } else {
    pattern = arg1;
  }
  pattern = pattern.trim();
  const patternKey = `${pattern}_${!!options.trimForExclusions}`;
  let parsedPattern = CACHE.get(patternKey);
  if (parsedPattern) {
    return wrapRelativePattern(parsedPattern, arg1);
  }
  let match;
  if (T1.test(pattern)) {
    parsedPattern = trivia1(pattern.substr(4), pattern);
  } else if (match = T2.exec(trimForExclusions(pattern, options))) {
    parsedPattern = trivia2(match[1], pattern);
  } else if ((options.trimForExclusions ? T3_2 : T3).test(pattern)) {
    parsedPattern = trivia3(pattern, options);
  } else if (match = T4.exec(trimForExclusions(pattern, options))) {
    parsedPattern = trivia4and5(match[1].substr(1), pattern, true);
  } else if (match = T5.exec(trimForExclusions(pattern, options))) {
    parsedPattern = trivia4and5(match[1], pattern, false);
  } else {
    parsedPattern = toRegExp(pattern);
  }
  CACHE.set(patternKey, parsedPattern);
  return wrapRelativePattern(parsedPattern, arg1);
}
function wrapRelativePattern(parsedPattern, arg2) {
  if (typeof arg2 === "string") {
    return parsedPattern;
  }
  const wrappedPattern = function(path4, basename3) {
    if (!isEqualOrParent(path4, arg2.base, !isLinux)) {
      return null;
    }
    return parsedPattern(ltrim(path4.substr(arg2.base.length), sep), basename3);
  };
  wrappedPattern.allBasenames = parsedPattern.allBasenames;
  wrappedPattern.allPaths = parsedPattern.allPaths;
  wrappedPattern.basenames = parsedPattern.basenames;
  wrappedPattern.patterns = parsedPattern.patterns;
  return wrappedPattern;
}
function trimForExclusions(pattern, options) {
  return options.trimForExclusions && pattern.endsWith("/**") ? pattern.substr(0, pattern.length - 2) : pattern;
}
function trivia1(base, pattern) {
  return function(path4, basename3) {
    return typeof path4 === "string" && path4.endsWith(base) ? pattern : null;
  };
}
function trivia2(base, pattern) {
  const slashBase = `/${base}`;
  const backslashBase = `\\${base}`;
  const parsedPattern = function(path4, basename3) {
    if (typeof path4 !== "string") {
      return null;
    }
    if (basename3) {
      return basename3 === base ? pattern : null;
    }
    return path4 === base || path4.endsWith(slashBase) || path4.endsWith(backslashBase) ? pattern : null;
  };
  const basenames = [base];
  parsedPattern.basenames = basenames;
  parsedPattern.patterns = [pattern];
  parsedPattern.allBasenames = basenames;
  return parsedPattern;
}
function trivia3(pattern, options) {
  const parsedPatterns = aggregateBasenameMatches(pattern.slice(1, -1).split(",").map((pattern2) => parsePattern(pattern2, options)).filter((pattern2) => pattern2 !== NULL), pattern);
  const patternsLength = parsedPatterns.length;
  if (!patternsLength) {
    return NULL;
  }
  if (patternsLength === 1) {
    return parsedPatterns[0];
  }
  const parsedPattern = function(path4, basename3) {
    for (let i = 0, n = parsedPatterns.length; i < n; i++) {
      if (parsedPatterns[i](path4, basename3)) {
        return pattern;
      }
    }
    return null;
  };
  const withBasenames = parsedPatterns.find((pattern2) => !!pattern2.allBasenames);
  if (withBasenames) {
    parsedPattern.allBasenames = withBasenames.allBasenames;
  }
  const allPaths = parsedPatterns.reduce((all, current) => current.allPaths ? all.concat(current.allPaths) : all, []);
  if (allPaths.length) {
    parsedPattern.allPaths = allPaths;
  }
  return parsedPattern;
}
function trivia4and5(targetPath, pattern, matchPathEnds) {
  const usingPosixSep = sep === posix.sep;
  const nativePath = usingPosixSep ? targetPath : targetPath.replace(ALL_FORWARD_SLASHES, sep);
  const nativePathEnd = sep + nativePath;
  const targetPathEnd = posix.sep + targetPath;
  let parsedPattern;
  if (matchPathEnds) {
    parsedPattern = function(path4, basename3) {
      return typeof path4 === "string" && (path4 === nativePath || path4.endsWith(nativePathEnd) || !usingPosixSep && (path4 === targetPath || path4.endsWith(targetPathEnd))) ? pattern : null;
    };
  } else {
    parsedPattern = function(path4, basename3) {
      return typeof path4 === "string" && (path4 === nativePath || !usingPosixSep && path4 === targetPath) ? pattern : null;
    };
  }
  parsedPattern.allPaths = [(matchPathEnds ? "*/" : "./") + targetPath];
  return parsedPattern;
}
function toRegExp(pattern) {
  try {
    const regExp = new RegExp(`^${parseRegExp(pattern)}$`);
    return function(path4) {
      regExp.lastIndex = 0;
      return typeof path4 === "string" && regExp.test(path4) ? pattern : null;
    };
  } catch (error) {
    return NULL;
  }
}
function parse5(arg1, options = {}) {
  if (!arg1) {
    return FALSE;
  }
  if (typeof arg1 === "string" || isRelativePattern(arg1)) {
    const parsedPattern = parsePattern(arg1, options);
    if (parsedPattern === NULL) {
      return FALSE;
    }
    const resultPattern = function(path4, basename3) {
      return !!parsedPattern(path4, basename3);
    };
    if (parsedPattern.allBasenames) {
      resultPattern.allBasenames = parsedPattern.allBasenames;
    }
    if (parsedPattern.allPaths) {
      resultPattern.allPaths = parsedPattern.allPaths;
    }
    return resultPattern;
  }
  return parsedExpression(arg1, options);
}
function isRelativePattern(obj) {
  const rp = obj;
  if (!rp) {
    return false;
  }
  return typeof rp.base === "string" && typeof rp.pattern === "string";
}
function parsedExpression(expression, options) {
  const parsedPatterns = aggregateBasenameMatches(Object.getOwnPropertyNames(expression).map((pattern) => parseExpressionPattern(pattern, expression[pattern], options)).filter((pattern) => pattern !== NULL));
  const patternsLength = parsedPatterns.length;
  if (!patternsLength) {
    return NULL;
  }
  if (!parsedPatterns.some((parsedPattern) => !!parsedPattern.requiresSiblings)) {
    if (patternsLength === 1) {
      return parsedPatterns[0];
    }
    const resultExpression2 = function(path4, basename3) {
      let resultPromises = void 0;
      for (let i = 0, n = parsedPatterns.length; i < n; i++) {
        const result = parsedPatterns[i](path4, basename3);
        if (typeof result === "string") {
          return result;
        }
        if (isThenable(result)) {
          if (!resultPromises) {
            resultPromises = [];
          }
          resultPromises.push(result);
        }
      }
      if (resultPromises) {
        return (async () => {
          for (const resultPromise of resultPromises) {
            const result = await resultPromise;
            if (typeof result === "string") {
              return result;
            }
          }
          return null;
        })();
      }
      return null;
    };
    const withBasenames2 = parsedPatterns.find((pattern) => !!pattern.allBasenames);
    if (withBasenames2) {
      resultExpression2.allBasenames = withBasenames2.allBasenames;
    }
    const allPaths2 = parsedPatterns.reduce((all, current) => current.allPaths ? all.concat(current.allPaths) : all, []);
    if (allPaths2.length) {
      resultExpression2.allPaths = allPaths2;
    }
    return resultExpression2;
  }
  const resultExpression = function(path4, base, hasSibling) {
    let name = void 0;
    let resultPromises = void 0;
    for (let i = 0, n = parsedPatterns.length; i < n; i++) {
      const parsedPattern = parsedPatterns[i];
      if (parsedPattern.requiresSiblings && hasSibling) {
        if (!base) {
          base = basename(path4);
        }
        if (!name) {
          name = base.substr(0, base.length - extname(path4).length);
        }
      }
      const result = parsedPattern(path4, base, name, hasSibling);
      if (typeof result === "string") {
        return result;
      }
      if (isThenable(result)) {
        if (!resultPromises) {
          resultPromises = [];
        }
        resultPromises.push(result);
      }
    }
    if (resultPromises) {
      return (async () => {
        for (const resultPromise of resultPromises) {
          const result = await resultPromise;
          if (typeof result === "string") {
            return result;
          }
        }
        return null;
      })();
    }
    return null;
  };
  const withBasenames = parsedPatterns.find((pattern) => !!pattern.allBasenames);
  if (withBasenames) {
    resultExpression.allBasenames = withBasenames.allBasenames;
  }
  const allPaths = parsedPatterns.reduce((all, current) => current.allPaths ? all.concat(current.allPaths) : all, []);
  if (allPaths.length) {
    resultExpression.allPaths = allPaths;
  }
  return resultExpression;
}
function parseExpressionPattern(pattern, value, options) {
  if (value === false) {
    return NULL;
  }
  const parsedPattern = parsePattern(pattern, options);
  if (parsedPattern === NULL) {
    return NULL;
  }
  if (typeof value === "boolean") {
    return parsedPattern;
  }
  if (value) {
    const when = value.when;
    if (typeof when === "string") {
      const result = (path4, basename3, name, hasSibling) => {
        if (!hasSibling || !parsedPattern(path4, basename3)) {
          return null;
        }
        const clausePattern = when.replace("$(basename)", () => name);
        const matched = hasSibling(clausePattern);
        return isThenable(matched) ? matched.then((match) => match ? pattern : null) : matched ? pattern : null;
      };
      result.requiresSiblings = true;
      return result;
    }
  }
  return parsedPattern;
}
function aggregateBasenameMatches(parsedPatterns, result) {
  const basenamePatterns = parsedPatterns.filter((parsedPattern) => !!parsedPattern.basenames);
  if (basenamePatterns.length < 2) {
    return parsedPatterns;
  }
  const basenames = basenamePatterns.reduce((all, current) => {
    const basenames2 = current.basenames;
    return basenames2 ? all.concat(basenames2) : all;
  }, []);
  let patterns;
  if (result) {
    patterns = [];
    for (let i = 0, n = basenames.length; i < n; i++) {
      patterns.push(result);
    }
  } else {
    patterns = basenamePatterns.reduce((all, current) => {
      const patterns2 = current.patterns;
      return patterns2 ? all.concat(patterns2) : all;
    }, []);
  }
  const aggregate = function(path4, basename3) {
    if (typeof path4 !== "string") {
      return null;
    }
    if (!basename3) {
      let i;
      for (i = path4.length; i > 0; i--) {
        const ch = path4.charCodeAt(i - 1);
        if (ch === 47 || ch === 92) {
          break;
        }
      }
      basename3 = path4.substr(i);
    }
    const index = basenames.indexOf(basename3);
    return index !== -1 ? patterns[index] : null;
  };
  aggregate.basenames = basenames;
  aggregate.patterns = patterns;
  aggregate.allBasenames = basenames;
  const aggregatedPatterns = parsedPatterns.filter((parsedPattern) => !parsedPattern.basenames);
  aggregatedPatterns.push(aggregate);
  return aggregatedPatterns;
}
function patternsEquals(patternsA, patternsB) {
  return equals(patternsA, patternsB, (a, b) => {
    if (typeof a === "string" && typeof b === "string") {
      return a === b;
    }
    if (typeof a !== "string" && typeof b !== "string") {
      return a.base === b.base && a.pattern === b.pattern;
    }
    return false;
  });
}
var GLOBSTAR, GLOB_SPLIT, PATH_REGEX, NO_PATH_REGEX, ALL_FORWARD_SLASHES, T1, T2, T3, T3_2, T4, T5, CACHE, FALSE, NULL;
var init_glob = __esm({
  "out-build/vs/base/common/glob.js"() {
    "use strict";
    init_arrays();
    init_async();
    init_extpath();
    init_map();
    init_path();
    init_platform();
    init_strings();
    GLOBSTAR = "**";
    GLOB_SPLIT = "/";
    PATH_REGEX = "[/\\\\]";
    NO_PATH_REGEX = "[^/\\\\]";
    ALL_FORWARD_SLASHES = /\//g;
    T1 = /^\*\*\/\*\.[\w\.-]+$/;
    T2 = /^\*\*\/([\w\.-]+)\/?$/;
    T3 = /^{\*\*\/\*?[\w\.-]+\/?(,\*\*\/\*?[\w\.-]+\/?)*}$/;
    T3_2 = /^{\*\*\/\*?[\w\.-]+(\/(\*\*)?)?(,\*\*\/\*?[\w\.-]+(\/(\*\*)?)?)*}$/;
    T4 = /^\*\*((\/[\w\.-]+)+)\/?$/;
    T5 = /^([\w\.-]+(\/[\w\.-]+)*)\/?$/;
    CACHE = new LRUCache(1e4);
    FALSE = function() {
      return false;
    };
    NULL = function() {
      return null;
    };
  }
});

// out-build/vs/platform/files/common/watcher.js
function isWatchRequestWithCorrelation(request) {
  return typeof request.correlationId === "number";
}
function isRecursiveWatchRequest(request) {
  return request.recursive === true;
}
function reviveFileChanges(changes) {
  return changes.map((change) => ({
    type: change.type,
    resource: URI.revive(change.resource),
    cId: change.cId
  }));
}
function coalesceEvents(changes) {
  const coalescer = new EventCoalescer();
  for (const event of changes) {
    coalescer.processE