const e=Object.freeze(JSON.parse(`{"displayName":"Emacs Lisp","fileTypes":["el","elc","eld","spacemacs","_emacs","emacs","emacs.desktop","abbrev_defs","Project.ede","Cask","gnus","viper"],"firstLineMatch":"^#!.*(?:[/\\\\s]|(?<=!)\\\\b)emacs(?:$|\\\\s)|(?:-\\\\*-(?i:[\\\\t ]*(?=[^:;\\\\s]+[\\\\t ]*-\\\\*-)|(?:.*?[\\\\t ;]|(?<=-\\\\*-))[\\\\t ]*mode[\\\\t ]*:[\\\\t ]*)(?i:emacs-lisp)(?=[\\\\t ;]|(?<![-*])-\\\\*-).*?-\\\\*-|(?:(?:^|[\\\\t ])(?:vi|Vi(?=m))(?:m(?:[<=>]?[0-9]+|))?|[\\\\t ]ex)(?=:(?:(?=[\\\\t ]*set?[\\\\t ][^\\\\n\\\\r:]+:)|(?![\\\\t ]*set?[\\\\t ])))(?:(?:[\\\\t ]*:[\\\\t ]*|[\\\\t ])\\\\w*(?:[\\\\t ]*=(?:[^\\\\\\\\\\\\s]|\\\\\\\\.)*)?)*[\\\\t :](?:filetype|ft|syntax)[\\\\t ]*=(?i:e(?:macs-|)lisp)(?=$|[:\\\\s]))","name":"emacs-lisp","patterns":[{"begin":"\\\\A(#!)","beginCaptures":{"1":{"name":"punctuation.definition.comment.hashbang.emacs.lisp"}},"end":"$","name":"comment.line.hashbang.emacs.lisp"},{"include":"#main"}],"repository":{"archive-sources":{"captures":{"1":{"name":"support.language.constant.archive-source.emacs.lisp"}},"match":"\\\\b(?<=[()\\\\[\\\\s]|^)(SC|gnu|marmalade|melpa-stable|melpa|org)(?=[()\\\\s]|$)\\\\b"},"arg-values":{"patterns":[{"match":"&(optional|rest)(?=[)\\\\s])","name":"constant.language.$1.arguments.emacs.lisp"}]},"autoload":{"begin":"^(;;;###)(autoload)","beginCaptures":{"1":{"name":"punctuation.definition.comment.emacs.lisp"},"2":{"name":"storage.modifier.autoload.emacs.lisp"}},"contentName":"string.unquoted.other.emacs.lisp","end":"$","name":"comment.line.semicolon.autoload.emacs.lisp"},"binding":{"match":"\\\\b(?<=[()\\\\[\\\\s]|^)(let\\\\*?|set[fq]?)(?=[()\\\\s]|$)","name":"storage.binding.emacs.lisp"},"boolean":{"patterns":[{"match":"\\\\b(?<=[()\\\\[\\\\s]|^)t(?=[()\\\\s]|$)\\\\b","name":"constant.boolean.true.emacs.lisp"},{"match":"\\\\b(?<=[()\\\\[\\\\s]|^)(nil)(?=[()\\\\s]|$)\\\\b","name":"constant.language.nil.emacs.lisp"}]},"cask":{"match":"\\\\b(?<=[()\\\\[\\\\s]|^)(?:files|source|development|depends-on|package-file|package-descriptor|package)(?=[()\\\\s]|$)\\\\b","name":"support.function.emacs.lisp"},"comment":{"begin":";","beginCaptures":{"0":{"name":"punctuation.definition.comment.emacs.lisp"}},"end":"$","name":"comment.line.semicolon.emacs.lisp","patterns":[{"include":"#modeline"},{"include":"#eldoc"}]},"definition":{"patterns":[{"begin":"(\\\\()(?:(cl-(def(?:un|macro|subst)))|(def(?:un|macro|subst)))(?!-)\\\\b(?:\\\\s*(?![-+\\\\d])([-!$%\\\\&*+/:<-@^{}~\\\\w]+))?","beginCaptures":{"1":{"name":"punctuation.section.expression.begin.emacs.lisp"},"2":{"name":"storage.type.$3.function.cl-lib.emacs.lisp"},"4":{"name":"storage.type.$4.function.emacs.lisp"},"5":{"name":"entity.function.name.emacs.lisp"}},"end":"\\\\)","endCaptures":{"0":{"name":"punctuation.section.expression.end.emacs.lisp"}},"name":"meta.function.definition.emacs.lisp","patterns":[{"include":"#defun-innards"}]},{"match":"\\\\b(?<=[()\\\\[\\\\s]|^)defun(?=[()\\\\s]|$)","name":"storage.type.function.emacs.lisp"},{"begin":"(?<=\\\\s|^)(\\\\()(def(advice|class|const|custom|face|image|group|package|struct|subst|theme|type|var))(?:\\\\s+([-!$%\\\\&*+/:<-@^{}~\\\\w]+))?(?=[()\\\\s]|$)","beginCaptures":{"1":{"name":"punctuation.section.expression.begin.emacs.lisp"},"2":{"name":"storage.type.$3.emacs.lisp"},"4":{"name":"entity.name.$3.emacs.lisp"}},"end":"\\\\)","endCaptures":{"0":{"name":"punctuation.section.expression.end.emacs.lisp"}},"name":"meta.$3.definition.emacs.lisp","patterns":[{"include":"$self"}]},{"match":"\\\\b(?<=[()\\\\[\\\\s]|^)(define-(?:condition|widget))(?=[()\\\\s]|$)\\\\b","name":"storage.type.$1.emacs.lisp"}]},"defun-innards":{"patterns":[{"begin":"\\\\G\\\\s*(\\\\()","beginCaptures":{"0":{"name":"punctuation.section.expression.begin.emacs.lisp"}},"end":"\\\\)","endCaptures":{"0":{"name":"punctuation.section.expression.end.emacs.lisp"}},"name":"meta.argument-list.expression.emacs.lisp","patterns":[{"include":"#arg-keywords"},{"match":"(?![-#\\\\&'+:\\\\d])([-!$%\\\\&*+/:<-@^{}~\\\\w]+)","name":"variable.parameter.emacs.lisp"},{"include":"$self"}]},{"include":"$self"}]},"docesc":{"patterns":[{"match":"\\\\\\\\{2}=","name":"constant.escape.character.key-sequence.emacs.lisp"},{"match":"\\\\\\\\{2}+","name":"constant.escape.character.suppress-link.emacs.lisp"}]},"dockey":{"captures":{"1":{"name":"punctuation.definition.reference.begin.emacs.lisp"},"2":{"name":"constant.other.reference.link.emacs.lisp"},"3":{"name":"punctuation.definition.reference.end.emacs.lisp"}},"match":"(\\\\\\\\{2}\\\\[)((?:[^\\\\\\\\\\\\s]|\\\\\\\\.)+)(])","name":"variable.other.reference.key-sequence.emacs.lisp"},"docmap":{"patterns":[{"captures":{"1":{"name":"punctuation.definition.reference.begin.emacs.lisp"},"2":{"name":"entity.name.tag.keymap.emacs.lisp"},"3":{"name":"punctuation.definition.reference.end.emacs.lisp"}},"match":"(\\\\\\\\{2}\\\\{)((?:[^\\\\\\\\\\\\s]|\\\\\\\\.)+)(})","name":"meta.keymap.summary.emacs.lisp"},{"captures":{"1":{"name":"punctuation.definition.reference.begin.emacs.lisp"},"2":{"name":"entity.name.tag.keymap.emacs.lisp"},"3":{"name":"punctuation.definition.reference.end.emacs.lisp"}},"match":"(\\\\\\\\{2}<)((?:[^\\\\\\\\\\\\s]|\\\\\\\\.)+)(>)","name":"meta.keymap.specifier.emacs.lisp"}]},"docvar":{"captures":{"1":{"name":"punctuation.definition.quote.begin.emacs.lisp"},"2":{"name":"punctuation.definition.quote.end.emacs.lisp"}},"match":"(\`)[^()\\\\s]+(')","name":"variable.other.literal.emacs.lisp"},"eldoc":{"patterns":[{"include":"#docesc"},{"include":"#docvar"},{"include":"#dockey"},{"include":"#docmap"}]},"escapes":{"patterns":[{"captures":{"1":{"name":"punctuation.definition.codepoint.emacs.lisp"},"2":{"name":"punctuation.definition.codepoint.emacs.lisp"}},"match":"(\\\\?)\\\\\\\\u\\\\h{4}|(\\\\?)\\\\\\\\U00\\\\h{6}","name":"constant.character.escape.hex.emacs.lisp"},{"captures":{"1":{"name":"punctuation.definition.codepoint.emacs.lisp"}},"match":"(\\\\?)\\\\\\\\x\\\\h+","name":"constant.character.escape.hex.emacs.lisp"},{"captures":{"1":{"name":"punctuation.definition.codepoint.emacs.lisp"}},"match":"(\\\\?)\\\\\\\\[0-7]{1,3}","name":"constant.character.escape.octal.emacs.lisp"},{"captures":{"1":{"name":"punctuation.definition.codepoint.emacs.lisp"},"2":{"name":"punctuation.definition.backslash.emacs.lisp"}},"match":"(\\\\?)(?:[^\\\\\\\\]|(\\\\\\\\).)","name":"constant.numeric.codepoint.emacs.lisp"},{"captures":{"1":{"name":"punctuation.definition.backslash.emacs.lisp"}},"match":"(\\\\\\\\).","name":"constant.character.escape.emacs.lisp"}]},"expression":{"patterns":[{"begin":"\\\\(","beginCaptures":{"0":{"name":"punctuation.section.expression.begin.emacs.lisp"}},"end":"\\\\)","endCaptures":{"0":{"name":"punctuation.section.expression.end.emacs.lisp"}},"name":"meta.expression.emacs.lisp","patterns":[{"include":"$self"}]},{"begin":"(')(\\\\()","beginCaptures":{"1":{"name":"punctuation.definition.symbol.emacs.lisp"},"2":{"name":"punctuation.section.quoted.expression.begin.emacs.lisp"}},"end":"\\\\)","endCaptures":{"0":{"name":"punctuation.section.quoted.expression.end.emacs.lisp"}},"name":"meta.quoted.expression.emacs.lisp","patterns":[{"include":"$self"}]},{"begin":"(\`)(\\\\()","beginCaptures":{"1":{"name":"punctuation.definition.symbol.emacs.lisp"},"2":{"name":"punctuation.section.backquoted.expression.begin.emacs.lisp"}},"end":"\\\\)","endCaptures":{"0":{"name":"punctuation.section.backquoted.expression.end.emacs.lisp"}},"name":"meta.backquoted.expression.emacs.lisp","patterns":[{"include":"$self"}]},{"begin":"(,@)(\\\\()","beginCaptures":{"1":{"name":"punctuation.definition.symbol.emacs.lisp"},"2":{"name":"punctuation.section.interpolated.expression.begin.emacs.lisp"}},"end":"\\\\)","endCaptures":{"0":{"name":"punctuation.section.interpolated.expression.end.emacs.lisp"}},"name":"meta.interpolated.expression.emacs.lisp","patterns":[{"include":"$self"}]}]},"face-innards":{"patterns":[{"captures":{"1":{"name":"punctuation.section.expression.begin.emacs.lisp"},"2":{"name":"variable.language.display.type.emacs.lisp"},"3":{"name":"support.constant.display.type.emacs.lisp"},"4":{"name":"punctuation.section.expression.end.emacs.lisp"}},"match":"(\\\\()(type)\\\\s+(graphic|x|pc|w32|tty)(\\\\))","name":"meta.expression.display-type.emacs.lisp"},{"captures":{"1":{"name":"punctuation.section.expression.begin.emacs.lisp"},"2":{"name":"variable.language.display.class.emacs.lisp"},"3":{"name":"support.constant.display.class.emacs.lisp"},"4":{"name":"punctuation.section.expression.end.emacs.lisp"}},"match":"(\\\\()(class)\\\\s+(color|grayscale|mono)(\\\\))","name":"meta.expression.display-class.emacs.lisp"},{"captures":{"1":{"name":"punctuation.section.expression.begin.emacs.lisp"},"2":{"name":"variable.language.background-type.emacs.lisp"},"3":{"name":"support.constant.background-type.emacs.lisp"},"4":{"name":"punctuation.section.expression.end.emacs.lisp"}},"match":"(\\\\()(background)\\\\s+(light|dark)(\\\\))","name":"meta.expression.background-type.emacs.lisp"},{"begin":"(\\\\()(min-colors|supports)(?=[()\\\\s]|$)","beginCaptures":{"1":{"name":"punctuation.section.expression.begin.emacs.lisp"},"2":{"name":"variable.language.display-prerequisite.emacs.lisp"}},"end":"\\\\)","endCaptures":{"0":{"name":"punctuation.section.expression.end.emacs.lisp"}},"name":"meta.expression.display-prerequisite.emacs.lisp","patterns":[{"include":"$self"}]}]},"faces":{"match":"\\\\b(?<=[()\\\\[\\\\s]|^)(?:Buffer-menu-buffer|Info-quoted|Info-title-1-face|Info-title-2-face|Info-title-3-face|Info-title-4-face|Man-overstrike|Man-reverse|Man-underline|antlr-default|antlr-font-lock-default-face|antlr-font-lock-keyword-face|antlr-font-lock-literal-face|antlr-font-lock-ruledef-face|antlr-font-lock-ruleref-face|antlr-font-lock-syntax-face|antlr-font-lock-tokendef-face|antlr-font-lock-tokenref-face|antlr-keyword|antlr-literal|antlr-ruledef|antlr-ruleref|antlr-syntax|antlr-tokendef|antlr-tokenref|apropos-keybinding|apropos-property|apropos-symbol|bat-label-face|bg:erc-color-face0|bg:erc-color-face10??|bg:erc-color-face11|bg:erc-color-face12|bg:erc-color-face13|bg:erc-color-face14|bg:erc-color-face15|bg:erc-color-face2|bg:erc-color-face3|bg:erc-color-face4|bg:erc-color-face5|bg:erc-color-face6|bg:erc-color-face7|bg:erc-color-face8|bg:erc-color-face9|bold-italic|bold|bookmark-menu-bookmark|bookmark-menu-heading|border|breakpoint-disabled|breakpoint-enabled|buffer-menu-buffer|button|c-annotation-face|calc-nonselected-face|calc-selected-face|calendar-month-header|calendar-today|calendar-weekday-header|calendar-weekend-header|change-log-acknowledgement-face|change-log-acknowledgement|change-log-acknowledgment|change-log-conditionals-face|change-log-conditionals|change-log-date-face|change-log-date|change-log-email-face|change-log-email|change-log-file-face|change-log-file|change-log-function-face|change-log-function|change-log-list-face|change-log-list|change-log-name-face|change-log-name|comint-highlight-input|comint-highlight-prompt|compare-windows|compilation-column-number|compilation-error|compilation-info|compilation-line-number|compilation-mode-line-exit|compilation-mode-line-fail|compilation-mode-line-run|compilation-warning|completions-annotations|completions-common-part|completions-first-difference|cperl-array-face|cperl-hash-face|cperl-nonoverridable-face|css-property|css-selector|cua-global-mark|cua-rectangle-noselect|cua-rectangle|cursor|custom-button-mouse|custom-button-pressed-unraised|custom-button-pressed|custom-button-unraised|custom-button|custom-changed|custom-comment-tag|custom-comment|custom-documentation|custom-face-tag|custom-group-subtitle|custom-group-tag-1|custom-group-tag|custom-invalid|custom-link|custom-modified|custom-rogue|custom-saved|custom-set|custom-state|custom-themed|custom-variable-button|custom-variable-tag|custom-visibility|cvs-filename-face|cvs-filename|cvs-handled-face|cvs-handled|cvs-header-face|cvs-header|cvs-marked-face|cvs-marked|cvs-msg-face|cvs-msg|cvs-need-action-face|cvs-need-action|cvs-unknown-face|cvs-unknown|default|diary-anniversary|diary-button|diary-time|diary|diff-added-face|diff-added|diff-changed-face|diff-changed|diff-context-face|diff-context|diff-file-header-face|diff-file-header|diff-function-face|diff-function|diff-header-face|diff-header|diff-hunk-header-face|diff-hunk-header|diff-index-face|diff-index|diff-indicator-added|diff-indicator-changed|diff-indicator-removed|diff-nonexistent-face|diff-nonexistent|diff-refine-added|diff-refine-changed??|diff-refine-removed|diff-removed-face|diff-removed|dired-directory|dired-flagged|dired-header|dired-ignored|dired-mark|dired-marked|dired-perm-write|dired-symlink|dired-warning|ebrowse-default|ebrowse-file-name|ebrowse-member-attribute|ebrowse-member-class|ebrowse-progress|ebrowse-root-class|ebrowse-tree-mark|ediff-current-diff-A|ediff-current-diff-Ancestor|ediff-current-diff-B|ediff-current-diff-C|ediff-even-diff-A|ediff-even-diff-Ancestor|ediff-even-diff-B|ediff-even-diff-C|ediff-fine-diff-A|ediff-fine-diff-Ancestor|ediff-fine-diff-B|ediff-fine-diff-C|ediff-odd-diff-A|ediff-odd-diff-Ancestor|ediff-odd-diff-B|ediff-odd-diff-C|eieio-custom-slot-tag-face|eldoc-highlight-function-argument|epa-field-body|epa-field-name|epa-mark|epa-string|epa-validity-disabled|epa-validity-high|epa-validity-low|epa-validity-medium|erc-action-face|erc-bold-face|erc-button|erc-command-indicator-face|erc-current-nick-face|erc-dangerous-host-face|erc-default-face|erc-direct-msg-face|erc-error-face|erc-fool-face|erc-header-line|erc-input-face|erc-inverse-face|erc-keyword-face|erc-my-nick-face|erc-my-nick-prefix-face|erc-nick-default-face|erc-nick-msg-face|erc-nick-prefix-face|erc-notice-face|erc-pal-face|erc-prompt-face|erc-timestamp-face|erc-underline-face|error|ert-test-result-expected|ert-test-result-unexpected|escape-glyph|eww-form-checkbox|eww-form-file|eww-form-select|eww-form-submit|eww-form-text|eww-form-textarea|eww-invalid-certificate|eww-valid-certificate|excerpt|ffap|fg:erc-color-face0|fg:erc-color-face10??|fg:erc-color-face11|fg:erc-color-face12|fg:erc-color-face13|fg:erc-color-face14|fg:erc-color-face15|fg:erc-color-face2|fg:erc-color-face3|fg:erc-color-face4|fg:erc-color-face5|fg:erc-color-face6|fg:erc-color-face7|fg:erc-color-face8|fg:erc-color-face9|file-name-shadow|fixed-pitch|fixed|flymake-errline|flymake-warnline|flyspell-duplicate|flyspell-incorrect|font-lock-builtin-face|font-lock-comment-delimiter-face|font-lock-comment-face|font-lock-constant-face|font-lock-doc-face|font-lock-function-name-face|font-lock-keyword-face|font-lock-negation-char-face|font-lock-preprocessor-face|font-lock-regexp-grouping-backslash|font-lock-regexp-grouping-construct|font-lock-string-face|font-lock-type-face|font-lock-variable-name-face|font-lock-warning-face|fringe|glyphless-char|gnus-button|gnus-cite-10??|gnus-cite-11|gnus-cite-2|gnus-cite-3|gnus-cite-4|gnus-cite-5|gnus-cite-6|gnus-cite-7|gnus-cite-8|gnus-cite-9|gnus-cite-attribution-face|gnus-cite-attribution|gnus-cite-face-10??|gnus-cite-face-11|gnus-cite-face-2|gnus-cite-face-3|gnus-cite-face-4|gnus-cite-face-5|gnus-cite-face-6|gnus-cite-face-7|gnus-cite-face-8|gnus-cite-face-9|gnus-emphasis-bold-italic|gnus-emphasis-bold|gnus-emphasis-highlight-words|gnus-emphasis-italic|gnus-emphasis-strikethru|gnus-emphasis-underline-bold-italic|gnus-emphasis-underline-bold|gnus-emphasis-underline-italic|gnus-emphasis-underline|gnus-group-mail-1-empty-face|gnus-group-mail-1-empty|gnus-group-mail-1-face|gnus-group-mail-1|gnus-group-mail-2-empty-face|gnus-group-mail-2-empty|gnus-group-mail-2-face|gnus-group-mail-2|gnus-group-mail-3-empty-face|gnus-group-mail-3-empty|gnus-group-mail-3-face|gnus-group-mail-3|gnus-group-mail-low-empty-face|gnus-group-mail-low-empty|gnus-group-mail-low-face|gnus-group-mail-low|gnus-group-news-1-empty-face|gnus-group-news-1-empty|gnus-group-news-1-face|gnus-group-news-1|gnus-group-news-2-empty-face|gnus-group-news-2-empty|gnus-group-news-2-face|gnus-group-news-2|gnus-group-news-3-empty-face|gnus-group-news-3-empty|gnus-group-news-3-face|gnus-group-news-3|gnus-group-news-4-empty-face|gnus-group-news-4-empty|gnus-group-news-4-face|gnus-group-news-4|gnus-group-news-5-empty-face|gnus-group-news-5-empty|gnus-group-news-5-face|gnus-group-news-5|gnus-group-news-6-empty-face|gnus-group-news-6-empty|gnus-group-news-6-face|gnus-group-news-6|gnus-group-news-low-empty-face|gnus-group-news-low-empty|gnus-group-news-low-face|gnus-group-news-low|gnus-header-content-face|gnus-header-content|gnus-header-from-face|gnus-header-from|gnus-header-name-face|gnus-header-name|gnus-header-newsgroups-face|gnus-header-newsgroups|gnus-header-subject-face|gnus-header-subject|gnus-signature-face|gnus-signature|gnus-splash-face|gnus-splash|gnus-summary-cancelled-face|gnus-summary-cancelled|gnus-summary-high-ancient-face|gnus-summary-high-ancient|gnus-summary-high-read-face|gnus-summary-high-read|gnus-summary-high-ticked-face|gnus-summary-high-ticked|gnus-summary-high-undownloaded-face|gnus-summary-high-undownloaded|gnus-summary-high-unread-face|gnus-summary-high-unread|gnus-summary-low-ancient-face|gnus-summary-low-ancient|gnus-summary-low-read-face|gnus-summary-low-read|gnus-summary-low-ticked-face|gnus-summary-low-ticked|gnus-summary-low-undownloaded-face|gnus-summary-low-undownloaded|gnus-summary-low-unread-face|gnus-summary-low-unread|gnus-summary-normal-ancient-face|gnus-summary-normal-ancient|gnus-summary-normal-read-face|gnus-summary-normal-read|gnus-summary-normal-ticked-face|gnus-summary-normal-ticked|gnus-summary-normal-undownloaded-face|gnus-summary-normal-undownloaded|gnus-summary-normal-unread-face|gnus-summary-normal-unread|gnus-summary-selected-face|gnus-summary-selected|gomoku-O|gomoku-X|header-line|help-argument-name|hexl-address-region|hexl-ascii-region|hi-black-b|hi-black-hb|hi-blue-b|hi-blue|hi-green-b|hi-green|hi-pink|hi-red-b|hi-yellow|hide-ifdef-shadow|highlight-changes-delete-face|highlight-changes-delete|highlight-changes-face|highlight-changes|highlight|hl-line|holiday|icomplete-first-match|idlwave-help-link|idlwave-shell-bp|idlwave-shell-disabled-bp|idlwave-shell-electric-stop-line|idlwave-shell-pending-electric-stop|idlwave-shell-pending-stop|ido-first-match|ido-incomplete-regexp|ido-indicator|ido-only-match|ido-subdir|ido-virtual|info-header-node|info-header-xref|info-index-match|info-menu-5|info-menu-header|info-menu-star|info-node|info-title-1|info-title-2|info-title-3|info-title-4|info-xref|isearch-fail|isearch-lazy-highlight-face|isearch|iswitchb-current-match|iswitchb-invalid-regexp|iswitchb-single-match|iswitchb-virtual-matches|italic|landmark-font-lock-face-O|landmark-font-lock-face-X|lazy-highlight|ld-script-location-counter|link-visited|link|log-edit-header|log-edit-summary|log-edit-unknown-header|log-view-file-face|log-view-file|log-view-message-face|log-view-message|makefile-makepp-perl|makefile-shell|makefile-space-face|makefile-space|makefile-targets|match|menu|message-cited-text-face|message-cited-text|message-header-cc-face|message-header-cc|message-header-name-face|message-header-name|message-header-newsgroups-face|message-header-newsgroups|message-header-other-face|message-header-other|message-header-subject-face|message-header-subject|message-header-to-face|message-header-to|message-header-xheader-face|message-header-xheader|message-mml-face|message-mml|message-separator-face|message-separator|mh-folder-address|mh-folder-blacklisted|mh-folder-body|mh-folder-cur-msg-number|mh-folder-date|mh-folder-deleted|mh-folder-followup|mh-folder-msg-number|mh-folder-refiled|mh-folder-sent-to-me-hint|mh-folder-sent-to-me-sender|mh-folder-subject|mh-folder-tick|mh-folder-to|mh-folder-whitelisted|mh-letter-header-field|mh-search-folder|mh-show-cc|mh-show-date|mh-show-from|mh-show-header|mh-show-pgg-bad|mh-show-pgg-good|mh-show-pgg-unknown|mh-show-signature|mh-show-subject|mh-show-to|mh-speedbar-folder-with-unseen-messages|mh-speedbar-folder|mh-speedbar-selected-folder-with-unseen-messages|mh-speedbar-selected-folder|minibuffer-prompt|mm-command-output|mm-uu-extract|mode-line-buffer-id|mode-line-emphasis|mode-line-highlight|mode-line-inactive|mode-line|modeline-buffer-id|modeline-highlight|modeline-inactive|mouse|mpuz-solved|mpuz-text|mpuz-trivial|mpuz-unsolved|newsticker-date-face|newsticker-default-face|newsticker-enclosure-face|newsticker-extra-face|newsticker-feed-face|newsticker-immortal-item-face|newsticker-new-item-face|newsticker-obsolete-item-face|newsticker-old-item-face|newsticker-statistics-face|newsticker-treeview-face|newsticker-treeview-immortal-face|newsticker-treeview-new-face|newsticker-treeview-obsolete-face|newsticker-treeview-old-face|newsticker-treeview-selection-face|next-error|nobreak-space|nxml-attribute-colon|nxml-attribute-local-name|nxml-attribute-prefix|nxml-attribute-value-delimiter|nxml-attribute-value|nxml-cdata-section-CDATA|nxml-cdata-section-content|nxml-cdata-section-delimiter|nxml-char-ref-delimiter|nxml-char-ref-number|nxml-comment-content|nxml-comment-delimiter|nxml-delimited-data|nxml-delimiter|nxml-element-colon|nxml-element-local-name|nxml-element-prefix|nxml-entity-ref-delimiter|nxml-entity-ref-name|nxml-glyph|nxml-hash|nxml-heading|nxml-markup-declaration-delimiter|nxml-name|nxml-namespace-attribute-colon|nxml-namespace-attribute-prefix|nxml-namespace-attribute-value-delimiter|nxml-namespace-attribute-value|nxml-namespace-attribute-xmlns|nxml-outline-active-indicator|nxml-outline-ellipsis|nxml-outline-indicator|nxml-processing-instruction-content|nxml-processing-instruction-delimiter|nxml-processing-instruction-target|nxml-prolog-keyword|nxml-prolog-literal-content|nxml-prolog-literal-delimiter|nxml-ref|nxml-tag-delimiter|nxml-tag-slash|nxml-text|octave-function-comment-block|org-agenda-calendar-event|org-agenda-calendar-sexp|org-agenda-clocking|org-agenda-column-dateline|org-agenda-current-time|org-agenda-date-today|org-agenda-date-weekend|org-agenda-date|org-agenda-diary|org-agenda-dimmed-todo-face|org-agenda-done|org-agenda-filter-category|org-agenda-filter-regexp|org-agenda-filter-tags|org-agenda-restriction-lock|org-agenda-structure|org-archived|org-block-background|org-block-begin-line|org-block-end-line|org-block|org-checkbox-statistics-done|org-checkbox-statistics-todo|org-checkbox|org-clock-overlay|org-code|org-column-title|org-column|org-date-selected|org-date|org-default|org-document-info-keyword|org-document-info|org-document-title|org-done|org-drawer|org-ellipsis|org-footnote|org-formula|org-headline-done|org-hide|org-latex-and-related|org-level-1|org-level-2|org-level-3|org-level-4|org-level-5|org-level-6|org-level-7|org-level-8|org-link|org-list-dt|org-macro|org-meta-line|org-mode-line-clock-overrun|org-mode-line-clock|org-priority|org-property-value|org-quote|org-scheduled-previously|org-scheduled-today|org-scheduled|org-sexp-date|org-special-keyword|org-table|org-tag-group|org-tag|org-target|org-time-grid|org-todo|org-upcoming-deadline|org-verbatim|org-verse|org-warning|outline-1|outline-2|outline-3|outline-4|outline-5|outline-6|outline-7|outline-8|proced-mark|proced-marked|proced-sort-header|pulse-highlight-face|pulse-highlight-start-face|query-replace|rcirc-bright-nick|rcirc-dim-nick|rcirc-keyword|rcirc-my-nick|rcirc-nick-in-message-full-line|rcirc-nick-in-message|rcirc-other-nick|rcirc-prompt|rcirc-server-prefix|rcirc-server|rcirc-timestamp|rcirc-track-keyword|rcirc-track-nick|rcirc-url|reb-match-0|reb-match-1|reb-match-2|reb-match-3|rectangle-preview-face|region|rmail-header-name|rmail-highlight|rng-error|rst-adornment|rst-block|rst-comment|rst-definition|rst-directive|rst-emphasis1|rst-emphasis2|rst-external|rst-level-1|rst-level-2|rst-level-3|rst-level-4|rst-level-5|rst-level-6|rst-literal|rst-reference|rst-transition|ruler-mode-column-number|ruler-mode-comment-column|ruler-mode-current-column|ruler-mode-default|ruler-mode-fill-column|ruler-mode-fringes|ruler-mode-goal-column|ruler-mode-margins|ruler-mode-pad|ruler-mode-tab-stop|scroll-bar|secondary-selection|semantic-highlight-edits-face|semantic-highlight-func-current-tag-face|semantic-unmatched-syntax-face|senator-momentary-highlight-face|sgml-namespace|sh-escaped-newline|sh-heredoc-face|sh-heredoc|sh-quoted-exec|shadow|show-paren-match-face|show-paren-match|show-paren-mismatch-face|show-paren-mismatch|shr-link|shr-strike-through|smerge-base-face|smerge-base|smerge-markers-face|smerge-markers|smerge-mine-face|smerge-mine|smerge-other-face|smerge-other|smerge-refined-added|smerge-refined-changed??|smerge-refined-removed|speedbar-button-face|speedbar-directory-face|speedbar-file-face|speedbar-highlight-face|speedbar-selected-face|speedbar-separator-face|speedbar-tag-face|srecode-separator-face|strokes-char|subscript|success|superscript|table-cell|tcl-escaped-newline|term-bold|term-color-black|term-color-blue|term-color-cyan|term-color-green|term-color-magenta|term-color-red|term-color-white|term-color-yellow|term-underline|term|testcover-1value|testcover-nohits|tex-math-face|tex-math|tex-verbatim-face|tex-verbatim|texinfo-heading-face|texinfo-heading|tmm-inactive|todo-archived-only|todo-button|todo-category-string|todo-comment|todo-date|todo-diary-expired|todo-done-sep|todo-done|todo-key-prompt|todo-mark|todo-nondiary|todo-prefix-string|todo-search|todo-sorted-column|todo-time|todo-top-priority|tool-bar|tooltip|trailing-whitespace|tty-menu-disabled-face|tty-menu-enabled-face|tty-menu-selected-face|underline|variable-pitch|vc-conflict-state|vc-edited-state|vc-locally-added-state|vc-locked-state|vc-missing-state|vc-needs-update-state|vc-removed-state|vc-state-base-face|vc-up-to-date-state|vcursor|vera-font-lock-function|vera-font-lock-interface|vera-font-lock-number|verilog-font-lock-ams-face|verilog-font-lock-grouping-keywords-face|verilog-font-lock-p1800-face|verilog-font-lock-translate-off-face|vertical-border|vhdl-font-lock-attribute-face|vhdl-font-lock-directive-face|vhdl-font-lock-enumvalue-face|vhdl-font-lock-function-face|vhdl-font-lock-generic-/constant-face|vhdl-font-lock-prompt-face|vhdl-font-lock-reserved-words-face|vhdl-font-lock-translate-off-face|vhdl-font-lock-type-face|vhdl-font-lock-variable-face|vhdl-speedbar-architecture-face|vhdl-speedbar-architecture-selected-face|vhdl-speedbar-configuration-face|vhdl-speedbar-configuration-selected-face|vhdl-speedbar-entity-face|vhdl-speedbar-entity-selected-face|vhdl-speedbar-instantiation-face|vhdl-speedbar-instantiation-selected-face|vhdl-speedbar-library-face|vhdl-speedbar-package-face|vhdl-speedbar-package-selected-face|vhdl-speedbar-subprogram-face|viper-minibuffer-emacs|viper-minibuffer-insert|viper-minibuffer-vi|viper-replace-overlay|viper-search|warning|which-func|whitespace-big-indent|whitespace-empty|whitespace-hspace|whitespace-indentation|whitespace-line|whitespace-newline|whitespace-space-after-tab|whitespace-space-before-tab|whitespace-space|whitespace-tab|whitespace-trailing|widget-button-face|widget-button-pressed-face|widget-button-pressed|widget-button|widget-documentation-face|widget-documentation|widget-field-face|widget-field|widget-inactive-face|widget-inactive|widget-single-line-field-face|widget-single-line-field|window-divider-first-pixel|window-divider-last-pixel|window-divider|woman-addition-face|woman-addition|woman-bold-face|woman-bold|woman-italic-face|woman-italic|woman-unknown-face|woman-unknown)(?=[()\\\\s]|$)\\\\b","name":"support.constant.face.emacs.lisp"},"format":{"begin":"\\\\G","contentName":"string.quoted.double.emacs.lisp","end":"(?=\\")","patterns":[{"captures":{"1":{"name":"constant.other.placeholder.emacs.lisp"},"2":{"name":"invalid.illegal.placeholder.emacs.lisp"}},"match":"(%[%SXc-gosx])|(%.)"},{"include":"#string-innards"}]},"formatting":{"begin":"(\\\\()(format|format-message|message|error)(?=\\\\s|$|\\")","beginCaptures":{"1":{"name":"punctuation.section.expression.begin.emacs.lisp"},"2":{"name":"support.function.$2.emacs.lisp"}},"end":"\\\\)","endCaptures":{"0":{"name":"punctuation.section.expression.end.emacs.lisp"}},"name":"meta.string-formatting.expression.emacs.lisp","patterns":[{"begin":"\\\\G\\\\s*(\\")","beginCaptures":{"1":{"name":"punctuation.definition.string.begin.emacs.lisp"}},"end":"\\"","endCaptures":{"0":{"name":"punctuation.definition.string.end.emacs.lisp"}},"patterns":[{"include":"#format"}]},{"begin":"\\\\G\\\\s*$\\\\n?","end":"\\"|(?<!^)$|[\\"\\\\s](?=[^\\"\\\\s])","patterns":[{"match":"^\\\\s*$\\\\n?"},{"captures":{"1":{"name":"punctuation.definition.string.begin.emacs.lisp"}},"match":"(?:^|\\\\G)\\\\s*(\\")"},{"begin":"(?<=\\")","end":"\\"","endCaptures":{"0":{"name":"punctuation.definition.string.end.emacs.lisp"}},"patterns":[{"include":"#format"}]}]},{"include":"$self"}]},"functions":{"match":"\\\\b(?<=[()\\\\[\\\\s]|^)(abs|append|apply|assoc|butlast|c[ad]{1,2}r|c[ad]r-safe|consp?|copy-alist|copy-tree|dolist|funcall|last|length|listp?|load|make-list|mapc|mapcar|max|min|member|nbutlast|nconc|nreverse|nth|nthcdr|null|pop|prin[1ct]|push|quote|rassoc|reverse|rplac[ad]|safe-length|setcar|setcdr)(?=[()\\\\s]|$)\\\\b","name":"keyword.control.function.$1.emacs.lisp"},"key-notation":{"patterns":[{"match":"\\\\b(DEL|ESC|LFD|NUL|RET|SPC|TAB)\\\\b","name":"constant.control-character.key.emacs.lisp"},{"captures":{"1":{"name":"punctuation.definition.escape.backslash.emacs.lisp"}},"match":"(\\\\\\\\)[0-7]{1,6}","name":"constant.character.escape.octal.codepoint.key.emacs.lisp"},{"captures":{"1":{"name":"punctuation.definition.escape.caret.emacs.lisp"}},"match":"(\\\\^)\\\\S","name":"constant.character.escape.caret.control.key.emacs.lisp"},{"captures":{"1":{"name":"punctuation.definition.double.angle.bracket.begin.emacs.lisp"},"2":{"name":"punctuation.definition.double.angle.bracket.end.emacs.lisp"}},"match":"(<<)[-0-9A-Za-z]+(>>)","name":"constant.command-name.key.emacs.lisp"},{"captures":{"1":{"name":"constant.numeric.integer.int.decimal.emacs.lisp"},"2":{"name":"keyword.operator.arithmetic.multiply.emacs.lisp"}},"match":"([0-9]+)(\\\\*)(?=\\\\S)","name":"meta.key-repetition.emacs.lisp"},{"captures":{"1":{"patterns":[{"include":"#key-notation-prefix"}]},"2":{"name":"constant.character.key.emacs.lisp"}},"match":"\\\\b(M-)(-?[0-9]+)\\\\b","name":"meta.key-sequence.emacs.lisp"},{"captures":{"1":{"patterns":[{"include":"#key-notation-prefix"}]},"2":{"name":"punctuation.definition.angle.bracket.begin.emacs.lisp"},"3":{"name":"constant.control-character.key.emacs.lisp"},"4":{"name":"punctuation.definition.angle.bracket.end.emacs.lisp"},"5":{"name":"constant.control-character.key.emacs.lisp"},"6":{"name":"invalid.illegal.bad-prefix.emacs.lisp"},"7":{"name":"constant.character.key.emacs.lisp"}},"match":"\\\\b((?:[ACHMSs]-)+)(?:(<)(DEL|ESC|LFD|NUL|RET|SPC|TAB)(>)|(DEL|ESC|LFD|NUL|RET|SPC|TAB)\\\\b|([!-_a-z]{2,})|([!-_a-z]))?","name":"meta.key-sequence.emacs.lisp"},{"captures":{"1":{"patterns":[{"match":"<","name":"punctuation.definition.angle.bracket.begin.emacs.lisp"},{"include":"#key-notation-prefix"}]},"2":{"name":"constant.function-key.emacs.lisp"},"3":{"name":"punctuation.definition.angle.bracket.end.emacs.lisp"}},"match":"([ACHMSs]-<|<[ACHMSs]-|<)([-0-9A-Za-z]+)(>)","name":"meta.function-key.emacs.lisp"},{"match":"(?<=\\\\s)(?![<>ACHMSs])[!-_a-z](?=\\\\s)","name":"constant.character.key.emacs.lisp"}]},"key-notation-prefix":{"captures":{"1":{"name":"constant.character.key.modifier.emacs.lisp"},"2":{"name":"punctuation.separator.modifier.dash.emacs.lisp"}},"match":"([ACHMSs])(-)"},"keyword":{"captures":{"1":{"name":"punctuation.definition.keyword.emacs.lisp"}},"match":"(?<=[()\\\\[\\\\s]|^)(:)[-!$%\\\\&*+/:<-@^{}~\\\\w]+","name":"constant.keyword.emacs.lisp"},"lambda":{"begin":"(\\\\()(lambda|function)(?:\\\\s+|(?=[()]))","beginCaptures":{"1":{"name":"punctuation.section.expression.begin.emacs.lisp"},"2":{"name":"storage.type.lambda.function.emacs.lisp"}},"end":"\\\\)","endCaptures":{"0":{"name":"punctuation.section.expression.end.emacs.lisp"}},"name":"meta.lambda.expression.emacs.lisp","patterns":[{"include":"#defun-innards"}]},"loop":{"begin":"(\\\\()(cl-loop)(?=[()\\\\s]|$)","beginCaptures":{"1":{"name":"punctuation.section.expression.begin.emacs.lisp"},"2":{"name":"support.function.cl-lib.emacs.lisp"}},"end":"\\\\)","endCaptures":{"0":{"name":"punctuation.section.expression.end.emacs.lisp"}},"name":"meta.cl-lib.loop.emacs.lisp","patterns":[{"match":"(?<=[()\\\\[\\\\s]|^)(above|across|across-ref|always|and|append|as|below|by|collect|concat|count|do|each|finally|for|from|if|in|in-ref|initially|into|maximize|minimize|named|nconc|never|of|of-ref|on|repeat|return|sum|then|thereis|sum|to|unless|until|using|vconcat|when|while|with|being\\\\s+(?:the)?\\\\s+(?:element|hash-key|hash-value|key-code|key-binding|key-seq|overlay|interval|symbols|frame|window|buffer)s?)(?=[()\\\\s]|$)","name":"keyword.control.emacs.lisp"},{"include":"$self"}]},"main":{"patterns":[{"include":"#autoload"},{"include":"#comment"},{"include":"#lambda"},{"include":"#loop"},{"include":"#escapes"},{"include":"#definition"},{"include":"#formatting"},{"include":"#face-innards"},{"include":"#expression"},{"include":"#operators"},{"include":"#functions"},{"include":"#binding"},{"include":"#keyword"},{"include":"#string"},{"include":"#number"},{"include":"#quote"},{"include":"#symbols"},{"include":"#vectors"},{"include":"#arg-values"},{"include":"#archive-sources"},{"include":"#boolean"},{"include":"#faces"},{"include":"#cask"},{"include":"#stdlib"}]},"modeline":{"captures":{"1":{"name":"punctuation.definition.modeline.begin.emacs.lisp"},"2":{"patterns":[{"include":"#modeline-innards"}]},"3":{"name":"punctuation.definition.modeline.end.emacs.lisp"}},"match":"(-\\\\*-)(.*)(-\\\\*-)","name":"meta.modeline.emacs.lisp"},"modeline-innards":{"patterns":[{"captures":{"1":{"name":"variable.assignment.modeline.emacs.lisp"},"2":{"name":"punctuation.separator.key-value.emacs.lisp"},"3":{"patterns":[{"include":"#modeline-innards"}]}},"match":"([^:;\\\\s]+)\\\\s*(:)\\\\s*([^;]*)","name":"meta.modeline.variable.emacs.lisp"},{"match":";","name":"punctuation.terminator.statement.emacs.lisp"},{"match":":","name":"punctuation.separator.key-value.emacs.lisp"},{"match":"\\\\S+","name":"string.other.modeline.emacs.lisp"}]},"number":{"patterns":[{"captures":{"1":{"name":"punctuation.definition.binary.emacs.lisp"}},"match":"(?<=[()\\\\[\\\\s]|^)(#)[Bb][01]+","name":"constant.numeric.integer.binary.emacs.lisp"},{"captures":{"1":{"name":"punctuation.definition.hex.emacs.lisp"}},"match":"(?<=[()\\\\[\\\\s]|^)(#)[Xx]\\\\h+","name":"constant.numeric.integer.hex.viml"},{"match":"(?<=[()\\\\[\\\\s]|^)[-+]?\\\\d*\\\\.\\\\d+(?:[Ee][-+]?\\\\d+|[Ee]\\\\+(?:INF|NaN))?(?=[()\\\\s]|$)","name":"constant.numeric.float.emacs.lisp"},{"match":"(?<=[()\\\\[\\\\s]|^)[-+]?\\\\d+(?:[Ee][-+]?\\\\d+|[Ee]\\\\+(?:INF|NaN))?(?=[()\\\\s]|$)","name":"constant.numeric.integer.emacs.lisp"}]},"operators":{"patterns":[{"match":"(?<=[()]|^)(and|catch|cond|condition-case(?:-unless-debug)?|dotimes|eql?|equal|if|not|or|pcase|prog[12n]|throw|unless|unwind-protect|when|while)(?=[()\\\\s]|$)","name":"keyword.control.$1.emacs.lisp"},{"match":"(?<=[(\\\\s]|^)(interactive)(?=[()\\\\s])","name":"storage.modifier.interactive.function.emacs.lisp"},{"match":"(?<=[(\\\\s]|^)[-%*+/](?=[)\\\\s]|$)","name":"keyword.operator.numeric.emacs.lisp"},{"match":"(?<=[(\\\\s]|^)[/<>]=|[<=>](?=[)\\\\s]|$)","name":"keyword.operator.comparison.emacs.lisp"},{"match":"(?<=\\\\s)\\\\.(?=\\\\s|$)","name":"keyword.operator.pair-separator.emacs.lisp"}]},"quote":{"patterns":[{"captures":{"1":{"name":"punctuation.definition.quote.emacs.lisp"},"2":{"patterns":[{"include":"$self"}]}},"match":"(')([-!$%\\\\&*+/:<-@^{}~\\\\w]+)","name":"constant.other.symbol.emacs.lisp"}]},"stdlib":{"patterns":[{"match":"(?<=[()]|^)(\`--pcase-macroexpander|Buffer-menu-unmark-all-buffers|Buffer-menu-unmark-all|Info-node-description|aa2u-mark-as-text|aa2u-mark-rectangle-as-text|aa2u-rectangle|aa2u|ada-find-file|ada-header|ada-mode|add-abbrev|add-change-log-entry-other-window|add-change-log-entry|add-dir-local-variable|add-file-local-variable-prop-line|add-file-local-variable|add-global-abbrev|add-log-current-defun|add-minor-mode|add-mode-abbrev|add-submenu|add-timeout|add-to-coding-system-list|add-to-list--anon-cmacro|add-variable-watcher|adoc-mode|advertised-undo|advice--add-function|advice--buffer-local|advice--called-interactively-skip|advice--car|advice--cd\\\\*r|advice--cdr|advice--defalias-fset|advice--interactive-form|advice--make-1|advice--make-docstring|advice--make-interactive-form|advice--make|advice--member-p|advice--normalize-place|advice--normalize|advice--props|advice--p|advice--remove-function|advice--set-buffer-local|advice--strip-macro|advice--subst-main|advice--symbol-function|advice--tweak|advice--where|after-insert-file-set-coding|aggressive-indent--extend-end-to-whole-sexps|aggressive-indent--indent-current-balanced-line|aggressive-indent--indent-if-changed|aggressive-indent--keep-track-of-changes|aggressive-indent--local-electric|aggressive-indent--proccess-changed-list-and-indent|aggressive-indent--run-user-hooks|aggressive-indent--softly-indent-defun|aggressive-indent--softly-indent-region-and-on|aggressive-indent-bug-report|aggressive-indent-global-mode|aggressive-indent-indent-defun|aggressive-indent-indent-region-and-on|aggressive-indent-mode-set-explicitly|aggressive-indent-mode|align-current|align-entire|align-highlight-rule|align-newline-and-indent|align-regexp|align-unhighlight-rule|align|alist-get|all-threads|allout-auto-activation-helper|allout-mode-p|allout-mode|allout-setup|allout-widgets-mode|allout-widgets-setup|alter-text-property|and-let\\\\*|ange-ftp-completion-hook-function|apache-mode|apropos-local-value|apropos-local-variable|arabic-shape-gstring|assoc-delete-all|auth-source--decode-octal-string|auth-source--symbol-keyword|auth-source-backend--anon-cmacro|auth-source-backend--eieio-childp|auth-source-backends-parser-file|auth-source-backends-parser-macos-keychain|auth-source-backends-parser-secrets|auth-source-json-check|auth-source-json-search|auth-source-pass-enable|auth-source-secrets-saver|auto-save-visited-mode|backtrace-frame--internal|backtrace-frames|backward-to-word|backward-word-strictly|battery-upower-prop|battery-upower|beginning-of-defun--in-emptyish-line-p|beginning-of-defun-comments|bf-help-describe-symbol|bf-help-mode|bf-help-setup|bignump|bison-mode|blink-cursor--rescan-frames|blink-cursor--should-blink|blink-cursor--start-idle-timer|blink-cursor--start-timer|bookmark-set-no-overwrite|brainfuck-mode|browse-url-conkeror|buffer-hash|bufferpos-to-filepos|byte-compile--function-signature|byte-compile--log-warning-for-byte-compile|byte-compile-cond-jump-table-info|byte-compile-cond-jump-table|byte-compile-cond-vars|byte-compile-define-symbol-prop|byte-compile-file-form-defvar-function|byte-compile-file-form-make-obsolete|byte-opt--arith-reduce|byte-opt--portable-numberp|byte-optimize-1-|byte-optimize-1\\\\+|byte-optimize-memq|c-or-c\\\\+\\\\+-mode|call-shell-region|cancel-debug-on-variable-change|cancel-debug-watch|capitalize-dwim|cconv--convert-funcbody|cconv--remap-llv|char-fold-to-regexp|char-from-name|checkdoc-file|checkdoc-package-keywords|cl--assertion-failed|cl--class-docstring--cmacro|cl--class-docstring|cl--class-index-table--cmacro|cl--class-index-table|cl--class-name--cmacro|cl--class-name|cl--class-p--cmacro|cl--class-parents--cmacro|cl--class-parents|cl--class-p|cl--class-slots--cmacro|cl--class-slots|cl--copy-slot-descriptor-1|cl--copy-slot-descriptor|cl--defstruct-predicate|cl--describe-class-slots?|cl--describe-class|cl--do-&aux|cl--find-class|cl--generic-arg-specializer|cl--generic-build-combined-method|cl--generic-cache-miss|cl--generic-class-parents|cl--generic-derived-specializers|cl--generic-describe|cl--generic-dispatches--cmacro|cl--generic-dispatches|cl--generic-fgrep|cl--generic-generalizer-name--cmacro|cl--generic-generalizer-name|cl--generic-generalizer-p--cmacro|cl--generic-generalizer-priority--cmacro|cl--generic-generalizer-priority|cl--generic-generalizer-p|cl--generic-generalizer-specializers-function--cmacro|cl--generic-generalizer-specializers-function|cl--generic-generalizer-tagcode-function--cmacro|cl--generic-generalizer-tagcode-function|cl--generic-get-dispatcher|cl--generic-isnot-nnm-p|cl--generic-lambda|cl--generic-load-hist-format|cl--generic-make--cmacro|cl--generic-make-defmethod-docstring|cl--generic-make-function|cl--generic-make-method--cmacro|cl--generic-make-method|cl--generic-make-next-function|cl--generic-make|cl--generic-member-method|cl--generic-method-documentation|cl--generic-method-files|cl--generic-method-function--cmacro|cl--generic-method-function|cl--generic-method-info|cl--generic-method-qualifiers--cmacro|cl--generic-method-qualifiers|cl--generic-method-specializers--cmacro|cl--generic-method-specializers|cl--generic-method-table--cmacro|cl--generic-method-table|cl--generic-method-uses-cnm--cmacro|cl--generic-method-uses-cnm|cl--generic-name--cmacro|cl--generic-name)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(cl--generic-no-next-method-function|cl--generic-options--cmacro|cl--generic-options|cl--generic-search-method|cl--generic-specializers-apply-to-type-p|cl--generic-split-args|cl--generic-standard-method-combination|cl--generic-struct-specializers|cl--generic-struct-tag|cl--generic-with-memoization|cl--generic|cl--make-random-state--cmacro|cl--make-random-state|cl--make-slot-descriptor--cmacro|cl--make-slot-descriptor|cl--make-slot-desc|cl--old-struct-type-of|cl--pcase-mutually-exclusive-p|cl--plist-remove|cl--print-table|cl--prog|cl--random-state-i--cmacro|cl--random-state-i|cl--random-state-j--cmacro|cl--random-state-j|cl--random-state-vec--cmacro|cl--random-state-vec|cl--slot-descriptor-initform--cmacro|cl--slot-descriptor-initform|cl--slot-descriptor-name--cmacro|cl--slot-descriptor-name|cl--slot-descriptor-props--cmacro|cl--slot-descriptor-props|cl--slot-descriptor-type--cmacro|cl--slot-descriptor-type|cl--struct-all-parents|cl--struct-cl--generic-method-p--cmacro|cl--struct-cl--generic-method-p|cl--struct-cl--generic-p--cmacro|cl--struct-cl--generic-p|cl--struct-class-children-sym--cmacro|cl--struct-class-children-sym|cl--struct-class-docstring--cmacro|cl--struct-class-docstring|cl--struct-class-index-table--cmacro|cl--struct-class-index-table|cl--struct-class-name--cmacro|cl--struct-class-named--cmacro|cl--struct-class-named?|cl--struct-class-p--cmacro|cl--struct-class-parents--cmacro|cl--struct-class-parents|cl--struct-class-print--cmacro|cl--struct-class-print|cl--struct-class-p|cl--struct-class-slots--cmacro|cl--struct-class-slots|cl--struct-class-tag--cmacro|cl--struct-class-tag|cl--struct-class-type--cmacro|cl--struct-class-type|cl--struct-get-class|cl--struct-name-p|cl--struct-new-class--cmacro|cl--struct-new-class|cl--struct-register-child|cl-call-next-method|cl-defgeneric|cl-defmethod|cl-describe-type|cl-find-class|cl-find-method|cl-generic-all-functions|cl-generic-apply|cl-generic-call-method|cl-generic-combine-methods|cl-generic-current-method-specializers|cl-generic-define-context-rewriter|cl-generic-define-generalizer|cl-generic-define-method|cl-generic-define|cl-generic-ensure-function|cl-generic-function-options|cl-generic-generalizers|cl-generic-make-generalizer--cmacro|cl-generic-make-generalizer|cl-generic-p|cl-iter-defun|cl-method-qualifiers|cl-next-method-p|cl-no-applicable-method|cl-no-next-method|cl-no-primary-method|cl-old-struct-compat-mode|cl-prin1-to-string|cl-prin1|cl-print-expand-ellipsis|cl-print-object|cl-print-to-string-with-limit|cl-prog\\\\*?|cl-random-state-p--cmacro|cl-slot-descriptor-p--cmacro|cl-slot-descriptor-p|cl-struct--pcase-macroexpander|cl-struct-define|cl-struct-p--cmacro|cl-struct-p|cl-struct-slot-value--inliner|cl-typep--inliner|clear-composition-cache|cmake-command-run|cmake-help-command|cmake-help-list-commands|cmake-help-module|cmake-help-property|cmake-help-variable|cmake-help|cmake-mode|coffee-mode|combine-change-calls-1|combine-change-calls|comment-line|comment-make-bol-ws|comment-quote-nested-default|comment-region-default-1|completion--category-override|completion-pcm--pattern-point-idx|condition-mutex|condition-name|condition-notify|condition-variable-p|condition-wait|conf-desktop-mode|conf-toml-mode|conf-toml-recognize-section|connection-local-set-profile-variables|connection-local-set-profiles|copy-cl--generic-generalizer|copy-cl--generic-method|copy-cl--generic|copy-from-above-command|copy-lisp-indent-state|copy-xref-elisp-location|copy-yas--exit|copy-yas--field|copy-yas--mirror|copy-yas--snippet|copy-yas--table|copy-yas--template|css-lookup-symbol|csv-mode|cuda-mode|current-thread|cursor-intangible-mode|cursor-sensor-mode|custom--should-apply-setting|debug-on-variable-change|debug-watch|default-font-width|define-symbol-prop|define-thing-chars|defined-colors-with-face-attributes|delete-selection-uses-region-p|describe-char-eldoc|describe-symbol|dir-locals--all-files|dir-locals-read-from-dir|dired--align-all-files|dired--need-align-p|dired-create-empty-file|dired-do-compress-to|dired-do-find-regexp-and-replace|dired-do-find-regexp|dired-mouse-find-file-other-frame|dired-mouse-find-file|dired-omit-mode|display-buffer--maybe-at-bottom|display-buffer--maybe-pop-up-frame|display-buffer--maybe-pop-up-window|display-buffer-in-child-frame|display-buffer-reuse-mode-window|display-buffer-use-some-frame|display-line-numbers-mode|dna-add-hooks|dna-isearch-forward|dna-mode|dna-reverse-complement-region|dockerfile-build-buffer|dockerfile-build-no-cache-buffer|dockerfile-mode|dolist-with-progress-reporter|dotenv-mode|downcase-dwim|dyalog-ediff-forward-word|dyalog-editor-connect|dyalog-fix-altgr-chars|dyalog-mode|dyalog-session-connect|easy-mmode--mode-docstring|eieio--add-new-slot|eieio--c3-candidate|eieio--c3-merge-lists|eieio--class-children--cmacro|eieio--class-class-allocation-values--cmacro|eieio--class-class-slots--cmacro|eieio--class-class-slots|eieio--class-constructor|eieio--class-default-object-cache--cmacro|eieio--class-docstring--cmacro|eieio--class-docstring|eieio--class-index-table--cmacro|eieio--class-index-table|eieio--class-initarg-tuples--cmacro|eieio--class-make--cmacro|eieio--class-make|eieio--class-method-invocation-order|eieio--class-name--cmacro|eieio--class-name|eieio--class-object|eieio--class-option-assoc|eieio--class-options--cmacro|eieio--class-option|eieio--class-p--cmacro)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(eieio--class-parents--cmacro|eieio--class-parents|eieio--class-precedence-bfs|eieio--class-precedence-c3|eieio--class-precedence-dfs|eieio--class-precedence-list|eieio--class-print-name|eieio--class-p|eieio--class-slot-initarg|eieio--class-slot-name-index|eieio--class-slots--cmacro|eieio--class-slots|eieio--class/struct-parents|eieio--generic-subclass-specializers|eieio--initarg-to-attribute|eieio--object-class-tag|eieio--pcase-macroexpander|eieio--perform-slot-validation-for-default|eieio--perform-slot-validation|eieio--slot-name-index|eieio--slot-override|eieio--validate-class-slot-value|eieio--validate-slot-value|eieio-change-class|eieio-class-slots|eieio-default-superclass--eieio-childp|eieio-defclass-internal|eieio-make-child-predicate|eieio-make-class-predicate|eieio-oref--anon-cmacro|eieio-pcase-slot-index-from-index-table|eieio-pcase-slot-index-table|eieio-slot-descriptor-name|eldoc--supported-p|eldoc-docstring-format-sym-doc|eldoc-mode-set-explicitly|electric-pair--balance-info|electric-pair--insert|electric-pair--inside-string-p|electric-pair--skip-whitespace|electric-pair--syntax-ppss|electric-pair--unbalanced-strings-p|electric-pair--with-uncached-syntax|electric-pair-conservative-inhibit|electric-pair-default-inhibit|electric-pair-default-skip-self|electric-pair-delete-pair|electric-pair-inhibit-if-helps-balance|electric-pair-local-mode|electric-pair-post-self-insert-function|electric-pair-skip-if-helps-balance|electric-pair-syntax-info|electric-pair-will-use-region|electric-quote-local-mode|electric-quote-mode|electric-quote-post-self-insert-function|elisp--font-lock-backslash|elisp--font-lock-flush-elisp-buffers|elisp--xref-backend|elisp--xref-make-xref|elisp-flymake--batch-compile-for-flymake|elisp-flymake--byte-compile-done|elisp-flymake-byte-compile|elisp-flymake-checkdoc|elisp-function-argstring|elisp-get-fnsym-args-string|elisp-get-var-docstring|elisp-load-path-roots|emacs-repository-version-git|enh-ruby-mode|epg-config--make-gpg-configuration|epg-config--make-gpgsm-configuration|epg-context-error-buffer--cmacro|epg-context-error-buffer|epg-find-configuration|erlang-compile|erlang-edoc-mode|erlang-find-tag-other-window|erlang-find-tag|erlang-mode|erlang-shell|erldoc-apropos|erldoc-browse-topic|erldoc-browse|erldoc-eldoc-function|etags--xref-backend|eval-expression-get-print-arguments|event-line-count|face-list-p|facemenu-set-charset|faces--attribute-at-point|faceup-clean-buffer|faceup-defexplainer|faceup-render-view-buffer|faceup-view-buffer|faceup-write-file|fic-mode|file-attribute-access-time|file-attribute-collect|file-attribute-device-number|file-attribute-group-id|file-attribute-inode-number|file-attribute-link-number|file-attribute-modes|file-attribute-modification-time|file-attribute-size|file-attribute-status-change-time|file-attribute-type|file-attribute-user-id|file-local-name|file-name-case-insensitive-p|file-name-quoted-p|file-name-quote|file-name-unquote|file-system-info|filepos-to-bufferpos--dos|filepos-to-bufferpos|files--ask-user-about-large-file|files--ensure-directory|files--force|files--make-magic-temp-file|files--message|files--name-absolute-system-p|files--splice-dirname-file|fill-polish-nobreak-p|find-function-on-key-other-frame|find-function-on-key-other-window|find-library-other-frame|find-library-other-window|fixnump|flymake-cc|flymake-diag-region|flymake-diagnostics|flymake-make-diagnostic|follow-scroll-down-window|follow-scroll-up-window|font-lock--remove-face-from-text-property|form-feed-mode|format-message|forth-block-mode|forth-eval-defun|forth-eval-last-expression-display-output|forth-eval-last-expression|forth-eval-region|forth-eval|forth-interaction-send|forth-kill|forth-load-file|forth-mode|forth-restart|forth-see|forth-switch-to-output-buffer|forth-switch-to-source-buffer|forth-words|fortune-message|forward-to-word|forward-word-strictly|frame--size-history|frame-after-make-frame|frame-ancestor-p|frame-creation-function|frame-edges|frame-focus-state|frame-geometry|frame-inner-height|frame-inner-width|frame-internal-border-width|frame-list-z-order|frame-monitor-attribute|frame-monitor-geometry|frame-monitor-workarea|frame-native-height|frame-native-width|frame-outer-height|frame-outer-width|frame-parent|frame-position|frame-restack|frame-size-changed-p|func-arity|generic--normalize-comments|generic-bracket-support|generic-mode-set-comments|generic-set-comment-syntax|generic-set-comment-vars|get-variable-watchers|gfm-mode|gfm-view-mode|ghc-core-create-core|ghc-core-mode|ghci-script-mode|git-commit--save-and-exit|git-commit-ack|git-commit-cc|git-commit-committer-email|git-commit-committer-name|git-commit-commit|git-commit-find-pseudo-header-position|git-commit-first-env-var|git-commit-font-lock-diff|git-commit-git-config-var|git-commit-insert-header-as-self|git-commit-insert-header|git-commit-mode|git-commit-reported|git-commit-review|git-commit-signoff|git-commit-test|git-define-git-commit-self|git-define-git-commit|gitattributes-mode--highlight-1st-field|gitattributes-mode-backward-field|gitattributes-mode-eldoc|gitattributes-mode-forward-field|gitattributes-mode-help|gitattributes-mode-menu|gitattributes-mode|gitconfig-indent-line|gitconfig-indentation-string|gitconfig-line-indented-p|gitconfig-mode|gitconfig-point-in-indentation-p|gitignore-mode|global-aggressive-indent-mode-check-buffers|global-aggressive-indent-mode-cmhh|global-aggressive-indent-mode-enable-in-buffers|global-aggressive-indent-mode|global-display-line-numbers-mode|global-eldoc-mode-check-buffers|global-eldoc-mode-cmhh|global-eldoc-mode-enable-in-buffers|glsl-mode|gnutls-asynchronous-parameters|gnutls-ciphers|gnutls-digests|gnutls-hash-digest|gnutls-hash-mac|gnutls-macs|gnutls-symmetric-decrypt|gnutls-symmetric-encrypt|go-download-play|go-mode|godoc|gofmt-before-save|gui-backend-get-selection|gui-backend-selection-exists-p|gui-backend-selection-owner-p|gui-backend-set-selection|gv-delay-error|gv-setter|gv-synthetic-place|hack-connection-local-variables-apply|handle-args-function|handle-move-frame|hash-table-empty-p|haskell-align-imports|haskell-c2hs-mode|haskell-cabal-get-dir|haskell-cabal-get-field|haskell-cabal-mode|haskell-cabal-visit-file|haskell-collapse-mode|haskell-compile|haskell-completions-completion-at-point|haskell-decl-scan-mode|haskell-describe|haskell-doc-current-info|haskell-doc-mode|haskell-doc-show-type|haskell-ds-create-imenu-index|haskell-forward-sexp|haskell-hayoo|haskell-hoogle-lookup-from-local|haskell-hoogle|haskell-indent-mode|haskell-indentation-mode|haskell-interactive-bring|haskell-interactive-kill|haskell-interactive-mode-echo|haskell-interactive-mode-reset-error|haskell-interactive-mode-return|haskell-interactive-mode-visit-error|haskell-interactive-switch|haskell-kill-session-process|haskell-menu|haskell-mode-after-save-handler|haskell-mode-find-uses|haskell-mode-generate-tags|haskell-mode-goto-loc|haskell-mode-jump-to-def-or-tag|haskell-mode-jump-to-def|haskell-mode-jump-to-tag|haskell-mode-show-type-at)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(haskell-mode-stylish-buffer|haskell-mode-tag-find|haskell-mode-view-news|haskell-mode|haskell-move-nested-left|haskell-move-nested-right|haskell-move-nested|haskell-navigate-imports-go|haskell-navigate-imports-return|haskell-navigate-imports|haskell-process-cabal-build|haskell-process-cabal-macros|haskell-process-cabal|haskell-process-cd|haskell-process-clear|haskell-process-do-info|haskell-process-do-type|haskell-process-interrupt|haskell-process-load-file|haskell-process-load-or-reload|haskell-process-minimal-imports|haskell-process-reload-devel-main|haskell-process-reload-file|haskell-process-reload|haskell-process-restart|haskell-process-show-repl-response|haskell-process-unignore|haskell-rgrep|haskell-session-all-modules|haskell-session-change-target|haskell-session-change|haskell-session-installed-modules|haskell-session-kill|haskell-session-maybe|haskell-session-process|haskell-session-project-modules|haskell-session|haskell-sort-imports|haskell-tab-indent-mode|haskell-version|hayoo|help--analyze-key|help--binding-undefined-p|help--docstring-quote|help--filter-info-list|help--load-prefixes|help--loaded-p|help--make-usage-docstring|help--make-usage|help--read-key-sequence|help--symbol-completion-table|help-definition-prefixes|help-fns--analyze-function|help-fns-function-description-header|help-fns-short-filename|highlight-uses-mode|hoogle|hyperspec-lookup|ibuffer-jump|ido-dired-other-frame|ido-dired-other-window|ido-display-buffer-other-frame|ido-find-alternate-file-other-window|if-let\\\\*|image-dired-minor-mode|image-mode-to-text|indent--default-inside-comment|indent--funcall-widened|indent-region-line-by-line|indent-relative-first-indent-point|inferior-erlang|inferior-lfe-mode|inferior-lfe|ini-mode|insert-directory-clean|insert-directory-wildcard-in-dir-p|interactive-haskell-mode|internal--compiler-macro-cXXr|internal--syntax-propertize|internal-auto-fill|internal-default-interrupt-process|internal-echo-keystrokes-prefix|internal-handle-focus-in|isearch--describe-regexp-mode|isearch--describe-word-mode|isearch--lax-regexp-function-p|isearch--momentary-message|isearch--yank-char-or-syntax|isearch-define-mode-toggle|isearch-lazy-highlight-start|isearch-string-propertize|isearch-toggle-char-fold|isearch-update-from-string-properties|isearch-xterm-paste|isearch-yank-symbol-or-char|jison-mode|jit-lock--run-functions|js-jsx-mode|js2-highlight-unused-variables-mode|js2-imenu-extras-mode|js2-imenu-extras-setup|js2-jsx-mode|js2-minor-mode|js2-mode|json--check-position|json--decode-utf-16-surrogates|json--plist-reverse|json--plist-to-alist|json--record-path|json-advance--inliner|json-path-to-position|json-peek--inliner|json-pop--inliner|json-pretty-print-buffer-ordered|json-pretty-print-ordered|json-readtable-dispatch|json-skip-whitespace--inliner|kill-current-buffer|kmacro-keyboard-macro-p|kmacro-p|kqueue-add-watch|kqueue-rm-watch|kqueue-valid-p|langdoc-call-fun|langdoc-define-help-mode|langdoc-if-let|langdoc-insert-link|langdoc-matched-strings|langdoc-while-let|lcms-cam02-ucs|lcms-cie-de2000|lcms-jab->jch|lcms-jch->jab|lcms-jch->xyz|lcms-temp->white-point|lcms-xyz->jch|lcms2-available-p|less-css-mode|let-when-compile|lfe-indent-function|lfe-mode|lgstring-remove-glyph|libxml-available-p|line-number-display-width|lisp--el-match-keyword|lisp--el-non-funcall-position-p|lisp-adaptive-fill|lisp-indent-calc-next|lisp-indent-initial-state|lisp-indent-region|lisp-indent-state-p--cmacro|lisp-indent-state-ppss--cmacro|lisp-indent-state-ppss-point--cmacro|lisp-indent-state-ppss-point|lisp-indent-state-ppss|lisp-indent-state-p|lisp-indent-state-stack--cmacro|lisp-indent-state-stack|lisp-ppss|list-timers|literate-haskell-mode|load-user-init-file|loadhist-unload-element|logcount|lread--substitute-object-in-subtree|macroexp-macroexpand|macroexp-parse-body|macrostep-c-mode-hook|macrostep-expand|macrostep-mode|major-mode-restore|major-mode-suspend|make-condition-variable|make-empty-file|make-finalizer|make-mutex|make-nearby-temp-file|make-pipe-process|make-process|make-record|make-temp-file-internal|make-thread|make-xref-elisp-location--cmacro|make-xref-elisp-location|make-yas--exit--cmacro|make-yas--exit|make-yas--field--cmacro|make-yas--field|make-yas--mirror--cmacro|make-yas--mirror|make-yas--snippet--cmacro|make-yas--snippet|make-yas--table--cmacro|make-yas--table|map--apply-alist|map--apply-array|map--apply-hash-table|map--do-alist|map--do-array|map--into-hash-table|map--make-pcase-bindings|map--make-pcase-patterns|map--pcase-macroexpander|map--put|map-apply|map-contains-key|map-copy|map-delete|map-do|map-elt|map-empty-p|map-every-p|map-filter|map-into|map-keys-apply|map-keys|map-length|map-let|map-merge-with|map-merge|map-nested-elt|map-pairs|map-put|map-remove|map-some|map-values-apply|map-values|mapbacktrace|mapp|mark-beginning-of-buffer|mark-end-of-buffer|markdown-live-preview-mode|markdown-mode|markdown-view-mode|mc-hide-unmatched-lines-mode|mc/add-cursor-on-click|mc/edit-beginnings-of-lines|mc/edit-ends-of-lines|mc/edit-lines|mc/insert-letters|mc/insert-numbers|mc/mark-all-dwim|mc/mark-all-in-region-regexp|mc/mark-all-in-region|mc/mark-all-like-this-dwim|mc/mark-all-like-this-in-defun|mc/mark-all-like-this|mc/mark-all-symbols-like-this-in-defun|mc/mark-all-symbols-like-this|mc/mark-all-words-like-this-in-defun|mc/mark-all-words-like-this|mc/mark-more-like-this-extended|mc/mark-next-like-this-word|mc/mark-next-like-this|mc/mark-next-lines|mc/mark-next-symbol-like-this|mc/mark-next-word-like-this|mc/mark-pop|mc/mark-previous-like-this-word|mc/mark-previous-like-this|mc/mark-previous-lines|mc/mark-previous-symbol-like-this|mc/mark-previous-word-like-this|mc/mark-sgml-tag-pair|mc/reverse-regions|mc/skip-to-next-like-this|mc/skip-to-previous-like-this|mc/sort-regions|mc/toggle-cursor-on-click|mc/unmark-next-like-this|mc/unmark-previous-like-this|mc/vertical-align-with-space|mc/vertical-align|menu-bar-bottom-and-right-window-divider|menu-bar-bottom-window-divider|menu-bar-display-line-numbers-mode|menu-bar-goto-uses-etags-p|menu-bar-no-window-divider|menu-bar-right-window-divider|menu-bar-window-divider-customize|mhtml-mode|midnight-mode|minibuffer-maybe-quote-filename|minibuffer-prompt-properties--setter|mm-images-in-region-p|mocha--get-callsite-name|mocha-attach-indium|mocha-check-debugger|mocha-compilation-filter|mocha-debug-at-point|mocha-debug-file|mocha-debug-project|mocha-debugger-get|mocha-debugger-name-p|mocha-debug|mocha-find-current-test|mocha-find-project-root|mocha-generate-command|mocha-list-of-strings-p|mocha-make-imenu-alist|mocha-opts-file|mocha-realgud:nodejs-attach|mocha-run|mocha-test-at-point|mocha-test-file|mocha-test-project|mocha-toggle-imenu-function|mocha-walk-up-to-it|mode-line-default-help-echo|module-function-p|module-load|mouse--click-1-maybe-follows-link|mouse-absolute-pixel-position|mouse-drag-and-drop-region|mouse-drag-bottom-edge|mouse-drag-bottom-left-corner|mouse-drag-bottom-right-corner|mouse-drag-frame|mouse-drag-left-edge|mouse-drag-right-edge|mouse-drag-top-edge|mouse-drag-top-left-corner|mouse-drag-top-right-corner|mouse-resize-frame|move-text--at-first-line-p)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(move-text--at-last-line-p|move-text--at-penultimate-line-p|move-text--last-line-is-just-newline|move-text--total-lines|move-text-default-bindings|move-text-down|move-text-line-down|move-text-line-up|move-text-region-down|move-text-region-up|move-text-region|move-text-up|move-to-window-group-line|mule--ucs-names-annotation|multiple-cursors-mode|mutex-lock|mutex-name|mutex-unlock|mutexp|nasm-mode|newlisp-mode|newlisp-show-repl|next-error-buffer-on-selected-frame|next-error-found|next-error-select-buffer|ninja-mode|obarray-get|obarray-make|obarray-map|obarray-put|obarray-remove|obarray-size|obarrayp|occur-regexp-descr|org-columns-insert-dblock|org-duration-from-minutes|org-duration-h:mm-only-p|org-duration-p|org-duration-set-regexps|org-duration-to-minutes|org-lint|package--activate-autoloads-and-load-path|package--add-to-compatibility-table|package--append-to-alist|package--autoloads-file-name|package--build-compatibility-table|package--check-signature-content|package--download-and-read-archives|package--find-non-dependencies|package--get-deps|package--incompatible-p|package--load-files-for-activation|package--newest-p|package--prettify-quick-help-key|package--print-help-section|package--quickstart-maybe-refresh|package--read-pkg-desc|package--removable-packages|package--remove-hidden|package--save-selected-packages|package--sort-by-dependence|package--sort-deps-in-alist|package--update-downloads-in-progress|package--update-selected-packages|package--used-elsewhere-p|package--user-installed-p|package--user-selected-p|package--with-response-buffer|package-activate-all|package-archive-priority|package-autoremove|package-delete-button-action|package-desc-priority-version|package-desc-priority|package-dir-info|package-install-selected-packages|package-menu--find-and-notify-upgrades|package-menu--list-to-prompt|package-menu--mark-or-notify-upgrades|package-menu--mark-upgrades-1|package-menu--partition-transaction|package-menu--perform-transaction|package-menu--populate-new-package-list|package-menu--post-refresh|package-menu--print-info-simple|package-menu--prompt-transaction-p|package-menu-hide-package|package-menu-mode-menu|package-menu-toggle-hiding|package-quickstart-refresh|package-reinstall|pcase--edebug-match-macro|pcase--make-docstring|pcase-lambda|pcomplete/find|perl-flymake|picolisp-mode|picolisp-repl-mode|picolisp-repl|pixel-scroll-mode|pos-visible-in-window-group-p|pov-mode|powershell-mode|powershell|prefix-command-preserve-state|prefix-command-update|prettify-symbols--post-command-hook|prettify-symbols-default-compose-p|print--preprocess|process-thread|prog-first-column|project-current|project-find-file|project-find-regexp|project-or-external-find-file|project-or-external-find-regexp|proper-list-p|provided-mode-derived-p|pulse-momentary-highlight-one-line|pulse-momentary-highlight-region|quelpa|query-replace--split-string|radix-tree--insert|radix-tree--lookup|radix-tree--prefixes|radix-tree--remove|radix-tree--subtree|radix-tree-count|radix-tree-from-map|radix-tree-insert|radix-tree-iter-mappings|radix-tree-iter-subtrees|radix-tree-leaf--pcase-macroexpander|radix-tree-lookup|radix-tree-prefixes|radix-tree-subtree|read-answer|read-multiple-choice|readable-foreground-color|recenter-window-group|recentf-mode|recode-file-name|recode-region|record-window-buffer|recordp?|recover-file|recover-session-finish|recover-session|recover-this-file|rectangle-mark-mode|rectangle-number-lines|rectangular-region-mode|redirect-debugging-output|redisplay--pre-redisplay-functions|redisplay--update-region-highlight|redraw-modeline|refill-mode|reftex-all-document-files|reftex-citation|reftex-index-phrases-mode|reftex-isearch-minor-mode|reftex-mode|reftex-reset-scanning-information|regexp-builder|regexp-opt-group|region-active-p|region-bounds|region-modifiable-p|region-noncontiguous-p|register-ccl-program|register-code-conversion-map|register-definition-prefixes|register-describe-oneline|register-input-method|register-preview-default|register-preview|register-swap-out|register-to-point|register-val-describe|register-val-insert|register-val-jump-to|registerv--make--cmacro|registerv--make|registerv-data--cmacro|registerv-data|registerv-insert-func--cmacro|registerv-insert-func|registerv-jump-func--cmacro|registerv-jump-func|registerv-make|registerv-p--cmacro|registerv-print-func--cmacro|registerv-print-func|registerv-p|remember-clipboard|remember-diary-extract-entries|remember-notes|remember-other-frame|remember|remove-variable-watcher|remove-yank-excluded-properties|rename-uniquely|repeat-complex-command|repeat-matching-complex-command|repeat|replace--push-stack|replace-buffer-contents|replace-dehighlight|replace-eval-replacement|replace-highlight|replace-loop-through-replacements|replace-match-data|replace-match-maybe-edit|replace-match-string-symbols|replace-quote|replace-rectangle|replace-regexp|replace-search|replace-string|report-emacs-bug|report-errors|reporter-submit-bug-report|reposition-window|repunctuate-sentences|reset-language-environment|reset-this-command-lengths|resize-mini-window-internal|resize-temp-buffer-window|reveal-mode|reverse-region|revert-buffer--default|revert-buffer-insert-file-contents--default-function|revert-buffer-with-coding-system|rfc2104-hash|rfc822-goto-eoh|rfn-eshadow-setup-minibuffer|rfn-eshadow-sifn-equal|rfn-eshadow-update-overlay|rgrep|right-char|right-word|rlogin|rmail-input|rmail-mode|rmail-movemail-variant-p|rmail-output-as-seen|run-erlang|run-forth|run-haskell|run-lfe|run-newlisp|run-sml|rust-mode|rx--pcase-macroexpander|save-mark-and-excursion--restore|save-mark-and-excursion--save|save-mark-and-excursion|save-place-local-mode|save-place-mode|scad-mode|search-forward-help-for-help|secondary-selection-exist-p|secondary-selection-from-region|secondary-selection-to-region|secure-hash-algorithms|sed-mode|selected-window-group|seq--activate-font-lock-keywords|seq--elt-safe|seq--into-list|seq--into-string|seq--into-vector|seq--make-pcase-bindings|seq--make-pcase-patterns|seq--pcase-macroexpander|seq-contains|seq-difference|seq-do-indexed|seq-find|seq-group-by|seq-intersection|seq-into-sequence|seq-into|seq-let|seq-map-indexed|seq-mapcat|seq-mapn|seq-max|seq-min|seq-partition|seq-position|seq-random-elt|seq-set-equal-p|seq-some|seq-sort-by|seqp|set--this-command-keys|set-binary-mode|set-buffer-redisplay|set-mouse-absolute-pixel-position|set-process-thread|set-rectangular-region-anchor|set-window-group-start|shell-command--save-pos-or-erase|shell-command--set-point-after-cmd|shift-number-down|shift-number-up|slime-connect|slime-lisp-mode-hook|slime-mode|slime-scheme-mode-hook|slime-selector|slime-setup|slime|smerge-refine-regions|sml-cm-mode|sml-lex-mode|sml-mode|sml-run|sml-yacc-mode|snippet-mode|spice-mode|split-window-no-error|sql-mariadb|ssh-authorized-keys-mode|ssh-config-mode|ssh-known-hosts-mode|startup--setup-quote-display|string-distance|string-greaterp|string-version-lessp|string>|subr--with-wrapper-hook-no-warnings|switch-to-haskell|sxhash-eql|sxhash-equal|sxhash-eq|syntax-ppss--data)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(tabulated-list--col-local-max-widths|tabulated-list--get-sorter|tabulated-list-header-overlay-p|tabulated-list-line-number-width|tabulated-list-watch-line-number-width|tabulated-list-window-scroll-function|terminal-init-xterm|thing-at-point--beginning-of-sexp|thing-at-point--end-of-sexp|thing-at-point--read-from-whole-string|thread--blocker|thread-alive-p|thread-handle-event|thread-join|thread-last-error|thread-live-p|thread-name|thread-signal|thread-yield|threadp|tildify-mode|tildify-space|toml-mode|tramp-archive-autoload-file-name-regexp|tramp-register-archive-file-name-handler|tty-color-24bit|turn-on-haskell-decl-scan|turn-on-haskell-doc-mode|turn-on-haskell-doc|turn-on-haskell-indentation|turn-on-haskell-indent|turn-on-haskell-unicode-input-method|typescript-mode|uncomment-region-default-1|undo--wrap-and-run-primitive-undo|undo-amalgamate-change-group|undo-auto--add-boundary|undo-auto--boundaries|undo-auto--boundary-ensure-timer|undo-auto--boundary-timer|undo-auto--ensure-boundary|undo-auto--last-boundary-amalgamating-number|undo-auto--needs-boundary-p|undo-auto--undoable-change|undo-auto-amalgamate|universal-argument--description|universal-argument--preserve|upcase-char|upcase-dwim|url-asynchronous--cmacro|url-asynchronous|url-directory-files|url-domain|url-file-attributes|url-file-directory-p|url-file-executable-p|url-file-exists-p|url-file-handler-identity|url-file-name-all-completions|url-file-name-completion|url-file-symlink-p|url-file-truename|url-file-writable-p|url-handler-directory-file-name|url-handler-expand-file-name|url-handler-file-name-directory|url-handler-file-remote-p|url-handler-unhandled-file-name-directory|url-handlers-create-wrapper|url-handlers-set-buffer-mode|url-insert-buffer-contents|url-insert|url-run-real-handler|user-ptrp|userlock--ask-user-about-supersession-threat|vc-message-unresolved-conflicts|vc-print-branch-log|vc-push|vc-refresh-state|version-control-safe-local-p|vimrc-mode|wavefront-obj-mode|when-let\\\\*|window--adjust-process-windows|window--even-window-sizes|window--make-major-side-window-next-to|window--make-major-side-window|window--process-window-list|window--sides-check-failed|window--sides-check|window--sides-reverse-all|window--sides-reverse-frame|window--sides-reverse-on-frame-p|window--sides-reverse-side|window--sides-reverse|window--sides-verticalize-frame|window--sides-verticalize|window-absolute-body-pixel-edges|window-absolute-pixel-position|window-adjust-process-window-size-largest|window-adjust-process-window-size-smallest|window-adjust-process-window-size|window-body-edges|window-body-pixel-edges|window-divider-mode-apply|window-divider-mode|window-divider-width-valid-p|window-font-height|window-font-width|window-group-end|window-group-start|window-largest-empty-rectangle--disjoint-maximums|window-largest-empty-rectangle--maximums-1|window-largest-empty-rectangle--maximums|window-largest-empty-rectangle|window-lines-pixel-dimensions|window-main-window|window-max-chars-per-line|window-pixel-height-before-size-change|window-pixel-width-before-size-change|window-swap-states|window-system-initialization|window-toggle-side-windows|with-connection-local-profiles|with-mutex|x-load-color-file|xml-remove-comments|xref-backend-apropos|xref-backend-definitions|xref-backend-identifier-completion-table|xref-collect-matches|xref-elisp-location-file--cmacro|xref-elisp-location-file|xref-elisp-location-p--cmacro|xref-elisp-location-symbol--cmacro|xref-elisp-location-symbol|xref-elisp-location-type--cmacro|xref-elisp-location-type|xref-find-backend|xref-find-definitions-at-mouse|xref-make-elisp-location--cmacro|xref-marker-stack-empty-p|xterm--init-activate-get-selection|xterm--init-activate-set-selection|xterm--init-bracketed-paste-mode|xterm--init-focus-tracking|xterm--init-frame-title|xterm--init-modify-other-keys|xterm--pasted-text|xterm--push-map|xterm--query|xterm--read-event-for-query|xterm--report-background-handler|xterm--selection-char|xterm--suspend-tty-function|xterm--version-handler|xterm-maybe-set-dark-background-mode|xterm-paste|xterm-register-default-colors|xterm-rgb-convert-to-16bit|xterm-set-window-title-flag|xterm-set-window-title|xterm-translate-bracketed-paste|xterm-translate-focus-in|xterm-translate-focus-out|xterm-unset-window-title-flag|xwidget-webkit-browse-url|yaml-mode|yas--add-template|yas--advance-end-maybe|yas--advance-end-of-parents-maybe|yas--advance-start-maybe|yas--all-templates|yas--apply-transform|yas--auto-fill-wrapper|yas--auto-fill|yas--auto-next|yas--calculate-adjacencies|yas--calculate-group|yas--calculate-mirror-depth|yas--calculate-simple-fom-parentage|yas--check-commit-snippet|yas--collect-snippet-markers|yas--commit-snippet|yas--compute-major-mode-and-parents|yas--create-snippet-xrefs|yas--define-menu-1|yas--define-parents|yas--define-snippets-1|yas--define-snippets-2|yas--define|yas--delete-from-keymap|yas--delete-regions|yas--describe-pretty-table|yas--escape-string|yas--eval-condition|yas--eval-for-effect|yas--eval-for-string|yas--exit-marker--cmacro|yas--exit-marker|yas--exit-next--cmacro|yas--exit-next|yas--exit-p--cmacro|yas--exit-p|yas--expand-from-keymap-doc|yas--expand-from-trigger-key-doc|yas--expand-or-prompt-for-template|yas--expand-or-visit-from-menu|yas--fallback-translate-input|yas--fallback|yas--fetch|yas--field-contains-point-p|yas--field-end--cmacro|yas--field-end|yas--field-mirrors--cmacro|yas--field-mirrors|yas--field-modified-p--cmacro|yas--field-modified-p|yas--field-next--cmacro|yas--field-next|yas--field-number--cmacro|yas--field-number|yas--field-p--cmacro|yas--field-parent-field--cmacro|yas--field-parent-field|yas--field-parse-create|yas--field-probably-deleted-p|yas--field-p|yas--field-start--cmacro|yas--field-start|yas--field-text-for-display|yas--field-transform--cmacro|yas--field-transform|yas--field-update-display|yas--filter-templates-by-condition|yas--find-next-field|yas--finish-moving-snippets|yas--fom-end|yas--fom-next|yas--fom-parent-field|yas--fom-start|yas--format|yas--get-field-once|yas--get-snippet-tables|yas--get-template-by-uuid|yas--global-mode-reload-with-jit-maybe|yas--goto-saved-location|yas--guess-snippet-directories-1|yas--guess-snippet-directories|yas--indent-parse-create|yas--indent-region|yas--indent|yas--key-from-desc|yas--keybinding-beyond-yasnippet|yas--letenv|yas--load-directory-1|yas--load-directory-2|yas--load-pending-jits|yas--load-snippet-dirs|yas--load-yas-setup-file|yas--lookup-snippet-1|yas--make-control-overlay|yas--make-directory-maybe|yas--make-exit--cmacro|yas--make-exit|yas--make-field--cmacro|yas--make-field|yas--make-marker|yas--make-menu-binding|yas--make-mirror--cmacro|yas--make-mirror|yas--make-move-active-field-overlay|yas--make-move-field-protection-overlays|yas--make-snippet--cmacro|yas--make-snippet-table--cmacro|yas--make-snippet-table|yas--make-snippet|yas--make-template--cmacro|yas--make-template)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(yas--mark-this-and-children-modified|yas--markers-to-points|yas--maybe-clear-field-filter|yas--maybe-expand-from-keymap-filter|yas--maybe-expand-key-filter|yas--maybe-move-to-active-field|yas--menu-keymap-get-create|yas--message|yas--minor-mode-menu|yas--mirror-depth--cmacro|yas--mirror-depth|yas--mirror-end--cmacro|yas--mirror-end|yas--mirror-next--cmacro|yas--mirror-next|yas--mirror-p--cmacro|yas--mirror-parent-field--cmacro|yas--mirror-parent-field|yas--mirror-p|yas--mirror-start--cmacro|yas--mirror-start|yas--mirror-transform--cmacro|yas--mirror-transform|yas--mirror-update-display|yas--modes-to-activate|yas--move-to-field|yas--namehash-templates-alist|yas--on-buffer-kill|yas--on-field-overlay-modification|yas--on-protection-overlay-modification|yas--parse-template|yas--place-overlays|yas--points-to-markers|yas--post-command-handler|yas--prepare-snippets-for-move|yas--prompt-for-keys|yas--prompt-for-table|yas--prompt-for-template|yas--protect-escapes|yas--read-keybinding|yas--read-lisp|yas--read-table|yas--remove-misc-free-from-undo|yas--remove-template-by-uuid|yas--replace-all|yas--require-template-specific-condition-p|yas--restore-backquotes|yas--restore-escapes|yas--restore-marker-location|yas--restore-overlay-line-location|yas--restore-overlay-location|yas--safely-call-fun|yas--safely-run-hook|yas--save-backquotes|yas--save-restriction-and-widen|yas--scan-sexps|yas--schedule-jit|yas--show-menu-p|yas--simple-fom-create|yas--skip-and-clear-field-p|yas--skip-and-clear|yas--snapshot-marker-location|yas--snapshot-overlay-line-location|yas--snapshot-overlay-location|yas--snippet-active-field--cmacro|yas--snippet-active-field|yas--snippet-control-overlay--cmacro|yas--snippet-control-overlay|yas--snippet-create|yas--snippet-description-finish-runonce|yas--snippet-exit--cmacro|yas--snippet-exit|yas--snippet-expand-env--cmacro|yas--snippet-expand-env|yas--snippet-field-compare|yas--snippet-fields--cmacro|yas--snippet-fields|yas--snippet-find-field|yas--snippet-force-exit--cmacro|yas--snippet-force-exit|yas--snippet-id--cmacro|yas--snippet-id|yas--snippet-live-p|yas--snippet-map-markers|yas--snippet-next-id|yas--snippet-p--cmacro|yas--snippet-parse-create|yas--snippet-previous-active-field--cmacro|yas--snippet-previous-active-field|yas--snippet-p|yas--snippet-revive|yas--snippet-sort-fields|yas--snippets-at-point|yas--subdirs|yas--table-all-keys|yas--table-direct-keymap--cmacro|yas--table-direct-keymap|yas--table-get-create|yas--table-hash--cmacro|yas--table-hash|yas--table-mode|yas--table-name--cmacro|yas--table-name|yas--table-p--cmacro|yas--table-parents--cmacro|yas--table-parents|yas--table-p|yas--table-templates|yas--table-uuidhash--cmacro|yas--table-uuidhash|yas--take-care-of-redo|yas--template-can-expand-p|yas--template-condition--cmacro|yas--template-condition|yas--template-content--cmacro|yas--template-content|yas--template-expand-env--cmacro|yas--template-expand-env|yas--template-fine-group|yas--template-get-file|yas--template-group--cmacro|yas--template-group|yas--template-key--cmacro|yas--template-keybinding--cmacro|yas--template-keybinding|yas--template-key|yas--template-load-file--cmacro|yas--template-load-file|yas--template-menu-binding-pair--cmacro|yas--template-menu-binding-pair-get-create|yas--template-menu-binding-pair|yas--template-menu-managed-by-yas-define-menu|yas--template-name--cmacro|yas--template-name|yas--template-p--cmacro|yas--template-perm-group--cmacro|yas--template-perm-group|yas--template-pretty-list|yas--template-p|yas--template-save-file--cmacro|yas--template-save-file|yas--template-table--cmacro|yas--template-table|yas--template-uuid--cmacro|yas--template-uuid|yas--templates-for-key-at-point|yas--transform-mirror-parse-create|yas--undo-in-progress|yas--update-mirrors|yas--update-template-menu|yas--update-template|yas--visit-snippet-file-1|yas--warning|yas--watch-auto-fill|yas-abort-snippet|yas-about|yas-activate-extra-mode|yas-active-keys|yas-active-snippets|yas-auto-next|yas-choose-value|yas-compile-directory|yas-completing-prompt|yas-current-field|yas-deactivate-extra-mode|yas-default-from-field|yas-define-condition-cache|yas-define-menu|yas-define-snippets|yas-describe-table-by-namehash|yas-describe-tables|yas-direct-keymaps-reload|yas-dropdown-prompt|yas-escape-text|yas-exit-all-snippets|yas-exit-snippet|yas-expand-from-keymap|yas-expand-from-trigger-key|yas-expand-snippet|yas-expand|yas-field-value|yas-global-mode-check-buffers|yas-global-mode-cmhh|yas-global-mode-enable-in-buffers|yas-global-mode|yas-hippie-try-expand|yas-ido-prompt|yas-initialize|yas-insert-snippet|yas-inside-string|yas-key-to-value|yas-load-directory|yas-load-snippet-buffer-and-close|yas-load-snippet-buffer|yas-longest-key-from-whitespace|yas-lookup-snippet|yas-maybe-ido-prompt|yas-maybe-load-snippet-buffer|yas-minor-mode-on|yas-minor-mode-set-explicitly|yas-minor-mode|yas-new-snippet|yas-next-field-or-maybe-expand|yas-next-field-will-exit-p|yas-next-field|yas-no-prompt|yas-prev-field|yas-recompile-all|yas-reload-all|yas-selected-text|yas-shortest-key-until-whitespace|yas-skip-and-clear-field|yas-skip-and-clear-or-delete-char|yas-snippet-dirs|yas-snippet-mode-buffer-p|yas-substr|yas-text|yas-throw|yas-try-key-from-whitespace|yas-tryout-snippet|yas-unimplemented|yas-verify-value|yas-visit-snippet-file|yas-x-prompt|yas/abort-snippet|yas/about|yas/choose-value|yas/compile-directory|yas/completing-prompt|yas/default-from-field|yas/define-condition-cache|yas/define-menu|yas/define-snippets|yas/describe-tables|yas/direct-keymaps-reload|yas/dropdown-prompt|yas/exit-all-snippets|yas/exit-snippet|yas/expand-from-keymap|yas/expand-from-trigger-key|yas/expand-snippet|yas/expand|yas/field-value|yas/global-mode|yas/hippie-try-expand|yas/ido-prompt|yas/initialize|yas/insert-snippet|yas/inside-string|yas/key-to-value|yas/load-directory|yas/load-snippet-buffer|yas/minor-mode-on|yas/minor-mode|yas/new-snippet|yas/next-field-or-maybe-expand|yas/next-field|yas/no-prompt|yas/prev-field|yas/recompile-all|yas/reload-all|yas/selected-text|yas/skip-and-clear-or-delete-char|yas/snippet-dirs|yas/substr|yas/text|yas/throw|yas/tryout-snippet|yas/unimplemented|yas/verify-value|yas/visit-snippet-file|yas/x-prompt|yasnippet-unload-function|zap-up-to-char)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(abbrev-all-caps|abbrev-expand-function|abbrev-expansion|abbrev-file-name|abbrev-get|abbrev-insert|abbrev-map|abbrev-minor-mode-table-alist|abbrev-prefix-mark|abbrev-put|abbrev-start-location|abbrev-start-location-buffer|abbrev-symbol|abbrev-table-get|abbrev-table-name-list|abbrev-table-p|abbrev-table-put|abbreviate-file-name|abbrevs-changed|abort-recursive-edit|accept-change-group|accept-process-output|access-file|accessible-keymaps|acos|activate-change-group|activate-mark-hook|active-minibuffer-window|adaptive-fill-first-line-regexp|adaptive-fill-function|adaptive-fill-mode|adaptive-fill-regexp|add-face-text-property|add-function|add-hook|add-name-to-file|add-text-properties|add-to-history|add-to-invisibility-spec|add-to-list|add-to-ordered-list|adjust-window-trailing-edge|advice-add|advice-eval-interactive-spec|advice-function-mapc|advice-function-member-p|advice-mapc|advice-member-p|advice-remove|after-change-functions|after-change-major-mode-hook|after-find-file|after-init-hook|after-init-time|after-insert-file-functions|after-load-functions|after-make-frame-functions|after-revert-hook|after-save-hook|after-setting-font-hook|all-completions|append-to-file|apply-partially|apropos|aref|argv|arrayp|ascii-case-table|aset|ash|asin|ask-user-about-lock|ask-user-about-supersession-threat|assoc-default|assoc-string|assq|assq-delete-all|atan|atom|auto-coding-alist|auto-coding-functions|auto-coding-regexp-alist|auto-fill-chars|auto-fill-function|auto-hscroll-mode|auto-mode-alist|auto-raise-tool-bar-buttons|auto-resize-tool-bars|auto-save-default|auto-save-file-name-p|auto-save-hook|auto-save-interval|auto-save-list-file-name|auto-save-list-file-prefix|auto-save-mode|auto-save-timeout|auto-save-visited-file-name|auto-window-vscroll|autoload|autoload-do-load|autoloadp|back-to-indentation|backtrace|backtrace-debug|backtrace-frame|backup-buffer|backup-by-copying|backup-by-copying-when-linked|backup-by-copying-when-mismatch|backup-by-copying-when-privileged-mismatch|backup-directory-alist|backup-enable-predicate|backup-file-name-p|backup-inhibited|backward-button|backward-char|backward-delete-char-untabify|backward-delete-char-untabify-method|backward-list|backward-prefix-chars|backward-sexp|backward-to-indentation|backward-word|balance-windows|balance-windows-area|barf-if-buffer-read-only|base64-decode-region|base64-decode-string|base64-encode-region|base64-encode-string|batch-byte-compile|baud-rate|beep|before-change-functions|before-hack-local-variables-hook|before-init-hook|before-init-time|before-make-frame-hook|before-revert-hook|before-save-hook|beginning-of-buffer|beginning-of-defun|beginning-of-defun-function|beginning-of-line|bidi-display-reordering|bidi-paragraph-direction|bidi-string-mark-left-to-right|bindat-get-field|bindat-ip-to-string|bindat-length|bindat-pack|bindat-unpack|bitmap-spec-p|blink-cursor-alist|blink-matching-delay|blink-matching-open|blink-matching-paren|blink-matching-paren-distance|blink-paren-function|bobp|bolp|bool-vector-count-consecutive|bool-vector-count-population|bool-vector-exclusive-or|bool-vector-intersection|bool-vector-not|bool-vector-p|bool-vector-set-difference|bool-vector-subsetp|bool-vector-union|booleanp|boundp|buffer-access-fontified-property|buffer-access-fontify-functions|buffer-auto-save-file-format|buffer-auto-save-file-name|buffer-backed-up|buffer-base-buffer|buffer-chars-modified-tick|buffer-disable-undo|buffer-display-count|buffer-display-table|buffer-display-time|buffer-enable-undo|buffer-end|buffer-file-coding-system|buffer-file-format|buffer-file-name|buffer-file-number|buffer-file-truename|buffer-invisibility-spec|buffer-list|buffer-list-update-hook|buffer-live-p|buffer-local-value|buffer-local-variables|buffer-modified-p|buffer-modified-tick|buffer-name|buffer-name-history|buffer-narrowed-p|buffer-offer-save|buffer-quit-function|buffer-read-only|buffer-save-without-query|buffer-saved-size|buffer-size|buffer-stale-function|buffer-string|buffer-substring|buffer-substring-filters|buffer-substring-no-properties|buffer-swap-text|buffer-undo-list|bufferp|bury-buffer|button-activate|button-at|button-end|button-get|button-has-type-p|button-label|button-put|button-start|button-type|button-type-get|button-type-put|button-type-subtype-p|byte-boolean-vars|byte-code-function-p|byte-compile|byte-compile-dynamic|byte-compile-dynamic-docstrings|byte-compile-file|byte-recompile-directory|byte-to-position|byte-to-string|call-interactively|call-process|call-process-region|call-process-shell-command|called-interactively-p|cancel-change-group|cancel-debug-on-entry|cancel-timer|capitalize|capitalize-region|capitalize-word|case-fold-search|case-replace|case-table-p|category-docstring|category-set-mnemonics|category-table|category-table-p|ceiling|change-major-mode-after-body-hook|change-major-mode-hook|char-after|char-before|char-category-set|char-charset|char-code-property-description|char-displayable-p|char-equal|char-or-string-p|char-property-alias-alist|char-script-table|char-syntax|char-table-extra-slot|char-table-p|char-table-parent|char-table-range|char-table-subtype|char-to-string|char-width|char-width-table|characterp|charset-after|charset-list|charset-plist|charset-priority-list|charsetp|check-coding-system|check-coding-systems-region|checkdoc-minor-mode|cl|clear-abbrev-table|clear-image-cache|clear-string|clear-this-command-keys|clear-visited-file-modtime|clone-indirect-buffer|clrhash|coding-system-aliases|coding-system-change-eol-conversion|coding-system-change-text-conversion|coding-system-charset-list|coding-system-eol-type|coding-system-for-read|coding-system-for-write|coding-system-get|coding-system-list|coding-system-p|coding-system-priority-list|collapse-delayed-warnings|color-defined-p|color-gray-p|color-supported-p|color-values|combine-after-change-calls|combine-and-quote-strings|command-debug-status|command-error-function|command-execute|command-history|command-line|command-line-args|command-line-args-left|command-line-functions|command-line-processed|command-remapping|command-switch-alist|commandp|compare-buffer-substrings|compare-strings|compare-window-configurations|compile-defun|completing-read|completing-read-function|completion-at-point|completion-at-point-functions|completion-auto-help|completion-boundaries|completion-category-overrides|completion-extra-properties|completion-ignore-case|completion-ignored-extensions|completion-in-region|completion-regexp-list|completion-styles|completion-styles-alist|completion-table-case-fold|completion-table-dynamic|completion-table-in-turn|completion-table-merge|completion-table-subvert|completion-table-with-cache|completion-table-with-predicate|completion-table-with-quoting|completion-table-with-terminator|compute-motion|concat|cons-cells-consed|constrain-to-field|continue-process|controlling-tty-p|convert-standard-filename|coordinates-in-window-p|copy-abbrev-table|copy-category-table|copy-directory|copy-file|copy-hash-table|copy-keymap|copy-marker|copy-overlay|copy-region-as-kill|copy-sequence|copy-syntax-table|copysign|cos|count-lines|count-loop|count-screen-lines|count-words|create-file-buffer|create-fontset-from-fontset-spec|create-image|create-lockfiles|current-active-maps|current-bidi-paragraph-direction|current-buffer|current-case-table|current-column|current-fill-column|current-frame-configuration|current-global-map|current-idle-time|current-indentation|current-input-method|current-input-mode|current-justification|current-kill|current-left-margin|current-local-map|current-message|current-minor-mode-maps|current-prefix-arg|current-time|current-time-string|current-time-zone|current-window-configuration|current-word|cursor-in-echo-area|cursor-in-non-selected-windows|cursor-type|cust-print|custom-add-frequent-value|custom-initialize-delay|custom-known-themes|custom-reevaluate-setting|custom-set-faces|custom-set-variables|custom-theme-p|custom-theme-set-faces|custom-theme-set-variables|custom-unlispify-remove-prefixes|custom-variable-p|customize-package-emacs-version-alist|cygwin-convert-file-name-from-windows|cygwin-convert-file-name-to-windows|data-directory|date-leap-year-p|date-to-time|deactivate-mark|deactivate-mark-hook|debug|debug-ignored-errors|debug-on-entry|debug-on-error|debug-on-event|debug-on-message|debug-on-next-call|debug-on-quit|debug-on-signal|debugger|debugger-bury-or-kill|declare|declare-function|decode-char|decode-coding-inserted-region|decode-coding-region|decode-coding-string|decode-time|def-edebug-spec|defalias|default-boundp|default-directory|default-file-modes|default-frame-alist|default-input-method|default-justification|default-minibuffer-frame|default-process-coding-system|default-text-properties|default-value|define-abbrev|define-abbrev-table|define-alternatives|define-button-type|define-category|define-derived-mode|define-error|define-fringe-bitmap|define-generic-mode|define-globalized-minor-mode|define-hash-table-test|define-key|define-key-after|define-minor-mode|define-obsolete-face-alias|define-obsolete-function-alias|define-obsolete-variable-alias|define-package|define-prefix-command|defined-colors|defining-kbd-macro|defun-prompt-regexp|defvar-local|defvaralias|delay-mode-hooks|delayed-warnings-hook|delayed-warnings-list|delete|delete-and-extract-region|delete-auto-save-file-if-necessary|delete-auto-save-files|delete-backward-char|delete-blank-lines|delete-by-moving-to-trash|delete-char|delete-directory|delete-dups|delete-exited-processes|delete-field|delete-file|delete-frame|delete-frame-functions|delete-horizontal-space|delete-indentation|delete-minibuffer-contents|delete-old-versions|delete-other-windows|delete-overlay|delete-process|delete-region|delete-terminal|delete-terminal-functions|delete-to-left-margin|delete-trailing-whitespace|delete-window|delete-windows-on|delq|derived-mode-p|describe-bindings|describe-buffer-case-table|describe-categories|describe-current-display-table|describe-display-table|describe-mode|describe-prefix-bindings|describe-syntax|desktop-buffer-mode-handlers|desktop-save-buffer|destroy-fringe-bitmap|detect-coding-region|detect-coding-string|digit-argument|ding|dir-locals-class-alist|dir-locals-directory-cache|dir-locals-file|dir-locals-set-class-variables|dir-locals-set-directory-class|directory-file-name|directory-files|directory-files-and-attributes|dired-kept-versions|disable-command|disable-point-adjustment|disable-theme|disabled|disabled-command-function|disassemble|discard-input|display-backing-store|display-buffer|display-buffer-alist|display-buffer-at-bottom|display-buffer-base-action|display-buffer-below-selected|display-buffer-fallback-action|display-buffer-in-previous-window|display-buffer-no-window|display-buffer-overriding-action|display-buffer-pop-up-frame|display-buffer-pop-up-window|display-buffer-reuse-window|display-buffer-same-window|display-buffer-use-some-window|display-color-cells|display-color-p|display-completion-list|display-delayed-warnings|display-graphic-p|display-grayscale-p|display-images-p|display-message-or-buffer|display-mm-dimensions-alist|display-mm-height|display-mm-width|display-monitor-attributes-list|display-mouse-p|display-pixel-height|display-pixel-width|display-planes|display-popup-menus-p|display-save-under|display-screens|display-selections-p|display-supports-face-attributes-p|display-table-slot|display-visual-class|display-warning|dnd-protocol-alist|do-auto-save|doc-directory|documentation|documentation-property|dotimes-with-progress-reporter|double-click-fuzz|double-click-time|down-list|downcase|downcase-region|downcase-word|dump-emacs|dynamic-library-alist)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(easy-menu-define|easy-mmode-define-minor-mode|echo-area-clear-hook|echo-keystrokes|edebug|edebug-all-defs|edebug-all-forms|edebug-continue-kbd-macro|edebug-defun|edebug-display-freq-count|edebug-eval-macro-args|edebug-eval-top-level-form|edebug-global-break-condition|edebug-initial-mode|edebug-on-error|edebug-on-quit|edebug-print-circle|edebug-print-length|edebug-print-level|edebug-print-trace-after|edebug-print-trace-before|edebug-save-displayed-buffer-points|edebug-save-windows|edebug-set-global-break-condition|edebug-setup-hook|edebug-sit-for-seconds|edebug-temp-display-freq-count|edebug-test-coverage|edebug-trace|edebug-tracing|edebug-unwrap-results|edit-and-eval-command|electric-future-map|elt|emacs-build-time|emacs-init-time|emacs-lisp-docstring-fill-column|emacs-major-version|emacs-minor-version|emacs-pid|emacs-save-session-functions|emacs-session-restore|emacs-startup-hook|emacs-uptime|emacs-version|emulation-mode-map-alists|enable-command|enable-dir-local-variables|enable-local-eval|enable-local-variables|enable-multibyte-characters|enable-recursive-minibuffers|enable-theme|encode-char|encode-coding-region|encode-coding-string|encode-time|end-of-buffer|end-of-defun|end-of-defun-function|end-of-file|end-of-line|eobp|eolp|equal-including-properties|erase-buffer|error|error-conditions|error-message-string|esc-map|ESC-prefix|eval|eval-and-compile|eval-buffer|eval-current-buffer|eval-expression-debug-on-error|eval-expression-print-length|eval-expression-print-level|eval-minibuffer|eval-region|eval-when-compile|event-basic-type|event-click-count|event-convert-list|event-end|event-modifiers|event-start|eventp|ewoc-buffer|ewoc-collect|ewoc-create|ewoc-data|ewoc-delete|ewoc-enter-after|ewoc-enter-before|ewoc-enter-first|ewoc-enter-last|ewoc-filter|ewoc-get-hf|ewoc-goto-next|ewoc-goto-node|ewoc-goto-prev|ewoc-invalidate|ewoc-locate|ewoc-location|ewoc-map|ewoc-next|ewoc-nth|ewoc-prev|ewoc-refresh|ewoc-set-data|ewoc-set-hf|exec-directory|exec-path|exec-suffixes|executable-find|execute-extended-command|execute-kbd-macro|executing-kbd-macro|exit|exit-minibuffer|exit-recursive-edit|exp|expand-abbrev|expand-file-name|expt|extended-command-history|extra-keyboard-modifiers|face-all-attributes|face-attribute|face-attribute-relative-p|face-background|face-bold-p|face-differs-from-default-p|face-documentation|face-equal|face-font|face-font-family-alternatives|face-font-registry-alternatives|face-font-rescale-alist|face-font-selection-order|face-foreground|face-id|face-inverse-video-p|face-italic-p|face-list|face-name-history|face-remap-add-relative|face-remap-remove-relative|face-remap-reset-base|face-remap-set-base|face-remapping-alist|face-spec-set|face-stipple|face-underline-p|facemenu-keymap|facep|fboundp|fceiling|feature-unload-function|featurep|features|fetch-bytecode|ffloor|field-beginning|field-end|field-string|field-string-no-properties|file-accessible-directory-p|file-acl|file-already-exists|file-attributes|file-chase-links|file-coding-system-alist|file-directory-p|file-equal-p|file-error|file-executable-p|file-exists-p|file-expand-wildcards|file-extended-attributes|file-in-directory-p|file-local-copy|file-local-variables-alist|file-locked|file-locked-p|file-modes|file-modes-symbolic-to-number|file-name-absolute-p|file-name-all-completions|file-name-as-directory|file-name-base|file-name-coding-system|file-name-completion|file-name-directory|file-name-extension|file-name-handler-alist|file-name-history|file-name-nondirectory|file-name-sans-extension|file-name-sans-versions|file-newer-than-file-p|file-newest-backup|file-nlinks|file-notify-add-watch|file-notify-rm-watch|file-ownership-preserved-p|file-precious-flag|file-readable-p|file-regular-p|file-relative-name|file-remote-p|file-selinux-context|file-supersession|file-symlink-p|file-truename|file-writable-p|fill-column|fill-context-prefix|fill-forward-paragraph-function|fill-individual-paragraphs|fill-individual-varying-indent|fill-nobreak-predicate|fill-paragraph|fill-paragraph-function|fill-prefix|fill-region|fill-region-as-paragraph|fillarray|filter-buffer-substring|filter-buffer-substring-functions??|find-auto-coding|find-backup-file-name|find-buffer-visiting|find-charset-region|find-charset-string|find-coding-systems-for-charsets|find-coding-systems-region|find-coding-systems-string|find-file|find-file-hook|find-file-literally|find-file-name-handler|find-file-noselect|find-file-not-found-functions|find-file-other-window|find-file-read-only|find-file-wildcards|find-font|find-image|find-operation-coding-system|first-change-hook|fit-frame-to-buffer|fit-frame-to-buffer-margins|fit-frame-to-buffer-sizes|fit-window-to-buffer|fit-window-to-buffer-horizontally|fixup-whitespace|float|float-e|float-output-format|float-pi|float-time|floatp|floats-consed|floor|fmakunbound|focus-follows-mouse|focus-in-hook|focus-out-hook|following-char|font-at|font-face-attributes|font-family-list|font-get|font-lock-add-keywords|font-lock-beginning-of-syntax-function|font-lock-builtin-face|font-lock-comment-delimiter-face|font-lock-comment-face|font-lock-constant-face|font-lock-defaults|font-lock-doc-face|font-lock-extend-after-change-region-function|font-lock-extra-managed-props|font-lock-fontify-buffer-function|font-lock-fontify-region-function|font-lock-function-name-face|font-lock-keyword-face|font-lock-keywords|font-lock-keywords-case-fold-search|font-lock-keywords-only|font-lock-mark-block-function|font-lock-multiline|font-lock-negation-char-face|font-lock-preprocessor-face|font-lock-remove-keywords|font-lock-string-face|font-lock-syntactic-face-function|font-lock-syntax-table|font-lock-type-face|font-lock-unfontify-buffer-function|font-lock-unfontify-region-function|font-lock-variable-name-face|font-lock-warning-face|font-put|font-spec|font-xlfd-name|fontification-functions|fontp|for|force-mode-line-update|force-window-update|format|format-alist|format-find-file|format-insert-file|format-mode-line|format-network-address|format-seconds|format-time-string|format-write-file|forward-button|forward-char|forward-comment|forward-line|forward-list|forward-sexp|forward-to-indentation|forward-word|frame-alpha-lower-limit|frame-auto-hide-function|frame-char-height|frame-char-width|frame-current-scroll-bars|frame-first-window|frame-height|frame-inherited-parameters|frame-list|frame-live-p|frame-monitor-attributes|frame-parameters??|frame-pixel-height|frame-pixel-width|frame-pointer-visible-p|frame-resize-pixelwise|frame-root-window|frame-selected-window|frame-terminal|frame-title-format|frame-visible-p|frame-width|framep|frexp|fringe-bitmaps-at-pos|fringe-cursor-alist|fringe-indicator-alist|fringes-outside-margins|fround|fset|ftp-login|ftruncate|function-get|functionp|fundamental-mode|fundamental-mode-abbrev-table|gap-position|gap-size|garbage-collect|garbage-collection-messages|gc-cons-percentage|gc-cons-threshold|gc-elapsed|gcs-done|generate-autoload-cookie|generate-new-buffer|generate-new-buffer-name|generated-autoload-file|get|get-buffer|get-buffer-create|get-buffer-process|get-buffer-window|get-buffer-window-list|get-byte|get-char-code-property|get-char-property|get-char-property-and-overlay|get-charset-property|get-device-terminal|get-file-buffer|get-internal-run-time|get-largest-window|get-load-suffixes|get-lru-window|get-pos-property|get-process|get-register|get-text-property|get-unused-category|get-window-with-predicate|getenv|gethash|global-abbrev-table|global-buffers-menu-map|global-disable-point-adjustment|global-key-binding|global-map|global-mode-string|global-set-key|global-unset-key|glyph-char|glyph-face|glyph-table|glyphless-char-display|glyphless-char-display-control|goto-char|goto-map|group-gid|group-real-gid|gv-define-expander|gv-define-setter|gv-define-simple-setter|gv-letplace|hack-dir-local-variables|hack-dir-local-variables-non-file-buffer|hack-local-variables|hack-local-variables-hook|handle-shift-selection|handle-switch-frame|hash-table-count|hash-table-p|hash-table-rehash-size|hash-table-rehash-threshold|hash-table-size|hash-table-test|hash-table-weakness|header-line-format|help-buffer|help-char|help-command|help-event-list|help-form|help-map|help-setup-xref|help-window-select|Helper-describe-bindings|Helper-help|Helper-help-map|history-add-new-input|history-delete-duplicates|history-length)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(icon-title-format|iconify-frame|identity|ignore|ignore-errors|ignore-window-parameters|ignored-local-variables|image-animate|image-animate-timer|image-cache-eviction-delay|image-current-frame|image-default-frame-delay|image-flush|image-format-suffixes|image-load-path|image-load-path-for-library|image-mask-p|image-minimum-frame-delay|image-multi-frame-p|image-show-frame|image-size|image-type-available-p|image-types|imagemagick-enabled-types|imagemagick-types|imagemagick-types-inhibit|imenu-add-to-menubar|imenu-case-fold-search|imenu-create-index-function|imenu-extract-index-name-function|imenu-generic-expression|imenu-prev-index-position-function|imenu-syntax-alist|inc|indent-according-to-mode|indent-code-rigidly|indent-for-tab-command|indent-line-function|indent-region|indent-region-function|indent-relative|indent-relative-maybe|indent-rigidly|indent-tabs-mode|indent-to|indent-to-left-margin|indicate-buffer-boundaries|indicate-empty-lines|indirect-function|indirect-variable|inhibit-default-init|inhibit-eol-conversion|inhibit-field-text-motion|inhibit-file-name-handlers|inhibit-file-name-operation|inhibit-iso-escape-detection|inhibit-local-variables-regexps|inhibit-modification-hooks|inhibit-null-byte-detection|inhibit-point-motion-hooks|inhibit-quit|inhibit-read-only|inhibit-splash-screen|inhibit-startup-echo-area-message|inhibit-startup-message|inhibit-startup-screen|inhibit-x-resources|init-file-user|initial-buffer-choice|initial-environment|initial-frame-alist|initial-major-mode|initial-scratch-message|initial-window-system|input-decode-map|input-method-alist|input-method-function|input-pending-p|insert|insert-abbrev-table-description|insert-and-inherit|insert-before-markers|insert-before-markers-and-inherit|insert-buffer|insert-buffer-substring|insert-buffer-substring-as-yank|insert-buffer-substring-no-properties|insert-button|insert-char|insert-default-directory|insert-directory|insert-directory-program|insert-file-contents|insert-file-contents-literally|insert-for-yank|insert-image|insert-register|insert-sliced-image|insert-text-button|installation-directory|integer-or-marker-p|integerp|interactive-form|intern|intern-soft|interpreter-mode-alist|interprogram-cut-function|interprogram-paste-function|interrupt-process|intervals-consed|invalid-function|invalid-read-syntax|invalid-regexp|invert-face|invisible-p|invocation-directory|invocation-name|isnan|jit-lock-register|jit-lock-unregister|just-one-space|justify-current-line|kbd|kbd-macro-termination-hook|kept-new-versions|kept-old-versions|key-binding|key-description|key-translation-map|keyboard-coding-system|keyboard-quit|keyboard-translate|keyboard-translate-table|keymap-parent|keymap-prompt|keymapp|keywordp|kill-all-local-variables|kill-append|kill-buffer|kill-buffer-hook|kill-buffer-query-functions|kill-emacs|kill-emacs-hook|kill-emacs-query-functions|kill-local-variable|kill-new|kill-process|kill-read-only-ok|kill-region|kill-ring|kill-ring-max|kill-ring-yank-pointer|kmacro-keymap|last-abbrev|last-abbrev-location|last-abbrev-text|last-buffer|last-coding-system-used|last-command|last-command-event|last-event-frame|last-input-event|last-kbd-macro|last-nonmenu-event|last-prefix-arg|last-repeatable-command|lax-plist-get|lax-plist-put|lazy-completion-table|ldexp|left-fringe-width|left-margin|left-margin-width|lexical-binding|libxml-parse-html-region|libxml-parse-xml-region|line-beginning-position|line-end-position|line-move-ignore-invisible|line-number-at-pos|line-prefix|line-spacing|lisp-mode-abbrev-table|list-buffers-directory|list-charset-chars|list-fonts|list-load-path-shadows|list-processes|list-system-processes|listify-key-sequence|ln|load-average|load-file|load-file-name|load-file-rep-suffixes|load-history|load-in-progress|load-library|load-path|load-prefer-newer|load-read-function|load-suffixes|load-theme|local-abbrev-table|local-function-key-map|local-key-binding|local-set-key|local-unset-key|local-variable-if-set-p|local-variable-p|locale-coding-system|locale-info|locate-file|locate-library|locate-user-emacs-file|lock-buffer|log|logand|logb|logior|lognot|logxor|looking-at|looking-at-p|looking-back|lookup-key|lower-frame|lsh|lwarn|macroexpand|macroexpand-all|macrop|magic-fallback-mode-alist|magic-mode-alist|mail-host-address|major-mode|make-abbrev-table|make-auto-save-file-name|make-backup-file-name|make-backup-file-name-function|make-backup-files|make-bool-vector|make-button|make-byte-code|make-category-set|make-category-table|make-char-table|make-composed-keymap|make-directory|make-display-table|make-frame|make-frame-invisible|make-frame-on-display|make-frame-visible|make-glyph-code|make-hash-table|make-help-screen|make-indirect-buffer|make-keymap|make-local-variable|make-marker|make-network-process|make-obsolete|make-obsolete-variable|make-overlay|make-progress-reporter|make-ring|make-serial-process|make-sparse-keymap|make-string|make-symbol|make-symbolic-link|make-syntax-table|make-temp-file|make-temp-name|make-text-button|make-translation-table|make-translation-table-from-alist|make-translation-table-from-vector|make-variable-buffer-local|make-vector|makehash|makunbound|map-char-table|map-charset-chars|map-keymap|map-y-or-n-p|mapatoms|mapconcat|maphash|mark|mark-active|mark-even-if-inactive|mark-marker|mark-ring|mark-ring-max|marker-buffer|marker-insertion-type|marker-position|markerp|match-beginning|match-data|match-end|match-string|match-string-no-properties|match-substitute-replacement|max-char|max-image-size|max-lisp-eval-depth|max-mini-window-height|max-specpdl-size|maximize-window|md5|member-ignore-case|memory-full|memory-limit|memory-use-counts|memql??|menu-bar-file-menu|menu-bar-final-items|menu-bar-help-menu|menu-bar-options-menu|menu-bar-tools-menu|menu-bar-update-hook|menu-item|menu-prompt-more-char|merge-face-attribute|message|message-box|message-log-max|message-or-box|message-truncate-lines|messages-buffer|meta-prefix-char|minibuffer-allow-text-properties|minibuffer-auto-raise|minibuffer-complete|minibuffer-complete-and-exit|minibuffer-complete-word|minibuffer-completion-confirm|minibuffer-completion-help|minibuffer-completion-predicate|minibuffer-completion-table|minibuffer-confirm-exit-commands|minibuffer-contents|minibuffer-contents-no-properties|minibuffer-depth|minibuffer-exit-hook|minibuffer-frame-alist|minibuffer-help-form|minibuffer-history|minibuffer-inactive-mode|minibuffer-local-completion-map|minibuffer-local-filename-completion-map|minibuffer-local-map|minibuffer-local-must-match-map|minibuffer-local-ns-map|minibuffer-local-shell-command-map|minibuffer-message|minibuffer-message-timeout|minibuffer-prompt|minibuffer-prompt-end|minibuffer-prompt-width|minibuffer-scroll-window|minibuffer-selected-window|minibuffer-setup-hook|minibuffer-window|minibuffer-window-active-p|minibufferp|minimize-window|minor-mode-alist|minor-mode-key-binding|minor-mode-list|minor-mode-map-alist|minor-mode-overriding-map-alist|misc-objects-consed|mkdir|mod|mode-line-buffer-identification|mode-line-client|mode-line-coding-system-map|mode-line-column-line-number-mode-map|mode-line-format|mode-line-frame-identification|mode-line-input-method-map|mode-line-modes|mode-line-modified|mode-line-mule-info|mode-line-position|mode-line-process|mode-line-remote|mode-name|mode-specific-map|modify-all-frames-parameters|modify-category-entry|modify-frame-parameters|modify-syntax-entry|momentary-string-display|most-negative-fixnum|most-positive-fixnum|mouse-1-click-follows-link|mouse-appearance-menu-map|mouse-leave-buffer-hook|mouse-movement-p|mouse-on-link-p|mouse-pixel-position|mouse-position|mouse-position-function|mouse-wheel-down-event|mouse-wheel-up-event|move-marker|move-overlay|move-point-visually|move-to-column|move-to-left-margin|move-to-window-line|movemail|mule-keymap|multi-query-replace-map|multibyte-char-to-unibyte|multibyte-string-p|multibyte-syntax-as-symbol|multiple-frames|narrow-map|narrow-to-page|narrow-to-region|natnump|negative-argument|network-coding-system-alist|network-interface-info|network-interface-list|newline|newline-and-indent|next-button|next-char-property-change|next-complete-history-element|next-frame|next-history-element|next-matching-history-element|next-overlay-change|next-property-change|next-screen-context-lines|next-single-char-property-change|next-single-property-change|next-window|nlistp|no-byte-compile|no-catch|no-redraw-on-reenter|noninteractive|noreturn|normal-auto-fill-function|normal-backup-enable-predicate|normal-mode|not-modified|notifications-close-notification|notifications-get-capabilities|notifications-get-server-information|notifications-notify|num-input-keys|num-nonmacro-input-events|number-or-marker-p|number-sequence|number-to-string|numberp|obarray|one-window-p|only-global-abbrevs|open-dribble-file|open-network-stream|open-paren-in-column-0-is-defun-start|open-termscript|other-buffer|other-window|other-window-scroll-buffer|overflow-newline-into-fringe|overlay-arrow-position|overlay-arrow-string|overlay-arrow-variable-list|overlay-buffer|overlay-end|overlay-get|overlay-properties|overlay-put|overlay-recenter|overlay-start|overlayp|overlays-at|overlays-in|overriding-local-map|overriding-local-map-menu-flag|overriding-terminal-local-map|overwrite-mode|package-archive-upload-base|package-archives|package-initialize|package-upload-buffer|package-upload-file|page-delimiter|paragraph-separate|paragraph-start|parse-colon-path|parse-partial-sexp|parse-sexp-ignore-comments|parse-sexp-lookup-properties|path-separator|perform-replace|play-sound|play-sound-file|play-sound-functions|plist-get|plist-member|plist-put|point|point-marker|point-max|point-max-marker|point-min|point-min-marker|pop-mark|pop-to-buffer|pop-up-frame-alist|pop-up-frame-function|pop-up-frames|pop-up-windows|pos-visible-in-window-p|position-bytes|posix-looking-at|posix-search-backward|posix-search-forward|posix-string-match|posn-actual-col-row|posn-area|posn-at-point|posn-at-x-y|posn-col-row|posn-image|posn-object|posn-object-width-height|posn-object-x-y|posn-point|posn-string|posn-timestamp|posn-window|posn-x-y|posnp|post-command-hook|post-gc-hook|post-self-insert-hook|pp|pre-command-hook|pre-redisplay-function|preceding-char|prefix-arg|prefix-help-command|prefix-numeric-value|preloaded-file-list|prepare-change-group|previous-button|previous-char-property-change|previous-complete-history-element|previous-frame|previous-history-element|previous-matching-history-element|previous-overlay-change|previous-property-change|previous-single-char-property-change|previous-single-property-change|previous-window|primitive-undo|prin1-to-string|print-circle|print-continuous-numbering|print-escape-multibyte|print-escape-newlines|print-escape-nonascii|print-gensym|print-length|print-level|print-number-table|print-quoted|printable-chars|process-adaptive-read-buffering|process-attributes|process-buffer|process-coding-system|process-coding-system-alist|process-command|process-connection-type|process-contact|process-datagram-address|process-environment|process-exit-status|process-file|process-file-shell-command|process-file-side-effects|process-filter|process-get|process-id|process-kill-buffer-query-function|process-lines|process-list|process-live-p|process-mark|process-name|process-plist|process-put|process-query-on-exit-flag|process-running-child-p|process-send-eof|process-send-region|process-send-string|process-sentinel|process-status|process-tty-name|process-type|processp|prog-mode|prog-mode-hook|progress-reporter-done|progress-reporter-force-update|progress-reporter-update|propertize|provide|provide-theme|pure-bytes-used|purecopy|purify-flag|push-button|push-mark|put|put-char-code-property|put-charset-property|put-image|put-text-property|puthash|query-replace-history|query-replace-map|quietly-read-abbrev-file|quit-flag|quit-process|quit-restore-window|quit-window|raise-frame|random|rassq|rassq-delete-all|re-builder|re-search-backward|re-search-forward|read|read-buffer|read-buffer-completion-ignore-case|read-buffer-function|read-char|read-char-choice|read-char-exclusive|read-circle|read-coding-system|read-color|read-command|read-directory-name|read-event|read-expression-history|read-file-modes|read-file-name|read-file-name-completion-ignore-case|read-file-name-function|read-from-minibuffer|read-from-string|read-input-method-name|read-kbd-macro|read-key|read-key-sequence|read-key-sequence-vector|read-minibuffer|read-no-blanks-input|read-non-nil-coding-system|read-only-mode|read-passwd|read-quoted-char|read-regexp|read-regexp-defaults-function|read-shell-command|read-string|read-variable|real-last-command|recent-auto-save-p|recent-keys|recenter|recenter-positions|recenter-redisplay|recenter-top-bottom|recursion-depth|recursive-edit|redirect-frame-focus|redisplay|redraw-display|redraw-frame|regexp-history|regexp-opt|regexp-opt-charset|regexp-opt-depth|regexp-quote|region-beginning|region-end|register-alist|register-read-with-preview|reindent-then-newline-and-indent|remhash|remote-file-name-inhibit-cache|remove|remove-from-invisibility-spec|remove-function|remove-hook|remove-images|remove-list-of-text-properties|remove-overlays|remove-text-properties|remq|rename-auto-save-file|rename-buffer|rename-file|replace-buffer-in-windows|replace-match|replace-re-search-function|replace-regexp-in-string|replace-search-function|require|require-final-newline|restore-buffer-modified-p|resume-tty|resume-tty-functions|revert-buffer|revert-buffer-function|revert-buffer-in-progress-p|revert-buffer-insert-file-contents-function|revert-without-query|right-fringe-width|right-margin-width|ring-bell-function|ring-copy|ring-elements|ring-empty-p|ring-insert|ring-insert-at-beginning|ring-length|ring-p|ring-ref|ring-remove|ring-size|risky-local-variable-p|rm|round|run-at-time|run-hook-with-args|run-hook-with-args-until-failure|run-hook-with-args-until-success|run-hooks|run-mode-hooks|run-with-idle-timer)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(safe-local-eval-forms|safe-local-variable-p|safe-local-variable-values|same-window-buffer-names|same-window-p|same-window-regexps|save-abbrevs|save-buffer|save-buffer-coding-system|save-current-buffer|save-excursion|save-match-data|save-restriction|save-selected-window|save-some-buffers|save-window-excursion|scalable-fonts-allowed|scan-lists|scan-sexps|scroll-bar-event-ratio|scroll-bar-mode|scroll-bar-scale|scroll-bar-width|scroll-conservatively|scroll-down|scroll-down-aggressively|scroll-down-command|scroll-error-top-bottom|scroll-left|scroll-margin|scroll-other-window|scroll-preserve-screen-position|scroll-right|scroll-step|scroll-up|scroll-up-aggressively|scroll-up-command|search-backward|search-failed|search-forward|search-map|search-spaces-regexp|seconds-to-time|secure-hash|select-frame|select-frame-set-input-focus|select-safe-coding-system|select-safe-coding-system-accept-default-p|select-window|selected-frame|selected-window|selection-coding-system|selective-display|selective-display-ellipses|self-insert-and-exit|self-insert-command|send-string-to-terminal|sentence-end|sentence-end-double-space|sentence-end-without-period|sentence-end-without-space|sequencep|serial-process-configure|serial-term|set-advertised-calling-convention|set-auto-coding|set-auto-mode|set-buffer|set-buffer-auto-saved|set-buffer-major-mode|set-buffer-modified-p|set-buffer-multibyte|set-case-syntax|set-case-syntax-delims|set-case-syntax-pair|set-case-table|set-category-table|set-char-table-extra-slot|set-char-table-parent|set-char-table-range|set-charset-priority|set-coding-system-priority|set-default|set-default-file-modes|set-display-table-slot|set-face-attribute|set-face-background|set-face-bold|set-face-font|set-face-foreground|set-face-inverse-video|set-face-italic|set-face-stipple|set-face-underline|set-file-acl|set-file-extended-attributes|set-file-modes|set-file-selinux-context|set-file-times|set-fontset-font|set-frame-configuration|set-frame-height|set-frame-parameter|set-frame-position|set-frame-selected-window|set-frame-size|set-frame-width|set-fringe-bitmap-face|set-input-method|set-input-mode|set-keyboard-coding-system|set-keymap-parent|set-left-margin|set-mark|set-marker|set-marker-insertion-type|set-match-data|set-minibuffer-window|set-mouse-pixel-position|set-mouse-position|set-network-process-option|set-process-buffer|set-process-coding-system|set-process-datagram-address|set-process-filter|set-process-plist|set-process-query-on-exit-flag|set-process-sentinel|set-register|set-right-margin|set-standard-case-table|set-syntax-table|set-terminal-coding-system|set-terminal-parameter|set-text-properties|set-transient-map|set-visited-file-modtime|set-visited-file-name|set-window-buffer|set-window-combination-limit|set-window-configuration|set-window-dedicated-p|set-window-display-table|set-window-fringes|set-window-hscroll|set-window-margins|set-window-next-buffers|set-window-parameter|set-window-point|set-window-prev-buffers|set-window-scroll-bars|set-window-start|set-window-vscroll|setenv|setplist|setq-default|setq-local|shell-command-history|shell-command-to-string|shell-quote-argument|show-help-function|shr-insert-document|shrink-window-if-larger-than-buffer|signal|signal-process|sin|single-key-description|sit-for|site-run-file|skip-chars-backward|skip-chars-forward|skip-syntax-backward|skip-syntax-forward|sleep-for|small-temporary-file-directory|smie-bnf->prec2|smie-close-block|smie-config|smie-config-guess|smie-config-local|smie-config-save|smie-config-set-indent|smie-config-show-indent|smie-down-list|smie-merge-prec2s|smie-prec2->grammar|smie-precs->prec2|smie-rule-bolp|smie-rule-hanging-p|smie-rule-next-p|smie-rule-parent|smie-rule-parent-p|smie-rule-prev-p|smie-rule-separator|smie-rule-sibling-p|smie-setup|Snarf-documentation|sort|sort-columns|sort-fields|sort-fold-case|sort-lines|sort-numeric-base|sort-numeric-fields|sort-pages|sort-paragraphs|sort-regexp-fields|sort-subr|special-event-map|special-form-p|special-mode|special-variable-p|split-height-threshold|split-string|split-string-and-unquote|split-string-default-separators|split-width-threshold|split-window|split-window-below|split-window-keep-point|split-window-preferred-function|split-window-right|split-window-sensibly|sqrt|standard-case-table|standard-category-table|standard-display-table|standard-input|standard-output|standard-syntax-table|standard-translation-table-for-decode|standard-translation-table-for-encode|start-file-process|start-file-process-shell-command|start-process|start-process-shell-command|stop-process|store-match-data|store-substring|string|string-as-multibyte|string-as-unibyte|string-bytes|string-chars-consed|string-equal|string-lessp|string-match|string-match-p|string-or-null-p|string-prefix-p|string-suffix-p|string-to-char|string-to-int|string-to-multibyte|string-to-number|string-to-syntax|string-to-unibyte|string-width|string<|string=|stringp|strings-consed|subr-arity|subrp|subst-char-in-region|substitute-command-keys|substitute-in-file-name|substitute-key-definition|substring|substring-no-properties|suppress-keymap|suspend-emacs|suspend-frame|suspend-hook|suspend-resume-hook|suspend-tty|suspend-tty-functions|switch-to-buffer|switch-to-buffer-other-frame|switch-to-buffer-other-window|switch-to-buffer-preserve-window-point|switch-to-next-buffer|switch-to-prev-buffer|switch-to-visible-buffer|sxhash|symbol-file|symbol-function|symbol-name|symbol-plist|symbol-value|symbolp|symbols-consed|syntax-after|syntax-begin-function|syntax-class|syntax-ppss|syntax-ppss-flush-cache|syntax-ppss-toplevel-pos|syntax-propertize-extend-region-functions|syntax-propertize-function|syntax-table|syntax-table-p|system-configuration|system-groups|system-key-alist|system-messages-locale|system-name|system-time-locale|system-type|system-users|tab-always-indent|tab-stop-list|tab-to-tab-stop|tab-width|tabulated-list-entries|tabulated-list-format|tabulated-list-init-header|tabulated-list-mode|tabulated-list-print|tabulated-list-printer|tabulated-list-revert-hook|tabulated-list-sort-key|tan|temacs|temp-buffer-setup-hook|temp-buffer-show-function|temp-buffer-show-hook|temp-buffer-window-setup-hook|temp-buffer-window-show-hook|temporary-file-directory|term-file-prefix|terminal-coding-system|terminal-list|terminal-live-p|terminal-name|terminal-parameters??|terpri|test-completion|testcover-mark-all|testcover-next-mark|testcover-start|text-char-description|text-mode|text-mode-abbrev-table|text-properties-at|text-property-any|text-property-default-nonsticky|text-property-not-all|thing-at-point|this-command|this-command-keys|this-command-keys-shift-translated|this-command-keys-vector|this-original-command|three-step-help|time-add|time-less-p|time-subtract|time-to-day-in-year|time-to-days|timer-max-repeats|toggle-enable-multibyte-characters|tool-bar-add-item|tool-bar-add-item-from-menu|tool-bar-border|tool-bar-button-margin|tool-bar-button-relief|tool-bar-local-item-from-menu|tool-bar-map|top-level|tq-close|tq-create|tq-enqueue|track-mouse|transient-mark-mode|translate-region|translation-table-for-input|transpose-regions|truncate|truncate-lines|truncate-partial-width-windows|truncate-string-to-width|try-completion|tty-color-alist|tty-color-approximate|tty-color-clear|tty-color-define|tty-color-translate|tty-erase-char|tty-setup-hook|tty-top-frame|type-of|unbury-buffer|undefined|underline-minimum-offset|undo-ask-before-discard|undo-boundary|undo-in-progress|undo-limit|undo-outer-limit|undo-strong-limit|unhandled-file-name-directory|unibyte-char-to-multibyte|unibyte-string|unicode-category-table|unintern|universal-argument|universal-argument-map|unload-feature|unload-feature-special-hooks|unlock-buffer|unread-command-events|unsafep|up-list|upcase|upcase-initials|upcase-region|upcase-word|update-directory-autoloads|update-file-autoloads|use-empty-active-region|use-global-map|use-hard-newlines|use-local-map|use-region-p|user-emacs-directory|user-error|user-full-name|user-init-file|user-login-name|user-mail-address|user-real-login-name|user-real-uid|user-uid|values|vc-mode|vc-prefix-map|vconcat|vector|vector-cells-consed|vectorp|verify-visited-file-modtime|version-control|vertical-motion|vertical-scroll-bar|view-register|visible-bell|visible-frame-list|visited-file-modtime|void-function|void-text-area-pointer|waiting-for-user-input-p|walk-windows|warn|warning-fill-prefix|warning-levels|warning-minimum-level|warning-minimum-log-level|warning-prefix-function|warning-series|warning-suppress-log-types|warning-suppress-types|warning-type-format|where-is-internal|while-no-input|wholenump|widen|window-absolute-pixel-edges|window-at|window-body-height|window-body-size|window-body-width|window-bottom-divider-width|window-buffer|window-child|window-combination-limit|window-combination-resize|window-combined-p|window-configuration-change-hook|window-configuration-frame|window-configuration-p|window-current-scroll-bars|window-dedicated-p|window-display-table|window-edges|window-end|window-frame|window-fringes|window-full-height-p|window-full-width-p|window-header-line-height|window-hscroll|window-in-direction|window-inside-absolute-pixel-edges|window-inside-edges|window-inside-pixel-edges|window-left-child|window-left-column|window-line-height|window-list|window-live-p|window-margins|window-min-height|window-min-size|window-min-width|window-minibuffer-p|window-mode-line-height|window-next-buffers|window-next-sibling|window-parameters??|window-parent|window-persistent-parameters|window-pixel-edges|window-pixel-height|window-pixel-left|window-pixel-top|window-pixel-width|window-point|window-point-insertion-type|window-prev-buffers|window-prev-sibling|window-resizable|window-resize|window-resize-pixelwise|window-right-divider-width|window-scroll-bar-width|window-scroll-bars|window-scroll-functions|window-setup-hook|window-size-change-functions|window-size-fixed|window-start|window-state-get|window-state-put|window-system|window-system-initialization-alist|window-text-change-functions|window-text-pixel-size|window-top-child|window-top-line|window-total-height|window-total-size|window-total-width|window-tree|window-valid-p|window-vscroll|windowp|with-case-table|with-coding-priority|with-current-buffer|with-current-buffer-window|with-demoted-errors|with-eval-after-load|with-help-window|with-local-quit|with-no-warnings|with-output-to-string|with-output-to-temp-buffer|with-selected-window|with-syntax-table|with-temp-buffer|with-temp-buffer-window|with-temp-file|with-temp-message|with-timeout|word-search-backward|word-search-backward-lax|word-search-forward|word-search-forward-lax|word-search-regexp|words-include-escapes|wrap-prefix|write-abbrev-file|write-char|write-contents-functions|write-file|write-file-functions|write-region|write-region-annotate-functions|write-region-post-annotation-function|wrong-number-of-arguments|wrong-type-argument|x-alt-keysym|x-alternatives-map|x-bitmap-file-path|x-close-connection|x-color-defined-p|x-color-values|x-defined-colors|x-display-color-p|x-display-list|x-dnd-known-types|x-dnd-test-function|x-dnd-types-alist|x-family-fonts|x-get-resource|x-get-selection|x-hyper-keysym|x-list-fonts|x-meta-keysym|x-open-connection|x-parse-geometry|x-pointer-shape|x-popup-dialog|x-popup-menu|x-resource-class|x-resource-name|x-sensitive-text-pointer-shape|x-server-vendor|x-server-version|x-set-selection|x-setup-function-keys|x-super-keysym|y-or-n-p|y-or-n-p-with-timeout|yank|yank-excluded-properties|yank-handled-properties|yank-pop|yank-undo-function|yes-or-no-p|zerop|zlib-available-p|zlib-decompress-region)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(?:mocha--other-js2-imenu-function|mocha-command|mocha-debug-port|mocha-debuggers?|mocha-environment-variables|mocha-imenu-functions|mocha-options|mocha-project-test-directory|mocha-reporter|mocha-test-definition-nodes|mocha-which-node|node-error-regexp-alist|node-error-regexp)(?=[()\\\\s]|$)","name":"support.variable.emacs.lisp"},{"match":"(?<=[()]|^)(?:define-modify-macro|define-setf-method|defsetf|eval-when-compile|flet|labels|lexical-let\\\\*?|cl-(?:acons|adjoin|assert|assoc|assoc-if|assoc-if-not|block|caddr|callf2??|case|ceiling|check-type|coerce|compiler-macroexpand|concatenate|copy-list|count|count-if|count-if-not|decf|declaim|declare|define-compiler-macro|defmacro|defstruct|defsubst|deftype|defun|delete|delete-duplicates|delete-if|delete-if-not|destructuring-bind|do\\\\*?|do-all-symbols|do-symbols|dolist|dotimes|ecase|endp|equalp|etypecase|eval-when|evenp|every|fill|find|find-if|find-if-not|first|flet|float-limits|floor|function|gcd|gensym|gentemp|getf?|incf|intersection|isqrt|labels|lcm|ldiff|letf\\\\*?|list\\\\*|list-length|load-time-value|locally|loop|macrolet|make-random-state|mapc??|mapcan|mapcar|mapcon|mapl|maplist|member|member-if|member-if-not|merge|minusp|mismatch|mod|multiple-value-bind|multiple-value-setq|nintersection|notany|notevery|nset-difference|nset-exclusive-or|nsublis|nsubst|nsubst-if|nsubst-if-not|nsubstitute|nsubstitute-if|nsubstitute-if-not|nunion|oddp|pairlis|plusp|position|position-if|position-if-not|prettyexpand|proclaim|progv|psetf|psetq|pushnew|random|random-state-p|rassoc|rassoc-if|rassoc-if-not|reduce|remf?|remove|remove-duplicates|remove-if|remove-if-not|remprop|replace|rest|return|return-from|rotatef|round|search|set-difference|set-exclusive-or|shiftf|some|sort|stable-sort|sublis|subseq|subsetp|subst|subst-if|subst-if-not|substitute|substitute-if|substitute-if-not|symbol-macrolet|tagbody|tailp|the|tree-equal|truncate|typecase|typep|union))(?=[()\\\\s]|$)","name":"support.function.cl-lib.emacs.lisp"},{"match":"(?<=[()]|^)(?:\\\\*table--cell-backward-kill-paragraph|\\\\*table--cell-backward-kill-sentence|\\\\*table--cell-backward-kill-sexp|\\\\*table--cell-backward-kill-word|\\\\*table--cell-backward-paragraph|\\\\*table--cell-backward-sentence|\\\\*table--cell-backward-word|\\\\*table--cell-beginning-of-buffer|\\\\*table--cell-beginning-of-line|\\\\*table--cell-center-line|\\\\*table--cell-center-paragraph|\\\\*table--cell-center-region|\\\\*table--cell-clipboard-yank|\\\\*table--cell-copy-region-as-kill|\\\\*table--cell-dabbrev-completion|\\\\*table--cell-dabbrev-expand|\\\\*table--cell-delete-backward-char|\\\\*table--cell-delete-char|\\\\*table--cell-delete-region|\\\\*table--cell-describe-bindings|\\\\*table--cell-describe-mode|\\\\*table--cell-end-of-buffer|\\\\*table--cell-end-of-line|\\\\*table--cell-fill-paragraph|\\\\*table--cell-forward-paragraph|\\\\*table--cell-forward-sentence|\\\\*table--cell-forward-word|\\\\*table--cell-insert|\\\\*table--cell-kill-line|\\\\*table--cell-kill-paragraph|\\\\*table--cell-kill-region|\\\\*table--cell-kill-ring-save|\\\\*table--cell-kill-sentence|\\\\*table--cell-kill-sexp|\\\\*table--cell-kill-word|\\\\*table--cell-move-beginning-of-line|\\\\*table--cell-move-end-of-line|\\\\*table--cell-newline-and-indent|\\\\*table--cell-newline|\\\\*table--cell-open-line|\\\\*table--cell-quoted-insert|\\\\*table--cell-self-insert-command|\\\\*table--cell-yank-clipboard-selection|\\\\*table--cell-yank|\\\\*table--present-cell-popup-menu|-cvs-create-fileinfo--cmacro|-cvs-create-fileinfo|-cvs-flags-make--cmacro|-cvs-flags-make|1\\\\+|1-|1value|2C-associate-buffer|2C-associated-buffer|2C-autoscroll|2C-command|2C-dissociate|2C-enlarge-window-horizontally|2C-merge|2C-mode|2C-newline|2C-other|2C-shrink-window-horizontally|2C-split|2C-toggle-autoscroll|2C-two-columns|5x5-bol|5x5-cell|5x5-copy-grid|5x5-crack-mutating-best|5x5-crack-mutating-current|5x5-crack-randomly|5x5-crack-xor-mutate|5x5-crack|5x5-defvar-local|5x5-down|5x5-draw-grid-end|5x5-draw-grid|5x5-eol|5x5-first|5x5-flip-cell|5x5-flip-current|5x5-grid-to-vec|5x5-grid-value|5x5-last|5x5-left|5x5-log-init|5x5-log|5x5-made-move|5x5-make-move|5x5-make-mutate-best|5x5-make-mutate-current|5x5-make-new-grid|5x5-make-random-grid|5x5-make-random-solution|5x5-make-xor-with-mutation|5x5-mode-menu|5x5-mode|5x5-mutate-solution|5x5-new-game|5x5-play-solution|5x5-position-cursor|5x5-quit-game|5x5-randomize|5x5-right|5x5-row-value|5x5-set-cell|5x5-solve-rotate-left|5x5-solve-rotate-right|5x5-solve-suggest|5x5-solver|5x5-up|5x5-vec-to-grid|5x5-xor|5x5-y-or-n-p|5x5|Buffer-menu--pretty-file-name|Buffer-menu--pretty-name|Buffer-menu--unmark|Buffer-menu-1-window|Buffer-menu-2-window|Buffer-menu-backup-unmark|Buffer-menu-beginning|Buffer-menu-buffer|Buffer-menu-bury|Buffer-menu-delete-backwards|Buffer-menu-delete|Buffer-menu-execute|Buffer-menu-info-node-description|Buffer-menu-isearch-buffers-regexp|Buffer-menu-isearch-buffers|Buffer-menu-mark|Buffer-menu-marked-buffers|Buffer-menu-mode|Buffer-menu-mouse-select|Buffer-menu-multi-occur|Buffer-menu-no-header|Buffer-menu-not-modified|Buffer-menu-other-window|Buffer-menu-save|Buffer-menu-select|Buffer-menu-sort|Buffer-menu-switch-other-window|Buffer-menu-this-window|Buffer-menu-toggle-files-only|Buffer-menu-toggle-read-only|Buffer-menu-unmark|Buffer-menu-view-other-window|Buffer-menu-view|Buffer-menu-visit-tags-table|Control-X-prefix|Custom-buffer-done|Custom-goto-parent|Custom-help|Custom-mode-menu|Custom-mode|Custom-newline|Custom-no-edit|Custom-reset-current|Custom-reset-saved|Custom-reset-standard|Custom-save|Custom-set|Electric-buffer-menu-exit|Electric-buffer-menu-mode-view-buffer|Electric-buffer-menu-mode|Electric-buffer-menu-mouse-select|Electric-buffer-menu-quit|Electric-buffer-menu-select|Electric-buffer-menu-undefined|Electric-command-history-redo-expression|Electric-command-loop|Electric-pop-up-window|Footnote-add-footnote|Footnote-assoc-index|Footnote-back-to-message|Footnote-current-regexp|Footnote-cycle-style|Footnote-delete-footnote|Footnote-english-lower|Footnote-english-upper|Footnote-goto-char-point-max|Footnote-goto-footnote|Footnote-index-to-string|Footnote-insert-footnote|Footnote-insert-numbered-footnote|Footnote-insert-pointer-marker|Footnote-insert-text-marker|Footnote-latin|Footnote-make-hole|Footnote-narrow-to-footnotes|Footnote-numeric|Footnote-refresh-footnotes|Footnote-renumber-footnotes|Footnote-renumber|Footnote-roman-common|Footnote-roman-lower|Footnote-roman-upper|Footnote-set-style|Footnote-sort|Footnote-style-p|Footnote-text-under-cursor|Footnote-under-cursor|Footnote-unicode|Info--search-loop|Info-apropos-find-file|Info-apropos-find-node|Info-apropos-matches|Info-apropos-toc-nodes|Info-backward-node|Info-bookmark-jump|Info-bookmark-make-record|Info-breadcrumbs|Info-build-node-completions-1|Info-build-node-completions|Info-cease-edit|Info-check-pointer|Info-clone-buffer|Info-complete-menu-item|Info-copy-current-node-name|Info-default-dirs|Info-desktop-buffer-misc-data|Info-dir-remove-duplicates|Info-directory-find-file|Info-directory-find-node|Info-directory-toc-nodes|Info-directory|Info-display-images-node|Info-edit-mode|Info-edit|Info-exit|Info-extract-menu-counting|Info-extract-menu-item|Info-extract-menu-node-name|Info-extract-pointer|Info-file-supports-index-cookies|Info-final-node|Info-find-emacs-command-nodes|Info-find-file|Info-find-in-tag-table-1|Info-find-in-tag-table|Info-find-index-name|Info-find-node-2|Info-find-node-in-buffer-1|Info-find-node-in-buffer|Info-find-node|Info-finder-find-file|Info-finder-find-node|Info-follow-nearest-node|Info-follow-reference|Info-following-node-name-re|Info-following-node-name|Info-fontify-node|Info-forward-node|Info-get-token|Info-goto-emacs-command-node|Info-goto-emacs-key-command-node|Info-goto-index|Info-goto-node|Info-help|Info-hide-cookies-node|Info-history-back|Info-history-find-file|Info-history-find-node|Info-history-forward|Info-history-toc-nodes|Info-history|Info-index-next|Info-index-nodes??|Info-index|Info-insert-dir|Info-install-speedbar-variables|Info-isearch-end|Info-isearch-filter|Info-isearch-pop-state|Info-isearch-push-state|Info-isearch-search|Info-isearch-start|Info-isearch-wrap|Info-kill-buffer|Info-last-menu-item|Info-last-preorder|Info-last|Info-menu-update|Info-menu|Info-mode-menu|Info-mode|Info-mouse-follow-link|Info-mouse-follow-nearest-node|Info-mouse-scroll-down|Info-mouse-scroll-up|Info-next-menu-item|Info-next-preorder|Info-next-reference-or-link|Info-next-reference|Info-next|Info-no-error|Info-node-at-bob-matching|Info-nth-menu-item|Info-on-current-buffer|Info-prev-reference-or-link|Info-prev-reference|Info-prev|Info-read-node-name-1|Info-read-node-name-2|Info-read-node-name|Info-read-subfile|Info-restore-desktop-buffer|Info-restore-point|Info-revert-buffer-function|Info-revert-find-node|Info-scroll-down|Info-scroll-up|Info-search-backward|Info-search-case-sensitively|Info-search-next|Info-search|Info-select-node|Info-set-mode-line|Info-speedbar-browser|Info-speedbar-buttons|Info-speedbar-expand-node|Info-speedbar-fetch-file-nodes|Info-speedbar-goto-node|Info-speedbar-hierarchy-buttons|Info-split-parameter-string|Info-split|Info-summary|Info-tagify|Info-toc-build|Info-toc-find-node|Info-toc-insert|Info-toc-nodes|Info-toc|Info-top-node|Info-try-follow-nearest-node|Info-undefined|Info-unescape-quotes|Info-up|Info-validate-node-name|Info-validate-tags-table|Info-validate|Info-virtual-call|Info-virtual-file-p|Info-virtual-fun|Info-virtual-index-find-node|Info-virtual-index|LaTeX-mode|Man-bgproc-filter|Man-bgproc-sentinel|Man-bookmark-jump|Man-bookmark-make-record|Man-build-man-command|Man-build-page-list|Man-build-references-alist|Man-build-section-alist|Man-cleanup-manpage|Man-completion-table|Man-default-bookmark-title|Man-default-man-entry|Man-find-section|Man-follow-manual-reference|Man-fontify-manpage|Man-getpage-in-background|Man-goto-page|Man-goto-section|Man-goto-see-also-section|Man-highlight-references0??|Man-init-defvars|Man-kill|Man-make-page-mode-string|Man-mode|Man-next-manpage|Man-next-section|Man-notify-when-ready|Man-page-from-arguments|Man-parse-man-k|Man-possibly-hyphenated-word|Man-previous-manpage|Man-previous-section|Man-quit|Man-softhyphen-to-minus|Man-start-calling|Man-strip-page-headers|Man-support-local-filenames|Man-translate-cleanup|Man-translate-references|Man-unindent|Man-update-manpage|Man-view-header-file|Man-xref-button-action|Math-anglep|Math-bignum-test|Math-equal-int|Math-equal|Math-integer-negp??|Math-integer-posp|Math-integerp|Math-lessp|Math-looks-negp|Math-messy-integerp|Math-natnum-lessp|Math-natnump|Math-negp|Math-num-integerp|Math-numberp|Math-objectp|Math-objvecp|Math-posp|Math-primp|Math-ratp|Math-realp|Math-scalarp|Math-vectorp|Math-zerop|TeX-mode|View-back-to-mark|View-exit-and-edit|View-exit|View-goto-line|View-goto-percent|View-kill-and-leave|View-leave|View-quit-all|View-quit|View-revert-buffer-scroll-page-forward|View-scroll-half-page-backward|View-scroll-half-page-forward|View-scroll-line-backward|View-scroll-line-forward|View-scroll-page-backward-set-page-size|View-scroll-page-backward|View-scroll-page-forward-set-page-size|View-scroll-page-forward|View-scroll-to-buffer-end|View-search-last-regexp-backward|View-search-last-regexp-forward|View-search-regexp-backward|View-search-regexp-forward|WoMan-find-buffer|WoMan-getpage-in-background|WoMan-log-1|WoMan-log-begin|WoMan-log-end|WoMan-log|WoMan-next-manpage|WoMan-previous-manpage|WoMan-warn-ignored|WoMan-warn|abbrev--active-tables|abbrev--before-point|abbrev--check-chars|abbrev--default-expand|abbrev--describe|abbrev--symbol|abbrev--write|abbrev-edit-save-buffer|abbrev-edit-save-to-file|abbrev-mode|abbrev-table-empty-p|abbrev-table-menu|abbrev-table-name|abort-if-file-too-large|about-emacs|accelerate-menu|accept-completion|acons|activate-input-method|activate-mark|activate-mode-local-bindings|ad--defalias-fset|ad--make-advised-docstring|ad-Advice-c-backward-sws|ad-Advice-c-beginning-of-macro|ad-Advice-c-forward-sws|ad-Advice-save-place-find-file-hook|ad-access-argument|ad-activate-advised-definition|ad-activate-all|ad-activate-internal|ad-activate-on|ad-activate-regexp|ad-activate|ad-add-advice|ad-advice-definition|ad-advice-enabled|ad-advice-name|ad-advice-p|ad-advice-position|ad-advice-protected|ad-advice-set-enabled|ad-advised-arglist|ad-advised-interactive-form|ad-arg-binding-field|ad-arglist|ad-assemble-advised-definition|ad-body-forms|ad-cache-id-verification-code|ad-class-p|ad-clear-advicefunname-definition|ad-clear-cache|ad-compile-function|ad-compiled-code|ad-compiled-p|ad-copy-advice-info|ad-deactivate-all|ad-deactivate-regexp|ad-deactivate|ad-definition-type|ad-disable-advice|ad-disable-regexp|ad-do-advised-functions|ad-docstring|ad-element-access|ad-enable-advice-internal|ad-enable-advice|ad-enable-regexp-internal|ad-enable-regexp|ad-find-advice|ad-find-some-advice|ad-get-advice-info-field|ad-get-advice-info-macro|ad-get-advice-info|ad-get-arguments??|ad-get-cache-class-id|ad-get-cache-definition|ad-get-cache-id|ad-get-enabled-advices|ad-get-orig-definition|ad-has-any-advice|ad-has-enabled-advice|ad-has-proper-definition|ad-has-redefining-advice|ad-initialize-advice-info|ad-insert-argument-access-forms|ad-interactive-form|ad-is-active|ad-is-advised|ad-is-compilable|ad-lambda-expression|ad-lambda-p|ad-lambdafy|ad-list-access|ad-macrofy|ad-make-advice|ad-make-advicefunname|ad-make-advised-definition|ad-make-cache-id|ad-make-hook-form|ad-make-single-advice-docstring|ad-map-arglists|ad-name-p|ad-parse-arglist|ad-pop-advised-function|ad-position-p|ad-preactivate-advice|ad-pushnew-advised-function|ad-read-advice-class|ad-read-advice-name|ad-read-advice-specification|ad-read-advised-function|ad-read-regexp|ad-real-definition|ad-real-orig-definition|ad-recover-all|ad-recover-normality|ad-recover|ad-remove-advice|ad-retrieve-args-form|ad-set-advice-info-field|ad-set-advice-info|ad-set-arguments??|ad-set-cache|ad-should-compile|ad-substitute-tree|ad-unadvise-all|ad-unadvise|ad-update-all|ad-update-regexp|ad-update|ad-verify-cache-class-id|ad-verify-cache-id|ad-with-originals|ada-activate-keys-for-case|ada-add-extensions|ada-adjust-case-buffer|ada-adjust-case-identifier|ada-adjust-case-interactive|ada-adjust-case-region|ada-adjust-case-skeleton|ada-adjust-case-substring|ada-adjust-case|ada-after-keyword-p|ada-array|ada-batch-reformat|ada-call-from-contextual-menu|ada-capitalize-word|ada-case-read-exceptions-from-file)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)a(?:da-case-read-exceptions|da-case|da-change-prj|da-check-current|da-check-defun-name|da-check-matching-start|da-compile-application|da-compile-current|da-compile-goto-error|da-compile-mouse-goto-error|da-complete-identifier|da-contextual-menu|da-create-case-exception-substring|da-create-case-exception|da-create-keymap|da-create-menu|da-customize|da-declare-block|da-else|da-elsif|da-exception-block|da-exception|da-exit|da-ff-other-window|da-fill-comment-paragraph-justify|da-fill-comment-paragraph-postfix|da-fill-comment-paragraph|da-find-any-references|da-find-file|da-find-local-references|da-find-references|da-find-src-file-in-dir|da-for-loop|da-format-paramlist|da-function-spec|da-gdb-application|da-gen-treat-proc|da-get-body-name|da-get-current-indent|da-get-indent-block-label|da-get-indent-block-start|da-get-indent-case|da-get-indent-end|da-get-indent-goto-label|da-get-indent-if|da-get-indent-loop|da-get-indent-nochange|da-get-indent-noindent|da-get-indent-open-paren|da-get-indent-paramlist|da-get-indent-subprog|da-get-indent-type|da-get-indent-when|da-gnat-style|da-goto-decl-start|da-goto-declaration-other-frame|da-goto-declaration|da-goto-matching-end|da-goto-matching-start|da-goto-next-non-ws|da-goto-next-word|da-goto-parent|da-goto-previous-word|da-goto-stmt-end|da-goto-stmt-start|da-header|da-if|da-in-comment-p|da-in-decl-p|da-in-numeric-literal-p|da-in-open-paren-p|da-in-paramlist-p|da-in-string-or-comment-p|da-in-string-p|da-indent-current-function|da-indent-current|da-indent-newline-indent-conditional|da-indent-newline-indent|da-indent-on-previous-lines|da-indent-region|da-insert-paramlist|da-justified-indent-current|da-looking-at-semi-or|da-looking-at-semi-private|da-loop|da-loose-case-word|da-make-body-gnatstub|da-make-body|da-make-filename-from-adaname|da-make-subprogram-body|da-mode-menu|da-mode-version|da-mode|da-move-to-end|da-move-to-start|da-narrow-to-defun|da-next-package|da-next-procedure|da-no-auto-case|da-other-file-name|da-outline-level|da-package-body|da-package-spec|da-point-and-xref|da-popup-menu|da-previous-package|da-previous-procedure|da-private|da-prj-edit|da-prj-new|da-prj-save|da-procedure-spec|da-record|da-region-selected|da-remove-trailing-spaces|da-reread-prj-file|da-run-application|da-save-exceptions-to-file|da-scan-paramlist|da-search-ignore-complex-boolean|da-search-ignore-string-comment|da-search-prev-end-stmt|da-set-default-project-file|da-set-main-compile-application|da-set-point-accordingly|da-show-current-main|da-subprogram-body|da-subtype|da-tab-hard|da-tab|da-tabsize|da-task-body|da-task-spec|da-type|da-uncomment-region|da-untab-hard|da-untab|da-use|da-when|da-which-function-are-we-in|da-which-function|da-while-loop|da-with|da-xref-goto-previous-reference|dd-abbrev|dd-change-log-entry-other-window|dd-change-log-entry|dd-completion-to-head|dd-completion-to-tail-if-new|dd-completion|dd-completions-from-buffer|dd-completions-from-c-buffer|dd-completions-from-file|dd-completions-from-lisp-buffer|dd-completions-from-tags-table|dd-dir-local-variable|dd-file-local-variable-prop-line|dd-file-local-variable|dd-global-abbrev|dd-log-current-defun|dd-log-edit-next-comment|dd-log-edit-prev-comment|dd-log-file-name|dd-log-iso8601-time-string|dd-log-iso8601-time-zone|dd-log-tcl-defun|dd-minor-mode|dd-mode-abbrev|dd-new-page|dd-permanent-completion|dd-submenu|dd-timeout|dd-to-coding-system-list|dd-to-list--anon-cmacro|ddbib|djoin|dvertised-undo|dvertised-widget-backward|dvertised-xscheme-send-previous-expression|dvice--add-function|dvice--buffer-local|dvice--called-interactively-skip|dvice--car|dvice--cd\\\\*r|dvice--cdr|dvice--defalias-fset|dvice--interactive-form|dvice--make-1|dvice--make-docstring|dvice--make-interactive-form|dvice--make|dvice--member-p|dvice--normalize-place|dvice--normalize|dvice--p|dvice--props|dvice--remove-function|dvice--set-buffer-local|dvice--strip-macro|dvice--subst-main|dvice--symbol-function|dvice--tweak|fter-insert-file-set-coding|lign--set-marker|lign-adjust-col-for-rule|lign-areas|lign-column|lign-current|lign-entire|lign-highlight-rule|lign-match-tex-pattern|lign-new-section-p|lign-newline-and-indent|lign-regexp|lign-regions??|lign-set-vhdl-rules|lign-unhighlight-rule|lign|list-get|llout-aberrant-container-p|llout-add-resumptions|llout-adjust-file-variable|llout-after-saves-handler|llout-annotate-hidden|llout-ascend-to-depth|llout-ascend|llout-auto-activation-helper|llout-auto-fill|llout-back-to-current-heading|llout-back-to-heading|llout-back-to-visible-text|llout-backward-current-level|llout-before-change-handler|llout-beginning-of-current-entry|llout-beginning-of-current-line|llout-beginning-of-level|llout-beginning-of-line|llout-body-modification-handler|llout-bullet-for-depth|llout-bullet-isearch|llout-called-interactively-p|llout-chart-exposure-contour-by-icon|llout-chart-siblings|llout-chart-subtree|llout-chart-to-reveal|llout-compose-and-institute-keymap|llout-copy-exposed-to-buffer|llout-copy-line-as-kill|llout-copy-topic-as-kill|llout-current-bullet-pos|llout-current-bullet|llout-current-decorated-p|llout-current-depth|llout-current-topic-collapsed-p|llout-deannotate-hidden|llout-decorate-item-and-context|llout-decorate-item-body|llout-decorate-item-cue|llout-decorate-item-guides|llout-decorate-item-icon|llout-decorate-item-span|llout-depth|llout-descend-to-depth|llout-distinctive-bullet|llout-do-doublecheck|llout-do-resumptions|llout-e-o-prefix-p|llout-elapsed-time-seconds|llout-encrypt-decrypted|llout-encrypt-string|llout-encrypted-topic-p|llout-encrypted-type-prefix|llout-end-of-current-heading|llout-end-of-current-line|llout-end-of-current-subtree|llout-end-of-entry|llout-end-of-heading|llout-end-of-level|llout-end-of-line|llout-end-of-prefix|llout-end-of-subtree|llout-expose-topic|llout-fetch-icon-image|llout-file-vars-section-data|llout-find-file-hook|llout-find-image|llout-flag-current-subtree|llout-flag-region|llout-flatten-exposed-to-buffer|llout-flatten|llout-format-quote|llout-forward-current-level|llout-frame-property|llout-get-body-text|llout-get-bullet|llout-get-configvar-values|llout-get-current-prefix|llout-get-invisibility-overlay|llout-get-item-widget|llout-get-or-create-item-widget|llout-get-or-create-parent-widget|llout-get-prefix-bullet|llout-goto-prefix-doublechecked|llout-goto-prefix|llout-graphics-modification-handler|llout-hidden-p|llout-hide-bodies|llout-hide-by-annotation|llout-hide-current-entry|llout-hide-current-leaves|llout-hide-current-subtree|llout-hide-region-body|llout-hotspot-key-handler|llout-indented-exposed-to-buffer|llout-infer-body-reindent|llout-infer-header-lead-and-primary-bullet|llout-infer-header-lead|llout-inhibit-auto-save-info-for-decryption|llout-init|llout-insert-latex-header|llout-insert-latex-trailer|llout-insert-listified|llout-institute-keymap|llout-isearch-end-handler|llout-item-actual-position|llout-item-element-span-is|llout-item-icon-key-handler|llout-item-location|llout-item-span|llout-kill-line|llout-kill-topic|llout-latex-verb-quote|llout-latex-verbatim-quote-curr-line|llout-latexify-exposed|llout-latexify-one-item|llout-lead-with-comment-string|llout-listify-exposed|llout-make-topic-prefix|llout-mark-active-p|llout-mark-marker|llout-mark-topic|llout-maybe-resume-auto-save-info-after-encryption|llout-minor-mode|llout-mode-map|llout-mode-p|llout-mode|llout-new-exposure|llout-new-item-widget|llout-next-heading|llout-next-sibling-leap|llout-next-sibling|llout-next-single-char-property-change|llout-next-topic-pending-encryption|llout-next-visible-heading|llout-number-siblings|llout-numbered-type-prefix|llout-old-expose-topic|llout-on-current-heading-p|llout-on-heading-p|llout-open-sibtopic|llout-open-subtopic|llout-open-supertopic|llout-open-topic|llout-overlay-insert-in-front-handler|llout-overlay-interior-modification-handler|llout-overlay-preparations|llout-parse-item-at-point|llout-post-command-business|llout-pre-command-business|llout-pre-next-prefix|llout-prefix-data|llout-previous-heading|llout-previous-sibling|llout-previous-single-char-property-change|llout-previous-visible-heading|llout-process-exposed|llout-range-overlaps|llout-rebullet-current-heading|llout-rebullet-heading|llout-rebullet-topic-grunt|llout-rebullet-topic|llout-recent-bullet|llout-recent-depth|llout-recent-prefix|llout-redecorate-item|llout-redecorate-visible-subtree|llout-region-active-p|llout-reindent-body|llout-renumber-to-depth|llout-reset-header-lead|llout-resolve-xref|llout-run-unit-tests|llout-select-safe-coding-system|llout-set-boundary-marker|llout-setup-menubar|llout-setup-text-properties|llout-setup|llout-shift-in|llout-shift-out|llout-show-all|llout-show-children|llout-show-current-branches|llout-show-current-entry|llout-show-current-subtree|llout-show-entry|llout-show-to-offshoot|llout-sibling-index|llout-snug-back|llout-solicit-alternate-bullet|llout-stringify-flat-index-indented|llout-stringify-flat-index-plain|llout-stringify-flat-index|llout-substring-no-properties|llout-test-range-overlaps|llout-test-resumptions|llout-tests-obliterate-variable|llout-this-or-next-heading|llout-toggle-current-subtree-encryption|llout-toggle-current-subtree-exposure|llout-toggle-subtree-encryption|llout-topic-flat-index|llout-unload-function|llout-unprotected|llout-up-current-level|llout-version|llout-widgetize-buffer|llout-widgets-additions-processor|llout-widgets-additions-recorder|llout-widgets-adjusting-message|llout-widgets-after-change-handler|llout-widgets-after-copy-or-kill-function|llout-widgets-after-undo-function|llout-widgets-before-change-handler|llout-widgets-changes-dispatcher|llout-widgets-copy-list|llout-widgets-count-buttons-in-region|llout-widgets-deletions-processor|llout-widgets-deletions-recorder|llout-widgets-exposure-change-processor|llout-widgets-exposure-change-recorder|llout-widgets-exposure-undo-processor|llout-widgets-exposure-undo-recorder|llout-widgets-hook-error-handler|llout-widgets-mode-disable|llout-widgets-mode-enable|llout-widgets-mode-off|llout-widgets-mode-on|llout-widgets-mode|llout-widgets-post-command-business|llout-widgets-pre-command-business|llout-widgets-prepopulate-buffer|llout-widgets-run-unit-tests|llout-widgets-setup|llout-widgets-shifts-processor|llout-widgets-shifts-recorder|llout-widgets-tally-string|llout-widgets-undecorate-item|llout-widgets-undecorate-region|llout-widgets-undecorate-text|llout-widgets-version|llout-write-contents-hook-handler|llout-yank-pop|llout-yank-processing|llout-yank|lter-text-property|nge-ftp-abbreviate-filename|nge-ftp-add-bs2000-host|nge-ftp-add-bs2000-posix-host|nge-ftp-add-cms-host|nge-ftp-add-dl-dir|nge-ftp-add-dumb-unix-host|nge-ftp-add-file-entry|nge-ftp-add-mts-host|nge-ftp-add-vms-host|nge-ftp-allow-child-lookup|nge-ftp-barf-if-not-directory|nge-ftp-barf-or-query-if-file-exists|nge-ftp-binary-file|nge-ftp-bs2000-cd-to-posix|nge-ftp-bs2000-host|nge-ftp-bs2000-posix-host|nge-ftp-call-chmod|nge-ftp-call-cont|nge-ftp-canonize-filename|nge-ftp-cd|nge-ftp-cf1|nge-ftp-cf2|nge-ftp-chase-symlinks|nge-ftp-cms-host|nge-ftp-cms-make-compressed-filename|nge-ftp-completion-hook-function|nge-ftp-compress|nge-ftp-copy-file-internal|nge-ftp-copy-file|nge-ftp-copy-files-async|nge-ftp-del-tmp-name|nge-ftp-delete-directory|nge-ftp-delete-file-entry|nge-ftp-delete-file|nge-ftp-directory-file-name|nge-ftp-directory-files-and-attributes|nge-ftp-directory-files|nge-ftp-dired-compress-file|nge-ftp-dired-uncache|nge-ftp-dl-parser|nge-ftp-dumb-unix-host|nge-ftp-error|nge-ftp-expand-dir|nge-ftp-expand-file-name|nge-ftp-expand-symlink|nge-ftp-file-attributes|nge-ftp-file-directory-p|nge-ftp-file-entry-not-ignored-p|nge-ftp-file-entry-p|nge-ftp-file-executable-p|nge-ftp-file-exists-p|nge-ftp-file-local-copy|nge-ftp-file-modtime|nge-ftp-file-name-all-completions|nge-ftp-file-name-as-directory|nge-ftp-file-name-completion-1|nge-ftp-file-name-completion|nge-ftp-file-name-directory|nge-ftp-file-name-nondirectory|nge-ftp-file-name-sans-versions)(?=[()\\\\s]|$)"},{"match":"(?<=[()]|^)a(?:nge-ftp-file-newer-than-file-p|nge-ftp-file-readable-p|nge-ftp-file-remote-p|nge-ftp-file-size|nge-ftp-file-symlink-p|nge-ftp-file-writable-p|nge-ftp-find-backup-file-name|nge-ftp-fix-dir-name-for-bs2000|nge-ftp-fix-dir-name-for-cms|nge-ftp-fix-dir-name-for-mts|nge-ftp-fix-dir-name-for-vms|nge-ftp-fix-name-for-bs2000|nge-ftp-fix-name-for-cms|nge-ftp-fix-name-for-mts|nge-ftp-fix-name-for-vms|nge-ftp-ftp-name-component|nge-ftp-ftp-name|nge-ftp-ftp-process-buffer|nge-ftp-generate-passwd-key|nge-ftp-generate-root-prefixes|nge-ftp-get-account|nge-ftp-get-file-entry|nge-ftp-get-file-part|nge-ftp-get-files|nge-ftp-get-host-with-passwd|nge-ftp-get-passwd|nge-ftp-get-process|nge-ftp-get-pwd|nge-ftp-get-user|nge-ftp-guess-hash-mark-size|nge-ftp-guess-host-type|nge-ftp-gwp-filter|nge-ftp-gwp-sentinel|nge-ftp-gwp-start|nge-ftp-hash-entry-exists-p|nge-ftp-hash-table-keys|nge-ftp-hook-function|nge-ftp-host-type|nge-ftp-ignore-errors-if-non-essential|nge-ftp-insert-directory|nge-ftp-insert-file-contents|nge-ftp-internal-add-file-entry|nge-ftp-internal-delete-file-entry|nge-ftp-kill-ftp-process|nge-ftp-load|nge-ftp-lookup-passwd|nge-ftp-ls-parser|nge-ftp-ls|nge-ftp-make-directory|nge-ftp-make-tmp-name|nge-ftp-message|nge-ftp-mts-host|nge-ftp-normal-login|nge-ftp-nslookup-host|nge-ftp-parse-bs2000-filename|nge-ftp-parse-bs2000-listing|nge-ftp-parse-cms-listing|nge-ftp-parse-dired-listing|nge-ftp-parse-filename|nge-ftp-parse-mts-listing|nge-ftp-parse-netrc-group|nge-ftp-parse-netrc-token|nge-ftp-parse-netrc|nge-ftp-parse-vms-filename|nge-ftp-parse-vms-listing|nge-ftp-passive-mode|nge-ftp-process-file|nge-ftp-process-filter|nge-ftp-process-handle-hash|nge-ftp-process-handle-line|nge-ftp-process-sentinel|nge-ftp-quote-string|nge-ftp-raw-send-cmd|nge-ftp-re-read-dir|nge-ftp-real-backup-buffer|nge-ftp-real-copy-file|nge-ftp-real-delete-directory|nge-ftp-real-delete-file|nge-ftp-real-directory-file-name|nge-ftp-real-directory-files-and-attributes|nge-ftp-real-directory-files|nge-ftp-real-expand-file-name|nge-ftp-real-file-attributes|nge-ftp-real-file-directory-p|nge-ftp-real-file-executable-p|nge-ftp-real-file-exists-p|nge-ftp-real-file-name-all-completions|nge-ftp-real-file-name-as-directory|nge-ftp-real-file-name-completion|nge-ftp-real-file-name-directory|nge-ftp-real-file-name-nondirectory|nge-ftp-real-file-name-sans-versions|nge-ftp-real-file-newer-than-file-p|nge-ftp-real-file-readable-p|nge-ftp-real-file-symlink-p|nge-ftp-real-file-writable-p|nge-ftp-real-find-backup-file-name|nge-ftp-real-insert-directory|nge-ftp-real-insert-file-contents|nge-ftp-real-load|nge-ftp-real-make-directory|nge-ftp-real-rename-file|nge-ftp-real-shell-command|nge-ftp-real-verify-visited-file-modtime|nge-ftp-real-write-region|nge-ftp-rename-file|nge-ftp-rename-local-to-remote|nge-ftp-rename-remote-to-local|nge-ftp-rename-remote-to-remote|nge-ftp-repaint-minibuffer|nge-ftp-replace-name-component|nge-ftp-reread-dir|nge-ftp-root-dir-p|nge-ftp-run-real-handler-orig|nge-ftp-run-real-handler|nge-ftp-send-cmd|nge-ftp-set-account|nge-ftp-set-ascii-mode|nge-ftp-set-binary-mode|nge-ftp-set-buffer-mode|nge-ftp-set-file-modes|nge-ftp-set-files|nge-ftp-set-passwd|nge-ftp-set-user|nge-ftp-set-xfer-size|nge-ftp-shell-command|nge-ftp-smart-login|nge-ftp-start-process|nge-ftp-switches-ok|nge-ftp-uncompress|nge-ftp-unhandled-file-name-directory|nge-ftp-use-gateway-p|nge-ftp-use-smart-gateway-p|nge-ftp-verify-visited-file-modtime|nge-ftp-vms-add-file-entry|nge-ftp-vms-delete-file-entry|nge-ftp-vms-file-name-as-directory|nge-ftp-vms-host|nge-ftp-vms-make-compressed-filename|nge-ftp-vms-sans-version|nge-ftp-wait-not-busy|nge-ftp-wipe-file-entries|nge-ftp-write-region|nimate-birthday-present|nimate-initialize|nimate-place-char|nimate-sequence|nimate-step|nimate-string|nother-calc|nsi-color--find-face|nsi-color-apply-on-region|nsi-color-apply-overlay-face|nsi-color-apply-sequence|nsi-color-apply|nsi-color-filter-apply|nsi-color-filter-region|nsi-color-for-comint-mode-filter|nsi-color-for-comint-mode-off|nsi-color-for-comint-mode-on|nsi-color-freeze-overlay|nsi-color-get-face-1|nsi-color-make-color-map|nsi-color-make-extent|nsi-color-make-face|nsi-color-map-update|nsi-color-parse-sequence|nsi-color-process-output|nsi-color-set-extent-face|nsi-color-unfontify-region|nsi-term|ntlr-beginning-of-body|ntlr-beginning-of-rule|ntlr-c\\\\+\\\\+-mode-extra|ntlr-c-forward-sws|ntlr-c-init-language-vars|ntlr-default-directory|ntlr-directory-dependencies|ntlr-downcase-literals|ntlr-electric-character|ntlr-end-of-body|ntlr-end-of-rule|ntlr-file-dependencies|ntlr-font-lock-keywords|ntlr-grammar-tokens|ntlr-hide-actions|ntlr-imenu-create-index-function|ntlr-indent-command|ntlr-indent-line|ntlr-insert-makefile-rules|ntlr-insert-option-area|ntlr-insert-option-do|ntlr-insert-option-existing|ntlr-insert-option-interactive|ntlr-insert-option-space|ntlr-insert-option|ntlr-inside-rule-p|ntlr-invalidate-context-cache|ntlr-language-option-extra|ntlr-language-option|ntlr-makefile-insert-variable|ntlr-mode-menu|ntlr-mode|ntlr-next-rule|ntlr-option-kind|ntlr-option-level|ntlr-option-location|ntlr-option-spec|ntlr-options-menu-filter|ntlr-outside-rule-p|ntlr-re-search-forward|ntlr-read-boolean|ntlr-read-shell-command|ntlr-read-value|ntlr-run-tool-interactive|ntlr-run-tool|ntlr-search-backward|ntlr-search-forward|ntlr-set-tabs|ntlr-show-makefile-rules|ntlr-skip-exception-part|ntlr-skip-file-prelude|ntlr-skip-sexps|ntlr-superclasses-glibs|ntlr-syntactic-context|ntlr-syntactic-grammar-depth|ntlr-upcase-literals|ntlr-upcase-p|ntlr-version-string|ntlr-with-displaying-help-buffer|ntlr-with-syntax-table|ppend-next-kill|ppend-to-buffer|ppend-to-register|pply-macro-to-region-lines|pply-on-rectangle|ppt-activate|ppt-add|propos-command|propos-documentation-property|propos-documentation|propos-internal|propos-library|propos-read-pattern|propos-user-option|propos-value|propos-variable|rchive-\\\\*-expunge|rchive-\\\\*-extract|rchive-\\\\*-write-file-member|rchive-7z-extract|rchive-7z-summarize|rchive-7z-write-file-member|rchive-add-new-member|rchive-alternate-display|rchive-ar-extract|rchive-ar-summarize|rchive-arc-rename-entry|rchive-arc-summarize|rchive-calc-mode|rchive-chgrp-entry|rchive-chmod-entry|rchive-chown-entry|rchive-delete-local|rchive-desummarize|rchive-display-other-window|rchive-dosdate|rchive-dostime|rchive-expunge|rchive-extract-by-file|rchive-extract-by-stdout|rchive-extract-other-window|rchive-extract|rchive-file-name-handler|rchive-find-type|rchive-flag-deleted|rchive-get-descr|rchive-get-lineno|rchive-get-marked|rchive-int-to-mode|rchive-l-e|rchive-lzh-chgrp-entry|rchive-lzh-chmod-entry|rchive-lzh-chown-entry|rchive-lzh-exe-extract|rchive-lzh-exe-summarize|rchive-lzh-extract|rchive-lzh-ogm|rchive-lzh-rename-entry|rchive-lzh-resum|rchive-lzh-summarize|rchive-mark|rchive-maybe-copy|rchive-maybe-update|rchive-mode-revert|rchive-mode|rchive-mouse-extract|rchive-name|rchive-next-line|rchive-previous-line|rchive-rar-exe-extract|rchive-rar-exe-summarize|rchive-rar-extract|rchive-rar-summarize|rchive-rename-entry|rchive-resummarize|rchive-set-buffer-as-visiting-file|rchive-summarize-files|rchive-summarize|rchive-try-jka-compr|rchive-undo|rchive-unflag-backwards|rchive-unflag|rchive-unique-fname|rchive-unixdate|rchive-unixtime|rchive-unmark-all-files|rchive-view|rchive-write-file-member|rchive-write-file|rchive-zip-chmod-entry|rchive-zip-extract|rchive-zip-summarize|rchive-zip-write-file-member|rchive-zoo-extract|rchive-zoo-summarize|rp|rray-backward-column|rray-beginning-of-field|rray-copy-backward|rray-copy-column-backward|rray-copy-column-forward|rray-copy-down|rray-copy-forward|rray-copy-once-horizontally|rray-copy-once-vertically|rray-copy-row-down|rray-copy-row-up|rray-copy-to-cell|rray-copy-to-column|rray-copy-to-row|rray-copy-up|rray-current-column|rray-current-row|rray-cursor-in-array-range|rray-display-local-variables|rray-end-of-field|rray-expand-rows|rray-field-string|rray-fill-rectangle|rray-forward-column|rray-goto-cell|rray-make-template|rray-maybe-scroll-horizontally|rray-mode|rray-move-one-column|rray-move-one-row|rray-move-to-cell|rray-move-to-column|rray-move-to-row|rray-next-row|rray-normalize-cursor|rray-previous-row|rray-reconfigure-rows|rray-update-array-position|rray-update-buffer-position|rray-what-position|rtist-2point-get-endpoint1|rtist-2point-get-endpoint2|rtist-2point-get-shapeinfo|rtist-arrow-point-get-direction|rtist-arrow-point-get-marker|rtist-arrow-point-get-orig-char|rtist-arrow-point-get-state|rtist-arrow-point-set-state|rtist-arrows|rtist-backward-char|rtist-calculate-new-chars??|rtist-charlist-to-string|rtist-clear-arrow-points|rtist-clear-buffer|rtist-compute-key-compl-table|rtist-compute-line-char|rtist-compute-popup-menu-table-sub|rtist-compute-popup-menu-table|rtist-compute-up-event-key|rtist-coord-add-new-char|rtist-coord-add-saved-char|rtist-coord-get-new-char|rtist-coord-get-saved-char|rtist-coord-get-x|rtist-coord-get-y|rtist-coord-set-new-char|rtist-coord-set-x|rtist-coord-set-y|rtist-coord-win-to-buf|rtist-copy-generic|rtist-copy-rect|rtist-copy-square|rtist-current-column|rtist-current-line|rtist-cut-rect|rtist-cut-square|rtist-direction-char|rtist-direction-step-x|rtist-direction-step-y|rtist-do-nothing|rtist-down-mouse-1|rtist-down-mouse-3|rtist-draw-circle|rtist-draw-ellipse-general|rtist-draw-ellipse-with-0-height|rtist-draw-ellipse|rtist-draw-line|rtist-draw-rect|rtist-draw-region-reset|rtist-draw-region-trim-line-endings|rtist-draw-sline|rtist-draw-square|rtist-eight-point|rtist-ellipse-compute-fill-info|rtist-ellipse-fill-info-add-center|rtist-ellipse-generate-quadrant|rtist-ellipse-mirror-quadrant|rtist-ellipse-point-list-add-center|rtist-ellipse-remove-0-fills|rtist-endpoint-get-x|rtist-endpoint-get-y|rtist-erase-char|rtist-erase-rect|rtist-event-is-shifted|rtist-fc-get-fn-from-symbol|rtist-fc-get-fn|rtist-fc-get-keyword|rtist-fc-get-symbol|rtist-fc-retrieve-from-symbol-sub|rtist-fc-retrieve-from-symbol|rtist-ff-get-rightmost-from-xy|rtist-ff-is-bottommost-line|rtist-ff-is-topmost-line|rtist-ff-too-far-right|rtist-figlet-choose-font|rtist-figlet-get-extra-args|rtist-figlet-get-font-list|rtist-figlet-run|rtist-figlet|rtist-file-to-string|rtist-fill-circle|rtist-fill-ellipse|rtist-fill-item-get-width|rtist-fill-item-get-x|rtist-fill-item-get-y|rtist-fill-item-set-width|rtist-fill-item-set-x|rtist-fill-item-set-y|rtist-fill-rect|rtist-fill-square|rtist-find-direction|rtist-find-octant|rtist-flood-fill|rtist-forward-char|rtist-funcall|rtist-get-buffer-contents-at-xy|rtist-get-char-at-xy-conv|rtist-get-char-at-xy|rtist-get-dfdx-init-coeff|rtist-get-dfdy-init-coeff|rtist-get-first-non-nil-op|rtist-get-last-non-nil-op|rtist-get-replacement-char|rtist-get-x-step-q<0|rtist-get-x-step-q>=0|rtist-get-y-step-q<0|rtist-get-y-step-q>=0|rtist-go-get-arrow-pred-from-symbol|rtist-go-get-arrow-pred|rtist-go-get-arrow-set-fn-from-symbol|rtist-go-get-arrow-set-fn|rtist-go-get-desc|rtist-go-get-draw-fn-from-symbol|rtist-go-get-draw-fn|rtist-go-get-draw-how-from-symbol|rtist-go-get-draw-how|rtist-go-get-exit-fn-from-symbol|rtist-go-get-exit-fn|rtist-go-get-fill-fn-from-symbol|rtist-go-get-fill-fn|rtist-go-get-fill-pred-from-symbol|rtist-go-get-fill-pred|rtist-go-get-init-fn-from-symbol|rtist-go-get-init-fn|rtist-go-get-interval-fn-from-symbol|rtist-go-get-interval-fn|rtist-go-get-keyword-from-symbol|rtist-go-get-keyword|rtist-go-get-mode-line-from-symbol|rtist-go-get-mode-line|rtist-go-get-prep-fill-fn-from-symbol|rtist-go-get-prep-fill-fn|rtist-go-get-shifted|rtist-go-get-symbol-shift-sub|rtist-go-get-symbol-shift|rtist-go-get-symbol|rtist-go-get-undraw-fn-from-symbol|rtist-go-get-undraw-fn|rtist-go-get-unshifted|rtist-go-retrieve-from-symbol-sub|rtist-go-retrieve-from-symbol|rtist-intersection-char|rtist-is-in-op-list-p|rtist-key-do-continously-1point|rtist-key-do-continously-2points|rtist-key-do-continously-common)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(?:artist-key-do-continously-continously|artist-key-do-continously-poly|artist-key-draw-1point|artist-key-draw-2points|artist-key-draw-common|artist-key-draw-continously|artist-key-draw-poly|artist-key-set-point-1point|artist-key-set-point-2points|artist-key-set-point-common|artist-key-set-point-continously|artist-key-set-point-poly|artist-key-set-point|artist-key-undraw-1point|artist-key-undraw-2points|artist-key-undraw-common|artist-key-undraw-continously|artist-key-undraw-poly|artist-make-2point-object|artist-make-arrow-point|artist-make-endpoint|artist-make-prev-next-op-alist|artist-mn-get-items|artist-mn-get-title|artist-mode-exit|artist-mode-init|artist-mode-line-show-curr-operation|artist-mode-off|artist-mode|artist-modify-new-chars|artist-mouse-choose-operation|artist-mouse-draw-1point|artist-mouse-draw-2points|artist-mouse-draw-continously|artist-mouse-draw-poly|artist-move-to-xy|artist-mt-get-info-part|artist-mt-get-symbol-from-keyword-sub|artist-mt-get-symbol-from-keyword|artist-mt-get-tag|artist-new-coord|artist-new-fill-item|artist-next-line|artist-nil|artist-no-arrows|artist-no-rb-set-point1|artist-no-rb-set-point2|artist-no-rb-unset-point1|artist-no-rb-unset-point2|artist-no-rb-unset-points|artist-paste|artist-pen-line|artist-pen-reset-last-xy|artist-pen-set-arrow-points|artist-pen|artist-previous-line|artist-put-pixel|artist-rect-corners-squarify|artist-replace-chars??|artist-replace-string|artist-save-chars-under-point-list|artist-save-chars-under-sline|artist-select-erase-char|artist-select-fill-char|artist-select-line-char|artist-select-next-op-in-list|artist-select-op-circle|artist-select-op-copy-rectangle|artist-select-op-copy-square|artist-select-op-cut-rectangle|artist-select-op-cut-square|artist-select-op-ellipse|artist-select-op-erase-char|artist-select-op-erase-rectangle|artist-select-op-flood-fill|artist-select-op-line|artist-select-op-paste|artist-select-op-pen-line|artist-select-op-poly-line|artist-select-op-rectangle|artist-select-op-spray-can|artist-select-op-spray-set-size|artist-select-op-square|artist-select-op-straight-line|artist-select-op-straight-poly-line|artist-select-op-text-overwrite|artist-select-op-text-see-thru|artist-select-op-vaporize-lines??|artist-select-operation|artist-select-prev-op-in-list|artist-select-spray-chars|artist-set-arrow-points-for-2points|artist-set-arrow-points-for-poly|artist-set-pointer-shape|artist-shift-has-changed|artist-sline|artist-spray-clear-circle|artist-spray-get-interval|artist-spray-random-points|artist-spray-set-radius|artist-spray|artist-straight-calculate-length|artist-string-split|artist-string-to-charlist|artist-string-to-file|artist-submit-bug-report|artist-system|artist-t-if-fill-char-set|artist-t|artist-text-insert-common|artist-text-insert-overwrite|artist-text-insert-see-thru|artist-text-overwrite|artist-text-see-thru|artist-toggle-borderless-shapes|artist-toggle-first-arrow|artist-toggle-rubber-banding|artist-toggle-second-arrow|artist-toggle-trim-line-endings|artist-undraw-circle|artist-undraw-ellipse|artist-undraw-line|artist-undraw-rect|artist-undraw-sline|artist-undraw-square|artist-unintersection-char|artist-uniq|artist-update-display|artist-update-pointer-shape|artist-vap-find-endpoint|artist-vap-find-endpoints-horiz|artist-vap-find-endpoints-nwse|artist-vap-find-endpoints-swne|artist-vap-find-endpoints-vert|artist-vap-find-endpoints|artist-vap-group-in-pairs|artist-vaporize-by-endpoints|artist-vaporize-lines??|asm-calculate-indentation|asm-colon|asm-comment|asm-indent-line|asm-mode|asm-newline|assert|assoc\\\\*|assoc-if-not|assoc-if|assoc-ignore-case|assoc-ignore-representation|async-shell-command|atomic-change-group|auth-source--aget|auth-source--aput-1|auth-source--aput|auth-source-backend-child-p|auth-source-backend-list-p|auth-source-backend-p|auth-source-backend-parse-parameters|auth-source-backend-parse|auth-source-backend|auth-source-current-line|auth-source-delete|auth-source-do-debug|auth-source-do-trivia|auth-source-do-warn|auth-source-ensure-strings|auth-source-epa-extract-gpg-token|auth-source-epa-make-gpg-token|auth-source-forget\\\\+|auth-source-forget-all-cached|auth-source-forget|auth-source-format-cache-entry|auth-source-format-prompt|auth-source-macos-keychain-create|auth-source-macos-keychain-result-append|auth-source-macos-keychain-search-items|auth-source-macos-keychain-search|auth-source-netrc-create|auth-source-netrc-element-or-first|auth-source-netrc-normalize|auth-source-netrc-parse-entries|auth-source-netrc-parse-next-interesting|auth-source-netrc-parse-one|auth-source-netrc-parse|auth-source-netrc-saver|auth-source-netrc-search|auth-source-pick-first-password|auth-source-plstore-create|auth-source-plstore-search|auth-source-read-char-choice|auth-source-recall|auth-source-remember|auth-source-remembered-p|auth-source-search-backends|auth-source-search-collection|auth-source-search|auth-source-secrets-create|auth-source-secrets-listify-pattern|auth-source-secrets-search|auth-source-specmatchp|auth-source-token-passphrase-callback-function|auth-source-user-and-password|auth-source-user-or-password|auto-coding-alist-lookup|auto-coding-regexp-alist-lookup|auto-compose-chars|auto-composition-mode|auto-compression-mode|auto-encryption-mode|auto-fill-mode|auto-image-file-mode|auto-insert-mode|auto-insert|auto-lower-mode|auto-raise-mode|auto-revert-active-p|auto-revert-buffers|auto-revert-handler|auto-revert-mode|auto-revert-notify-add-watch|auto-revert-notify-handler|auto-revert-notify-rm-watch|auto-revert-set-timer|auto-revert-tail-handler|auto-revert-tail-mode|autoarg-kp-digit-argument|autoarg-kp-mode|autoarg-mode|autoarg-terminate|autoconf-current-defun-function|autoconf-mode|autodoc-font-lock-keywords|autodoc-font-lock-line-markup|autoload-coding-system|autoload-rubric|avl-tree--check-node|avl-tree--check|avl-tree--cmpfun--cmacro|avl-tree--cmpfun|avl-tree--create--cmacro|avl-tree--create|avl-tree--del-balance|avl-tree--dir-to-sign|avl-tree--do-copy|avl-tree--do-del-internal|avl-tree--do-delete|avl-tree--do-enter|avl-tree--dummyroot--cmacro|avl-tree--dummyroot|avl-tree--enter-balance|avl-tree--mapc|avl-tree--node-balance--cmacro|avl-tree--node-balance|avl-tree--node-branch|avl-tree--node-create--cmacro|avl-tree--node-create|avl-tree--node-data--cmacro|avl-tree--node-data|avl-tree--node-left--cmacro|avl-tree--node-left|avl-tree--node-right--cmacro|avl-tree--node-right|avl-tree--root|avl-tree--sign-to-dir|avl-tree--stack-create|avl-tree--stack-p--cmacro|avl-tree--stack-p|avl-tree--stack-repopulate|avl-tree--stack-reverse--cmacro|avl-tree--stack-reverse|avl-tree--stack-store--cmacro|avl-tree--stack-store|avl-tree--switch-dir|avl-tree-clear|avl-tree-compare-function|avl-tree-copy|avl-tree-create|avl-tree-delete|avl-tree-empty|avl-tree-enter|avl-tree-first|avl-tree-flatten|avl-tree-last|avl-tree-mapc??|avl-tree-mapcar|avl-tree-mapf|avl-tree-member-p|avl-tree-member|avl-tree-p--cmacro|avl-tree-p|avl-tree-size|avl-tree-stack-empty-p|avl-tree-stack-first|avl-tree-stack-p|avl-tree-stack-pop|avl-tree-stack|awk-mode|babel-as-string|background-color-at-point|backquote-delay-process|backquote-list\\\\*-function|backquote-list\\\\*-macro|backquote-list\\\\*|backquote-listify|backquote-process|backquote|backtrace--locals|backtrace-eval|backup-buffer-copy|backup-extract-version|backward-delete-char|backward-ifdef|backward-kill-paragraph|backward-kill-sentence|backward-kill-sexp|backward-kill-word|backward-page|backward-paragraph|backward-sentence|backward-text-line|backward-up-list|bad-package-check|balance-windows-1|balance-windows-2|balance-windows-area-adjust|basic-save-buffer-1|basic-save-buffer-2|basic-save-buffer|bat-cmd-help|bat-mode|bat-run-args|bat-run|bat-template|batch-byte-compile-file|batch-byte-compile-if-not-done|batch-byte-recompile-directory|batch-info-validate|batch-texinfo-format|batch-titdic-convert|batch-unrmail|batch-update-autoloads|battery-bsd-apm|battery-format|battery-linux-proc-acpi|battery-linux-proc-apm|battery-linux-sysfs|battery-pmset|battery-search-for-one-match-in-files|battery-update-handler|battery-update|battery|bb-bol|bb-done|bb-down|bb-eol|bb-goto|bb-init-board|bb-insert-board|bb-left|bb-outside-box|bb-place-ball|bb-right|bb-romp|bb-show-bogus-balls-2|bb-show-bogus-balls|bb-trace-ray-2|bb-trace-ray|bb-up|bb-update-board|beginning-of-buffer-other-window|beginning-of-defun-raw|beginning-of-icon-defun|beginning-of-line-text|beginning-of-sexp|beginning-of-thing|beginning-of-visual-line|benchmark-elapse|benchmark-run-compiled|benchmark-run|benchmark|bib-capitalize-title-region|bib-capitalize-title|bib-find-key|bib-mode|bibtex-Article|bibtex-Book|bibtex-BookInBook|bibtex-Booklet|bibtex-Collection|bibtex-InBook|bibtex-InCollection|bibtex-InProceedings|bibtex-InReference|bibtex-MVBook|bibtex-MVCollection|bibtex-MVProceedings|bibtex-MVReference|bibtex-Manual|bibtex-MastersThesis|bibtex-Misc|bibtex-Online|bibtex-Patent|bibtex-Periodical|bibtex-PhdThesis|bibtex-Preamble|bibtex-Proceedings|bibtex-Reference|bibtex-Report|bibtex-String|bibtex-SuppBook|bibtex-SuppCollection|bibtex-SuppPeriodical|bibtex-TechReport|bibtex-Thesis|bibtex-Unpublished|bibtex-autofill-entry|bibtex-autokey-abbrev|bibtex-autokey-demangle-name|bibtex-autokey-demangle-title|bibtex-autokey-get-field|bibtex-autokey-get-names|bibtex-autokey-get-title|bibtex-autokey-get-year|bibtex-beginning-first-field|bibtex-beginning-of-entry|bibtex-beginning-of-field|bibtex-beginning-of-first-entry|bibtex-button-action|bibtex-button|bibtex-clean-entry|bibtex-complete-crossref-cleanup|bibtex-complete-string-cleanup|bibtex-complete|bibtex-completion-at-point-function|bibtex-convert-alien|bibtex-copy-entry-as-kill|bibtex-copy-field-as-kill|bibtex-copy-summary-as-kill|bibtex-count-entries|bibtex-current-line|bibtex-delete-whitespace|bibtex-display-entries|bibtex-dist|bibtex-edit-menu|bibtex-empty-field|bibtex-enclosing-field|bibtex-end-of-entry|bibtex-end-of-field|bibtex-end-of-name-in-field|bibtex-end-of-string|bibtex-end-of-text-in-field|bibtex-end-of-text-in-string|bibtex-entry-alist|bibtex-entry-index|bibtex-entry-left-delimiter|bibtex-entry-right-delimiter|bibtex-entry-update|bibtex-entry|bibtex-field-left-delimiter|bibtex-field-list|bibtex-field-re-init|bibtex-field-right-delimiter|bibtex-fill-entry|bibtex-fill-field-bounds|bibtex-fill-field|bibtex-find-crossref|bibtex-find-entry|bibtex-find-text-internal|bibtex-find-text|bibtex-flash-head|bibtex-font-lock-cite|bibtex-font-lock-crossref|bibtex-font-lock-url|bibtex-format-entry|bibtex-generate-autokey|bibtex-global-key-alist|bibtex-goto-line|bibtex-init-sort-entry-class-alist|bibtex-initialize|bibtex-insert-kill|bibtex-ispell-abstract|bibtex-ispell-entry|bibtex-key-in-head|bibtex-kill-entry|bibtex-kill-field|bibtex-lessp|bibtex-make-field|bibtex-make-optional-field|bibtex-map-entries|bibtex-mark-entry|bibtex-mode|bibtex-move-outside-of-entry|bibtex-name-in-field|bibtex-narrow-to-entry|bibtex-next-field|bibtex-parse-association|bibtex-parse-buffers-stealthily|bibtex-parse-entry|bibtex-parse-field-name|bibtex-parse-field-string|bibtex-parse-field-text|bibtex-parse-field|bibtex-parse-keys|bibtex-parse-preamble|bibtex-parse-string-postfix|bibtex-parse-string-prefix|bibtex-parse-strings??|bibtex-pop-next|bibtex-pop-previous|bibtex-pop|bibtex-prepare-new-entry|bibtex-print-help-message|bibtex-progress-message|bibtex-read-key|bibtex-read-string-key|bibtex-realign|bibtex-reference-key-in-string|bibtex-reformat|bibtex-remove-OPT-or-ALT|bibtex-remove-delimiters|bibtex-reposition-window|bibtex-search-backward-field|bibtex-search-crossref|bibtex-search-entries|bibtex-search-entry|bibtex-search-forward-field|bibtex-search-forward-string|bibtex-set-dialect|bibtex-skip-to-valid-entry|bibtex-sort-buffer|bibtex-start-of-field|bibtex-start-of-name-in-field|bibtex-start-of-text-in-field|bibtex-start-of-text-in-string|bibtex-string-files-init|bibtex-string=|bibtex-strings|bibtex-style-calculate-indentation|bibtex-style-indent-line|bibtex-style-mode|bibtex-summary|bibtex-text-in-field-bounds|bibtex-text-in-field|bibtex-text-in-string|bibtex-type-in-head|bibtex-url|bibtex-valid-entry|bibtex-validate-globally|bibtex-validate|bibtex-vec-incr|bibtex-vec-push|bibtex-yank-pop|bibtex-yank|bidi-find-overridden-directionality)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)b(?:idi-resolved-levels|inary-overwrite-mode|indat--length-group|indat--pack-group|indat--pack-item|indat--pack-u16r??|indat--pack-u24r??|indat--pack-u32r??|indat--pack-u8|indat--unpack-group|indat--unpack-item|indat--unpack-u16r??|indat--unpack-u24r??|indat--unpack-u32r??|indat--unpack-u8|indat-format-vector|indat-vector-to-dec|indat-vector-to-hex|indings--define-key|inhex-char-int|inhex-char-map|inhex-decode-region-external|inhex-decode-region-internal|inhex-decode-region|inhex-header|inhex-insert-char|inhex-push-char|inhex-string-big-endian|inhex-string-little-endian|inhex-update-crc|inhex-verify-crc|lackbox-mode|lackbox-redefine-key|lackbox|link-cursor-check|link-cursor-end|link-cursor-mode|link-cursor-start|link-cursor-suspend|link-cursor-timer-function|link-matching-check-mismatch|link-paren-post-self-insert-function|lock|ookmark--jump-via|ookmark-alist-from-buffer|ookmark-all-names|ookmark-bmenu-1-window|ookmark-bmenu-2-window|ookmark-bmenu-any-marks|ookmark-bmenu-backup-unmark|ookmark-bmenu-bookmark|ookmark-bmenu-delete-backwards|ookmark-bmenu-delete|ookmark-bmenu-edit-annotation|ookmark-bmenu-ensure-position|ookmark-bmenu-execute-deletions|ookmark-bmenu-filter-alist-by-regexp|ookmark-bmenu-goto-bookmark|ookmark-bmenu-hide-filenames|ookmark-bmenu-list|ookmark-bmenu-load|ookmark-bmenu-locate|ookmark-bmenu-mark|ookmark-bmenu-mode|ookmark-bmenu-other-window-with-mouse|ookmark-bmenu-other-window|ookmark-bmenu-relocate|ookmark-bmenu-rename|ookmark-bmenu-save|ookmark-bmenu-search|ookmark-bmenu-select|ookmark-bmenu-set-header|ookmark-bmenu-show-all-annotations|ookmark-bmenu-show-annotation|ookmark-bmenu-show-filenames|ookmark-bmenu-surreptitiously-rebuild-list|ookmark-bmenu-switch-other-window|ookmark-bmenu-this-window|ookmark-bmenu-toggle-filenames|ookmark-bmenu-unmark|ookmark-buffer-file-name|ookmark-buffer-name|ookmark-completing-read|ookmark-default-annotation-text|ookmark-default-handler|ookmark-delete|ookmark-edit-annotation-mode|ookmark-edit-annotation|ookmark-exit-hook-internal|ookmark-get-annotation|ookmark-get-bookmark-record|ookmark-get-bookmark|ookmark-get-filename|ookmark-get-front-context-string|ookmark-get-handler|ookmark-get-position|ookmark-get-rear-context-string|ookmark-grok-file-format-version|ookmark-handle-bookmark|ookmark-import-new-list|ookmark-insert-annotation|ookmark-insert-file-format-version-stamp|ookmark-insert-location|ookmark-insert|ookmark-jump-noselect|ookmark-jump-other-window|ookmark-jump|ookmark-kill-line|ookmark-load|ookmark-locate|ookmark-location|ookmark-make-record-default|ookmark-make-record|ookmark-map|ookmark-maybe-historicize-string|ookmark-maybe-load-default-file|ookmark-maybe-message|ookmark-maybe-rename|ookmark-maybe-sort-alist|ookmark-maybe-upgrade-file-format|ookmark-menu-popup-paned-menu|ookmark-name-from-full-record|ookmark-prop-get|ookmark-prop-set|ookmark-relocate|ookmark-rename|ookmark-save|ookmark-send-edited-annotation|ookmark-set-annotation|ookmark-set-filename|ookmark-set-front-context-string|ookmark-set-name|ookmark-set-position|ookmark-set-rear-context-string|ookmark-set|ookmark-show-all-annotations|ookmark-show-annotation|ookmark-store|ookmark-time-to-save-p|ookmark-unload-function|ookmark-upgrade-file-format-from-0|ookmark-upgrade-version-0-alist|ookmark-write-file|ookmark-write|ookmark-yank-word|ool-vector|ound-and-true-p|ounds-of-thing-at-point|ovinate|ovine-grammar-mode|rowse-url-at-mouse|rowse-url-at-point|rowse-url-can-use-xdg-open|rowse-url-cci|rowse-url-chromium|rowse-url-default-browser|rowse-url-default-macosx-browser|rowse-url-default-windows-browser|rowse-url-delete-temp-file|rowse-url-elinks-new-window|rowse-url-elinks-sentinel|rowse-url-elinks|rowse-url-emacs-display|rowse-url-emacs|rowse-url-encode-url|rowse-url-epiphany-sentinel|rowse-url-epiphany|rowse-url-file-url|rowse-url-firefox-sentinel|rowse-url-firefox|rowse-url-galeon-sentinel|rowse-url-galeon|rowse-url-generic|rowse-url-gnome-moz|rowse-url-interactive-arg|rowse-url-kde|rowse-url-mail|rowse-url-maybe-new-window|rowse-url-mosaic|rowse-url-mozilla-sentinel|rowse-url-mozilla|rowse-url-netscape-reload|rowse-url-netscape-send|rowse-url-netscape-sentinel|rowse-url-netscape|rowse-url-of-buffer|rowse-url-of-dired-file|rowse-url-of-file|rowse-url-of-region|rowse-url-process-environment|rowse-url-text-emacs|rowse-url-text-xterm|rowse-url-url-at-point|rowse-url-url-encode-chars|rowse-url-w3-gnudoit|rowse-url-w3|rowse-url-xdg-open|rowse-url|rowse-web|s--configuration-name-for-prefix-arg|s--create-header-line|s--current-buffer|s--current-config-message|s--down|s--format-aux|s--get-file-name|s--get-marked-string|s--get-mode-name|s--get-modified-string|s--get-name-length|s--get-name|s--get-readonly-string|s--get-size-string|s--get-value|s--goto-current-buffer|s--insert-one-entry|s--make-header-match-string|s--mark-unmark|s--nth-wrapper|s--redisplay|s--remove-hooks|s--restore-window-config|s--set-toggle-to-show|s--set-window-height|s--show-config-message|s--show-header|s--show-with-configuration|s--sort-by-filename|s--sort-by-mode|s--sort-by-name|s--sort-by-size|s--track-window-changes|s--up|s--update-current-line|s-abort|s-apply-sort-faces|s-buffer-list|s-buffer-sort|s-bury-buffer|s-clear-modified|s-config--all-intern-last|s-config--all|s-config--files-and-scratch|s-config--only-files|s-config-clear|s-customize|s-cycle-next|s-cycle-previous|s-define-sort-function|s-delete-backward|s-delete|s-down|s-help|s-kill|s-mark-current|s-message-without-log|s-mode|s-mouse-select-other-frame|s-mouse-select|s-next-buffer|s-next-config-aux|s-next-config|s-previous-buffer|s-refresh|s-save|s-select-in-one-window|s-select-next-configuration|s-select-other-frame|s-select-other-window|s-select|s-set-configuration-and-refresh|s-set-configuration|s-set-current-buffer-to-show-always|s-set-current-buffer-to-show-never|s-show-in-buffer|s-show-sorted|s-show|s-sort-buffer-interns-are-last|s-tmp-select-other-window|s-toggle-current-to-show|s-toggle-readonly|s-toggle-show-all|s-unload-function|s-unmark-current|s-up|s-view|s-visit-tags-table|s-visits-non-file|ubbles--char-at|ubbles--col|ubbles--colors|ubbles--compute-offsets|ubbles--count|ubbles--empty-char|ubbles--game-over|ubbles--goto|ubbles--grid-height|ubbles--grid-width|ubbles--initialize-faces|ubbles--initialize-images|ubbles--initialize|ubbles--mark-direct-neighbors|ubbles--mark-neighborhood|ubbles--neighborhood-available|ubbles--remove-overlays|ubbles--reset-score|ubbles--row|ubbles--set-faces|ubbles--shift-mode|ubbles--shift|ubbles--show-images|ubbles--show-scores|ubbles--update-faces-or-images|ubbles--update-neighborhood-score|ubbles--update-score|ubbles-customize|ubbles-mode|ubbles-plop|ubbles-quit|ubbles-save-settings|ubbles-set-game-difficult|ubbles-set-game-easy|ubbles-set-game-hard|ubbles-set-game-medium|ubbles-set-game-userdefined|ubbles-set-graphics-theme-ascii|ubbles-set-graphics-theme-balls|ubbles-set-graphics-theme-circles|ubbles-set-graphics-theme-diamonds|ubbles-set-graphics-theme-emacs|ubbles-set-graphics-theme-squares|ubbles-undo|ubbles|uffer-face-mode-invoke|uffer-face-mode|uffer-face-set|uffer-face-toggle|uffer-has-markers-at|uffer-menu-open|uffer-menu-other-window|uffer-menu|uffer-stale--default-function|uffer-substring--filter|uffer-substring-with-bidi-context|ug-reference-fontify|ug-reference-mode|ug-reference-prog-mode|ug-reference-push-button|ug-reference-set-overlay-properties|ug-reference-unfontify|uild-mail-abbrevs|uild-mail-aliases|ury-buffer-internal|utterfly|utton--area-button-p|utton--area-button-string|utton-category-symbol|yte-code|yte-compile--declare-var|yte-compile--reify-function|yte-compile-abbreviate-file|yte-compile-and-folded|yte-compile-and-recursion|yte-compile-and|yte-compile-annotate-call-tree|yte-compile-arglist-signature-string|yte-compile-arglist-signature|yte-compile-arglist-signatures-congruent-p|yte-compile-arglist-vars|yte-compile-arglist-warn|yte-compile-associative|yte-compile-autoload|yte-compile-backward-char|yte-compile-backward-word|yte-compile-bind|yte-compile-body-do-effect|yte-compile-body|yte-compile-butlast|yte-compile-callargs-warn|yte-compile-catch|yte-compile-char-before|yte-compile-check-lambda-list|yte-compile-check-variable|yte-compile-cl-file-p|yte-compile-cl-warn|yte-compile-close-variables|yte-compile-concat|yte-compile-cond|yte-compile-condition-case--new|yte-compile-condition-case--old|yte-compile-condition-case|yte-compile-constant|yte-compile-constants-vector|yte-compile-defvar|yte-compile-delete-first|yte-compile-dest-file|yte-compile-disable-warning|yte-compile-discard|yte-compile-dynamic-variable-bind|yte-compile-dynamic-variable-op|yte-compile-enable-warning|yte-compile-eval-before-compile|yte-compile-eval|yte-compile-fdefinition|yte-compile-file-form-autoload|yte-compile-file-form-custom-declare-variable|yte-compile-file-form-defalias|yte-compile-file-form-define-abbrev-table|yte-compile-file-form-defmumble|yte-compile-file-form-defvar|yte-compile-file-form-eval|yte-compile-file-form-progn|yte-compile-file-form-require|yte-compile-file-form-with-no-warnings|yte-compile-file-form|yte-compile-find-bound-condition|yte-compile-find-cl-functions|yte-compile-fix-header|yte-compile-flush-pending|yte-compile-form-do-effect|yte-compile-form-make-variable-buffer-local|yte-compile-form|yte-compile-format-warn|yte-compile-from-buffer|yte-compile-fset|yte-compile-funcall|yte-compile-function-form|yte-compile-function-warn|yte-compile-get-closed-var|yte-compile-get-constant|yte-compile-goto-if|yte-compile-goto|yte-compile-if|yte-compile-indent-to|yte-compile-inline-expand|yte-compile-inline-lapcode|yte-compile-insert-header|yte-compile-insert|yte-compile-keep-pending|yte-compile-lambda-form|yte-compile-lambda|yte-compile-lapcode|yte-compile-let|yte-compile-list|yte-compile-log-1|yte-compile-log-file|yte-compile-log-lap-1|yte-compile-log-lap|yte-compile-log-warning|yte-compile-log|yte-compile-macroexpand-declare-function|yte-compile-make-args-desc|yte-compile-make-closure|yte-compile-make-lambda-lexenv|yte-compile-make-obsolete-variable|yte-compile-make-tag|yte-compile-make-variable-buffer-local|yte-compile-maybe-guarded|yte-compile-minus|yte-compile-nconc|yte-compile-negated|yte-compile-negation-optimizer|yte-compile-nilconstp|yte-compile-no-args|yte-compile-no-warnings|yte-compile-nogroup-warn|yte-compile-noop|yte-compile-normal-call|yte-compile-not-lexical-var-p|yte-compile-one-arg|yte-compile-one-or-two-args|yte-compile-or-recursion|yte-compile-or|yte-compile-out-tag|yte-compile-out-toplevel|yte-compile-out|yte-compile-output-as-comment|yte-compile-output-docform|yte-compile-output-file-form|yte-compile-preprocess|yte-compile-print-syms|yte-compile-prog1|yte-compile-prog2|yte-compile-progn|yte-compile-push-binding-init|yte-compile-push-bytecode-const2|yte-compile-push-bytecodes|yte-compile-push-constant|yte-compile-quo|yte-compile-quote|yte-compile-recurse-toplevel|yte-compile-refresh-preloaded|yte-compile-report-error|yte-compile-report-ops|yte-compile-save-current-buffer|yte-compile-save-excursion|yte-compile-save-restriction|yte-compile-set-default|yte-compile-set-symbol-position|yte-compile-setq-default|yte-compile-setq|yte-compile-sexp|yte-compile-stack-adjustment|yte-compile-stack-ref|yte-compile-stack-set|yte-compile-subr-wrong-args|yte-compile-three-args|yte-compile-top-level-body|yte-compile-top-level|yte-compile-toplevel-file-form|yte-compile-trueconstp|yte-compile-two-args|yte-compile-two-or-three-args|yte-compile-unbind|yte-compile-unfold-bcf|yte-compile-unfold-lambda|yte-compile-unwind-protect|yte-compile-variable-ref)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(?:byte-compile-variable-set|byte-compile-warn-about-unresolved-functions|byte-compile-warn-obsolete|byte-compile-warn|byte-compile-warning-enabled-p|byte-compile-warning-prefix|byte-compile-warning-series|byte-compile-while|byte-compile-zero-or-one-arg|byte-compiler-base-file-name|byte-decompile-bytecode-1|byte-decompile-bytecode|byte-defop-compiler-1|byte-defop-compiler|byte-defop|byte-extrude-byte-code-vectors|byte-force-recompile|byte-optimize-all-constp|byte-optimize-and|byte-optimize-apply|byte-optimize-approx-equal|byte-optimize-associative-math|byte-optimize-binary-predicate|byte-optimize-body|byte-optimize-cond|byte-optimize-delay-constants-math|byte-optimize-divide|byte-optimize-form-code-walker|byte-optimize-form|byte-optimize-funcall|byte-optimize-identity|byte-optimize-if|byte-optimize-inline-handler|byte-optimize-lapcode|byte-optimize-letX|byte-optimize-logmumble|byte-optimize-minus|byte-optimize-multiply|byte-optimize-nonassociative-math|byte-optimize-nth|byte-optimize-nthcdr|byte-optimize-or|byte-optimize-plus|byte-optimize-predicate|byte-optimize-quote|byte-optimize-set|byte-optimize-while|byte-recompile-file|byteorder|c\\\\+\\\\+-font-lock-keywords-2|c\\\\+\\\\+-font-lock-keywords-3|c\\\\+\\\\+-font-lock-keywords|c\\\\+\\\\+-mode|c--macroexpand-all|c-add-class-syntax|c-add-language|c-add-stmt-syntax|c-add-style|c-add-syntax|c-add-type|c-advise-fl-for-region|c-after-change-check-<>-operators|c-after-change|c-after-conditional|c-after-font-lock-init|c-after-special-operator-id|c-after-statement-terminator-p|c-append-backslashes-forward|c-append-lower-brace-pair-to-state-cache|c-append-syntax|c-append-to-state-cache|c-ascertain-following-literal|c-ascertain-preceding-literal|c-at-expression-start-p|c-at-macro-vsemi-p|c-at-statement-start-p|c-at-toplevel-p|c-at-vsemi-p|c-awk-menu|c-back-over-illiterals|c-back-over-member-initializer-braces|c-back-over-member-initializers|c-backslash-region|c-backward-<>-arglist|c-backward-colon-prefixed-type|c-backward-comments|c-backward-conditional|c-backward-into-nomenclature|c-backward-over-enum-header|c-backward-sexp|c-backward-single-comment|c-backward-sws|c-backward-syntactic-ws|c-backward-to-block-anchor|c-backward-to-decl-anchor|c-backward-to-nth-BOF-\\\\{|c-backward-token-1|c-backward-token-2|c-basic-common-init|c-before-change-check-<>-operators|c-before-change|c-before-hack-hook|c-beginning-of-current-token|c-beginning-of-decl-1|c-beginning-of-defun-1|c-beginning-of-defun|c-beginning-of-inheritance-list|c-beginning-of-macro|c-beginning-of-sentence-in-comment|c-beginning-of-sentence-in-string|c-beginning-of-statement-1|c-beginning-of-statement|c-beginning-of-syntax|c-benign-error|c-bind-special-erase-keys|c-block-in-arglist-dwim|c-bos-pop-state-and-retry|c-bos-pop-state|c-bos-push-state|c-bos-report-error|c-bos-restore-pos|c-bos-save-error-info|c-bos-save-pos|c-brace-anchor-point|c-brace-newlines|c-c\\\\+\\\\+-menu|c-c-menu|c-calc-comment-indent|c-calc-offset|c-calculate-state|c-change-set-fl-decl-start|c-cheap-inside-bracelist-p|c-check-type|c-clear-<-pair-props-if-match-after|c-clear-<-pair-props|c-clear-<>-pair-props|c-clear->-pair-props-if-match-before|c-clear->-pair-props|c-clear-c-type-property|c-clear-char-properties|c-clear-char-property-with-value-function|c-clear-char-property-with-value|c-clear-char-property|c-clear-cpp-delimiters|c-clear-found-types|c-collect-line-comments|c-comment-indent|c-comment-line-break-function|c-comment-out-cpps|c-common-init|c-compose-keywords-list|c-concat-separated|c-constant-symbol|c-context-line-break|c-context-open-line|c-context-set-fl-decl-start|c-count-cfss|c-cpp-define-name|c-crosses-statement-barrier-p|c-debug-add-face|c-debug-parse-state-double-cons|c-debug-parse-state|c-debug-put-decl-spot-faces|c-debug-remove-decl-spot-faces|c-debug-remove-face|c-debug-sws-msg|c-declaration-limits|c-declare-lang-variables|c-default-value-sentence-end|c-define-abbrev-table|c-define-lang-constant|c-defun-name|c-delete-and-extract-region|c-delete-backslashes-forward|c-delete-overlay|c-determine-\\\\+ve-limit|c-determine-limit-get-base|c-determine-limit|c-do-auto-fill|c-down-conditional-with-else|c-down-conditional|c-down-list-backward|c-down-list-forward|c-echo-parsing-error|c-electric-backspace|c-electric-brace|c-electric-colon|c-electric-continued-statement|c-electric-delete-forward|c-electric-delete|c-electric-indent-local-mode-hook|c-electric-indent-mode-hook|c-electric-lt-gt|c-electric-paren|c-electric-pound|c-electric-semi&comma|c-electric-slash|c-electric-star|c-end-of-current-token|c-end-of-decl-1|c-end-of-defun-1|c-end-of-defun|c-end-of-macro|c-end-of-sentence-in-comment|c-end-of-sentence-in-string|c-end-of-statement|c-evaluate-offset|c-extend-after-change-region|c-extend-font-lock-region-for-macros|c-extend-region-for-CPP|c-face-name-p|c-fdoc-shift-type-backward|c-fill-paragraph|c-find-assignment-for-mode|c-find-decl-prefix-search|c-find-decl-spots|c-find-invalid-doc-markup|c-fn-region-is-active-p|c-font-lock-<>-arglists|c-font-lock-c\\\\+\\\\+-new|c-font-lock-complex-decl-prepare|c-font-lock-declarations|c-font-lock-declarators|c-font-lock-doc-comments|c-font-lock-enclosing-decls|c-font-lock-enum-tail|c-font-lock-fontify-region|c-font-lock-init|c-font-lock-invalid-string|c-font-lock-keywords-2|c-font-lock-keywords-3|c-font-lock-keywords|c-font-lock-labels|c-font-lock-objc-methods??|c-fontify-recorded-types-and-refs|c-fontify-types-and-refs|c-forward-<>-arglist-recur|c-forward-<>-arglist|c-forward-annotation|c-forward-comments|c-forward-conditional|c-forward-decl-or-cast-1|c-forward-id-comma-list|c-forward-into-nomenclature|c-forward-keyword-clause|c-forward-keyword-prefixed-id|c-forward-label|c-forward-name|c-forward-objc-directive|c-forward-over-cpp-define-id|c-forward-over-illiterals|c-forward-sexp|c-forward-single-comment|c-forward-sws|c-forward-syntactic-ws|c-forward-to-cpp-define-body|c-forward-to-nth-EOF-}|c-forward-token-1|c-forward-token-2|c-forward-type|c-get-cache-scan-pos|c-get-char-property|c-get-current-file|c-get-lang-constant|c-get-offset|c-get-style-variables|c-get-syntactic-indentation|c-gnu-impose-minimum|c-go-down-list-backward|c-go-down-list-forward|c-go-list-backward|c-go-list-forward|c-go-up-list-backward|c-go-up-list-forward|c-got-face-at|c-guess-accumulate-offset|c-guess-accumulate|c-guess-basic-syntax|c-guess-buffer-no-install|c-guess-buffer|c-guess-continued-construct|c-guess-current-offset|c-guess-dump-accumulator|c-guess-dump-guessed-style|c-guess-dump-guessed-values|c-guess-empty-line-p|c-guess-examine|c-guess-fill-prefix|c-guess-guess|c-guess-guessed-syntactic-symbols|c-guess-install|c-guess-make-basic-offset|c-guess-make-offsets-alist|c-guess-make-style|c-guess-merge-offsets-alists|c-guess-no-install|c-guess-region-no-install|c-guess-region|c-guess-reset-accumulator|c-guess-sort-accumulator|c-guess-style-name|c-guess-symbolize-integer|c-guess-symbolize-offsets-alist|c-guess-view-mark-guessed-entries|c-guess-view-reorder-offsets-alist-in-style|c-guess-view|c-guess|c-hungry-backspace|c-hungry-delete-backwards|c-hungry-delete-forward|c-hungry-delete|c-idl-menu|c-in-comment-line-prefix-p|c-in-function-trailer-p|c-in-gcc-asm-p|c-in-knr-argdecl|c-in-literal|c-in-method-def-p|c-indent-command|c-indent-defun|c-indent-exp|c-indent-line-or-region|c-indent-line|c-indent-multi-line-block|c-indent-new-comment-line|c-indent-one-line-block|c-indent-region|c-init-language-vars-for|c-initialize-builtin-style|c-initialize-cc-mode|c-inside-bracelist-p|c-int-to-char|c-intersect-lists|c-invalidate-find-decl-cache|c-invalidate-macro-cache|c-invalidate-state-cache-1|c-invalidate-state-cache|c-invalidate-sws-region-after|c-java-menu|c-just-after-func-arglist-p|c-keep-region-active|c-keyword-member|c-keyword-sym|c-lang-const|c-lang-defconst-eval-immediately|c-lang-defconst|c-lang-major-mode-is|c-langelem-2nd-pos|c-langelem-col|c-langelem-pos|c-langelem-sym|c-last-command-char|c-least-enclosing-brace|c-leave-cc-mode-mode|c-lineup-C-comments|c-lineup-ObjC-method-args-2|c-lineup-ObjC-method-args|c-lineup-ObjC-method-call-colons|c-lineup-ObjC-method-call|c-lineup-after-whitesmith-blocks|c-lineup-argcont-scan|c-lineup-argcont|c-lineup-arglist-close-under-paren|c-lineup-arglist-intro-after-paren|c-lineup-arglist-operators|c-lineup-arglist|c-lineup-assignments|c-lineup-cascaded-calls|c-lineup-close-paren|c-lineup-comment|c-lineup-cpp-define|c-lineup-dont-change|c-lineup-gcc-asm-reg|c-lineup-gnu-DEFUN-intro-cont|c-lineup-inexpr-block|c-lineup-java-inher|c-lineup-java-throws|c-lineup-knr-region-comment|c-lineup-math|c-lineup-multi-inher|c-lineup-respect-col-0|c-lineup-runin-statements|c-lineup-streamop|c-lineup-string-cont|c-lineup-template-args|c-lineup-topmost-intro-cont|c-lineup-whitesmith-in-block|c-list-found-types|c-literal-limits-fast|c-literal-limits|c-literal-type|c-looking-at-bos|c-looking-at-decl-block|c-looking-at-inexpr-block-backward|c-looking-at-inexpr-block|c-looking-at-non-alphnumspace|c-looking-at-special-brace-list|c-lookup-lists|c-macro-display-buffer|c-macro-expand|c-macro-expansion|c-macro-is-genuine-p|c-macro-vsemi-status-unknown-p|c-major-mode-is|c-make-bare-char-alt|c-make-font-lock-BO-decl-search-function|c-make-font-lock-context-search-function|c-make-font-lock-extra-types-blurb|c-make-font-lock-search-form|c-make-font-lock-search-function|c-make-inherited-keymap|c-make-inverse-face|c-make-keywords-re|c-make-macro-with-semi-re|c-make-styles-buffer-local|c-make-syntactic-matcher|c-mark-<-as-paren|c-mark->-as-paren|c-mark-function|c-mask-paragraph|c-mode-menu|c-mode-symbol|c-mode-var|c-mode|c-most-enclosing-brace|c-most-enclosing-decl-block|c-narrow-to-comment-innards|c-narrow-to-most-enclosing-decl-block|c-neutralize-CPP-line|c-neutralize-syntax-in-and-mark-CPP|c-newline-and-indent|c-next-single-property-change|c-objc-menu|c-on-identifier|c-one-line-string-p|c-outline-level|c-override-default-keywords|c-parse-state-1|c-parse-state-get-strategy|c-parse-state|c-partial-ws-p|c-pike-menu|c-point-syntax|c-point|c-populate-syntax-table|c-postprocess-file-styles|c-progress-fini|c-progress-init|c-progress-update|c-pull-open-brace|c-punctuation-in|c-put-c-type-property|c-put-char-property-fun|c-put-char-property|c-put-font-lock-face|c-put-font-lock-string-face|c-put-in-sws|c-put-is-sws|c-put-overlay|c-query-and-set-macro-start|c-query-macro-start|c-read-offset|c-real-parse-state|c-record-parse-state-state|c-record-ref-id|c-record-type-id|c-regexp-opt-depth|c-regexp-opt|c-region-is-active-p|c-remove-any-local-eval-or-mode-variables|c-remove-font-lock-face|c-remove-in-sws|c-remove-is-and-in-sws|c-remove-is-sws|c-remove-stale-state-cache-backwards|c-remove-stale-state-cache|c-renarrow-state-cache|c-replay-parse-state-state|c-restore-<->-as-parens|c-run-mode-hooks|c-safe-position|c-safe-scan-lists|c-safe|c-save-buffer-state|c-sc-parse-partial-sexp-no-category|c-sc-parse-partial-sexp|c-sc-scan-lists-no-category\\\\+1\\\\+1|c-sc-scan-lists-no-category\\\\+1-1|c-sc-scan-lists-no-category-1\\\\+1|c-sc-scan-lists-no-category-1-1|c-sc-scan-lists|c-scan-conditionals|c-scope-operator|c-search-backward-char-property|c-search-decl-header-end|c-search-forward-char-property|c-search-uplist-for-classkey|c-semi&comma-inside-parenlist|c-semi&comma-no-newlines-before-nonblanks|c-semi&comma-no-newlines-for-oneline-inliners|c-sentence-end|c-set-cpp-delimiters|c-set-fl-decl-start|c-set-offset|c-set-region-active|c-set-style-1|c-set-style|c-set-stylevar-fallback|c-setup-doc-comment-style|c-setup-filladapt|c-setup-paragraph-variables|c-shift-line-indentation|c-show-syntactic-information|c-simple-skip-symbol-backward|c-skip-comments-and-strings|c-skip-conditional|c-skip-ws-backward|c-skip-ws-forward|c-snug-1line-defun-close|c-snug-do-while|c-ssb-lit-begin|c-state-balance-parens-backwards|c-state-cache-after-top-paren|c-state-cache-init|c-state-cache-non-literal-place|c-state-cache-top-lparen|c-state-cache-top-paren|c-state-get-min-scan-pos|c-state-lit-beg|c-state-literal-at|c-state-mark-point-min-literal|c-state-maybe-marker|c-state-pp-to-literal|c-state-push-any-brace-pair|c-state-safe-place|c-state-semi-safe-place|c-submit-bug-report|c-subword-mode|c-suppress-<->-as-parens|c-syntactic-content|c-syntactic-end-of-macro|c-syntactic-information-on-region|c-syntactic-re-search-forward|c-syntactic-skip-backward|c-tentative-buffer-changes|c-tnt-chng-cleanup)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)c(?:-tnt-chng-record-state|-toggle-auto-hungry-state|-toggle-auto-newline|-toggle-auto-state|-toggle-electric-state|-toggle-hungry-state|-toggle-parse-state-debug|-toggle-syntactic-indentation|-trim-found-types|-try-one-liner|-uncomment-out-cpps|-unfind-coalesced-tokens|-unfind-enclosing-token|-unfind-type|-unmark-<->-as-paren|-up-conditional-with-else|-up-conditional|-up-list-backward|-up-list-forward|-update-modeline|-valid-offset|-version|-vsemi-status-unknown-p|-whack-state-after|-whack-state-before|-where-wrt-brace-construct|-while-widening-to-decl-block|-widen-to-enclosing-decl-scope|-with-<->-as-parens-suppressed|-with-all-but-one-cpps-commented-out|-with-cpps-commented-out|-with-syntax-table|aaaar|aaadr|aaar|aadar|aaddr|aadr|adaar|adadr|adar|addar|adddr|addr|al-html-cursor-month|al-html-cursor-year|al-menu-context-mouse-menu|al-menu-global-mouse-menu|al-menu-holiday-window-suffix|al-menu-set-date-title|al-menu-x-popup-menu|al-tex-cursor-day|al-tex-cursor-filofax-2week|al-tex-cursor-filofax-daily|al-tex-cursor-filofax-week|al-tex-cursor-filofax-year|al-tex-cursor-month-landscape|al-tex-cursor-month|al-tex-cursor-week-iso|al-tex-cursor-week-monday|al-tex-cursor-week|al-tex-cursor-week2-summary|al-tex-cursor-week2|al-tex-cursor-year-landscape|al-tex-cursor-year|alc-alg-digit-entry|alc-alg-entry|alc-algebraic-entry|alc-align-stack-window|alc-auto-algebraic-entry|alc-big-or-small|alc-binary-op|alc-change-sign|alc-check-defines|alc-check-stack|alc-check-trail-aligned|alc-check-user-syntax|alc-clear-unread-commands|alc-count-lines|alc-create-buffer|alc-cursor-stack-index|alc-dispatch-help|alc-dispatch|alc-divide|alc-do-alg-entry|alc-do-calc-eval|alc-do-dispatch|alc-do-embedded-activate|alc-do-handle-whys|alc-do-quick-calc|alc-do-refresh|alc-do|alc-embedded-activate|alc-embedded|alc-enter-result|alc-enter|alc-eval|alc-get-stack-element|alc-grab-rectangle|alc-grab-region|alc-grab-sum-across|alc-grab-sum-down|alc-handle-whys|alc-help|alc-info-goto-node|alc-info-summary|alc-info|alc-inv|alc-keypad|alc-kill-stack-buffer|alc-last-args-stub|alc-left-divide|alc-match-user-syntax|alc-minibuffer-contains|alc-minibuffer-size|alc-minus|alc-missing-key|alc-mod|alc-mode-var-list-restore-default-values|alc-mode-var-list-restore-saved-values|alc-normalize|alc-num-prefix-name|alc-other-window|alc-over|alc-percent|alc-plus|alc-pop-above|alc-pop-push-list|alc-pop-push-record-list|alc-pop-stack|alc-pop|alc-power|alc-push-list|alc-quit|alc-read-key-sequence|alc-read-key|alc-record-list|alc-record-undo|alc-record-why|alc-record|alc-refresh|alc-renumber-stack|alc-report-bug|alc-roll-down-stack|alc-roll-down|alc-roll-up-stack|alc-roll-up|alc-same-interface|alc-select-buffer|alc-set-command-flag|alc-set-mode-line|alc-shift-Y-prefix-help|alc-slow-wrapper|alc-stack-size|alc-substack-height|alc-temp-minibuffer-message|alc-times|alc-top-list-n|alc-top-list|alc-top-n|alc-top|alc-trail-buffer|alc-trail-display|alc-trail-here|alc-transpose-lines|alc-tutorial|alc-unary-op|alc-undo|alc-unread-command|alc-user-invocation|alc-window-width|alc-with-default-simplification|alc-with-trail-buffer|alc-wrapper|alc-yank|alc|alcDigit-algebraic|alcDigit-backspace|alcDigit-edit|alcDigit-key|alcDigit-letter|alcDigit-nondigit|alcDigit-start|alcFunc-floor|alcFunc-inv|alcFunc-trunc|alculate-icon-indent|alculate-lisp-indent|alculate-tcl-indent|alculator-add-operators|alculator-backspace|alculator-clear-fragile|alculator-clear-saved|alculator-clear|alculator-close-paren|alculator-copy|alculator-dec/deg-mode|alculator-decimal|alculator-digit|alculator-displayer-next|alculator-displayer-prev|alculator-eng-display|alculator-enter|alculator-expt??|alculator-fact|alculator-funcall|alculator-get-display|alculator-get-register|alculator-groupize-number|alculator-help|alculator-last-input|alculator-menu|alculator-message|alculator-mode|alculator-need-3-lines|alculator-number-to-string|alculator-op-arity|alculator-op-or-exp|alculator-op-prec|alculator-op|alculator-open-paren|alculator-paste|alculator-push-curnum|alculator-put-value|alculator-quit|alculator-radix-input-mode|alculator-radix-mode|alculator-radix-output-mode|alculator-reduce-stack-once|alculator-reduce-stack|alculator-remove-zeros|alculator-repL|alculator-repR|alculator-reset|alculator-rotate-displayer-back|alculator-rotate-displayer|alculator-save-and-quit|alculator-save-on-list|alculator-saved-down|alculator-saved-move|alculator-saved-up|alculator-set-register|alculator-standard-displayer|alculator-string-to-number|alculator-truncate|alculator-update-display|alculator|alendar-abbrev-construct|alendar-absolute-from-gregorian|alendar-astro-date-string|alendar-astro-from-absolute|alendar-astro-goto-day-number|alendar-astro-print-day-number|alendar-astro-to-absolute|alendar-backward-day|alendar-backward-month|alendar-backward-week|alendar-backward-year|alendar-bahai-date-string|alendar-bahai-goto-date|alendar-bahai-mark-date-pattern|alendar-bahai-print-date|alendar-basic-setup|alendar-beginning-of-month|alendar-beginning-of-week|alendar-beginning-of-year|alendar-buffer-list|alendar-check-holidays|alendar-chinese-date-string|alendar-chinese-goto-date|alendar-chinese-print-date|alendar-column-to-segment|alendar-coptic-date-string|alendar-coptic-goto-date|alendar-coptic-print-date|alendar-count-days-region|alendar-current-date|alendar-cursor-holidays|alendar-cursor-to-date|alendar-cursor-to-nearest-date|alendar-cursor-to-visible-date|alendar-customized-p|alendar-date-compare|alendar-date-equal|alendar-date-is-valid-p|alendar-date-is-visible-p|alendar-date-string|alendar-day-header-construct|alendar-day-name|alendar-day-number|alendar-day-of-week|alendar-day-of-year-string|alendar-dayname-on-or-before|alendar-end-of-month|alendar-end-of-week|alendar-end-of-year|alendar-ensure-newline|alendar-ethiopic-date-string|alendar-ethiopic-goto-date|alendar-ethiopic-print-date|alendar-exchange-point-and-mark|alendar-exit|alendar-extract-day|alendar-extract-month|alendar-extract-year|alendar-forward-day|alendar-forward-month|alendar-forward-week|alendar-forward-year|alendar-frame-setup|alendar-french-date-string|alendar-french-goto-date|alendar-french-print-date|alendar-generate-month|alendar-generate-window|alendar-generate|alendar-goto-date|alendar-goto-day-of-year|alendar-goto-info-node|alendar-goto-today|alendar-gregorian-from-absolute|alendar-hebrew-date-string|alendar-hebrew-goto-date|alendar-hebrew-list-yahrzeits|alendar-hebrew-mark-date-pattern|alendar-hebrew-print-date|alendar-holiday-list|alendar-in-read-only-buffer|alendar-increment-month-cons|alendar-increment-month|alendar-insert-at-column|alendar-interval|alendar-islamic-date-string|alendar-islamic-goto-date|alendar-islamic-mark-date-pattern|alendar-islamic-print-date|alendar-iso-date-string|alendar-iso-from-absolute|alendar-iso-goto-date|alendar-iso-goto-week|alendar-iso-print-date|alendar-julian-date-string|alendar-julian-from-absolute|alendar-julian-goto-date|alendar-julian-print-date|alendar-last-day-of-month|alendar-leap-year-p|alendar-list-holidays|alendar-lunar-phases|alendar-make-alist|alendar-make-temp-face|alendar-mark-1|alendar-mark-complex|alendar-mark-date-pattern|alendar-mark-days-named|alendar-mark-holidays|alendar-mark-month|alendar-mark-today|alendar-mark-visible-date|alendar-mayan-date-string|alendar-mayan-goto-long-count-date|alendar-mayan-next-haab-date|alendar-mayan-next-round-date|alendar-mayan-next-tzolkin-date|alendar-mayan-previous-haab-date|alendar-mayan-previous-round-date|alendar-mayan-previous-tzolkin-date|alendar-mayan-print-date|alendar-mode-line-entry|alendar-mode|alendar-month-edges|alendar-month-name|alendar-mouse-view-diary-entries|alendar-mouse-view-other-diary-entries|alendar-move-to-column|alendar-nongregorian-visible-p|alendar-not-implemented|alendar-nth-named-absday|alendar-nth-named-day|alendar-other-dates|alendar-other-month|alendar-persian-date-string|alendar-persian-goto-date|alendar-persian-print-date|alendar-print-day-of-year|alendar-print-other-dates|alendar-read-date|alendar-read|alendar-recompute-layout-variables|alendar-redraw|alendar-scroll-left-three-months|alendar-scroll-left|alendar-scroll-right-three-months|alendar-scroll-right|alendar-scroll-toolkit-scroll|alendar-set-date-style|alendar-set-layout-variable|alendar-set-mark|alendar-set-mode-line|alendar-star-date|alendar-string-spread|alendar-sum|alendar-sunrise-sunset-month|alendar-sunrise-sunset|alendar-unmark|alendar-update-mode-line|alendar-week-end-day|alendar|all-last-kbd-macro|all-next-method|allf2??|ancel-edebug-on-entry|ancel-function-timers|ancel-kbd-macro-events|ancel-timer-internal|anlock-insert-header|anlock-verify|anonicalize-coding-system-name|anonically-space-region|apitalized-words-mode|ar-less-than-car|ase-table-get-table|ase|c-choose-style-for-mode|c-eval-when-compile|c-imenu-init|c-imenu-java-build-type-args-regex|c-imenu-objc-function|c-imenu-objc-method-to-selector|c-imenu-objc-remove-white-space|cl-compile|cl-dump|cl-execute-on-string|cl-execute-with-args|cl-execute|cl-program-p|conv--analyze-function|conv--analyze-use|conv--convert-function|conv--map-diff-elem|conv--map-diff-set|conv--map-diff|conv--set-diff-map|conv--set-diff|conv-analyse-form|conv-analyze-form|conv-closure-convert|conv-convert|conv-warnings-only|d-absolute|d|daaar|daadr|daar|dadar|daddr|dadr|ddaar|ddadr|ddar|dddar|ddddr|dddr|dl-get-file|dl-put-region|edet-version|eiling\\\\*|enter-line|enter-paragraph|enter-region|fengine-auto-mode|fengine-common-settings|fengine-common-syntax|fengine-fill-paragraph|fengine-mode|fengine2-beginning-of-defun|fengine2-end-of-defun|fengine2-indent-line|fengine2-mode|fengine2-outline-level|fengine3--current-function|fengine3-beginning-of-defun|fengine3-clear-syntax-cache|fengine3-completion-function|fengine3-create-imenu-index|fengine3-current-defun|fengine3-documentation-function|fengine3-end-of-defun|fengine3-format-function-docstring|fengine3-indent-line|fengine3-make-syntax-cache|fengine3-mode|hange-class|hange-log-beginning-of-defun|hange-log-end-of-defun|hange-log-fill-forward-paragraph|hange-log-fill-parenthesized-list|hange-log-find-file|hange-log-get-method-definition-1|hange-log-get-method-definition|hange-log-goto-source-1|hange-log-goto-source|hange-log-indent|hange-log-merge|hange-log-mode|hange-log-name|hange-log-next-buffer|hange-log-next-error|hange-log-resolve-conflict|hange-log-search-file-name|hange-log-search-tag-name-1|hange-log-search-tag-name|hange-log-sortable-date-at|hange-log-version-number-search|har-resolve-modifiers|har-valid-p|harset-bytes|harset-chars|harset-description|harset-dimension|harset-id-internal|harset-id|harset-info|harset-iso-final-char|harset-long-name|harset-short-name|hart-add-sequence|hart-axis-child-p|hart-axis-draw|hart-axis-list-p|hart-axis-names-child-p|hart-axis-names-list-p|hart-axis-names-p|hart-axis-names|hart-axis-p|hart-axis-range-child-p|hart-axis-range-list-p|hart-axis-range-p|hart-axis-range|hart-axis|hart-bar-child-p|hart-bar-list-p|hart-bar-p|hart-bar-quickie|hart-bar|hart-child-p|hart-deface-rectangle|hart-display-label|hart-draw-axis|hart-draw-data|hart-draw-line|hart-draw-title|hart-draw|hart-emacs-lists|hart-emacs-storage|hart-file-count|hart-goto-xy|hart-list-p|hart-mode|hart-new-buffer|hart-p|hart-rmail-from|hart-sequece-child-p|hart-sequece-list-p|hart-sequece-p|hart-sequece|hart-size-in-dir|hart-sort-matchlist|hart-sort|hart-space-usage|hart-test-it-all|hart-translate-namezone|hart-translate-xpos|hart-translate-ypos|hart-trim|hart-zap-chars|hart|heck-ccl-program|heck-completion-length|heck-declare-directory|heck-declare-errmsg|heck-declare-files??|heck-declare-locate|heck-declare-scan|heck-declare-sort|heck-declare-verify|heck-declare-warn)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)c(?:heck-face|heck-ispell-version|heck-parens|heck-type|heckdoc-autofix-ask-replace|heckdoc-buffer-label|heckdoc-char=|heckdoc-comments|heckdoc-continue|heckdoc-create-common-verbs-regexp|heckdoc-create-error|heckdoc-current-buffer|heckdoc-defun-info|heckdoc-defun|heckdoc-delete-overlay|heckdoc-display-status-buffer|heckdoc-error-end|heckdoc-error-start|heckdoc-error-text|heckdoc-error-unfixable|heckdoc-error|heckdoc-eval-current-buffer|heckdoc-eval-defun|heckdoc-file-comments-engine|heckdoc-in-example-string-p|heckdoc-in-sample-code-p|heckdoc-interactive-ispell-loop|heckdoc-interactive-loop|heckdoc-interactive|heckdoc-ispell-comments|heckdoc-ispell-continue|heckdoc-ispell-current-buffer|heckdoc-ispell-defun|heckdoc-ispell-docstring-engine|heckdoc-ispell-init|heckdoc-ispell-interactive|heckdoc-ispell-message-interactive|heckdoc-ispell-message-text|heckdoc-ispell-start|heckdoc-ispell|heckdoc-list-of-strings-p|heckdoc-make-overlay|heckdoc-message-interactive-ispell-loop|heckdoc-message-interactive|heckdoc-message-text-engine|heckdoc-message-text-next-string|heckdoc-message-text-search|heckdoc-message-text|heckdoc-mode-line-update|heckdoc-next-docstring|heckdoc-next-error|heckdoc-next-message-error|heckdoc-output-mode|heckdoc-outside-major-sexp|heckdoc-overlay-end|heckdoc-overlay-put|heckdoc-overlay-start|heckdoc-proper-noun-region-engine|heckdoc-recursive-edit|heckdoc-rogue-space-check-engine|heckdoc-rogue-spaces|heckdoc-run-hooks|heckdoc-sentencespace-region-engine|heckdoc-show-diagnostics|heckdoc-start-section|heckdoc-start|heckdoc-this-string-valid-engine|heckdoc-this-string-valid|heckdoc-y-or-n-p|heckdoc|hild-of-class-p|hmod|hoose-completion-delete-max-match|hoose-completion-guess-base-position|hoose-completion-string|hoose-completion|l--adjoin|l--arglist-args|l--block-throw--cmacro|l--block-throw|l--block-wrapper--cmacro|l--block-wrapper|l--check-key|l--check-match|l--check-test-nokey|l--check-test|l--compile-time-too|l--compiler-macro-adjoin|l--compiler-macro-assoc|l--compiler-macro-cXXr|l--compiler-macro-get|l--compiler-macro-list\\\\*|l--compiler-macro-member|l--compiler-macro-typep|l--compiling-file|l--const-expr-p|l--const-expr-val|l--defalias|l--defsubst-expand|l--delete-duplicates|l--do-arglist|l--do-prettyprint|l--do-proclaim|l--do-remf|l--do-subst|l--expand-do-loop|l--expr-contains-any|l--expr-contains|l--expr-depends-p|l--finite-do|l--function-convert|l--gv-adapt|l--labels-convert|l--letf|l--loop-build-ands|l--loop-handle-accum|l--loop-let|l--loop-set-iterator-function|l--macroexp-fboundp|l--make-type-test|l--make-usage-args|l--make-usage-var|l--map-intervals|l--map-keymap-recursively|l--map-overlays|l--mapcar-many|l--nsublis-rec|l--parse-loop-clause|l--parsing-keywords|l--pass-args-to-cl-declare|l--pop2|l--position|l--random-time|l--safe-expr-p|l--set-buffer-substring|l--set-frame-visible-p|l--set-getf|l--set-substring|l--simple-expr-p|l--simple-exprs-p|l--sm-macroexpand|l--struct-epg-context-p--cmacro|l--struct-epg-context-p|l--struct-epg-data-p--cmacro|l--struct-epg-data-p|l--struct-epg-import-result-p--cmacro|l--struct-epg-import-result-p|l--struct-epg-import-status-p--cmacro|l--struct-epg-import-status-p|l--struct-epg-key-p--cmacro|l--struct-epg-key-p|l--struct-epg-key-signature-p--cmacro|l--struct-epg-key-signature-p|l--struct-epg-new-signature-p--cmacro|l--struct-epg-new-signature-p|l--struct-epg-sig-notation-p--cmacro|l--struct-epg-sig-notation-p|l--struct-epg-signature-p--cmacro|l--struct-epg-signature-p|l--struct-epg-sub-key-p--cmacro|l--struct-epg-sub-key-p|l--struct-epg-user-id-p--cmacro|l--struct-epg-user-id-p|l--sublis-rec|l--sublis|l--transform-lambda|l--tree-equal-rec|l--unused-var-p|l--wrap-in-nil-block|l-caaaar|l-caaadr|l-caaar|l-caadar|l-caaddr|l-caadr|l-cadaar|l-cadadr|l-cadar|l-caddar|l-cadddr|l-cdaaar|l-cdaadr|l-cdaar|l-cdadar|l-cdaddr|l-cdadr|l-cddaar|l-cddadr|l-cddar|l-cdddar|l-cddddr|l-cdddr|l-clrhash|l-copy-seq|l-copy-tree|l-digit-char-p|l-eighth|l-fifth|l-flet\\\\*|l-floatp-safe|l-fourth|l-fresh-line|l-gethash|l-hash-table-count|l-hash-table-p|l-maclisp-member|l-macroexpand-all|l-macroexpand|l-make-hash-table|l-map-extents|l-map-intervals|l-map-keymap-recursively|l-map-keymap|l-maphash|l-multiple-value-apply|l-multiple-value-call|l-multiple-value-list|l-ninth|l-not-hash-table|l-nreconc|l-nth-value|l-parse-integer|l-prettyprint|l-puthash|l-remhash|l-revappend|l-second|l-set-getf|l-seventh|l-signum|l-sixth|l-struct-sequence-type|l-struct-setf-expander|l-struct-slot-info|l-struct-slot-offset|l-struct-slot-value--cmacro|l-struct-slot-value|l-svref|l-tenth|l-third|l-unload-function|l-values-list|l-values|lass-abstract-p|lass-children|lass-constructor|lass-direct-subclasses|lass-direct-superclasses|lass-method-invocation-order|lass-name|lass-of|lass-option-assoc|lass-option|lass-p|lass-parents??|lass-precedence-list|lass-slot-initarg|lass-v|lean-buffer-list-delay|lean-buffer-list|lear-all-completions|lear-buffer-auto-save-failure|lear-charset-maps|lear-face-cache|lear-font-cache|lear-rectangle-line|lear-rectangle|lipboard-kill-region|lipboard-kill-ring-save|lipboard-yank|lone-buffer|lone-indirect-buffer-other-window|lone-process|lone|lose-display-connection|lose-font|lose-rectangle|mpl-coerce-string-case|mpl-hours-since-origin|mpl-merge-string-cases|mpl-prefix-entry-head|mpl-prefix-entry-tail|mpl-string-case-type|oding-system-base|oding-system-category|oding-system-doc-string|oding-system-eol-type-mnemonic|oding-system-equal|oding-system-from-name|oding-system-lessp|oding-system-mnemonic|oding-system-plist|oding-system-post-read-conversion|oding-system-pre-write-conversion|oding-system-put|oding-system-translation-table-for-decode|oding-system-translation-table-for-encode|oding-system-type|oerce|olor-cie-de2000|olor-clamp|olor-complement-hex|olor-complement|olor-darken-hsl|olor-darken-name|olor-desaturate-hsl|olor-desaturate-name|olor-distance|olor-gradient|olor-hsl-to-rgb|olor-hue-to-rgb|olor-lab-to-srgb|olor-lab-to-xyz|olor-lighten-hsl|olor-lighten-name|olor-name-to-rgb|olor-rgb-to-hex|olor-rgb-to-hsl|olor-rgb-to-hsv|olor-saturate-hsl|olor-saturate-name|olor-srgb-to-lab|olor-srgb-to-xyz|olor-xyz-to-lab|olor-xyz-to-srgb|olumn-number-mode|ombine-after-change-execute|omint--complete-file-name-data|omint--match-partial-filename|omint--requote-argument|omint--unquote&expand-filename|omint--unquote&requote-argument|omint--unquote-argument|omint-accumulate|omint-add-to-input-history|omint-adjust-point|omint-adjust-window-point|omint-after-pmark-p|omint-append-output-to-file|omint-args|omint-arguments|omint-backward-matching-input|omint-bol-or-process-mark|omint-bol|omint-c-a-p-replace-by-expanded-history|omint-carriage-motion|omint-check-proc|omint-check-source|omint-completion-at-point|omint-completion-file-name-table|omint-continue-subjob|omint-copy-old-input|omint-delchar-or-maybe-eof|omint-delete-input|omint-delete-output|omint-delim-arg|omint-directory|omint-dynamic-complete-as-filename|omint-dynamic-complete-filename|omint-dynamic-complete|omint-dynamic-list-completions|omint-dynamic-list-filename-completions|omint-dynamic-list-input-ring-select|omint-dynamic-list-input-ring|omint-dynamic-simple-complete|omint-exec-1|omint-exec|omint-extract-string|omint-filename-completion|omint-forward-matching-input|omint-get-next-from-history|omint-get-old-input-default|omint-get-source|omint-goto-input|omint-goto-process-mark|omint-history-isearch-backward-regexp|omint-history-isearch-backward|omint-history-isearch-end|omint-history-isearch-message|omint-history-isearch-pop-state|omint-history-isearch-push-state|omint-history-isearch-search|omint-history-isearch-setup|omint-history-isearch-wrap|omint-how-many-region|omint-insert-input|omint-insert-previous-argument|omint-interrupt-subjob|omint-kill-input|omint-kill-region|omint-kill-subjob|omint-kill-whole-line|omint-line-beginning-position|omint-magic-space|omint-match-partial-filename|omint-mode|omint-next-input|omint-next-matching-input-from-input|omint-next-matching-input|omint-next-prompt|omint-output-filter|omint-postoutput-scroll-to-bottom|omint-preinput-scroll-to-bottom|omint-previous-input-string|omint-previous-input|omint-previous-matching-input-from-input|omint-previous-matching-input-string-position|omint-previous-matching-input-string|omint-previous-matching-input|omint-previous-prompt|omint-proc-query|omint-quit-subjob|omint-quote-filename|omint-read-input-ring|omint-read-noecho|omint-redirect-cleanup|omint-redirect-filter|omint-redirect-preoutput-filter|omint-redirect-remove-redirection|omint-redirect-results-list-from-process|omint-redirect-results-list|omint-redirect-send-command-to-process|omint-redirect-send-command|omint-redirect-setup|omint-regexp-arg|omint-replace-by-expanded-filename|omint-replace-by-expanded-history-before-point|omint-replace-by-expanded-history|omint-restore-input|omint-run|omint-search-arg|omint-search-start|omint-send-eof|omint-send-input|omint-send-region|omint-send-string|omint-set-process-mark|omint-show-maximum-output|omint-show-output|omint-simple-send|omint-skip-input|omint-skip-prompt|omint-snapshot-last-prompt|omint-source-default|omint-stop-subjob|omint-strip-ctrl-m|omint-substitute-in-file-name|omint-truncate-buffer|omint-unquote-filename|omint-update-fence|omint-watch-for-password-prompt|omint-within-quotes|omint-word|omint-write-input-ring|omint-write-output|ommand-apropos|ommand-error-default-function|ommand-history-mode|ommand-history-repeat|ommand-line-1|ommand-line-normalize-file-name|omment-add|omment-beginning|omment-box|omment-choose-indent|omment-dwim|omment-enter-backward|omment-forward|omment-indent-default|omment-indent-new-line|omment-indent|omment-kill|omment-make-extra-lines|omment-normalize-vars|omment-only-p|omment-or-uncomment-region|omment-padleft|omment-padright|omment-quote-nested|omment-quote-re|omment-region-default|omment-region-internal|omment-region|omment-search-backward|omment-search-forward|omment-set-column|omment-string-reverse|omment-string-strip|omment-valid-prefix-p|omment-with-narrowing|ommon-lisp-indent-function|ommon-lisp-mode|ompare-windows-dehighlight|ompare-windows-get-next-window|ompare-windows-get-recent-window|ompare-windows-highlight|ompare-windows-skip-whitespace|ompare-windows-sync-default-function|ompare-windows-sync-regexp|ompare-windows|ompilation--compat-error-properties|ompilation--compat-parse-errors|ompilation--ensure-parse|ompilation--file-struct->file-spec|ompilation--file-struct->formats|ompilation--file-struct->loc-tree|ompilation--flush-directory-cache|ompilation--flush-file-structure|ompilation--flush-parse|ompilation--loc->col|ompilation--loc->file-struct|ompilation--loc->line|ompilation--loc->marker|ompilation--loc->visited|ompilation--make-cdrloc|ompilation--make-file-struct|ompilation--make-message--cmacro|ompilation--make-message|ompilation--message->end-loc--cmacro|ompilation--message->end-loc|ompilation--message->loc--cmacro|ompilation--message->loc|ompilation--message->type--cmacro|ompilation--message->type|ompilation--message-p--cmacro|ompilation--message-p|ompilation--parse-region|ompilation--previous-directory|ompilation--put-prop|ompilation--remove-properties|ompilation--unsetup|ompilation-auto-jump|ompilation-buffer-internal-p|ompilation-buffer-name|ompilation-buffer-p|ompilation-button-map|ompilation-directory-properties|ompilation-display-error|ompilation-error-properties|ompilation-face|ompilation-fake-loc|ompilation-filter|ompilation-find-buffer|ompilation-find-file|ompilation-forget-errors|ompilation-get-file-structure|ompilation-goto-locus-delete-o|ompilation-goto-locus|ompilation-handle-exit|ompilation-internal-error-properties|ompilation-loop|ompilation-minor-mode|ompilation-mode-font-lock-keywords|ompilation-mode|ompilation-move-to-column|ompilation-next-error-function|ompilation-next-error|ompilation-next-file|ompilation-next-single-property-change)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)c(?:ompilation-parse-errors|ompilation-previous-error|ompilation-previous-file|ompilation-read-command|ompilation-revert-buffer|ompilation-sentinel|ompilation-set-skip-threshold|ompilation-set-window-height|ompilation-set-window|ompilation-setup|ompilation-shell-minor-mode|ompilation-start|ompile-goto-error|ompile-mouse-goto-error|ompile|ompiler-macroexpand|omplete-in-turn|omplete-symbol|omplete-tag|omplete-with-action|omplete|ompleting-read-default|ompleting-read-multiple|ompletion--cache-all-sorted-completions|ompletion--capf-wrapper|ompletion--common-suffix|ompletion--complete-and-exit|ompletion--cycle-threshold|ompletion--do-completion|ompletion--done|ompletion--embedded-envvar-table|ompletion--field-metadata|ompletion--file-name-table|ompletion--flush-all-sorted-completions|ompletion--in-region-1|ompletion--in-region|ompletion--insert-strings|ompletion--make-envvar-table|ompletion--merge-suffix|ompletion--message|ompletion--metadata|ompletion--nth-completion|ompletion--post-self-insert|ompletion--replace|ompletion--sifn-requote|ompletion--some|ompletion--string-equal-p|ompletion--styles|ompletion--try-word-completion|ompletion--twq-all|ompletion--twq-try|ompletion-all-completions|ompletion-all-sorted-completions|ompletion-backup-filename|ompletion-basic--pattern|ompletion-basic-all-completions|ompletion-basic-try-completion|ompletion-before-command|ompletion-c-mode-hook|ompletion-complete-and-exit|ompletion-def-wrapper|ompletion-emacs21-all-completions|ompletion-emacs21-try-completion|ompletion-emacs22-all-completions|ompletion-emacs22-try-completion|ompletion-file-name-table|ompletion-find-file-hook|ompletion-help-at-point|ompletion-hilit-commonality|ompletion-in-region--postch|ompletion-in-region--single-word|ompletion-in-region-mode|ompletion-initialize|ompletion-initials-all-completions|ompletion-initials-expand|ompletion-initials-try-completion|ompletion-kill-region|ompletion-last-use-time|ompletion-lisp-mode-hook|ompletion-list-mode-finish|ompletion-list-mode|ompletion-metadata-get|ompletion-metadata|ompletion-mode|ompletion-num-uses|ompletion-pcm--all-completions|ompletion-pcm--filename-try-filter|ompletion-pcm--find-all-completions|ompletion-pcm--hilit-commonality|ompletion-pcm--merge-completions|ompletion-pcm--merge-try|ompletion-pcm--optimize-pattern|ompletion-pcm--pattern->regex|ompletion-pcm--pattern->string|ompletion-pcm--pattern-trivial-p|ompletion-pcm--prepare-delim-re|ompletion-pcm--string->pattern|ompletion-pcm-all-completions|ompletion-pcm-try-completion|ompletion-search-next|ompletion-search-peek|ompletion-search-reset-1|ompletion-search-reset|ompletion-setup-fortran-mode|ompletion-setup-function|ompletion-source|ompletion-string|ompletion-substring--all-completions|ompletion-substring-all-completions|ompletion-substring-try-completion|ompletion-table-with-context|ompletion-try-completion|ompose-chars-after|ompose-chars|ompose-glyph-string-relative|ompose-glyph-string|ompose-gstring-for-dotted-circle|ompose-gstring-for-graphic|ompose-gstring-for-terminal|ompose-gstring-for-variation-glyph|ompose-last-chars|ompose-mail-other-frame|ompose-mail-other-window|ompose-mail|ompose-region-internal|ompose-region|ompose-string-internal|ompose-string|omposition-get-gstring|oncatenate|ondition-case-no-debug|onf-align-assignments|onf-colon-mode|onf-javaprop-mode|onf-mode-initialize|onf-mode-maybe|onf-mode|onf-outline-level|onf-ppd-mode|onf-quote-normal|onf-space-keywords|onf-space-mode-internal|onf-space-mode|onf-unix-mode|onf-windows-mode|onf-xdefaults-mode|onfirm-nonexistent-file-or-buffer|onstructor|onvert-define-charset-argument|ookie-apropos|ookie-check-file|ookie-doctor|ookie-insert|ookie-read|ookie-shuffle-vector|ookie-snarf|ookie1??|opy-case-table|opy-cvs-flags|opy-cvs-tag|opy-dir-locals-to-file-locals-prop-line|opy-dir-locals-to-file-locals|opy-ebrowse-bs|opy-ebrowse-cs|opy-ebrowse-hs|opy-ebrowse-ms|opy-ebrowse-position|opy-ebrowse-ts|opy-erc-channel-user|opy-erc-response|opy-erc-server-user|opy-ert--ewoc-entry|opy-ert--stats|opy-ert--test-execution-info|opy-ert-test-aborted-with-non-local-exit|opy-ert-test-failed|opy-ert-test-passed|opy-ert-test-quit|opy-ert-test-result-with-condition|opy-ert-test-result|opy-ert-test-skipped|opy-ert-test|opy-ewoc--node|opy-ewoc|opy-face|opy-file-locals-to-dir-locals|opy-flymake-ler|opy-gdb-handler|opy-gdb-table|opy-htmlize-fstruct|opy-js--js-handle|opy-js--pitem|opy-list|opy-package--bi-desc|opy-package-desc|opy-profiler-calltree|opy-profiler-profile|opy-rectangle-as-kill|opy-rectangle-to-register|opy-seq|opy-ses--locprn|opy-sgml-tag|opy-soap-array-type|opy-soap-basic-type|opy-soap-binding|opy-soap-bound-operation|opy-soap-element|opy-soap-message|opy-soap-namespace-link|opy-soap-namespace|opy-soap-operation|opy-soap-port-type|opy-soap-port|opy-soap-sequence-element|opy-soap-sequence-type|opy-soap-simple-type|opy-soap-wsdl|opy-tar-header|opy-to-buffer|opy-to-register|opy-url-queue|opyright-find-copyright|opyright-find-end|opyright-fix-years|opyright-limit|opyright-offset-too-large-p|opyright-re-search|opyright-start-point|opyright-update-directory|opyright-update-year|opyright-update|opyright|ount-if-not|ount-if|ount-lines-page|ount-lines-region|ount-matches|ount-text-lines|ount-trailing-whitespace-region|ount-windows|ount-words--buffer-message|ount-words--message|ount-words-region|ount|perl-1\\\\+|perl-1-|perl-add-tags-recurse-noxs-fullpath|perl-add-tags-recurse-noxs|perl-add-tags-recurse|perl-after-block-and-statement-beg|perl-after-block-p|perl-after-change-function|perl-after-expr-p|perl-after-label|perl-after-sub-regexp|perl-at-end-of-expr|perl-backward-to-noncomment|perl-backward-to-start-of-continued-exp|perl-backward-to-start-of-expr|perl-beautify-level|perl-beautify-regexp-piece|perl-beautify-regexp|perl-beginning-of-property|perl-block-p|perl-build-manpage|perl-cached-syntax-table|perl-calculate-indent-within-comment|perl-calculate-indent|perl-check-syntax|perl-choose-color|perl-comment-indent|perl-comment-region|perl-commentify|perl-contract-levels??|perl-db|perl-define-key|perl-delay-update-hook|perl-describe-perl-symbol|perl-do-auto-fill|perl-electric-backspace|perl-electric-brace|perl-electric-else|perl-electric-keyword|perl-electric-lbrace|perl-electric-paren|perl-electric-pod|perl-electric-rparen|perl-electric-semi|perl-electric-terminator|perl-emulate-lazy-lock|perl-enable-font-lock|perl-ensure-newlines|perl-etags|perl-facemenu-add-face-function|perl-fill-paragraph|perl-find-bad-style|perl-find-pods-heres-region|perl-find-pods-heres|perl-find-sub-attrs|perl-find-tags|perl-fix-line-spacing|perl-font-lock-fontify-region-function|perl-font-lock-unfontify-region-function|perl-fontify-syntaxically|perl-fontify-update-bad|perl-fontify-update|perl-forward-group-in-re|perl-forward-re|perl-forward-to-end-of-expr|perl-get-help-defer|perl-get-help|perl-get-here-doc-region|perl-get-state|perl-here-doc-spell|perl-highlight-charclass|perl-imenu--create-perl-index|perl-imenu-addback|perl-imenu-info-imenu-name|perl-imenu-info-imenu-search|perl-imenu-name-and-position|perl-imenu-on-info|perl-indent-command|perl-indent-exp|perl-indent-for-comment|perl-indent-line|perl-indent-region|perl-info-buffer|perl-info-on-command|perl-info-on-current-command|perl-init-faces-weak|perl-init-faces|perl-inside-parens-p|perl-invert-if-unless-modifiers|perl-invert-if-unless|perl-lazy-hook|perl-lazy-install|perl-lazy-unstall|perl-linefeed|perl-lineup|perl-list-fold|perl-load-font-lock-keywords-1|perl-load-font-lock-keywords-2|perl-load-font-lock-keywords|perl-look-at-leading-count|perl-make-indent|perl-make-regexp-x|perl-map-pods-heres|perl-mark-active|perl-menu-to-keymap|perl-menu|perl-mode|perl-modify-syntax-type|perl-msb-fix|perl-narrow-to-here-doc|perl-next-bad-style|perl-next-interpolated-REx-0|perl-next-interpolated-REx-1|perl-next-interpolated-REx|perl-outline-level|perl-perldoc-at-point|perl-perldoc|perl-pod-spell|perl-pod-to-manpage|perl-pod2man-build-command|perl-postpone-fontification|perl-protect-defun-start|perl-ps-print-init|perl-ps-print|perl-put-do-not-fontify|perl-putback-char|perl-regext-to-level-start|perl-select-this-pod-or-here-doc|perl-set-style-back|perl-set-style|perl-setup-tmp-buf|perl-sniff-for-indent|perl-switch-to-doc-buffer|perl-tags-hier-fill|perl-tags-hier-init|perl-tags-treeify|perl-time-fontification|perl-to-comment-or-eol|perl-toggle-abbrev|perl-toggle-auto-newline|perl-toggle-autohelp|perl-toggle-construct-fix|perl-toggle-electric|perl-toggle-set-debug-unwind|perl-uncomment-region|perl-unwind-to-safe|perl-update-syntaxification|perl-use-region-p|perl-val|perl-windowed-init|perl-word-at-point-hard|perl-word-at-point|perl-write-tags|perl-xsub-scan|pp-choose-branch|pp-choose-default-face|pp-choose-face|pp-choose-symbol|pp-create-bg-face|pp-edit-apply|pp-edit-background|pp-edit-false|pp-edit-home|pp-edit-known|pp-edit-list-entry-get-or-create|pp-edit-load|pp-edit-mode|pp-edit-reset|pp-edit-save|pp-edit-toggle-known|pp-edit-toggle-unknown|pp-edit-true|pp-edit-unknown|pp-edit-write|pp-face-name|pp-grow-overlay|pp-highlight-buffer|pp-make-button|pp-make-known-overlay|pp-make-overlay-hidden|pp-make-overlay-read-only|pp-make-overlay-sticky|pp-make-unknown-overlay|pp-parse-close|pp-parse-edit|pp-parse-error|pp-parse-open|pp-parse-reset|pp-progress-message|pp-push-button|pp-signal-read-only|reate-default-fontset|reate-fontset-from-ascii-font|reate-fontset-from-x-resource|reate-glyph|rm--choose-completion-string|rm--collection-fn|rm--completion-command|rm--current-element|rm-complete-and-exit|rm-complete-word|rm-complete|rm-completion-help|rm-minibuffer-complete-and-exit|rm-minibuffer-complete|rm-minibuffer-completion-help|ss--font-lock-keywords|ss-current-defun-name|ss-extract-keyword-list|ss-extract-parse-val-grammar|ss-extract-props-and-vals|ss-fill-paragraph|ss-mode|ss-smie--backward-token|ss-smie--forward-token|ss-smie-rules|text-non-standard-encodings-table|text-post-read-conversion|text-pre-write-conversion|tl-x-4-prefix|tl-x-5-prefix|tl-x-ctl-p-prefix|ua--M/H-key|ua--deactivate|ua--fallback|ua--filter-buffer-noprops|ua--init-keymaps|ua--keep-active|ua--post-command-handler-1|ua--post-command-handler|ua--pre-command-handler-1|ua--pre-command-handler|ua--prefix-arg|ua--prefix-copy-handler|ua--prefix-cut-handler|ua--prefix-override-handler|ua--prefix-override-replay|ua--prefix-override-timeout|ua--prefix-repeat-handler|ua--select-keymaps|ua--self-insert-char-p|ua--shift-control-c-prefix|ua--shift-control-prefix|ua--shift-control-x-prefix|ua--update-indications|ua-cancel|ua-copy-region|ua-cut-region|ua-debug|ua-delete-region|ua-exchange-point-and-mark|ua-help-for-region|ua-mode|ua-paste-pop|ua-paste|ua-pop-to-last-change|ua-rectangle-mark-mode|ua-scroll-down|ua-scroll-up|ua-selection-mode|ua-set-mark|ua-set-rectangle-mark|ua-toggle-global-mark|urrent-line|ustom--frame-color-default|ustom--initialize-widget-variables|ustom--sort-vars-1|ustom--sort-vars|ustom-add-dependencies|ustom-add-link|ustom-add-load|ustom-add-option|ustom-add-package-version|ustom-add-parent-links|ustom-add-see-also|ustom-add-to-group|ustom-add-version|ustom-autoload|ustom-available-themes|ustom-browse-face-tag-action|ustom-browse-group-tag-action|ustom-browse-insert-prefix|ustom-browse-variable-tag-action|ustom-browse-visibility-action|ustom-buffer-create-internal|ustom-buffer-create-other-window|ustom-buffer-create|ustom-check-theme|ustom-command-apply|ustom-comment-create|ustom-comment-hide|ustom-comment-invisible-p|ustom-comment-show|ustom-convert-widget|ustom-current-group|ustom-declare-face|ustom-declare-group|ustom-declare-theme|ustom-declare-variable|ustom-face-action|ustom-face-attributes-get|ustom-face-edit-activate|ustom-face-edit-all|ustom-face-edit-attribute-tag|ustom-face-edit-convert-widget)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(?:custom-face-edit-deactivate|custom-face-edit-delete|custom-face-edit-fix-value|custom-face-edit-lisp|custom-face-edit-selected|custom-face-edit-value-create|custom-face-edit-value-visibility-action|custom-face-get-current-spec|custom-face-mark-to-reset-standard|custom-face-mark-to-save|custom-face-menu-create|custom-face-reset-saved|custom-face-reset-standard|custom-face-save-command|custom-face-save|custom-face-set|custom-face-standard-value|custom-face-state-set-and-redraw|custom-face-state-set|custom-face-state|custom-face-value-create|custom-face-widget-to-spec|custom-facep|custom-file|custom-filter-face-spec|custom-fix-face-spec|custom-get-fresh-buffer|custom-group-action|custom-group-link-action|custom-group-mark-to-reset-standard|custom-group-mark-to-save|custom-group-members|custom-group-menu-create|custom-group-of-mode|custom-group-reset-current|custom-group-reset-saved|custom-group-reset-standard|custom-group-sample-face-get|custom-group-save|custom-group-set|custom-group-state-set-and-redraw|custom-group-state-update|custom-group-value-create|custom-group-visibility-create|custom-guess-type|custom-handle-all-keywords|custom-handle-keyword|custom-hook-convert-widget|custom-initialize-changed|custom-initialize-default|custom-initialize-reset|custom-initialize-set|custom-load-symbol|custom-load-widget|custom-magic-reset|custom-magic-value-create|custom-make-theme-feature|custom-menu-create|custom-menu-filter|custom-mode|custom-note-var-changed|custom-notify|custom-post-filter-face-spec|custom-pre-filter-face-spec|custom-prefix-add|custom-prompt-customize-unsaved-options|custom-prompt-variable|custom-push-theme|custom-put-if-not|custom-quote|custom-redraw-magic|custom-redraw|custom-reset-faces|custom-reset-standard-save-and-update|custom-reset-variables|custom-reset|custom-save-all|custom-save-delete|custom-save-faces|custom-save-variables|custom-set-default|custom-set-minor-mode|custom-show|custom-sort-items|custom-split-regexp-maybe|custom-state-buffer-message|custom-tag-action|custom-tag-mouse-down-action|custom-theme--load-path|custom-theme-enabled-p|custom-theme-load-confirm|custom-theme-name-valid-p|custom-theme-recalc-face|custom-theme-recalc-variable|custom-theme-reset-faces|custom-theme-reset-variables|custom-theme-visit-theme|custom-toggle-hide-face|custom-toggle-hide-variable|custom-toggle-hide|custom-toggle-parent|custom-unlispify-menu-entry|custom-unlispify-tag-name|custom-unloaded-symbol-p|custom-unloaded-widget-p|custom-unsaved-options|custom-variable-action|custom-variable-backup-value|custom-variable-documentation|custom-variable-edit-lisp|custom-variable-edit|custom-variable-mark-to-reset-standard|custom-variable-mark-to-save|custom-variable-menu-create|custom-variable-prompt|custom-variable-reset-backup|custom-variable-reset-saved|custom-variable-reset-standard|custom-variable-save|custom-variable-set|custom-variable-standard-value|custom-variable-state-set-and-redraw|custom-variable-state-set|custom-variable-state|custom-variable-theme-value|custom-variable-type|custom-variable-value-create|customize-apropos-faces|customize-apropos-groups|customize-apropos-options|customize-apropos|customize-browse|customize-changed-options|customize-changed|customize-create-theme|customize-customized|customize-face-other-window|customize-face|customize-group-other-window|customize-group|customize-mark-as-set|customize-mark-to-save|customize-menu-create|customize-mode|customize-object|customize-option-other-window|customize-option|customize-package-emacs-version|customize-project|customize-push-and-save|customize-read-group|customize-rogue|customize-save-customized|customize-save-variable|customize-saved|customize-set-value|customize-set-variable|customize-target|customize-themes|customize-unsaved|customize-variable-other-window|customize-variable|customize-version-lessp|customize|cvs-add-branch-prefix|cvs-add-face|cvs-add-secondary-branch-prefix|cvs-addto-collection|cvs-append-to-ignore|cvs-append|cvs-applicable-p|cvs-buffer-check|cvs-buffer-p|cvs-bury-buffer|cvs-car|cvs-cdr|cvs-change-cvsroot|cvs-check-fileinfo|cvs-checkout|cvs-cleanup-collection|cvs-cleanup-removed|cvs-cmd-do|cvs-commit-filelist|cvs-commit-minor-wrap|cvs-create-fileinfo|cvs-defaults|cvs-diff-backup-extractor|cvs-dir-member-p|cvs-dired-noselect|cvs-do-commit|cvs-do-edit-log|cvs-do-match|cvs-do-removal|cvs-ediff-diff|cvs-ediff-exit-hook|cvs-ediff-merge|cvs-ediff-startup-hook|cvs-edit-log-filelist|cvs-edit-log-minor-wrap|cvs-edit-log-text-at-point|cvs-emerge-diff|cvs-emerge-merge|cvs-enabledp|cvs-every|cvs-examine|cvs-execute-single-file-list|cvs-execute-single-file|cvs-expand-dir-name|cvs-file-to-string|cvs-fileinfo->backup-file|cvs-fileinfo->base-rev--cmacro|cvs-fileinfo->base-rev|cvs-fileinfo->dir--cmacro|cvs-fileinfo->dir|cvs-fileinfo->file--cmacro|cvs-fileinfo->file|cvs-fileinfo->full-log--cmacro|cvs-fileinfo->full-log|cvs-fileinfo->full-name|cvs-fileinfo->full-path|cvs-fileinfo->head-rev--cmacro|cvs-fileinfo->head-rev|cvs-fileinfo->marked--cmacro|cvs-fileinfo->marked|cvs-fileinfo->merge--cmacro|cvs-fileinfo->merge|cvs-fileinfo->pp-name|cvs-fileinfo->subtype--cmacro|cvs-fileinfo->subtype|cvs-fileinfo->type--cmacro|cvs-fileinfo->type|cvs-fileinfo-from-entries|cvs-fileinfo-p--cmacro|cvs-fileinfo-pp??|cvs-fileinfo-update|cvs-fileinfo<|cvs-find-modif|cvs-first|cvs-flags-defaults--cmacro|cvs-flags-defaults|cvs-flags-define|cvs-flags-desc--cmacro|cvs-flags-desc|cvs-flags-hist-sym--cmacro|cvs-flags-hist-sym|cvs-flags-p--cmacro|cvs-flags-p|cvs-flags-persist--cmacro|cvs-flags-persist|cvs-flags-qtypedesc--cmacro|cvs-flags-qtypedesc|cvs-flags-query|cvs-flags-set|cvs-get-buffer-create|cvs-get-cvsroot|cvs-get-marked|cvs-get-module|cvs-global-menu|cvs-header-msg|cvs-help|cvs-ignore-marks-p|cvs-insert-file|cvs-insert-strings|cvs-insert-visited-file|cvs-is-within-p|cvs-make-cvs-buffer|cvs-map|cvs-mark-buffer-changed|cvs-mark-fis-dead|cvs-match|cvs-menu|cvs-minor-mode|cvs-mode!|cvs-mode-acknowledge|cvs-mode-add-change-log-entry-other-window|cvs-mode-add|cvs-mode-byte-compile-files|cvs-mode-checkout|cvs-mode-commit-setup|cvs-mode-commit|cvs-mode-delete-lock|cvs-mode-diff-1|cvs-mode-diff-backup|cvs-mode-diff-head|cvs-mode-diff-map|cvs-mode-diff-repository|cvs-mode-diff-vendor|cvs-mode-diff-yesterday|cvs-mode-diff|cvs-mode-display-file|cvs-mode-do|cvs-mode-edit-log|cvs-mode-examine|cvs-mode-files|cvs-mode-find-file-other-window|cvs-mode-find-file|cvs-mode-force-command|cvs-mode-idiff-other|cvs-mode-idiff|cvs-mode-ignore|cvs-mode-imerge|cvs-mode-insert|cvs-mode-kill-buffers|cvs-mode-kill-process|cvs-mode-log|cvs-mode-map|cvs-mode-mark-all-files|cvs-mode-mark-get-modif|cvs-mode-mark-matching-files|cvs-mode-mark-on-state|cvs-mode-mark|cvs-mode-marked|cvs-mode-next-line|cvs-mode-previous-line|cvs-mode-quit|cvs-mode-remove-handled|cvs-mode-remove|cvs-mode-revert-buffer|cvs-mode-revert-to-rev|cvs-mode-run|cvs-mode-set-flags|cvs-mode-status|cvs-mode-tag|cvs-mode-toggle-marks??|cvs-mode-tree|cvs-mode-undo|cvs-mode-unmark-all-files|cvs-mode-unmark-up|cvs-mode-unmark|cvs-mode-untag|cvs-mode-update|cvs-mode-view-file-other-window|cvs-mode-view-file|cvs-mode|cvs-mouse-toggle-mark|cvs-move-to-goal-column|cvs-or|cvs-parse-buffer|cvs-parse-commit|cvs-parse-merge|cvs-parse-msg|cvs-parse-process|cvs-parse-run-table|cvs-parse-status|cvs-parse-table|cvs-parsed-fileinfo|cvs-partition|cvs-pop-to-buffer-same-frame|cvs-prefix-define|cvs-prefix-get|cvs-prefix-make-local|cvs-prefix-set|cvs-prefix-sym|cvs-qtypedesc-complete--cmacro|cvs-qtypedesc-complete|cvs-qtypedesc-create--cmacro|cvs-qtypedesc-create|cvs-qtypedesc-hist-sym--cmacro|cvs-qtypedesc-hist-sym|cvs-qtypedesc-obj2str--cmacro|cvs-qtypedesc-obj2str|cvs-qtypedesc-p--cmacro|cvs-qtypedesc-p|cvs-qtypedesc-require--cmacro|cvs-qtypedesc-require|cvs-qtypedesc-str2obj--cmacro|cvs-qtypedesc-str2obj|cvs-query-directory|cvs-query-read|cvs-quickdir|cvs-reread-cvsrc|cvs-retrieve-revision|cvs-revert-if-needed|cvs-run-process|cvs-sentinel|cvs-set-branch-prefix|cvs-set-secondary-branch-prefix|cvs-status-current-file|cvs-status-current-tag|cvs-status-cvstrees|cvs-status-get-tags|cvs-status-minor-wrap|cvs-status-mode|cvs-status-next|cvs-status-prev|cvs-status-trees|cvs-status-vl-to-str|cvs-status|cvs-string-prefix-p|cvs-tag->name--cmacro|cvs-tag->name|cvs-tag->string|cvs-tag->type--cmacro|cvs-tag->type|cvs-tag->vlist--cmacro|cvs-tag->vlist|cvs-tag-compare-1|cvs-tag-compare|cvs-tag-lessp|cvs-tag-make--cmacro|cvs-tag-make-tag|cvs-tag-make|cvs-tag-merge|cvs-tag-p--cmacro|cvs-tag-p|cvs-tags->tree|cvs-tags-list|cvs-temp-buffer|cvs-tree-merge|cvs-tree-print|cvs-tree-tags-insert|cvs-union|cvs-update-filter|cvs-update-header|cvs-update|cvs-vc-command-advice|cwarn-font-lock-keywords|cwarn-font-lock-match-assignment-in-expression|cwarn-font-lock-match-dangerous-semicolon|cwarn-font-lock-match-reference|cwarn-font-lock-match|cwarn-inside-macro|cwarn-is-enabled|cwarn-mode-set-explicitly|cwarn-mode|cycle-spacing|cyrillic-encode-alternativnyj-char|cyrillic-encode-koi8-r-char|dabbrev--abbrev-at-point|dabbrev--find-all-expansions|dabbrev--find-expansion|dabbrev--goto-start-of-abbrev|dabbrev--ignore-buffer-p|dabbrev--ignore-case-p|dabbrev--make-friend-buffer-list|dabbrev--minibuffer-origin|dabbrev--reset-global-variables|dabbrev--safe-replace-match|dabbrev--same-major-mode-p|dabbrev--search|dabbrev--select-buffers|dabbrev--substitute-expansion|dabbrev--try-find|dabbrev-completion|dabbrev-expand|dabbrev-filter-elements|daemon-initialized|daemonp|data-debug-new-buffer|date-to-day|days-between|days-to-time|dbus--init-bus|dbus-byte-array-to-string|dbus-call-method-handler|dbus-check-event|dbus-escape-as-identifier|dbus-event-bus-name|dbus-event-interface-name|dbus-event-member-name|dbus-event-message-type|dbus-event-path-name|dbus-event-serial-number|dbus-event-service-name|dbus-get-all-managed-objects|dbus-get-all-properties|dbus-get-name-owner|dbus-get-property|dbus-get-unique-name|dbus-handle-bus-disconnect|dbus-handle-event|dbus-ignore-errors|dbus-init-bus|dbus-introspect-get-all-nodes|dbus-introspect-get-annotation-names|dbus-introspect-get-annotation|dbus-introspect-get-argument-names|dbus-introspect-get-argument|dbus-introspect-get-attribute|dbus-introspect-get-interface-names|dbus-introspect-get-interface|dbus-introspect-get-method-names|dbus-introspect-get-method|dbus-introspect-get-node-names|dbus-introspect-get-property-names|dbus-introspect-get-property|dbus-introspect-get-signal-names|dbus-introspect-get-signal|dbus-introspect-get-signature|dbus-introspect-xml|dbus-introspect|dbus-list-activatable-names|dbus-list-hash-table|dbus-list-known-names|dbus-list-names|dbus-list-queued-owners|dbus-managed-objects-handler|dbus-message-internal|dbus-method-error-internal|dbus-method-return-internal|dbus-notice-synchronous-call-errors|dbus-peer-handler|dbus-ping|dbus-property-handler|dbus-register-method|dbus-register-property|dbus-register-service|dbus-register-signal|dbus-set-property|dbus-setenv|dbus-string-to-byte-array|dbus-unescape-from-identifier|dbus-unregister-object|dbus-unregister-service|dbx|dcl-back-to-indentation-1|dcl-back-to-indentation|dcl-backward-command|dcl-beginning-of-command-p|dcl-beginning-of-command|dcl-beginning-of-statement|dcl-calc-command-indent-hang|dcl-calc-command-indent-multiple|dcl-calc-command-indent|dcl-calc-cont-indent-relative|dcl-calc-continuation-indent|dcl-command-p|dcl-delete-chars|dcl-delete-indentation|dcl-electric-character|dcl-end-of-command-p|dcl-end-of-command|dcl-end-of-statement|dcl-forward-command|dcl-get-line-type|dcl-guess-option-value|dcl-guess-option|dcl-imenu-create-index-function|dcl-indent-command-line|dcl-indent-command|dcl-indent-continuation-line|dcl-indent-line|dcl-indent-to|dcl-indentation-point|dcl-mode|dcl-option-value-basic|dcl-option-value-comment-line|dcl-option-value-margin-offset|dcl-option-value-offset|dcl-save-all-options|dcl-save-local-variable|dcl-save-mode|dcl-save-nondefault-options|dcl-save-option|dcl-set-option|dcl-show-line-type|dcl-split-line|dcl-tab|dcl-was-looking-at|deactivate-input-method|deactivate-mode-local-bindings|debug--function-list|debug--implement-debug-on-entry|debug-help-follow|debugger--backtrace-base|debugger--hide-locals|debugger--insert-locals|debugger--locals-visible-p|debugger--show-locals)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)d(?:ebugger-continue|ebugger-env-macro|ebugger-eval-expression|ebugger-frame-clear|ebugger-frame-number|ebugger-frame|ebugger-jump|ebugger-list-functions|ebugger-make-xrefs|ebugger-mode|ebugger-record-expression|ebugger-reenable|ebugger-return-value|ebugger-setup-buffer|ebugger-step-through|ebugger-toggle-locals|ecf|ecipher--analyze|ecipher--digram-counts|ecipher--digram-total|ecipher-add-undo|ecipher-adjacency-list|ecipher-alphabet-keypress|ecipher-analyze-buffer|ecipher-analyze|ecipher-complete-alphabet|ecipher-copy-cons|ecipher-digram-list|ecipher-display-range|ecipher-display-regexp|ecipher-display-stats-buffer|ecipher-frequency-count|ecipher-get-undo|ecipher-insert-frequency-counts|ecipher-insert|ecipher-keypress|ecipher-last-command-char|ecipher-loop-no-breaks|ecipher-loop-with-breaks|ecipher-make-checkpoint|ecipher-mode|ecipher-read-alphabet|ecipher-restore-checkpoint|ecipher-resync|ecipher-set-map|ecipher-show-alphabet|ecipher-stats-buffer|ecipher-stats-mode|ecipher-undo|ecipher|eclaim|eclare-ccl-program|eclare-equiv-charset|ecode-big5-char|ecode-composition-components|ecode-composition-rule|ecode-hex-string|ecode-hz-buffer|ecode-hz-region|ecode-sjis-char|ecompose-region|ecompose-string|ecrease-left-margin|ecrease-right-margin|ef-gdb-auto-update-handler|ef-gdb-auto-update-trigger|ef-gdb-memory-format|ef-gdb-memory-show-page|ef-gdb-memory-unit|ef-gdb-preempt-display-buffer|ef-gdb-set-positive-number|ef-gdb-thread-buffer-command|ef-gdb-thread-buffer-gud-command|ef-gdb-thread-buffer-simple-command|ef-gdb-trigger-and-handler|efault-command-history-filter|efault-font-height|efault-indent-new-line|efault-line-height|efault-toplevel-value|efcalcmodevar|efconst-mode-local|efcustom-c-stylevar|efcustom-mh|efezimage|efface-mh|efgeneric|efgroup-mh|efimage-speedbar|efine-abbrevs|efine-advice|efine-auto-insert|efine-ccl-program|efine-char-code-property|efine-charset-alias|efine-charset-internal|efine-charset|efine-child-mode|efine-coding-system-alias|efine-coding-system-internal|efine-coding-system|efine-compilation-mode|efine-compiler-macro|efine-erc-module|efine-erc-response-handler|efine-global-abbrev|efine-global-minor-mode|efine-hmac-function|efine-ibuffer-column|efine-ibuffer-filter|efine-ibuffer-op|efine-ibuffer-sorter|efine-inline|efine-lex-analyzer|efine-lex-block-analyzer|efine-lex-block-type-analyzer|efine-lex-keyword-type-analyzer|efine-lex-regex-analyzer|efine-lex-regex-type-analyzer|efine-lex-sexp-type-analyzer|efine-lex-simple-regex-analyzer|efine-lex-string-type-analyzer|efine-lex|efine-mail-abbrev|efine-mail-alias|efine-mail-user-agent|efine-mode-abbrev|efine-mode-local-override|efine-mode-overload-implementation|efine-overload|efine-overloadable-function|efine-setf-expander|efine-skeleton|efine-translation-hash-table|efine-translation-table|efine-widget-keywords|efmacro-mh|efmath|efmethod|efun-cvs-mode|efun-gmm|efun-mh|efun-rcirc-command|efvar-mode-local|egrees-to-radians|ehexlify-buffer|elay-warning|elete\\\\*|elete-active-region|elete-all-overlays|elete-completion-window|elete-completion|elete-consecutive-dups|elete-dir-local-variable|elete-directory-internal|elete-duplicate-lines|elete-duplicates|elete-extract-rectangle-line|elete-extract-rectangle|elete-file-local-variable-prop-line|elete-file-local-variable|elete-forward-char|elete-frame-enabled-p|elete-if-not|elete-if|elete-instance|elete-matching-lines|elete-non-matching-lines|elete-other-frames|elete-other-windows-internal|elete-other-windows-vertically|elete-pair|elete-rectangle-line|elete-rectangle|elete-selection-helper|elete-selection-mode|elete-selection-pre-hook|elete-selection-repeat-replace-region|elete-side-window|elete-whitespace-rectangle-line|elete-whitespace-rectangle|elete-window-internal|elimit-columns-customize|elimit-columns-format|elimit-columns-rectangle-line|elimit-columns-rectangle-max|elimit-columns-rectangle|elimit-columns-region|elimit-columns-str|elphi-mode|elsel-unload-function|enato-region|erived-mode-abbrev-table-name|erived-mode-class|erived-mode-hook-name|erived-mode-init-mode-variables|erived-mode-make-docstring|erived-mode-map-name|erived-mode-merge-abbrev-tables|erived-mode-merge-keymaps|erived-mode-merge-syntax-tables|erived-mode-run-hooks|erived-mode-set-abbrev-table|erived-mode-set-keymap|erived-mode-set-syntax-table|erived-mode-setup-function-name|erived-mode-syntax-table-name|escribe-bindings-internal|escribe-buffer-bindings|escribe-char-after|escribe-char-categories|escribe-char-display|escribe-char-padded-string|escribe-char-unicode-data|escribe-char|escribe-character-set|escribe-chinese-environment-map|escribe-coding-system|escribe-copying|escribe-current-coding-system-briefly|escribe-current-coding-system|escribe-current-input-method|escribe-cyrillic-environment-map|escribe-distribution|escribe-european-environment-map|escribe-face|escribe-font|escribe-fontset|escribe-function-1|escribe-function|escribe-gnu-project|escribe-indian-environment-map|escribe-input-method|escribe-key-briefly|escribe-key|escribe-language-environment|escribe-minor-mode-completion-table-for-indicator|escribe-minor-mode-completion-table-for-symbol|escribe-minor-mode-from-indicator|escribe-minor-mode-from-symbol|escribe-minor-mode|escribe-mode-local-bindings-in-mode|escribe-mode-local-bindings|escribe-no-warranty|escribe-package-1|escribe-package|escribe-project|escribe-property-list|escribe-register-1|escribe-specified-language-support|escribe-text-category|escribe-text-properties-1|escribe-text-properties|escribe-text-sexp|escribe-text-widget|escribe-theme|escribe-variable-custom-version-info|escribe-variable|escribe-vector|esktop--check-dont-save|esktop--v2s|esktop-append-buffer-args|esktop-auto-save-cancel-timer|esktop-auto-save-disable|esktop-auto-save-enable|esktop-auto-save-set-timer|esktop-auto-save|esktop-buffer-info|esktop-buffer|esktop-change-dir|esktop-claim-lock|esktop-clear|esktop-create-buffer|esktop-file-name|esktop-full-file-name|esktop-full-lock-name|esktop-idle-create-buffers|esktop-kill|esktop-lazy-abort|esktop-lazy-complete|esktop-lazy-create-buffer|esktop-list\\\\*|esktop-load-default|esktop-load-file|esktop-outvar|esktop-owner|esktop-read|esktop-release-lock|esktop-remove|esktop-restore-file-buffer|esktop-restore-frameset|esktop-restoring-frameset-p|esktop-revert|esktop-save-buffer-p|esktop-save-frameset|esktop-save-in-desktop-dir|esktop-save-mode-off|esktop-save-mode|esktop-save|esktop-truncate|esktop-value-to-string|estructor|estructuring-bind|etect-coding-with-language-environment|etect-coding-with-priority|frame-attached-frame|frame-click|frame-close-frame|frame-current-frame|frame-detach|frame-double-click|frame-frame-mode|frame-frame-parameter|frame-get-focus|frame-hack-buffer-menu|frame-handle-delete-frame|frame-handle-iconify-frame|frame-handle-make-frame-visible|frame-help-echo|frame-live-p|frame-maybee-jump-to-attached-frame|frame-message|frame-mouse-event-p|frame-mouse-hscroll|frame-mouse-set-point|frame-needed-height|frame-popup-kludge|frame-power-click|frame-quick-mouse|frame-reposition-frame-emacs|frame-reposition-frame-xemacs|frame-reposition-frame|frame-select-attached-frame|frame-set-timer-internal|frame-set-timer|frame-switch-buffer-attached-frame|frame-temp-buffer-show-function|frame-timer-fn|frame-track-mouse-xemacs|frame-track-mouse|frame-update-keymap|frame-with-attached-buffer|frame-y-or-n-p|iary-add-to-list|iary-anniversary|iary-astro-day-number|iary-attrtype-convert|iary-bahai-date|iary-bahai-insert-entry|iary-bahai-insert-monthly-entry|iary-bahai-insert-yearly-entry|iary-bahai-list-entries|iary-bahai-mark-entries|iary-block|iary-check-diary-file|iary-chinese-anniversary|iary-chinese-date|iary-chinese-insert-anniversary-entry|iary-chinese-insert-entry|iary-chinese-insert-monthly-entry|iary-chinese-insert-yearly-entry|iary-chinese-list-entries|iary-chinese-mark-entries|iary-coptic-date|iary-cyclic|iary-date-display-form|iary-date|iary-day-of-year|iary-display-no-entries|iary-entry-compare|iary-entry-time|iary-ethiopic-date|iary-fancy-date-matcher|iary-fancy-date-pattern|iary-fancy-display-mode|iary-fancy-display|iary-fancy-font-lock-fontify-region-function|iary-float|iary-font-lock-date-forms|iary-font-lock-keywords-1|iary-font-lock-keywords|iary-font-lock-sexps|iary-french-date|iary-from-outlook-gnus|iary-from-outlook-internal|iary-from-outlook-rmail|iary-from-outlook|iary-goto-entry|iary-hebrew-birthday|iary-hebrew-date|iary-hebrew-insert-entry|iary-hebrew-insert-monthly-entry|iary-hebrew-insert-yearly-entry|iary-hebrew-list-entries|iary-hebrew-mark-entries|iary-hebrew-omer|iary-hebrew-parasha|iary-hebrew-rosh-hodesh|iary-hebrew-sabbath-candles|iary-hebrew-yahrzeit|iary-include-files|iary-include-other-diary-files|iary-insert-anniversary-entry|iary-insert-block-entry|iary-insert-cyclic-entry|iary-insert-entry-1|iary-insert-entry|iary-insert-monthly-entry|iary-insert-weekly-entry|iary-insert-yearly-entry|iary-islamic-date|iary-islamic-insert-entry|iary-islamic-insert-monthly-entry|iary-islamic-insert-yearly-entry|iary-islamic-list-entries|iary-islamic-mark-entries|iary-iso-date|iary-julian-date|iary-list-entries-1|iary-list-entries-2|iary-list-entries|iary-list-sexp-entries|iary-live-p|iary-lunar-phases|iary-mail-entries|iary-make-date|iary-make-entry|iary-mark-entries-1|iary-mark-entries|iary-mark-included-diary-files|iary-mark-sexp-entries|iary-mayan-date|iary-mode|iary-name-pattern|iary-ordinal-suffix|iary-outlook-format-1|iary-persian-date|iary-print-entries|iary-pull-attrs|iary-redraw-calendar|iary-remind|iary-set-header|iary-set-maybe-redraw|iary-sexp-entry|iary-show-all-entries|iary-simple-display|iary-sort-entries|iary-sunrise-sunset|iary-unhide-everything|iary-view-entries|iary-view-other-diary-entries|iary|iff-add-change-log-entries-other-window|iff-after-change-function|iff-apply-hunk|iff-auto-refine-mode|iff-backup|iff-beginning-of-file-and-junk|iff-beginning-of-file|iff-beginning-of-hunk|iff-bounds-of-file|iff-bounds-of-hunk|iff-buffer-with-file|iff-context->unified|iff-count-matches|iff-current-defun|iff-delete-empty-files|iff-delete-if-empty|iff-delete-trailing-whitespace|iff-ediff-patch|iff-end-of-file|iff-end-of-hunk|iff-file-kill|iff-file-local-copy|iff-file-next|iff-file-prev|iff-filename-drop-dir|iff-find-approx-text|iff-find-file-name|iff-find-source-location|iff-find-text|iff-fixup-modifs|iff-goto-source|iff-hunk-file-names|iff-hunk-kill|iff-hunk-next|iff-hunk-prev|iff-hunk-status-msg|iff-hunk-style|iff-hunk-text|iff-ignore-whitespace-hunk|iff-kill-applied-hunks|iff-kill-junk|iff-latest-backup-file|iff-make-unified|iff-merge-strings|iff-minor-mode|iff-mode-menu|iff-mode|iff-mouse-goto-source|iff-next-complex-hunk|iff-next-error|iff-no-select|iff-post-command-hook|iff-process-filter|iff-refine-hunk|iff-refine-preproc|iff-restrict-view|iff-reverse-direction|iff-sanity-check-context-hunk-half|iff-sanity-check-hunk|iff-sentinel|iff-setup-whitespace|iff-split-hunk|iff-splittable-p|iff-switches|iff-tell-file-name|iff-test-hunk|iff-undo|iff-unified->context|iff-unified-hunk-p|iff-write-contents-hooks|iff-xor|iff-yank-function|iff|ig-exit|ig-extract-rr|ig-invoke|ig-mode|ig-rr-get-pkix-cert|ig|igest-md5-challenge|igest-md5-digest-response|igest-md5-digest-uri|igest-md5-parse-digest-challenge|ir-locals-collect-mode-variables|ir-locals-collect-variables|ir-locals-find-file|ir-locals-get-class-variables|ir-locals-read-from-file|irectory-files-recursively|irectory-name-p|ired-add-file|ired-advertise|ired-advertised-find-file|ired-align-file|ired-alist-add-1|ired-at-point-prompter|ired-at-point|ired-backup-diff|ired-between-files|ired-buffer-stale-p|ired-buffers-for-dir|ired-build-subdir-alist|ired-change-marks|ired-check-switches|ired-clean-directory|ired-clean-up-after-deletion|ired-clear-alist|ired-compare-directories|ired-compress-file|ired-copy-file|ired-copy-filename-as-kill|ired-create-directory)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(?:dired-current-directory|dired-delete-entry|dired-delete-file|dired-desktop-buffer-misc-data|dired-diff|dired-directory-changed-p|dired-display-file|dired-dnd-do-ask-action|dired-dnd-handle-file|dired-dnd-handle-local-file|dired-dnd-popup-notice|dired-do-async-shell-command|dired-do-byte-compile|dired-do-chgrp|dired-do-chmod|dired-do-chown|dired-do-compress|dired-do-copy-regexp|dired-do-copy|dired-do-create-files-regexp|dired-do-delete|dired-do-flagged-delete|dired-do-hardlink-regexp|dired-do-hardlink|dired-do-isearch-regexp|dired-do-isearch|dired-do-kill-lines|dired-do-load|dired-do-print|dired-do-query-replace-regexp|dired-do-redisplay|dired-do-relsymlink|dired-do-rename-regexp|dired-do-rename|dired-do-search|dired-do-shell-command|dired-do-symlink-regexp|dired-do-symlink|dired-do-touch|dired-downcase|dired-file-marker|dired-file-name-at-point|dired-find-alternate-file|dired-find-buffer-nocreate|dired-find-file-other-window|dired-find-file|dired-flag-auto-save-files|dired-flag-backup-files|dired-flag-file-deletion|dired-flag-files-regexp|dired-flag-garbage-files|dired-format-columns-of-files|dired-fun-in-all-buffers|dired-get-file-for-visit|dired-get-filename|dired-get-marked-files|dired-get-subdir-max|dired-get-subdir-min|dired-get-subdir|dired-glob-regexp|dired-goto-file-1|dired-goto-file|dired-goto-next-file|dired-goto-next-nontrivial-file|dired-goto-subdir|dired-hide-all|dired-hide-details-mode|dired-hide-details-update-invisibility-spec|dired-hide-subdir|dired-in-this-tree|dired-initial-position|dired-insert-directory|dired-insert-old-subdirs|dired-insert-set-properties|dired-insert-subdir|dired-internal-do-deletions|dired-internal-noselect|dired-isearch-filenames-regexp|dired-isearch-filenames-setup|dired-isearch-filenames|dired-jump-other-window|dired-jump|dired-kill-subdir|dired-log-summary|dired-log|dired-make-absolute|dired-make-relative|dired-map-over-marks|dired-mark-directories|dired-mark-executables|dired-mark-files-containing-regexp|dired-mark-files-in-region|dired-mark-files-regexp|dired-mark-if|dired-mark-pop-up|dired-mark-prompt|dired-mark-remembered|dired-mark-subdir-files|dired-mark-symlinks|dired-mark|dired-marker-regexp|dired-maybe-insert-subdir|dired-mode|dired-mouse-find-file-other-window|dired-move-to-end-of-filename|dired-move-to-filename|dired-next-dirline|dired-next-line|dired-next-marked-file|dired-next-subdir|dired-normalize-subdir|dired-noselect|dired-other-frame|dired-other-window|dired-plural-s|dired-pop-to-buffer|dired-prev-dirline|dired-prev-marked-file|dired-prev-subdir|dired-previous-line|dired-query|dired-read-dir-and-switches|dired-read-regexp|dired-readin-insert|dired-readin|dired-relist-file|dired-remember-hidden|dired-remember-marks|dired-remove-file|dired-rename-file|dired-repeat-over-lines|dired-replace-in-string|dired-restore-desktop-buffer|dired-restore-positions|dired-revert|dired-run-shell-command|dired-safe-switches-p|dired-save-positions|dired-show-file-type|dired-sort-R-check|dired-sort-other|dired-sort-set-mode-line|dired-sort-set-modeline|dired-sort-toggle-or-edit|dired-sort-toggle|dired-string-replace-match|dired-subdir-index|dired-subdir-max|dired-summary|dired-switches-escape-p|dired-switches-recursive-p|dired-toggle-marks|dired-toggle-read-only|dired-tree-down|dired-tree-up|dired-unadvertise|dired-uncache|dired-undo|dired-unmark-all-files|dired-unmark-all-marks|dired-unmark-backward|dired-unmark|dired-up-directory|dired-upcase|dired-view-file|dired-why|dired|dirs|dirtrack-cygwin-directory-function|dirtrack-debug-message|dirtrack-debug-mode|dirtrack-debug-toggle|dirtrack-mode|dirtrack-toggle|dirtrack-windows-directory-function|dirtrack|disable-timeout|disassemble-1|disassemble-internal|disassemble-offset|display-about-screen|display-battery-mode|display-buffer--maybe-pop-up-frame-or-window|display-buffer--maybe-same-window|display-buffer--special-action|display-buffer-assq-regexp|display-buffer-in-atom-window|display-buffer-in-major-side-window|display-buffer-in-side-window|display-buffer-other-frame|display-buffer-record-window|display-call-tree|display-local-help|display-multi-font-p|display-multi-frame-p|display-splash-screen|display-startup-echo-area-message|display-startup-screen|display-table-print-array|display-time-mode|display-time-world|display-time|displaying-byte-compile-warnings|dissociated-press|dnd-get-local-file-name|dnd-get-local-file-uri|dnd-handle-one-url|dnd-insert-text|dnd-open-file|dnd-open-local-file|dnd-open-remote-url|dnd-unescape-uri|dns-get-txt-answer|dns-get|dns-inverse-get|dns-lookup-host|dns-make-network-process|dns-mode-menu|dns-mode-soa-increment-serial|dns-mode-soa-maybe-increment-serial|dns-mode|dns-query-cached|dns-query|dns-read-bytes|dns-read-int32|dns-read-name|dns-read-string-name|dns-read-txt|dns-read-type|dns-read|dns-servers-up-to-date-p|dns-set-servers|dns-write-bytes|dns-write-name|dns-write|dnsDomainIs|dnsResolve|do\\\\*|do-after-load-evaluation|do-all-symbols|do-auto-fill|do-symbols|do|doc\\\\$|doc//|doc-file-to-info|doc-file-to-man|doc-view--current-cache-dir|doc-view-active-pages|doc-view-already-converted-p|doc-view-bookmark-jump|doc-view-bookmark-make-record|doc-view-buffer-message|doc-view-clear-cache|doc-view-clone-buffer-hook|doc-view-convert-current-doc|doc-view-current-cache-doc-pdf|doc-view-current-image|doc-view-current-info|doc-view-current-overlay|doc-view-current-page|doc-view-current-slice|doc-view-desktop-save-buffer|doc-view-dired-cache|doc-view-display|doc-view-djvu->tiff-converter-ddjvu|doc-view-doc->txt|doc-view-document->bitmap|doc-view-dvi->pdf|doc-view-enlarge|doc-view-fallback-mode|doc-view-first-page|doc-view-fit-height-to-window|doc-view-fit-page-to-window|doc-view-fit-width-to-window|doc-view-get-bounding-box|doc-view-goto-page|doc-view-guess-paper-size|doc-view-initiate-display|doc-view-insert-image|doc-view-intersection|doc-view-kill-proc-and-buffer|doc-view-kill-proc|doc-view-last-page-number|doc-view-last-page|doc-view-make-safe-dir|doc-view-menu|doc-view-minor-mode|doc-view-mode-maybe|doc-view-mode-p|doc-view-mode|doc-view-new-window-function|doc-view-next-line-or-next-page|doc-view-next-page|doc-view-odf->pdf-converter-soffice|doc-view-odf->pdf-converter-unoconv|doc-view-open-text|doc-view-pdf/ps->png|doc-view-pdf->png-converter-ghostscript|doc-view-pdf->png-converter-mupdf|doc-view-pdf->txt|doc-view-previous-line-or-previous-page|doc-view-previous-page|doc-view-ps->pdf|doc-view-ps->png-converter-ghostscript|doc-view-reconvert-doc|doc-view-reset-slice|doc-view-restore-desktop-buffer|doc-view-revert-buffer|doc-view-scale-adjust|doc-view-scale-bounding-box|doc-view-scale-reset|doc-view-scroll-down-or-previous-page|doc-view-scroll-up-or-next-page|doc-view-search-backward|doc-view-search-internal|doc-view-search-next-match|doc-view-search-no-of-matches|doc-view-search-previous-match|doc-view-search|doc-view-sentinel|doc-view-set-doc-type|doc-view-set-slice-from-bounding-box|doc-view-set-slice-using-mouse|doc-view-set-slice|doc-view-set-up-single-converter|doc-view-show-tooltip|doc-view-shrink|doc-view-sort|doc-view-start-process|doc-view-toggle-display|doctex-font-lock-\\\\^\\\\^A|doctex-font-lock-syntactic-face-function|doctex-mode|doctor-\\\\$|doctor-adjectivep|doctor-adverbp|doctor-alcohol|doctor-articlep|doctor-assm|doctor-build|doctor-chat|doctor-colorp|doctor-concat|doctor-conj|doctor-correct-spelling|doctor-death|doctor-def|doctor-define|doctor-defq|doctor-desire1??|doctor-doc|doctor-drug|doctor-eliza|doctor-family|doctor-fear|doctor-fix-2|doctor-fixup|doctor-forget|doctor-foul|doctor-getnoun|doctor-go|doctor-hates??|doctor-hates1|doctor-howdy|doctor-huh|doctor-loves??|doctor-mach|doctor-make-string|doctor-math|doctor-meaning|doctor-mode|doctor-modifierp|doctor-mood|doctor-nmbrp|doctor-nounp|doctor-othermodifierp|doctor-plural|doctor-possess|doctor-possessivepronounp|doctor-prepp|doctor-pronounp|doctor-put-meaning|doctor-qloves|doctor-query|doctor-read-print|doctor-read-token|doctor-readin|doctor-remem|doctor-remember|doctor-replace|doctor-ret-or-read|doctor-rms|doctor-rthing|doctor-school|doctor-setprep|doctor-sexnoun|doctor-sexverb|doctor-short|doctor-shorten|doctor-sizep|doctor-sports|doctor-state|doctor-subjsearch|doctor-svo|doctor-symptoms|doctor-toke|doctor-txtype|doctor-type-symbol|doctor-type|doctor-verbp|doctor-vowelp|doctor-when|doctor-wherego|doctor-zippy|doctor|dom-add-child-before|dom-append-child|dom-attr|dom-attributes|dom-by-class|dom-by-id|dom-by-style|dom-by-tag|dom-child-by-tag|dom-children|dom-elements|dom-ensure-node|dom-node|dom-non-text-children|dom-parent|dom-pp|dom-set-attributes??|dom-tag|dom-texts??|dont-compile|double-column|double-mode|double-read-event|double-translate-key|down-ifdef|dsssl-mode|dunnet|dynamic-completion-mode|dynamic-completion-table|dynamic-setting-handle-config-changed-event|easy-menu-add-item|easy-menu-add|easy-menu-always-true-p|easy-menu-binding|easy-menu-change|easy-menu-convert-item-1|easy-menu-convert-item|easy-menu-create-menu|easy-menu-define-key|easy-menu-do-define|easy-menu-filter-return|easy-menu-get-map|easy-menu-intern|easy-menu-item-present-p|easy-menu-lookup-name|easy-menu-make-symbol|easy-menu-name-match|easy-menu-remove-item|easy-menu-remove|easy-menu-return-item|easy-mmode-define-global-mode|easy-mmode-define-keymap|easy-mmode-define-navigation|easy-mmode-define-syntax|easy-mmode-defmap|easy-mmode-defsyntax|easy-mmode-pretty-mode-name|easy-mmode-set-keymap-parents|ebnf-abn-initialize|ebnf-abn-parser|ebnf-adjust-empty|ebnf-adjust-width|ebnf-alternative-dimension|ebnf-alternative-width|ebnf-apply-style1??|ebnf-begin-file|ebnf-begin-job|ebnf-begin-line|ebnf-bnf-initialize|ebnf-bnf-parser|ebnf-boolean|ebnf-buffer-substring|ebnf-check-style-values|ebnf-customize|ebnf-delete-style|ebnf-despool|ebnf-dimensions|ebnf-directory|ebnf-dtd-initialize|ebnf-dtd-parser|ebnf-dup-list|ebnf-ebx-initialize|ebnf-ebx-parser|ebnf-element-width|ebnf-eliminate-empty-rules|ebnf-empty-alternative|ebnf-end-of-string|ebnf-entry|ebnf-eop-horizontal|ebnf-eop-vertical|ebnf-eps-add-context|ebnf-eps-add-production|ebnf-eps-buffer|ebnf-eps-directory|ebnf-eps-file|ebnf-eps-filename|ebnf-eps-finish-and-write|ebnf-eps-footer-comment|ebnf-eps-footer|ebnf-eps-header-comment|ebnf-eps-header-footer-comment|ebnf-eps-header-footer-file|ebnf-eps-header-footer-p|ebnf-eps-header-footer-set|ebnf-eps-header-footer|ebnf-eps-header|ebnf-eps-output|ebnf-eps-production-list|ebnf-eps-region|ebnf-eps-remove-context|ebnf-eps-string|ebnf-eps-write-kill-temp|ebnf-except-dimension|ebnf-file|ebnf-find-style|ebnf-font-attributes|ebnf-font-background|ebnf-font-foreground|ebnf-font-height|ebnf-font-list|ebnf-font-name-select|ebnf-font-name|ebnf-font-select|ebnf-font-size|ebnf-font-width|ebnf-format-color|ebnf-format-float|ebnf-gen-terminal|ebnf-generate-alternative|ebnf-generate-empty|ebnf-generate-eps|ebnf-generate-except|ebnf-generate-non-terminal|ebnf-generate-one-or-more|ebnf-generate-optional|ebnf-generate-postscript|ebnf-generate-production|ebnf-generate-region|ebnf-generate-repeat|ebnf-generate-sequence|ebnf-generate-special|ebnf-generate-terminal|ebnf-generate-with-max-height|ebnf-generate-without-max-height|ebnf-generate-zero-or-more|ebnf-generate|ebnf-get-string|ebnf-horizontal-movement|ebnf-insert-ebnf-prologue|ebnf-insert-style|ebnf-iso-initialize|ebnf-iso-parser|ebnf-justify-list|ebnf-justify|ebnf-log-header|ebnf-log|ebnf-make-alternative|ebnf-make-dup-sequence|ebnf-make-empty|ebnf-make-except|ebnf-make-non-terminal|ebnf-make-one-or-more|ebnf-make-optional|ebnf-make-or-more1|ebnf-make-production|ebnf-make-repeat|ebnf-make-sequence|ebnf-make-special|ebnf-make-terminal1??|ebnf-make-zero-or-more|ebnf-max-width|ebnf-merge-style|ebnf-message-float|ebnf-message-info|ebnf-new-page|ebnf-newline|ebnf-node-action|ebnf-node-default|ebnf-node-dimension-func|ebnf-node-entry|ebnf-node-generation|ebnf-node-height|ebnf-node-kind|ebnf-node-list|ebnf-node-name|ebnf-node-production|ebnf-node-separator|ebnf-node-width-func|ebnf-node-width|ebnf-non-terminal-dimension|ebnf-one-or-more-dimension|ebnf-optimize|ebnf-optional-dimension|ebnf-otz-initialize|ebnf-parse-and-sort|ebnf-pop-style|ebnf-print-buffer|ebnf-print-directory|ebnf-print-file|ebnf-print-region|ebnf-production-dimension|ebnf-push-style|ebnf-range-regexp|ebnf-repeat-dimension|ebnf-reset-style|ebnf-sequence-dimension|ebnf-sequence-width)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)e(?:bnf-setup|bnf-shape-value|bnf-sorter-ascending|bnf-sorter-descending|bnf-special-dimension|bnf-spool-buffer|bnf-spool-directory|bnf-spool-file|bnf-spool-region|bnf-string|bnf-syntax-buffer|bnf-syntax-directory|bnf-syntax-file|bnf-syntax-region|bnf-terminal-dimension1??|bnf-token-alternative|bnf-token-except|bnf-token-optional|bnf-token-repeat|bnf-token-sequence|bnf-trim-right|bnf-vertical-movement|bnf-yac-initialize|bnf-yac-parser|bnf-zero-or-more-dimension|browse-back-in-position-stack|browse-base-classes|browse-browser-buffer-list|browse-bs-file--cmacro|browse-bs-file|browse-bs-flags--cmacro|browse-bs-flags|browse-bs-name--cmacro|browse-bs-name|browse-bs-p--cmacro|browse-bs-p|browse-bs-pattern--cmacro|browse-bs-pattern|browse-bs-point--cmacro|browse-bs-point|browse-bs-scope--cmacro|browse-bs-scope|browse-buffer-p|browse-build-tree-obarray|browse-choose-from-browser-buffers|browse-choose-tree|browse-class-alist-for-member|browse-class-declaration-regexp|browse-class-in-tree|browse-class-name-displayed-in-member-buffer|browse-collapse-branch|browse-collapse-fn|browse-completing-read-value|browse-const-p|browse-create-tree-buffer|browse-cs-file--cmacro|browse-cs-file|browse-cs-flags--cmacro|browse-cs-flags|browse-cs-name--cmacro|browse-cs-name|browse-cs-p--cmacro|browse-cs-p|browse-cs-pattern--cmacro|browse-cs-pattern|browse-cs-point--cmacro|browse-cs-point|browse-cs-scope--cmacro|browse-cs-scope|browse-cs-source-file--cmacro|browse-cs-source-file|browse-cyclic-display-next/previous-member-list|browse-cyclic-successor-in-string-list|browse-define-p|browse-direct-base-classes|browse-display-friends-member-list|browse-display-function-member-list|browse-display-member-buffer|browse-display-member-list-for-accessor|browse-display-next-member-list|browse-display-previous-member-list|browse-display-static-functions-member-list|browse-display-static-variables-member-list|browse-display-types-member-list|browse-display-variables-member-list|browse-displaying-friends|browse-displaying-functions|browse-displaying-static-functions|browse-displaying-static-variables|browse-displaying-types|browse-displaying-variables|browse-draw-file-member-info|browse-draw-marks-fn|browse-draw-member-attributes|browse-draw-member-buffer-class-line|browse-draw-member-long-fn|browse-draw-member-regexp|browse-draw-member-short-fn|browse-draw-position-buffer|browse-draw-tree-fn|browse-electric-buffer-list|browse-electric-choose-tree|browse-electric-find-position|browse-electric-get-buffer|browse-electric-list-looper|browse-electric-list-mode|browse-electric-list-quit|browse-electric-list-select|browse-electric-list-undefined|browse-electric-position-looper|browse-electric-position-menu|browse-electric-position-mode|browse-electric-position-quit|browse-electric-position-undefined|browse-electric-select-position|browse-electric-view-buffer|browse-electric-view-position|browse-every|browse-expand-all|browse-expand-branch|browse-explicit-p|browse-extern-c-p|browse-files-list|browse-files-table|browse-fill-member-table|browse-find-class-declaration|browse-find-member-declaration|browse-find-member-definition|browse-find-pattern|browse-find-source-file|browse-for-all-trees|browse-forward-in-position-stack|browse-freeze-member-buffer|browse-frozen-tree-buffer-name|browse-function-declaration/definition-regexp|browse-gather-statistics|browse-globals-tree-p|browse-goto-visible-member/all-member-lists|browse-goto-visible-member|browse-hack-electric-buffer-menu|browse-hide-line|browse-hs-command-line-options--cmacro|browse-hs-command-line-options|browse-hs-member-table--cmacro|browse-hs-member-table|browse-hs-p--cmacro|browse-hs-p|browse-hs-unused--cmacro|browse-hs-unused|browse-hs-version--cmacro|browse-hs-version|browse-ignoring-completion-case|browse-inline-p|browse-insert-supers|browse-install-1-to-9-keys|browse-kill-member-buffers-displaying|browse-known-class-trees-buffer-list|browse-list-of-matching-members|browse-list-tree-buffers|browse-mark-all-classes|browse-marked-classes-p|browse-member-bit-set-p|browse-member-buffer-list|browse-member-buffer-object-menu|browse-member-buffer-p|browse-member-class-name-object-menu|browse-member-display-p|browse-member-info-from-point|browse-member-list-name|browse-member-mode|browse-member-mouse-2|browse-member-mouse-3|browse-member-name-object-menu|browse-member-table|browse-mouse-1-in-tree-buffer|browse-mouse-2-in-tree-buffer|browse-mouse-3-in-tree-buffer|browse-mouse-find-member|browse-move-in-position-stack|browse-move-point-to-member|browse-ms-definition-file--cmacro|browse-ms-definition-file|browse-ms-definition-pattern--cmacro|browse-ms-definition-pattern|browse-ms-definition-point--cmacro|browse-ms-definition-point|browse-ms-file--cmacro|browse-ms-file|browse-ms-flags--cmacro|browse-ms-flags|browse-ms-name--cmacro|browse-ms-name|browse-ms-p--cmacro|browse-ms-p|browse-ms-pattern--cmacro|browse-ms-pattern|browse-ms-point--cmacro|browse-ms-point|browse-ms-scope--cmacro|browse-ms-scope|browse-ms-visibility--cmacro|browse-ms-visibility|browse-mutable-p|browse-name/accessor-alist-for-class-members|browse-name/accessor-alist-for-visible-members|browse-name/accessor-alist|browse-on-class-name|browse-on-member-name|browse-output|browse-pop/switch-to-member-buffer-for-same-tree|browse-pop-from-member-to-tree-buffer|browse-pop-to-browser-buffer|browse-popup-menu|browse-position-file-name--cmacro|browse-position-file-name|browse-position-info--cmacro|browse-position-info|browse-position-name|browse-position-p--cmacro|browse-position-p|browse-position-point--cmacro|browse-position-point|browse-position-target--cmacro|browse-position-target|browse-position|browse-pp-define-regexp|browse-print-statistics-line|browse-pure-virtual-p|browse-push-position|browse-qualified-class-name|browse-read-class-name-and-go|browse-read|browse-redisplay-member-buffer|browse-redraw-marks|browse-redraw-tree|browse-remove-all-member-filters|browse-remove-class-and-kill-member-buffers|browse-remove-class-at-point|browse-rename-buffer|browse-repeat-member-search|browse-revert-tree-buffer-from-file|browse-same-tree-member-buffer-list|browse-save-class|browse-save-selective|browse-save-tree-as|browse-save-tree|browse-select-1st-to-9nth|browse-set-face|browse-set-mark-props|browse-set-member-access-visibility|browse-set-member-buffer-column-width|browse-set-tree-indentation|browse-show-displayed-class-in-tree|browse-show-file-name-at-point|browse-show-progress|browse-some-member-table|browse-some|browse-sort-tree-list|browse-statistics|browse-switch-member-buffer-to-any-class|browse-switch-member-buffer-to-base-class|browse-switch-member-buffer-to-derived-class|browse-switch-member-buffer-to-next-sibling-class|browse-switch-member-buffer-to-other-class|browse-switch-member-buffer-to-previous-sibling-class|browse-switch-member-buffer-to-sibling-class|browse-switch-to-next-member-buffer|browse-symbol-regexp|browse-tags-apropos|browse-tags-choose-class|browse-tags-complete-symbol|browse-tags-display-member-buffer|browse-tags-find-declaration-other-frame|browse-tags-find-declaration-other-window|browse-tags-find-declaration|browse-tags-find-definition-other-frame|browse-tags-find-definition-other-window|browse-tags-find-definition|browse-tags-list-members-in-file|browse-tags-loop-continue|browse-tags-next-file|browse-tags-query-replace|browse-tags-read-member\\\\+class-name|browse-tags-read-name|browse-tags-search-member-use|browse-tags-search|browse-tags-select/create-member-buffer|browse-tags-view/find-member-decl/defn|browse-tags-view-declaration-other-frame|browse-tags-view-declaration-other-window|browse-tags-view-declaration|browse-tags-view-definition-other-frame|browse-tags-view-definition-other-window|browse-tags-view-definition|browse-template-p|browse-throw-list-p|browse-toggle-base-class-display|browse-toggle-const-member-filter|browse-toggle-file-name-display|browse-toggle-inline-member-filter|browse-toggle-long-short-display|browse-toggle-mark-at-point|browse-toggle-member-attributes-display|browse-toggle-private-member-filter|browse-toggle-protected-member-filter|browse-toggle-public-member-filter|browse-toggle-pure-member-filter|browse-toggle-regexp-display|browse-toggle-virtual-member-filter|browse-tree-at-point|browse-tree-buffer-class-object-menu|browse-tree-buffer-list|browse-tree-buffer-object-menu|browse-tree-buffer-p|browse-tree-command:show-friends|browse-tree-command:show-member-functions|browse-tree-command:show-member-variables|browse-tree-command:show-static-member-functions|browse-tree-command:show-static-member-variables|browse-tree-command:show-types|browse-tree-mode|browse-tree-obarray-as-alist|browse-trim-string|browse-ts-base-classes--cmacro|browse-ts-base-classes|browse-ts-class--cmacro|browse-ts-class|browse-ts-friends--cmacro|browse-ts-friends|browse-ts-mark--cmacro|browse-ts-mark|browse-ts-member-functions--cmacro|browse-ts-member-functions|browse-ts-member-variables--cmacro|browse-ts-member-variables|browse-ts-p--cmacro|browse-ts-p|browse-ts-static-functions--cmacro|browse-ts-static-functions|browse-ts-static-variables--cmacro|browse-ts-static-variables|browse-ts-subclasses--cmacro|browse-ts-subclasses|browse-ts-types--cmacro|browse-ts-types|browse-unhide-base-classes|browse-update-member-buffer-mode-line|browse-update-tree-buffer-mode-line|browse-variable-declaration-regexp|browse-view/find-class-declaration|browse-view/find-file-and-search-pattern|browse-view/find-member-declaration/definition|browse-view/find-position|browse-view-class-declaration|browse-view-exit-fn|browse-view-file-other-frame|browse-view-member-declaration|browse-view-member-definition|browse-virtual-p|browse-width-of-drawable-area|browse-write-file-hook-fn|buffers3??|case|complete-display-matches|complete-setup|de--detect-ldf-predicate|de--detect-ldf-root-predicate|de--detect-ldf-rootonly-predicate|de--detect-scan-directory-for-project-root|de--detect-scan-directory-for-project|de--detect-scan-directory-for-rootonly-project|de--detect-stop-scan-p|de--directory-project-add-description-to-hash|de--directory-project-from-hash|de--get-inode-dir-hash|de--inode-for-dir|de--inode-get-toplevel-open-project|de--project-inode|de--put-inode-dir-hash|de-add-file|de-add-project-autoload|de-add-project-to-global-list|de-add-subproject|de-adebug-project-parent|de-adebug-project-root|de-adebug-project|de-apply-object-keymap|de-apply-preprocessor-map|de-apply-project-local-variables|de-apply-target-options|de-auto-add-to-target|de-auto-detect-in-dir|de-auto-load-project|de-buffer-belongs-to-project-p|de-buffer-belongs-to-target-p|de-buffer-documentation-files|de-buffer-header-file|de-buffer-mine|de-buffer-object|de-buffers|de-build-forms-menu|de-check-project-directory|de-choose-object|de-commit-local-variables|de-compile-project|de-compile-selected|de-compile-target|de-configuration-forms-menu|de-convert-path|de-cpp-root-project-child-p|de-cpp-root-project-list-p|de-cpp-root-project-p|de-cpp-root-project|de-create-tag-buttons|de-current-project|de-customize-current-target|de-customize-forms-menu|de-customize-project|de-debug-target|de-delete-project-from-global-list|de-delete-target|de-description|de-detect-directory-for-project|de-detect-qtest|de-directory-get-open-project|de-directory-get-toplevel-open-project|de-directory-project-cons|de-directory-project-p|de-directory-safe-p|de-dired-minor-mode|de-dirmatch-installed|de-do-dirmatch|de-documentation-files|de-documentation|de-ecb-project-paths|de-edit-file-target|de-edit-web-page|de-enable-generic-projects|de-enable-locate-on-project|de-expand-filename-impl-via-subproj|de-expand-filename-impl|de-expand-filename-local|de-expand-filename|de-file-find|de-find-file|de-find-nearest-file-line|de-find-subproject-for-directory|de-find-target|de-flush-deleted-projects|de-flush-directory-hash|de-flush-project-hash|de-get-locator-object|de-global-list-sanity-check|de-header-file|de-html-documentation-files|de-html-documentation|de-ignore-file|de-initialize-state-current-buffer|de-invoke-method)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)ed(?:e-java-classpath|e-linux-load|e-load-cache|e-load-project-file|e-make-check-version|e-make-dist|e-make-project-local-variable|e-map-all-subprojects|e-map-any-target-p|e-map-buffers|e-map-project-buffers|e-map-subprojects|e-map-target-buffers|e-map-targets|e-menu-items-build|e-menu-obj-of-class-p|e-minor-mode|e-name|e-new-target-custom|e-new-target|e-new|e-normalize-file/directory|e-object-keybindings|e-object-menu|e-object-sourcecode|e-parent-project|e-preprocessor-map|e-project-autoload-child-p|e-project-autoload-dirmatch-child-p|e-project-autoload-dirmatch-list-p|e-project-autoload-dirmatch-p|e-project-autoload-dirmatch|e-project-autoload-list-p|e-project-autoload-p|e-project-autoload|e-project-buffers|e-project-child-p|e-project-configurations-set|e-project-directory-remove-hash|e-project-forms-menu|e-project-list-p|e-project-p|e-project-placeholder-child-p|e-project-placeholder-list-p|e-project-placeholder-p|e-project-placeholder|e-project-root-directory|e-project-root|e-project-sort-targets|e-project|e-remove-file|e-rescan-toplevel|e-reset-all-buffers|e-run-target|e-save-cache|e-set-project-local-variable|e-set-project-variables|e-set|e-singular-object|e-source-paths|e-sourcecode-child-p|e-sourcecode-list-p|e-sourcecode-p|e-sourcecode|e-speedbar-compile-file-project|e-speedbar-compile-line|e-speedbar-compile-project|e-speedbar-edit-projectfile|e-speedbar-file-setup|e-speedbar-get-top-project-for-line|e-speedbar-make-distribution|e-speedbar-make-map|e-speedbar-remove-file-from-target|e-speedbar-toplevel-buttons|e-speedbar|e-subproject-p|e-subproject-relative-path|e-system-include-path|e-tag-expand|e-tag-find|e-target-buffer-in-sourcelist|e-target-buffers|e-target-child-p|e-target-forms-menu|e-target-in-project-p|e-target-list-p|e-target-name|e-target-p|e-target-parent|e-target-sourcecode|e-target|e-toplevel-project-or-nil|e-toplevel-project|e-toplevel|e-turn-on-hook|e-up-directory|e-update-version|e-upload-distribution|e-upload-html-documentation|e-vc-project-directory|e-version|e-want-any-auxiliary-files-p|e-want-any-files-p|e-want-any-source-files-p|e-want-file-auxiliary-p|e-want-file-p|e-want-file-source-p|e-web-browse-home|e-with-projectfile|e|ebug-&optional-wrapper|ebug-&rest-wrapper|ebug--called-interactively-skip|ebug--display|ebug--enter-trace|ebug--form-data-begin--cmacro|ebug--form-data-begin|ebug--form-data-end--cmacro|ebug--form-data-end|ebug--form-data-name--cmacro|ebug--form-data-name|ebug--make-form-data-entry--cmacro|ebug--make-form-data-entry|ebug--read|ebug--recursive-edit|ebug--require-cl-read|ebug--update-coverage|ebug-Continue-fast-mode|ebug-Go-nonstop-mode|ebug-Trace-fast-mode|ebug-\`|ebug-adjust-window|ebug-after-offset|ebug-after|ebug-all-defuns|ebug-backtrace|ebug-basic-spec|ebug-before-offset|ebug-before|ebug-bounce-point|ebug-changing-windows|ebug-clear-coverage|ebug-clear-form-data-entry|ebug-clear-frequency-count|ebug-compute-previous-result|ebug-continue-mode|ebug-copy-cursor|ebug-create-eval-buffer|ebug-current-windows|ebug-cursor-expressions|ebug-cursor-offsets|ebug-debugger|ebug-defining-form|ebug-delete-eval-item|ebug-empty-cursor|ebug-enter|ebug-eval-defun|ebug-eval-display-list|ebug-eval-display|ebug-eval-expression|ebug-eval-last-sexp|ebug-eval-mode|ebug-eval-print-last-sexp|ebug-eval-redisplay|ebug-eval-result-list|ebug-eval|ebug-fast-after|ebug-fast-before|ebug-find-stop-point|ebug-form-data-symbol|ebug-form|ebug-format|ebug-forms|ebug-forward-sexp|ebug-get-displayed-buffer-points|ebug-get-form-data-entry|ebug-go-mode|ebug-goto-here|ebug-help|ebug-ignore-offset|ebug-inc-offset|ebug-initialize-offsets|ebug-install-read-eval-functions|ebug-instrument-callee|ebug-instrument-function|ebug-interactive-p-name|ebug-kill-buffer|ebug-lambda-list-keywordp|ebug-last-sexp|ebug-list-form-args|ebug-list-form|ebug-make-after-form|ebug-make-before-and-after-form|ebug-make-enter-wrapper|ebug-make-form-wrapper|ebug-make-top-form-data-entry|ebug-mark-marker|ebug-mark|ebug-match-&define|ebug-match-&key|ebug-match-¬|ebug-match-&optional|ebug-match-&or|ebug-match-&rest|ebug-match-arg|ebug-match-body|ebug-match-colon-name|ebug-match-def-body|ebug-match-def-form|ebug-match-form|ebug-match-function|ebug-match-gate|ebug-match-lambda-expr|ebug-match-list|ebug-match-name|ebug-match-nil|ebug-match-one-spec|ebug-match-place|ebug-match-sexp|ebug-match-specs|ebug-match-string|ebug-match-sublist|ebug-match-symbol|ebug-match|ebug-menu|ebug-message|ebug-mode|ebug-modify-breakpoint|ebug-move-cursor|ebug-new-cursor|ebug-next-breakpoint|ebug-next-mode|ebug-next-token-class|ebug-no-match|ebug-on-entry|ebug-outside-excursion|ebug-overlay-arrow|ebug-pop-to-buffer|ebug-previous-result|ebug-prin1-to-string|ebug-prin1|ebug-print|ebug-read-and-maybe-wrap-form1??|ebug-read-backquote|ebug-read-comma|ebug-read-function|ebug-read-list|ebug-read-quote|ebug-read-sexp|ebug-read-storing-offsets|ebug-read-string|ebug-read-symbol|ebug-read-top-level-form|ebug-read-vector|ebug-report-error|ebug-restore-status|ebug-run-fast|ebug-run-slow|ebug-safe-eval|ebug-safe-prin1-to-string|ebug-set-breakpoint|ebug-set-buffer-points|ebug-set-conditional-breakpoint|ebug-set-cursor|ebug-set-form-data-entry|ebug-set-mode|ebug-set-windows|ebug-sexps|ebug-signal|ebug-skip-whitespace|ebug-slow-after|ebug-slow-before|ebug-sort-alist|ebug-spec-p|ebug-step-in|ebug-step-mode|ebug-step-out|ebug-step-through-mode|ebug-stop|ebug-store-after-offset|ebug-store-before-offset|ebug-storing-offsets|ebug-syntax-error|ebug-toggle-save-all-windows|ebug-toggle-save-selected-window|ebug-toggle-save-windows|ebug-toggle|ebug-top-element-required|ebug-top-element|ebug-top-level-nonstop|ebug-top-offset|ebug-trace-display|ebug-trace-mode|ebug-uninstall-read-eval-functions|ebug-unload-function|ebug-unset-breakpoint|ebug-unwrap\\\\*?|ebug-update-eval-list|ebug-var-status|ebug-view-outside|ebug-visit-eval-list|ebug-where|ebug-window-list|ebug-window-live-p|ebug-wrap-def-body|iff-3way-comparison-job|iff-3way-job|iff-abbrev-jobname|iff-abbreviate-file-name|iff-activate-mark|iff-add-slash-if-directory|iff-add-to-history|iff-ancestor-metajob|iff-append-custom-diff|iff-arrange-autosave-in-merge-jobs|iff-background-face|iff-backup|iff-barf-if-not-control-buffer|iff-buffer-live-p|iff-buffer-type|iff-buffers-internal|iff-buffers3??|iff-bury-dir-diffs-buffer|iff-calc-command-time|iff-change-saved-variable|iff-char-to-buftype|iff-check-version|iff-choose-syntax-table|iff-choose-window-setup-function-automatically|iff-cleanup-mess|iff-cleanup-meta-buffer|iff-clear-diff-vector|iff-clear-fine-diff-vector|iff-clear-fine-differences-in-one-buffer|iff-clear-fine-differences|iff-clone-buffer-for-current-diff-comparison|iff-clone-buffer-for-region-comparison|iff-clone-buffer-for-window-comparison|iff-collect-custom-diffs|iff-collect-diffs-metajob|iff-color-display-p|iff-combine-diffs|iff-comparison-metajob3|iff-compute-custom-diffs-maybe|iff-compute-toolbar-width|iff-convert-diffs-to-overlays|iff-convert-fine-diffs-to-overlays|iff-convert-standard-filename|iff-copy-A-to-B|iff-copy-A-to-C|iff-copy-B-to-A|iff-copy-B-to-C|iff-copy-C-to-A|iff-copy-C-to-B|iff-copy-diff|iff-copy-list|iff-copy-to-buffer|iff-current-file|iff-customize|iff-deactivate-mark|iff-debug-info|iff-default-suspend-function|iff-defvar-local|iff-delete-all-matches|iff-delete-overlay|iff-delete-temp-files|iff-destroy-control-frame|iff-device-type|iff-diff-at-point|iff-diff-to-diff|iff-diff3-job|iff-dir-diff-copy-file|iff-directories-command|iff-directories-internal|iff-directories|iff-directories3-command|iff-directories3|iff-directory-revisions-internal|iff-directory-revisions|iff-display-pixel-height|iff-display-pixel-width|iff-dispose-of-meta-buffer|iff-dispose-of-variant-according-to-user|iff-do-merge|iff-documentation|iff-draw-dir-diffs|iff-empty-diff-region-p|iff-empty-overlay-p|iff-event-buffer|iff-event-key|iff-event-point|iff-exec-process|iff-extract-diffs3??|iff-file-attributes|iff-file-checked-in-p|iff-file-checked-out-p|iff-file-compressed-p|iff-file-modtime|iff-file-remote-p|iff-file-size|iff-filegroup-action|iff-filename-magic-p|iff-files-command|iff-files-internal|iff-files3??|iff-fill-leading-zero|iff-find-file|iff-focus-on-regexp-matches|iff-format-bindings-of|iff-format-date|iff-forward-word|iff-frame-char-height|iff-frame-char-width|iff-frame-has-dedicated-windows|iff-frame-iconified-p|iff-frame-unsplittable-p|iff-get-buffer|iff-get-combined-region|iff-get-default-directory-name|iff-get-default-file-name|iff-get-diff-overlay-from-diff-record|iff-get-diff-overlay|iff-get-diff-posn|iff-get-diff3-group|iff-get-difference|iff-get-directory-files-under-revision|iff-get-file-eqstatus|iff-get-fine-diff-vector-from-diff-record|iff-get-fine-diff-vector|iff-get-group-buffer|iff-get-group-comparison-func|iff-get-group-merge-autostore-dir|iff-get-group-objA|iff-get-group-objB|iff-get-group-objC|iff-get-group-regexp|iff-get-lines-to-region-end|iff-get-lines-to-region-start|iff-get-meta-info|iff-get-meta-overlay-at-pos|iff-get-next-window|iff-get-region-contents|iff-get-region-size-coefficient|iff-get-selected-buffers|iff-get-session-activity-marker|iff-get-session-buffer|iff-get-session-number-at-pos|iff-get-session-objA-name|iff-get-session-objA|iff-get-session-objB-name|iff-get-session-objB|iff-get-session-objC-name|iff-get-session-objC|iff-get-session-status|iff-get-state-of-ancestor|iff-get-state-of-diff|iff-get-state-of-merge|iff-get-symbol-from-alist|iff-get-value-according-to-buffer-type|iff-get-visible-buffer-window|iff-get-window-by-clicking|iff-good-frame-under-mouse|iff-goto-word|iff-has-face-support-p|iff-has-gutter-support-p|iff-has-toolbar-support-p|iff-help-for-quick-help|iff-help-message-line-length|iff-hide-face|iff-hide-marked-sessions|iff-hide-regexp-matches|iff-highlight-diff-in-one-buffer|iff-highlight-diff|iff-in-control-buffer-p|iff-indent-help-message|iff-inferior-compare-regions|iff-insert-dirs-in-meta-buffer|iff-insert-session-activity-marker-in-meta-buffer|iff-insert-session-info-in-meta-buffer|iff-insert-session-status-in-meta-buffer|iff-install-fine-diff-if-necessary|iff-intersect-directories|iff-intersection|iff-janitor|iff-jump-to-difference-at-point|iff-jump-to-difference|iff-keep-window-config|iff-key-press-event-p|iff-kill-bottom-toolbar|iff-kill-buffer-carefully|iff-last-command-char|iff-listable-file|iff-load-version-control|iff-looks-like-combined-merge|iff-make-base-title|iff-make-bottom-toolbar|iff-make-bullet-proof-overlay|iff-make-cloned-buffer|iff-make-current-diff-overlay|iff-make-diff2-buffer|iff-make-empty-tmp-file|iff-make-fine-diffs|iff-make-frame-position|iff-make-indirect-buffer|iff-make-narrow-control-buffer-id|iff-make-new-meta-list-element|iff-make-new-meta-list-header|iff-make-or-kill-fine-diffs|iff-make-overlay|iff-make-temp-file|iff-make-wide-control-buffer-id|iff-make-wide-display|iff-mark-diff-as-space-only|iff-mark-for-hiding-at-pos|iff-mark-for-operation-at-pos|iff-mark-if-equal|iff-mark-session-for-hiding|iff-mark-session-for-operation|iff-maybe-checkout|iff-maybe-save-and-delete-merge|iff-member|iff-merge-buffers-with-ancestor|iff-merge-buffers|iff-merge-changed-from-default-p|iff-merge-command|iff-merge-directories-command|iff-merge-directories-with-ancestor-command)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)e(?:diff-merge-directories-with-ancestor|diff-merge-directories|diff-merge-directory-revisions-with-ancestor|diff-merge-directory-revisions|diff-merge-files-with-ancestor|diff-merge-files|diff-merge-job|diff-merge-metajob|diff-merge-on-startup|diff-merge-region-is-non-clash-to-skip|diff-merge-region-is-non-clash|diff-merge-revisions-with-ancestor|diff-merge-revisions|diff-merge-with-ancestor-command|diff-merge-with-ancestor-job|diff-merge-with-ancestor|diff-merge|diff-message-if-verbose|diff-meta-insert-file-info1|diff-meta-mark-equal-files|diff-meta-mode|diff-meta-session-p|diff-meta-show-patch|diff-metajob3|diff-minibuffer-with-setup-hook|diff-mode|diff-mouse-event-p|diff-move-overlay|diff-multiframe-setup-p|diff-narrow-control-frame-p|diff-narrow-job|diff-next-difference|diff-next-meta-item1??|diff-next-meta-overlay-start|diff-no-fine-diffs-p|diff-nonempty-string-p|diff-nuke-selective-display|diff-one-filegroup-metajob|diff-operate-on-marked-sessions|diff-operate-on-windows|diff-other-buffer|diff-overlay-buffer|diff-overlay-end|diff-overlay-get|diff-overlay-put|diff-overlay-start|diff-overlayp|diff-paint-background-regions-in-one-buffer|diff-paint-background-regions|diff-patch-buffer|diff-patch-file-form-meta|diff-patch-file-internal|diff-patch-file|diff-patch-job|diff-patch-metajob|diff-place-flags-in-buffer1??|diff-pop-diff|diff-position-region|diff-prepare-error-list|diff-prepare-meta-buffer|diff-previous-difference|diff-previous-meta-item1??|diff-previous-meta-overlay-start|diff-print-diff-vector|diff-problematic-session-p|diff-process-filter|diff-process-sentinel|diff-profile|diff-quit-meta-buffer|diff-quit|diff-re-merge|diff-read-event|diff-read-file-name|diff-really-quit|diff-recenter-ancestor|diff-recenter-one-window|diff-recenter|diff-redraw-directory-group-buffer|diff-redraw-registry-buffer|diff-refresh-control-frame|diff-refresh-mode-lines|diff-region-help-echo|diff-regions-internal|diff-regions-linewise|diff-regions-wordwise|diff-registry-action|diff-reload-keymap|diff-remove-flags-from-buffer|diff-replace-session-activity-marker-in-meta-buffer|diff-replace-session-status-in-meta-buffer|diff-reset-mouse|diff-restore-diff-in-merge-buffer|diff-restore-diff|diff-restore-highlighting|diff-restore-protected-variables|diff-restore-variables|diff-revert-buffers-then-recompute-diffs|diff-revision-metajob|diff-revision|diff-safe-to-quit|diff-same-contents|diff-same-file-contents-lists|diff-same-file-contents|diff-save-buffer-in-file|diff-save-buffer|diff-save-diff-region|diff-save-protected-variables|diff-save-time|diff-save-variables|diff-scroll-horizontally|diff-scroll-vertically|diff-select-difference|diff-select-lowest-window|diff-set-actual-diff-options|diff-set-diff-options|diff-set-diff-overlays-in-one-buffer|diff-set-difference|diff-set-face-pixmap|diff-set-file-eqstatus|diff-set-fine-diff-properties-in-one-buffer|diff-set-fine-diff-properties|diff-set-fine-diff-vector|diff-set-fine-overlays-for-combined-merge|diff-set-fine-overlays-in-one-buffer|diff-set-help-message|diff-set-help-overlays|diff-set-keys|diff-set-merge-mode|diff-set-meta-overlay|diff-set-overlay-face|diff-set-read-only-in-buf-A|diff-set-session-status|diff-set-state-of-all-diffs-in-all-buffers|diff-set-state-of-diff-in-all-buffers|diff-set-state-of-diff|diff-set-state-of-merge|diff-setup-control-buffer|diff-setup-control-frame|diff-setup-diff-regions3??|diff-setup-fine-diff-regions|diff-setup-keymap|diff-setup-meta-map|diff-setup-windows-default|diff-setup-windows-multiframe-compare|diff-setup-windows-multiframe-merge|diff-setup-windows-multiframe|diff-setup-windows-plain-compare|diff-setup-windows-plain-merge|diff-setup-windows-plain|diff-setup-windows|diff-setup|diff-show-all-diffs|diff-show-ancestor|diff-show-current-session-meta-buffer|diff-show-diff-output|diff-show-dir-diffs|diff-show-meta-buff-from-registry|diff-show-meta-buffer|diff-show-registry|diff-shrink-window-C|diff-skip-merge-region-if-changed-from-default-p|diff-skip-unsuitable-frames|diff-spy-after-mouse|diff-status-info|diff-strip-last-dir|diff-strip-mode-line-format|diff-submit-report|diff-suspend|diff-swap-buffers|diff-test-save-region|diff-toggle-autorefine|diff-toggle-filename-truncation|diff-toggle-help|diff-toggle-hilit|diff-toggle-ignore-case|diff-toggle-multiframe|diff-toggle-narrow-region|diff-toggle-read-only|diff-toggle-regexp-match|diff-toggle-show-clashes-only|diff-toggle-skip-changed-regions|diff-toggle-skip-similar|diff-toggle-split|diff-toggle-use-toolbar|diff-toggle-verbose-help-meta-buffer|diff-toggle-wide-display|diff-truncate-string-left|diff-unhighlight-diff-in-one-buffer|diff-unhighlight-diff|diff-unhighlight-diffs-totally-in-one-buffer|diff-unhighlight-diffs-totally|diff-union|diff-unique-buffer-name|diff-unmark-all-for-hiding|diff-unmark-all-for-operation|diff-unselect-and-select-difference|diff-unselect-difference|diff-up-meta-hierarchy|diff-update-diffs|diff-update-markers-in-dir-meta-buffer|diff-update-meta-buffer|diff-update-registry|diff-update-session-marker-in-dir-meta-buffer|diff-use-toolbar-p|diff-user-grabbed-mouse|diff-valid-difference-p|diff-verify-file-buffer|diff-verify-file-merge-buffer|diff-version|diff-visible-region|diff-whitespace-diff-region-p|diff-window-display-p|diff-window-ok-for-display|diff-window-visible-p|diff-windows-job|diff-windows-linewise|diff-windows-wordwise|diff-windows|diff-with-current-buffer|diff-with-syntax-table|diff-word-mode-job|diff-wordify|diff-write-merge-buffer-and-maybe-kill|diff-xemacs-select-frame-hook|diff|diff3-files-command|diff3|dir-merge-revisions-with-ancestor|dir-merge-revisions|dir-revisions|dirs-merge-with-ancestor|dirs-merge|dirs3??|dit-abbrevs-mode|dit-abbrevs-redefine|dit-abbrevs|dit-bookmarks|dit-kbd-macro|dit-last-kbd-macro|dit-named-kbd-macro|dit-picture|dit-tab-stops-note-changes|dit-tab-stops|dmacro-finish-edit|dmacro-fix-menu-commands|dmacro-format-keys|dmacro-insert-key|dmacro-mode|dmacro-parse-keys|dmacro-sanitize-for-string|dt-advance|dt-append|dt-backup|dt-beginning-of-line|dt-bind-function-key-default|dt-bind-function-key|dt-bind-gold-key-default|dt-bind-gold-key|dt-bind-key-default|dt-bind-key|dt-bind-standard-key|dt-bottom-check|dt-bottom|dt-change-case|dt-change-direction|dt-character|dt-check-match|dt-check-prefix|dt-check-selection|dt-copy-rectangle|dt-copy|dt-current-line|dt-cut-or-copy|dt-cut-rectangle-insert-mode|dt-cut-rectangle-overstrike-mode|dt-cut-rectangle|dt-cut|dt-default-emulation-setup|dt-default-menu-bar-update-buffers|dt-define-key|dt-delete-character|dt-delete-entire-line|dt-delete-line|dt-delete-previous-character|dt-delete-to-beginning-of-line|dt-delete-to-beginning-of-word|dt-delete-to-end-of-line|dt-delete-word|dt-display-the-time|dt-duplicate-line|dt-duplicate-word|dt-electric-helpify|dt-electric-keypad-help|dt-electric-user-keypad-help|dt-eliminate-all-tabs|dt-emulation-off|dt-emulation-on|dt-end-of-line-backward|dt-end-of-line-forward|dt-end-of-line|dt-exit|dt-fill-region|dt-find-backward|dt-find-forward|dt-find-next-backward|dt-find-next-forward|dt-find-next|dt-find|dt-form-feed-insert|dt-goto-percentage|dt-indent-or-fill-region|dt-key-not-assigned|dt-keypad-help|dt-learn|dt-line-backward|dt-line-forward|dt-line-to-bottom-of-window|dt-line-to-middle-of-window|dt-line-to-top-of-window|dt-line|dt-load-keys|dt-lowercase|dt-mark-section-wisely|dt-match-beginning|dt-match-end|dt-next-line|dt-one-word-backward|dt-one-word-forward|dt-page-backward|dt-page-forward|dt-page|dt-paragraph-backward|dt-paragraph-forward|dt-paragraph|dt-paste-rectangle-insert-mode|dt-paste-rectangle-overstrike-mode|dt-paste-rectangle|dt-previous-line|dt-quit|dt-remember|dt-replace|dt-reset|dt-restore-key|dt-scroll-line|dt-scroll-window-backward-line|dt-scroll-window-backward|dt-scroll-window-forward-line|dt-scroll-window-forward|dt-scroll-window|dt-sect-backward|dt-sect-forward|dt-sect|dt-select-default-global-map|dt-select-mode|dt-select-user-global-map|dt-select|dt-sentence-backward|dt-sentence-forward|dt-sentence|dt-set-match|dt-set-screen-width-132|dt-set-screen-width-80|dt-set-scroll-margins|dt-setup-default-bindings|dt-show-match-markers|dt-split-window|dt-substitute|dt-switch-global-maps|dt-tab-insert|dt-toggle-capitalization-of-word|dt-toggle-select|dt-top-check|dt-top|dt-undelete-character|dt-undelete-line|dt-undelete-word|dt-unset-match|dt-uppercase|dt-user-emulation-setup|dt-user-menu-bar-update-buffers|dt-window-bottom|dt-window-top|dt-with-position|dt-word-backward|dt-word-forward|dt-word|dt-y-or-n-p|help-command|ieio--check-type|ieio--class--unused-0|ieio--class-children|ieio--class-class-allocation-a|ieio--class-class-allocation-custom-group|ieio--class-class-allocation-custom-label|ieio--class-class-allocation-custom|ieio--class-class-allocation-doc|ieio--class-class-allocation-printer|ieio--class-class-allocation-protection|ieio--class-class-allocation-type|ieio--class-class-allocation-values|ieio--class-default-object-cache|ieio--class-initarg-tuples|ieio--class-options|ieio--class-parent|ieio--class-protection|ieio--class-public-a|ieio--class-public-custom-group|ieio--class-public-custom-label|ieio--class-public-custom|ieio--class-public-d|ieio--class-public-doc|ieio--class-public-printer|ieio--class-public-type|ieio--class-symbol-obarray|ieio--class-symbol|ieio--defalias|ieio--defgeneric-init-form|ieio--define-field-accessors|ieio--defmethod|ieio--object--unused-0|ieio--object-class|ieio--object-name|ieio--scoped-class|ieio--with-scoped-class|ieio-add-new-slot|ieio-attribute-to-initarg|ieio-barf-if-slot-unbound|ieio-browse|ieio-c3-candidate|ieio-c3-merge-lists|ieio-class-children-fast|ieio-class-children|ieio-class-name|ieio-class-parent|ieio-class-parents-fast|ieio-class-parents|ieio-class-precedence-bfs|ieio-class-precedence-c3|ieio-class-precedence-dfs|ieio-class-precedence-list|ieio-class-slot-name-index|ieio-class-un-autoload|ieio-copy-parents-into-subclass|ieio-custom-mode|ieio-custom-object-apply-reset|ieio-custom-toggle-hide|ieio-custom-toggle-parent|ieio-custom-widget-insert|ieio-customize-object-group|ieio-customize-object|ieio-default-eval-maybe|ieio-default-superclass-child-p|ieio-default-superclass-list-p|ieio-default-superclass-p|ieio-default-superclass|ieio-defclass-autoload|ieio-defclass|ieio-defgeneric-form-primary-only-one|ieio-defgeneric-form-primary-only|ieio-defgeneric-form|ieio-defgeneric-reset-generic-form-primary-only-one|ieio-defgeneric-reset-generic-form-primary-only|ieio-defgeneric-reset-generic-form|ieio-defgeneric|ieio-defmethod|ieio-done-customizing|ieio-edebug-prin1-to-string|ieio-eval-default-p|ieio-filter-slot-type|ieio-generic-call-primary-only|ieio-generic-call|ieio-generic-form|ieio-help-class|ieio-help-constructor|ieio-help-generic|ieio-initarg-to-attribute|ieio-instance-inheritor-child-p|ieio-instance-inheritor-list-p|ieio-instance-inheritor-p|ieio-instance-inheritor-slot-boundp|ieio-instance-inheritor|ieio-instance-tracker-child-p|ieio-instance-tracker-find|ieio-instance-tracker-list-p|ieio-instance-tracker-p|ieio-instance-tracker|ieio-list-prin1|ieio-named-child-p|ieio-named-list-p|ieio-named-p|ieio-named|ieio-object-abstract-to-value|ieio-object-class-name|ieio-object-class|ieio-object-match|ieio-object-name-string|ieio-object-name|ieio-object-p|ieio-object-set-name-string|ieio-object-value-create|ieio-object-value-get|ieio-object-value-to-abstract|ieio-oref-default|ieio-oref|ieio-oset-default|ieio-oset|ieio-override-prin1|ieio-perform-slot-validation-for-default|ieio-perform-slot-validation|ieio-persistent-child-p|ieio-persistent-convert-list-to-object|ieio-persistent-list-p|ieio-persistent-p|ieio-persistent-path-relative)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)e(?:ieio-persistent-read|ieio-persistent-save-interactive|ieio-persistent-save|ieio-persistent-slot-type-is-class-p|ieio-persistent-validate/fix-slot-value|ieio-persistent|ieio-read-customization-group|ieio-set-defaults|ieio-singleton-child-p|ieio-singleton-list-p|ieio-singleton-p|ieio-singleton|ieio-slot-name-index|ieio-slot-originating-class-p|ieio-slot-value-create|ieio-slot-value-get|ieio-specialized-key-to-generic-key|ieio-speedbar-buttons|ieio-speedbar-child-description|ieio-speedbar-child-make-tag-lines|ieio-speedbar-child-p|ieio-speedbar-create-engine|ieio-speedbar-create|ieio-speedbar-customize-line|ieio-speedbar-derive-line-path|ieio-speedbar-description|ieio-speedbar-directory-button-child-p|ieio-speedbar-directory-button-list-p|ieio-speedbar-directory-button-p|ieio-speedbar-directory-button|ieio-speedbar-expand|ieio-speedbar-file-button-child-p|ieio-speedbar-file-button-list-p|ieio-speedbar-file-button-p|ieio-speedbar-file-button|ieio-speedbar-find-nearest-object|ieio-speedbar-handle-click|ieio-speedbar-item-info|ieio-speedbar-line-path|ieio-speedbar-list-p|ieio-speedbar-make-map|ieio-speedbar-make-tag-line|ieio-speedbar-object-buttonname|ieio-speedbar-object-children|ieio-speedbar-object-click|ieio-speedbar-object-expand|ieio-speedbar-p|ieio-speedbar|ieio-unbind-method-implementations|ieio-validate-class-slot-value|ieio-validate-slot-value|ieio-version|ieio-widget-test-class-child-p|ieio-widget-test-class-list-p|ieio-widget-test-class-p|ieio-widget-test-class|ieiomt-add|ieiomt-install|ieiomt-method-list|ieiomt-next|ieiomt-sym-optimize|ighth|ldoc--message-command-p|ldoc-add-command-completions|ldoc-add-command|ldoc-display-message-no-interference-p|ldoc-display-message-p|ldoc-edit-message-commands|ldoc-message|ldoc-minibuffer-message|ldoc-mode|ldoc-pre-command-refresh-echo-area|ldoc-print-current-symbol-info|ldoc-remove-command-completions|ldoc-remove-command|ldoc-schedule-timer|lectric--after-char-pos|lectric--sort-post-self-insertion-hook|lectric-apropos|lectric-buffer-list|lectric-buffer-menu-looper|lectric-buffer-menu-mode|lectric-buffer-update-highlight|lectric-command-apropos|lectric-describe-bindings|lectric-describe-function|lectric-describe-key|lectric-describe-mode|lectric-describe-syntax|lectric-describe-variable|lectric-help-command-loop|lectric-help-ctrl-x-prefix|lectric-help-execute-extended|lectric-help-exit|lectric-help-help|lectric-help-mode|lectric-help-retain|lectric-help-undefined|lectric-helpify|lectric-icon-brace|lectric-indent-just-newline|lectric-indent-local-mode|lectric-indent-mode|lectric-indent-post-self-insert-function|lectric-layout-mode|lectric-layout-post-self-insert-function|lectric-newline-and-maybe-indent|lectric-nroff-mode|lectric-nroff-newline|lectric-pair-mode|lectric-pascal-colon|lectric-pascal-equal|lectric-pascal-hash|lectric-pascal-semi-or-dot|lectric-pascal-tab|lectric-pascal-terminate-line|lectric-perl-terminator|lectric-verilog-backward-sexp|lectric-verilog-colon|lectric-verilog-forward-sexp|lectric-verilog-semi-with-comment|lectric-verilog-semi|lectric-verilog-tab|lectric-verilog-terminate-and-indent|lectric-verilog-terminate-line|lectric-verilog-tick|lectric-view-lossage|l-get[-\\\\w]*|lide-head-show|lide-head|lint-add-required-env|lint-check-cond-form|lint-check-condition-case-form|lint-check-conditional-form|lint-check-defalias-form|lint-check-defcustom-form|lint-check-defun-form|lint-check-defvar-form|lint-check-function-form|lint-check-let-form|lint-check-macro-form|lint-check-quote-form|lint-check-setq-form|lint-clear-log|lint-current-buffer|lint-defun|lint-directory|lint-display-log|lint-env-add-env|lint-env-add-func|lint-env-add-global-var|lint-env-add-macro|lint-env-add-var|lint-env-find-func|lint-env-find-var|lint-env-macro-env|lint-env-macrop|lint-error|lint-file|lint-find-args-in-code|lint-find-autoloaded-variables|lint-find-builtin-args|lint-find-builtins|lint-find-next-top-form|lint-forms??|lint-get-args|lint-get-log-buffer|lint-get-top-forms|lint-init-env|lint-init-form|lint-initialize|lint-log-message|lint-log|lint-make-env|lint-make-top-form|lint-match-args|lint-output|lint-put-function-args|lint-scan-doc-file|lint-set-mode-line|lint-top-form-form|lint-top-form-pos|lint-top-form|lint-unbound-variable|lint-update-env|lint-warning|lisp--beginning-of-sexp|lisp--byte-code-comment|lisp--company-doc-buffer|lisp--company-doc-string|lisp--company-location|lisp--current-symbol|lisp--docstring-first-line|lisp--docstring-format-sym-doc|lisp--eval-defun-1|lisp--eval-defun|lisp--eval-last-sexp-print-value|lisp--eval-last-sexp|lisp--expect-function-p|lisp--fnsym-in-current-sexp|lisp--form-quoted-p|lisp--function-argstring|lisp--get-fnsym-args-string|lisp--get-var-docstring|lisp--highlight-function-argument|lisp--last-data-store|lisp--local-variables-1|lisp--local-variables|lisp--preceding-sexp|lisp--xref-find-apropos|lisp--xref-find-definitions|lisp--xref-identifier-completion-table|lisp--xref-identifier-file|lisp-byte-code-mode|lisp-byte-code-syntax-propertize|lisp-completion-at-point|lisp-eldoc-documentation-function|lisp-index-search|lisp-last-sexp-toggle-display|lisp-xref-find|lp--instrumented-p|lp--make-wrapper|lp-elapsed-time|lp-instrument-function|lp-instrument-list|lp-instrument-package|lp-output-insert-symname|lp-output-result|lp-pack-number|lp-profilable-p|lp-reset-all|lp-reset-function|lp-reset-list|lp-restore-all|lp-restore-function|lp-restore-list|lp-results-jump-to-definition|lp-results|lp-set-master|lp-sort-by-average-time|lp-sort-by-call-count|lp-sort-by-total-time|lp-unload-function|lp-unset-master|macs-bzr-get-version|macs-bzr-version-bzr|macs-bzr-version-dirstate|macs-index-search|macs-lisp-byte-compile-and-load|macs-lisp-byte-compile|macs-lisp-macroexpand|macs-lisp-mode|macs-lock--can-auto-unlock|macs-lock--exit-locked-buffer|macs-lock--kill-buffer-query-functions|macs-lock--kill-emacs-hook|macs-lock--kill-emacs-query-functions|macs-lock--set-mode|macs-lock-live-process-p|macs-lock-mode|macs-lock-unload-function|macs-repository-get-version|macs-session-filename|macs-session-save|merge-abort|merge-auto-advance|merge-buffers-with-ancestor|merge-buffers|merge-combine-versions-edit|merge-combine-versions-internal|merge-combine-versions-register|merge-combine-versions|merge-command-exit|merge-compare-buffers|merge-convert-diffs-to-markers|merge-copy-as-kill-A|merge-copy-as-kill-B|merge-copy-modes|merge-count-matches-string|merge-default-A|merge-default-B|merge-define-key-if-possible|merge-defvar-local|merge-edit-mode|merge-execute-line|merge-extract-diffs3??|merge-fast-mode|merge-file-names|merge-files-command|merge-files-exit|merge-files-internal|merge-files-remote|merge-files-with-ancestor-command|merge-files-with-ancestor-internal|merge-files-with-ancestor-remote|merge-files-with-ancestor|merge-files|merge-find-difference-A|merge-find-difference-B|merge-find-difference-merge|merge-find-difference1??|merge-force-define-key|merge-get-diff3-group|merge-goto-line|merge-handle-local-variables|merge-hash-string-into-string|merge-insert-A|merge-insert-B|merge-join-differences|merge-jump-to-difference|merge-line-number-in-buf|merge-line-numbers|merge-make-auto-save-file-name|merge-make-diff-list|merge-make-diff3-list|merge-make-temp-file|merge-mark-difference|merge-merge-directories|merge-mode|merge-new-flags|merge-next-difference|merge-one-line-window|merge-operate-on-windows|merge-place-flags-in-buffer1??|merge-position-region|merge-prepare-error-list|merge-previous-difference|merge-protect-metachars|merge-query-and-call|merge-query-save-buffer|merge-query-write-file|merge-quit|merge-read-file-name|merge-really-quit|merge-recenter|merge-refresh-mode-line|merge-remember-buffer-characteristics|merge-remote-exit|merge-remove-flags-in-buffer|merge-restore-buffer-characteristics|merge-restore-variables|merge-revision-with-ancestor-internal|merge-revisions-internal|merge-revisions-with-ancestor|merge-revisions|merge-save-variables|merge-scroll-down|merge-scroll-left|merge-scroll-reset|merge-scroll-right|merge-scroll-up|merge-select-A-edit|merge-select-A|merge-select-B-edit|merge-select-B|merge-select-difference|merge-select-prefer-Bs|merge-select-version|merge-set-combine-template|merge-set-combine-versions-template|merge-set-keys|merge-set-merge-mode|merge-setup-fixed-keymaps|merge-setup-windows|merge-setup-with-ancestor|merge-setup|merge-show-file-name|merge-skip-prefers|merge-split-difference|merge-trim-difference|merge-unique-buffer-name|merge-unselect-and-select-difference|merge-unselect-difference|merge-unslashify-name|merge-validate-difference|merge-verify-file-buffer|merge-write-and-delete|n/disable-command|nable-flow-control-on|nable-flow-control|ncode-big5-char|ncode-coding-char|ncode-composition-components|ncode-composition-rule|ncode-hex-string|ncode-hz-buffer|ncode-hz-region|ncode-sjis-char|ncode-time-value|ncoded-string-description|nd-kbd-macro|nd-of-buffer-other-window|nd-of-icon-defun|nd-of-paragraph-text|nd-of-sexp|nd-of-thing|nd-of-visible-line|nd-of-visual-line|ndp|nlarge-window-horizontally|nlarge-window|nriched-after-change-major-mode|nriched-before-change-major-mode|nriched-decode-background|nriched-decode-display-prop|nriched-decode-foreground|nriched-decode|nriched-encode-other-face|nriched-encode|nriched-face-ans|nriched-get-file-width|nriched-handle-display-prop|nriched-insert-indentation|nriched-make-annotation|nriched-map-property-regions|nriched-mode-map|nriched-mode|nriched-next-annotation|nriched-remove-header|pa--decode-coding-string|pa--derived-mode-p|pa--encode-coding-string|pa--find-coding-system-for-mime-charset|pa--insert-keys|pa--key-list-revert-buffer|pa--key-widget-action|pa--key-widget-button-face-get|pa--key-widget-help-echo|pa--key-widget-value-create|pa--list-keys|pa--marked-keys|pa--read-signature-type|pa--select-keys|pa--select-safe-coding-system|pa--show-key|pa-decrypt-armor-in-region|pa-decrypt-file|pa-decrypt-region|pa-delete-keys|pa-dired-do-decrypt|pa-dired-do-encrypt|pa-dired-do-sign|pa-dired-do-verify|pa-display-error|pa-display-info|pa-display-verify-result|pa-encrypt-file|pa-encrypt-region|pa-exit-buffer|pa-export-keys|pa-file--file-name-regexp-set|pa-file-disable|pa-file-enable|pa-file-find-file-hook|pa-file-handler|pa-file-name-regexp-update|pa-global-mail-mode|pa-import-armor-in-region|pa-import-keys-region|pa-import-keys|pa-info-mode|pa-insert-keys|pa-key-list-mode|pa-key-mode|pa-list-keys|pa-list-secret-keys|pa-mail-decrypt|pa-mail-encrypt|pa-mail-import-keys|pa-mail-mode|pa-mail-sign|pa-mail-verify|pa-mark-key|pa-passphrase-callback-function|pa-progress-callback-function|pa-read-file-name|pa-select-keys|pa-sign-file|pa-sign-region|pa-unmark-key|pa-verify-cleartext-in-region|pa-verify-file|pa-verify-region|patch-buffer|patch|pg--args-from-sig-notations|pg--check-error-for-decrypt|pg--clear-string|pg--decode-coding-string|pg--decode-hexstring|pg--decode-percent-escape|pg--decode-quotedstring|pg--encode-coding-string|pg--gv-nreverse|pg--import-keys-1|pg--list-keys-1|pg--make-sub-key-1|pg--make-temp-file|pg--process-filter|pg--prompt-GET_BOOL-untrusted_key\\\\.override|pg--prompt-GET_BOOL|pg--start|pg--status-\\\\*SIG|pg--status-BADARMOR|pg--status-BADSIG|pg--status-DECRYPTION_FAILED|pg--status-DECRYPTION_OKAY|pg--status-DELETE_PROBLEM|pg--status-ENC_TO|pg--status-ERRSIG|pg--status-EXPKEYSIG|pg--status-EXPSIG|pg--status-GET_BOOL|pg--status-GET_HIDDEN|pg--status-GET_LINE|pg--status-GOODSIG|pg--status-IMPORTED|pg--status-IMPORT_OK|pg--status-IMPORT_PROBLEM|pg--status-IMPORT_RES|pg--status-INV_RECP|pg--status-INV_SGNR|pg--status-KEYEXPIRED|pg--status-KEYREVOKED|pg--status-KEY_CREATED|pg--status-KEY_NOT_CREATED|pg--status-NEED_PASSPHRASE|pg--status-NEED_PASSPHRASE_PIN|pg--status-NEED_PASSPHRASE_SYM|pg--status-NODATA)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)e(?:pg--status-NOTATION_DATA|pg--status-NOTATION_NAME|pg--status-NO_PUBKEY|pg--status-NO_RECP|pg--status-NO_SECKEY|pg--status-NO_SGNR|pg--status-POLICY_URL|pg--status-PROGRESS|pg--status-REVKEYSIG|pg--status-SIG_CREATED|pg--status-TRUST_FULLY|pg--status-TRUST_MARGINAL|pg--status-TRUST_NEVER|pg--status-TRUST_ULTIMATE|pg--status-TRUST_UNDEFINED|pg--status-UNEXPECTED|pg--status-USERID_HINT|pg--status-VALIDSIG|pg--time-from-seconds|pg-cancel|pg-check-configuration|pg-config--compare-version|pg-config--parse-version|pg-configuration|pg-context--make|pg-context-armor--cmacro|pg-context-armor|pg-context-cipher-algorithm--cmacro|pg-context-cipher-algorithm|pg-context-compress-algorithm--cmacro|pg-context-compress-algorithm|pg-context-digest-algorithm--cmacro|pg-context-digest-algorithm|pg-context-edit-callback--cmacro|pg-context-edit-callback|pg-context-error-output--cmacro|pg-context-error-output|pg-context-home-directory--cmacro|pg-context-home-directory|pg-context-include-certs--cmacro|pg-context-include-certs|pg-context-operation--cmacro|pg-context-operation|pg-context-output-file--cmacro|pg-context-output-file|pg-context-passphrase-callback--cmacro|pg-context-passphrase-callback|pg-context-pinentry-mode--cmacro|pg-context-pinentry-mode|pg-context-process--cmacro|pg-context-process|pg-context-program--cmacro|pg-context-program|pg-context-progress-callback--cmacro|pg-context-progress-callback|pg-context-protocol--cmacro|pg-context-protocol|pg-context-result--cmacro|pg-context-result-for|pg-context-result|pg-context-set-armor|pg-context-set-passphrase-callback|pg-context-set-progress-callback|pg-context-set-result-for|pg-context-set-signers|pg-context-set-textmode|pg-context-sig-notations--cmacro|pg-context-sig-notations|pg-context-signers--cmacro|pg-context-signers|pg-context-textmode--cmacro|pg-context-textmode|pg-data-file--cmacro|pg-data-file|pg-data-string--cmacro|pg-data-string|pg-decode-dn|pg-decrypt-file|pg-decrypt-string|pg-delete-keys|pg-delete-output-file|pg-dn-from-string|pg-edit-key|pg-encrypt-file|pg-encrypt-string|pg-error-to-string|pg-errors-to-string|pg-expand-group|pg-export-keys-to-file|pg-export-keys-to-string|pg-generate-key-from-file|pg-generate-key-from-string|pg-import-keys-from-file|pg-import-keys-from-server|pg-import-keys-from-string|pg-import-result-considered--cmacro|pg-import-result-considered|pg-import-result-imported--cmacro|pg-import-result-imported-rsa--cmacro|pg-import-result-imported-rsa|pg-import-result-imported|pg-import-result-imports--cmacro|pg-import-result-imports|pg-import-result-new-revocations--cmacro|pg-import-result-new-revocations|pg-import-result-new-signatures--cmacro|pg-import-result-new-signatures|pg-import-result-new-sub-keys--cmacro|pg-import-result-new-sub-keys|pg-import-result-new-user-ids--cmacro|pg-import-result-new-user-ids|pg-import-result-no-user-id--cmacro|pg-import-result-no-user-id|pg-import-result-not-imported--cmacro|pg-import-result-not-imported|pg-import-result-secret-imported--cmacro|pg-import-result-secret-imported|pg-import-result-secret-read--cmacro|pg-import-result-secret-read|pg-import-result-secret-unchanged--cmacro|pg-import-result-secret-unchanged|pg-import-result-to-string|pg-import-result-unchanged--cmacro|pg-import-result-unchanged|pg-import-status-fingerprint--cmacro|pg-import-status-fingerprint|pg-import-status-new--cmacro|pg-import-status-new|pg-import-status-reason--cmacro|pg-import-status-reason|pg-import-status-secret--cmacro|pg-import-status-secret|pg-import-status-signature--cmacro|pg-import-status-signature|pg-import-status-sub-key--cmacro|pg-import-status-sub-key|pg-import-status-user-id--cmacro|pg-import-status-user-id|pg-key-owner-trust--cmacro|pg-key-owner-trust|pg-key-signature-class--cmacro|pg-key-signature-class|pg-key-signature-creation-time--cmacro|pg-key-signature-creation-time|pg-key-signature-expiration-time--cmacro|pg-key-signature-expiration-time|pg-key-signature-exportable-p--cmacro|pg-key-signature-exportable-p|pg-key-signature-key-id--cmacro|pg-key-signature-key-id|pg-key-signature-pubkey-algorithm--cmacro|pg-key-signature-pubkey-algorithm|pg-key-signature-user-id--cmacro|pg-key-signature-user-id|pg-key-signature-validity--cmacro|pg-key-signature-validity|pg-key-sub-key-list--cmacro|pg-key-sub-key-list|pg-key-user-id-list--cmacro|pg-key-user-id-list|pg-list-keys|pg-make-context|pg-make-data-from-file--cmacro|pg-make-data-from-file|pg-make-data-from-string--cmacro|pg-make-data-from-string|pg-make-import-result--cmacro|pg-make-import-result|pg-make-import-status--cmacro|pg-make-import-status|pg-make-key--cmacro|pg-make-key-signature--cmacro|pg-make-key-signature|pg-make-key|pg-make-new-signature--cmacro|pg-make-new-signature|pg-make-sig-notation--cmacro|pg-make-sig-notation|pg-make-signature--cmacro|pg-make-signature|pg-make-sub-key--cmacro|pg-make-sub-key|pg-make-user-id--cmacro|pg-make-user-id|pg-new-signature-class--cmacro|pg-new-signature-class|pg-new-signature-creation-time--cmacro|pg-new-signature-creation-time|pg-new-signature-digest-algorithm--cmacro|pg-new-signature-digest-algorithm|pg-new-signature-fingerprint--cmacro|pg-new-signature-fingerprint|pg-new-signature-pubkey-algorithm--cmacro|pg-new-signature-pubkey-algorithm|pg-new-signature-to-string|pg-new-signature-type--cmacro|pg-new-signature-type|pg-passphrase-callback-function|pg-read-output|pg-receive-keys|pg-reset|pg-sig-notation-critical--cmacro|pg-sig-notation-critical|pg-sig-notation-human-readable--cmacro|pg-sig-notation-human-readable|pg-sig-notation-name--cmacro|pg-sig-notation-name|pg-sig-notation-value--cmacro|pg-sig-notation-value|pg-sign-file|pg-sign-keys|pg-sign-string|pg-signature-class--cmacro|pg-signature-class|pg-signature-creation-time--cmacro|pg-signature-creation-time|pg-signature-digest-algorithm--cmacro|pg-signature-digest-algorithm|pg-signature-expiration-time--cmacro|pg-signature-expiration-time|pg-signature-fingerprint--cmacro|pg-signature-fingerprint|pg-signature-key-id--cmacro|pg-signature-key-id|pg-signature-notations--cmacro|pg-signature-notations|pg-signature-pubkey-algorithm--cmacro|pg-signature-pubkey-algorithm|pg-signature-status--cmacro|pg-signature-status|pg-signature-to-string|pg-signature-validity--cmacro|pg-signature-validity|pg-signature-version--cmacro|pg-signature-version|pg-start-decrypt|pg-start-delete-keys|pg-start-edit-key|pg-start-encrypt|pg-start-export-keys|pg-start-generate-key|pg-start-import-keys|pg-start-receive-keys|pg-start-sign-keys|pg-start-sign|pg-start-verify|pg-sub-key-algorithm--cmacro|pg-sub-key-algorithm|pg-sub-key-capability--cmacro|pg-sub-key-capability|pg-sub-key-creation-time--cmacro|pg-sub-key-creation-time|pg-sub-key-expiration-time--cmacro|pg-sub-key-expiration-time|pg-sub-key-fingerprint--cmacro|pg-sub-key-fingerprint|pg-sub-key-id--cmacro|pg-sub-key-id|pg-sub-key-length--cmacro|pg-sub-key-length|pg-sub-key-secret-p--cmacro|pg-sub-key-secret-p|pg-sub-key-validity--cmacro|pg-sub-key-validity|pg-user-id-signature-list--cmacro|pg-user-id-signature-list|pg-user-id-string--cmacro|pg-user-id-string|pg-user-id-validity--cmacro|pg-user-id-validity|pg-verify-file|pg-verify-result-to-string|pg-verify-string|pg-wait-for-completion|pg-wait-for-status|qualp|rc-active-buffer|rc-add-dangerous-host|rc-add-default-channel|rc-add-entry-to-list|rc-add-fool|rc-add-keyword|rc-add-pal|rc-add-query|rc-add-scroll-to-bottom|rc-add-server-user|rc-add-timestamp|rc-add-to-input-ring|rc-all-buffer-names|rc-already-logged-in|rc-arrange-session-in-multiple-windows|rc-auto-query|rc-autoaway-mode|rc-autojoin-add|rc-autojoin-after-ident|rc-autojoin-channels-delayed|rc-autojoin-channels|rc-autojoin-disable|rc-autojoin-enable|rc-autojoin-mode|rc-autojoin-remove|rc-away-time|rc-banlist-finished|rc-banlist-store|rc-banlist-update|rc-beep-on-match|rc-beg-of-input-line|rc-bol|rc-browse-emacswiki-lisp|rc-browse-emacswiki|rc-buffer-filter|rc-buffer-list-with-nick|rc-buffer-list|rc-buffer-visible|rc-button-add-button|rc-button-add-buttons-1|rc-button-add-buttons|rc-button-add-face|rc-button-add-nickname-buttons|rc-button-beats-to-time|rc-button-click-button|rc-button-describe-symbol|rc-button-disable|rc-button-enable|rc-button-mode|rc-button-next-function|rc-button-next|rc-button-press-button|rc-button-previous|rc-button-remove-old-buttons|rc-button-setup|rc-call-hooks|rc-cancel-timer|rc-canonicalize-server-name|rc-capab-identify-mode|rc-change-user-nickname|rc-channel-begin-receiving-names|rc-channel-end-receiving-names|rc-channel-list|rc-channel-names|rc-channel-p|rc-channel-receive-names|rc-channel-user-admin--cmacro|rc-channel-user-admin-p|rc-channel-user-admin|rc-channel-user-halfop--cmacro|rc-channel-user-halfop-p|rc-channel-user-halfop|rc-channel-user-last-message-time--cmacro|rc-channel-user-last-message-time|rc-channel-user-op--cmacro|rc-channel-user-op-p|rc-channel-user-op|rc-channel-user-owner--cmacro|rc-channel-user-owner-p|rc-channel-user-owner|rc-channel-user-p--cmacro|rc-channel-user-p|rc-channel-user-voice--cmacro|rc-channel-user-voice-p|rc-channel-user-voice|rc-clear-input-ring|rc-client-info|rc-cmd-AMSG|rc-cmd-APPENDTOPIC|rc-cmd-AT|rc-cmd-AWAY|rc-cmd-BANLIST|rc-cmd-BL|rc-cmd-BYE|rc-cmd-CHANNEL|rc-cmd-CLEAR|rc-cmd-CLEARTOPIC|rc-cmd-COUNTRY|rc-cmd-CTCP|rc-cmd-DATE|rc-cmd-DCC|rc-cmd-DEOP|rc-cmd-DESCRIBE|rc-cmd-EXIT|rc-cmd-GAWAY|rc-cmd-GQ|rc-cmd-GQUIT|rc-cmd-H|rc-cmd-HELP|rc-cmd-IDLE|rc-cmd-IGNORE|rc-cmd-J|rc-cmd-JOIN|rc-cmd-KICK|rc-cmd-LASTLOG|rc-cmd-LEAVE|rc-cmd-LIST|rc-cmd-LOAD|rc-cmd-M|rc-cmd-MASSUNBAN|rc-cmd-ME'S|rc-cmd-ME|rc-cmd-MODE|rc-cmd-MSG|rc-cmd-MUB|rc-cmd-N|rc-cmd-NAMES|rc-cmd-NICK|rc-cmd-NOTICE|rc-cmd-NOTIFY|rc-cmd-OPS??|rc-cmd-PART|rc-cmd-PING|rc-cmd-Q|rc-cmd-QUERY|rc-cmd-QUIT|rc-cmd-QUOTE|rc-cmd-RECONNECT|rc-cmd-SAY|rc-cmd-SERVER|rc-cmd-SET|rc-cmd-SIGNOFF|rc-cmd-SM|rc-cmd-SQUERY|rc-cmd-SV|rc-cmd-T|rc-cmd-TIME|rc-cmd-TOPIC|rc-cmd-UNIGNORE|rc-cmd-VAR|rc-cmd-VARIABLE|rc-cmd-WHOAMI|rc-cmd-WHOIS|rc-cmd-WHOLEFT|rc-cmd-WI|rc-cmd-WL|rc-cmd-default|rc-cmd-ezb|rc-coding-system-for-target|rc-command-indicator|rc-command-name|rc-command-no-process-p|rc-command-symbol|rc-complete-word-at-point|rc-complete-word|rc-completion-mode|rc-compute-full-name|rc-compute-nick|rc-compute-port|rc-compute-server|rc-connection-established|rc-controls-highlight|rc-controls-interpret|rc-controls-propertize|rc-controls-strip|rc-create-imenu-index|rc-ctcp-query-ACTION|rc-ctcp-query-CLIENTINFO|rc-ctcp-query-DCC|rc-ctcp-query-ECHO|rc-ctcp-query-FINGER|rc-ctcp-query-PING|rc-ctcp-query-TIME|rc-ctcp-query-USERINFO|rc-ctcp-query-VERSION|rc-ctcp-reply-CLIENTINFO|rc-ctcp-reply-ECHO|rc-ctcp-reply-FINGER|rc-ctcp-reply-PING|rc-ctcp-reply-TIME|rc-ctcp-reply-VERSION|rc-current-network|rc-current-nick-p|rc-current-nick|rc-current-time|rc-dcc-mode|rc-debug-missing-hooks|rc-decode-coding-string|rc-decode-parsed-server-response|rc-decode-string-from-target|rc-default-server-handler|rc-default-target|rc-define-catalog-entry|rc-define-catalog|rc-define-minor-mode|rc-delete-dangerous-host|rc-delete-default-channel|rc-delete-dups|rc-delete-fool|rc-delete-if|rc-delete-keyword|rc-delete-pal|rc-delete-query|rc-determine-network|rc-determine-parameters|rc-directory-writable-p|rc-display-command|rc-display-error-notice|rc-display-line-1|rc-display-line|rc-display-message-highlight|rc-display-message|rc-display-msg|rc-display-prompt|rc-display-server-message|rc-downcase|rc-echo-notice-in-active-buffer|rc-echo-notice-in-active-non-server-buffer|rc-echo-notice-in-default-buffer|rc-echo-notice-in-first-user-buffer|rc-echo-notice-in-minibuffer|rc-echo-notice-in-server-buffer|rc-echo-notice-in-target-buffer|rc-echo-notice-in-user-and-target-buffers|rc-echo-notice-in-user-buffers|rc-echo-timestamp|rc-emacs-time-to-erc-time|rc-encode-coding-string|rc-end-of-input-line|rc-ensure-channel-name|rc-error|rc-extract-command-from-line|rc-extract-nick|rc-ezb-add-session|rc-ezb-end-of-session-list|rc-ezb-get-login|rc-ezb-identify)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)er(?:c-ezb-init-session-list|c-ezb-initialize|c-ezb-lookup-action|c-ezb-notice-autodetect|c-ezb-select-session|c-ezb-select|c-faces-in|c-fill-disable|c-fill-enable|c-fill-mode|c-fill-regarding-timestamp|c-fill-static|c-fill-variable|c-fill|c-find-file|c-find-parsed-property|c-find-script-file|c-format-@nick|c-format-away-status|c-format-channel-modes|c-format-lag-time|c-format-message|c-format-my-nick|c-format-network|c-format-nick|c-format-privmessage|c-format-target-and/or-network|c-format-target-and/or-server|c-format-target|c-format-timestamp|c-function-arglist|c-generate-new-buffer-name|c-get-arglist|c-get-bg-color-face|c-get-buffer-create|c-get-buffer|c-get-channel-mode-from-keypress|c-get-channel-nickname-alist|c-get-channel-nickname-list|c-get-channel-user-list|c-get-channel-user|c-get-fg-color-face|c-get-hook|c-get-parsed-vector-nick|c-get-parsed-vector-type|c-get-parsed-vector|c-get-server-nickname-alist|c-get-server-nickname-list|c-get-server-user|c-get-user-mode-prefix|c-get|c-go-to-log-matches-buffer|c-grab-region|c-group-list|c-handle-irc-url|c-handle-login|c-handle-parsed-server-response|c-handle-unknown-server-response|c-handle-user-status-change|c-hide-current-message-p|c-hide-fools|c-hide-timestamps|c-highlight-error|c-highlight-notice|c-identd-mode|c-identd-start|c-identd-stop|c-ignored-reply-p|c-ignored-user-p|c-imenu-setup|c-initialize-log-marker|c-input-action|c-input-message|c-input-ring-setup|c-insert-aligned|c-insert-mode-command|c-insert-timestamp-left-and-right|c-insert-timestamp-left|c-insert-timestamp-right|c-invite-only-mode|c-irccontrols-disable|c-irccontrols-enable|c-irccontrols-mode|c-is-message-ctcp-and-not-action-p|c-is-message-ctcp-p|c-is-valid-nick-p|c-ison-p|c-iswitchb|c-join-channel|c-keep-place-disable|c-keep-place-enable|c-keep-place-mode|c-keep-place|c-kill-buffer-function|c-kill-channel|c-kill-input|c-kill-query-buffers|c-kill-server|c-list-button|c-list-disable|c-list-enable|c-list-handle-322|c-list-insert-item|c-list-install-322-handler|c-list-join|c-list-kill|c-list-make-string|c-list-match|c-list-menu-mode|c-list-menu-sort-by-column|c-list-mode|c-list-revert|c-list|c-load-irc-script-lines|c-load-irc-script|c-load-script|c-log-aux|c-log-irc-protocol|c-log-matches-come-back|c-log-matches-make-buffer|c-log-matches|c-log-mode|c-log|c-logging-enabled|c-login|c-lurker-cleanup|c-lurker-initialize|c-lurker-maybe-trim|c-lurker-p|c-lurker-update-status|c-make-message-variable-name|c-make-mode-line-buffer-name|c-make-notice|c-make-obsolete-variable|c-make-obsolete|c-make-read-only|c-match-current-nick-p|c-match-dangerous-host-p|c-match-directed-at-fool-p|c-match-disable|c-match-enable|c-match-fool-p|c-match-keyword-p|c-match-message|c-match-mode|c-match-pal-p|c-member-if|c-member-ignore-case|c-menu-add|c-menu-disable|c-menu-enable|c-menu-mode|c-menu-remove|c-menu|c-message-english-PART|c-message-target|c-message-type-member|c-message|c-migrate-modules|c-modes??|c-modified-channels-display|c-modified-channels-object|c-modified-channels-remove-buffer|c-modified-channels-update|c-move-to-prompt-disable|c-move-to-prompt-enable|c-move-to-prompt-mode|c-move-to-prompt-setup|c-move-to-prompt|c-munge-invisibility-spec|c-netsplit-JOIN|c-netsplit-MODE|c-netsplit-QUIT|c-netsplit-disable|c-netsplit-enable|c-netsplit-install-message-catalogs|c-netsplit-mode|c-netsplit-timer|c-network-name|c-network|c-networks-disable|c-networks-enable|c-networks-mode|c-next-command|c-nick-at-point|c-nick-equal-p|c-nick-popup|c-nickname-in-use|c-nickserv-identify-mode|c-nickserv-identify|c-noncommands-disable|c-noncommands-enable|c-noncommands-mode|c-normalize-port|c-notifications-mode|c-notify-mode|c-occur|c-once-with-server-event|c-open-server-buffer-p|c-open-tls-stream|c-open|c-page-mode|c-parse-modes|c-parse-prefix|c-parse-server-response|c-parse-user|c-part-from-channel|c-part-reason-normal|c-part-reason-various|c-part-reason-zippy|c-pcomplete-disable|c-pcomplete-enable|c-pcomplete-mode|c-pcomplete|c-pcompletions-at-point|c-popup-input-buffer|c-port-equal|c-port-to-string|c-ports-list|c-previous-command|c-process-away|c-process-ctcp-query|c-process-ctcp-reply|c-process-input-line|c-process-script-line|c-process-sentinel-1|c-process-sentinel-2|c-process-sentinel|c-prompt|c-propertize|c-put-text-properties|c-put-text-property|c-query-buffer-p|c-query|c-quit/part-reason-default|c-quit-reason-normal|c-quit-reason-various|c-quit-reason-zippy|c-quit-server|c-readonly-disable|c-readonly-enable|c-readonly-mode|c-remove-channel-member|c-remove-channel-users??|c-remove-current-channel-member|c-remove-entry-from-list|c-remove-if-not|c-remove-server-user|c-remove-text-properties-region|c-remove-user|c-replace-current-command|c-replace-match-subexpression-in-string|c-replace-mode|c-replace-regexp-in-string|c-response-p--cmacro|c-response-p|c-response\\\\.command--cmacro|c-response\\\\.command-args--cmacro|c-response\\\\.command-args|c-response\\\\.command|c-response\\\\.contents--cmacro|c-response\\\\.contents|c-response\\\\.sender--cmacro|c-response\\\\.sender|c-response\\\\.unparsed--cmacro|c-response\\\\.unparsed|c-restore-text-properties|c-retrieve-catalog-entry|c-ring-disable|c-ring-enable|c-ring-mode|c-save-buffer-in-logs|c-scroll-to-bottom|c-scrolltobottom-disable|c-scrolltobottom-enable|c-scrolltobottom-mode|c-sec-to-time|c-seconds-to-string|c-select-read-args|c-select-startup-file|c-select|c-send-action|c-send-command|c-send-ctcp-message|c-send-ctcp-notice|c-send-current-line|c-send-distinguish-noncommands|c-send-input-line|c-send-input|c-send-line|c-send-message|c-server-001|c-server-002|c-server-003|c-server-004|c-server-005|c-server-221|c-server-250|c-server-251|c-server-252|c-server-253|c-server-254|c-server-255|c-server-256|c-server-257|c-server-258|c-server-259|c-server-265|c-server-266|c-server-275|c-server-290|c-server-301|c-server-303|c-server-305|c-server-306|c-server-307|c-server-311|c-server-312|c-server-313|c-server-314|c-server-315|c-server-317|c-server-318|c-server-319|c-server-320|c-server-321-message|c-server-321|c-server-322-message|c-server-322|c-server-323|c-server-324|c-server-328|c-server-329|c-server-330|c-server-331|c-server-332|c-server-333|c-server-341|c-server-352|c-server-353|c-server-366|c-server-367|c-server-368|c-server-369|c-server-371|c-server-372|c-server-374|c-server-375|c-server-376|c-server-377|c-server-378|c-server-379|c-server-391|c-server-401|c-server-403|c-server-404|c-server-405|c-server-406|c-server-412|c-server-421|c-server-422|c-server-431|c-server-432|c-server-433|c-server-437|c-server-442|c-server-445|c-server-446|c-server-451|c-server-461|c-server-462|c-server-463|c-server-464|c-server-465|c-server-474|c-server-475|c-server-477|c-server-481|c-server-482|c-server-483|c-server-484|c-server-485|c-server-491|c-server-501|c-server-502|c-server-671|c-server-ERROR|c-server-INVITE|c-server-JOIN|c-server-KICK|c-server-MODE|c-server-MOTD|c-server-NICK|c-server-NOTICE|c-server-PART|c-server-PING|c-server-PONG|c-server-PRIVMSG|c-server-QUIT|c-server-TOPIC|c-server-WALLOPS|c-server-buffer-live-p|c-server-buffer-p|c-server-buffer|c-server-connect|c-server-filter-function|c-server-join-channel|c-server-process-alive|c-server-reconnect-p|c-server-reconnect|c-server-select|c-server-send-ping|c-server-send-queue|c-server-send|c-server-setup-periodical-ping|c-server-user-buffers--cmacro|c-server-user-buffers|c-server-user-full-name--cmacro|c-server-user-full-name|c-server-user-host--cmacro|c-server-user-host|c-server-user-info--cmacro|c-server-user-info|c-server-user-login--cmacro|c-server-user-login|c-server-user-nickname--cmacro|c-server-user-nickname|c-server-user-p--cmacro|c-server-user-p|c-services-mode|c-set-active-buffer|c-set-channel-key|c-set-channel-limit|c-set-current-nick|c-set-initial-user-mode|c-set-modes|c-set-network-name|c-set-topic|c-set-write-file-functions|c-setup-buffer|c-shorten-server-name|c-show-timestamps|c-smiley-disable|c-smiley-enable|c-smiley-mode|c-smiley|c-sort-channel-users-alphabetically|c-sort-channel-users-by-activity|c-sort-strings|c-sound-mode|c-speedbar-browser|c-spelling-mode|c-split-line|c-split-multiline-safe|c-ssl|c-stamp-disable|c-stamp-enable|c-stamp-mode|c-string-invisible-p|c-string-no-properties|c-string-to-emacs-time|c-string-to-port|c-subseq|c-time-diff|c-time-gt|c-timestamp-mode|c-timestamp-offset|c-tls|c-toggle-channel-mode|c-toggle-ctcp-autoresponse|c-toggle-debug-irc-protocol|c-toggle-flood-control|c-toggle-interpret-controls|c-toggle-timestamps|c-track-add-to-mode-line|c-track-disable|c-track-enable|c-track-face-priority|c-track-find-face|c-track-get-active-buffer|c-track-get-buffer-window|c-track-minor-mode-maybe|c-track-minor-mode|c-track-mode|c-track-modified-channels|c-track-remove-from-mode-line|c-track-shorten-names|c-track-sort-by-activest|c-track-sort-by-importance|c-track-switch-buffer|c-trim-string|c-truncate-buffer-to-size|c-truncate-buffer|c-truncate-mode|c-unique-channel-names|c-unique-substring-1|c-unique-substrings|c-unmorse-disable|c-unmorse-enable|c-unmorse-mode|c-unmorse|c-unset-network-name|c-upcase-first-word|c-update-channel-key|c-update-channel-limit|c-update-channel-member|c-update-channel-topic|c-update-current-channel-member|c-update-mode-line-buffer|c-update-mode-line|c-update-modes|c-update-modules|c-update-undo-list|c-update-user-nick|c-update-user|c-user-input|c-user-is-active|c-user-spec|c-version|c-view-mode-enter|c-wash-quit-reason|c-window-configuration-change|c-with-all-buffers-of-server|c-with-buffer|c-with-selected-window|c-with-server-buffer|c-xdcc-add-file|c-xdcc-mode|c|egistry|evision|t--abbreviate-string|t--activate-font-lock-keywords|t--button-action-position|t--ewoc-entry-expanded-p--cmacro|t--ewoc-entry-expanded-p|t--ewoc-entry-extended-printer-limits-p--cmacro|t--ewoc-entry-extended-printer-limits-p|t--ewoc-entry-hidden-p--cmacro|t--ewoc-entry-hidden-p|t--ewoc-entry-p--cmacro|t--ewoc-entry-p|t--ewoc-entry-test--cmacro|t--ewoc-entry-test|t--ewoc-position|t--expand-should-1|t--expand-should|t--explain-equal-including-properties|t--explain-equal-rec|t--explain-equal|t--explain-format-atom|t--force-message-log-buffer-truncation|t--format-time-iso8601|t--insert-human-readable-selector|t--insert-infos|t--make-stats|t--make-xrefs-region|t--parse-keys-and-body|t--plist-difference-explanation|t--pp-with-indentation-and-newline|t--print-backtrace|t--print-test-for-ewoc|t--proper-list-p|t--record-backtrace|t--remove-from-list|t--results-expand-collapse-button-action|t--results-font-lock-function|t--results-format-expected-unexpected|t--results-move|t--results-progress-bar-button-action|t--results-test-at-point-allow-redefinition|t--results-test-at-point-no-redefinition|t--results-test-node-at-point|t--results-test-node-or-null-at-point|t--results-update-after-test-redefinition|t--results-update-ewoc-hf|t--results-update-stats-display-maybe|t--results-update-stats-display|t--run-test-debugger|t--run-test-internal|t--setup-results-buffer|t--should-error-handle-error|t--signal-should-execution|t--significant-plist-keys|t--skip-unless|t--special-operator-p|t--stats-aborted-p--cmacro|t--stats-aborted-p|t--stats-current-test--cmacro|t--stats-current-test|t--stats-end-time--cmacro)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)e(?:rt--stats-end-time|rt--stats-failed-expected--cmacro|rt--stats-failed-expected|rt--stats-failed-unexpected--cmacro|rt--stats-failed-unexpected|rt--stats-next-redisplay--cmacro|rt--stats-next-redisplay|rt--stats-p--cmacro|rt--stats-p|rt--stats-passed-expected--cmacro|rt--stats-passed-expected|rt--stats-passed-unexpected--cmacro|rt--stats-passed-unexpected|rt--stats-selector--cmacro|rt--stats-selector|rt--stats-set-test-and-result|rt--stats-skipped--cmacro|rt--stats-skipped|rt--stats-start-time--cmacro|rt--stats-start-time|rt--stats-test-end-times--cmacro|rt--stats-test-end-times|rt--stats-test-key|rt--stats-test-map--cmacro|rt--stats-test-map|rt--stats-test-pos|rt--stats-test-results--cmacro|rt--stats-test-results|rt--stats-test-start-times--cmacro|rt--stats-test-start-times|rt--stats-tests--cmacro|rt--stats-tests|rt--string-first-line|rt--test-execution-info-ert-debug-on-error--cmacro|rt--test-execution-info-ert-debug-on-error|rt--test-execution-info-exit-continuation--cmacro|rt--test-execution-info-exit-continuation|rt--test-execution-info-next-debugger--cmacro|rt--test-execution-info-next-debugger|rt--test-execution-info-p--cmacro|rt--test-execution-info-p|rt--test-execution-info-result--cmacro|rt--test-execution-info-result|rt--test-execution-info-test--cmacro|rt--test-execution-info-test|rt--test-name-button-action|rt--tests-running-mode-line-indicator|rt--unload-function|rt-char-for-test-result|rt-deftest|rt-delete-all-tests|rt-delete-test|rt-describe-test|rt-equal-including-properties|rt-face-for-stats|rt-face-for-test-result|rt-fail|rt-find-test-other-window|rt-get-test|rt-info|rt-insert-test-name-button|rt-kill-all-test-buffers|rt-make-test-unbound|rt-pass|rt-read-test-name-at-point|rt-read-test-name|rt-results-describe-test-at-point|rt-results-find-test-at-point-other-window|rt-results-jump-between-summary-and-result|rt-results-mode-menu|rt-results-mode|rt-results-next-test|rt-results-pop-to-backtrace-for-test-at-point|rt-results-pop-to-messages-for-test-at-point|rt-results-pop-to-should-forms-for-test-at-point|rt-results-pop-to-timings|rt-results-previous-test|rt-results-rerun-all-tests|rt-results-rerun-test-at-point-debugging-errors|rt-results-rerun-test-at-point|rt-results-toggle-printer-limits-for-test-at-point|rt-run-or-rerun-test|rt-run-test|rt-run-tests-batch-and-exit|rt-run-tests-batch|rt-run-tests-interactively|rt-run-tests|rt-running-test|rt-select-tests|rt-set-test|rt-simple-view-mode|rt-skip|rt-stats-completed-expected|rt-stats-completed-unexpected|rt-stats-completed|rt-stats-skipped|rt-stats-total|rt-string-for-test-result|rt-summarize-tests-batch-and-exit|rt-test-aborted-with-non-local-exit-messages--cmacro|rt-test-aborted-with-non-local-exit-messages|rt-test-aborted-with-non-local-exit-p--cmacro|rt-test-aborted-with-non-local-exit-p|rt-test-aborted-with-non-local-exit-should-forms--cmacro|rt-test-aborted-with-non-local-exit-should-forms|rt-test-at-point|rt-test-body--cmacro|rt-test-body|rt-test-boundp|rt-test-documentation--cmacro|rt-test-documentation|rt-test-expected-result-type--cmacro|rt-test-expected-result-type|rt-test-failed-backtrace--cmacro|rt-test-failed-backtrace|rt-test-failed-condition--cmacro|rt-test-failed-condition|rt-test-failed-infos--cmacro|rt-test-failed-infos|rt-test-failed-messages--cmacro|rt-test-failed-messages|rt-test-failed-p--cmacro|rt-test-failed-p|rt-test-failed-should-forms--cmacro|rt-test-failed-should-forms|rt-test-most-recent-result--cmacro|rt-test-most-recent-result|rt-test-name--cmacro|rt-test-name|rt-test-p--cmacro|rt-test-p|rt-test-passed-messages--cmacro|rt-test-passed-messages|rt-test-passed-p--cmacro|rt-test-passed-p|rt-test-passed-should-forms--cmacro|rt-test-passed-should-forms|rt-test-quit-backtrace--cmacro|rt-test-quit-backtrace|rt-test-quit-condition--cmacro|rt-test-quit-condition|rt-test-quit-infos--cmacro|rt-test-quit-infos|rt-test-quit-messages--cmacro|rt-test-quit-messages|rt-test-quit-p--cmacro|rt-test-quit-p|rt-test-quit-should-forms--cmacro|rt-test-quit-should-forms|rt-test-result-expected-p|rt-test-result-messages--cmacro|rt-test-result-messages|rt-test-result-p--cmacro|rt-test-result-p|rt-test-result-should-forms--cmacro|rt-test-result-should-forms|rt-test-result-type-p|rt-test-result-with-condition-backtrace--cmacro|rt-test-result-with-condition-backtrace|rt-test-result-with-condition-condition--cmacro|rt-test-result-with-condition-condition|rt-test-result-with-condition-infos--cmacro|rt-test-result-with-condition-infos|rt-test-result-with-condition-messages--cmacro|rt-test-result-with-condition-messages|rt-test-result-with-condition-p--cmacro|rt-test-result-with-condition-p|rt-test-result-with-condition-should-forms--cmacro|rt-test-result-with-condition-should-forms|rt-test-skipped-backtrace--cmacro|rt-test-skipped-backtrace|rt-test-skipped-condition--cmacro|rt-test-skipped-condition|rt-test-skipped-infos--cmacro|rt-test-skipped-infos|rt-test-skipped-messages--cmacro|rt-test-skipped-messages|rt-test-skipped-p--cmacro|rt-test-skipped-p|rt-test-skipped-should-forms--cmacro|rt-test-skipped-should-forms|rt-test-tags--cmacro|rt-test-tags|rt|shell/addpath|shell/define|shell/env|shell/eshell-debug|shell/exit|shell/export|shell/jobs|shell/kill|shell/setq|shell/unset|shell/wait|shell/which|shell--apply-redirections|shell--do-opts|shell--process-args|shell--process-option|shell--set-option|shell-add-to-window-buffer-names|shell-apply\\\\*|shell-apply-indices|shell-applyn??|shell-arg-delimiter|shell-arg-initialize|shell-as-subcommand|shell-backward-argument|shell-begin-on-new-line|shell-beginning-of-input|shell-beginning-of-output|shell-bol|shell-buffered-print|shell-clipboard-append|shell-close-handles|shell-close-target|shell-cmd-initialize|shell-command-finished|shell-command-result|shell-command-started|shell-command-to-value|shell-commands??|shell-complete-lisp-symbols|shell-complete-variable-assignment|shell-complete-variable-reference|shell-condition-case|shell-convert|shell-copy-environment|shell-copy-handles|shell-copy-old-input|shell-copy-tree|shell-create-handles|shell-current-ange-uids|shell-debug-command|shell-debug-show-parsed-args|shell-directory-files-and-attributes|shell-directory-files|shell-do-command-to-value|shell-do-eval|shell-do-pipelines-synchronously|shell-do-pipelines|shell-do-subjob|shell-end-of-output|shell-environment-variables|shell-envvar-names|shell-errorn??|shell-escape-arg|shell-eval\\\\*|shell-eval-command|shell-eval-using-options|shell-evaln??|shell-exec-lisp|shell-execute-pipeline|shell-exit-success-p|shell-explicit-command|shell-ext-initialize|shell-external-command|shell-file-attributes|shell-find-alias-function|shell-find-delimiter|shell-find-interpreter|shell-find-tag|shell-finish-arg|shell-flatten-and-stringify|shell-flatten-list|shell-flush|shell-for|shell-forward-argument|shell-funcall\\\\*?|shell-funcalln|shell-gather-process-output|shell-get-old-input|shell-get-target|shell-get-variable|shell-goto-input-start|shell-group-id|shell-group-name|shell-handle-ansi-color|shell-handle-control-codes|shell-handle-local-variables|shell-index-value|shell-init-print-buffer|shell-insert-buffer-name|shell-insert-envvar|shell-insert-process|shell-insertion-filter|shell-interactive-output-p|shell-interactive-print|shell-interactive-process|shell-intercept-commands|shell-interpolate-variable|shell-interrupt-process|shell-invoke-batch-file|shell-invoke-directly|shell-invokify-arg|shell-io-initialize|shell-kill-append|shell-kill-buffer-function|shell-kill-input|shell-kill-new|shell-kill-output|shell-kill-process-function|shell-kill-process|shell-life-is-too-much|shell-lisp-command\\\\*?|shell-looking-at-backslash-return|shell-make-private-directory|shell-manipulate|shell-mark-output|shell-mode|shell-move-argument|shell-named-command\\\\*?|shell-needs-pipe-p|shell-no-command-conversion|shell-operator|shell-output-filter|shell-output-object-to-target|shell-output-object|shell-parse-ange-ls|shell-parse-arguments??|shell-parse-backslash|shell-parse-colon-path|shell-parse-command-input|shell-parse-command|shell-parse-delimiter|shell-parse-double-quote|shell-parse-indices|shell-parse-lisp-argument|shell-parse-literal-quote|shell-parse-pipeline|shell-parse-redirection|shell-parse-special-reference|shell-parse-subcommand-argument|shell-parse-variable-ref|shell-parse-variable|shell-plain-command|shell-postoutput-scroll-to-bottom|shell-preinput-scroll-to-bottom|shell-print|shell-printable-size|shell-printn|shell-proc-initialize|shell-process-identity|shell-process-interact|shell-processp|shell-protect-handles|shell-protect|shell-push-command-mark|shell-query-kill-processes|shell-queue-input|shell-quit-process|shell-quote-argument|shell-quote-backslash|shell-read-group-names|shell-read-host-names|shell-read-hosts-file|shell-read-hosts|shell-read-passwd-file|shell-read-passwd|shell-read-process-name|shell-read-user-names|shell-record-process-object|shell-redisplay|shell-regexp-arg|shell-remote-command|shell-remove-from-window-buffer-names|shell-remove-process-entry|shell-repeat-argument|shell-report-bug|shell-reset-after-proc|shell-reset|shell-resolve-current-argument|shell-resume-command|shell-resume-eval|shell-return-exits-minibuffer|shell-rewrite-for-command|shell-rewrite-if-command|shell-rewrite-initial-subcommand|shell-rewrite-named-command|shell-rewrite-sexp-command|shell-rewrite-while-command|shell-round-robin-kill|shell-run-output-filters|shell-script-interpreter|shell-search-path|shell-self-insert-command|shell-send-eof-to-process|shell-send-input|shell-send-invisible|shell-sentinel|shell-separate-commands|shell-set-output-handle|shell-show-maximum-output|shell-show-output|shell-show-usage|shell-split-path|shell-stringify-list|shell-stringify|shell-strip-redirections|shell-structure-basic-command|shell-subcommand-arg-values|shell-subgroups|shell-sublist|shell-substring|shell-to-flat-string|shell-toggle-direct-send|shell-trap-errors|shell-truncate-buffer|shell-under-windows-p|shell-uniqify-list|shell-unload-all-modules|shell-unload-extension-modules|shell-update-markers|shell-user-id|shell-user-name|shell-using-module|shell-var-initialize|shell-variables-list|shell-wait-for-process|shell-watch-for-password-prompt|shell-winnow-list|shell-with-file-modes|shell-with-private-file-modes|shell|tags--xref-find-definitions|tags-file-of-tag|tags-goto-tag-location|tags-list-tags|tags-recognize-tags-table|tags-snarf-tag|tags-tags-apropos-additional|tags-tags-apropos|tags-tags-completion-table|tags-tags-included-tables|tags-tags-table-files|tags-verify-tags-table|tags-xref-find|thio-composition-function|thio-fidel-to-java-buffer|thio-fidel-to-sera-buffer|thio-fidel-to-sera-marker|thio-fidel-to-sera-region|thio-fidel-to-tex-buffer|thio-find-file|thio-input-special-character|thio-insert-ethio-space|thio-java-to-fidel-buffer|thio-modify-vowel|thio-replace-space|thio-sera-to-fidel-buffer|thio-sera-to-fidel-marker|thio-sera-to-fidel-region|thio-tex-to-fidel-buffer|thio-write-file|typecase|udc-add-field-to-records|udc-bookmark-current-server|udc-bookmark-server|udc-caar|udc-cadr|udc-cdaar|udc-cdar|udc-customize|udc-default-set|udc-display-generic-binary|udc-display-jpeg-as-button|udc-display-jpeg-inline|udc-display-mail|udc-display-records|udc-display-sound|udc-display-url|udc-distribute-field-on-records|udc-edit-hotlist|udc-expand-inline|udc-extract-n-word-formats|udc-filter-duplicate-attributes|udc-filter-partial-records|udc-format-attribute-name-for-display|udc-format-query|udc-get-attribute-list|udc-get-email|udc-get-phone|udc-insert-record-at-point-into-bbdb|udc-install-menu|udc-lax-plist-get|udc-load-eudc|udc-menu|udc-mode|udc-move-to-next-record|udc-move-to-previous-record|udc-plist-get|udc-plist-member)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(?:eudc-print-attribute-value|eudc-print-record-field|eudc-process-form|eudc-protocol-local-variable-p|eudc-protocol-set|eudc-query-form|eudc-query|eudc-register-protocol|eudc-replace-in-string|eudc-save-options|eudc-select|eudc-server-local-variable-p|eudc-server-set|eudc-set-server|eudc-set|eudc-tools-menu|eudc-translate-attribute-list|eudc-translate-query|eudc-try-bbdb-insert|eudc-update-local-variables|eudc-update-variable|eudc-variable-default-value|eudc-variable-protocol-value|eudc-variable-server-value|eval-after-load--anon-cmacro|eval-after-load|eval-defun|eval-expression-print-format|eval-expression|eval-last-sexp|eval-next-after-load|eval-print-last-sexp|eval-sexp-add-defvars|eval-when|evenp|event-apply-alt-modifier|event-apply-control-modifier|event-apply-hyper-modifier|event-apply-meta-modifier|event-apply-modifier|event-apply-shift-modifier|event-apply-super-modifier|every|ewoc--adjust|ewoc--buffer--cmacro|ewoc--buffer|ewoc--create--cmacro|ewoc--create|ewoc--dll--cmacro|ewoc--dll|ewoc--filter-hf-nodes|ewoc--footer--cmacro|ewoc--footer|ewoc--header--cmacro|ewoc--header|ewoc--hf-pp--cmacro|ewoc--hf-pp|ewoc--insert-new-node|ewoc--last-node--cmacro|ewoc--last-node|ewoc--node-create--cmacro|ewoc--node-create|ewoc--node-data--cmacro|ewoc--node-data|ewoc--node-left--cmacro|ewoc--node-left|ewoc--node-next|ewoc--node-nth|ewoc--node-prev|ewoc--node-right--cmacro|ewoc--node-right|ewoc--node-start-marker--cmacro|ewoc--node-start-marker|ewoc--pretty-printer--cmacro|ewoc--pretty-printer|ewoc--refresh-node|ewoc--set-buffer-bind-dll-let\\\\*|ewoc--set-buffer-bind-dll|ewoc--wrap|ewoc-p--cmacro|ewoc-p|eww-add-bookmark|eww-back-url|eww-beginning-of-field|eww-beginning-of-text|eww-bookmark-browse|eww-bookmark-kill|eww-bookmark-mode|eww-bookmark-prepare|eww-bookmark-yank|eww-browse-url|eww-browse-with-external-browser|eww-buffer-kill|eww-buffer-select|eww-buffer-show-next|eww-buffer-show-previous|eww-buffer-show|eww-buffers-mode|eww-change-select|eww-copy-page-url|eww-current-url|eww-desktop-data-1|eww-desktop-history-duplicate|eww-desktop-misc-data|eww-detect-charset|eww-display-html|eww-display-image|eww-display-pdf|eww-display-raw|eww-download-callback|eww-download|eww-end-of-field|eww-end-of-text|eww-follow-link|eww-form-checkbox|eww-form-file|eww-form-submit|eww-form-text|eww-forward-url|eww-handle-link|eww-highest-readability|eww-history-browse|eww-history-mode|eww-input-value|eww-inputs|eww-links-at-point|eww-list-bookmarks|eww-list-buffers|eww-list-histories|eww-make-unique-file-name|eww-mode|eww-next-bookmark|eww-next-url|eww-open-file|eww-parse-headers|eww-previous-bookmark|eww-previous-url|eww-process-text-input|eww-read-bookmarks|eww-readable|eww-reload|eww-render|eww-restore-desktop|eww-restore-history|eww-same-page-p|eww-save-history|eww-score-readability|eww-search-words|eww-select-display|eww-select-file|eww-set-character-encoding|eww-setup-buffer|eww-size-text-inputs|eww-submit|eww-suggested-uris|eww-tag-a|eww-tag-body|eww-tag-form|eww-tag-input|eww-tag-link|eww-tag-select|eww-tag-textarea|eww-tag-title|eww-toggle-checkbox|eww-top-url|eww-up-url|eww-update-field|eww-update-header-line-format|eww-view-source|eww-write-bookmarks|eww|ex-args|ex-cd|ex-cmd-accepts-multiple-files-p|ex-cmd-assoc|ex-cmd-complete|ex-cmd-execute|ex-cmd-is-mashed-with-args|ex-cmd-is-one-letter|ex-cmd-not-yet|ex-cmd-obsolete|ex-cmd-read-exit|ex-command|ex-compile|ex-copy|ex-delete|ex-edit|ex-expand-filsyms|ex-find-file|ex-fixup-history|ex-get-inline-cmd-args|ex-global|ex-goto|ex-help|ex-line-no|ex-line-subr|ex-line|ex-map-read-args|ex-map|ex-mark|ex-next-related-buffer|ex-next|ex-preserve|ex-print-display-lines|ex-print|ex-put|ex-pwd|ex-quit|ex-read|ex-recover|ex-rewind|ex-search-address|ex-set-read-variable|ex-set-visited-file-name|ex-set|ex-shell|ex-show-vars|ex-source|ex-splice-args-in-1-letr-cmd|ex-substitute|ex-tag|ex-unmap-read-args|ex-unmap|ex-write-info|ex-write|ex-yank|exchange-dot-and-mark|exchange-point-and-mark|executable-chmod|executable-command-find-posix-p|executable-interpret|executable-make-buffer-file-executable-if-script-p|executable-self-display|executable-set-magic|execute-extended-command--shorter-1|execute-extended-command--shorter|exit-scheme-interaction-mode|exit-splash-screen|expand-abbrev-from-expand|expand-abbrev-hook|expand-add-abbrevs??|expand-build-list|expand-build-marks|expand-c-for-skeleton|expand-clear-markers|expand-do-expansion|expand-in-literal|expand-jump-to-next-slot|expand-jump-to-previous-slot|expand-list-to-markers|expand-mail-aliases|expand-previous-word|expand-region-abbrevs|expand-skeleton-end-hook|external-debugging-output|extract-rectangle-line|extract-rectangle|ezimage-all-images|ezimage-image-association-dump|ezimage-image-dump|ezimage-image-over-string|ezimage-insert-image-button-maybe|ezimage-insert-over-text|f90-abbrev-help|f90-abbrev-start|f90-add-imenu-menu|f90-backslash-not-special|f90-beginning-of-block|f90-beginning-of-subprogram|f90-block-match|f90-break-line|f90-calculate-indent|f90-capitalize-keywords|f90-capitalize-region-keywords|f90-change-keywords|f90-comment-indent|f90-comment-region|f90-current-defun|f90-current-indentation|f90-do-auto-fill|f90-downcase-keywords|f90-downcase-region-keywords|f90-electric-insert|f90-end-of-block|f90-end-of-subprogram|f90-equal-symbols|f90-fill-region|f90-find-breakpoint|f90-font-lock-1|f90-font-lock-2|f90-font-lock-3|f90-font-lock-4|f90-font-lock-n|f90-get-correct-indent|f90-get-present-comment-type|f90-imenu-type-matcher|f90-in-comment|f90-in-string|f90-indent-line-no|f90-indent-line|f90-indent-new-line|f90-indent-region|f90-indent-subprogram|f90-indent-to|f90-insert-end|f90-join-lines|f90-line-continued|f90-looking-at-associate|f90-looking-at-critical|f90-looking-at-do|f90-looking-at-end-critical|f90-looking-at-if-then|f90-looking-at-program-block-end|f90-looking-at-program-block-start|f90-looking-at-select-case|f90-looking-at-type-like|f90-looking-at-where-or-forall|f90-mark-subprogram|f90-match-end|f90-menu|f90-mode|f90-next-block|f90-next-statement|f90-no-block-limit|f90-prepare-abbrev-list-buffer|f90-present-statement-cont|f90-previous-block|f90-previous-statement|f90-typedec-matcher|f90-typedef-matcher|f90-upcase-keywords|f90-upcase-region-keywords|f90-update-line|face-at-point|face-attr-construct|face-attr-match-p|face-attribute-merged-with|face-attribute-specified-or|face-attributes-as-vector|face-attrs-more-relative-p|face-background-pixmap|face-default-spec|face-descriptive-attribute-name|face-doc-string|face-name|face-nontrivial-p|face-read-integer|face-read-string|face-remap-order|face-set-after-frame-default|face-spec-choose|face-spec-match-p|face-spec-recalc|face-spec-reset-face|face-spec-set-2|face-spec-set-match-display|face-user-default-spec|face-valid-attribute-values|facemenu-active-faces|facemenu-add-face|facemenu-add-new-color|facemenu-add-new-face|facemenu-background-menu|facemenu-color-equal|facemenu-complete-face-list|facemenu-enable-faces-p|facemenu-face-menu|facemenu-foreground-menu|facemenu-indentation-menu|facemenu-iterate|facemenu-justification-menu|facemenu-menu|facemenu-post-self-insert-function|facemenu-read-color|facemenu-remove-all|facemenu-remove-face-props|facemenu-remove-special|facemenu-set-background|facemenu-set-bold-italic|facemenu-set-bold|facemenu-set-default|facemenu-set-face-from-menu|facemenu-set-face|facemenu-set-foreground|facemenu-set-intangible|facemenu-set-invisible|facemenu-set-italic|facemenu-set-read-only|facemenu-set-self-insert-face|facemenu-set-underline|facemenu-special-menu|facemenu-update|fancy-about-screen|fancy-splash-frame|fancy-splash-head|fancy-splash-image-file|fancy-splash-insert|fancy-startup-screen|fancy-startup-tail|feature-file|feature-symbols|feedmail-accume-n-nuke-header|feedmail-buffer-to-binmail|feedmail-buffer-to-sendmail|feedmail-buffer-to-smtp|feedmail-buffer-to-smtpmail|feedmail-confirm-addresses-hook-example|feedmail-create-queue-filename|feedmail-deduce-address-list|feedmail-default-date-generator|feedmail-default-message-id-generator|feedmail-default-x-mailer-generator|feedmail-dump-message-to-queue|feedmail-envelope-deducer|feedmail-fiddle-date|feedmail-fiddle-from|feedmail-fiddle-header|feedmail-fiddle-list-of-fiddle-plexes|feedmail-fiddle-list-of-spray-fiddle-plexes|feedmail-fiddle-message-id|feedmail-fiddle-sender|feedmail-fiddle-spray-address|feedmail-fiddle-x-mailer|feedmail-fill-this-one|feedmail-fill-to-cc-function|feedmail-find-eoh|feedmail-fqm-p|feedmail-give-it-to-buffer-eater|feedmail-look-at-queue-directory|feedmail-mail-send-hook-splitter|feedmail-message-action-draft-strong|feedmail-message-action-draft|feedmail-message-action-edit|feedmail-message-action-help-blat|feedmail-message-action-help|feedmail-message-action-queue-strong|feedmail-message-action-queue|feedmail-message-action-scroll-down|feedmail-message-action-scroll-up|feedmail-message-action-send-strong|feedmail-message-action-send|feedmail-message-action-toggle-spray|feedmail-one-last-look|feedmail-queue-express-to-draft|feedmail-queue-express-to-queue|feedmail-queue-reminder-brief|feedmail-queue-reminder-medium|feedmail-queue-reminder|feedmail-queue-runner-prompt|feedmail-queue-send-edit-prompt-inner|feedmail-queue-send-edit-prompt|feedmail-queue-subject-slug-maker|feedmail-rfc822-date|feedmail-rfc822-time-zone|feedmail-run-the-queue-global-prompt|feedmail-run-the-queue-no-prompts|feedmail-run-the-queue|feedmail-say-chatter|feedmail-say-debug|feedmail-scroll-buffer|feedmail-send-it-immediately-wrapper|feedmail-send-it-immediately|feedmail-send-it|feedmail-spray-via-bbdb|feedmail-tidy-up-slug|feedmail-vm-mail-mode|fetch-overload|ff-all-dirs-under|ff-basename|ff-cc-hh-converter|ff-find-file|ff-find-other-file|ff-find-related-file|ff-find-the-other-file|ff-get-file-name|ff-get-file|ff-get-other-file|ff-list-replace-env-vars|ff-mouse-find-other-file-other-window|ff-mouse-find-other-file|ff-other-file-name|ff-set-point-accordingly|ff-string-match|ff-switch-file|ff-switch-to-buffer|ff-treat-as-special|ff-upcase-p|ff-which-function-are-we-in|ffap--toggle-read-only|ffap-all-subdirs-loop|ffap-all-subdirs|ffap-alternate-file-other-window|ffap-alternate-file|ffap-at-mouse|ffap-bib|ffap-bindings|ffap-bug|ffap-c\\\\+\\\\+-mode|ffap-c-mode|ffap-completable|ffap-copy-string-as-kill|ffap-dired-other-frame|ffap-dired-other-window|ffap-dired|ffap-el-mode|ffap-el|ffap-event-buffer|ffap-file-at-point|ffap-file-exists-string|ffap-file-remote-p|ffap-file-suffix|ffap-fixup-machine|ffap-fixup-url|ffap-fortran-mode|ffap-gnus-hook|ffap-gnus-menu|ffap-gnus-next|ffap-gnus-wrapper|ffap-gopher-at-point|ffap-guess-file-name-at-point|ffap-guesser|ffap-highlight|ffap-home|ffap-host-to-filename|ffap-info-2|ffap-info-3|ffap-info|ffap-kpathsea-expand-path|ffap-latex-mode|ffap-lcd|ffap-list-directory|ffap-list-env|ffap-literally|ffap-locate-file|ffap-machine-at-point|ffap-machine-p|ffap-menu-ask|ffap-menu-cont|ffap-menu-rescan|ffap-menu|ffap-mouse-event|ffap-newsgroup-p|ffap-next-guess|ffap-next-url|ffap-next|ffap-other-frame|ffap-other-window|ffap-prompter|ffap-read-file-or-url-internal|ffap-read-file-or-url|ffap-read-only-other-frame|ffap-read-only-other-window|ffap-read-only|ffap-read-url-internal|ffap-reduce-path|ffap-replace-file-component|ffap-rfc|ffap-ro-mode-hook|ffap-string-around|ffap-string-at-point|ffap-submit-bug|ffap-symbol-value|ffap-tex-init|ffap-tex-mode|ffap-tex|ffap-url-at-point|ffap-url-p|ffap-url-unwrap-local|ffap-url-unwrap-remote|ffap-what-domain|ffap|field-at-pos|field-complete|fifth|file-attributes-lessp|file-cache--read-list|file-cache-add-directory-list|file-cache-add-directory-recursively|file-cache-add-directory-using-find|file-cache-add-directory-using-locate|file-cache-add-directory|file-cache-add-file-list|file-cache-add-file|file-cache-add-from-file-cache-buffer|file-cache-canonical-directory|file-cache-choose-completion|file-cache-clear-cache|file-cache-complete|file-cache-completion-setup-function|file-cache-debug-read-from-minibuffer|file-cache-delete-directory-list|file-cache-delete-directory|file-cache-delete-file-list|file-cache-delete-file-regexp|file-cache-delete-file|file-cache-directory-name|file-cache-display|file-cache-do-delete-directory)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)f(?:ile-cache-file-name|ile-cache-files-matching-internal|ile-cache-files-matching|ile-cache-minibuffer-complete|ile-cache-mouse-choose-completion|ile-dependents|ile-loadhist-lookup|ile-modes-char-to-right|ile-modes-char-to-who|ile-modes-rights-to-number|ile-name-non-special|ile-name-shadow-mode|ile-notify--event-cookie|ile-notify--event-file-name|ile-notify--event-file1-name|ile-notify-callback|ile-notify-handle-event|ile-of-tag|ile-provides|ile-requires|ile-set-intersect|ile-size-human-readable|ile-tree-walk|ilesets-add-buffer|ilesets-alist-get|ilesets-browse-dir|ilesets-browser-name|ilesets-build-dir-submenu-now|ilesets-build-dir-submenu|ilesets-build-ingroup-submenu|ilesets-build-menu-maybe|ilesets-build-menu-now|ilesets-build-menu|ilesets-build-submenu|ilesets-close|ilesets-cmd-get-args|ilesets-cmd-get-def|ilesets-cmd-get-fn|ilesets-cmd-isearch-getargs|ilesets-cmd-query-replace-getargs|ilesets-cmd-query-replace-regexp-getargs|ilesets-cmd-shell-command-getargs|ilesets-cmd-shell-command|ilesets-cmd-show-result|ilesets-conditional-sort|ilesets-convert-path-list|ilesets-convert-patterns|ilesets-customize|ilesets-data-get-data|ilesets-data-get-name|ilesets-data-get|ilesets-data-set-default|ilesets-data-set|ilesets-directory-files|ilesets-edit|ilesets-entry-get-dormant-flag|ilesets-entry-get-files??|ilesets-entry-get-filter-dirs-flag|ilesets-entry-get-master|ilesets-entry-get-open-fn|ilesets-entry-get-pattern--dir|ilesets-entry-get-pattern--pattern|ilesets-entry-get-pattern|ilesets-entry-get-save-fn|ilesets-entry-get-tree-max-level|ilesets-entry-get-tree|ilesets-entry-get-verbosity|ilesets-entry-mode|ilesets-entry-set-files|ilesets-error|ilesets-eviewer-constraint-p|ilesets-eviewer-get-props|ilesets-exit|ilesets-file-close|ilesets-file-open|ilesets-files-equalp|ilesets-files-in-same-directory-p|ilesets-filetype-get-prop|ilesets-filetype-property|ilesets-filter-dir-names|ilesets-filter-list|ilesets-find-file-using|ilesets-find-file|ilesets-find-or-display-file|ilesets-get-cmd-menu|ilesets-get-external-viewer-by-name|ilesets-get-external-viewer|ilesets-get-filelist|ilesets-get-fileset-from-name|ilesets-get-fileset-name|ilesets-get-menu-epilog|ilesets-get-quoted-selection|ilesets-get-selection|ilesets-get-shortcut|ilesets-goto-homepage|ilesets-info|ilesets-ingroup-cache-get|ilesets-ingroup-cache-put|ilesets-ingroup-collect-build-menu|ilesets-ingroup-collect-files|ilesets-ingroup-collect-finder|ilesets-ingroup-collect|ilesets-ingroup-get-data|ilesets-ingroup-get-pattern|ilesets-ingroup-get-remdupl-p|ilesets-init|ilesets-member|ilesets-menu-cache-file-load|ilesets-menu-cache-file-save-maybe|ilesets-menu-cache-file-save|ilesets-message|ilesets-open|ilesets-ormap|ilesets-quote|ilesets-rebuild-this-submenu|ilesets-remake-shortcut|ilesets-remove-buffer|ilesets-remove-from-ubl|ilesets-reset-filename-on-change|ilesets-reset-fileset|ilesets-run-cmd--repl-fn|ilesets-run-cmd|ilesets-save-config|ilesets-select-command|ilesets-set-config|ilesets-set-default!|ilesets-set-default\\\\+?|ilesets-some|ilesets-spawn-external-viewer|ilesets-sublist|ilesets-update-cleanup|ilesets-update-pre010505|ilesets-update|ilesets-which-command-p|ilesets-which-command|ilesets-which-file|ilesets-wrap-submenu|ill-comment-paragraph|ill-common-string-prefix|ill-delete-newlines|ill-delete-prefix|ill-find-break-point|ill-flowed-encode|ill-flowed|ill-forward-paragraph|ill-french-nobreak-p|ill-indent-to-left-margin|ill-individual-paragraphs-citation|ill-individual-paragraphs-prefix|ill-match-adaptive-prefix|ill-minibuffer-function|ill-move-to-break-point|ill-newline|ill-nobreak-p|ill-nonuniform-paragraphs|ill-single-char-nobreak-p|ill-single-word-nobreak-p|ill-text-properties-at|ill|iltered-frame-list|ind-alternate-file-other-window|ind-alternate-file|ind-change-log|ind-class|ind-cmd|ind-cmpl-prefix-entry|ind-coding-systems-region-internal|ind-composition-internal|ind-composition|ind-definition-noselect|ind-dired-filter|ind-dired-sentinel|ind-dired|ind-emacs-lisp-shadows|ind-exact-completion|ind-face-definition|ind-file--read-only|ind-file-at-point|ind-file-existing|ind-file-literally-at-point|ind-file-noselect-1|ind-file-other-frame|ind-file-read-args|ind-file-read-only-other-frame|ind-file-read-only-other-window|ind-function-C-source|ind-function-advised-original|ind-function-at-point|ind-function-do-it|ind-function-library|ind-function-noselect|ind-function-on-key|ind-function-other-frame|ind-function-other-window|ind-function-read|ind-function-search-for-symbol|ind-function-setup-keys|ind-function|ind-grep-dired|ind-grep|ind-if-not|ind-if|ind-library--load-name|ind-library-name|ind-library-suffixes|ind-library|ind-lisp-debug-message|ind-lisp-default-directory-predicate|ind-lisp-default-file-predicate|ind-lisp-file-predicate-is-directory|ind-lisp-find-dired-filter|ind-lisp-find-dired-insert-file|ind-lisp-find-dired-internal|ind-lisp-find-dired-subdirectories|ind-lisp-find-dired|ind-lisp-find-files-internal|ind-lisp-find-files|ind-lisp-format-time|ind-lisp-format|ind-lisp-insert-directory|ind-lisp-object-file-name|ind-lisp-time-index|ind-multibyte-characters|ind-name-dired|ind-new-buffer-file-coding-system|ind-tag-default-as-regexp|ind-tag-default-as-symbol-regexp|ind-tag-default-bounds|ind-tag-default|ind-tag-in-order|ind-tag-interactive|ind-tag-noselect|ind-tag-other-frame|ind-tag-other-window|ind-tag-regexp|ind-tag-tag|ind-tag|ind-variable-at-point|ind-variable-noselect|ind-variable-other-frame|ind-variable-other-window|ind-variable|ind|inder-by-keyword|inder-commentary|inder-compile-keywords-make-dist|inder-compile-keywords|inder-current-item|inder-exit|inder-goto-xref|inder-insert-at-column|inder-list-keywords|inder-list-matches|inder-mode|inder-mouse-face-on-line|inder-mouse-select|inder-select|inder-summary|inder-unknown-keywords|inder-unload-function|inger|irst-error|irst|loatp-safe|loor\\\\*|lush-lines|lymake-add-buildfile-to-cache|lymake-add-err-info|lymake-add-line-err-info|lymake-add-project-include-dirs-to-cache|lymake-after-change-function|lymake-after-save-hook|lymake-can-syntax-check-file|lymake-check-include|lymake-check-patch-master-file-buffer|lymake-clear-buildfile-cache|lymake-clear-project-include-dirs-cache|lymake-compilation-is-running|lymake-compile|lymake-copy-buffer-to-temp-buffer|lymake-create-master-file|lymake-create-temp-inplace|lymake-create-temp-with-folder-structure|lymake-delete-own-overlays|lymake-delete-temp-directory|lymake-display-err-menu-for-current-line|lymake-display-warning|lymake-er-get-line-err-info-list|lymake-er-get-line|lymake-er-make-er|lymake-find-buffer-for-file|lymake-find-buildfile|lymake-find-err-info|lymake-find-file-hook|lymake-find-make-buildfile|lymake-find-possible-master-files|lymake-fix-file-name|lymake-fix-line-numbers|lymake-get-ant-cmdline|lymake-get-buildfile-from-cache|lymake-get-cleanup-function|lymake-get-err-count|lymake-get-file-name-mode-and-masks|lymake-get-first-err-line-no|lymake-get-full-nonpatched-file-name|lymake-get-full-patched-file-name|lymake-get-include-dirs-dot|lymake-get-include-dirs|lymake-get-init-function|lymake-get-last-err-line-no|lymake-get-line-err-count|lymake-get-make-cmdline|lymake-get-next-err-line-no|lymake-get-prev-err-line-no|lymake-get-project-include-dirs-from-cache|lymake-get-project-include-dirs-imp|lymake-get-project-include-dirs|lymake-get-real-file-name-function|lymake-get-real-file-name|lymake-get-syntax-check-program-args|lymake-get-system-include-dirs|lymake-get-tex-args|lymake-goto-file-and-line|lymake-goto-line|lymake-goto-next-error|lymake-goto-prev-error|lymake-highlight-err-lines|lymake-highlight-line|lymake-init-create-temp-buffer-copy|lymake-init-create-temp-source-and-master-buffer-copy|lymake-init-find-buildfile-dir|lymake-ins-after|lymake-kill-buffer-hook|lymake-kill-process|lymake-ler-file--cmacro|lymake-ler-file|lymake-ler-full-file--cmacro|lymake-ler-full-file|lymake-ler-line--cmacro|lymake-ler-line|lymake-ler-make-ler--cmacro|lymake-ler-make-ler|lymake-ler-p--cmacro|lymake-ler-p|lymake-ler-set-file|lymake-ler-set-full-file|lymake-ler-set-line|lymake-ler-text--cmacro|lymake-ler-text|lymake-ler-type--cmacro|lymake-ler-type|lymake-line-err-info-is-less-or-equal|lymake-log|lymake-make-overlay|lymake-master-cleanup|lymake-master-file-compare|lymake-master-make-header-init|lymake-master-make-init|lymake-master-tex-init|lymake-mode-off|lymake-mode-on|lymake-mode|lymake-on-timer-event|lymake-overlay-p|lymake-parse-err-lines|lymake-parse-line|lymake-parse-output-and-residual|lymake-parse-residual|lymake-patch-err-text|lymake-perl-init|lymake-php-init|lymake-popup-current-error-menu|lymake-post-syntax-check|lymake-process-filter|lymake-process-sentinel|lymake-read-file-to-temp-buffer|lymake-reformat-err-line-patterns-from-compile-el|lymake-region-has-flymake-overlays|lymake-replace-region|lymake-report-fatal-status|lymake-report-status|lymake-safe-delete-directory|lymake-safe-delete-file|lymake-same-files|lymake-save-buffer-in-file|lymake-set-at|lymake-simple-ant-java-init|lymake-simple-cleanup|lymake-simple-java-cleanup|lymake-simple-make-init-impl|lymake-simple-make-init|lymake-simple-make-java-init|lymake-simple-tex-init|lymake-skip-whitespace|lymake-split-output|lymake-start-syntax-check-process|lymake-start-syntax-check|lymake-stop-all-syntax-checks|lymake-xml-init|lyspell-abbrev-table|lyspell-accept-buffer-local-defs|lyspell-after-change-function|lyspell-ajust-cursor-point|lyspell-already-abbrevp|lyspell-auto-correct-previous-hook|lyspell-auto-correct-previous-word|lyspell-auto-correct-word|lyspell-buffer|lyspell-change-abbrev|lyspell-check-changed-word-p|lyspell-check-pre-word-p|lyspell-check-previous-highlighted-word|lyspell-check-region-doublons|lyspell-check-word-p|lyspell-correct-word-before-point|lyspell-correct-word|lyspell-debug-signal-changed-checked|lyspell-debug-signal-no-check|lyspell-debug-signal-pre-word-checked|lyspell-debug-signal-word-checked|lyspell-define-abbrev|lyspell-delay-commands??|lyspell-delete-all-overlays|lyspell-delete-region-overlays|lyspell-deplacement-commands??|lyspell-display-next-corrections|lyspell-do-correct|lyspell-emacs-popup|lyspell-external-point-words|lyspell-generic-progmode-verify|lyspell-get-casechars|lyspell-get-not-casechars|lyspell-get-word|lyspell-goto-next-error|lyspell-hack-local-variables-hook|lyspell-highlight-duplicate-region|lyspell-highlight-incorrect-region|lyspell-kill-ispell-hook|lyspell-large-region|lyspell-math-tex-command-p|lyspell-maybe-correct-doubling|lyspell-maybe-correct-transposition|lyspell-minibuffer-p|lyspell-mode-off|lyspell-mode-on|lyspell-mode|lyspell-notify-misspell|lyspell-overlay-p|lyspell-post-command-hook|lyspell-pre-command-hook|lyspell-process-localwords|lyspell-prog-mode|lyspell-properties-at-p|lyspell-region|lyspell-small-region|lyspell-tex-command-p|lyspell-unhighlight-at|lyspell-word-search-backward|lyspell-word-search-forward|lyspell-word|lyspell-xemacs-popup|ocus-frame|oldout-exit-fold|oldout-mouse-goto-heading|oldout-mouse-hide-or-exit|oldout-mouse-show|oldout-mouse-swallow-events|oldout-mouse-zoom|oldout-update-mode-line|oldout-zoom-subtree|ollow--window-sorter|ollow-adjust-window|ollow-align-compilation-windows|ollow-all-followers|ollow-avoid-tail-recenter|ollow-cache-valid-p|ollow-calc-win-end|ollow-calc-win-start|ollow-calculate-first-window-start-from-above|ollow-calculate-first-window-start-from-below|ollow-comint-scroll-to-bottom|ollow-debug-message|ollow-delete-other-windows-and-split|ollow-end-of-buffer|ollow-estimate-first-window-start|ollow-find-file-hook|ollow-first-window|ollow-last-window|ollow-maximize-region|ollow-menu-filter|ollow-mode|ollow-mwheel-scroll|ollow-next-window|ollow-point-visible-all-windows-p|ollow-pos-visible|ollow-post-command-hook|ollow-previous-window|ollow-recenter|ollow-redisplay|ollow-redraw-after-event|ollow-redraw|ollow-scroll-bar-drag|ollow-scroll-bar-scroll-down)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(?:follow-scroll-bar-scroll-up|follow-scroll-bar-toolkit-scroll|follow-scroll-down|follow-scroll-up|follow-select-if-end-visible|follow-select-if-visible-from-first|follow-select-if-visible|follow-split-followers|follow-switch-to-buffer-all|follow-switch-to-buffer|follow-switch-to-current-buffer-all|follow-update-window-start|follow-window-size-change|follow-windows-aligned-p|follow-windows-start-end|font-get-glyphs|font-get-system-font|font-get-system-normal-font|font-info|font-lock-after-change-function|font-lock-after-fontify-buffer|font-lock-after-unfontify-buffer|font-lock-append-text-property|font-lock-apply-highlight|font-lock-apply-syntactic-highlight|font-lock-change-mode|font-lock-choose-keywords|font-lock-compile-keywords??|font-lock-default-fontify-buffer|font-lock-default-fontify-region|font-lock-default-function|font-lock-default-unfontify-buffer|font-lock-default-unfontify-region|font-lock-defontify|font-lock-ensure|font-lock-eval-keywords|font-lock-extend-jit-lock-region-after-change|font-lock-extend-region-multiline|font-lock-extend-region-wholelines|font-lock-fillin-text-property|font-lock-flush|font-lock-fontify-anchored-keywords|font-lock-fontify-block|font-lock-fontify-buffer|font-lock-fontify-keywords-region|font-lock-fontify-region|font-lock-fontify-syntactic-anchored-keywords|font-lock-fontify-syntactic-keywords-region|font-lock-fontify-syntactically-region|font-lock-initial-fontify|font-lock-match-c-style-declaration-item-and-skip-to-next|font-lock-match-meta-declaration-item-and-skip-to-next|font-lock-mode-internal|font-lock-mode-set-explicitly|font-lock-mode|font-lock-prepend-text-property|font-lock-refresh-defaults|font-lock-set-defaults|font-lock-specified-p|font-lock-turn-off-thing-lock|font-lock-turn-on-thing-lock|font-lock-unfontify-buffer|font-lock-unfontify-region|font-lock-update-removed-keyword-alist|font-lock-value-in-major-mode|font-match-p|font-menu-add-default|font-setting-change-default-font|font-shape-gstring|font-show-log|font-variation-glyphs|fontset-font|fontset-info|fontset-list|fontset-name-p|fontset-plain-name|footnote-mode|foreground-color-at-point|form-at-point|format-annotate-atomic-property-change|format-annotate-function|format-annotate-location|format-annotate-region|format-annotate-single-property-change|format-annotate-value|format-deannotate-region|format-decode-buffer|format-decode-region|format-decode-run-method|format-decode|format-delq-cons|format-encode-buffer|format-encode-region|format-encode-run-method|format-insert-annotations|format-kbd-macro|format-make-relatively-unique|format-proper-list-p|format-property-increment-region|format-read|format-reorder|format-replace-strings|format-spec-make|format-spec|format-subtract-regions|forms-find-file-other-window|forms-find-file|forms-mode|fortran-abbrev-help|fortran-abbrev-start|fortran-analyze-file-format|fortran-auto-fill-mode|fortran-auto-fill|fortran-beginning-do|fortran-beginning-if|fortran-beginning-of-block|fortran-beginning-of-subprogram|fortran-blink-match|fortran-blink-matching-do|fortran-blink-matching-if|fortran-break-line|fortran-calculate-indent|fortran-check-end-prog-re|fortran-check-for-matching-do|fortran-column-ruler|fortran-comment-indent|fortran-comment-region|fortran-current-defun|fortran-current-line-indentation|fortran-electric-line-number|fortran-end-do|fortran-end-if|fortran-end-of-block|fortran-end-of-subprogram|fortran-fill-paragraph|fortran-fill-statement|fortran-fill|fortran-find-comment-start-skip|fortran-gud-find-expr|fortran-hack-local-variables|fortran-indent-comment|fortran-indent-line|fortran-indent-new-line|fortran-indent-subprogram|fortran-indent-to-column|fortran-is-in-string-p|fortran-join-line|fortran-line-length|fortran-line-number-indented-correctly-p|fortran-looking-at-if-then|fortran-make-syntax-propertize-function|fortran-mark-do|fortran-mark-if|fortran-match-and-skip-declaration|fortran-menu|fortran-mode|fortran-next-statement|fortran-numerical-continuation-char|fortran-prepare-abbrev-list-buffer|fortran-previous-statement|fortran-remove-continuation|fortran-split-line|fortran-strip-sequence-nos|fortran-uncomment-region|fortran-window-create-momentarily|fortran-window-create|fortune-add-fortune|fortune-append|fortune-ask-file|fortune-compile|fortune-from-region|fortune-in-buffer|fortune-to-signature|fortune|forward-ifdef|forward-page|forward-paragraph|forward-point|forward-same-syntax|forward-sentence|forward-symbol|forward-text-line|forward-thing|forward-visible-line|forward-whitespace|fourth|frame-border-width|frame-bottom-divider-width|frame-can-run-window-configuration-change-hook|frame-char-size|frame-configuration-p|frame-configuration-to-register|frame-face-alist|frame-focus|frame-font-cache|frame-fringe-width|frame-geom-spec-cons|frame-geom-value-cons|frame-initialize|frame-notice-user-settings|frame-or-buffer-changed-p|frame-remove-geometry-params|frame-right-divider-width|frame-root-window-p|frame-scroll-bar-height|frame-scroll-bar-width|frame-set-background-mode|frame-terminal-default-bg-mode|frame-text-cols|frame-text-height|frame-text-lines|frame-text-width|frame-total-cols|frame-total-lines|frame-windows-min-size|framep-on-display|frames-on-display-list|frameset--find-frame-if|frameset--initial-params|frameset--jump-to-register|frameset--make--cmacro|frameset--make|frameset--minibufferless-last-p|frameset--print-register|frameset--prop-setter|frameset--record-minibuffer-relationships|frameset--restore-frame|frameset--reuse-frame|frameset--set-id|frameset-app--cmacro|frameset-app|frameset-cfg-id|frameset-compute-pos|frameset-copy|frameset-description--cmacro|frameset-description|frameset-filter-iconified|frameset-filter-minibuffer|frameset-filter-params|frameset-filter-sanitize-color|frameset-filter-shelve-param|frameset-filter-tty-to-GUI|frameset-filter-unshelve-param|frameset-frame-id-equal-p|frameset-frame-id|frameset-frame-with-id|frameset-keep-original-display-p|frameset-minibufferless-first-p|frameset-move-onscreen|frameset-name--cmacro|frameset-name|frameset-p--cmacro|frameset-p|frameset-prop|frameset-properties--cmacro|frameset-properties|frameset-restore|frameset-save|frameset-states--cmacro|frameset-states|frameset-switch-to-gui-p|frameset-switch-to-tty-p|frameset-timestamp--cmacro|frameset-timestamp|frameset-to-register|frameset-valid-p|frameset-version--cmacro|frameset-version|fringe--check-style|fringe-bitmap-p|fringe-columns|fringe-mode-initialize|fringe-mode|fringe-query-style|ftp-mode|ftp|full-calc-keypad|full-calc|funcall-interactively|function\\\\*|function-called-at-point|function-equal|function-overload-p|function-put|function|gamegrid-add-score-insecure|gamegrid-add-score-with-update-game-score-1|gamegrid-add-score-with-update-game-score|gamegrid-add-score|gamegrid-cell-offset|gamegrid-characterp|gamegrid-color|gamegrid-colorize-glyph|gamegrid-display-type|gamegrid-event-x|gamegrid-event-y|gamegrid-get-cell|gamegrid-init-buffer|gamegrid-init|gamegrid-initialize-display|gamegrid-kill-timer|gamegrid-make-color-tty-face|gamegrid-make-color-x-face|gamegrid-make-face|gamegrid-make-glyph|gamegrid-make-grid-x-face|gamegrid-make-image-from-vector|gamegrid-make-mono-tty-face|gamegrid-make-mono-x-face|gamegrid-match-spec-list|gamegrid-match-spec|gamegrid-set-cell|gamegrid-set-display-table|gamegrid-set-face|gamegrid-set-font|gamegrid-set-timer|gamegrid-setup-default-font|gamegrid-setup-face|gamegrid-start-timer|gametree-apply-layout|gametree-apply-register-layout|gametree-break-line-here|gametree-children-shown-p|gametree-compute-and-insert-score|gametree-compute-reduced-score|gametree-current-branch-depth|gametree-current-branch-ply|gametree-current-branch-score|gametree-current-layout|gametree-entry-shown-p|gametree-forward-line|gametree-hack-file-layout|gametree-insert-new-leaf|gametree-insert-score|gametree-layout-to-register|gametree-looking-at-ply|gametree-merge-line|gametree-mode|gametree-mouse-break-line-here|gametree-mouse-hide-subtree|gametree-mouse-show-children-and-entry|gametree-mouse-show-subtree|gametree-prettify-heading|gametree-restore-layout|gametree-save-and-hack-layout|gametree-save-layout|gametree-show-children-and-entry|gametree-transpose-following-leaves|gcd|gdb--check-interpreter|gdb--if-arrow|gdb-add-handler|gdb-add-subscriber|gdb-append-to-partial-output|gdb-bind-function-to-buffer|gdb-breakpoints-buffer-name|gdb-breakpoints-list-handler-custom|gdb-breakpoints-list-handler|gdb-breakpoints-mode|gdb-buffer-shows-main-thread-p|gdb-buffer-type|gdb-changed-registers-handler|gdb-check-target-async|gdb-clear-inferior-io|gdb-clear-partial-output|gdb-concat-output|gdb-console|gdb-continue-thread|gdb-control-all-threads|gdb-control-current-thread|gdb-create-define-alist|gdb-current-buffer-frame|gdb-current-buffer-rules|gdb-current-buffer-thread|gdb-current-context-buffer-name|gdb-current-context-command|gdb-current-context-mode-name|gdb-delchar-or-quit|gdb-delete-breakpoint|gdb-delete-frame-or-window|gdb-delete-handler|gdb-delete-subscriber|gdb-disassembly-buffer-name|gdb-disassembly-handler-custom|gdb-disassembly-handler|gdb-disassembly-mode|gdb-disassembly-place-breakpoints|gdb-display-breakpoints-buffer|gdb-display-buffer|gdb-display-disassembly-buffer|gdb-display-disassembly-for-thread|gdb-display-gdb-buffer|gdb-display-io-buffer|gdb-display-locals-buffer|gdb-display-locals-for-thread|gdb-display-memory-buffer|gdb-display-registers-buffer|gdb-display-registers-for-thread|gdb-display-source-buffer|gdb-display-stack-buffer|gdb-display-stack-for-thread|gdb-display-threads-buffer|gdb-done-or-error|gdb-done|gdb-edit-locals-value|gdb-edit-register-value|gdb-edit-value-handler|gdb-edit-value|gdb-emit-signal|gdb-enable-debug|gdb-error|gdb-find-file-hook|gdb-find-watch-expression|gdb-force-mode-line-update|gdb-frame-breakpoints-buffer|gdb-frame-disassembly-buffer|gdb-frame-disassembly-for-thread|gdb-frame-gdb-buffer|gdb-frame-handler|gdb-frame-io-buffer|gdb-frame-locals-buffer|gdb-frame-locals-for-thread|gdb-frame-location|gdb-frame-memory-buffer|gdb-frame-registers-buffer|gdb-frame-registers-for-thread|gdb-frame-stack-buffer|gdb-frame-stack-for-thread|gdb-frame-threads-buffer|gdb-frames-mode|gdb-gdb|gdb-get-buffer-create|gdb-get-buffer|gdb-get-changed-registers|gdb-get-handler-function|gdb-get-location|gdb-get-main-selected-frame|gdb-get-many-fields|gdb-get-prompt|gdb-get-source-file-list|gdb-get-source-file|gdb-get-subscribers|gdb-get-target-string|gdb-goto-breakpoint|gdb-gud-context-call|gdb-gud-context-command|gdb-handle-reply|gdb-handler-function--cmacro|gdb-handler-function|gdb-handler-p--cmacro|gdb-handler-p|gdb-handler-pending-trigger--cmacro|gdb-handler-pending-trigger|gdb-handler-token-number--cmacro|gdb-handler-token-number|gdb-ignored-notification|gdb-inferior-filter|gdb-inferior-io--init-proc|gdb-inferior-io-mode|gdb-inferior-io-name|gdb-inferior-io-sentinel|gdb-init-1|gdb-init-buffer|gdb-input|gdb-internals|gdb-interrupt-thread|gdb-invalidate-breakpoints|gdb-invalidate-disassembly|gdb-invalidate-frames|gdb-invalidate-locals|gdb-invalidate-memory|gdb-invalidate-registers|gdb-invalidate-threads|gdb-io-eof|gdb-io-interrupt|gdb-io-quit|gdb-io-stop|gdb-json-partial-output|gdb-json-read-buffer|gdb-json-string|gdb-jsonify-buffer|gdb-line-posns|gdb-locals-buffer-name|gdb-locals-handler-custom|gdb-locals-handler|gdb-locals-mode|gdb-make-header-line-mouse-map|gdb-many-windows|gdb-mark-line|gdb-memory-buffer-name|gdb-memory-column-width|gdb-memory-format-binary|gdb-memory-format-hexadecimal|gdb-memory-format-menu-1|gdb-memory-format-menu|gdb-memory-format-octal|gdb-memory-format-signed|gdb-memory-format-unsigned|gdb-memory-mode|gdb-memory-set-address-event|gdb-memory-set-address|gdb-memory-set-columns|gdb-memory-set-rows|gdb-memory-show-next-page|gdb-memory-show-previous-page|gdb-memory-unit-byte|gdb-memory-unit-giant|gdb-memory-unit-halfword|gdb-memory-unit-menu-1|gdb-memory-unit-menu|gdb-memory-unit-word|gdb-mi-quote|gdb-mouse-jump|gdb-mouse-set-clear-breakpoint|gdb-mouse-toggle-breakpoint-fringe|gdb-mouse-toggle-breakpoint-margin|gdb-mouse-until|gdb-non-stop-handler|gdb-pad-string|gdb-parent-mode|gdb-partial-output-name|gdb-pending-handler-p|gdb-place-breakpoints|gdb-preempt-existing-or-display-buffer|gdb-preemptively-display-disassembly-buffer|gdb-preemptively-display-locals-buffer|gdb-preemptively-display-registers-buffer|gdb-preemptively-display-stack-buffer|gdb-propertize-header)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)g(?:db-put-breakpoint-icon|db-put-string|db-read-memory-custom|db-read-memory-handler|db-register-names-handler|db-registers-buffer-name|db-registers-handler-custom|db-registers-handler|db-registers-mode|db-remove-all-pending-triggers|db-remove-breakpoint-icons|db-remove-strings|db-reset|db-restore-windows|db-resync|db-rules-buffer-mode|db-rules-name-maker|db-rules-update-trigger|db-running|db-script-beginning-of-defun|db-script-calculate-indentation|db-script-end-of-defun|db-script-font-lock-syntactic-face|db-script-indent-line|db-script-mode|db-script-skip-to-head|db-select-frame|db-select-thread|db-send|db-set-buffer-rules|db-set-window-buffer|db-setq-thread-number|db-setup-windows|db-shell|db-show-run-p|db-show-stop-p|db-speedbar-auto-raise|db-speedbar-expand-node|db-speedbar-timer-fn|db-speedbar-update|db-stack-buffer-name|db-stack-list-frames-custom|db-stack-list-frames-handler|db-starting|db-step-thread|db-stopped|db-strip-string-backslash|db-table-add-row|db-table-column-sizes--cmacro|db-table-column-sizes|db-table-p--cmacro|db-table-p|db-table-right-align--cmacro|db-table-right-align|db-table-row-properties--cmacro|db-table-row-properties|db-table-rows--cmacro|db-table-rows|db-table-string|db-thread-created|db-thread-exited|db-thread-list-handler-custom|db-thread-list-handler|db-thread-selected|db-threads-buffer-name|db-threads-mode|db-toggle-breakpoint|db-toggle-switch-when-another-stopped|db-tooltip-print-1|db-tooltip-print|db-update-buffer-name|db-update-gud-running|db-update|db-var-create-handler|db-var-delete-1|db-var-delete-children|db-var-delete|db-var-evaluate-expression-handler|db-var-list-children-handler|db-var-list-children|db-var-set-format|db-var-update-handler|db-var-update|db-wait-for-pending|db|dbmi-bnf-async-record|dbmi-bnf-console-stream-output|dbmi-bnf-gdb-prompt|dbmi-bnf-incomplete-record-result|dbmi-bnf-init|dbmi-bnf-log-stream-output|dbmi-bnf-out-of-band-record|dbmi-bnf-output|dbmi-bnf-result-and-async-record-impl|dbmi-bnf-result-record|dbmi-bnf-skip-unrecognized|dbmi-bnf-stream-record|dbmi-bnf-target-stream-output|dbmi-is-number|dbmi-same-start|dbmi-start-with|enerate-fontset-menu|eneric-char-p|eneric-make-keywords-list|eneric-mode-internal|eneric-mode|eneric-p|eneric-primary-only-one-p|eneric-primary-only-p|ensym|entemp|et\\\\*|et-edebug-spec|et-file-char|et-free-disk-space|et-language-info|et-mode-local-parent|et-mru-window|et-next-valid-buffer|et-other-frame|et-scroll-bar-mode|et-unicode-property-internal|et-unused-iso-final-char|et-upcase-table|etenv-internal|etf|file-add-watch|file-rm-watch|lasses-change|lasses-convert-to-unreadable|lasses-custom-set|lasses-make-overlay|lasses-make-readable|lasses-make-unreadable|lasses-mode|lasses-overlay-p|lasses-parenthesis-exception-p|lasses-set-overlay-properties|lobal-auto-composition-mode|lobal-auto-revert-mode|lobal-cwarn-mode-check-buffers|lobal-cwarn-mode-cmhh|lobal-cwarn-mode-enable-in-buffers|lobal-cwarn-mode|lobal-ede-mode|lobal-eldoc-mode|lobal-font-lock-mode-check-buffers|lobal-font-lock-mode-cmhh|lobal-font-lock-mode-enable-in-buffers|lobal-font-lock-mode|lobal-hi-lock-mode-check-buffers|lobal-hi-lock-mode-cmhh|lobal-hi-lock-mode-enable-in-buffers|lobal-hi-lock-mode|lobal-highlight-changes-mode-check-buffers|lobal-highlight-changes-mode-cmhh|lobal-highlight-changes-mode-enable-in-buffers|lobal-highlight-changes-mode|lobal-highlight-changes|lobal-hl-line-highlight|lobal-hl-line-mode|lobal-hl-line-unhighlight-all|lobal-hl-line-unhighlight|lobal-linum-mode-check-buffers|lobal-linum-mode-cmhh|lobal-linum-mode-enable-in-buffers|lobal-linum-mode|lobal-prettify-symbols-mode-check-buffers|lobal-prettify-symbols-mode-cmhh|lobal-prettify-symbols-mode-enable-in-buffers|lobal-prettify-symbols-mode|lobal-reveal-mode|lobal-semantic-decoration-mode|lobal-semantic-highlight-edits-mode|lobal-semantic-highlight-func-mode|lobal-semantic-idle-completions-mode|lobal-semantic-idle-local-symbol-highlight-mode|lobal-semantic-idle-scheduler-mode|lobal-semantic-idle-summary-mode|lobal-semantic-mru-bookmark-mode|lobal-semantic-show-parser-state-mode|lobal-semantic-show-unmatched-syntax-mode|lobal-semantic-stickyfunc-mode|lobal-semanticdb-minor-mode|lobal-set-scheme-interaction-buffer|lobal-srecode-minor-mode|lobal-subword-mode|lobal-superword-mode|lobal-visual-line-mode-check-buffers|lobal-visual-line-mode-cmhh|lobal-visual-line-mode-enable-in-buffers|lobal-visual-line-mode|lobal-whitespace-mode|lobal-whitespace-newline-mode|lobal-whitespace-toggle-options|lyphless-set-char-table-range|mm-called-interactively-p|mm-customize-mode|mm-error|mm-format-time-string|mm-image-load-path-for-library|mm-image-search-load-path|mm-labels|mm-message|mm-regexp-concat|mm-tool-bar-from-list|mm-widget-p|mm-write-region|nus--random-face-with-type|nus-1|nus-Folder-save-name|nus-active|nus-add-buffer|nus-add-configuration|nus-add-shutdown|nus-add-text-properties-when|nus-add-text-properties|nus-add-to-sorted-list|nus-agent-batch-fetch|nus-agent-batch|nus-agent-delete-group|nus-agent-fetch-session|nus-agent-find-parameter|nus-agent-get-function|nus-agent-get-undownloaded-list|nus-agent-group-covered-p|nus-agent-method-p|nus-agent-possibly-alter-active|nus-agent-possibly-save-gcc|nus-agent-regenerate|nus-agent-rename-group|nus-agent-request-article|nus-agent-retrieve-headers|nus-agent-save-active|nus-agent-save-group-info|nus-agent-store-article|nus-agentize|nus-alist-pull|nus-alive-p|nus-and|nus-annotation-in-region-p|nus-apply-kill-file-internal|nus-apply-kill-file|nus-archive-server-wanted-p|nus-article-date-lapsed|nus-article-date-local|nus-article-date-original|nus-article-de-base64-unreadable|nus-article-de-quoted-unreadable|nus-article-decode-HZ|nus-article-decode-encoded-words|nus-article-delete-invisible-text|nus-article-display-x-face|nus-article-edit-article|nus-article-edit-done|nus-article-edit-mode|nus-article-fill-cited-article|nus-article-fill-cited-long-lines|nus-article-hide-boring-headers|nus-article-hide-citation-in-followups|nus-article-hide-citation-maybe|nus-article-hide-citation|nus-article-hide-headers|nus-article-hide-pem|nus-article-hide-signature|nus-article-highlight-citation|nus-article-html|nus-article-mail|nus-article-mode|nus-article-next-page|nus-article-outlook-deuglify-article|nus-article-outlook-repair-attribution|nus-article-outlook-unwrap-lines|nus-article-prepare-display|nus-article-prepare|nus-article-prev-page|nus-article-read-summary-keys|nus-article-remove-cr|nus-article-remove-trailing-blank-lines|nus-article-save|nus-article-set-window-start|nus-article-setup-buffer|nus-article-strip-leading-blank-lines|nus-article-treat-overstrike|nus-article-unsplit-urls|nus-article-wash-html|nus-assq-delete-all|nus-async-halt-prefetch|nus-async-prefetch-article|nus-async-prefetch-next|nus-async-prefetch-remove-group|nus-async-request-fetched-article|nus-atomic-progn-assign|nus-atomic-progn|nus-atomic-setq|nus-backlog-enter-article|nus-backlog-remove-article|nus-backlog-request-article|nus-batch-kill|nus-batch-score|nus-binary-mode|nus-bind-print-variables|nus-blocked-images|nus-bookmark-bmenu-list|nus-bookmark-jump|nus-bookmark-set|nus-bound-and-true-p|nus-boundp|nus-browse-foreign-server|nus-buffer-exists-p|nus-buffer-live-p|nus-buffers|nus-bug|nus-button-mailto|nus-button-reply|nus-byte-compile|nus-cache-articles-in-group|nus-cache-close|nus-cache-delete-group|nus-cache-enter-article|nus-cache-enter-remove-article|nus-cache-file-contents|nus-cache-generate-active|nus-cache-generate-nov-databases|nus-cache-open|nus-cache-possibly-alter-active|nus-cache-possibly-enter-article|nus-cache-possibly-remove-articles|nus-cache-remove-article|nus-cache-rename-group|nus-cache-request-article|nus-cache-retrieve-headers|nus-cache-save-buffers|nus-cache-update-article|nus-cached-article-p|nus-character-to-event|nus-check-backend-function|nus-check-reasonable-setup|nus-completing-read|nus-configure-windows|nus-continuum-version|nus-convert-article-to-rmail|nus-convert-face-to-png|nus-convert-gray-x-face-to-xpm|nus-convert-image-to-gray-x-face|nus-convert-png-to-face|nus-copy-article-buffer|nus-copy-file|nus-copy-overlay|nus-copy-sequence|nus-create-hash-size|nus-create-image|nus-create-info-command|nus-current-score-file-nondirectory|nus-data-find|nus-data-header|nus-date-get-time|nus-date-iso8601|nus-dd-mmm|nus-deactivate-mark|nus-declare-backend|nus-decode-newsgroups|nus-define-group-parameter|nus-define-keymap|nus-define-keys-1|nus-define-keys-safe|nus-define-keys|nus-delay-article|nus-delay-initialize|nus-delay-send-queue|nus-delete-alist|nus-delete-directory|nus-delete-duplicates|nus-delete-file|nus-delete-first|nus-delete-gnus-frame|nus-delete-line|nus-delete-overlay|nus-demon-add-disconnection|nus-demon-add-handler|nus-demon-add-rescan|nus-demon-add-scan-timestamps|nus-demon-add-scanmail|nus-demon-cancel|nus-demon-init|nus-demon-remove-handler|nus-display-x-face-in-from|nus-draft-mode|nus-draft-reminder|nus-dribble-enter|nus-dribble-touch|nus-dup-enter-articles|nus-dup-suppress-articles|nus-dup-unsuppress-article|nus-edit-form|nus-emacs-completing-read|nus-emacs-version|nus-ems-redefine|nus-enter-server-buffer|nus-ephemeral-group-p|nus-error|nus-eval-in-buffer-window|nus-execute|nus-expand-group-parameters??|nus-expunge|nus-extended-version|nus-extent-detached-p|nus-extent-start-open|nus-extract-address-components|nus-extract-references|nus-face-from-file|nus-faces-at|nus-fetch-field|nus-fetch-group-other-frame|nus-fetch-group|nus-fetch-original-field|nus-file-newer-than|nus-final-warning|nus-find-method-for-group|nus-find-subscribed-addresses|nus-find-text-property-region|nus-float-time|nus-folder-save-name|nus-frame-or-window-display-name|nus-generate-new-group-name|nus-get-buffer-create|nus-get-buffer-window|nus-get-display-table|nus-get-info|nus-get-text-property-excluding-characters-with-faces|nus-getenv-nntpserver|nus-gethash-safe|nus-gethash|nus-globalify-regexp|nus-goto-char|nus-goto-colon|nus-graphic-display-p|nus-grep-in-list|nus-group-add-parameter|nus-group-add-score|nus-group-auto-expirable-p|nus-group-customize|nus-group-decoded-name|nus-group-entry|nus-group-fast-parameter|nus-group-find-parameter|nus-group-first-unread-group|nus-group-foreign-p|nus-group-full-name|nus-group-get-new-news|nus-group-get-parameter|nus-group-group-name|nus-group-guess-full-name-from-command-method|nus-group-insert-group-line|nus-group-iterate|nus-group-list-groups|nus-group-mail|nus-group-make-help-group|nus-group-method|nus-group-name-charset|nus-group-name-decode|nus-group-name-to-method|nus-group-native-p|nus-group-news|nus-group-parameter-value|nus-group-position-point|nus-group-post-news|nus-group-prefixed-name|nus-group-prefixed-p|nus-group-quit-config|nus-group-quit|nus-group-read-only-p|nus-group-real-name|nus-group-real-prefix|nus-group-remove-parameter|nus-group-save-newsrc|nus-group-secondary-p|nus-group-send-queue|nus-group-server|nus-group-set-info|nus-group-set-mode-line|nus-group-set-parameter|nus-group-setup-buffer|nus-group-short-name|nus-group-split-fancy|nus-group-split-setup|nus-group-split-update|nus-group-split|nus-group-startup-message|nus-group-total-expirable-p|nus-group-unread|nus-group-update-group|nus-groups-from-server|nus-header-from|nus-highlight-selected-tree|nus-horizontal-recenter|nus-html-prefetch-images|nus-ido-completing-read|nus-image-type-available-p|nus-indent-rigidly|nus-info-find-node|nus-info-group|nus-info-level|nus-info-marks|nus-info-method|nus-info-params|nus-info-rank|nus-info-read|nus-info-score|nus-info-set-entry|nus-info-set-group|nus-info-set-level|nus-info-set-marks|nus-info-set-method|nus-info-set-params|nus-info-set-rank|nus-info-set-read|nus-info-set-score|nus-insert-random-face-header|nus-insert-random-x-face-header|nus-interactive|nus-intern-safe|nus-intersection|nus-invisible-p|nus-iswitchb-completing-read|nus-jog-cache|nus-key-press-event-p|nus-kill-all-overlays)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(?:gnus-kill-buffer|gnus-kill-ephemeral-group|gnus-kill-file-edit-file|gnus-kill-file-raise-followups-to-author|gnus-kill-save-kill-buffer|gnus-kill|gnus-list-debbugs|gnus-list-memq-of-list|gnus-list-of-read-articles|gnus-list-of-unread-articles|gnus-local-set-keys|gnus-mail-strip-quoted-names|gnus-mailing-list-insinuate|gnus-mailing-list-mode|gnus-make-directory|gnus-make-hashtable|gnus-make-local-hook|gnus-make-overlay|gnus-make-predicate-1|gnus-make-predicate|gnus-make-sort-function-1|gnus-make-sort-function|gnus-make-thread-indent-array|gnus-map-function|gnus-mapcar|gnus-mark-active-p|gnus-match-substitute-replacement|gnus-max-width-function|gnus-member-of-valid|gnus-merge|gnus-message-with-timestamp|gnus-message|gnus-method-ephemeral-p|gnus-method-equal|gnus-method-option-p|gnus-method-simplify|gnus-method-to-full-server-name|gnus-method-to-server-name|gnus-method-to-server|gnus-methods-equal-p|gnus-methods-sloppily-equal|gnus-methods-using|gnus-mime-view-all-parts|gnus-mode-line-buffer-identification|gnus-mode-string-quote|gnus-move-overlay|gnus-msg-mail|gnus-mule-max-width-function|gnus-multiple-choice|gnus-narrow-to-body|gnus-narrow-to-page|gnus-native-method-p|gnus-news-group-p|gnus-newsgroup-directory-form|gnus-newsgroup-kill-file|gnus-newsgroup-savable-name|gnus-newsrc-parse-options|gnus-next-char-property-change|gnus-no-server-1|gnus-no-server|gnus-not-ignore|gnus-notifications|gnus-offer-save-summaries|gnus-online|gnus-open-agent|gnus-open-server|gnus-or|gnus-other-frame|gnus-outlook-deuglify-article|gnus-output-to-mail|gnus-output-to-rmail|gnus-overlay-buffer|gnus-overlay-end|gnus-overlay-get|gnus-overlay-put|gnus-overlay-start|gnus-overlays-at|gnus-overlays-in|gnus-parameter-charset|gnus-parameter-ham-marks|gnus-parameter-ham-process-destination|gnus-parameter-ham-resend-to|gnus-parameter-large-newsgroup-initial|gnus-parameter-post-method|gnus-parameter-registry-ignore|gnus-parameter-spam-autodetect-methods|gnus-parameter-spam-autodetect|gnus-parameter-spam-contents|gnus-parameter-spam-marks|gnus-parameter-spam-process-destination|gnus-parameter-spam-process|gnus-parameter-spam-resend-to|gnus-parameter-subscribed|gnus-parameter-to-address|gnus-parameter-to-list|gnus-parameters-get-parameter|gnus-parent-id|gnus-parse-without-error|gnus-pick-mode|gnus-plugged|gnus-possibly-generate-tree|gnus-possibly-score-headers|gnus-post-news|gnus-pp-to-string|gnus-pp|gnus-previous-char-property-change|gnus-prin1-to-string|gnus-prin1|gnus-process-get|gnus-process-plist|gnus-process-put|gnus-put-display-table|gnus-put-image|gnus-put-overlay-excluding-newlines|gnus-put-text-property-excluding-characters-with-faces|gnus-put-text-property-excluding-newlines|gnus-put-text-property|gnus-random-face|gnus-random-x-face|gnus-range-add|gnus-read-event-char|gnus-read-group|gnus-read-init-file|gnus-read-method|gnus-read-shell-command|gnus-recursive-directory-files|gnus-redefine-select-method-widget|gnus-region-active-p|gnus-registry-handle-action|gnus-registry-initialize|gnus-registry-install-hooks|gnus-remassoc|gnus-remove-from-range|gnus-remove-if-not|gnus-remove-if|gnus-remove-image|gnus-remove-text-properties-when|gnus-remove-text-with-property|gnus-rename-file|gnus-replace-in-string|gnus-request-article-this-buffer|gnus-request-post|gnus-request-type|gnus-rescale-image|gnus-run-hook-with-args|gnus-run-hooks|gnus-run-mode-hooks|gnus-same-method-different-name|gnus-score-adaptive|gnus-score-advanced|gnus-score-close|gnus-score-customize|gnus-score-delta-default|gnus-score-file-name|gnus-score-find-trace|gnus-score-flush-cache|gnus-score-followup-article|gnus-score-followup-thread|gnus-score-headers|gnus-score-mode|gnus-score-save|gnus-secondary-method-p|gnus-seconds-month|gnus-seconds-today|gnus-seconds-year|gnus-select-frame-set-input-focus|gnus-select-lowest-window|gnus-server-add-address|gnus-server-equal|gnus-server-extend-method|gnus-server-get-method|gnus-server-server-name|gnus-server-set-info|gnus-server-status|gnus-server-string|gnus-server-to-method|gnus-servers-using-backend|gnus-set-active|gnus-set-file-modes|gnus-set-info|gnus-set-process-plist|gnus-set-process-query-on-exit-flag|gnus-set-sorted-intersection|gnus-set-window-start|gnus-set-work-buffer|gnus-sethash|gnus-short-group-name|gnus-shutdown|gnus-sieve-article-add-rule|gnus-sieve-generate|gnus-sieve-update|gnus-similar-server-opened|gnus-simplify-mode-line|gnus-slave-no-server|gnus-slave-unplugged|gnus-slave|gnus-sloppily-equal-method-parameters|gnus-sorted-complement|gnus-sorted-difference|gnus-sorted-intersection|gnus-sorted-ndifference|gnus-sorted-nintersection|gnus-sorted-nunion|gnus-sorted-range-intersection|gnus-sorted-union|gnus-splash-svg-color-symbols|gnus-splash|gnus-split-references|gnus-start-date-timer|gnus-stop-date-timer|gnus-string-equal|gnus-string-mark-left-to-right|gnus-string-match-p|gnus-string-or-1|gnus-string-or|gnus-string-prefix-p|gnus-string-remove-all-properties|gnus-string<|gnus-string>|gnus-strip-whitespace|gnus-subscribe-topics|gnus-summary-article-number|gnus-summary-bookmark-jump|gnus-summary-buffer-name|gnus-summary-cancel-article|gnus-summary-current-score|gnus-summary-exit|gnus-summary-followup-to-mail-with-original|gnus-summary-followup-to-mail|gnus-summary-followup-with-original|gnus-summary-followup|gnus-summary-increase-score|gnus-summary-insert-cached-articles|gnus-summary-insert-line|gnus-summary-last-subject|gnus-summary-line-format-spec|gnus-summary-lower-same-subject-and-select|gnus-summary-lower-same-subject|gnus-summary-lower-score|gnus-summary-lower-thread|gnus-summary-mail-forward|gnus-summary-mail-other-window|gnus-summary-news-other-window|gnus-summary-position-point|gnus-summary-post-forward|gnus-summary-post-news|gnus-summary-raise-same-subject-and-select|gnus-summary-raise-same-subject|gnus-summary-raise-score|gnus-summary-raise-thread|gnus-summary-read-group|gnus-summary-reply-with-original|gnus-summary-reply|gnus-summary-resend-bounced-mail|gnus-summary-resend-message|gnus-summary-save-article-folder|gnus-summary-save-article-vm|gnus-summary-save-in-folder|gnus-summary-save-in-vm|gnus-summary-score-map|gnus-summary-send-map|gnus-summary-set-agent-mark|gnus-summary-set-score|gnus-summary-skip-intangible|gnus-summary-supersede-article|gnus-summary-wide-reply-with-original|gnus-summary-wide-reply|gnus-suppress-keymap|gnus-symbolic-argument|gnus-sync-initialize|gnus-sync-install-hooks|gnus-time-iso8601|gnus-timer--function|gnus-tool-bar-update|gnus-topic-mode|gnus-topic-remove-group|gnus-topic-set-parameters|gnus-treat-article|gnus-treat-from-gravatar|gnus-treat-from-picon|gnus-treat-mail-gravatar|gnus-treat-mail-picon|gnus-treat-newsgroups-picon|gnus-tree-close|gnus-tree-open|gnus-try-warping-via-registry|gnus-turn-off-edit-menu|gnus-undo-mode|gnus-undo-register|gnus-union|gnus-unplugged|gnus-update-alist-soft|gnus-update-format|gnus-update-read-articles|gnus-url-unhex-string|gnus-url-unhex|gnus-use-long-file-name|gnus-user-format-function-D|gnus-user-format-function-d|gnus-uu-decode-binhex-view|gnus-uu-decode-binhex|gnus-uu-decode-save-view|gnus-uu-decode-save|gnus-uu-decode-unshar-and-save-view|gnus-uu-decode-unshar-and-save|gnus-uu-decode-unshar-view|gnus-uu-decode-unshar|gnus-uu-decode-uu-and-save-view|gnus-uu-decode-uu-and-save|gnus-uu-decode-uu-view|gnus-uu-decode-uu|gnus-uu-delete-work-dir|gnus-uu-digest-mail-forward|gnus-uu-digest-post-forward|gnus-uu-extract-map|gnus-uu-invert-processable|gnus-uu-mark-all|gnus-uu-mark-buffer|gnus-uu-mark-by-regexp|gnus-uu-mark-map|gnus-uu-mark-over|gnus-uu-mark-region|gnus-uu-mark-series|gnus-uu-mark-sparse|gnus-uu-mark-thread|gnus-uu-post-news|gnus-uu-unmark-thread|gnus-version|gnus-virtual-group-p|gnus-visual-p|gnus-window-edges|gnus-window-inside-pixel-edges|gnus-with-output-to-file|gnus-write-active-file|gnus-write-buffer|gnus-x-face-from-file|gnus-xmas-define|gnus-xmas-redefine|gnus-xmas-splash|gnus-y-or-n-p|gnus-yes-or-no-p|gnus|gnutls-available-p|gnutls-boot|gnutls-bye|gnutls-deinit|gnutls-error-fatalp|gnutls-error-string|gnutls-errorp|gnutls-get-initstage|gnutls-message-maybe|gnutls-negotiate|gnutls-peer-status-warning-describe|gnutls-peer-status|gomoku--intangible|gomoku-beginning-of-line|gomoku-check-filled-qtuple|gomoku-click|gomoku-crash-game|gomoku-cross-qtuple|gomoku-display-statistics|gomoku-emacs-plays|gomoku-end-of-line|gomoku-find-filled-qtuple|gomoku-goto-square|gomoku-goto-xy|gomoku-human-plays|gomoku-human-resigns|gomoku-human-takes-back|gomoku-index-to-x|gomoku-index-to-y|gomoku-init-board|gomoku-init-display|gomoku-init-score-table|gomoku-init-square-score|gomoku-max-height|gomoku-max-width|gomoku-mode|gomoku-mouse-play|gomoku-move-down|gomoku-move-ne|gomoku-move-nw|gomoku-move-se|gomoku-move-sw|gomoku-move-up|gomoku-nb-qtuples|gomoku-offer-a-draw|gomoku-play-move|gomoku-plot-square|gomoku-point-square|gomoku-point-y|gomoku-prompt-for-move|gomoku-prompt-for-other-game|gomoku-start-game|gomoku-strongest-square|gomoku-switch-to-window|gomoku-take-back|gomoku-terminate-game|gomoku-update-score-in-direction|gomoku-update-score-table|gomoku-xy-to-index|gomoku|goto-address-at-mouse|goto-address-at-point|goto-address-find-address-at-point|goto-address-fontify-region|goto-address-fontify|goto-address-mode|goto-address-prog-mode|goto-address-unfontify|goto-address|goto-history-element|goto-line|goto-next-locus|gpm-mouse-disable|gpm-mouse-enable|gpm-mouse-mode|gpm-mouse-start|gpm-mouse-stop|gravatar-retrieve-synchronously|gravatar-retrieve|grep-apply-setting|grep-compute-defaults|grep-default-command|grep-expand-template|grep-filter|grep-find|grep-mode|grep-probe|grep-process-setup|grep-read-files|grep-read-regexp|grep-tag-default|grep|gs-height-in-pt|gs-load-image|gs-options|gs-set-ghostview-colors-window-prop|gs-set-ghostview-window-prop|gs-width-in-pt|gud-backward-sexp|gud-basic-call|gud-call|gud-common-init|gud-dbx-marker-filter|gud-dbx-massage-args|gud-def|gud-dguxdbx-marker-filter|gud-display-frame|gud-display-line|gud-expansion-speedbar-buttons|gud-expr-compound-sep|gud-expr-compound|gud-file-name|gud-filter|gud-find-c-expr|gud-find-class|gud-find-expr|gud-find-file|gud-format-command|gud-forward-sexp|gud-gdb-completion-at-point|gud-gdb-completions-1|gud-gdb-completions|gud-gdb-fetch-lines-filter|gud-gdb-get-stackframe|gud-gdb-goto-stackframe|gud-gdb-marker-filter|gud-gdb-run-command-fetch-lines|gud-gdb|gud-gdbmi-completions|gud-gdbmi-fetch-lines-filter|gud-gdbmi-marker-filter|gud-goto-info|gud-guiler-marker-filter|gud-innermost-expr|gud-install-speedbar-variables|gud-irixdbx-marker-filter|gud-jdb-analyze-source|gud-jdb-build-class-source-alist-for-file|gud-jdb-build-class-source-alist|gud-jdb-build-source-files-list|gud-jdb-find-source-file|gud-jdb-find-source-using-classpath|gud-jdb-find-source|gud-jdb-marker-filter|gud-jdb-massage-args|gud-jdb-parse-classpath-string|gud-jdb-skip-block|gud-jdb-skip-character-literal|gud-jdb-skip-id-ish-thing|gud-jdb-skip-single-line-comment|gud-jdb-skip-string-literal|gud-jdb-skip-traditional-or-documentation-comment|gud-jdb-skip-whitespace-and-comments|gud-jdb-skip-whitespace|gud-kill-buffer-hook|gud-marker-filter|gud-mipsdbx-marker-filter|gud-mode|gud-next-expr|gud-pdb-marker-filter|gud-perldb-marker-filter|gud-perldb-massage-args|gud-prev-expr|gud-query-cmdline|gud-read-address|gud-refresh|gud-reset|gud-sdb-find-file|gud-sdb-marker-filter|gud-sentinel|gud-set-buffer|gud-speedbar-buttons|gud-speedbar-item-info|gud-stop-subjob|gud-symbol|gud-tool-bar-item-visible-no-fringe|gud-tooltip-activate-mouse-motions-if-enabled|gud-tooltip-activate-mouse-motions|gud-tooltip-change-major-mode|gud-tooltip-dereference|gud-tooltip-mode|gud-tooltip-mouse-motion|gud-tooltip-print-command|gud-tooltip-process-output|gud-tooltip-tips|gud-val|gud-watch|gud-xdb-marker-filter|gud-xdb-massage-args|gui--selection-value-internal|gui--valid-simple-selection-p|gui-call|gui-get-primary-selection|gui-get-selection|gui-method--name|gui-method-declare|gui-method-define|gui-method|gui-select-text|gui-selection-value|gui-set-selection|guiler|gv--defsetter|gv--defun-declaration|gv-deref|gv-get|gv-ref|hack-local-variables-apply|hack-local-variables-confirm|hack-local-variables-filter|hack-local-variables-prop-line|hack-one-local-variable--obsolete|hack-one-local-variable-constantp|hack-one-local-variable-eval-safep|hack-one-local-variable-quotep|hack-one-local-variable|handle-delete-frame|handle-focus-in|handle-focus-out|handle-save-session|handle-select-window|handwrite-10pt|handwrite-11pt|handwrite-12pt|handwrite-13pt|handwrite-insert-font|handwrite-insert-header|handwrite-insert-info|handwrite-insert-preamble|handwrite-set-pagenumber-off|handwrite-set-pagenumber-on|handwrite-set-pagenumber|handwrite|hangul-input-method-activate|hanoi-0|hanoi-goto-char|hanoi-insert-ring|hanoi-internal|hanoi-move-ring|hanoi-n|hanoi-pos-on-tower-p|hanoi-put-face|hanoi-ring-to-pos|hanoi-sit-for|hanoi-unix-64|hanoi-unix|hanoi|hash-table-keys|hash-table-values|hashcash-already-paid-p|hashcash-cancel-async|hashcash-check-payment|hashcash-generate-payment-async|hashcash-generate-payment|hashcash-insert-payment-async-2|hashcash-insert-payment-async|hashcash-insert-payment|hashcash-payment-required|hashcash-payment-to|hashcash-point-at-bol|hashcash-point-at-eol|hashcash-processes-running-p|hashcash-strip-quoted-names|hashcash-token-substring|hashcash-verify-payment|hashcash-version|hashcash-wait-async|hashcash-wait-or-cancel|he--all-buffers|he-buffer-member|he-capitalize-first|he-concat-directory-file-name|he-dabbrev-beg|he-dabbrev-kill-search|he-dabbrev-search|he-file-name-beg|he-init-string|he-kill-beg|he-line-beg|he-line-search-regexp|he-line-search|he-lisp-symbol-beg)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(?:he-list-beg|he-list-search|he-ordinary-case-p|he-reset-string|he-string-member|he-substitute-string|he-transfer-case|he-whole-kill-search|hebrew-font-get-precomposed|hebrew-shape-gstring|help--binding-locus|help--key-binding-keymap|help-C-file-name|help-add-fundoc-usage|help-at-pt-cancel-timer|help-at-pt-kbd-string|help-at-pt-maybe-display|help-at-pt-set-timer|help-at-pt-string|help-bookmark-jump|help-bookmark-make-record|help-button-action|help-describe-category-set|help-do-arg-highlight|help-do-xref|help-fns--autoloaded-p|help-fns--compiler-macro|help-fns--interactive-only|help-fns--key-bindings|help-fns--obsolete|help-fns--parent-mode|help-fns--signature|help-follow-mouse|help-follow-symbol|help-follow|help-for-help-internal-doc|help-for-help-internal|help-for-help|help-form-show|help-function-arglist|help-go-back|help-go-forward|help-highlight-arg|help-highlight-arguments|help-insert-string|help-insert-xref-button|help-key-description|help-make-usage|help-make-xrefs|help-mode-finish|help-mode-menu|help-mode-revert-buffer|help-mode-setup|help-mode|help-print-return-message|help-quit|help-split-fundoc|help-window-display-message|help-window-setup|help-with-tutorial-spec-language|help-with-tutorial|help-xref-button|help-xref-go-back|help-xref-go-forward|help-xref-interned|help-xref-on-pp|help|hexl-C-c-prefix|hexl-C-x-prefix|hexl-ESC-prefix|hexl-activate-ruler|hexl-address-to-marker|hexl-ascii-start-column|hexl-backward-char|hexl-backward-short|hexl-backward-word|hexl-beginning-of-1k-page|hexl-beginning-of-512b-page|hexl-beginning-of-buffer|hexl-beginning-of-line|hexl-char-after-point|hexl-current-address|hexl-end-of-1k-page|hexl-end-of-512b-page|hexl-end-of-buffer|hexl-end-of-line|hexl-find-file|hexl-follow-ascii-find|hexl-follow-ascii|hexl-follow-line|hexl-forward-char|hexl-forward-short|hexl-forward-word|hexl-goto-address|hexl-goto-hex-address|hexl-hex-char-to-integer|hexl-hex-string-to-integer|hexl-highlight-line-range|hexl-htoi|hexl-insert-char|hexl-insert-decimal-char|hexl-insert-hex-char|hexl-insert-hex-string|hexl-insert-multibyte-char|hexl-insert-octal-char|hexl-isearch-search-function|hexl-line-displen|hexl-maybe-dehexlify-buffer|hexl-menu|hexl-mode--minor-mode-p|hexl-mode--setq-local|hexl-mode-exit|hexl-mode-ruler|hexl-mode|hexl-next-line|hexl-oct-char-to-integer|hexl-octal-string-to-integer|hexl-options|hexl-previous-line|hexl-print-current-point-info|hexl-printable-character|hexl-quoted-insert|hexl-revert-buffer-function|hexl-rulerize|hexl-save-buffer|hexl-scroll-down|hexl-scroll-up|hexl-self-insert-command|hexlify-buffer|hfy-begin-span|hfy-bgcol|hfy-box-to-border-assoc|hfy-box-to-style|hfy-box|hfy-buffer|hfy-colour-vals|hfy-colour|hfy-combined-face-spec|hfy-compile-face-map|hfy-compile-stylesheet|hfy-copy-and-fontify-file|hfy-css-name|hfy-decor|hfy-default-footer|hfy-default-header|hfy-dirname|hfy-end-span|hfy-face-at|hfy-face-attr-for-class|hfy-face-or-def-to-name|hfy-face-resolve-face|hfy-face-to-css-default|hfy-face-to-style-i|hfy-face-to-style|hfy-fallback-colour-values|hfy-family|hfy-find-invisible-ranges|hfy-flatten-style|hfy-fontified-p|hfy-fontify-buffer|hfy-force-fontification|hfy-href-stub|hfy-href|hfy-html-dekludge-buffer|hfy-html-enkludge-buffer|hfy-html-quote|hfy-init-progn|hfy-initfile|hfy-interq|hfy-invisible-name|hfy-invisible|hfy-kludge-cperl-mode|hfy-link-style-string|hfy-link-style|hfy-list-files|hfy-load-tags-cache|hfy-lookup|hfy-make-directory|hfy-mark-tag-hrefs|hfy-mark-tag-names|hfy-mark-trailing-whitespace|hfy-merge-adjacent-spans|hfy-opt|hfy-overlay-props-at|hfy-parse-tags-buffer|hfy-prepare-index-i|hfy-prepare-index|hfy-prepare-tag-map|hfy-prop-invisible-p|hfy-relstub|hfy-save-buffer-state|hfy-save-initvar|hfy-save-kill-buffers|hfy-shell|hfy-size-to-int|hfy-size|hfy-slant|hfy-sprintf-stylesheet|hfy-subtract-maps|hfy-tags-for-file|hfy-text-p|hfy-triplet|hfy-unmark-trailing-whitespace|hfy-weight|hfy-which-etags|hfy-width|hfy-word-regex|hi-lock--hashcons|hi-lock--regexps-at-point|hi-lock-face-buffer|hi-lock-face-phrase-buffer|hi-lock-face-symbol-at-point|hi-lock-find-patterns|hi-lock-font-lock-hook|hi-lock-keyword->face|hi-lock-line-face-buffer|hi-lock-mode-set-explicitly|hi-lock-mode|hi-lock-process-phrase|hi-lock-read-face-name|hi-lock-regexp-okay|hi-lock-set-file-patterns|hi-lock-set-pattern|hi-lock-unface-buffer|hi-lock-unload-function|hi-lock-write-interactive-patterns|hide-body|hide-entry|hide-ifdef-block|hide-ifdef-define|hide-ifdef-guts|hide-ifdef-mode-menu|hide-ifdef-mode|hide-ifdef-region-internal|hide-ifdef-region|hide-ifdef-set-define-alist|hide-ifdef-toggle-outside-read-only|hide-ifdef-toggle-read-only|hide-ifdef-toggle-shadowing|hide-ifdef-undef|hide-ifdef-use-define-alist|hide-ifdefs|hide-leaves|hide-other|hide-region-body|hide-sublevels|hide-subtree|hif-add-new-defines|hif-after-revert-function|hif-and-expr|hif-and|hif-canonicalize-tokens|hif-canonicalize|hif-clear-all-ifdef-defined|hif-comma|hif-comp-expr|hif-compress-define-list|hif-conditional|hif-define-macro|hif-define-operator|hif-defined|hif-delimit|hif-divide|hif-end-of-line|hif-endif-to-ifdef|hif-eq-expr|hif-equal|hif-evaluate-macro|hif-evaluate-region|hif-expand-token-list|hif-expr|hif-exprlist|hif-factor|hif-find-any-ifX|hif-find-define|hif-find-ifdef-block|hif-find-next-relevant|hif-find-previous-relevant|hif-find-range|hif-flatten|hif-get-argument-list|hif-greater-equal|hif-greater|hif-hide-line|hif-if-valid-identifier-p|hif-ifdef-to-endif|hif-invoke|hif-less-equal|hif-less|hif-logand-expr|hif-logand|hif-logior-expr|hif-logior|hif-lognot|hif-logshift-expr|hif-logxor-expr|hif-logxor|hif-looking-at-elif|hif-looking-at-else|hif-looking-at-endif|hif-looking-at-ifX|hif-lookup|hif-macro-supply-arguments|hif-make-range|hif-math|hif-mathify-binop|hif-mathify|hif-merge-ifdef-region|hif-minus|hif-modulo|hif-muldiv-expr|hif-multiply|hif-nexttoken|hif-not|hif-notequal|hif-or-expr|hif-or|hif-parse-exp|hif-parse-macro-arglist|hif-place-macro-invocation|hif-plus|hif-possibly-hide|hif-range-elif|hif-range-else|hif-range-end|hif-range-start|hif-recurse-on|hif-set-var|hif-shiftleft|hif-shiftright|hif-show-all|hif-show-ifdef-region|hif-string-concatenation|hif-string-to-number|hif-stringify|hif-token-concat|hif-token-concatenation|hif-token-stringification|hif-tokenize|hif-undefine-symbol|highlight-changes-mode-set-explicitly|highlight-changes-mode-turn-on|highlight-changes-mode|highlight-changes-next-change|highlight-changes-previous-change|highlight-changes-remove-highlight|highlight-changes-rotate-faces|highlight-changes-visible-mode|highlight-compare-buffers|highlight-compare-with-file|highlight-lines-matching-regexp|highlight-markup-buffers|highlight-phrase|highlight-regexp|highlight-symbol-at-point|hilit-chg-bump-change|hilit-chg-clear|hilit-chg-cust-fix-changes-face-list|hilit-chg-desktop-restore|hilit-chg-display-changes|hilit-chg-fixup|hilit-chg-get-diff-info|hilit-chg-get-diff-list-hk|hilit-chg-hide-changes|hilit-chg-make-list|hilit-chg-make-ov|hilit-chg-map-changes|hilit-chg-set-face-on-change|hilit-chg-set|hilit-chg-unload-function|hilit-chg-update|hippie-expand|hl-line-highlight|hl-line-make-overlay|hl-line-mode|hl-line-move|hl-line-unhighlight|hl-line-unload-function|hmac-md5-96|hmac-md5|holiday-list|holidays|horizontal-scroll-bar-mode|horizontal-scroll-bars-available-p|how-many|hs-already-hidden-p|hs-c-like-adjust-block-beginning|hs-discard-overlays|hs-find-block-beginning|hs-forward-sexp|hs-grok-mode-type|hs-hide-all|hs-hide-block-at-point|hs-hide-block|hs-hide-comment-region|hs-hide-initial-comment-block|hs-hide-level-recursive|hs-hide-level|hs-inside-comment-p|hs-isearch-show-temporary|hs-isearch-show|hs-life-goes-on|hs-looking-at-block-start-p|hs-make-overlay|hs-minor-mode-menu|hs-minor-mode|hs-mouse-toggle-hiding|hs-overlay-at|hs-show-all|hs-show-block|hs-toggle-hiding|html-autoview-mode|html-checkboxes|html-current-defun-name|html-headline-1|html-headline-2|html-headline-3|html-headline-4|html-headline-5|html-headline-6|html-horizontal-rule|html-href-anchor|html-image|html-imenu-index|html-line|html-list-item|html-mode|html-name-anchor|html-ordered-list|html-paragraph|html-radio-buttons|html-unordered-list|html2text|htmlfontify-buffer|htmlfontify-copy-and-link-dir|htmlfontify-load-initfile|htmlfontify-load-rgb-file|htmlfontify-run-etags|htmlfontify-save-initfile|htmlfontify-string|htmlize-attrlist-to-fstruct|htmlize-buffer-1|htmlize-buffer-substring-no-invisible|htmlize-buffer|htmlize-color-to-rgb|htmlize-copy-attr-if-set|htmlize-css-insert-head|htmlize-css-insert-text|htmlize-css-specs|htmlize-defang-local-variables|htmlize-default-body-tag|htmlize-default-doctype|htmlize-despam-address|htmlize-ensure-fontified|htmlize-face-background|htmlize-face-color-internal|htmlize-face-emacs21-attr|htmlize-face-foreground|htmlize-face-list-p|htmlize-face-size|htmlize-face-specifies-property|htmlize-face-to-fstruct|htmlize-faces-at-point|htmlize-faces-in-buffer|htmlize-file|htmlize-font-body-tag|htmlize-font-insert-text|htmlize-fstruct-background--cmacro|htmlize-fstruct-background|htmlize-fstruct-boldp--cmacro|htmlize-fstruct-boldp|htmlize-fstruct-css-name--cmacro|htmlize-fstruct-css-name|htmlize-fstruct-foreground--cmacro|htmlize-fstruct-foreground|htmlize-fstruct-italicp--cmacro|htmlize-fstruct-italicp|htmlize-fstruct-overlinep--cmacro|htmlize-fstruct-overlinep|htmlize-fstruct-p--cmacro|htmlize-fstruct-p|htmlize-fstruct-size--cmacro|htmlize-fstruct-size|htmlize-fstruct-strikep--cmacro|htmlize-fstruct-strikep|htmlize-fstruct-underlinep--cmacro|htmlize-fstruct-underlinep|htmlize-get-color-rgb-hash|htmlize-inline-css-body-tag|htmlize-inline-css-insert-text|htmlize-locate-file|htmlize-make-face-map|htmlize-make-file-name|htmlize-make-hyperlinks|htmlize-many-files-dired|htmlize-many-files|htmlize-memoize|htmlize-merge-faces|htmlize-merge-size|htmlize-merge-two-faces|htmlize-method-function|htmlize-method|htmlize-next-change|htmlize-protect-string|htmlize-region-for-paste|htmlize-region|htmlize-trim-ellipsis|htmlize-unstringify-face|htmlize-untabify|htmlize-with-fontify-message|ibuffer-active-formats-name|ibuffer-add-saved-filters|ibuffer-add-to-tmp-hide|ibuffer-add-to-tmp-show|ibuffer-assert-ibuffer-mode|ibuffer-auto-mode|ibuffer-backward-filter-group|ibuffer-backward-line|ibuffer-backwards-next-marked|ibuffer-bs-show|ibuffer-buf-matches-predicates|ibuffer-buffer-file-name|ibuffer-buffer-name-face|ibuffer-buffer-names-with-mark|ibuffer-bury-buffer|ibuffer-check-formats|ibuffer-clear-filter-groups|ibuffer-clear-summary-columns|ibuffer-columnize-and-insert-list|ibuffer-compile-format|ibuffer-compile-make-eliding-form|ibuffer-compile-make-format-form|ibuffer-compile-make-substring-form|ibuffer-confirm-operation-on|ibuffer-copy-filename-as-kill|ibuffer-count-deletion-lines|ibuffer-count-marked-lines|ibuffer-current-buffer|ibuffer-current-buffers-with-marks|ibuffer-current-formats??|ibuffer-current-mark|ibuffer-current-state-list|ibuffer-customize|ibuffer-decompose-filter-group|ibuffer-decompose-filter|ibuffer-delete-saved-filter-groups|ibuffer-delete-saved-filters|ibuffer-deletion-marked-buffer-names|ibuffer-diff-with-file|ibuffer-do-delete|ibuffer-do-eval|ibuffer-do-isearch-regexp|ibuffer-do-isearch|ibuffer-do-kill-lines|ibuffer-do-kill-on-deletion-marks|ibuffer-do-occur|ibuffer-do-print|ibuffer-do-query-replace-regexp|ibuffer-do-query-replace|ibuffer-do-rename-uniquely|ibuffer-do-replace-regexp|ibuffer-do-revert|ibuffer-do-save|ibuffer-do-shell-command-file|ibuffer-do-shell-command-pipe-replace|ibuffer-do-shell-command-pipe|ibuffer-do-sort-by-alphabetic|ibuffer-do-sort-by-filename/process|ibuffer-do-sort-by-major-mode|ibuffer-do-sort-by-mode-name|ibuffer-do-sort-by-recency|ibuffer-do-sort-by-size|ibuffer-do-toggle-modified|ibuffer-do-toggle-read-only|ibuffer-do-view-1|ibuffer-do-view-and-eval|ibuffer-do-view-horizontally|ibuffer-do-view-other-frame|ibuffer-do-view|ibuffer-exchange-filters|ibuffer-expand-format-entry|ibuffer-filter-buffers|ibuffer-filter-by-content|ibuffer-filter-by-derived-mode|ibuffer-filter-by-filename|ibuffer-filter-by-mode|ibuffer-filter-by-name|ibuffer-filter-by-predicate|ibuffer-filter-by-size-gt|ibuffer-filter-by-size-lt|ibuffer-filter-by-used-mode|ibuffer-filter-disable|ibuffer-filters-to-filter-group|ibuffer-find-file)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)i(?:buffer-format-column|buffer-forward-filter-group|buffer-forward-line|buffer-forward-next-marked|buffer-get-marked-buffers|buffer-included-in-filters-p|buffer-insert-buffer-line|buffer-insert-filter-group|buffer-interactive-filter-by-mode|buffer-invert-sorting|buffer-jump-to-buffer|buffer-jump-to-filter-group|buffer-kill-filter-group|buffer-kill-line|buffer-list-buffers|buffer-make-column-filename-and-process|buffer-make-column-filename|buffer-make-column-process|buffer-map-deletion-lines|buffer-map-lines-nomodify|buffer-map-lines|buffer-map-marked-lines|buffer-map-on-mark|buffer-mark-by-file-name-regexp|buffer-mark-by-mode-regexp|buffer-mark-by-mode|buffer-mark-by-name-regexp|buffer-mark-compressed-file-buffers|buffer-mark-dired-buffers|buffer-mark-dissociated-buffers|buffer-mark-for-delete-backwards|buffer-mark-for-delete|buffer-mark-forward|buffer-mark-help-buffers|buffer-mark-interactive|buffer-mark-modified-buffers|buffer-mark-old-buffers|buffer-mark-read-only-buffers|buffer-mark-special-buffers|buffer-mark-unsaved-buffers|buffer-marked-buffer-names|buffer-mode|buffer-mouse-filter-by-mode|buffer-mouse-popup-menu|buffer-mouse-toggle-filter-group|buffer-mouse-toggle-mark|buffer-mouse-visit-buffer|buffer-negate-filter|buffer-or-filter|buffer-other-window|buffer-pop-filter-group|buffer-pop-filter|buffer-recompile-formats|buffer-redisplay-current|buffer-redisplay-engine|buffer-redisplay|buffer-save-filter-groups|buffer-save-filters|buffer-set-filter-groups-by-mode|buffer-set-mark-1|buffer-set-mark|buffer-shrink-to-fit|buffer-skip-properties|buffer-sort-bufferlist|buffer-switch-format|buffer-switch-to-saved-filter-groups|buffer-switch-to-saved-filters|buffer-toggle-filter-group|buffer-toggle-marks|buffer-toggle-sorting-mode|buffer-unmark-all|buffer-unmark-backward|buffer-unmark-forward|buffer-update-format|buffer-update-title-and-summary|buffer-update|buffer-visible-p|buffer-visit-buffer-1-window|buffer-visit-buffer-other-frame|buffer-visit-buffer-other-window-noselect|buffer-visit-buffer-other-window|buffer-visit-buffer|buffer-visit-tags-table|buffer-yank-filter-group|buffer-yank|buffer|calendar--add-decoded-times|calendar--add-diary-entry|calendar--all-events|calendar--convert-all-timezones|calendar--convert-anniversary-to-ical|calendar--convert-block-to-ical|calendar--convert-cyclic-to-ical|calendar--convert-date-to-ical|calendar--convert-float-to-ical|calendar--convert-ical-to-diary|calendar--convert-non-recurring-all-day-to-diary|calendar--convert-non-recurring-not-all-day-to-diary|calendar--convert-ordinary-to-ical|calendar--convert-recurring-to-diary|calendar--convert-sexp-to-ical|calendar--convert-string-for-export|calendar--convert-string-for-import|calendar--convert-to-ical|calendar--convert-tz-offset|calendar--convert-weekly-to-ical|calendar--convert-yearly-to-ical|calendar--create-ical-alarm|calendar--create-uid|calendar--date-to-isodate|calendar--datestring-to-isodate|calendar--datetime-to-american-date|calendar--datetime-to-colontime|calendar--datetime-to-diary-date|calendar--datetime-to-european-date|calendar--datetime-to-iso-date|calendar--datetime-to-noneuropean-date|calendar--decode-isodatetime|calendar--decode-isoduration|calendar--diarytime-to-isotime|calendar--dmsg|calendar--do-create-ical-alarm|calendar--find-time-zone|calendar--format-ical-event|calendar--get-children|calendar--get-event-properties|calendar--get-event-property-attributes|calendar--get-event-property|calendar--get-month-number|calendar--get-unfolded-buffer|calendar--get-weekday-abbrev|calendar--get-weekday-numbers??|calendar--parse-summary-and-rest|calendar--parse-vtimezone|calendar--read-element|calendar--rris|calendar--split-value|calendar-convert-diary-to-ical|calendar-export-file|calendar-export-region|calendar-extract-ical-from-buffer|calendar-first-weekday-of-year|calendar-import-buffer|calendar-import-file|calendar-import-format-sample|complete--completion-predicate|complete--completion-table|complete--field-beg|complete--field-end|complete--field-string|complete--in-region-setup|complete-backward-completions|complete-completions|complete-exhibit|complete-forward-completions|complete-minibuffer-setup|complete-mode|complete-post-command-hook|complete-pre-command-hook|complete-simple-completing-p|complete-tidy|con-backward-to-noncomment|con-backward-to-start-of-continued-exp|con-backward-to-start-of-if|con-comment-indent|con-forward-sexp-function|con-indent-command|con-indent-line|con-is-continuation-line|con-is-continued-line|con-mode|conify-or-deiconify-frame|dl-font-lock-keywords-2|dl-font-lock-keywords-3|dl-font-lock-keywords|dl-mode|dlwave-action-and-binding|dlwave-active-rinfo-space|dlwave-add-file-link-selector|dlwave-after-successful-completion|dlwave-all-assq|dlwave-all-class-inherits|dlwave-all-class-tags|dlwave-all-method-classes|dlwave-all-method-keyword-classes|dlwave-any-syslib|dlwave-attach-class-tag-classes|dlwave-attach-classes|dlwave-attach-keyword-classes|dlwave-attach-method-classes|dlwave-auto-fill-mode|dlwave-auto-fill|dlwave-backward-block|dlwave-backward-up-block|dlwave-beginning-of-block|dlwave-beginning-of-statement|dlwave-beginning-of-subprogram|dlwave-best-rinfo-assoc|dlwave-best-rinfo-assq|dlwave-block-jump-out|dlwave-block-master|dlwave-calc-hanging-indent|dlwave-calculate-cont-indent|dlwave-calculate-indent|dlwave-calculate-paren-indent|dlwave-call-special|dlwave-case|dlwave-check-abbrev|dlwave-choose-completion|dlwave-choose|dlwave-class-alist|dlwave-class-file-or-buffer|dlwave-class-found-in|dlwave-class-info|dlwave-class-inherits|dlwave-class-or-superclass-with-tag|dlwave-class-tag-reset|dlwave-class-tags|dlwave-close-block|dlwave-code-abbrev|dlwave-command-hook|dlwave-comment-hook|dlwave-complete-class-structure-tag-help|dlwave-complete-class-structure-tag|dlwave-complete-class|dlwave-complete-filename|dlwave-complete-in-buffer|dlwave-complete-sysvar-help|dlwave-complete-sysvar-or-tag|dlwave-complete-sysvar-tag-help|dlwave-complete|dlwave-completing-read|dlwave-completion-fontify-classes|dlwave-concatenate-rinfo-lists|dlwave-context-help|dlwave-convert-xml-clean-routine-aliases|dlwave-convert-xml-clean-statement-aliases|dlwave-convert-xml-clean-sysvar-aliases|dlwave-convert-xml-system-routine-info|dlwave-count-eq|dlwave-count-memq|dlwave-count-outlawed-buffers|dlwave-create-customize-menu|dlwave-create-user-catalog-file|dlwave-current-indent|dlwave-current-routine-fullname|dlwave-current-routine|dlwave-current-statement-indent|dlwave-custom-ampersand-surround|dlwave-custom-ltgtr-surround|dlwave-customize|dlwave-debug-map|dlwave-default-choose-completion|dlwave-default-insert-timestamp|dlwave-define-abbrev|dlwave-delete-user-catalog-file|dlwave-determine-class|dlwave-display-calling-sequence|dlwave-display-completion-list-emacs|dlwave-display-completion-list-xemacs|dlwave-display-completion-list|dlwave-display-user-catalog-widget|dlwave-do-action|dlwave-do-context-help1??|dlwave-do-find-module|dlwave-do-kill-autoloaded-buffers|dlwave-do-mouse-completion-help|dlwave-doc-header|dlwave-doc-modification|dlwave-down-block|dlwave-downcase-safe|dlwave-edit-in-idlde|dlwave-elif|dlwave-end-of-block|dlwave-end-of-statement0??|dlwave-end-of-subprogram|dlwave-entry-find-keyword|dlwave-entry-has-help|dlwave-entry-keywords|dlwave-expand-equal|dlwave-expand-keyword|dlwave-expand-lib-file-name|dlwave-expand-path|dlwave-expand-region-abbrevs|dlwave-explicit-class-listed|dlwave-fill-paragraph|dlwave-find-class-definition|dlwave-find-file-noselect|dlwave-find-inherited-class|dlwave-find-key|dlwave-find-module-this-file|dlwave-find-module|dlwave-find-struct-tag|dlwave-find-structure-definition|dlwave-fix-keywords|dlwave-fix-module-if-obj_new|dlwave-font-lock-fontify-region|dlwave-for|dlwave-forward-block|dlwave-function-menu|dlwave-function|dlwave-get-buffer-routine-info|dlwave-get-buffer-visiting|dlwave-get-routine-info-from-buffers|dlwave-goto-comment|dlwave-grep|dlwave-hard-tab|dlwave-has-help|dlwave-help-assistant-available|dlwave-help-assistant-close|dlwave-help-assistant-command|dlwave-help-assistant-help-with-topic|dlwave-help-assistant-open-link|dlwave-help-assistant-raise|dlwave-help-assistant-start|dlwave-help-check-locations|dlwave-help-diagnostics|dlwave-help-display-help-window|dlwave-help-error|dlwave-help-find-first-header|dlwave-help-find-header|dlwave-help-find-in-doc-header|dlwave-help-find-routine-definition|dlwave-help-fontify|dlwave-help-get-help-buffer|dlwave-help-get-special-help|dlwave-help-html-link|dlwave-help-menu|dlwave-help-mode|dlwave-help-quit|dlwave-help-return-to-calling-frame|dlwave-help-select-help-frame|dlwave-help-show-help-frame|dlwave-help-toggle-header-match-and-def|dlwave-help-toggle-header-top-and-def|dlwave-help-with-source|dlwave-highlight-linked-completions|dlwave-html-help-location|dlwave-if|dlwave-in-comment|dlwave-in-quote|dlwave-in-structure|dlwave-indent-and-action|dlwave-indent-left-margin|dlwave-indent-line|dlwave-indent-statement|dlwave-indent-subprogram|dlwave-indent-to|dlwave-info|dlwave-insert-source-location|dlwave-is-comment-line|dlwave-is-comment-or-empty-line|dlwave-is-continuation-line|dlwave-is-pointer-dereference|dlwave-keyboard-quit|dlwave-keyword-abbrev|dlwave-kill-autoloaded-buffers|dlwave-kill-buffer-update|dlwave-last-valid-char|dlwave-launch-idlhelp|dlwave-lib-p|dlwave-list-abbrevs|dlwave-list-all-load-path-shadows|dlwave-list-buffer-load-path-shadows|dlwave-list-load-path-shadows|dlwave-list-shell-load-path-shadows|dlwave-load-all-rinfo|dlwave-load-rinfo-next-step|dlwave-load-system-routine-info|dlwave-local-value|dlwave-locate-lib-file|dlwave-look-at|dlwave-make-force-complete-where-list|dlwave-make-full-name|dlwave-make-modified-completion-map-emacs|dlwave-make-modified-completion-map-xemacs|dlwave-make-one-key-alist|dlwave-make-space|dlwave-make-tags|dlwave-mark-block|dlwave-mark-doclib|dlwave-mark-statement|dlwave-mark-subprogram|dlwave-match-class-arrows|dlwave-members-only|dlwave-min-current-statement-indent|dlwave-mode-debug-menu|dlwave-mode-menu|dlwave-mode|dlwave-mouse-active-rinfo-right|dlwave-mouse-active-rinfo-shift|dlwave-mouse-active-rinfo|dlwave-mouse-choose-completion|dlwave-mouse-completion-help|dlwave-mouse-context-help|dlwave-new-buffer-update|dlwave-new-sintern-type|dlwave-newline|dlwave-next-statement|dlwave-nonmembers-only|dlwave-one-key-select|dlwave-online-help|dlwave-parse-definition|dlwave-path-alist-add-flag|dlwave-path-alist-remove-flag|dlwave-popup-select|dlwave-prepare-class-tag-completion|dlwave-prev-index-position|dlwave-previous-statement|dlwave-print-source|dlwave-procedure|dlwave-process-sysvars|dlwave-quit-help|dlwave-quoted|dlwave-read-paths|dlwave-recursive-directory-list|dlwave-region-active-p|dlwave-repeat|dlwave-replace-buffer-routine-info|dlwave-replace-string|dlwave-rescan-asynchronously|dlwave-rescan-catalog-directories|dlwave-reset-sintern-type|dlwave-reset-sintern|dlwave-resolve|dlwave-restore-wconf-after-completion|dlwave-revoke-license-to-kill|dlwave-rinfo-assoc|dlwave-rinfo-assq-any-class|dlwave-rinfo-assq|dlwave-rinfo-group-keywords|dlwave-rinfo-insert-keyword|dlwave-routine-entry-compare-twins|dlwave-routine-entry-compare|dlwave-routine-info|dlwave-routine-source-file|dlwave-routine-twin-compare|dlwave-routine-twins|dlwave-routines|dlwave-rw-case|dlwave-save-buffer-update|dlwave-save-routine-info|dlwave-scan-class-info|dlwave-scan-library-catalogs|dlwave-scan-user-lib-files|dlwave-scroll-completions|dlwave-selector|dlwave-set-local|dlwave-setup|dlwave-shell-break-here|dlwave-shell-compile-helper-routines|dlwave-shell-filter-sysvars|dlwave-shell-recenter-shell-window|dlwave-shell-run-region|dlwave-shell-save-and-run|dlwave-shell-send-command|dlwave-shell-show-commentary|dlwave-shell-update-routine-info|dlwave-shell|dlwave-shorten-syntax|dlwave-show-begin-check|dlwave-show-begin|dlwave-show-commentary|dlwave-show-matching-quote|dlwave-sintern-class-info|dlwave-sintern-class-tag|dlwave-sintern-class)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)i(?:dlwave-sintern-dir|dlwave-sintern-keyword-list|dlwave-sintern-keyword|dlwave-sintern-libname|dlwave-sintern-method|dlwave-sintern-rinfo-list|dlwave-sintern-routine-or-method|dlwave-sintern-routine|dlwave-sintern-set|dlwave-sintern-sysvar-alist|dlwave-sintern-sysvar|dlwave-sintern-sysvartag|dlwave-sintern|dlwave-skip-label-or-case|dlwave-skip-multi-commands|dlwave-skip-object|dlwave-special-lib-test|dlwave-split-line|dlwave-split-link-target|dlwave-split-menu-emacs|dlwave-split-menu-xemacs|dlwave-split-string|dlwave-start-load-rinfo-timer|dlwave-start-of-substatement|dlwave-statement-type|dlwave-struct-borders|dlwave-struct-inherits|dlwave-struct-tags|dlwave-study-twins|dlwave-substitute-link-target|dlwave-surround|dlwave-switch|dlwave-sys-dir|dlwave-syslib-p|dlwave-syslib-scanned-p|dlwave-sysvars-reset|dlwave-template|dlwave-this-word|dlwave-toggle-comment-region|dlwave-true-path-alist|dlwave-uniquify|dlwave-unit-name|dlwave-update-buffer-routine-info|dlwave-update-current-buffer-info|dlwave-update-routine-info|dlwave-user-catalog-command-hook|dlwave-what-function|dlwave-what-module-find-class|dlwave-what-module|dlwave-what-procedure|dlwave-where|dlwave-while|dlwave-widget-scan-user-lib-files|dlwave-with-special-syntax|dlwave-write-paths|dlwave-xml-create-class-method-lists|dlwave-xml-create-rinfo-list|dlwave-xml-create-sysvar-alist|dlwave-xml-system-routine-info-up-to-date|dlwave-xor|dna-to-ascii|do-active|do-add-virtual-buffers-to-list|do-all-completions|do-buffer-internal|do-buffer-window-other-frame|do-bury-buffer-at-head|do-cache-ftp-valid|do-cache-unc-valid|do-choose-completion-string|do-chop|do-common-initialization|do-complete-space|do-complete|do-completing-read|do-completion-help|do-completions|do-copy-current-file-name|do-copy-current-word|do-delete-backward-updir|do-delete-backward-word-updir|do-delete-file-at-head|do-directory-too-big-p|do-dired|do-display-buffer|do-display-file|do-edit-input|do-enter-dired|do-enter-find-file|do-enter-insert-buffer|do-enter-insert-file|do-enter-switch-buffer|do-everywhere|do-exhibit|do-existing-item-p|do-exit-minibuffer|do-expand-directory|do-fallback-command|do-file-extension-aux|do-file-extension-lessp|do-file-extension-order|do-file-internal|do-file-lessp|do-file-name-all-completions-1|do-file-name-all-completions|do-final-slash|do-find-alternate-file|do-find-common-substring|do-find-file-in-dir|do-find-file-other-frame|do-find-file-other-window|do-find-file-read-only-other-frame|do-find-file-read-only-other-window|do-find-file-read-only|do-find-file|do-flatten-merged-list|do-forget-work-directory|do-fractionp|do-get-buffers-in-frames|do-get-bufname|do-get-work-directory|do-get-work-file|do-ignore-item-p|do-init-completion-maps|do-initiate-auto-merge|do-insert-buffer|do-insert-file|do-is-ftp-directory|do-is-root-directory|do-is-slow-ftp-host|do-is-tramp-root|do-is-unc-host|do-is-unc-root|do-kill-buffer-at-head|do-kill-buffer|do-kill-emacs-hook|do-list-directory|do-load-history|do-local-file-exists-p|do-magic-backward-char|do-magic-delete-char|do-magic-forward-char|do-make-buffer-list-1|do-make-buffer-list|do-make-choice-list|do-make-dir-list-1|do-make-dir-list|do-make-directory|do-make-file-list-1|do-make-file-list|do-make-merged-file-list-1|do-make-merged-file-list|do-make-prompt|do-makealist|do-may-cache-directory|do-merge-work-directories|do-minibuffer-setup|do-mode|do-name|do-next-match-dir|do-next-match|do-next-work-directory|do-next-work-file|do-no-final-slash|do-nonreadable-directory-p|do-pop-dir|do-pp|do-prev-match-dir|do-prev-match|do-prev-work-directory|do-prev-work-file|do-push-dir-first|do-push-dir|do-read-buffer|do-read-directory-name|do-read-file-name|do-read-internal|do-record-command|do-record-work-directory|do-record-work-file|do-remove-cached-dir|do-reread-directory|do-restrict-to-matches|do-save-history|do-select-text|do-set-common-completion|do-set-current-directory|do-set-current-home|do-set-matches-1|do-set-matches|do-setup-completion-map|do-sort-merged-list|do-summary-buffers-to-end|do-switch-buffer-other-frame|do-switch-buffer-other-window|do-switch-buffer|do-take-first-match|do-tidy|do-time-stamp|do-to-end|do-toggle-case|do-toggle-ignore|do-toggle-literal|do-toggle-prefix|do-toggle-regexp|do-toggle-trace|do-toggle-vc|do-toggle-virtual-buffers|do-trace|do-unc-hosts-net-view|do-unc-hosts|do-undo-merge-work-directory|do-unload-function|do-up-directory|do-visit-buffer|do-wash-history|do-wide-find-dir-or-delete-dir|do-wide-find-dir|do-wide-find-dirs-or-files|do-wide-find-file-or-pop-dir|do-wide-find-file|do-word-matching-substring|do-write-file|elm|etf-drums-get-comment|etf-drums-init|etf-drums-make-address|etf-drums-narrow-to-header|etf-drums-parse-address|etf-drums-parse-addresses|etf-drums-parse-date|etf-drums-quote-string|etf-drums-remove-comments|etf-drums-remove-whitespace|etf-drums-strip|etf-drums-token-to-list|etf-drums-unfold-fws|f-let|fconfig|image-mode-buffer|image-mode|image-modification-hook|image-recenter|mage--set-speed|mage-after-revert-hook|mage-animate-get-speed|mage-animate-set-speed|mage-animate-timeout|mage-animated-p|mage-backward-hscroll|mage-bob|mage-bol|mage-bookmark-jump|mage-bookmark-make-record|mage-decrease-speed|mage-dired--with-db-file|mage-dired-add-to-file-comment-list|mage-dired-add-to-tag-file-lists??|mage-dired-associated-dired-buffer-window|mage-dired-associated-dired-buffer|mage-dired-backward-image|mage-dired-comment-thumbnail|mage-dired-copy-with-exif-file-name|mage-dired-create-display-image-buffer|mage-dired-create-gallery-lists|mage-dired-create-thumb|mage-dired-create-thumbnail-buffer|mage-dired-create-thumbs|mage-dired-define-display-image-mode-keymap|mage-dired-define-thumbnail-mode-keymap|mage-dired-delete-char|mage-dired-delete-tag|mage-dired-dir|mage-dired-dired-after-readin-hook|mage-dired-dired-comment-files|mage-dired-dired-display-external|mage-dired-dired-display-image|mage-dired-dired-display-properties|mage-dired-dired-edit-comment-and-tags|mage-dired-dired-file-marked-p|mage-dired-dired-next-line|mage-dired-dired-previous-line|mage-dired-dired-toggle-marked-thumbs|mage-dired-dired-with-window-configuration|mage-dired-display-current-image-full|mage-dired-display-current-image-sized|mage-dired-display-image-mode|mage-dired-display-image|mage-dired-display-next-thumbnail-original|mage-dired-display-previous-thumbnail-original|mage-dired-display-thumb-properties|mage-dired-display-thumb|mage-dired-display-thumbnail-original-image|mage-dired-display-thumbs-append|mage-dired-display-thumbs|mage-dired-display-window-height|mage-dired-display-window-width|mage-dired-display-window|mage-dired-flag-thumb-original-file|mage-dired-format-properties-string|mage-dired-forward-image|mage-dired-gallery-generate|mage-dired-get-buffer-window|mage-dired-get-comment|mage-dired-get-exif-data|mage-dired-get-exif-file-name|mage-dired-get-thumbnail-image|mage-dired-hidden-p|mage-dired-image-at-point-p|mage-dired-insert-image|mage-dired-insert-thumbnail|mage-dired-jump-original-dired-buffer|mage-dired-jump-thumbnail-buffer|mage-dired-kill-buffer-and-window|mage-dired-line-up-dynamic|mage-dired-line-up-interactive|mage-dired-line-up|mage-dired-list-tags|mage-dired-mark-and-display-next|mage-dired-mark-tagged-files|mage-dired-mark-thumb-original-file|mage-dired-modify-mark-on-thumb-original-file|mage-dired-mouse-display-image|mage-dired-mouse-select-thumbnail|mage-dired-mouse-toggle-mark|mage-dired-next-line-and-display|mage-dired-next-line|mage-dired-original-file-name|mage-dired-previous-line-and-display|mage-dired-previous-line|mage-dired-read-comment|mage-dired-refresh-thumb|mage-dired-remove-tag|mage-dired-restore-window-configuration|mage-dired-rotate-original-left|mage-dired-rotate-original-right|mage-dired-rotate-original|mage-dired-rotate-thumbnail-left|mage-dired-rotate-thumbnail-right|mage-dired-rotate-thumbnail|mage-dired-sane-db-file|mage-dired-save-information-from-widgets|mage-dired-set-exif-data|mage-dired-setup-dired-keybindings|mage-dired-show-all-from-dir|mage-dired-slideshow-start|mage-dired-slideshow-step|mage-dired-slideshow-stop|mage-dired-tag-files|mage-dired-tag-thumbnail-remove|mage-dired-tag-thumbnail|mage-dired-thumb-name|mage-dired-thumbnail-display-external|mage-dired-thumbnail-mode|mage-dired-thumbnail-set-image-description|mage-dired-thumbnail-window|mage-dired-toggle-append-browsing|mage-dired-toggle-dired-display-properties|mage-dired-toggle-mark-thumb-original-file|mage-dired-toggle-movement-tracking|mage-dired-track-original-file|mage-dired-track-thumbnail|mage-dired-unmark-thumb-original-file|mage-dired-update-property|mage-dired-window-height-pixels|mage-dired-window-width-pixels|mage-dired-write-comments|mage-dired-write-tags|mage-dired|mage-display-size|mage-eob|mage-eol|mage-extension-data|mage-file-call-underlying|mage-file-handler|mage-file-name-regexp|mage-file-yank-handler|mage-forward-hscroll|mage-get-display-property|mage-goto-frame|mage-increase-speed|mage-jpeg-p|mage-metadata|mage-minor-mode|mage-mode--images-in-directory|mage-mode-as-text|mage-mode-fit-frame|mage-mode-maybe|mage-mode-menu|mage-mode-reapply-winprops|mage-mode-setup-winprops|mage-mode-window-get|mage-mode-window-put|mage-mode-winprops|mage-mode|mage-next-file|mage-next-frame|mage-next-line|mage-previous-file|mage-previous-frame|mage-previous-line|mage-refresh|mage-reset-speed|mage-reverse-speed|mage-scroll-down|mage-scroll-up|mage-search-load-path|mage-set-window-hscroll|mage-set-window-vscroll|mage-toggle-animation|mage-toggle-display-image|mage-toggle-display-text|mage-toggle-display|mage-transform-check-size|mage-transform-fit-to-height|mage-transform-fit-to-width|mage-transform-fit-width|mage-transform-properties|mage-transform-reset|mage-transform-set-rotation|mage-transform-set-scale|mage-transform-width|mage-type-auto-detected-p|mage-type-from-buffer|mage-type-from-data|mage-type-from-file-header|mage-type-from-file-name|mage-type|magemagick-filter-types|magemagick-register-types|map-add-callback|map-anonymous-auth|map-anonymous-p|map-arrival-filter|map-authenticate|map-body-lines|map-capability|map-close|map-cram-md5-auth|map-cram-md5-p|map-current-mailbox-p-1|map-current-mailbox-p|map-current-mailbox|map-current-message|map-digest-md5-auth|map-digest-md5-p|map-disable-multibyte|map-envelope-from|map-error-text|map-fetch-asynch|map-fetch-safe|map-fetch|map-find-next-line|map-forward|map-gssapi-auth-p|map-gssapi-auth|map-gssapi-open|map-gssapi-stream-p|map-id|map-interactive-login|map-kerberos4-auth-p|map-kerberos4-auth|map-kerberos4-open|map-kerberos4-stream-p|map-list-to-message-set|map-log|map-login-auth|map-login-p|map-logout-wait|map-logout|map-mailbox-acl-delete|map-mailbox-acl-get|map-mailbox-acl-set|map-mailbox-close|map-mailbox-create-1|map-mailbox-create|map-mailbox-delete|map-mailbox-examine-1|map-mailbox-examine|map-mailbox-expunge|map-mailbox-get-1|map-mailbox-get|map-mailbox-list|map-mailbox-lsub|map-mailbox-map-1|map-mailbox-map|map-mailbox-put|map-mailbox-rename|map-mailbox-select-1|map-mailbox-select|map-mailbox-status-asynch|map-mailbox-status|map-mailbox-subscribe|map-mailbox-unselect|map-mailbox-unsubscribe|map-message-append|map-message-appenduid-1|map-message-appenduid|map-message-body|map-message-copy|map-message-copyuid-1|map-message-copyuid|map-message-envelope-bcc|map-message-envelope-cc|map-message-envelope-date|map-message-envelope-from|map-message-envelope-in-reply-to|map-message-envelope-message-id|map-message-envelope-reply-to|map-message-envelope-sender|map-message-envelope-subject|map-message-envelope-to|map-message-flag-permanent-p|map-message-flags-add|map-message-flags-del|map-message-flags-set|map-message-get|map-message-map|map-message-put|map-namespace|map-network-open|map-network-p|map-ok-p|map-open-1|map-open|map-opened|map-parse-acl|map-parse-address-list|map-parse-address|map-parse-astring|map-parse-body-ext)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)i(?:map-parse-body-extension|map-parse-body|map-parse-data-list|map-parse-envelope|map-parse-fetch-body-section|map-parse-fetch|map-parse-flag-list|map-parse-greeting|map-parse-header-list|map-parse-literal|map-parse-mailbox|map-parse-nil|map-parse-nstring|map-parse-number|map-parse-resp-text-code|map-parse-resp-text|map-parse-response|map-parse-status|map-parse-string-list|map-parse-string|map-ping-server|map-quote-specials|map-range-to-message-set|map-remassoc|map-sasl-auth-p|map-sasl-auth|map-sasl-make-mechanisms|map-search|map-send-command-1|map-send-command-wait|map-send-command|map-sentinel|map-shell-open|map-shell-p|map-ssl-open|map-ssl-p|map-starttls-open|map-starttls-p|map-string-to-integer|map-tls-open|map-tls-p|map-utf7-decode|map-utf7-encode|map-wait-for-tag|menu--cleanup|menu--completion-buffer|menu--create-keymap|menu--generic-function|menu--in-alist|menu--make-index-alist|menu--menubar-select|menu--mouse-menu|menu--relative-position|menu--sort-by-name|menu--sort-by-position|menu--split-menu|menu--split-submenus|menu--split|menu--subalist-p|menu--truncate-items|menu-add-menubar-index|menu-choose-buffer-index|menu-default-create-index-function|menu-default-goto-function|menu-example--create-c-index|menu-example--create-lisp-index|menu-example--lisp-extract-index-name|menu-example--name-and-position|menu-find-default|menu-progress-message|menu-update-menubar|menu|n-is13194-post-read-conversion|n-is13194-pre-write-conversion|n-string-p|nactivate-input-method|ncf|ncrease-left-margin|ncrease-right-margin|ncrement-register|ndent-accumulate-tab-stops|ndent-for-comment|ndent-icon-exp|ndent-line-to|ndent-new-comment-line|ndent-next-tab-stop|ndent-perl-exp|ndent-pp-sexp|ndent-rigidly--current-indentation|ndent-rigidly--pop-undo|ndent-rigidly-left-to-tab-stop|ndent-rigidly-left|ndent-rigidly-right-to-tab-stop|ndent-rigidly-right|ndent-sexp|ndent-tcl-exp|ndent-to-column|ndented-text-mode|ndian-2-column-to-ucs-region|ndian-compose-regexp|ndian-compose-region|ndian-compose-string|ndicate-copied-region|nferior-lisp-install-letter-bindings|nferior-lisp-menu|nferior-lisp-mode|nferior-lisp-proc|nferior-lisp|nferior-octave-check-process|nferior-octave-complete|nferior-octave-completion-at-point|nferior-octave-completion-table|nferior-octave-directory-tracker|nferior-octave-dynamic-list-input-ring|nferior-octave-mode|nferior-octave-output-digest|nferior-octave-process-live-p|nferior-octave-resync-dirs|nferior-octave-send-list-and-digest|nferior-octave-startup|nferior-octave-track-window-width-change|nferior-octave|nferior-python-mode|nferior-scheme-mode|nferior-tcl-mode|nferior-tcl-proc|nferior-tcl|nfo--manual-names|nfo--prettify-description|nfo-apropos|nfo-complete-file|nfo-complete-symbol|nfo-complete|nfo-display-manual|nfo-emacs-bug|nfo-emacs-manual|nfo-file-exists-p|nfo-finder|nfo-initialize|nfo-insert-file-contents-1|nfo-insert-file-contents|nfo-lookup->all-modes|nfo-lookup->cache|nfo-lookup->completions|nfo-lookup->doc-spec|nfo-lookup->ignore-case|nfo-lookup->initialized|nfo-lookup->mode-cache|nfo-lookup->mode-value|nfo-lookup->other-modes|nfo-lookup->parse-rule|nfo-lookup->refer-modes|nfo-lookup->regexp|nfo-lookup->topic-cache|nfo-lookup->topic-value|nfo-lookup-add-help\\\\*?|nfo-lookup-change-mode|nfo-lookup-completions-at-point|nfo-lookup-file|nfo-lookup-guess-c-symbol|nfo-lookup-guess-custom-symbol|nfo-lookup-guess-default\\\\*?|nfo-lookup-interactive-arguments|nfo-lookup-make-completions|nfo-lookup-maybe-add-help|nfo-lookup-quick-all-modes|nfo-lookup-reset|nfo-lookup-select-mode|nfo-lookup-setup-mode|nfo-lookup-symbol|nfo-lookup|nfo-other-window|nfo-setup|nfo-standalone|nfo-xref-all-info-files|nfo-xref-check-all-custom|nfo-xref-check-all|nfo-xref-check-buffer|nfo-xref-check-list|nfo-xref-check-node|nfo-xref-check|nfo-xref-docstrings|nfo-xref-goto-node-p|nfo-xref-lock-file-p|nfo-xref-output-error|nfo-xref-output|nfo-xref-subfile-p|nfo-xref-with-file|nfo-xref-with-output|nfo|nhibit-local-variables-p|nit-image-library|nitialize-completions|nitialize-instance|nitialize-new-tags-table|nline|nsert-abbrevs|nsert-byte|nsert-directory-adj-pos|nsert-directory-safely|nsert-file-1|nsert-file-literally|nsert-file|nsert-for-yank-1|nsert-image-file|nsert-kbd-macro|nsert-pair|nsert-parentheses|nsert-rectangle|nsert-string|nsert-tab|nt-to-string|nteractive-completion-string-reader|nteractive-p|ntern-safe|nternal--after-save-selected-window|nternal--after-with-selected-window|nternal--before-save-selected-window|nternal--before-with-selected-window|nternal--build-binding-value-form|nternal--build-bindings??|nternal--check-binding|nternal--listify|nternal--thread-argument|nternal--track-mouse|nternal-ange-ftp-mode|nternal-char-font|nternal-complete-buffer-except|nternal-complete-buffer|nternal-copy-lisp-face|nternal-default-process-filter|nternal-default-process-sentinel|nternal-describe-syntax-value|nternal-event-symbol-parse-modifiers|nternal-face-x-get-resource|nternal-get-lisp-face-attribute|nternal-lisp-face-attribute-values|nternal-lisp-face-empty-p|nternal-lisp-face-equal-p|nternal-lisp-face-p|nternal-macroexpand-for-load|nternal-make-lisp-face|nternal-make-var-non-special|nternal-merge-in-global-face|nternal-pop-keymap|nternal-push-keymap|nternal-set-alternative-font-family-alist|nternal-set-alternative-font-registry-alist|nternal-set-font-selection-order|nternal-set-lisp-face-attribute-from-resource|nternal-set-lisp-face-attribute|nternal-show-cursor-p|nternal-show-cursor|nternal-temp-output-buffer-show|nternal-timer-start-idle|ntersection|nverse-add-abbrev|nverse-add-global-abbrev|nverse-add-mode-abbrev|nversion-<|nversion-=|nversion-add-to-load-path|nversion-check-version|nversion-decode-version|nversion-download-package-ask|nversion-find-version|nversion-locate-package-files-and-split|nversion-locate-package-files|nversion-package-incompatibility-version|nversion-package-version|nversion-recode|nversion-release-to-number|nversion-require-emacs|nversion-require|nversion-reverse-test|nversion-test|pconfig|rc|sInNet|sPlainHostName|sResolvable|search--get-state|search--set-state|search--state-barrier--cmacro|search--state-barrier|search--state-case-fold-search--cmacro|search--state-case-fold-search|search--state-error--cmacro|search--state-error|search--state-forward--cmacro|search--state-forward|search--state-message--cmacro|search--state-message|search--state-other-end--cmacro|search--state-other-end|search--state-p--cmacro|search--state-p|search--state-point--cmacro|search--state-point|search--state-pop-fun--cmacro|search--state-pop-fun|search--state-string--cmacro|search--state-string|search--state-success--cmacro|search--state-success|search--state-word--cmacro|search--state-word|search--state-wrapped--cmacro|search--state-wrapped|search-abort|search-back-into-window|search-backslash|search-backward-regexp|search-backward|search-cancel|search-char-by-name|search-clean-overlays|search-close-unnecessary-overlays|search-complete-edit|search-complete1??|search-dehighlight|search-del-char|search-delete-char|search-describe-bindings|search-describe-key|search-describe-mode|search-done|search-edit-string|search-exit|search-fail-pos|search-fallback|search-filter-visible|search-forward-exit-minibuffer|search-forward-regexp|search-forward-symbol-at-point|search-forward-symbol|search-forward-word|search-forward|search-help-for-help-internal-doc|search-help-for-help-internal|search-help-for-help|search-highlight-regexp|search-highlight|search-intersects-p|search-lazy-highlight-cleanup|search-lazy-highlight-new-loop|search-lazy-highlight-search|search-lazy-highlight-update|search-message-prefix|search-message-suffix|search-message|search-mode-help|search-mode|search-mouse-2|search-no-upper-case-p|search-nonincremental-exit-minibuffer|search-occur|search-open-necessary-overlays|search-open-overlay-temporary|search-pop-state|search-post-command-hook|search-pre-command-hook|search-printing-char|search-process-search-char|search-process-search-multibyte-characters|search-process-search-string|search-push-state|search-query-replace-regexp|search-query-replace|search-quote-char|search-range-invisible|search-repeat-backward|search-repeat-forward|search-repeat|search-resume|search-reverse-exit-minibuffer|search-ring-adjust1??|search-ring-advance|search-ring-retreat|search-search-and-update|search-search-fun-default|search-search-fun|search-search-string|search-search|search-string-out-of-window|search-symbol-regexp|search-text-char-description|search-toggle-case-fold|search-toggle-input-method|search-toggle-invisible|search-toggle-lax-whitespace|search-toggle-regexp|search-toggle-specified-input-method|search-toggle-symbol|search-toggle-word|search-unread|search-update-ring|search-update|search-yank-char-in-minibuffer|search-yank-char|search-yank-internal|search-yank-kill|search-yank-line|search-yank-pop|search-yank-string|search-yank-word-or-char|search-yank-word|search-yank-x-selection|searchb-activate|searchb-follow-char|searchb-iswitchb|searchb-set-keybindings|searchb-stop|searchb|so-charset|so-cvt-define-menu|so-cvt-read-only|so-cvt-write-only|so-german|so-gtex2iso|so-iso2duden|so-iso2gtex|so-iso2sgml|so-iso2tex|so-sgml2iso|so-spanish|so-tex2iso|so-transl-ctl-x-8-map|spell-accept-buffer-local-defs|spell-accept-output|spell-add-per-file-word-list|spell-aspell-add-aliases|spell-aspell-find-dictionary|spell-begin-skip-region-regexp|spell-begin-skip-region|spell-begin-tex-skip-regexp|spell-buffer-local-dict|spell-buffer-local-parsing|spell-buffer-local-words|spell-buffer-with-debug|spell-buffer|spell-call-process-region|spell-call-process|spell-change-dictionary|spell-check-minver|spell-check-version|spell-command-loop|spell-comments-and-strings|spell-complete-word-interior-frag|spell-complete-word|spell-continue|spell-create-debug-buffer|spell-decode-string|spell-display-buffer|spell-filter|spell-find-aspell-dictionaries|spell-find-hunspell-dictionaries|spell-get-aspell-config-value|spell-get-casechars|spell-get-coding-system|spell-get-decoded-string|spell-get-extended-character-mode|spell-get-ispell-args|spell-get-line|spell-get-many-otherchars-p|spell-get-not-casechars|spell-get-otherchars|spell-get-word|spell-help|spell-highlight-spelling-error-generic|spell-highlight-spelling-error-overlay|spell-highlight-spelling-error-xemacs|spell-highlight-spelling-error|spell-horiz-scroll|spell-hunspell-fill-dictionary-entry|spell-ignore-fcc|spell-init-process|spell-int-char|spell-internal-change-dictionary|spell-kill-ispell|spell-looking-at|spell-looking-back|spell-lookup-words|spell-menu-map|spell-message|spell-mime-multipartp|spell-mime-skip-part|spell-minor-check|spell-minor-mode|spell-non-empty-string|spell-parse-hunspell-affix-file|spell-parse-output|spell-pdict-save|spell-print-if-debug|spell-process-line|spell-process-status|spell-region|spell-send-replacement|spell-send-string|spell-set-spellchecker-params|spell-show-choices|spell-skip-region-list|spell-skip-region|spell-start-process|spell-tex-arg-end|spell-valid-dictionary-list|spell-with-no-warnings|spell-word|spell|sqrt|switchb-buffer-other-frame|switchb-buffer-other-window|switchb-buffer|switchb-case|switchb-chop|switchb-complete|switchb-completion-help|switchb-completions|switchb-display-buffer|switchb-entryfn-p|switchb-exhibit|switchb-existing-buffer-p|switchb-exit-minibuffer|switchb-find-common-substring|switchb-find-file|switchb-get-buffers-in-frames|switchb-get-bufname|switchb-get-matched-buffers|switchb-ignore-buffername-p|switchb-init-XEmacs-trick|switchb-kill-buffer|switchb-make-buflist|switchb-makealist|switchb-minibuffer-setup|switchb-mode|switchb-next-match|switchb-output-completion|switchb-possible-new-buffer)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(?:iswitchb-post-command|iswitchb-pre-command|iswitchb-prev-match|iswitchb-read-buffer|iswitchb-rotate-list|iswitchb-select-buffer-text|iswitchb-set-common-completion|iswitchb-set-matches|iswitchb-summaries-to-end|iswitchb-tidy|iswitchb-to-end|iswitchb-toggle-case|iswitchb-toggle-ignore|iswitchb-toggle-regexp|iswitchb-visit-buffer|iswitchb-window-buffer-p|iswitchb-word-matching-substring|iswitchb-xemacs-backspacekey|iswitchb|iwconfig|japanese-hankaku-region|japanese-hankaku|japanese-hiragana-region|japanese-hiragana|japanese-katakana-region|japanese-katakana|japanese-zenkaku-region|japanese-zenkaku|java-font-lock-keywords-2|java-font-lock-keywords-3|java-font-lock-keywords|java-mode|javascript-mode|jdb|jit-lock--debug-fontify|jit-lock-after-change|jit-lock-context-fontify|jit-lock-debug-mode|jit-lock-deferred-fontify|jit-lock-fontify-now|jit-lock-force-redisplay|jit-lock-function|jit-lock-mode|jit-lock-refontify|jit-lock-stealth-chunk-start|jit-lock-stealth-fontify|jka-compr-build-file-regexp|jka-compr-byte-compiler-base-file-name|jka-compr-call-process|jka-compr-error|jka-compr-file-local-copy|jka-compr-get-compression-info|jka-compr-handler|jka-compr-info-can-append|jka-compr-info-compress-args|jka-compr-info-compress-message|jka-compr-info-compress-program|jka-compr-info-file-magic-bytes|jka-compr-info-regexp|jka-compr-info-strip-extension|jka-compr-info-uncompress-args|jka-compr-info-uncompress-message|jka-compr-info-uncompress-program|jka-compr-insert-file-contents|jka-compr-install|jka-compr-installed-p|jka-compr-load|jka-compr-make-temp-name|jka-compr-partial-uncompress|jka-compr-run-real-handler|jka-compr-set|jka-compr-uninstall|jka-compr-update|jka-compr-write-region|join-line|js--array-comp-indentation|js--backward-pstate|js--backward-syntactic-ws|js--backward-text-property|js--beginning-of-defun-flat|js--beginning-of-defun-nested|js--beginning-of-defun-raw|js--beginning-of-macro|js--class-decl-matcher|js--clear-stale-cache|js--continued-expression-p|js--ctrl-statement-indentation|js--debug|js--end-of-defun-flat|js--end-of-defun-nested|js--end-of-do-while-loop-p|js--ensure-cache--pop-if-ended|js--ensure-cache--update-parse|js--ensure-cache|js--flatten-list|js--flush-caches|js--forward-destructuring-spec|js--forward-expression|js--forward-function-decl|js--forward-pstate|js--forward-syntactic-ws|js--forward-text-property|js--function-prologue-beginning|js--get-all-known-symbols|js--get-c-offset|js--get-js-context|js--get-tabs|js--guess-eval-defun-info|js--guess-function-name|js--guess-symbol-at-point|js--imenu-create-index|js--imenu-to-flat|js--indent-in-array-comp|js--inside-dojo-class-list-p|js--inside-param-list-p|js--inside-pitem-p|js--js-add-resource-alias|js--js-content-window|js--js-create-instance|js--js-decode-retval|js--js-encode-value|js--js-enter-repl|js--js-eval|js--js-funcall|js--js-get-service|js--js-get|js--js-handle-expired-p|js--js-handle-id--cmacro|js--js-handle-id|js--js-handle-p--cmacro|js--js-handle-p|js--js-handle-process--cmacro|js--js-handle-process|js--js-leave-repl|js--js-list|js--js-new|js--js-not|js--js-put|js--js-qi|js--js-true|js--js-wait-for-eval-prompt|js--looking-at-operator-p|js--make-framework-matcher|js--make-merged-item|js--make-nsilocalfile|js--maybe-join|js--maybe-make-marker|js--multi-line-declaration-indentation|js--optimize-arglist|js--parse-state-at-point|js--pitem-add-child|js--pitem-b-end--cmacro|js--pitem-b-end|js--pitem-children--cmacro|js--pitem-children|js--pitem-format|js--pitem-goto-h-end|js--pitem-h-begin--cmacro|js--pitem-h-begin|js--pitem-name--cmacro|js--pitem-name|js--pitem-paren-depth--cmacro|js--pitem-paren-depth|js--pitem-strname|js--pitem-type--cmacro|js--pitem-type|js--pitems-to-imenu|js--proper-indentation|js--pstate-is-toplevel-defun|js--re-search-backward-inner|js--re-search-backward|js--re-search-forward-inner|js--re-search-forward|js--read-symbol|js--read-tab|js--regexp-opt-symbol|js--same-line|js--show-cache-at-point|js--splice-into-items|js--split-name|js--syntactic-context-from-pstate|js--syntax-begin-function|js--up-nearby-list|js--update-quick-match-re|js--variable-decl-matcher|js--wait-for-matching-output|js--which-func-joiner|js-beginning-of-defun|js-c-fill-paragraph|js-end-of-defun|js-eval-defun|js-eval|js-find-symbol|js-gc|js-indent-line|js-mode|js-set-js-context|js-syntactic-context|js-syntax-propertize-regexp|js-syntax-propertize|json--with-indentation|json-add-to-object|json-advance|json-alist-p|json-decode-char0|json-encode-alist|json-encode-array|json-encode-char0??|json-encode-hash-table|json-encode-key|json-encode-keyword|json-encode-list|json-encode-number|json-encode-plist|json-encode-string|json-encode|json-join|json-new-object|json-peek|json-plist-p|json-pop|json-pretty-print-buffer|json-pretty-print|json-read-array|json-read-escaped-char|json-read-file|json-read-from-string|json-read-keyword|json-read-number|json-read-object|json-read-string|json-read|json-skip-whitespace|jump-to-register|kbd-macro-query|keep-lines-read-args|keep-lines|kermit-clean-filter|kermit-clean-off|kermit-clean-on|kermit-default-cr|kermit-default-nl|kermit-esc|kermit-send-char|kermit-send-input-cr|keyboard-escape-quit|keymap--menu-item-binding|keymap--menu-item-with-binding|keymap--merge-bindings|keymap-canonicalize|keypad-setup|kill-all-abbrevs|kill-backward-chars|kill-backward-up-list|kill-buffer-and-window|kill-buffer-ask|kill-buffer-if-not-modified|kill-comment|kill-compilation|kill-completion|kill-emacs-save-completions|kill-find|kill-forward-chars|kill-grep|kill-line|kill-matching-buffers|kill-paragraph|kill-rectangle|kill-ring-save|kill-sentence|kill-sexp|kill-some-buffers|kill-this-buffer-enabled-p|kill-this-buffer|kill-visual-line|kill-whole-line|kill-word|kinsoku-longer|kinsoku-shorter|kinsoku|kkc-region|kmacro-add-counter|kmacro-bind-to-key|kmacro-call-macro|kmacro-call-ring-2nd-repeat|kmacro-call-ring-2nd|kmacro-cycle-ring-next|kmacro-cycle-ring-previous|kmacro-delete-ring-head|kmacro-display-counter|kmacro-display|kmacro-edit-lossage|kmacro-edit-macro-repeat|kmacro-edit-macro|kmacro-end-and-call-macro|kmacro-end-call-mouse|kmacro-end-macro|kmacro-end-or-call-macro-repeat|kmacro-end-or-call-macro|kmacro-exec-ring-item|kmacro-execute-from-register|kmacro-extract-lambda|kmacro-get-repeat-prefix|kmacro-insert-counter|kmacro-keyboard-quit|kmacro-lambda-form|kmacro-loop-setup-function|kmacro-name-last-macro|kmacro-pop-ring1??|kmacro-push-ring|kmacro-repeat-on-last-key|kmacro-ring-empty-p|kmacro-ring-head|kmacro-set-counter|kmacro-set-format|kmacro-split-ring-element|kmacro-start-macro-or-insert-counter|kmacro-start-macro|kmacro-step-edit-insert|kmacro-step-edit-macro|kmacro-step-edit-minibuf-setup|kmacro-step-edit-post-command|kmacro-step-edit-pre-command|kmacro-step-edit-prompt|kmacro-step-edit-query|kmacro-swap-ring|kmacro-to-register|kmacro-view-macro-repeat|kmacro-view-macro|kmacro-view-ring-2nd|lambda|landmark--distance|landmark--intangible|landmark-amble-robot|landmark-beginning-of-line|landmark-blackbox|landmark-calc-confidences|landmark-calc-current-smells|landmark-calc-distance-of-robot-from|landmark-calc-payoff|landmark-calc-smell-internal|landmark-check-filled-qtuple|landmark-click|landmark-confidence-for|landmark-crash-game|landmark-cross-qtuple|landmark-display-statistics|landmark-emacs-plays|landmark-end-of-line|landmark-f|landmark-find-filled-qtuple|landmark-fix-weights-for|landmark-flip-a-coin|landmark-goto-square|landmark-goto-xy|landmark-human-plays|landmark-human-resigns|landmark-human-takes-back|landmark-index-to-x|landmark-index-to-y|landmark-init-board|landmark-init-display|landmark-init-score-table|landmark-init-square-score|landmark-init|landmark-max-height|landmark-max-width|landmark-mode|landmark-mouse-play|landmark-move-down|landmark-move-ne|landmark-move-nw|landmark-move-se|landmark-move-sw|landmark-move-up|landmark-move|landmark-nb-qtuples|landmark-noise|landmark-nslify-wts-int|landmark-nslify-wts|landmark-offer-a-draw|landmark-play-move|landmark-plot-internal|landmark-plot-landmarks|landmark-plot-square|landmark-point-square|landmark-point-y|landmark-print-distance-int|landmark-print-distance|landmark-print-moves|landmark-print-smell-int|landmark-print-smell|landmark-print-w0-int|landmark-print-w0|landmark-print-wts-blackbox|landmark-print-wts-int|landmark-print-wts|landmark-print-y-s-noise-int|landmark-print-y-s-noise|landmark-prompt-for-move|landmark-prompt-for-other-game|landmark-random-move|landmark-randomize-weights-for|landmark-repeat|landmark-set-landmark-signal-strengths|landmark-start-game|landmark-start-robot|landmark-store-old-y_t|landmark-strongest-square|landmark-switch-to-window|landmark-take-back|landmark-terminate-game|landmark-test-run|landmark-update-naught-weights|landmark-update-normal-weights|landmark-update-score-in-direction|landmark-update-score-table|landmark-weights-debug|landmark-xy-to-index|landmark-y|landmark|lao-compose-region|lao-compose-string|lao-composition-function|lao-transcribe-roman-to-lao-string|lao-transcribe-single-roman-syllable-to-lao|last-nonminibuffer-frame|last-sexp-setup-props|latex-backward-sexp-1|latex-close-block|latex-complete-bibtex-keys|latex-complete-data|latex-complete-envnames|latex-complete-refkeys|latex-down-list|latex-electric-env-pair-mode|latex-env-before-change|latex-fill-nobreak-predicate|latex-find-indent|latex-forward-sexp-1|latex-forward-sexp|latex-imenu-create-index|latex-indent|latex-insert-block|latex-insert-item|latex-mode|latex-outline-level|latex-skip-close-parens|latex-split-block|latex-string-prefix-p|latex-syntax-after|latexenc-coding-system-to-inputenc|latexenc-find-file-coding-system|latexenc-inputenc-to-coding-system|latin1-display|lazy-highlight-cleanup|lcm|ld-script-mode|ldap-decode-address|ldap-decode-attribute|ldap-decode-boolean|ldap-decode-string|ldap-encode-address|ldap-encode-boolean|ldap-encode-country-string|ldap-encode-string|ldap-get-host-parameter|ldap-search-internal|ldap-search|ldiff|led-flash|led-off|led-on|led-update|left-char|left-word|let-alist--access-sexp|let-alist--deep-dot-search|let-alist--list-to-sexp|let-alist--remove-dot|let-alist|letf\\\\*?|letrec|lglyph-adjustment|lglyph-ascent|lglyph-char|lglyph-code|lglyph-copy|lglyph-descent|lglyph-from|lglyph-lbearing|lglyph-rbearing|lglyph-set-adjustment|lglyph-set-char|lglyph-set-code|lglyph-set-from-to|lglyph-set-width|lglyph-to|lglyph-width|lgrep|lgstring-char-len|lgstring-char|lgstring-font|lgstring-glyph-len|lgstring-glyph|lgstring-header|lgstring-insert-glyph|lgstring-set-glyph|lgstring-set-header|lgstring-set-id|lgstring-shaped-p|life-birth-char|life-birth-string|life-compute-neighbor-deltas|life-death-char|life-death-string|life-display-generation|life-expand-plane-if-needed|life-extinct-quit|life-grim-reaper|life-increment-generation|life-increment|life-insert-random-pattern|life-life-char|life-life-string|life-mode|life-not-void-regexp|life-setup|life-void-char|life-void-string|life|limit-index|line-move-1|line-move-finish|line-move-partial|line-move-to-column|line-move-visual|line-move|line-number-mode|line-pixel-height|line-substring-with-bidi-context|linum--face-width|linum-after-change|linum-after-scroll|linum-delete-overlays|linum-mode-set-explicitly|linum-mode|linum-on|linum-schedule|linum-unload-function|linum-update-current|linum-update-window|linum-update|lisp--match-hidden-arg|lisp-comment-indent|lisp-compile-defun-and-go|lisp-compile-defun|lisp-compile-file|lisp-compile-region-and-go|lisp-compile-region|lisp-compile-string|lisp-complete-symbol|lisp-completion-at-point|lisp-current-defun-name|lisp-describe-sym|lisp-do-defun|lisp-eval-defun-and-go|lisp-eval-defun|lisp-eval-form-and-next|lisp-eval-last-sexp|lisp-eval-paragraph|lisp-eval-region-and-go|lisp-eval-region|lisp-eval-string|lisp-fill-paragraph|lisp-find-tag-default|lisp-fn-called-at-pt|lisp-font-lock-syntactic-face-function|lisp-get-old-input|lisp-indent-defform|lisp-indent-function|lisp-indent-line|lisp-indent-specform|lisp-input-filter|lisp-interaction-mode|lisp-load-file|lisp-mode-auto-fill|lisp-mode-variables|lisp-mode|lisp-outline-level|lisp-show-arglist|lisp-show-function-documentation|lisp-show-variable-documentation|lisp-string-after-doc-keyword-p|lisp-string-in-doc-position-p)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(?:lisp-symprompt|lisp-var-at-pt|list\\\\*|list-abbrevs|list-all-completions-1|list-all-completions-by-hash-bucket-1|list-all-completions-by-hash-bucket|list-all-completions|list-at-point|list-bookmarks|list-buffers--refresh|list-buffers-noselect|list-buffers|list-character-sets|list-coding-categories|list-coding-systems|list-colors-display|list-colors-duplicates|list-colors-print|list-colors-redisplay|list-colors-sort-key|list-command-history|list-directory|list-dynamic-libraries|list-faces-display|list-fontsets|list-holidays|list-input-methods|list-length|list-matching-lines|list-packages|list-processes--refresh|list-registers|list-tags|lm-adapted-by|lm-authors|lm-code-mark|lm-code-start|lm-commentary-end|lm-commentary-mark|lm-commentary-start|lm-commentary|lm-copyright-mark|lm-crack-address|lm-crack-copyright|lm-creation-date|lm-get-header-re|lm-get-package-name|lm-header-multiline|lm-header|lm-history-mark|lm-history-start|lm-homepage|lm-insert-at-column|lm-keywords-finder-p|lm-keywords-list|lm-keywords|lm-last-modified-date|lm-maintainer|lm-report-bug|lm-section-end|lm-section-mark|lm-section-start|lm-summary|lm-synopsis|lm-verify|lm-version|lm-with-file|load-completions-from-file|load-history-filename-element|load-history-regexp|load-path-shadows-find|load-path-shadows-mode|load-path-shadows-same-file-or-nonexistent|load-save-place-alist-from-file|load-time-value|load-with-code-conversion|local-clear-scheme-interaction-buffer|local-set-scheme-interaction-buffer|locale-charset-match-p|locale-charset-to-coding-system|locale-name-match|locale-translate|locally|locate-completion-db-error|locate-completion-entry-retry|locate-completion-entry|locate-current-line-number|locate-default-make-command-line|locate-do-redisplay|locate-do-setup|locate-dominating-file|locate-file-completion-table|locate-file-completion|locate-file-internal|locate-filter-output|locate-find-directory-other-window|locate-find-directory|locate-get-dirname|locate-get-file-positions|locate-get-filename|locate-in-alternate-database|locate-insert-header|locate-main-listing-line-p|locate-mode|locate-mouse-view-file|locate-prompt-for-search-string|locate-set-properties|locate-tags|locate-update|locate-with-filter|locate-word-at-point|locate|log-edit--match-first-line|log-edit-add-field|log-edit-add-to-changelog|log-edit-beginning-of-line|log-edit-changelog-entries|log-edit-changelog-entry|log-edit-changelog-insert-entries|log-edit-changelog-ours-p|log-edit-changelog-paragraph|log-edit-changelog-subparagraph|log-edit-comment-search-backward|log-edit-comment-search-forward|log-edit-comment-to-change-log|log-edit-done|log-edit-empty-buffer-p|log-edit-extract-headers|log-edit-files|log-edit-font-lock-keywords|log-edit-goto-eoh|log-edit-hide-buf|log-edit-insert-changelog-entries|log-edit-insert-changelog|log-edit-insert-cvs-rcstemplate|log-edit-insert-cvs-template|log-edit-insert-filenames-without-changelog|log-edit-insert-filenames|log-edit-insert-message-template|log-edit-kill-buffer|log-edit-match-to-eoh|log-edit-menu|log-edit-mode-help|log-edit-mode|log-edit-narrow-changelog|log-edit-new-comment-index|log-edit-next-comment|log-edit-previous-comment|log-edit-remember-comment|log-edit-set-common-indentation|log-edit-set-header|log-edit-show-diff|log-edit-show-files|log-edit-toggle-header|log-edit|log-view-annotate-version|log-view-beginning-of-defun|log-view-current-entry|log-view-current-file|log-view-current-tag|log-view-diff-changeset|log-view-diff-common|log-view-diff|log-view-end-of-defun-1|log-view-end-of-defun|log-view-extract-comment|log-view-file-next|log-view-file-prev|log-view-find-revision|log-view-get-marked|log-view-goto-rev|log-view-inside-comment-p|log-view-minor-wrap|log-view-mode-menu|log-view-mode|log-view-modify-change-comment|log-view-msg-next|log-view-msg-prev|log-view-toggle-entry-display|log-view-toggle-mark-entry|log10|lookfor-dired|lookup-image-map|lookup-key-ignore-too-long|lookup-minor-mode-from-indicator|lookup-nested-alist|lookup-words|loop|lpr-buffer|lpr-customize|lpr-eval-switch|lpr-flatten-list-1|lpr-flatten-list|lpr-print-region|lpr-region|lpr-setup|lunar-phases|m2-begin-comment|m2-begin|m2-case|m2-compile|m2-definition|m2-else|m2-end-comment|m2-execute-monitor-command|m2-export|m2-for|m2-header|m2-if|m2-import|m2-link|m2-loop|m2-mode|m2-module|m2-or|m2-procedure|m2-record|m2-smie-backward-token|m2-smie-forward-token|m2-smie-refine-colon|m2-smie-refine-of|m2-smie-refine-semi|m2-smie-rules|m2-stdio|m2-toggle|m2-type|m2-until|m2-var|m2-visit|m2-while|m2-with|m4--quoted-p|m4-current-defun-name|m4-m4-buffer|m4-m4-region|m4-mode|macro-declaration-function|macroexp--accumulate|macroexp--all-clauses|macroexp--all-forms|macroexp--backtrace|macroexp--compiler-macro|macroexp--compiling-p|macroexp--cons|macroexp--const-symbol-p|macroexp--expand-all|macroexp--funcall-if-compiled|macroexp--maxsize|macroexp--obsolete-warning|macroexp--trim-backtrace-frame|macroexp--warn-and-return|macroexp-const-p|macroexp-copyable-p|macroexp-if|macroexp-let\\\\*|macroexp-let2\\\\*?|macroexp-progn|macroexp-quote|macroexp-small-p|macroexp-unprogn|macroexpand-1|macrolet|mail-abbrev-complete-alias|mail-abbrev-end-of-buffer|mail-abbrev-expand-hook|mail-abbrev-expand-wrapper|mail-abbrev-in-expansion-header-p|mail-abbrev-insert-alias|mail-abbrev-make-syntax-table|mail-abbrev-next-line|mail-abbrevs-disable|mail-abbrevs-enable|mail-abbrevs-mode|mail-abbrevs-setup|mail-abbrevs-sync-aliases|mail-add-attachment|mail-add-payment-async|mail-add-payment|mail-attach-file|mail-bcc|mail-bury|mail-cc|mail-check-payment|mail-comma-list-regexp|mail-complete|mail-completion-at-point-function|mail-completion-expand|mail-content-type-get|mail-decode-encoded-address-region|mail-decode-encoded-address-string|mail-decode-encoded-word-region|mail-decode-encoded-word-string|mail-directory-process|mail-directory-stream|mail-directory|mail-do-fcc|mail-dont-reply-to|mail-dont-send|mail-encode-encoded-word-buffer|mail-encode-encoded-word-region|mail-encode-encoded-word-string|mail-encode-header|mail-envelope-from|mail-extract-address-components|mail-fcc|mail-fetch-field|mail-file-babyl-p|mail-fill-yanked-message|mail-get-names|mail-header-chars|mail-header-date|mail-header-encode-parameter|mail-header-end|mail-header-extra|mail-header-extract-no-properties|mail-header-extract|mail-header-field-value|mail-header-fold-field|mail-header-format|mail-header-from|mail-header-get-comment|mail-header-id|mail-header-lines|mail-header-make-address|mail-header-merge|mail-header-message-id|mail-header-narrow-to-field|mail-header-number|mail-header-parse-address|mail-header-parse-addresses|mail-header-parse-content-disposition|mail-header-parse-content-type|mail-header-parse-date|mail-header-parse|mail-header-references|mail-header-remove-comments|mail-header-remove-whitespace|mail-header-set-chars|mail-header-set-date|mail-header-set-extra|mail-header-set-from|mail-header-set-id|mail-header-set-lines|mail-header-set-message-id|mail-header-set-number|mail-header-set-references|mail-header-set-subject|mail-header-set-xref|mail-header-set|mail-header-strip|mail-header-subject|mail-header-unfold-field|mail-header-xref|mail-header|mail-hist-define-keys|mail-hist-enable|mail-hist-put-headers-into-history|mail-indent-citation|mail-insert-file|mail-insert-from-field|mail-mail-followup-to|mail-mail-reply-to|mail-mbox-from|mail-mode-auto-fill|mail-mode-fill-paragraph|mail-mode-flyspell-verify|mail-mode|mail-narrow-to-head|mail-other-frame|mail-other-window|mail-parse-comma-list|mail-position-on-field|mail-quote-printable-region|mail-quote-printable|mail-quote-string|mail-recover-1|mail-recover|mail-reply-to|mail-resolve-all-aliases-1|mail-resolve-all-aliases|mail-rfc822-date|mail-rfc822-time-zone|mail-send-and-exit|mail-send|mail-sendmail-delimit-header|mail-sendmail-undelimit-header|mail-sent-via|mail-sentto-newsgroups|mail-setup|mail-signature|mail-split-line|mail-string-delete|mail-strip-quoted-names|mail-subject|mail-text-start|mail-text|mail-to|mail-unquote-printable-hexdigit|mail-unquote-printable-region|mail-unquote-printable|mail-yank-clear-headers|mail-yank-original|mail-yank-region|mail|mailcap-add-mailcap-entry|mailcap-add|mailcap-command-p|mailcap-delete-duplicates|mailcap-extension-to-mime|mailcap-file-default-commands|mailcap-mailcap-entry-passes-test|mailcap-maybe-eval|mailcap-mime-info|mailcap-mime-types|mailcap-parse-mailcap-extras|mailcap-parse-mailcaps??|mailcap-parse-mimetype-file|mailcap-parse-mimetypes|mailcap-possible-viewers|mailcap-replace-in-string|mailcap-replace-regexp|mailcap-save-binary-file|mailcap-unescape-mime-test|mailcap-view-mime|mailcap-viewer-lessp|mailcap-viewer-passes-test|mailclient-encode-string-as-url|mailclient-gather-addresses|mailclient-send-it|mailclient-url-delim|mairix-build-search-list|mairix-call-mairix|mairix-edit-saved-searches-customize|mairix-edit-saved-searches|mairix-gnus-ephemeral-nndoc|mairix-gnus-fetch-field|mairix-insert-search-line|mairix-next-search|mairix-previous-search|mairix-replace-invalid-chars|mairix-rmail-display|mairix-rmail-fetch-field|mairix-save-search|mairix-search-from-this-article|mairix-search-thread-this-article|mairix-search|mairix-searches-mode|mairix-select-delete|mairix-select-edit|mairix-select-quit|mairix-select-save|mairix-select-search|mairix-sentinel-mairix-update-finished|mairix-show-folder|mairix-update-database|mairix-use-saved-search|mairix-vm-display|mairix-vm-fetch-field|mairix-widget-add|mairix-widget-build-editable-fields|mairix-widget-create-query|mairix-widget-get-values|mairix-widget-make-query-from-widgets|mairix-widget-save-search|mairix-widget-search-based-on-article|mairix-widget-search|mairix-widget-send-query|mairix-widget-toggle-activate|make-backup-file-name--default-function|make-backup-file-name-1|make-char-internal|make-char|make-cmpl-prefix-entry|make-coding-system|make-comint-in-buffer|make-comint|make-command-summary|make-completion|make-directory-internal|make-doctor-variables|make-ebrowse-bs--cmacro|make-ebrowse-bs|make-ebrowse-cs--cmacro|make-ebrowse-cs|make-ebrowse-hs--cmacro|make-ebrowse-hs|make-ebrowse-ms--cmacro|make-ebrowse-ms|make-ebrowse-position--cmacro|make-ebrowse-position|make-ebrowse-ts--cmacro|make-ebrowse-ts|make-empty-face|make-erc-channel-user--cmacro|make-erc-channel-user|make-erc-response--cmacro|make-erc-response|make-erc-server-user--cmacro|make-erc-server-user|make-ert--ewoc-entry--cmacro|make-ert--ewoc-entry|make-ert--stats--cmacro|make-ert--stats|make-ert--test-execution-info--cmacro|make-ert--test-execution-info|make-ert-test--cmacro|make-ert-test-aborted-with-non-local-exit--cmacro|make-ert-test-aborted-with-non-local-exit|make-ert-test-failed--cmacro|make-ert-test-failed|make-ert-test-passed--cmacro|make-ert-test-passed|make-ert-test-quit--cmacro|make-ert-test-quit|make-ert-test-result--cmacro|make-ert-test-result-with-condition--cmacro|make-ert-test-result-with-condition|make-ert-test-result|make-ert-test-skipped--cmacro|make-ert-test-skipped|make-ert-test|make-face-bold-italic|make-face-bold|make-face-italic|make-face-unbold|make-face-unitalic|make-face-x-resource-internal|make-face|make-flyspell-overlay|make-frame-command|make-frame-names-alist|make-full-mail-header|make-gdb-handler--cmacro|make-gdb-handler|make-gdb-table--cmacro|make-gdb-table|make-hippie-expand-function|make-htmlize-fstruct--cmacro|make-htmlize-fstruct|make-initial-minibuffer-frame|make-instance|make-js--js-handle--cmacro|make-js--js-handle|make-js--pitem--cmacro|make-js--pitem|make-mail-header|make-mode-line-mouse-map|make-obsolete-overload|make-package--ac-desc--cmacro|make-package--ac-desc|make-package--bi-desc--cmacro|make-package--bi-desc|make-random-state|make-ses--locprn--cmacro|make-ses--locprn|make-sgml-tag--cmacro|make-sgml-tag|make-soap-array-type--cmacro|make-soap-array-type|make-soap-basic-type--cmacro|make-soap-basic-type|make-soap-binding--cmacro|make-soap-binding|make-soap-bound-operation--cmacro|make-soap-bound-operation|make-soap-element--cmacro|make-soap-element|make-soap-message--cmacro|make-soap-message|make-soap-namespace--cmacro|make-soap-namespace-link--cmacro|make-soap-namespace-link|make-soap-namespace|make-soap-operation--cmacro|make-soap-operation|make-soap-port--cmacro|make-soap-port-type--cmacro|make-soap-port-type)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)m(?:ake-soap-port|ake-soap-sequence-element--cmacro|ake-soap-sequence-element|ake-soap-sequence-type--cmacro|ake-soap-sequence-type|ake-soap-simple-type--cmacro|ake-soap-simple-type|ake-soap-wsdl--cmacro|ake-soap-wsdl|ake-tar-header--cmacro|ake-tar-header|ake-term|ake-terminal-frame|ake-url-queue--cmacro|ake-url-queue|ake-variable-frame-local|akefile-add-log-defun|akefile-append-backslash|akefile-automake-mode|akefile-backslash-region|akefile-browse|akefile-browser-fill|akefile-browser-format-macro-line|akefile-browser-format-target-line|akefile-browser-get-state-for-line|akefile-browser-insert-continuation|akefile-browser-insert-selection-and-quit|akefile-browser-insert-selection|akefile-browser-next-line|akefile-browser-on-macro-line-p|akefile-browser-previous-line|akefile-browser-quit|akefile-browser-send-this-line-item|akefile-browser-set-state-for-line|akefile-browser-start-interaction|akefile-browser-this-line-macro-name|akefile-browser-this-line-target-name|akefile-browser-toggle-state-for-line|akefile-browser-toggle|akefile-bsdmake-mode|akefile-cleanup-continuations|akefile-complete|akefile-completions-at-point|akefile-create-up-to-date-overview|akefile-delete-backslash|akefile-do-macro-insertion|akefile-electric-colon|akefile-electric-dot|akefile-electric-equal|akefile-fill-paragraph|akefile-first-line-p|akefile-format-macro-ref|akefile-forward-after-target-colon|akefile-generate-temporary-filename|akefile-gmake-mode|akefile-imake-mode|akefile-insert-gmake-function|akefile-insert-macro-ref|akefile-insert-macro|akefile-insert-special-target|akefile-insert-target-ref|akefile-insert-target|akefile-last-line-p|akefile-make-font-lock-keywords|akefile-makepp-mode|akefile-match-action|akefile-match-dependency|akefile-match-function-end|akefile-mode|akefile-next-dependency|akefile-pickup-everything|akefile-pickup-filenames-as-targets|akefile-pickup-macros|akefile-pickup-targets|akefile-previous-dependency|akefile-prompt-for-gmake-funargs|akefile-query-by-make-minus-q|akefile-query-targets|akefile-remember-macro|akefile-remember-target|akefile-save-temporary|akefile-switch-to-browser|akefile-warn-continuations|akefile-warn-suspicious-lines|akeinfo-buffer|akeinfo-compilation-sentinel-buffer|akeinfo-compilation-sentinel-region|akeinfo-compile|akeinfo-current-node|akeinfo-next-error|akeinfo-recenter-compilation-buffer|akeinfo-region|an-follow|an|antemp-insert-cxx-syntax|antemp-make-mantemps-buffer|antemp-make-mantemps-region|antemp-make-mantemps|antemp-remove-comments|antemp-remove-memfuncs|antemp-sort-and-unique-lines|anual-entry|ap-keymap-internal|ap-keymap-sorted|ap-query-replace-regexp|ap|apcan|apcar\\\\*|apcon|apl|aplist|ark-bib|ark-defun|ark-end-of-sentence|ark-icon-function|ark-page|ark-paragraph|ark-perl-function|ark-sexp|ark-whole-buffer|ark-word|aster-mode|aster-says-beginning-of-buffer|aster-says-end-of-buffer|aster-says-recenter|aster-says-scroll-down|aster-says-scroll-up|aster-says|aster-set-slave|aster-show-slave|atching-paren|ath-add-bignum|ath-add-float|ath-add|ath-bignum-big|ath-bignum|ath-build-parse-table|ath-check-complete|ath-comp-concat|ath-concat|ath-constp|ath-div-bignum-big|ath-div-bignum-digit|ath-div-bignum-part|ath-div-bignum-try|ath-div-bignum|ath-div-float|ath-div|ath-div10-bignum|ath-div2-bignum|ath-div2|ath-do-working|ath-evenp|ath-expr-ops|ath-find-user-tokens|ath-fixnatnump|ath-fixnump|ath-floatp??|ath-floor|ath-format-bignum-decimal|ath-format-bignum|ath-format-flat-expr|ath-format-number|ath-format-stack-value|ath-format-value|ath-idivmod|ath-imod|ath-infinitep|ath-ipow|ath-looks-negp|ath-make-float|ath-match-substring|ath-mod|ath-mul-bignum-digit|ath-mul-bignum|ath-mul|ath-negp??|ath-normalize|ath-numdigs|ath-posp|ath-pow|ath-quotient|ath-read-bignum|ath-read-expr-list|ath-read-exprs|ath-read-if|ath-read-number-simple|ath-read-number|ath-read-preprocess-string|ath-read-radix-digit|ath-read-token|ath-reject-arg|ath-remove-dashes|ath-scale-int|ath-scale-left-bignum|ath-scale-left|ath-scale-right-bignum|ath-scale-right|ath-scale-rounding|ath-showing-full-precision|ath-stack-value-offset|ath-standard-ops-p|ath-standard-ops|ath-sub-bignum|ath-sub-float|ath-sub|ath-trunc|ath-with-extra-prec|ath-working|ath-zerop|d4-64|d4-F|d4-G|d4-H|d4-add|d4-and|d4-copy64|d4-make-step|d4-pack-int16|d4-pack-int32|d4-round1|d4-round2|d4-round3|d4-unpack-int16|d4-unpack-int32|d4|d5-binary|ember\\\\*|ember-if-not|ember-if|emory-info|enu-bar-bookmark-map|enu-bar-buffer-vector|enu-bar-ediff-menu|enu-bar-ediff-merge-menu|enu-bar-ediff-misc-menu|enu-bar-enable-clipboard|enu-bar-epatch-menu|enu-bar-frame-for-menubar|enu-bar-handwrite-map|enu-bar-horizontal-scroll-bar|enu-bar-kill-ring-save|enu-bar-left-scroll-bar|enu-bar-make-mm-toggle|enu-bar-make-toggle|enu-bar-menu-at-x-y|enu-bar-menu-frame-live-and-visible-p|enu-bar-mode|enu-bar-next-tag-other-window|enu-bar-next-tag|enu-bar-no-horizontal-scroll-bar|enu-bar-no-scroll-bar|enu-bar-non-minibuffer-window-p|enu-bar-open|enu-bar-options-save|enu-bar-positive-p|enu-bar-read-lispintro|enu-bar-read-lispref|enu-bar-read-mail|enu-bar-right-scroll-bar|enu-bar-select-buffer|enu-bar-select-frame|enu-bar-select-yank|enu-bar-set-tool-bar-position|enu-bar-showhide-fringe-ind-box|enu-bar-showhide-fringe-ind-customize|enu-bar-showhide-fringe-ind-left|enu-bar-showhide-fringe-ind-mixed|enu-bar-showhide-fringe-ind-none|enu-bar-showhide-fringe-ind-right|enu-bar-showhide-fringe-menu-customize-disable|enu-bar-showhide-fringe-menu-customize-left|enu-bar-showhide-fringe-menu-customize-reset|enu-bar-showhide-fringe-menu-customize-right|enu-bar-showhide-fringe-menu-customize|enu-bar-showhide-tool-bar-menu-customize-disable|enu-bar-showhide-tool-bar-menu-customize-enable-bottom|enu-bar-showhide-tool-bar-menu-customize-enable-left|enu-bar-showhide-tool-bar-menu-customize-enable-right|enu-bar-showhide-tool-bar-menu-customize-enable-top|enu-bar-update-buffers-1|enu-bar-update-buffers|enu-bar-update-yank-menu|enu-find-file-existing|enu-or-popup-active-p|enu-set-font|ercury-mode|erge-coding-systems|erge-mail-abbrevs|erge|essage--yank-original-internal|essage-add-action|essage-add-archive-header|essage-add-header|essage-alter-recipients-discard-bogus-full-name|essage-beginning-of-line|essage-bogus-recipient-p|essage-bold-region|essage-bounce|essage-buffer-name|essage-buffers|essage-bury|essage-caesar-buffer-body|essage-caesar-region|essage-cancel-news|essage-canlock-generate|essage-canlock-password|essage-carefully-insert-headers|essage-change-subject|essage-check-element|essage-check-news-body-syntax|essage-check-news-header-syntax|essage-check-news-syntax|essage-check-recipients|essage-check|essage-checksum|essage-cite-original-1|essage-cite-original-without-signature|essage-cite-original|essage-cleanup-headers|essage-clone-locals|essage-completion-function|essage-completion-in-region|essage-cross-post-followup-to-header|essage-cross-post-followup-to|essage-cross-post-insert-note|essage-default-send-mail-function|essage-default-send-rename-function|essage-delete-action|essage-delete-line|essage-delete-not-region|essage-delete-overlay|essage-disassociate-draft|essage-display-abbrev|essage-do-actions|essage-do-auto-fill|essage-do-fcc|essage-do-send-housekeeping|essage-dont-reply-to-names|essage-dont-send|essage-elide-region|essage-encode-message-body|essage-exchange-point-and-mark|essage-expand-group|essage-expand-name|essage-fetch-field|essage-fetch-reply-field|essage-field-name|essage-field-value|essage-fill-field-address|essage-fill-field-general|essage-fill-field|essage-fill-paragraph|essage-fill-yanked-message|essage-fix-before-sending|essage-flatten-list|essage-followup|essage-font-lock-make-header-matcher|essage-forward-make-body-digest-mime|essage-forward-make-body-digest-plain|essage-forward-make-body-digest|essage-forward-make-body-mime|essage-forward-make-body-mml|essage-forward-make-body-plain|essage-forward-make-body|essage-forward-rmail-make-body|essage-forward-subject-author-subject|essage-forward-subject-fwd|essage-forward-subject-name-subject|essage-forward|essage-generate-headers|essage-generate-new-buffer-clone-locals|essage-generate-unsubscribed-mail-followup-to|essage-get-reply-headers|essage-gnksa-enable-p|essage-goto-bcc|essage-goto-body|essage-goto-cc|essage-goto-distribution|essage-goto-eoh|essage-goto-fcc|essage-goto-followup-to|essage-goto-from|essage-goto-keywords|essage-goto-mail-followup-to|essage-goto-newsgroups|essage-goto-reply-to|essage-goto-signature|essage-goto-subject|essage-goto-summary|essage-goto-to|essage-headers-to-generate|essage-hide-header-p|essage-hide-headers|essage-idna-to-ascii-rhs-1|essage-idna-to-ascii-rhs|essage-in-body-p|essage-indent-citation|essage-info|essage-insert-canlock|essage-insert-citation-line|essage-insert-courtesy-copy|essage-insert-disposition-notification-to|essage-insert-expires|essage-insert-formatted-citation-line|essage-insert-headers??|essage-insert-importance-high|essage-insert-importance-low|essage-insert-newsgroups|essage-insert-or-toggle-importance|essage-insert-signature|essage-insert-to|essage-insert-wide-reply|essage-insinuate-rmail|essage-is-yours-p|essage-kill-address|essage-kill-all-overlays|essage-kill-buffer|essage-kill-to-signature|essage-mail-alias-type-p|essage-mail-file-mbox-p|essage-mail-other-frame|essage-mail-other-window|essage-mail-p|essage-mail-user-agent|essage-mail|essage-make-address|essage-make-caesar-translation-table|essage-make-date|essage-make-distribution|essage-make-domain|essage-make-expires-date|essage-make-expires|essage-make-forward-subject|essage-make-fqdn|essage-make-from|essage-make-html-message-with-image-files|essage-make-in-reply-to|essage-make-lines|essage-make-mail-followup-to|essage-make-message-id|essage-make-organization|essage-make-overlay|essage-make-path|essage-make-references|essage-make-sender|essage-make-tool-bar|essage-mark-active-p|essage-mark-insert-file|essage-mark-inserted-region|essage-mode-field-menu|essage-mode-menu|essage-mode|essage-multi-smtp-send-mail|essage-narrow-to-field|essage-narrow-to-head-1|essage-narrow-to-head|essage-narrow-to-headers-or-head|essage-narrow-to-headers|essage-newline-and-reformat|essage-news-other-frame|essage-news-other-window|essage-news-p|essage-news|essage-next-header|essage-number-base36|essage-options-get|essage-options-set-recipient|essage-options-set|essage-output|essage-overlay-put|essage-pipe-buffer-body|essage-point-in-header-p|essage-pop-to-buffer|essage-position-on-field|essage-position-point|essage-posting-charset|essage-prune-recipients|essage-put-addresses-in-ecomplete|essage-read-from-minibuffer|essage-recover|essage-reduce-to-to-cc|essage-remove-blank-cited-lines|essage-remove-first-header|essage-remove-header|essage-remove-ignored-headers|essage-rename-buffer|essage-replace-header|essage-reply|essage-resend|essage-send-and-exit|essage-send-form-letter|essage-send-mail-function|essage-send-mail-partially|essage-send-mail-with-mailclient|essage-send-mail-with-mh|essage-send-mail-with-qmail|essage-send-mail-with-sendmail|essage-send-mail|essage-send-news|essage-send-via-mail|essage-send-via-news|essage-send|essage-sendmail-envelope-from|essage-set-auto-save-file-name|essage-setup-1|essage-setup-fill-variables|essage-setup-toolbar|essage-setup|essage-shorten-1|essage-shorten-references|essage-signed-or-encrypted-p|essage-simplify-recipients|essage-simplify-subject|essage-skip-to-next-address|essage-smtpmail-send-it|essage-sort-headers-1|essage-sort-headers|essage-split-line|essage-strip-forbidden-properties|essage-strip-list-identifiers|essage-strip-subject-encoded-words|essage-strip-subject-re|essage-strip-subject-trailing-was|essage-subscribed-p|essage-supersede|essage-tab|essage-talkative-question|essage-tamago-not-in-use-p|essage-text-with-property|essage-to-list-only|essage-tokenize-header|essage-tool-bar-update|essage-unbold-region|essage-unique-id|essage-unquote-tokens|essage-use-alternative-email-as-from|essage-user-mail-address|essage-wash-subject|essage-wide-reply|essage-widen-reply|essage-with-reply-buffer|essage-y-or-n-p)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)m(?:essage-yank-buffer|essage-yank-original|essages-buffer-mode|eta-add-symbols|eta-beginning-of-defun|eta-car-string-lessp|eta-comment-defun|eta-comment-indent|eta-comment-region|eta-common-mode|eta-complete-symbol|eta-completions-at-point|eta-end-of-defun|eta-indent-buffer|eta-indent-calculate|eta-indent-current-indentation|eta-indent-current-nesting|eta-indent-defun|eta-indent-in-string-p|eta-indent-level-count|eta-indent-line|eta-indent-looking-at-code|eta-indent-previous-line|eta-indent-region|eta-indent-unfinished-line|eta-listify|eta-mark-active|eta-mark-defun|eta-mode-menu|eta-symbol-list|eta-uncomment-defun|eta-uncomment-region|etafont-mode|etamail-buffer|etamail-interpret-body|etamail-interpret-header|etamail-region|etapost-mode|h-adaptive-cmd-note-flag-check|h-add-missing-mime-version-header|h-add-msgs-to-seq|h-alias-address-to-alias|h-alias-expand|h-alias-for-from-p|h-alias-grab-from-field|h-alias-letter-expand-alias|h-alias-minibuffer-confirm-address|h-alias-reload-maybe|h-assoc-string|h-beginning-of-word|h-bogofilter-blacklist|h-bogofilter-whitelist|h-buffer-data|h-burst-digest|h-cancel-timer|h-catchup|h-cl-flet|h-clean-msg-header|h-clear-sub-folders-cache|h-coalesce-msg-list|h-colors-available-p|h-colors-in-use-p|h-complete-word|h-compose-forward|h-compose-insertion|h-copy-msg|h-create-sequence-map|h-customize|h-decode-message-header|h-decode-message-subject|h-define-obsolete-variable-alias|h-define-sequence|h-defstruct|h-delete-a-msg|h-delete-line|h-delete-msg-from-seq|h-delete-msg-no-motion|h-delete-msg|h-delete-seq|h-delete-subject-or-thread|h-delete-subject|h-destroy-postponed-handles|h-display-color-cells|h-display-completion-list|h-display-emphasis|h-display-msg|h-display-smileys|h-display-with-external-viewer|h-do-at-event-location|h-do-in-gnu-emacs|h-do-in-xemacs|h-edit-again|h-ephem-message|h-exchange-point-and-mark-preserving-active-mark|h-exec-cmd-daemon|h-exec-cmd-env-daemon|h-exec-cmd-error|h-exec-cmd-output|h-exec-cmd-quiet|h-exec-cmd|h-exec-lib-cmd-output|h-execute-commands|h-expand-file-name|h-extract-from-header-value|h-extract-rejected-mail|h-face-background|h-face-data|h-face-foreground|h-file-command-p|h-file-mime-type|h-find-path|h-find-seq|h-first-msg|h-folder-completion-function|h-folder-from-address|h-folder-inline-mime-part|h-folder-list|h-folder-mode|h-folder-name-p|h-folder-save-mime-part|h-folder-speedbar-buttons|h-folder-toggle-mime-part|h-font-lock-add-keywords|h-forward|h-fully-kill-draft|h-funcall-if-exists|h-get-header-field|h-get-msg-num|h-gnus-article-highlight-citation|h-goto-cur-msg|h-goto-header-end|h-goto-header-field|h-goto-msg|h-goto-next-button|h-handle-process-error|h-have-file-command|h-header-display|h-header-field-beginning|h-header-field-end|h-help|h-identity-add-menu|h-identity-handler-attribution-verb|h-identity-handler-bottom|h-identity-handler-gpg-identity|h-identity-handler-signature|h-identity-handler-top|h-identity-insert-attribution-verb|h-identity-make-menu-no-autoload|h-identity-make-menu|h-image-load-path-for-library|h-image-search-load-path|h-in-header-p|h-in-show-buffer|h-inc-folder|h-inc-spool-make-no-autoload|h-inc-spool-make|h-index-add-to-sequence|h-index-create-imenu-index|h-index-create-sequences|h-index-delete-folder-headers|h-index-delete-from-sequence|h-index-execute-commands|h-index-group-by-folder|h-index-insert-folder-headers|h-index-new-messages|h-index-next-folder|h-index-previous-folder|h-index-read-data|h-index-sequenced-messages|h-index-ticked-messages|h-index-update-maps|h-index-visit-folder|h-insert-auto-fields|h-insert-identity|h-insert-signature|h-interactive-range|h-invalidate-show-buffer|h-invisible-headers|h-iterate-on-messages-in-region|h-iterate-on-range|h-junk-blacklist-disposition|h-junk-blacklist|h-junk-choose|h-junk-process-blacklist|h-junk-process-whitelist|h-junk-whitelist|h-kill-folder|h-last-msg|h-lessp|h-letter-hide-all-skipped-fields|h-letter-mode|h-letter-next-header-field|h-letter-skip-leading-whitespace-in-header-field|h-letter-skipped-header-field-p|h-letter-speedbar-buttons|h-letter-toggle-header-field-display-button|h-letter-toggle-header-field-display|h-line-beginning-position|h-line-end-position|h-list-folders|h-list-sequences|h-list-to-string-1|h-list-to-string|h-logo-display|h-macro-expansion-time-gnus-version|h-mail-abbrev-make-syntax-table|h-mail-header-end|h-make-folder-mode-line|h-make-local-hook|h-make-local-vars|h-make-obsolete-variable|h-mapc|h-mark-active-p|h-match-string-no-properties|h-maybe-show|h-mh-compose-anon-ftp|h-mh-compose-external-compressed-tar|h-mh-compose-external-type|h-mh-directive-present-p|h-mh-to-mime-undo|h-mh-to-mime|h-mime-cleanup|h-mime-display|h-mime-save-parts|h-mml-forward-message|h-mml-secure-message-encrypt|h-mml-secure-message-sign|h-mml-secure-message-signencrypt|h-mml-tag-present-p|h-mml-to-mime|h-mml-unsecure-message|h-modify|h-msg-filename|h-msg-is-in-seq|h-msg-num-width-to-column|h-msg-num-width|h-narrow-to-cc|h-narrow-to-from|h-narrow-to-range|h-narrow-to-seq|h-narrow-to-subject|h-narrow-to-tick|h-narrow-to-to|h-new-draft-name|h-next-button|h-next-msg|h-next-undeleted-msg|h-next-unread-msg|h-nmail|h-notate-cur|h-notate-deleted-and-refiled|h-notate-user-sequences|h-notate|h-outstanding-commands-p|h-pack-folder|h-page-digest-backwards|h-page-digest|h-page-msg|h-parse-flist-output-line|h-pipe-msg|h-position-on-field|h-prefix-help|h-prev-button|h-previous-page|h-previous-undeleted-msg|h-previous-unread-msg|h-print-msg|h-process-daemon|h-process-or-undo-commands|h-profile-component-value|h-profile-component|h-prompt-for-folder|h-prompt-for-refile-folder|h-ps-print-msg-file|h-ps-print-msg|h-ps-print-toggle-color|h-ps-print-toggle-faces|h-put-msg-in-seq|h-quit|h-quote-for-shell|h-quote-pick-expr|h-range-to-msg-list|h-read-address|h-read-folder-sequences|h-read-range|h-read-seq-default|h-recenter|h-redistribute|h-refile-a-msg|h-refile-msg|h-refile-or-write-again|h-regenerate-headers|h-remove-all-notation|h-remove-cur-notation|h-remove-from-sub-folders-cache|h-replace-regexp-in-string|h-replace-string|h-reply|h-require-cl|h-require|h-rescan-folder|h-reset-threads-and-narrowing|h-rmail|h-run-time-gnus-version|h-scan-folder|h-scan-format-file-check|h-scan-format|h-scan-msg-number-regexp|h-scan-msg-search-regexp|h-search-from-end|h-search-p|h-search|h-send-letter|h-send|h-seq-msgs|h-seq-to-msgs|h-set-cmd-note|h-set-folder-modified-p|h-set-help|h-set-x-image-cache-directory|h-show-addr|h-show-buffer-message-number|h-show-font-lock-keywords-with-cite|h-show-font-lock-keywords|h-show-mode|h-show-preferred-alternative|h-show-speedbar-buttons|h-show-xface|h-show|h-showing-mode|h-signature-separator-p|h-smail-batch|h-smail-other-window|h-smail|h-sort-folder|h-spamassassin-blacklist|h-spamassassin-identify-spammers|h-spamassassin-whitelist|h-spamprobe-blacklist|h-spamprobe-whitelist|h-speed-add-folder|h-speed-flists-active-p|h-speed-flists|h-speed-invalidate-map|h-start-of-uncleaned-message|h-store-msg|h-strip-package-version|h-sub-folders|h-test-completion|h-thread-add-spaces|h-thread-ancestor|h-thread-delete|h-thread-find-msg-subject|h-thread-forget-message|h-thread-generate|h-thread-inc|h-thread-next-sibling|h-thread-parse-scan-line|h-thread-previous-sibling|h-thread-print-scan-lines|h-thread-refile|h-thread-update-scan-line-map|h-toggle-mh-decode-mime-flag|h-toggle-mime-buttons|h-toggle-showing|h-toggle-threads|h-toggle-tick|h-translate-range|h-truncate-log-buffer|h-undefine-sequence|h-undo-folder|h-undo|h-update-sequences|h-url-hexify-string|h-user-agent-compose|h-valid-seq-p|h-valid-view-change-operation-p|h-variant-gnu-mh-info|h-variant-info|h-variant-mh-info|h-variant-nmh-info|h-variant-p|h-variant-set-variant|h-variant-set|h-variants|h-version|h-view-mode-enter|h-visit-folder|h-widen|h-window-full-height-p|h-write-file-functions|h-write-msg-to-file|h-xargs|h-yank-cur-msg|idnight-buffer-display-time|idnight-delay-set|idnight-find|idnight-next|ime-to-mml|inibuf-eldef-setup-minibuffer|inibuf-eldef-update-minibuffer|inibuffer--bitset|inibuffer--double-dollars|inibuffer-avoid-prompt|inibuffer-completion-contents|inibuffer-default--in-prompt-regexps|inibuffer-default-add-completions|inibuffer-default-add-shell-commands|inibuffer-depth-indicate-mode|inibuffer-depth-setup|inibuffer-electric-default-mode|inibuffer-force-complete-and-exit|inibuffer-force-complete|inibuffer-frame-list|inibuffer-hide-completions|inibuffer-history-initialize|inibuffer-history-isearch-end|inibuffer-history-isearch-message|inibuffer-history-isearch-pop-state|inibuffer-history-isearch-push-state|inibuffer-history-isearch-search|inibuffer-history-isearch-setup|inibuffer-history-isearch-wrap|inibuffer-insert-file-name-at-point|inibuffer-keyboard-quit|inibuffer-with-setup-hook|inor-mode-menu-from-indicator|inusp|ismatch|ixal-debug|ixal-describe-operation-code|ixal-mode|ixal-run|m-add-meta-html-tag|m-alist-to-plist|m-annotationp|m-append-to-file|m-archive-decoders|m-archive-dissect-and-inline|m-assoc-string-match|m-attachment-override-p|m-auto-mode-alist|m-automatic-display-p|m-automatic-external-display-p|m-body-7-or-8|m-body-encoding|m-char-int|m-char-or-char-int-p|m-charset-after|m-charset-to-coding-system|m-codepage-setup|m-coding-system-equal|m-coding-system-list|m-coding-system-p|m-coding-system-to-mime-charset|m-complicated-handles|m-content-transfer-encoding|m-convert-shr-links|m-copy-to-buffer|m-create-image-xemacs|m-decode-body|m-decode-coding-region|m-decode-coding-string|m-decode-content-transfer-encoding|m-decode-string|m-decompress-buffer|m-default-file-encoding|m-default-multibyte-p|m-delete-duplicates|m-destroy-parts??|m-destroy-postponed-undisplay-list|m-detect-coding-region|m-detect-mime-charset-region|m-disable-multibyte|m-display-external|m-display-inline|m-display-parts??|m-dissect-archive|m-dissect-buffer|m-dissect-multipart|m-dissect-singlepart|m-enable-multibyte|m-encode-body|m-encode-buffer|m-encode-coding-region|m-encode-coding-string|m-encode-content-transfer-encoding|m-enrich-utf-8-by-mule-ucs|m-extern-cache-contents|m-file-name-collapse-whitespace|m-file-name-delete-control|m-file-name-delete-gotchas|m-file-name-delete-whitespace|m-file-name-replace-whitespace|m-file-name-trim-whitespace|m-find-buffer-file-coding-system|m-find-charset-region|m-find-mime-charset-region|m-find-part-by-type|m-find-raw-part-by-type|m-get-coding-system-list|m-get-content-id|m-get-image|m-get-part|m-guess-charset|m-handle-buffer|m-handle-cache|m-handle-description|m-handle-displayed-p|m-handle-disposition|m-handle-encoding|m-handle-filename|m-handle-id|m-handle-media-subtype|m-handle-media-supertype|m-handle-media-type|m-handle-multipart-ctl-parameter|m-handle-multipart-from|m-handle-multipart-original-buffer|m-handle-set-cache|m-handle-set-external-undisplayer|m-handle-set-undisplayer|m-handle-type|m-handle-undisplayer|m-image-fit-p|m-image-load-path|m-image-type-from-buffer|m-inlinable-p|m-inline-external-body|m-inline-override-p|m-inline-partial|m-inlined-p|m-insert-byte|m-insert-file-contents|m-insert-headers|m-insert-inline|m-insert-multipart-headers|m-insert-part|m-insert-rfc822-headers|m-interactively-view-part|m-iso-8859-x-to-15-region|m-keep-viewer-alive-p|m-line-number-at-pos|m-long-lines-p|m-mailcap-command|m-make-handle|m-make-temp-file|m-merge-handles|m-mime-charset|m-mule-charset-to-mime-charset|m-multibyte-char-to-unibyte|m-multibyte-p|m-multibyte-string-p|m-multiple-handles|m-pipe-part|m-possibly-verify-or-decrypt|m-preferred-alternative-precedence|m-preferred-alternative|m-preferred-coding-system|m-qp-or-base64|m-read-charset|m-read-coding-system|m-readable-p|m-remove-parts??|m-replace-in-string|m-safer-encoding|m-save-part-to-file|m-save-part|m-set-buffer-file-coding-system|m-set-buffer-multibyte|m-set-handle-multipart-parameter|m-setup-codepage-ibm|m-setup-codepage-iso-8859|m-shr|m-sort-coding-systems-predicate)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(?:mm-special-display-p|mm-string-as-multibyte|mm-string-as-unibyte|mm-string-make-unibyte|mm-string-to-multibyte|mm-subst-char-in-string|mm-substring-no-properties|mm-temp-files-delete|mm-ucs-to-char|mm-url-decode-entities-nbsp|mm-url-decode-entities-string|mm-url-decode-entities|mm-url-encode-multipart-form-data|mm-url-encode-www-form-urlencoded|mm-url-form-encode-xwfu|mm-url-insert-file-contents-external|mm-url-insert-file-contents|mm-url-insert|mm-url-load-url|mm-url-remove-markup|mm-uu-dissect-text-parts|mm-uu-dissect|mm-valid-and-fit-image-p|mm-valid-image-format-p|mm-view-pkcs7|mm-with-multibyte-buffer|mm-with-part|mm-with-unibyte-buffer|mm-with-unibyte-current-buffer|mm-write-region|mm-xemacs-find-mime-charset-1|mm-xemacs-find-mime-charset|mml-attach-buffer|mml-attach-external|mml-attach-file|mml-buffer-substring-no-properties-except-hard-newlines|mml-compute-boundary-1|mml-compute-boundary|mml-content-disposition|mml-destroy-buffers|mml-dnd-attach-file|mml-expand-html-into-multipart-related|mml-generate-mime-1|mml-generate-mime|mml-generate-new-buffer|mml-insert-buffer|mml-insert-empty-tag|mml-insert-mime-headers|mml-insert-mime|mml-insert-mml-markup|mml-insert-multipart|mml-insert-parameter-string|mml-insert-parameter|mml-insert-part|mml-insert-tag|mml-make-boundary|mml-menu|mml-minibuffer-read-description|mml-minibuffer-read-disposition|mml-minibuffer-read-file|mml-minibuffer-read-type|mml-mode|mml-parameter-string|mml-parse-1|mml-parse-file-name|mml-parse-singlepart-with-multiple-charsets|mml-parse|mml-pgp-encrypt-buffer|mml-pgp-sign-buffer|mml-pgpauto-encrypt-buffer|mml-pgpauto-sign-buffer|mml-pgpmime-encrypt-buffer|mml-pgpmime-sign-buffer|mml-preview-insert-mail-followup-to|mml-preview|mml-quote-region|mml-read-part|mml-read-tag|mml-secure-encrypt-pgp|mml-secure-encrypt-pgpmime|mml-secure-encrypt-smime|mml-secure-encrypt|mml-secure-message-encrypt-pgp|mml-secure-message-encrypt-pgpauto|mml-secure-message-encrypt-pgpmime|mml-secure-message-encrypt-smime|mml-secure-message-encrypt|mml-secure-message-sign-encrypt|mml-secure-message-sign-pgp|mml-secure-message-sign-pgpauto|mml-secure-message-sign-pgpmime|mml-secure-message-sign-smime|mml-secure-message-sign|mml-secure-message|mml-secure-part|mml-secure-sign-pgp|mml-secure-sign-pgpauto|mml-secure-sign-pgpmime|mml-secure-sign-smime|mml-secure-sign|mml-signencrypt-style|mml-smime-encrypt-buffer|mml-smime-encrypt-query|mml-smime-encrypt|mml-smime-sign-buffer|mml-smime-sign-query|mml-smime-sign|mml-smime-verify-test|mml-smime-verify|mml-to-mime|mml-tweak-externalize-attachments|mml-tweak-part|mml-unsecure-message|mml-validate|mml1991-encrypt|mml1991-sign|mml2015-decrypt-test|mml2015-decrypt|mml2015-encrypt|mml2015-self-encrypt|mml2015-sign|mml2015-verify-test|mml2015-verify|mod\\\\*|mode-line-bury-buffer|mode-line-change-eol|mode-line-eol-desc|mode-line-frame-control|mode-line-minor-mode-help|mode-line-modified-help-echo|mode-line-mule-info-help-echo|mode-line-next-buffer|mode-line-other-buffer|mode-line-previous-buffer|mode-line-read-only-help-echo|mode-line-toggle-modified|mode-line-toggle-read-only|mode-line-unbury-buffer|mode-line-widen|mode-local--expand-overrides|mode-local--overload-body|mode-local--override|mode-local-augment-function-help|mode-local-bind|mode-local-describe-bindings-1|mode-local-describe-bindings-2|mode-local-equivalent-mode-p|mode-local-initialized-p|mode-local-map-file-buffers|mode-local-map-mode-buffers|mode-local-on-major-mode-change|mode-local-post-major-mode-change|mode-local-print-bindings??|mode-local-read-function|mode-local-setup-edebug-specs|mode-local-symbol-value|mode-local-symbol|mode-local-use-bindings-p|mode-local-value|mode-specific-command-prefix|modify-coding-system-alist|modify-face|modula-2-mode|morse-region|mouse--down-1-maybe-follows-link|mouse--drag-set-mark-and-point|mouse--strip-first-event|mouse-appearance-menu|mouse-autoselect-window-cancel|mouse-autoselect-window-select|mouse-autoselect-window-start|mouse-avoidance-banish-destination|mouse-avoidance-banish-mouse|mouse-avoidance-banish|mouse-avoidance-delta|mouse-avoidance-exile|mouse-avoidance-fancy|mouse-avoidance-ignore-p|mouse-avoidance-mode|mouse-avoidance-nudge-mouse|mouse-avoidance-point-position|mouse-avoidance-random-shape|mouse-avoidance-set-mouse-position|mouse-avoidance-set-pointer-shape|mouse-avoidance-too-close-p|mouse-buffer-menu-alist|mouse-buffer-menu-keymap|mouse-buffer-menu-map|mouse-buffer-menu-split|mouse-buffer-menu|mouse-choose-completion|mouse-copy-work-around-drag-bug|mouse-delete-other-windows|mouse-delete-window|mouse-drag-drag|mouse-drag-events-are-point-events-p|mouse-drag-header-line|mouse-drag-line|mouse-drag-mode-line|mouse-drag-region|mouse-drag-repeatedly-safe-scroll|mouse-drag-safe-scroll|mouse-drag-scroll-delta|mouse-drag-secondary-moving|mouse-drag-secondary-pasting|mouse-drag-secondary|mouse-drag-should-do-col-scrolling|mouse-drag-throw|mouse-drag-track|mouse-drag-vertical-line|mouse-event-p|mouse-fixup-help-message|mouse-kill-preserving-secondary|mouse-kill-ring-save|mouse-kill-secondary|mouse-kill|mouse-major-mode-menu|mouse-menu-bar-map|mouse-menu-major-mode-map|mouse-menu-non-singleton|mouse-minibuffer-check|mouse-minor-mode-menu|mouse-popup-menubar-stuff|mouse-popup-menubar|mouse-posn-property|mouse-region-match|mouse-save-then-kill-delete-region|mouse-save-then-kill|mouse-scroll-subr|mouse-secondary-save-then-kill|mouse-select-buffer|mouse-select-font|mouse-select-window|mouse-set-font|mouse-set-mark-fast|mouse-set-mark|mouse-set-point|mouse-set-region-1|mouse-set-region|mouse-set-secondary|mouse-skip-word|mouse-split-window-horizontally|mouse-split-window-vertically|mouse-start-end|mouse-start-secondary|mouse-tear-off-window|mouse-undouble-last-event|mouse-wheel-change-button|mouse-wheel-mode|mouse-yank-at-click|mouse-yank-primary|mouse-yank-secondary|move-beginning-of-line|move-end-of-line|move-file-to-trash|move-past-close-and-reindent|move-to-column-untabify|move-to-tab-stop|move-to-window-line-top-bottom|mpc--debug|mpc--faster-stop|mpc--faster-toggle-refresh|mpc--faster-toggle|mpc--faster|mpc--proc-alist-to-alists|mpc--proc-connect|mpc--proc-filter|mpc--proc-quote-string|mpc--songduration|mpc--status-callback|mpc--status-idle-timer-run|mpc--status-idle-timer-start|mpc--status-idle-timer-stop|mpc--status-timer-run|mpc--status-timer-start|mpc--status-timer-stop|mpc--status-timers-refresh|mpc-assq-all|mpc-cmd-add|mpc-cmd-clear|mpc-cmd-delete|mpc-cmd-find|mpc-cmd-flush|mpc-cmd-list|mpc-cmd-move|mpc-cmd-pause|mpc-cmd-play|mpc-cmd-special-tag-p|mpc-cmd-status|mpc-cmd-stop|mpc-cmd-tagtypes|mpc-cmd-update|mpc-compare-strings|mpc-constraints-get-current|mpc-constraints-pop|mpc-constraints-push|mpc-constraints-restore|mpc-constraints-tag-lookup|mpc-current-refresh|mpc-data-directory|mpc-drag-n-drop|mpc-event-set-point|mpc-ffwd|mpc-file-local-copy|mpc-format|mpc-intersection|mpc-mode-menu|mpc-mode|mpc-next|mpc-pause|mpc-play-at-point|mpc-play|mpc-playlist-add|mpc-playlist-create|mpc-playlist-delete|mpc-playlist-destroy|mpc-playlist-rename|mpc-playlist|mpc-prev|mpc-proc-buf-to-alists??|mpc-proc-buffer|mpc-proc-check|mpc-proc-cmd-list-ok|mpc-proc-cmd-list|mpc-proc-cmd-to-alist|mpc-proc-cmd|mpc-proc-sync|mpc-proc-tag-string-to-sym|mpc-proc|mpc-quit|mpc-reorder|mpc-resume|mpc-rewind|mpc-ring-make|mpc-ring-pop|mpc-ring-push|mpc-secs-to-time|mpc-select-extend|mpc-select-get-selection|mpc-select-make-overlay|mpc-select-restore|mpc-select-save|mpc-select-toggle|mpc-select|mpc-selection-refresh|mpc-separator|mpc-songpointer-context|mpc-songpointer-refresh-hairy|mpc-songpointer-refresh|mpc-songpointer-score|mpc-songpointer-set|mpc-songs-buf|mpc-songs-hashcons|mpc-songs-jump-to|mpc-songs-kill-search|mpc-songs-mode|mpc-songs-refresh|mpc-songs-search|mpc-songs-selection|mpc-sort|mpc-status-buffer-refresh|mpc-status-buffer-show|mpc-status-mode|mpc-status-refresh|mpc-status-stop|mpc-stop|mpc-string-prefix-p|mpc-tagbrowser-all-p|mpc-tagbrowser-all-select|mpc-tagbrowser-buf|mpc-tagbrowser-dir-mode|mpc-tagbrowser-dir-toggle|mpc-tagbrowser-mode|mpc-tagbrowser-refresh|mpc-tagbrowser-tag-name|mpc-tagbrowser|mpc-tempfiles-add|mpc-tempfiles-clean|mpc-union|mpc-update|mpc-updated-db|mpc-volume-mouse-set|mpc-volume-refresh|mpc-volume-widget|mpc|mpuz-ask-for-try|mpuz-build-random-perm|mpuz-check-all-solved|mpuz-close-game|mpuz-create-buffer|mpuz-digit-solved-p|mpuz-ding|mpuz-get-buffer|mpuz-mode|mpuz-offer-abort|mpuz-paint-board|mpuz-paint-digit|mpuz-paint-errors|mpuz-paint-number|mpuz-paint-statistics|mpuz-put-number-on-board|mpuz-random-puzzle|mpuz-show-solution|mpuz-solve|mpuz-start-new-game|mpuz-switch-to-window|mpuz-to-digit|mpuz-to-letter|mpuz-try-letter|mpuz-try-proposal|mpuz|msb--add-separators|msb--add-to-menu|msb--aggregate-alist|msb--choose-file-menu|msb--choose-menu|msb--collect|msb--create-buffer-menu-2|msb--create-buffer-menu|msb--create-function-info|msb--create-sort-item|msb--dired-directory|msb--format-title|msb--init-file-alist|msb--make-keymap-menu|msb--mode-menu-cond|msb--most-recently-used-menu|msb--split-menus-2|msb--split-menus|msb--strip-dir|msb--toggle-menu-type|msb-alon-item-handler|msb-custom-set|msb-dired-item-handler|msb-invisible-buffer-p|msb-item-handler|msb-menu-bar-update-buffers|msb-mode|msb-sort-by-directory|msb-sort-by-name|msb-unload-function|msb|mspools-get-folder-from-spool|mspools-get-spool-files|mspools-get-spool-name|mspools-help|mspools-mode|mspools-quit|mspools-revert-buffer|mspools-set-vm-spool-files|mspools-show-again|mspools-show|mspools-size-folder|mspools-visit-spool|mule-diag|multi-isearch-buffers-regexp|multi-isearch-buffers|multi-isearch-end|multi-isearch-files-regexp|multi-isearch-files|multi-isearch-next-buffer-from-list|multi-isearch-next-file-buffer-from-list|multi-isearch-pop-state|multi-isearch-push-state|multi-isearch-read-buffers|multi-isearch-read-files|multi-isearch-read-matching-buffers|multi-isearch-read-matching-files|multi-isearch-search-fun|multi-isearch-setup|multi-isearch-wrap|multi-occur-in-matching-buffers|multi-occur|multiple-value-apply|multiple-value-bind|multiple-value-call|multiple-value-list|multiple-value-setq|mwheel-event-button|mwheel-event-window|mwheel-filter-click-events|mwheel-inhibit-click-timeout|mwheel-install|mwheel-scroll|name-last-kbd-macro|narrow-to-defun|nato-region|nested-alist-p|net-utils--revert-function|net-utils-machine-at-point|net-utils-mode|net-utils-remove-ctrl-m-filter|net-utils-run-program|net-utils-run-simple|net-utils-url-at-point|netrc-credentials|netrc-find-service-name|netrc-get|netrc-machine-user-or-password|netrc-machine|netrc-parse-services|netrc-parse|netrc-port-equal|netstat|network-connection-mode-setup|network-connection-mode|network-connection-reconnect|network-connection-to-service|network-connection|network-service-connection|network-stream-certificate|network-stream-command|network-stream-get-response|network-stream-open-plain|network-stream-open-shell|network-stream-open-starttls|network-stream-open-tls|new-fontset|new-frame|new-mode-local-bindings|newline-cache-check|newsticker--age|newsticker--buffer-beginning-of-feed|newsticker--buffer-beginning-of-item|newsticker--buffer-do-insert-text|newsticker--buffer-end-of-feed|newsticker--buffer-end-of-item|newsticker--buffer-get-feed-title-at-point|newsticker--buffer-get-item-title-at-point|newsticker--buffer-goto|newsticker--buffer-hideshow|newsticker--buffer-insert-all-items|newsticker--buffer-insert-item|newsticker--buffer-make-item-completely-visible|newsticker--buffer-redraw|newsticker--buffer-set-faces|newsticker--buffer-set-invisibility|newsticker--buffer-set-uptodate|newsticker--buffer-statistics|newsticker--cache-add|newsticker--cache-contains|newsticker--cache-dir|newsticker--cache-get-feed|newsticker--cache-item-compare-by-position|newsticker--cache-item-compare-by-time|newsticker--cache-item-compare-by-title|newsticker--cache-mark-expired|newsticker--cache-read-feed|newsticker--cache-read-version1|newsticker--cache-read|newsticker--cache-remove|newsticker--cache-replace-age|newsticker--cache-save-feed|newsticker--cache-save-version1|newsticker--cache-save|newsticker--cache-set-preformatted-contents|newsticker--cache-set-preformatted-title|newsticker--cache-sort)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)n(?:ewsticker--cache-update|ewsticker--count-grouped-feeds|ewsticker--count-groups|ewsticker--debug-msg|ewsticker--decode-iso8601-date|ewsticker--decode-rfc822-date|ewsticker--desc|ewsticker--display-jump|ewsticker--display-scroll|ewsticker--display-tick|ewsticker--do-forget-preformatted|ewsticker--do-mark-item-at-point-as-read|ewsticker--do-print-extra-element|ewsticker--do-run-auto-mark-filter|ewsticker--do-xml-workarounds|ewsticker--echo-area-clean-p|ewsticker--enclosure|ewsticker--extra|ewsticker--forget-preformatted|ewsticker--get-group-names|ewsticker--get-icon-url-atom-1\\\\.0|ewsticker--get-logo-url-atom-0\\\\.3|ewsticker--get-logo-url-atom-1\\\\.0|ewsticker--get-logo-url-rss-0\\\\.91|ewsticker--get-logo-url-rss-0\\\\.92|ewsticker--get-logo-url-rss-1\\\\.0|ewsticker--get-logo-url-rss-2\\\\.0|ewsticker--get-news-by-funcall|ewsticker--get-news-by-url-callback|ewsticker--get-news-by-url|ewsticker--get-news-by-wget|ewsticker--group-all-groups|ewsticker--group-do-find-group|ewsticker--group-do-get-group|ewsticker--group-do-rename-group|ewsticker--group-find-parent-group|ewsticker--group-get-feeds|ewsticker--group-get-group|ewsticker--group-get-subgroups|ewsticker--group-manage-orphan-feeds|ewsticker--group-names|ewsticker--group-remove-obsolete-feeds|ewsticker--group-shift|ewsticker--guid-to-string|ewsticker--guid|ewsticker--icon-read|ewsticker--icons-dir|ewsticker--image-download-by-url-callback|ewsticker--image-download-by-url|ewsticker--image-download-by-wget|ewsticker--image-get|ewsticker--image-read|ewsticker--image-remove|ewsticker--image-save|ewsticker--image-sentinel|ewsticker--images-dir|ewsticker--imenu-create-index|ewsticker--imenu-goto|ewsticker--insert-enclosure|ewsticker--insert-image|ewsticker--link|ewsticker--lists-intersect-p|ewsticker--opml-import-outlines|ewsticker--parse-atom-0\\\\.3|ewsticker--parse-atom-1\\\\.0|ewsticker--parse-generic-feed|ewsticker--parse-generic-items|ewsticker--parse-rss-0\\\\.91|ewsticker--parse-rss-0\\\\.92|ewsticker--parse-rss-1\\\\.0|ewsticker--parse-rss-2\\\\.0|ewsticker--pos|ewsticker--preformatted-contents|ewsticker--preformatted-title|ewsticker--print-extra-elements|ewsticker--process-auto-mark-filter-match|ewsticker--real-feed-name|ewsticker--remove-whitespace|ewsticker--run-auto-mark-filter|ewsticker--sentinel-work|ewsticker--sentinel|ewsticker--set-customvar-buffer|ewsticker--set-customvar-formatting|ewsticker--set-customvar-retrieval|ewsticker--set-customvar-sorting|ewsticker--set-customvar-ticker|ewsticker--set-face-properties|ewsticker--splicer|ewsticker--start-feed|ewsticker--stat-num-items-for-group|ewsticker--stat-num-items-total|ewsticker--stat-num-items|ewsticker--stop-feed|ewsticker--ticker-text-remove|ewsticker--ticker-text-setup|ewsticker--time|ewsticker--title|ewsticker--tree-widget-icon-create|ewsticker--treeview-activate-node|ewsticker--treeview-buffer-init|ewsticker--treeview-count-node-items|ewsticker--treeview-do-get-node-by-id|ewsticker--treeview-do-get-node-of-feed|ewsticker--treeview-first-feed|ewsticker--treeview-frame-init|ewsticker--treeview-get-current-node|ewsticker--treeview-get-feed-vfeed|ewsticker--treeview-get-first-child|ewsticker--treeview-get-id|ewsticker--treeview-get-last-child|ewsticker--treeview-get-next-sibling|ewsticker--treeview-get-next-uncle|ewsticker--treeview-get-node-by-id|ewsticker--treeview-get-node-of-feed|ewsticker--treeview-get-other-tree|ewsticker--treeview-get-prev-sibling|ewsticker--treeview-get-prev-uncle|ewsticker--treeview-get-second-child|ewsticker--treeview-get-selected-item|ewsticker--treeview-ids-eq|ewsticker--treeview-item-buffer|ewsticker--treeview-item-show-text|ewsticker--treeview-item-show|ewsticker--treeview-item-update|ewsticker--treeview-item-window|ewsticker--treeview-list-add-item|ewsticker--treeview-list-all-items|ewsticker--treeview-list-buffer|ewsticker--treeview-list-clear-highlight|ewsticker--treeview-list-clear|ewsticker--treeview-list-compare-item-by-age-reverse|ewsticker--treeview-list-compare-item-by-age|ewsticker--treeview-list-compare-item-by-time-reverse|ewsticker--treeview-list-compare-item-by-time|ewsticker--treeview-list-compare-item-by-title-reverse|ewsticker--treeview-list-compare-item-by-title|ewsticker--treeview-list-feed-items|ewsticker--treeview-list-highlight-start|ewsticker--treeview-list-immortal-items|ewsticker--treeview-list-items-v|ewsticker--treeview-list-items-with-age-callback|ewsticker--treeview-list-items-with-age|ewsticker--treeview-list-items|ewsticker--treeview-list-new-items|ewsticker--treeview-list-obsolete-items|ewsticker--treeview-list-select|ewsticker--treeview-list-sort-by-column|ewsticker--treeview-list-sort-items|ewsticker--treeview-list-update-faces|ewsticker--treeview-list-update-highlight|ewsticker--treeview-list-update|ewsticker--treeview-list-window|ewsticker--treeview-load|ewsticker--treeview-mark-item|ewsticker--treeview-nodes-eq|ewsticker--treeview-propertize-tag|ewsticker--treeview-render-text|ewsticker--treeview-restore-layout|ewsticker--treeview-set-current-node|ewsticker--treeview-tree-buffer|ewsticker--treeview-tree-do-update-tags|ewsticker--treeview-tree-expand-status|ewsticker--treeview-tree-expand|ewsticker--treeview-tree-get-tag|ewsticker--treeview-tree-open-menu|ewsticker--treeview-tree-update-highlight|ewsticker--treeview-tree-update-tags??|ewsticker--treeview-tree-update|ewsticker--treeview-tree-window|ewsticker--treeview-unfold-node|ewsticker--treeview-virtual-feed-p|ewsticker--treeview-window-init|ewsticker--unxml-attribute|ewsticker--unxml-node|ewsticker--unxml|ewsticker--update-process-ids|ewsticker-add-url|ewsticker-browse-url-item|ewsticker-browse-url|ewsticker-buffer-force-update|ewsticker-buffer-update|ewsticker-close-buffer|ewsticker-customize|ewsticker-download-enclosures|ewsticker-download-images|ewsticker-get-all-news|ewsticker-get-news-at-point|ewsticker-get-news|ewsticker-group-add-group|ewsticker-group-delete-group|ewsticker-group-move-feed|ewsticker-group-rename-group|ewsticker-group-shift-feed-down|ewsticker-group-shift-feed-up|ewsticker-group-shift-group-down|ewsticker-group-shift-group-up|ewsticker-handle-url|ewsticker-hide-all-desc|ewsticker-hide-entry|ewsticker-hide-extra|ewsticker-hide-feed-desc|ewsticker-hide-new-item-desc|ewsticker-hide-old-item-desc|ewsticker-hide-old-items|ewsticker-htmlr-render|ewsticker-item-not-immortal-p|ewsticker-item-not-old-p|ewsticker-mark-all-items-as-read|ewsticker-mark-all-items-at-point-as-read-and-redraw|ewsticker-mark-all-items-at-point-as-read|ewsticker-mark-all-items-of-feed-as-read|ewsticker-mark-item-at-point-as-immortal|ewsticker-mark-item-at-point-as-read|ewsticker-mode|ewsticker-mouse-browse-url|ewsticker-new-item-functions-sample|ewsticker-next-feed-available-p|ewsticker-next-feed|ewsticker-next-item-available-p|ewsticker-next-item-same-feed|ewsticker-next-item|ewsticker-next-new-item|ewsticker-opml-export|ewsticker-opml-import|ewsticker-plainview|ewsticker-previous-feed-available-p|ewsticker-previous-feed|ewsticker-previous-item-available-p|ewsticker-previous-item|ewsticker-previous-new-item|ewsticker-retrieve-random-message|ewsticker-running-p|ewsticker-save-item|ewsticker-set-auto-narrow-to-feed|ewsticker-set-auto-narrow-to-item|ewsticker-show-all-desc|ewsticker-show-entry|ewsticker-show-extra|ewsticker-show-feed-desc|ewsticker-show-new-item-desc|ewsticker-show-news|ewsticker-show-old-item-desc|ewsticker-show-old-items|ewsticker-start-ticker|ewsticker-start|ewsticker-stop-ticker|ewsticker-stop|ewsticker-ticker-running-p|ewsticker-toggle-auto-narrow-to-feed|ewsticker-toggle-auto-narrow-to-item|ewsticker-treeview-browse-url-item|ewsticker-treeview-browse-url|ewsticker-treeview-get-news|ewsticker-treeview-item-mode|ewsticker-treeview-jump|ewsticker-treeview-list-make-sort-button|ewsticker-treeview-list-mode|ewsticker-treeview-mark-item-old|ewsticker-treeview-mark-list-items-old|ewsticker-treeview-mode|ewsticker-treeview-mouse-browse-url|ewsticker-treeview-next-feed|ewsticker-treeview-next-item|ewsticker-treeview-next-new-or-immortal-item|ewsticker-treeview-next-page|ewsticker-treeview-prev-feed|ewsticker-treeview-prev-item|ewsticker-treeview-prev-new-or-immortal-item|ewsticker-treeview-quit|ewsticker-treeview-save-item|ewsticker-treeview-save|ewsticker-treeview-scroll-item|ewsticker-treeview-show-item|ewsticker-treeview-toggle-item-immortal|ewsticker-treeview-tree-click|ewsticker-treeview-tree-do-click|ewsticker-treeview-update|ewsticker-treeview|ewsticker-w3m-show-inline-images|ext-buffer|ext-cdabbrev|ext-completion|ext-error-buffer-p|ext-error-find-buffer|ext-error-follow-minor-mode|ext-error-follow-mode-post-command-hook|ext-error-internal|ext-error-no-select|ext-error|ext-file|ext-ifdef|ext-line-or-history-element|ext-line|ext-logical-line|ext-match|ext-method-p|ext-multiframe-window|ext-page|ext-read-file-uses-dialog-p|intersection|inth|ndiary-generate-nov-databases|ndoc-add-type|ndraft-request-associate-buffer|ndraft-request-expire-articles|nfolder-generate-active-file|nheader-accept-process-output|nheader-article-p|nheader-article-to-file-alist|nheader-be-verbose|nheader-cancel-function-timers|nheader-cancel-timer|nheader-concat|nheader-directory-articles|nheader-directory-files-safe|nheader-directory-files|nheader-directory-regular-files|nheader-fake-message-id-p|nheader-file-error|nheader-file-size|nheader-file-to-group|nheader-file-to-number|nheader-find-etc-directory|nheader-find-file-noselect|nheader-find-nov-line|nheader-fold-continuation-lines|nheader-generate-fake-message-id|nheader-get-lines-and-char|nheader-get-report-string|nheader-get-report|nheader-group-pathname|nheader-header-value|nheader-init-server-buffer|nheader-insert-article-line|nheader-insert-buffer-substring|nheader-insert-file-contents|nheader-insert-head|nheader-insert-header|nheader-insert-nov-file|nheader-insert-nov|nheader-insert-references|nheader-insert|nheader-message-maybe|nheader-message|nheader-ms-strip-cr|nheader-narrow-to-headers|nheader-nov-delete-outside-range|nheader-nov-field|nheader-nov-parse-extra|nheader-nov-read-integer|nheader-nov-read-message-id|nheader-nov-skip-field|nheader-parse-head|nheader-parse-naked-head|nheader-parse-nov|nheader-parse-overview-file|nheader-re-read-dir|nheader-remove-body|nheader-remove-cr-followed-by-lf|nheader-replace-chars-in-string|nheader-replace-duplicate-chars-in-string|nheader-replace-header|nheader-replace-regexp|nheader-replace-string|nheader-report|nheader-set-temp-buffer|nheader-skeleton-replace|nheader-strip-cr|nheader-translate-file-chars|nheader-update-marks-actions|nheader-write-overview-file|nmail-article-group|nmail-message-id|nmail-split-fancy|nml-generate-nov-databases|nvirtual-catchup-group|nvirtual-convert-headers|nvirtual-find-group-art|o-applicable-method|o-next-method|onincremental-re-search-backward|onincremental-re-search-forward|onincremental-repeat-search-backward|onincremental-repeat-search-forward|onincremental-search-backward|onincremental-search-forward|ormal-about-screen|ormal-erase-is-backspace-mode|ormal-erase-is-backspace-setup-frame|ormal-mouse-startup-screen|ormal-no-mouse-startup-screen|ormal-splash-screen|ormal-top-level-add-subdirs-to-load-path|ormal-top-level-add-to-load-path|ormal-top-level|otany|otevery|otifications-on-action-signal|otifications-on-closed-signal|reconc|roff-backward-text-line|roff-comment-indent|roff-count-text-lines|roff-electric-mode|roff-electric-newline|roff-forward-text-line|roff-insert-comment-function|roff-mode|roff-outline-level|roff-view|set-difference|set-exclusive-or|slookup-host|slookup-mode|slookup|sm-certificate-part|sm-check-certificate|sm-check-plain-connection|sm-check-protocol|sm-check-tls-connection|sm-fingerprint-ok-p|sm-fingerprint|sm-format-certificate|sm-host-settings|sm-id|sm-level|sm-new-fingerprint-ok-p|sm-parse-subject|sm-query-user|sm-query|sm-read-settings|sm-remove-permanent-setting|sm-remove-temporary-setting|sm-save-host|sm-verify-connection|sm-warnings-ok-p|sm-write-settings|sublis|subst-if-not|subst-if|subst|substitute-if-not)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(?:nsubstitute-if|nsubstitute|nth-value|ntlm-ascii2unicode|ntlm-build-auth-request|ntlm-build-auth-response|ntlm-get-password-hashes|ntlm-md4hash|ntlm-smb-des-e-p16|ntlm-smb-des-e-p24|ntlm-smb-dohash|ntlm-smb-hash|ntlm-smb-owf-encrypt|ntlm-smb-passwd-hash|ntlm-smb-str-to-key|ntlm-string-lshift|ntlm-string-permute|ntlm-string-xor|ntlm-unicode2ascii|nullify-allout-prefix-data|number-at-point|number-to-register|nunion|nxml-enable-unicode-char-name-sets|nxml-glyph-display-string|nxml-mode|obj-of-class-p|objc-font-lock-keywords-2|objc-font-lock-keywords-3|objc-font-lock-keywords|objc-mode|object-add-to-list|object-assoc-list-safe|object-assoc-list|object-assoc|object-class-fast|object-class-name|object-class|object-name-string|object-name|object-of-class-p|object-p|object-print|object-remove-from-list|object-set-name-string|object-slots|object-write|occur-1|occur-accumulate-lines|occur-after-change-function|occur-cease-edit|occur-context-lines|occur-edit-mode|occur-engine-add-prefix|occur-engine-line|occur-engine|occur-find-match|occur-mode-display-occurrence|occur-mode-find-occurrence|occur-mode-goto-occurrence-other-window|occur-mode-goto-occurrence|occur-mode-mouse-goto|occur-mode|occur-next-error|occur-next|occur-prev|occur-read-primary-args|occur-rename-buffer|occur-revert-function|occur|octave--indent-new-comment-line|octave-add-log-current-defun|octave-beginning-of-defun|octave-beginning-of-line|octave-complete-symbol|octave-completing-read|octave-completion-at-point|octave-eldoc-function-signatures|octave-eldoc-function|octave-end-of-line|octave-eval-print-last-sexp|octave-fill-paragraph|octave-find-definition-default-filename|octave-find-definition|octave-font-lock-texinfo-comment|octave-function-file-comment|octave-function-file-p|octave-goto-function-definition|octave-help-mode|octave-help|octave-hide-process-buffer|octave-in-comment-p|octave-in-string-or-comment-p|octave-in-string-p|octave-indent-comment|octave-indent-defun|octave-indent-new-comment-line|octave-insert-defun|octave-kill-process|octave-lookfor|octave-looking-at-kw|octave-mark-block|octave-maybe-insert-continuation-string|octave-mode-menu|octave-mode|octave-next-code-line|octave-previous-code-line|octave-send-block|octave-send-buffer|octave-send-defun|octave-send-line|octave-send-region|octave-show-process-buffer|octave-skip-comment-forward|octave-smie-backward-token|octave-smie-forward-token|octave-smie-rules|octave-source-directories|octave-source-file|octave-submit-bug-report|octave-sync-function-file-names|octave-syntax-propertize-function|octave-syntax-propertize-sqs|octave-update-function-file-comment|oddp|opascal-block-start|opascal-char-token-at|opascal-charset-token-at|opascal-column-of|opascal-comment-block-end|opascal-comment-block-start|opascal-comment-content-start|opascal-comment-indent-of|opascal-composite-type-start|opascal-corrected-indentation|opascal-current-token|opascal-debug-goto-next-token|opascal-debug-goto-point|opascal-debug-goto-previous-token|opascal-debug-log|opascal-debug-show-current-string|opascal-debug-show-current-token|opascal-debug-token-string|opascal-debug-tokenize-buffer|opascal-debug-tokenize-region|opascal-debug-tokenize-window|opascal-else-start|opascal-enclosing-indent-of|opascal-ensure-buffer|opascal-explicit-token-at|opascal-fill-comment|opascal-find-current-body|opascal-find-current-def|opascal-find-current-xdef|opascal-find-unit-file|opascal-find-unit-in-directory|opascal-find-unit|opascal-group-end|opascal-group-start|opascal-in-token|opascal-indent-line|opascal-indent-of|opascal-is-block-after-expr-statement|opascal-is-directory|opascal-is-file|opascal-is-literal-end|opascal-is-simple-class-type|opascal-is-use-clause-end|opascal-is|opascal-line-indent-of|opascal-literal-end-pattern|opascal-literal-kind|opascal-literal-start-pattern|opascal-literal-stop-pattern|opascal-literal-token-at|opascal-log-msg|opascal-looking-at-string|opascal-match-token|opascal-mode|opascal-new-comment-line|opascal-next-line-start|opascal-next-token|opascal-next-visible-token|opascal-on-first-comment-line|opascal-open-group-indent|opascal-point-token-at|opascal-previous-indent-of|opascal-previous-token|opascal-progress-done|opascal-progress-start|opascal-save-excursion|opascal-search-directory|opascal-section-indent-of|opascal-set-token-end|opascal-set-token-kind|opascal-set-token-start|opascal-space-token-at|opascal-step-progress|opascal-stmt-line-indent-of|opascal-string-of|opascal-tab|opascal-token-at|opascal-token-end|opascal-token-kind|opascal-token-of|opascal-token-start|opascal-token-string|opascal-word-token-at|open-font|open-gnutls-stream|open-line|open-protocol-stream|open-rectangle-line|open-rectangle|open-tls-stream|operate-on-rectangle|optimize-char-table|oref-default|oref|org-2ft|org-N-empty-lines-before-current|org-activate-angle-links|org-activate-bracket-links|org-activate-code|org-activate-dates|org-activate-footnote-links|org-activate-mark|org-activate-plain-links|org-activate-tags|org-activate-target-links|org-adaptive-fill-function|org-add-angle-brackets|org-add-archive-files|org-add-hook|org-add-link-props|org-add-link-type|org-add-log-note|org-add-log-setup|org-add-note|org-add-planning-info|org-add-prop-inherited|org-add-props|org-advertized-archive-subtree|org-agenda-check-for-timestamp-as-reason-to-ignore-todo-item|org-agenda-columns|org-agenda-file-p|org-agenda-file-to-front|org-agenda-files|org-agenda-list-stuck-projects|org-agenda-list|org-agenda-prepare-buffers|org-agenda-set-restriction-lock|org-agenda-to-appt|org-agenda|org-align-all-tags|org-align-tags-here|org-all-targets|org-apply-on-list|org-apps-regexp-alist|org-archive-subtree-default-with-confirmation|org-archive-subtree-default|org-archive-subtree|org-archive-to-archive-sibling|org-ascii-export-as-ascii|org-ascii-export-to-ascii|org-ascii-publish-to-ascii|org-ascii-publish-to-latin1|org-ascii-publish-to-utf8|org-assign-fast-keys|org-at-TBLFM-p|org-at-block-p|org-at-clock-log-p|org-at-comment-p|org-at-date-range-p|org-at-drawer-p|org-at-heading-or-item-p|org-at-heading-p|org-at-item-bullet-p|org-at-item-checkbox-p|org-at-item-counter-p|org-at-item-description-p|org-at-item-p|org-at-item-timer-p|org-at-property-p|org-at-regexp-p|org-at-table-hline-p|org-at-table-p|org-at-table\\\\.el-p|org-at-target-p|org-at-timestamp-p|org-attach|org-auto-fill-function|org-auto-repeat-maybe|org-babel--shell-command-on-region|org-babel-active-location-p|org-babel-balanced-split|org-babel-check-confirm-evaluate|org-babel-check-evaluate|org-babel-check-src-block|org-babel-chomp|org-babel-combine-header-arg-lists|org-babel-comint-buffer-livep|org-babel-comint-eval-invisibly-and-wait-for-file|org-babel-comint-in-buffer|org-babel-comint-input-command|org-babel-comint-wait-for-output|org-babel-comint-with-output|org-babel-confirm-evaluate|org-babel-current-result-hash|org-babel-del-hlines|org-babel-demarcate-block|org-babel-describe-bindings|org-babel-detangle|org-babel-disassemble-tables|org-babel-do-in-edit-buffer|org-babel-do-key-sequence-in-edit-buffer|org-babel-do-load-languages|org-babel-edit-distance|org-babel-enter-header-arg-w-completion|org-babel-eval-error-notify|org-babel-eval-read-file|org-babel-eval-wipe-error-buffer|org-babel-eval|org-babel-examplize-region|org-babel-execute-buffer|org-babel-execute-maybe|org-babel-execute-safely-maybe|org-babel-execute-src-block-maybe|org-babel-execute-src-block|org-babel-execute-subtree|org-babel-execute:emacs-lisp|org-babel-exp-code|org-babel-exp-do-export|org-babel-exp-get-export-buffer|org-babel-exp-in-export-file|org-babel-exp-process-buffer|org-babel-exp-results|org-babel-exp-src-block|org-babel-expand-body:emacs-lisp|org-babel-expand-body:generic|org-babel-expand-noweb-references|org-babel-expand-src-block-maybe|org-babel-expand-src-block|org-babel-find-file-noselect-refresh|org-babel-find-named-block|org-babel-find-named-result|org-babel-format-result|org-babel-get-colnames|org-babel-get-header|org-babel-get-inline-src-block-matches|org-babel-get-lob-one-liner-matches|org-babel-get-rownames|org-babel-get-src-block-info|org-babel-goto-named-result|org-babel-goto-named-src-block|org-babel-goto-src-block-head|org-babel-hash-at-point|org-babel-header-arg-expand|org-babel-hide-all-hashes|org-babel-hide-hash|org-babel-hide-result-toggle-maybe|org-babel-hide-result-toggle|org-babel-import-elisp-from-file|org-babel-in-example-or-verbatim|org-babel-initiate-session|org-babel-insert-header-arg|org-babel-insert-result|org-babel-join-splits-near-ch|org-babel-load-file|org-babel-load-in-session-maybe|org-babel-load-in-session|org-babel-lob-execute-maybe|org-babel-lob-execute|org-babel-lob-get-info|org-babel-lob-ingest|org-babel-local-file-name|org-babel-map-call-lines|org-babel-map-executables|org-babel-map-inline-src-blocks|org-babel-map-src-blocks|org-babel-mark-block|org-babel-merge-params|org-babel-named-data-regexp-for-name|org-babel-named-src-block-regexp-for-name|org-babel-next-src-block|org-babel-noweb-p|org-babel-noweb-wrap|org-babel-number-p|org-babel-open-src-block-result|org-babel-params-from-properties|org-babel-parse-header-arguments|org-babel-parse-inline-src-block-match|org-babel-parse-multiple-vars|org-babel-parse-src-block-match|org-babel-pick-name|org-babel-pop-to-session-maybe|org-babel-pop-to-session|org-babel-previous-src-block|org-babel-process-file-name|org-babel-process-params|org-babel-put-colnames|org-babel-put-rownames|org-babel-read-link|org-babel-read-list|org-babel-read-result|org-babel-read-table|org-babel-read|org-babel-reassemble-table|org-babel-ref-at-ref-p|org-babel-ref-goto-headline-id|org-babel-ref-headline-body|org-babel-ref-index-list|org-babel-ref-parse|org-babel-ref-resolve|org-babel-ref-split-args|org-babel-remove-result|org-babel-remove-temporary-directory|org-babel-result-cond|org-babel-result-end|org-babel-result-hide-all|org-babel-result-hide-spec|org-babel-result-names|org-babel-result-to-file|org-babel-script-escape|org-babel-set-current-result-hash|org-babel-sha1-hash|org-babel-show-result-all|org-babel-spec-to-string|org-babel-speed-command-activate|org-babel-speed-command-hook|org-babel-src-block-names|org-babel-string-read|org-babel-switch-to-session-with-code|org-babel-switch-to-session|org-babel-table-truncate-at-newline|org-babel-tangle-clean|org-babel-tangle-collect-blocks|org-babel-tangle-comment-links|org-babel-tangle-file|org-babel-tangle-jump-to-org|org-babel-tangle-publish|org-babel-tangle-single-block|org-babel-tangle|org-babel-temp-file|org-babel-tramp-handle-call-process-region|org-babel-trim|org-babel-update-block-body|org-babel-view-src-block-info|org-babel-when-in-src-block|org-babel-where-is-src-block-head|org-babel-where-is-src-block-result|org-babel-with-temp-filebuffer|org-back-over-empty-lines|org-back-to-heading|org-backward-element|org-backward-heading-same-level|org-backward-paragraph|org-backward-sentence|org-base-buffer|org-batch-agenda-csv|org-batch-agenda|org-batch-store-agenda-views|org-bbdb-anniversaries|org-beamer-export-as-latex|org-beamer-export-to-latex|org-beamer-export-to-pdf|org-beamer-insert-options-template|org-beamer-mode|org-beamer-publish-to-latex|org-beamer-publish-to-pdf|org-beamer-select-environment|org-before-change-function|org-before-first-heading-p|org-beginning-of-dblock|org-beginning-of-item-list|org-beginning-of-item|org-beginning-of-line|org-between-regexps-p|org-block-map|org-block-todo-from-checkboxes|org-block-todo-from-children-or-siblings-or-parent|org-bookmark-jump-unhide|org-bound-and-true-p|org-buffer-list|org-buffer-narrowed-p|org-buffer-property-keys|org-cached-entry-get|org-calendar-goto-agenda|org-calendar-holiday|org-calendar-select-mouse|org-calendar-select|org-call-for-shift-select|org-call-with-arg|org-called-interactively-p|org-capture-import-remember-templates|org-capture-string|org-capture|org-cdlatex-math-modify|org-cdlatex-mode|org-cdlatex-underscore-caret|org-change-tag-in-region|org-char-to-string|org-check-after-date|org-check-agenda-file|org-check-and-save-marker|org-check-before-date|org-check-before-invisible-edit|org-check-dates-range|org-check-deadlines|org-check-external-command|org-check-for-hidden|org-check-running-clock|org-check-version|org-clean-visibility-after-subtree-move|org-clock-cancel|org-clock-display|org-clock-get-clocktable|org-clock-goto|org-clock-in-last|org-clock-in|org-clock-is-active|org-clock-out|org-clock-persistence-insinuate|org-clock-remove-overlays|org-clock-report|org-clock-sum|org-clock-update-time-maybe|org-clocktable-shift|org-clocktable-try-shift|org-clone-local-variables)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)org-(?:clone-subtree-with-time-shift|closest-date|columns-compute|columns-get-format-and-top-level|columns-number-to-string|columns-remove-overlays|columns|combine-plists|command-at-point|comment-line-break-function|comment-or-uncomment-region|compatible-face|complete-expand-structure-template|completing-read-no-i|completing-read|compute-latex-and-related-regexp|compute-property-at-point|content|context-p|context|contextualize-keys|contextualize-validate-key|convert-to-odd-levels|convert-to-oddeven-levels|copy-face|copy-special|copy-subtree|copy-visible|copy|count-lines|count|create-customize-menu|create-dblock|create-formula--latex-header|create-formula-image-with-dvipng|create-formula-image-with-imagemagick|create-formula-image|create-math-formula|create-multibrace-regexp|ctrl-c-ctrl-c|ctrl-c-minus|ctrl-c-ret|ctrl-c-star|current-effective-time|current-level|current-line-string|current-line|current-time|cursor-to-region-beginning|customize|cut-special|cut-subtree|cycle-agenda-files|cycle-hide-archived-subtrees|cycle-hide-drawers|cycle-hide-inline-tasks|cycle-internal-global|cycle-internal-local|cycle-item-indentation|cycle-level|cycle-list-bullet|cycle-show-empty-lines|cycle|date-from-calendar|date-to-gregorian|datetree-find-date-create|days-to-iso-week|days-to-time|dblock-update|dblock-write:clocktable|dblock-write:columnview|deadline-close|deadline|decompose-region|default-apps|defkey|defvaralias|delete-all|delete-backward-char|delete-char|delete-directory|delete-property-globally|delete-property|demote-subtree|demote|detach-overlay|diary-sexp-entry|diary-to-ical-string|diary|display-custom-time|display-inline-images|display-inline-modification-hook|display-inline-remove-overlay|display-outline-path|display-warning|do-demote|do-emphasis-faces|do-latex-and-related|do-occur|do-promote|do-remove-indentation|do-sort|do-wrap|down-element|drag-element-backward|drag-element-forward|drag-line-backward|drag-line-forward|duration-string-to-minutes|dvipng-color-format|dvipng-color|edit-agenda-file-list|edit-fixed-width-region|edit-special|edit-src-abort|edit-src-code|edit-src-continue|edit-src-exit|edit-src-find-buffer|edit-src-find-region-and-lang|edit-src-get-indentation|edit-src-get-label-format|edit-src-get-lang|edit-src-save|element-at-point|element-context|element-interpret-data|email-link-description|emphasize|end-of-item-list|end-of-item|end-of-line|end-of-meta-data-and-drawers|end-of-subtree|entities-create-table|entities-help|entity-get-representation|entity-get|entity-latex-math-p|entry-add-to-multivalued-property|entry-beginning-position|entry-blocked-p|entry-delete|entry-end-position|entry-get-multivalued-property|entry-get-with-inheritance|entry-get|entry-is-done-p|entry-is-todo-p|entry-member-in-multivalued-property|entry-properties|entry-protect-space|entry-put-multivalued-property|entry-put|entry-remove-from-multivalued-property|entry-restore-space|escape-code-in-region|escape-code-in-string|eval-in-calendar|eval-in-environment|eval|evaluate-time-range|every|export-as|export-dispatch|export-insert-default-template|export-replace-region-by|export-string-as|export-to-buffer|export-to-file|extract-attributes|extract-log-state-settings|face-from-face-or-color|fast-tag-insert|fast-tag-selection|fast-tag-show-exit|fast-todo-selection|feed-goto-inbox|feed-show-raw-feed|feed-update-all|feed-update|file-apps-entry-match-against-dlink-p|file-complete-link|file-contents|file-equal-p|file-image-p|file-menu-entry|file-remote-p|files-list|fill-line-break-nobreak-p|fill-paragraph-with-timestamp-nobreak-p|fill-paragraph|fill-template|find-base-buffer-visiting|find-dblock|find-entry-with-id|find-exact-heading-in-directory|find-exact-headline-in-buffer|find-file-at-mouse|find-if|find-invisible-foreground|find-invisible|find-library-dir|find-olp|find-overlays|find-text-property-in-string|find-visible|first-headline-recenter|first-sibling-p|fit-window-to-buffer|fix-decoded-time|fix-indentation|fix-position-after-promote|fix-tags-on-the-fly|fixup-indentation|fixup-message-id-for-http|flag-drawer|flag-heading|flag-subtree|float-time|floor\\\\*|follow-timestamp-link|font-lock-add-priority-faces|font-lock-add-tag-faces|font-lock-ensure|font-lock-hook|fontify-entities|fontify-like-in-org-mode|fontify-meta-lines-and-blocks-1|fontify-meta-lines-and-blocks|footnote-action|footnote-all-labels|footnote-at-definition-p|footnote-at-reference-p|footnote-auto-adjust-maybe|footnote-create-definition|footnote-delete-definitions|footnote-delete-references|footnote-delete|footnote-get-definition|footnote-get-next-reference|footnote-goto-definition|footnote-goto-local-insertion-point|footnote-goto-previous-reference|footnote-in-valid-context-p|footnote-new|footnote-next-reference-or-definition|footnote-normalize-label|footnote-normalize|footnote-renumber-fn:N|footnote-unique-label|force-cycle-archived|force-self-insert|format-latex-as-mathml|format-latex-mathml-available-p|format-latex|format-outline-path|format-seconds|forward-element|forward-heading-same-level|forward-paragraph|forward-sentence|get-agenda-file-buffer|get-alist-option|get-at-bol|get-buffer-for-internal-link|get-buffer-tags|get-category|get-checkbox-statistics-face|get-compact-tod|get-cursor-date|get-date-from-calendar|get-deadline-time|get-entry|get-export-keywords|get-heading|get-indentation|get-indirect-buffer|get-last-sibling|get-level-face|get-limited-outline-regexp|get-local-tags-at|get-local-tags|get-local-variables|get-location|get-next-sibling|get-org-file|get-outline-path|get-packages-alist|get-previous-line-level|get-priority|get-property-block|get-repeat|get-scheduled-time|get-string-indentation|get-tag-face|get-tags-at|get-tags-string|get-tags|get-todo-face|get-todo-sequence-head|get-todo-state|get-valid-level|get-wdays|get-x-clipboard-compat|get-x-clipboard|git-version|global-cycle|global-tags-completion-table|goto-calendar|goto-first-child|goto-left|goto-line|goto-local-auto-isearch|goto-local-search-headings|goto-map|goto-marker-or-bmk|goto-quit|goto-ret|goto-right|goto-sibling|goto|heading-components|hh:mm-string-to-minutes|hidden-tree-error|hide-archived-subtrees|hide-block-all|hide-block-toggle-all|hide-block-toggle-maybe|hide-block-toggle|hide-wide-columns|highlight-new-match|hours-to-clocksum-string|html-convert-region-to-html|html-export-as-html|html-export-to-html|html-htmlize-generate-css|html-publish-to-html|icalendar-combine-agenda-files|icalendar-export-agenda-files|icalendar-export-to-ics|icompleting-read|id-copy|id-find-id-file|id-find|id-get-create|id-get-with-outline-drilling|id-get-with-outline-path-completion|id-get|id-goto|id-new|id-store-link|id-update-id-locations|ido-switchb|image-file-name-regexp|imenu-get-tree|imenu-new-marker|in-block-p|in-clocktable-p|in-commented-line|in-drawer-p|in-fixed-width-region-p|in-indented-comment-line|in-invisibility-spec-p|in-item-p|in-regexp|in-src-block-p|in-subtree-not-table-p|in-verbatim-emphasis|inc-effort|indent-block|indent-drawer|indent-item-tree|indent-item|indent-line-to|indent-line|indent-mode|indent-region|indent-to-column|info|inhibit-invisibility|insert-all-links|insert-columns-dblock|insert-comment|insert-drawer|insert-heading-after-current|insert-heading-respect-content|insert-heading|insert-item|insert-link-global|insert-link|insert-property-drawer|insert-subheading|insert-time-stamp|insert-todo-heading-respect-content|insert-todo-heading|insert-todo-subheading|inside-LaTeX-fragment-p|inside-latex-macro-p|install-agenda-files-menu|invisible-p2|irc-store-link|iread-file-name|isearch-end|isearch-post-command|iswitchb-completing-read|iswitchb|item-beginning-re|item-re|key|kill-is-subtree-p|kill-line|kill-new|kill-note-or-show-branches|last|latex-color-format|latex-color|latex-convert-region-to-latex|latex-export-as-latex|latex-export-to-latex|latex-export-to-pdf|latex-packages-to-string|latex-publish-to-latex|latex-publish-to-pdf|let2??|level-increment|link-display-format|link-escape|link-expand-abbrev|link-fontify-links-to-this-file|link-prettify|link-search|link-try-special-completion|link-unescape-compound|link-unescape-single-byte-sequence|link-unescape|list-at-regexp-after-bullet-p|list-bullet-string|list-context|list-delete-item|list-get-all-items|list-get-bottom-point|list-get-bullet|list-get-checkbox|list-get-children|list-get-counter|list-get-first-item|list-get-ind|list-get-item-begin|list-get-item-end-before-blank|list-get-item-end|list-get-item-number|list-get-last-item|list-get-list-begin|list-get-list-end|list-get-list-type|list-get-next-item|list-get-nth|list-get-parent|list-get-prev-item|list-get-subtree|list-get-tag|list-get-top-point|list-has-child-p|list-in-valid-context-p|list-inc-bullet-maybe|list-indent-item-generic|list-insert-item|list-insert-radio-list|list-item-body-column|list-item-trim-br|list-make-subtree|list-parents-alist|list-prevs-alist|list-repair|list-search-backward|list-search-forward|list-search-generic|list-send-item|list-send-list|list-separating-blank-lines-number|list-set-bullet|list-set-checkbox|list-set-ind|list-set-item-visibility|list-set-nth|list-struct-apply-struct|list-struct-assoc-end|list-struct-fix-box|list-struct-fix-bul|list-struct-fix-ind|list-struct-fix-item-end|list-struct-indent|list-struct-outdent|list-swap-items|list-to-generic|list-to-html|list-to-latex|list-to-subtree|list-to-texinfo|list-use-alpha-bul-p|list-write-struct|load-modules-maybe|load-noerror-mustsuffix|local-logging|log-into-drawer|looking-at-p|looking-back|macro--collect-macros|macro-expand|macro-initialize-templates|macro-replace-all|make-link-regexps|make-link-string|make-options-regexp|make-org-heading-search-string|make-parameter-alist|make-tags-matcher|make-target-link-regexp|make-tdiff-string|map-dblocks|map-entries|map-region|map-tree|mark-element|mark-ring-goto|mark-ring-push|mark-subtree|match-any-p|match-line|match-sparse-tree|match-string-no-properties|matcher-time|maybe-intangible|md-convert-region-to-md|md-export-as-markdown|md-export-to-markdown|meta-return|metadown|metaleft|metaright|metaup|minutes-to-clocksum-string|minutes-to-hh:mm-string|mobile-pull|mobile-push|mode-flyspell-verify|mode-restart|mode|modifier-cursor-error)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(?:org-modify-ts-extra|org-move-item-down|org-move-item-up|org-move-subtree-down|org-move-subtree-up|org-move-to-column|org-narrow-to-block|org-narrow-to-element|org-narrow-to-subtree|org-next-block|org-next-item|org-next-link|org-no-popups|org-no-properties|org-no-read-only|org-no-warnings|org-normalize-color|org-not-nil|org-notes-order-reversed-p|org-number-sequence|org-occur-in-agenda-files|org-occur-link-in-agenda-files|org-occur-next-match|org-occur|org-odt-convert|org-odt-export-as-odf-and-open|org-odt-export-as-odf|org-odt-export-to-odt|org-offer-links-in-entry|org-olpath-completing-read|org-on-heading-p|org-on-target-p|org-op-to-function|org-open-at-mouse|org-open-at-point-global|org-open-at-point|org-open-file-with-emacs|org-open-file-with-system|org-open-file|org-open-line|org-open-link-from-string|org-optimize-window-after-visibility-change|org-order-calendar-date-args|org-org-export-as-org|org-org-export-to-org|org-org-menu|org-org-publish-to-org|org-outdent-item-tree|org-outdent-item|org-outline-level|org-outline-overlay-data|org-overlay-before-string|org-overlay-display|org-overview|org-parse-arguments|org-parse-time-string|org-paste-special|org-paste-subtree|org-pcomplete-case-double|org-pcomplete-initial|org-plist-delete|org-plot/gnuplot|org-point-at-end-of-empty-headline|org-point-in-group|org-pop-to-buffer-same-window|org-pos-in-match-range|org-prepare-dblock|org-preserve-lc|org-preview-latex-fragment|org-previous-block|org-previous-item|org-previous-line-empty-p|org-previous-link|org-print-speed-command|org-priority-down|org-priority-up|org-priority|org-promote-subtree|org-promote|org-propertize|org-property-action|org-property-get-allowed-values|org-property-inherit-p|org-property-next-allowed-value|org-property-or-variable-value|org-property-previous-allowed-value|org-property-values|org-protect-slash|org-publish-all|org-publish-current-file|org-publish-current-project|org-publish-project|org-publish|org-quote-csv-field|org-quote-vert|org-raise-scripts|org-re-property|org-re-timestamp|org-re|org-read-agenda-file-list|org-read-date-analyze|org-read-date-display|org-read-date-get-relative|org-read-date|org-read-property-name|org-read-property-value|org-rear-nonsticky-at|org-recenter-calendar|org-redisplay-inline-images|org-reduce|org-reduced-level|org-refile--get-location|org-refile-cache-check-set|org-refile-cache-clear|org-refile-cache-get|org-refile-cache-put|org-refile-check-position|org-refile-get-location|org-refile-get-targets|org-refile-goto-last-stored|org-refile-marker|org-refile-new-child|org-refile|org-refresh-category-properties|org-refresh-properties|org-reftex-citation|org-region-active-p|org-reinstall-markers-in-region|org-release-buffers|org-release|org-reload|org-remap|org-remove-angle-brackets|org-remove-double-quotes|org-remove-empty-drawer-at|org-remove-empty-overlays-at|org-remove-file|org-remove-flyspell-overlays-in|org-remove-font-lock-display-properties|org-remove-from-invisibility-spec|org-remove-if-not|org-remove-if|org-remove-indentation|org-remove-inline-images|org-remove-keyword-keys|org-remove-latex-fragment-image-overlays|org-remove-occur-highlights|org-remove-tabs|org-remove-timestamp-with-keyword|org-remove-uninherited-tags|org-replace-escapes|org-replace-match-keep-properties|org-require-autoloaded-modules|org-reset-checkbox-state-subtree|org-resolve-clocks|org-restart-font-lock|org-return-indent|org-return|org-reveal|org-reverse-string|org-revert-all-org-buffers|org-run-like-in-org-mode|org-save-all-org-buffers|org-save-markers-in-region|org-save-outline-visibility|org-sbe|org-scan-tags|org-schedule|org-search-not-self|org-search-view|org-select-frame-set-input-focus|org-self-insert-command|org-set-current-tags-overlay|org-set-effort|org-set-emph-re|org-set-font-lock-defaults|org-set-frame-title|org-set-local|org-set-modules|org-set-outline-overlay-data|org-set-packages-alist|org-set-property-and-value|org-set-property-function|org-set-property|org-set-regexps-and-options-for-tags|org-set-regexps-and-options|org-set-startup-visibility|org-set-tag-faces|org-set-tags-command|org-set-tags-to|org-set-tags|org-set-transient-map|org-set-visibility-according-to-property|org-setup-comments-handling|org-setup-filling|org-shiftcontroldown|org-shiftcontrolleft|org-shiftcontrolright|org-shiftcontrolup|org-shiftdown|org-shiftleft|org-shiftmetadown|org-shiftmetaleft|org-shiftmetaright|org-shiftmetaup|org-shiftright|org-shiftselect-error|org-shifttab|org-shiftup|org-shorten-string|org-show-block-all|org-show-context|org-show-empty-lines-in-parent|org-show-entry|org-show-hidden-entry|org-show-priority|org-show-siblings|org-show-subtree|org-show-todo-tree|org-skip-over-state-notes|org-skip-whitespace|org-small-year-to-year|org-some|org-sort-entries|org-sort-list|org-sort-remove-invisible|org-sort|org-sparse-tree|org-speed-command-activate|org-speed-command-default-hook|org-speed-command-help|org-speed-move-safe|org-speedbar-set-agenda-restriction|org-splice-latex-header|org-split-string|org-src-associate-babel-session|org-src-babel-configure-edit-buffer|org-src-construct-edit-buffer-name|org-src-do-at-code-block|org-src-do-key-sequence-at-code-block|org-src-edit-buffer-p|org-src-font-lock-fontify-block|org-src-fontify-block|org-src-fontify-buffer|org-src-get-lang-mode|org-src-in-org-buffer|org-src-mode-configure-edit-buffer|org-src-mode|org-src-native-tab-command-maybe|org-src-switch-to-buffer|org-src-tangle|org-store-agenda-views|org-store-link-props|org-store-link|org-store-log-note|org-store-new-agenda-file-list|org-string-match-p|org-string-nw-p|org-string-width|org-string<=|org-string<>|org-string>=??|org-sublist|org-submit-bug-report|org-substitute-posix-classes|org-subtree-end-visible-p|org-switch-to-buffer-other-window|org-switchb|org-table-align|org-table-begin|org-table-blank-field|org-table-convert-region|org-table-convert|org-table-copy-down|org-table-copy-region|org-table-create-or-convert-from-region|org-table-create-with-table\\\\.el|org-table-create|org-table-current-dline|org-table-cut-region|org-table-delete-column|org-table-edit-field|org-table-edit-formulas|org-table-end|org-table-eval-formula|org-table-export|org-table-field-info|org-table-get-stored-formulas|org-table-goto-column|org-table-hline-and-move|org-table-import|org-table-insert-column|org-table-insert-hline|org-table-insert-row|org-table-iterate-buffer-tables|org-table-iterate|org-table-justify-field-maybe|org-table-kill-row|org-table-map-tables|org-table-maybe-eval-formula|org-table-maybe-recalculate-line|org-table-move-column-left|org-table-move-column-right|org-table-move-column|org-table-move-row-down|org-table-move-row-up|org-table-move-row|org-table-next-field|org-table-next-row|org-table-p|org-table-paste-rectangle|org-table-previous-field|org-table-recalculate-buffer-tables|org-table-recalculate|org-table-recognize-table\\\\.el|org-table-rotate-recalc-marks|org-table-set-constants|org-table-sort-lines|org-table-sum|org-table-to-lisp|org-table-toggle-coordinate-overlays|org-table-toggle-formula-debugger|org-table-wrap-region|org-tag-inherit-p|org-tags-completion-function|org-tags-expand|org-tags-sparse-tree|org-tags-view|org-tbl-menu|org-texinfo-convert-region-to-texinfo|org-texinfo-publish-to-texinfo|org-thing-at-point|org-time-from-absolute|org-time-stamp-format|org-time-stamp-inactive|org-time-stamp-to-now|org-time-stamp|org-time-string-to-absolute|org-time-string-to-seconds|org-time-string-to-time|org-time-today|org-time<=??|org-time<>|org-time=|org-time>=??|org-timer-change-times-in-region|org-timer-item|org-timer-set-timer|org-timer-start|org-timer|org-timestamp-change|org-timestamp-down-day|org-timestamp-down|org-timestamp-format|org-timestamp-has-time-p|org-timestamp-split-range|org-timestamp-translate|org-timestamp-up-day|org-timestamp-up|org-today|org-todo-list|org-todo-trigger-tag-changes|org-todo-yesterday|org-todo|org-toggle-archive-tag|org-toggle-checkbox|org-toggle-comment|org-toggle-custom-properties-visibility|org-toggle-fixed-width-section|org-toggle-heading|org-toggle-inline-images|org-toggle-item|org-toggle-link-display|org-toggle-ordered-property|org-toggle-pretty-entities|org-toggle-sticky-agenda|org-toggle-tag|org-toggle-tags-groups|org-toggle-time-stamp-overlays|org-toggle-timestamp-type|org-tr-level|org-translate-link-from-planner|org-translate-link|org-translate-time|org-transpose-element|org-transpose-words|org-tree-to-indirect-buffer|org-trim|org-truely-invisible-p|org-try-cdlatex-tab|org-try-structure-completion|org-unescape-code-in-region|org-unescape-code-in-string|org-unfontify-region|org-unindent-buffer|org-uniquify-alist|org-uniquify|org-unlogged-message|org-unmodified|org-up-element|org-up-heading-all|org-up-heading-safe|org-update-all-dblocks|org-update-checkbox-count-maybe|org-update-checkbox-count|org-update-dblock|org-update-parent-todo-statistics|org-update-property-plist|org-update-radio-target-regexp|org-update-statistics-cookies|org-uuidgen-p|org-version-check|org-version|org-with-gensyms|org-with-limited-levels|org-with-point-at|org-with-remote-undo|org-with-silent-modifications|org-with-wide-buffer|org-without-partial-completion|org-wrap|org-xemacs-without-invisibility|org-xor|org-yank-folding-would-swallow-text|org-yank-generic|org-yank|org<>|orgstruct\\\\+\\\\+-mode|orgstruct-error|orgstruct-make-binding|orgstruct-mode|orgstruct-setup|orgtbl-mode|orgtbl-to-csv|orgtbl-to-generic|orgtbl-to-html|orgtbl-to-latex|orgtbl-to-orgtbl|orgtbl-to-texinfo|orgtbl-to-tsv|oset-default|oset|other-frame|other-window-for-scrolling|outline-back-to-heading|outline-backward-same-level|outline-demote|outline-end-of-heading|outline-end-of-subtree|outline-flag-region|outline-flag-subtree|outline-font-lock-face|outline-forward-same-level|outline-get-last-sibling|outline-get-next-sibling|outline-head-from-level|outline-headers-as-kill|outline-insert-heading|outline-invent-heading|outline-invisible-p|outline-isearch-open-invisible|outline-level|outline-map-region|outline-mark-subtree|outline-minor-mode|outline-mode|outline-move-subtree-down|outline-move-subtree-up|outline-next-heading|outline-next-preface|outline-next-visible-heading|outline-on-heading-p|outline-previous-heading|outline-previous-visible-heading|outline-promote|outline-reveal-toggle-invisible|outline-show-heading|outline-toggle-children|outline-up-heading|outlineify-sticky|outlinify-sticky|overlay-lists|overload-docstring-extension|overload-obsoleted-by|overload-that-obsolete|package--ac-desc-extras--cmacro|package--ac-desc-extras|package--ac-desc-kind--cmacro|package--ac-desc-kind|package--ac-desc-reqs--cmacro|package--ac-desc-reqs|package--ac-desc-summary--cmacro|package--ac-desc-summary|package--ac-desc-version--cmacro|package--ac-desc-version|package--add-to-archive-contents|package--alist-to-plist-args|package--archive-file-exists-p|package--bi-desc-reqs--cmacro|package--bi-desc-reqs|package--bi-desc-summary--cmacro|package--bi-desc-summary|package--bi-desc-version--cmacro|package--bi-desc-version|package--check-signature|package--compile|package--description-file|package--display-verify-error|package--download-one-archive|package--from-builtin|package--has-keyword-p|package--list-loaded-files|package--make-autoloads-and-stuff|package--mapc|package--prepare-dependencies|package--push|package--read-archive-file|package--with-work-buffer|package--write-file-no-coding|package-activate-1|package-activate|package-all-keywords|package-archive-base|package-autoload-ensure-default-file|package-buffer-info|package-built-in-p|package-compute-transaction|package-delete|package-desc--keywords|package-desc-archive--cmacro|package-desc-archive|package-desc-create--cmacro|package-desc-create|package-desc-dir--cmacro|package-desc-dir|package-desc-extras--cmacro|package-desc-extras|package-desc-from-define|package-desc-full-name|package-desc-kind--cmacro|package-desc-kind|package-desc-name--cmacro|package-desc-name|package-desc-p--cmacro|package-desc-p|package-desc-reqs--cmacro|package-desc-reqs|package-desc-signed--cmacro|package-desc-signed|package-desc-status|package-desc-suffix|package-desc-summary--cmacro|package-desc-summary|package-desc-version--cmacro|package-desc-version|package-disabled-p|package-download-transaction|package-generate-autoloads|package-generate-description-file|package-import-keyring|package-install-button-action|package-install-file|package-install-from-archive)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)p(?:ackage-install-from-buffer|ackage-install|ackage-installed-p|ackage-keyword-button-action|ackage-list-packages-no-fetch|ackage-list-packages|ackage-load-all-descriptors|ackage-load-descriptor|ackage-make-ac-desc--cmacro|ackage-make-ac-desc|ackage-make-builtin--cmacro|ackage-make-builtin|ackage-make-button|ackage-menu--archive-predicate|ackage-menu--description-predicate|ackage-menu--find-upgrades|ackage-menu--generate|ackage-menu--name-predicate|ackage-menu--print-info|ackage-menu--refresh|ackage-menu--status-predicate|ackage-menu--version-predicate|ackage-menu-backup-unmark|ackage-menu-describe-package|ackage-menu-execute|ackage-menu-filter|ackage-menu-get-status|ackage-menu-mark-delete|ackage-menu-mark-install|ackage-menu-mark-obsolete-for-deletion|ackage-menu-mark-unmark|ackage-menu-mark-upgrades|ackage-menu-mode|ackage-menu-quick-help|ackage-menu-refresh|ackage-menu-view-commentary|ackage-process-define-package|ackage-read-all-archive-contents|ackage-read-archive-contents|ackage-read-from-string|ackage-refresh-contents|ackage-show-package-list|ackage-strip-rcs-id|ackage-tar-file-info|ackage-unpack|ackage-untar-buffer|ackage-version-join|ages-copy-header-and-position|ages-directory-address-mode|ages-directory-for-addresses|ages-directory-goto-with-mouse|ages-directory-goto|ages-directory-mode|ages-directory|airlis|aragraph-indent-minor-mode|aragraph-indent-text-mode|arse-iso8601-time-string|arse-time-string-chars|arse-time-string|arse-time-tokenize|ascal-beg-of-defun|ascal-build-defun-re|ascal-calculate-indent|ascal-capitalize-keywords|ascal-change-keywords|ascal-comment-area|ascal-comp-defun|ascal-complete-word|ascal-completion|ascal-completions-at-point|ascal-declaration-beg|ascal-declaration-end|ascal-downcase-keywords|ascal-end-of-defun|ascal-end-of-statement|ascal-func-completion|ascal-get-completion-decl|ascal-get-default-symbol|ascal-get-lineup-indent|ascal-goto-defun|ascal-hide-other-defuns|ascal-indent-case|ascal-indent-command|ascal-indent-comment|ascal-indent-declaration|ascal-indent-level|ascal-indent-line|ascal-indent-paramlist|ascal-insert-block|ascal-keyword-completion|ascal-mark-defun|ascal-mode|ascal-outline-change|ascal-outline-goto-defun|ascal-outline-mode|ascal-outline-next-defun|ascal-outline-prev-defun|ascal-outline|ascal-set-auto-comments|ascal-show-all|ascal-show-completions|ascal-star-comment|ascal-string-diff|ascal-type-completion|ascal-uncomment-area|ascal-upcase-keywords|ascal-var-completion|ascal-within-string|assword-cache-add|assword-cache-remove|assword-in-cache-p|assword-read-and-add|assword-read-from-cache|assword-read|assword-reset|case--and|case--app-subst-match|case--app-subst-rest|case--eval|case--expand|case--fgrep|case--flip|case--funcall|case--if|case--let\\\\*|case--macroexpand|case--mark-used|case--match|case--mutually-exclusive-p|case--self-quoting-p|case--small-branch-p|case--split-equal|case--split-match|case--split-member|case--split-pred|case--split-rest|case--trivial-upat-p|case--u1??|case-codegen|case-defmacro|case-dolist|case-exhaustive|case-let\\\\*?|complete/ack-grep|complete/ack|complete/ag|complete/bzip2|complete/cd|complete/chgrp|complete/chown|complete/cvs|complete/erc-mode/CLEARTOPIC|complete/erc-mode/CTCP|complete/erc-mode/DCC|complete/erc-mode/DEOP|complete/erc-mode/DESCRIBE|complete/erc-mode/IDLE|complete/erc-mode/KICK|complete/erc-mode/LEAVE|complete/erc-mode/LOAD|complete/erc-mode/ME|complete/erc-mode/MODE|complete/erc-mode/MSG|complete/erc-mode/NAMES|complete/erc-mode/NOTICE|complete/erc-mode/NOTIFY|complete/erc-mode/OP|complete/erc-mode/PART|complete/erc-mode/QUERY|complete/erc-mode/SAY|complete/erc-mode/SOUND|complete/erc-mode/TOPIC|complete/erc-mode/UNIGNORE|complete/erc-mode/WHOIS|complete/erc-mode/complete-command|complete/eshell-mode/eshell-debug|complete/eshell-mode/export|complete/eshell-mode/setq|complete/eshell-mode/unset|complete/gdb|complete/gzip|complete/kill|complete/make|complete/mount|complete/org-mode/block-option/clocktable|complete/org-mode/block-option/src|complete/org-mode/drawer|complete/org-mode/file-option/author|complete/org-mode/file-option/bind|complete/org-mode/file-option/date|complete/org-mode/file-option/email|complete/org-mode/file-option/exclude_tags|complete/org-mode/file-option/filetags|complete/org-mode/file-option/infojs_opt|complete/org-mode/file-option/language|complete/org-mode/file-option/options|complete/org-mode/file-option/priorities|complete/org-mode/file-option/select_tags|complete/org-mode/file-option/startup|complete/org-mode/file-option/tags|complete/org-mode/file-option/title|complete/org-mode/file-option|complete/org-mode/link|complete/org-mode/prop|complete/org-mode/searchhead|complete/org-mode/tag|complete/org-mode/tex|complete/org-mode/todo|complete/pushd|complete/rm|complete/rmdir|complete/rpm|complete/scp|complete/ssh|complete/tar|complete/time|complete/tlmgr|complete/umount|complete/which|complete/xargs|complete--common-suffix|complete--entries|complete--help|complete--here|complete--test|complete-actual-arg|complete-all-entries|complete-arg|complete-begin|complete-comint-setup|complete-command-name|complete-completions-at-point|complete-completions|complete-continue|complete-dirs-or-entries|complete-dirs|complete-do-complete|complete-entries|complete-erc-all-nicks|complete-erc-channels|complete-erc-command-name|complete-erc-commands|complete-erc-nicks|complete-erc-not-ops|complete-erc-ops|complete-erc-parse-arguments|complete-erc-setup|complete-event-matches-key-specifier-p|complete-executables|complete-expand-and-complete|complete-expand|complete-find-completion-function|complete-help|complete-here\\\\*?|complete-insert-entry|complete-list|complete-match-beginning|complete-match-end|complete-match-string|complete-match|complete-next-arg|complete-opt|complete-parse-arguments|complete-parse-buffer-arguments|complete-parse-comint-arguments|complete-process-result|complete-quote-argument|complete-read-event|complete-restore-windows|complete-reverse|complete-shell-setup|complete-show-completions|complete-std-complete|complete-stub|complete-test|complete-uniqify-list|complete-unquote-argument|complete|db|ending-delete-mode|erl-backward-to-noncomment|erl-backward-to-start-of-continued-exp|erl-beginning-of-function|erl-calculate-indent|erl-comment-indent|erl-continuation-line-p|erl-current-defun-name|erl-electric-noindent-p|erl-electric-terminator|erl-end-of-function|erl-font-lock-syntactic-face-function|erl-hanging-paren-p|erl-indent-command|erl-indent-exp|erl-indent-line|erl-indent-new-calculate|erl-mark-function|erl-mode|erl-outline-level|erl-quote-syntax-table|erl-syntax-propertize-function|erl-syntax-propertize-special-constructs|erldb|icture-backward-clear-column|icture-backward-column|icture-beginning-of-line|icture-clear-column|icture-clear-line|icture-clear-rectangle-to-register|icture-clear-rectangle|icture-current-line|icture-delete-char|icture-draw-rectangle|icture-duplicate-line|icture-end-of-line|icture-forward-column|icture-insert-rectangle|icture-insert|icture-mode-exit|icture-mode|icture-motion-reverse|icture-motion|icture-mouse-set-point|icture-move-down|icture-move-up|icture-move|icture-movement-down|icture-movement-left|icture-movement-ne|icture-movement-nw|icture-movement-right|icture-movement-se|icture-movement-sw|icture-movement-up|icture-newline|icture-open-line|icture-replace-match|icture-self-insert|icture-set-motion|icture-set-tab-stops|icture-snarf-rectangle|icture-tab-search|icture-tab|icture-update-desired-column|icture-yank-at-click|icture-yank-rectangle-from-register|icture-yank-rectangle|ike-font-lock-keywords-2|ike-font-lock-keywords-3|ike-font-lock-keywords|ike-mode|ing|lain-TeX-mode|lain-tex-mode|lay-sound-internal|lstore-delete|lstore-find|lstore-get-file|lstore-mode|lstore-open|lstore-put|lstore-save|lusp|o-find-charset|o-find-file-coding-system-guts|o-find-file-coding-system|oint-at-bol|oint-at-eol|oint-to-register|ong-display-options|ong-init-buffer|ong-init|ong-move-down|ong-move-left|ong-move-right|ong-move-up|ong-pause|ong-quit|ong-resume|ong-update-bat|ong-update-game|ong-update-score|ong|op-global-mark|op-tag-mark|op-to-buffer-same-window|op-to-mark-command|op3-movemail|opup-menu-normalize-position|opup-menu|osition-if-not|osition-if|osition|osn-set-point|ost-read-decode-hz|p-buffer|p-display-expression|p-eval-expression|p-eval-last-sexp|p-last-sexp|p-macroexpand-expression|p-macroexpand-last-sexp|p-to-string|r-alist-custom-set|r-article-date|r-auto-mode-p|r-call-process|r-choice-alist|r-command|r-complete-alist|r-create-interface|r-customize|r-delete-file-if-exists|r-delete-file|r-despool-preview|r-despool-print|r-despool-ps-print|r-despool-using-ghostscript|r-do-update-menus|r-dosify-file-name|r-eval-alist|r-eval-local-alist|r-eval-setting-alist|r-even-or-odd-pages|r-expand-file-name|r-file-list|r-find-buffer-visiting|r-find-command|r-get-symbol|r-global-menubar|r-gnus-lpr|r-gnus-print|r-help|r-i-directory|r-i-ps-send|r-insert-button|r-insert-checkbox|r-insert-italic|r-insert-menu|r-insert-radio-button|r-insert-section-1|r-insert-section-2|r-insert-section-3|r-insert-section-4|r-insert-section-5|r-insert-section-6|r-insert-section-7|r-insert-toggle|r-interactive-dir-args|r-interactive-dir|r-interactive-n-up-file|r-interactive-n-up-inout|r-interactive-n-up|r-interactive-ps-dir-args|r-interactive-regexp|r-interface-directory|r-interface-help|r-interface-infile|r-interface-outfile|r-interface-preview|r-interface-printify|r-interface-ps-print|r-interface-ps|r-interface-quit|r-interface-save|r-interface-txt-print|r-interface|r-keep-region-active|r-kill-help|r-kill-local-variable|r-local-variable|r-lpr-message-from-summary|r-menu-alist|r-menu-bind|r-menu-char-height|r-menu-char-width|r-menu-create|r-menu-get-item|r-menu-index|r-menu-lock|r-menu-lookup|r-menu-position|r-menu-set-item-name|r-menu-set-ps-title|r-menu-set-txt-title|r-menu-set-utility-title|r-mh-current-message|r-mh-lpr-1|r-mh-lpr-2|r-mh-print-1|r-mh-print-2|r-mode-alist-p|r-mode-lpr|r-mode-print|r-path-command|r-printify-buffer|r-printify-directory|r-printify-region|r-prompt-gs|r-prompt-region|r-prompt|r-ps-buffer-preview|r-ps-buffer-print|r-ps-buffer-ps-print|r-ps-buffer-using-ghostscript|r-ps-directory-preview|r-ps-directory-print|r-ps-directory-ps-print|r-ps-directory-using-ghostscript|r-ps-fast-fire|r-ps-file-list|r-ps-file-preview|r-ps-file-print|r-ps-file-ps-print|r-ps-file-up-preview|r-ps-file-up-ps-print|r-ps-file-using-ghostscript|r-ps-file|r-ps-infile-preprint|r-ps-message-from-summary|r-ps-mode-preview|r-ps-mode-print|r-ps-mode-ps-print|r-ps-mode-using-ghostscript|r-ps-mode|r-ps-name-custom-set|r-ps-name|r-ps-outfile-preprint|r-ps-preview|r-ps-print|r-ps-region-preview|r-ps-region-print|r-ps-region-ps-print|r-ps-region-using-ghostscript|r-ps-set-printer|r-ps-set-utility|r-ps-using-ghostscript|r-ps-utility-args|r-ps-utility-custom-set|r-ps-utility-process|r-ps-utility|r-read-string|r-region-active-p|r-region-active-string|r-region-active-symbol|r-remove-nil-from-list|r-rmail-lpr|r-rmail-print|r-save-file-modes|r-set-dir-args|r-set-keymap-name|r-set-keymap-parents|r-set-n-up-and-filename|r-set-outfilename|r-set-ps-dir-args|r-setup|r-show-lpr-setup|r-show-pr-setup|r-show-ps-setup|r-show-setup|r-standard-file-name|r-switches-string|r-switches|r-text2ps|r-toggle-duplex-menu|r-toggle-duplex|r-toggle-faces-menu|r-toggle-faces|r-toggle-file-duplex-menu|r-toggle-file-duplex)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)p(?:r-toggle-file-landscape-menu|r-toggle-file-landscape|r-toggle-file-tumble-menu|r-toggle-file-tumble|r-toggle-ghostscript-menu|r-toggle-ghostscript|r-toggle-header-frame-menu|r-toggle-header-frame|r-toggle-header-menu|r-toggle-header|r-toggle-landscape-menu|r-toggle-landscape|r-toggle-line-menu|r-toggle-line|r-toggle-lock-menu|r-toggle-lock|r-toggle-mode-menu|r-toggle-mode|r-toggle-region-menu|r-toggle-region|r-toggle-spool-menu|r-toggle-spool|r-toggle-tumble-menu|r-toggle-tumble|r-toggle-upside-down-menu|r-toggle-upside-down|r-toggle-zebra-menu|r-toggle-zebra|r-toggle|r-txt-buffer|r-txt-directory|r-txt-fast-fire|r-txt-mode|r-txt-name-custom-set|r-txt-name|r-txt-print|r-txt-region|r-txt-set-printer|r-unixify-file-name|r-update-checkbox|r-update-menus|r-update-mode-line|r-update-radio-button|r-update-var|r-using-ghostscript-p|r-visible-p|r-vm-lpr|r-vm-print|r-widget-field-action|re-write-encode-hz|receding-sexp|refer-coding-system|repare-abbrev-list-buffer|repend-to-buffer|repend-to-register|rettify-symbols--compose-symbol|rettify-symbols--make-keywords|rettify-symbols-mode-set-explicitly|rettify-symbols-mode|revious-buffer|revious-completion|revious-error-no-select|revious-error|revious-ifdef|revious-line-or-history-element|revious-line|revious-logical-line|revious-multiframe-window|revious-page|rin1-char|rinc-list|rint-buffer|rint-help-return-message|rint-region-1|rint-region-new-buffer|rint-region|rintify-region|roced-<|roced-auto-update-timer|roced-children-alist|roced-children-pids|roced-do-mark-all|roced-do-mark|roced-filter-children|roced-filter-interactive|roced-filter-parents|roced-filter|roced-format-args|roced-format-interactive|roced-format-start|roced-format-time|roced-format-tree|roced-format-ttname|roced-format|roced-header-line|roced-help|roced-insert-mark|roced-log-summary|roced-log|roced-mark-all|roced-mark-children|roced-mark-parents|roced-mark-process-alist|roced-mark|roced-marked-processes|roced-marker-regexp|roced-menu|roced-mode|roced-move-to-goal-column|roced-omit-process|roced-omit-processes|roced-pid-at-point|roced-process-attributes|roced-process-tree-internal|roced-process-tree|roced-refine|roced-renice|roced-revert|roced-send-signal|roced-sort-header|roced-sort-interactive|roced-sort-p|roced-sort-pcpu|roced-sort-pid|roced-sort-pmem|roced-sort-start|roced-sort-time|roced-sort-user|roced-sort|roced-string-lessp|roced-success-message|roced-time-lessp|roced-toggle-auto-update|roced-toggle-marks|roced-toggle-tree|roced-tree-insert|roced-tree|roced-undo|roced-unmark-all|roced-unmark-backward|roced-unmark|roced-update|roced-why|roced-with-processes-buffer|roced-xor|roced|rocess-filter-multibyte-p|rocess-inherit-coding-system-flag|rocess-kill-without-query|rocess-menu-delete-process|rocess-menu-mode|rocess-menu-visit-buffer|roclaim|roduce-allout-mode-menubar-entries|rofiler-calltree-build-1|rofiler-calltree-build-unified|rofiler-calltree-build|rofiler-calltree-children--cmacro|rofiler-calltree-children|rofiler-calltree-compute-percentages|rofiler-calltree-count--cmacro|rofiler-calltree-count-percent--cmacro|rofiler-calltree-count-percent|rofiler-calltree-count<??|rofiler-calltree-count>|rofiler-calltree-depth|rofiler-calltree-entry--cmacro|rofiler-calltree-entry|rofiler-calltree-find|rofiler-calltree-leaf-p|rofiler-calltree-p--cmacro|rofiler-calltree-p|rofiler-calltree-parent--cmacro|rofiler-calltree-parent|rofiler-calltree-sort|rofiler-calltree-walk|rofiler-compare-logs|rofiler-compare-profiles|rofiler-cpu-log|rofiler-cpu-profile|rofiler-cpu-running-p|rofiler-cpu-start|rofiler-cpu-stop|rofiler-ensure-string|rofiler-find-profile-other-frame|rofiler-find-profile-other-window|rofiler-find-profile|rofiler-fixup-backtrace|rofiler-fixup-entry|rofiler-fixup-log|rofiler-fixup-profile|rofiler-format-entry|rofiler-format-number|rofiler-format-percent|rofiler-format|rofiler-make-calltree--cmacro|rofiler-make-calltree|rofiler-make-profile--cmacro|rofiler-make-profile|rofiler-memory-log|rofiler-memory-profile|rofiler-memory-running-p|rofiler-memory-start|rofiler-memory-stop|rofiler-profile-diff-p--cmacro|rofiler-profile-diff-p|rofiler-profile-log--cmacro|rofiler-profile-log|rofiler-profile-tag--cmacro|rofiler-profile-tag|rofiler-profile-timestamp--cmacro|rofiler-profile-timestamp|rofiler-profile-type--cmacro|rofiler-profile-type|rofiler-profile-version--cmacro|rofiler-profile-version|rofiler-read-profile|rofiler-report-ascending-sort|rofiler-report-calltree-at-point|rofiler-report-collapse-entry|rofiler-report-compare-profile|rofiler-report-cpu|rofiler-report-descending-sort|rofiler-report-describe-entry|rofiler-report-expand-entry|rofiler-report-find-entry|rofiler-report-header-line-format|rofiler-report-insert-calltree-children|rofiler-report-insert-calltree|rofiler-report-line-format|rofiler-report-make-buffer-name|rofiler-report-make-entry-part|rofiler-report-make-name-part|rofiler-report-memory|rofiler-report-menu|rofiler-report-mode|rofiler-report-move-to-entry|rofiler-report-next-entry|rofiler-report-previous-entry|rofiler-report-profile-other-frame|rofiler-report-profile-other-window|rofiler-report-profile|rofiler-report-render-calltree-1|rofiler-report-render-calltree|rofiler-report-render-reversed-calltree|rofiler-report-rerender-calltree|rofiler-report-setup-buffer-1|rofiler-report-setup-buffer|rofiler-report-toggle-entry|rofiler-report-write-profile|rofiler-report|rofiler-reset|rofiler-running-p|rofiler-start|rofiler-stop|rofiler-write-profile|rog-indent-sexp|rogress-reporter-do-update|rogv|roject-add-file|roject-compile-project|roject-compile-target|roject-debug-target|roject-delete-target|roject-dist-files|roject-edit-file-target|roject-interactive-select-target|roject-make-dist|roject-new-target-custom|roject-new-target|roject-remove-file|roject-rescan|roject-run-target|rolog-Info-follow-nearest-node|rolog-atleast-version|rolog-atom-under-point|rolog-beginning-of-clause|rolog-beginning-of-predicate|rolog-bsts|rolog-buffer-module|rolog-build-info-alist|rolog-build-prolog-command|rolog-clause-end|rolog-clause-info|rolog-clause-start|rolog-comment-limits|rolog-compile-buffer|rolog-compile-file|rolog-compile-predicate|rolog-compile-region|rolog-compile-string|rolog-consult-buffer|rolog-consult-compile-buffer|rolog-consult-compile-file|rolog-consult-compile-filter|rolog-consult-compile-predicate|rolog-consult-compile-region|rolog-consult-compile|rolog-consult-file|rolog-consult-predicate|rolog-consult-region|rolog-consult-string|rolog-debug-off|rolog-debug-on|rolog-disable-sicstus-sd|rolog-do-auto-fill|rolog-edit-menu-insert-move|rolog-edit-menu-runtime|rolog-electric--colon|rolog-electric--dash|rolog-electric--dot|rolog-electric--if-then-else|rolog-electric--underscore|rolog-enable-sicstus-sd|rolog-end-of-clause|rolog-end-of-predicate|rolog-ensure-process|rolog-face-name-p|rolog-fill-paragraph|rolog-find-documentation|rolog-find-term|rolog-find-unmatched-paren|rolog-find-value-by-system|rolog-font-lock-keywords|rolog-font-lock-object-matcher|rolog-get-predspec|rolog-goto-predicate-info|rolog-goto-prolog-process-buffer|rolog-guess-fill-prefix|rolog-help-apropos|rolog-help-info|rolog-help-on-predicate|rolog-help-online|rolog-in-object|rolog-indent-buffer|rolog-indent-predicate|rolog-inferior-buffer|rolog-inferior-guess-flavor|rolog-inferior-menu-all|rolog-inferior-menu|rolog-inferior-mode|rolog-inferior-self-insert-command|rolog-input-filter|rolog-insert-module-modeline|rolog-insert-next-clause|rolog-insert-predicate-template|rolog-insert-predspec|rolog-mark-clause|rolog-mark-predicate|rolog-menu-help|rolog-menu|rolog-mode-keybindings-common|rolog-mode-keybindings-edit|rolog-mode-keybindings-inferior|rolog-mode-variables|rolog-mode-version|rolog-mode|rolog-old-process-buffer|rolog-old-process-file|rolog-old-process-predicate|rolog-old-process-region|rolog-paren-balance|rolog-parse-sicstus-compilation-errors|rolog-post-self-insert|rolog-pred-end|rolog-pred-start|rolog-process-insert-string|rolog-program-name|rolog-program-switches|rolog-prompt-regexp|rolog-read-predicate|rolog-replace-in-string|rolog-smie-backward-token|rolog-smie-forward-token|rolog-smie-rules|rolog-temporary-file|rolog-toggle-sicstus-sd|rolog-trace-off|rolog-trace-on|rolog-uncomment-region|rolog-variables-to-anonymous|rolog-view-predspec|rolog-zip-off|rolog-zip-on|rompt-for-change-log-name|ropertized-buffer-identification|rune-directory-list|s-alist-position|s-avg-char-width|s-background-image|s-background-pages|s-background-text|s-background|s-basic-plot-str|s-basic-plot-string|s-basic-plot-whitespace|s-begin-file|s-begin-job|s-begin-page|s-boolean-capitalized|s-boolean-constant|s-build-reference-face-lists|s-color-device|s-color-scale|s-color-values|s-comment-string|s-continue-line|s-control-character|s-count-lines-preprint|s-count-lines|s-del|s-despool|s-do-despool|s-end-job|s-end-page|s-end-sheet|s-extend-face-list|s-extend-face|s-extension-bit|s-face-attribute-list|s-face-attributes|s-face-background-color-p|s-face-background-name|s-face-background|s-face-bold-p|s-face-box-p|s-face-color-p|s-face-extract-color|s-face-foreground-color-p|s-face-foreground-name|s-face-italic-p|s-face-overline-p|s-face-strikeout-p|s-face-underlined-p|s-find-wrappoint|s-float-format|s-flush-output|s-font-alist|s-font-lock-face-attributes|s-font-number|s-fonts??|s-format-color|s-frame-parameter|s-generate-header-line|s-generate-header|s-generate-postscript-with-faces1??|s-generate-postscript|s-generate|s-get-boundingbox|s-get-buffer-name|s-get-font-size|s-get-page-dimensions|s-get-size|s-get|s-header-dirpart|s-header-page|s-header-sheet|s-init-output-queue|s-insert-file|s-insert-string|s-kill-emacs-check|s-line-height|s-line-lengths-internal|s-line-lengths|s-lookup|s-map-face|s-mark-active-p|s-message-log-max|s-mode--syntax-propertize-special|s-mode-RE|s-mode-backward-delete-char|s-mode-center|s-mode-comment-out-region|s-mode-epsf-rich|s-mode-epsf-sparse|s-mode-heapsort|s-mode-latin-extended|s-mode-main|s-mode-octal-buffer|s-mode-octal-region|s-mode-other-newline|s-mode-print-buffer|s-mode-print-region|s-mode-right|s-mode-show-version|s-mode-smie-rules|s-mode-submit-bug-report|s-mode-syntax-propertize|s-mode-target-column|s-mode-uncomment-region|s-mode|s-mule-begin-job|s-mule-end-job|s-mule-initialize|s-n-up-columns|s-n-up-end|s-n-up-filling|s-n-up-landscape|s-n-up-lines|s-n-up-missing|s-n-up-printing|s-n-up-repeat|s-n-up-xcolumn|s-n-up-xline|s-n-up-xstart|s-n-up-ycolumn|s-n-up-yline|s-n-up-ystart|s-nb-pages-buffer|s-nb-pages-region|s-nb-pages|s-next-line|s-next-page|s-output-boolean|s-output-frame-properties|s-output-prologue|s-output-string-prim|s-output-string|s-output|s-page-dimensions-get-height|s-page-dimensions-get-media|s-page-dimensions-get-width|s-page-number|s-plot-region|s-plot-string|s-plot-with-face|s-plot|s-print-buffer-with-faces|s-print-buffer|s-print-customize|s-print-ensure-fontified|s-print-page-p|s-print-preprint-region|s-print-preprint|s-print-quote|s-print-region-with-faces|s-print-region|s-print-sheet-p|s-print-with-faces|s-print-without-faces|s-printing-region|s-prologue-file|s-put|s-remove-duplicates|s-restore-selected-pages|s-rgb-color|s-run-boundingbox|s-run-buffer|s-run-cleanup|s-run-clear|s-run-goto-error|s-run-kill|s-run-make-tmp-filename|s-run-mode|s-run-mouse-goto-error|s-run-quit|s-run-region|s-run-running|s-run-send-string|s-run-start|s-screen-to-bit-face|s-select-font|s-selected-pages|s-set-bg|s-set-color|s-set-face-attribute|s-set-face-bold|s-set-face-italic|s-set-face-underline|s-set-font|s-setup|s-size-scale|s-skip-newline|s-space-width|s-spool-buffer-with-faces|s-spool-buffer|s-spool-region-with-faces|s-spool-region|s-spool-with-faces|s-spool-without-faces|s-time-stamp-hh:mm:ss|s-time-stamp-iso8601)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(?:ps-time-stamp-locale-default|ps-time-stamp-mon-dd-yyyy|ps-time-stamp-yyyy-mm-dd|ps-title-line-height|ps-value-string|ps-value|psetf|psetq|push-mark-command|pushnew|put-unicode-property-internal|pwd|python-check|python-comint-output-filter-function|python-comint-postoutput-scroll-to-bottom|python-completion-at-point|python-completion-complete-at-point|python-define-auxiliary-skeleton|python-docstring-at-p|python-eldoc--get-doc-at-point|python-eldoc-at-point|python-eldoc-function|python-electric-pair-string-delimiter|python-ffap-module-path|python-fill-comment|python-fill-decorator|python-fill-paragraph|python-fill-paren|python-fill-string|python-font-lock-syntactic-face-function|python-imenu--build-tree|python-imenu--put-parent|python-imenu-create-flat-index|python-imenu-create-index|python-imenu-format-item-label|python-imenu-format-parent-item-jump-label|python-imenu-format-parent-item-label|python-indent-calculate-indentation|python-indent-calculate-levels|python-indent-context|python-indent-dedent-line-backspace|python-indent-dedent-line|python-indent-guess-indent-offset|python-indent-line-function|python-indent-line|python-indent-post-self-insert-function|python-indent-region|python-indent-shift-left|python-indent-shift-right|python-indent-toggle-levels|python-info-assignment-continuation-line-p|python-info-beginning-of-backslash|python-info-beginning-of-block-p|python-info-beginning-of-statement-p|python-info-block-continuation-line-p|python-info-closing-block-message|python-info-closing-block|python-info-continuation-line-p|python-info-current-defun|python-info-current-line-comment-p|python-info-current-line-empty-p|python-info-current-symbol|python-info-dedenter-opening-block-message|python-info-dedenter-opening-block-positions??|python-info-dedenter-statement-p|python-info-encoding-from-cookie|python-info-encoding|python-info-end-of-block-p|python-info-end-of-statement-p|python-info-line-ends-backslash-p|python-info-looking-at-beginning-of-defun|python-info-ppss-comment-or-string-p|python-info-ppss-context-type|python-info-ppss-context|python-info-statement-ends-block-p|python-info-statement-starts-block-p|python-menu|python-mode|python-nav--beginning-of-defun|python-nav--forward-defun|python-nav--forward-sexp|python-nav--lisp-forward-sexp-safe|python-nav--lisp-forward-sexp|python-nav--syntactically|python-nav--up-list|python-nav-backward-block|python-nav-backward-defun|python-nav-backward-sexp-safe|python-nav-backward-sexp|python-nav-backward-statement|python-nav-backward-up-list|python-nav-beginning-of-block|python-nav-beginning-of-defun|python-nav-beginning-of-statement|python-nav-end-of-block|python-nav-end-of-defun|python-nav-end-of-statement|python-nav-forward-block|python-nav-forward-defun|python-nav-forward-sexp-safe|python-nav-forward-sexp|python-nav-forward-statement|python-nav-if-name-main|python-nav-up-list|python-pdbtrack-comint-output-filter-function|python-pdbtrack-set-tracked-buffer|python-proc|python-send-receive|python-send-string|python-shell--save-temp-file|python-shell-accept-process-output|python-shell-buffer-substring|python-shell-calculate-command|python-shell-calculate-exec-path|python-shell-calculate-process-environment|python-shell-calculate-pythonpath|python-shell-comint-end-of-output-p|python-shell-completion-at-point|python-shell-completion-complete-at-point|python-shell-completion-complete-or-indent|python-shell-completion-get-completions|python-shell-font-lock-cleanup-buffer|python-shell-font-lock-comint-output-filter-function|python-shell-font-lock-get-or-create-buffer|python-shell-font-lock-kill-buffer|python-shell-font-lock-post-command-hook|python-shell-font-lock-toggle|python-shell-font-lock-turn-off|python-shell-font-lock-turn-on|python-shell-font-lock-with-font-lock-buffer|python-shell-get-buffer|python-shell-get-or-create-process|python-shell-get-process-name|python-shell-get-process|python-shell-internal-get-or-create-process|python-shell-internal-get-process-name|python-shell-internal-send-string|python-shell-make-comint|python-shell-output-filter|python-shell-package-enable|python-shell-parse-command|python-shell-prompt-detect|python-shell-prompt-set-calculated-regexps|python-shell-prompt-validate-regexps|python-shell-send-buffer|python-shell-send-defun|python-shell-send-file|python-shell-send-region|python-shell-send-setup-code|python-shell-send-string-no-output|python-shell-send-string|python-shell-switch-to-shell|python-shell-with-shell-buffer|python-skeleton--else|python-skeleton--except|python-skeleton--finally|python-skeleton-add-menu-items|python-skeleton-class|python-skeleton-def|python-skeleton-define|python-skeleton-for|python-skeleton-if|python-skeleton-import|python-skeleton-try|python-skeleton-while|python-syntax-comment-or-string-p|python-syntax-context-type|python-syntax-context|python-syntax-count-quotes|python-syntax-stringify|python-util-clone-local-variables|python-util-comint-last-prompt|python-util-forward-comment|python-util-goto-line|python-util-list-directories|python-util-list-files|python-util-list-packages|python-util-popn|python-util-strip-string|python-util-text-properties-replace-name|python-util-valid-regexp-p|quail-define-package|quail-define-rules|quail-defrule-internal|quail-defrule|quail-install-decode-map|quail-install-map|quail-set-keyboard-layout|quail-show-keyboard-layout|quail-title|quail-update-leim-list-file|quail-use-package|query-dig|query-font|query-fontset|query-replace-compile-replacement|query-replace-descr|query-replace-read-args|query-replace-read-from|query-replace-read-to|query-replace-regexp-eval|query-replace-regexp|query-replace|quick-calc|quickurl-add-url|quickurl-ask|quickurl-browse-url-ask|quickurl-browse-url|quickurl-edit-urls|quickurl-find-url|quickurl-grab-url|quickurl-insert|quickurl-list-add-url|quickurl-list-insert-lookup|quickurl-list-insert-naked-url|quickurl-list-insert-url|quickurl-list-insert-with-desc|quickurl-list-insert-with-lookup|quickurl-list-insert|quickurl-list-make-inserter|quickurl-list-mode|quickurl-list-mouse-select|quickurl-list-populate-buffer|quickurl-list-quit|quickurl-list|quickurl-load-urls|quickurl-make-url|quickurl-read|quickurl-save-urls|quickurl-url-comment|quickurl-url-commented-p|quickurl-url-description|quickurl-url-keyword|quickurl-url-url|quickurl|quit-windows-on|quoted-insert|quoted-printable-decode-region|quoted-printable-decode-string|quoted-printable-encode-region|r2b-barf-output|r2b-capitalize-title-region|r2b-capitalize-title|r2b-clear-variables|r2b-convert-buffer|r2b-convert-month|r2b-convert-record|r2b-get-field|r2b-help|r2b-isa-proceedings|r2b-isa-university|r2b-match|r2b-moveq|r2b-put-field|r2b-require|r2b-reset|r2b-set-match|r2b-snarf-input|r2b-trace|r2b-warning|radians-to-degrees|raise-sexp|random\\\\*|random-state-p|rassoc\\\\*|rassoc-if-not|rassoc-if|rcirc--connection-open-p|rcirc-abbreviate|rcirc-activity-string|rcirc-add-face|rcirc-add-or-remove|rcirc-any-buffer|rcirc-authenticate|rcirc-browse-url|rcirc-buffer-nick|rcirc-buffer-process|rcirc-change-major-mode-hook|rcirc-channel-nicks|rcirc-channel-p|rcirc-check-auth-status|rcirc-clean-up-buffer|rcirc-clear-activity|rcirc-clear-unread|rcirc-cmd-bright|rcirc-cmd-ctcp|rcirc-cmd-dim|rcirc-cmd-ignore|rcirc-cmd-invite|rcirc-cmd-join|rcirc-cmd-keyword|rcirc-cmd-kick|rcirc-cmd-list|rcirc-cmd-me|rcirc-cmd-mode|rcirc-cmd-msg|rcirc-cmd-names|rcirc-cmd-nick|rcirc-cmd-oper|rcirc-cmd-part|rcirc-cmd-query|rcirc-cmd-quit|rcirc-cmd-quote|rcirc-cmd-reconnect|rcirc-cmd-topic|rcirc-cmd-whois|rcirc-complete|rcirc-completion-at-point|rcirc-condition-filter|rcirc-connect|rcirc-ctcp-sender-PING|rcirc-debug|rcirc-delete-process|rcirc-disconnect-buffer|rcirc-edit-multiline|rcirc-elapsed-lines|rcirc-facify|rcirc-fill-paragraph|rcirc-filter|rcirc-float-time|rcirc-format-response-string|rcirc-generate-log-filename|rcirc-generate-new-buffer-name|rcirc-get-buffer-create|rcirc-get-buffer|rcirc-get-temp-buffer-create|rcirc-handler-001|rcirc-handler-301|rcirc-handler-317|rcirc-handler-332|rcirc-handler-333|rcirc-handler-353|rcirc-handler-366|rcirc-handler-433|rcirc-handler-477|rcirc-handler-CTCP-response|rcirc-handler-CTCP|rcirc-handler-ERROR|rcirc-handler-INVITE|rcirc-handler-JOIN|rcirc-handler-KICK|rcirc-handler-MODE|rcirc-handler-NICK|rcirc-handler-NOTICE|rcirc-handler-PART-or-KICK|rcirc-handler-PART|rcirc-handler-PING|rcirc-handler-PONG|rcirc-handler-PRIVMSG|rcirc-handler-QUIT|rcirc-handler-TOPIC|rcirc-handler-WALLOPS|rcirc-handler-ctcp-ACTION|rcirc-handler-ctcp-KEEPALIVE|rcirc-handler-ctcp-TIME|rcirc-handler-ctcp-VERSION|rcirc-handler-generic|rcirc-ignore-update-automatic|rcirc-insert-next-input|rcirc-insert-prev-input|rcirc-join-channels-post-auth|rcirc-join-channels|rcirc-jump-to-first-unread-line|rcirc-keepalive|rcirc-kill-buffer-hook|rcirc-last-line|rcirc-last-quit-line|rcirc-log-write|rcirc-log|rcirc-looking-at-input|rcirc-make-trees|rcirc-markup-attributes|rcirc-markup-bright-nicks|rcirc-markup-fill|rcirc-markup-keywords|rcirc-markup-my-nick|rcirc-markup-timestamp|rcirc-markup-urls|rcirc-maybe-remember-nick-quit|rcirc-mode|rcirc-multiline-minor-cancel|rcirc-multiline-minor-mode|rcirc-multiline-minor-submit|rcirc-next-active-buffer|rcirc-nick-channels|rcirc-nick-remove|rcirc-nick|rcirc-nickname<|rcirc-non-irc-buffer|rcirc-omit-mode|rcirc-prev-input-string|rcirc-print|rcirc-process-command|rcirc-process-input-line|rcirc-process-list|rcirc-process-message|rcirc-process-server-response-1|rcirc-process-server-response|rcirc-prompt-for-encryption|rcirc-put-nick-channel|rcirc-rebuild-tree|rcirc-record-activity|rcirc-remove-nick-channel|rcirc-reschedule-timeout|rcirc-send-ctcp|rcirc-send-input|rcirc-send-message|rcirc-send-privmsg|rcirc-send-string|rcirc-sentinel|rcirc-server-name|rcirc-set-changed|rcirc-short-buffer-name|rcirc-sort-nicknames-join|rcirc-split-activity|rcirc-split-message|rcirc-switch-to-server-buffer|rcirc-target-buffer|rcirc-toggle-ignore-buffer-activity|rcirc-toggle-low-priority|rcirc-track-minor-mode|rcirc-update-activity-string|rcirc-update-prompt|rcirc-update-short-buffer-names|rcirc-user-nick|rcirc-view-log-file|rcirc-visible-buffers|rcirc-window-configuration-change-1|rcirc-window-configuration-change|rcirc|re-builder-unload-function|re-search-backward-lax-whitespace|re-search-forward-lax-whitespace|read--expression|read-abbrev-file|read-all-face-attributes|read-buffer-file-coding-system|read-buffer-to-switch|read-char-by-name|read-charset|read-cookie|read-envvar-name|read-extended-command|read-face-and-attribute|read-face-attribute|read-face-font|read-face-name|read-feature|read-file-name--defaults|read-file-name-default|read-file-name-internal|read-from-whole-string|read-hiragana-string|read-input|read-language-name|read-multilingual-string|read-number|read-regexp-suggestions|reb-assert-buffer-in-window|reb-auto-update|reb-change-syntax|reb-change-target-buffer|reb-color-display-p|reb-cook-regexp|reb-copy|reb-count-subexps|reb-delete-overlays|reb-display-subexp|reb-do-update|reb-empty-regexp|reb-enter-subexp-mode|reb-force-update|reb-initialize-buffer|reb-insert-regexp|reb-kill-buffer|reb-lisp-mode|reb-lisp-syntax-p|reb-mode-buffer-p|reb-mode-common|reb-mode|reb-next-match|reb-prev-match|reb-quit-subexp-mode|reb-quit|reb-read-regexp|reb-show-subexp|reb-target-binding|reb-toggle-case|reb-update-modestring|reb-update-overlays|reb-update-regexp|rebuild-mail-abbrevs|recentf-add-file|recentf-apply-filename-handlers|recentf-apply-menu-filter|recentf-arrange-by-dir|recentf-arrange-by-mode|recentf-arrange-by-rule|recentf-auto-cleanup|recentf-build-mode-rules|recentf-cancel-dialog|recentf-cleanup|recentf-dialog-goto-first|recentf-dialog-mode|recentf-dialog|recentf-digit-shortcut-command-name|recentf-dir-rule|recentf-directory-compare|recentf-dump-variable|recentf-edit-list-select|recentf-edit-list-validate|recentf-edit-list|recentf-elements|recentf-enabled-p|recentf-expand-file-name|recentf-file-name-nondir|recentf-filter-changer-select|recentf-filter-changer|recentf-hide-menu|recentf-include-p|recentf-indirect-mode-rule|recentf-keep-default-predicate|recentf-keep-p|recentf-load-list|recentf-make-default-menu-element|recentf-make-menu-element|recentf-make-menu-items??|recentf-match-rule|recentf-menu-bar|recentf-menu-customization-changed|recentf-menu-element-item|recentf-menu-element-value|recentf-menu-elements)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(?:rmail-output-body-to-file|rmail-output-to-rmail-buffer|rmail-output|rmail-parse-url|rmail-perm-variables|rmail-pop-to-buffer|rmail-previous-labeled-message|rmail-previous-message|rmail-previous-same-subject|rmail-previous-undeleted-message|rmail-probe|rmail-quit|rmail-read-label|rmail-redecode-body|rmail-reply|rmail-require-mime-maybe|rmail-resend|rmail-restore-desktop-buffer|rmail-retry-failure|rmail-revert|rmail-search-backwards|rmail-search-message|rmail-search|rmail-select-summary|rmail-set-attribute-1|rmail-set-attribute|rmail-set-header-1|rmail-set-header|rmail-set-message-counters-counter|rmail-set-message-counters|rmail-set-message-deleted-p|rmail-set-remote-password|rmail-show-message-1|rmail-show-message|rmail-simplified-subject-regexp|rmail-simplified-subject|rmail-sort-by-author|rmail-sort-by-correspondent|rmail-sort-by-date|rmail-sort-by-labels|rmail-sort-by-lines|rmail-sort-by-recipient|rmail-sort-by-subject|rmail-speedbar-buttons??|rmail-speedbar-find-file|rmail-speedbar-move-message-to-folder-on-line|rmail-speedbar-move-message|rmail-start-mail|rmail-summary-by-labels|rmail-summary-by-recipients|rmail-summary-by-regexp|rmail-summary-by-senders|rmail-summary-by-topic|rmail-summary-displayed|rmail-summary-exists|rmail-summary|rmail-swap-buffers-maybe|rmail-swap-buffers|rmail-toggle-header|rmail-undelete-previous-message|rmail-unfontify-buffer-function|rmail-unknown-mail-followup-to|rmail-unrmail-new-mail-maybe|rmail-unrmail-new-mail|rmail-update-summary|rmail-variables|rmail-view-buffer-kill-buffer-hook|rmail-what-message|rmail-widen-to-current-msgbeg|rmail-widen|rmail-write-region-annotate|rmail-yank-current-message|rmail|rng-c-load-schema|rng-nxml-mode-init|rng-validate-mode|rng-xsd-compile|robin-define-package|robin-modify-package|robin-use-package|rot13-other-window|rot13-region|rot13-string|rot13|rotate-yank-pointer|rotatef|round\\\\*|route|rsh|rst-minor-mode|rst-mode|ruby--at-indentation-p|ruby--detect-encoding|ruby--electric-indent-p|ruby--encoding-comment-required-p|ruby--insert-coding-comment|ruby--inverse-string-quote|ruby--string-region|ruby-accurate-end-of-block|ruby-add-log-current-method|ruby-backward-sexp|ruby-beginning-of-block|ruby-beginning-of-defun|ruby-beginning-of-indent|ruby-block-contains-point|ruby-brace-to-do-end|ruby-calculate-indent|ruby-current-indentation|ruby-deep-indent-paren-p|ruby-do-end-to-brace|ruby-end-of-block|ruby-end-of-defun|ruby-expr-beg|ruby-forward-sexp|ruby-forward-string|ruby-here-doc-end-match|ruby-imenu-create-index-in-block|ruby-imenu-create-index|ruby-in-ppss-context-p|ruby-indent-exp|ruby-indent-line|ruby-indent-size|ruby-indent-to|ruby-match-expression-expansion|ruby-mode-menu|ruby-mode-set-encoding|ruby-mode-variables|ruby-mode|ruby-move-to-block|ruby-parse-partial|ruby-parse-region|ruby-singleton-class-p|ruby-smie--args-separator-p|ruby-smie--at-dot-call|ruby-smie--backward-token|ruby-smie--bosp|ruby-smie--closing-pipe-p|ruby-smie--forward-token|ruby-smie--implicit-semi-p|ruby-smie--indent-to-stmt-p|ruby-smie--indent-to-stmt|ruby-smie--opening-pipe-p|ruby-smie--redundant-do-p|ruby-smie-rules|ruby-special-char-p|ruby-string-at-point-p|ruby-syntax-enclosing-percent-literal|ruby-syntax-expansion-allowed-p|ruby-syntax-propertize-expansions??|ruby-syntax-propertize-function|ruby-syntax-propertize-heredoc|ruby-syntax-propertize-percent-literal|ruby-toggle-block|ruby-toggle-string-quotes|ruler--save-header-line-format|ruler-mode-character-validate|ruler-mode-full-window-width|ruler-mode-mouse-add-tab-stop|ruler-mode-mouse-del-tab-stop|ruler-mode-mouse-drag-any-column-iteration|ruler-mode-mouse-drag-any-column|ruler-mode-mouse-grab-any-column|ruler-mode-mouse-set-left-margin|ruler-mode-mouse-set-right-margin|ruler-mode-ruler|ruler-mode-space|ruler-mode-toggle-show-tab-stops|ruler-mode-window-col|ruler-mode|run-dig|run-hook-wrapped|run-lisp|run-network-program|run-octave|run-prolog|run-python-internal|run-python|run-scheme|run-tcl|run-window-configuration-change-hook|run-window-scroll-functions|run-with-timer|rx-\\\\*\\\\*|rx-=|rx->=|rx-and|rx-any-condense-range|rx-any-delete-from-range|rx-any|rx-anything|rx-atomic-p|rx-backref|rx-category|rx-check-any-string|rx-check-any|rx-check-backref|rx-check-category|rx-check-not|rx-check|rx-eval|rx-form|rx-greedy|rx-group-if|rx-info|rx-kleene|rx-not-char|rx-not-syntax|rx-not|rx-or|rx-regexp|rx-repeat|rx-submatch-n|rx-submatch|rx-syntax|rx-to-string|rx-trans-forms|rx|rzgrep|safe-date-to-time|same-class-fast-p|same-class-p|sanitize-coding-system-list|sasl-anonymous-response|sasl-client-mechanism|sasl-client-name|sasl-client-properties|sasl-client-property|sasl-client-server|sasl-client-service|sasl-client-set-properties|sasl-client-set-property|sasl-error|sasl-find-mechanism|sasl-login-response-1|sasl-login-response-2|sasl-make-client|sasl-make-mechanism|sasl-mechanism-name|sasl-mechanism-steps|sasl-next-step|sasl-plain-response|sasl-read-passphrase|sasl-step-data|sasl-step-set-data|sasl-unique-id-function|sasl-unique-id-number-base36|sasl-unique-id|save-buffers-kill-emacs|save-buffers-kill-terminal|save-completions-to-file|save-place-alist-to-file|save-place-dired-hook|save-place-find-file-hook|save-place-forget-unreadable-files|save-place-kill-emacs-hook|save-place-to-alist|save-places-to-alist|savehist-autosave|savehist-install|savehist-load|savehist-minibuffer-hook|savehist-mode|savehist-printable|savehist-save|savehist-trim-history|savehist-uninstall|sc-S-cite-region-limit|sc-S-mail-header-nuke-list|sc-S-mail-nuke-mail-headers|sc-S-preferred-attribution-list|sc-S-preferred-header-style|sc-T-auto-fill-region|sc-T-confirm-always|sc-T-describe|sc-T-downcase|sc-T-electric-circular|sc-T-electric-references|sc-T-fixup-whitespace|sc-T-mail-nuke-blank-lines|sc-T-nested-citation|sc-T-use-only-preferences|sc-add-citation-level|sc-ask|sc-attribs-!-addresses|sc-attribs-%@-addresses|sc-attribs-<>-addresses|sc-attribs-chop-address|sc-attribs-chop-namestring|sc-attribs-emailname|sc-attribs-extract-namestring|sc-attribs-filter-namelist|sc-attribs-strip-initials|sc-cite-coerce-cited-line|sc-cite-coerce-dumb-citer|sc-cite-line|sc-cite-original|sc-cite-regexp|sc-cite-region|sc-describe|sc-electric-mode|sc-eref-abort|sc-eref-exit|sc-eref-goto|sc-eref-insert-selected|sc-eref-jump|sc-eref-next|sc-eref-prev|sc-eref-setn|sc-eref-show|sc-fill-if-different|sc-get-address|sc-guess-attribution|sc-guess-nesting|sc-hdr|sc-header-attributed-writes|sc-header-author-writes|sc-header-inarticle-writes|sc-header-on-said|sc-header-regarding-adds|sc-header-verbose|sc-insert-citation|sc-insert-reference|sc-mail-append-field|sc-mail-build-nuke-frame|sc-mail-check-from|sc-mail-cleanup-blank-lines|sc-mail-error-in-mail-field|sc-mail-fetch-field|sc-mail-field-query|sc-mail-field|sc-mail-nuke-continuation-line|sc-mail-nuke-header-line|sc-mail-nuke-line|sc-mail-process-headers|sc-make-citation|sc-minor-mode|sc-name-substring|sc-no-blank-line-or-header|sc-no-header|sc-open-line|sc-raw-mode-toggle|sc-recite-line|sc-recite-region|sc-scan-info-alist|sc-select-attribution|sc-set-variable|sc-setup-filladapt|sc-setvar-symbol|sc-toggle-fn|sc-toggle-symbol|sc-toggle-var|sc-uncite-line|sc-uncite-region|sc-valid-index-p|sc-whofrom|scan-buf-move-to-region|scan-buf-next-region|scan-buf-previous-region|scheme-compile-definition-and-go|scheme-compile-definition|scheme-compile-file|scheme-compile-region-and-go|scheme-compile-region|scheme-debugger-mode-commands|scheme-debugger-mode-initialize|scheme-debugger-mode|scheme-debugger-self-insert|scheme-expand-current-form|scheme-form-at-point|scheme-get-old-input|scheme-get-process|scheme-indent-function|scheme-input-filter|scheme-interaction-mode-commands|scheme-interaction-mode-initialize|scheme-interaction-mode|scheme-interactively-start-process|scheme-let-indent|scheme-load-file|scheme-mode-commands|scheme-mode-variables|scheme-mode|scheme-proc|scheme-send-definition-and-go|scheme-send-definition|scheme-send-last-sexp|scheme-send-region-and-go|scheme-send-region|scheme-start-file|scheme-syntax-propertize-sexp-comment|scheme-syntax-propertize|scheme-trace-procedure|scroll-all-beginning-of-buffer-all|scroll-all-check-to-scroll|scroll-all-end-of-buffer-all|scroll-all-function-all|scroll-all-mode|scroll-all-page-down-all|scroll-all-page-up-all|scroll-all-scroll-down-all|scroll-all-scroll-up-all|scroll-bar-columns|scroll-bar-drag-1|scroll-bar-drag-position|scroll-bar-drag|scroll-bar-horizontal-drag-1|scroll-bar-horizontal-drag|scroll-bar-lines|scroll-bar-maybe-set-window-start|scroll-bar-scroll-down|scroll-bar-scroll-up|scroll-bar-set-window-start|scroll-bar-toolkit-horizontal-scroll|scroll-bar-toolkit-scroll|scroll-down-line|scroll-lock-mode|scroll-other-window-down|scroll-up-line|scss-mode|scss-smie--not-interpolation-p|sdb|search-backward-lax-whitespace|search-backward-regexp|search-emacs-glossary|search-forward-lax-whitespace|search-forward-regexp|search-pages|search-unencodable-char|search|second|seconds-to-string|secrets-close-session|secrets-collection-handler|secrets-collection-path|secrets-create-collection|secrets-create-item|secrets-delete-alias|secrets-delete-collection|secrets-delete-item|secrets-empty-path|secrets-expand-collection|secrets-expand-item|secrets-get-alias|secrets-get-attributes??|secrets-get-collection-properties|secrets-get-collection-property|secrets-get-collections|secrets-get-item-properties|secrets-get-item-property|secrets-get-items|secrets-get-secret|secrets-item-path|secrets-list-collections|secrets-list-items|secrets-mode|secrets-open-session|secrets-prompt-handler|secrets-prompt|secrets-search-items|secrets-set-alias|secrets-show-collections|secrets-show-secrets|secrets-tree-widget-after-toggle-function|secrets-tree-widget-show-password|secrets-unlock-collection|secure-hash|select-frame-by-name|select-frame-set-input-focus|select-frame|select-message-coding-system|select-safe-coding-system-interactively|select-safe-coding-system|select-scheme|select-tags-table-mode|select-tags-table-quit|select-tags-table-select|select-tags-table|select-window|selected-frame|selected-window|self-insert-and-exit|self-insert-command|semantic--set-buffer-cache|semantic--tag-attributes-cdr|semantic--tag-copy-properties|semantic--tag-deep-copy-attributes|semantic--tag-deep-copy-tag-list|semantic--tag-deep-copy-value|semantic--tag-expand|semantic--tag-expanded-p|semantic--tag-find-parent-by-name|semantic--tag-get-property|semantic--tag-link-cache-to-buffer|semantic--tag-link-list-to-buffer|semantic--tag-link-to-buffer|semantic--tag-overlay-cdr|semantic--tag-properties-cdr|semantic--tag-put-property-no-side-effect|semantic--tag-put-property|semantic--tag-run-hooks|semantic--tag-set-overlay|semantic--tag-unlink-cache-from-buffer|semantic--tag-unlink-from-buffer|semantic--tag-unlink-list-from-buffer|semantic--umatched-syntax-needs-refresh-p|semantic-active-p|semantic-add-label|semantic-add-minor-mode|semantic-add-system-include|semantic-alias-obsolete|semantic-analyze-completion-at-point-function|semantic-analyze-current-context|semantic-analyze-current-tag|semantic-analyze-nolongprefix-completion-at-point-function|semantic-analyze-notc-completion-at-point-function|semantic-analyze-possible-completions|semantic-analyze-proto-impl-toggle|semantic-analyze-type-constants|semantic-assert-valid-token|semantic-bovinate-from-nonterminal-full|semantic-bovinate-from-nonterminal|semantic-bovinate-region-until-error|semantic-bovinate-stream|semantic-bovinate-toplevel|semantic-buffer-local-value|semantic-c-add-preprocessor-symbol|semantic-cache-data-post-command-hook|semantic-cache-data-to-buffer|semantic-calculate-scope|semantic-change-function|semantic-clean-token-of-unmatched-syntax|semantic-clean-unmatched-syntax-in-buffer|semantic-clean-unmatched-syntax-in-region|semantic-clear-parser-warnings|semantic-clear-toplevel-cache|semantic-clear-unmatched-syntax-cache|semantic-comment-lexer|semantic-complete-analyze-and-replace|semantic-complete-analyze-inline-idle|semantic-complete-analyze-inline|semantic-complete-inline-project|semantic-complete-jump-local-members|semantic-complete-jump-local|semantic-complete-jump|semantic-complete-self-insert|semantic-complete-symbol|semantic-create-imenu-index|semantic-create-tag-proxy|semantic-ctxt-current-mode|semantic-current-tag-parent|semantic-current-tag|semantic-customize-system-include-path|semantic-debug|semantic-decoration-include-visit|semantic-decoration-unparsed-include-do-reset)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)se(?:mantic-default-c-setup|mantic-default-elisp-setup|mantic-default-html-setup|mantic-default-make-setup|mantic-default-scheme-setup|mantic-default-texi-setup|mantic-delete-overlay-maybe|mantic-dependency-tag-file|mantic-describe-buffer-var-helper|mantic-describe-buffer|mantic-describe-tag|mantic-desktop-ignore-this-minor-mode|mantic-documentation-for-tag|mantic-dump-parser-warnings|mantic-edits-incremental-parser|mantic-elapsed-time|mantic-equivalent-tag-p|mantic-error-if-unparsed|mantic-event-window|mantic-exit-on-input|mantic-fetch-available-tags|mantic-fetch-tags-fast|mantic-fetch-tags|mantic-file-tag-table|mantic-file-token-stream|mantic-find-file-noselect|mantic-find-first-tag-by-name|mantic-find-tag-by-overlay-in-region|mantic-find-tag-by-overlay-next|mantic-find-tag-by-overlay-prev|mantic-find-tag-by-overlay|mantic-find-tag-for-completion|mantic-find-tag-parent-by-overlay|mantic-find-tags-by-scope-protection|mantic-find-tags-included|mantic-flatten-tags-table|mantic-flex-buffer|mantic-flex-end|mantic-flex-keyword-get|mantic-flex-keyword-p|mantic-flex-keyword-put|mantic-flex-keywords|mantic-flex-list|mantic-flex-make-keyword-table|mantic-flex-map-keywords|mantic-flex-start|mantic-flex-text|mantic-flex|mantic-force-refresh|mantic-foreign-tag-check|mantic-foreign-tag-invalid|mantic-foreign-tag-p|mantic-foreign-tag|mantic-format-tag-concise-prototype|mantic-format-tag-name|mantic-format-tag-prototype|mantic-format-tag-summarize|mantic-fw-add-edebug-spec|mantic-gcc-setup|mantic-get-cache-data|mantic-go-to-tag|mantic-highlight-edits-mode|mantic-highlight-edits-new-change-hook-fcn|mantic-highlight-func-highlight-current-tag|mantic-highlight-func-menu|mantic-highlight-func-mode|mantic-highlight-func-popup-menu|mantic-ia-complete-symbol-menu|mantic-ia-complete-symbol|mantic-ia-complete-tip|mantic-ia-describe-class|mantic-ia-fast-jump|mantic-ia-fast-mouse-jump|mantic-ia-show-doc|mantic-ia-show-summary|mantic-ia-show-variants|mantic-idle-completions-mode|mantic-idle-scheduler-mode|mantic-idle-summary-mode|mantic-insert-foreign-tag-change-log-mode|mantic-insert-foreign-tag-default|mantic-insert-foreign-tag-log-edit-mode|mantic-insert-foreign-tag|mantic-install-function-overrides|mantic-lex-beginning-of-line|mantic-lex-buffer|mantic-lex-catch-errors|mantic-lex-charquote|mantic-lex-close-paren|mantic-lex-comments-as-whitespace|mantic-lex-comments|mantic-lex-debug-break|mantic-lex-debug|mantic-lex-default-action|mantic-lex-end-block|mantic-lex-expand-block-specs|mantic-lex-highlight-token|mantic-lex-ignore-comments|mantic-lex-ignore-newline|mantic-lex-ignore-whitespace|mantic-lex-init|mantic-lex-keyword-get|mantic-lex-keyword-invalid|mantic-lex-keyword-p|mantic-lex-keyword-put|mantic-lex-keyword-set|mantic-lex-keyword-symbol|mantic-lex-keyword-value|mantic-lex-keywords|mantic-lex-list|mantic-lex-make-keyword-table|mantic-lex-make-type-table|mantic-lex-map-keywords|mantic-lex-map-symbols|mantic-lex-map-types|mantic-lex-newline-as-whitespace|mantic-lex-newline|mantic-lex-number|mantic-lex-one-token|mantic-lex-open-paren|mantic-lex-paren-or-list|mantic-lex-preset-default-types|mantic-lex-punctuation-type|mantic-lex-punctuation|mantic-lex-push-token|mantic-lex-spp-table-write-slot-value|mantic-lex-start-block|mantic-lex-string|mantic-lex-symbol-or-keyword|mantic-lex-test|mantic-lex-token-bounds|mantic-lex-token-class|mantic-lex-token-end|mantic-lex-token-p|mantic-lex-token-start|mantic-lex-token-text|mantic-lex-token-with-text-p|mantic-lex-token-without-text-p|mantic-lex-token|mantic-lex-type-get|mantic-lex-type-invalid|mantic-lex-type-p|mantic-lex-type-put|mantic-lex-type-set|mantic-lex-type-symbol|mantic-lex-type-value|mantic-lex-types|mantic-lex-unterminated-syntax-detected|mantic-lex-unterminated-syntax-protection|mantic-lex-whitespace|mantic-lex|mantic-make-local-hook|mantic-make-overlay|mantic-map-buffers|mantic-map-mode-buffers|mantic-menu-item|mantic-mode-line-update|mantic-mode|mantic-narrow-to-tag|mantic-new-buffer-fcn|mantic-next-unmatched-syntax|mantic-obtain-foreign-tag|mantic-overlay-buffer|mantic-overlay-delete|mantic-overlay-end|mantic-overlay-get|mantic-overlay-lists|mantic-overlay-live-p|mantic-overlay-move|mantic-overlay-next-change|mantic-overlay-p|mantic-overlay-previous-change|mantic-overlay-properties|mantic-overlay-put|mantic-overlay-start|mantic-overlays-at|mantic-overlays-in|mantic-overload-symbol-from-function|mantic-parse-changes-default|mantic-parse-changes|mantic-parse-region-default|mantic-parse-region|mantic-parse-stream-default|mantic-parse-stream|mantic-parse-tree-needs-rebuild-p|mantic-parse-tree-needs-update-p|mantic-parse-tree-set-needs-rebuild|mantic-parse-tree-set-needs-update|mantic-parse-tree-set-up-to-date|mantic-parse-tree-unparseable-p|mantic-parse-tree-unparseable|mantic-parse-tree-up-to-date-p|mantic-parser-working-message|mantic-popup-menu|mantic-push-parser-warning|mantic-read-event|mantic-read-function|mantic-read-symbol|mantic-read-type|mantic-read-variable|mantic-refresh-tags-safe|mantic-remove-system-include|mantic-repeat-parse-whole-stream|mantic-require-version|mantic-reset-system-include|mantic-run-mode-hooks|mantic-safe|mantic-sanity-check|mantic-set-unmatched-syntax-cache|mantic-show-label|mantic-show-parser-state-auto-marker|mantic-show-parser-state-marker|mantic-show-parser-state-mode|mantic-show-unmatched-lex-tokens-fetch|mantic-show-unmatched-syntax-mode|mantic-show-unmatched-syntax-next|mantic-show-unmatched-syntax|mantic-showing-unmatched-syntax-p|mantic-simple-lexer|mantic-something-to-stream|mantic-something-to-tag-table|mantic-speedbar-analysis|mantic-stickyfunc-fetch-stickyline|mantic-stickyfunc-menu|mantic-stickyfunc-mode|mantic-stickyfunc-popup-menu|mantic-stickyfunc-tag-to-stick|mantic-subst-char-in-string|mantic-symref-find-file-references-by-name|mantic-symref-find-references-by-name|mantic-symref-find-tags-by-completion|mantic-symref-find-tags-by-name|mantic-symref-find-tags-by-regexp|mantic-symref-find-text|mantic-symref-regexp|mantic-symref-symbol|mantic-symref-tool-cscope-child-p|mantic-symref-tool-cscope-list-p|mantic-symref-tool-cscope-p|mantic-symref-tool-cscope|mantic-symref-tool-global-child-p|mantic-symref-tool-global-list-p|mantic-symref-tool-global-p|mantic-symref-tool-global|mantic-symref-tool-grep-child-p|mantic-symref-tool-grep-list-p|mantic-symref-tool-grep-p|mantic-symref-tool-grep|mantic-symref-tool-idutils-child-p|mantic-symref-tool-idutils-list-p|mantic-symref-tool-idutils-p|mantic-symref-tool-idutils|mantic-symref|mantic-tag-add-hook|mantic-tag-alias-class|mantic-tag-alias-definition|mantic-tag-attributes|mantic-tag-bounds|mantic-tag-buffer|mantic-tag-children-compatibility|mantic-tag-class|mantic-tag-clone|mantic-tag-code-detail|mantic-tag-components-default|mantic-tag-components-with-overlays-default|mantic-tag-components-with-overlays|mantic-tag-components|mantic-tag-copy|mantic-tag-deep-copy-one-tag|mantic-tag-docstring|mantic-tag-end|mantic-tag-external-member-parent|mantic-tag-faux-p|mantic-tag-file-name|mantic-tag-function-arguments|mantic-tag-function-constructor-p|mantic-tag-function-destructor-p|mantic-tag-function-parent|mantic-tag-function-throws|mantic-tag-get-attribute|mantic-tag-in-buffer-p|mantic-tag-include-filename-default|mantic-tag-include-filename|mantic-tag-include-system-p|mantic-tag-make-assoc-list|mantic-tag-make-plist|mantic-tag-mode|mantic-tag-modifiers|mantic-tag-name|mantic-tag-named-parent|mantic-tag-new-alias|mantic-tag-new-code|mantic-tag-new-function|mantic-tag-new-include|mantic-tag-new-package|mantic-tag-new-type|mantic-tag-new-variable|mantic-tag-of-class-p|mantic-tag-of-type-p|mantic-tag-overlay|mantic-tag-p|mantic-tag-properties|mantic-tag-prototype-p|mantic-tag-put-attribute-no-side-effect|mantic-tag-put-attribute|mantic-tag-remove-hook|mantic-tag-resolve-proxy|mantic-tag-set-bounds|mantic-tag-set-faux|mantic-tag-set-name|mantic-tag-set-proxy|mantic-tag-similar-with-subtags-p|mantic-tag-start|mantic-tag-type-compound-p|mantic-tag-type-interfaces|mantic-tag-type-members|mantic-tag-type-superclass-protection|mantic-tag-type-superclasses|mantic-tag-type|mantic-tag-variable-constant-p|mantic-tag-variable-default|mantic-tag-with-position-p|mantic-tag-write-list-slot-value|mantic-tag|mantic-test-data-cache|mantic-throw-on-input|mantic-toggle-minor-mode-globally|mantic-token-type-parent|mantic-unmatched-syntax-overlay-p|mantic-unmatched-syntax-tokens|mantic-varalias-obsolete|mantic-with-buffer-narrowed-to-current-tag|mantic-with-buffer-narrowed-to-tag|manticdb-database-typecache-child-p|manticdb-database-typecache-list-p|manticdb-database-typecache-p|manticdb-database-typecache|manticdb-enable-gnu-global-databases|manticdb-file-table-object|manticdb-find-adebug-lost-includes|manticdb-find-result-length|manticdb-find-result-nth-in-buffer|manticdb-find-result-nth|manticdb-find-table-for-include|manticdb-find-tags-by-class|manticdb-find-tags-by-name-regexp|manticdb-find-tags-by-name|manticdb-find-tags-for-completion|manticdb-find-test-translate-path|manticdb-find-translate-path|manticdb-minor-mode-p|manticdb-project-database-file-child-p|manticdb-project-database-file-list-p|manticdb-project-database-file-p|manticdb-project-database-file|manticdb-strip-find-results|manticdb-typecache-child-p|manticdb-typecache-find|manticdb-typecache-list-p|manticdb-typecache-p|manticdb-typecache|manticdb-without-unloaded-file-searches|nator-copy-tag-to-register|nator-copy-tag|nator-go-to-up-reference|nator-kill-tag|nator-next-tag|nator-previous-tag|nator-transpose-tags-down|nator-transpose-tags-up|nator-yank-tag|nd-invisible|nd-process-next-char|nd-region|nd-string|ndmail-query-once|ndmail-query-user-about-smtp|ndmail-send-it|ndmail-sync-aliases|ndmail-user-agent-compose|ntence-at-point|q--count-successive|q--drop-list|q--drop-while-list|q--take-list|q--take-while-list|q-concatenate|q-contains-p|q-copy|q-count|q-do|q-doseq|q-drop-while|q-drop|q-each|q-elt|q-empty-p|q-every-p|q-filter|q-length|q-map|q-reduce|q-remove|q-reverse|q-some-p|q-sort|q-subseq|q-take-while|q-take|q-uniq|rial-mode-line-config-menu-1|rial-mode-line-config-menu|rial-mode-line-speed-menu-1|rial-mode-line-speed-menu|rial-nice-speed-history|rial-port-is-file-p|rial-read-name|rial-read-speed|rial-speed|rial-supported-or-barf|rial-update-config-menu|rial-update-speed-menu|rver--on-display-p|rver-add-client|rver-buffer-done|rver-clients-with|rver-create-tty-frame|rver-create-window-system-frame|rver-delete-client|rver-done|rver-edit|rver-ensure-safe-dir|rver-eval-and-print|rver-eval-at|rver-execute-continuation|rver-execute|rver-force-delete|rver-force-stop|rver-generate-key|rver-get-auth-key|rver-goto-line-column|rver-goto-toplevel|rver-handle-delete-frame|rver-handle-suspend-tty|rver-kill-buffer|rver-kill-emacs-query-function|rver-log|rver-mode|rver-process-filter|rver-quote-arg|rver-reply-print|rver-return-error|rver-running-p|rver-save-buffers-kill-terminal|rver-select-display|rver-send-string|rver-sentinel|rver-start|rver-switch-buffer|rver-temp-file-p|rver-unload-function|rver-unquote-arg|rver-unselect-display|rver-visit-files|rver-with-environment|s\\\\+|s--advice-copy-region-as-kill|s--advice-yank|s--cell|s--clean-!|s--clean-_|s--letref|s--local-printer|s--locprn-compiled--cmacro|s--locprn-compiled|s--locprn-def--cmacro|s--locprn-def|s--locprn-local-printer-list--cmacro|s--locprn-local-printer-list|s--locprn-number--cmacro|s--locprn-number|s--locprn-p--cmacro|s--locprn-p|s--metaprogramming)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)s(?:es--time-check|es-adjust-print-width|es-append-row-jump-first-column|es-aset-with-undo|es-average|es-begin-change|es-calculate-cell|es-call-printer|es-cell--formula--cmacro|es-cell--formula|es-cell--printer--cmacro|es-cell--printer|es-cell--properties--cmacro|es-cell--properties|es-cell--references--cmacro|es-cell--references|es-cell--symbol--cmacro|es-cell--symbol|es-cell-formula|es-cell-p|es-cell-printer|es-cell-property-pop|es-cell-property|es-cell-references|es-cell-set-formula|es-cell-symbol|es-cell-value|es-center-span|es-center|es-check-curcell|es-cleanup|es-clear-cell-backward|es-clear-cell-forward|es-clear-cell|es-col-printer|es-col-width|es-column-letter|es-column-printers|es-column-widths|es-command-hook|es-copy-region-helper|es-copy-region|es-create-cell-symbol|es-create-cell-variable-range|es-create-cell-variable|es-create-header-string|es-dashfill-span|es-dashfill|es-decode-cell-symbol|es-default-printer|es-define-local-printer|es-delete-blanks|es-delete-column|es-delete-line|es-delete-row|es-destroy-cell-variable-range|es-dorange|es-edit-cell|es-end-of-line|es-export-keymap|es-export-tab|es-export-tsf|es-export-tsv|es-file-format-extend-parameter-list|es-formula-record|es-formula-references|es-forward-or-insert|es-get-cell|es-goto-data|es-goto-print|es-header-line-menu|es-header-row|es-in-print-area|es-initialize-Dijkstra-attempt|es-insert-column|es-insert-range-click|es-insert-range|es-insert-row|es-insert-ses-range-click|es-insert-ses-range|es-is-cell-sym-p|es-jump-safe|es-jump|es-kill-override|es-load|es-local-printer-compile|es-make-cell--cmacro|es-make-cell|es-make-local-printer-info|es-mark-column|es-mark-row|es-menu|es-mode-print-map|es-mode|es-print-cell-new-width|es-print-cell|es-printer-record|es-printer-validate|es-range|es-read-cell-printer|es-read-cell|es-read-column-printer|es-read-default-printer|es-read-printer|es-read-symbol|es-recalculate-all|es-recalculate-cell|es-reconstruct-all|es-refresh-local-printer|es-relocate-all|es-relocate-formula|es-relocate-range|es-relocate-symbol|es-rename-cell|es-renarrow-buffer|es-repair-cell-reference-all|es-replace-name-in-formula|es-reprint-all|es-reset-header-string|es-safe-formula|es-safe-printer|es-select|es-set-cell|es-set-column-width|es-set-curcell|es-set-header-row|es-set-localvars|es-set-parameter|es-set-with-undo|es-setter-with-undo|es-setup|es-sort-column-click|es-sort-column|es-sym-rowcol|es-tildefill-span|es-truncate-cell|es-unload-function|es-unsafe|es-unset-header-row|es-update-cells|es-vector-delete|es-vector-insert|es-warn-unsafe|es-widen|es-write-cells|es-yank-cells|es-yank-one|es-yank-pop|es-yank-resize|es-yank-tsf|et-allout-regexp|et-auto-mode-0|et-auto-mode-1|et-background-color|et-border-color|et-buffer-file-coding-system|et-buffer-process-coding-system|et-cdabbrev-buffer|et-charset-plist|et-clipboard-coding-system|et-cmpl-prefix-entry-head|et-cmpl-prefix-entry-tail|et-coding-priority|et-comment-column|et-completion-last-use-time|et-completion-num-uses|et-completion-string|et-cursor-color|et-default-coding-systems|et-default-font|et-default-toplevel-value|et-difference|et-display-table-and-terminal-coding-system|et-downcase-syntax|et-exclusive-or|et-face-attribute-from-resource|et-face-attributes-from-resources|et-face-background-pixmap|et-face-bold-p|et-face-doc-string|et-face-documentation|et-face-inverse-video-p|et-face-italic-p|et-face-underline-p|et-file-name-coding-system|et-fill-column|et-fill-prefix|et-font-encoding|et-foreground-color|et-frame-font|et-frame-name|et-fringe-mode-1|et-fringe-mode|et-fringe-style|et-goal-column|et-hard-newline-properties|et-input-interrupt-mode|et-input-meta-mode|et-justification-center|et-justification-full|et-justification-left|et-justification-none|et-justification-right|et-justification|et-keyboard-coding-system-internal|et-language-environment-charset|et-language-environment-coding-systems|et-language-environment-input-method|et-language-environment-nonascii-translation|et-language-environment-unibyte|et-language-environment|et-language-info-alist|et-language-info-internal|et-language-info|et-locale-environment|et-mark-command|et-mode-local-parent|et-mouse-color|et-nested-alist|et-next-selection-coding-system|et-output-flow-control|et-page-delimiter|et-process-filter-multibyte|et-process-inherit-coding-system-flag|et-process-window-size|et-quit-char|et-rcirc-decode-coding-system|et-rcirc-encode-coding-system|et-rmail-inbox-list|et-safe-terminal-coding-system-internal|et-scroll-bar-mode|et-selection-coding-system|et-selective-display|et-slot-value|et-temporary-overlay-map|et-terminal-coding-system-internal|et-time-zone-rule|et-upcase-syntax|et-variable|et-viper-state-in-major-mode|et-window-buffer-start-and-point|et-window-dot|et-window-new-normal|et-window-new-pixel|et-window-new-total|et-window-redisplay-end-trigger|et-window-text-height|et-woman-file-regexp|etenv-internal|etq-mode-local|etup-chinese-environment-map|etup-cyrillic-environment-map|etup-default-fontset|etup-ethiopic-environment-internal|etup-european-environment-map|etup-indian-environment-map|etup-japanese-environment-internal|etup-korean-environment-internal|etup-specified-language-environment|eventh|exp-at-point|gml-at-indentation-p|gml-attributes|gml-auto-attributes|gml-beginning-of-tag|gml-calculate-indent|gml-close-tag|gml-comment-indent-new-line|gml-comment-indent|gml-delete-tag|gml-electric-tag-pair-before-change-function|gml-electric-tag-pair-flush-overlays|gml-electric-tag-pair-mode|gml-empty-tag-p|gml-fill-nobreak|gml-get-context|gml-guess-indent|gml-html-meta-auto-coding-function|gml-indent-line|gml-lexical-context|gml-looking-back-at|gml-make-syntax-table|gml-make-tag--cmacro|gml-make-tag|gml-maybe-end-tag|gml-maybe-name-self|gml-mode-facemenu-add-face-function|gml-mode-flyspell-verify|gml-mode|gml-name-8bit-mode|gml-name-char|gml-name-self|gml-namify-char|gml-parse-dtd|gml-parse-tag-backward|gml-parse-tag-name|gml-point-entered|gml-pretty-print|gml-quote|gml-show-context|gml-skip-tag-backward|gml-skip-tag-forward|gml-slash-matching|gml-slash|gml-tag-end--cmacro|gml-tag-end|gml-tag-help|gml-tag-name--cmacro|gml-tag-name|gml-tag-p--cmacro|gml-tag-p|gml-tag-start--cmacro|gml-tag-start|gml-tag-text-p|gml-tag-type--cmacro|gml-tag-type|gml-tag|gml-tags-invisible|gml-unclosed-tag-p|gml-validate|gml-value|gml-xml-auto-coding-function|gml-xml-guess|h--cmd-completion-table|h--inside-noncommand-expression|h--maybe-here-document|h--vars-before-point|h-add-completer|h-add|h-after-hack-local-variables|h-append-backslash|h-append|h-assignment|h-backslash-region|h-basic-indent-line|h-beginning-of-command|h-blink|h-calculate-indent|h-canonicalize-shell|h-case|h-cd-here|h-check-rule|h-completion-at-point-function|h-current-defun-name|h-debug|h-delete-backslash|h-electric-here-document-mode|h-end-of-command|h-execute-region|h-feature|h-find-prev-matching|h-find-prev-switch|h-font-lock-backslash-quote|h-font-lock-keywords-1|h-font-lock-keywords-2|h-font-lock-keywords|h-font-lock-open-heredoc|h-font-lock-paren|h-font-lock-quoted-subshell|h-font-lock-syntactic-face-function|h-for|h-function|h-get-indent-info|h-get-indent-var-for-line|h-get-kw|h-get-word|h-goto-match-for-done|h-goto-matching-case|h-goto-matching-if|h-guess-basic-offset|h-handle-after-case-label|h-handle-prev-case-alt-end|h-handle-prev-case|h-handle-prev-do|h-handle-prev-done|h-handle-prev-else|h-handle-prev-esac|h-handle-prev-fi|h-handle-prev-if|h-handle-prev-open|h-handle-prev-rc-case|h-handle-prev-then|h-handle-this-close|h-handle-this-do|h-handle-this-done|h-handle-this-else|h-handle-this-esac|h-handle-this-fi|h-handle-this-rc-case|h-handle-this-then|h-help-string-for-variable|h-if|h-in-comment-or-string|h-indent-line|h-indexed-loop|h-is-quoted-p|h-learn-buffer-indent|h-learn-line-indent|h-load-style|h-make-vars-local|h-mark-init|h-mark-line|h-maybe-here-document|h-mkword-regexpr|h-mode-syntax-table|h-mode|h-modify|h-must-support-indent|h-name-style|h-prev-line|h-prev-stmt|h-prev-thing|h-quoted-p|h-read-variable|h-remember-variable|h-repeat|h-reset-indent-vars-to-global-values|h-safe-forward-sexp|h-save-styles-to-buffer|h-select|h-send-line-or-region-and-step|h-send-text|h-set-indent|h-set-shell|h-set-var-value|h-shell-initialize-variables|h-shell-process|h-show-indent|h-show-shell|h-smie--continuation-start-indent|h-smie--default-backward-token|h-smie--default-forward-token|h-smie--keyword-p|h-smie--looking-back-at-continuation-p|h-smie--newline-semi-p|h-smie--rc-after-special-arg-p|h-smie--rc-newline-semi-p|h-smie--sh-keyword-in-p|h-smie--sh-keyword-p|h-smie-rc-backward-token|h-smie-rc-forward-token|h-smie-rc-rules|h-smie-sh-backward-token|h-smie-sh-forward-token|h-smie-sh-rules|h-syntax-propertize-function|h-syntax-propertize-here-doc|h-this-is-a-continuation|h-tmp-file|h-until|h-var-value|h-while-getopts|h-while|ha1|hadow-add-to-todo|hadow-cancel|hadow-cluster-name|hadow-cluster-primary|hadow-cluster-regexp|hadow-contract-file-name|hadow-copy-files??|hadow-define-cluster|hadow-define-literal-group|hadow-define-regexp-group|hadow-expand-cluster-in-file-name|hadow-expand-file-name|hadow-file-match|hadow-find|hadow-get-cluster|hadow-get-user|hadow-initialize|hadow-insert-var|hadow-invalidate-hashtable|hadow-local-file|hadow-make-cluster|hadow-make-fullname|hadow-make-group|hadow-parse-fullname|hadow-parse-name|hadow-read-files|hadow-read-site|hadow-regexp-superquote|hadow-remove-from-todo|hadow-replace-name-component|hadow-same-site|hadow-save-buffers-kill-emacs|hadow-save-todo-file|hadow-set-cluster|hadow-shadows-of-1|hadow-shadows-of|hadow-shadows|hadow-site-cluster|hadow-site-match|hadow-site-primary|hadow-suffix|hadow-union|hadow-write-info-file|hadow-write-todo-file|hadowfile-unload-function|hared-initialize|hell--command-completion-data|hell--parse-pcomplete-arguments|hell--requote-argument|hell--unquote&requote-argument|hell--unquote-argument|hell-apply-ansi-color|hell-backward-command|hell-c-a-p-replace-by-expanded-directory|hell-cd|hell-command-completion-function|hell-command-completion|hell-command-on-region|hell-command-sentinel|hell-command|hell-completion-vars|hell-copy-environment-variable|hell-directory-tracker|hell-dirstack-message|hell-dirtrack-mode|hell-dirtrack-toggle|hell-dynamic-complete-command|hell-dynamic-complete-environment-variable|hell-dynamic-complete-filename|hell-environment-variable-completion|hell-extract-num|hell-filename-completion|hell-filter-ctrl-a-ctrl-b|hell-forward-command|hell-match-partial-variable|hell-mode|hell-prefixed-directory-name|hell-process-cd|hell-process-popd|hell-process-pushd|hell-quote-wildcard-pattern|hell-reapply-ansi-color|hell-replace-by-expanded-directory|hell-resync-dirs|hell-script-mode|hell-snarf-envar|hell-strip-ctrl-m|hell-unquote-argument|hell-write-history-on-exit|hell|hiftf|hould-error|hould-not|hould|how-all|how-branches|how-buffer|how-children|how-entry|how-ifdef-block|how-ifdefs|how-paren--categorize-paren|how-paren--default|how-paren--locate-near-paren|how-paren--unescaped-p|how-paren-function|how-paren-mode|how-subtree|hr--extract-best-source|hr--get-media-pref|hr-add-font|hr-browse-image|hr-browse-url|hr-buffer-width|hr-char-breakable-p--inliner|hr-char-breakable-p|hr-char-kinsoku-bol-p--inliner|hr-char-kinsoku-bol-p|hr-char-kinsoku-eol-p--inliner|hr-char-kinsoku-eol-p|hr-char-nospace-p--inliner|hr-char-nospace-p|hr-color->hexadecimal|hr-color-check|hr-color-hsl-to-rgb-fractions|hr-color-hue-to-rgb|hr-color-relative-to-absolute|hr-color-set-minimum-interval|hr-color-visible|hr-colorize-region|hr-column-specs|hr-copy-url|hr-count|hr-descend|hr-dom-print|hr-dom-to-xml|hr-encode-url|hr-ensure-newline|hr-ensure-paragraph|hr-expand-newlines|hr-expand-url|hr-find-fill-point|hr-fold-text|hr-fontize-dom|hr-generic|hr-get-image-data|hr-heading|hr-image-displayer|hr-image-fetched|hr-image-from-data|hr-indent)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)s(?:hr-insert-image|hr-insert-table-ruler|hr-insert-table|hr-insert|hr-make-table-1|hr-make-table|hr-max-columns|hr-mouse-browse-url|hr-next-link|hr-parse-base|hr-parse-image-data|hr-parse-style|hr-previous-link|hr-previous-newline-padding-width|hr-pro-rate-columns|hr-put-image|hr-remove-trailing-whitespace|hr-render-buffer|hr-render-region|hr-render-td|hr-rescale-image|hr-save-contents|hr-show-alt-text|hr-store-contents|hr-table-widths|hr-tag-a|hr-tag-audio|hr-tag-b|hr-tag-base|hr-tag-blockquote|hr-tag-body|hr-tag-br|hr-tag-comment|hr-tag-dd|hr-tag-del|hr-tag-div|hr-tag-dl|hr-tag-dt|hr-tag-em|hr-tag-font|hr-tag-h1|hr-tag-h2|hr-tag-h3|hr-tag-h4|hr-tag-h5|hr-tag-h6|hr-tag-hr|hr-tag-i|hr-tag-img|hr-tag-label|hr-tag-li|hr-tag-object|hr-tag-ol|hr-tag-p|hr-tag-pre|hr-tag-s|hr-tag-script|hr-tag-span|hr-tag-strong|hr-tag-style|hr-tag-sub|hr-tag-sup|hr-tag-svg|hr-tag-table-1|hr-tag-table|hr-tag-title|hr-tag-ul??|hr-tag-video|hr-urlify|hr-zoom-image|hrink-window-horizontally|hrink-window|huffle-vector|ieve-manage|ieve-mode|ieve-upload-and-bury|ieve-upload-and-kill|ieve-upload|ignum|imula-backward-up-level|imula-calculate-indent|imula-context|imula-electric-keyword|imula-electric-label|imula-expand-keyword|imula-expand-stdproc|imula-find-do-match|imula-find-if|imula-find-inspect|imula-forward-down-level|imula-forward-up-level|imula-goto-definition|imula-indent-command|imula-indent-exp|imula-indent-line|imula-inside-parens|imula-install-standard-abbrevs|imula-mode|imula-next-statement|imula-popup-menu|imula-previous-statement|imula-search-backward|imula-search-forward|imula-skip-comment-backward|imula-skip-comment-forward|imula-submit-bug-report|ixth|ize-indication-mode|keleton-insert|keleton-internal-1|keleton-internal-list|keleton-pair-insert-maybe|keleton-proxy-new|keleton-read|kip-line-prefix|litex-mode|lot-boundp|lot-exists-p|lot-makeunbound|lot-missing|lot-unbound|lot-value|mbclient-list-shares|mbclient-mode|mbclient|merge--get-marker|merge-apply-resolution-patch|merge-auto-combine|merge-auto-leave|merge-batch-resolve|merge-check|merge-combine-with-next|merge-conflict-overlay|merge-context-menu|merge-diff-base-mine|merge-diff-base-other|merge-diff-mine-other|merge-diff|merge-ediff|merge-ensure-match|merge-find-conflict|merge-get-current|merge-keep-all|merge-keep-base|merge-keep-current|merge-keep-mine|merge-keep-n|merge-keep-other|merge-kill-current|merge-makeup-conflict|merge-match-conflict|merge-mode-menu|merge-mode|merge-next|merge-popup-context-menu|merge-prev|merge-refine-chopup-region|merge-refine-forward|merge-refine-highlight-change|merge-refine-subst|merge-refine|merge-remove-props|merge-resolve--extract-comment|merge-resolve--normalize|merge-resolve-all|merge-resolve|merge-start-session|merge-swap|mie--associative-p|mie--matching-block-data|mie--next-indent-change|mie--opener/closer-at-point|mie-auto-fill|mie-backward-sexp-command|mie-backward-sexp|mie-blink-matching-check|mie-blink-matching-open|mie-bnf--classify|mie-bnf--closer-alist|mie-bnf--set-class|mie-config--advice|mie-config--get-trace|mie-config--guess-1|mie-config--guess-value|mie-config--guess|mie-config--mode-hook|mie-config--setter|mie-debug--describe-cycle|mie-debug--prec2-cycle|mie-default-backward-token|mie-default-forward-token|mie-edebug|mie-forward-sexp-command|mie-forward-sexp|mie-indent--bolp-1|mie-indent--bolp|mie-indent--hanging-p|mie-indent--offset|mie-indent--parent|mie-indent--rule-1|mie-indent--rule|mie-indent--separator-outdent|mie-indent-after-keyword|mie-indent-backward-token|mie-indent-bob|mie-indent-calculate|mie-indent-close|mie-indent-comment-close|mie-indent-comment-continue|mie-indent-comment-inside|mie-indent-comment|mie-indent-exps|mie-indent-fixindent|mie-indent-forward-token|mie-indent-inside-string|mie-indent-keyword|mie-indent-line|mie-indent-virtual|mie-next-sexp|mie-op-left|mie-op-right|mie-set-prec2tab|miley-buffer|miley-region|mtpmail-command-or-throw|mtpmail-cred-cert|mtpmail-cred-key|mtpmail-cred-passwd|mtpmail-cred-port|mtpmail-cred-server|mtpmail-cred-user|mtpmail-deduce-address-list|mtpmail-do-bcc|mtpmail-find-credentials|mtpmail-fqdn|mtpmail-intersection|mtpmail-maybe-append-domain|mtpmail-ok-p|mtpmail-process-filter|mtpmail-query-smtp-server|mtpmail-read-response|mtpmail-response-code|mtpmail-response-text|mtpmail-send-command|mtpmail-send-data-1|mtpmail-send-data|mtpmail-send-it|mtpmail-send-queued-mail|mtpmail-try-auth-methods??|mtpmail-user-mail-address|mtpmail-via-smtp|nake-active-p|nake-display-options|nake-end-game|nake-final-x-velocity|nake-final-y-velocity|nake-init-buffer|nake-mode|nake-move-down|nake-move-left|nake-move-right|nake-move-up|nake-pause-game|nake-reset-game|nake-start-game|nake-update-game|nake-update-score|nake-update-velocity|nake|narf-spooks|nmp-calculate-indent|nmp-common-mode|nmp-completing-read|nmp-indent-line|nmp-mode-imenu-create-index|nmp-mode|nmpv2-mode|oap-array-type-element-type--cmacro|oap-array-type-element-type|oap-array-type-name--cmacro|oap-array-type-name|oap-array-type-namespace-tag--cmacro|oap-array-type-namespace-tag|oap-array-type-p--cmacro|oap-array-type-p|oap-basic-type-kind--cmacro|oap-basic-type-kind|oap-basic-type-name--cmacro|oap-basic-type-name|oap-basic-type-namespace-tag--cmacro|oap-basic-type-namespace-tag|oap-basic-type-p--cmacro|oap-basic-type-p|oap-binding-name--cmacro|oap-binding-name|oap-binding-namespace-tag--cmacro|oap-binding-namespace-tag|oap-binding-operations--cmacro|oap-binding-operations|oap-binding-p--cmacro|oap-binding-p|oap-binding-port-type--cmacro|oap-binding-port-type|oap-bound-operation-operation--cmacro|oap-bound-operation-operation|oap-bound-operation-p--cmacro|oap-bound-operation-p|oap-bound-operation-soap-action--cmacro|oap-bound-operation-soap-action|oap-bound-operation-use--cmacro|oap-bound-operation-use|oap-create-envelope|oap-decode-any-type|oap-decode-array-type|oap-decode-array|oap-decode-basic-type|oap-decode-sequence-type|oap-decode-type|oap-default-soapenc-types|oap-default-xsd-types|oap-element-fq-name|oap-element-name--cmacro|oap-element-name|oap-element-namespace-tag--cmacro|oap-element-namespace-tag|oap-element-p--cmacro|oap-element-p|oap-encode-array-type|oap-encode-basic-type|oap-encode-body|oap-encode-sequence-type|oap-encode-simple-type|oap-encode-value|oap-extract-xmlns|oap-get-target-namespace|oap-invoke|oap-l2fq|oap-l2wk|oap-load-wsdl-from-url|oap-load-wsdl|oap-message-name--cmacro|oap-message-name|oap-message-namespace-tag--cmacro|oap-message-namespace-tag|oap-message-p--cmacro|oap-message-p|oap-message-parts--cmacro|oap-message-parts|oap-namespace-elements--cmacro|oap-namespace-elements|oap-namespace-get|oap-namespace-link-name--cmacro|oap-namespace-link-name|oap-namespace-link-namespace-tag--cmacro|oap-namespace-link-namespace-tag|oap-namespace-link-p--cmacro|oap-namespace-link-p|oap-namespace-link-target--cmacro|oap-namespace-link-target|oap-namespace-name--cmacro|oap-namespace-name|oap-namespace-p--cmacro|oap-namespace-p|oap-namespace-put-link|oap-namespace-put|oap-operation-faults--cmacro|oap-operation-faults|oap-operation-input--cmacro|oap-operation-input|oap-operation-name--cmacro|oap-operation-name|oap-operation-namespace-tag--cmacro|oap-operation-namespace-tag|oap-operation-output--cmacro|oap-operation-output|oap-operation-p--cmacro|oap-operation-p|oap-operation-parameter-order--cmacro|oap-operation-parameter-order|oap-parse-binding|oap-parse-complex-type-complex-content|oap-parse-complex-type-sequence|oap-parse-complex-type|oap-parse-envelope|oap-parse-message|oap-parse-operation|oap-parse-port-type|oap-parse-response|oap-parse-schema-element|oap-parse-schema|oap-parse-sequence|oap-parse-simple-type|oap-parse-wsdl|oap-port-binding--cmacro|oap-port-binding|oap-port-name--cmacro|oap-port-name|oap-port-namespace-tag--cmacro|oap-port-namespace-tag|oap-port-p--cmacro|oap-port-p|oap-port-service-url--cmacro|oap-port-service-url|oap-port-type-name--cmacro|oap-port-type-name|oap-port-type-namespace-tag--cmacro|oap-port-type-namespace-tag|oap-port-type-operations--cmacro|oap-port-type-operations|oap-port-type-p--cmacro|oap-port-type-p|oap-resolve-references-for-array-type|oap-resolve-references-for-binding|oap-resolve-references-for-element|oap-resolve-references-for-message|oap-resolve-references-for-operation|oap-resolve-references-for-port|oap-resolve-references-for-sequence-type|oap-resolve-references-for-simple-type|oap-sequence-element-multiple\\\\?--cmacro|oap-sequence-element-multiple\\\\?|oap-sequence-element-name--cmacro|oap-sequence-element-name|oap-sequence-element-nillable\\\\?--cmacro|oap-sequence-element-nillable\\\\?|oap-sequence-element-p--cmacro|oap-sequence-element-p|oap-sequence-element-type--cmacro|oap-sequence-element-type|oap-sequence-type-elements--cmacro|oap-sequence-type-elements|oap-sequence-type-name--cmacro|oap-sequence-type-name|oap-sequence-type-namespace-tag--cmacro|oap-sequence-type-namespace-tag|oap-sequence-type-p--cmacro|oap-sequence-type-p|oap-sequence-type-parent--cmacro|oap-sequence-type-parent|oap-simple-type-enumeration--cmacro|oap-simple-type-enumeration|oap-simple-type-kind--cmacro|oap-simple-type-kind|oap-simple-type-name--cmacro|oap-simple-type-name|oap-simple-type-namespace-tag--cmacro|oap-simple-type-namespace-tag|oap-simple-type-p--cmacro|oap-simple-type-p|oap-type-p|oap-warning|oap-with-local-xmlns|oap-wk2l|oap-wsdl-add-alias|oap-wsdl-add-namespace|oap-wsdl-alias-table--cmacro|oap-wsdl-alias-table|oap-wsdl-find-namespace|oap-wsdl-get|oap-wsdl-namespaces--cmacro|oap-wsdl-namespaces|oap-wsdl-origin--cmacro|oap-wsdl-origin|oap-wsdl-p--cmacro|oap-wsdl-p|oap-wsdl-ports--cmacro|oap-wsdl-ports|oap-wsdl-resolve-references|oap-xml-get-attribute-or-nil1|oap-xml-get-children1|ocks-build-auth-list|ocks-chap-auth|ocks-cram-auth|ocks-filter|ocks-find-route|ocks-find-services-entry|ocks-gssapi-auth|ocks-nslookup-host|ocks-open-connection|ocks-open-network-stream|ocks-original-open-network-stream|ocks-parse-services|ocks-register-authentication-method|ocks-send-command|ocks-split-string|ocks-unregister-authentication-method|ocks-username/password-auth-filter|ocks-username/password-auth|ocks-wait-for-state-change|olicit-char-in-string|olitaire-build-mode-line|olitaire-center-point|olitaire-check|olitaire-current-line|olitaire-do-check|olitaire-down|olitaire-insert-board|olitaire-left|olitaire-mode|olitaire-move-down|olitaire-move-left|olitaire-move-right|olitaire-move-up|olitaire-move|olitaire-possible-move|olitaire-right|olitaire-solve|olitaire-undo|olitaire-up|olitaire|ome-window|ome|ort\\\\*|ort-build-lists|ort-charsets|ort-coding-systems|ort-fields-1|ort-pages-buffer|ort-pages-in-region|ort-regexp-fields-next-record|ort-reorder-buffer|ort-skip-fields|oundex|paces-string|pam-initialize|pam-report-agentize|pam-report-deagentize|pam-report-process-queue|pam-report-url-ping-mm-url|pam-report-url-to-file|pecial-display-p|pecial-display-popup-frame|peedbar-add-expansion-list|peedbar-add-ignored-directory-regexp|peedbar-add-ignored-path-regexp|peedbar-add-indicator|peedbar-add-localized-speedbar-support|peedbar-add-mode-functions-list|peedbar-add-supported-extension|peedbar-backward-list|peedbar-buffer-buttons-engine|peedbar-buffer-buttons-temp|peedbar-buffer-buttons|peedbar-buffer-click|peedbar-buffer-kill-buffer|peedbar-buffer-revert-buffer|peedbar-buffers-item-info|peedbar-buffers-line-directory|peedbar-buffers-line-path|peedbar-buffers-tail-notes|peedbar-center-buffer-smartly|peedbar-change-expand-button-char|peedbar-change-initial-expansion-list|peedbar-check-obj-this-line|peedbar-check-objects|peedbar-check-read-only|peedbar-check-vc-this-line|peedbar-check-vc|peedbar-clear-current-file|peedbar-click|peedbar-contract-line-descendants|peedbar-contract-line|peedbar-create-directory)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(?:speedbar-create-tag-hierarchy|speedbar-current-frame|speedbar-customize|speedbar-default-directory-list|speedbar-delete-overlay|speedbar-delete-subblock|speedbar-dir-follow|speedbar-directory-buttons-follow|speedbar-directory-buttons|speedbar-directory-line|speedbar-dired|speedbar-disable-update|speedbar-do-function-pointer|speedbar-edit-line|speedbar-enable-update|speedbar-expand-line-descendants|speedbar-expand-line|speedbar-extension-list-to-regex|speedbar-extract-one-symbol|speedbar-fetch-dynamic-etags|speedbar-fetch-dynamic-imenu|speedbar-fetch-dynamic-tags|speedbar-fetch-replacement-function|speedbar-file-lists|speedbar-files-item-info|speedbar-files-line-directory|speedbar-find-file-in-frame|speedbar-find-file|speedbar-find-selected-file|speedbar-flush-expand-line|speedbar-forward-list|speedbar-frame-mode|speedbar-frame-reposition-smartly|speedbar-frame-width|speedbar-generic-item-info|speedbar-generic-list-group-p|speedbar-generic-list-positioned-group-p|speedbar-generic-list-tag-p|speedbar-get-focus|speedbar-goto-this-file|speedbar-handle-delete-frame|speedbar-highlight-one-tag-line|speedbar-image-dump|speedbar-initial-expansion-list|speedbar-initial-keymap|speedbar-initial-menu|speedbar-initial-stealthy-functions|speedbar-insert-button|speedbar-insert-etags-list|speedbar-insert-files-at-point|speedbar-insert-generic-list|speedbar-insert-image-button-maybe|speedbar-insert-imenu-list|speedbar-insert-separator|speedbar-item-byte-compile|speedbar-item-copy|speedbar-item-delete|speedbar-item-info-file-helper|speedbar-item-info-tag-helper|speedbar-item-info|speedbar-item-load|speedbar-item-object-delete|speedbar-item-rename|speedbar-line-directory|speedbar-line-file|speedbar-line-path|speedbar-line-text|speedbar-line-token|speedbar-make-button|speedbar-make-overlay|speedbar-make-specialized-keymap|speedbar-make-tag-line|speedbar-maybe-add-localized-support|speedbar-maybee-jump-to-attached-frame|speedbar-message|speedbar-mode-line-update|speedbar-mode|speedbar-mouse-item-info|speedbar-navigate-list|speedbar-next|speedbar-overlay-put|speedbar-parse-c-or-c\\\\+\\\\+tag|speedbar-parse-tex-string|speedbar-path-line|speedbar-position-cursor-on-line|speedbar-prefix-group-tag-hierarchy|speedbar-prev|speedbar-recenter-to-top|speedbar-recenter|speedbar-reconfigure-keymaps|speedbar-refresh|speedbar-remove-localized-speedbar-support|speedbar-reset-scanners|speedbar-restricted-move|speedbar-restricted-next|speedbar-restricted-prev|speedbar-scroll-down|speedbar-scroll-up|speedbar-select-attached-frame|speedbar-set-mode-line-format|speedbar-set-timer|speedbar-show-info-under-mouse|speedbar-simple-group-tag-hierarchy|speedbar-sort-tag-hierarchy|speedbar-stealthy-updates|speedbar-tag-expand|speedbar-tag-file|speedbar-tag-find|speedbar-this-file-in-vc|speedbar-timer-fn|speedbar-toggle-etags|speedbar-toggle-images|speedbar-toggle-line-expansion|speedbar-toggle-show-all-files|speedbar-toggle-sorting|speedbar-toggle-updates|speedbar-track-mouse|speedbar-trim-words-tag-hierarchy|speedbar-try-completion|speedbar-unhighlight-one-tag-line|speedbar-up-directory|speedbar-update-contents|speedbar-update-current-file|speedbar-update-directory-contents|speedbar-update-localized-contents|speedbar-update-special-contents|speedbar-vc-check-dir-p|speedbar-with-attached-buffer|speedbar-with-writable|speedbar-y-or-n-p|speedbar|split-char|split-line|split-window-horizontally|split-window-internal|split-window-vertically|spook|sql--completion-table|sql--make-help-docstring|sql--oracle-show-reserved-words|sql-accumulate-and-indent|sql-add-product-keywords|sql-add-product|sql-beginning-of-statement|sql-buffer-live-p|sql-build-completions-1|sql-build-completions|sql-comint-db2|sql-comint-informix|sql-comint-ingres|sql-comint-interbase|sql-comint-linter|sql-comint-ms|sql-comint-mysql|sql-comint-oracle|sql-comint-postgres|sql-comint-solid|sql-comint-sqlite|sql-comint-sybase|sql-comint-vertica|sql-comint|sql-connect|sql-connection-menu-filter|sql-copy-column|sql-db2|sql-default-value|sql-del-product|sql-end-of-statement|sql-ends-with-prompt-re|sql-escape-newlines-filter|sql-execute-feature|sql-execute|sql-find-sqli-buffer|sql-font-lock-keywords-builder|sql-for-each-login|sql-get-login-ext|sql-get-login|sql-get-product-feature|sql-help-list-products|sql-help|sql-highlight-ansi-keywords|sql-highlight-db2-keywords|sql-highlight-informix-keywords|sql-highlight-ingres-keywords|sql-highlight-interbase-keywords|sql-highlight-linter-keywords|sql-highlight-ms-keywords|sql-highlight-mysql-keywords|sql-highlight-oracle-keywords|sql-highlight-postgres-keywords|sql-highlight-product|sql-highlight-solid-keywords|sql-highlight-sqlite-keywords|sql-highlight-sybase-keywords|sql-highlight-vertica-keywords|sql-informix|sql-ingres|sql-input-sender|sql-interactive-mode-menu|sql-interactive-mode|sql-interactive-remove-continuation-prompt|sql-interbase|sql-linter|sql-list-all|sql-list-table|sql-magic-go|sql-magic-semicolon|sql-make-alternate-buffer-name|sql-mode-menu|sql-mode|sql-ms|sql-mysql|sql-oracle-completion-object|sql-oracle-list-all|sql-oracle-list-table|sql-oracle-restore-settings|sql-oracle-save-settings|sql-oracle|sql-placeholders-filter|sql-postgres-completion-object|sql-postgres|sql-product-font-lock-syntax-alist|sql-product-font-lock|sql-product-interactive|sql-product-syntax-table|sql-read-connection|sql-read-product|sql-read-table-name|sql-redirect-one|sql-redirect-value|sql-redirect|sql-regexp-abbrev-list|sql-regexp-abbrev|sql-remove-tabs-filter|sql-rename-buffer|sql-save-connection|sql-send-buffer|sql-send-line-and-next|sql-send-magic-terminator|sql-send-paragraph|sql-send-region|sql-send-string|sql-set-product-feature|sql-set-product|sql-set-sqli-buffer-generally|sql-set-sqli-buffer|sql-show-sqli-buffer|sql-solid|sql-sqlite-completion-object|sql-sqlite|sql-starts-with-prompt-re|sql-statement-regexp|sql-stop|sql-str-literal|sql-sybase|sql-toggle-pop-to-buffer-after-send-region|sql-vertica|squeeze-bidi-context-1|squeeze-bidi-context|srecode-compile-templates|srecode-document-insert-comment|srecode-document-insert-function-comment|srecode-document-insert-group-comments|srecode-document-insert-variable-one-line-comment|srecode-get-maps|srecode-insert-getset|srecode-insert-prototype-expansion|srecode-insert|srecode-minor-mode|srecode-semantic-handle-:c|srecode-semantic-handle-:cpp|srecode-semantic-handle-:el-custom|srecode-semantic-handle-:el|srecode-semantic-handle-:java|srecode-semantic-handle-:srt|srecode-semantic-handle-:texi|srecode-semantic-handle-:texitag|srecode-template-mode|srecode-template-setup-parser|srt-mode|stable-sort|standard-class|standard-display-8bit|standard-display-ascii|standard-display-cyrillic-translit|standard-display-default|standard-display-european-internal|standard-display-european|standard-display-g1|standard-display-graphic|standard-display-underline|start-kbd-macro|start-of-paragraph-text|start-scheme|starttls-any-program-available|starttls-available-p|starttls-negotiate-gnutls|starttls-negotiate|starttls-open-stream-gnutls|starttls-open-stream|starttls-set-process-query-on-exit-flag|startup-echo-area-message|straight-use-package|store-kbd-macro-event|string-blank-p|string-collate-equalp|string-collate-lessp|string-empty-p|string-insert-rectangle|string-join|string-make-multibyte|string-make-unibyte|string-rectangle-line|string-rectangle|string-remove-prefix|string-remove-suffix|string-reverse|string-to-list|string-to-vector|string-trim-left|string-trim-right|string-trim|strokes-alphabetic-lessp|strokes-button-press-event-p|strokes-button-release-event-p|strokes-click-p|strokes-compose-complex-stroke|strokes-decode-buffer|strokes-define-stroke|strokes-describe-stroke|strokes-distance-squared|strokes-do-complex-stroke|strokes-do-stroke|strokes-eliminate-consecutive-redundancies|strokes-encode-buffer|strokes-event-closest-point-1|strokes-event-closest-point|strokes-execute-stroke|strokes-fill-current-buffer-with-whitespace|strokes-fill-stroke|strokes-get-grid-position|strokes-get-stroke-extent|strokes-global-set-stroke-string|strokes-global-set-stroke|strokes-help|strokes-lift-p|strokes-list-strokes|strokes-load-user-strokes|strokes-match-stroke|strokes-mode|strokes-mouse-event-p|strokes-prompt-user-save-strokes|strokes-rate-stroke|strokes-read-complex-stroke|strokes-read-stroke|strokes-remassoc|strokes-renormalize-to-grid|strokes-report-bug|strokes-square|strokes-toggle-strokes-buffer|strokes-unload-function|strokes-unset-last-stroke|strokes-update-window-configuration|strokes-window-configuration-changed-p|strokes-xpm-char-bit-p|strokes-xpm-char-on-p|strokes-xpm-decode-char|strokes-xpm-encode-length-as-string|strokes-xpm-for-compressed-string|strokes-xpm-for-stroke|strokes-xpm-to-compressed-string|studlify-buffer|studlify-region|studlify-word|sublis|subr-name|subregexp-context-p|subseq|subsetp|subst-char-in-string|subst-if-not|subst-if|subst|substitute-env-in-file-name|substitute-env-vars|substitute-if-not|substitute-if|substitute-key-definition-key|substitute|subtract-time|subword-mode|sunrise-sunset|superword-mode|suspicious-object|svref|switch-to-completions|switch-to-lisp|switch-to-prolog|switch-to-scheme|switch-to-tcl|symbol-at-point|symbol-before-point-for-complete|symbol-before-point|symbol-macrolet|symbol-under-or-before-point|symbol-under-point|syntax-ppss-after-change-function|syntax-ppss-context|syntax-ppss-debug|syntax-ppss-depth|syntax-ppss-stats|syntax-propertize--shift-groups|syntax-propertize-multiline|syntax-propertize-precompile-rules|syntax-propertize-rules|syntax-propertize-via-font-lock|syntax-propertize-wholelines|syntax-propertize|t-mouse-mode|tabify|table--at-cell-p|table--buffer-substring-and-trim|table--cancel-timer|table--cell-blank-str|table--cell-can-span-p|table--cell-can-split-horizontally-p|table--cell-can-split-vertically-p|table--cell-horizontal-char-p|table--cell-insert-char|table--cell-list-to-coord-list|table--cell-to-coord|table--char-in-str-at-column|table--copy-coordinate|table--create-growing-space-below|table--current-line|table--detect-cell-alignment|table--editable-cell-p|table--fill-region-strictly|table--fill-region|table--find-row-column|table--finish-delayed-tasks|table--generate-source-cell-contents|table--generate-source-cells-in-a-row|table--generate-source-epilogue|table--generate-source-prologue|table--generate-source-scan-lines|table--generate-source-scan-rows|table--get-cell-justify-property|table--get-cell-valign-property|table--get-coordinate|table--get-last-command|table--get-property|table--goto-coordinate|table--horizontal-cell-list|table--horizontally-shift-above-and-below|table--insert-rectangle|table--justify-cell-contents|table--line-column-position|table--log|table--make-cell-map|table--measure-max-width|table--min-coord-list|table--multiply-string|table--offset-coordinate|table--point-entered-cell-function|table--point-in-cell-p|table--point-left-cell-function|table--probe-cell-left-up|table--probe-cell-right-bottom|table--probe-cell|table--put-cell-content-property|table--put-cell-face-property|table--put-cell-indicator-property|table--put-cell-justify-property|table--put-cell-keymap-property|table--put-cell-line-property|table--put-cell-point-entered/left-property|table--put-cell-property|table--put-cell-rear-nonsticky|table--put-cell-valign-property|table--put-property|table--query-justification|table--read-from-minibuffer|table--region-in-cell-p|table--remove-blank-lines|table--remove-cell-properties|table--remove-eol-spaces|table--row-column-insertion-point-p|table--set-timer|table--spacify-frame|table--str-index-at-column|table--string-to-number-list|table--test-cell-list|table--transcoord-cache-to-table|table--transcoord-table-to-cache|table--uniform-list-p|table--untabify-line|table--untabify|table--update-cell-face|table--update-cell-heightened|table--update-cell-widened|table--update-cell|table--valign|table--vertical-cell-list|table--warn-incompatibility|table-backward-cell|table-capture|table-delete-column|table-delete-row|table-fixed-width-mode|table-forward-cell|table-function|table-generate-source|table-get-source-info|table-global-menu-map|table-goto-bottom-left-corner|table-goto-bottom-right-corner|table-goto-top-left-corner|table-goto-top-right-corner|table-heighten-cell|table-insert-column|table-insert-row-column|table-insert-row|table-insert-sequence|table-insert|table-justify-cell|table-justify-column|table-justify-row|table-justify|table-narrow-cell|table-put-source-info|table-query-dimension|table-recognize-cell|table-recognize-region)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)t(?:able-recognize-table|able-recognize|able-release|able-shorten-cell|able-span-cell|able-split-cell-horizontally|able-split-cell-vertically|able-split-cell|able-unrecognize-cell|able-unrecognize-region|able-unrecognize-table|able-unrecognize|able-widen-cell|able-with-cache-buffer|abulated-list--column-number|abulated-list--sort-by-column-name|abulated-list-col-sort|abulated-list-delete-entry|abulated-list-entry-size->|abulated-list-get-entry|abulated-list-get-id|abulated-list-print-col|abulated-list-print-entry|abulated-list-print-fake-header|abulated-list-put-tag|abulated-list-revert|abulated-list-set-col|abulated-list-sort|ag-any-match-p|ag-exact-file-name-match-p|ag-exact-match-p|ag-file-name-match-p|ag-find-file-of-tag-noselect|ag-find-file-of-tag|ag-implicit-name-match-p|ag-partial-file-name-match-p|ag-re-match-p|ag-symbol-match-p|ag-word-match-p|ags-apropos|ags-complete-tags-table-file|ags-completion-at-point-function|ags-completion-table|ags-expand-table-name|ags-included-tables|ags-lazy-completion-table|ags-loop-continue|ags-loop-eval|ags-next-table|ags-query-replace|ags-recognize-empty-tags-table|ags-reset-tags-tables|ags-search|ags-table-check-computed-list|ags-table-extend-computed-list|ags-table-files|ags-table-including|ags-table-list-member|ags-table-mode|ags-verify-table|ags-with-face|ai-viet-composition-function|ailp|alk-add-display|alk-connect|alk-disconnect|alk-handle-delete-frame|alk-split-up-frame|alk-update-buffers|alk|ar--check-descriptor|ar--extract|ar-alter-one-field|ar-change-major-mode-hook|ar-chgrp-entry|ar-chmod-entry|ar-chown-entry|ar-clear-modification-flags|ar-clip-time-string|ar-copy|ar-current-descriptor|ar-data-swapped-p|ar-display-other-window|ar-expunge-internal|ar-expunge|ar-extract-other-window|ar-extract|ar-file-name-handler|ar-flag-deleted|ar-get-descriptor|ar-get-file-descriptor|ar-grind-file-mode|ar-header-block-check-checksum|ar-header-block-checksum|ar-header-block-summarize|ar-header-block-tokenize|ar-header-checksum--cmacro|ar-header-checksum|ar-header-data-end|ar-header-data-start--cmacro|ar-header-data-start|ar-header-date--cmacro|ar-header-date|ar-header-dmaj--cmacro|ar-header-dmaj|ar-header-dmin--cmacro|ar-header-dmin|ar-header-gid--cmacro|ar-header-gid|ar-header-gname--cmacro|ar-header-gname|ar-header-header-start--cmacro|ar-header-header-start|ar-header-link-name--cmacro|ar-header-link-name|ar-header-link-type--cmacro|ar-header-link-type|ar-header-magic--cmacro|ar-header-magic|ar-header-mode--cmacro|ar-header-mode|ar-header-name--cmacro|ar-header-name|ar-header-p--cmacro|ar-header-p|ar-header-size--cmacro|ar-header-size|ar-header-uid--cmacro|ar-header-uid|ar-header-uname--cmacro|ar-header-uname|ar-mode-kill-buffer-hook|ar-mode-revert|ar-mode|ar-mouse-extract|ar-next-line|ar-octal-time|ar-pad-to-blocksize|ar-parse-octal-integer-safe|ar-parse-octal-integer|ar-parse-octal-long-integer|ar-previous-line|ar-read-file-name|ar-rename-entry|ar-roundup-512|ar-subfile-mode|ar-subfile-save-buffer|ar-summarize-buffer|ar-swap-data|ar-unflag-backwards|ar-unflag|ar-untar-buffer|ar-view|ar-write-region-annotate|cl-add-log-defun|cl-auto-fill-mode|cl-beginning-of-defun|cl-calculate-indent|cl-comment-indent|cl-current-word|cl-electric-brace|cl-electric-char|cl-electric-hash|cl-end-of-defun|cl-eval-defun|cl-eval-region|cl-figure-type|cl-files-alist|cl-filter|cl-guess-application|cl-hairy-scan-for-comment|cl-hashify-buffer|cl-help-on-word|cl-help-snarf-commands|cl-in-comment|cl-indent-command|cl-indent-exp|cl-indent-for-comment|cl-indent-line|cl-load-file|cl-mark-defun|cl-mark|cl-mode-menu|cl-mode|cl-outline-level|cl-popup-menu|cl-quote|cl-real-command-p|cl-real-comment-p|cl-reread-help-files|cl-restart-with-file|cl-send-region|cl-send-string|cl-set-font-lock-keywords|cl-set-proc-regexp|cl-uncomment-region|cl-word-no-props|ear-off-window|elnet-c-z|elnet-check-software-type-initialize|elnet-filter|elnet-initial-filter|elnet-interrupt-subjob|elnet-mode|elnet-send-input|elnet-simple-send|elnet|emp-buffer-resize-mode|emp-buffer-window-setup|emp-buffer-window-show|empo-add-tag|empo-backward-mark|empo-build-collection|empo-complete-tag|empo-define-template|empo-display-completions|empo-expand-if-complete|empo-find-match-string|empo-forget-insertions|empo-forward-mark|empo-insert-mark|empo-insert-named|empo-insert-prompt-compat|empo-insert-prompt|empo-insert-template|empo-insert|empo-invalidate-collection|empo-is-user-element|empo-lookup-named|empo-process-and-insert-string|empo-save-named|empo-template-dcl-f\\\\$context|empo-template-dcl-f\\\\$csid|empo-template-dcl-f\\\\$cvsi|empo-template-dcl-f\\\\$cvtime|empo-template-dcl-f\\\\$cvui|empo-template-dcl-f\\\\$device|empo-template-dcl-f\\\\$directory|empo-template-dcl-f\\\\$edit|empo-template-dcl-f\\\\$element|empo-template-dcl-f\\\\$environment|empo-template-dcl-f\\\\$extract|empo-template-dcl-f\\\\$fao|empo-template-dcl-f\\\\$file_attributes|empo-template-dcl-f\\\\$getdvi|empo-template-dcl-f\\\\$getjpi|empo-template-dcl-f\\\\$getqui|empo-template-dcl-f\\\\$getsyi|empo-template-dcl-f\\\\$identifier|empo-template-dcl-f\\\\$integer|empo-template-dcl-f\\\\$length|empo-template-dcl-f\\\\$locate|empo-template-dcl-f\\\\$message|empo-template-dcl-f\\\\$mode|empo-template-dcl-f\\\\$parse|empo-template-dcl-f\\\\$pid|empo-template-dcl-f\\\\$privilege|empo-template-dcl-f\\\\$process|empo-template-dcl-f\\\\$search|empo-template-dcl-f\\\\$setprv|empo-template-dcl-f\\\\$string|empo-template-dcl-f\\\\$time|empo-template-dcl-f\\\\$trnlnm|empo-template-dcl-f\\\\$type|empo-template-dcl-f\\\\$user|empo-template-dcl-f\\\\$verify|empo-template-snmp-object-type|empo-template-snmp-table-type|empo-template-snmpv2-object-type|empo-template-snmpv2-table-type|empo-template-snmpv2-textual-convention|empo-use-tag-list|enth|erm-adjust-current-row-cache|erm-after-pmark-p|erm-ansi-make-term|erm-ansi-reset|erm-args|erm-arguments|erm-backward-matching-input|erm-bol|erm-buffer-vertical-motion|erm-char-mode|erm-check-kill-echo-list|erm-check-proc|erm-check-size|erm-check-source|erm-command-hook|erm-continue-subjob|erm-copy-old-input|erm-current-column|erm-current-row|erm-delchar-or-maybe-eof|erm-delete-chars|erm-delete-lines|erm-delim-arg|erm-directory|erm-display-buffer-line|erm-display-line|erm-down|erm-dynamic-complete-as-filename|erm-dynamic-complete-filename|erm-dynamic-complete|erm-dynamic-list-completions|erm-dynamic-list-filename-completions|erm-dynamic-list-input-ring|erm-dynamic-simple-complete|erm-emulate-terminal|erm-erase-in-display|erm-erase-in-line|erm-exec-1|erm-exec|erm-extract-string|erm-forward-matching-input|erm-get-old-input-default|erm-get-source|erm-goto-home|erm-goto|erm-handle-ansi-escape|erm-handle-ansi-terminal-messages|erm-handle-colors-array|erm-handle-deferred-scroll|erm-handle-exit|erm-handle-scroll|erm-handling-pager|erm-horizontal-column|erm-how-many-region|erm-in-char-mode|erm-in-line-mode|erm-insert-char|erm-insert-lines|erm-insert-spaces|erm-interrupt-subjob|erm-kill-input|erm-kill-output|erm-kill-subjob|erm-line-mode|erm-magic-space|erm-match-partial-filename|erm-mode|erm-mouse-paste|erm-move-columns|erm-next-input|erm-next-matching-input-from-input|erm-next-matching-input|erm-next-prompt|erm-pager-back-line|erm-pager-back-page|erm-pager-bob|erm-pager-continue|erm-pager-disable|erm-pager-discard|erm-pager-enabled??|erm-pager-eob|erm-pager-help|erm-pager-line|erm-pager-menu|erm-pager-page|erm-pager-toggle|erm-paste|erm-previous-input-string|erm-previous-input|erm-previous-matching-input-from-input|erm-previous-matching-input-string-position|erm-previous-matching-input-string|erm-previous-matching-input|erm-previous-prompt|erm-proc-query|erm-process-pager|erm-quit-subjob|erm-read-input-ring|erm-read-noecho|erm-regexp-arg|erm-replace-by-expanded-filename|erm-replace-by-expanded-history-before-point|erm-replace-by-expanded-history|erm-reset-size|erm-reset-terminal|erm-search-arg|erm-search-start|erm-send-backspace|erm-send-del|erm-send-down|erm-send-end|erm-send-eof|erm-send-home|erm-send-input|erm-send-insert|erm-send-invisible|erm-send-left|erm-send-next|erm-send-prior|erm-send-raw-meta|erm-send-raw-string|erm-send-raw|erm-send-region|erm-send-right|erm-send-string|erm-send-up|erm-sentinel|erm-set-escape-char|erm-set-scroll-region|erm-show-maximum-output|erm-show-output|erm-signals-menu|erm-simple-send|erm-skip-prompt|erm-source-default|erm-start-line-column|erm-start-output-log|erm-stop-output-log|erm-stop-subjob|erm-terminal-menu|erm-terminal-pos|erm-unwrap-line|erm-update-mode-line|erm-using-alternate-sub-buffer|erm-vertical-motion|erm-window-width|erm-within-quotes|erm-word|erm-write-input-ring|erm|estcover-1value|estcover-after|estcover-end|estcover-enter|estcover-mark|estcover-read|estcover-reinstrument-compose|estcover-reinstrument-list|estcover-reinstrument|estcover-this-defun|estcover-unmark-all|etris-active-p|etris-default-update-speed-function|etris-display-options|etris-draw-border-p|etris-draw-next-shape|etris-draw-score|etris-draw-shape|etris-end-game|etris-erase-shape|etris-full-row|etris-get-shape-cell|etris-get-tick-period|etris-init-buffer|etris-mode|etris-move-bottom|etris-move-left|etris-move-right|etris-new-shape|etris-pause-game|etris-reset-game|etris-rotate-next|etris-rotate-prev|etris-shape-done|etris-shape-rotations|etris-shape-width|etris-shift-down|etris-shift-row|etris-start-game|etris-test-shape|etris-update-game|etris-update-score|etris|ex-alt-print|ex-append|ex-bibtex-file|ex-buffer|ex-categorize-whitespace|ex-close-latex-block|ex-cmd-doc-view|ex-command-active-p|ex-command-executable|ex-common-initialization|ex-compile-default|ex-compile|ex-count-words|ex-current-defun-name|ex-define-common-keys|ex-delete-last-temp-files|ex-display-shell|ex-env-mark|ex-executable-exists-p|ex-expand-files|ex-facemenu-add-face-function|ex-feed-input|ex-file|ex-font-lock-append-prop|ex-font-lock-match-suscript|ex-font-lock-suscript|ex-font-lock-syntactic-face-function|ex-font-lock-unfontify-region|ex-font-lock-verb|ex-format-cmd|ex-generate-zap-file-name|ex-goto-last-unclosed-latex-block|ex-guess-main-file|ex-guess-mode|ex-insert-braces|ex-insert-quote|ex-kill-job|ex-last-unended-begin|ex-last-unended-eparen|ex-latex-block|ex-main-file|ex-mode-flyspell-verify|ex-mode-internal|ex-mode|ex-next-unmatched-end|ex-next-unmatched-eparen|ex-old-error-file-name|ex-print|ex-recenter-output-buffer|ex-region-header|ex-region|ex-search-noncomment|ex-send-command|ex-send-tex-command|ex-set-buffer-directory|ex-shell-buf-no-error|ex-shell-buf|ex-shell-proc|ex-shell-running|ex-shell-sentinel|ex-shell|ex-show-print-queue|ex-start-shell|ex-start-tex|ex-string-prefix-p|ex-summarize-command|ex-suscript-height|ex-terminate-paragraph|ex-uptodate-p|ex-validate-buffer|ex-validate-region|ex-view|exi2info|exinfmt-version|exinfo-alias|exinfo-all-menus-update|exinfo-alphaenumerate-item|exinfo-alphaenumerate|exinfo-anchor|exinfo-append-refill|exinfo-capsenumerate-item|exinfo-capsenumerate|exinfo-check-for-node-name|exinfo-clean-up-node-line|exinfo-clear|exinfo-clone-environment|exinfo-copy-menu-title|exinfo-copy-menu|exinfo-copy-next-section-title|exinfo-copy-node-name|exinfo-copy-section-title|exinfo-copying|exinfo-current-defun-name|exinfo-define-common-keys|exinfo-define-info-enclosure|exinfo-delete-existing-pointers|exinfo-delete-from-print-queue|exinfo-delete-old-menu|exinfo-description|exinfo-discard-command-and-arg|exinfo-discard-command|exinfo-discard-line-with-args|exinfo-discard-line|exinfo-do-flushright|exinfo-do-itemize|exinfo-end-alphaenumerate|exinfo-end-capsenumerate|exinfo-end-defun|exinfo-end-direntry|exinfo-end-enumerate|exinfo-end-example|exinfo-end-flushleft)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)t(?:exinfo-end-flushright|exinfo-end-ftable|exinfo-end-indextable|exinfo-end-itemize|exinfo-end-multitable|exinfo-end-table|exinfo-end-vtable|exinfo-enumerate-item|exinfo-enumerate|exinfo-every-node-update|exinfo-filter|exinfo-find-higher-level-node|exinfo-find-lower-level-node|exinfo-find-pointer|exinfo-footnotestyle|exinfo-format-\\\\.|exinfo-format-:|exinfo-format-French-OE-ligature|exinfo-format-French-oe-ligature|exinfo-format-German-sharp-S|exinfo-format-Latin-Scandinavian-AE|exinfo-format-Latin-Scandinavian-ae|exinfo-format-Polish-suppressed-L|exinfo-format-Polish-suppressed-l-lower-case|exinfo-format-Scandinavian-A-with-circle|exinfo-format-Scandinavian-O-with-slash|exinfo-format-Scandinavian-a-with-circle|exinfo-format-Scandinavian-o-with-slash-lower-case|exinfo-format-TeX|exinfo-format-begin-end|exinfo-format-begin|exinfo-format-breve-accent|exinfo-format-buffer-1|exinfo-format-buffer|exinfo-format-bullet|exinfo-format-cedilla-accent|exinfo-format-center|exinfo-format-chapter-1|exinfo-format-chapter|exinfo-format-cindex|exinfo-format-code|exinfo-format-convert|exinfo-format-copyright|exinfo-format-ctrl|exinfo-format-defcv|exinfo-format-deffn|exinfo-format-defindex|exinfo-format-defivar|exinfo-format-defmethod|exinfo-format-defn|exinfo-format-defop|exinfo-format-deftypefn|exinfo-format-deftypefun|exinfo-format-defun-1|exinfo-format-defunx??|exinfo-format-dircategory|exinfo-format-direntry|exinfo-format-documentdescription|exinfo-format-dotless|exinfo-format-dots|exinfo-format-email|exinfo-format-emph|exinfo-format-end-node|exinfo-format-end|exinfo-format-enddots|exinfo-format-equiv|exinfo-format-error|exinfo-format-example|exinfo-format-exdent|exinfo-format-expand-region|exinfo-format-expansion|exinfo-format-findex|exinfo-format-flushleft|exinfo-format-flushright|exinfo-format-footnote|exinfo-format-hacek-accent|exinfo-format-html|exinfo-format-ifeq|exinfo-format-ifhtml|exinfo-format-ifnotinfo|exinfo-format-ifplaintext|exinfo-format-iftex|exinfo-format-ifxml|exinfo-format-ignore|exinfo-format-image|exinfo-format-inforef|exinfo-format-kbd|exinfo-format-key|exinfo-format-kindex|exinfo-format-long-Hungarian-umlaut|exinfo-format-menu|exinfo-format-minus|exinfo-format-node|exinfo-format-noop|exinfo-format-option|exinfo-format-overdot-accent|exinfo-format-paragraph-break|exinfo-format-parse-args|exinfo-format-parse-defun-args|exinfo-format-parse-line-args|exinfo-format-pindex|exinfo-format-point|exinfo-format-pounds|exinfo-format-print|exinfo-format-printindex|exinfo-format-pxref|exinfo-format-refill|exinfo-format-region|exinfo-format-result|exinfo-format-ring-accent|exinfo-format-scan|exinfo-format-section|exinfo-format-sectionpad|exinfo-format-separate-node|exinfo-format-setfilename|exinfo-format-soft-hyphen|exinfo-format-sp|exinfo-format-specialized-defun|exinfo-format-subsection|exinfo-format-subsubsection|exinfo-format-synindex|exinfo-format-tex|exinfo-format-tie-after-accent|exinfo-format-timestamp|exinfo-format-tindex|exinfo-format-titlepage|exinfo-format-titlespec|exinfo-format-today|exinfo-format-underbar-accent|exinfo-format-underdot-accent|exinfo-format-upside-down-exclamation-mark|exinfo-format-upside-down-question-mark|exinfo-format-uref|exinfo-format-var|exinfo-format-verb|exinfo-format-vindex|exinfo-format-xml|exinfo-format-xref|exinfo-ftable-item|exinfo-ftable|exinfo-hierarchic-level|exinfo-if-clear|exinfo-if-set|exinfo-incorporate-descriptions|exinfo-incorporate-menu-entry-names|exinfo-indent-menu-description|exinfo-index-defcv|exinfo-index-deffn|exinfo-index-defivar|exinfo-index-defmethod|exinfo-index-defop|exinfo-index-deftypefn|exinfo-index-defun|exinfo-index|exinfo-indextable-item|exinfo-indextable|exinfo-insert-@code|exinfo-insert-@dfn|exinfo-insert-@email|exinfo-insert-@emph|exinfo-insert-@end|exinfo-insert-@example|exinfo-insert-@file|exinfo-insert-@item|exinfo-insert-@kbd|exinfo-insert-@node|exinfo-insert-@noindent|exinfo-insert-@quotation|exinfo-insert-@samp|exinfo-insert-@strong|exinfo-insert-@table|exinfo-insert-@uref|exinfo-insert-@url|exinfo-insert-@var|exinfo-insert-block|exinfo-insert-braces|exinfo-insert-master-menu-list|exinfo-insert-menu|exinfo-insert-node-lines|exinfo-insert-pointer|exinfo-insert-quote|exinfo-insertcopying|exinfo-inside-env-p|exinfo-inside-macro-p|exinfo-item|exinfo-itemize-item|exinfo-itemize|exinfo-last-unended-begin|exinfo-locate-menu-p|exinfo-make-menu-list|exinfo-make-menu|exinfo-make-one-menu|exinfo-master-menu-list|exinfo-master-menu|exinfo-menu-copy-old-description|exinfo-menu-end|exinfo-menu-first-node|exinfo-menu-indent-description|exinfo-menu-locate-entry-p|exinfo-mode-flyspell-verify|exinfo-mode-menu|exinfo-mode|exinfo-multi-file-included-list|exinfo-multi-file-master-menu-list|exinfo-multi-file-update|exinfo-multi-files-insert-main-menu|exinfo-multiple-files-update|exinfo-multitable-extract-row|exinfo-multitable-item|exinfo-multitable-widths|exinfo-multitable|exinfo-next-unmatched-end|exinfo-noindent|exinfo-old-menu-p|exinfo-optional-braces-discard|exinfo-paragraphindent|exinfo-parse-arg-discard|exinfo-parse-expanded-arg|exinfo-parse-line-arg|exinfo-pointer-name|exinfo-pop-stack|exinfo-print-index|exinfo-push-stack|exinfo-quit-job|exinfo-raise-lower-sections|exinfo-sequential-node-update|exinfo-sequentially-find-pointer|exinfo-sequentially-insert-pointer|exinfo-sequentially-update-the-node|exinfo-set|exinfo-show-structure|exinfo-sort-region|exinfo-sort-startkeyfun|exinfo-specific-section-type|exinfo-start-menu-description|exinfo-table-item|exinfo-table|exinfo-tex-buffer|exinfo-tex-print|exinfo-tex-region|exinfo-tex-view|exinfo-texindex|exinfo-top-pointer-case|exinfo-unsupported|exinfo-update-menu-region-beginning|exinfo-update-menu-region-end|exinfo-update-node|exinfo-update-the-node|exinfo-value|exinfo-vtable-item|exinfo-vtable|ext-clone--maintain|ext-clone-create|ext-mode-hook-identify|ext-scale-adjust|ext-scale-decrease|ext-scale-increase|ext-scale-mode|ext-scale-set|hai-compose-buffer|hai-compose-region|hai-compose-string|hai-composition-function|he|hing-at-point--bounds-of-markedup-url|hing-at-point--bounds-of-well-formed-url|hing-at-point-bounds-of-list-at-point|hing-at-point-bounds-of-url-at-point|hing-at-point-looking-at|hing-at-point-newsgroup-p|hing-at-point-url-at-point|hird|his-major-mode-requires-vi-state|his-single-command-keys|his-single-command-raw-keys|hread-first|hread-last|humbs-backward-char|humbs-backward-line|humbs-call-convert|humbs-call-setroot-command|humbs-cleanup-thumbsdir|humbs-current-image|humbs-delete-images|humbs-dired-setroot|humbs-dired-show-marked|humbs-dired-show|humbs-dired|humbs-display-thumbs-buffer|humbs-do-thumbs-insertion|humbs-emboss-image|humbs-enlarge-image|humbs-file-alist|humbs-file-list|humbs-file-size|humbs-find-image-at-point-other-window|humbs-find-image-at-point|humbs-find-image|humbs-find-thumb|humbs-forward-char|humbs-forward-line|humbs-image-type|humbs-insert-image|humbs-insert-thumb|humbs-kill-buffer|humbs-make-thumb|humbs-mark|humbs-mode|humbs-modify-image|humbs-monochrome-image|humbs-mouse-find-image|humbs-negate-image|humbs-new-image-size|humbs-next-image|humbs-previous-image|humbs-redraw-buffer|humbs-rename-images|humbs-resize-image-1|humbs-resize-image|humbs-rotate-left|humbs-rotate-right|humbs-save-current-image|humbs-set-image-at-point-to-root-window|humbs-set-root|humbs-show-from-dir|humbs-show-image-num|humbs-show-more-images|humbs-show-name|humbs-show-thumbs-list|humbs-shrink-image|humbs-temp-dir|humbs-temp-file|humbs-thumbname|humbs-thumbsdir|humbs-unmark|humbs-view-image-mode|humbs|ibetan-char-p|ibetan-compose-buffer|ibetan-compose-region|ibetan-compose-string|ibetan-decompose-buffer|ibetan-decompose-region|ibetan-decompose-string|ibetan-post-read-conversion|ibetan-pre-write-canonicalize-for-unicode|ibetan-pre-write-conversion|ibetan-tibetan-to-transcription|ibetan-transcription-to-tibetan|ildify--deprecated-ignore-evironments|ildify--find-env|ildify--foreach-region|ildify--pick-alist-entry|ildify-buffer|ildify-foreach-ignore-environments|ildify-region|ildify-tildify|ime-date--day-in-year|ime-since|ime-stamp-conv-warn|ime-stamp-do-number|ime-stamp-fconcat|ime-stamp-mail-host-name|ime-stamp-once|ime-stamp-string-preprocess|ime-stamp-string|ime-stamp-toggle-active|ime-stamp|ime-to-number-of-days|ime-to-seconds|imeclock-ask-for-project|imeclock-ask-for-reason|imeclock-change|imeclock-completing-read|imeclock-current-debt|imeclock-currently-in-p|imeclock-day-alist|imeclock-day-base|imeclock-day-begin|imeclock-day-break|imeclock-day-debt|imeclock-day-end|imeclock-day-length|imeclock-day-list-begin|imeclock-day-list-break|imeclock-day-list-debt|imeclock-day-list-end|imeclock-day-list-length|imeclock-day-list-projects|imeclock-day-list-required|imeclock-day-list-span|imeclock-day-list-template|imeclock-day-list|imeclock-day-projects|imeclock-day-required|imeclock-day-span|imeclock-entry-begin|imeclock-entry-comment|imeclock-entry-end|imeclock-entry-length|imeclock-entry-list-begin|imeclock-entry-list-break|imeclock-entry-list-end|imeclock-entry-list-length|imeclock-entry-list-projects|imeclock-entry-list-span|imeclock-entry-project|imeclock-find-discrep|imeclock-generate-report|imeclock-in|imeclock-last-period|imeclock-log-data|imeclock-log|imeclock-make-hours-explicit|imeclock-mean|imeclock-mode-line-display|imeclock-modeline-display|imeclock-out|imeclock-project-alist|imeclock-query-out|imeclock-read-moment|imeclock-reread-log|imeclock-seconds-to-string|imeclock-seconds-to-time|imeclock-status-string|imeclock-time-to-date|imeclock-time-to-seconds|imeclock-update-mode-line|imeclock-update-modeline|imeclock-visit-timelog|imeclock-when-to-leave-string|imeclock-when-to-leave|imeclock-workday-elapsed-string|imeclock-workday-elapsed|imeclock-workday-remaining-string|imeclock-workday-remaining|imeout-event-p|imep|imer--activate|imer--args--cmacro|imer--args|imer--check|imer--function--cmacro|imer--function|imer--high-seconds--cmacro|imer--high-seconds|imer--idle-delay--cmacro|imer--idle-delay|imer--low-seconds--cmacro|imer--low-seconds|imer--psecs--cmacro|imer--psecs|imer--repeat-delay--cmacro|imer--repeat-delay|imer--time-less-p|imer--time-setter|imer--time|imer--triggered--cmacro|imer--triggered|imer--usecs--cmacro|imer--usecs|imer-activate-when-idle|imer-activate|imer-create--cmacro|imer-create|imer-duration|imer-event-handler|imer-inc-time|imer-next-integral-multiple-of-time|imer-relative-time|imer-set-function|imer-set-idle-time|imer-set-time-with-usecs|imer-set-time|imer-until|imerp|imezone-absolute-from-gregorian|imezone-day-number|imezone-fix-time|imezone-last-day-of-month|imezone-leap-year-p|imezone-make-arpa-date|imezone-make-date-arpa-standard|imezone-make-date-sortable|imezone-make-sortable-date|imezone-make-time-string|imezone-parse-date|imezone-parse-time|imezone-time-from-absolute|imezone-time-zone-from-absolute|imezone-zone-to-minute|itdic-convert|ls-certificate-information|mm--completion-table|mm-add-one-shortcut|mm-add-prompt|mm-add-shortcuts|mm-completion-delete-prompt|mm-define-keys|mm-get-keybind|mm-get-keymap|mm-goto-completions|mm-menubar-mouse|mm-menubar|mm-prompt|mm-remove-inactive-mouse-face|mm-shortcut|odo--user-error-if-marked-done-item|odo-absolute-file-name|odo-add-category|odo-add-file|odo-adjusted-category-label-length|odo-archive-done-item|odo-archive-mode|odo-backward-category|odo-backward-item|odo-categories-mode|odo-category-completions|odo-category-number|odo-category-select|odo-category-string-matcher-1|odo-category-string-matcher-2|odo-check-file|odo-check-filtered-items-file|odo-check-format|odo-choose-archive|odo-clear-matches|odo-comment-string-matcher|odo-convert-legacy-date-time|odo-convert-legacy-files|odo-current-category|odo-date-string-matcher|odo-delete-category|odo-delete-file|odo-delete-item|odo-desktop-save-buffer)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)t(?:odo-diary-expired-matcher|odo-diary-goto-entry|odo-diary-item-p|odo-diary-nonmarking-matcher|odo-display-categories|odo-display-sorted|odo-done-item-p|odo-done-item-section-p|odo-done-separator|odo-done-string-matcher|odo-edit-category-diary-inclusion|odo-edit-category-diary-nonmarking|odo-edit-file|odo-edit-item--diary-inclusion|odo-edit-item--header|odo-edit-item--next-key|odo-edit-item--text|odo-edit-item|odo-edit-mode|odo-edit-quit|odo-files|odo-filter-diary-items-multifile|odo-filter-diary-items|odo-filter-items-1|odo-filter-items-filename|odo-filter-items|odo-filter-regexp-items-multifile|odo-filter-regexp-items|odo-filter-top-priorities-multifile|odo-filter-top-priorities|odo-filtered-items-mode|odo-find-archive|odo-find-filtered-items-file|odo-find-item|odo-forward-category|odo-forward-item|odo-get-count|odo-get-overlay|odo-go-to-source-item|odo-indent|odo-insert-category-line|odo-insert-item--apply-args|odo-insert-item--argsleft|odo-insert-item--basic|odo-insert-item--keyof|odo-insert-item--next-param|odo-insert-item--this-key|odo-insert-item-from-calendar|odo-insert-item|odo-insert-sort-button|odo-insert-with-overlays|odo-item-done|odo-item-end|odo-item-start|odo-item-string|odo-item-undone|odo-jump-to-archive-category|odo-jump-to-category|odo-label-to-key|odo-longest-category-name-length|odo-lower-category|odo-lower-item-priority|odo-make-categories-list|odo-mark-category|odo-marked-item-p|odo-menu|odo-merge-category|odo-mode-external-set|odo-mode-line-control|odo-mode|odo-modes-set-1|odo-modes-set-2|odo-modes-set-3|odo-move-category|odo-move-item|odo-multiple-filter-files|odo-next-button|odo-next-item|odo-nondiary-marker-matcher|odo-padded-string|odo-prefix-overlays|odo-previous-button|odo-previous-item|odo-print-buffer-to-file|odo-print-buffer|odo-quit|odo-raise-category|odo-raise-item-priority|odo-read-category|odo-read-date|odo-read-dayname|odo-read-file-name|odo-read-time|odo-reevaluate-category-completions-files-defcustom|odo-reevaluate-default-file-defcustom|odo-reevaluate-filelist-defcustoms|odo-reevaluate-filter-files-defcustom|odo-remove-item|odo-rename-category|odo-rename-file|odo-repair-categories-sexp|odo-reset-and-enable-done-separator|odo-reset-comment-string|odo-reset-done-separator-string|odo-reset-done-separator|odo-reset-done-string|odo-reset-global-current-todo-file|odo-reset-highlight-item|odo-reset-nondiary-marker|odo-reset-prefix|odo-restore-desktop-buffer|odo-revert-buffer|odo-save-filtered-items-buffer|odo-save|odo-search|odo-set-categories|odo-set-category-number|odo-set-date-from-calendar|odo-set-item-priority|odo-set-show-current-file|odo-set-top-priorities-in-category|odo-set-top-priorities-in-file|odo-set-top-priorities|odo-short-file-name|odo-show-categories-table|odo-show-current-file|odo-show|odo-sort-categories-alphabetically-or-numerically|odo-sort-categories-by-archived|odo-sort-categories-by-diary|odo-sort-categories-by-done|odo-sort-categories-by-todo|odo-sort|odo-time-string-matcher|odo-toggle-item-header|odo-toggle-item-highlighting|odo-toggle-mark-item|odo-toggle-prefix-numbers|odo-toggle-view-done-items|odo-toggle-view-done-only|odo-total-item-counts|odo-unarchive-items|odo-unmark-category|odo-update-buffer-list|odo-update-categories-display|odo-update-categories-sexp|odo-update-count|odo-validate-name|odo-y-or-n-p|oggle-auto-composition|oggle-case-fold-search|oggle-debug-on-error|oggle-debug-on-quit|oggle-emacs-lock|oggle-frame-fullscreen|oggle-frame-maximized|oggle-horizontal-scroll-bar|oggle-indicate-empty-lines|oggle-input-method|oggle-menu-bar-mode-from-frame|oggle-read-only|oggle-rot13-mode|oggle-save-place-globally|oggle-save-place|oggle-scroll-bar|oggle-text-mode-auto-fill|oggle-tool-bar-mode-from-frame|oggle-truncate-lines|oggle-uniquify-buffer-names|oggle-use-system-font|oggle-viper-mode|oggle-word-wrap|ool-bar--image-expression|ool-bar-get-system-style|ool-bar-height|ool-bar-lines-needed|ool-bar-local-item|ool-bar-make-keymap-1|ool-bar-make-keymap|ool-bar-mode|ool-bar-pixel-width|ool-bar-setup|ooltip-cancel-delayed-tip|ooltip-delay|ooltip-event-buffer|ooltip-expr-to-print|ooltip-gud-toggle-dereference|ooltip-help-tips|ooltip-hide|ooltip-identifier-from-point|ooltip-mode|ooltip-process-prompt-regexp|ooltip-set-param|ooltip-show-help-non-mode|ooltip-show-help|ooltip-show|ooltip-start-delayed-tip|ooltip-strip-prompt|ooltip-timeout|q-buffer|q-filter|q-process-buffer|q-process|q-queue-add|q-queue-empty|q-queue-head-closure|q-queue-head-fn|q-queue-head-question|q-queue-head-regexp|q-queue-pop|q-queue|race--display-buffer|race--read-args|race-entry-message|race-exit-message|race-function-background|race-function-foreground|race-function-internal|race-function|race-is-traced|race-make-advice|race-values|raceroute|ramp-accept-process-output|ramp-action-login|ramp-action-out-of-band|ramp-action-password|ramp-action-permission-denied|ramp-action-process-alive|ramp-action-succeed|ramp-action-terminal|ramp-action-yesno|ramp-action-yn|ramp-adb-file-name-handler|ramp-adb-file-name-p|ramp-adb-parse-device-names|ramp-autoload-file-name-handler|ramp-backtrace|ramp-buffer-name|ramp-bug|ramp-cache-print|ramp-call-process|ramp-check-cached-permissions|ramp-check-for-regexp|ramp-check-proper-method-and-host|ramp-cleanup-all-buffers|ramp-cleanup-all-connections|ramp-cleanup-connection|ramp-cleanup-this-connection|ramp-clear-passwd|ramp-compat-coding-system-change-eol-conversion|ramp-compat-condition-case-unless-debug|ramp-compat-copy-directory|ramp-compat-copy-file|ramp-compat-decimal-to-octal|ramp-compat-delete-directory|ramp-compat-delete-file|ramp-compat-file-attributes|ramp-compat-font-lock-add-keywords|ramp-compat-funcall|ramp-compat-load|ramp-compat-make-temp-file|ramp-compat-most-positive-fixnum|ramp-compat-number-sequence|ramp-compat-octal-to-decimal|ramp-compat-process-get|ramp-compat-process-put|ramp-compat-process-running-p|ramp-compat-replace-regexp-in-string|ramp-compat-set-process-query-on-exit-flag|ramp-compat-split-string|ramp-compat-temporary-file-directory|ramp-compat-with-temp-message|ramp-completion-dissect-file-name1??|ramp-completion-file-name-handler|ramp-completion-handle-file-name-all-completions|ramp-completion-handle-file-name-completion|ramp-completion-make-tramp-file-name|ramp-completion-mode-p|ramp-completion-run-real-handler|ramp-condition-case-unless-debug|ramp-connectable-p|ramp-connection-property-p|ramp-debug-buffer-name|ramp-debug-message|ramp-debug-outline-level|ramp-default-file-modes|ramp-delete-temp-file-function|ramp-dissect-file-name|ramp-drop-volume-letter|ramp-equal-remote|ramp-error-with-buffer|ramp-error|ramp-eshell-directory-change|ramp-exists-file-name-handler|ramp-file-mode-from-int|ramp-file-mode-permissions|ramp-file-name-domain|ramp-file-name-for-operation|ramp-file-name-handler|ramp-file-name-hop|ramp-file-name-host|ramp-file-name-localname|ramp-file-name-method|ramp-file-name-p|ramp-file-name-port|ramp-file-name-real-host|ramp-file-name-real-user|ramp-file-name-user|ramp-find-file-name-coding-system-alist|ramp-find-foreign-file-name-handler|ramp-find-host|ramp-find-method|ramp-find-user|ramp-flush-connection-property|ramp-flush-directory-property|ramp-flush-file-property|ramp-ftp-enable-ange-ftp|ramp-ftp-file-name-handler|ramp-ftp-file-name-p|ramp-get-buffer|ramp-get-completion-function|ramp-get-completion-methods|ramp-get-completion-user-host|ramp-get-connection-buffer|ramp-get-connection-name|ramp-get-connection-process|ramp-get-connection-property|ramp-get-debug-buffer|ramp-get-device|ramp-get-file-property|ramp-get-inode|ramp-get-local-gid|ramp-get-local-uid|ramp-get-method-parameter|ramp-get-remote-tmpdir|ramp-gvfs-file-name-handler|ramp-gvfs-file-name-p|ramp-gw-open-connection|ramp-handle-directory-file-name|ramp-handle-directory-files-and-attributes|ramp-handle-directory-files|ramp-handle-dired-uncache|ramp-handle-file-accessible-directory-p|ramp-handle-file-exists-p|ramp-handle-file-modes|ramp-handle-file-name-as-directory|ramp-handle-file-name-completion|ramp-handle-file-name-directory|ramp-handle-file-name-nondirectory|ramp-handle-file-newer-than-file-p|ramp-handle-file-notify-add-watch|ramp-handle-file-notify-rm-watch|ramp-handle-file-regular-p|ramp-handle-file-remote-p|ramp-handle-file-symlink-p|ramp-handle-find-backup-file-name|ramp-handle-insert-directory|ramp-handle-insert-file-contents|ramp-handle-load|ramp-handle-make-auto-save-file-name|ramp-handle-make-symbolic-link|ramp-handle-set-visited-file-modtime|ramp-handle-shell-command|ramp-handle-substitute-in-file-name|ramp-handle-unhandled-file-name-directory|ramp-handle-verify-visited-file-modtime|ramp-list-connections|ramp-local-host-p|ramp-make-tramp-file-name|ramp-make-tramp-temp-file|ramp-message|ramp-mode-string-to-int|ramp-parse-connection-properties|ramp-parse-file|ramp-parse-group|ramp-parse-hosts-group|ramp-parse-hosts|ramp-parse-netrc-group|ramp-parse-netrc|ramp-parse-passwd-group|ramp-parse-passwd|ramp-parse-putty-group|ramp-parse-putty|ramp-parse-rhosts-group|ramp-parse-rhosts|ramp-parse-sconfig-group|ramp-parse-sconfig|ramp-parse-shostkeys-sknownhosts|ramp-parse-shostkeys|ramp-parse-shosts-group|ramp-parse-shosts|ramp-parse-sknownhosts|ramp-process-actions|ramp-process-one-action|ramp-progress-reporter-update|ramp-read-passwd|ramp-register-autoload-file-name-handlers|ramp-register-file-name-handlers|ramp-replace-environment-variables|ramp-rfn-eshadow-setup-minibuffer|ramp-rfn-eshadow-update-overlay|ramp-run-real-handler|ramp-send-string|ramp-set-auto-save-file-modes|ramp-set-completion-function|ramp-set-connection-property|ramp-set-file-property|ramp-sh-file-name-handler|ramp-shell-quote-argument|ramp-smb-file-name-handler|ramp-smb-file-name-p|ramp-subst-strs-in-string|ramp-time-diff|ramp-tramp-file-p|ramp-unload-file-name-handlers|ramp-unload-tramp|ramp-user-error|ramp-uuencode-region|ramp-version|ramp-wait-for-regexp|ransform-make-coding-system-args|ranslate-region-internal|ranspose-chars|ranspose-lines|ranspose-paragraphs|ranspose-sentences|ranspose-sexps|ranspose-subr-1|ranspose-subr|ranspose-words|ree-equal|ree-widget--locate-sub-directory|ree-widget-action|ree-widget-button-click|ree-widget-children-value-save|ree-widget-convert-widget|ree-widget-create-image|ree-widget-expander-p|ree-widget-find-image|ree-widget-help-echo|ree-widget-icon-action|ree-widget-icon-create|ree-widget-icon-help-echo|ree-widget-image-formats|ree-widget-image-properties|ree-widget-keep|ree-widget-leaf-node-icon-p|ree-widget-lookup-image|ree-widget-node|ree-widget-p|ree-widget-set-image-properties|ree-widget-set-parent-theme|ree-widget-set-theme|ree-widget-theme-name|ree-widget-themes-path|ree-widget-use-image-p|ree-widget-value-create|runcate\\\\*|runcated-partial-width-window-p|ry-complete-file-name-partially|ry-complete-file-name|ry-complete-lisp-symbol-partially|ry-complete-lisp-symbol|ry-expand-all-abbrevs|ry-expand-dabbrev-all-buffers|ry-expand-dabbrev-from-kill|ry-expand-dabbrev-visible|ry-expand-dabbrev|ry-expand-line-all-buffers|ry-expand-line|ry-expand-list-all-buffers|ry-expand-list|ry-expand-whole-kill|ty-color-by-index|ty-color-canonicalize|ty-color-desc|ty-color-gray-shades|ty-color-off-gray-diag|ty-color-standard-values|ty-color-values|ty-create-frame-with-faces|ty-display-color-cells|ty-display-color-p|ty-find-type|ty-handle-args|ty-handle-reverse-video|ty-modify-color-alist|ty-no-underline|ty-register-default-colors|ty-run-terminal-initialization|ty-set-up-initial-frame-faces|ty-suppress-bold-inverse-default-colors|ty-type|umme|urkish-case-conversion-disable|urkish-case-conversion-enable|urn-off-auto-fill|urn-off-flyspell|urn-off-follow-mode|urn-off-hideshow|urn-off-iimage-mode|urn-off-xterm-mouse-tracking-on-terminal|urn-on-auto-fill|urn-on-auto-revert-mode|urn-on-auto-revert-tail-mode|urn-on-cwarn-mode-if-enabled|urn-on-cwarn-mode|urn-on-eldoc-mode|urn-on-flyspell|urn-on-follow-mode|urn-on-font-lock-if-desired|urn-on-font-lock|urn-on-gnus-dired-mode)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(?:turn-on-gnus-mailing-list-mode|turn-on-hi-lock-if-enabled|turn-on-iimage-mode|turn-on-org-cdlatex|turn-on-orgstruct\\\\+\\\\+|turn-on-orgstruct|turn-on-orgtbl|turn-on-prettify-symbols-mode|turn-on-reftex|turn-on-visual-line-mode|turn-on-xterm-mouse-tracking-on-terminal|type-break-alarm|type-break-cancel-function-timers|type-break-cancel-schedule|type-break-cancel-time-warning-schedule|type-break-catch-up-event|type-break-check-keystroke-warning|type-break-check-post-command-hook|type-break-check|type-break-choose-file|type-break-demo-boring|type-break-demo-hanoi|type-break-demo-life|type-break-do-query|type-break-file-keystroke-count|type-break-file-time|type-break-force-mode-line-update|type-break-format-time|type-break-get-previous-count|type-break-get-previous-time|type-break-guesstimate-keystroke-threshold|type-break-keystroke-reset|type-break-keystroke-warning|type-break-mode-line-countdown-or-break|type-break-mode-line-message-mode|type-break-mode|type-break-noninteractive-query|type-break-query-mode|type-break-query|type-break-run-at-time|type-break-run-tb-post-command-hook|type-break-schedule|type-break-statistics|type-break-time-difference|type-break-time-stamp|type-break-time-sum|type-break-time-warning-alarm|type-break-time-warning-schedule|type-break-time-warning|type-break|typecase|typep|uce-insert-ranting|uce-reply-to-uce|ucs-input-activate|ucs-insert|ucs-names|ucs-normalize-HFS-NFC-region|ucs-normalize-HFS-NFC-string|ucs-normalize-HFS-NFD-region|ucs-normalize-HFS-NFD-string|ucs-normalize-NFC-region|ucs-normalize-NFC-string|ucs-normalize-NFD-region|ucs-normalize-NFD-string|ucs-normalize-NFKC-region|ucs-normalize-NFKC-string|ucs-normalize-NFKD-region|ucs-normalize-NFKD-string|uncomment-region-default|uncomment-region|uncompface|underline-region|undigestify-rmail-message|undo-adjust-beg-end|undo-adjust-elt|undo-adjust-pos|undo-copy-list-1|undo-copy-list|undo-delta|undo-elt-crosses-region|undo-elt-in-region|undo-make-selective-list|undo-more|undo-only|undo-outer-limit-truncate|undo-start|undo|unencodable-char-position|unexpand-abbrev|unfocus-frame|unforward-rmail-message|unhighlight-regexp|unicode-property-table-internal|unify-8859-on-decoding-mode|unify-8859-on-encoding-mode|unify-charset|union|uniquify--create-file-buffer-advice|uniquify--rename-buffer-advice|uniquify-buffer-base-name|uniquify-buffer-file-name|uniquify-get-proposed-name|uniquify-item-base--cmacro|uniquify-item-base|uniquify-item-buffer--cmacro|uniquify-item-buffer|uniquify-item-dirname--cmacro|uniquify-item-dirname|uniquify-item-greaterp|uniquify-item-p--cmacro|uniquify-item-p|uniquify-item-proposed--cmacro|uniquify-item-proposed|uniquify-kill-buffer-function|uniquify-make-item--cmacro|uniquify-make-item|uniquify-maybe-rerationalize-w/o-cb|uniquify-rationalize-a-list|uniquify-rationalize-conflicting-sublist|uniquify-rationalize-file-buffer-names|uniquify-rationalize|uniquify-rename-buffer|uniquify-rerationalize-w/o-cb|uniquify-unload-function|universal-argument--mode|universal-argument-more|universal-coding-system-argument|unix-sync|unjustify-current-line|unjustify-region|unload--set-major-mode|unmorse-region|unmsys--file-name|unread-bib|unrecord-window-buffer|unrmail|unsafep-function|unsafep-let|unsafep-progn|unsafep-variable|untabify-backward|untabify|untrace-all|untrace-function|ununderline-region|up-ifdef|upcase-initials-region|update-glyphless-char-display|update-leim-list-file|url--allowed-chars|url-attributes--cmacro|url-attributes|url-auth-registered|url-auth-user-prompt|url-basepath|url-basic-auth|url-bit-for-url|url-build-query-string|url-cache-create-filename|url-cache-extract|url-cache-prune-cache|url-cid|url-completion-function|url-cookie-clean-up|url-cookie-create--cmacro|url-cookie-create|url-cookie-delete|url-cookie-domain--cmacro|url-cookie-domain|url-cookie-expired-p|url-cookie-expires--cmacro|url-cookie-expires|url-cookie-generate-header-lines|url-cookie-handle-set-cookie|url-cookie-host-can-set-p|url-cookie-list|url-cookie-localpart--cmacro|url-cookie-localpart|url-cookie-mode|url-cookie-name--cmacro|url-cookie-name|url-cookie-p--cmacro|url-cookie-p|url-cookie-parse-file|url-cookie-quit|url-cookie-retrieve|url-cookie-secure--cmacro|url-cookie-secure|url-cookie-setup-save-timer|url-cookie-store|url-cookie-value--cmacro|url-cookie-value|url-cookie-write-file|url-copy-file|url-data|url-dav-request|url-dav-supported-p|url-dav-vc-registered|url-debug|url-default-expander|url-default-find-proxy-for-url|url-device-type|url-digest-auth-create-key|url-digest-auth|url-display-percentage|url-do-auth-source-search|url-do-setup|url-domsuf-cookie-allowed-p|url-domsuf-parse-file|url-eat-trailing-space|url-encode-url|url-expand-file-name|url-expander-remove-relative-links|url-extract-mime-headers|url-file-directory|url-file-extension|url-file-handler|url-file-local-copy|url-file-nondirectory|url-file|url-filename--cmacro|url-filename|url-find-proxy-for-url|url-fullness--cmacro|url-fullness|url-gateway-nslookup-host|url-gc-dead-buffers|url-generate-unique-filename|url-generic-emulator-loader|url-generic-parse-url|url-get-authentication|url-get-normalized-date|url-get-url-at-point|url-handle-content-transfer-encoding|url-handler-mode|url-have-visited-url|url-hexify-string|url-history-parse-history|url-history-save-history|url-history-setup-save-timer|url-history-update-url|url-host--cmacro|url-host|url-http-activate-callback|url-http-async-sentinel|url-http-chunked-encoding-after-change-function|url-http-clean-headers|url-http-content-length-after-change-function|url-http-create-request|url-http-debug|url-http-end-of-document-sentinel|url-http-expand-file-name|url-http-file-attributes|url-http-file-exists-p|url-http-file-readable-p|url-http-find-free-connection|url-http-generic-filter|url-http-handle-authentication|url-http-handle-cookies|url-http-head-file-attributes|url-http-head|url-http-idle-sentinel|url-http-mark-connection-as-busy|url-http-mark-connection-as-free|url-http-options|url-http-parse-headers|url-http-parse-response|url-http-simple-after-change-function|url-http-symbol-value-in-buffer|url-http-user-agent-string|url-http-wait-for-headers-change-function|url-http|url-https-create-secure-wrapper|url-https-expand-file-name|url-https-file-attributes|url-https-file-exists-p|url-https-file-readable-p|url-https|url-identity-expander|url-info|url-insert-entities-in-string|url-insert-file-contents|url-irc|url-is-cached|url-lazy-message|url-ldap|url-mail|url-mailto|url-make-private-file|url-man|url-mark-buffer-as-dead|url-mime-charset-string|url-mm-callback|url-mm-url|url-news|url-normalize-url|url-ns-prefs|url-ns-user-pref|url-open-rlogin|url-open-stream|url-open-telnet|url-p--cmacro|url-p|url-parse-args|url-parse-make-urlobj--cmacro|url-parse-make-urlobj|url-parse-query-string|url-password--cmacro|url-password-for-url|url-password|url-path-and-query|url-percentage|url-port-if-non-default|url-port|url-portspec--cmacro|url-portspec|url-pretty-length|url-proxy|url-queue-buffer--cmacro|url-queue-buffer|url-queue-callback--cmacro|url-queue-callback-function|url-queue-callback|url-queue-cbargs--cmacro|url-queue-cbargs|url-queue-inhibit-cookiesp--cmacro|url-queue-inhibit-cookiesp|url-queue-kill-job|url-queue-p--cmacro|url-queue-p|url-queue-pre-triggered--cmacro|url-queue-pre-triggered|url-queue-prune-old-entries|url-queue-remove-jobs-from-host|url-queue-retrieve|url-queue-run-queue|url-queue-setup-runners|url-queue-silentp--cmacro|url-queue-silentp|url-queue-start-retrieve|url-queue-start-time--cmacro|url-queue-start-time|url-queue-url--cmacro|url-queue-url|url-recreate-url-attributes|url-recreate-url|url-register-auth-scheme|url-retrieve-internal|url-retrieve-synchronously|url-retrieve|url-rlogin|url-scheme-default-loader|url-scheme-get-property|url-scheme-register-proxy|url-set-mime-charset-string|url-setup-privacy-info|url-silent--cmacro|url-silent|url-snews|url-store-in-cache|url-strip-leading-spaces|url-target--cmacro|url-target|url-telnet|url-tn3270|url-tramp-file-handler|url-truncate-url-for-viewing|url-type--cmacro|url-type|url-unhex-string|url-unhex|url-use-cookies--cmacro|url-use-cookies|url-user--cmacro|url-user-for-url|url-user|url-view-url|url-wait-for-string|url-warn|use-cjk-char-width-table|use-completion-backward-under|use-completion-backward|use-completion-before-point|use-completion-before-separator|use-completion-minibuffer-separator|use-completion-under-or-before-point|use-completion-under-point|use-default-char-width-table|use-fancy-splash-screens-p|use-package|user-original-login-name|user-variable-p|utf-7-imap-post-read-conversion|utf-7-imap-pre-write-conversion|utf-7-post-read-conversion|utf-7-pre-write-conversion|utf7-decode|utf7-encode|uudecode-char-int|uudecode-decode-region-external|uudecode-decode-region-internal|uudecode-decode-region|uudecode-string-to-multibyte|values-list|variable-at-point|variable-binding-locus|variable-pitch-mode|vc--add-line|vc--process-sentinel|vc--read-lines|vc--remove-regexp|vc-after-save|vc-annotate|vc-backend-for-registration|vc-backend-subdirectory-name|vc-backend|vc-before-save|vc-branch-p|vc-branch-part|vc-buffer-context|vc-buffer-sync|vc-bzr-registered|vc-call-backend|vc-call|vc-check-headers|vc-check-master-templates|vc-checkin|vc-checkout-model|vc-checkout|vc-clear-context|vc-coding-system-for-diff|vc-comment-search-forward|vc-comment-search-reverse|vc-comment-to-change-log|vc-compatible-state|vc-compilation-mode|vc-context-matches-p|vc-create-repo|vc-create-tag|vc-cvs-after-dir-status|vc-cvs-annotate-command|vc-cvs-annotate-current-time|vc-cvs-annotate-extract-revision-at-line|vc-cvs-annotate-process-filter|vc-cvs-annotate-time|vc-cvs-append-to-ignore|vc-cvs-check-headers|vc-cvs-checkin|vc-cvs-checkout-model|vc-cvs-checkout|vc-cvs-command|vc-cvs-comment-history|vc-cvs-could-register|vc-cvs-create-tag|vc-cvs-delete-file|vc-cvs-diff|vc-cvs-dir-extra-headers|vc-cvs-dir-status-files|vc-cvs-dir-status-heuristic|vc-cvs-file-to-string|vc-cvs-find-admin-dir|vc-cvs-find-revision|vc-cvs-get-entries|vc-cvs-ignore|vc-cvs-make-version-backups-p|vc-cvs-merge-file|vc-cvs-merge-news|vc-cvs-merge|vc-cvs-mode-line-string|vc-cvs-modify-change-comment|vc-cvs-next-revision|vc-cvs-parse-entry|vc-cvs-parse-root|vc-cvs-parse-status|vc-cvs-parse-sticky-tag|vc-cvs-parse-uhp|vc-cvs-previous-revision|vc-cvs-print-log|vc-cvs-register|vc-cvs-registered|vc-cvs-repository-hostname|vc-cvs-responsible-p|vc-cvs-retrieve-tag|vc-cvs-revert|vc-cvs-revision-completion-table|vc-cvs-revision-granularity|vc-cvs-revision-table|vc-cvs-state-heuristic|vc-cvs-state|vc-cvs-stay-local-p|vc-cvs-update-changelog|vc-cvs-valid-revision-number-p|vc-cvs-valid-symbolic-tag-name-p|vc-cvs-working-revision|vc-deduce-backend|vc-deduce-fileset|vc-default-check-headers|vc-default-comment-history|vc-default-dir-status-files|vc-default-extra-menu|vc-default-find-file-hook|vc-default-find-revision|vc-default-ignore-completion-table|vc-default-ignore|vc-default-log-edit-mode|vc-default-log-view-mode|vc-default-make-version-backups-p|vc-default-mark-resolved|vc-default-mode-line-string|vc-default-receive-file|vc-default-registered|vc-default-rename-file|vc-default-responsible-p|vc-default-retrieve-tag|vc-default-revert|vc-default-revision-completion-table|vc-default-show-log-entry|vc-default-working-revision|vc-delete-automatic-version-backups|vc-delete-file|vc-delistify|vc-diff-build-argument-list-internal|vc-diff-finish|vc-diff-internal|vc-diff-switches-list|vc-diff|vc-dir-mode|vc-dir|vc-dired-deduce-fileset|vc-dispatcher-browsing|vc-do-async-command|vc-do-command|vc-ediff|vc-editable-p|vc-ensure-vc-buffer|vc-error-occurred|vc-exec-after|vc-expand-dirs|vc-file-clearprops|vc-file-getprop|vc-file-setprop|vc-file-tree-walk-internal|vc-file-tree-walk|vc-find-backend-function|vc-find-conflicted-file|vc-find-file-hook|vc-find-position-by-context|vc-find-revision|vc-find-root|vc-finish-logentry|vc-follow-link|vc-git-registered|vc-hg-registered|vc-ignore|vc-incoming-outgoing-internal|vc-insert-file|vc-insert-headers|vc-kill-buffer-hook|vc-log-edit|vc-log-incoming|vc-log-internal-common|vc-log-outgoing|vc-make-backend-sym|vc-make-version-backup|vc-mark-resolved|vc-maybe-resolve-conflicts|vc-menu-map-filter|vc-menu-map|vc-merge|vc-mode-line|vc-modify-change-comment|vc-mtn-registered|vc-next-action|vc-next-comment|vc-parse-buffer)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)v(?:c-position-context|c-possible-master|c-previous-comment|c-print-log-internal|c-print-log-setup-buttons|c-print-log|c-print-root-log|c-process-filter|c-pull|c-rcs-registered|c-read-backend|c-read-revision|c-region-history|c-register-with|c-register|c-registered|c-rename-file|c-resolve-conflicts|c-responsible-backend|c-restore-buffer-context|c-resynch-buffer|c-resynch-buffers-in-directory|c-resynch-window|c-retrieve-tag|c-revert-buffer-internal|c-revert-buffer|c-revert-file|c-revert|c-revision-other-window|c-rollback|c-root-diff|c-root-dir|c-run-delayed|c-sccs-registered|c-sccs-search-project-dir|c-set-async-update|c-set-mode-line-busy-indicator|c-setup-buffer|c-src-registered|c-start-logentry|c-state-refresh|c-state|c-steal-lock|c-string-prefix-p|c-svn-registered|c-switch-backend|c-switches|c-tag-precondition|c-toggle-read-only|c-transfer-file|c-up-to-date-p|c-update-change-log|c-update|c-user-login-name|c-version-backup-file-name|c-version-backup-file|c-version-diff|c-version-ediff|c-workfile-version|c-working-revision|cursor-backward-char|cursor-backward-word|cursor-beginning-of-buffer|cursor-beginning-of-line|cursor-bind-keys|cursor-check|cursor-compare-windows|cursor-copy-line|cursor-copy-word|cursor-copy|cursor-cs-binding|cursor-disable|cursor-end-of-buffer|cursor-end-of-line|cursor-execute-command|cursor-execute-key|cursor-find-window|cursor-forward-char|cursor-forward-word|cursor-get-char-count|cursor-goto|cursor-insert|cursor-isearch-backward|cursor-isearch-forward|cursor-locate|cursor-map|cursor-move|cursor-next-line|cursor-other-window|cursor-post-command|cursor-previous-line|cursor-relative-move|cursor-scroll-down|cursor-scroll-up|cursor-swap-point|cursor-toggle-copy|cursor-toggle-vcursor-map|cursor-use-vcursor-map|cursor-window-funcall|ector-or-char-table-p|endor-specific-keysyms|era-add-syntax|era-backward-same-indent|era-backward-statement|era-backward-syntactic-ws|era-beginning-of-statement|era-beginning-of-substatement|era-comment-uncomment-region|era-corresponding-begin|era-corresponding-if|era-customize|era-electric-closing-brace|era-electric-opening-brace|era-electric-pound|era-electric-return|era-electric-slash|era-electric-space|era-electric-star|era-electric-tab|era-evaluate-offset|era-expand-abbrev|era-font-lock-match-item|era-fontify-buffer|era-forward-same-indent|era-forward-statement|era-forward-syntactic-ws|era-get-offset|era-guess-basic-syntax|era-in-literal|era-indent-block-closing|era-indent-buffer|era-indent-line|era-indent-region|era-langelem-col|era-lineup-C-comments|era-lineup-comment|era-mode-menu|era-mode|era-point|era-prepare-search|era-re-search-backward|era-re-search-forward|era-skip-backward-literal|era-skip-forward-literal|era-submit-bug-report|era-try-expand-abbrev|era-version|erify-xscheme-buffer|erilog-add-list-unique|erilog-alw-get-inputs|erilog-alw-get-outputs-delayed|erilog-alw-get-outputs-immediate|erilog-alw-get-temps|erilog-alw-get-uses-delayed|erilog-alw-new|erilog-at-close-constraint-p|erilog-at-close-struct-p|erilog-at-constraint-p|erilog-at-struct-mv-p|erilog-at-struct-p|erilog-auto-arg-ports|erilog-auto-arg|erilog-auto-ascii-enum|erilog-auto-assign-modport|erilog-auto-inout-comp|erilog-auto-inout-in|erilog-auto-inout-modport|erilog-auto-inout-module|erilog-auto-inout-param|erilog-auto-inout|erilog-auto-input|erilog-auto-insert-last|erilog-auto-insert-lisp|erilog-auto-inst-first|erilog-auto-inst-param|erilog-auto-inst-port-list|erilog-auto-inst-port-map|erilog-auto-inst-port|erilog-auto-inst|erilog-auto-logic-setup|erilog-auto-logic|erilog-auto-output-every|erilog-auto-output|erilog-auto-re-search-do|erilog-auto-read-locals|erilog-auto-reeval-locals|erilog-auto-reg-input|erilog-auto-reg|erilog-auto-reset|erilog-auto-save-check|erilog-auto-save-compile|erilog-auto-sense-sigs|erilog-auto-sense|erilog-auto-star-safe|erilog-auto-star|erilog-auto-template-lint|erilog-auto-templated-rel|erilog-auto-tieoff|erilog-auto-undef|erilog-auto-unused|erilog-auto-wire|erilog-auto|erilog-back-to-start-translate-off|erilog-backward-case-item|erilog-backward-open-bracket|erilog-backward-open-paren|erilog-backward-sexp|erilog-backward-syntactic-ws-quick|erilog-backward-syntactic-ws|erilog-backward-token|erilog-backward-up-list|erilog-backward-ws&directives|erilog-batch-auto|erilog-batch-delete-auto|erilog-batch-delete-trailing-whitespace|erilog-batch-diff-auto|erilog-batch-error-wrapper|erilog-batch-execute-func|erilog-batch-indent|erilog-batch-inject-auto|erilog-beg-of-defun-quick|erilog-beg-of-defun|erilog-beg-of-statement-1|erilog-beg-of-statement|erilog-booleanp|erilog-build-defun-re|erilog-calc-1|erilog-calculate-indent-directive|erilog-calculate-indent|erilog-case-indent-level|erilog-clog2|erilog-colorize-include-files-buffer|erilog-comment-depth|erilog-comment-indent|erilog-comment-region|erilog-comp-defun|erilog-complete-word|erilog-completion-response|erilog-completion|erilog-continued-line-1|erilog-continued-line|erilog-current-flags|erilog-current-indent-level|erilog-customize|erilog-declaration-beg|erilog-declaration-end|erilog-decls-append|erilog-decls-get-assigns|erilog-decls-get-consts|erilog-decls-get-gparams|erilog-decls-get-inouts|erilog-decls-get-inputs|erilog-decls-get-interfaces|erilog-decls-get-iovars|erilog-decls-get-modports|erilog-decls-get-outputs|erilog-decls-get-ports|erilog-decls-get-signals|erilog-decls-get-vars|erilog-decls-new|erilog-decls-princ|erilog-define-abbrev|erilog-delete-auto-star-all|erilog-delete-auto-star-implicit|erilog-delete-auto|erilog-delete-autos-lined|erilog-delete-empty-auto-pair|erilog-delete-to-paren|erilog-delete-trailing-whitespace|erilog-diff-auto|erilog-diff-buffers-p|erilog-diff-file-with-buffer|erilog-diff-report|erilog-dir-file-exists-p|erilog-dir-files|erilog-do-indent|erilog-easy-menu-filter|erilog-end-of-defun|erilog-end-of-statement|erilog-end-translate-off|erilog-enum-ascii|erilog-error-regexp-add-emacs|erilog-expand-command|erilog-expand-dirnames|erilog-expand-vector-internal|erilog-expand-vector|erilog-faq|erilog-font-customize|erilog-font-lock-match-item|erilog-forward-close-paren|erilog-forward-or-insert-line|erilog-forward-sexp-cmt|erilog-forward-sexp-function|erilog-forward-sexp-ign-cmt|erilog-forward-sexp|erilog-forward-syntactic-ws|erilog-forward-ws&directives|erilog-func-completion|erilog-generate-numbers|erilog-get-completion-decl|erilog-get-default-symbol|erilog-get-end-of-defun|erilog-get-expr|erilog-get-lineup-indent-2|erilog-get-lineup-indent|erilog-getopt-file|erilog-getopt-flags|erilog-getopt|erilog-goto-defun-file|erilog-goto-defun|erilog-header|erilog-highlight-buffer|erilog-highlight-region|erilog-in-attribute-p|erilog-in-case-region-p|erilog-in-comment-or-string-p|erilog-in-comment-p|erilog-in-coverage-p|erilog-in-directive-p|erilog-in-escaped-name-p|erilog-in-fork-region-p|erilog-in-generate-region-p|erilog-in-parameter-p|erilog-in-paren-count|erilog-in-paren-quick|erilog-in-paren|erilog-in-parenthesis-p|erilog-in-slash-comment-p|erilog-in-star-comment-p|erilog-in-struct-nested-p|erilog-in-struct-p|erilog-indent-buffer|erilog-indent-comment|erilog-indent-declaration|erilog-indent-line-relative|erilog-indent-line|erilog-inject-arg|erilog-inject-auto|erilog-inject-inst|erilog-inject-sense|erilog-insert-1|erilog-insert-block|erilog-insert-date|erilog-insert-definition|erilog-insert-indent|erilog-insert-indices|erilog-insert-last-command-event|erilog-insert-one-definition|erilog-insert-year|erilog-insert|erilog-inside-comment-or-string-p|erilog-is-number|erilog-just-one-space|erilog-keyword-completion|erilog-kill-existing-comment|erilog-label-be|erilog-leap-to-case-head|erilog-leap-to-head|erilog-library-filenames|erilog-lint-off|erilog-linter-name|erilog-load-file-at-mouse|erilog-load-file-at-point|erilog-make-width-expression|erilog-mark-defun|erilog-match-translate-off|erilog-menu|erilog-mode|erilog-modi-cache-add-gparams|erilog-modi-cache-add-inouts|erilog-modi-cache-add-inputs|erilog-modi-cache-add-outputs|erilog-modi-cache-add-vars|erilog-modi-cache-add|erilog-modi-cache-results|erilog-modi-current-get|erilog-modi-current|erilog-modi-file-or-buffer|erilog-modi-filename|erilog-modi-get-decls|erilog-modi-get-point|erilog-modi-get-sub-decls|erilog-modi-get-type|erilog-modi-goto|erilog-modi-lookup|erilog-modi-modport-lookup-one|erilog-modi-modport-lookup|erilog-modi-name|erilog-modi-new|erilog-modify-compile-command|erilog-modport-clockings-add|erilog-modport-clockings|erilog-modport-decls-set|erilog-modport-decls|erilog-modport-name|erilog-modport-new|erilog-modport-princ|erilog-module-filenames|erilog-module-inside-filename-p|erilog-more-comment|erilog-one-line|erilog-parenthesis-depth|erilog-point-text|erilog-preprocess|erilog-preserve-dir-cache|erilog-preserve-modi-cache|erilog-pretty-declarations-auto|erilog-pretty-declarations|erilog-pretty-expr|erilog-re-search-backward-quick|erilog-re-search-backward-substr|erilog-re-search-backward|erilog-re-search-forward-quick|erilog-re-search-forward-substr|erilog-re-search-forward|erilog-read-always-signals-recurse|erilog-read-always-signals|erilog-read-arg-pins|erilog-read-auto-constants|erilog-read-auto-lisp-present|erilog-read-auto-lisp|erilog-read-auto-params|erilog-read-auto-template-hit|erilog-read-auto-template-middle|erilog-read-auto-template|erilog-read-decls|erilog-read-defines|erilog-read-includes|erilog-read-inst-backward-name|erilog-read-inst-module-matcher|erilog-read-inst-module|erilog-read-inst-name|erilog-read-inst-param-value|erilog-read-inst-pins|erilog-read-instants|erilog-read-module-name|erilog-read-signals|erilog-read-sub-decls-expr|erilog-read-sub-decls-gate|erilog-read-sub-decls-line|erilog-read-sub-decls-sig|erilog-read-sub-decls|erilog-regexp-opt|erilog-regexp-words|erilog-repair-close-comma|erilog-repair-open-comma|erilog-run-hooks|erilog-save-buffer-state|erilog-save-font-mods|erilog-save-no-change-functions|erilog-save-scan-cache|erilog-scan-and-debug|erilog-scan-cache-flush|erilog-scan-cache-ok-p|erilog-scan-debug|erilog-scan-region|erilog-scan|erilog-set-auto-endcomments|erilog-set-compile-command|erilog-set-define|erilog-show-completions|erilog-showscopes|erilog-sig-bits|erilog-sig-comment|erilog-sig-enum|erilog-sig-memory|erilog-sig-modport|erilog-sig-multidim-string|erilog-sig-multidim|erilog-sig-name|erilog-sig-new|erilog-sig-signed|erilog-sig-tieoff|erilog-sig-type-set|erilog-sig-type|erilog-sig-width|erilog-signals-combine-bus|erilog-signals-edit-wire-reg|erilog-signals-from-signame|erilog-signals-in|erilog-signals-matching-dir-re|erilog-signals-matching-enum|erilog-signals-matching-regexp|erilog-signals-memory|erilog-signals-not-in|erilog-signals-not-matching-regexp|erilog-signals-not-params|erilog-signals-princ|erilog-signals-sort-compare|erilog-signals-with|erilog-simplify-range-expression|erilog-sk-always|erilog-sk-assign|erilog-sk-begin|erilog-sk-casex??|erilog-sk-casez|erilog-sk-comment|erilog-sk-datadef|erilog-sk-def-reg|erilog-sk-define-signal|erilog-sk-else-if|erilog-sk-fork??|erilog-sk-function|erilog-sk-generate|erilog-sk-header-tmpl|erilog-sk-header|erilog-sk-if|erilog-sk-initial|erilog-sk-inout|erilog-sk-input|erilog-sk-module|erilog-sk-output|erilog-sk-ovm-class|erilog-sk-primitive|erilog-sk-prompt-clock|erilog-sk-prompt-condition|erilog-sk-prompt-inc|erilog-sk-prompt-init|erilog-sk-prompt-lsb|erilog-sk-prompt-msb|erilog-sk-prompt-name|erilog-sk-prompt-output|erilog-sk-prompt-reset|erilog-sk-prompt-state-selector|erilog-sk-prompt-width|erilog-sk-reg|erilog-sk-repeat|erilog-sk-specify|erilog-sk-state-machine|erilog-sk-task|erilog-sk-uvm-component|erilog-sk-uvm-object|erilog-sk-while|erilog-sk-wire|erilog-skip-backward-comment-or-string|erilog-skip-backward-comments|erilog-skip-forward-comment-or-string)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)v(?:erilog-skip-forward-comment-p|erilog-star-comment|erilog-start-translate-off|erilog-stmt-menu|erilog-string-diff|erilog-string-match-fold|erilog-string-remove-spaces|erilog-string-replace-matches|erilog-strip-comments|erilog-subdecls-get-inouts|erilog-subdecls-get-inputs|erilog-subdecls-get-interfaced|erilog-subdecls-get-interfaces|erilog-subdecls-get-outputs|erilog-subdecls-new|erilog-submit-bug-report|erilog-surelint-off|erilog-symbol-detick-denumber|erilog-symbol-detick-text|erilog-symbol-detick|erilog-syntax-ppss|erilog-typedef-name-p|erilog-uncomment-region|erilog-var-completion|erilog-verilint-off|erilog-version|erilog-wai|erilog-warn-error|erilog-warn|erilog-within-string|erilog-within-translate-off|ersion-list-<=??|ersion-list-=|ersion-list-not-zero|ersion-to-list|ersion<??|ersion<=|ersion=|hdl-abbrev-list-init|hdl-activate-customizations|hdl-add-modified-file|hdl-add-source-files-menu|hdl-add-syntax|hdl-adelete|hdl-aget|hdl-align-buffer|hdl-align-declarations|hdl-align-group|hdl-align-inline-comment-buffer|hdl-align-inline-comment-group|hdl-align-inline-comment-region-1|hdl-align-inline-comment-region|hdl-align-list|hdl-align-region-1|hdl-align-region-2|hdl-align-region-groups|hdl-align-region|hdl-align-same-indent|hdl-aput-delete-if-nil|hdl-aput|hdl-auto-load-project|hdl-back-to-indentation|hdl-backward-same-indent|hdl-backward-sexp|hdl-backward-skip-label|hdl-backward-syntactic-ws|hdl-backward-to-block|hdl-backward-up-list|hdl-beautify-buffer|hdl-beautify-region|hdl-begin-p|hdl-beginning-of-block|hdl-beginning-of-defun|hdl-beginning-of-libunit|hdl-beginning-of-macro|hdl-beginning-of-statement-1|hdl-beginning-of-statement|hdl-case-alternative-p|hdl-case-keyword|hdl-case-word|hdl-character-to-event|hdl-comment-append-inline|hdl-comment-block|hdl-comment-display-line|hdl-comment-display|hdl-comment-indent|hdl-comment-insert-inline|hdl-comment-insert|hdl-comment-kill-inline-region|hdl-comment-kill-region|hdl-comment-uncomment-line|hdl-comment-uncomment-region|hdl-compile-directory|hdl-compile-init|hdl-compile-print-file-name|hdl-compile|hdl-compose-components-package|hdl-compose-configuration-architecture|hdl-compose-configuration|hdl-compose-insert-generic|hdl-compose-insert-port|hdl-compose-insert-signal|hdl-compose-new-component|hdl-compose-place-component|hdl-compose-wire-components|hdl-corresponding-begin|hdl-corresponding-defun|hdl-corresponding-end|hdl-corresponding-mid|hdl-create-mode-menu|hdl-current-line|hdl-custom-set|hdl-customize|hdl-decision-query|hdl-default-directory|hdl-defun-p|hdl-delete-indentation|hdl-delete|hdl-directory-files|hdl-do-group|hdl-do-list|hdl-do-same-indent|hdl-doc-mode|hdl-doc-variable|hdl-duplicate-project|hdl-electric-close-bracket|hdl-electric-comma|hdl-electric-dash|hdl-electric-equal|hdl-electric-mode|hdl-electric-open-bracket|hdl-electric-period|hdl-electric-quote|hdl-electric-return|hdl-electric-semicolon|hdl-electric-space|hdl-electric-tab|hdl-end-of-block|hdl-end-of-defun|hdl-end-of-leader|hdl-end-of-statement|hdl-end-p|hdl-end-translate-off|hdl-error-regexp-add-emacs|hdl-expand-abbrev|hdl-expand-paren|hdl-export-project|hdl-fill-group|hdl-fill-list|hdl-fill-region|hdl-fill-same-indent|hdl-first-word|hdl-fix-case-buffer|hdl-fix-case-region-1|hdl-fix-case-region|hdl-fix-case-word|hdl-fix-clause-buffer|hdl-fix-clause|hdl-fix-statement-buffer|hdl-fix-statement-region|hdl-fixup-whitespace-buffer|hdl-fixup-whitespace-region|hdl-font-lock-init|hdl-font-lock-match-item|hdl-fontify-buffer|hdl-forward-comment|hdl-forward-same-indent|hdl-forward-sexp|hdl-forward-skip-label|hdl-forward-syntactic-ws|hdl-function-name|hdl-generate-makefile-1|hdl-generate-makefile|hdl-get-block-state|hdl-get-compile-options|hdl-get-components-package-name|hdl-get-end-of-unit|hdl-get-hierarchy|hdl-get-instantiations|hdl-get-library-unit|hdl-get-make-options|hdl-get-offset|hdl-get-packages|hdl-get-source-files|hdl-get-subdirs|hdl-get-syntactic-context|hdl-get-visible-signals|hdl-goto-marker|hdl-has-syntax|hdl-he-list-beg|hdl-hideshow-init|hdl-hooked-abbrev|hdl-hs-forward-sexp-func|hdl-hs-minor-mode|hdl-import-project|hdl-in-argument-list-p|hdl-in-comment-p|hdl-in-extended-identifier-p|hdl-in-literal|hdl-in-quote-p|hdl-in-string-p|hdl-indent-buffer|hdl-indent-group|hdl-indent-line|hdl-indent-region|hdl-indent-sexp|hdl-index-menu-init|hdl-insert-file-contents|hdl-insert-keyword|hdl-insert-string-or-file|hdl-keep-region-active|hdl-last-word|hdl-libunit-p|hdl-line-copy|hdl-line-expand|hdl-line-kill-entire|hdl-line-kill|hdl-line-open|hdl-line-transpose-next|hdl-line-transpose-previous|hdl-line-yank|hdl-lineup-arglist-intro|hdl-lineup-arglist|hdl-lineup-comment|hdl-lineup-statement-cont|hdl-load-cache|hdl-make|hdl-makefile-name|hdl-mark-defun|hdl-match-string-downcase|hdl-match-translate-off|hdl-max-marker|hdl-menu-split|hdl-minibuffer-tab|hdl-mode-abbrev-table-init|hdl-mode-map-init|hdl-mode|hdl-model-defun|hdl-model-example-model|hdl-model-insert|hdl-model-map-init|hdl-parse-group-comment|hdl-parse-string|hdl-paste-group-comment|hdl-point|hdl-port-copy|hdl-port-flatten|hdl-port-paste-component|hdl-port-paste-constants|hdl-port-paste-context-clause|hdl-port-paste-declaration|hdl-port-paste-entity|hdl-port-paste-generic-map|hdl-port-paste-generic|hdl-port-paste-initializations|hdl-port-paste-instance|hdl-port-paste-port-map|hdl-port-paste-port|hdl-port-paste-signals|hdl-port-paste-testbench|hdl-port-reverse-direction|hdl-prepare-search-1|hdl-prepare-search-2|hdl-print-warnings|hdl-process-command-line-option|hdl-project-p|hdl-ps-print-init|hdl-ps-print-settings|hdl-re-search-backward|hdl-re-search-forward|hdl-read-offset|hdl-regress-line|hdl-remove-trailing-spaces-region|hdl-remove-trailing-spaces|hdl-replace-string|hdl-require-hierarchy-info|hdl-resolve-env-variable|hdl-resolve-paths|hdl-run-when-idle|hdl-safe|hdl-save-caches??|hdl-scan-context-clause|hdl-scan-directory-contents|hdl-scan-project-contents|hdl-sequential-statement-p|hdl-set-compiler|hdl-set-default-project|hdl-set-offset|hdl-set-project|hdl-set-style|hdl-show-messages|hdl-show-syntactic-information|hdl-skip-case-alternative|hdl-sort-alist|hdl-speedbar-check-unit|hdl-speedbar-configuration|hdl-speedbar-contract-all|hdl-speedbar-contract-level|hdl-speedbar-dired|hdl-speedbar-display-directory|hdl-speedbar-display-projects|hdl-speedbar-expand-all|hdl-speedbar-expand-architecture|hdl-speedbar-expand-config|hdl-speedbar-expand-dirs|hdl-speedbar-expand-entity|hdl-speedbar-expand-package|hdl-speedbar-expand-project|hdl-speedbar-expand-units|hdl-speedbar-find-file|hdl-speedbar-generate-makefile|hdl-speedbar-goto-this-unit|hdl-speedbar-higher-text|hdl-speedbar-initialize|hdl-speedbar-insert-dir-hierarchy|hdl-speedbar-insert-dirs|hdl-speedbar-insert-hierarchy|hdl-speedbar-insert-project-hierarchy|hdl-speedbar-insert-projects|hdl-speedbar-insert-subpackages|hdl-speedbar-item-info|hdl-speedbar-line-key|hdl-speedbar-line-project|hdl-speedbar-line-text|hdl-speedbar-make-design|hdl-speedbar-make-inst-line|hdl-speedbar-make-pack-line|hdl-speedbar-make-subpack-line|hdl-speedbar-make-subprogram-line|hdl-speedbar-make-title-line|hdl-speedbar-place-component|hdl-speedbar-port-copy|hdl-speedbar-refresh|hdl-speedbar-rescan-hierarchy|hdl-speedbar-select-mra|hdl-speedbar-set-depth|hdl-speedbar-update-current-project|hdl-speedbar-update-current-unit|hdl-speedbar-update-units|hdl-speedbar|hdl-standard-p|hdl-start-translate-off|hdl-statement-p|hdl-statistics-buffer|hdl-stutter-mode|hdl-submit-bug-report|hdl-subprog-copy|hdl-subprog-flatten|hdl-subprog-paste-body|hdl-subprog-paste-call|hdl-subprog-paste-declaration|hdl-subprog-paste-specification|hdl-template-alias-hook|hdl-template-alias|hdl-template-and-hook|hdl-template-architecture-hook|hdl-template-architecture|hdl-template-argument-list|hdl-template-array|hdl-template-assert-hook|hdl-template-assert|hdl-template-attribute-decl|hdl-template-attribute-hook|hdl-template-attribute-spec|hdl-template-attribute|hdl-template-bare-loop-hook|hdl-template-bare-loop|hdl-template-begin-end|hdl-template-block-configuration|hdl-template-block-hook|hdl-template-block|hdl-template-break-hook|hdl-template-break|hdl-template-case-hook|hdl-template-case-is|hdl-template-case-use|hdl-template-case|hdl-template-clocked-wait|hdl-template-component-conf|hdl-template-component-decl|hdl-template-component-hook|hdl-template-component-inst|hdl-template-component|hdl-template-conditional-signal-asst-hook|hdl-template-conditional-signal-asst|hdl-template-configuration-decl|hdl-template-configuration-hook|hdl-template-configuration-spec|hdl-template-configuration|hdl-template-constant-hook|hdl-template-constant|hdl-template-construct-alist-init|hdl-template-default-hook|hdl-template-default-indent-hook|hdl-template-default-indent|hdl-template-default|hdl-template-directive-synthesis-off|hdl-template-directive-synthesis-on|hdl-template-directive-translate-off|hdl-template-directive-translate-on|hdl-template-directive|hdl-template-disconnect-hook|hdl-template-disconnect|hdl-template-display-comment-hook|hdl-template-else-hook|hdl-template-else|hdl-template-elsif-hook|hdl-template-elsif|hdl-template-entity-hook|hdl-template-entity|hdl-template-exit-hook|hdl-template-exit|hdl-template-field|hdl-template-file-hook|hdl-template-file|hdl-template-footer|hdl-template-for-generate|hdl-template-for-hook|hdl-template-for-loop|hdl-template-for|hdl-template-function-body|hdl-template-function-decl|hdl-template-function-hook|hdl-template-function|hdl-template-generate-body|hdl-template-generate|hdl-template-generic-hook|hdl-template-generic-list|hdl-template-generic|hdl-template-group-decl|hdl-template-group-hook|hdl-template-group-template|hdl-template-group|hdl-template-header|hdl-template-if-generate|hdl-template-if-hook|hdl-template-if-then-use|hdl-template-if-then|hdl-template-if-use|hdl-template-if|hdl-template-insert-construct|hdl-template-insert-date|hdl-template-insert-directive|hdl-template-insert-fun|hdl-template-insert-package|hdl-template-instance-hook|hdl-template-instance|hdl-template-library-hook|hdl-template-library|hdl-template-limit-hook|hdl-template-limit|hdl-template-loop|hdl-template-map-hook|hdl-template-map-init|hdl-template-map|hdl-template-modify-noerror|hdl-template-modify|hdl-template-nand-hook|hdl-template-nature-hook|hdl-template-nature|hdl-template-next-hook|hdl-template-next|hdl-template-nor-hook|hdl-template-not-hook|hdl-template-or-hook|hdl-template-others-hook|hdl-template-others|hdl-template-package-alist-init|hdl-template-package-body|hdl-template-package-decl|hdl-template-package-electrical-systems|hdl-template-package-energy-systems|hdl-template-package-fluidic-systems|hdl-template-package-fundamental-constants|hdl-template-package-hook|hdl-template-package-material-constants|hdl-template-package-math-complex|hdl-template-package-math-real|hdl-template-package-mechanical-systems|hdl-template-package-numeric-bit|hdl-template-package-numeric-std|hdl-template-package-radiant-systems|hdl-template-package-std-logic-1164|hdl-template-package-std-logic-arith|hdl-template-package-std-logic-misc|hdl-template-package-std-logic-signed|hdl-template-package-std-logic-textio|hdl-template-package-std-logic-unsigned|hdl-template-package-textio|hdl-template-package-thermal-systems|hdl-template-package|hdl-template-paired-parens|hdl-template-port-hook|hdl-template-port-list|hdl-template-port|hdl-template-procedural-hook|hdl-template-procedural|hdl-template-procedure-body|hdl-template-procedure-decl|hdl-template-procedure-hook|hdl-template-procedure|hdl-template-process-comb|hdl-template-process-hook|hdl-template-process-seq|hdl-template-process|hdl-template-quantity-branch|hdl-template-quantity-free|hdl-template-quantity-hook|hdl-template-quantity-source|hdl-template-quantity|hdl-template-record|hdl-template-replace-header-keywords|hdl-template-report-hook|hdl-template-report)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)v(?:hdl-template-return-hook|hdl-template-return|hdl-template-search-prompt|hdl-template-selected-signal-asst-hook|hdl-template-selected-signal-asst|hdl-template-seq-process|hdl-template-signal-hook|hdl-template-signal|hdl-template-standard-package|hdl-template-subnature-hook|hdl-template-subnature|hdl-template-subprogram-body|hdl-template-subprogram-decl|hdl-template-subtype-hook|hdl-template-subtype|hdl-template-terminal-hook|hdl-template-terminal|hdl-template-type-hook|hdl-template-type|hdl-template-undo|hdl-template-use-hook|hdl-template-use|hdl-template-variable-hook|hdl-template-variable|hdl-template-wait-hook|hdl-template-wait|hdl-template-when-hook|hdl-template-when|hdl-template-while-loop-hook|hdl-template-while-loop|hdl-template-with-hook|hdl-template-with|hdl-template-xnor-hook|hdl-template-xor-hook|hdl-toggle-project|hdl-try-expand-abbrev|hdl-uniquify|hdl-upcase-list|hdl-update-file-contents|hdl-update-hierarchy|hdl-update-mode-menu|hdl-update-progress-info|hdl-update-sensitivity-list-buffer|hdl-update-sensitivity-list-process|hdl-update-sensitivity-list|hdl-use-direct-instantiation|hdl-version|hdl-visit-file|hdl-warning-when-idle|hdl-warning|hdl-widget-directory-validate|hdl-win-bsws|hdl-win-fsws|hdl-win-il|hdl-within-translate-off|hdl-words-init|hdl-work-library|hdl-write-file-hooks-init|iet-decode-viqr-buffer|iet-decode-viqr-region|iet-encode-viqr-buffer|iet-encode-viqr-region|iet-encode-viscii-char|iew--disable|iew--enable|iew-buffer-other-frame|iew-buffer-other-window|iew-buffer|iew-echo-area-messages|iew-emacs-FAQ|iew-emacs-debugging|iew-emacs-news|iew-emacs-problems|iew-emacs-todo|iew-end-message|iew-external-packages|iew-file-other-frame|iew-file-other-window|iew-file|iew-hello-file|iew-help-file|iew-lossage|iew-mode-disable|iew-mode-enable|iew-mode-enter|iew-mode-exit|iew-mode|iew-order-manuals|iew-page-size-default|iew-really-at-end|iew-recenter|iew-return-to-alist-update|iew-scroll-lines|iew-search-no-match-lines|iew-search|iew-set-half-page-size-default|iew-todo|iew-window-size|iper--lookup-key|iper--tty-ESC-filter|iper-Append|iper-ESC-event-p|iper-ESC-keyseq-timeout|iper-ESC|iper-Insert|iper-Open-line|iper-P-val|iper-Put-back|iper-R-state-post-command-sentinel|iper-Region|iper-abbreviate-file-name|iper-abbreviate-string|iper-activate-input-method-action|iper-activate-input-method|iper-add-keymap|iper-add-local-keys|iper-add-newline-at-eob-if-necessary|iper-adjust-keys-for|iper-adjust-undo|iper-adjust-window|iper-after-change-sentinel|iper-after-change-undo-hook|iper-alist-to-list|iper-alternate-Meta-key|iper-append-filter-alist|iper-append-to-register|iper-append|iper-apply-major-mode-modifiers|iper-array-to-string|iper-ask-level|iper-autoindent|iper-backward-Word|iper-backward-char-carefully|iper-backward-char|iper-backward-indent|iper-backward-paragraph|iper-backward-sentence|iper-backward-word-kernel|iper-backward-word|iper-before-change-sentinel|iper-beginning-of-field|iper-beginning-of-line|iper-bind-mouse-insert-key|iper-bind-mouse-search-key|iper-bol-and-skip-white|iper-brac-function|iper-buffer-live-p|iper-buffer-search-enable|iper-can-release-key|iper-catch-tty-ESC|iper-change-cursor-color|iper-change-state-to-emacs|iper-change-state-to-insert|iper-change-state-to-replace|iper-change-state-to-vi|iper-change-state|iper-change-subr|iper-change-to-eol|iper-change|iper-char-array-p|iper-char-array-to-macro|iper-char-at-pos|iper-char-equal|iper-char-symbol-sequence-p|iper-characterp|iper-charlist-to-string|iper-charpair-command-p|iper-chars-in-region|iper-check-minibuffer-overlay|iper-check-version|iper-cleanup-ring|iper-color-defined-p|iper-color-display-p|iper-comint-mode-hook|iper-command-argument|iper-common-seq-prefix|iper-complete-filename-or-exit|iper-copy-event|iper-copy-region-as-kill|iper-current-ring-item|iper-cycle-through-mark-ring|iper-deactivate-input-method-action|iper-deactivate-input-method|iper-deactivate-mark|iper-debug-keymaps|iper-default-ex-addresses|iper-deflocalvar|iper-del-backward-char-in-insert|iper-del-backward-char-in-replace|iper-del-forward-char-in-insert|iper-delete-backward-char|iper-delete-backward-word|iper-delete-char|iper-delocalize-var|iper-describe-arg|iper-describe-kbd-macros|iper-describe-one-macro-elt|iper-describe-one-macro|iper-device-type|iper-digit-argument|iper-digit-command-p|iper-display-current-destructive-command|iper-display-macro|iper-display-vector-completions|iper-do-sequence-completion|iper-dotable-command-p|iper-downgrade-to-insert|iper-end-mapping-kbd-macro|iper-end-of-Word|iper-end-of-word-kernel|iper-end-of-word-p|iper-end-of-word|iper-end-with-a-newline-p|iper-enlarge-region|iper-erase-line|iper-escape-to-emacs|iper-escape-to-state|iper-escape-to-vi|iper-event-click-count|iper-event-key|iper-event-vector-p|iper-eventify-list-xemacs|iper-events-to-macro|iper-ex-read-file-name|iper-ex|iper-exchange-point-and-mark|iper-exec-Change|iper-exec-Delete|iper-exec-Yank|iper-exec-bang|iper-exec-buffer-search|iper-exec-change|iper-exec-delete|iper-exec-dummy|iper-exec-equals|iper-exec-form-in-emacs|iper-exec-form-in-vi|iper-exec-key-in-emacs|iper-exec-mapped-kbd-macro|iper-exec-shift|iper-exec-yank|iper-execute-com|iper-exit-insert-state|iper-exit-minibuffer|iper-extract-matching-alist-members|iper-fast-keysequence-p|iper-file-add-suffix|iper-file-checked-in-p|iper-filter-alist|iper-filter-list|iper-find-best-matching-macro|iper-find-char-backward|iper-find-char-forward|iper-find-char|iper-finish-R-mode|iper-finish-change|iper-fixup-macro|iper-flash-search-pattern|iper-forward-Word|iper-forward-char-carefully|iper-forward-char|iper-forward-indent|iper-forward-paragraph|iper-forward-sentence|iper-forward-word-kernel|iper-forward-word|iper-frame-value|iper-get-cursor-color|iper-get-ex-address-subr|iper-get-ex-address|iper-get-ex-buffer|iper-get-ex-com-subr|iper-get-ex-count|iper-get-ex-file|iper-get-ex-opt-gc|iper-get-ex-pat|iper-get-ex-token|iper-get-face|iper-get-filenames-from-buffer|iper-get-saved-cursor-color-in-emacs-mode|iper-get-saved-cursor-color-in-insert-mode|iper-get-saved-cursor-color-in-replace-mode|iper-get-visible-buffer-window|iper-getCom|iper-getcom|iper-glob-mswindows-files|iper-glob-unix-files|iper-global-execute|iper-go-away|iper-goto-char-backward|iper-goto-char-forward|iper-goto-col|iper-goto-eol|iper-goto-line|iper-goto-mark-and-skip-white|iper-goto-mark-subr|iper-goto-mark|iper-handle-!|iper-harness-minor-mode|iper-has-face-support-p|iper-hash-command-p|iper-heading-end|iper-hide-replace-overlay|iper-hide-search-overlay|iper-iconify|iper-if-string|iper-indent-line|iper-info-on-file|iper-insert-isearch-string|iper-insert-next-from-insertion-ring|iper-insert-prev-from-insertion-ring|iper-insert-state-post-command-sentinel|iper-insert-state-pre-command-sentinel|iper-insert-tab|iper-insert|iper-int-to-char|iper-intercept-ESC-key|iper-is-in-minibuffer|iper-isearch-backward|iper-isearch-forward|iper-join-lines|iper-kbd-buf-alist|iper-kbd-buf-definition|iper-kbd-buf-pair|iper-kbd-global-definition|iper-kbd-global-pair|iper-kbd-mode-alist|iper-kbd-mode-definition|iper-kbd-mode-pair|iper-ket-function|iper-key-press-events-to-chars|iper-key-to-character|iper-key-to-emacs-key|iper-keyseq-is-a-possible-macro|iper-kill-buffer|iper-kill-line|iper-last-command-char|iper-leave-region-active|iper-line-pos|iper-line-to-bottom|iper-line-to-middle|iper-line-to-top|iper-line|iper-list-to-alist|iper-load-custom-file|iper-looking-at-alpha|iper-looking-at-alphasep|iper-looking-at-separator|iper-looking-back|iper-loop|iper-macro-to-events|iper-major-mode-change-sentinel|iper-make-overlay|iper-mark-beginning-of-buffer|iper-mark-end-of-buffer|iper-mark-marker|iper-mark-point|iper-maybe-checkout|iper-memq-char|iper-message-conditions|iper-minibuffer-post-command-hook|iper-minibuffer-real-start|iper-minibuffer-setup-sentinel|iper-minibuffer-standard-hook|iper-minibuffer-trim-tail|iper-mode|iper-modify-keymap|iper-modify-major-mode|iper-mouse-catch-frame-switch|iper-mouse-click-frame|iper-mouse-click-get-word|iper-mouse-click-insert-word|iper-mouse-click-posn|iper-mouse-click-search-word|iper-mouse-click-window-buffer-name|iper-mouse-click-window-buffer|iper-mouse-click-window|iper-mouse-event-p|iper-move-marker-locally|iper-move-overlay|iper-move-replace-overlay|iper-movement-command-p|iper-multiclick-p|iper-next-destructive-command|iper-next-heading|iper-next-line-at-bol|iper-next-line-carefully|iper-next-line|iper-nil|iper-non-hook-settings|iper-normalize-minor-mode-map-alist|iper-open-line-at-point|iper-open-line|iper-over-whitespace-line|iper-overlay-end|iper-overlay-get|iper-overlay-live-p|iper-overlay-p|iper-overlay-put|iper-overlay-start|iper-overwrite|iper-p-val|iper-paren-match|iper-parse-mouse-key|iper-pos-within-region|iper-post-command-sentinel|iper-pre-command-sentinel|iper-prefix-arg-com|iper-prefix-arg-value|iper-prefix-command-p|iper-prefix-subseq-p|iper-preserve-cursor-color|iper-prev-destructive-command|iper-prev-heading|iper-previous-line-at-bol|iper-previous-line|iper-push-onto-ring|iper-put-back|iper-put-on-search-overlay|iper-put-string-on-kill-ring|iper-query-replace|iper-quote-region|iper-read-char-exclusive|iper-read-event-convert-to-char|iper-read-event|iper-read-fast-keysequence|iper-read-key-sequence|iper-read-key|iper-read-string-with-history|iper-record-kbd-macro|iper-refresh-mode-line|iper-region|iper-register-macro|iper-register-to-point|iper-regsuffix-command-p|iper-remember-current-frame|iper-remove-hooks|iper-repeat-find-opposite|iper-repeat-find|iper-repeat-from-history|iper-repeat-insert-command|iper-repeat|iper-replace-char-subr|iper-replace-char|iper-replace-end|iper-replace-mode-spy-after|iper-replace-mode-spy-before|iper-replace-start|iper-replace-state-carriage-return|iper-replace-state-exit-cmd|iper-replace-state-post-command-sentinel|iper-replace-state-pre-command-sentinel|iper-reset-mouse-insert-key|iper-reset-mouse-search-key|iper-restore-cursor-color|iper-restore-cursor-type|iper-ring-insert|iper-ring-pop|iper-ring-rotate1|iper-same-line|iper-save-cursor-color|iper-save-kill-buffer|iper-save-last-insertion|iper-save-setting|iper-save-string-in-file|iper-scroll-down-one|iper-scroll-down|iper-scroll-screen-back|iper-scroll-screen|iper-scroll-up-one|iper-scroll-up|iper-search-Next|iper-search-backward|iper-search-forward|iper-search-next|iper-search|iper-separator-skipback-special|iper-seq-last-elt|iper-set-complex-command-for-undo|iper-set-cursor-color-according-to-state|iper-set-destructive-command|iper-set-emacs-state-searchstyle-macros|iper-set-expert-level|iper-set-hooks|iper-set-input-method|iper-set-insert-cursor-type|iper-set-iso-accents-mode|iper-set-mark-if-necessary|iper-set-minibuffer-overlay|iper-set-minibuffer-style|iper-set-mode-vars-for|iper-set-parsing-style-toggling-macro|iper-set-register-macro|iper-set-replace-overlay-glyphs|iper-set-replace-overlay|iper-set-searchstyle-toggling-macros|iper-set-syntax-preference|iper-set-unread-command-events|iper-setup-ESC-to-escape|iper-setup-master-buffer|iper-sit-for-short|iper-skip-all-separators-backward|iper-skip-all-separators-forward|iper-skip-alpha-backward|iper-skip-alpha-forward|iper-skip-nonalphasep-backward|iper-skip-nonalphasep-forward|iper-skip-nonseparators|iper-skip-separators|iper-skip-syntax|iper-special-prefix-com|iper-special-read-and-insert-char|iper-special-ring-rotate1|iper-standard-value|iper-start-R-mode|iper-start-replace|iper-string-to-list|iper-submit-report|iper-subseq|iper-substitute-line|iper-substitute|iper-surrounding-word|iper-switch-to-buffer-other-window|iper-switch-to-buffer|iper-test-com-defun|iper-this-buffer-macros|iper-tmp-insert-at-eob|iper-toggle-case|iper-toggle-key-action|iper-toggle-parse-sexp-ignore-comments)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(?:viper-toggle-search-style|viper-translate-all-ESC-keysequences|viper-trim-replace-chars-to-delete-if-necessary|viper-unbind-mouse-insert-key|viper-unbind-mouse-search-key|viper-uncatch-tty-ESC|viper-undisplayed-files|viper-undo-more|viper-undo-sentinel|viper-undo|viper-unrecord-kbd-macro|viper-update-syntax-classes|viper-valid-marker|viper-valid-register|viper-version|viper-vi-command-p|viper-wildcard-to-regexp|viper-window-bottom|viper-window-display-p|viper-window-middle|viper-window-top|viper-yank-defun|viper-yank-last-insertion|viper-yank-line|viper-yank|viper-zap-local-keys|viper=|viqr-post-read-conversion|viqr-pre-write-conversion|visible-mode|visit-tags-table-buffer|visit-tags-table|visual-line-mode-set-explicitly|visual-line-mode|vt-keypad-off|vt-keypad-on|vt-narrow|vt-numlock|vt-toggle-screen|vt-wide|walk-window-subtree|walk-window-tree-1|walk-window-tree|warn-maybe-out-of-memory|warning-numeric-level|warning-suppress-p|wdired-abort-changes|wdired-capitalize-word|wdired-change-to-dired-mode|wdired-change-to-wdired-mode|wdired-check-kill-buffer|wdired-customize|wdired-do-perm-changes|wdired-do-renames|wdired-do-symlink-changes|wdired-downcase-word|wdired-exit|wdired-finish-edit|wdired-flag-for-deletion|wdired-get-filename|wdired-get-previous-link|wdired-isearch-filter-read-only|wdired-mode|wdired-mouse-toggle-bit|wdired-next-line|wdired-normalize-filename|wdired-perm-allowed-in-pos|wdired-perms-to-number|wdired-preprocess-files|wdired-preprocess-perms|wdired-preprocess-symlinks|wdired-previous-line|wdired-revert|wdired-search-and-rename|wdired-set-bit|wdired-toggle-bit|wdired-upcase-word|wdired-xcase-word|webjump-builtin-check-args|webjump-builtin|webjump-choose-mirror|webjump-do-simple-query|webjump-mirror-default|webjump-null-or-blank-string-p|webjump-read-choice|webjump-read-number|webjump-read-string|webjump-read-url-choice|webjump-to-iwin|webjump-to-risks|webjump-url-encode|webjump-url-fix-trailing-slash|webjump-url-fix|webjump|what-cursor-position|what-domain|what-line|what-page|when-let|where-is|which-func-ff-hook|which-func-mode|which-func-update-1|which-func-update-ediff-windows|which-func-update|which-function-mode|which-function|whitespace-action-when-on|whitespace-buffer-changed|whitespace-char-valid-p|whitespace-cleanup-region|whitespace-cleanup|whitespace-color-off|whitespace-color-on|whitespace-display-char-off|whitespace-display-char-on|whitespace-display-vector-p|whitespace-display-window|whitespace-empty-at-bob-regexp|whitespace-empty-at-eob-regexp|whitespace-ensure-local-variables|whitespace-help-off|whitespace-help-on|whitespace-help-scroll|whitespace-indentation-regexp|whitespace-insert-option-mark|whitespace-insert-value|whitespace-interactive-char|whitespace-kill-buffer|whitespace-looking-back|whitespace-mark-x|whitespace-mode|whitespace-newline-mode|whitespace-point--flush-used|whitespace-point--used|whitespace-post-command-hook|whitespace-regexp|whitespace-replace-action|whitespace-report-region|whitespace-report|whitespace-space-after-tab-regexp|whitespace-style-face-p|whitespace-style-mark-p|whitespace-toggle-list|whitespace-toggle-options|whitespace-trailing-regexp|whitespace-turn-off|whitespace-turn-on-if-enabled|whitespace-turn-on|whitespace-unload-function|whitespace-warn-read-only|whitespace-write-file-hook|whois-get-tld|whois-reverse-lookup|whois|widget-add-change|widget-add-documentation-string-button|widget-after-change|widget-alist-convert-option|widget-alist-convert-widget|widget-apply-action|widget-apply|widget-at|widget-backward|widget-before-change|widget-beginning-of-line|widget-boolean-prompt-value|widget-browse-at|widget-browse-other-window|widget-browse|widget-button-click|widget-button-press|widget-button-release-event-p|widget-checkbox-action|widget-checklist-add-item|widget-checklist-match-find|widget-checklist-match-inline|widget-checklist-match-up|widget-checklist-match|widget-checklist-validate|widget-checklist-value-create|widget-checklist-value-get|widget-child-validate|widget-child-value-get|widget-child-value-inline|widget-children-validate|widget-children-value-delete|widget-choice-action|widget-choice-default-get|widget-choice-match-inline|widget-choice-match|widget-choice-mouse-down-action|widget-choice-prompt-value|widget-choice-validate|widget-choice-value-create|widget-choose|widget-clear-undo|widget-coding-system-action|widget-coding-system-prompt-value|widget-color--choose-action|widget-color-action|widget-color-notify|widget-color-sample-face-get|widget-color-value-create|widget-complete|widget-completions-at-point|widget-cons-match|widget-const-prompt-value|widget-convert-button|widget-convert-text|widget-convert|widget-copy|widget-create-child-and-convert|widget-create-child-value|widget-create-child|widget-create|widget-default-action|widget-default-active|widget-default-button-face-get|widget-default-completions|widget-default-create|widget-default-deactivate|widget-default-default-get|widget-default-delete|widget-default-format-handler|widget-default-get|widget-default-menu-tag-get|widget-default-mouse-face-get|widget-default-notify|widget-default-prompt-value|widget-default-sample-face-get|widget-default-value-inline|widget-default-value-set|widget-delete-button-action|widget-delete|widget-docstring|widget-documentation-link-action|widget-documentation-link-add|widget-documentation-string-action|widget-documentation-string-indent-to|widget-documentation-string-value-create|widget-echo-help|widget-editable-list-delete-at|widget-editable-list-entry-create|widget-editable-list-format-handler|widget-editable-list-insert-before|widget-editable-list-match-inline|widget-editable-list-match|widget-editable-list-value-create|widget-editable-list-value-get|widget-emacs-commentary-link-action|widget-emacs-library-link-action|widget-end-of-line|widget-event-point|widget-face-notify|widget-face-sample-face-get|widget-field-action|widget-field-activate|widget-field-at|widget-field-buffer|widget-field-end|widget-field-find|widget-field-match|widget-field-prompt-internal|widget-field-prompt-value|widget-field-start|widget-field-text-end|widget-field-validate|widget-field-value-create|widget-field-value-delete|widget-field-value-get|widget-field-value-set|widget-file-link-action|widget-file-prompt-value|widget-forward|widget-function-link-action|widget-get-indirect|widget-get-sibling|widget-get|widget-group-default-get|widget-group-match-inline|widget-group-match|widget-group-value-create|widget-image-find|widget-image-insert|widget-info-link-action|widget-insert-button-action|widget-insert|widget-item-action|widget-item-match-inline|widget-item-match|widget-item-value-create|widget-key-sequence-read-event|widget-key-sequence-validate|widget-key-sequence-value-to-external|widget-key-sequence-value-to-internal|widget-kill-line|widget-leave-text|widget-magic-mouse-down-action|widget-map-buttons|widget-match-inline|widget-member|widget-minor-mode|widget-mouse-help|widget-move-and-invoke|widget-move|widget-narrow-to-field|widget-overlay-inactive|widget-parent-action|widget-plist-convert-option|widget-plist-convert-widget|widget-plist-member|widget-princ-to-string|widget-prompt-value|widget-push-button-value-create|widget-put|widget-radio-action|widget-radio-add-item|widget-radio-button-notify|widget-radio-chosen|widget-radio-validate|widget-radio-value-create|widget-radio-value-get|widget-radio-value-inline|widget-radio-value-set|widget-regexp-match|widget-regexp-validate|widget-restricted-sexp-match|widget-setup|widget-sexp-prompt-value|widget-sexp-validate|widget-sexp-value-to-internal|widget-specify-active|widget-specify-button|widget-specify-doc|widget-specify-field|widget-specify-inactive|widget-specify-insert|widget-specify-sample|widget-specify-secret|widget-sublist|widget-symbol-prompt-internal|widget-tabable-at|widget-toggle-action|widget-toggle-value-create|widget-type-default-get|widget-type-match|widget-type-value-create|widget-type|widget-types-convert-widget|widget-types-copy|widget-url-link-action|widget-value-convert-widget|widget-value-set|widget-value-value-get|widget-value|widget-variable-link-action|widget-vector-match|widget-visibility-value-create|widgetp|wildcard-to-regexp|windmove-constrain-around-range|windmove-constrain-loc-for-movement|windmove-constrain-to-range|windmove-coord-add|windmove-default-keybindings|windmove-do-window-select|windmove-down|windmove-find-other-window|windmove-frame-edges|windmove-left|windmove-other-window-loc|windmove-reference-loc|windmove-right|windmove-up|windmove-wrap-loc-for-movement|window--atom-check-1|window--atom-check|window--check|window--delete|window--display-buffer|window--dump-frame|window--dump-window|window--even-window-heights|window--frame-usable-p|window--in-direction-2|window--in-subtree-p|window--major-non-side-window|window--major-side-window|window--max-delta-1|window--maybe-raise-frame|window--min-delta-1|window--min-size-1|window--min-size-ignore-p|window--pixel-to-total-1|window--pixel-to-total|window--preservable-size|window--preserve-size|window--resizable-p|window--resizable|window--resize-apply-p|window--resize-child-windows-normal|window--resize-child-windows-skip-p|window--resize-child-windows|window--resize-mini-window|window--resize-reset-1|window--resize-reset|window--resize-root-window-vertically|window--resize-root-window|window--resize-siblings|window--resize-this-window|window--sanitize-margin|window--sanitize-window-sizes|window--side-check|window--side-window-p|window--size-fixed-1|window--size-ignore-p|window--size-to-pixel|window--state-get-1|window--state-put-1|window--state-put-2|window--subtree|window--try-to-split-window|window-at-side-list|window-at-side-p|window-atom-root|window-buffer-height|window-child-count|window-combination-p|window-combinations|window-configuration-to-register|window-deletable-p|window-dot|window-fixed-size-p|window-height|window-last-child|window-left|window-list-1|window-make-atom|window-max-delta|window-min-delta|window-min-pixel-height|window-min-pixel-size|window-min-pixel-width|window-new-normal|window-new-pixel|window-new-total|window-normal-size|window-normalize-buffer-to-switch-to|window-normalize-buffer|window-normalize-frame|window-normalize-window|window-old-point|window-preserve-size|window-preserved-size|window-redisplay-end-trigger|window-resizable-p|window-resize-apply-total|window-resize-apply|window-resize-no-error|window-right|window-safe-min-pixel-height|window-safe-min-pixel-size|window-safe-min-pixel-width|window-safe-min-size|window-safely-shrinkable-p|window-screen-lines|window-scroll-bar-height|window-sizable-p|window-sizable|window-size-fixed-p|window-size|window-splittable-p|window-system-for-display|window-text-height|window-text-width|window-use-time|window-width|window-with-parameter|winner-active-region|winner-change-fun|winner-conf|winner-configuration|winner-edges|winner-equal|winner-get-point|winner-insert-if-new|winner-make-point-alist|winner-mode|winner-redo|winner-remember|winner-ring|winner-save-conditionally|winner-save-old-configurations|winner-save-unconditionally|winner-set-conf|winner-set|winner-sorted-window-list|winner-undo-this|winner-undo|winner-win-data|winner-window-list|wisent-grammar-mode|wisent-java-default-setup|wisent-javascript-setup-parser|wisent-python-default-setup|with-auto-compression-mode|with-buffer-modified-unmodified|with-category-table|with-decoded-time-value|with-displayed-buffer-window|with-electric-help|with-file-modes|with-isearch-suspended|with-js|with-mh-folder-updating|with-mode-local-symbol|with-mode-local|with-parsed-tramp-file-name|with-rcirc-process-buffer|with-rcirc-server-buffer|with-selected-frame|with-silent-modifications|with-slots|with-timeout-suspend|with-timeout-unsuspend|with-tramp-connection-property|with-tramp-file-property|with-tramp-progress-reporter|with-vc-properties|with-wrapper-hook|woman-Cyg-to-Win|woman-bookmark-jump|woman-bookmark-make-record|woman-break-table|woman-cached-data|woman-canonicalize-dir|woman-change-fonts|woman-decode-buffer|woman-decode-region|woman-default-faces|woman-delete-following-space|woman-delete-line|woman-delete-match|woman-delete-whole-line|woman-directory-files|woman-dired-define-key-maybe|woman-dired-define-keys??|woman-dired-find-file|woman-display-extended-fonts)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"},{"match":"(?<=[()]|^)(?:woman-expand-directory-path|woman-expand-locale|woman-file-accessible-directory-p|woman-file-name-all-completions|woman-file-name|woman-file-readable-p|woman-find-file|woman-find-next-control-line-carefully|woman-find-next-control-line|woman-follow-word|woman-follow|woman-forward-arg|woman-get-next-char|woman-get-numeric-arg|woman-get-tab-stop|woman-horizontal-escapes|woman-horizontal-line|woman-if-body|woman-if-ignore|woman-imenu|woman-insert-file-contents|woman-interparagraph-space|woman-interpolate-macro|woman-leave-blank-lines|woman-make-bufname|woman-man-buffer|woman-manpath-add-locales|woman-mark-horizontal-position|woman-match-name|woman-menu|woman-mini-help|woman-mode|woman-monochrome-faces|woman-negative-vertical-space|woman-non-underline-faces|woman-not-member|woman-parse-colon-path|woman-parse-man\\\\.conf|woman-parse-numeric-arg|woman-parse-numeric-value|woman-pop|woman-pre-process-region|woman-process-buffer|woman-push|woman-read-directory-cache|woman-really-find-file|woman-reformat-last-file|woman-replace-match|woman-reset-emulation|woman-reset-nospace|woman-select-symbol-fonts|woman-select|woman-set-arg|woman-set-buffer-display-table|woman-set-face|woman-set-interparagraph-distance|woman-special-characters|woman-strings|woman-tab-to-tab-stop|woman-tar-extract-file|woman-toggle-fill-frame|woman-toggle-use-extended-font|woman-toggle-use-symbol-font|woman-topic-all-completions-1|woman-topic-all-completions-merge|woman-topic-all-completions|woman-translate|woman-unescape|woman-unquote-args|woman-unquote|woman-write-directory-cache|woman|woman0-de|woman0-el|woman0-if|woman0-ig|woman0-macro|woman0-process-escapes|woman0-rename|woman0-rn|woman0-roff-buffer|woman0-so|woman1-B-or-I|woman1-BI??|woman1-BR|woman1-IB??|woman1-IR|woman1-IX|woman1-RB|woman1-RI|woman1-SB|woman1-SM|woman1-TP|woman1-TX|woman1-alt-fonts|woman1-bd|woman1-cs|woman1-hc|woman1-hw|woman1-hy|woman1-ne|woman1-nh|woman1-ps|woman1-roff-buffer|woman1-ss|woman1-ul|woman1-vs|woman2-DT|woman2-HP|woman2-IP|woman2-LP|woman2-PD??|woman2-PP|woman2-RE|woman2-RS|woman2-SH|woman2-SS|woman2-TE|woman2-TH|woman2-TP|woman2-TS|woman2-ad|woman2-br|woman2-fc|woman2-fi|woman2-format-paragraphs|woman2-get-prevailing-indent|woman2-in|woman2-ll|woman2-na|woman2-nf|woman2-nr|woman2-ns|woman2-process-escapes-to-eol|woman2-process-escapes|woman2-roff-buffer|woman2-rs|woman2-sp|woman2-ta|woman2-tagged-paragraph|woman2-ti|woman2-tr|word-at-point|x-apply-session-resources|x-backspace-delete-keys-p|x-change-window-property|x-clipboard-yank|x-complement-fontset-spec|x-compose-font-name|x-create-frame-with-faces|x-create-frame|x-cut-buffer-or-selection-value|x-decompose-font-name|x-delete-window-property|x-disown-selection-internal|x-display-backing-store|x-display-color-cells|x-display-grayscale-p|x-display-mm-height|x-display-mm-width|x-display-monitor-attributes-list|x-display-pixel-height|x-display-pixel-width|x-display-planes|x-display-save-under|x-display-screens|x-display-visual-class|x-dnd-choose-type|x-dnd-current-type|x-dnd-default-test-function|x-dnd-drop-data|x-dnd-forget-drop|x-dnd-get-drop-width-height|x-dnd-get-drop-x-y|x-dnd-get-motif-value|x-dnd-get-state-cons-for-frame|x-dnd-get-state-for-frame|x-dnd-handle-drag-n-drop-event|x-dnd-handle-file-name|x-dnd-handle-motif|x-dnd-handle-moz-url|x-dnd-handle-old-kde|x-dnd-handle-uri-list|x-dnd-handle-xdnd|x-dnd-init-frame|x-dnd-init-motif-for-frame|x-dnd-init-xdnd-for-frame|x-dnd-insert-ctext|x-dnd-insert-utf16-text|x-dnd-insert-utf8-text|x-dnd-maybe-call-test-function|x-dnd-more-than-3-from-flags|x-dnd-motif-value-to-list|x-dnd-save-state|x-dnd-version-from-flags|x-file-dialog|x-focus-frame|x-frame-geometry|x-get-atom-name|x-get-clipboard|x-get-selection-internal|x-get-selection-value|x-gtk-map-stock|x-handle-args|x-handle-display|x-handle-geometry|x-handle-iconic|x-handle-initial-switch|x-handle-name-switch|x-handle-named-frame-geometry|x-handle-no-bitmap-icon|x-handle-numeric-switch|x-handle-parent-id|x-handle-reverse-video|x-handle-smid|x-handle-switch|x-handle-xrm-switch|x-hide-tip|x-initialize-window-system|x-menu-bar-open-internal|x-menu-bar-open|x-must-resolve-font-name|x-own-selection-internal|x-register-dnd-atom|x-resolve-font-name|x-select-font|x-select-text|x-selection-exists-p|x-selection-owner-p|x-selection-value|x-selection|x-send-client-message|x-server-max-request-size|x-show-tip|x-synchronize|x-uses-old-gtk-dialog|x-win-suspend-error|x-window-property|x-wm-set-size-hint|xdb|xml--entity-replacement-text|xml--parse-buffer|xml-debug-print-internal|xml-debug-print|xml-escape-string|xml-find-file-coding-system|xml-get-attribute-or-nil|xml-get-attribute|xml-get-children|xml-maybe-do-ns|xml-mode|xml-node-attributes|xml-node-children|xml-node-name|xml-parse-attlist|xml-parse-dtd|xml-parse-elem-type|xml-parse-file|xml-parse-region|xml-parse-string|xml-parse-tag-1|xml-parse-tag|xml-print|xml-skip-dtd|xml-substitute-numeric-entities|xml-substitute-special|xmltok-get-declared-encoding-position|xor|xref--alistify|xref--analyze|xref--display-position|xref--find-definitions|xref--goto-location|xref--insert-propertized|xref--insert-xrefs|xref--location-at-point|xref--next-line|xref--pop-to-location|xref--read-identifier|xref--search-property|xref--show-location|xref--show-xref-buffer|xref--show-xrefs|xref--xref-buffer-mode|xref--xref-child-p|xref--xref-description|xref--xref-list-p|xref--xref-location|xref--xref-p|xref--xref|xref-bogus-location-child-p|xref-bogus-location-list-p|xref-bogus-location-message|xref-bogus-location-p|xref-bogus-location|xref-buffer-location-child-p|xref-buffer-location-list-p|xref-buffer-location-p|xref-buffer-location|xref-clear-marker-stack|xref-default-identifier-at-point|xref-elisp-location-child-p|xref-elisp-location-list-p|xref-elisp-location-p|xref-elisp-location|xref-file-location-child-p|xref-file-location-list-p|xref-file-location-p|xref-file-location|xref-find-apropos|xref-find-definitions-other-frame|xref-find-definitions-other-window|xref-find-definitions|xref-find-references|xref-goto-xref|xref-location-child-p|xref-location-group|xref-location-list-p|xref-location-marker|xref-location-p|xref-location|xref-make-bogus-location|xref-make-buffer-location|xref-make-elisp-location|xref-make-file-location|xref-make|xref-next-line|xref-pop-marker-stack|xref-prev-line|xref-push-marker-stack|xscheme-cd|xscheme-coerce-prompt|xscheme-debugger-mode-p|xscheme-default-command-line|xscheme-delete-output|xscheme-display-process-buffer|xscheme-enable-control-g|xscheme-enter-debugger-mode|xscheme-enter-input-wait|xscheme-enter-interaction-mode|xscheme-eval|xscheme-evaluation-commands|xscheme-exit-input-wait|xscheme-finish-gc|xscheme-goto-output-point|xscheme-guarantee-newlines|xscheme-insert-expression|xscheme-interrupt-commands|xscheme-message|xscheme-mode-line-initialize|xscheme-output-goto|xscheme-parse-command-line|xscheme-process-buffer-current-p|xscheme-process-buffer-window|xscheme-process-buffer|xscheme-process-filter-initialize|xscheme-process-filter-output|xscheme-process-filter|xscheme-process-filter:simple-action|xscheme-process-filter:string-action-noexcursion|xscheme-process-filter:string-action|xscheme-process-running-p|xscheme-process-sentinel|xscheme-prompt-for-confirmation|xscheme-prompt-for-expression-exit|xscheme-prompt-for-expression|xscheme-read-command-line|xscheme-region-expression-p|xscheme-rotate-yank-pointer|xscheme-select-process-buffer|xscheme-send-breakpoint-interrupt|xscheme-send-buffer|xscheme-send-char|xscheme-send-control-g-interrupt|xscheme-send-control-u-interrupt|xscheme-send-control-x-interrupt|xscheme-send-current-line|xscheme-send-definition|xscheme-send-interrupt|xscheme-send-next-expression|xscheme-send-previous-expression|xscheme-send-proceed|xscheme-send-region|xscheme-send-string-1|xscheme-send-string-2|xscheme-send-string|xscheme-set-prompt-variable|xscheme-set-prompt|xscheme-set-runlight|xscheme-start-gc|xscheme-start-process|xscheme-start|xscheme-unsolicited-read-char|xscheme-wait-for-process|xscheme-write-message-1|xscheme-write-value|xscheme-yank-pop|xscheme-yank-previous-send|xscheme-yank-push|xscheme-yank|xselect--encode-string|xselect--int-to-cons|xselect--selection-bounds|xselect-convert-to-atom|xselect-convert-to-charpos|xselect-convert-to-class|xselect-convert-to-colno|xselect-convert-to-delete|xselect-convert-to-filename|xselect-convert-to-host|xselect-convert-to-identity|xselect-convert-to-integer|xselect-convert-to-length|xselect-convert-to-lineno|xselect-convert-to-name|xselect-convert-to-os|xselect-convert-to-save-targets|xselect-convert-to-string|xselect-convert-to-targets|xselect-convert-to-user|xterm-mouse--read-event-sequence-1000|xterm-mouse--read-event-sequence-1006|xterm-mouse--set-click-count|xterm-mouse-event|xterm-mouse-mode|xterm-mouse-position-function|xterm-mouse-translate-1|xterm-mouse-translate-extended|xterm-mouse-translate|xterm-mouse-truncate-wrap|xw-color-defined-p|xw-color-values|xw-defined-colors|xw-display-color-p|yank-handle-category-property|yank-handle-font-lock-face-property|yank-menu|yank-rectangle|yenc-decode-region|yenc-extract-filename|zap-to-char|zeroconf-get-domain|zeroconf-get-host-domain|zeroconf-get-host|zeroconf-get-interface-name|zeroconf-get-interface-number|zeroconf-get-service|zeroconf-init|zeroconf-list-service-names|zeroconf-list-service-types|zeroconf-list-services|zeroconf-publish-service|zeroconf-register-service-browser|zeroconf-register-service-resolver|zeroconf-register-service-type-browser|zeroconf-resolve-service|zeroconf-service-add-hook|zeroconf-service-address|zeroconf-service-aprotocol|zeroconf-service-browser-handler|zeroconf-service-domain|zeroconf-service-flags|zeroconf-service-host|zeroconf-service-interface|zeroconf-service-name|zeroconf-service-port|zeroconf-service-protocol|zeroconf-service-remove-hook|zeroconf-service-resolver-handler|zeroconf-service-txt|zeroconf-service-type-browser-handler|zeroconf-service-type|zerop--anon-cmacro|zone-call|zone-cpos|zone-exploding-remove|zone-fall-through-ws|zone-fill-out-screen|zone-fret|zone-hiding-mode-line|zone-leave-me-alone|zone-line-specs|zone-mode|zone-orig|zone-park/sit-for|zone-pgm-2nd-putz-with-case|zone-pgm-dissolve|zone-pgm-drip-fretfully|zone-pgm-drip|zone-pgm-explode|zone-pgm-five-oclock-swan-dive|zone-pgm-jitter|zone-pgm-martini-swan-dive|zone-pgm-paragraph-spaz|zone-pgm-putz-with-case|zone-pgm-random-life|zone-pgm-rat-race|zone-pgm-rotate-LR-lockstep|zone-pgm-rotate-LR-variable|zone-pgm-rotate-RL-lockstep|zone-pgm-rotate-RL-variable|zone-pgm-rotate|zone-pgm-stress-destress|zone-pgm-stress|zone-pgm-whack-chars|zone-remove-text|zone-replace-char|zone-shift-down|zone-shift-left|zone-shift-right|zone-shift-up|zone-when-idle|zone|zrgrep)(?=[()\\\\s]|$)","name":"support.function.emacs.lisp"}]},"string":{"begin":"\\"","beginCaptures":{"0":{"name":"punctuation.definition.string.begin.emacs.lisp"}},"end":"\\"","endCaptures":{"0":{"name":"punctuation.definition.string.end.emacs.lisp"}},"name":"string.quoted.double.emacs.lisp","patterns":[{"include":"#string-innards"}]},"string-innards":{"patterns":[{"include":"#eldoc"},{"match":"(\\\\\\\\)$\\\\n?","name":"constant.escape.character.newline.emacs.lisp"},{"captures":{"1":{"name":"punctuation.escape.backslash.emacs.lisp"}},"match":"(\\\\\\\\).","name":"constant.escape.character.emacs.lisp"}]},"symbols":{"patterns":[{"captures":{"0":{"name":"punctuation.definition.symbol.emacs.lisp"}},"match":"(?<=[()\\\\[\\\\s]|^)##","name":"constant.other.interned.blank.symbol.emacs.lisp"},{"captures":{"1":{"name":"punctuation.definition.symbol.emacs.lisp"},"2":{"patterns":[{"include":"$self"}]}},"match":"(?<=[()\\\\[\\\\s]|^)(#)((?:[-!$-'*+/:<-@^{}~\\\\w]|\\\\\\\\.)+)","name":"constant.other.symbol.emacs.lisp"},{"captures":{"1":{"name":"punctuation.definition.spliced.symbol.emacs.lisp"}},"match":"(,@)([-!$%\\\\&*+/:<-@^{}~\\\\w]+)","name":"constant.other.spliced.symbol.emacs.lisp"},{"captures":{"1":{"name":"punctuation.definition.inserted.symbol.emacs.lisp"}},"match":"(,)([-!$%\\\\&*+/:<-@^{}~\\\\w]+)","name":"constant.other.inserted.symbol.emacs.lisp"}]},"vectors":{"patterns":[{"match":"\\\\[","name":"punctuation.section.vector.begin.emacs.lisp"},{"match":"]","name":"punctuation.section.vector.end.emacs.lisp"}]}},"scopeName":"source.emacs.lisp","aliases":["elisp"]}`)),t=[e];export{t as default};
//# sourceMappingURL=chunk-C9XAeP06.js.map
